from .__class_init__ import *
from ..types import choices
from ..types.implementations import structs
from .overview import VERSION_0
threshold_scaler_unit = cdt.ScalUnitType(b'\x02\x02\x0f\x00\x16\x07')


class Thresholds(cdt.Array):
    TYPE = choices.simple_dt


class ActionSet(cdt.Structure):
    """TODO:"""
    action_up: structs.ActionItem
    action_down: structs.ActionItem


class Actions(cdt.Array):
    """Defines the scripts to be executed when the monitored attribute of the referenced object crosses the corresponding threshold. The attribute actions has exactly
    the same number of elements as the attribute thresholds. The ordering of the action_items corresponds to the ordering of the thresholds (see above)."""
    TYPE = ActionSet


class RegisterMonitor(ic.COSEMInterfaceClasses):
    """ DLMS UA 1000-1 Ed.14. 4.5.6. This IC allows modelling the function of monitoring of values modelled by “Data”, “Register”, “Extended register” or “Demand register” objects.
    It allows specifying thresholds, the value monitored, and a set of scripts (see 4.5.2) that are executed when the value monitored crosses a threshold """
    CLASS_ID = ClassID.REGISTER_MONITOR
    VERSION = VERSION_0
    A_ELEMENTS = (ic.ICAElement("thresholds", Thresholds),
                  ic.ICAElement("monitored_value", structs.ValueDefinition),
                  ic.ICAElement("actions", Actions))

    def characteristics_init(self):
        ...

    @property
    def thresholds(self) -> Thresholds:
        return self.get_attr(2)

    @property
    def monitored_value(self) -> structs.ValueDefinition:
        return self.get_attr(3)

    @property
    def threshold_normal(self) -> Actions:
        return self.get_attr(4)
