# dazpycheck: Your AI Code's Quality Guardian

![dazpycheck banner](output/banner.png)

**dazpycheck** is a powerful and comprehensive tool for ensuring your Python code is clean, correct, and consistent. It's especially useful for checking code generated by AI, which can sometimes take shortcuts or introduce subtle errors.

## Why dazpycheck?

AI is a powerful tool, but it's not perfect. AI-generated code can sometimes be messy, inefficient, or even contain bugs. `dazpycheck` helps you catch these issues before they become problems. It's the perfect last step in your development workflow to ensure your code is production-ready.

![dazpycheck logo](output/logo.png)

## Features

*   **All-in-One Checking:** dazpycheck integrates `black` for formatting, `flake8` for linting, `pyright` for type checking, and `py_compile` for compilation, giving you a complete picture of your code's health.
*   **Automated Fixing:** By default, `dazpycheck` will automatically fix formatting issues. Use the `--readonly` flag to see what would be changed without modifying any files.
*   **Banned Words Enforcement:** Define a list of "banned words" to enforce your own coding standards. `dazpycheck` will scan your entire repository and flag any occurrences of these words.
*   **Parallel Execution:** `dazpycheck` runs all readonly checks in parallel, making it fast and efficient, even on large codebases.
*   **Integrated Test Runner:** By default, `dazpycheck` will run all your `unittest` and `pytest` tests. Use the `--no-test` flag to skip testing.

![Parallel Checks](output/parallel_checks.png)

## Installation

`dazpycheck` is available on PyPI. You can install it using `pip`:

```bash
pip install dazpycheck
```

## Usage

Once installed, you can run `dazpycheck` from anywhere on your system:

```bash
dazpycheck
```

This will run all checks and tests on the current directory. You can also specify a directory:

```bash
dazpycheck /path/to/your/project
```

### Options

*   `--readonly`: Only check for issues, don't modify files.
*   `--no-test`: Skip running tests.
*   `--single-thread`: Run checks sequentially.
*   `--full`: Run all checks regardless of failures.

![Banned Words](output/banned_words.png)

We hope you find `dazpycheck` to be a valuable addition to your development workflow!