# mypy-boto3-glue

[![PyPI - mypy-boto3-glue](https://img.shields.io/pypi/v/mypy-boto3-glue.svg?color=blue)](https://pypi.org/project/mypy-boto3-glue)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-glue.svg?color=blue)](https://pypi.org/project/mypy-boto3-glue)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Glue 1.12.33](https://boto3.amazonaws.com/v1/documentation/api/1.12.33/reference/services/glue.html#Glue) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.6](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-glue](#mypy-boto3-glue)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Glue` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-glue]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import glue
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_glue as glue

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("glue")
client: glue.GlueClient = boto3.client("glue")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: glue.GlueClient = session.client("glue")


# Paginators need type annotation on creation
get_classifiers_paginator: glue.GetClassifiersPaginator = client.get_paginator("get_classifiers")
get_connections_paginator: glue.GetConnectionsPaginator = client.get_paginator("get_connections")
get_crawler_metrics_paginator: glue.GetCrawlerMetricsPaginator = client.get_paginator("get_crawler_metrics")
get_crawlers_paginator: glue.GetCrawlersPaginator = client.get_paginator("get_crawlers")
get_databases_paginator: glue.GetDatabasesPaginator = client.get_paginator("get_databases")
get_dev_endpoints_paginator: glue.GetDevEndpointsPaginator = client.get_paginator("get_dev_endpoints")
get_job_runs_paginator: glue.GetJobRunsPaginator = client.get_paginator("get_job_runs")
get_jobs_paginator: glue.GetJobsPaginator = client.get_paginator("get_jobs")
get_partitions_paginator: glue.GetPartitionsPaginator = client.get_paginator("get_partitions")
get_security_configurations_paginator: glue.GetSecurityConfigurationsPaginator = client.get_paginator("get_security_configurations")
get_table_versions_paginator: glue.GetTableVersionsPaginator = client.get_paginator("get_table_versions")
get_tables_paginator: glue.GetTablesPaginator = client.get_paginator("get_tables")
get_triggers_paginator: glue.GetTriggersPaginator = client.get_paginator("get_triggers")
get_user_defined_functions_paginator: glue.GetUserDefinedFunctionsPaginator = client.get_paginator("get_user_defined_functions")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.