<div align="center"><a name="readme-top"></a>

# Dingent

**A lightweight, user-friendly LLM Agent framework focused on simplifying data retrieval application development.**

**English** · [简体中文](./README.zh-CN.md)

[Fast Track](https://saya-ashen.github.io/Dingent/docs/intro#fast-track)
|
[Installation](https://saya-ashen.github.io/Dingent/docs/getting-started/installation)
|
[Configuration](https://saya-ashen.github.io/Dingent/docs/getting-started/configuration)
</div>

**Dingent** is a lightweight, user-friendly agent framework whose core goal is to simplify the process of creating data-driven applications powered by Large Language Models (LLMs). We provide a concise yet powerful toolkit, with a standout feature of automatic database connectivity. This allows you to quickly link your database with an LLM to build applications capable of intelligent Q\&A, data extraction, and analysis. For other data sources like APIs and local documents, Dingent offers a flexible framework that developers can easily extend by writing custom code.

## 🎯 Why Choose Dingent?

When building LLM data applications, developers often spend a significant amount of time on "glue code": connecting to databases, wrapping APIs, setting up frontend-backend communication... These tasks are tedious and repetitive.

**Dingent's core value lies in:**

  * **No More Repetition**: We package the best practices for backend services (LangGraph), data interfaces (Assistants), and frontend presentation (CopilotKit) into a single command. You no longer need to build everything from scratch and can start writing your core business logic immediately.

  * **Core Features Built-In**: We believe a simple and easy-to-use agent shouldn't require users to spend a lot of time maintaining plugins. Therefore, we are committed to integrating features the community deems important directly into the framework. If you think a feature is crucial, we encourage you to open an Issue or PR. This directly reflects our core mission of "making Agents simpler for users."

  * **Focused, Not Comprehensive**: Unlike other general-purpose Agent frameworks, Dingent specializes in data retrieval and Q\&A scenarios, offering a more lightweight and focused solution.

  * **Smooth Learning Curve**: You only need a basic understanding of Python and some frontend knowledge to build powerful applications, without needing to be an expert in LangGraph or FastAPI. At the same time, we retain the flexibility to expand functionalities, ensuring the framework can fully support custom development when needed.

## ✨ Features

  * **One-Click Project Initialization**: Use the `uvx dingent[cli] init` command to quickly generate a complete project structure with a frontend, backend, and core logic using templates.
  * **Lightweight and Easy to Use**: A clean design and a gentle learning curve let you focus on business logic rather than tedious configuration.
  * **Specialized for Data Retrieval**: Optimized for scenarios like data Q\&A, extraction, and analysis to provide efficient solutions.
  * **Flexible Data Source Integration**: Easily integrate with various data sources, including APIs, databases, and files (PDF, Markdown, etc.).
  * **LLM-Powered**: Seamlessly connect with mainstream LLMs like the OpenAI GPT series, local models, and more.

## 🚀 Quick Start

Create a fully functional agent project from scratch in just a few minutes.

### 1\. Prerequisites

Before you begin, ensure your development environment  has the following installed:

  * [**uv**](https://docs.astral.sh/uv/getting-started/installation/): A very fast Python package installer and resolver.

    ```bash
    # On macOS and Linux
    curl -LsSf https://astral.sh/uv/install.sh | sh
    ```

    ```powershell
    # On Windows
    powershell -ExecutionPolicy ByPass -c "irm https://astral.sh/uv/install.ps1 | iex"
    ```

  * [**Node.js**](https://nodejs.org/en/download/) version 18.0 or above (which can be checked by running node -v)

    Installation: [https://nodejs.org/en/download](https://nodejs.org/en/download)

### 2\. Initialize Your Agent Project

Run the following command, and the Dingent CLI will guide you through the project creation process.

```bash
# Use the 'basic' template to create a new project
uvx dingent init basic
```

The CLI will prompt you for a project name, author, etc., and then automatically create the project directory and install all frontend and backend dependencies.

### 3\. Launch and Develop

Once the project is created, navigate to the project directory:

```bash
cd my-awesome-agent

# On macOS and Linux
export OPENAI_API_KEY=sk-xxxxxxxxxxxxxxxxxxx # Replace with your OpenAI API Key

# On Windows (PowerShell)
$env:OPENAI_API_KEY="sk-xxxxxxxxxxxxxxxxxxx" # Replace with your OpenAI API Key

uvx dingent run
```

By default, Dingent will start a LangGraph backend service and an Assistants service, and it will open the frontend interface in your browser.
If the frontend doesn't open automatically, you can manually visit [http://localhost:3000](http://localhost:3000).

Your project skeleton is now ready\! You can now:

  * **Explore the project structure**: See the `🏛️ Project Architecture` section below to understand the directory layout.
  * **Develop the backend logic**: Edit the Python files in the `assistants/` and `backend/` directories to implement your core agent logic and APIs.
  * **Develop the frontend interface**: Build your user interface in the `frontend/` directory.

## 🏛️ Project Architecture

Projects generated with the `init` command have a standardized structure, making collaboration and maintenance easier:

```plaintext
my-awesome-agent/
├── 📁 backend/       # Backend service (based on FastAPI and LangGraph)
├── 📁 frontend/      # Frontend application (based on CopilotKit)
├── 📁 assistants/    # A collection of tools for specific domain tasks
└── 📄 README.md      # The project's documentation
```

### 📦 backend/

  * The backend service is the core coordinator of the application, built with FastAPI and [LangGraph](https://www.langchain.com/langgraph).
  * **Primary Responsibilities**: It handles requests from the frontend, orchestrates and executes the Agent's core logic, interacts with the LLM and Assistants service, and returns results to the frontend.
  * **Files**: `main.py` is the service entry point where you can define API routes and the Agent's execution flow. For details, refer to the [LangGraph documentation](https://langchain-ai.github.io/langgraph).

### 📦 frontend/

  * The frontend is a modern web interface built with [CopilotKit](https://docs.copilotkit.ai), responsible for all user interaction.
  * **Primary Responsibilities**: It provides an interface for users to ask questions and displays the Agent's streaming responses, data tables, Markdown, and other content formats.
  * **Files**: The core page logic is in `src/app/page.tsx`, and UI components are in `src/components/`.

### 📦 assistants/

  - data/: Store your data source files here (e.g., .db, .csv, .md).
  - plugins/: Define custom tools that your Agent can call. This is the ideal place to implement your personalized or private business logic. However, if you develop a tool with general applicability, we strongly encourage you to contribute it to the main project via a Pull Request to help all users!
  - main.py: Starts the Assistants service and registers the above resources and tools.

## 🗺️ Roadmap

- **✅ 1. Documentation & Tutorials**
    - `[x]` **Basic Docs:** Installation and configuration guides.
    - `[ ]` **Core Concepts:** In-depth explanations of key features and design.
    - `[ ]` **Plugin Dev Guide:** How to build your own plugins.
    - `[ ]` **End-to-End Tutorials:** Complete, step-by-step project examples.

- **⏳ 2. Plugin System**
    - `[x]` **Plugin management system**: Automatically loads plugin configurations and manages dependencies.
    - `[ ]` **Plugin CLI:** Install and manage plugins via the command line.
    - `[ ]` **Plugin Marketplace:** Discover, search, and download community plugins.
    - `[ ]` **Plugin Manager GUI:** A graphical interface to easily manage your plugins.

- **💡 3. Core Plugins**
    - `[x]` **Database Plugin:** Connect to mainstream databases.
    - `[ ]` **Knowledge Base Q&A Plugin:** Quickly build a Q&A application on your documents.

## 🤝 How to Contribute

We created this project to make Agents simpler for users, not to build yet another complex development framework. Therefore, we warmly welcome and heavily rely on community contributions to shape the future of **Dingent**.

If a feature is important to you, we strongly encourage you to discuss it by opening a GitHub Issue or contributing code directly through a Pull Request. Our core philosophy is that the developer community should decide which features are built into the software, rather than leaving users to maintain their own plugins\!

If you share our vision and wish to contribute code, please follow these steps:

1.  Fork this repository.
2.  Create a new feature branch (`git checkout -b feature/YourAmazingFeature`).
3.  Commit your changes (`git commit -m 'Add some AmazingFeature'`).
4.  Push your branch to GitHub (`git push origin feature/YourAmazingFeature`).
5.  Create a Pull Request and clearly describe the value of your feature.

We believe that through our collective efforts, Dingent can become a truly powerful and "out-of-the-box" tool.

## 📄 License

This project is licensed under the [MIT License](https://www.google.com/search?q=./LICENSE).
