---
sidebar_position: 1
---

# Assistant

## **概念：助手 (Assistant)**

一个**助手（Assistant）是一个面向特定领域任务的工具集合**。

如果说“工具”是一把螺丝刀或一个扳手，那么“助手”就是一个为特定工作（如“修理电脑”或“组装家具”）而准备的完整**工具箱**。它不仅包含了完成任务所需的工具，还包含了关于如何执行任务的**高级指令**。

例如，您可以创建：

  * **通用聊天助手**: 包含“打招呼”、“天气查询”、“网络搜索”等工具。
  * **数据分析助手**: 包含“数据库连接”、“SQL执行”、“图表生成”等一系列专业工具。
  * **客户服务助手**: 包含“订单查询”、“知识库检索”、“创建工单”等工具。

作为用户，您可以通过定义不同的助手，来创建多个具有不同能力和个性的智能体。

## **如何配置助手？**

您可以在一个独立的配置文件中定义一个或多个助手。每个助手的配置主要包括它的基本信息（如名称）、行为指令，以及它被授权使用的**工具列表**。

**配置文件示例**

  * **文件位置**: `<此处填写用户配置助手的文件路径，例如：config/assistants.yaml>`

<!-- end list -->

```yaml
# "assistants" 列表定义了项目中的所有助手
```

#### **配置字段详解**

  * `name` (必需): 您为这个助手设定的唯一名称。
  * `description` (可选): 对这个助手功能的简短描述，方便您自己管理和识别。
  * `instructions` (必需): 这是您给大模型的**核心指令**（也称为 System Prompt）。模型将严格遵循这里的指示来行动，这决定了它的性格、说话风格、行为准则和任务目标。您可以使用 `|` 来输入多行文本。
  * `tools` (必需): 一个列表，其中包含了这个助手**被授权使用的所有工具的 `id`**。
      * 列表中的每一个字符串，都必须与您在工具配置文件（例如 `config/tools.yaml`）中为工具实例定义的 `id` 完全匹配。
      * 只有在这里列出的工具，这个助手才能“看到”并调用它们。这是一种强大的安全和功能隔离机制。
