import base64
from . import config
import jwt


def set_dummy_signing_key():
    config.PYCAFE_SERVER_SIGN_PRIVATE_KEY = "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"  # noqa: E501
    config.PYCAFE_SERVER_SIGN_PUBLIC_KEY = "LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUFud0ZSQXhMWnR6VkN4dzFiU3VxRgpDdk1iRXNCRm5yeHloZTg5OW03TFB2dkU5WC9jTjFaKzB0M3FKS3M0ZmhuMFJkNHU5TGdaYU5iVHpyanZycG9JCit6NTJtQXhvMEVpN0M3dk1sTkRDNHFHZlp6MmZFUlM4YzBPK1Y5TjNGUDlqaURIWWJJVGx5bnhWWk9Ea0x3OW0KMUYxcTh4YzhYcC9QUGFwVlA4TmVqM2ZTZlhlOUc4MUttclYwVm5qTWFCbHZ2NWNUNi92WTlPeDFiUjBHcnFXSApuaVNhZEdFNFNoNXIrUVFsOHh0MllDSzBVY3FjbDdyeHFnOE9NUjNwbEhFM0lFeGF5cVdZdEY3Zk1UajlVMy9PCnJyWmxWdVRhVzZaRnNadVlKdmR4MWdLSG9nVCswQXZPN24wWWtxNjhoQzFtZmhCTzI2VWdFMTBzdnp3YjR2M0MKcVFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg=="  # noqa: E501


def sign_hash(hash: str, user_id: str) -> str:
    private_key_base64 = config.PYCAFE_SERVER_SIGN_PRIVATE_KEY
    private_key = base64.b64decode(private_key_base64)
    # TODO: we should include the user id, otherwise we cannot confirm the user
    data = {
        "hash": hash,
        "user_id": user_id,
    }
    return jwt.encode(data, private_key, algorithm="RS256")
