"""
Radia Test Suite

This package contains automated tests for the Radia Python module.

Test Categories:
- test_simple.py: Basic functionality tests
- test_radia.py: Comprehensive test suite
- test_advanced.py: Advanced features and edge cases
- test_parallel_performance.py: OpenMP parallelization tests
- benchmarks/: Performance benchmarking scripts

Usage:
	# Run all tests
	pytest tests/

	# Run specific test file
	pytest tests/test_simple.py

	# Run with verbose output
	pytest -v tests/

	# Run benchmarks
	python tests/benchmarks/benchmark_openmp.py
"""

__version__ = "4.32"
