# Generated by Django 4.2.9 on 2024-02-14 15:00

from django.db import migrations, models


def migrate_group(apps, schema_editor):
    Position = apps.get_model("wbhuman_resources", "Position")
    for position in Position.objects.filter(group__isnull=False):
        if position.group not in position.groups.all():
            position.groups.add(position.group)


class Migration(migrations.Migration):
    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("wbhuman_resources", "0017_absencerequest_crossborder_country_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="position",
            name="groups",
            field=models.ManyToManyField(blank=True, related_name="human_resources_positions", to="auth.group"),
        ),
        migrations.RunSQL(sql="SET CONSTRAINTS ALL IMMEDIATE;"),
        migrations.RunPython(migrate_group),
        migrations.RunSQL(sql="SET CONSTRAINTS ALL DEFERRED;"),
        migrations.RemoveField(
            model_name="position",
            name="group",
        ),
    ]
