# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, BinaryIO


class Config(TeaModel):
    """
    Model for initing client
    """
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        security_token: str = None,
        protocol: str = None,
        read_timeout: int = None,
        connect_timeout: int = None,
        http_proxy: str = None,
        https_proxy: str = None,
        endpoint: str = None,
        no_proxy: str = None,
        max_idle_conns: int = None,
        user_agent: str = None,
        socks_5proxy: str = None,
        socks_5net_work: str = None,
        max_idle_time_millis: int = None,
        keep_alive_duration_millis: int = None,
        max_requests: int = None,
        max_requests_per_host: int = None,
    ):
        # accesskey id
        self.access_key_id = access_key_id
        # accesskey secret
        self.access_key_secret = access_key_secret
        # security token
        self.security_token = security_token
        # http protocol
        self.protocol = protocol
        # read timeout
        self.read_timeout = read_timeout
        # connect timeout
        self.connect_timeout = connect_timeout
        # http proxy
        self.http_proxy = http_proxy
        # https proxy
        self.https_proxy = https_proxy
        # endpoint
        self.endpoint = endpoint
        # proxy white list
        self.no_proxy = no_proxy
        # max idle conns
        self.max_idle_conns = max_idle_conns
        # user agent
        self.user_agent = user_agent
        # socks5 proxy
        self.socks_5proxy = socks_5proxy
        # socks5 network
        self.socks_5net_work = socks_5net_work
        # 长链接最大空闲时长
        self.max_idle_time_millis = max_idle_time_millis
        # 长链接最大连接时长
        self.keep_alive_duration_millis = keep_alive_duration_millis
        # 最大连接数（长链接最大总数）
        self.max_requests = max_requests
        # 每个目标主机的最大连接数（分主机域名的长链接最大总数
        self.max_requests_per_host = max_requests_per_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.read_timeout is not None:
            result['readTimeout'] = self.read_timeout
        if self.connect_timeout is not None:
            result['connectTimeout'] = self.connect_timeout
        if self.http_proxy is not None:
            result['httpProxy'] = self.http_proxy
        if self.https_proxy is not None:
            result['httpsProxy'] = self.https_proxy
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.no_proxy is not None:
            result['noProxy'] = self.no_proxy
        if self.max_idle_conns is not None:
            result['maxIdleConns'] = self.max_idle_conns
        if self.user_agent is not None:
            result['userAgent'] = self.user_agent
        if self.socks_5proxy is not None:
            result['socks5Proxy'] = self.socks_5proxy
        if self.socks_5net_work is not None:
            result['socks5NetWork'] = self.socks_5net_work
        if self.max_idle_time_millis is not None:
            result['maxIdleTimeMillis'] = self.max_idle_time_millis
        if self.keep_alive_duration_millis is not None:
            result['keepAliveDurationMillis'] = self.keep_alive_duration_millis
        if self.max_requests is not None:
            result['maxRequests'] = self.max_requests
        if self.max_requests_per_host is not None:
            result['maxRequestsPerHost'] = self.max_requests_per_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('readTimeout') is not None:
            self.read_timeout = m.get('readTimeout')
        if m.get('connectTimeout') is not None:
            self.connect_timeout = m.get('connectTimeout')
        if m.get('httpProxy') is not None:
            self.http_proxy = m.get('httpProxy')
        if m.get('httpsProxy') is not None:
            self.https_proxy = m.get('httpsProxy')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('noProxy') is not None:
            self.no_proxy = m.get('noProxy')
        if m.get('maxIdleConns') is not None:
            self.max_idle_conns = m.get('maxIdleConns')
        if m.get('userAgent') is not None:
            self.user_agent = m.get('userAgent')
        if m.get('socks5Proxy') is not None:
            self.socks_5proxy = m.get('socks5Proxy')
        if m.get('socks5NetWork') is not None:
            self.socks_5net_work = m.get('socks5NetWork')
        if m.get('maxIdleTimeMillis') is not None:
            self.max_idle_time_millis = m.get('maxIdleTimeMillis')
        if m.get('keepAliveDurationMillis') is not None:
            self.keep_alive_duration_millis = m.get('keepAliveDurationMillis')
        if m.get('maxRequests') is not None:
            self.max_requests = m.get('maxRequests')
        if m.get('maxRequestsPerHost') is not None:
            self.max_requests_per_host = m.get('maxRequestsPerHost')
        return self


class RtopLevelDistribution(TeaModel):
    def __init__(
        self,
        count: int = None,
        level: str = None,
    ):
        # 统计值
        self.count = count
        # 等级
        self.level = level

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.level, 'level')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.level is not None:
            result['level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('level') is not None:
            self.level = m.get('level')
        return self


class InfoCodes(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # infocode
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class OutParams(TeaModel):
    def __init__(
        self,
        name: str = None,
        desc: str = None,
        value: str = None,
    ):
        # 输出参数
        self.name = name
        # 参数描述
        self.desc = desc
        # 参数值
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.desc is not None:
            result['desc'] = self.desc
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class SecurityScene(TeaModel):
    def __init__(
        self,
        access_channel: str = None,
        ctu_params: str = None,
        product_name: str = None,
        product_node: str = None,
        security_scene_params: str = None,
        system_name: str = None,
        total_fee: str = None,
    ):
        # 接入渠道
        self.access_channel = access_channel
        # 事件信息
        self.ctu_params = ctu_params
        # 产品名称
        self.product_name = product_name
        # 产品节点
        self.product_node = product_node
        # 扩展参数
        self.security_scene_params = security_scene_params
        # 系统名称
        self.system_name = system_name
        # 总金额
        self.total_fee = total_fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_channel is not None:
            result['access_channel'] = self.access_channel
        if self.ctu_params is not None:
            result['ctu_params'] = self.ctu_params
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.product_node is not None:
            result['product_node'] = self.product_node
        if self.security_scene_params is not None:
            result['security_scene_params'] = self.security_scene_params
        if self.system_name is not None:
            result['system_name'] = self.system_name
        if self.total_fee is not None:
            result['total_fee'] = self.total_fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('access_channel') is not None:
            self.access_channel = m.get('access_channel')
        if m.get('ctu_params') is not None:
            self.ctu_params = m.get('ctu_params')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('product_node') is not None:
            self.product_node = m.get('product_node')
        if m.get('security_scene_params') is not None:
            self.security_scene_params = m.get('security_scene_params')
        if m.get('system_name') is not None:
            self.system_name = m.get('system_name')
        if m.get('total_fee') is not None:
            self.total_fee = m.get('total_fee')
        return self


class Contact(TeaModel):
    def __init__(
        self,
        kind: str = None,
        name: str = None,
        mobile: str = None,
    ):
        # 联系人类型
        # 1配偶
        # 2父母
        # 3子女
        # 4兄弟
        # 5姐妹
        # 6朋友
        # 7其他
        self.kind = kind
        # 联系人姓名
        self.name = name
        # 联系人手机号
        self.mobile = mobile

    def validate(self):
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')
        self.validate_required(self.mobile, 'mobile')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        if self.mobile is not None:
            result['mobile'] = self.mobile
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        return self


class BatchQueryOutputModelInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_type: str = None,
    ):
        # 变量名称
        self.name = name
        # 变量值
        self.value = value
        # 变量值类型
        self.value_type = value_type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')
        self.validate_required(self.value_type, 'value_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        if self.value_type is not None:
            result['value_type'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('value_type') is not None:
            self.value_type = m.get('value_type')
        return self


class RiskDetail(TeaModel):
    def __init__(
        self,
        rule_weight: str = None,
        rule_name: str = None,
    ):
        # 反欺诈风险数据服务命中规则风险权重
        self.rule_weight = rule_weight
        # 反欺诈风险数据服务命中规则名称
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.rule_weight, 'rule_weight')
        self.validate_required(self.rule_name, 'rule_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_weight is not None:
            result['rule_weight'] = self.rule_weight
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_weight') is not None:
            self.rule_weight = m.get('rule_weight')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        return self


class BackflowEventRecordProperty(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # 属性code
        self.key = key
        # 属性value，统一为字符串
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class TermDetail(TeaModel):
    def __init__(
        self,
        term: str = None,
        term_amount: int = None,
        term_principal: int = None,
        term_fee: int = None,
        settle_date: str = None,
        penalty: int = None,
        guarantee_fee: int = None,
        liquidated_damages: int = None,
        server_fee: int = None,
        deduct_amount: int = None,
    ):
        # 期数
        self.term = term
        # 期供金额
        self.term_amount = term_amount
        # 当期本金
        self.term_principal = term_principal
        # 当期利息（分期产生的利息/手续费）
        self.term_fee = term_fee
        # 应还款日期
        self.settle_date = settle_date
        # 罚息
        self.penalty = penalty
        # 担保费
        self.guarantee_fee = guarantee_fee
        # 违约金
        self.liquidated_damages = liquidated_damages
        # 服务费
        self.server_fee = server_fee
        # 减免金额
        self.deduct_amount = deduct_amount

    def validate(self):
        self.validate_required(self.term, 'term')
        self.validate_required(self.term_amount, 'term_amount')
        self.validate_required(self.term_principal, 'term_principal')
        self.validate_required(self.term_fee, 'term_fee')
        self.validate_required(self.settle_date, 'settle_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.term is not None:
            result['term'] = self.term
        if self.term_amount is not None:
            result['term_amount'] = self.term_amount
        if self.term_principal is not None:
            result['term_principal'] = self.term_principal
        if self.term_fee is not None:
            result['term_fee'] = self.term_fee
        if self.settle_date is not None:
            result['settle_date'] = self.settle_date
        if self.penalty is not None:
            result['penalty'] = self.penalty
        if self.guarantee_fee is not None:
            result['guarantee_fee'] = self.guarantee_fee
        if self.liquidated_damages is not None:
            result['liquidated_damages'] = self.liquidated_damages
        if self.server_fee is not None:
            result['server_fee'] = self.server_fee
        if self.deduct_amount is not None:
            result['deduct_amount'] = self.deduct_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('term') is not None:
            self.term = m.get('term')
        if m.get('term_amount') is not None:
            self.term_amount = m.get('term_amount')
        if m.get('term_principal') is not None:
            self.term_principal = m.get('term_principal')
        if m.get('term_fee') is not None:
            self.term_fee = m.get('term_fee')
        if m.get('settle_date') is not None:
            self.settle_date = m.get('settle_date')
        if m.get('penalty') is not None:
            self.penalty = m.get('penalty')
        if m.get('guarantee_fee') is not None:
            self.guarantee_fee = m.get('guarantee_fee')
        if m.get('liquidated_damages') is not None:
            self.liquidated_damages = m.get('liquidated_damages')
        if m.get('server_fee') is not None:
            self.server_fee = m.get('server_fee')
        if m.get('deduct_amount') is not None:
            self.deduct_amount = m.get('deduct_amount')
        return self


class BaseCustomerUmktInfoModel(TeaModel):
    def __init__(
        self,
        customer_key: str = None,
        query_template: str = None,
        umkt_result: int = None,
    ):
        # 用户凭证
        self.customer_key = customer_key
        # 输入模板
        self.query_template = query_template
        # 实时营销结果
        self.umkt_result = umkt_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.query_template is not None:
            result['query_template'] = self.query_template
        if self.umkt_result is not None:
            result['umkt_result'] = self.umkt_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('query_template') is not None:
            self.query_template = m.get('query_template')
        if m.get('umkt_result') is not None:
            self.umkt_result = m.get('umkt_result')
        return self


class RtopTypeDistribution(TeaModel):
    def __init__(
        self,
        count: int = None,
        level_distribution: List[RtopLevelDistribution] = None,
        type: str = None,
    ):
        # 统计值
        self.count = count
        # 当前类型下的等级分布
        self.level_distribution = level_distribution
        # 类型
        self.type = type

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.level_distribution, 'level_distribution')
        if self.level_distribution:
            for k in self.level_distribution:
                if k:
                    k.validate()
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        result['levelDistribution'] = []
        if self.level_distribution is not None:
            for k in self.level_distribution:
                result['levelDistribution'].append(k.to_map() if k else None)
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        self.level_distribution = []
        if m.get('levelDistribution') is not None:
            for k in m.get('levelDistribution'):
                temp_model = RtopLevelDistribution()
                self.level_distribution.append(temp_model.from_map(k))
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UmktOfflineDecisionTaskDetailInfo(TeaModel):
    def __init__(
        self,
        task_id: int = None,
        decision_plan_id: int = None,
        decision_result_status: str = None,
        status_remark: str = None,
    ):
        # 任务id
        self.task_id = task_id
        # 圈客计划id
        self.decision_plan_id = decision_plan_id
        # 圈客结果状态
        self.decision_result_status = decision_result_status
        # 圈客结果状态描述
        self.status_remark = status_remark

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.decision_plan_id, 'decision_plan_id')
        self.validate_required(self.decision_result_status, 'decision_result_status')
        self.validate_required(self.status_remark, 'status_remark')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.decision_plan_id is not None:
            result['decision_plan_id'] = self.decision_plan_id
        if self.decision_result_status is not None:
            result['decision_result_status'] = self.decision_result_status
        if self.status_remark is not None:
            result['status_remark'] = self.status_remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('decision_plan_id') is not None:
            self.decision_plan_id = m.get('decision_plan_id')
        if m.get('decision_result_status') is not None:
            self.decision_result_status = m.get('decision_result_status')
        if m.get('status_remark') is not None:
            self.status_remark = m.get('status_remark')
        return self


class ActionParamInfo(TeaModel):
    def __init__(
        self,
        content_type: str = None,
        action_param: List[str] = None,
    ):
        # 触达媒介类型
        self.content_type = content_type
        # 触达媒介参数列表
        self.action_param = action_param

    def validate(self):
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.action_param, 'action_param')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_type is not None:
            result['content_type'] = self.content_type
        if self.action_param is not None:
            result['action_param'] = self.action_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content_type') is not None:
            self.content_type = m.get('content_type')
        if m.get('action_param') is not None:
            self.action_param = m.get('action_param')
        return self


class RtopCrowdRiskFeatureTag(TeaModel):
    def __init__(
        self,
        tag_explanation: str = None,
        tag_name: str = None,
    ):
        # 标签描述
        self.tag_explanation = tag_explanation
        # 标签名称
        self.tag_name = tag_name

    def validate(self):
        self.validate_required(self.tag_explanation, 'tag_explanation')
        self.validate_required(self.tag_name, 'tag_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_explanation is not None:
            result['tag_explanation'] = self.tag_explanation
        if self.tag_name is not None:
            result['tag_name'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tag_explanation') is not None:
            self.tag_explanation = m.get('tag_explanation')
        if m.get('tag_name') is not None:
            self.tag_name = m.get('tag_name')
        return self


class DecisionFlow(TeaModel):
    def __init__(
        self,
        decision_flow: OutParams = None,
        decision: str = None,
        info_codes: InfoCodes = None,
    ):
        # 输出参数
        self.decision_flow = decision_flow
        # 决策结果
        self.decision = decision
        # infocodes
        self.info_codes = info_codes

    def validate(self):
        if self.decision_flow:
            self.decision_flow.validate()
        self.validate_required(self.decision, 'decision')
        if self.info_codes:
            self.info_codes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decision_flow is not None:
            result['decision_flow'] = self.decision_flow.to_map()
        if self.decision is not None:
            result['decision'] = self.decision
        if self.info_codes is not None:
            result['info_codes'] = self.info_codes.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('decision_flow') is not None:
            temp_model = OutParams()
            self.decision_flow = temp_model.from_map(m['decision_flow'])
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('info_codes') is not None:
            temp_model = InfoCodes()
            self.info_codes = temp_model.from_map(m['info_codes'])
        return self


class RpspInfoModel(TeaModel):
    def __init__(
        self,
        plan_code: str = None,
        scene_strategy_id: int = None,
        rpsp_result: str = None,
        rpsp_out_put_info: str = None,
    ):
        # 流量分层计划code
        self.plan_code = plan_code
        # 场景策略Id
        self.scene_strategy_id = scene_strategy_id
        # 客群分层结果
        self.rpsp_result = rpsp_result
        # 
        # json 结构的营销额外输出信息
        self.rpsp_out_put_info = rpsp_out_put_info

    def validate(self):
        self.validate_required(self.plan_code, 'plan_code')
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.rpsp_result, 'rpsp_result')
        self.validate_required(self.rpsp_out_put_info, 'rpsp_out_put_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.plan_code is not None:
            result['plan_code'] = self.plan_code
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.rpsp_result is not None:
            result['rpsp_result'] = self.rpsp_result
        if self.rpsp_out_put_info is not None:
            result['rpsp_out_put_info'] = self.rpsp_out_put_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('plan_code') is not None:
            self.plan_code = m.get('plan_code')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('rpsp_result') is not None:
            self.rpsp_result = m.get('rpsp_result')
        if m.get('rpsp_out_put_info') is not None:
            self.rpsp_out_put_info = m.get('rpsp_out_put_info')
        return self


class CouponInfo(TeaModel):
    def __init__(
        self,
        coupon_id: str = None,
        coupon_name: str = None,
        status: str = None,
        use_condition: str = None,
        coupon_code: str = None,
        coupon_type: str = None,
        coupon_value: str = None,
        coupon_amount: str = None,
        expired_time: str = None,
        effective_time: str = None,
        use_detail: str = None,
        min_amount: str = None,
        max_amount: str = None,
        min_period: str = None,
        max_period: str = None,
        min_day: str = None,
        repayment_method: str = None,
        is_period_limit: str = None,
        repay_condition: str = None,
        repay_ways: str = None,
        coupon_model_no: str = None,
        to_maturity: str = None,
    ):
        # 优惠券Id
        self.coupon_id = coupon_id
        # 优惠券名称
        self.coupon_name = coupon_name
        # 优惠券状态
        # unUsed-未使用
        # Used-已使用
        # Expired-过期
        self.status = status
        # 使用场景
        # 01-提款使用
        # 02-还款使用
        self.use_condition = use_condition
        # 优惠码
        self.coupon_code = coupon_code
        # 优惠券类型
        # 01-金额优惠
        # 02-天数优惠
        # 03-折扣优惠
        # 04-期数优惠
        # 05-固定利率
        self.coupon_type = coupon_type
        # 优惠券面额
        # coupon_type=01 时为优惠金额
        # coupon_type=02 时为减免天数
        # coupon_type=03 时为折扣值（如6 折）
        # coupon_type=04 时为减免期数
        # coupon_type=05 时为折扣值（如 8.88 为利率8.88%）
        self.coupon_value = coupon_value
        # 当 coupon_type=01 时，才会有优惠金额
        self.coupon_amount = coupon_amount
        # 过期时间yyyy-MM-dd HH:mm:ss
        self.expired_time = expired_time
        # 生效时间yyyy-MM-dd HH:mm:ss
        self.effective_time = effective_time
        # 使用规则
        self.use_detail = use_detail
        # 贷款最低金额
        self.min_amount = min_amount
        # 贷款最高金额
        self.max_amount = max_amount
        # 最低贷款期数
        self.min_period = min_period
        # 最高贷款期数
        self.max_period = max_period
        # 贷款最低期限天数
        self.min_day = min_day
        # 还款方式
        # 1-等额本息
        # 2-等额本金
        # 3-等本等费
        # 4-按期付息到期还本
        # 5-到期一次性还本付息
        # 6-等本等费-总费率
        # 7-等额本息(长期)
        self.repayment_method = repayment_method
        # 是否有贷款期数要求
        # 0：否
        # 1：是
        self.is_period_limit = is_period_limit
        # 贷款期限要求还款条件
        # 01：可提前还款
        # 02：不可提前还款
        # isPeriodLimit=1 && repayCondition=01 代表：有可提前还款锁期
        # isPeriodLimit=1 && repayCondition=02 代表：有不可提前还款锁期
        self.repay_condition = repay_condition
        # 还款场景
        # 01-到期还款
        # 02-即期还款
        self.repay_ways = repay_ways
        # 优惠模板Id
        self.coupon_model_no = coupon_model_no
        # 至到期:X年X月X日
        # 0：不是至到期券
        # 1：是至到期券
        self.to_maturity = to_maturity

    def validate(self):
        self.validate_required(self.coupon_id, 'coupon_id')
        self.validate_required(self.coupon_name, 'coupon_name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.use_condition, 'use_condition')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coupon_id is not None:
            result['coupon_id'] = self.coupon_id
        if self.coupon_name is not None:
            result['coupon_name'] = self.coupon_name
        if self.status is not None:
            result['status'] = self.status
        if self.use_condition is not None:
            result['use_condition'] = self.use_condition
        if self.coupon_code is not None:
            result['coupon_code'] = self.coupon_code
        if self.coupon_type is not None:
            result['coupon_type'] = self.coupon_type
        if self.coupon_value is not None:
            result['coupon_value'] = self.coupon_value
        if self.coupon_amount is not None:
            result['coupon_amount'] = self.coupon_amount
        if self.expired_time is not None:
            result['expired_time'] = self.expired_time
        if self.effective_time is not None:
            result['effective_time'] = self.effective_time
        if self.use_detail is not None:
            result['use_detail'] = self.use_detail
        if self.min_amount is not None:
            result['min_amount'] = self.min_amount
        if self.max_amount is not None:
            result['max_amount'] = self.max_amount
        if self.min_period is not None:
            result['min_period'] = self.min_period
        if self.max_period is not None:
            result['max_period'] = self.max_period
        if self.min_day is not None:
            result['min_day'] = self.min_day
        if self.repayment_method is not None:
            result['repayment_method'] = self.repayment_method
        if self.is_period_limit is not None:
            result['is_period_limit'] = self.is_period_limit
        if self.repay_condition is not None:
            result['repay_condition'] = self.repay_condition
        if self.repay_ways is not None:
            result['repay_ways'] = self.repay_ways
        if self.coupon_model_no is not None:
            result['coupon_model_no'] = self.coupon_model_no
        if self.to_maturity is not None:
            result['to_maturity'] = self.to_maturity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('coupon_id') is not None:
            self.coupon_id = m.get('coupon_id')
        if m.get('coupon_name') is not None:
            self.coupon_name = m.get('coupon_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('use_condition') is not None:
            self.use_condition = m.get('use_condition')
        if m.get('coupon_code') is not None:
            self.coupon_code = m.get('coupon_code')
        if m.get('coupon_type') is not None:
            self.coupon_type = m.get('coupon_type')
        if m.get('coupon_value') is not None:
            self.coupon_value = m.get('coupon_value')
        if m.get('coupon_amount') is not None:
            self.coupon_amount = m.get('coupon_amount')
        if m.get('expired_time') is not None:
            self.expired_time = m.get('expired_time')
        if m.get('effective_time') is not None:
            self.effective_time = m.get('effective_time')
        if m.get('use_detail') is not None:
            self.use_detail = m.get('use_detail')
        if m.get('min_amount') is not None:
            self.min_amount = m.get('min_amount')
        if m.get('max_amount') is not None:
            self.max_amount = m.get('max_amount')
        if m.get('min_period') is not None:
            self.min_period = m.get('min_period')
        if m.get('max_period') is not None:
            self.max_period = m.get('max_period')
        if m.get('min_day') is not None:
            self.min_day = m.get('min_day')
        if m.get('repayment_method') is not None:
            self.repayment_method = m.get('repayment_method')
        if m.get('is_period_limit') is not None:
            self.is_period_limit = m.get('is_period_limit')
        if m.get('repay_condition') is not None:
            self.repay_condition = m.get('repay_condition')
        if m.get('repay_ways') is not None:
            self.repay_ways = m.get('repay_ways')
        if m.get('coupon_model_no') is not None:
            self.coupon_model_no = m.get('coupon_model_no')
        if m.get('to_maturity') is not None:
            self.to_maturity = m.get('to_maturity')
        return self


class UmktInfoModel(TeaModel):
    def __init__(
        self,
        scene_strategy_id: int = None,
        umkt_result: int = None,
        umkt_out_put_info: str = None,
    ):
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 实时营销结果
        self.umkt_result = umkt_result
        # json 结构的营销额外输出信息
        self.umkt_out_put_info = umkt_out_put_info

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.umkt_result, 'umkt_result')
        self.validate_required(self.umkt_out_put_info, 'umkt_out_put_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.umkt_result is not None:
            result['umkt_result'] = self.umkt_result
        if self.umkt_out_put_info is not None:
            result['umkt_out_put_info'] = self.umkt_out_put_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('umkt_result') is not None:
            self.umkt_result = m.get('umkt_result')
        if m.get('umkt_out_put_info') is not None:
            self.umkt_out_put_info = m.get('umkt_out_put_info')
        return self


class RtopRiskTag(TeaModel):
    def __init__(
        self,
        tag_id: str = None,
        tag_name: str = None,
        tag_type: str = None,
        tag_text: str = None,
        tag_clue: str = None,
        clue_detail_type: str = None,
        tag_clue_detail: str = None,
    ):
        # 标签ID
        self.tag_id = tag_id
        # 标签名称
        self.tag_name = tag_name
        # 标签类型
        self.tag_type = tag_type
        # 标签文本
        self.tag_text = tag_text
        # 线索概览
        self.tag_clue = tag_clue
        # 线索明细类型
        self.clue_detail_type = clue_detail_type
        # 线索明细
        self.tag_clue_detail = tag_clue_detail

    def validate(self):
        self.validate_required(self.tag_id, 'tag_id')
        self.validate_required(self.tag_name, 'tag_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_id is not None:
            result['tag_id'] = self.tag_id
        if self.tag_name is not None:
            result['tag_name'] = self.tag_name
        if self.tag_type is not None:
            result['tag_type'] = self.tag_type
        if self.tag_text is not None:
            result['tag_text'] = self.tag_text
        if self.tag_clue is not None:
            result['tag_clue'] = self.tag_clue
        if self.clue_detail_type is not None:
            result['clue_detail_type'] = self.clue_detail_type
        if self.tag_clue_detail is not None:
            result['tag_clue_detail'] = self.tag_clue_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tag_id') is not None:
            self.tag_id = m.get('tag_id')
        if m.get('tag_name') is not None:
            self.tag_name = m.get('tag_name')
        if m.get('tag_type') is not None:
            self.tag_type = m.get('tag_type')
        if m.get('tag_text') is not None:
            self.tag_text = m.get('tag_text')
        if m.get('tag_clue') is not None:
            self.tag_clue = m.get('tag_clue')
        if m.get('clue_detail_type') is not None:
            self.clue_detail_type = m.get('clue_detail_type')
        if m.get('tag_clue_detail') is not None:
            self.tag_clue_detail = m.get('tag_clue_detail')
        return self


class StatisticInfoDetail(TeaModel):
    def __init__(
        self,
        action_driver_code: int = None,
        success_count: int = None,
        fail_count: int = None,
        waiting_sub_task_count: int = None,
        total_count: int = None,
    ):
        # actionDriverCode类型
        self.action_driver_code = action_driver_code
        # 成功数
        self.success_count = success_count
        # 失败数
        self.fail_count = fail_count
        # 待触达的手机号数
        self.waiting_sub_task_count = waiting_sub_task_count
        # 已收到的回执数
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_driver_code is not None:
            result['action_driver_code'] = self.action_driver_code
        if self.success_count is not None:
            result['success_count'] = self.success_count
        if self.fail_count is not None:
            result['fail_count'] = self.fail_count
        if self.waiting_sub_task_count is not None:
            result['waiting_sub_task_count'] = self.waiting_sub_task_count
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action_driver_code') is not None:
            self.action_driver_code = m.get('action_driver_code')
        if m.get('success_count') is not None:
            self.success_count = m.get('success_count')
        if m.get('fail_count') is not None:
            self.fail_count = m.get('fail_count')
        if m.get('waiting_sub_task_count') is not None:
            self.waiting_sub_task_count = m.get('waiting_sub_task_count')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class RuleDetail(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 规则细节名称
        self.name = name
        # 规则细节值
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class Additional(TeaModel):
    def __init__(
        self,
        deliveryman: str = None,
    ):
        # 骑手标识；1-骑手
        self.deliveryman = deliveryman

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deliveryman is not None:
            result['deliveryman'] = self.deliveryman
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deliveryman') is not None:
            self.deliveryman = m.get('deliveryman')
        return self


class RepayResult(TeaModel):
    def __init__(
        self,
        custom_no: str = None,
        period: str = None,
        need_amount: int = None,
        need_corpus: int = None,
        need_accrual: int = None,
        need_fee: int = None,
        already_amount: int = None,
        already_corpus: int = None,
        already_overcorpus: int = None,
        already_accrual: int = None,
        already_punish: int = None,
        already_fee: int = None,
        rate: int = None,
        penalty_value: int = None,
        rest_amount: int = None,
        rest_corpus: int = None,
        rest_accrual: int = None,
        rest_punish: int = None,
        remain_corpus: int = None,
        receipt_no: str = None,
        status: str = None,
        settle_date: str = None,
        trade_date: str = None,
        already_guarantee_fee: int = None,
        already_liquidated_damages: int = None,
        rest_guarantee_fee: int = None,
        rest_liquidated_damages: int = None,
        need_guarantee_fee: int = None,
        need_liquidated_damages: int = None,
        overdue_days: int = None,
    ):
        # 客户编码
        self.custom_no = custom_no
        # 当前期数
        self.period = period
        # 应还总额
        self.need_amount = need_amount
        # 应还本金
        self.need_corpus = need_corpus
        # 应还利息
        self.need_accrual = need_accrual
        # 应还手续费
        self.need_fee = need_fee
        # 已还总额
        self.already_amount = already_amount
        # 已还本金
        self.already_corpus = already_corpus
        # 已还逾期本金
        self.already_overcorpus = already_overcorpus
        # 已还利息
        self.already_accrual = already_accrual
        # 已还逾期息
        self.already_punish = already_punish
        # 已还手续费
        self.already_fee = already_fee
        # 利率
        self.rate = rate
        # 罚息率
        self.penalty_value = penalty_value
        # 当期剩余总额
        self.rest_amount = rest_amount
        # 当期剩余本金
        self.rest_corpus = rest_corpus
        # 当期剩余利息
        self.rest_accrual = rest_accrual
        # 当期剩余罚息
        self.rest_punish = rest_punish
        # 期末本金
        self.remain_corpus = remain_corpus
        # 借据编号
        self.receipt_no = receipt_no
        # 还款状态1：已还清 2 未还 3 部分还款
        self.status = status
        # 应还日期
        self.settle_date = settle_date
        # 还款日期
        self.trade_date = trade_date
        # 已还担保费
        self.already_guarantee_fee = already_guarantee_fee
        # 已还违约金
        self.already_liquidated_damages = already_liquidated_damages
        # 当期剩余担保费
        self.rest_guarantee_fee = rest_guarantee_fee
        # 当期剩余违约金
        self.rest_liquidated_damages = rest_liquidated_damages
        # 应还担保费
        self.need_guarantee_fee = need_guarantee_fee
        # 应还违约金
        self.need_liquidated_damages = need_liquidated_damages
        # 逾期天数
        self.overdue_days = overdue_days

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.period, 'period')
        self.validate_required(self.need_amount, 'need_amount')
        self.validate_required(self.need_corpus, 'need_corpus')
        self.validate_required(self.need_accrual, 'need_accrual')
        self.validate_required(self.need_fee, 'need_fee')
        self.validate_required(self.already_amount, 'already_amount')
        self.validate_required(self.already_corpus, 'already_corpus')
        self.validate_required(self.already_overcorpus, 'already_overcorpus')
        self.validate_required(self.already_accrual, 'already_accrual')
        self.validate_required(self.already_punish, 'already_punish')
        self.validate_required(self.already_fee, 'already_fee')
        self.validate_required(self.rate, 'rate')
        self.validate_required(self.penalty_value, 'penalty_value')
        self.validate_required(self.rest_amount, 'rest_amount')
        self.validate_required(self.rest_corpus, 'rest_corpus')
        self.validate_required(self.rest_accrual, 'rest_accrual')
        self.validate_required(self.rest_punish, 'rest_punish')
        self.validate_required(self.remain_corpus, 'remain_corpus')
        self.validate_required(self.receipt_no, 'receipt_no')
        self.validate_required(self.status, 'status')
        self.validate_required(self.settle_date, 'settle_date')
        if self.settle_date is not None:
            self.validate_pattern(self.settle_date, 'settle_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.trade_date, 'trade_date')
        if self.trade_date is not None:
            self.validate_pattern(self.trade_date, 'trade_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.already_guarantee_fee, 'already_guarantee_fee')
        self.validate_required(self.already_liquidated_damages, 'already_liquidated_damages')
        self.validate_required(self.rest_guarantee_fee, 'rest_guarantee_fee')
        self.validate_required(self.rest_liquidated_damages, 'rest_liquidated_damages')
        self.validate_required(self.need_guarantee_fee, 'need_guarantee_fee')
        self.validate_required(self.need_liquidated_damages, 'need_liquidated_damages')
        self.validate_required(self.overdue_days, 'overdue_days')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.period is not None:
            result['period'] = self.period
        if self.need_amount is not None:
            result['need_amount'] = self.need_amount
        if self.need_corpus is not None:
            result['need_corpus'] = self.need_corpus
        if self.need_accrual is not None:
            result['need_accrual'] = self.need_accrual
        if self.need_fee is not None:
            result['need_fee'] = self.need_fee
        if self.already_amount is not None:
            result['already_amount'] = self.already_amount
        if self.already_corpus is not None:
            result['already_corpus'] = self.already_corpus
        if self.already_overcorpus is not None:
            result['already_overcorpus'] = self.already_overcorpus
        if self.already_accrual is not None:
            result['already_accrual'] = self.already_accrual
        if self.already_punish is not None:
            result['already_punish'] = self.already_punish
        if self.already_fee is not None:
            result['already_fee'] = self.already_fee
        if self.rate is not None:
            result['rate'] = self.rate
        if self.penalty_value is not None:
            result['penalty_value'] = self.penalty_value
        if self.rest_amount is not None:
            result['rest_amount'] = self.rest_amount
        if self.rest_corpus is not None:
            result['rest_corpus'] = self.rest_corpus
        if self.rest_accrual is not None:
            result['rest_accrual'] = self.rest_accrual
        if self.rest_punish is not None:
            result['rest_punish'] = self.rest_punish
        if self.remain_corpus is not None:
            result['remain_corpus'] = self.remain_corpus
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.status is not None:
            result['status'] = self.status
        if self.settle_date is not None:
            result['settle_date'] = self.settle_date
        if self.trade_date is not None:
            result['trade_date'] = self.trade_date
        if self.already_guarantee_fee is not None:
            result['already_guarantee_fee'] = self.already_guarantee_fee
        if self.already_liquidated_damages is not None:
            result['already_liquidated_damages'] = self.already_liquidated_damages
        if self.rest_guarantee_fee is not None:
            result['rest_guarantee_fee'] = self.rest_guarantee_fee
        if self.rest_liquidated_damages is not None:
            result['rest_liquidated_damages'] = self.rest_liquidated_damages
        if self.need_guarantee_fee is not None:
            result['need_guarantee_fee'] = self.need_guarantee_fee
        if self.need_liquidated_damages is not None:
            result['need_liquidated_damages'] = self.need_liquidated_damages
        if self.overdue_days is not None:
            result['overdue_days'] = self.overdue_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('need_amount') is not None:
            self.need_amount = m.get('need_amount')
        if m.get('need_corpus') is not None:
            self.need_corpus = m.get('need_corpus')
        if m.get('need_accrual') is not None:
            self.need_accrual = m.get('need_accrual')
        if m.get('need_fee') is not None:
            self.need_fee = m.get('need_fee')
        if m.get('already_amount') is not None:
            self.already_amount = m.get('already_amount')
        if m.get('already_corpus') is not None:
            self.already_corpus = m.get('already_corpus')
        if m.get('already_overcorpus') is not None:
            self.already_overcorpus = m.get('already_overcorpus')
        if m.get('already_accrual') is not None:
            self.already_accrual = m.get('already_accrual')
        if m.get('already_punish') is not None:
            self.already_punish = m.get('already_punish')
        if m.get('already_fee') is not None:
            self.already_fee = m.get('already_fee')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('penalty_value') is not None:
            self.penalty_value = m.get('penalty_value')
        if m.get('rest_amount') is not None:
            self.rest_amount = m.get('rest_amount')
        if m.get('rest_corpus') is not None:
            self.rest_corpus = m.get('rest_corpus')
        if m.get('rest_accrual') is not None:
            self.rest_accrual = m.get('rest_accrual')
        if m.get('rest_punish') is not None:
            self.rest_punish = m.get('rest_punish')
        if m.get('remain_corpus') is not None:
            self.remain_corpus = m.get('remain_corpus')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('settle_date') is not None:
            self.settle_date = m.get('settle_date')
        if m.get('trade_date') is not None:
            self.trade_date = m.get('trade_date')
        if m.get('already_guarantee_fee') is not None:
            self.already_guarantee_fee = m.get('already_guarantee_fee')
        if m.get('already_liquidated_damages') is not None:
            self.already_liquidated_damages = m.get('already_liquidated_damages')
        if m.get('rest_guarantee_fee') is not None:
            self.rest_guarantee_fee = m.get('rest_guarantee_fee')
        if m.get('rest_liquidated_damages') is not None:
            self.rest_liquidated_damages = m.get('rest_liquidated_damages')
        if m.get('need_guarantee_fee') is not None:
            self.need_guarantee_fee = m.get('need_guarantee_fee')
        if m.get('need_liquidated_damages') is not None:
            self.need_liquidated_damages = m.get('need_liquidated_damages')
        if m.get('overdue_days') is not None:
            self.overdue_days = m.get('overdue_days')
        return self


class RiskInfo(TeaModel):
    def __init__(
        self,
        risk_group_desc: str = None,
        risk_group: str = None,
        risk_group_category: str = None,
        risk_details: List[RiskDetail] = None,
    ):
        # 反欺诈风险数据服务风险组描述
        self.risk_group_desc = risk_group_desc
        # 反欺诈风险数据服务风险组名
        self.risk_group = risk_group
        # 反欺诈风险数据服务风险组类别
        self.risk_group_category = risk_group_category
        # 反欺诈风险数据服务风险组信息
        self.risk_details = risk_details

    def validate(self):
        self.validate_required(self.risk_group_desc, 'risk_group_desc')
        self.validate_required(self.risk_group, 'risk_group')
        self.validate_required(self.risk_group_category, 'risk_group_category')
        self.validate_required(self.risk_details, 'risk_details')
        if self.risk_details:
            for k in self.risk_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_group_desc is not None:
            result['risk_group_desc'] = self.risk_group_desc
        if self.risk_group is not None:
            result['risk_group'] = self.risk_group
        if self.risk_group_category is not None:
            result['risk_group_category'] = self.risk_group_category
        result['risk_details'] = []
        if self.risk_details is not None:
            for k in self.risk_details:
                result['risk_details'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('risk_group_desc') is not None:
            self.risk_group_desc = m.get('risk_group_desc')
        if m.get('risk_group') is not None:
            self.risk_group = m.get('risk_group')
        if m.get('risk_group_category') is not None:
            self.risk_group_category = m.get('risk_group_category')
        self.risk_details = []
        if m.get('risk_details') is not None:
            for k in m.get('risk_details'):
                temp_model = RiskDetail()
                self.risk_details.append(temp_model.from_map(k))
        return self


class UpdateCustomerRelationResponseData(TeaModel):
    def __init__(
        self,
        id: int = None,
        channel_code: str = None,
        channel_no: str = None,
        customer_no: str = None,
        create_time: str = None,
        update_time: str = None,
    ):
        # id
        self.id = id
        # 渠道编码
        self.channel_code = channel_code
        # 渠道id
        self.channel_no = channel_no
        # 客户号
        self.customer_no = customer_no
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.create_time is not None:
            self.validate_pattern(self.create_time, 'create_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.update_time is not None:
            self.validate_pattern(self.update_time, 'update_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.channel_no is not None:
            result['channel_no'] = self.channel_no
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.update_time is not None:
            result['update_time'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('channel_no') is not None:
            self.channel_no = m.get('channel_no')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        return self


class SmsTemplate(TeaModel):
    def __init__(
        self,
        scene_strategy_id: str = None,
        scene_strategy_name: str = None,
        template_content: str = None,
    ):
        # 场景策略ID
        self.scene_strategy_id = scene_strategy_id
        # 计划名称
        self.scene_strategy_name = scene_strategy_name
        # 模板内容
        self.template_content = template_content

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.scene_strategy_name, 'scene_strategy_name')
        self.validate_required(self.template_content, 'template_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.scene_strategy_name is not None:
            result['scene_strategy_name'] = self.scene_strategy_name
        if self.template_content is not None:
            result['template_content'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('scene_strategy_name') is not None:
            self.scene_strategy_name = m.get('scene_strategy_name')
        if m.get('template_content') is not None:
            self.template_content = m.get('template_content')
        return self


class BackflowEventRecord(TeaModel):
    def __init__(
        self,
        properties: List[BackflowEventRecordProperty] = None,
    ):
        # 回流事件部分分组后的记录list
        self.properties = properties

    def validate(self):
        self.validate_required(self.properties, 'properties')
        if self.properties:
            for k in self.properties:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['properties'] = []
        if self.properties is not None:
            for k in self.properties:
                result['properties'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.properties = []
        if m.get('properties') is not None:
            for k in m.get('properties'):
                temp_model = BackflowEventRecordProperty()
                self.properties.append(temp_model.from_map(k))
        return self


class RtopCompanyRiskFactor(TeaModel):
    def __init__(
        self,
        name: str = None,
        score: int = None,
    ):
        # 维度名称
        self.name = name
        # 维度分数
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class TestStruct(TeaModel):
    def __init__(
        self,
        test_field: List[SecurityScene] = None,
    ):
        # 测试
        self.test_field = test_field

    def validate(self):
        self.validate_required(self.test_field, 'test_field')
        if self.test_field:
            for k in self.test_field:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['test_field'] = []
        if self.test_field is not None:
            for k in self.test_field:
                result['test_field'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.test_field = []
        if m.get('test_field') is not None:
            for k in m.get('test_field'):
                temp_model = SecurityScene()
                self.test_field.append(temp_model.from_map(k))
        return self


class Material(TeaModel):
    def __init__(
        self,
        m_type: str = None,
        big_code: str = None,
        small_code: str = None,
        meterial_name: str = None,
        file_path: str = None,
    ):
        # 资料类型0-风控报告1-合同2-图片3-附件
        self.m_type = m_type
        # 大类编码00-风控报告10-合同20身份证图片26人脸图片30-附件
        self.big_code = big_code
        # 小类编码
        # 201-身份证人脸面202身份证国徽面212-活体人脸图片
        self.small_code = small_code
        # 资料名称
        self.meterial_name = meterial_name
        # 文件地址
        self.file_path = file_path

    def validate(self):
        self.validate_required(self.m_type, 'm_type')
        self.validate_required(self.big_code, 'big_code')
        self.validate_required(self.small_code, 'small_code')
        self.validate_required(self.meterial_name, 'meterial_name')
        self.validate_required(self.file_path, 'file_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.m_type is not None:
            result['m_type'] = self.m_type
        if self.big_code is not None:
            result['big_code'] = self.big_code
        if self.small_code is not None:
            result['small_code'] = self.small_code
        if self.meterial_name is not None:
            result['meterial_name'] = self.meterial_name
        if self.file_path is not None:
            result['file_path'] = self.file_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('m_type') is not None:
            self.m_type = m.get('m_type')
        if m.get('big_code') is not None:
            self.big_code = m.get('big_code')
        if m.get('small_code') is not None:
            self.small_code = m.get('small_code')
        if m.get('meterial_name') is not None:
            self.meterial_name = m.get('meterial_name')
        if m.get('file_path') is not None:
            self.file_path = m.get('file_path')
        return self


class CustomReceiptStatus(TeaModel):
    def __init__(
        self,
        receipt_flag: bool = None,
    ):
        # 是否结清
        self.receipt_flag = receipt_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.receipt_flag is not None:
            result['receipt_flag'] = self.receipt_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('receipt_flag') is not None:
            self.receipt_flag = m.get('receipt_flag')
        return self


class RiskData(TeaModel):
    def __init__(
        self,
        contacts: List[Contact] = None,
        face_point: str = None,
        face_source: str = None,
    ):
        # 联系人信息列表
        self.contacts = contacts
        # 人脸对比分
        self.face_point = face_point
        # 活体供应商
        self.face_source = face_source

    def validate(self):
        self.validate_required(self.contacts, 'contacts')
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['contacts'].append(k.to_map() if k else None)
        if self.face_point is not None:
            result['face_point'] = self.face_point
        if self.face_source is not None:
            result['face_source'] = self.face_source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contacts = []
        if m.get('contacts') is not None:
            for k in m.get('contacts'):
                temp_model = Contact()
                self.contacts.append(temp_model.from_map(k))
        if m.get('face_point') is not None:
            self.face_point = m.get('face_point')
        if m.get('face_source') is not None:
            self.face_source = m.get('face_source')
        return self


class RepayInfos(TeaModel):
    def __init__(
        self,
        period: int = None,
        amount: int = None,
        principal: int = None,
        interest: int = None,
        channel_amt: int = None,
        fee: int = None,
        punish: int = None,
        guarantee_fee: int = None,
        liquidated_damages: int = None,
    ):
        # 期次
        self.period = period
        # 实还总额
        self.amount = amount
        # 实还本金
        self.principal = principal
        # 实还利息
        self.interest = interest
        # 实还通道手续费
        self.channel_amt = channel_amt
        # 实还手续费
        self.fee = fee
        # 实收罚息
        self.punish = punish
        # 担保费
        self.guarantee_fee = guarantee_fee
        # 违约金
        self.liquidated_damages = liquidated_damages

    def validate(self):
        self.validate_required(self.period, 'period')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.principal, 'principal')
        self.validate_required(self.interest, 'interest')
        self.validate_required(self.channel_amt, 'channel_amt')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.punish, 'punish')
        self.validate_required(self.guarantee_fee, 'guarantee_fee')
        self.validate_required(self.liquidated_damages, 'liquidated_damages')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['period'] = self.period
        if self.amount is not None:
            result['amount'] = self.amount
        if self.principal is not None:
            result['principal'] = self.principal
        if self.interest is not None:
            result['interest'] = self.interest
        if self.channel_amt is not None:
            result['channel_amt'] = self.channel_amt
        if self.fee is not None:
            result['fee'] = self.fee
        if self.punish is not None:
            result['punish'] = self.punish
        if self.guarantee_fee is not None:
            result['guarantee_fee'] = self.guarantee_fee
        if self.liquidated_damages is not None:
            result['liquidated_damages'] = self.liquidated_damages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('principal') is not None:
            self.principal = m.get('principal')
        if m.get('interest') is not None:
            self.interest = m.get('interest')
        if m.get('channel_amt') is not None:
            self.channel_amt = m.get('channel_amt')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('punish') is not None:
            self.punish = m.get('punish')
        if m.get('guarantee_fee') is not None:
            self.guarantee_fee = m.get('guarantee_fee')
        if m.get('liquidated_damages') is not None:
            self.liquidated_damages = m.get('liquidated_damages')
        return self


class SecurityDataQueryStruct(TeaModel):
    def __init__(
        self,
        params: str = None,
        type: str = None,
        version: str = None,
    ):
        # 请求数据参数
        self.params = params
        # 请求数据类型
        self.type = type
        # 请求数据版本
        self.version = version

    def validate(self):
        self.validate_required(self.params, 'params')
        self.validate_required(self.type, 'type')
        self.validate_required(self.version, 'version')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class UserAggregationInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        credit_amount: int = None,
        available_amount: int = None,
        should_pay_amount: int = None,
        overdue_amount: int = None,
        next_period_amount: int = None,
        next_period_repay_time: str = None,
        next_apply_time: str = None,
        coupon_list: List[CouponInfo] = None,
    ):
        # 状态
        # 0: 未授信
        # 1: 授信中
        # 2: 已授信未支用
        # 3: 支用中
        # 4: 已支用
        # 5: 借据逾期
        # 6: 授信过期
        # 7: 授信冻结
        # 8: 可重新授信
        # 9: 授信拒绝
        self.status = status
        # 总额度
        self.credit_amount = credit_amount
        # 可用额度
        self.available_amount = available_amount
        # 待还总金额
        self.should_pay_amount = should_pay_amount
        # 逾期总金额
        self.overdue_amount = overdue_amount
        # 下一期应还金额
        self.next_period_amount = next_period_amount
        # 下一期还款时间yyyy-MM-dd
        self.next_period_repay_time = next_period_repay_time
        # 下次可授信时间yyyy-MM-dd
        self.next_apply_time = next_apply_time
        # 优惠券列表
        self.coupon_list = coupon_list

    def validate(self):
        self.validate_required(self.status, 'status')
        if self.coupon_list:
            for k in self.coupon_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['status'] = self.status
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.available_amount is not None:
            result['available_amount'] = self.available_amount
        if self.should_pay_amount is not None:
            result['should_pay_amount'] = self.should_pay_amount
        if self.overdue_amount is not None:
            result['overdue_amount'] = self.overdue_amount
        if self.next_period_amount is not None:
            result['next_period_amount'] = self.next_period_amount
        if self.next_period_repay_time is not None:
            result['next_period_repay_time'] = self.next_period_repay_time
        if self.next_apply_time is not None:
            result['next_apply_time'] = self.next_apply_time
        result['coupon_list'] = []
        if self.coupon_list is not None:
            for k in self.coupon_list:
                result['coupon_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('available_amount') is not None:
            self.available_amount = m.get('available_amount')
        if m.get('should_pay_amount') is not None:
            self.should_pay_amount = m.get('should_pay_amount')
        if m.get('overdue_amount') is not None:
            self.overdue_amount = m.get('overdue_amount')
        if m.get('next_period_amount') is not None:
            self.next_period_amount = m.get('next_period_amount')
        if m.get('next_period_repay_time') is not None:
            self.next_period_repay_time = m.get('next_period_repay_time')
        if m.get('next_apply_time') is not None:
            self.next_apply_time = m.get('next_apply_time')
        self.coupon_list = []
        if m.get('coupon_list') is not None:
            for k in m.get('coupon_list'):
                temp_model = CouponInfo()
                self.coupon_list.append(temp_model.from_map(k))
        return self


class SceneInfos(TeaModel):
    def __init__(
        self,
        decision: str = None,
        scene_code: str = None,
    ):
        # 决策结果
        self.decision = decision
        # 场景code
        self.scene_code = scene_code

    def validate(self):
        self.validate_required(self.decision, 'decision')
        self.validate_required(self.scene_code, 'scene_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decision is not None:
            result['decision'] = self.decision
        if self.scene_code is not None:
            result['scene_code'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('scene_code') is not None:
            self.scene_code = m.get('scene_code')
        return self


class ActionPlanDetailInfo(TeaModel):
    def __init__(
        self,
        scene_strategy_id: int = None,
        scene_strategy_name: str = None,
        scene_strategy_status: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        action_param_info: List[ActionParamInfo] = None,
    ):
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 场景策略名称
        self.scene_strategy_name = scene_strategy_name
        # 场景策略状态
        self.scene_strategy_status = scene_strategy_status
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 触达媒介参数信息
        self.action_param_info = action_param_info

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.scene_strategy_name, 'scene_strategy_name')
        self.validate_required(self.scene_strategy_status, 'scene_strategy_status')
        self.validate_required(self.gmt_create, 'gmt_create')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.action_param_info, 'action_param_info')
        if self.action_param_info:
            for k in self.action_param_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.scene_strategy_name is not None:
            result['scene_strategy_name'] = self.scene_strategy_name
        if self.scene_strategy_status is not None:
            result['scene_strategy_status'] = self.scene_strategy_status
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['action_param_info'] = []
        if self.action_param_info is not None:
            for k in self.action_param_info:
                result['action_param_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('scene_strategy_name') is not None:
            self.scene_strategy_name = m.get('scene_strategy_name')
        if m.get('scene_strategy_status') is not None:
            self.scene_strategy_status = m.get('scene_strategy_status')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.action_param_info = []
        if m.get('action_param_info') is not None:
            for k in m.get('action_param_info'):
                temp_model = ActionParamInfo()
                self.action_param_info.append(temp_model.from_map(k))
        return self


class RiskLabelInfo(TeaModel):
    def __init__(
        self,
        clue_detail_type: str = None,
        dt: str = None,
        gmt_create: str = None,
        id: int = None,
        is_deleted: int = None,
        mct_one_id: str = None,
        operator_id: str = None,
        op_type: str = None,
        org_name: str = None,
        risk_detail_type: str = None,
        risk_dimension_type: str = None,
        tag_clue: str = None,
        tag_clue_detail: str = None,
        tag_id: str = None,
        tag_list_headers: str = None,
        tag_list_order_column: str = None,
        tag_list_order_type: str = None,
        tag_text: str = None,
        tag_trend_chart_name: str = None,
        update_date: str = None,
    ):
        # 线索明细类型(字段停用)
        self.clue_detail_type = clue_detail_type
        # odps数据产出时间，冗余字段，业务上不需要，以备错误排查
        self.dt = dt
        # 数据产生时间
        self.gmt_create = gmt_create
        # 记录唯一ID
        self.id = id
        # 0-正常 1-删除
        self.is_deleted = is_deleted
        # 企业ID
        self.mct_one_id = mct_one_id
        # 操作人ID
        self.operator_id = operator_id
        # 操作类型
        # add、delete、update
        self.op_type = op_type
        # 企业名称
        self.org_name = org_name
        # 线索类型
        self.risk_detail_type = risk_detail_type
        # 风险维度
        # 
        self.risk_dimension_type = risk_dimension_type
        # 线索概览
        self.tag_clue = tag_clue
        # 线索明细
        self.tag_clue_detail = tag_clue_detail
        # 标签ID
        self.tag_id = tag_id
        # 线索列表表头，英文逗号分隔
        # 
        self.tag_list_headers = tag_list_headers
        # 标签列表，排序字段
        self.tag_list_order_column = tag_list_order_column
        # 标签列表排序方式
        self.tag_list_order_type = tag_list_order_type
        # 标签文本
        self.tag_text = tag_text
        # 趋势图表名
        self.tag_trend_chart_name = tag_trend_chart_name
        # 数据同步到公有云时间(业务上赋值当天)
        self.update_date = update_date

    def validate(self):
        self.validate_required(self.clue_detail_type, 'clue_detail_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.id, 'id')
        self.validate_required(self.is_deleted, 'is_deleted')
        self.validate_required(self.mct_one_id, 'mct_one_id')
        self.validate_required(self.operator_id, 'operator_id')
        self.validate_required(self.op_type, 'op_type')
        self.validate_required(self.org_name, 'org_name')
        self.validate_required(self.risk_detail_type, 'risk_detail_type')
        self.validate_required(self.risk_dimension_type, 'risk_dimension_type')
        self.validate_required(self.tag_clue, 'tag_clue')
        self.validate_required(self.tag_clue_detail, 'tag_clue_detail')
        self.validate_required(self.tag_id, 'tag_id')
        self.validate_required(self.tag_list_headers, 'tag_list_headers')
        self.validate_required(self.tag_list_order_column, 'tag_list_order_column')
        self.validate_required(self.tag_list_order_type, 'tag_list_order_type')
        self.validate_required(self.tag_text, 'tag_text')
        self.validate_required(self.tag_trend_chart_name, 'tag_trend_chart_name')
        self.validate_required(self.update_date, 'update_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clue_detail_type is not None:
            result['clue_detail_type'] = self.clue_detail_type
        if self.dt is not None:
            result['dt'] = self.dt
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.id is not None:
            result['id'] = self.id
        if self.is_deleted is not None:
            result['is_deleted'] = self.is_deleted
        if self.mct_one_id is not None:
            result['mct_one_id'] = self.mct_one_id
        if self.operator_id is not None:
            result['operator_id'] = self.operator_id
        if self.op_type is not None:
            result['op_type'] = self.op_type
        if self.org_name is not None:
            result['org_name'] = self.org_name
        if self.risk_detail_type is not None:
            result['risk_detail_type'] = self.risk_detail_type
        if self.risk_dimension_type is not None:
            result['risk_dimension_type'] = self.risk_dimension_type
        if self.tag_clue is not None:
            result['tag_clue'] = self.tag_clue
        if self.tag_clue_detail is not None:
            result['tag_clue_detail'] = self.tag_clue_detail
        if self.tag_id is not None:
            result['tag_id'] = self.tag_id
        if self.tag_list_headers is not None:
            result['tag_list_headers'] = self.tag_list_headers
        if self.tag_list_order_column is not None:
            result['tag_list_order_column'] = self.tag_list_order_column
        if self.tag_list_order_type is not None:
            result['tag_list_order_type'] = self.tag_list_order_type
        if self.tag_text is not None:
            result['tag_text'] = self.tag_text
        if self.tag_trend_chart_name is not None:
            result['tag_trend_chart_name'] = self.tag_trend_chart_name
        if self.update_date is not None:
            result['update_date'] = self.update_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clue_detail_type') is not None:
            self.clue_detail_type = m.get('clue_detail_type')
        if m.get('dt') is not None:
            self.dt = m.get('dt')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('is_deleted') is not None:
            self.is_deleted = m.get('is_deleted')
        if m.get('mct_one_id') is not None:
            self.mct_one_id = m.get('mct_one_id')
        if m.get('operator_id') is not None:
            self.operator_id = m.get('operator_id')
        if m.get('op_type') is not None:
            self.op_type = m.get('op_type')
        if m.get('org_name') is not None:
            self.org_name = m.get('org_name')
        if m.get('risk_detail_type') is not None:
            self.risk_detail_type = m.get('risk_detail_type')
        if m.get('risk_dimension_type') is not None:
            self.risk_dimension_type = m.get('risk_dimension_type')
        if m.get('tag_clue') is not None:
            self.tag_clue = m.get('tag_clue')
        if m.get('tag_clue_detail') is not None:
            self.tag_clue_detail = m.get('tag_clue_detail')
        if m.get('tag_id') is not None:
            self.tag_id = m.get('tag_id')
        if m.get('tag_list_headers') is not None:
            self.tag_list_headers = m.get('tag_list_headers')
        if m.get('tag_list_order_column') is not None:
            self.tag_list_order_column = m.get('tag_list_order_column')
        if m.get('tag_list_order_type') is not None:
            self.tag_list_order_type = m.get('tag_list_order_type')
        if m.get('tag_text') is not None:
            self.tag_text = m.get('tag_text')
        if m.get('tag_trend_chart_name') is not None:
            self.tag_trend_chart_name = m.get('tag_trend_chart_name')
        if m.get('update_date') is not None:
            self.update_date = m.get('update_date')
        return self


class RtopCompanyFeedback(TeaModel):
    def __init__(
        self,
        id: int = None,
        company_id: str = None,
        feedback_reason: str = None,
        feedback_reason_detail: str = None,
        comment: str = None,
    ):
        # 主键
        self.id = id
        # 企业ID
        self.company_id = company_id
        # 反馈原因
        self.feedback_reason = feedback_reason
        # 反馈原因详情
        self.feedback_reason_detail = feedback_reason_detail
        # 评论
        self.comment = comment

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.company_id, 'company_id')
        self.validate_required(self.feedback_reason, 'feedback_reason')
        self.validate_required(self.feedback_reason_detail, 'feedback_reason_detail')
        self.validate_required(self.comment, 'comment')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.company_id is not None:
            result['company_id'] = self.company_id
        if self.feedback_reason is not None:
            result['feedback_reason'] = self.feedback_reason
        if self.feedback_reason_detail is not None:
            result['feedback_reason_detail'] = self.feedback_reason_detail
        if self.comment is not None:
            result['comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('company_id') is not None:
            self.company_id = m.get('company_id')
        if m.get('feedback_reason') is not None:
            self.feedback_reason = m.get('feedback_reason')
        if m.get('feedback_reason_detail') is not None:
            self.feedback_reason_detail = m.get('feedback_reason_detail')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        return self


class RuntimeResult(TeaModel):
    def __init__(
        self,
        code: int = None,
        success: bool = None,
        resultmsg: str = None,
        data: str = None,
    ):
        # 上传成功
        self.code = code
        # true代表上传成功，false代表上传失败
        self.success = success
        # 上文件传成功
        self.resultmsg = resultmsg
        # 文件上传结果
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.resultmsg, 'resultmsg')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.success is not None:
            result['success'] = self.success
        if self.resultmsg is not None:
            result['resultmsg'] = self.resultmsg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('resultmsg') is not None:
            self.resultmsg = m.get('resultmsg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class RtopMonitorCompanyFeature(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        risk_tags: List[str] = None,
        score: int = None,
    ):
        # 特征的描述
        self.description = description
        # 特征的名称
        self.name = name
        # 特征里的风险标签列表
        self.risk_tags = risk_tags
        # 特征的评分
        self.score = score

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.score, 'score')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.risk_tags is not None:
            result['risk_tags'] = self.risk_tags
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('risk_tags') is not None:
            self.risk_tags = m.get('risk_tags')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class RtopCompanyRiskInfo(TeaModel):
    def __init__(
        self,
        place_type: str = None,
        place_name: str = None,
        mct_one_id: str = None,
        uc_code: str = None,
        reg_no: str = None,
        org_code: str = None,
        org_name: str = None,
        risk_score: str = None,
        risk_shift_rank: str = None,
        risk_type: str = None,
        risk_tags_id: List[str] = None,
        tags_clue: str = None,
        tags_clue_detail: str = None,
    ):
        # 区域类型
        self.place_type = place_type
        # 区域
        self.place_name = place_name
        # 企业唯一id
        self.mct_one_id = mct_one_id
        # 企业统一社会信用代码
        self.uc_code = uc_code
        # 工商注册号
        self.reg_no = reg_no
        # 组织机构代码
        self.org_code = org_code
        # 企业名
        self.org_name = org_name
        # 风险评分
        self.risk_score = risk_score
        # 风险变化程度排序，根据分值波动大小，标签变更次数排序
        self.risk_shift_rank = risk_shift_rank
        # 风险定性
        self.risk_type = risk_type
        # 风险标签id列表
        self.risk_tags_id = risk_tags_id
        # 线索
        self.tags_clue = tags_clue
        # 风险线索明细
        self.tags_clue_detail = tags_clue_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.place_type is not None:
            result['place_type'] = self.place_type
        if self.place_name is not None:
            result['place_name'] = self.place_name
        if self.mct_one_id is not None:
            result['mct_one_id'] = self.mct_one_id
        if self.uc_code is not None:
            result['uc_code'] = self.uc_code
        if self.reg_no is not None:
            result['reg_no'] = self.reg_no
        if self.org_code is not None:
            result['org_code'] = self.org_code
        if self.org_name is not None:
            result['org_name'] = self.org_name
        if self.risk_score is not None:
            result['risk_score'] = self.risk_score
        if self.risk_shift_rank is not None:
            result['risk_shift_rank'] = self.risk_shift_rank
        if self.risk_type is not None:
            result['risk_type'] = self.risk_type
        if self.risk_tags_id is not None:
            result['risk_tags_id'] = self.risk_tags_id
        if self.tags_clue is not None:
            result['tags_clue'] = self.tags_clue
        if self.tags_clue_detail is not None:
            result['tags_clue_detail'] = self.tags_clue_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('place_type') is not None:
            self.place_type = m.get('place_type')
        if m.get('place_name') is not None:
            self.place_name = m.get('place_name')
        if m.get('mct_one_id') is not None:
            self.mct_one_id = m.get('mct_one_id')
        if m.get('uc_code') is not None:
            self.uc_code = m.get('uc_code')
        if m.get('reg_no') is not None:
            self.reg_no = m.get('reg_no')
        if m.get('org_code') is not None:
            self.org_code = m.get('org_code')
        if m.get('org_name') is not None:
            self.org_name = m.get('org_name')
        if m.get('risk_score') is not None:
            self.risk_score = m.get('risk_score')
        if m.get('risk_shift_rank') is not None:
            self.risk_shift_rank = m.get('risk_shift_rank')
        if m.get('risk_type') is not None:
            self.risk_type = m.get('risk_type')
        if m.get('risk_tags_id') is not None:
            self.risk_tags_id = m.get('risk_tags_id')
        if m.get('tags_clue') is not None:
            self.tags_clue = m.get('tags_clue')
        if m.get('tags_clue_detail') is not None:
            self.tags_clue_detail = m.get('tags_clue_detail')
        return self


class RtopRiskStormCompanyAnnualReport(TeaModel):
    def __init__(
        self,
        annual_report_count: int = None,
        annual_report_has_equity_transfer: bool = None,
        annual_report_has_external_guarantee: bool = None,
        annual_report_has_external_invest: bool = None,
        annual_report_main_business_income: str = None,
        annual_report_net_profit: str = None,
        annual_report_release_date: str = None,
        annual_report_sh_actual_paid: str = None,
        annual_report_staff_count: int = None,
        annual_report_total_assets: str = None,
        annual_report_total_liabilities: str = None,
        annual_report_total_operating_income: str = None,
        annual_report_total_owner_equity: str = None,
        annual_report_total_profit: str = None,
        annual_report_total_tax: str = None,
        annual_report_year: str = None,
    ):
        # 年报个数
        self.annual_report_count = annual_report_count
        # 年报是否发生股权转让
        self.annual_report_has_equity_transfer = annual_report_has_equity_transfer
        # 年报是否对外提供担保
        self.annual_report_has_external_guarantee = annual_report_has_external_guarantee
        # 年报是否对外投资
        self.annual_report_has_external_invest = annual_report_has_external_invest
        # 营业总收入中主营业务收入
        self.annual_report_main_business_income = annual_report_main_business_income
        # 年报净利润
        self.annual_report_net_profit = annual_report_net_profit
        # 年报发布日期
        self.annual_report_release_date = annual_report_release_date
        # 年报股东实缴出资额（万元（实缴出资额用两个冒号::分割）
        self.annual_report_sh_actual_paid = annual_report_sh_actual_paid
        # 年报公司人数
        self.annual_report_staff_count = annual_report_staff_count
        # 资产总额
        self.annual_report_total_assets = annual_report_total_assets
        # 负债总额
        self.annual_report_total_liabilities = annual_report_total_liabilities
        # 营业总收入
        self.annual_report_total_operating_income = annual_report_total_operating_income
        # 年报所有者权益合计
        self.annual_report_total_owner_equity = annual_report_total_owner_equity
        # 年报利润总额
        self.annual_report_total_profit = annual_report_total_profit
        # 纳税总额
        self.annual_report_total_tax = annual_report_total_tax
        # 年报报送年度
        self.annual_report_year = annual_report_year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annual_report_count is not None:
            result['annual_report_count'] = self.annual_report_count
        if self.annual_report_has_equity_transfer is not None:
            result['annual_report_has_equity_transfer'] = self.annual_report_has_equity_transfer
        if self.annual_report_has_external_guarantee is not None:
            result['annual_report_has_external_guarantee'] = self.annual_report_has_external_guarantee
        if self.annual_report_has_external_invest is not None:
            result['annual_report_has_external_invest'] = self.annual_report_has_external_invest
        if self.annual_report_main_business_income is not None:
            result['annual_report_main_business_income'] = self.annual_report_main_business_income
        if self.annual_report_net_profit is not None:
            result['annual_report_net_profit'] = self.annual_report_net_profit
        if self.annual_report_release_date is not None:
            result['annual_report_release_date'] = self.annual_report_release_date
        if self.annual_report_sh_actual_paid is not None:
            result['annual_report_sh_actual_paid'] = self.annual_report_sh_actual_paid
        if self.annual_report_staff_count is not None:
            result['annual_report_staff_count'] = self.annual_report_staff_count
        if self.annual_report_total_assets is not None:
            result['annual_report_total_assets'] = self.annual_report_total_assets
        if self.annual_report_total_liabilities is not None:
            result['annual_report_total_liabilities'] = self.annual_report_total_liabilities
        if self.annual_report_total_operating_income is not None:
            result['annual_report_total_operating_income'] = self.annual_report_total_operating_income
        if self.annual_report_total_owner_equity is not None:
            result['annual_report_total_owner_equity'] = self.annual_report_total_owner_equity
        if self.annual_report_total_profit is not None:
            result['annual_report_total_profit'] = self.annual_report_total_profit
        if self.annual_report_total_tax is not None:
            result['annual_report_total_tax'] = self.annual_report_total_tax
        if self.annual_report_year is not None:
            result['annual_report_year'] = self.annual_report_year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('annual_report_count') is not None:
            self.annual_report_count = m.get('annual_report_count')
        if m.get('annual_report_has_equity_transfer') is not None:
            self.annual_report_has_equity_transfer = m.get('annual_report_has_equity_transfer')
        if m.get('annual_report_has_external_guarantee') is not None:
            self.annual_report_has_external_guarantee = m.get('annual_report_has_external_guarantee')
        if m.get('annual_report_has_external_invest') is not None:
            self.annual_report_has_external_invest = m.get('annual_report_has_external_invest')
        if m.get('annual_report_main_business_income') is not None:
            self.annual_report_main_business_income = m.get('annual_report_main_business_income')
        if m.get('annual_report_net_profit') is not None:
            self.annual_report_net_profit = m.get('annual_report_net_profit')
        if m.get('annual_report_release_date') is not None:
            self.annual_report_release_date = m.get('annual_report_release_date')
        if m.get('annual_report_sh_actual_paid') is not None:
            self.annual_report_sh_actual_paid = m.get('annual_report_sh_actual_paid')
        if m.get('annual_report_staff_count') is not None:
            self.annual_report_staff_count = m.get('annual_report_staff_count')
        if m.get('annual_report_total_assets') is not None:
            self.annual_report_total_assets = m.get('annual_report_total_assets')
        if m.get('annual_report_total_liabilities') is not None:
            self.annual_report_total_liabilities = m.get('annual_report_total_liabilities')
        if m.get('annual_report_total_operating_income') is not None:
            self.annual_report_total_operating_income = m.get('annual_report_total_operating_income')
        if m.get('annual_report_total_owner_equity') is not None:
            self.annual_report_total_owner_equity = m.get('annual_report_total_owner_equity')
        if m.get('annual_report_total_profit') is not None:
            self.annual_report_total_profit = m.get('annual_report_total_profit')
        if m.get('annual_report_total_tax') is not None:
            self.annual_report_total_tax = m.get('annual_report_total_tax')
        if m.get('annual_report_year') is not None:
            self.annual_report_year = m.get('annual_report_year')
        return self


class CustomerRpspInfosModel(TeaModel):
    def __init__(
        self,
        rpsp_results: List[RpspInfoModel] = None,
        customer_key: str = None,
    ):
        # 归属用户的混合分层决策结果
        self.rpsp_results = rpsp_results
        # 用户凭证
        self.customer_key = customer_key

    def validate(self):
        self.validate_required(self.rpsp_results, 'rpsp_results')
        if self.rpsp_results:
            for k in self.rpsp_results:
                if k:
                    k.validate()
        self.validate_required(self.customer_key, 'customer_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['rpsp_results'] = []
        if self.rpsp_results is not None:
            for k in self.rpsp_results:
                result['rpsp_results'].append(k.to_map() if k else None)
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rpsp_results = []
        if m.get('rpsp_results') is not None:
            for k in m.get('rpsp_results'):
                temp_model = RpspInfoModel()
                self.rpsp_results.append(temp_model.from_map(k))
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        return self


class QueryInfo(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class StrategyUploadResult(TeaModel):
    def __init__(
        self,
        rule_meta_id: int = None,
        scene_id: int = None,
        tenant_scene_id: int = None,
        decision_rule_id: int = None,
        scene_strategy_id: int = None,
    ):
        # 元数据id
        self.rule_meta_id = rule_meta_id
        # 场景id
        self.scene_id = scene_id
        # 租户场景id
        self.tenant_scene_id = tenant_scene_id
        # 圈客规则id
        self.decision_rule_id = decision_rule_id
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_meta_id is not None:
            result['rule_meta_id'] = self.rule_meta_id
        if self.scene_id is not None:
            result['scene_id'] = self.scene_id
        if self.tenant_scene_id is not None:
            result['tenant_scene_id'] = self.tenant_scene_id
        if self.decision_rule_id is not None:
            result['decision_rule_id'] = self.decision_rule_id
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_meta_id') is not None:
            self.rule_meta_id = m.get('rule_meta_id')
        if m.get('scene_id') is not None:
            self.scene_id = m.get('scene_id')
        if m.get('tenant_scene_id') is not None:
            self.tenant_scene_id = m.get('tenant_scene_id')
        if m.get('decision_rule_id') is not None:
            self.decision_rule_id = m.get('decision_rule_id')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        return self


class RtopRiskyCompany(TeaModel):
    def __init__(
        self,
        company_id: str = None,
        change_score: str = None,
        change_level: str = None,
        new_added_time: str = None,
        head_register_place: str = None,
        data_time: str = None,
    ):
        # 企业ID
        self.company_id = company_id
        # 异动分数
        self.change_score = change_score
        # 异动程度
        self.change_level = change_level
        # 新增企业的时间
        self.new_added_time = new_added_time
        # 总公司注册地
        self.head_register_place = head_register_place
        # 数据的时间
        self.data_time = data_time

    def validate(self):
        self.validate_required(self.company_id, 'company_id')
        self.validate_required(self.change_score, 'change_score')
        self.validate_required(self.change_level, 'change_level')
        self.validate_required(self.new_added_time, 'new_added_time')
        if self.new_added_time is not None:
            self.validate_pattern(self.new_added_time, 'new_added_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.head_register_place, 'head_register_place')
        self.validate_required(self.data_time, 'data_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_id is not None:
            result['company_id'] = self.company_id
        if self.change_score is not None:
            result['change_score'] = self.change_score
        if self.change_level is not None:
            result['change_level'] = self.change_level
        if self.new_added_time is not None:
            result['new_added_time'] = self.new_added_time
        if self.head_register_place is not None:
            result['head_register_place'] = self.head_register_place
        if self.data_time is not None:
            result['data_time'] = self.data_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('company_id') is not None:
            self.company_id = m.get('company_id')
        if m.get('change_score') is not None:
            self.change_score = m.get('change_score')
        if m.get('change_level') is not None:
            self.change_level = m.get('change_level')
        if m.get('new_added_time') is not None:
            self.new_added_time = m.get('new_added_time')
        if m.get('head_register_place') is not None:
            self.head_register_place = m.get('head_register_place')
        if m.get('data_time') is not None:
            self.data_time = m.get('data_time')
        return self


class ZhimaQueryResp(TeaModel):
    def __init__(
        self,
        ep_cert_no: str = None,
        ep_name: str = None,
        failed_code: str = None,
        passed: str = None,
        result_code: str = None,
        result_msg: str = None,
        sub_code: str = None,
        sub_msg: str = None,
    ):
        # 认证的企业证件号
        self.ep_cert_no = ep_cert_no
        # 认证的企业名
        self.ep_name = ep_name
        # 认证不通过的错误码
        self.failed_code = failed_code
        # 认证是否通过，通过为true，不通过为false
        self.passed = passed
        # 10000是成功，其余是失败
        self.result_code = result_code
        # 
        self.result_msg = result_msg
        # 
        self.sub_code = sub_code
        # 
        self.sub_msg = sub_msg

    def validate(self):
        self.validate_required(self.result_code, 'result_code')
        self.validate_required(self.result_msg, 'result_msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.ep_name is not None:
            result['ep_name'] = self.ep_name
        if self.failed_code is not None:
            result['failed_code'] = self.failed_code
        if self.passed is not None:
            result['passed'] = self.passed
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.sub_code is not None:
            result['sub_code'] = self.sub_code
        if self.sub_msg is not None:
            result['sub_msg'] = self.sub_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('ep_name') is not None:
            self.ep_name = m.get('ep_name')
        if m.get('failed_code') is not None:
            self.failed_code = m.get('failed_code')
        if m.get('passed') is not None:
            self.passed = m.get('passed')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('sub_code') is not None:
            self.sub_code = m.get('sub_code')
        if m.get('sub_msg') is not None:
            self.sub_msg = m.get('sub_msg')
        return self


class RtopCrowdRiskSummaryResp(TeaModel):
    def __init__(
        self,
        active_city: str = None,
        active_county: str = None,
        active_province: str = None,
        clue_tags: List[str] = None,
        company_id: str = None,
        company_name: str = None,
        crowd_risk_level: str = None,
        crowd_risk_score: int = None,
        crowd_risk_type: str = None,
        detected_time: str = None,
        money_involved: int = None,
        people_involved: int = None,
        registered_city: str = None,
        registered_county: str = None,
        registered_province: str = None,
    ):
        # 活跃市
        self.active_city = active_city
        # 活跃县
        self.active_county = active_county
        # 活跃省
        self.active_province = active_province
        # 风险标签
        self.clue_tags = clue_tags
        # 企业ID
        self.company_id = company_id
        # 企业名称
        self.company_name = company_name
        # 风险等级
        self.crowd_risk_level = crowd_risk_level
        # 涉众风险分数
        self.crowd_risk_score = crowd_risk_score
        # 涉众风险类型
        self.crowd_risk_type = crowd_risk_type
        # 发现时间
        self.detected_time = detected_time
        # 影响金额
        self.money_involved = money_involved
        # 影响人数
        self.people_involved = people_involved
        # 注册市
        self.registered_city = registered_city
        # 注册县
        self.registered_county = registered_county
        # 注册省
        self.registered_province = registered_province

    def validate(self):
        self.validate_required(self.company_id, 'company_id')
        self.validate_required(self.company_name, 'company_name')
        if self.detected_time is not None:
            self.validate_pattern(self.detected_time, 'detected_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_city is not None:
            result['active_city'] = self.active_city
        if self.active_county is not None:
            result['active_county'] = self.active_county
        if self.active_province is not None:
            result['active_province'] = self.active_province
        if self.clue_tags is not None:
            result['clue_tags'] = self.clue_tags
        if self.company_id is not None:
            result['company_id'] = self.company_id
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.crowd_risk_level is not None:
            result['crowd_risk_level'] = self.crowd_risk_level
        if self.crowd_risk_score is not None:
            result['crowd_risk_score'] = self.crowd_risk_score
        if self.crowd_risk_type is not None:
            result['crowd_risk_type'] = self.crowd_risk_type
        if self.detected_time is not None:
            result['detected_time'] = self.detected_time
        if self.money_involved is not None:
            result['money_involved'] = self.money_involved
        if self.people_involved is not None:
            result['people_involved'] = self.people_involved
        if self.registered_city is not None:
            result['registered_city'] = self.registered_city
        if self.registered_county is not None:
            result['registered_county'] = self.registered_county
        if self.registered_province is not None:
            result['registered_province'] = self.registered_province
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active_city') is not None:
            self.active_city = m.get('active_city')
        if m.get('active_county') is not None:
            self.active_county = m.get('active_county')
        if m.get('active_province') is not None:
            self.active_province = m.get('active_province')
        if m.get('clue_tags') is not None:
            self.clue_tags = m.get('clue_tags')
        if m.get('company_id') is not None:
            self.company_id = m.get('company_id')
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('crowd_risk_level') is not None:
            self.crowd_risk_level = m.get('crowd_risk_level')
        if m.get('crowd_risk_score') is not None:
            self.crowd_risk_score = m.get('crowd_risk_score')
        if m.get('crowd_risk_type') is not None:
            self.crowd_risk_type = m.get('crowd_risk_type')
        if m.get('detected_time') is not None:
            self.detected_time = m.get('detected_time')
        if m.get('money_involved') is not None:
            self.money_involved = m.get('money_involved')
        if m.get('people_involved') is not None:
            self.people_involved = m.get('people_involved')
        if m.get('registered_city') is not None:
            self.registered_city = m.get('registered_city')
        if m.get('registered_county') is not None:
            self.registered_county = m.get('registered_county')
        if m.get('registered_province') is not None:
            self.registered_province = m.get('registered_province')
        return self


class StatisticResult(TeaModel):
    def __init__(
        self,
        valid_count: int = None,
        statistic_info_detail_list: List[StatisticInfoDetail] = None,
    ):
        # 有效任务总数量
        self.valid_count = valid_count
        # 各类actionDriverCode的统计结果集合
        self.statistic_info_detail_list = statistic_info_detail_list

    def validate(self):
        self.validate_required(self.valid_count, 'valid_count')
        self.validate_required(self.statistic_info_detail_list, 'statistic_info_detail_list')
        if self.statistic_info_detail_list:
            for k in self.statistic_info_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.valid_count is not None:
            result['valid_count'] = self.valid_count
        result['statistic_info_detail_list'] = []
        if self.statistic_info_detail_list is not None:
            for k in self.statistic_info_detail_list:
                result['statistic_info_detail_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('valid_count') is not None:
            self.valid_count = m.get('valid_count')
        self.statistic_info_detail_list = []
        if m.get('statistic_info_detail_list') is not None:
            for k in m.get('statistic_info_detail_list'):
                temp_model = StatisticInfoDetail()
                self.statistic_info_detail_list.append(temp_model.from_map(k))
        return self


class RiskLabelConfigInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        tag_id: str = None,
        tag_text: str = None,
        risk_dimension_type: str = None,
        risk_detail_type: str = None,
        tag_trend_chart_name: str = None,
        tag_list_headers: str = None,
        tag_list_order_column: str = None,
        tag_list_order_type: str = None,
        is_delete: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        operator_id: str = None,
    ):
        # id
        self.id = id
        # 线索ID
        self.tag_id = tag_id
        # 标签文本
        self.tag_text = tag_text
        # 风险维度
        self.risk_dimension_type = risk_dimension_type
        # 线索类型
        self.risk_detail_type = risk_detail_type
        # 趋势图表名
        self.tag_trend_chart_name = tag_trend_chart_name
        # 线索列表表头，英文逗号分隔
        self.tag_list_headers = tag_list_headers
        # 标签列表，排序字段
        self.tag_list_order_column = tag_list_order_column
        # 标签列表排序方式
        self.tag_list_order_type = tag_list_order_type
        # 标记删除
        self.is_delete = is_delete
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 操作人ID
        self.operator_id = operator_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.tag_id, 'tag_id')
        self.validate_required(self.tag_text, 'tag_text')
        self.validate_required(self.risk_dimension_type, 'risk_dimension_type')
        self.validate_required(self.risk_detail_type, 'risk_detail_type')
        self.validate_required(self.tag_trend_chart_name, 'tag_trend_chart_name')
        self.validate_required(self.tag_list_headers, 'tag_list_headers')
        self.validate_required(self.tag_list_order_column, 'tag_list_order_column')
        self.validate_required(self.tag_list_order_type, 'tag_list_order_type')
        self.validate_required(self.is_delete, 'is_delete')
        self.validate_required(self.gmt_create, 'gmt_create')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.operator_id, 'operator_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.tag_id is not None:
            result['tag_id'] = self.tag_id
        if self.tag_text is not None:
            result['tag_text'] = self.tag_text
        if self.risk_dimension_type is not None:
            result['risk_dimension_type'] = self.risk_dimension_type
        if self.risk_detail_type is not None:
            result['risk_detail_type'] = self.risk_detail_type
        if self.tag_trend_chart_name is not None:
            result['tag_trend_chart_name'] = self.tag_trend_chart_name
        if self.tag_list_headers is not None:
            result['tag_list_headers'] = self.tag_list_headers
        if self.tag_list_order_column is not None:
            result['tag_list_order_column'] = self.tag_list_order_column
        if self.tag_list_order_type is not None:
            result['tag_list_order_type'] = self.tag_list_order_type
        if self.is_delete is not None:
            result['is_delete'] = self.is_delete
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.operator_id is not None:
            result['operator_id'] = self.operator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('tag_id') is not None:
            self.tag_id = m.get('tag_id')
        if m.get('tag_text') is not None:
            self.tag_text = m.get('tag_text')
        if m.get('risk_dimension_type') is not None:
            self.risk_dimension_type = m.get('risk_dimension_type')
        if m.get('risk_detail_type') is not None:
            self.risk_detail_type = m.get('risk_detail_type')
        if m.get('tag_trend_chart_name') is not None:
            self.tag_trend_chart_name = m.get('tag_trend_chart_name')
        if m.get('tag_list_headers') is not None:
            self.tag_list_headers = m.get('tag_list_headers')
        if m.get('tag_list_order_column') is not None:
            self.tag_list_order_column = m.get('tag_list_order_column')
        if m.get('tag_list_order_type') is not None:
            self.tag_list_order_type = m.get('tag_list_order_type')
        if m.get('is_delete') is not None:
            self.is_delete = m.get('is_delete')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('operator_id') is not None:
            self.operator_id = m.get('operator_id')
        return self


class StrategyDetails(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        decision: str = None,
        scene_code: str = None,
    ):
        # 策略id
        self.id = id
        # 策略名称
        self.name = name
        # 决策结果
        self.decision = decision
        # 场景码
        self.scene_code = scene_code

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.decision, 'decision')
        self.validate_required(self.scene_code, 'scene_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.decision is not None:
            result['decision'] = self.decision
        if self.scene_code is not None:
            result['scene_code'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('scene_code') is not None:
            self.scene_code = m.get('scene_code')
        return self


class SecurityResultInfos(TeaModel):
    def __init__(
        self,
        decision: str = None,
        risk_score: int = None,
        scene_code: str = None,
    ):
        # 反欺诈风险数据服务风险建议决策
        self.decision = decision
        # 反欺诈风险数据服务风险分
        self.risk_score = risk_score
        # 反欺诈风险数据服务场景码
        self.scene_code = scene_code

    def validate(self):
        self.validate_required(self.decision, 'decision')
        self.validate_required(self.risk_score, 'risk_score')
        self.validate_required(self.scene_code, 'scene_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decision is not None:
            result['decision'] = self.decision
        if self.risk_score is not None:
            result['risk_score'] = self.risk_score
        if self.scene_code is not None:
            result['scene_code'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('risk_score') is not None:
            self.risk_score = m.get('risk_score')
        if m.get('scene_code') is not None:
            self.scene_code = m.get('scene_code')
        return self


class RtopAgeDistribution(TeaModel):
    def __init__(
        self,
        age: str = None,
        count: int = None,
    ):
        # 年龄
        self.age = age
        # 统计值
        self.count = count

    def validate(self):
        self.validate_required(self.age, 'age')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.age is not None:
            result['age'] = self.age
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('age') is not None:
            self.age = m.get('age')
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class CustomerInfo(TeaModel):
    def __init__(
        self,
        customer_key: str = None,
        properties: str = None,
    ):
        # 查询的用户凭证列表
        self.customer_key = customer_key
        # 客户属性的额外信息
        self.properties = properties

    def validate(self):
        self.validate_required(self.customer_key, 'customer_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class CompanyInfo(TeaModel):
    def __init__(
        self,
        active_addr_json: str = None,
        active_city: str = None,
        active_county: str = None,
        active_province: str = None,
        categories: str = None,
        check_date: str = None,
        del_flag: str = None,
        dt: str = None,
        former_org_names: str = None,
        head_office: str = None,
        id: int = None,
        involved_amount: int = None,
        involved_people: int = None,
        key_rela_orgs: str = None,
        legal_representative: str = None,
        mct_one_id: str = None,
        operating_addr_json: str = None,
        operating_city: str = None,
        operating_county: str = None,
        operating_place: str = None,
        operating_province: str = None,
        oprt_actv_state: str = None,
        oprt_end_date: str = None,
        oprt_scope: str = None,
        oprt_start_date: str = None,
        op_type: str = None,
        org_code: str = None,
        org_email: str = None,
        org_name: str = None,
        org_reg_cptl_rmb: str = None,
        org_state: str = None,
        org_tel: str = None,
        org_type: str = None,
        platform_name: str = None,
        platform_states: str = None,
        register_capital_currency: str = None,
        register_capital_value: str = None,
        register_city: str = None,
        register_county: str = None,
        register_date: str = None,
        register_place: str = None,
        register_province: str = None,
        registration_authority: str = None,
        reg_no: str = None,
        riskstorm_company_id: str = None,
        risk_factors: str = None,
        risk_graph_json: str = None,
        risk_message: str = None,
        risk_score: int = None,
        risk_score_trend: str = None,
        risk_score_weekly_float: int = None,
        risk_tags: str = None,
        risk_tags_id: str = None,
        risk_type: str = None,
        search_content: str = None,
        spread_number: int = None,
        spread_num_distribution: str = None,
        uc_code: str = None,
        update_date: str = None,
        platform: str = None,
    ):
        # 活跃地json
        self.active_addr_json = active_addr_json
        # 活跃市(字段停用)
        self.active_city = active_city
        # 活跃县(字段停用)
        self.active_county = active_county
        # 活跃省(字段停用)
        self.active_province = active_province
        # 类经融行业分类
        self.categories = categories
        # 核准日期
        self.check_date = check_date
        # 删除标志
        self.del_flag = del_flag
        # odps数据产生时间，业务上不关心
        self.dt = dt
        # 企业曾用名
        self.former_org_names = former_org_names
        # {"mct_one_id":"ID1","org_name":"总公司名称1"}
        self.head_office = head_office
        # 记录ID
        self.id = id
        # 影响金额
        self.involved_amount = involved_amount
        # 影响人数
        self.involved_people = involved_people
        # 重要关联企业,json格式
        self.key_rela_orgs = key_rela_orgs
        # 法人
        self.legal_representative = legal_representative
        # 企业ID
        self.mct_one_id = mct_one_id
        # 经营地json
        self.operating_addr_json = operating_addr_json
        # 经营市(字段停用)
        self.operating_city = operating_city
        # 经营县(字段停用)
        self.operating_county = operating_county
        # 经营地址(字段停用)
        self.operating_place = operating_place
        # 经营省(字段停用)
        self.operating_province = operating_province
        # 营运状态(1:营运0:不营运)
        self.oprt_actv_state = oprt_actv_state
        # 经营期限至
        self.oprt_end_date = oprt_end_date
        # 经营范围
        self.oprt_scope = oprt_scope
        # 经营期限自
        self.oprt_start_date = oprt_start_date
        # 操作类型
        # 
        self.op_type = op_type
        # 组织机构代码
        self.org_code = org_code
        # 电子邮箱
        self.org_email = org_email
        # 企业名
        self.org_name = org_name
        # 注册资本折人民币(万元)
        self.org_reg_cptl_rmb = org_reg_cptl_rmb
        # 企业状态
        self.org_state = org_state
        # 联系电话
        self.org_tel = org_tel
        # 企业类型
        self.org_type = org_type
        # 平台名
        self.platform_name = platform_name
        # 平台状态
        self.platform_states = platform_states
        # 注册资本币种
        self.register_capital_currency = register_capital_currency
        # 注册资本值
        self.register_capital_value = register_capital_value
        # 注册市
        self.register_city = register_city
        # 注册区县
        self.register_county = register_county
        # 注册时间
        self.register_date = register_date
        # 注册地址
        self.register_place = register_place
        # 注册省
        self.register_province = register_province
        # 登记机关
        self.registration_authority = registration_authority
        # 工商注册号
        self.reg_no = reg_no
        # 风报企业ID
        self.riskstorm_company_id = riskstorm_company_id
        # 风险维度
        self.risk_factors = risk_factors
        # 风险图谱可视化数据
        self.risk_graph_json = risk_graph_json
        # 风险报文
        self.risk_message = risk_message
        # 风险指数
        self.risk_score = risk_score
        # 风险指数，按日的趋势图
        self.risk_score_trend = risk_score_trend
        # 风险指数周波动
        self.risk_score_weekly_float = risk_score_weekly_float
        # 风险标签(字段停用)
        self.risk_tags = risk_tags
        # 风险标签ID
        self.risk_tags_id = risk_tags_id
        # 风险定性
        self.risk_type = risk_type
        # 搜索内容
        self.search_content = search_content
        # 传播人次
        self.spread_number = spread_number
        # 影响地区人次分布,json格式如下
        self.spread_num_distribution = spread_num_distribution
        # 社会统一信用代码
        self.uc_code = uc_code
        # 公有云数据库产生时间
        self.update_date = update_date
        # 平台json
        self.platform = platform

    def validate(self):
        self.validate_required(self.active_addr_json, 'active_addr_json')
        self.validate_required(self.active_city, 'active_city')
        self.validate_required(self.active_county, 'active_county')
        self.validate_required(self.active_province, 'active_province')
        self.validate_required(self.categories, 'categories')
        self.validate_required(self.check_date, 'check_date')
        self.validate_required(self.del_flag, 'del_flag')
        self.validate_required(self.dt, 'dt')
        self.validate_required(self.former_org_names, 'former_org_names')
        self.validate_required(self.head_office, 'head_office')
        self.validate_required(self.id, 'id')
        self.validate_required(self.involved_amount, 'involved_amount')
        self.validate_required(self.involved_people, 'involved_people')
        self.validate_required(self.key_rela_orgs, 'key_rela_orgs')
        self.validate_required(self.legal_representative, 'legal_representative')
        self.validate_required(self.mct_one_id, 'mct_one_id')
        self.validate_required(self.operating_addr_json, 'operating_addr_json')
        self.validate_required(self.operating_city, 'operating_city')
        self.validate_required(self.operating_county, 'operating_county')
        self.validate_required(self.operating_place, 'operating_place')
        self.validate_required(self.operating_province, 'operating_province')
        self.validate_required(self.oprt_actv_state, 'oprt_actv_state')
        self.validate_required(self.oprt_end_date, 'oprt_end_date')
        self.validate_required(self.oprt_scope, 'oprt_scope')
        self.validate_required(self.oprt_start_date, 'oprt_start_date')
        self.validate_required(self.op_type, 'op_type')
        self.validate_required(self.org_code, 'org_code')
        self.validate_required(self.org_email, 'org_email')
        self.validate_required(self.org_name, 'org_name')
        self.validate_required(self.org_reg_cptl_rmb, 'org_reg_cptl_rmb')
        self.validate_required(self.org_state, 'org_state')
        self.validate_required(self.org_tel, 'org_tel')
        self.validate_required(self.org_type, 'org_type')
        self.validate_required(self.platform_name, 'platform_name')
        self.validate_required(self.platform_states, 'platform_states')
        self.validate_required(self.register_capital_currency, 'register_capital_currency')
        self.validate_required(self.register_capital_value, 'register_capital_value')
        self.validate_required(self.register_city, 'register_city')
        self.validate_required(self.register_county, 'register_county')
        self.validate_required(self.register_date, 'register_date')
        self.validate_required(self.register_place, 'register_place')
        self.validate_required(self.register_province, 'register_province')
        self.validate_required(self.registration_authority, 'registration_authority')
        self.validate_required(self.reg_no, 'reg_no')
        self.validate_required(self.riskstorm_company_id, 'riskstorm_company_id')
        self.validate_required(self.risk_factors, 'risk_factors')
        self.validate_required(self.risk_graph_json, 'risk_graph_json')
        self.validate_required(self.risk_message, 'risk_message')
        self.validate_required(self.risk_score, 'risk_score')
        self.validate_required(self.risk_score_trend, 'risk_score_trend')
        self.validate_required(self.risk_score_weekly_float, 'risk_score_weekly_float')
        self.validate_required(self.risk_tags, 'risk_tags')
        self.validate_required(self.risk_tags_id, 'risk_tags_id')
        self.validate_required(self.risk_type, 'risk_type')
        self.validate_required(self.search_content, 'search_content')
        self.validate_required(self.spread_number, 'spread_number')
        self.validate_required(self.spread_num_distribution, 'spread_num_distribution')
        self.validate_required(self.uc_code, 'uc_code')
        self.validate_required(self.update_date, 'update_date')
        self.validate_required(self.platform, 'platform')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_addr_json is not None:
            result['active_addr_json'] = self.active_addr_json
        if self.active_city is not None:
            result['active_city'] = self.active_city
        if self.active_county is not None:
            result['active_county'] = self.active_county
        if self.active_province is not None:
            result['active_province'] = self.active_province
        if self.categories is not None:
            result['categories'] = self.categories
        if self.check_date is not None:
            result['check_date'] = self.check_date
        if self.del_flag is not None:
            result['del_flag'] = self.del_flag
        if self.dt is not None:
            result['dt'] = self.dt
        if self.former_org_names is not None:
            result['former_org_names'] = self.former_org_names
        if self.head_office is not None:
            result['head_office'] = self.head_office
        if self.id is not None:
            result['id'] = self.id
        if self.involved_amount is not None:
            result['involved_amount'] = self.involved_amount
        if self.involved_people is not None:
            result['involved_people'] = self.involved_people
        if self.key_rela_orgs is not None:
            result['key_rela_orgs'] = self.key_rela_orgs
        if self.legal_representative is not None:
            result['legal_representative'] = self.legal_representative
        if self.mct_one_id is not None:
            result['mct_one_id'] = self.mct_one_id
        if self.operating_addr_json is not None:
            result['operating_addr_json'] = self.operating_addr_json
        if self.operating_city is not None:
            result['operating_city'] = self.operating_city
        if self.operating_county is not None:
            result['operating_county'] = self.operating_county
        if self.operating_place is not None:
            result['operating_place'] = self.operating_place
        if self.operating_province is not None:
            result['operating_province'] = self.operating_province
        if self.oprt_actv_state is not None:
            result['oprt_actv_state'] = self.oprt_actv_state
        if self.oprt_end_date is not None:
            result['oprt_end_date'] = self.oprt_end_date
        if self.oprt_scope is not None:
            result['oprt_scope'] = self.oprt_scope
        if self.oprt_start_date is not None:
            result['oprt_start_date'] = self.oprt_start_date
        if self.op_type is not None:
            result['op_type'] = self.op_type
        if self.org_code is not None:
            result['org_code'] = self.org_code
        if self.org_email is not None:
            result['org_email'] = self.org_email
        if self.org_name is not None:
            result['org_name'] = self.org_name
        if self.org_reg_cptl_rmb is not None:
            result['org_reg_cptl_rmb'] = self.org_reg_cptl_rmb
        if self.org_state is not None:
            result['org_state'] = self.org_state
        if self.org_tel is not None:
            result['org_tel'] = self.org_tel
        if self.org_type is not None:
            result['org_type'] = self.org_type
        if self.platform_name is not None:
            result['platform_name'] = self.platform_name
        if self.platform_states is not None:
            result['platform_states'] = self.platform_states
        if self.register_capital_currency is not None:
            result['register_capital_currency'] = self.register_capital_currency
        if self.register_capital_value is not None:
            result['register_capital_value'] = self.register_capital_value
        if self.register_city is not None:
            result['register_city'] = self.register_city
        if self.register_county is not None:
            result['register_county'] = self.register_county
        if self.register_date is not None:
            result['register_date'] = self.register_date
        if self.register_place is not None:
            result['register_place'] = self.register_place
        if self.register_province is not None:
            result['register_province'] = self.register_province
        if self.registration_authority is not None:
            result['registration_authority'] = self.registration_authority
        if self.reg_no is not None:
            result['reg_no'] = self.reg_no
        if self.riskstorm_company_id is not None:
            result['riskstorm_company_id'] = self.riskstorm_company_id
        if self.risk_factors is not None:
            result['risk_factors'] = self.risk_factors
        if self.risk_graph_json is not None:
            result['risk_graph_json'] = self.risk_graph_json
        if self.risk_message is not None:
            result['risk_message'] = self.risk_message
        if self.risk_score is not None:
            result['risk_score'] = self.risk_score
        if self.risk_score_trend is not None:
            result['risk_score_trend'] = self.risk_score_trend
        if self.risk_score_weekly_float is not None:
            result['risk_score_weekly_float'] = self.risk_score_weekly_float
        if self.risk_tags is not None:
            result['risk_tags'] = self.risk_tags
        if self.risk_tags_id is not None:
            result['risk_tags_id'] = self.risk_tags_id
        if self.risk_type is not None:
            result['risk_type'] = self.risk_type
        if self.search_content is not None:
            result['search_content'] = self.search_content
        if self.spread_number is not None:
            result['spread_number'] = self.spread_number
        if self.spread_num_distribution is not None:
            result['spread_num_distribution'] = self.spread_num_distribution
        if self.uc_code is not None:
            result['uc_code'] = self.uc_code
        if self.update_date is not None:
            result['update_date'] = self.update_date
        if self.platform is not None:
            result['platform'] = self.platform
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active_addr_json') is not None:
            self.active_addr_json = m.get('active_addr_json')
        if m.get('active_city') is not None:
            self.active_city = m.get('active_city')
        if m.get('active_county') is not None:
            self.active_county = m.get('active_county')
        if m.get('active_province') is not None:
            self.active_province = m.get('active_province')
        if m.get('categories') is not None:
            self.categories = m.get('categories')
        if m.get('check_date') is not None:
            self.check_date = m.get('check_date')
        if m.get('del_flag') is not None:
            self.del_flag = m.get('del_flag')
        if m.get('dt') is not None:
            self.dt = m.get('dt')
        if m.get('former_org_names') is not None:
            self.former_org_names = m.get('former_org_names')
        if m.get('head_office') is not None:
            self.head_office = m.get('head_office')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('involved_amount') is not None:
            self.involved_amount = m.get('involved_amount')
        if m.get('involved_people') is not None:
            self.involved_people = m.get('involved_people')
        if m.get('key_rela_orgs') is not None:
            self.key_rela_orgs = m.get('key_rela_orgs')
        if m.get('legal_representative') is not None:
            self.legal_representative = m.get('legal_representative')
        if m.get('mct_one_id') is not None:
            self.mct_one_id = m.get('mct_one_id')
        if m.get('operating_addr_json') is not None:
            self.operating_addr_json = m.get('operating_addr_json')
        if m.get('operating_city') is not None:
            self.operating_city = m.get('operating_city')
        if m.get('operating_county') is not None:
            self.operating_county = m.get('operating_county')
        if m.get('operating_place') is not None:
            self.operating_place = m.get('operating_place')
        if m.get('operating_province') is not None:
            self.operating_province = m.get('operating_province')
        if m.get('oprt_actv_state') is not None:
            self.oprt_actv_state = m.get('oprt_actv_state')
        if m.get('oprt_end_date') is not None:
            self.oprt_end_date = m.get('oprt_end_date')
        if m.get('oprt_scope') is not None:
            self.oprt_scope = m.get('oprt_scope')
        if m.get('oprt_start_date') is not None:
            self.oprt_start_date = m.get('oprt_start_date')
        if m.get('op_type') is not None:
            self.op_type = m.get('op_type')
        if m.get('org_code') is not None:
            self.org_code = m.get('org_code')
        if m.get('org_email') is not None:
            self.org_email = m.get('org_email')
        if m.get('org_name') is not None:
            self.org_name = m.get('org_name')
        if m.get('org_reg_cptl_rmb') is not None:
            self.org_reg_cptl_rmb = m.get('org_reg_cptl_rmb')
        if m.get('org_state') is not None:
            self.org_state = m.get('org_state')
        if m.get('org_tel') is not None:
            self.org_tel = m.get('org_tel')
        if m.get('org_type') is not None:
            self.org_type = m.get('org_type')
        if m.get('platform_name') is not None:
            self.platform_name = m.get('platform_name')
        if m.get('platform_states') is not None:
            self.platform_states = m.get('platform_states')
        if m.get('register_capital_currency') is not None:
            self.register_capital_currency = m.get('register_capital_currency')
        if m.get('register_capital_value') is not None:
            self.register_capital_value = m.get('register_capital_value')
        if m.get('register_city') is not None:
            self.register_city = m.get('register_city')
        if m.get('register_county') is not None:
            self.register_county = m.get('register_county')
        if m.get('register_date') is not None:
            self.register_date = m.get('register_date')
        if m.get('register_place') is not None:
            self.register_place = m.get('register_place')
        if m.get('register_province') is not None:
            self.register_province = m.get('register_province')
        if m.get('registration_authority') is not None:
            self.registration_authority = m.get('registration_authority')
        if m.get('reg_no') is not None:
            self.reg_no = m.get('reg_no')
        if m.get('riskstorm_company_id') is not None:
            self.riskstorm_company_id = m.get('riskstorm_company_id')
        if m.get('risk_factors') is not None:
            self.risk_factors = m.get('risk_factors')
        if m.get('risk_graph_json') is not None:
            self.risk_graph_json = m.get('risk_graph_json')
        if m.get('risk_message') is not None:
            self.risk_message = m.get('risk_message')
        if m.get('risk_score') is not None:
            self.risk_score = m.get('risk_score')
        if m.get('risk_score_trend') is not None:
            self.risk_score_trend = m.get('risk_score_trend')
        if m.get('risk_score_weekly_float') is not None:
            self.risk_score_weekly_float = m.get('risk_score_weekly_float')
        if m.get('risk_tags') is not None:
            self.risk_tags = m.get('risk_tags')
        if m.get('risk_tags_id') is not None:
            self.risk_tags_id = m.get('risk_tags_id')
        if m.get('risk_type') is not None:
            self.risk_type = m.get('risk_type')
        if m.get('search_content') is not None:
            self.search_content = m.get('search_content')
        if m.get('spread_number') is not None:
            self.spread_number = m.get('spread_number')
        if m.get('spread_num_distribution') is not None:
            self.spread_num_distribution = m.get('spread_num_distribution')
        if m.get('uc_code') is not None:
            self.uc_code = m.get('uc_code')
        if m.get('update_date') is not None:
            self.update_date = m.get('update_date')
        if m.get('platform') is not None:
            self.platform = m.get('platform')
        return self


class EventResultSyncDetail(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        plan_id: str = None,
        msg_id: str = None,
        event_time: str = None,
        event_type: int = None,
        state: int = None,
        key_type: str = None,
        customer_key: str = None,
        ext_data: str = None,
    ):
        # 事件唯一id（单个租户全局唯一）
        self.event_id = event_id
        # 营销计划id
        self.plan_id = plan_id
        # 消息id
        self.msg_id = msg_id
        # 事件时间
        self.event_time = event_time
        # 事件类型：1为富信贴尾
        self.event_type = event_type
        # 1为成功 2为失败
        self.state = state
        # 用户key类型
        self.key_type = key_type
        # 手机号
        self.customer_key = customer_key
        # 扩展字段
        self.ext_data = ext_data

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.plan_id, 'plan_id')
        self.validate_required(self.msg_id, 'msg_id')
        self.validate_required(self.event_time, 'event_time')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.state, 'state')
        self.validate_required(self.key_type, 'key_type')
        self.validate_required(self.customer_key, 'customer_key')
        self.validate_required(self.ext_data, 'ext_data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['event_id'] = self.event_id
        if self.plan_id is not None:
            result['plan_id'] = self.plan_id
        if self.msg_id is not None:
            result['msg_id'] = self.msg_id
        if self.event_time is not None:
            result['event_time'] = self.event_time
        if self.event_type is not None:
            result['event_type'] = self.event_type
        if self.state is not None:
            result['state'] = self.state
        if self.key_type is not None:
            result['key_type'] = self.key_type
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.ext_data is not None:
            result['ext_data'] = self.ext_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('event_id') is not None:
            self.event_id = m.get('event_id')
        if m.get('plan_id') is not None:
            self.plan_id = m.get('plan_id')
        if m.get('msg_id') is not None:
            self.msg_id = m.get('msg_id')
        if m.get('event_time') is not None:
            self.event_time = m.get('event_time')
        if m.get('event_type') is not None:
            self.event_type = m.get('event_type')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('key_type') is not None:
            self.key_type = m.get('key_type')
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('ext_data') is not None:
            self.ext_data = m.get('ext_data')
        return self


class RpcommonResp(TeaModel):
    def __init__(
        self,
        success: bool = None,
        result_msg: str = None,
        response_code: str = None,
        data: str = None,
    ):
        # 调用是否成功
        self.success = success
        # 结果描述
        self.result_msg = result_msg
        # 结果码
        self.response_code = response_code
        # 具体返回值.jsonString形式
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.result_msg, 'result_msg')
        self.validate_required(self.response_code, 'response_code')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.response_code is not None:
            result['response_code'] = self.response_code
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('response_code') is not None:
            self.response_code = m.get('response_code')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CustomInfoResult(TeaModel):
    def __init__(
        self,
        credit_code: str = None,
        company_name: str = None,
        legal_name: str = None,
        id_card: str = None,
        phone_number: str = None,
        account: str = None,
        password: str = None,
    ):
        # 社会信用代码
        self.credit_code = credit_code
        # 公司名称
        self.company_name = company_name
        # 法人姓名
        self.legal_name = legal_name
        # 身份证号
        self.id_card = id_card
        # 手机号
        self.phone_number = phone_number
        # 账号
        self.account = account
        # 密码
        self.password = password

    def validate(self):
        self.validate_required(self.credit_code, 'credit_code')
        self.validate_required(self.company_name, 'company_name')
        self.validate_required(self.legal_name, 'legal_name')
        self.validate_required(self.id_card, 'id_card')
        self.validate_required(self.phone_number, 'phone_number')
        self.validate_required(self.account, 'account')
        self.validate_required(self.password, 'password')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.credit_code is not None:
            result['credit_code'] = self.credit_code
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.legal_name is not None:
            result['legal_name'] = self.legal_name
        if self.id_card is not None:
            result['id_card'] = self.id_card
        if self.phone_number is not None:
            result['phone_number'] = self.phone_number
        if self.account is not None:
            result['account'] = self.account
        if self.password is not None:
            result['password'] = self.password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('credit_code') is not None:
            self.credit_code = m.get('credit_code')
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('legal_name') is not None:
            self.legal_name = m.get('legal_name')
        if m.get('id_card') is not None:
            self.id_card = m.get('id_card')
        if m.get('phone_number') is not None:
            self.phone_number = m.get('phone_number')
        if m.get('account') is not None:
            self.account = m.get('account')
        if m.get('password') is not None:
            self.password = m.get('password')
        return self


class RtopTagImage(TeaModel):
    def __init__(
        self,
        id: int = None,
        image: str = None,
    ):
        # 标签图片表主键
        self.id = id
        # 图片
        self.image = image

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.image is not None:
            result['image'] = self.image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('image') is not None:
            self.image = m.get('image')
        return self


class ApplyInfo(TeaModel):
    def __init__(
        self,
        apply_no: str = None,
        fund_code: str = None,
        fund_name: str = None,
        rate_value: int = None,
        rate_value_day: int = None,
        days_num_year: int = None,
        total_amount: int = None,
        balance_amount: int = None,
    ):
        # 授信编号
        self.apply_no = apply_no
        # 资金方编号
        self.fund_code = fund_code
        # 资金方名称
        self.fund_name = fund_name
        # 贷款利率
        self.rate_value = rate_value
        # 贷款日利率
        self.rate_value_day = rate_value_day
        # 年天数
        self.days_num_year = days_num_year
        # 总授信额度
        self.total_amount = total_amount
        # 可用额度
        self.balance_amount = balance_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_no is not None:
            result['apply_no'] = self.apply_no
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.fund_name is not None:
            result['fund_name'] = self.fund_name
        if self.rate_value is not None:
            result['rate_value'] = self.rate_value
        if self.rate_value_day is not None:
            result['rate_value_day'] = self.rate_value_day
        if self.days_num_year is not None:
            result['days_num_year'] = self.days_num_year
        if self.total_amount is not None:
            result['total_amount'] = self.total_amount
        if self.balance_amount is not None:
            result['balance_amount'] = self.balance_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_no') is not None:
            self.apply_no = m.get('apply_no')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('fund_name') is not None:
            self.fund_name = m.get('fund_name')
        if m.get('rate_value') is not None:
            self.rate_value = m.get('rate_value')
        if m.get('rate_value_day') is not None:
            self.rate_value_day = m.get('rate_value_day')
        if m.get('days_num_year') is not None:
            self.days_num_year = m.get('days_num_year')
        if m.get('total_amount') is not None:
            self.total_amount = m.get('total_amount')
        if m.get('balance_amount') is not None:
            self.balance_amount = m.get('balance_amount')
        return self


class RtopRiskGeneNode(TeaModel):
    def __init__(
        self,
        main_company_id: str = None,
        main_company_name: str = None,
        node_id: str = None,
        node_name: str = None,
        node_cert_no: str = None,
        node_type: str = None,
        node_ext_json: str = None,
        risk_label: str = None,
        risk_mode: str = None,
    ):
        # 主企业唯一ID
        self.main_company_id = main_company_id
        # 主企业名称
        self.main_company_name = main_company_name
        # 节点唯一ID
        self.node_id = node_id
        # 节点名称
        self.node_name = node_name
        # 节点证件号码
        self.node_cert_no = node_cert_no
        # 节点类型，枚举值
        self.node_type = node_type
        # 节点扩展信息
        self.node_ext_json = node_ext_json
        # 基因模式
        self.risk_label = risk_label
        # 基因模式
        self.risk_mode = risk_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.main_company_id is not None:
            result['main_company_id'] = self.main_company_id
        if self.main_company_name is not None:
            result['main_company_name'] = self.main_company_name
        if self.node_id is not None:
            result['node_id'] = self.node_id
        if self.node_name is not None:
            result['node_name'] = self.node_name
        if self.node_cert_no is not None:
            result['node_cert_no'] = self.node_cert_no
        if self.node_type is not None:
            result['node_type'] = self.node_type
        if self.node_ext_json is not None:
            result['node_ext_json'] = self.node_ext_json
        if self.risk_label is not None:
            result['risk_label'] = self.risk_label
        if self.risk_mode is not None:
            result['risk_mode'] = self.risk_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('main_company_id') is not None:
            self.main_company_id = m.get('main_company_id')
        if m.get('main_company_name') is not None:
            self.main_company_name = m.get('main_company_name')
        if m.get('node_id') is not None:
            self.node_id = m.get('node_id')
        if m.get('node_name') is not None:
            self.node_name = m.get('node_name')
        if m.get('node_cert_no') is not None:
            self.node_cert_no = m.get('node_cert_no')
        if m.get('node_type') is not None:
            self.node_type = m.get('node_type')
        if m.get('node_ext_json') is not None:
            self.node_ext_json = m.get('node_ext_json')
        if m.get('risk_label') is not None:
            self.risk_label = m.get('risk_label')
        if m.get('risk_mode') is not None:
            self.risk_mode = m.get('risk_mode')
        return self


class RtopPopulationDistribution(TeaModel):
    def __init__(
        self,
        city: str = None,
        count: int = None,
    ):
        # 市
        self.city = city
        # 统计值
        self.count = count

    def validate(self):
        self.validate_required(self.city, 'city')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['city'] = self.city
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class DubheFileInfo(TeaModel):
    def __init__(
        self,
        file_path: str = None,
    ):
        # 文件访问路径
        self.file_path = file_path

    def validate(self):
        self.validate_required(self.file_path, 'file_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_path is not None:
            result['file_path'] = self.file_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_path') is not None:
            self.file_path = m.get('file_path')
        return self


class CustomerUmktInfosModel(TeaModel):
    def __init__(
        self,
        umkt_results: List[UmktInfoModel] = None,
        customer_key: str = None,
    ):
        # 归属用户的混合营销决策结果
        self.umkt_results = umkt_results
        # 用户凭证
        self.customer_key = customer_key

    def validate(self):
        self.validate_required(self.umkt_results, 'umkt_results')
        if self.umkt_results:
            for k in self.umkt_results:
                if k:
                    k.validate()
        self.validate_required(self.customer_key, 'customer_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['umkt_results'] = []
        if self.umkt_results is not None:
            for k in self.umkt_results:
                result['umkt_results'].append(k.to_map() if k else None)
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.umkt_results = []
        if m.get('umkt_results') is not None:
            for k in m.get('umkt_results'):
                temp_model = UmktInfoModel()
                self.umkt_results.append(temp_model.from_map(k))
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        return self


class ModelDetails(TeaModel):
    def __init__(
        self,
        scene_code: str = None,
        score: str = None,
    ):
        # 风险场景编码
        self.scene_code = scene_code
        # 该风险场景的风险分值
        # 
        self.score = score

    def validate(self):
        self.validate_required(self.scene_code, 'scene_code')
        self.validate_required(self.score, 'score')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene_code is not None:
            result['scene_code'] = self.scene_code
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene_code') is not None:
            self.scene_code = m.get('scene_code')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class GwFundRouterResult(TeaModel):
    def __init__(
        self,
        fund_code: str = None,
        abbre_fund_name: str = None,
    ):
        # 资金方代码
        self.fund_code = fund_code
        # 资金方简称
        self.abbre_fund_name = abbre_fund_name

    def validate(self):
        self.validate_required(self.fund_code, 'fund_code')
        self.validate_required(self.abbre_fund_name, 'abbre_fund_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.abbre_fund_name is not None:
            result['abbre_fund_name'] = self.abbre_fund_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('abbre_fund_name') is not None:
            self.abbre_fund_name = m.get('abbre_fund_name')
        return self


class RiskLabelFilterConfigInfo(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        is_base: int = None,
        is_delete: int = None,
        operator_id: str = None,
        place_name: str = None,
        place_type: str = None,
        tag_id: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # 是否为基本筛选标签
        self.is_base = is_base
        # 标记删除
        self.is_delete = is_delete
        # 操作人员ID
        self.operator_id = operator_id
        # 地区名
        self.place_name = place_name
        # 地区类型
        self.place_type = place_type
        # 标签ID
        self.tag_id = tag_id

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.is_base, 'is_base')
        self.validate_required(self.is_delete, 'is_delete')
        self.validate_required(self.operator_id, 'operator_id')
        self.validate_required(self.place_name, 'place_name')
        self.validate_required(self.place_type, 'place_type')
        self.validate_required(self.tag_id, 'tag_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.is_base is not None:
            result['is_base'] = self.is_base
        if self.is_delete is not None:
            result['is_delete'] = self.is_delete
        if self.operator_id is not None:
            result['operator_id'] = self.operator_id
        if self.place_name is not None:
            result['place_name'] = self.place_name
        if self.place_type is not None:
            result['place_type'] = self.place_type
        if self.tag_id is not None:
            result['tag_id'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('is_base') is not None:
            self.is_base = m.get('is_base')
        if m.get('is_delete') is not None:
            self.is_delete = m.get('is_delete')
        if m.get('operator_id') is not None:
            self.operator_id = m.get('operator_id')
        if m.get('place_name') is not None:
            self.place_name = m.get('place_name')
        if m.get('place_type') is not None:
            self.place_type = m.get('place_type')
        if m.get('tag_id') is not None:
            self.tag_id = m.get('tag_id')
        return self


class RobotCallCustomerParam(TeaModel):
    def __init__(
        self,
        customer_key: str = None,
        customer_out_info: str = None,
        properties: str = None,
    ):
        # 手机号/手机号md5
        self.customer_key = customer_key
        # 用户维度透传字段
        self.customer_out_info = customer_out_info
        # 外呼话术变量字段
        self.properties = properties

    def validate(self):
        self.validate_required(self.customer_key, 'customer_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.customer_out_info is not None:
            result['customer_out_info'] = self.customer_out_info
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('customer_out_info') is not None:
            self.customer_out_info = m.get('customer_out_info')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class JobInfo(TeaModel):
    def __init__(
        self,
        job_type: str = None,
        work_position: str = None,
        job_life: str = None,
        current_job_life: int = None,
        company_name: str = None,
        company_industry_type: str = None,
        company_tel: str = None,
        company_province: str = None,
        company_city: str = None,
        company_area: str = None,
        company_street: str = None,
        company_address: str = None,
        year_salary: int = None,
        indu_invol: str = None,
    ):
        # 职业
        self.job_type = job_type
        # 职务
        self.work_position = work_position
        # 工作年限
        self.job_life = job_life
        # 本单位工作年限
        self.current_job_life = current_job_life
        # 公司名称
        self.company_name = company_name
        # 公司行业类型
        self.company_industry_type = company_industry_type
        # 公司电话
        self.company_tel = company_tel
        # 公司省份
        self.company_province = company_province
        # 公司城市
        self.company_city = company_city
        # 公司区域
        self.company_area = company_area
        # 公司街道
        self.company_street = company_street
        # 公司详细地址
        self.company_address = company_address
        # 年收入
        self.year_salary = year_salary
        # 贷款用户所属行业类别
        self.indu_invol = indu_invol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_type is not None:
            result['job_type'] = self.job_type
        if self.work_position is not None:
            result['work_position'] = self.work_position
        if self.job_life is not None:
            result['job_life'] = self.job_life
        if self.current_job_life is not None:
            result['current_job_life'] = self.current_job_life
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.company_industry_type is not None:
            result['company_industry_type'] = self.company_industry_type
        if self.company_tel is not None:
            result['company_tel'] = self.company_tel
        if self.company_province is not None:
            result['company_province'] = self.company_province
        if self.company_city is not None:
            result['company_city'] = self.company_city
        if self.company_area is not None:
            result['company_area'] = self.company_area
        if self.company_street is not None:
            result['company_street'] = self.company_street
        if self.company_address is not None:
            result['company_address'] = self.company_address
        if self.year_salary is not None:
            result['year_salary'] = self.year_salary
        if self.indu_invol is not None:
            result['indu_invol'] = self.indu_invol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('job_type') is not None:
            self.job_type = m.get('job_type')
        if m.get('work_position') is not None:
            self.work_position = m.get('work_position')
        if m.get('job_life') is not None:
            self.job_life = m.get('job_life')
        if m.get('current_job_life') is not None:
            self.current_job_life = m.get('current_job_life')
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('company_industry_type') is not None:
            self.company_industry_type = m.get('company_industry_type')
        if m.get('company_tel') is not None:
            self.company_tel = m.get('company_tel')
        if m.get('company_province') is not None:
            self.company_province = m.get('company_province')
        if m.get('company_city') is not None:
            self.company_city = m.get('company_city')
        if m.get('company_area') is not None:
            self.company_area = m.get('company_area')
        if m.get('company_street') is not None:
            self.company_street = m.get('company_street')
        if m.get('company_address') is not None:
            self.company_address = m.get('company_address')
        if m.get('year_salary') is not None:
            self.year_salary = m.get('year_salary')
        if m.get('indu_invol') is not None:
            self.indu_invol = m.get('indu_invol')
        return self


class LiveInfo(TeaModel):
    def __init__(
        self,
        live_province: str = None,
        live_city: str = None,
        live_area: str = None,
        live_street: str = None,
        live_address: str = None,
        live_years: int = None,
    ):
        # 居住省份
        self.live_province = live_province
        # 居住城市
        self.live_city = live_city
        # 居住区域
        self.live_area = live_area
        # 居住街道
        self.live_street = live_street
        # 居住详细地址
        self.live_address = live_address
        # 居住年限
        self.live_years = live_years

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_province is not None:
            result['live_province'] = self.live_province
        if self.live_city is not None:
            result['live_city'] = self.live_city
        if self.live_area is not None:
            result['live_area'] = self.live_area
        if self.live_street is not None:
            result['live_street'] = self.live_street
        if self.live_address is not None:
            result['live_address'] = self.live_address
        if self.live_years is not None:
            result['live_years'] = self.live_years
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('live_province') is not None:
            self.live_province = m.get('live_province')
        if m.get('live_city') is not None:
            self.live_city = m.get('live_city')
        if m.get('live_area') is not None:
            self.live_area = m.get('live_area')
        if m.get('live_street') is not None:
            self.live_street = m.get('live_street')
        if m.get('live_address') is not None:
            self.live_address = m.get('live_address')
        if m.get('live_years') is not None:
            self.live_years = m.get('live_years')
        return self


class RiskStormLabelResp(TeaModel):
    def __init__(
        self,
        label_count: int = None,
        label_id: str = None,
        label_name: str = None,
    ):
        # 标签次数
        self.label_count = label_count
        # 标签id
        self.label_id = label_id
        # 标签名称
        self.label_name = label_name

    def validate(self):
        self.validate_required(self.label_count, 'label_count')
        self.validate_required(self.label_id, 'label_id')
        self.validate_required(self.label_name, 'label_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_count is not None:
            result['label_count'] = self.label_count
        if self.label_id is not None:
            result['label_id'] = self.label_id
        if self.label_name is not None:
            result['label_name'] = self.label_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('label_count') is not None:
            self.label_count = m.get('label_count')
        if m.get('label_id') is not None:
            self.label_id = m.get('label_id')
        if m.get('label_name') is not None:
            self.label_name = m.get('label_name')
        return self


class SupplementFile(TeaModel):
    def __init__(
        self,
        file_type: str = None,
        file_url: str = None,
        file_desc: str = None,
        file_suffix: str = None,
    ):
        # 材料类型：
        # 301-行驶证正本
        # 302-行驶证副本
        # 303-车辆产证（摩托车二手车）
        # 
        self.file_type = file_type
        # 材料url
        self.file_url = file_url
        # 材料名称/描述
        self.file_desc = file_desc
        # 材料后缀，如png/jpg/jpeg
        self.file_suffix = file_suffix

    def validate(self):
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.file_url, 'file_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_type is not None:
            result['file_type'] = self.file_type
        if self.file_url is not None:
            result['file_url'] = self.file_url
        if self.file_desc is not None:
            result['file_desc'] = self.file_desc
        if self.file_suffix is not None:
            result['file_suffix'] = self.file_suffix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_type') is not None:
            self.file_type = m.get('file_type')
        if m.get('file_url') is not None:
            self.file_url = m.get('file_url')
        if m.get('file_desc') is not None:
            self.file_desc = m.get('file_desc')
        if m.get('file_suffix') is not None:
            self.file_suffix = m.get('file_suffix')
        return self


class ZhimaIdentifyResp(TeaModel):
    def __init__(
        self,
        biz_no: str = None,
        certify_url: str = None,
        result_code: str = None,
        result_msg: str = None,
        sub_code: str = None,
        sub_msg: str = None,
    ):
        # 唯一ID，接口正常的话有此字段
        self.biz_no = biz_no
        # 带参数的回调地址，接口正常的话有此字段
        self.certify_url = certify_url
        # 蚂蚁调用芝麻的错误码
        self.result_code = result_code
        # 蚂蚁调用芝麻的结果描述
        self.result_msg = result_msg
        # 蚂蚁调用芝麻的错误码
        self.sub_code = sub_code
        # 蚂蚁调用芝麻信息
        self.sub_msg = sub_msg

    def validate(self):
        self.validate_required(self.result_code, 'result_code')
        self.validate_required(self.result_msg, 'result_msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        if self.certify_url is not None:
            result['certify_url'] = self.certify_url
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.sub_code is not None:
            result['sub_code'] = self.sub_code
        if self.sub_msg is not None:
            result['sub_msg'] = self.sub_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        if m.get('certify_url') is not None:
            self.certify_url = m.get('certify_url')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('sub_code') is not None:
            self.sub_code = m.get('sub_code')
        if m.get('sub_msg') is not None:
            self.sub_msg = m.get('sub_msg')
        return self


class CpaasSmsTemplate(TeaModel):
    def __init__(
        self,
        template_type: str = None,
        template_name: str = None,
        template_content: str = None,
        status: str = None,
        template_code: str = None,
        fail_reason: str = None,
        create_time: str = None,
    ):
        # 模板类型
        self.template_type = template_type
        # 模板名称
        self.template_name = template_name
        # 模板内容
        self.template_content = template_content
        # 审批状态
        self.status = status
        # 模版code
        self.template_code = template_code
        # 审核未通过原因
        self.fail_reason = fail_reason
        # 短信创建时间
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_type is not None:
            result['template_type'] = self.template_type
        if self.template_name is not None:
            result['template_name'] = self.template_name
        if self.template_content is not None:
            result['template_content'] = self.template_content
        if self.status is not None:
            result['status'] = self.status
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        if self.create_time is not None:
            result['create_time'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('template_type') is not None:
            self.template_type = m.get('template_type')
        if m.get('template_name') is not None:
            self.template_name = m.get('template_name')
        if m.get('template_content') is not None:
            self.template_content = m.get('template_content')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        return self


class VariableDetails(TeaModel):
    def __init__(
        self,
        variable_name: str = None,
        variable_value: str = None,
        variable_type: str = None,
    ):
        # 输出变量名称
        self.variable_name = variable_name
        # 输出变量值
        self.variable_value = variable_value
        # 输出变量值类型
        self.variable_type = variable_type

    def validate(self):
        self.validate_required(self.variable_name, 'variable_name')
        self.validate_required(self.variable_value, 'variable_value')
        self.validate_required(self.variable_type, 'variable_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.variable_name is not None:
            result['variable_name'] = self.variable_name
        if self.variable_value is not None:
            result['variable_value'] = self.variable_value
        if self.variable_type is not None:
            result['variable_type'] = self.variable_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('variable_name') is not None:
            self.variable_name = m.get('variable_name')
        if m.get('variable_value') is not None:
            self.variable_value = m.get('variable_value')
        if m.get('variable_type') is not None:
            self.variable_type = m.get('variable_type')
        return self


class RtopCompanyOpinionDetail(TeaModel):
    def __init__(
        self,
        doc_content: str = None,
        doc_id: str = None,
        doc_title: str = None,
        doc_url: str = None,
        emotion_score: str = None,
        entity_relevancy_score: str = None,
        hit_keywords: str = None,
        media_influence_score: str = None,
        media_name: str = None,
        media_propagation_score: str = None,
        publish_time: str = None,
        similar_docs: int = None,
    ):
        # 具体的舆情内容
        self.doc_content = doc_content
        # 舆情的id
        self.doc_id = doc_id
        # 舆情的标题
        self.doc_title = doc_title
        # 舆情的url
        self.doc_url = doc_url
        # 情感得分
        self.emotion_score = emotion_score
        # 实体相关度得分
        self.entity_relevancy_score = entity_relevancy_score
        # 命中的关键词
        self.hit_keywords = hit_keywords
        # 媒体影响力得分
        self.media_influence_score = media_influence_score
        # 来源媒体
        self.media_name = media_name
        # 媒体传播得分
        self.media_propagation_score = media_propagation_score
        # 舆情的发布时间
        self.publish_time = publish_time
        # 相似文章数
        self.similar_docs = similar_docs

    def validate(self):
        self.validate_required(self.doc_content, 'doc_content')
        self.validate_required(self.doc_id, 'doc_id')
        self.validate_required(self.doc_title, 'doc_title')
        self.validate_required(self.doc_url, 'doc_url')
        self.validate_required(self.media_name, 'media_name')
        self.validate_required(self.publish_time, 'publish_time')
        if self.publish_time is not None:
            self.validate_pattern(self.publish_time, 'publish_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_content is not None:
            result['doc_content'] = self.doc_content
        if self.doc_id is not None:
            result['doc_id'] = self.doc_id
        if self.doc_title is not None:
            result['doc_title'] = self.doc_title
        if self.doc_url is not None:
            result['doc_url'] = self.doc_url
        if self.emotion_score is not None:
            result['emotion_score'] = self.emotion_score
        if self.entity_relevancy_score is not None:
            result['entity_relevancy_score'] = self.entity_relevancy_score
        if self.hit_keywords is not None:
            result['hit_keywords'] = self.hit_keywords
        if self.media_influence_score is not None:
            result['media_influence_score'] = self.media_influence_score
        if self.media_name is not None:
            result['media_name'] = self.media_name
        if self.media_propagation_score is not None:
            result['media_propagation_score'] = self.media_propagation_score
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.similar_docs is not None:
            result['similar_docs'] = self.similar_docs
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('doc_content') is not None:
            self.doc_content = m.get('doc_content')
        if m.get('doc_id') is not None:
            self.doc_id = m.get('doc_id')
        if m.get('doc_title') is not None:
            self.doc_title = m.get('doc_title')
        if m.get('doc_url') is not None:
            self.doc_url = m.get('doc_url')
        if m.get('emotion_score') is not None:
            self.emotion_score = m.get('emotion_score')
        if m.get('entity_relevancy_score') is not None:
            self.entity_relevancy_score = m.get('entity_relevancy_score')
        if m.get('hit_keywords') is not None:
            self.hit_keywords = m.get('hit_keywords')
        if m.get('media_influence_score') is not None:
            self.media_influence_score = m.get('media_influence_score')
        if m.get('media_name') is not None:
            self.media_name = m.get('media_name')
        if m.get('media_propagation_score') is not None:
            self.media_propagation_score = m.get('media_propagation_score')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('similar_docs') is not None:
            self.similar_docs = m.get('similar_docs')
        return self


class SmsReponse(TeaModel):
    def __init__(
        self,
        biz_id: str = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
    ):
        # 发送回执ID
        self.biz_id = biz_id
        # 请求状态码; OK表示成功, 其他表示失败
        self.code = code
        # 是否调用接口成功的描述
        self.message = message
        # 请求ID
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['request_id'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('request_id') is not None:
            self.request_id = m.get('request_id')
        return self


class ReceiptInfo(TeaModel):
    def __init__(
        self,
        custom_name: str = None,
        card_no: str = None,
        mobile: str = None,
        apply_amount: int = None,
        loan_amount: int = None,
        period: int = None,
        cur_period: int = None,
        repay_type: str = None,
        repay_date: str = None,
        loan_time: str = None,
        status: str = None,
        already_corpus: int = None,
        already_accrual: int = None,
        already_date: str = None,
        workflow_status: str = None,
        receipt_no: str = None,
        loan_status: str = None,
        prod_type: str = None,
    ):
        # 客户名
        self.custom_name = custom_name
        # 证件号码
        self.card_no = card_no
        # 手机号
        self.mobile = mobile
        # 贷款金额
        self.apply_amount = apply_amount
        # 发放金额
        self.loan_amount = loan_amount
        # 期数
        self.period = period
        # 当前期数
        self.cur_period = cur_period
        # 还款方式1：等额本息，2：等额本金，3：按月付息到期还本，4：利随本清，5：自由还款
        self.repay_type = repay_type
        # 还款日
        self.repay_date = repay_date
        # 放款时间
        self.loan_time = loan_time
        # 借据状态0：未还清，1：已还清，2：已提前还清
        self.status = status
        # 已还本金
        self.already_corpus = already_corpus
        # 已还利息
        self.already_accrual = already_accrual
        # 结清日期
        self.already_date = already_date
        # 审批状态0：通过 1：拒绝 2：审批中 3：失败
        self.workflow_status = workflow_status
        # 借据编号
        self.receipt_no = receipt_no
        # 放款状态(0：放款成功 1：放款失败 2：放款异常 3：放款中）
        self.loan_status = loan_status
        # 业务类型 1：现金贷（默认）、2：分期付
        self.prod_type = prod_type

    def validate(self):
        self.validate_required(self.custom_name, 'custom_name')
        self.validate_required(self.card_no, 'card_no')
        self.validate_required(self.mobile, 'mobile')
        self.validate_required(self.apply_amount, 'apply_amount')
        self.validate_required(self.loan_amount, 'loan_amount')
        self.validate_required(self.period, 'period')
        self.validate_required(self.cur_period, 'cur_period')
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.repay_date, 'repay_date')
        self.validate_required(self.loan_time, 'loan_time')
        if self.loan_time is not None:
            self.validate_pattern(self.loan_time, 'loan_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.status, 'status')
        self.validate_required(self.already_corpus, 'already_corpus')
        self.validate_required(self.already_accrual, 'already_accrual')
        self.validate_required(self.already_date, 'already_date')
        if self.already_date is not None:
            self.validate_pattern(self.already_date, 'already_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.workflow_status, 'workflow_status')
        self.validate_required(self.receipt_no, 'receipt_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.apply_amount is not None:
            result['apply_amount'] = self.apply_amount
        if self.loan_amount is not None:
            result['loan_amount'] = self.loan_amount
        if self.period is not None:
            result['period'] = self.period
        if self.cur_period is not None:
            result['cur_period'] = self.cur_period
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.loan_time is not None:
            result['loan_time'] = self.loan_time
        if self.status is not None:
            result['status'] = self.status
        if self.already_corpus is not None:
            result['already_corpus'] = self.already_corpus
        if self.already_accrual is not None:
            result['already_accrual'] = self.already_accrual
        if self.already_date is not None:
            result['already_date'] = self.already_date
        if self.workflow_status is not None:
            result['workflow_status'] = self.workflow_status
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.loan_status is not None:
            result['loan_status'] = self.loan_status
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('apply_amount') is not None:
            self.apply_amount = m.get('apply_amount')
        if m.get('loan_amount') is not None:
            self.loan_amount = m.get('loan_amount')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('cur_period') is not None:
            self.cur_period = m.get('cur_period')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('loan_time') is not None:
            self.loan_time = m.get('loan_time')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('already_corpus') is not None:
            self.already_corpus = m.get('already_corpus')
        if m.get('already_accrual') is not None:
            self.already_accrual = m.get('already_accrual')
        if m.get('already_date') is not None:
            self.already_date = m.get('already_date')
        if m.get('workflow_status') is not None:
            self.workflow_status = m.get('workflow_status')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('loan_status') is not None:
            self.loan_status = m.get('loan_status')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        return self


class RepayRef(TeaModel):
    def __init__(
        self,
        custom_no: str = None,
        period: str = None,
        need_amount: int = None,
        need_corpus: int = None,
        need_accrual: int = None,
        need_fee: int = None,
        already_amount: int = None,
        already_corpus: int = None,
        already_overcorpus: int = None,
        already_accrual: int = None,
        already_punish: int = None,
        already_fee: int = None,
        rate: int = None,
        penalty_value: int = None,
        rest_amount: int = None,
        rest_corpus: int = None,
        rest_accrual: int = None,
        rest_punish: int = None,
        remain_corpus: int = None,
        receipt_no: str = None,
        status: str = None,
        settle_date: str = None,
        trade_date: str = None,
    ):
        # 客户编码
        self.custom_no = custom_no
        # 当前期数
        self.period = period
        # 应还总额
        self.need_amount = need_amount
        # 应还本金
        self.need_corpus = need_corpus
        # 应还利息
        self.need_accrual = need_accrual
        # 应还手续费
        self.need_fee = need_fee
        # 已还总额
        self.already_amount = already_amount
        # 已还本金
        self.already_corpus = already_corpus
        # 已还逾期本金
        self.already_overcorpus = already_overcorpus
        # 已还利息
        self.already_accrual = already_accrual
        # 已还逾期息
        self.already_punish = already_punish
        # 已还手续费
        self.already_fee = already_fee
        # 利率
        self.rate = rate
        # 罚息率
        self.penalty_value = penalty_value
        # 当期剩余总额
        self.rest_amount = rest_amount
        # 当期剩余本金
        self.rest_corpus = rest_corpus
        # 当期剩余利息
        self.rest_accrual = rest_accrual
        # 当期剩余罚息
        self.rest_punish = rest_punish
        # 期末本金
        self.remain_corpus = remain_corpus
        # 借据编号
        self.receipt_no = receipt_no
        # 还款状态1：已还清 2 未还 3 部分还款
        self.status = status
        # 应还日期
        self.settle_date = settle_date
        # 还款日期
        self.trade_date = trade_date

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.period, 'period')
        self.validate_required(self.need_amount, 'need_amount')
        self.validate_required(self.need_corpus, 'need_corpus')
        self.validate_required(self.need_accrual, 'need_accrual')
        self.validate_required(self.need_fee, 'need_fee')
        self.validate_required(self.already_amount, 'already_amount')
        self.validate_required(self.already_corpus, 'already_corpus')
        self.validate_required(self.already_overcorpus, 'already_overcorpus')
        self.validate_required(self.already_accrual, 'already_accrual')
        self.validate_required(self.already_punish, 'already_punish')
        self.validate_required(self.already_fee, 'already_fee')
        self.validate_required(self.rate, 'rate')
        self.validate_required(self.penalty_value, 'penalty_value')
        self.validate_required(self.rest_amount, 'rest_amount')
        self.validate_required(self.rest_corpus, 'rest_corpus')
        self.validate_required(self.rest_accrual, 'rest_accrual')
        self.validate_required(self.rest_punish, 'rest_punish')
        self.validate_required(self.remain_corpus, 'remain_corpus')
        self.validate_required(self.receipt_no, 'receipt_no')
        self.validate_required(self.status, 'status')
        self.validate_required(self.settle_date, 'settle_date')
        if self.settle_date is not None:
            self.validate_pattern(self.settle_date, 'settle_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.trade_date, 'trade_date')
        if self.trade_date is not None:
            self.validate_pattern(self.trade_date, 'trade_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.period is not None:
            result['period'] = self.period
        if self.need_amount is not None:
            result['need_amount'] = self.need_amount
        if self.need_corpus is not None:
            result['need_corpus'] = self.need_corpus
        if self.need_accrual is not None:
            result['need_accrual'] = self.need_accrual
        if self.need_fee is not None:
            result['need_fee'] = self.need_fee
        if self.already_amount is not None:
            result['already_amount'] = self.already_amount
        if self.already_corpus is not None:
            result['already_corpus'] = self.already_corpus
        if self.already_overcorpus is not None:
            result['already_overcorpus'] = self.already_overcorpus
        if self.already_accrual is not None:
            result['already_accrual'] = self.already_accrual
        if self.already_punish is not None:
            result['already_punish'] = self.already_punish
        if self.already_fee is not None:
            result['already_fee'] = self.already_fee
        if self.rate is not None:
            result['rate'] = self.rate
        if self.penalty_value is not None:
            result['penalty_value'] = self.penalty_value
        if self.rest_amount is not None:
            result['rest_amount'] = self.rest_amount
        if self.rest_corpus is not None:
            result['rest_corpus'] = self.rest_corpus
        if self.rest_accrual is not None:
            result['rest_accrual'] = self.rest_accrual
        if self.rest_punish is not None:
            result['rest_punish'] = self.rest_punish
        if self.remain_corpus is not None:
            result['remain_corpus'] = self.remain_corpus
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.status is not None:
            result['status'] = self.status
        if self.settle_date is not None:
            result['settle_date'] = self.settle_date
        if self.trade_date is not None:
            result['trade_date'] = self.trade_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('need_amount') is not None:
            self.need_amount = m.get('need_amount')
        if m.get('need_corpus') is not None:
            self.need_corpus = m.get('need_corpus')
        if m.get('need_accrual') is not None:
            self.need_accrual = m.get('need_accrual')
        if m.get('need_fee') is not None:
            self.need_fee = m.get('need_fee')
        if m.get('already_amount') is not None:
            self.already_amount = m.get('already_amount')
        if m.get('already_corpus') is not None:
            self.already_corpus = m.get('already_corpus')
        if m.get('already_overcorpus') is not None:
            self.already_overcorpus = m.get('already_overcorpus')
        if m.get('already_accrual') is not None:
            self.already_accrual = m.get('already_accrual')
        if m.get('already_punish') is not None:
            self.already_punish = m.get('already_punish')
        if m.get('already_fee') is not None:
            self.already_fee = m.get('already_fee')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('penalty_value') is not None:
            self.penalty_value = m.get('penalty_value')
        if m.get('rest_amount') is not None:
            self.rest_amount = m.get('rest_amount')
        if m.get('rest_corpus') is not None:
            self.rest_corpus = m.get('rest_corpus')
        if m.get('rest_accrual') is not None:
            self.rest_accrual = m.get('rest_accrual')
        if m.get('rest_punish') is not None:
            self.rest_punish = m.get('rest_punish')
        if m.get('remain_corpus') is not None:
            self.remain_corpus = m.get('remain_corpus')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('settle_date') is not None:
            self.settle_date = m.get('settle_date')
        if m.get('trade_date') is not None:
            self.trade_date = m.get('trade_date')
        return self


class CommonNotyfyResult(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        biz_response: str = None,
    ):
        # 请求id
        self.request_id = request_id
        # 业务响应Json
        self.biz_response = biz_response

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.biz_response, 'biz_response')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['request_id'] = self.request_id
        if self.biz_response is not None:
            result['biz_response'] = self.biz_response
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('request_id') is not None:
            self.request_id = m.get('request_id')
        if m.get('biz_response') is not None:
            self.biz_response = m.get('biz_response')
        return self


class RtopStarCompanyInfo(TeaModel):
    def __init__(
        self,
        categories: List[str] = None,
        operating_place: str = None,
        operating_province: str = None,
        org_name: str = None,
        risk_score: int = None,
        risk_tags: List[str] = None,
        risk_tag_details: List[RtopRiskTag] = None,
        risk_tag_ids: List[str] = None,
        uc_code: str = None,
    ):
        # 行业
        self.categories = categories
        # 经营地址
        self.operating_place = operating_place
        # 经营省份
        self.operating_province = operating_province
        # 企业名称
        self.org_name = org_name
        # 风险分数
        self.risk_score = risk_score
        # 风险标签
        self.risk_tags = risk_tags
        # 风险线索
        self.risk_tag_details = risk_tag_details
        # 风险标签Id集合
        self.risk_tag_ids = risk_tag_ids
        # 统一社会信用代码
        self.uc_code = uc_code

    def validate(self):
        if self.risk_tag_details:
            for k in self.risk_tag_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['categories'] = self.categories
        if self.operating_place is not None:
            result['operating_place'] = self.operating_place
        if self.operating_province is not None:
            result['operating_province'] = self.operating_province
        if self.org_name is not None:
            result['org_name'] = self.org_name
        if self.risk_score is not None:
            result['risk_score'] = self.risk_score
        if self.risk_tags is not None:
            result['risk_tags'] = self.risk_tags
        result['risk_tag_details'] = []
        if self.risk_tag_details is not None:
            for k in self.risk_tag_details:
                result['risk_tag_details'].append(k.to_map() if k else None)
        if self.risk_tag_ids is not None:
            result['risk_tag_ids'] = self.risk_tag_ids
        if self.uc_code is not None:
            result['uc_code'] = self.uc_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('categories') is not None:
            self.categories = m.get('categories')
        if m.get('operating_place') is not None:
            self.operating_place = m.get('operating_place')
        if m.get('operating_province') is not None:
            self.operating_province = m.get('operating_province')
        if m.get('org_name') is not None:
            self.org_name = m.get('org_name')
        if m.get('risk_score') is not None:
            self.risk_score = m.get('risk_score')
        if m.get('risk_tags') is not None:
            self.risk_tags = m.get('risk_tags')
        self.risk_tag_details = []
        if m.get('risk_tag_details') is not None:
            for k in m.get('risk_tag_details'):
                temp_model = RtopRiskTag()
                self.risk_tag_details.append(temp_model.from_map(k))
        if m.get('risk_tag_ids') is not None:
            self.risk_tag_ids = m.get('risk_tag_ids')
        if m.get('uc_code') is not None:
            self.uc_code = m.get('uc_code')
        return self


class PlatformRepayTypeInfo(TeaModel):
    def __init__(
        self,
        repay_type: str = None,
        periods: List[str] = None,
    ):
        # 1：等额本息
        # 2：等额本金
        # 3：按期付息到期还本（先息后本）
        self.repay_type = repay_type
        # {”1“，”2“}
        self.periods = periods

    def validate(self):
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.periods, 'periods')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.periods is not None:
            result['periods'] = self.periods
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('periods') is not None:
            self.periods = m.get('periods')
        return self


class RtopDateDistribution(TeaModel):
    def __init__(
        self,
        count: int = None,
        date: str = None,
    ):
        # 统计值
        self.count = count
        # 年龄
        self.date = date

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.date, 'date')
        if self.date is not None:
            self.validate_pattern(self.date, 'date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.date is not None:
            result['date'] = self.date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('date') is not None:
            self.date = m.get('date')
        return self


class PersonalInfo(TeaModel):
    def __init__(
        self,
        custom_name: str = None,
        card_no: str = None,
        id_type: str = None,
        cert_sign_date: str = None,
        cert_validate: str = None,
        cert_adr: str = None,
        mobile: str = None,
        education: str = None,
        province: str = None,
        city: str = None,
        area: str = None,
        address: str = None,
        sex: str = None,
        nation: str = None,
        marital_status: str = None,
    ):
        # 客户姓名
        self.custom_name = custom_name
        # 身份证号码(18位)
        self.card_no = card_no
        # 1-身份证
        self.id_type = id_type
        # 证件开始日期(格式：YYYY-MM-DD)
        # 
        self.cert_sign_date = cert_sign_date
        # 格式：YYYY-MM-DD，身份证有效期为长期的送: 9999-12-31
        self.cert_validate = cert_validate
        # 证件地址
        self.cert_adr = cert_adr
        # 手机号
        self.mobile = mobile
        # 学历
        self.education = education
        # 所在省份 汉字
        self.province = province
        # 所在城市 汉字
        self.city = city
        # 地区名称 汉字
        self.area = area
        # 详细地址
        self.address = address
        # 性别M-男
        # F-女
        self.sex = sex
        # 民族
        self.nation = nation
        # 婚姻状态：00-未婚，01-已婚，02-离婚，03-丧偶，99-未知
        self.marital_status = marital_status

    def validate(self):
        self.validate_required(self.custom_name, 'custom_name')
        self.validate_required(self.card_no, 'card_no')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.cert_sign_date, 'cert_sign_date')
        self.validate_required(self.cert_validate, 'cert_validate')
        self.validate_required(self.cert_adr, 'cert_adr')
        self.validate_required(self.mobile, 'mobile')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.cert_sign_date is not None:
            result['cert_sign_date'] = self.cert_sign_date
        if self.cert_validate is not None:
            result['cert_validate'] = self.cert_validate
        if self.cert_adr is not None:
            result['cert_adr'] = self.cert_adr
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.education is not None:
            result['education'] = self.education
        if self.province is not None:
            result['province'] = self.province
        if self.city is not None:
            result['city'] = self.city
        if self.area is not None:
            result['area'] = self.area
        if self.address is not None:
            result['address'] = self.address
        if self.sex is not None:
            result['sex'] = self.sex
        if self.nation is not None:
            result['nation'] = self.nation
        if self.marital_status is not None:
            result['marital_status'] = self.marital_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('cert_sign_date') is not None:
            self.cert_sign_date = m.get('cert_sign_date')
        if m.get('cert_validate') is not None:
            self.cert_validate = m.get('cert_validate')
        if m.get('cert_adr') is not None:
            self.cert_adr = m.get('cert_adr')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('education') is not None:
            self.education = m.get('education')
        if m.get('province') is not None:
            self.province = m.get('province')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('area') is not None:
            self.area = m.get('area')
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('sex') is not None:
            self.sex = m.get('sex')
        if m.get('nation') is not None:
            self.nation = m.get('nation')
        if m.get('marital_status') is not None:
            self.marital_status = m.get('marital_status')
        return self


class DfSceneInfos(TeaModel):
    def __init__(
        self,
        scene_code: str = None,
        scene_decision: str = None,
        decision_flow: DecisionFlow = None,
    ):
        # scene_code
        self.scene_code = scene_code
        # 拒绝
        self.scene_decision = scene_decision
        # decision_flow
        self.decision_flow = decision_flow

    def validate(self):
        self.validate_required(self.scene_code, 'scene_code')
        self.validate_required(self.scene_decision, 'scene_decision')
        self.validate_required(self.decision_flow, 'decision_flow')
        if self.decision_flow:
            self.decision_flow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene_code is not None:
            result['scene_code'] = self.scene_code
        if self.scene_decision is not None:
            result['scene_decision'] = self.scene_decision
        if self.decision_flow is not None:
            result['decision_flow'] = self.decision_flow.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene_code') is not None:
            self.scene_code = m.get('scene_code')
        if m.get('scene_decision') is not None:
            self.scene_decision = m.get('scene_decision')
        if m.get('decision_flow') is not None:
            temp_model = DecisionFlow()
            self.decision_flow = temp_model.from_map(m['decision_flow'])
        return self


class CustomerDetail(TeaModel):
    def __init__(
        self,
        customer_key: str = None,
        channel_params: str = None,
        ext_info: str = None,
    ):
        # 用户标识
        self.customer_key = customer_key
        # 渠道参数
        self.channel_params = channel_params
        # 用户透传字段
        self.ext_info = ext_info

    def validate(self):
        self.validate_required(self.customer_key, 'customer_key')
        self.validate_required(self.channel_params, 'channel_params')
        self.validate_required(self.ext_info, 'ext_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.channel_params is not None:
            result['channel_params'] = self.channel_params
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('channel_params') is not None:
            self.channel_params = m.get('channel_params')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        return self


class CustomerBankCardInfo(TeaModel):
    def __init__(
        self,
        bank_name: str = None,
        bank_code: str = None,
        bank_card_no: str = None,
        signed: str = None,
        acct_bank_card: str = None,
    ):
        # 银行名称
        self.bank_name = bank_name
        # 银行编码
        self.bank_code = bank_code
        # 银行卡号
        self.bank_card_no = bank_card_no
        # 是否已签约
        self.signed = signed
        # 是否为账户代扣银行卡
        self.acct_bank_card = acct_bank_card

    def validate(self):
        self.validate_required(self.bank_name, 'bank_name')
        self.validate_required(self.bank_code, 'bank_code')
        self.validate_required(self.bank_card_no, 'bank_card_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.bank_code is not None:
            result['bank_code'] = self.bank_code
        if self.bank_card_no is not None:
            result['bank_card_no'] = self.bank_card_no
        if self.signed is not None:
            result['signed'] = self.signed
        if self.acct_bank_card is not None:
            result['acct_bank_card'] = self.acct_bank_card
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('bank_code') is not None:
            self.bank_code = m.get('bank_code')
        if m.get('bank_card_no') is not None:
            self.bank_card_no = m.get('bank_card_no')
        if m.get('signed') is not None:
            self.signed = m.get('signed')
        if m.get('acct_bank_card') is not None:
            self.acct_bank_card = m.get('acct_bank_card')
        return self


class InstallmentTrial(TeaModel):
    def __init__(
        self,
        total_period: str = None,
        total_amount: int = None,
        total_fee: int = None,
        fee_rate: int = None,
        year_rate: int = None,
        term_detail_list: List[TermDetail] = None,
        optimal: bool = None,
        total_penalty: int = None,
        total_guarantee_fee: int = None,
        total_liquidated_damages: int = None,
        total_server_fee: int = None,
        discount: int = None,
        total_deduct_amount: int = None,
    ):
        # 总期数
        self.total_period = total_period
        # 分期应还总金额
        self.total_amount = total_amount
        # 总利息（分期产生的利息/手续费）
        self.total_fee = total_fee
        # 期费率，精确到小数点后四位0.1250，表示年利率为12.5%\
        self.fee_rate = fee_rate
        # 年利率，精确到小数点后四位0.1250，表示年利率为12.5%\
        self.year_rate = year_rate
        # 月供列表
        self.term_detail_list = term_detail_list
        # 是否最优标识
        self.optimal = optimal
        # 总罚息
        self.total_penalty = total_penalty
        # 总担保费
        self.total_guarantee_fee = total_guarantee_fee
        # 总违约金
        self.total_liquidated_damages = total_liquidated_damages
        # 总服务费
        self.total_server_fee = total_server_fee
        # 费率折扣，0.95：九五折；0：免息；1/null：不打折
        self.discount = discount
        # 总减免金额
        self.total_deduct_amount = total_deduct_amount

    def validate(self):
        self.validate_required(self.total_period, 'total_period')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.total_fee, 'total_fee')
        self.validate_required(self.fee_rate, 'fee_rate')
        self.validate_required(self.year_rate, 'year_rate')
        self.validate_required(self.term_detail_list, 'term_detail_list')
        if self.term_detail_list:
            for k in self.term_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_period is not None:
            result['total_period'] = self.total_period
        if self.total_amount is not None:
            result['total_amount'] = self.total_amount
        if self.total_fee is not None:
            result['total_fee'] = self.total_fee
        if self.fee_rate is not None:
            result['fee_rate'] = self.fee_rate
        if self.year_rate is not None:
            result['year_rate'] = self.year_rate
        result['term_detail_list'] = []
        if self.term_detail_list is not None:
            for k in self.term_detail_list:
                result['term_detail_list'].append(k.to_map() if k else None)
        if self.optimal is not None:
            result['optimal'] = self.optimal
        if self.total_penalty is not None:
            result['total_penalty'] = self.total_penalty
        if self.total_guarantee_fee is not None:
            result['total_guarantee_fee'] = self.total_guarantee_fee
        if self.total_liquidated_damages is not None:
            result['total_liquidated_damages'] = self.total_liquidated_damages
        if self.total_server_fee is not None:
            result['total_server_fee'] = self.total_server_fee
        if self.discount is not None:
            result['discount'] = self.discount
        if self.total_deduct_amount is not None:
            result['total_deduct_amount'] = self.total_deduct_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('total_period') is not None:
            self.total_period = m.get('total_period')
        if m.get('total_amount') is not None:
            self.total_amount = m.get('total_amount')
        if m.get('total_fee') is not None:
            self.total_fee = m.get('total_fee')
        if m.get('fee_rate') is not None:
            self.fee_rate = m.get('fee_rate')
        if m.get('year_rate') is not None:
            self.year_rate = m.get('year_rate')
        self.term_detail_list = []
        if m.get('term_detail_list') is not None:
            for k in m.get('term_detail_list'):
                temp_model = TermDetail()
                self.term_detail_list.append(temp_model.from_map(k))
        if m.get('optimal') is not None:
            self.optimal = m.get('optimal')
        if m.get('total_penalty') is not None:
            self.total_penalty = m.get('total_penalty')
        if m.get('total_guarantee_fee') is not None:
            self.total_guarantee_fee = m.get('total_guarantee_fee')
        if m.get('total_liquidated_damages') is not None:
            self.total_liquidated_damages = m.get('total_liquidated_damages')
        if m.get('total_server_fee') is not None:
            self.total_server_fee = m.get('total_server_fee')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('total_deduct_amount') is not None:
            self.total_deduct_amount = m.get('total_deduct_amount')
        return self


class UmktOfflineDecisionTaskExecBatchInfo(TeaModel):
    def __init__(
        self,
        exec_batch: str = None,
        offline_decision_task_detail_info_list: List[UmktOfflineDecisionTaskDetailInfo] = None,
    ):
        # 执行批次
        self.exec_batch = exec_batch
        # 批次下任务列表
        self.offline_decision_task_detail_info_list = offline_decision_task_detail_info_list

    def validate(self):
        self.validate_required(self.exec_batch, 'exec_batch')
        self.validate_required(self.offline_decision_task_detail_info_list, 'offline_decision_task_detail_info_list')
        if self.offline_decision_task_detail_info_list:
            for k in self.offline_decision_task_detail_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec_batch is not None:
            result['exec_batch'] = self.exec_batch
        result['offline_decision_task_detail_info_list'] = []
        if self.offline_decision_task_detail_info_list is not None:
            for k in self.offline_decision_task_detail_info_list:
                result['offline_decision_task_detail_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec_batch') is not None:
            self.exec_batch = m.get('exec_batch')
        self.offline_decision_task_detail_info_list = []
        if m.get('offline_decision_task_detail_info_list') is not None:
            for k in m.get('offline_decision_task_detail_info_list'):
                temp_model = UmktOfflineDecisionTaskDetailInfo()
                self.offline_decision_task_detail_info_list.append(temp_model.from_map(k))
        return self


class Supplier(TeaModel):
    def __init__(
        self,
        supplier_id: str = None,
        supplier_name: str = None,
    ):
        # 供应商id
        self.supplier_id = supplier_id
        # 供应商名字
        self.supplier_name = supplier_name

    def validate(self):
        self.validate_required(self.supplier_id, 'supplier_id')
        self.validate_required(self.supplier_name, 'supplier_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supplier_id is not None:
            result['supplier_id'] = self.supplier_id
        if self.supplier_name is not None:
            result['supplier_name'] = self.supplier_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('supplier_id') is not None:
            self.supplier_id = m.get('supplier_id')
        if m.get('supplier_name') is not None:
            self.supplier_name = m.get('supplier_name')
        return self


class QueryResult(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class OverdueInfoResponse(TeaModel):
    def __init__(
        self,
        over_due_flag: bool = None,
        over_days: int = None,
        valuable_over_days: int = None,
        over_period_count: int = None,
        over_principal: int = None,
        over_interest: int = None,
        over_punish: int = None,
        need_overdue_amount: int = None,
        current_need_amount: int = None,
        total_amount: int = None,
        settle_date: str = None,
        receipt_no: str = None,
        already_repay_period_count: int = None,
        loan_period_count: int = None,
        outstanding_principal: int = None,
        loan_time: str = None,
        settle_flag: bool = None,
        nearest_repay_time: str = None,
    ):
        # 逾期标识
        # true：逾期
        # false：未逾期
        self.over_due_flag = over_due_flag
        # 逾期天数
        self.over_days = over_days
        # 逾期金额在50元以上的客户的逾期天数
        self.valuable_over_days = valuable_over_days
        # 逾期期数
        self.over_period_count = over_period_count
        # 逾期本金
        self.over_principal = over_principal
        # 逾期利息
        self.over_interest = over_interest
        # 应还罚息
        self.over_punish = over_punish
        # 应还逾期总额
        self.need_overdue_amount = need_overdue_amount
        # 当前应还总额
        self.current_need_amount = current_need_amount
        # 总剩余应还
        self.total_amount = total_amount
        # 数据日期
        self.settle_date = settle_date
        # 借款唯一编号
        self.receipt_no = receipt_no
        # 已还期数
        self.already_repay_period_count = already_repay_period_count
        # 贷款期数
        self.loan_period_count = loan_period_count
        # 未还本金
        self.outstanding_principal = outstanding_principal
        # 放款日期
        self.loan_time = loan_time
        # 结清标志
        self.settle_flag = settle_flag
        # 最近一次还款日期
        self.nearest_repay_time = nearest_repay_time

    def validate(self):
        self.validate_required(self.over_due_flag, 'over_due_flag')
        self.validate_required(self.over_days, 'over_days')
        self.validate_required(self.valuable_over_days, 'valuable_over_days')
        self.validate_required(self.over_period_count, 'over_period_count')
        self.validate_required(self.over_principal, 'over_principal')
        self.validate_required(self.over_interest, 'over_interest')
        self.validate_required(self.over_punish, 'over_punish')
        self.validate_required(self.need_overdue_amount, 'need_overdue_amount')
        self.validate_required(self.current_need_amount, 'current_need_amount')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.settle_date, 'settle_date')
        if self.settle_date is not None:
            self.validate_pattern(self.settle_date, 'settle_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.receipt_no, 'receipt_no')
        self.validate_required(self.already_repay_period_count, 'already_repay_period_count')
        self.validate_required(self.loan_period_count, 'loan_period_count')
        self.validate_required(self.outstanding_principal, 'outstanding_principal')
        self.validate_required(self.loan_time, 'loan_time')
        if self.loan_time is not None:
            self.validate_pattern(self.loan_time, 'loan_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.settle_flag, 'settle_flag')
        self.validate_required(self.nearest_repay_time, 'nearest_repay_time')
        if self.nearest_repay_time is not None:
            self.validate_pattern(self.nearest_repay_time, 'nearest_repay_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.over_due_flag is not None:
            result['over_due_flag'] = self.over_due_flag
        if self.over_days is not None:
            result['over_days'] = self.over_days
        if self.valuable_over_days is not None:
            result['valuable_over_days'] = self.valuable_over_days
        if self.over_period_count is not None:
            result['over_period_count'] = self.over_period_count
        if self.over_principal is not None:
            result['over_principal'] = self.over_principal
        if self.over_interest is not None:
            result['over_interest'] = self.over_interest
        if self.over_punish is not None:
            result['over_punish'] = self.over_punish
        if self.need_overdue_amount is not None:
            result['need_overdue_amount'] = self.need_overdue_amount
        if self.current_need_amount is not None:
            result['current_need_amount'] = self.current_need_amount
        if self.total_amount is not None:
            result['total_amount'] = self.total_amount
        if self.settle_date is not None:
            result['settle_date'] = self.settle_date
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.already_repay_period_count is not None:
            result['already_repay_period_count'] = self.already_repay_period_count
        if self.loan_period_count is not None:
            result['loan_period_count'] = self.loan_period_count
        if self.outstanding_principal is not None:
            result['outstanding_principal'] = self.outstanding_principal
        if self.loan_time is not None:
            result['loan_time'] = self.loan_time
        if self.settle_flag is not None:
            result['settle_flag'] = self.settle_flag
        if self.nearest_repay_time is not None:
            result['nearest_repay_time'] = self.nearest_repay_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('over_due_flag') is not None:
            self.over_due_flag = m.get('over_due_flag')
        if m.get('over_days') is not None:
            self.over_days = m.get('over_days')
        if m.get('valuable_over_days') is not None:
            self.valuable_over_days = m.get('valuable_over_days')
        if m.get('over_period_count') is not None:
            self.over_period_count = m.get('over_period_count')
        if m.get('over_principal') is not None:
            self.over_principal = m.get('over_principal')
        if m.get('over_interest') is not None:
            self.over_interest = m.get('over_interest')
        if m.get('over_punish') is not None:
            self.over_punish = m.get('over_punish')
        if m.get('need_overdue_amount') is not None:
            self.need_overdue_amount = m.get('need_overdue_amount')
        if m.get('current_need_amount') is not None:
            self.current_need_amount = m.get('current_need_amount')
        if m.get('total_amount') is not None:
            self.total_amount = m.get('total_amount')
        if m.get('settle_date') is not None:
            self.settle_date = m.get('settle_date')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('already_repay_period_count') is not None:
            self.already_repay_period_count = m.get('already_repay_period_count')
        if m.get('loan_period_count') is not None:
            self.loan_period_count = m.get('loan_period_count')
        if m.get('outstanding_principal') is not None:
            self.outstanding_principal = m.get('outstanding_principal')
        if m.get('loan_time') is not None:
            self.loan_time = m.get('loan_time')
        if m.get('settle_flag') is not None:
            self.settle_flag = m.get('settle_flag')
        if m.get('nearest_repay_time') is not None:
            self.nearest_repay_time = m.get('nearest_repay_time')
        return self


class RdaasTaxDecsionServiceIndicator(TeaModel):
    def __init__(
        self,
        id: str = None,
        service_id: str = None,
        property_name: str = None,
        property_value: str = None,
        decision_tenant: str = None,
        create_time: str = None,
    ):
        # 决策指标id
        self.id = id
        # 决策服务id
        self.service_id = service_id
        # 属性名
        self.property_name = property_name
        # 属性值或指标值
        self.property_value = property_value
        # 决策租户
        self.decision_tenant = decision_tenant
        # 创建时间，格式:yyyy-MM-dd HH:mm:ss
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.property_name, 'property_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.service_id is not None:
            result['service_id'] = self.service_id
        if self.property_name is not None:
            result['property_name'] = self.property_name
        if self.property_value is not None:
            result['property_value'] = self.property_value
        if self.decision_tenant is not None:
            result['decision_tenant'] = self.decision_tenant
        if self.create_time is not None:
            result['create_time'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('service_id') is not None:
            self.service_id = m.get('service_id')
        if m.get('property_name') is not None:
            self.property_name = m.get('property_name')
        if m.get('property_value') is not None:
            self.property_value = m.get('property_value')
        if m.get('decision_tenant') is not None:
            self.decision_tenant = m.get('decision_tenant')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        return self


class GetAgreementUrlResponseData(TeaModel):
    def __init__(
        self,
        title: str = None,
        agreement_url: str = None,
        file_base_64: str = None,
        pic_file_base_64list: List[str] = None,
        pic_oss_path_list: List[str] = None,
        organization_name: str = None,
        file_type: str = None,
        file_type_name: str = None,
    ):
        # 协议标题
        self.title = title
        # 协议地址
        self.agreement_url = agreement_url
        # 协议文件Base64
        self.file_base_64 = file_base_64
        # 协议图片文件base64集合
        self.pic_file_base_64list = pic_file_base_64list
        # 图片文件oss集合
        self.pic_oss_path_list = pic_oss_path_list
        # 机构名称
        self.organization_name = organization_name
        # 协议类型-code
        self.file_type = file_type
        # 协议类型-名称
        self.file_type_name = file_type_name

    def validate(self):
        self.validate_required(self.title, 'title')
        self.validate_required(self.organization_name, 'organization_name')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.file_type_name, 'file_type_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.title is not None:
            result['title'] = self.title
        if self.agreement_url is not None:
            result['agreement_url'] = self.agreement_url
        if self.file_base_64 is not None:
            result['file_base64'] = self.file_base_64
        if self.pic_file_base_64list is not None:
            result['pic_file_base64_list'] = self.pic_file_base_64list
        if self.pic_oss_path_list is not None:
            result['pic_oss_path_list'] = self.pic_oss_path_list
        if self.organization_name is not None:
            result['organization_name'] = self.organization_name
        if self.file_type is not None:
            result['file_type'] = self.file_type
        if self.file_type_name is not None:
            result['file_type_name'] = self.file_type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('agreement_url') is not None:
            self.agreement_url = m.get('agreement_url')
        if m.get('file_base64') is not None:
            self.file_base_64 = m.get('file_base64')
        if m.get('pic_file_base64_list') is not None:
            self.pic_file_base_64list = m.get('pic_file_base64_list')
        if m.get('pic_oss_path_list') is not None:
            self.pic_oss_path_list = m.get('pic_oss_path_list')
        if m.get('organization_name') is not None:
            self.organization_name = m.get('organization_name')
        if m.get('file_type') is not None:
            self.file_type = m.get('file_type')
        if m.get('file_type_name') is not None:
            self.file_type_name = m.get('file_type_name')
        return self


class DefinInnerChannelNotifyResult(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        biz_response: str = None,
    ):
        # 请求编号
        self.request_id = request_id
        # 业务响应Json
        self.biz_response = biz_response

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.biz_response, 'biz_response')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['request_id'] = self.request_id
        if self.biz_response is not None:
            result['biz_response'] = self.biz_response
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('request_id') is not None:
            self.request_id = m.get('request_id')
        if m.get('biz_response') is not None:
            self.biz_response = m.get('biz_response')
        return self


class StoreInfo(TeaModel):
    def __init__(
        self,
        store_brand: str = None,
        store_id: str = None,
        store_name: str = None,
        usci: str = None,
        province: str = None,
        city: str = None,
        district: str = None,
        address: str = None,
        store_start_date: str = None,
        store_end_date: str = None,
        store_type: str = None,
        legal_person_name: str = None,
        legal_person_id_card: str = None,
        legal_person_mobile: str = None,
        effective_date: str = None,
        bank_name: str = None,
        branch_name: str = None,
        cnaps_code: str = None,
        account_name: str = None,
        account_number: str = None,
        bank_province: str = None,
        bank_city: str = None,
        payee_bank_card: str = None,
        payee_bank_name: str = None,
        login_tenant: str = None,
        login_date: str = None,
    ):
        # 品牌
        self.store_brand = store_brand
        # 门店ID
        self.store_id = store_id
        # 门店名称
        self.store_name = store_name
        # 统一社会信用代码
        self.usci = usci
        # 门店-省，浙江省
        self.province = province
        # 门店-市，杭州市
        self.city = city
        # 门店-区，滨江区
        self.district = district
        # 门店-详细地址，
        # 望江路万达广场一层001号
        self.address = address
        # 营业执照-开始时间，yyyy-MM-dd
        self.store_start_date = store_start_date
        # 营业执照-结束时间，yyyy-MM-dd，长期上送：9999-12-31
        self.store_end_date = store_end_date
        # 门店类型，
        # 个体、企业、其他
        self.store_type = store_type
        # 法人-姓名
        self.legal_person_name = legal_person_name
        # 法人-身份证号
        self.legal_person_id_card = legal_person_id_card
        # 法人-手机号
        self.legal_person_mobile = legal_person_mobile
        # 法人-身份证有效期，，身份证反面格式：如yyyy.MM.dd-长期
        self.effective_date = effective_date
        # 对公-开户行名称
        self.bank_name = bank_name
        # 对公-支行名称
        self.branch_name = branch_name
        # 对公-联行号
        self.cnaps_code = cnaps_code
        # 对公-银行账户名称
        self.account_name = account_name
        # 对公-银行账户号
        self.account_number = account_number
        # 对公-开户行所在省，浙江
        self.bank_province = bank_province
        # 对公-开户行所在市，杭州
        self.bank_city = bank_city
        # 对私-银行卡号
        self.payee_bank_card = payee_bank_card
        # 对私-银行名称
        self.payee_bank_name = payee_bank_name
        # 蚂蚁数科入驻账号
        self.login_tenant = login_tenant
        # 入驻时间
        self.login_date = login_date

    def validate(self):
        self.validate_required(self.store_brand, 'store_brand')
        self.validate_required(self.store_id, 'store_id')
        self.validate_required(self.store_name, 'store_name')
        self.validate_required(self.usci, 'usci')
        self.validate_required(self.province, 'province')
        self.validate_required(self.city, 'city')
        self.validate_required(self.district, 'district')
        self.validate_required(self.address, 'address')
        self.validate_required(self.store_start_date, 'store_start_date')
        self.validate_required(self.store_end_date, 'store_end_date')
        self.validate_required(self.store_type, 'store_type')
        self.validate_required(self.legal_person_name, 'legal_person_name')
        self.validate_required(self.legal_person_id_card, 'legal_person_id_card')
        self.validate_required(self.legal_person_mobile, 'legal_person_mobile')
        self.validate_required(self.effective_date, 'effective_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.store_brand is not None:
            result['store_brand'] = self.store_brand
        if self.store_id is not None:
            result['store_id'] = self.store_id
        if self.store_name is not None:
            result['store_name'] = self.store_name
        if self.usci is not None:
            result['usci'] = self.usci
        if self.province is not None:
            result['province'] = self.province
        if self.city is not None:
            result['city'] = self.city
        if self.district is not None:
            result['district'] = self.district
        if self.address is not None:
            result['address'] = self.address
        if self.store_start_date is not None:
            result['store_start_date'] = self.store_start_date
        if self.store_end_date is not None:
            result['store_end_date'] = self.store_end_date
        if self.store_type is not None:
            result['store_type'] = self.store_type
        if self.legal_person_name is not None:
            result['legal_person_name'] = self.legal_person_name
        if self.legal_person_id_card is not None:
            result['legal_person_id_card'] = self.legal_person_id_card
        if self.legal_person_mobile is not None:
            result['legal_person_mobile'] = self.legal_person_mobile
        if self.effective_date is not None:
            result['effective_date'] = self.effective_date
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.branch_name is not None:
            result['branch_name'] = self.branch_name
        if self.cnaps_code is not None:
            result['cnaps_code'] = self.cnaps_code
        if self.account_name is not None:
            result['account_name'] = self.account_name
        if self.account_number is not None:
            result['account_number'] = self.account_number
        if self.bank_province is not None:
            result['bank_province'] = self.bank_province
        if self.bank_city is not None:
            result['bank_city'] = self.bank_city
        if self.payee_bank_card is not None:
            result['payee_bank_card'] = self.payee_bank_card
        if self.payee_bank_name is not None:
            result['payee_bank_name'] = self.payee_bank_name
        if self.login_tenant is not None:
            result['login_tenant'] = self.login_tenant
        if self.login_date is not None:
            result['login_date'] = self.login_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('store_brand') is not None:
            self.store_brand = m.get('store_brand')
        if m.get('store_id') is not None:
            self.store_id = m.get('store_id')
        if m.get('store_name') is not None:
            self.store_name = m.get('store_name')
        if m.get('usci') is not None:
            self.usci = m.get('usci')
        if m.get('province') is not None:
            self.province = m.get('province')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('district') is not None:
            self.district = m.get('district')
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('store_start_date') is not None:
            self.store_start_date = m.get('store_start_date')
        if m.get('store_end_date') is not None:
            self.store_end_date = m.get('store_end_date')
        if m.get('store_type') is not None:
            self.store_type = m.get('store_type')
        if m.get('legal_person_name') is not None:
            self.legal_person_name = m.get('legal_person_name')
        if m.get('legal_person_id_card') is not None:
            self.legal_person_id_card = m.get('legal_person_id_card')
        if m.get('legal_person_mobile') is not None:
            self.legal_person_mobile = m.get('legal_person_mobile')
        if m.get('effective_date') is not None:
            self.effective_date = m.get('effective_date')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('branch_name') is not None:
            self.branch_name = m.get('branch_name')
        if m.get('cnaps_code') is not None:
            self.cnaps_code = m.get('cnaps_code')
        if m.get('account_name') is not None:
            self.account_name = m.get('account_name')
        if m.get('account_number') is not None:
            self.account_number = m.get('account_number')
        if m.get('bank_province') is not None:
            self.bank_province = m.get('bank_province')
        if m.get('bank_city') is not None:
            self.bank_city = m.get('bank_city')
        if m.get('payee_bank_card') is not None:
            self.payee_bank_card = m.get('payee_bank_card')
        if m.get('payee_bank_name') is not None:
            self.payee_bank_name = m.get('payee_bank_name')
        if m.get('login_tenant') is not None:
            self.login_tenant = m.get('login_tenant')
        if m.get('login_date') is not None:
            self.login_date = m.get('login_date')
        return self


class BatchQueryResult(TeaModel):
    def __init__(
        self,
        query_key: str = None,
        decision: str = None,
        output_info: BatchQueryOutputModelInfo = None,
    ):
        # 查询主体
        self.query_key = query_key
        # 单用户决策结果
        self.decision = decision
        # 输出变量信息
        self.output_info = output_info

    def validate(self):
        self.validate_required(self.query_key, 'query_key')
        self.validate_required(self.decision, 'decision')
        self.validate_required(self.output_info, 'output_info')
        if self.output_info:
            self.output_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.query_key is not None:
            result['query_key'] = self.query_key
        if self.decision is not None:
            result['decision'] = self.decision
        if self.output_info is not None:
            result['output_info'] = self.output_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('query_key') is not None:
            self.query_key = m.get('query_key')
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('output_info') is not None:
            temp_model = BatchQueryOutputModelInfo()
            self.output_info = temp_model.from_map(m['output_info'])
        return self


class CommonRobotCallDetail(TeaModel):
    def __init__(
        self,
        ext_info: str = None,
        result_code: str = None,
        customer_key: str = None,
        current_call_times: int = None,
        key_template: str = None,
        batch_id: str = None,
        call_type: int = None,
        tag: str = None,
        call_id: str = None,
        task_id: int = None,
        template_id: int = None,
        status_code: int = None,
        status_description: str = None,
        transfer_status_code: int = None,
        transfer_status: str = None,
        agent_id: int = None,
        agent_tag: str = None,
        agent_extension: str = None,
        import_time: str = None,
        call_begin_time: str = None,
        ring_time: int = None,
        answer_time: str = None,
        speaking_time: str = None,
        speaking_duration: int = None,
        hangup_time: str = None,
        speaking_turns: int = None,
        agent_speaking_time: str = None,
        agent_speaking_duration: int = None,
        intent_tag: str = None,
        intent_description: str = None,
        individual_tag: str = None,
        keywords: str = None,
        hungup_type: int = None,
        sms: str = None,
        chat_record: str = None,
        chats: str = None,
        add_wx: int = None,
        add_wx_status: str = None,
        answer_recall: int = None,
        properties: str = None,
        biz_properties: str = None,
        intercept_reason: str = None,
    ):
        # 客户请求时的透传字段
        self.ext_info = ext_info
        # 成功触达：OK；未触达：AI_ROBOT_CALL_REQUEST_NOT_EXIST
        self.result_code = result_code
        # 外呼号码
        self.customer_key = customer_key
        # 呼叫次数
        self.current_call_times = current_call_times
        # 号码模版
        self.key_template = key_template
        # 导入号码时返回的批次号
        self.batch_id = batch_id
        # 2001:批量-预测外呼，2002:批量-AI外呼-不转人工，2003:批量-AI外呼-接通转人工，2004: 批量-AI外呼-智能转人工,2005:批量-语音通知
        self.call_type = call_type
        # 用户自定义标签
        self.tag = tag
        # 外呼id
        self.call_id = call_id
        # 外呼任务编号
        self.task_id = task_id
        # AI话术ID
        self.template_id = template_id
        # 外呼状态编码
        self.status_code = status_code
        # 外呼状态描述
        self.status_description = status_description
        # 转人工状态编码
        self.transfer_status_code = transfer_status_code
        # 转人工状态
        self.transfer_status = transfer_status
        # 分配坐席ID
        self.agent_id = agent_id
        # 坐席在贵司业务系统唯一标识，用于查询对应agentId；可以为空。
        self.agent_tag = agent_tag
        # 坐席分机号
        self.agent_extension = agent_extension
        # 导入时间
        self.import_time = import_time
        # 开始通话时间
        self.call_begin_time = call_begin_time
        # 振铃时长，单位ms
        self.ring_time = ring_time
        # 接通时间
        self.answer_time = answer_time
        # 通话时长，单位：大于1分钟，显示分钟秒，小于1分钟，显示秒
        self.speaking_time = speaking_time
        # 通话时长，单位：秒
        self.speaking_duration = speaking_duration
        # 挂断时间
        self.hangup_time = hangup_time
        # 对话轮次
        self.speaking_turns = speaking_turns
        # 人工通话时长，单位：大于1分钟，显示分钟秒，小于1分钟，显示秒
        self.agent_speaking_time = agent_speaking_time
        # 人工通话时长，单位：秒
        self.agent_speaking_duration = agent_speaking_duration
        # 意向标签
        self.intent_tag = intent_tag
        # 意向说明
        self.intent_description = intent_description
        # 个性标签
        self.individual_tag = individual_tag
        # 回复关键词
        self.keywords = keywords
        # 挂机方式，AI挂机1，坐席挂机2，客户挂机3
        self.hungup_type = hungup_type
        # 挂机短信，可选值：1、2
        # 1:发送，2:不发送
        self.sms = sms
        # 对话录音，URL，可以为空
        self.chat_record = chat_record
        # 聊天记录，可以为空
        self.chats = chats
        # 可选值：0、1
        # 0:不添加，1:添加
        self.add_wx = add_wx
        # 加微进度，可选值：已申请、加微成功
        self.add_wx_status = add_wx_status
        # 是否接通重呼，可选值：0、1
        # 0正常外呼，1接通重呼
        self.answer_recall = answer_recall
        # 导入号码时的参数值
        self.properties = properties
        # 导入号码时的业务参数值，原样返回
        self.biz_properties = biz_properties
        # 拦截原因：当状态为已拦截时，可选值：黑名单拦截，灰名单拦截，异常号码拦截
        self.intercept_reason = intercept_reason

    def validate(self):
        self.validate_required(self.ext_info, 'ext_info')
        self.validate_required(self.result_code, 'result_code')
        self.validate_required(self.customer_key, 'customer_key')
        self.validate_required(self.current_call_times, 'current_call_times')
        self.validate_required(self.key_template, 'key_template')
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.call_type, 'call_type')
        self.validate_required(self.call_id, 'call_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.status_description, 'status_description')
        self.validate_required(self.transfer_status_code, 'transfer_status_code')
        self.validate_required(self.transfer_status, 'transfer_status')
        self.validate_required(self.import_time, 'import_time')
        self.validate_required(self.call_begin_time, 'call_begin_time')
        self.validate_required(self.ring_time, 'ring_time')
        self.validate_required(self.speaking_time, 'speaking_time')
        self.validate_required(self.speaking_duration, 'speaking_duration')
        self.validate_required(self.hangup_time, 'hangup_time')
        self.validate_required(self.speaking_turns, 'speaking_turns')
        self.validate_required(self.agent_speaking_time, 'agent_speaking_time')
        self.validate_required(self.agent_speaking_duration, 'agent_speaking_duration')
        self.validate_required(self.intent_tag, 'intent_tag')
        self.validate_required(self.intent_description, 'intent_description')
        self.validate_required(self.hungup_type, 'hungup_type')
        self.validate_required(self.sms, 'sms')
        self.validate_required(self.answer_recall, 'answer_recall')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.current_call_times is not None:
            result['current_call_times'] = self.current_call_times
        if self.key_template is not None:
            result['key_template'] = self.key_template
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.call_type is not None:
            result['call_type'] = self.call_type
        if self.tag is not None:
            result['tag'] = self.tag
        if self.call_id is not None:
            result['call_id'] = self.call_id
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.status_code is not None:
            result['status_code'] = self.status_code
        if self.status_description is not None:
            result['status_description'] = self.status_description
        if self.transfer_status_code is not None:
            result['transfer_status_code'] = self.transfer_status_code
        if self.transfer_status is not None:
            result['transfer_status'] = self.transfer_status
        if self.agent_id is not None:
            result['agent_id'] = self.agent_id
        if self.agent_tag is not None:
            result['agent_tag'] = self.agent_tag
        if self.agent_extension is not None:
            result['agent_extension'] = self.agent_extension
        if self.import_time is not None:
            result['import_time'] = self.import_time
        if self.call_begin_time is not None:
            result['call_begin_time'] = self.call_begin_time
        if self.ring_time is not None:
            result['ring_time'] = self.ring_time
        if self.answer_time is not None:
            result['answer_time'] = self.answer_time
        if self.speaking_time is not None:
            result['speaking_time'] = self.speaking_time
        if self.speaking_duration is not None:
            result['speaking_duration'] = self.speaking_duration
        if self.hangup_time is not None:
            result['hangup_time'] = self.hangup_time
        if self.speaking_turns is not None:
            result['speaking_turns'] = self.speaking_turns
        if self.agent_speaking_time is not None:
            result['agent_speaking_time'] = self.agent_speaking_time
        if self.agent_speaking_duration is not None:
            result['agent_speaking_duration'] = self.agent_speaking_duration
        if self.intent_tag is not None:
            result['intent_tag'] = self.intent_tag
        if self.intent_description is not None:
            result['intent_description'] = self.intent_description
        if self.individual_tag is not None:
            result['individual_tag'] = self.individual_tag
        if self.keywords is not None:
            result['keywords'] = self.keywords
        if self.hungup_type is not None:
            result['hungup_type'] = self.hungup_type
        if self.sms is not None:
            result['sms'] = self.sms
        if self.chat_record is not None:
            result['chat_record'] = self.chat_record
        if self.chats is not None:
            result['chats'] = self.chats
        if self.add_wx is not None:
            result['add_wx'] = self.add_wx
        if self.add_wx_status is not None:
            result['add_wx_status'] = self.add_wx_status
        if self.answer_recall is not None:
            result['answer_recall'] = self.answer_recall
        if self.properties is not None:
            result['properties'] = self.properties
        if self.biz_properties is not None:
            result['biz_properties'] = self.biz_properties
        if self.intercept_reason is not None:
            result['intercept_reason'] = self.intercept_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('current_call_times') is not None:
            self.current_call_times = m.get('current_call_times')
        if m.get('key_template') is not None:
            self.key_template = m.get('key_template')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('call_type') is not None:
            self.call_type = m.get('call_type')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('call_id') is not None:
            self.call_id = m.get('call_id')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('status_code') is not None:
            self.status_code = m.get('status_code')
        if m.get('status_description') is not None:
            self.status_description = m.get('status_description')
        if m.get('transfer_status_code') is not None:
            self.transfer_status_code = m.get('transfer_status_code')
        if m.get('transfer_status') is not None:
            self.transfer_status = m.get('transfer_status')
        if m.get('agent_id') is not None:
            self.agent_id = m.get('agent_id')
        if m.get('agent_tag') is not None:
            self.agent_tag = m.get('agent_tag')
        if m.get('agent_extension') is not None:
            self.agent_extension = m.get('agent_extension')
        if m.get('import_time') is not None:
            self.import_time = m.get('import_time')
        if m.get('call_begin_time') is not None:
            self.call_begin_time = m.get('call_begin_time')
        if m.get('ring_time') is not None:
            self.ring_time = m.get('ring_time')
        if m.get('answer_time') is not None:
            self.answer_time = m.get('answer_time')
        if m.get('speaking_time') is not None:
            self.speaking_time = m.get('speaking_time')
        if m.get('speaking_duration') is not None:
            self.speaking_duration = m.get('speaking_duration')
        if m.get('hangup_time') is not None:
            self.hangup_time = m.get('hangup_time')
        if m.get('speaking_turns') is not None:
            self.speaking_turns = m.get('speaking_turns')
        if m.get('agent_speaking_time') is not None:
            self.agent_speaking_time = m.get('agent_speaking_time')
        if m.get('agent_speaking_duration') is not None:
            self.agent_speaking_duration = m.get('agent_speaking_duration')
        if m.get('intent_tag') is not None:
            self.intent_tag = m.get('intent_tag')
        if m.get('intent_description') is not None:
            self.intent_description = m.get('intent_description')
        if m.get('individual_tag') is not None:
            self.individual_tag = m.get('individual_tag')
        if m.get('keywords') is not None:
            self.keywords = m.get('keywords')
        if m.get('hungup_type') is not None:
            self.hungup_type = m.get('hungup_type')
        if m.get('sms') is not None:
            self.sms = m.get('sms')
        if m.get('chat_record') is not None:
            self.chat_record = m.get('chat_record')
        if m.get('chats') is not None:
            self.chats = m.get('chats')
        if m.get('add_wx') is not None:
            self.add_wx = m.get('add_wx')
        if m.get('add_wx_status') is not None:
            self.add_wx_status = m.get('add_wx_status')
        if m.get('answer_recall') is not None:
            self.answer_recall = m.get('answer_recall')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        if m.get('biz_properties') is not None:
            self.biz_properties = m.get('biz_properties')
        if m.get('intercept_reason') is not None:
            self.intercept_reason = m.get('intercept_reason')
        return self


class PayMethodLockResult(TeaModel):
    def __init__(
        self,
        sign_status: str = None,
        account_id: str = None,
        login_id: str = None,
        pay_channel: str = None,
        account_name: str = None,
    ):
        # 签约结果
        self.sign_status = sign_status
        # 账号
        self.account_id = account_id
        # 登录号
        self.login_id = login_id
        # 支付公司
        self.pay_channel = pay_channel
        # 绑定账号名称
        self.account_name = account_name

    def validate(self):
        self.validate_required(self.sign_status, 'sign_status')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.login_id, 'login_id')
        self.validate_required(self.pay_channel, 'pay_channel')
        self.validate_required(self.account_name, 'account_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sign_status is not None:
            result['sign_status'] = self.sign_status
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.login_id is not None:
            result['login_id'] = self.login_id
        if self.pay_channel is not None:
            result['pay_channel'] = self.pay_channel
        if self.account_name is not None:
            result['account_name'] = self.account_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sign_status') is not None:
            self.sign_status = m.get('sign_status')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('login_id') is not None:
            self.login_id = m.get('login_id')
        if m.get('pay_channel') is not None:
            self.pay_channel = m.get('pay_channel')
        if m.get('account_name') is not None:
            self.account_name = m.get('account_name')
        return self


class Contract(TeaModel):
    def __init__(
        self,
        relation_no: str = None,
        contract_no: str = None,
        contract_name: str = None,
        contract_type: str = None,
        custom_no: str = None,
        save_path: str = None,
        contract_amount: int = None,
        disburse_contract_no: str = None,
        credit_contract_no: str = None,
    ):
        # 关联编号
        self.relation_no = relation_no
        # 合同编号
        self.contract_no = contract_no
        # 合同名称
        self.contract_name = contract_name
        # 合同类型
        self.contract_type = contract_type
        # 客户编号
        self.custom_no = custom_no
        # 合同存放目录
        self.save_path = save_path
        # 合同金额
        self.contract_amount = contract_amount
        # 用信合同编号
        self.disburse_contract_no = disburse_contract_no
        # 授信合同编号
        self.credit_contract_no = credit_contract_no

    def validate(self):
        self.validate_required(self.relation_no, 'relation_no')
        self.validate_required(self.contract_no, 'contract_no')
        self.validate_required(self.contract_name, 'contract_name')
        self.validate_required(self.contract_type, 'contract_type')
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.save_path, 'save_path')
        self.validate_required(self.contract_amount, 'contract_amount')
        self.validate_required(self.disburse_contract_no, 'disburse_contract_no')
        self.validate_required(self.credit_contract_no, 'credit_contract_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relation_no is not None:
            result['relation_no'] = self.relation_no
        if self.contract_no is not None:
            result['contract_no'] = self.contract_no
        if self.contract_name is not None:
            result['contract_name'] = self.contract_name
        if self.contract_type is not None:
            result['contract_type'] = self.contract_type
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.save_path is not None:
            result['save_path'] = self.save_path
        if self.contract_amount is not None:
            result['contract_amount'] = self.contract_amount
        if self.disburse_contract_no is not None:
            result['disburse_contract_no'] = self.disburse_contract_no
        if self.credit_contract_no is not None:
            result['credit_contract_no'] = self.credit_contract_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('relation_no') is not None:
            self.relation_no = m.get('relation_no')
        if m.get('contract_no') is not None:
            self.contract_no = m.get('contract_no')
        if m.get('contract_name') is not None:
            self.contract_name = m.get('contract_name')
        if m.get('contract_type') is not None:
            self.contract_type = m.get('contract_type')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('save_path') is not None:
            self.save_path = m.get('save_path')
        if m.get('contract_amount') is not None:
            self.contract_amount = m.get('contract_amount')
        if m.get('disburse_contract_no') is not None:
            self.disburse_contract_no = m.get('disburse_contract_no')
        if m.get('credit_contract_no') is not None:
            self.credit_contract_no = m.get('credit_contract_no')
        return self


class AICallbackMessage(TeaModel):
    def __init__(
        self,
        batch_id: str = None,
        tag: str = None,
        call_id: str = None,
        template_id: int = None,
        status_code: int = None,
        status_description: str = None,
        import_time: str = None,
        call_begin_time: str = None,
        ring_time: int = None,
        answer_time: str = None,
        speaking_duration: int = None,
        hangup_time: str = None,
        speaking_turns: int = None,
        intent_tag: str = None,
        intent_description: str = None,
        individual_tag: str = None,
        keywords: str = None,
        chat_record: str = None,
        properties: str = None,
    ):
        # 批次号
        self.batch_id = batch_id
        # 用户标签
        self.tag = tag
        # 外呼id
        self.call_id = call_id
        # 外呼的话术模板Id
        self.template_id = template_id
        # 外呼状态编码
        self.status_code = status_code
        # 外呼状态描述
        self.status_description = status_description
        # 导入时间
        self.import_time = import_time
        # 开始通话时间
        self.call_begin_time = call_begin_time
        # 振铃时长, 单位毫秒
        self.ring_time = ring_time
        # 接通时间
        self.answer_time = answer_time
        # AI通话时长,单位s
        self.speaking_duration = speaking_duration
        # 挂断时间
        self.hangup_time = hangup_time
        # 对话轮次
        self.speaking_turns = speaking_turns
        # 意向标签
        self.intent_tag = intent_tag
        # 意向说明
        self.intent_description = intent_description
        # 个性标签
        self.individual_tag = individual_tag
        # 回复关键词
        self.keywords = keywords
        # 对话录音
        self.chat_record = chat_record
        # 参数值
        self.properties = properties

    def validate(self):
        self.validate_required(self.tag, 'tag')
        self.validate_required(self.call_id, 'call_id')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.status_description, 'status_description')
        self.validate_required(self.import_time, 'import_time')
        self.validate_required(self.call_begin_time, 'call_begin_time')
        self.validate_required(self.ring_time, 'ring_time')
        self.validate_required(self.answer_time, 'answer_time')
        self.validate_required(self.speaking_duration, 'speaking_duration')
        self.validate_required(self.hangup_time, 'hangup_time')
        self.validate_required(self.speaking_turns, 'speaking_turns')
        self.validate_required(self.intent_tag, 'intent_tag')
        self.validate_required(self.intent_description, 'intent_description')
        self.validate_required(self.individual_tag, 'individual_tag')
        self.validate_required(self.keywords, 'keywords')
        self.validate_required(self.properties, 'properties')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.tag is not None:
            result['tag'] = self.tag
        if self.call_id is not None:
            result['call_id'] = self.call_id
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.status_code is not None:
            result['status_code'] = self.status_code
        if self.status_description is not None:
            result['status_description'] = self.status_description
        if self.import_time is not None:
            result['import_time'] = self.import_time
        if self.call_begin_time is not None:
            result['call_begin_time'] = self.call_begin_time
        if self.ring_time is not None:
            result['ring_time'] = self.ring_time
        if self.answer_time is not None:
            result['answer_time'] = self.answer_time
        if self.speaking_duration is not None:
            result['speaking_duration'] = self.speaking_duration
        if self.hangup_time is not None:
            result['hangup_time'] = self.hangup_time
        if self.speaking_turns is not None:
            result['speaking_turns'] = self.speaking_turns
        if self.intent_tag is not None:
            result['intent_tag'] = self.intent_tag
        if self.intent_description is not None:
            result['intent_description'] = self.intent_description
        if self.individual_tag is not None:
            result['individual_tag'] = self.individual_tag
        if self.keywords is not None:
            result['keywords'] = self.keywords
        if self.chat_record is not None:
            result['chat_record'] = self.chat_record
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('call_id') is not None:
            self.call_id = m.get('call_id')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('status_code') is not None:
            self.status_code = m.get('status_code')
        if m.get('status_description') is not None:
            self.status_description = m.get('status_description')
        if m.get('import_time') is not None:
            self.import_time = m.get('import_time')
        if m.get('call_begin_time') is not None:
            self.call_begin_time = m.get('call_begin_time')
        if m.get('ring_time') is not None:
            self.ring_time = m.get('ring_time')
        if m.get('answer_time') is not None:
            self.answer_time = m.get('answer_time')
        if m.get('speaking_duration') is not None:
            self.speaking_duration = m.get('speaking_duration')
        if m.get('hangup_time') is not None:
            self.hangup_time = m.get('hangup_time')
        if m.get('speaking_turns') is not None:
            self.speaking_turns = m.get('speaking_turns')
        if m.get('intent_tag') is not None:
            self.intent_tag = m.get('intent_tag')
        if m.get('intent_description') is not None:
            self.intent_description = m.get('intent_description')
        if m.get('individual_tag') is not None:
            self.individual_tag = m.get('individual_tag')
        if m.get('keywords') is not None:
            self.keywords = m.get('keywords')
        if m.get('chat_record') is not None:
            self.chat_record = m.get('chat_record')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class RtopCompanyAlarm(TeaModel):
    def __init__(
        self,
        company_id: str = None,
        alarm_type: str = None,
        alarm_idx: str = None,
        alarm_date: str = None,
        alarm_flag: str = None,
    ):
        # 企业ID
        self.company_id = company_id
        # 预警类型
        self.alarm_type = alarm_type
        # 预警序号
        self.alarm_idx = alarm_idx
        # 预警日期
        self.alarm_date = alarm_date
        # 预警标识，是否需要预警
        self.alarm_flag = alarm_flag

    def validate(self):
        self.validate_required(self.company_id, 'company_id')
        self.validate_required(self.alarm_type, 'alarm_type')
        self.validate_required(self.alarm_idx, 'alarm_idx')
        self.validate_required(self.alarm_date, 'alarm_date')
        self.validate_required(self.alarm_flag, 'alarm_flag')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_id is not None:
            result['company_id'] = self.company_id
        if self.alarm_type is not None:
            result['alarm_type'] = self.alarm_type
        if self.alarm_idx is not None:
            result['alarm_idx'] = self.alarm_idx
        if self.alarm_date is not None:
            result['alarm_date'] = self.alarm_date
        if self.alarm_flag is not None:
            result['alarm_flag'] = self.alarm_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('company_id') is not None:
            self.company_id = m.get('company_id')
        if m.get('alarm_type') is not None:
            self.alarm_type = m.get('alarm_type')
        if m.get('alarm_idx') is not None:
            self.alarm_idx = m.get('alarm_idx')
        if m.get('alarm_date') is not None:
            self.alarm_date = m.get('alarm_date')
        if m.get('alarm_flag') is not None:
            self.alarm_flag = m.get('alarm_flag')
        return self


class RtopGenderDistribution(TeaModel):
    def __init__(
        self,
        count: int = None,
        gender: str = None,
    ):
        # 统计值
        self.count = count
        # 性别
        self.gender = gender

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.gender, 'gender')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.gender is not None:
            result['gender'] = self.gender
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        return self


class ShortUrlInfo(TeaModel):
    def __init__(
        self,
        mobile: str = None,
        short_url: str = None,
    ):
        # 支持卡片短信的手机号
        self.mobile = mobile
        # 解析生成的短链
        self.short_url = short_url

    def validate(self):
        self.validate_required(self.mobile, 'mobile')
        self.validate_required(self.short_url, 'short_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.short_url is not None:
            result['short_url'] = self.short_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('short_url') is not None:
            self.short_url = m.get('short_url')
        return self


class CustomRelationStatus(TeaModel):
    def __init__(
        self,
        reg_flag: bool = None,
    ):
        # 是否联登
        self.reg_flag = reg_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reg_flag is not None:
            result['reg_flag'] = self.reg_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('reg_flag') is not None:
            self.reg_flag = m.get('reg_flag')
        return self


class VehicleInfo(TeaModel):
    def __init__(
        self,
        biz_order_no: str = None,
        trade_amount: str = None,
        installment_amount: str = None,
        down_payment: str = None,
        wifi_mac: str = None,
        sn: str = None,
        frame_no: str = None,
        sku: str = None,
        color: str = None,
        model_keyword: str = None,
        range: str = None,
        guide_price: str = None,
        selling_price: str = None,
        brand: str = None,
        model: str = None,
        model_year: str = None,
        odo: str = None,
        first_reg_date: str = None,
        otr: str = None,
        parts: str = None,
    ):
        # 流量方购物订单号
        self.biz_order_no = biz_order_no
        # 订单[分期]金额，单位：元
        self.trade_amount = trade_amount
        # 订单分期金额，单位：元
        self.installment_amount = installment_amount
        # 首付金额，单位：元
        self.down_payment = down_payment
        # pad设备提供
        self.wifi_mac = wifi_mac
        # SN码/中控号(授信后放款前)
        self.sn = sn
        # 车驾号(授信后放款前)
        self.frame_no = frame_no
        # SKU ID
        self.sku = sku
        # 颜色
        self.color = color
        # 车型关键词
        self.model_keyword = model_keyword
        # 续航里程
        self.range = range
        # 新车指导价，单位：元
        self.guide_price = guide_price
        # 售价，单位：元
        self.selling_price = selling_price
        # 品牌
        self.brand = brand
        # 车型
        self.model = model
        # 年款，yyyy
        self.model_year = model_year
        # 公里数，Odometer
        self.odo = odo
        # 首次上牌时间
        self.first_reg_date = first_reg_date
        # 过户次数，Ownership Transfer Records
        self.otr = otr
        # 配件信息
        self.parts = parts

    def validate(self):
        self.validate_required(self.biz_order_no, 'biz_order_no')
        self.validate_required(self.trade_amount, 'trade_amount')
        self.validate_required(self.sku, 'sku')
        self.validate_required(self.guide_price, 'guide_price')
        self.validate_required(self.selling_price, 'selling_price')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        if self.trade_amount is not None:
            result['trade_amount'] = self.trade_amount
        if self.installment_amount is not None:
            result['installment_amount'] = self.installment_amount
        if self.down_payment is not None:
            result['down_payment'] = self.down_payment
        if self.wifi_mac is not None:
            result['wifi_mac'] = self.wifi_mac
        if self.sn is not None:
            result['sn'] = self.sn
        if self.frame_no is not None:
            result['frame_no'] = self.frame_no
        if self.sku is not None:
            result['sku'] = self.sku
        if self.color is not None:
            result['color'] = self.color
        if self.model_keyword is not None:
            result['model_keyword'] = self.model_keyword
        if self.range is not None:
            result['range'] = self.range
        if self.guide_price is not None:
            result['guide_price'] = self.guide_price
        if self.selling_price is not None:
            result['selling_price'] = self.selling_price
        if self.brand is not None:
            result['brand'] = self.brand
        if self.model is not None:
            result['model'] = self.model
        if self.model_year is not None:
            result['model_year'] = self.model_year
        if self.odo is not None:
            result['odo'] = self.odo
        if self.first_reg_date is not None:
            result['first_reg_date'] = self.first_reg_date
        if self.otr is not None:
            result['otr'] = self.otr
        if self.parts is not None:
            result['parts'] = self.parts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        if m.get('trade_amount') is not None:
            self.trade_amount = m.get('trade_amount')
        if m.get('installment_amount') is not None:
            self.installment_amount = m.get('installment_amount')
        if m.get('down_payment') is not None:
            self.down_payment = m.get('down_payment')
        if m.get('wifi_mac') is not None:
            self.wifi_mac = m.get('wifi_mac')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('frame_no') is not None:
            self.frame_no = m.get('frame_no')
        if m.get('sku') is not None:
            self.sku = m.get('sku')
        if m.get('color') is not None:
            self.color = m.get('color')
        if m.get('model_keyword') is not None:
            self.model_keyword = m.get('model_keyword')
        if m.get('range') is not None:
            self.range = m.get('range')
        if m.get('guide_price') is not None:
            self.guide_price = m.get('guide_price')
        if m.get('selling_price') is not None:
            self.selling_price = m.get('selling_price')
        if m.get('brand') is not None:
            self.brand = m.get('brand')
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('model_year') is not None:
            self.model_year = m.get('model_year')
        if m.get('odo') is not None:
            self.odo = m.get('odo')
        if m.get('first_reg_date') is not None:
            self.first_reg_date = m.get('first_reg_date')
        if m.get('otr') is not None:
            self.otr = m.get('otr')
        if m.get('parts') is not None:
            self.parts = m.get('parts')
        return self


class RdaasTaxDecsionService(TeaModel):
    def __init__(
        self,
        id: str = None,
        service_name: str = None,
        service_zone: str = None,
        channel: str = None,
        decision_tenant: str = None,
        status: str = None,
        create_time: str = None,
    ):
        # 决策服务id
        self.id = id
        # 产品编码
        self.service_name = service_name
        # 区域编码
        self.service_zone = service_zone
        # 渠道
        self.channel = channel
        # 决策租户
        self.decision_tenant = decision_tenant
        # 是否启用
        self.status = status
        # 创建时间，格式:yyyy-MM-dd HH:mm:ss
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.service_name, 'service_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.service_name is not None:
            result['service_name'] = self.service_name
        if self.service_zone is not None:
            result['service_zone'] = self.service_zone
        if self.channel is not None:
            result['channel'] = self.channel
        if self.decision_tenant is not None:
            result['decision_tenant'] = self.decision_tenant
        if self.status is not None:
            result['status'] = self.status
        if self.create_time is not None:
            result['create_time'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('service_name') is not None:
            self.service_name = m.get('service_name')
        if m.get('service_zone') is not None:
            self.service_zone = m.get('service_zone')
        if m.get('channel') is not None:
            self.channel = m.get('channel')
        if m.get('decision_tenant') is not None:
            self.decision_tenant = m.get('decision_tenant')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        return self


class ServiceContext(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        client_pcidguid: str = None,
        server_name: str = None,
        session_id: str = None,
        user_id: str = None,
    ):
        # 客户端IP
        self.client_ip = client_ip
        # 客户端UMID
        self.client_pcidguid = client_pcidguid
        # 服务器名
        self.server_name = server_name
        # 会话ID
        self.session_id = session_id
        # 用户ID
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['client_ip'] = self.client_ip
        if self.client_pcidguid is not None:
            result['client_pcidguid'] = self.client_pcidguid
        if self.server_name is not None:
            result['server_name'] = self.server_name
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_ip') is not None:
            self.client_ip = m.get('client_ip')
        if m.get('client_pcidguid') is not None:
            self.client_pcidguid = m.get('client_pcidguid')
        if m.get('server_name') is not None:
            self.server_name = m.get('server_name')
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CustomerUmktInfoModel(TeaModel):
    def __init__(
        self,
        base_info: BaseCustomerUmktInfoModel = None,
        umkt_out_put_info: str = None,
    ):
        # 基本圈客结果信息
        self.base_info = base_info
        # 额外的营销分结果
        self.umkt_out_put_info = umkt_out_put_info

    def validate(self):
        self.validate_required(self.base_info, 'base_info')
        if self.base_info:
            self.base_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_info is not None:
            result['base_info'] = self.base_info.to_map()
        if self.umkt_out_put_info is not None:
            result['umkt_out_put_info'] = self.umkt_out_put_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('base_info') is not None:
            temp_model = BaseCustomerUmktInfoModel()
            self.base_info = temp_model.from_map(m['base_info'])
        if m.get('umkt_out_put_info') is not None:
            self.umkt_out_put_info = m.get('umkt_out_put_info')
        return self


class RtopCompanyOpinionCount(TeaModel):
    def __init__(
        self,
        company_name: str = None,
        count: int = None,
    ):
        # 企业名称
        self.company_name = company_name
        # 企业对应的舆情数量
        self.count = count

    def validate(self):
        self.validate_required(self.company_name, 'company_name')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class FundChainLockResult(TeaModel):
    def __init__(
        self,
        name: str = None,
        id: str = None,
        status: str = None,
    ):
        # 店铺名称
        self.name = name
        # 店铺id
        self.id = id
        # 0:成功
        # 1:失败
        # 2:处理中
        self.status = status

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.id is not None:
            result['id'] = self.id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class RtopRegionalDistribution(TeaModel):
    def __init__(
        self,
        count: int = None,
        place: str = None,
        type_distribution: List[RtopTypeDistribution] = None,
    ):
        # 统计值
        self.count = count
        # 地区
        self.place = place
        # 当前地区的涉众风险类型分布，即非法集资有多少企业，传销有多少企业
        self.type_distribution = type_distribution

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.place, 'place')
        if self.type_distribution:
            for k in self.type_distribution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.place is not None:
            result['place'] = self.place
        result['type_distribution'] = []
        if self.type_distribution is not None:
            for k in self.type_distribution:
                result['type_distribution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('place') is not None:
            self.place = m.get('place')
        self.type_distribution = []
        if m.get('type_distribution') is not None:
            for k in m.get('type_distribution'):
                temp_model = RtopTypeDistribution()
                self.type_distribution.append(temp_model.from_map(k))
        return self


class CertificateInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        relation_no: str = None,
        certificate_url: str = None,
        certificate_base_64: str = None,
        message: str = None,
    ):
        # 结清证明开具结果，0：有结清证明、1：无结清证明、2：开具中、3：暂不支持开具
        self.status = status
        # 用信申请订单号
        self.relation_no = relation_no
        # 结清证明url
        self.certificate_url = certificate_url
        # 结清证明文件Base64
        self.certificate_base_64 = certificate_base_64
        # 说明
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['status'] = self.status
        if self.relation_no is not None:
            result['relation_no'] = self.relation_no
        if self.certificate_url is not None:
            result['certificate_url'] = self.certificate_url
        if self.certificate_base_64 is not None:
            result['certificate_base64'] = self.certificate_base_64
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('relation_no') is not None:
            self.relation_no = m.get('relation_no')
        if m.get('certificate_url') is not None:
            self.certificate_url = m.get('certificate_url')
        if m.get('certificate_base64') is not None:
            self.certificate_base_64 = m.get('certificate_base64')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class RtopCrowdRiskFeatureResp(TeaModel):
    def __init__(
        self,
        clue_tags: List[RtopCrowdRiskFeatureTag] = None,
        feature_name: str = None,
        score: int = None,
    ):
        # 特征标签列表
        self.clue_tags = clue_tags
        # 特征名称
        self.feature_name = feature_name
        # 特征​分数
        self.score = score

    def validate(self):
        if self.clue_tags:
            for k in self.clue_tags:
                if k:
                    k.validate()
        self.validate_required(self.feature_name, 'feature_name')
        self.validate_required(self.score, 'score')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['clue_tags'] = []
        if self.clue_tags is not None:
            for k in self.clue_tags:
                result['clue_tags'].append(k.to_map() if k else None)
        if self.feature_name is not None:
            result['feature_name'] = self.feature_name
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clue_tags = []
        if m.get('clue_tags') is not None:
            for k in m.get('clue_tags'):
                temp_model = RtopCrowdRiskFeatureTag()
                self.clue_tags.append(temp_model.from_map(k))
        if m.get('feature_name') is not None:
            self.feature_name = m.get('feature_name')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class OfflineDecisionPlanDetail(TeaModel):
    def __init__(
        self,
        decision_plan_id: str = None,
        decision_result_status: str = None,
    ):
        # 圈客计划ID
        self.decision_plan_id = decision_plan_id
        # 离线圈客执行任务状态
        self.decision_result_status = decision_result_status

    def validate(self):
        self.validate_required(self.decision_plan_id, 'decision_plan_id')
        self.validate_required(self.decision_result_status, 'decision_result_status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decision_plan_id is not None:
            result['decision_plan_id'] = self.decision_plan_id
        if self.decision_result_status is not None:
            result['decision_result_status'] = self.decision_result_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('decision_plan_id') is not None:
            self.decision_plan_id = m.get('decision_plan_id')
        if m.get('decision_result_status') is not None:
            self.decision_result_status = m.get('decision_result_status')
        return self


class UserClassifyInfo(TeaModel):
    def __init__(
        self,
        version: str = None,
        rate_classify: str = None,
        classify_ext_1: str = None,
        classify_ext_2: str = None,
    ):
        # 版本号
        self.version = version
        # 流量分层
        self.rate_classify = rate_classify
        # 流量扩展分层1
        self.classify_ext_1 = classify_ext_1
        # 流量扩展分层2
        self.classify_ext_2 = classify_ext_2

    def validate(self):
        self.validate_required(self.version, 'version')
        self.validate_required(self.rate_classify, 'rate_classify')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.version is not None:
            result['version'] = self.version
        if self.rate_classify is not None:
            result['rate_classify'] = self.rate_classify
        if self.classify_ext_1 is not None:
            result['classify_ext1'] = self.classify_ext_1
        if self.classify_ext_2 is not None:
            result['classify_ext2'] = self.classify_ext_2
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('rate_classify') is not None:
            self.rate_classify = m.get('rate_classify')
        if m.get('classify_ext1') is not None:
            self.classify_ext_1 = m.get('classify_ext1')
        if m.get('classify_ext2') is not None:
            self.classify_ext_2 = m.get('classify_ext2')
        return self


class RepayInfo(TeaModel):
    def __init__(
        self,
        overdue_flag: bool = None,
        over_days: int = None,
        valuable_over_days: int = None,
        over_period_count: int = None,
        over_principal: int = None,
        over_interest: int = None,
        over_punish: int = None,
        need_overdue_amount: int = None,
        current_need_amount: int = None,
        total_amount: int = None,
    ):
        # true：逾期
        # false：未逾期
        self.overdue_flag = overdue_flag
        # 逾期天数
        self.over_days = over_days
        # 逾期金额在50元以上的客户的逾期天数
        self.valuable_over_days = valuable_over_days
        # 逾期期数
        self.over_period_count = over_period_count
        # 逾期本金
        self.over_principal = over_principal
        # 逾期利息
        self.over_interest = over_interest
        # 应还罚息
        self.over_punish = over_punish
        # 应还逾期总额
        self.need_overdue_amount = need_overdue_amount
        # 当前应还总额（包含逾期和当前期）
        self.current_need_amount = current_need_amount
        # 总剩余应还
        self.total_amount = total_amount

    def validate(self):
        self.validate_required(self.overdue_flag, 'overdue_flag')
        self.validate_required(self.over_days, 'over_days')
        self.validate_required(self.valuable_over_days, 'valuable_over_days')
        self.validate_required(self.over_period_count, 'over_period_count')
        self.validate_required(self.over_principal, 'over_principal')
        self.validate_required(self.over_interest, 'over_interest')
        self.validate_required(self.over_punish, 'over_punish')
        self.validate_required(self.need_overdue_amount, 'need_overdue_amount')
        self.validate_required(self.current_need_amount, 'current_need_amount')
        self.validate_required(self.total_amount, 'total_amount')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overdue_flag is not None:
            result['overdue_flag'] = self.overdue_flag
        if self.over_days is not None:
            result['over_days'] = self.over_days
        if self.valuable_over_days is not None:
            result['valuable_over_days'] = self.valuable_over_days
        if self.over_period_count is not None:
            result['over_period_count'] = self.over_period_count
        if self.over_principal is not None:
            result['over_principal'] = self.over_principal
        if self.over_interest is not None:
            result['over_interest'] = self.over_interest
        if self.over_punish is not None:
            result['over_punish'] = self.over_punish
        if self.need_overdue_amount is not None:
            result['need_overdue_amount'] = self.need_overdue_amount
        if self.current_need_amount is not None:
            result['current_need_amount'] = self.current_need_amount
        if self.total_amount is not None:
            result['total_amount'] = self.total_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('overdue_flag') is not None:
            self.overdue_flag = m.get('overdue_flag')
        if m.get('over_days') is not None:
            self.over_days = m.get('over_days')
        if m.get('valuable_over_days') is not None:
            self.valuable_over_days = m.get('valuable_over_days')
        if m.get('over_period_count') is not None:
            self.over_period_count = m.get('over_period_count')
        if m.get('over_principal') is not None:
            self.over_principal = m.get('over_principal')
        if m.get('over_interest') is not None:
            self.over_interest = m.get('over_interest')
        if m.get('over_punish') is not None:
            self.over_punish = m.get('over_punish')
        if m.get('need_overdue_amount') is not None:
            self.need_overdue_amount = m.get('need_overdue_amount')
        if m.get('current_need_amount') is not None:
            self.current_need_amount = m.get('current_need_amount')
        if m.get('total_amount') is not None:
            self.total_amount = m.get('total_amount')
        return self


class CreditAmount(TeaModel):
    def __init__(
        self,
        credit_amount: int = None,
        rest_amount: int = None,
        pay_date: str = None,
        expire_date: str = None,
        rate_unit: str = None,
        rate_value: int = None,
        repay_way: str = None,
        status: str = None,
        pay_date_sup: str = None,
        expire_date_sup: str = None,
    ):
        # 授信额度
        self.credit_amount = credit_amount
        # 授信余额
        self.rest_amount = rest_amount
        # 发放日期
        self.pay_date = pay_date
        # 到期日期
        self.expire_date = expire_date
        # 利率单位(1:年，2：月，3：日)
        self.rate_unit = rate_unit
        # 执行利率,利率值，单位%\
        # 年化5%，rateValue=5
        # 
        self.rate_value = rate_value
        # 还款方式1等额本息2等额本金3先息后本4一次性利随本清5只还本金6等本等息
        self.repay_way = repay_way
        # 状态0-正常 1-冻结 2-终止
        self.status = status
        # 发放日期（兼容字段）
        self.pay_date_sup = pay_date_sup
        # 到期日期（兼容字段）
        self.expire_date_sup = expire_date_sup

    def validate(self):
        self.validate_required(self.credit_amount, 'credit_amount')
        self.validate_required(self.rest_amount, 'rest_amount')
        self.validate_required(self.pay_date, 'pay_date')
        if self.pay_date is not None:
            self.validate_pattern(self.pay_date, 'pay_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.expire_date, 'expire_date')
        if self.expire_date is not None:
            self.validate_pattern(self.expire_date, 'expire_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.rate_unit, 'rate_unit')
        self.validate_required(self.rate_value, 'rate_value')
        self.validate_required(self.repay_way, 'repay_way')
        self.validate_required(self.status, 'status')
        if self.pay_date_sup is not None:
            self.validate_pattern(self.pay_date_sup, 'pay_date_sup', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.expire_date_sup is not None:
            self.validate_pattern(self.expire_date_sup, 'expire_date_sup', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.rest_amount is not None:
            result['rest_amount'] = self.rest_amount
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.rate_unit is not None:
            result['rate_unit'] = self.rate_unit
        if self.rate_value is not None:
            result['rate_value'] = self.rate_value
        if self.repay_way is not None:
            result['repay_way'] = self.repay_way
        if self.status is not None:
            result['status'] = self.status
        if self.pay_date_sup is not None:
            result['pay_date_sup'] = self.pay_date_sup
        if self.expire_date_sup is not None:
            result['expire_date_sup'] = self.expire_date_sup
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('rest_amount') is not None:
            self.rest_amount = m.get('rest_amount')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('rate_unit') is not None:
            self.rate_unit = m.get('rate_unit')
        if m.get('rate_value') is not None:
            self.rate_value = m.get('rate_value')
        if m.get('repay_way') is not None:
            self.repay_way = m.get('repay_way')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('pay_date_sup') is not None:
            self.pay_date_sup = m.get('pay_date_sup')
        if m.get('expire_date_sup') is not None:
            self.expire_date_sup = m.get('expire_date_sup')
        return self


class EventInfo(TeaModel):
    def __init__(
        self,
        event_code: str = None,
        gmt_occur: str = None,
    ):
        # 事件编码
        self.event_code = event_code
        # 事件产生时间
        self.gmt_occur = gmt_occur

    def validate(self):
        self.validate_required(self.event_code, 'event_code')
        self.validate_required(self.gmt_occur, 'gmt_occur')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_code is not None:
            result['event_code'] = self.event_code
        if self.gmt_occur is not None:
            result['gmt_occur'] = self.gmt_occur
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('event_code') is not None:
            self.event_code = m.get('event_code')
        if m.get('gmt_occur') is not None:
            self.gmt_occur = m.get('gmt_occur')
        return self


class RepayTrail(TeaModel):
    def __init__(
        self,
        period: str = None,
        need_amt: int = None,
        already_amt: int = None,
        trans_principal: int = None,
        trans_interest: int = None,
        trans_fee: int = None,
        remain_principal: int = None,
        repay_time: str = None,
        start_time: str = None,
        end_time: str = None,
        trial_no: str = None,
        discount_after_need_amt: int = None,
        discount_after_interest: int = None,
        discount_interest: int = None,
    ):
        # 期数
        self.period = period
        # 每期应还金额
        self.need_amt = need_amt
        # 每期已还金额
        self.already_amt = already_amt
        # 每期应还本金
        self.trans_principal = trans_principal
        # 每期应还利息
        self.trans_interest = trans_interest
        # 每期还款费用
        self.trans_fee = trans_fee
        # 剩余本金
        self.remain_principal = remain_principal
        # 还款时间
        self.repay_time = repay_time
        # 计息开始时间
        self.start_time = start_time
        # 计息结束时间
        self.end_time = end_time
        # 试算编号
        self.trial_no = trial_no
        # 优惠后应还金额
        self.discount_after_need_amt = discount_after_need_amt
        # 优惠后应还利息
        self.discount_after_interest = discount_after_interest
        # 优惠利息
        self.discount_interest = discount_interest

    def validate(self):
        self.validate_required(self.period, 'period')
        self.validate_required(self.need_amt, 'need_amt')
        self.validate_required(self.already_amt, 'already_amt')
        self.validate_required(self.trans_principal, 'trans_principal')
        self.validate_required(self.trans_interest, 'trans_interest')
        self.validate_required(self.trans_fee, 'trans_fee')
        self.validate_required(self.remain_principal, 'remain_principal')
        self.validate_required(self.repay_time, 'repay_time')
        if self.repay_time is not None:
            self.validate_pattern(self.repay_time, 'repay_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.start_time, 'start_time')
        if self.start_time is not None:
            self.validate_pattern(self.start_time, 'start_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.end_time, 'end_time')
        if self.end_time is not None:
            self.validate_pattern(self.end_time, 'end_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.trial_no, 'trial_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['period'] = self.period
        if self.need_amt is not None:
            result['need_amt'] = self.need_amt
        if self.already_amt is not None:
            result['already_amt'] = self.already_amt
        if self.trans_principal is not None:
            result['trans_principal'] = self.trans_principal
        if self.trans_interest is not None:
            result['trans_interest'] = self.trans_interest
        if self.trans_fee is not None:
            result['trans_fee'] = self.trans_fee
        if self.remain_principal is not None:
            result['remain_principal'] = self.remain_principal
        if self.repay_time is not None:
            result['repay_time'] = self.repay_time
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.trial_no is not None:
            result['trial_no'] = self.trial_no
        if self.discount_after_need_amt is not None:
            result['discount_after_need_amt'] = self.discount_after_need_amt
        if self.discount_after_interest is not None:
            result['discount_after_interest'] = self.discount_after_interest
        if self.discount_interest is not None:
            result['discount_interest'] = self.discount_interest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('need_amt') is not None:
            self.need_amt = m.get('need_amt')
        if m.get('already_amt') is not None:
            self.already_amt = m.get('already_amt')
        if m.get('trans_principal') is not None:
            self.trans_principal = m.get('trans_principal')
        if m.get('trans_interest') is not None:
            self.trans_interest = m.get('trans_interest')
        if m.get('trans_fee') is not None:
            self.trans_fee = m.get('trans_fee')
        if m.get('remain_principal') is not None:
            self.remain_principal = m.get('remain_principal')
        if m.get('repay_time') is not None:
            self.repay_time = m.get('repay_time')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('trial_no') is not None:
            self.trial_no = m.get('trial_no')
        if m.get('discount_after_need_amt') is not None:
            self.discount_after_need_amt = m.get('discount_after_need_amt')
        if m.get('discount_after_interest') is not None:
            self.discount_after_interest = m.get('discount_after_interest')
        if m.get('discount_interest') is not None:
            self.discount_interest = m.get('discount_interest')
        return self


class CustomStatus(TeaModel):
    def __init__(
        self,
        apply_flag: bool = None,
        status: str = None,
        msg: str = None,
    ):
        # 是否进行过授信申请
        self.apply_flag = apply_flag
        # 0:通过； 1:拒绝； 2:处理中；
        self.status = status
        # 拒绝原因
        self.msg = msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_flag is not None:
            result['apply_flag'] = self.apply_flag
        if self.status is not None:
            result['status'] = self.status
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_flag') is not None:
            self.apply_flag = m.get('apply_flag')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class TenantActionPlanInfo(TeaModel):
    def __init__(
        self,
        scene_strategy_id: int = None,
        scene_strategy_name: str = None,
        scene_strategy_status: str = None,
        action_driver_code: int = None,
        channel_code: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        action_param_info: List[str] = None,
        is_param_query_done: bool = None,
    ):
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 营销名称
        self.scene_strategy_name = scene_strategy_name
        # 营销状态
        self.scene_strategy_status = scene_strategy_status
        # 渠道id
        self.action_driver_code = action_driver_code
        # 渠道类型
        self.channel_code = channel_code
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 场景策略入参名
        self.action_param_info = action_param_info
        # 参数查询是否完成
        self.is_param_query_done = is_param_query_done

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.scene_strategy_name, 'scene_strategy_name')
        self.validate_required(self.scene_strategy_status, 'scene_strategy_status')
        self.validate_required(self.action_driver_code, 'action_driver_code')
        self.validate_required(self.channel_code, 'channel_code')
        self.validate_required(self.gmt_create, 'gmt_create')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.scene_strategy_name is not None:
            result['scene_strategy_name'] = self.scene_strategy_name
        if self.scene_strategy_status is not None:
            result['scene_strategy_status'] = self.scene_strategy_status
        if self.action_driver_code is not None:
            result['action_driver_code'] = self.action_driver_code
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.action_param_info is not None:
            result['action_param_info'] = self.action_param_info
        if self.is_param_query_done is not None:
            result['is_param_query_done'] = self.is_param_query_done
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('scene_strategy_name') is not None:
            self.scene_strategy_name = m.get('scene_strategy_name')
        if m.get('scene_strategy_status') is not None:
            self.scene_strategy_status = m.get('scene_strategy_status')
        if m.get('action_driver_code') is not None:
            self.action_driver_code = m.get('action_driver_code')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('action_param_info') is not None:
            self.action_param_info = m.get('action_param_info')
        if m.get('is_param_query_done') is not None:
            self.is_param_query_done = m.get('is_param_query_done')
        return self


class XNameValuePair(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 键名
        self.name = name
        # 键值
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ReceiveBenefithubRiskPayRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_code: str = None,
        product_code: str = None,
        user_unique_id: str = None,
        result_type: str = None,
        callback_result: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 业务分配的平台code，8位纯大写字母code
        self.platform_code = platform_code
        # 产品code
        self.product_code = product_code
        # 平台code、用户唯一ID 组合出全局唯一id
        self.user_unique_id = user_unique_id
        # 类型：订单支付结果类、订单退款类、续费扣款类、签约成功、解约成功、订单超时类型
        # 具体如下：
        # ODRDER_PAYMENT-订单支付结果类通知、ORDER_REFUND-订单退款、RENEWAL_DEDUCTION-续费扣款、CONTRACT_SIGNED-签约成功、CONTRACT_TERMINATED-解约成功、
        # ORDER_TIMEOUT-订单超时类型
        self.result_type = result_type
        # 回调结果，json数据
        # 各个平台返回的支付结果、支付退款、续费结果通知、签约、解约、订单、超时关单
        self.callback_result = callback_result

    def validate(self):
        self.validate_required(self.platform_code, 'platform_code')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.user_unique_id, 'user_unique_id')
        self.validate_required(self.result_type, 'result_type')
        self.validate_required(self.callback_result, 'callback_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.user_unique_id is not None:
            result['user_unique_id'] = self.user_unique_id
        if self.result_type is not None:
            result['result_type'] = self.result_type
        if self.callback_result is not None:
            result['callback_result'] = self.callback_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('user_unique_id') is not None:
            self.user_unique_id = m.get('user_unique_id')
        if m.get('result_type') is not None:
            self.result_type = m.get('result_type')
        if m.get('callback_result') is not None:
            self.callback_result = m.get('callback_result')
        return self


class ReceiveBenefithubRiskPayResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class NotifyBenefithubRiskLoginRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_code: str = None,
        user_unique_id: str = None,
        mobile: str = None,
        product_code: str = None,
        scene_config: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 平台码
        # 注：不同平台的平台码都是固定好的，如果传入的平台码有误会抛出平台码错误的信息
        self.platform_code = platform_code
        # 用户id
        self.user_unique_id = user_unique_id
        # 渠道、平台方推送的手机号
        self.mobile = mobile
        # 产品code必填，后续多产品时可以区分
        self.product_code = product_code
        # 场景配置信息字符串，用于透传
        self.scene_config = scene_config

    def validate(self):
        self.validate_required(self.platform_code, 'platform_code')
        self.validate_required(self.user_unique_id, 'user_unique_id')
        self.validate_required(self.mobile, 'mobile')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.user_unique_id is not None:
            result['user_unique_id'] = self.user_unique_id
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.scene_config is not None:
            result['scene_config'] = self.scene_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('user_unique_id') is not None:
            self.user_unique_id = m.get('user_unique_id')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('scene_config') is not None:
            self.scene_config = m.get('scene_config')
        return self


class NotifyBenefithubRiskLoginResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        h_5url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # h5跳转链接
        self.h_5url = h_5url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.h_5url is not None:
            result['h5_url'] = self.h_5url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('h5_url') is not None:
            self.h_5url = m.get('h5_url')
        return self


class NotifyBenefithubRiskPayunilateralRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_type: str = None,
        payment_no: str = None,
        status: str = None,
        order_amount: str = None,
        payment_amount: str = None,
        payment_time: str = None,
        payment_method_type: str = None,
        cap_num: str = None,
        merchant_no: str = None,
        order_type: str = None,
        order_source: str = None,
        platform_code: str = None,
        user_unique_id: str = None,
        product_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 业务操作类型,目前只支持下单
        self.biz_type = biz_type
        # 外部支付的订单号
        self.payment_no = payment_no
        # 订单状态
        self.status = status
        # 订单金额
        self.order_amount = order_amount
        # 订单实际支付金额
        self.payment_amount = payment_amount
        # 支付时间
        self.payment_time = payment_time
        # 支付使用的方式
        self.payment_method_type = payment_method_type
        # 三方支付流水号
        self.cap_num = cap_num
        # 支付通道商户号
        self.merchant_no = merchant_no
        # 订单类型，订阅、单次购买等
        self.order_type = order_type
        # 订单来源
        self.order_source = order_source
        # 平台code，由蚂蚁数科颁发的特定平台code，用于报告产品授权使用
        self.platform_code = platform_code
        # 用户唯一id，流量平台提供，内部结合platformCode 组成唯一code
        self.user_unique_id = user_unique_id
        # 产品code，具体的报告产品；不同产品价格、展示内容可能均不一样，可通过产品code区分不同场景
        self.product_code = product_code

    def validate(self):
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.payment_no, 'payment_no')
        self.validate_required(self.status, 'status')
        self.validate_required(self.order_amount, 'order_amount')
        self.validate_required(self.payment_amount, 'payment_amount')
        self.validate_required(self.payment_time, 'payment_time')
        self.validate_required(self.payment_method_type, 'payment_method_type')
        self.validate_required(self.cap_num, 'cap_num')
        self.validate_required(self.order_type, 'order_type')
        self.validate_required(self.order_source, 'order_source')
        self.validate_required(self.platform_code, 'platform_code')
        self.validate_required(self.user_unique_id, 'user_unique_id')
        self.validate_required(self.product_code, 'product_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.payment_no is not None:
            result['payment_no'] = self.payment_no
        if self.status is not None:
            result['status'] = self.status
        if self.order_amount is not None:
            result['order_amount'] = self.order_amount
        if self.payment_amount is not None:
            result['payment_amount'] = self.payment_amount
        if self.payment_time is not None:
            result['payment_time'] = self.payment_time
        if self.payment_method_type is not None:
            result['payment_method_type'] = self.payment_method_type
        if self.cap_num is not None:
            result['cap_num'] = self.cap_num
        if self.merchant_no is not None:
            result['merchant_no'] = self.merchant_no
        if self.order_type is not None:
            result['order_type'] = self.order_type
        if self.order_source is not None:
            result['order_source'] = self.order_source
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.user_unique_id is not None:
            result['user_unique_id'] = self.user_unique_id
        if self.product_code is not None:
            result['product_code'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('payment_no') is not None:
            self.payment_no = m.get('payment_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('order_amount') is not None:
            self.order_amount = m.get('order_amount')
        if m.get('payment_amount') is not None:
            self.payment_amount = m.get('payment_amount')
        if m.get('payment_time') is not None:
            self.payment_time = m.get('payment_time')
        if m.get('payment_method_type') is not None:
            self.payment_method_type = m.get('payment_method_type')
        if m.get('cap_num') is not None:
            self.cap_num = m.get('cap_num')
        if m.get('merchant_no') is not None:
            self.merchant_no = m.get('merchant_no')
        if m.get('order_type') is not None:
            self.order_type = m.get('order_type')
        if m.get('order_source') is not None:
            self.order_source = m.get('order_source')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('user_unique_id') is not None:
            self.user_unique_id = m.get('user_unique_id')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        return self


class NotifyBenefithubRiskPayunilateralResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result_data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求返回结果
        self.result_data = result_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result_data is not None:
            result['result_data'] = self.result_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result_data') is not None:
            self.result_data = m.get('result_data')
        return self


class QueryBenefithubReportInformationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        platform_code: str = None,
        product_code: str = None,
        user_unique_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 业务分配的平台code，8位纯大写字母code
        self.platform_code = platform_code
        # 产品码
        self.product_code = product_code
        # 平台code、用户唯一ID 组合出全局唯一id
        self.user_unique_id = user_unique_id

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.platform_code, 'platform_code')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.user_unique_id, 'user_unique_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.user_unique_id is not None:
            result['user_unique_id'] = self.user_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('user_unique_id') is not None:
            self.user_unique_id = m.get('user_unique_id')
        return self


class QueryBenefithubReportInformationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        uuid: str = None,
        order_no: str = None,
        platform_code: str = None,
        product_code: str = None,
        report_no: str = None,
        report_time: str = None,
        report_end_time: str = None,
        report_content: str = None,
        status: str = None,
        name: str = None,
        id_card: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用户id
        self.uuid = uuid
        # 订单号
        self.order_no = order_no
        # 平台code
        self.platform_code = platform_code
        # 产品码
        self.product_code = product_code
        # 报案号
        self.report_no = report_no
        # 报告生成时间
        self.report_time = report_time
        # 报案到期时间
        self.report_end_time = report_end_time
        # 报告内容
        self.report_content = report_content
        # 状态
        self.status = status
        # 用户姓名
        self.name = name
        # 身份证号
        self.id_card = id_card

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.uuid is not None:
            result['uuid'] = self.uuid
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.report_no is not None:
            result['report_no'] = self.report_no
        if self.report_time is not None:
            result['report_time'] = self.report_time
        if self.report_end_time is not None:
            result['report_end_time'] = self.report_end_time
        if self.report_content is not None:
            result['report_content'] = self.report_content
        if self.status is not None:
            result['status'] = self.status
        if self.name is not None:
            result['name'] = self.name
        if self.id_card is not None:
            result['id_card'] = self.id_card
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('uuid') is not None:
            self.uuid = m.get('uuid')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        if m.get('report_time') is not None:
            self.report_time = m.get('report_time')
        if m.get('report_end_time') is not None:
            self.report_end_time = m.get('report_end_time')
        if m.get('report_content') is not None:
            self.report_content = m.get('report_content')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('id_card') is not None:
            self.id_card = m.get('id_card')
        return self


class BatchqueryCreditshieldProductInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        query_code: str = None,
        query_infos: List[QueryInfo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询编码： 1.还款概率评估 2.经济波动检测 3.触达前筛等
        self.query_code = query_code
        # 查询信息集合
        self.query_infos = query_infos

    def validate(self):
        self.validate_required(self.query_code, 'query_code')
        if self.query_infos:
            for k in self.query_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.query_code is not None:
            result['query_code'] = self.query_code
        result['query_infos'] = []
        if self.query_infos is not None:
            for k in self.query_infos:
                result['query_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('query_code') is not None:
            self.query_code = m.get('query_code')
        self.query_infos = []
        if m.get('query_infos') is not None:
            for k in m.get('query_infos'):
                temp_model = QueryInfo()
                self.query_infos.append(temp_model.from_map(k))
        return self


class BatchqueryCreditshieldProductInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        query_results: List[QueryResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果是否成功
        self.success = success
        # 查询结果
        self.query_results = query_results

    def validate(self):
        if self.query_results:
            for k in self.query_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        result['query_results'] = []
        if self.query_results is not None:
            for k in self.query_results:
                result['query_results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.query_results = []
        if m.get('query_results') is not None:
            for k in m.get('query_results'):
                temp_model = QueryResult()
                self.query_results.append(temp_model.from_map(k))
        return self


class QueryCreditshieldProductCallbackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        query_code: str = None,
        query_infos: List[QueryInfo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询编码
        # 1.支付宝交易流水查询
        # 2.审批回调
        self.query_code = query_code
        # 查询信息集合
        self.query_infos = query_infos

    def validate(self):
        self.validate_required(self.query_code, 'query_code')
        if self.query_infos:
            for k in self.query_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.query_code is not None:
            result['query_code'] = self.query_code
        result['query_infos'] = []
        if self.query_infos is not None:
            for k in self.query_infos:
                result['query_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('query_code') is not None:
            self.query_code = m.get('query_code')
        self.query_infos = []
        if m.get('query_infos') is not None:
            for k in m.get('query_infos'):
                temp_model = QueryInfo()
                self.query_infos.append(temp_model.from_map(k))
        return self


class QueryCreditshieldProductCallbackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        query_results: List[QueryResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 接口请求是否成功
        self.success = success
        # 查询结果
        self.query_results = query_results

    def validate(self):
        if self.query_results:
            for k in self.query_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        result['query_results'] = []
        if self.query_results is not None:
            for k in self.query_results:
                result['query_results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.query_results = []
        if m.get('query_results') is not None:
            for k in m.get('query_results'):
                temp_model = QueryResult()
                self.query_results.append(temp_model.from_map(k))
        return self


class QueryCreditshieldProductIvrfcRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        query_code: str = None,
        query_infos: List[QueryInfo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 1.信息查询 2.债务人判断
        self.query_code = query_code
        # 查询信息Map集合
        self.query_infos = query_infos

    def validate(self):
        self.validate_required(self.query_code, 'query_code')
        if self.query_infos:
            for k in self.query_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.query_code is not None:
            result['query_code'] = self.query_code
        result['query_infos'] = []
        if self.query_infos is not None:
            for k in self.query_infos:
                result['query_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('query_code') is not None:
            self.query_code = m.get('query_code')
        self.query_infos = []
        if m.get('query_infos') is not None:
            for k in m.get('query_infos'):
                temp_model = QueryInfo()
                self.query_infos.append(temp_model.from_map(k))
        return self


class QueryCreditshieldProductIvrfcResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        query_result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 
        # 接口请求是否成功
        self.success = success
        # 查询结果
        self.query_result = query_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        if self.query_result is not None:
            result['query_result'] = self.query_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('query_result') is not None:
            self.query_result = m.get('query_result')
        return self


class QuerySecurityPolicyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        risk_type: str = None,
        security_scene: SecurityScene = None,
        service_context: ServiceContext = None,
        event_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 风险类型：表示风险处理或风险咨询——process/advice
        self.risk_type = risk_type
        # 风险场景信息
        self.security_scene = security_scene
        # 服务上下文
        self.service_context = service_context
        # 事件业务属性
        self.event_info = event_info

    def validate(self):
        if self.security_scene:
            self.security_scene.validate()
        if self.service_context:
            self.service_context.validate()
        self.validate_required(self.event_info, 'event_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.risk_type is not None:
            result['risk_type'] = self.risk_type
        if self.security_scene is not None:
            result['security_scene'] = self.security_scene.to_map()
        if self.service_context is not None:
            result['service_context'] = self.service_context.to_map()
        if self.event_info is not None:
            result['event_info'] = self.event_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('risk_type') is not None:
            self.risk_type = m.get('risk_type')
        if m.get('security_scene') is not None:
            temp_model = SecurityScene()
            self.security_scene = temp_model.from_map(m['security_scene'])
        if m.get('service_context') is not None:
            temp_model = ServiceContext()
            self.service_context = temp_model.from_map(m['service_context'])
        if m.get('event_info') is not None:
            self.event_info = m.get('event_info')
        return self


class QuerySecurityPolicyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        security_id: str = None,
        security_result: str = None,
        success: str = None,
        verify_id: str = None,
        verify_url: str = None,
        model_details: ModelDetails = None,
        variable_details: VariableDetails = None,
        strategy_details: StrategyDetails = None,
        scene_infos: SceneInfos = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 反馈成功之后的id
        self.security_id = security_id
        # 安全处理结果，枚举值为：reject[拒绝],validate[校验],accept[放过]
        self.security_result = security_result
        # 是否成功
        self.success = success
        # native场景下的核身id
        self.verify_id = verify_id
        # h5场景下的核身地址
        self.verify_url = verify_url
        # 场景分
        self.model_details = model_details
        # 输出变量
        self.variable_details = variable_details
        # 策略详情
        self.strategy_details = strategy_details
        # 场景决策
        self.scene_infos = scene_infos

    def validate(self):
        self.validate_required(self.success, 'success')
        if self.model_details:
            self.model_details.validate()
        if self.variable_details:
            self.variable_details.validate()
        if self.strategy_details:
            self.strategy_details.validate()
        if self.scene_infos:
            self.scene_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.security_id is not None:
            result['security_id'] = self.security_id
        if self.security_result is not None:
            result['security_result'] = self.security_result
        if self.success is not None:
            result['success'] = self.success
        if self.verify_id is not None:
            result['verify_id'] = self.verify_id
        if self.verify_url is not None:
            result['verify_url'] = self.verify_url
        if self.model_details is not None:
            result['model_details'] = self.model_details.to_map()
        if self.variable_details is not None:
            result['variable_details'] = self.variable_details.to_map()
        if self.strategy_details is not None:
            result['strategy_details'] = self.strategy_details.to_map()
        if self.scene_infos is not None:
            result['scene_infos'] = self.scene_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('security_id') is not None:
            self.security_id = m.get('security_id')
        if m.get('security_result') is not None:
            self.security_result = m.get('security_result')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('verify_id') is not None:
            self.verify_id = m.get('verify_id')
        if m.get('verify_url') is not None:
            self.verify_url = m.get('verify_url')
        if m.get('model_details') is not None:
            temp_model = ModelDetails()
            self.model_details = temp_model.from_map(m['model_details'])
        if m.get('variable_details') is not None:
            temp_model = VariableDetails()
            self.variable_details = temp_model.from_map(m['variable_details'])
        if m.get('strategy_details') is not None:
            temp_model = StrategyDetails()
            self.strategy_details = temp_model.from_map(m['strategy_details'])
        if m.get('scene_infos') is not None:
            temp_model = SceneInfos()
            self.scene_infos = temp_model.from_map(m['scene_infos'])
        return self


class SendSecurityDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        security_content: str = None,
        security_sign: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 安全累计属性列表字段，安全属性列表
        self.security_content = security_content
        # 代码发送给安全核心的事件编码
        self.security_sign = security_sign

    def validate(self):
        self.validate_required(self.security_content, 'security_content')
        self.validate_required(self.security_sign, 'security_sign')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.security_content is not None:
            result['security_content'] = self.security_content
        if self.security_sign is not None:
            result['security_sign'] = self.security_sign
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('security_content') is not None:
            self.security_content = m.get('security_content')
        if m.get('security_sign') is not None:
            self.security_sign = m.get('security_sign')
        return self


class SendSecurityDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ConfirmSecurityPolicyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        confirm_params: str = None,
        security_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 二次确认参数，防止篡改
        self.confirm_params = confirm_params
        # 代码发送给安全核心的事件编码
        self.security_id = security_id

    def validate(self):
        self.validate_required(self.confirm_params, 'confirm_params')
        self.validate_required(self.security_id, 'security_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.confirm_params is not None:
            result['confirm_params'] = self.confirm_params
        if self.security_id is not None:
            result['security_id'] = self.security_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('confirm_params') is not None:
            self.confirm_params = m.get('confirm_params')
        if m.get('security_id') is not None:
            self.security_id = m.get('security_id')
        return self


class ConfirmSecurityPolicyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CheckSecurityRdsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        rds_content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 输入大字段，具体见接入文档
        self.rds_content = rds_content

    def validate(self):
        self.validate_required(self.rds_content, 'rds_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.rds_content is not None:
            result['rds_content'] = self.rds_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('rds_content') is not None:
            self.rds_content = m.get('rds_content')
        return self


class CheckSecurityRdsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.result = result

    def validate(self):
        self.validate_required(self.result, 'result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QuerySecurityDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        req_info: List[SecurityDataQueryStruct] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.req_info = req_info

    def validate(self):
        self.validate_required(self.req_info, 'req_info')
        if self.req_info:
            for k in self.req_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        result['req_info'] = []
        if self.req_info is not None:
            for k in self.req_info:
                result['req_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        self.req_info = []
        if m.get('req_info') is not None:
            for k in m.get('req_info'):
                temp_model = SecurityDataQueryStruct()
                self.req_info.append(temp_model.from_map(k))
        return self


class QuerySecurityDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CheckSecurityDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        req_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 入参为Map转换后的String
        self.req_info = req_info

    def validate(self):
        self.validate_required(self.req_info, 'req_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.req_info is not None:
            result['req_info'] = self.req_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('req_info') is not None:
            self.req_info = m.get('req_info')
        return self


class CheckSecurityDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        response: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # code表示状态，message为提示，data为返回结果
        self.response = response

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.response is not None:
            result['response'] = self.response
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('response') is not None:
            self.response = m.get('response')
        return self


class ExecSecurityRiskdataserviceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        event_info: str = None,
        risk_data_serviace_apply_id: str = None,
        risk_data_service_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 风险数据服务请求事件属性详情
        self.event_info = event_info
        # 反欺诈数据服务查询请求唯一凭证，为申请成功后得到，当请求类型是query时必填
        self.risk_data_serviace_apply_id = risk_data_serviace_apply_id
        # 反欺诈风险数据服务请求类型（query or apply）
        self.risk_data_service_type = risk_data_service_type

    def validate(self):
        self.validate_required(self.event_info, 'event_info')
        self.validate_required(self.risk_data_service_type, 'risk_data_service_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.event_info is not None:
            result['event_info'] = self.event_info
        if self.risk_data_serviace_apply_id is not None:
            result['risk_data_serviace_apply_id'] = self.risk_data_serviace_apply_id
        if self.risk_data_service_type is not None:
            result['risk_data_service_type'] = self.risk_data_service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('event_info') is not None:
            self.event_info = m.get('event_info')
        if m.get('risk_data_serviace_apply_id') is not None:
            self.risk_data_serviace_apply_id = m.get('risk_data_serviace_apply_id')
        if m.get('risk_data_service_type') is not None:
            self.risk_data_service_type = m.get('risk_data_service_type')
        return self


class ExecSecurityRiskdataserviceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        risk_data_service_apply_id: str = None,
        risk_infos: List[RiskInfo] = None,
        security_id: str = None,
        security_result_infos: SecurityResultInfos = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 反欺诈风险数据服务申请成功时返回的查询凭证（申请请求时存在）
        self.risk_data_service_apply_id = risk_data_service_apply_id
        # 反欺诈风险数据服务查询请求结果中风险详细信息字段（查询请求时存在）
        self.risk_infos = risk_infos
        # 请求响应业务唯一id
        self.security_id = security_id
        # 反欺诈风险数据服务查询成功时得到风险建议结果信息（查询请求时存在）
        self.security_result_infos = security_result_infos
        # 请求是否成功
        self.success = success

    def validate(self):
        if self.risk_infos:
            for k in self.risk_infos:
                if k:
                    k.validate()
        if self.security_result_infos:
            self.security_result_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.risk_data_service_apply_id is not None:
            result['risk_data_service_apply_id'] = self.risk_data_service_apply_id
        result['risk_infos'] = []
        if self.risk_infos is not None:
            for k in self.risk_infos:
                result['risk_infos'].append(k.to_map() if k else None)
        if self.security_id is not None:
            result['security_id'] = self.security_id
        if self.security_result_infos is not None:
            result['security_result_infos'] = self.security_result_infos.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('risk_data_service_apply_id') is not None:
            self.risk_data_service_apply_id = m.get('risk_data_service_apply_id')
        self.risk_infos = []
        if m.get('risk_infos') is not None:
            for k in m.get('risk_infos'):
                temp_model = RiskInfo()
                self.risk_infos.append(temp_model.from_map(k))
        if m.get('security_id') is not None:
            self.security_id = m.get('security_id')
        if m.get('security_result_infos') is not None:
            temp_model = SecurityResultInfos()
            self.security_result_infos = temp_model.from_map(m['security_result_infos'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QuerySaasSecurityPolicyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        event_info: EventInfo = None,
        risk_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 风控事件咨询查询入参
        self.event_info = event_info
        # 请求处理方式
        self.risk_type = risk_type

    def validate(self):
        self.validate_required(self.event_info, 'event_info')
        if self.event_info:
            self.event_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.event_info is not None:
            result['event_info'] = self.event_info.to_map()
        if self.risk_type is not None:
            result['risk_type'] = self.risk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('event_info') is not None:
            temp_model = EventInfo()
            self.event_info = temp_model.from_map(m['event_info'])
        if m.get('risk_type') is not None:
            self.risk_type = m.get('risk_type')
        return self


class QuerySaasSecurityPolicyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        model_details: List[ModelDetails] = None,
        security_id: str = None,
        security_result: str = None,
        strategy_details: List[StrategyDetails] = None,
        df_scene_infos: List[DfSceneInfos] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 场景分
        self.model_details = model_details
        # 安全请求id
        self.security_id = security_id
        # 策略结果
        self.security_result = security_result
        # 策略结果详情
        self.strategy_details = strategy_details
        # 决策流信息
        self.df_scene_infos = df_scene_infos

    def validate(self):
        if self.model_details:
            for k in self.model_details:
                if k:
                    k.validate()
        if self.strategy_details:
            for k in self.strategy_details:
                if k:
                    k.validate()
        if self.df_scene_infos:
            for k in self.df_scene_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['model_details'] = []
        if self.model_details is not None:
            for k in self.model_details:
                result['model_details'].append(k.to_map() if k else None)
        if self.security_id is not None:
            result['security_id'] = self.security_id
        if self.security_result is not None:
            result['security_result'] = self.security_result
        result['strategy_details'] = []
        if self.strategy_details is not None:
            for k in self.strategy_details:
                result['strategy_details'].append(k.to_map() if k else None)
        result['df_scene_infos'] = []
        if self.df_scene_infos is not None:
            for k in self.df_scene_infos:
                result['df_scene_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.model_details = []
        if m.get('model_details') is not None:
            for k in m.get('model_details'):
                temp_model = ModelDetails()
                self.model_details.append(temp_model.from_map(k))
        if m.get('security_id') is not None:
            self.security_id = m.get('security_id')
        if m.get('security_result') is not None:
            self.security_result = m.get('security_result')
        self.strategy_details = []
        if m.get('strategy_details') is not None:
            for k in m.get('strategy_details'):
                temp_model = StrategyDetails()
                self.strategy_details.append(temp_model.from_map(k))
        self.df_scene_infos = []
        if m.get('df_scene_infos') is not None:
            for k in m.get('df_scene_infos'):
                temp_model = DfSceneInfos()
                self.df_scene_infos.append(temp_model.from_map(k))
        return self


class QueryBatchSecurityPolicyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        event_code: str = None,
        query_keys: List[str] = None,
        query_key_type: str = None,
        event_info: List[EventInfo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 请求事件编码
        self.event_code = event_code
        # 查询客户主体
        self.query_keys = query_keys
        # 用户凭证类型, 手机号/身份证号/加密类型等
        self.query_key_type = query_key_type
        # 额外的事件属性
        self.event_info = event_info

    def validate(self):
        self.validate_required(self.event_code, 'event_code')
        self.validate_required(self.query_keys, 'query_keys')
        self.validate_required(self.query_key_type, 'query_key_type')
        self.validate_required(self.event_info, 'event_info')
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.event_code is not None:
            result['event_code'] = self.event_code
        if self.query_keys is not None:
            result['query_keys'] = self.query_keys
        if self.query_key_type is not None:
            result['query_key_type'] = self.query_key_type
        result['event_info'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['event_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('event_code') is not None:
            self.event_code = m.get('event_code')
        if m.get('query_keys') is not None:
            self.query_keys = m.get('query_keys')
        if m.get('query_key_type') is not None:
            self.query_key_type = m.get('query_key_type')
        self.event_info = []
        if m.get('event_info') is not None:
            for k in m.get('event_info'):
                temp_model = EventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryBatchSecurityPolicyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        query_results: List[BatchQueryResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果是否成功
        self.success = success
        # 批量查询结果
        self.query_results = query_results

    def validate(self):
        if self.query_results:
            for k in self.query_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        result['query_results'] = []
        if self.query_results is not None:
            for k in self.query_results:
                result['query_results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.query_results = []
        if m.get('query_results') is not None:
            for k in m.get('query_results'):
                temp_model = BatchQueryResult()
                self.query_results.append(temp_model.from_map(k))
        return self


class QueryCreditshieldProductBatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        query_code: str = None,
        query_infos: List[QueryInfo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询编码：
        # 1.还款概率评估
        # 2.经济波动检测
        # 3.触达前筛
        self.query_code = query_code
        # 查询信息集合
        self.query_infos = query_infos

    def validate(self):
        self.validate_required(self.query_code, 'query_code')
        if self.query_infos:
            for k in self.query_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.query_code is not None:
            result['query_code'] = self.query_code
        result['query_infos'] = []
        if self.query_infos is not None:
            for k in self.query_infos:
                result['query_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('query_code') is not None:
            self.query_code = m.get('query_code')
        self.query_infos = []
        if m.get('query_infos') is not None:
            for k in m.get('query_infos'):
                temp_model = QueryInfo()
                self.query_infos.append(temp_model.from_map(k))
        return self


class QueryCreditshieldProductBatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
        query_results: List[QueryResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果是否成功
        self.success = success
        # 查询结果
        self.query_results = query_results

    def validate(self):
        if self.query_results:
            for k in self.query_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        result['query_results'] = []
        if self.query_results is not None:
            for k in self.query_results:
                result['query_results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        self.query_results = []
        if m.get('query_results') is not None:
            for k in m.get('query_results'):
                temp_model = QueryResult()
                self.query_results.append(temp_model.from_map(k))
        return self


class QueryDubheTestRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        testid: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 测试id字段
        self.testid = testid

    def validate(self):
        self.validate_required(self.testid, 'testid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.testid is not None:
            result['testid'] = self.testid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('testid') is not None:
            self.testid = m.get('testid')
        return self


class QueryDubheTestResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        test_response_str: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 测试返回体
        self.test_response_str = test_response_str

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.test_response_str is not None:
            result['test_response_str'] = self.test_response_str
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('test_response_str') is not None:
            self.test_response_str = m.get('test_response_str')
        return self


class QueryDubheRouterFundrouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        card_no: str = None,
        mobile: str = None,
        custom_name: str = None,
        prod_no: str = None,
        channel_type: str = None,
        custom_type: str = None,
        traffic_platform: str = None,
        traffic_source_name: str = None,
        traffic_ad_id: str = None,
        traffic_mkt_id: str = None,
        click_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 身份证号(md5加密32位)
        self.card_no = card_no
        # 手机号（MD5加密，32位）
        self.mobile = mobile
        # 客户姓名
        self.custom_name = custom_name
        # 合作方产品编号
        self.prod_no = prod_no
        # 渠道类型
        self.channel_type = channel_type
        # 客户类型
        self.custom_type = custom_type
        # 导流平台
        self.traffic_platform = traffic_platform
        # 流量名称
        self.traffic_source_name = traffic_source_name
        # 广告位标志
        self.traffic_ad_id = traffic_ad_id
        # 预留
        self.traffic_mkt_id = traffic_mkt_id
        # 预留
        self.click_id = click_id

    def validate(self):
        self.validate_required(self.card_no, 'card_no')
        self.validate_required(self.mobile, 'mobile')
        self.validate_required(self.custom_name, 'custom_name')
        self.validate_required(self.prod_no, 'prod_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        if self.traffic_platform is not None:
            result['traffic_platform'] = self.traffic_platform
        if self.traffic_source_name is not None:
            result['traffic_source_name'] = self.traffic_source_name
        if self.traffic_ad_id is not None:
            result['traffic_ad_id'] = self.traffic_ad_id
        if self.traffic_mkt_id is not None:
            result['traffic_mkt_id'] = self.traffic_mkt_id
        if self.click_id is not None:
            result['click_id'] = self.click_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        if m.get('traffic_platform') is not None:
            self.traffic_platform = m.get('traffic_platform')
        if m.get('traffic_source_name') is not None:
            self.traffic_source_name = m.get('traffic_source_name')
        if m.get('traffic_ad_id') is not None:
            self.traffic_ad_id = m.get('traffic_ad_id')
        if m.get('traffic_mkt_id') is not None:
            self.traffic_mkt_id = m.get('traffic_mkt_id')
        if m.get('click_id') is not None:
            self.click_id = m.get('click_id')
        return self


class QueryDubheRouterFundrouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        fund_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 资金方代码
        self.fund_code = fund_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        return self


class ApplyDubheCreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        personal_info: PersonalInfo = None,
        open_id: str = None,
        order_no: str = None,
        borrower_live_info: LiveInfo = None,
        borrower_emp_info: JobInfo = None,
        prod_no: str = None,
        risk_data: RiskData = None,
        loan_reason: str = None,
        materials: List[Material] = None,
        traffic_platform: str = None,
        traffic_source_name: str = None,
        traffic_ad_id: str = None,
        traffic_mkt_id: str = None,
        click_id: str = None,
        channel_type: str = None,
        custom_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 基础信息
        self.personal_info = personal_info
        # 资产方用户唯一标识
        self.open_id = open_id
        # 订单号
        self.order_no = order_no
        # 居住信息
        self.borrower_live_info = borrower_live_info
        # 工作信息
        self.borrower_emp_info = borrower_emp_info
        # 产品编号
        self.prod_no = prod_no
        # 风险数据对象
        self.risk_data = risk_data
        # 借款用途
        self.loan_reason = loan_reason
        # 资料文件
        self.materials = materials
        # 导流平台
        self.traffic_platform = traffic_platform
        # 流量名称
        self.traffic_source_name = traffic_source_name
        # 广告位标志
        self.traffic_ad_id = traffic_ad_id
        # 预留
        self.traffic_mkt_id = traffic_mkt_id
        # 预留
        self.click_id = click_id
        # 渠道类型
        self.channel_type = channel_type
        # 客户类型
        self.custom_type = custom_type

    def validate(self):
        self.validate_required(self.personal_info, 'personal_info')
        if self.personal_info:
            self.personal_info.validate()
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.order_no, 'order_no')
        if self.borrower_live_info:
            self.borrower_live_info.validate()
        if self.borrower_emp_info:
            self.borrower_emp_info.validate()
        self.validate_required(self.prod_no, 'prod_no')
        if self.risk_data:
            self.risk_data.validate()
        if self.materials:
            for k in self.materials:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.personal_info is not None:
            result['personal_info'] = self.personal_info.to_map()
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.borrower_live_info is not None:
            result['borrower_live_info'] = self.borrower_live_info.to_map()
        if self.borrower_emp_info is not None:
            result['borrower_emp_info'] = self.borrower_emp_info.to_map()
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.risk_data is not None:
            result['risk_data'] = self.risk_data.to_map()
        if self.loan_reason is not None:
            result['loan_reason'] = self.loan_reason
        result['materials'] = []
        if self.materials is not None:
            for k in self.materials:
                result['materials'].append(k.to_map() if k else None)
        if self.traffic_platform is not None:
            result['traffic_platform'] = self.traffic_platform
        if self.traffic_source_name is not None:
            result['traffic_source_name'] = self.traffic_source_name
        if self.traffic_ad_id is not None:
            result['traffic_ad_id'] = self.traffic_ad_id
        if self.traffic_mkt_id is not None:
            result['traffic_mkt_id'] = self.traffic_mkt_id
        if self.click_id is not None:
            result['click_id'] = self.click_id
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('personal_info') is not None:
            temp_model = PersonalInfo()
            self.personal_info = temp_model.from_map(m['personal_info'])
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('borrower_live_info') is not None:
            temp_model = LiveInfo()
            self.borrower_live_info = temp_model.from_map(m['borrower_live_info'])
        if m.get('borrower_emp_info') is not None:
            temp_model = JobInfo()
            self.borrower_emp_info = temp_model.from_map(m['borrower_emp_info'])
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('risk_data') is not None:
            temp_model = RiskData()
            self.risk_data = temp_model.from_map(m['risk_data'])
        if m.get('loan_reason') is not None:
            self.loan_reason = m.get('loan_reason')
        self.materials = []
        if m.get('materials') is not None:
            for k in m.get('materials'):
                temp_model = Material()
                self.materials.append(temp_model.from_map(k))
        if m.get('traffic_platform') is not None:
            self.traffic_platform = m.get('traffic_platform')
        if m.get('traffic_source_name') is not None:
            self.traffic_source_name = m.get('traffic_source_name')
        if m.get('traffic_ad_id') is not None:
            self.traffic_ad_id = m.get('traffic_ad_id')
        if m.get('traffic_mkt_id') is not None:
            self.traffic_mkt_id = m.get('traffic_mkt_id')
        if m.get('click_id') is not None:
            self.click_id = m.get('click_id')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        return self


class ApplyDubheCreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        custom_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户编号
        self.custom_no = custom_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        return self


class QueryDubheCreditStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class QueryDubheCreditStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
        msg: str = None,
        credit_amt: int = None,
        period: int = None,
        repay_type: str = None,
        credit_info: CreditAmount = None,
        custom_no: str = None,
        apply_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信状态（0-通过/1-不通过2-处理中）
        self.status = status
        # 拒绝原因
        self.msg = msg
        # 授信额度
        self.credit_amt = credit_amt
        # 期数
        self.period = period
        # 还款方式
        self.repay_type = repay_type
        # 额度信息
        self.credit_info = credit_info
        # 客户编号(该客户的唯一标识，后续接口需要用到)
        self.custom_no = custom_no
        # 授信申请编号
        self.apply_no = apply_no

    def validate(self):
        if self.credit_info:
            self.credit_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        if self.msg is not None:
            result['msg'] = self.msg
        if self.credit_amt is not None:
            result['credit_amt'] = self.credit_amt
        if self.period is not None:
            result['period'] = self.period
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.credit_info is not None:
            result['credit_info'] = self.credit_info.to_map()
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.apply_no is not None:
            result['apply_no'] = self.apply_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('credit_amt') is not None:
            self.credit_amt = m.get('credit_amt')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('credit_info') is not None:
            temp_model = CreditAmount()
            self.credit_info = temp_model.from_map(m['credit_info'])
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('apply_no') is not None:
            self.apply_no = m.get('apply_no')
        return self


class CountDubheRepayReftrialRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
        prod_no: str = None,
        apply_amount: int = None,
        apply_period: int = None,
        repay_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 产品编号
        self.prod_no = prod_no
        # 借款金额
        self.apply_amount = apply_amount
        # 借款期数
        self.apply_period = apply_period
        # 还款方式
        self.repay_type = repay_type

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.prod_no, 'prod_no')
        self.validate_required(self.apply_amount, 'apply_amount')
        self.validate_required(self.apply_period, 'apply_period')
        self.validate_required(self.repay_type, 'repay_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.apply_amount is not None:
            result['apply_amount'] = self.apply_amount
        if self.apply_period is not None:
            result['apply_period'] = self.apply_period
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('apply_amount') is not None:
            self.apply_amount = m.get('apply_amount')
        if m.get('apply_period') is not None:
            self.apply_period = m.get('apply_period')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        return self


class CountDubheRepayReftrialResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_ref_list: List[RepayRef] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款计划试算结果
        self.repay_ref_list = repay_ref_list

    def validate(self):
        if self.repay_ref_list:
            for k in self.repay_ref_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['repay_ref_list'] = []
        if self.repay_ref_list is not None:
            for k in self.repay_ref_list:
                result['repay_ref_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.repay_ref_list = []
        if m.get('repay_ref_list') is not None:
            for k in m.get('repay_ref_list'):
                temp_model = RepayRef()
                self.repay_ref_list.append(temp_model.from_map(k))
        return self


class QueryDubheRepayListRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 用信申请订单号
        self.original_order_no = original_order_no

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        return self


class QueryDubheRepayListResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_ref_list: List[RepayRef] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款计划查询结果
        self.repay_ref_list = repay_ref_list

    def validate(self):
        if self.repay_ref_list:
            for k in self.repay_ref_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['repay_ref_list'] = []
        if self.repay_ref_list is not None:
            for k in self.repay_ref_list:
                result['repay_ref_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.repay_ref_list = []
        if m.get('repay_ref_list') is not None:
            for k in m.get('repay_ref_list'):
                temp_model = RepayRef()
                self.repay_ref_list.append(temp_model.from_map(k))
        return self


class ApplyDubheUsecreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        loan_amount: int = None,
        period: int = None,
        open_id: str = None,
        order_on: str = None,
        repay_type: str = None,
        loan_way: str = None,
        channel_type: str = None,
        custom_type: str = None,
        repay_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 用信金额
        self.loan_amount = loan_amount
        # 期数
        self.period = period
        # 资产方用户唯一标识
        self.open_id = open_id
        # 订单号
        self.order_on = order_on
        # 还款方式
        self.repay_type = repay_type
        # 1：手机数码 2：旅游 3：装修 4：教育 5：婚庆 6：租房 7：家具家居 8：健康医疗 9：其他消费 10：家用电器
        self.loan_way = loan_way
        # 1: APP
        # 2: 支付宝小程序
        # 3：微信小程序
        # 4：微信公众号
        # 5：PC网页
        # 默认1
        self.channel_type = channel_type
        # 1: 新增客户
        # 2：存量激活客户
        # 3：目标营销客户
        # 默认1
        self.custom_type = custom_type
        # 指定还款日（仅无在贷借据时生效）
        self.repay_date = repay_date

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.loan_amount, 'loan_amount')
        self.validate_required(self.period, 'period')
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.order_on, 'order_on')
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.loan_way, 'loan_way')
        self.validate_required(self.channel_type, 'channel_type')
        self.validate_required(self.custom_type, 'custom_type')
        self.validate_required(self.repay_date, 'repay_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.loan_amount is not None:
            result['loan_amount'] = self.loan_amount
        if self.period is not None:
            result['period'] = self.period
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.order_on is not None:
            result['order_on'] = self.order_on
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.loan_way is not None:
            result['loan_way'] = self.loan_way
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('loan_amount') is not None:
            self.loan_amount = m.get('loan_amount')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('order_on') is not None:
            self.order_on = m.get('order_on')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('loan_way') is not None:
            self.loan_way = m.get('loan_way')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        return self


class ApplyDubheUsecreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDubheUsecreditStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        order_on: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用信申请订单号
        self.original_order_no = original_order_no
        # 请求网络流水号
        self.order_on = order_on

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.order_on, 'order_on')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.order_on is not None:
            result['order_on'] = self.order_on
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('order_on') is not None:
            self.order_on = m.get('order_on')
        return self


class QueryDubheUsecreditStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
        msg: str = None,
        receipt_info: ReceiptInfo = None,
        repay_ref: List[RepayRef] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用信状态（0-通过/1-不通过2-处理中）
        self.status = status
        # 拒绝原因
        self.msg = msg
        # 借据信息
        self.receipt_info = receipt_info
        # 还款计划列表
        self.repay_ref = repay_ref

    def validate(self):
        if self.receipt_info:
            self.receipt_info.validate()
        if self.repay_ref:
            for k in self.repay_ref:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        if self.msg is not None:
            result['msg'] = self.msg
        if self.receipt_info is not None:
            result['receipt_info'] = self.receipt_info.to_map()
        result['repay_ref'] = []
        if self.repay_ref is not None:
            for k in self.repay_ref:
                result['repay_ref'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('receipt_info') is not None:
            temp_model = ReceiptInfo()
            self.receipt_info = temp_model.from_map(m['receipt_info'])
        self.repay_ref = []
        if m.get('repay_ref') is not None:
            for k in m.get('repay_ref'):
                temp_model = RepayRef()
                self.repay_ref.append(temp_model.from_map(k))
        return self


class CountDubheRepayTrialRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        repay_type: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用信申请订单号
        self.original_order_no = original_order_no
        # 还款类型1:当期结清，2：正常还款3：全部结清
        self.repay_type = repay_type
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class CountDubheRepayTrialResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        real_principal: int = None,
        real_interest: int = None,
        real_over_amt: int = None,
        service_charge: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款本金
        self.real_principal = real_principal
        # 还款利息
        self.real_interest = real_interest
        # 还款费用
        self.real_over_amt = real_over_amt
        # 服务费
        self.service_charge = service_charge

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.real_principal is not None:
            result['real_principal'] = self.real_principal
        if self.real_interest is not None:
            result['real_interest'] = self.real_interest
        if self.real_over_amt is not None:
            result['real_over_amt'] = self.real_over_amt
        if self.service_charge is not None:
            result['service_charge'] = self.service_charge
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('real_principal') is not None:
            self.real_principal = m.get('real_principal')
        if m.get('real_interest') is not None:
            self.real_interest = m.get('real_interest')
        if m.get('real_over_amt') is not None:
            self.real_over_amt = m.get('real_over_amt')
        if m.get('service_charge') is not None:
            self.service_charge = m.get('service_charge')
        return self


class RepayDubheRepayCheckstandRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        repay_type: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用信申请订单号
        self.original_order_no = original_order_no
        # 还款类型1:当期结清，2：正常还款3：全部结清
        self.repay_type = repay_type
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.repay_type, 'repay_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class RepayDubheRepayCheckstandResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        checkstand_address: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 收银台地址(成功就有值)
        self.checkstand_address = checkstand_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.checkstand_address is not None:
            result['checkstand_address'] = self.checkstand_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('checkstand_address') is not None:
            self.checkstand_address = m.get('checkstand_address')
        return self


class QueryDubheRepayInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 原还款订单号
        self.original_order_no = original_order_no
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class QueryDubheRepayInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_no: str = None,
        receipt_no: str = None,
        custom_no: str = None,
        custom_name: str = None,
        repay_type: str = None,
        repay_sign: str = None,
        repay_date: str = None,
        repay_amount: int = None,
        repay_principal: int = None,
        repay_interest: int = None,
        channel_amt: int = None,
        repay_fee: str = None,
        repay_punish: int = None,
        repay_account: str = None,
        repay_account_name: str = None,
        repay_mobile: str = None,
        repay_bank_no: str = None,
        repay_bank_name: str = None,
        repay_status: str = None,
        fail_reason: str = None,
        apply_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款编号
        self.repay_no = repay_no
        # 借据编码
        self.receipt_no = receipt_no
        # 客户编号
        self.custom_no = custom_no
        # 客户名称
        self.custom_name = custom_name
        # 还款类型1:提前还款，2：正常还款 3:批量还款 4：自由还款
        self.repay_type = repay_type
        # 还款标志1 线下还款 2 用户主动还款 3 系统代扣
        self.repay_sign = repay_sign
        # 还款日期
        self.repay_date = repay_date
        # 实还总额
        self.repay_amount = repay_amount
        # 实还本金
        self.repay_principal = repay_principal
        # 实还利息
        self.repay_interest = repay_interest
        # 实还通道手续费
        self.channel_amt = channel_amt
        # 实还手续费
        self.repay_fee = repay_fee
        # 实收罚息
        self.repay_punish = repay_punish
        # 还款账户
        self.repay_account = repay_account
        # 还款账户名称
        self.repay_account_name = repay_account_name
        # 还款账户的手机号
        self.repay_mobile = repay_mobile
        # 还款账户银行行号
        self.repay_bank_no = repay_bank_no
        # 还款账户银行名称
        self.repay_bank_name = repay_bank_name
        # 还款状态0:失败 1成功 2-审批中 3-还款中
        self.repay_status = repay_status
        # 失败原因
        self.fail_reason = fail_reason
        # 授信申请编号
        self.apply_no = apply_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.repay_no is not None:
            result['repay_no'] = self.repay_no
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.repay_sign is not None:
            result['repay_sign'] = self.repay_sign
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.repay_amount is not None:
            result['repay_amount'] = self.repay_amount
        if self.repay_principal is not None:
            result['repay_principal'] = self.repay_principal
        if self.repay_interest is not None:
            result['repay_interest'] = self.repay_interest
        if self.channel_amt is not None:
            result['channel_amt'] = self.channel_amt
        if self.repay_fee is not None:
            result['repay_fee'] = self.repay_fee
        if self.repay_punish is not None:
            result['repay_punish'] = self.repay_punish
        if self.repay_account is not None:
            result['repay_account'] = self.repay_account
        if self.repay_account_name is not None:
            result['repay_account_name'] = self.repay_account_name
        if self.repay_mobile is not None:
            result['repay_mobile'] = self.repay_mobile
        if self.repay_bank_no is not None:
            result['repay_bank_no'] = self.repay_bank_no
        if self.repay_bank_name is not None:
            result['repay_bank_name'] = self.repay_bank_name
        if self.repay_status is not None:
            result['repay_status'] = self.repay_status
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        if self.apply_no is not None:
            result['apply_no'] = self.apply_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('repay_no') is not None:
            self.repay_no = m.get('repay_no')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('repay_sign') is not None:
            self.repay_sign = m.get('repay_sign')
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('repay_amount') is not None:
            self.repay_amount = m.get('repay_amount')
        if m.get('repay_principal') is not None:
            self.repay_principal = m.get('repay_principal')
        if m.get('repay_interest') is not None:
            self.repay_interest = m.get('repay_interest')
        if m.get('channel_amt') is not None:
            self.channel_amt = m.get('channel_amt')
        if m.get('repay_fee') is not None:
            self.repay_fee = m.get('repay_fee')
        if m.get('repay_punish') is not None:
            self.repay_punish = m.get('repay_punish')
        if m.get('repay_account') is not None:
            self.repay_account = m.get('repay_account')
        if m.get('repay_account_name') is not None:
            self.repay_account_name = m.get('repay_account_name')
        if m.get('repay_mobile') is not None:
            self.repay_mobile = m.get('repay_mobile')
        if m.get('repay_bank_no') is not None:
            self.repay_bank_no = m.get('repay_bank_no')
        if m.get('repay_bank_name') is not None:
            self.repay_bank_name = m.get('repay_bank_name')
        if m.get('repay_status') is not None:
            self.repay_status = m.get('repay_status')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        if m.get('apply_no') is not None:
            self.apply_no = m.get('apply_no')
        return self


class UpdateDubheCustomerInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        custom_name: str = None,
        census_register: str = None,
        card_no: str = None,
        mobile: str = None,
        custom_no: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户姓名(可修改字段)
        self.custom_name = custom_name
        # 户籍所在地(可修改字段)
        self.census_register = census_register
        # 证件号码(可修改字段)
        self.card_no = card_no
        # 手机号码(可修改字段)
        self.mobile = mobile
        # 客户编号(唯一不变)
        self.custom_no = custom_no
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.census_register is not None:
            result['census_register'] = self.census_register
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('census_register') is not None:
            self.census_register = m.get('census_register')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class UpdateDubheCustomerInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ApplyDubheCustomerAgreementsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        custom_no: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户编号
        self.custom_no = custom_no
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class ApplyDubheCustomerAgreementsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        sdk_params: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # sdkParams返回给商户app客户端，作为客户端唤起sdk的入参
        self.sdk_params = sdk_params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.sdk_params is not None:
            result['sdk_params'] = self.sdk_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('sdk_params') is not None:
            self.sdk_params = m.get('sdk_params')
        return self


class QueryDubheCustomerAgreementsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        custom_no: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户编号
        self.custom_no = custom_no
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class QueryDubheCustomerAgreementsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        custom_no: str = None,
        trans_serials: str = None,
        status: str = None,
        sign_time: str = None,
        valid_time: str = None,
        invalid_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户编号
        self.custom_no = custom_no
        # 流水号(代扣协议中标示用户的唯一签约号)
        self.trans_serials = trans_serials
        # 协议签约状态(0-成功1-失败2-处理中)
        self.status = status
        # 协议签约时间(支付宝代扣协议的实际签约时间，格式为yyyy-MM-dd HH:mm:ss)
        self.sign_time = sign_time
        # 协议生效时间(用户代扣协议的实际生效时间，格式为yyyy-MM-dd HH:mm:ss)
        self.valid_time = valid_time
        # 协议失效时间(用户代扣协议的失效时间，格式为yyyy-MM-dd HH:mm:ss)
        self.invalid_time = invalid_time

    def validate(self):
        if self.sign_time is not None:
            self.validate_pattern(self.sign_time, 'sign_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.valid_time is not None:
            self.validate_pattern(self.valid_time, 'valid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.invalid_time is not None:
            self.validate_pattern(self.invalid_time, 'invalid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.trans_serials is not None:
            result['trans_serials'] = self.trans_serials
        if self.status is not None:
            result['status'] = self.status
        if self.sign_time is not None:
            result['sign_time'] = self.sign_time
        if self.valid_time is not None:
            result['valid_time'] = self.valid_time
        if self.invalid_time is not None:
            result['invalid_time'] = self.invalid_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('trans_serials') is not None:
            self.trans_serials = m.get('trans_serials')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sign_time') is not None:
            self.sign_time = m.get('sign_time')
        if m.get('valid_time') is not None:
            self.valid_time = m.get('valid_time')
        if m.get('invalid_time') is not None:
            self.invalid_time = m.get('invalid_time')
        return self


class RepayDubheRepayWithholdRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        repay_type: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # originalOrderNo
        self.original_order_no = original_order_no
        # 还款类型1:当期结清，2：正常还款3：全部结清
        self.repay_type = repay_type
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class RepayDubheRepayWithholdResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDubheSearchContractRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 原用信订单号
        self.original_order_no = original_order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        return self


class QueryDubheSearchContractResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        relation_no: str = None,
        contract_no: str = None,
        contract_name: str = None,
        contract_type: str = None,
        custom_no: str = None,
        save_path: str = None,
        contract_amount: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 关联编号（授信/用信）
        self.relation_no = relation_no
        # 合同编号
        self.contract_no = contract_no
        # 合同名称
        self.contract_name = contract_name
        # 合同类型
        self.contract_type = contract_type
        # 客户编号
        self.custom_no = custom_no
        # 下载地址
        self.save_path = save_path
        # 合同金额
        self.contract_amount = contract_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.relation_no is not None:
            result['relation_no'] = self.relation_no
        if self.contract_no is not None:
            result['contract_no'] = self.contract_no
        if self.contract_name is not None:
            result['contract_name'] = self.contract_name
        if self.contract_type is not None:
            result['contract_type'] = self.contract_type
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.save_path is not None:
            result['save_path'] = self.save_path
        if self.contract_amount is not None:
            result['contract_amount'] = self.contract_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('relation_no') is not None:
            self.relation_no = m.get('relation_no')
        if m.get('contract_no') is not None:
            self.contract_no = m.get('contract_no')
        if m.get('contract_name') is not None:
            self.contract_name = m.get('contract_name')
        if m.get('contract_type') is not None:
            self.contract_type = m.get('contract_type')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('save_path') is not None:
            self.save_path = m.get('save_path')
        if m.get('contract_amount') is not None:
            self.contract_amount = m.get('contract_amount')
        return self


class QueryDubheReceiptOverdueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        contract_no: str = None,
        channel_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同编号
        self.contract_no = contract_no
        # 渠道号
        self.channel_code = channel_code

    def validate(self):
        self.validate_required(self.contract_no, 'contract_no')
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.contract_no is not None:
            result['contract_no'] = self.contract_no
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('contract_no') is not None:
            self.contract_no = m.get('contract_no')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        return self


class QueryDubheReceiptOverdueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: OverdueInfoResponse = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 逾期信息响应
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = OverdueInfoResponse()
            self.data = temp_model.from_map(m['data'])
        return self


class SendDubbridgeSmsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        phone_numbers: str = None,
        sign_name: str = None,
        template_code: str = None,
        template_param: str = None,
        sms_up_extend_code: str = None,
        out_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 接收短信的手机号码。支持对多个手机号码发送短信，手机号码之间以英文逗号（,）分隔。上限为1000个手机号码。批量调用相对于单条调用及时性稍有延迟。
        self.phone_numbers = phone_numbers
        # 短信签名
        self.sign_name = sign_name
        # 短信模板CODE
        self.template_code = template_code
        # 短信模板变量对应的值，JSON格式
        self.template_param = template_param
        # 上行短信扩展码
        self.sms_up_extend_code = sms_up_extend_code
        # 外部流水扩展
        self.out_id = out_id

    def validate(self):
        self.validate_required(self.phone_numbers, 'phone_numbers')
        self.validate_required(self.sign_name, 'sign_name')
        self.validate_required(self.template_code, 'template_code')
        self.validate_required(self.out_id, 'out_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.phone_numbers is not None:
            result['phone_numbers'] = self.phone_numbers
        if self.sign_name is not None:
            result['sign_name'] = self.sign_name
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.template_param is not None:
            result['template_param'] = self.template_param
        if self.sms_up_extend_code is not None:
            result['sms_up_extend_code'] = self.sms_up_extend_code
        if self.out_id is not None:
            result['out_id'] = self.out_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('phone_numbers') is not None:
            self.phone_numbers = m.get('phone_numbers')
        if m.get('sign_name') is not None:
            self.sign_name = m.get('sign_name')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('template_param') is not None:
            self.template_param = m.get('template_param')
        if m.get('sms_up_extend_code') is not None:
            self.sms_up_extend_code = m.get('sms_up_extend_code')
        if m.get('out_id') is not None:
            self.out_id = m.get('out_id')
        return self


class SendDubbridgeSmsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        response: SmsReponse = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 云通信发送结果
        self.response = response

    def validate(self):
        if self.response:
            self.response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.response is not None:
            result['response'] = self.response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('response') is not None:
            temp_model = SmsReponse()
            self.response = temp_model.from_map(m['response'])
        return self


class SendDubbridgeSmsBatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        template_code: str = None,
        phone_number_json: str = None,
        sign_name_json: str = None,
        template_param_json: str = None,
        sms_up_extend_code_json: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 短信模板code
        self.template_code = template_code
        # 接收短信的手机号码，JSON数组格式
        self.phone_number_json = phone_number_json
        # 短信签名名称，JSON数组格式
        self.sign_name_json = sign_name_json
        # 短信模板变量对应的实际值，JSON数组格式
        self.template_param_json = template_param_json
        # 上行短信扩展码，JSON数组格式。无特殊需要此字段的用户请忽略此字段
        self.sms_up_extend_code_json = sms_up_extend_code_json

    def validate(self):
        self.validate_required(self.template_code, 'template_code')
        self.validate_required(self.phone_number_json, 'phone_number_json')
        self.validate_required(self.sign_name_json, 'sign_name_json')
        self.validate_required(self.template_param_json, 'template_param_json')
        self.validate_required(self.sms_up_extend_code_json, 'sms_up_extend_code_json')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.phone_number_json is not None:
            result['phone_number_json'] = self.phone_number_json
        if self.sign_name_json is not None:
            result['sign_name_json'] = self.sign_name_json
        if self.template_param_json is not None:
            result['template_param_json'] = self.template_param_json
        if self.sms_up_extend_code_json is not None:
            result['sms_up_extend_code_json'] = self.sms_up_extend_code_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('phone_number_json') is not None:
            self.phone_number_json = m.get('phone_number_json')
        if m.get('sign_name_json') is not None:
            self.sign_name_json = m.get('sign_name_json')
        if m.get('template_param_json') is not None:
            self.template_param_json = m.get('template_param_json')
        if m.get('sms_up_extend_code_json') is not None:
            self.sms_up_extend_code_json = m.get('sms_up_extend_code_json')
        return self


class SendDubbridgeSmsBatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        response: SmsReponse = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 云通信短信发送结果
        self.response = response

    def validate(self):
        if self.response:
            self.response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.response is not None:
            result['response'] = self.response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('response') is not None:
            temp_model = SmsReponse()
            self.response = temp_model.from_map(m['response'])
        return self


class QueryDubbridgeRouterFundrouterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        prod_type: str = None,
        open_id: str = None,
        mobile: str = None,
        biz_order_no: str = None,
        card_no: str = None,
        custom_name: str = None,
        mobile_type: str = None,
        card_no_type: str = None,
        custom_name_type: str = None,
        channel_type: str = None,
        custom_type: str = None,
        prod_no: str = None,
        expired_platform_no: str = None,
        traffic_platform: str = None,
        traffic_source_name: str = None,
        traffic_ad_id: str = None,
        traffic_mkt_id: str = None,
        click_id: str = None,
        risk_data: str = None,
        ext_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 1：现金贷（默认）
        # 2：分期付
        self.prod_type = prod_type
        # 资产方用户唯一标识
        self.open_id = open_id
        # 手机号
        self.mobile = mobile
        # 资产方购物订单号，如二轮车/摩托车订单号；购物场景时传递
        self.biz_order_no = biz_order_no
        # 身份证号
        self.card_no = card_no
        # 姓名
        self.custom_name = custom_name
        # 默认：0
        # 0：明文
        # 1：md5
        self.mobile_type = mobile_type
        # 默认：0
        # 0：明文
        # 1：md5
        self.card_no_type = card_no_type
        # 默认：0
        # 0：明文
        # 1：md5
        self.custom_name_type = custom_name_type
        # 渠道类型
        self.channel_type = channel_type
        # 客户类型
        self.custom_type = custom_type
        # 合作方产品编号
        self.prod_no = prod_no
        # 授信过期的资金方编码
        self.expired_platform_no = expired_platform_no
        # 导流平台
        self.traffic_platform = traffic_platform
        # 流量名称
        self.traffic_source_name = traffic_source_name
        # 广告位标志
        self.traffic_ad_id = traffic_ad_id
        # 预留
        self.traffic_mkt_id = traffic_mkt_id
        # 预留
        self.click_id = click_id
        # 风险字段
        self.risk_data = risk_data
        # 扩展字段
        self.ext_info = ext_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.mobile_type is not None:
            result['mobile_type'] = self.mobile_type
        if self.card_no_type is not None:
            result['card_no_type'] = self.card_no_type
        if self.custom_name_type is not None:
            result['custom_name_type'] = self.custom_name_type
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.expired_platform_no is not None:
            result['expired_platform_no'] = self.expired_platform_no
        if self.traffic_platform is not None:
            result['traffic_platform'] = self.traffic_platform
        if self.traffic_source_name is not None:
            result['traffic_source_name'] = self.traffic_source_name
        if self.traffic_ad_id is not None:
            result['traffic_ad_id'] = self.traffic_ad_id
        if self.traffic_mkt_id is not None:
            result['traffic_mkt_id'] = self.traffic_mkt_id
        if self.click_id is not None:
            result['click_id'] = self.click_id
        if self.risk_data is not None:
            result['risk_data'] = self.risk_data
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('mobile_type') is not None:
            self.mobile_type = m.get('mobile_type')
        if m.get('card_no_type') is not None:
            self.card_no_type = m.get('card_no_type')
        if m.get('custom_name_type') is not None:
            self.custom_name_type = m.get('custom_name_type')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('expired_platform_no') is not None:
            self.expired_platform_no = m.get('expired_platform_no')
        if m.get('traffic_platform') is not None:
            self.traffic_platform = m.get('traffic_platform')
        if m.get('traffic_source_name') is not None:
            self.traffic_source_name = m.get('traffic_source_name')
        if m.get('traffic_ad_id') is not None:
            self.traffic_ad_id = m.get('traffic_ad_id')
        if m.get('traffic_mkt_id') is not None:
            self.traffic_mkt_id = m.get('traffic_mkt_id')
        if m.get('click_id') is not None:
            self.click_id = m.get('click_id')
        if m.get('risk_data') is not None:
            self.risk_data = m.get('risk_data')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        return self


class QueryDubbridgeRouterFundrouterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        fund_code: str = None,
        abbre_fund_name: str = None,
        customer_no: str = None,
        fund_list: List[GwFundRouterResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 资金方代码
        self.fund_code = fund_code
        # 资金方简称
        self.abbre_fund_name = abbre_fund_name
        # 客户编号
        self.customer_no = customer_no
        # 资金方列表
        self.fund_list = fund_list

    def validate(self):
        if self.fund_list:
            for k in self.fund_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.abbre_fund_name is not None:
            result['abbre_fund_name'] = self.abbre_fund_name
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        result['fund_list'] = []
        if self.fund_list is not None:
            for k in self.fund_list:
                result['fund_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('abbre_fund_name') is not None:
            self.abbre_fund_name = m.get('abbre_fund_name')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        self.fund_list = []
        if m.get('fund_list') is not None:
            for k in m.get('fund_list'):
                temp_model = GwFundRouterResult()
                self.fund_list.append(temp_model.from_map(k))
        return self


class ApplyDubbridgeCreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        personal_info: PersonalInfo = None,
        open_id: str = None,
        order_no: str = None,
        borrower_live_info: LiveInfo = None,
        borrower_emp_info: JobInfo = None,
        prod_no: str = None,
        risk_data: str = None,
        loan_reason: str = None,
        materials: List[Material] = None,
        traffic_platform: str = None,
        traffic_source_name: str = None,
        traffic_ad_id: str = None,
        traffic_mkt_id: str = None,
        click_id: str = None,
        channel_type: str = None,
        custom_type: str = None,
        fund_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 基础信息
        self.personal_info = personal_info
        # 资产方用户唯一标识
        self.open_id = open_id
        # 订单号
        self.order_no = order_no
        # 居住信息
        self.borrower_live_info = borrower_live_info
        # 工作信息
        self.borrower_emp_info = borrower_emp_info
        # 产品编号
        self.prod_no = prod_no
        # 风险数据对象json字符串
        self.risk_data = risk_data
        # 借款用途
        self.loan_reason = loan_reason
        # 资料文件
        self.materials = materials
        # 导流平台
        self.traffic_platform = traffic_platform
        # 流量名称
        self.traffic_source_name = traffic_source_name
        # 广告位标志
        self.traffic_ad_id = traffic_ad_id
        # 预留
        self.traffic_mkt_id = traffic_mkt_id
        # 预留
        self.click_id = click_id
        # 渠道类型
        self.channel_type = channel_type
        # 客户类型
        self.custom_type = custom_type
        # 资金方代码
        self.fund_code = fund_code

    def validate(self):
        self.validate_required(self.personal_info, 'personal_info')
        if self.personal_info:
            self.personal_info.validate()
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.order_no, 'order_no')
        if self.borrower_live_info:
            self.borrower_live_info.validate()
        if self.borrower_emp_info:
            self.borrower_emp_info.validate()
        self.validate_required(self.risk_data, 'risk_data')
        if self.materials:
            for k in self.materials:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.personal_info is not None:
            result['personal_info'] = self.personal_info.to_map()
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.borrower_live_info is not None:
            result['borrower_live_info'] = self.borrower_live_info.to_map()
        if self.borrower_emp_info is not None:
            result['borrower_emp_info'] = self.borrower_emp_info.to_map()
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.risk_data is not None:
            result['risk_data'] = self.risk_data
        if self.loan_reason is not None:
            result['loan_reason'] = self.loan_reason
        result['materials'] = []
        if self.materials is not None:
            for k in self.materials:
                result['materials'].append(k.to_map() if k else None)
        if self.traffic_platform is not None:
            result['traffic_platform'] = self.traffic_platform
        if self.traffic_source_name is not None:
            result['traffic_source_name'] = self.traffic_source_name
        if self.traffic_ad_id is not None:
            result['traffic_ad_id'] = self.traffic_ad_id
        if self.traffic_mkt_id is not None:
            result['traffic_mkt_id'] = self.traffic_mkt_id
        if self.click_id is not None:
            result['click_id'] = self.click_id
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('personal_info') is not None:
            temp_model = PersonalInfo()
            self.personal_info = temp_model.from_map(m['personal_info'])
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('borrower_live_info') is not None:
            temp_model = LiveInfo()
            self.borrower_live_info = temp_model.from_map(m['borrower_live_info'])
        if m.get('borrower_emp_info') is not None:
            temp_model = JobInfo()
            self.borrower_emp_info = temp_model.from_map(m['borrower_emp_info'])
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('risk_data') is not None:
            self.risk_data = m.get('risk_data')
        if m.get('loan_reason') is not None:
            self.loan_reason = m.get('loan_reason')
        self.materials = []
        if m.get('materials') is not None:
            for k in m.get('materials'):
                temp_model = Material()
                self.materials.append(temp_model.from_map(k))
        if m.get('traffic_platform') is not None:
            self.traffic_platform = m.get('traffic_platform')
        if m.get('traffic_source_name') is not None:
            self.traffic_source_name = m.get('traffic_source_name')
        if m.get('traffic_ad_id') is not None:
            self.traffic_ad_id = m.get('traffic_ad_id')
        if m.get('traffic_mkt_id') is not None:
            self.traffic_mkt_id = m.get('traffic_mkt_id')
        if m.get('click_id') is not None:
            self.click_id = m.get('click_id')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        return self


class ApplyDubbridgeCreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        custom_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户编号
        self.custom_no = custom_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        return self


class UploadDubbridgeFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        channel_code: str = None,
        file_name: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
        file_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 渠道号
        self.channel_code = channel_code
        # 文件名
        self.file_name = file_name
        # 文件id
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id
        # 文件类型
        self.file_type = file_type

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        if self.order_no is not None:
            self.validate_max_length(self.order_no, 'order_no', 32)
        self.validate_required(self.channel_code, 'channel_code')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.file_type, 'file_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_type is not None:
            result['file_type'] = self.file_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_type') is not None:
            self.file_type = m.get('file_type')
        return self


class UploadDubbridgeFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        file_info: DubheFileInfo = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 文件信息
        self.file_info = file_info

    def validate(self):
        if self.file_info:
            self.file_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.file_info is not None:
            result['file_info'] = self.file_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('file_info') is not None:
            temp_model = DubheFileInfo()
            self.file_info = temp_model.from_map(m['file_info'])
        return self


class BindDubbridgeCustomerBankcardRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        customer_no: str = None,
        bank_card_no: str = None,
        channel_code: str = None,
        custom_name: str = None,
        open_id: str = None,
        card_no: str = None,
        mobile: str = None,
        bank_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 客户编号
        self.customer_no = customer_no
        # 银行卡号
        self.bank_card_no = bank_card_no
        # 渠道描述，具体请见分配
        self.channel_code = channel_code
        # 客户名称
        self.custom_name = custom_name
        # 资产方用户唯一标识
        self.open_id = open_id
        # 身份证号
        self.card_no = card_no
        # 手机号
        self.mobile = mobile
        # 银行名称
        self.bank_name = bank_name

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.customer_no, 'customer_no')
        self.validate_required(self.bank_card_no, 'bank_card_no')
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.bank_card_no is not None:
            result['bank_card_no'] = self.bank_card_no
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('bank_card_no') is not None:
            self.bank_card_no = m.get('bank_card_no')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        return self


class BindDubbridgeCustomerBankcardResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        bind_serial_no: str = None,
        customer_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 绑卡流水
        self.bind_serial_no = bind_serial_no
        # 客户号
        self.customer_no = customer_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.bind_serial_no is not None:
            result['bind_serial_no'] = self.bind_serial_no
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('bind_serial_no') is not None:
            self.bind_serial_no = m.get('bind_serial_no')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        return self


class VerifyDubbridgeCustomerBankcardRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        customer_no: str = None,
        bind_serial_no: str = None,
        bind_valid_code: str = None,
        bank_card_no: str = None,
        channel_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 客户号
        self.customer_no = customer_no
        # 绑卡流水
        self.bind_serial_no = bind_serial_no
        # 绑卡验证码
        self.bind_valid_code = bind_valid_code
        # 银行卡号
        self.bank_card_no = bank_card_no
        # 渠道号
        self.channel_code = channel_code

    def validate(self):
        self.validate_required(self.bind_serial_no, 'bind_serial_no')
        self.validate_required(self.bind_valid_code, 'bind_valid_code')
        self.validate_required(self.bank_card_no, 'bank_card_no')
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.bind_serial_no is not None:
            result['bind_serial_no'] = self.bind_serial_no
        if self.bind_valid_code is not None:
            result['bind_valid_code'] = self.bind_valid_code
        if self.bank_card_no is not None:
            result['bank_card_no'] = self.bank_card_no
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('bind_serial_no') is not None:
            self.bind_serial_no = m.get('bind_serial_no')
        if m.get('bind_valid_code') is not None:
            self.bind_valid_code = m.get('bind_valid_code')
        if m.get('bank_card_no') is not None:
            self.bank_card_no = m.get('bank_card_no')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        return self


class VerifyDubbridgeCustomerBankcardResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        bind_serial_no: str = None,
        sign_result: str = None,
        customer_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 绑卡流水
        self.bind_serial_no = bind_serial_no
        # 签约结果
        self.sign_result = sign_result
        # 客户号
        self.customer_no = customer_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.bind_serial_no is not None:
            result['bind_serial_no'] = self.bind_serial_no
        if self.sign_result is not None:
            result['sign_result'] = self.sign_result
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('bind_serial_no') is not None:
            self.bind_serial_no = m.get('bind_serial_no')
        if m.get('sign_result') is not None:
            self.sign_result = m.get('sign_result')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        return self


class NotifyDubbridgeDefininnerchannelRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        seq_no: str = None,
        api_name: str = None,
        inst_member_code: str = None,
        biz_param: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用流水
        self.seq_no = seq_no
        # 机构平台接口名
        self.api_name = api_name
        # 机构编号
        self.inst_member_code = inst_member_code
        # 业务参数Json
        self.biz_param = biz_param

    def validate(self):
        self.validate_required(self.seq_no, 'seq_no')
        self.validate_required(self.api_name, 'api_name')
        self.validate_required(self.inst_member_code, 'inst_member_code')
        self.validate_required(self.biz_param, 'biz_param')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.seq_no is not None:
            result['seq_no'] = self.seq_no
        if self.api_name is not None:
            result['api_name'] = self.api_name
        if self.inst_member_code is not None:
            result['inst_member_code'] = self.inst_member_code
        if self.biz_param is not None:
            result['biz_param'] = self.biz_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('seq_no') is not None:
            self.seq_no = m.get('seq_no')
        if m.get('api_name') is not None:
            self.api_name = m.get('api_name')
        if m.get('inst_member_code') is not None:
            self.inst_member_code = m.get('inst_member_code')
        if m.get('biz_param') is not None:
            self.biz_param = m.get('biz_param')
        return self


class NotifyDubbridgeDefininnerchannelResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: DefinInnerChannelNotifyResult = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 处理结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = DefinInnerChannelNotifyResult()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDubbridgeCreditStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        order_no: str = None,
        open_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 订单号
        self.order_no = order_no
        # 三方客户id
        self.open_id = open_id

    def validate(self):
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        return self


class QueryDubbridgeCreditStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
        msg: str = None,
        credit_amt: int = None,
        period: int = None,
        repay_type: str = None,
        credit_info: CreditAmount = None,
        custom_no: str = None,
        apply_no: str = None,
        fund_code: str = None,
        cooling_period: str = None,
        loan_inst_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信状态（0-通过/1-不通过2-处理中）
        self.status = status
        # 拒绝原因
        self.msg = msg
        # 授信额度
        self.credit_amt = credit_amt
        # 期数
        self.period = period
        # 还款方式
        self.repay_type = repay_type
        # 额度信息
        self.credit_info = credit_info
        # 客户编号(该客户的唯一标识，后续接口需要用到)
        self.custom_no = custom_no
        # 授信申请编号
        self.apply_no = apply_no
        # 资金方编号
        self.fund_code = fund_code
        # 冷静期结束日期
        self.cooling_period = cooling_period
        # 资金源编码
        self.loan_inst_code = loan_inst_code

    def validate(self):
        if self.credit_info:
            self.credit_info.validate()
        if self.cooling_period is not None:
            self.validate_pattern(self.cooling_period, 'cooling_period', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        if self.msg is not None:
            result['msg'] = self.msg
        if self.credit_amt is not None:
            result['credit_amt'] = self.credit_amt
        if self.period is not None:
            result['period'] = self.period
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.credit_info is not None:
            result['credit_info'] = self.credit_info.to_map()
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.apply_no is not None:
            result['apply_no'] = self.apply_no
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.cooling_period is not None:
            result['cooling_period'] = self.cooling_period
        if self.loan_inst_code is not None:
            result['loan_inst_code'] = self.loan_inst_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('credit_amt') is not None:
            self.credit_amt = m.get('credit_amt')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('credit_info') is not None:
            temp_model = CreditAmount()
            self.credit_info = temp_model.from_map(m['credit_info'])
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('apply_no') is not None:
            self.apply_no = m.get('apply_no')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('cooling_period') is not None:
            self.cooling_period = m.get('cooling_period')
        if m.get('loan_inst_code') is not None:
            self.loan_inst_code = m.get('loan_inst_code')
        return self


class QueryDubbridgeRiskinfoEnterprisescoreRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        social_credit_code: str = None,
        mobile: str = None,
        customer_no: str = None,
        channel_code: str = None,
        mobile_md_5: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 统一信用代码
        self.social_credit_code = social_credit_code
        # 手机号
        self.mobile = mobile
        # 客户号
        self.customer_no = customer_no
        # 渠道号
        self.channel_code = channel_code
        # 手机号md5
        self.mobile_md_5 = mobile_md_5

    def validate(self):
        self.validate_required(self.social_credit_code, 'social_credit_code')
        self.validate_required(self.customer_no, 'customer_no')
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.social_credit_code is not None:
            result['social_credit_code'] = self.social_credit_code
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.mobile_md_5 is not None:
            result['mobile_md5'] = self.mobile_md_5
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('social_credit_code') is not None:
            self.social_credit_code = m.get('social_credit_code')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('mobile_md5') is not None:
            self.mobile_md_5 = m.get('mobile_md5')
        return self


class QueryDubbridgeRiskinfoEnterprisescoreResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        score: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 小微分
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class QueryDubbridgeRiskinfoCommonRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        query_id: str = None,
        id_type: str = None,
        open_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询id
        self.query_id = query_id
        # 查询id类型
        self.id_type = id_type
        # 用户id
        self.open_id = open_id

    def validate(self):
        self.validate_required(self.query_id, 'query_id')
        self.validate_required(self.id_type, 'id_type')
        self.validate_required(self.open_id, 'open_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.query_id is not None:
            result['query_id'] = self.query_id
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.open_id is not None:
            result['open_id'] = self.open_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('query_id') is not None:
            self.query_id = m.get('query_id')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        return self


class QueryDubbridgeRiskinfoCommonResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 风控信息Json字符串
        self.query_result = query_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.query_result is not None:
            result['query_result'] = self.query_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('query_result') is not None:
            self.query_result = m.get('query_result')
        return self


class UpdateDubbridgeInstitutionCreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        serial_no: str = None,
        credit_no: str = None,
        name: str = None,
        cert_no: str = None,
        apply_type: str = None,
        credit_amount: str = None,
        credit_rate: str = None,
        source: str = None,
        reason_code: str = None,
        reason_msg: str = None,
        ext_info_ts: str = None,
        ext_info: str = None,
        credit_expire_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 机构请求流水号，用于幂等。行方需确保唯一性
        self.serial_no = serial_no
        # 授信编号，授信申请时同申请单号一致，调额等操作同前授信申请时的授信编号一致
        self.credit_no = credit_no
        # 客户姓名
        self.name = name
        # 身份证号
        self.cert_no = cert_no
        # ADJUST_AMT_APPLY|ADJUST_RATE_APPLY|CLEAR_UP_APPLY|FROZEN_APPLY|UN_FROZEN_APPLY
        self.apply_type = apply_type
        # 基础固额-申请调整值，单位分，机构发起调额场景下有值
        self.credit_amount = credit_amount
        # 年利率-申请调整值，机构发起调价场景下有值
        self.credit_rate = credit_rate
        # 申请来源
        self.source = source
        # 机构申请原因码
        self.reason_code = reason_code
        # 机构发起原因描述
        self.reason_msg = reason_msg
        # 透传授信阶段天枢字段，json格式
        self.ext_info_ts = ext_info_ts
        # 扩展信息，json格式
        self.ext_info = ext_info
        # 授信有效期-申请调整值，机构发起授信有效期更新场景下有值
        self.credit_expire_date = credit_expire_date

    def validate(self):
        self.validate_required(self.serial_no, 'serial_no')
        self.validate_required(self.credit_no, 'credit_no')
        self.validate_required(self.name, 'name')
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.apply_type, 'apply_type')
        self.validate_required(self.source, 'source')
        self.validate_required(self.reason_code, 'reason_code')
        self.validate_required(self.reason_msg, 'reason_msg')
        self.validate_required(self.ext_info_ts, 'ext_info_ts')
        self.validate_required(self.ext_info, 'ext_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.serial_no is not None:
            result['serial_no'] = self.serial_no
        if self.credit_no is not None:
            result['credit_no'] = self.credit_no
        if self.name is not None:
            result['name'] = self.name
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.apply_type is not None:
            result['apply_type'] = self.apply_type
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.credit_rate is not None:
            result['credit_rate'] = self.credit_rate
        if self.source is not None:
            result['source'] = self.source
        if self.reason_code is not None:
            result['reason_code'] = self.reason_code
        if self.reason_msg is not None:
            result['reason_msg'] = self.reason_msg
        if self.ext_info_ts is not None:
            result['ext_info_ts'] = self.ext_info_ts
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        if self.credit_expire_date is not None:
            result['credit_expire_date'] = self.credit_expire_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('serial_no') is not None:
            self.serial_no = m.get('serial_no')
        if m.get('credit_no') is not None:
            self.credit_no = m.get('credit_no')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('apply_type') is not None:
            self.apply_type = m.get('apply_type')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('credit_rate') is not None:
            self.credit_rate = m.get('credit_rate')
        if m.get('source') is not None:
            self.source = m.get('source')
        if m.get('reason_code') is not None:
            self.reason_code = m.get('reason_code')
        if m.get('reason_msg') is not None:
            self.reason_msg = m.get('reason_msg')
        if m.get('ext_info_ts') is not None:
            self.ext_info_ts = m.get('ext_info_ts')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        if m.get('credit_expire_date') is not None:
            self.credit_expire_date = m.get('credit_expire_date')
        return self


class UpdateDubbridgeInstitutionCreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_no: str = None,
        serial_no: str = None,
        biz_code: str = None,
        biz_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 蚂蚁端返回申请单号
        self.apply_no = apply_no
        # 机构请求流水号，用于幂等
        self.serial_no = serial_no
        # 业务响应码
        self.biz_code = biz_code
        # 业务消息
        self.biz_msg = biz_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_no is not None:
            result['apply_no'] = self.apply_no
        if self.serial_no is not None:
            result['serial_no'] = self.serial_no
        if self.biz_code is not None:
            result['biz_code'] = self.biz_code
        if self.biz_msg is not None:
            result['biz_msg'] = self.biz_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_no') is not None:
            self.apply_no = m.get('apply_no')
        if m.get('serial_no') is not None:
            self.serial_no = m.get('serial_no')
        if m.get('biz_code') is not None:
            self.biz_code = m.get('biz_code')
        if m.get('biz_msg') is not None:
            self.biz_msg = m.get('biz_msg')
        return self


class QueryDubbridgeRiskinfoBusinessinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        channel_code: str = None,
        customer_no: str = None,
        social_credit_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 渠道号
        self.channel_code = channel_code
        # 客户号
        self.customer_no = customer_no
        # 统一社会信用代码
        self.social_credit_code = social_credit_code

    def validate(self):
        self.validate_required(self.channel_code, 'channel_code')
        self.validate_required(self.customer_no, 'customer_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.social_credit_code is not None:
            result['social_credit_code'] = self.social_credit_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('social_credit_code') is not None:
            self.social_credit_code = m.get('social_credit_code')
        return self


class QueryDubbridgeRiskinfoBusinessinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        info: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 企业经营信息
        self.info = info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.info is not None:
            result['info'] = self.info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('info') is not None:
            self.info = m.get('info')
        return self


class ApplyDubbridgeCustomerAgreementsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        custom_no: str = None,
        custom_name: str = None,
        card_no: str = None,
        id_type: str = None,
        fund_code: str = None,
        channel_code: str = None,
        project_code: str = None,
        org_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 客户编号
        self.custom_no = custom_no
        # 张三
        self.custom_name = custom_name
        # 110101xxxxxxxx
        self.card_no = card_no
        # 证件类型
        self.id_type = id_type
        # 资金方编号
        self.fund_code = fund_code
        # 渠道号
        self.channel_code = channel_code
        # 项目编号
        self.project_code = project_code
        # 渠道号
        self.org_code = org_code

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.custom_name, 'custom_name')
        self.validate_required(self.card_no, 'card_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.id_type is not None:
            result['id_type'] = self.id_type
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.org_code is not None:
            result['org_code'] = self.org_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('id_type') is not None:
            self.id_type = m.get('id_type')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('org_code') is not None:
            self.org_code = m.get('org_code')
        return self


class ApplyDubbridgeCustomerAgreementsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        sdk_params: str = None,
        custom_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # sdkParams返回给商户app客户端，作为客户端唤起sdk的入参
        self.sdk_params = sdk_params
        # 客户编号
        self.custom_no = custom_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.sdk_params is not None:
            result['sdk_params'] = self.sdk_params
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('sdk_params') is not None:
            self.sdk_params = m.get('sdk_params')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        return self


class QueryDubbridgeAccountStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        custom_no: str = None,
        open_id: str = None,
        biz_type: str = None,
        channel_code: str = None,
        org_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户编号（资产方用户唯一标记二选一）
        self.custom_no = custom_no
        # 资产方用户唯一标识（资产方用户唯一标记二选一）
        self.open_id = open_id
        # 查询业务
        self.biz_type = biz_type
        # 渠道号
        self.channel_code = channel_code
        # 渠道号
        self.org_code = org_code

    def validate(self):
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.org_code is not None:
            result['org_code'] = self.org_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('org_code') is not None:
            self.org_code = m.get('org_code')
        return self


class QueryDubbridgeAccountStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: CustomStatus = None,
        pay_method_lock_result: PayMethodLockResult = None,
        fund_chain_lock_result: List[FundChainLockResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信申请状态
        self.data = data
        # 支付账户签约结果
        self.pay_method_lock_result = pay_method_lock_result
        # 支付账户锁定结果
        self.fund_chain_lock_result = fund_chain_lock_result

    def validate(self):
        if self.data:
            self.data.validate()
        if self.pay_method_lock_result:
            self.pay_method_lock_result.validate()
        if self.fund_chain_lock_result:
            for k in self.fund_chain_lock_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.pay_method_lock_result is not None:
            result['pay_method_lock_result'] = self.pay_method_lock_result.to_map()
        result['fund_chain_lock_result'] = []
        if self.fund_chain_lock_result is not None:
            for k in self.fund_chain_lock_result:
                result['fund_chain_lock_result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = CustomStatus()
            self.data = temp_model.from_map(m['data'])
        if m.get('pay_method_lock_result') is not None:
            temp_model = PayMethodLockResult()
            self.pay_method_lock_result = temp_model.from_map(m['pay_method_lock_result'])
        self.fund_chain_lock_result = []
        if m.get('fund_chain_lock_result') is not None:
            for k in m.get('fund_chain_lock_result'):
                temp_model = FundChainLockResult()
                self.fund_chain_lock_result.append(temp_model.from_map(k))
        return self


class QueryDubbridgeAccountCustomRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        channel_code: str = None,
        custom_no: str = None,
        open_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 渠道号
        self.channel_code = channel_code
        # 客户编码
        self.custom_no = custom_no
        # open_id
        self.open_id = open_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        return self


class QueryDubbridgeAccountCustomResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: CustomRelationStatus = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否进行过授信申请
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = CustomRelationStatus()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateDubbridgeAccountCustomRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        channel_code: str = None,
        new_open_id: str = None,
        source_open_id: str = None,
        customer_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 渠道编码
        self.channel_code = channel_code
        # 新渠道id
        self.new_open_id = new_open_id
        # 原渠道id
        self.source_open_id = source_open_id
        # 客户号
        self.customer_no = customer_no

    def validate(self):
        self.validate_required(self.channel_code, 'channel_code')
        self.validate_required(self.new_open_id, 'new_open_id')
        self.validate_required(self.source_open_id, 'source_open_id')
        self.validate_required(self.customer_no, 'customer_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.new_open_id is not None:
            result['new_open_id'] = self.new_open_id
        if self.source_open_id is not None:
            result['source_open_id'] = self.source_open_id
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('new_open_id') is not None:
            self.new_open_id = m.get('new_open_id')
        if m.get('source_open_id') is not None:
            self.source_open_id = m.get('source_open_id')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        return self


class UpdateDubbridgeAccountCustomResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: UpdateCustomerRelationResponseData = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 更新渠道返回体
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = UpdateCustomerRelationResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDubbridgeCustomerAgreementsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        custom_no: str = None,
        order_no: str = None,
        fund_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户编码
        self.custom_no = custom_no
        # 订单号
        self.order_no = order_no
        # 资金方编号
        self.fund_code = fund_code

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.fund_code, 'fund_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        return self


class QueryDubbridgeCustomerAgreementsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        custom_no: str = None,
        trans_serials: str = None,
        status: str = None,
        sign_time: str = None,
        valid_time: str = None,
        invalid_time: str = None,
        custom_name: str = None,
        alipay_user_id: str = None,
        protocol_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户编号
        self.custom_no = custom_no
        # 流水号(代扣协议中标示用户的唯一签约号)
        self.trans_serials = trans_serials
        # 协议签约状态(0-成功1-失败2-处理中)
        self.status = status
        # 协议签约时间(支付宝代扣协议的实际签约时间，格式为yyyy-MM-dd HH:mm:ss)
        self.sign_time = sign_time
        # 协议生效时间(用户代扣协议的实际生效时间，格式为yyyy-MM-dd HH:mm:ss)
        self.valid_time = valid_time
        # 协议失效时间(用户代扣协议的失效时间，格式为yyyy-MM-dd HH:mm:ss)
        self.invalid_time = invalid_time
        # 客户名称
        self.custom_name = custom_name
        # 支付宝会员id
        self.alipay_user_id = alipay_user_id
        # 用以唯一标识用户签约记录的编号
        self.protocol_no = protocol_no

    def validate(self):
        if self.sign_time is not None:
            self.validate_pattern(self.sign_time, 'sign_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.valid_time is not None:
            self.validate_pattern(self.valid_time, 'valid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.invalid_time is not None:
            self.validate_pattern(self.invalid_time, 'invalid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.trans_serials is not None:
            result['trans_serials'] = self.trans_serials
        if self.status is not None:
            result['status'] = self.status
        if self.sign_time is not None:
            result['sign_time'] = self.sign_time
        if self.valid_time is not None:
            result['valid_time'] = self.valid_time
        if self.invalid_time is not None:
            result['invalid_time'] = self.invalid_time
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.alipay_user_id is not None:
            result['alipay_user_id'] = self.alipay_user_id
        if self.protocol_no is not None:
            result['protocol_no'] = self.protocol_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('trans_serials') is not None:
            self.trans_serials = m.get('trans_serials')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sign_time') is not None:
            self.sign_time = m.get('sign_time')
        if m.get('valid_time') is not None:
            self.valid_time = m.get('valid_time')
        if m.get('invalid_time') is not None:
            self.invalid_time = m.get('invalid_time')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('alipay_user_id') is not None:
            self.alipay_user_id = m.get('alipay_user_id')
        if m.get('protocol_no') is not None:
            self.protocol_no = m.get('protocol_no')
        return self


class UpdateDubbridgeCustomerInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        custom_name: str = None,
        census_register: str = None,
        card_no: str = None,
        mobile: str = None,
        custom_no: str = None,
        order_no: str = None,
        id_valid_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户姓名(可修改字段)
        self.custom_name = custom_name
        # 户籍所在地(可修改字段)
        self.census_register = census_register
        # 证件号码(可修改字段)
        self.card_no = card_no
        # 手机号码(可修改字段)
        self.mobile = mobile
        # 客户编号(唯一不变)
        self.custom_no = custom_no
        # 订单号
        self.order_no = order_no
        # 身份证有效期
        self.id_valid_date = id_valid_date

    def validate(self):
        self.validate_required(self.custom_no, 'custom_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.census_register is not None:
            result['census_register'] = self.census_register
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.id_valid_date is not None:
            result['id_valid_date'] = self.id_valid_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('census_register') is not None:
            self.census_register = m.get('census_register')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('id_valid_date') is not None:
            self.id_valid_date = m.get('id_valid_date')
        return self


class UpdateDubbridgeCustomerInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDubbridgeReceiptOverdueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        contract_no: str = None,
        channel_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同编码
        self.contract_no = contract_no
        # 渠道编码
        self.channel_code = channel_code

    def validate(self):
        self.validate_required(self.contract_no, 'contract_no')
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.contract_no is not None:
            result['contract_no'] = self.contract_no
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('contract_no') is not None:
            self.contract_no = m.get('contract_no')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        return self


class QueryDubbridgeReceiptOverdueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: OverdueInfoResponse = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 逾期信息响应
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = OverdueInfoResponse()
            self.data = temp_model.from_map(m['data'])
        return self


class RepayDubbridgeRepayCheckstandRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        repay_type: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用信申请订单号
        self.original_order_no = original_order_no
        # 还款类型1:当期结清，2：正常还款3：全部结清
        self.repay_type = repay_type
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.repay_type, 'repay_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class RepayDubbridgeRepayCheckstandResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        checkstand_address: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 收银台地址(成功就有值)
        self.checkstand_address = checkstand_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.checkstand_address is not None:
            result['checkstand_address'] = self.checkstand_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('checkstand_address') is not None:
            self.checkstand_address = m.get('checkstand_address')
        return self


class QueryDubbridgeRepayInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 原还款订单号
        self.original_order_no = original_order_no
        # 订单号
        self.order_no = order_no

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.order_no is not None:
            result['order_no'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        return self


class QueryDubbridgeRepayInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_no: str = None,
        receipt_no: str = None,
        custom_no: str = None,
        custom_name: str = None,
        repay_type: str = None,
        repay_sign: str = None,
        repay_date: str = None,
        repay_amount: int = None,
        repay_principal: int = None,
        repay_interest: int = None,
        channel_amt: int = None,
        repay_fee: str = None,
        repay_punish: int = None,
        repay_account: str = None,
        repay_account_name: str = None,
        repay_mobile: str = None,
        repay_bank_no: str = None,
        repay_bank_name: str = None,
        repay_status: str = None,
        fail_reason: str = None,
        apply_no: str = None,
        guarantee_fee: int = None,
        liquidated_damages: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款编号
        self.repay_no = repay_no
        # 借据编码
        self.receipt_no = receipt_no
        # 客户编号
        self.custom_no = custom_no
        # 客户名称
        self.custom_name = custom_name
        # 还款类型1:提前还款，2：正常还款 3:批量还款 4：自由还款
        self.repay_type = repay_type
        # repay_sign
        self.repay_sign = repay_sign
        # 还款日期
        self.repay_date = repay_date
        # 实还总额
        self.repay_amount = repay_amount
        # 实还本金
        self.repay_principal = repay_principal
        # 实还利息
        self.repay_interest = repay_interest
        # 实还通道手续费
        self.channel_amt = channel_amt
        # 实还手续费
        self.repay_fee = repay_fee
        # 实收罚息
        self.repay_punish = repay_punish
        # 还款账户
        self.repay_account = repay_account
        # 还款账户名称
        self.repay_account_name = repay_account_name
        # 还款账户的手机号
        self.repay_mobile = repay_mobile
        # 还款账户银行行号
        self.repay_bank_no = repay_bank_no
        # 还款账户银行名称
        self.repay_bank_name = repay_bank_name
        # 还款状态0:失败 1成功 2-审批中 3-还款中
        self.repay_status = repay_status
        # 失败原因
        self.fail_reason = fail_reason
        # 授信申请编号
        self.apply_no = apply_no
        # 担保费
        self.guarantee_fee = guarantee_fee
        # 违约金
        self.liquidated_damages = liquidated_damages

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.repay_no is not None:
            result['repay_no'] = self.repay_no
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.repay_sign is not None:
            result['repay_sign'] = self.repay_sign
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.repay_amount is not None:
            result['repay_amount'] = self.repay_amount
        if self.repay_principal is not None:
            result['repay_principal'] = self.repay_principal
        if self.repay_interest is not None:
            result['repay_interest'] = self.repay_interest
        if self.channel_amt is not None:
            result['channel_amt'] = self.channel_amt
        if self.repay_fee is not None:
            result['repay_fee'] = self.repay_fee
        if self.repay_punish is not None:
            result['repay_punish'] = self.repay_punish
        if self.repay_account is not None:
            result['repay_account'] = self.repay_account
        if self.repay_account_name is not None:
            result['repay_account_name'] = self.repay_account_name
        if self.repay_mobile is not None:
            result['repay_mobile'] = self.repay_mobile
        if self.repay_bank_no is not None:
            result['repay_bank_no'] = self.repay_bank_no
        if self.repay_bank_name is not None:
            result['repay_bank_name'] = self.repay_bank_name
        if self.repay_status is not None:
            result['repay_status'] = self.repay_status
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        if self.apply_no is not None:
            result['apply_no'] = self.apply_no
        if self.guarantee_fee is not None:
            result['guarantee_fee'] = self.guarantee_fee
        if self.liquidated_damages is not None:
            result['liquidated_damages'] = self.liquidated_damages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('repay_no') is not None:
            self.repay_no = m.get('repay_no')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('repay_sign') is not None:
            self.repay_sign = m.get('repay_sign')
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('repay_amount') is not None:
            self.repay_amount = m.get('repay_amount')
        if m.get('repay_principal') is not None:
            self.repay_principal = m.get('repay_principal')
        if m.get('repay_interest') is not None:
            self.repay_interest = m.get('repay_interest')
        if m.get('channel_amt') is not None:
            self.channel_amt = m.get('channel_amt')
        if m.get('repay_fee') is not None:
            self.repay_fee = m.get('repay_fee')
        if m.get('repay_punish') is not None:
            self.repay_punish = m.get('repay_punish')
        if m.get('repay_account') is not None:
            self.repay_account = m.get('repay_account')
        if m.get('repay_account_name') is not None:
            self.repay_account_name = m.get('repay_account_name')
        if m.get('repay_mobile') is not None:
            self.repay_mobile = m.get('repay_mobile')
        if m.get('repay_bank_no') is not None:
            self.repay_bank_no = m.get('repay_bank_no')
        if m.get('repay_bank_name') is not None:
            self.repay_bank_name = m.get('repay_bank_name')
        if m.get('repay_status') is not None:
            self.repay_status = m.get('repay_status')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        if m.get('apply_no') is not None:
            self.apply_no = m.get('apply_no')
        if m.get('guarantee_fee') is not None:
            self.guarantee_fee = m.get('guarantee_fee')
        if m.get('liquidated_damages') is not None:
            self.liquidated_damages = m.get('liquidated_damages')
        return self


class QueryDubbridgeRepayListRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 用信申请订单号
        self.original_order_no = original_order_no

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        return self


class QueryDubbridgeRepayListResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_result_list: List[RepayResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款计划查询结果
        self.repay_result_list = repay_result_list

    def validate(self):
        if self.repay_result_list:
            for k in self.repay_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['repay_result_list'] = []
        if self.repay_result_list is not None:
            for k in self.repay_result_list:
                result['repay_result_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.repay_result_list = []
        if m.get('repay_result_list') is not None:
            for k in m.get('repay_result_list'):
                temp_model = RepayResult()
                self.repay_result_list.append(temp_model.from_map(k))
        return self


class CountDubbridgeRepayReftrialRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
        prod_no: str = None,
        apply_amount: int = None,
        apply_period: int = None,
        repay_type: str = None,
        repay_date: str = None,
        coupon_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 产品编号
        self.prod_no = prod_no
        # 借款金额
        self.apply_amount = apply_amount
        # 借款期数
        self.apply_period = apply_period
        # 还款方式1：等额本息，2：等额本金
        self.repay_type = repay_type
        # 还款日
        self.repay_date = repay_date
        # 优惠券id
        self.coupon_id = coupon_id

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.apply_amount, 'apply_amount')
        self.validate_required(self.apply_period, 'apply_period')
        self.validate_required(self.repay_type, 'repay_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.apply_amount is not None:
            result['apply_amount'] = self.apply_amount
        if self.apply_period is not None:
            result['apply_period'] = self.apply_period
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.coupon_id is not None:
            result['coupon_id'] = self.coupon_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('apply_amount') is not None:
            self.apply_amount = m.get('apply_amount')
        if m.get('apply_period') is not None:
            self.apply_period = m.get('apply_period')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('coupon_id') is not None:
            self.coupon_id = m.get('coupon_id')
        return self


class CountDubbridgeRepayReftrialResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_trail_list: List[RepayTrail] = None,
        repay_date: str = None,
        repay_account: str = None,
        total_interest: int = None,
        apply_info: ApplyInfo = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款计划试算结果
        self.repay_trail_list = repay_trail_list
        # 还款日
        self.repay_date = repay_date
        # 还款账户
        self.repay_account = repay_account
        # 总利息
        self.total_interest = total_interest
        # 授信信息
        self.apply_info = apply_info

    def validate(self):
        if self.repay_trail_list:
            for k in self.repay_trail_list:
                if k:
                    k.validate()
        if self.apply_info:
            self.apply_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['repay_trail_list'] = []
        if self.repay_trail_list is not None:
            for k in self.repay_trail_list:
                result['repay_trail_list'].append(k.to_map() if k else None)
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.repay_account is not None:
            result['repay_account'] = self.repay_account
        if self.total_interest is not None:
            result['total_interest'] = self.total_interest
        if self.apply_info is not None:
            result['apply_info'] = self.apply_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.repay_trail_list = []
        if m.get('repay_trail_list') is not None:
            for k in m.get('repay_trail_list'):
                temp_model = RepayTrail()
                self.repay_trail_list.append(temp_model.from_map(k))
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('repay_account') is not None:
            self.repay_account = m.get('repay_account')
        if m.get('total_interest') is not None:
            self.total_interest = m.get('total_interest')
        if m.get('apply_info') is not None:
            temp_model = ApplyInfo()
            self.apply_info = temp_model.from_map(m['apply_info'])
        return self


class CountDubbridgeRepayTrialRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        repay_type: str = None,
        order_no: str = None,
        period_list: List[int] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用信申请订单号
        self.original_order_no = original_order_no
        # 还款类型1:当期结清，2：正常还款3：全部结清
        self.repay_type = repay_type
        # 订单号
        self.order_no = order_no
        # 试算逾期期次列表
        self.period_list = period_list

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.period_list is not None:
            result['period_list'] = self.period_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('period_list') is not None:
            self.period_list = m.get('period_list')
        return self


class CountDubbridgeRepayTrialResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        real_principal: int = None,
        real_interest: int = None,
        real_over_amt: int = None,
        service_charge: int = None,
        real_guarantee_fee: int = None,
        real_liquidated_damages: int = None,
        repay_result_list: List[RepayResult] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款本金
        self.real_principal = real_principal
        # 还款利息
        self.real_interest = real_interest
        # 还款费用
        self.real_over_amt = real_over_amt
        # 服务费
        self.service_charge = service_charge
        # 担保费
        self.real_guarantee_fee = real_guarantee_fee
        # 违约金
        self.real_liquidated_damages = real_liquidated_damages
        # 试算期次还款计划结果
        self.repay_result_list = repay_result_list

    def validate(self):
        if self.repay_result_list:
            for k in self.repay_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.real_principal is not None:
            result['real_principal'] = self.real_principal
        if self.real_interest is not None:
            result['real_interest'] = self.real_interest
        if self.real_over_amt is not None:
            result['real_over_amt'] = self.real_over_amt
        if self.service_charge is not None:
            result['service_charge'] = self.service_charge
        if self.real_guarantee_fee is not None:
            result['real_guarantee_fee'] = self.real_guarantee_fee
        if self.real_liquidated_damages is not None:
            result['real_liquidated_damages'] = self.real_liquidated_damages
        result['repay_result_list'] = []
        if self.repay_result_list is not None:
            for k in self.repay_result_list:
                result['repay_result_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('real_principal') is not None:
            self.real_principal = m.get('real_principal')
        if m.get('real_interest') is not None:
            self.real_interest = m.get('real_interest')
        if m.get('real_over_amt') is not None:
            self.real_over_amt = m.get('real_over_amt')
        if m.get('service_charge') is not None:
            self.service_charge = m.get('service_charge')
        if m.get('real_guarantee_fee') is not None:
            self.real_guarantee_fee = m.get('real_guarantee_fee')
        if m.get('real_liquidated_damages') is not None:
            self.real_liquidated_damages = m.get('real_liquidated_damages')
        self.repay_result_list = []
        if m.get('repay_result_list') is not None:
            for k in m.get('repay_result_list'):
                temp_model = RepayResult()
                self.repay_result_list.append(temp_model.from_map(k))
        return self


class RepayDubbridgeRepayWithholdRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
        repay_type: str = None,
        period_list: List[int] = None,
        valid_repay_amount: str = None,
        bank_card_no: str = None,
        payment_flag: str = None,
        account_name: str = None,
        reserved_mobile: str = None,
        account_open_bank: str = None,
        deduction_code: str = None,
        signing_agreement_num: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 还款类型1:当期结清，2：正常还款3：全部结清
        self.repay_type = repay_type
        # 逾期期次列表（担保渠道）
        self.period_list = period_list
        # 校验还款金额
        self.valid_repay_amount = valid_repay_amount
        # 银行卡号
        self.bank_card_no = bank_card_no
        # 是否支付代扣，Y是N否（Y：支付代扣，N：无需走支付通道，直接信息流入账--线下还款模式）；（担保渠道）
        self.payment_flag = payment_flag
        # 账号开户名，payment_flag=Y时，必填；（担保渠道）
        self.account_name = account_name
        # 银行预留手机号，payment_flag=Y时，必填；（担保渠道）
        self.reserved_mobile = reserved_mobile
        # 账号开户行编码（担保渠道）
        self.account_open_bank = account_open_bank
        # 扣款渠道代码（担保渠道）
        self.deduction_code = deduction_code
        # 通道签约协议号（担保渠道）
        self.signing_agreement_num = signing_agreement_num

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.repay_type, 'repay_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.period_list is not None:
            result['period_list'] = self.period_list
        if self.valid_repay_amount is not None:
            result['valid_repay_amount'] = self.valid_repay_amount
        if self.bank_card_no is not None:
            result['bank_card_no'] = self.bank_card_no
        if self.payment_flag is not None:
            result['payment_flag'] = self.payment_flag
        if self.account_name is not None:
            result['account_name'] = self.account_name
        if self.reserved_mobile is not None:
            result['reserved_mobile'] = self.reserved_mobile
        if self.account_open_bank is not None:
            result['account_open_bank'] = self.account_open_bank
        if self.deduction_code is not None:
            result['deduction_code'] = self.deduction_code
        if self.signing_agreement_num is not None:
            result['signing_agreement_num'] = self.signing_agreement_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('period_list') is not None:
            self.period_list = m.get('period_list')
        if m.get('valid_repay_amount') is not None:
            self.valid_repay_amount = m.get('valid_repay_amount')
        if m.get('bank_card_no') is not None:
            self.bank_card_no = m.get('bank_card_no')
        if m.get('payment_flag') is not None:
            self.payment_flag = m.get('payment_flag')
        if m.get('account_name') is not None:
            self.account_name = m.get('account_name')
        if m.get('reserved_mobile') is not None:
            self.reserved_mobile = m.get('reserved_mobile')
        if m.get('account_open_bank') is not None:
            self.account_open_bank = m.get('account_open_bank')
        if m.get('deduction_code') is not None:
            self.deduction_code = m.get('deduction_code')
        if m.get('signing_agreement_num') is not None:
            self.signing_agreement_num = m.get('signing_agreement_num')
        return self


class RepayDubbridgeRepayWithholdResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDubbridgeSearchContractRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        customer_no: str = None,
        contract_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 原用信订单号
        self.original_order_no = original_order_no
        # 客户号
        self.customer_no = customer_no
        # 合同类型
        self.contract_type = contract_type

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.customer_no, 'customer_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.contract_type is not None:
            result['contract_type'] = self.contract_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('contract_type') is not None:
            self.contract_type = m.get('contract_type')
        return self


class QueryDubbridgeSearchContractResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        contracts: List[Contract] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 合同信息列表
        self.contracts = contracts

    def validate(self):
        if self.contracts:
            for k in self.contracts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['contracts'] = []
        if self.contracts is not None:
            for k in self.contracts:
                result['contracts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.contracts = []
        if m.get('contracts') is not None:
            for k in m.get('contracts'):
                temp_model = Contract()
                self.contracts.append(temp_model.from_map(k))
        return self


class ApplyDubbridgeUsecreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        loan_amount: int = None,
        period: int = None,
        open_id: str = None,
        order_no: str = None,
        repay_type: str = None,
        loan_way: str = None,
        repay_date: str = None,
        channel_type: str = None,
        custom_type: str = None,
        risk_data: str = None,
        loan_inst_code: str = None,
        bank_card_no: str = None,
        materials: List[Material] = None,
        coupon_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授信申请订单号
        self.original_order_no = original_order_no
        # 用信金额
        self.loan_amount = loan_amount
        # 期数
        self.period = period
        # 资产方用户唯一标识
        self.open_id = open_id
        # 订单号
        self.order_no = order_no
        # 还款方式:1：等额本息，2：等额本金
        self.repay_type = repay_type
        # 1：手机数码 2：旅游 3：装修 4：教育 5：婚庆 6：租房 7：家具家居 8：健康医疗 9：其他消费 10：家用电器
        self.loan_way = loan_way
        # 还款日
        self.repay_date = repay_date
        # 渠道类型
        self.channel_type = channel_type
        # 客户类型
        self.custom_type = custom_type
        # 风险数据对象（json字符串）
        self.risk_data = risk_data
        # 资金源编码
        self.loan_inst_code = loan_inst_code
        # 银行卡号
        self.bank_card_no = bank_card_no
        # 影像件信息
        self.materials = materials
        # 优惠券id
        self.coupon_id = coupon_id

    def validate(self):
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.loan_amount, 'loan_amount')
        self.validate_required(self.period, 'period')
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.repay_type, 'repay_type')
        self.validate_required(self.loan_way, 'loan_way')
        if self.materials:
            for k in self.materials:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.loan_amount is not None:
            result['loan_amount'] = self.loan_amount
        if self.period is not None:
            result['period'] = self.period
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.loan_way is not None:
            result['loan_way'] = self.loan_way
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        if self.risk_data is not None:
            result['risk_data'] = self.risk_data
        if self.loan_inst_code is not None:
            result['loan_inst_code'] = self.loan_inst_code
        if self.bank_card_no is not None:
            result['bank_card_no'] = self.bank_card_no
        result['materials'] = []
        if self.materials is not None:
            for k in self.materials:
                result['materials'].append(k.to_map() if k else None)
        if self.coupon_id is not None:
            result['coupon_id'] = self.coupon_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('loan_amount') is not None:
            self.loan_amount = m.get('loan_amount')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('loan_way') is not None:
            self.loan_way = m.get('loan_way')
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        if m.get('risk_data') is not None:
            self.risk_data = m.get('risk_data')
        if m.get('loan_inst_code') is not None:
            self.loan_inst_code = m.get('loan_inst_code')
        if m.get('bank_card_no') is not None:
            self.bank_card_no = m.get('bank_card_no')
        self.materials = []
        if m.get('materials') is not None:
            for k in m.get('materials'):
                temp_model = Material()
                self.materials.append(temp_model.from_map(k))
        if m.get('coupon_id') is not None:
            self.coupon_id = m.get('coupon_id')
        return self


class ApplyDubbridgeUsecreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDubbridgeUsecreditStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        prod_type: str = None,
        original_order_no: str = None,
        biz_order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 请求网络流水号
        self.order_no = order_no
        # 1：现金贷（默认）
        # 2：分期付
        self.prod_type = prod_type
        # 天枢系统用信申请的订单号
        self.original_order_no = original_order_no
        # 购物订单号，如二轮车/摩托车订单号
        self.biz_order_no = biz_order_no

    def validate(self):
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        return self


class QueryDubbridgeUsecreditStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
        msg: str = None,
        receipt_info: ReceiptInfo = None,
        repay_ref: List[RepayRef] = None,
        disburse_contract_no: str = None,
        credit_contract_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用信状态（0-通过/1-不通过2-处理中）
        self.status = status
        # 拒绝原因
        self.msg = msg
        # 借据信息
        self.receipt_info = receipt_info
        # 还款计划列表
        self.repay_ref = repay_ref
        # 用信合同编号
        self.disburse_contract_no = disburse_contract_no
        # 授信合同编号
        self.credit_contract_no = credit_contract_no

    def validate(self):
        if self.receipt_info:
            self.receipt_info.validate()
        if self.repay_ref:
            for k in self.repay_ref:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        if self.msg is not None:
            result['msg'] = self.msg
        if self.receipt_info is not None:
            result['receipt_info'] = self.receipt_info.to_map()
        result['repay_ref'] = []
        if self.repay_ref is not None:
            for k in self.repay_ref:
                result['repay_ref'].append(k.to_map() if k else None)
        if self.disburse_contract_no is not None:
            result['disburse_contract_no'] = self.disburse_contract_no
        if self.credit_contract_no is not None:
            result['credit_contract_no'] = self.credit_contract_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('receipt_info') is not None:
            temp_model = ReceiptInfo()
            self.receipt_info = temp_model.from_map(m['receipt_info'])
        self.repay_ref = []
        if m.get('repay_ref') is not None:
            for k in m.get('repay_ref'):
                temp_model = RepayRef()
                self.repay_ref.append(temp_model.from_map(k))
        if m.get('disburse_contract_no') is not None:
            self.disburse_contract_no = m.get('disburse_contract_no')
        if m.get('credit_contract_no') is not None:
            self.credit_contract_no = m.get('credit_contract_no')
        return self


class QueryDubbridgeReceiptStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        open_id: str = None,
        custom_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # open_id
        self.open_id = open_id
        # 客户号
        self.custom_no = custom_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        return self


class QueryDubbridgeReceiptStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: CustomReceiptStatus = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否结清结构体
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = CustomReceiptStatus()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDubbridgeCustomerCommonagreementsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        custom_no: str = None,
        fund_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 客户编号
        self.custom_no = custom_no
        # 资金方编号
        self.fund_code = fund_code

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.fund_code, 'fund_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        return self


class QueryDubbridgeCustomerCommonagreementsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        custom_no: str = None,
        custom_name: str = None,
        trans_serials: str = None,
        status: str = None,
        account_user_id: str = None,
        account_no: str = None,
        protocol_no: str = None,
        sign_time: str = None,
        valid_time: str = None,
        invalid_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户编号
        self.custom_no = custom_no
        # 客户名称
        self.custom_name = custom_name
        # 流水号
        self.trans_serials = trans_serials
        # 签约状态
        self.status = status
        # 签约用户唯一标识
        self.account_user_id = account_user_id
        # 脱敏的签约账号
        self.account_no = account_no
        # 协议号
        self.protocol_no = protocol_no
        # 协议签约时间
        self.sign_time = sign_time
        # 协议生效时间
        self.valid_time = valid_time
        # 协议失效时间
        self.invalid_time = invalid_time

    def validate(self):
        if self.sign_time is not None:
            self.validate_pattern(self.sign_time, 'sign_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.valid_time is not None:
            self.validate_pattern(self.valid_time, 'valid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.invalid_time is not None:
            self.validate_pattern(self.invalid_time, 'invalid_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.trans_serials is not None:
            result['trans_serials'] = self.trans_serials
        if self.status is not None:
            result['status'] = self.status
        if self.account_user_id is not None:
            result['account_user_id'] = self.account_user_id
        if self.account_no is not None:
            result['account_no'] = self.account_no
        if self.protocol_no is not None:
            result['protocol_no'] = self.protocol_no
        if self.sign_time is not None:
            result['sign_time'] = self.sign_time
        if self.valid_time is not None:
            result['valid_time'] = self.valid_time
        if self.invalid_time is not None:
            result['invalid_time'] = self.invalid_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('trans_serials') is not None:
            self.trans_serials = m.get('trans_serials')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('account_user_id') is not None:
            self.account_user_id = m.get('account_user_id')
        if m.get('account_no') is not None:
            self.account_no = m.get('account_no')
        if m.get('protocol_no') is not None:
            self.protocol_no = m.get('protocol_no')
        if m.get('sign_time') is not None:
            self.sign_time = m.get('sign_time')
        if m.get('valid_time') is not None:
            self.valid_time = m.get('valid_time')
        if m.get('invalid_time') is not None:
            self.invalid_time = m.get('invalid_time')
        return self


class UpdateDubbridgeFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
        custom_no: str = None,
        materials: List[Material] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 授信申请订单号(资产方)
        self.original_order_no = original_order_no
        # 客户编号
        self.custom_no = custom_no
        # 资料文件
        self.materials = materials

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.custom_no, 'custom_no')
        self.validate_required(self.materials, 'materials')
        if self.materials:
            for k in self.materials:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        result['materials'] = []
        if self.materials is not None:
            for k in self.materials:
                result['materials'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        self.materials = []
        if m.get('materials') is not None:
            for k in m.get('materials'):
                temp_model = Material()
                self.materials.append(temp_model.from_map(k))
        return self


class UpdateDubbridgeFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class NotifyDubbridgeCallbackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        channel_code: str = None,
        biz_param: str = None,
        biz_type: str = None,
        seq_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户id
        self.channel_code = channel_code
        # json参数
        self.biz_param = biz_param
        # 回调类型（1授信回调2用信回调）
        self.biz_type = biz_type
        # 对应授信/用信传给三方留存单号
        self.seq_no = seq_no

    def validate(self):
        self.validate_required(self.channel_code, 'channel_code')
        self.validate_required(self.biz_param, 'biz_param')
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.seq_no, 'seq_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.biz_param is not None:
            result['biz_param'] = self.biz_param
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.seq_no is not None:
            result['seq_no'] = self.seq_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('biz_param') is not None:
            self.biz_param = m.get('biz_param')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('seq_no') is not None:
            self.seq_no = m.get('seq_no')
        return self


class NotifyDubbridgeCallbackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: CommonNotyfyResult = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 
        # 处理结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = CommonNotyfyResult()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDubbridgeRepayResultRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 123
        self.original_order_no = original_order_no

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        return self


class QueryDubbridgeRepayResultResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_no: str = None,
        receipt_no: str = None,
        custom_no: str = None,
        repay_type: str = None,
        repay_sign: str = None,
        repay_account: str = None,
        repay_status: str = None,
        fail_reason: str = None,
        repay_infos: List[RepayInfos] = None,
        repay_date: str = None,
        repay_amount: int = None,
        repay_principal: int = None,
        repay_interest: int = None,
        repay_punish: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款编号
        self.repay_no = repay_no
        # 借据编号
        self.receipt_no = receipt_no
        # 客户编号
        self.custom_no = custom_no
        # 还款类型
        # 1: 全部结清，
        # 2：正常还款
        # 3：当期结清
        # 4：逾期还款
        # 
        self.repay_type = repay_type
        # 还款标志
        # 1 线下还款
        # 2 用户主动还款
        # 3 系统代扣
        # 
        self.repay_sign = repay_sign
        # 还款账户
        self.repay_account = repay_account
        # 还款状态
        self.repay_status = repay_status
        # 失败原因
        self.fail_reason = fail_reason
        # 还款信息列表
        self.repay_infos = repay_infos
        # 还款日期
        self.repay_date = repay_date
        # 实还总额
        self.repay_amount = repay_amount
        # 实还总本金
        self.repay_principal = repay_principal
        # 实还总利息
        self.repay_interest = repay_interest
        # 实收总罚息
        self.repay_punish = repay_punish

    def validate(self):
        if self.repay_infos:
            for k in self.repay_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.repay_no is not None:
            result['repay_no'] = self.repay_no
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.repay_sign is not None:
            result['repay_sign'] = self.repay_sign
        if self.repay_account is not None:
            result['repay_account'] = self.repay_account
        if self.repay_status is not None:
            result['repay_status'] = self.repay_status
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        result['repay_infos'] = []
        if self.repay_infos is not None:
            for k in self.repay_infos:
                result['repay_infos'].append(k.to_map() if k else None)
        if self.repay_date is not None:
            result['repay_date'] = self.repay_date
        if self.repay_amount is not None:
            result['repay_amount'] = self.repay_amount
        if self.repay_principal is not None:
            result['repay_principal'] = self.repay_principal
        if self.repay_interest is not None:
            result['repay_interest'] = self.repay_interest
        if self.repay_punish is not None:
            result['repay_punish'] = self.repay_punish
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('repay_no') is not None:
            self.repay_no = m.get('repay_no')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('repay_sign') is not None:
            self.repay_sign = m.get('repay_sign')
        if m.get('repay_account') is not None:
            self.repay_account = m.get('repay_account')
        if m.get('repay_status') is not None:
            self.repay_status = m.get('repay_status')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        self.repay_infos = []
        if m.get('repay_infos') is not None:
            for k in m.get('repay_infos'):
                temp_model = RepayInfos()
                self.repay_infos.append(temp_model.from_map(k))
        if m.get('repay_date') is not None:
            self.repay_date = m.get('repay_date')
        if m.get('repay_amount') is not None:
            self.repay_amount = m.get('repay_amount')
        if m.get('repay_principal') is not None:
            self.repay_principal = m.get('repay_principal')
        if m.get('repay_interest') is not None:
            self.repay_interest = m.get('repay_interest')
        if m.get('repay_punish') is not None:
            self.repay_punish = m.get('repay_punish')
        return self


class QueryDubbridgeCreditPermitRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        card_no: str = None,
        mobile: str = None,
        custom_name: str = None,
        prod_no: str = None,
        channel_type: str = None,
        custom_type: str = None,
        traffic_platform: str = None,
        traffic_source_name: str = None,
        traffic_ad_id: str = None,
        traffic_mkt_id: str = None,
        click_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 身份证号
        self.card_no = card_no
        # 手机号
        self.mobile = mobile
        # 姓名
        self.custom_name = custom_name
        # 合作方产品编号
        self.prod_no = prod_no
        # 1:app
        # 2:H5
        self.channel_type = channel_type
        # 客户类型
        # ("1", "新增客户"),("2", "存量激活客户"),("3", "目标营销账户")
        self.custom_type = custom_type
        # 导流平台
        self.traffic_platform = traffic_platform
        # 流量来源名称
        self.traffic_source_name = traffic_source_name
        # 广告位标志
        self.traffic_ad_id = traffic_ad_id
        # 营销id
        self.traffic_mkt_id = traffic_mkt_id
        # 点击id
        self.click_id = click_id

    def validate(self):
        self.validate_required(self.mobile, 'mobile')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.prod_no is not None:
            result['prod_no'] = self.prod_no
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.custom_type is not None:
            result['custom_type'] = self.custom_type
        if self.traffic_platform is not None:
            result['traffic_platform'] = self.traffic_platform
        if self.traffic_source_name is not None:
            result['traffic_source_name'] = self.traffic_source_name
        if self.traffic_ad_id is not None:
            result['traffic_ad_id'] = self.traffic_ad_id
        if self.traffic_mkt_id is not None:
            result['traffic_mkt_id'] = self.traffic_mkt_id
        if self.click_id is not None:
            result['click_id'] = self.click_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('prod_no') is not None:
            self.prod_no = m.get('prod_no')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('custom_type') is not None:
            self.custom_type = m.get('custom_type')
        if m.get('traffic_platform') is not None:
            self.traffic_platform = m.get('traffic_platform')
        if m.get('traffic_source_name') is not None:
            self.traffic_source_name = m.get('traffic_source_name')
        if m.get('traffic_ad_id') is not None:
            self.traffic_ad_id = m.get('traffic_ad_id')
        if m.get('traffic_mkt_id') is not None:
            self.traffic_mkt_id = m.get('traffic_mkt_id')
        if m.get('click_id') is not None:
            self.click_id = m.get('click_id')
        return self


class QueryDubbridgeCreditPermitResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        enable_apply: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Y：准入
        # N：未准入
        self.enable_apply = enable_apply

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.enable_apply is not None:
            result['enable_apply'] = self.enable_apply
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('enable_apply') is not None:
            self.enable_apply = m.get('enable_apply')
        return self


class QueryDubbridgeUserUpgradestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        open_id: str = None,
        customer_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资产方用户唯一标识
        self.open_id = open_id
        # 天枢客户编号
        self.customer_no = customer_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        return self


class QueryDubbridgeUserUpgradestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用户状态：0已升级，1未升级
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryDubbridgeLoanUpgradestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        original_order_no: str = None,
        receipt_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用信申请订单号(资产方)
        self.original_order_no = original_order_no
        # 借据编号
        self.receipt_no = receipt_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.receipt_no is not None:
            result['receipt_no'] = self.receipt_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('receipt_no') is not None:
            self.receipt_no = m.get('receipt_no')
        return self


class QueryDubbridgeLoanUpgradestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 借据状态：0存量，1增量
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryDubbridgeCustomerBankcardlistRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer_no: str = None,
        fund_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户号
        self.customer_no = customer_no
        # 资金方编号
        self.fund_code = fund_code

    def validate(self):
        self.validate_required(self.customer_no, 'customer_no')
        self.validate_required(self.fund_code, 'fund_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        return self


class QueryDubbridgeCustomerBankcardlistResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        customer_bank_card_info_list: List[CustomerBankCardInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用户绑定银行卡信息列表
        self.customer_bank_card_info_list = customer_bank_card_info_list

    def validate(self):
        if self.customer_bank_card_info_list:
            for k in self.customer_bank_card_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['customer_bank_card_info_list'] = []
        if self.customer_bank_card_info_list is not None:
            for k in self.customer_bank_card_info_list:
                result['customer_bank_card_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.customer_bank_card_info_list = []
        if m.get('customer_bank_card_info_list') is not None:
            for k in m.get('customer_bank_card_info_list'):
                temp_model = CustomerBankCardInfo()
                self.customer_bank_card_info_list.append(temp_model.from_map(k))
        return self


class QueryDubbridgeRouterUserselectRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        card_no: str = None,
        mobile: str = None,
        custom_name: str = None,
        platform_no: str = None,
        ext_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 身份证号
        self.card_no = card_no
        # 手机号
        self.mobile = mobile
        # 姓名
        self.custom_name = custom_name
        # 机构编码
        self.platform_no = platform_no
        # 扩展信息JSON
        self.ext_info = ext_info

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.mobile, 'mobile')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.custom_name is not None:
            result['custom_name'] = self.custom_name
        if self.platform_no is not None:
            result['platform_no'] = self.platform_no
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('custom_name') is not None:
            self.custom_name = m.get('custom_name')
        if m.get('platform_no') is not None:
            self.platform_no = m.get('platform_no')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        return self


class QueryDubbridgeRouterUserselectResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        user_classify_info: UserClassifyInfo = None,
        ext_info: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用户分层信息
        self.user_classify_info = user_classify_info
        # json字符串，预留扩展字段
        self.ext_info = ext_info

    def validate(self):
        if self.user_classify_info:
            self.user_classify_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.user_classify_info is not None:
            result['user_classify_info'] = self.user_classify_info.to_map()
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('user_classify_info') is not None:
            temp_model = UserClassifyInfo()
            self.user_classify_info = temp_model.from_map(m['user_classify_info'])
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        return self


class QueryDubbridgeSettlementCertificateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        original_order_no: str = None,
        scene: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 授信/用信申请订单号
        self.original_order_no = original_order_no
        # 开具类型，授信：01，提现：02
        self.scene = scene

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.original_order_no, 'original_order_no')
        self.validate_required(self.scene, 'scene')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.original_order_no is not None:
            result['original_order_no'] = self.original_order_no
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('original_order_no') is not None:
            self.original_order_no = m.get('original_order_no')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class QueryDubbridgeSettlementCertificateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        certificate_info_list: List[CertificateInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 结清证明列表
        self.certificate_info_list = certificate_info_list

    def validate(self):
        if self.certificate_info_list:
            for k in self.certificate_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['certificate_info_list'] = []
        if self.certificate_info_list is not None:
            for k in self.certificate_info_list:
                result['certificate_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.certificate_info_list = []
        if m.get('certificate_info_list') is not None:
            for k in m.get('certificate_info_list'):
                temp_model = CertificateInfo()
                self.certificate_info_list.append(temp_model.from_map(k))
        return self


class QueryDubbridgeAgreementPreviewRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_type: str = None,
        fund_code: str = None,
        customer_no: str = None,
        loan_amount: int = None,
        period: int = None,
        bank_code: str = None,
        repay_type: str = None,
        bank_name: str = None,
        bank_card_no: str = None,
        receipt_end_date: str = None,
        loan_way: str = None,
        lpr: int = None,
        lpr_point: int = None,
        lpr_effect_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 授信：apply
        # 借款：loan
        # 绑卡：bind
        self.biz_type = biz_type
        # 资金方编号
        self.fund_code = fund_code
        # 客户号
        self.customer_no = customer_no
        # 借款金额
        self.loan_amount = loan_amount
        # 分期期数
        self.period = period
        # 银行编码
        self.bank_code = bank_code
        # 还款方式
        self.repay_type = repay_type
        # 银行名称
        self.bank_name = bank_name
        # 银行卡号
        self.bank_card_no = bank_card_no
        # 借据截至日期yyyy-MM-dd
        self.receipt_end_date = receipt_end_date
        # 借款用途
        self.loan_way = loan_way
        # lpr
        self.lpr = lpr
        # LPR加点值
        self.lpr_point = lpr_point
        # LPR发布日期
        self.lpr_effect_date = lpr_effect_date

    def validate(self):
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.fund_code, 'fund_code')
        self.validate_required(self.customer_no, 'customer_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_type is not None:
            result['biz_type'] = self.biz_type
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.loan_amount is not None:
            result['loan_amount'] = self.loan_amount
        if self.period is not None:
            result['period'] = self.period
        if self.bank_code is not None:
            result['bank_code'] = self.bank_code
        if self.repay_type is not None:
            result['repay_type'] = self.repay_type
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.bank_card_no is not None:
            result['bank_card_no'] = self.bank_card_no
        if self.receipt_end_date is not None:
            result['receipt_end_date'] = self.receipt_end_date
        if self.loan_way is not None:
            result['loan_way'] = self.loan_way
        if self.lpr is not None:
            result['lpr'] = self.lpr
        if self.lpr_point is not None:
            result['lpr_point'] = self.lpr_point
        if self.lpr_effect_date is not None:
            result['lpr_effect_date'] = self.lpr_effect_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_type') is not None:
            self.biz_type = m.get('biz_type')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('loan_amount') is not None:
            self.loan_amount = m.get('loan_amount')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('bank_code') is not None:
            self.bank_code = m.get('bank_code')
        if m.get('repay_type') is not None:
            self.repay_type = m.get('repay_type')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('bank_card_no') is not None:
            self.bank_card_no = m.get('bank_card_no')
        if m.get('receipt_end_date') is not None:
            self.receipt_end_date = m.get('receipt_end_date')
        if m.get('loan_way') is not None:
            self.loan_way = m.get('loan_way')
        if m.get('lpr') is not None:
            self.lpr = m.get('lpr')
        if m.get('lpr_point') is not None:
            self.lpr_point = m.get('lpr_point')
        if m.get('lpr_effect_date') is not None:
            self.lpr_effect_date = m.get('lpr_effect_date')
        return self


class QueryDubbridgeAgreementPreviewResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        agreement_info_list: List[GetAgreementUrlResponseData] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 协议列表
        self.agreement_info_list = agreement_info_list

    def validate(self):
        if self.agreement_info_list:
            for k in self.agreement_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['agreement_info_list'] = []
        if self.agreement_info_list is not None:
            for k in self.agreement_info_list:
                result['agreement_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.agreement_info_list = []
        if m.get('agreement_info_list') is not None:
            for k in m.get('agreement_info_list'):
                temp_model = GetAgreementUrlResponseData()
                self.agreement_info_list.append(temp_model.from_map(k))
        return self


class QueryDubbridgeAccountUsecreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        channel_code: str = None,
        custom_no: str = None,
        open_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 渠道号
        self.channel_code = channel_code
        # 客户编码
        self.custom_no = custom_no
        # 资产方用户唯一标识
        self.open_id = open_id

    def validate(self):
        self.validate_required(self.channel_code, 'channel_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        return self


class QueryDubbridgeAccountUsecreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: CustomReceiptStatus = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用户借款是否结清
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = CustomReceiptStatus()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDubbridgeUserAggregationinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        open_id: str = None,
        custom_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 资产方用户唯一标识
        self.open_id = open_id
        # 客户编码
        self.custom_no = custom_no

    def validate(self):
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.custom_no is not None:
            result['custom_no'] = self.custom_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('custom_no') is not None:
            self.custom_no = m.get('custom_no')
        return self


class QueryDubbridgeUserAggregationinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        user_aggregation_info: UserAggregationInfo = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用户聚合状态信息
        self.user_aggregation_info = user_aggregation_info

    def validate(self):
        if self.user_aggregation_info:
            self.user_aggregation_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.user_aggregation_info is not None:
            result['user_aggregation_info'] = self.user_aggregation_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('user_aggregation_info') is not None:
            temp_model = UserAggregationInfo()
            self.user_aggregation_info = temp_model.from_map(m['user_aggregation_info'])
        return self


class QueryDubbridgeMarketingCouponlistRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer_no: str = None,
        status: str = None,
        page: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户号
        self.customer_no = customer_no
        # 优惠券状态
        self.status = status
        # 页码
        self.page = page
        # 每页数量
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.customer_no, 'customer_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.status is not None:
            result['status'] = self.status
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryDubbridgeMarketingCouponlistResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        coupon_list: List[CouponInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 优惠券列表
        self.coupon_list = coupon_list

    def validate(self):
        if self.coupon_list:
            for k in self.coupon_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['coupon_list'] = []
        if self.coupon_list is not None:
            for k in self.coupon_list:
                result['coupon_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.coupon_list = []
        if m.get('coupon_list') is not None:
            for k in m.get('coupon_list'):
                temp_model = CouponInfo()
                self.coupon_list.append(temp_model.from_map(k))
        return self


class QueryDubbridgeRepaytypeInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer_no: str = None,
        fund_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 客户号
        self.customer_no = customer_no
        # 资金方编号
        self.fund_code = fund_code

    def validate(self):
        self.validate_required(self.customer_no, 'customer_no')
        self.validate_required(self.fund_code, 'fund_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        return self


class QueryDubbridgeRepaytypeInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        repay_type_info_list: List[PlatformRepayTypeInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 还款方式/借款期数集合
        self.repay_type_info_list = repay_type_info_list

    def validate(self):
        if self.repay_type_info_list:
            for k in self.repay_type_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['repay_type_info_list'] = []
        if self.repay_type_info_list is not None:
            for k in self.repay_type_info_list:
                result['repay_type_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.repay_type_info_list = []
        if m.get('repay_type_info_list') is not None:
            for k in m.get('repay_type_info_list'):
                temp_model = PlatformRepayTypeInfo()
                self.repay_type_info_list.append(temp_model.from_map(k))
        return self


class QueryDubbridgeInstallmentCreditamtRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        prod_type: str = None,
        open_id: str = None,
        mobile: str = None,
        project_code: str = None,
        biz_order_no: str = None,
        card_no: str = None,
        trade_amount: str = None,
        customer_name: str = None,
        traffic_platform: str = None,
        traffic_source_name: str = None,
        traffic_ad_id: str = None,
        traffic_mkt_id: str = None,
        click_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号：request请求单号，每次请求唯一，如uuid
        self.order_no = order_no
        # 1：现金贷、2：分期付
        self.prod_type = prod_type
        # 资产方用户唯一标识
        self.open_id = open_id
        # 手机号
        self.mobile = mobile
        # 项目编号
        self.project_code = project_code
        # 资产方购物订单号，如二轮车/摩托车订单号
        self.biz_order_no = biz_order_no
        # 身份证号
        self.card_no = card_no
        # 交易金额，单位：元，如199.88（用于筛选额度充足的机构）
        self.trade_amount = trade_amount
        # 客户姓名
        self.customer_name = customer_name
        # 导流平台
        self.traffic_platform = traffic_platform
        # 流量来源名称，导流平台背后具体的流量名称
        self.traffic_source_name = traffic_source_name
        # 广告位id，流量来源内各广告位标志
        self.traffic_ad_id = traffic_ad_id
        # 营销活动编号
        self.traffic_mkt_id = traffic_mkt_id
        # 点击id
        self.click_id = click_id

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.prod_type, 'prod_type')
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.mobile, 'mobile')
        self.validate_required(self.project_code, 'project_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        if self.card_no is not None:
            result['card_no'] = self.card_no
        if self.trade_amount is not None:
            result['trade_amount'] = self.trade_amount
        if self.customer_name is not None:
            result['customer_name'] = self.customer_name
        if self.traffic_platform is not None:
            result['traffic_platform'] = self.traffic_platform
        if self.traffic_source_name is not None:
            result['traffic_source_name'] = self.traffic_source_name
        if self.traffic_ad_id is not None:
            result['traffic_ad_id'] = self.traffic_ad_id
        if self.traffic_mkt_id is not None:
            result['traffic_mkt_id'] = self.traffic_mkt_id
        if self.click_id is not None:
            result['click_id'] = self.click_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        if m.get('card_no') is not None:
            self.card_no = m.get('card_no')
        if m.get('trade_amount') is not None:
            self.trade_amount = m.get('trade_amount')
        if m.get('customer_name') is not None:
            self.customer_name = m.get('customer_name')
        if m.get('traffic_platform') is not None:
            self.traffic_platform = m.get('traffic_platform')
        if m.get('traffic_source_name') is not None:
            self.traffic_source_name = m.get('traffic_source_name')
        if m.get('traffic_ad_id') is not None:
            self.traffic_ad_id = m.get('traffic_ad_id')
        if m.get('traffic_mkt_id') is not None:
            self.traffic_mkt_id = m.get('traffic_mkt_id')
        if m.get('click_id') is not None:
            self.click_id = m.get('click_id')
        return self


class QueryDubbridgeInstallmentCreditamtResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_status: str = None,
        credit_status: str = None,
        credit_amount: int = None,
        rest_amount: int = None,
        pay_date: str = None,
        expire_date: str = None,
        rate_value: int = None,
        fund_code: str = None,
        abbre_fund_name: str = None,
        prod_type: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信申请状态：
        # 0- 通过
        # 1- 拒绝
        # 2- 审批中
        # 3- 失败
        # 
        self.apply_status = apply_status
        # 额度状态：
        # 0- 正常
        # 1- 冻结
        # 2- 过期
        self.credit_status = credit_status
        # 授信总额度，单位：元
        self.credit_amount = credit_amount
        # 可用余额
        self.rest_amount = rest_amount
        # 发放日期，yyyy-MM-dd
        self.pay_date = pay_date
        # 到期日期，yyyy-MM-dd
        self.expire_date = expire_date
        # 授信年利率。精确到小数点后四位0.1250，表示年利率为12.5%\
        self.rate_value = rate_value
        # 资金方编号
        self.fund_code = fund_code
        # 资金方简称
        self.abbre_fund_name = abbre_fund_name
        # 1：现金贷、2：分期付
        self.prod_type = prod_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_status is not None:
            result['apply_status'] = self.apply_status
        if self.credit_status is not None:
            result['credit_status'] = self.credit_status
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.rest_amount is not None:
            result['rest_amount'] = self.rest_amount
        if self.pay_date is not None:
            result['pay_date'] = self.pay_date
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.rate_value is not None:
            result['rate_value'] = self.rate_value
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.abbre_fund_name is not None:
            result['abbre_fund_name'] = self.abbre_fund_name
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_status') is not None:
            self.apply_status = m.get('apply_status')
        if m.get('credit_status') is not None:
            self.credit_status = m.get('credit_status')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('rest_amount') is not None:
            self.rest_amount = m.get('rest_amount')
        if m.get('pay_date') is not None:
            self.pay_date = m.get('pay_date')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('rate_value') is not None:
            self.rate_value = m.get('rate_value')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('abbre_fund_name') is not None:
            self.abbre_fund_name = m.get('abbre_fund_name')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        return self


class CancelDubbridgeInstallmentOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        prod_type: str = None,
        biz_order_no: str = None,
        open_id: str = None,
        customer_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号：request请求单号，每次请求唯一，如uuid
        self.order_no = order_no
        # 1：现金贷、2：分期付
        # 
        self.prod_type = prod_type
        # 待支付的购物订单编号
        self.biz_order_no = biz_order_no
        # 渠道方唯一标识
        self.open_id = open_id
        # 天枢客户号
        self.customer_no = customer_no

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.biz_order_no, 'biz_order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        return self


class CancelDubbridgeInstallmentOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        cancel_result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 订单取消请求接受结果：
        # Y: 成功; N: 失败
        self.cancel_result = cancel_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.cancel_result is not None:
            result['cancel_result'] = self.cancel_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('cancel_result') is not None:
            self.cancel_result = m.get('cancel_result')
        return self


class PushDubbridgeInstallmentSupplementRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        open_id: str = None,
        biz_order_no: str = None,
        prod_type: str = None,
        file_scene: str = None,
        file_list: List[SupplementFile] = None,
        store_info: StoreInfo = None,
        vehicle_info: VehicleInfo = None,
        additional: Additional = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号：request请求单号，每次请求唯一，如uuid
        self.order_no = order_no
        # 资产方用户唯一标识
        self.open_id = open_id
        # 资产方购物订单号，如二轮车/摩托车订单号
        self.biz_order_no = biz_order_no
        # 业务类型：1-现金贷；2-分期付
        # 
        self.prod_type = prod_type
        # 材料场景：2-支用前、3-支用后
        self.file_scene = file_scene
        # 材料列表
        self.file_list = file_list
        # 门店信息
        self.store_info = store_info
        # 订单车辆信息
        self.vehicle_info = vehicle_info
        # 补充信息
        self.additional = additional

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.biz_order_no, 'biz_order_no')
        if self.file_list:
            for k in self.file_list:
                if k:
                    k.validate()
        if self.store_info:
            self.store_info.validate()
        if self.vehicle_info:
            self.vehicle_info.validate()
        if self.additional:
            self.additional.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        if self.file_scene is not None:
            result['file_scene'] = self.file_scene
        result['file_list'] = []
        if self.file_list is not None:
            for k in self.file_list:
                result['file_list'].append(k.to_map() if k else None)
        if self.store_info is not None:
            result['store_info'] = self.store_info.to_map()
        if self.vehicle_info is not None:
            result['vehicle_info'] = self.vehicle_info.to_map()
        if self.additional is not None:
            result['additional'] = self.additional.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        if m.get('file_scene') is not None:
            self.file_scene = m.get('file_scene')
        self.file_list = []
        if m.get('file_list') is not None:
            for k in m.get('file_list'):
                temp_model = SupplementFile()
                self.file_list.append(temp_model.from_map(k))
        if m.get('store_info') is not None:
            temp_model = StoreInfo()
            self.store_info = temp_model.from_map(m['store_info'])
        if m.get('vehicle_info') is not None:
            temp_model = VehicleInfo()
            self.vehicle_info = temp_model.from_map(m['vehicle_info'])
        if m.get('additional') is not None:
            temp_model = Additional()
            self.additional = temp_model.from_map(m['additional'])
        return self


class PushDubbridgeInstallmentSupplementResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDubbridgeInstallmentTrialRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        order_no: str = None,
        prod_type: str = None,
        biz_order_no: str = None,
        customer_no: str = None,
        open_id: str = None,
        fund_code: str = None,
        trade_amount: str = None,
        coupon_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 订单号
        self.order_no = order_no
        # 业务类型，1：现金贷；2：分期付
        self.prod_type = prod_type
        # 资产方购物订单号
        self.biz_order_no = biz_order_no
        # 天枢客户号
        self.customer_no = customer_no
        # 资产方用户唯一标识
        self.open_id = open_id
        # 资金方编码
        self.fund_code = fund_code
        # 订单交易金额
        self.trade_amount = trade_amount
        # 优惠券id
        self.coupon_id = coupon_id

    def validate(self):
        self.validate_required(self.order_no, 'order_no')
        self.validate_required(self.prod_type, 'prod_type')
        self.validate_required(self.biz_order_no, 'biz_order_no')
        self.validate_required(self.open_id, 'open_id')
        self.validate_required(self.fund_code, 'fund_code')
        self.validate_required(self.trade_amount, 'trade_amount')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.prod_type is not None:
            result['prod_type'] = self.prod_type
        if self.biz_order_no is not None:
            result['biz_order_no'] = self.biz_order_no
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.open_id is not None:
            result['open_id'] = self.open_id
        if self.fund_code is not None:
            result['fund_code'] = self.fund_code
        if self.trade_amount is not None:
            result['trade_amount'] = self.trade_amount
        if self.coupon_id is not None:
            result['coupon_id'] = self.coupon_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('prod_type') is not None:
            self.prod_type = m.get('prod_type')
        if m.get('biz_order_no') is not None:
            self.biz_order_no = m.get('biz_order_no')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('open_id') is not None:
            self.open_id = m.get('open_id')
        if m.get('fund_code') is not None:
            self.fund_code = m.get('fund_code')
        if m.get('trade_amount') is not None:
            self.trade_amount = m.get('trade_amount')
        if m.get('coupon_id') is not None:
            self.coupon_id = m.get('coupon_id')
        return self


class QueryDubbridgeInstallmentTrialResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        credit_amount: str = None,
        rest_amount: str = None,
        installment_list: List[InstallmentTrial] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信额度
        self.credit_amount = credit_amount
        # 可用额度
        self.rest_amount = rest_amount
        # 期数费用列表
        self.installment_list = installment_list

    def validate(self):
        if self.installment_list:
            for k in self.installment_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.rest_amount is not None:
            result['rest_amount'] = self.rest_amount
        result['installment_list'] = []
        if self.installment_list is not None:
            for k in self.installment_list:
                result['installment_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('rest_amount') is not None:
            self.rest_amount = m.get('rest_amount')
        self.installment_list = []
        if m.get('installment_list') is not None:
            for k in m.get('installment_list'):
                temp_model = InstallmentTrial()
                self.installment_list.append(temp_model.from_map(k))
        return self


class VerifyFinserviceZhimaIdentifyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
        merchant_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要校验的人姓名
        self.legal_person_cert_name = legal_person_cert_name
        # 需要校验的人身份证号
        self.legal_person_cert_no = legal_person_cert_no
        # 认证结束后的商户回调地址。
        self.merchant_url = merchant_url

    def validate(self):
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')
        self.validate_required(self.legal_person_cert_no, 'legal_person_cert_no')
        self.validate_required(self.merchant_url, 'merchant_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        if self.merchant_url is not None:
            result['merchant_url'] = self.merchant_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        if m.get('merchant_url') is not None:
            self.merchant_url = m.get('merchant_url')
        return self


class VerifyFinserviceZhimaIdentifyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ZhimaIdentifyResp = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 本次认证的唯一标识，商户需要记录，后续的操作都需要用到。
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ZhimaIdentifyResp()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryFinserviceZhimaIdentifyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 初始化时候返回的唯一标识
        self.biz_no = biz_no

    def validate(self):
        self.validate_required(self.biz_no, 'biz_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_no is not None:
            result['biz_no'] = self.biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_no') is not None:
            self.biz_no = m.get('biz_no')
        return self


class QueryFinserviceZhimaIdentifyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: ZhimaQueryResp = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = ZhimaQueryResp()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryMdipDataserviceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        service_code: str = None,
        service_param: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务编码
        self.service_code = service_code
        # 服务参数
        self.service_param = service_param

    def validate(self):
        self.validate_required(self.service_code, 'service_code')
        self.validate_required(self.service_param, 'service_param')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.service_code is not None:
            result['service_code'] = self.service_code
        if self.service_param is not None:
            result['service_param'] = self.service_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('service_code') is not None:
            self.service_code = m.get('service_code')
        if m.get('service_param') is not None:
            self.service_param = m.get('service_param')
        return self


class QueryMdipDataserviceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 多源查询结果值
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ReceiveMdipParamsFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # file_id
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        return self


class ReceiveMdipParamsFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        content: RuntimeResult = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 文件上传结果
        self.content = content

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('content') is not None:
            temp_model = RuntimeResult()
            self.content = temp_model.from_map(m['content'])
        return self


class ReceiveMdipParamsRbbfileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
        file_name: str = None,
        tenant_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # file_id
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id
        # 文件名
        self.file_name = file_name
        # 租户code
        self.tenant_code = tenant_code

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.tenant_code, 'tenant_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.tenant_code is not None:
            result['tenant_code'] = self.tenant_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('tenant_code') is not None:
            self.tenant_code = m.get('tenant_code')
        return self


class ReceiveMdipParamsRbbfileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CallbackMdipAuditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        audit_result: str = None,
        biz_code: str = None,
        extend: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 审批结果
        self.audit_result = audit_result
        # 工单流水号
        self.biz_code = biz_code
        # 额外信息
        self.extend = extend

    def validate(self):
        self.validate_required(self.audit_result, 'audit_result')
        self.validate_required(self.biz_code, 'biz_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.audit_result is not None:
            result['audit_result'] = self.audit_result
        if self.biz_code is not None:
            result['biz_code'] = self.biz_code
        if self.extend is not None:
            result['extend'] = self.extend
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('audit_result') is not None:
            self.audit_result = m.get('audit_result')
        if m.get('biz_code') is not None:
            self.biz_code = m.get('biz_code')
        if m.get('extend') is not None:
            self.extend = m.get('extend')
        return self


class CallbackMdipAuditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryMdipDataservicePocRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        service_code: str = None,
        service_param: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务编码
        # 
        self.service_code = service_code
        # 服务参数
        self.service_param = service_param

    def validate(self):
        self.validate_required(self.service_code, 'service_code')
        self.validate_required(self.service_param, 'service_param')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.service_code is not None:
            result['service_code'] = self.service_code
        if self.service_param is not None:
            result['service_param'] = self.service_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('service_code') is not None:
            self.service_code = m.get('service_code')
        if m.get('service_param') is not None:
            self.service_param = m.get('service_param')
        return self


class QueryMdipDataservicePocResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 
        # 多源查询结果值
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ListMdipDefaultSupplierRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        default_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # ANTCLOUD
        self.default_tenant = default_tenant

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.default_tenant is not None:
            result['default_tenant'] = self.default_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('default_tenant') is not None:
            self.default_tenant = m.get('default_tenant')
        return self


class ListMdipDefaultSupplierResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        supplier_list: List[Supplier] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 供应商列表
        self.supplier_list = supplier_list

    def validate(self):
        if self.supplier_list:
            for k in self.supplier_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['supplier_list'] = []
        if self.supplier_list is not None:
            for k in self.supplier_list:
                result['supplier_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.supplier_list = []
        if m.get('supplier_list') is not None:
            for k in m.get('supplier_list'):
                temp_model = Supplier()
                self.supplier_list.append(temp_model.from_map(k))
        return self


class CallbackMdipYunfengdieParamsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        params_map: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 回调参数
        self.params_map = params_map

    def validate(self):
        self.validate_required(self.params_map, 'params_map')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.params_map is not None:
            result['params_map'] = self.params_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('params_map') is not None:
            self.params_map = m.get('params_map')
        return self


class CallbackMdipYunfengdieParamsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ApplyQmpRtBatchmarketingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        scene_strategy_id: int = None,
        out_serial_no: str = None,
        param_type: str = None,
        out_info: str = None,
        customer_details: List[CustomerDetail] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 外部流水号
        self.out_serial_no = out_serial_no
        # 用户标识类型
        self.param_type = param_type
        # 批量透传字段
        self.out_info = out_info
        # 用户凭证列表
        self.customer_details = customer_details

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.out_serial_no, 'out_serial_no')
        self.validate_required(self.param_type, 'param_type')
        self.validate_required(self.customer_details, 'customer_details')
        if self.customer_details:
            for k in self.customer_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.out_serial_no is not None:
            result['out_serial_no'] = self.out_serial_no
        if self.param_type is not None:
            result['param_type'] = self.param_type
        if self.out_info is not None:
            result['out_info'] = self.out_info
        result['customer_details'] = []
        if self.customer_details is not None:
            for k in self.customer_details:
                result['customer_details'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('out_serial_no') is not None:
            self.out_serial_no = m.get('out_serial_no')
        if m.get('param_type') is not None:
            self.param_type = m.get('param_type')
        if m.get('out_info') is not None:
            self.out_info = m.get('out_info')
        self.customer_details = []
        if m.get('customer_details') is not None:
            for k in m.get('customer_details'):
                temp_model = CustomerDetail()
                self.customer_details.append(temp_model.from_map(k))
        return self


class ApplyQmpRtBatchmarketingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次流水号
        self.biz_id = biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        return self


class SendQmpTextsmsBatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cpass_ak: str = None,
        industry_tag: str = None,
        phone_number_json: str = None,
        sign_name_json: str = None,
        template_code: str = None,
        template_param_json: str = None,
        sms_up_extend_code_json: str = None,
        out_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cpassAccessKey
        self.cpass_ak = cpass_ak
        # 行业标签
        self.industry_tag = industry_tag
        # 手机号json
        self.phone_number_json = phone_number_json
        # 签名信息
        self.sign_name_json = sign_name_json
        # 文本短信模板code
        self.template_code = template_code
        # 文本短信模板参数
        self.template_param_json = template_param_json
        # 上行短信扩展码
        self.sms_up_extend_code_json = sms_up_extend_code_json
        # 透传字段
        self.out_id = out_id

    def validate(self):
        self.validate_required(self.industry_tag, 'industry_tag')
        self.validate_required(self.phone_number_json, 'phone_number_json')
        self.validate_required(self.sign_name_json, 'sign_name_json')
        self.validate_required(self.template_code, 'template_code')
        self.validate_required(self.template_param_json, 'template_param_json')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cpass_ak is not None:
            result['cpass_ak'] = self.cpass_ak
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        if self.phone_number_json is not None:
            result['phone_number_json'] = self.phone_number_json
        if self.sign_name_json is not None:
            result['sign_name_json'] = self.sign_name_json
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.template_param_json is not None:
            result['template_param_json'] = self.template_param_json
        if self.sms_up_extend_code_json is not None:
            result['sms_up_extend_code_json'] = self.sms_up_extend_code_json
        if self.out_id is not None:
            result['out_id'] = self.out_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cpass_ak') is not None:
            self.cpass_ak = m.get('cpass_ak')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        if m.get('phone_number_json') is not None:
            self.phone_number_json = m.get('phone_number_json')
        if m.get('sign_name_json') is not None:
            self.sign_name_json = m.get('sign_name_json')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('template_param_json') is not None:
            self.template_param_json = m.get('template_param_json')
        if m.get('sms_up_extend_code_json') is not None:
            self.sms_up_extend_code_json = m.get('sms_up_extend_code_json')
        if m.get('out_id') is not None:
            self.out_id = m.get('out_id')
        return self


class SendQmpTextsmsBatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 回执id
        self.biz_id = biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        return self


class ApplyQmpRobotcallRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        out_serial_no: str = None,
        scene_strategy_id: int = None,
        out_info: str = None,
        param_template: str = None,
        customer_details: List[RobotCallCustomerParam] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 外部流水号
        self.out_serial_no = out_serial_no
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 客户透传字段
        self.out_info = out_info
        # 用户参数类型
        self.param_template = param_template
        # 每个手机号的详细参数
        self.customer_details = customer_details

    def validate(self):
        self.validate_required(self.out_serial_no, 'out_serial_no')
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.param_template, 'param_template')
        if self.customer_details:
            for k in self.customer_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.out_serial_no is not None:
            result['out_serial_no'] = self.out_serial_no
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.out_info is not None:
            result['out_info'] = self.out_info
        if self.param_template is not None:
            result['param_template'] = self.param_template
        result['customer_details'] = []
        if self.customer_details is not None:
            for k in self.customer_details:
                result['customer_details'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('out_serial_no') is not None:
            self.out_serial_no = m.get('out_serial_no')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('out_info') is not None:
            self.out_info = m.get('out_info')
        if m.get('param_template') is not None:
            self.param_template = m.get('param_template')
        self.customer_details = []
        if m.get('customer_details') is not None:
            for k in m.get('customer_details'):
                temp_model = RobotCallCustomerParam()
                self.customer_details.append(temp_model.from_map(k))
        return self


class ApplyQmpRobotcallResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        call_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 呼叫记录id
        self.call_id = call_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.call_id is not None:
            result['call_id'] = self.call_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('call_id') is not None:
            self.call_id = m.get('call_id')
        return self


class SendQmpCardsmsBatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cpass_ak: str = None,
        industry_tag: str = None,
        card_template_code: str = None,
        card_template_param_json: str = None,
        phone_number_json: str = None,
        sign_name_json: str = None,
        sms_up_extend_code_json: str = None,
        fallback_type: str = None,
        fallback_template_code: str = None,
        fallback_template_param_json: str = None,
        template_code: str = None,
        template_param_json: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cpassAccessKey
        self.cpass_ak = cpass_ak
        # 行业标签
        self.industry_tag = industry_tag
        # 卡片短信模板
        self.card_template_code = card_template_code
        # 卡片短信模板参数json
        self.card_template_param_json = card_template_param_json
        # 手机号json
        self.phone_number_json = phone_number_json
        # ["蚂蚁营销"]
        self.sign_name_json = sign_name_json
        # 上行短信扩展码
        self.sms_up_extend_code_json = sms_up_extend_code_json
        # 回落类型
        self.fallback_type = fallback_type
        # 回落短信模版
        self.fallback_template_code = fallback_template_code
        # 回落短信模版参数
        self.fallback_template_param_json = fallback_template_param_json
        # 卡片短信对应的原始文本短信模板，不传则用默认文本
        self.template_code = template_code
        # 默认文本对应参数
        self.template_param_json = template_param_json

    def validate(self):
        self.validate_required(self.industry_tag, 'industry_tag')
        self.validate_required(self.card_template_code, 'card_template_code')
        self.validate_required(self.card_template_param_json, 'card_template_param_json')
        self.validate_required(self.phone_number_json, 'phone_number_json')
        self.validate_required(self.sign_name_json, 'sign_name_json')
        self.validate_required(self.template_code, 'template_code')
        self.validate_required(self.template_param_json, 'template_param_json')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cpass_ak is not None:
            result['cpass_ak'] = self.cpass_ak
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        if self.card_template_code is not None:
            result['card_template_code'] = self.card_template_code
        if self.card_template_param_json is not None:
            result['card_template_param_json'] = self.card_template_param_json
        if self.phone_number_json is not None:
            result['phone_number_json'] = self.phone_number_json
        if self.sign_name_json is not None:
            result['sign_name_json'] = self.sign_name_json
        if self.sms_up_extend_code_json is not None:
            result['sms_up_extend_code_json'] = self.sms_up_extend_code_json
        if self.fallback_type is not None:
            result['fallback_type'] = self.fallback_type
        if self.fallback_template_code is not None:
            result['fallback_template_code'] = self.fallback_template_code
        if self.fallback_template_param_json is not None:
            result['fallback_template_param_json'] = self.fallback_template_param_json
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.template_param_json is not None:
            result['template_param_json'] = self.template_param_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cpass_ak') is not None:
            self.cpass_ak = m.get('cpass_ak')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        if m.get('card_template_code') is not None:
            self.card_template_code = m.get('card_template_code')
        if m.get('card_template_param_json') is not None:
            self.card_template_param_json = m.get('card_template_param_json')
        if m.get('phone_number_json') is not None:
            self.phone_number_json = m.get('phone_number_json')
        if m.get('sign_name_json') is not None:
            self.sign_name_json = m.get('sign_name_json')
        if m.get('sms_up_extend_code_json') is not None:
            self.sms_up_extend_code_json = m.get('sms_up_extend_code_json')
        if m.get('fallback_type') is not None:
            self.fallback_type = m.get('fallback_type')
        if m.get('fallback_template_code') is not None:
            self.fallback_template_code = m.get('fallback_template_code')
        if m.get('fallback_template_param_json') is not None:
            self.fallback_template_param_json = m.get('fallback_template_param_json')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('template_param_json') is not None:
            self.template_param_json = m.get('template_param_json')
        return self


class SendQmpCardsmsBatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_card_id: str = None,
        media_mobiles: str = None,
        not_media_mobiles: str = None,
        biz_id: str = None,
        biz_digital_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 卡片短信回执id
        self.biz_card_id = biz_card_id
        # 支持的手机号
        self.media_mobiles = media_mobiles
        # 不支持的手机号
        self.not_media_mobiles = not_media_mobiles
        # 回落文本短信回执id
        self.biz_id = biz_id
        # 回落数字短信回执id
        self.biz_digital_id = biz_digital_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_card_id is not None:
            result['biz_card_id'] = self.biz_card_id
        if self.media_mobiles is not None:
            result['media_mobiles'] = self.media_mobiles
        if self.not_media_mobiles is not None:
            result['not_media_mobiles'] = self.not_media_mobiles
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.biz_digital_id is not None:
            result['biz_digital_id'] = self.biz_digital_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_card_id') is not None:
            self.biz_card_id = m.get('biz_card_id')
        if m.get('media_mobiles') is not None:
            self.media_mobiles = m.get('media_mobiles')
        if m.get('not_media_mobiles') is not None:
            self.not_media_mobiles = m.get('not_media_mobiles')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('biz_digital_id') is not None:
            self.biz_digital_id = m.get('biz_digital_id')
        return self


class CallbackQmpSmsUpRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        type: str = None,
        phone_number: str = None,
        send_time: str = None,
        content: str = None,
        sign_name: str = None,
        app_key: str = None,
        dest_code: str = None,
        sequence_id: int = None,
        key_template: str = None,
        origin_key_template: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 回执类型
        self.type = type
        # 手机号码
        self.phone_number = phone_number
        # 发送时间
        self.send_time = send_time
        # 发送内容
        self.content = content
        # 签名信息
        self.sign_name = sign_name
        # 签名对应的客户ak
        self.app_key = app_key
        # 行短信扩展号码
        self.dest_code = dest_code
        # 序列号
        self.sequence_id = sequence_id
        # 手机号模版类型
        # 
        self.key_template = key_template
        # 原始手机号模版类型
        self.origin_key_template = origin_key_template

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.phone_number, 'phone_number')
        self.validate_required(self.send_time, 'send_time')
        self.validate_required(self.content, 'content')
        self.validate_required(self.sign_name, 'sign_name')
        self.validate_required(self.app_key, 'app_key')
        self.validate_required(self.dest_code, 'dest_code')
        self.validate_required(self.sequence_id, 'sequence_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.type is not None:
            result['type'] = self.type
        if self.phone_number is not None:
            result['phone_number'] = self.phone_number
        if self.send_time is not None:
            result['send_time'] = self.send_time
        if self.content is not None:
            result['content'] = self.content
        if self.sign_name is not None:
            result['sign_name'] = self.sign_name
        if self.app_key is not None:
            result['app_key'] = self.app_key
        if self.dest_code is not None:
            result['dest_code'] = self.dest_code
        if self.sequence_id is not None:
            result['sequence_id'] = self.sequence_id
        if self.key_template is not None:
            result['key_template'] = self.key_template
        if self.origin_key_template is not None:
            result['origin_key_template'] = self.origin_key_template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('phone_number') is not None:
            self.phone_number = m.get('phone_number')
        if m.get('send_time') is not None:
            self.send_time = m.get('send_time')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('sign_name') is not None:
            self.sign_name = m.get('sign_name')
        if m.get('app_key') is not None:
            self.app_key = m.get('app_key')
        if m.get('dest_code') is not None:
            self.dest_code = m.get('dest_code')
        if m.get('sequence_id') is not None:
            self.sequence_id = m.get('sequence_id')
        if m.get('key_template') is not None:
            self.key_template = m.get('key_template')
        if m.get('origin_key_template') is not None:
            self.origin_key_template = m.get('origin_key_template')
        return self


class CallbackQmpSmsUpResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CallbackQmpSmsReportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        type: str = None,
        phone_number: str = None,
        send_time: str = None,
        report_time: str = None,
        success: bool = None,
        err_code: str = None,
        err_msg: str = None,
        sms_size: str = None,
        biz_id: str = None,
        biz_properties: str = None,
        sms_type: str = None,
        service_provider: str = None,
        city: str = None,
        key_template: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 短信回执类型
        self.type = type
        # 手机号码
        self.phone_number = phone_number
        # 发送时间
        self.send_time = send_time
        # 状态报告时间
        self.report_time = report_time
        # 是否接收成功。取值：true：接收成功false：接收失败
        self.success = success
        # 状态报告编码
        self.err_code = err_code
        # 状态报告说明
        self.err_msg = err_msg
        # 短信长度
        self.sms_size = sms_size
        # 发送回执ID，即发送流水号
        self.biz_id = biz_id
        # 业务扩展字段，回执时透传，JSON格式
        self.biz_properties = biz_properties
        # 发送卡片短信时，文本短信状态报告中才会有该字段，且取值为CARD_SMS，发送纯文本短信时，状态报告中没有该字段
        self.sms_type = sms_type
        # 运营商
        self.service_provider = service_provider
        # 手机号码所属城市
        self.city = city
        # 手机号模版类型
        self.key_template = key_template

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.phone_number, 'phone_number')
        self.validate_required(self.send_time, 'send_time')
        self.validate_required(self.report_time, 'report_time')
        self.validate_required(self.success, 'success')
        self.validate_required(self.err_code, 'err_code')
        self.validate_required(self.err_msg, 'err_msg')
        self.validate_required(self.sms_size, 'sms_size')
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.biz_properties, 'biz_properties')
        self.validate_required(self.service_provider, 'service_provider')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.type is not None:
            result['type'] = self.type
        if self.phone_number is not None:
            result['phone_number'] = self.phone_number
        if self.send_time is not None:
            result['send_time'] = self.send_time
        if self.report_time is not None:
            result['report_time'] = self.report_time
        if self.success is not None:
            result['success'] = self.success
        if self.err_code is not None:
            result['err_code'] = self.err_code
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.sms_size is not None:
            result['sms_size'] = self.sms_size
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.biz_properties is not None:
            result['biz_properties'] = self.biz_properties
        if self.sms_type is not None:
            result['sms_type'] = self.sms_type
        if self.service_provider is not None:
            result['service_provider'] = self.service_provider
        if self.city is not None:
            result['city'] = self.city
        if self.key_template is not None:
            result['key_template'] = self.key_template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('phone_number') is not None:
            self.phone_number = m.get('phone_number')
        if m.get('send_time') is not None:
            self.send_time = m.get('send_time')
        if m.get('report_time') is not None:
            self.report_time = m.get('report_time')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('err_code') is not None:
            self.err_code = m.get('err_code')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('sms_size') is not None:
            self.sms_size = m.get('sms_size')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('biz_properties') is not None:
            self.biz_properties = m.get('biz_properties')
        if m.get('sms_type') is not None:
            self.sms_type = m.get('sms_type')
        if m.get('service_provider') is not None:
            self.service_provider = m.get('service_provider')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('key_template') is not None:
            self.key_template = m.get('key_template')
        return self


class CallbackQmpSmsReportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SendQmpDigitalsmsBatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cpass_ak: str = None,
        industry_tag: str = None,
        phone_numbers: str = None,
        template_code: str = None,
        template_param: str = None,
        out_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cpassAccessKey
        self.cpass_ak = cpass_ak
        # 行业标签
        self.industry_tag = industry_tag
        # 手机号列表以,分隔
        self.phone_numbers = phone_numbers
        # 数字短信模板code
        self.template_code = template_code
        # 短信模板参数
        self.template_param = template_param
        # 透传字段
        self.out_id = out_id

    def validate(self):
        self.validate_required(self.industry_tag, 'industry_tag')
        self.validate_required(self.phone_numbers, 'phone_numbers')
        self.validate_required(self.template_code, 'template_code')
        self.validate_required(self.template_param, 'template_param')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cpass_ak is not None:
            result['cpass_ak'] = self.cpass_ak
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        if self.phone_numbers is not None:
            result['phone_numbers'] = self.phone_numbers
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.template_param is not None:
            result['template_param'] = self.template_param
        if self.out_id is not None:
            result['out_id'] = self.out_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cpass_ak') is not None:
            self.cpass_ak = m.get('cpass_ak')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        if m.get('phone_numbers') is not None:
            self.phone_numbers = m.get('phone_numbers')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('template_param') is not None:
            self.template_param = m.get('template_param')
        if m.get('out_id') is not None:
            self.out_id = m.get('out_id')
        return self


class SendQmpDigitalsmsBatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        biz_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 回执id
        self.biz_id = biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        return self


class CallbackQmpRobotcallRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer_key: str = None,
        current_call_times: int = None,
        key_template: str = None,
        batch_id: str = None,
        call_type: int = None,
        tag: str = None,
        call_id: str = None,
        task_id: int = None,
        task_name: str = None,
        template_id: int = None,
        status_code: int = None,
        status_description: str = None,
        transfer_status_code: str = None,
        transfer_status: str = None,
        agent_id: int = None,
        agent_tag: str = None,
        agent_extension: str = None,
        import_time: str = None,
        call_begin_time: str = None,
        ring_time: int = None,
        answer_time: str = None,
        speaking_time: str = None,
        speaking_duration: int = None,
        hangup_time: str = None,
        speaking_turns: int = None,
        agent_speaking_time: str = None,
        agent_speaking_duration: int = None,
        intent_tag: str = None,
        intent_description: str = None,
        individual_tag: str = None,
        keywords: str = None,
        hungup_type: int = None,
        sms: int = None,
        chat_record: str = None,
        chats: str = None,
        add_wx: int = None,
        add_wx_status: str = None,
        answer_recall: int = None,
        properties: str = None,
        biz_properties: str = None,
        intercept_reason: str = None,
        ext_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 外呼号码，支持密文
        self.customer_key = customer_key
        # 当前呼叫次数 Integer
        self.current_call_times = current_call_times
        # 号码的模版类型
        self.key_template = key_template
        # 导入号码时返回的批次号
        self.batch_id = batch_id
        # 外呼类型 建议按照如下约定给到 2001:批量-预测外呼 2002:批量-AI外呼-不转人工 2003:批量-AI外呼-接通转人工 2004: 批量-AI外呼-智能转人工 2005:批量-语音通知
        self.call_type = call_type
        # 用户自定义标签
        self.tag = tag
        # 外呼呼叫实例id
        self.call_id = call_id
        # 外呼任务编号
        self.task_id = task_id
        # 外呼任务名称
        self.task_name = task_name
        # 外呼的话术模板ID，可以为空
        self.template_id = template_id
        # 外呼状态编码
        self.status_code = status_code
        # 外呼状态编码对应描述
        self.status_description = status_description
        # 转人工状态编码
        self.transfer_status_code = transfer_status_code
        # 转人工状态编码对应描述
        self.transfer_status = transfer_status
        # 分配坐席ID,可以为空
        self.agent_id = agent_id
        # 建议填写坐席在贵司业务系统唯一标识，用于查询对应agentId；可以为空。
        self.agent_tag = agent_tag
        # 坐席分机号，可以为空
        self.agent_extension = agent_extension
        # 导入时间，格式:2019-01-09 14:14:19
        self.import_time = import_time
        # 开始通话时间，格式：2019-01-09 14:14:19
        self.call_begin_time = call_begin_time
        # 振铃时长,单位毫秒
        self.ring_time = ring_time
        # 接通时间
        self.answer_time = answer_time
        # 通话时长，单位：大于1分钟，显示分钟秒，小于1分钟，显示秒
        self.speaking_time = speaking_time
        # 通话时长，单位：秒
        self.speaking_duration = speaking_duration
        # 通话挂断时间
        self.hangup_time = hangup_time
        # 对话轮次
        self.speaking_turns = speaking_turns
        # 坐席通话时长，单位：大于1分钟，显示分钟秒，小于1分钟，显示秒
        self.agent_speaking_time = agent_speaking_time
        # 坐席通话时长，单位：秒
        self.agent_speaking_duration = agent_speaking_duration
        # 意向标签
        self.intent_tag = intent_tag
        # 意向说明
        self.intent_description = intent_description
        # 个性标签
        self.individual_tag = individual_tag
        # 回复关键词
        self.keywords = keywords
        # 挂机方式
        self.hungup_type = hungup_type
        # 挂机短信，1:发送，2:不发送
        self.sms = sms
        # 对话录音,url
        self.chat_record = chat_record
        # 对话记录
        self.chats = chats
        # 0:不添加，1:添加
        self.add_wx = add_wx
        # 加微进度可选值：已申请、加微成功
        self.add_wx_status = add_wx_status
        # 是否接通重呼 0正常外呼，1接通重呼
        self.answer_recall = answer_recall
        # 导入号码时的参数值
        self.properties = properties
        # 导入号码时的业务参数值
        self.biz_properties = biz_properties
        # 拦截原因 可选值：黑名单拦截，灰名单拦截，异常号码拦截
        self.intercept_reason = intercept_reason
        # 回调冗余字段
        self.ext_info = ext_info

    def validate(self):
        self.validate_required(self.customer_key, 'customer_key')
        self.validate_required(self.current_call_times, 'current_call_times')
        self.validate_required(self.key_template, 'key_template')
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.call_type, 'call_type')
        self.validate_required(self.call_id, 'call_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_name, 'task_name')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.status_description, 'status_description')
        self.validate_required(self.transfer_status_code, 'transfer_status_code')
        self.validate_required(self.transfer_status, 'transfer_status')
        self.validate_required(self.import_time, 'import_time')
        self.validate_required(self.call_begin_time, 'call_begin_time')
        self.validate_required(self.ring_time, 'ring_time')
        self.validate_required(self.speaking_time, 'speaking_time')
        self.validate_required(self.speaking_duration, 'speaking_duration')
        self.validate_required(self.hangup_time, 'hangup_time')
        self.validate_required(self.speaking_turns, 'speaking_turns')
        self.validate_required(self.agent_speaking_time, 'agent_speaking_time')
        self.validate_required(self.agent_speaking_duration, 'agent_speaking_duration')
        self.validate_required(self.intent_tag, 'intent_tag')
        self.validate_required(self.intent_description, 'intent_description')
        self.validate_required(self.hungup_type, 'hungup_type')
        self.validate_required(self.sms, 'sms')
        self.validate_required(self.answer_recall, 'answer_recall')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.current_call_times is not None:
            result['current_call_times'] = self.current_call_times
        if self.key_template is not None:
            result['key_template'] = self.key_template
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.call_type is not None:
            result['call_type'] = self.call_type
        if self.tag is not None:
            result['tag'] = self.tag
        if self.call_id is not None:
            result['call_id'] = self.call_id
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.task_name is not None:
            result['task_name'] = self.task_name
        if self.template_id is not None:
            result['template_id'] = self.template_id
        if self.status_code is not None:
            result['status_code'] = self.status_code
        if self.status_description is not None:
            result['status_description'] = self.status_description
        if self.transfer_status_code is not None:
            result['transfer_status_code'] = self.transfer_status_code
        if self.transfer_status is not None:
            result['transfer_status'] = self.transfer_status
        if self.agent_id is not None:
            result['agent_id'] = self.agent_id
        if self.agent_tag is not None:
            result['agent_tag'] = self.agent_tag
        if self.agent_extension is not None:
            result['agent_extension'] = self.agent_extension
        if self.import_time is not None:
            result['import_time'] = self.import_time
        if self.call_begin_time is not None:
            result['call_begin_time'] = self.call_begin_time
        if self.ring_time is not None:
            result['ring_time'] = self.ring_time
        if self.answer_time is not None:
            result['answer_time'] = self.answer_time
        if self.speaking_time is not None:
            result['speaking_time'] = self.speaking_time
        if self.speaking_duration is not None:
            result['speaking_duration'] = self.speaking_duration
        if self.hangup_time is not None:
            result['hangup_time'] = self.hangup_time
        if self.speaking_turns is not None:
            result['speaking_turns'] = self.speaking_turns
        if self.agent_speaking_time is not None:
            result['agent_speaking_time'] = self.agent_speaking_time
        if self.agent_speaking_duration is not None:
            result['agent_speaking_duration'] = self.agent_speaking_duration
        if self.intent_tag is not None:
            result['intent_tag'] = self.intent_tag
        if self.intent_description is not None:
            result['intent_description'] = self.intent_description
        if self.individual_tag is not None:
            result['individual_tag'] = self.individual_tag
        if self.keywords is not None:
            result['keywords'] = self.keywords
        if self.hungup_type is not None:
            result['hungup_type'] = self.hungup_type
        if self.sms is not None:
            result['sms'] = self.sms
        if self.chat_record is not None:
            result['chat_record'] = self.chat_record
        if self.chats is not None:
            result['chats'] = self.chats
        if self.add_wx is not None:
            result['add_wx'] = self.add_wx
        if self.add_wx_status is not None:
            result['add_wx_status'] = self.add_wx_status
        if self.answer_recall is not None:
            result['answer_recall'] = self.answer_recall
        if self.properties is not None:
            result['properties'] = self.properties
        if self.biz_properties is not None:
            result['biz_properties'] = self.biz_properties
        if self.intercept_reason is not None:
            result['intercept_reason'] = self.intercept_reason
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('current_call_times') is not None:
            self.current_call_times = m.get('current_call_times')
        if m.get('key_template') is not None:
            self.key_template = m.get('key_template')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('call_type') is not None:
            self.call_type = m.get('call_type')
        if m.get('tag') is not None:
            self.tag = m.get('tag')
        if m.get('call_id') is not None:
            self.call_id = m.get('call_id')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('task_name') is not None:
            self.task_name = m.get('task_name')
        if m.get('template_id') is not None:
            self.template_id = m.get('template_id')
        if m.get('status_code') is not None:
            self.status_code = m.get('status_code')
        if m.get('status_description') is not None:
            self.status_description = m.get('status_description')
        if m.get('transfer_status_code') is not None:
            self.transfer_status_code = m.get('transfer_status_code')
        if m.get('transfer_status') is not None:
            self.transfer_status = m.get('transfer_status')
        if m.get('agent_id') is not None:
            self.agent_id = m.get('agent_id')
        if m.get('agent_tag') is not None:
            self.agent_tag = m.get('agent_tag')
        if m.get('agent_extension') is not None:
            self.agent_extension = m.get('agent_extension')
        if m.get('import_time') is not None:
            self.import_time = m.get('import_time')
        if m.get('call_begin_time') is not None:
            self.call_begin_time = m.get('call_begin_time')
        if m.get('ring_time') is not None:
            self.ring_time = m.get('ring_time')
        if m.get('answer_time') is not None:
            self.answer_time = m.get('answer_time')
        if m.get('speaking_time') is not None:
            self.speaking_time = m.get('speaking_time')
        if m.get('speaking_duration') is not None:
            self.speaking_duration = m.get('speaking_duration')
        if m.get('hangup_time') is not None:
            self.hangup_time = m.get('hangup_time')
        if m.get('speaking_turns') is not None:
            self.speaking_turns = m.get('speaking_turns')
        if m.get('agent_speaking_time') is not None:
            self.agent_speaking_time = m.get('agent_speaking_time')
        if m.get('agent_speaking_duration') is not None:
            self.agent_speaking_duration = m.get('agent_speaking_duration')
        if m.get('intent_tag') is not None:
            self.intent_tag = m.get('intent_tag')
        if m.get('intent_description') is not None:
            self.intent_description = m.get('intent_description')
        if m.get('individual_tag') is not None:
            self.individual_tag = m.get('individual_tag')
        if m.get('keywords') is not None:
            self.keywords = m.get('keywords')
        if m.get('hungup_type') is not None:
            self.hungup_type = m.get('hungup_type')
        if m.get('sms') is not None:
            self.sms = m.get('sms')
        if m.get('chat_record') is not None:
            self.chat_record = m.get('chat_record')
        if m.get('chats') is not None:
            self.chats = m.get('chats')
        if m.get('add_wx') is not None:
            self.add_wx = m.get('add_wx')
        if m.get('add_wx_status') is not None:
            self.add_wx_status = m.get('add_wx_status')
        if m.get('answer_recall') is not None:
            self.answer_recall = m.get('answer_recall')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        if m.get('biz_properties') is not None:
            self.biz_properties = m.get('biz_properties')
        if m.get('intercept_reason') is not None:
            self.intercept_reason = m.get('intercept_reason')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        return self


class CallbackQmpRobotcallResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryQmpRobotcallDetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_id: str = None,
        phone_number: str = None,
        template_type: str = None,
        scene_strategy_id: int = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次号
        self.biz_id = biz_id
        # 手机号
        self.phone_number = phone_number
        # 手机号类型
        self.template_type = template_type
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.phone_number, 'phone_number')
        self.validate_required(self.template_type, 'template_type')
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.phone_number is not None:
            result['phone_number'] = self.phone_number
        if self.template_type is not None:
            result['template_type'] = self.template_type
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('phone_number') is not None:
            self.phone_number = m.get('phone_number')
        if m.get('template_type') is not None:
            self.template_type = m.get('template_type')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class QueryQmpRobotcallDetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        out_info: str = None,
        customer_out_info: str = None,
        call_info: List[AICallbackMessage] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求时的透传字段
        self.out_info = out_info
        # 请求时每个手机号的透传字段
        self.customer_out_info = customer_out_info
        # 外呼记录列表
        self.call_info = call_info

    def validate(self):
        if self.call_info:
            for k in self.call_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.out_info is not None:
            result['out_info'] = self.out_info
        if self.customer_out_info is not None:
            result['customer_out_info'] = self.customer_out_info
        result['call_info'] = []
        if self.call_info is not None:
            for k in self.call_info:
                result['call_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('out_info') is not None:
            self.out_info = m.get('out_info')
        if m.get('customer_out_info') is not None:
            self.customer_out_info = m.get('customer_out_info')
        self.call_info = []
        if m.get('call_info') is not None:
            for k in m.get('call_info'):
                temp_model = AICallbackMessage()
                self.call_info.append(temp_model.from_map(k))
        return self


class QueryQmpDataaccessStatisticRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        task_id: int = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询回执统计的任务id
        self.task_id = task_id
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class QueryQmpDataaccessStatisticResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        statistic_result: StatisticResult = None,
        task_status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 回执统计结果
        self.statistic_result = statistic_result
        # 任务状态
        self.task_status = task_status

    def validate(self):
        if self.statistic_result:
            self.statistic_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.statistic_result is not None:
            result['statistic_result'] = self.statistic_result.to_map()
        if self.task_status is not None:
            result['task_status'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('statistic_result') is not None:
            temp_model = StatisticResult()
            self.statistic_result = temp_model.from_map(m['statistic_result'])
        if m.get('task_status') is not None:
            self.task_status = m.get('task_status')
        return self


class QueryQmpRobotcallStatisticinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        scene_strategy_id: int = None,
        out_info: str = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 客户透传字段
        self.out_info = out_info
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')
        self.validate_required(self.out_info, 'out_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.out_info is not None:
            result['out_info'] = self.out_info
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('out_info') is not None:
            self.out_info = m.get('out_info')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class QueryQmpRobotcallStatisticinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total_count: int = None,
        call_count: int = None,
        callee_count: int = None,
        connect_count: int = None,
        call_rate: str = None,
        connect_rate: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 全量手机号数量
        self.total_count = total_count
        # 累计拨打次数
        self.call_count = call_count
        # 已经拨打的手机号数量
        self.callee_count = callee_count
        # 已拨打次数中接通的数量
        self.connect_count = connect_count
        # 拨打率
        self.call_rate = call_rate
        # 接通率
        self.connect_rate = connect_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total_count is not None:
            result['total_count'] = self.total_count
        if self.call_count is not None:
            result['call_count'] = self.call_count
        if self.callee_count is not None:
            result['callee_count'] = self.callee_count
        if self.connect_count is not None:
            result['connect_count'] = self.connect_count
        if self.call_rate is not None:
            result['call_rate'] = self.call_rate
        if self.connect_rate is not None:
            result['connect_rate'] = self.connect_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        if m.get('call_count') is not None:
            self.call_count = m.get('call_count')
        if m.get('callee_count') is not None:
            self.callee_count = m.get('callee_count')
        if m.get('connect_count') is not None:
            self.connect_count = m.get('connect_count')
        if m.get('call_rate') is not None:
            self.call_rate = m.get('call_rate')
        if m.get('connect_rate') is not None:
            self.connect_rate = m.get('connect_rate')
        return self


class BatchqueryQmpTaskDetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_id: str = None,
        customer_keys: List[str] = None,
        key_template: str = None,
        scene_strategy_id: int = None,
        call_date: str = None,
        end_call_date: str = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 上传外呼任务返回的callId
        self.biz_id = biz_id
        # 手机号列表
        self.customer_keys = customer_keys
        # 手机号类型
        self.key_template = key_template
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 开始外呼时间，只可查询最近30天的日期
        self.call_date = call_date
        # 结束外呼时间
        self.end_call_date = end_call_date
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.customer_keys, 'customer_keys')
        self.validate_required(self.key_template, 'key_template')
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_id is not None:
            result['biz_id'] = self.biz_id
        if self.customer_keys is not None:
            result['customer_keys'] = self.customer_keys
        if self.key_template is not None:
            result['key_template'] = self.key_template
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.call_date is not None:
            result['call_date'] = self.call_date
        if self.end_call_date is not None:
            result['end_call_date'] = self.end_call_date
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_id') is not None:
            self.biz_id = m.get('biz_id')
        if m.get('customer_keys') is not None:
            self.customer_keys = m.get('customer_keys')
        if m.get('key_template') is not None:
            self.key_template = m.get('key_template')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('call_date') is not None:
            self.call_date = m.get('call_date')
        if m.get('end_call_date') is not None:
            self.end_call_date = m.get('end_call_date')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class BatchqueryQmpTaskDetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        out_info: str = None,
        call_info: List[CommonRobotCallDetail] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户请求时的透传字段
        self.out_info = out_info
        # 外呼记录列表
        self.call_info = call_info

    def validate(self):
        if self.call_info:
            for k in self.call_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.out_info is not None:
            result['out_info'] = self.out_info
        result['call_info'] = []
        if self.call_info is not None:
            for k in self.call_info:
                result['call_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('out_info') is not None:
            self.out_info = m.get('out_info')
        self.call_info = []
        if m.get('call_info') is not None:
            for k in m.get('call_info'):
                temp_model = CommonRobotCallDetail()
                self.call_info.append(temp_model.from_map(k))
        return self


class QueryQmpCardsmsSupportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cpass_ak: str = None,
        industry_tag: str = None,
        template_code: str = None,
        mobiles: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cpassAccessKey
        self.cpass_ak = cpass_ak
        # 行业标签
        self.industry_tag = industry_tag
        # 卡片短信模板
        self.template_code = template_code
        # 手机号
        self.mobiles = mobiles

    def validate(self):
        self.validate_required(self.industry_tag, 'industry_tag')
        self.validate_required(self.template_code, 'template_code')
        self.validate_required(self.mobiles, 'mobiles')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cpass_ak is not None:
            result['cpass_ak'] = self.cpass_ak
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        if self.template_code is not None:
            result['template_code'] = self.template_code
        if self.mobiles is not None:
            result['mobiles'] = self.mobiles
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cpass_ak') is not None:
            self.cpass_ak = m.get('cpass_ak')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        if m.get('template_code') is not None:
            self.template_code = m.get('template_code')
        if m.get('mobiles') is not None:
            self.mobiles = m.get('mobiles')
        return self


class QueryQmpCardsmsSupportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        datas: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 手机号卡片短信支持信息
        self.datas = datas

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.datas is not None:
            result['datas'] = self.datas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('datas') is not None:
            self.datas = m.get('datas')
        return self


class BatchqueryQmpActionplanDetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        scene_strategy_id: List[int] = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 场景策略id
        self.scene_strategy_id = scene_strategy_id
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.scene_strategy_id, 'scene_strategy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.scene_strategy_id is not None:
            result['scene_strategy_id'] = self.scene_strategy_id
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('scene_strategy_id') is not None:
            self.scene_strategy_id = m.get('scene_strategy_id')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class BatchqueryQmpActionplanDetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        action_plan_detail_info: List[ActionPlanDetailInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 触达策略详细信息
        self.action_plan_detail_info = action_plan_detail_info

    def validate(self):
        if self.action_plan_detail_info:
            for k in self.action_plan_detail_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['action_plan_detail_info'] = []
        if self.action_plan_detail_info is not None:
            for k in self.action_plan_detail_info:
                result['action_plan_detail_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.action_plan_detail_info = []
        if m.get('action_plan_detail_info') is not None:
            for k in m.get('action_plan_detail_info'):
                temp_model = ActionPlanDetailInfo()
                self.action_plan_detail_info.append(temp_model.from_map(k))
        return self


class ApplyQmpPhonenumberstatusforsmsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        customer_key: str = None,
        param_template: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 12345
        self.customer_key = customer_key
        # 用户模版类型
        self.param_template = param_template

    def validate(self):
        self.validate_required(self.customer_key, 'customer_key')
        self.validate_required(self.param_template, 'param_template')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.param_template is not None:
            result['param_template'] = self.param_template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('param_template') is not None:
            self.param_template = m.get('param_template')
        return self


class ApplyQmpPhonenumberstatusforsmsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        customer_key: str = None,
        status: str = None,
        carrier: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 12345
        self.customer_key = customer_key
        # 用户凭证状态
        self.status = status
        # 号码当前归属的基础运营商
        self.carrier = carrier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.customer_key is not None:
            result['customer_key'] = self.customer_key
        if self.status is not None:
            result['status'] = self.status
        if self.carrier is not None:
            result['carrier'] = self.carrier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('customer_key') is not None:
            self.customer_key = m.get('customer_key')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('carrier') is not None:
            self.carrier = m.get('carrier')
        return self


class BatchqueryQmpTenantActionplaninfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        content_type: str = None,
        page_num: int = None,
        page_size: int = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 渠道类型
        self.content_type = content_type
        # 页码
        self.page_num = page_num
        # 页数
        self.page_size = page_size
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.content_type is not None:
            result['content_type'] = self.content_type
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('content_type') is not None:
            self.content_type = m.get('content_type')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class BatchqueryQmpTenantActionplaninfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_result: List[ActionPlanDetailInfo] = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 触达策略信息
        self.query_result = query_result
        # 总数
        self.total_count = total_count

    def validate(self):
        if self.query_result:
            for k in self.query_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['query_result'] = []
        if self.query_result is not None:
            for k in self.query_result:
                result['query_result'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.query_result = []
        if m.get('query_result') is not None:
            for k in m.get('query_result'):
                temp_model = ActionPlanDetailInfo()
                self.query_result.append(temp_model.from_map(k))
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryQmpTenantActionplaninfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        channel_type: str = None,
        industry_tag: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 页码
        self.page_num = page_num
        # 页容量
        self.page_size = page_size
        # 渠道code
        self.channel_type = channel_type
        # 分流字段，行业标签区分哈啰流量归属于umkt或qmp
        self.industry_tag = industry_tag

    def validate(self):
        self.validate_required(self.channel_type, 'channel_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.channel_type is not None:
            result['channel_type'] = self.channel_type
        if self.industry_tag is not None:
            result['industry_tag'] = self.industry_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('channel_type') is not None:
            self.channel_type = m.get('channel_type')
        if m.get('industry_tag') is not None:
            self.industry_tag = m.get('industry_tag')
        return self


class QueryQmpTenantActionplaninfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_result: List[TenantActionPlanInfo] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 租户策略信息列表
        self.query_result = query_result
        # 页码
        self.page_num = page_num
        # 页容量
        self.page_size = page_size
        # 总量
        self.total_count = total_count

    def validate(self):
        if self.query_result:
            for k in self.query_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['query_result'] = []
        if self.query_result is not None:
            for k in self.query_result:
                result['query_result'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.query_result = []
        if m.get('query_result') is not None:
            for k in m.get('query_result'):
                temp_model = TenantActionPlanInfo()
                self.query_result.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryQmpCpaassmsTemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        sms_type: str = None,
        tenant_industry: str = None,
        status: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 短信类型
        self.sms_type = sms_type
        # 行业标签
        self.tenant_industry = tenant_industry
        # 审批状态
        self.status = status
        # 页码
        self.page_num = page_num
        # 每页记录数量
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.sms_type, 'sms_type')
        self.validate_required(self.tenant_industry, 'tenant_industry')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.sms_type is not None:
            result['sms_type'] = self.sms_type
        if self.tenant_industry is not None:
            result['tenant_industry'] = self.tenant_industry
        if self.status is not None:
            result['status'] = self.status
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('sms_type') is not None:
            self.sms_type = m.get('sms_type')
        if m.get('tenant_industry') is not None:
            self.tenant_industry = m.get('tenant_industry')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryQmpCpaassmsTemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total: int = None,
        page_size: int = None,
        page_num: int = None,
        cpass_sms_templates: List[CpaasSmsTemplate] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 总数
        self.total = total
        # 每页记录数
        self.page_size = page_size
        # 页码
        self.page_num = page_num
        # 模板列表
        self.cpass_sms_templates = cpass_sms_templates

    def validate(self):
        if self.cpass_sms_templates:
            for k in self.cpass_sms_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total is not None:
            result['total'] = self.total
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.page_num is not None:
            result['page_num'] = self.page_num
        result['cpass_sms_templates'] = []
        if self.cpass_sms_templates is not None:
            for k in self.cpass_sms_templates:
                result['cpass_sms_templates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        self.cpass_sms_templates = []
        if m.get('cpass_sms_templates') is not None:
            for k in m.get('cpass_sms_templates'):
                temp_model = CpaasSmsTemplate()
                self.cpass_sms_templates.append(temp_model.from_map(k))
        return self


class QueryQmpTextsmsTemplateRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        sms_type: str = None,
        tenant_industry: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 短信类型
        self.sms_type = sms_type
        # 行业标签
        self.tenant_industry = tenant_industry
        # 页码
        self.page_num = page_num
        # 每页记录数量
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.sms_type, 'sms_type')
        self.validate_required(self.tenant_industry, 'tenant_industry')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.sms_type is not None:
            result['sms_type'] = self.sms_type
        if self.tenant_industry is not None:
            result['tenant_industry'] = self.tenant_industry
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('sms_type') is not None:
            self.sms_type = m.get('sms_type')
        if m.get('tenant_industry') is not None:
            self.tenant_industry = m.get('tenant_industry')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryQmpTextsmsTemplateResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total: int = None,
        page_num: int = None,
        page_size: int = None,
        ext_info: str = None,
        sms_templates: List[SmsTemplate] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 总数
        self.total = total
        # 页码
        self.page_num = page_num
        # 每页记录数
        self.page_size = page_size
        # 扩展参数
        self.ext_info = ext_info
        # 模板列表
        self.sms_templates = sms_templates

    def validate(self):
        if self.sms_templates:
            for k in self.sms_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total is not None:
            result['total'] = self.total
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        result['sms_templates'] = []
        if self.sms_templates is not None:
            for k in self.sms_templates:
                result['sms_templates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        self.sms_templates = []
        if m.get('sms_templates') is not None:
            for k in m.get('sms_templates'):
                temp_model = SmsTemplate()
                self.sms_templates.append(temp_model.from_map(k))
        return self


class PushQmpBackflowEventRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        event_id: int = None,
        event_records: List[BackflowEventRecord] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 回流事件id，对应租户回流事件id
        self.event_id = event_id
        # 回流事件记录列表
        self.event_records = event_records

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_records, 'event_records')
        if self.event_records:
            for k in self.event_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.event_id is not None:
            result['event_id'] = self.event_id
        result['event_records'] = []
        if self.event_records is not None:
            for k in self.event_records:
                result['event_records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('event_id') is not None:
            self.event_id = m.get('event_id')
        self.event_records = []
        if m.get('event_records') is not None:
            for k in m.get('event_records'):
                temp_model = BackflowEventRecord()
                self.event_records.append(temp_model.from_map(k))
        return self


class PushQmpBackflowEventResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class PushQmpBackflowJsondataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        event_id: int = None,
        event_records: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 回流事件id，对应租户回流事件id
        self.event_id = event_id
        # 回流事件记录列表
        self.event_records = event_records

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_records, 'event_records')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.event_id is not None:
            result['event_id'] = self.event_id
        if self.event_records is not None:
            result['event_records'] = self.event_records
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('event_id') is not None:
            self.event_id = m.get('event_id')
        if m.get('event_records') is not None:
            self.event_records = m.get('event_records')
        return self


class PushQmpBackflowJsondataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class BatchqueryQmpRtMixedmarketingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        plan_codes: List[str] = None,
        plan_set_code: str = None,
        query_template: str = None,
        customer_details: List[CustomerInfo] = None,
        public_properties: str = None,
        biz_serial_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 圈客计划code列表
        self.plan_codes = plan_codes
        # 计划集合code，对标圈客计划code列表，一般不可变
        self.plan_set_code = plan_set_code
        # 查询协议模版
        self.query_template = query_template
        # 客群凭证和其他信息
        self.customer_details = customer_details
        # 客群共用参数
        self.public_properties = public_properties
        # 外部业务流水号
        self.biz_serial_no = biz_serial_no

    def validate(self):
        self.validate_required(self.plan_codes, 'plan_codes')
        self.validate_required(self.query_template, 'query_template')
        self.validate_required(self.customer_details, 'customer_details')
        if self.customer_details:
            for k in self.customer_details:
                if k:
                    k.validate()
        self.validate_required(self.biz_serial_no, 'biz_serial_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.plan_codes is not None:
            result['plan_codes'] = self.plan_codes
        if self.plan_set_code is not None:
            result['plan_set_code'] = self.plan_set_code
        if self.query_template is not None:
            result['query_template'] = self.query_template
        result['customer_details'] = []
        if self.customer_details is not None:
            for k in self.customer_details:
                result['customer_details'].append(k.to_map() if k else None)
        if self.public_properties is not None:
            result['public_properties'] = self.public_properties
        if self.biz_serial_no is not None:
            result['biz_serial_no'] = self.biz_serial_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('plan_codes') is not None:
            self.plan_codes = m.get('plan_codes')
        if m.get('plan_set_code') is not None:
            self.plan_set_code = m.get('plan_set_code')
        if m.get('query_template') is not None:
            self.query_template = m.get('query_template')
        self.customer_details = []
        if m.get('customer_details') is not None:
            for k in m.get('customer_details'):
                temp_model = CustomerInfo()
                self.customer_details.append(temp_model.from_map(k))
        if m.get('public_properties') is not None:
            self.public_properties = m.get('public_properties')
        if m.get('biz_serial_no') is not None:
            self.biz_serial_no = m.get('biz_serial_no')
        return self


class BatchqueryQmpRtMixedmarketingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_results: List[CustomerRpspInfosModel] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.query_results = query_results

    def validate(self):
        if self.query_results:
            for k in self.query_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['query_results'] = []
        if self.query_results is not None:
            for k in self.query_results:
                result['query_results'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.query_results = []
        if m.get('query_results') is not None:
            for k in m.get('query_results'):
                temp_model = CustomerRpspInfosModel()
                self.query_results.append(temp_model.from_map(k))
        return self


class UploadQmpOfflinehostplanRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
        file_template: str = None,
        plan_code: str = None,
        properties: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件上传后的fileId
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id
        # MOBILE/MOBILE_MD5/OAID/IDFA/IMEI/CAID选择其中一种
        self.file_template = file_template
        # plancode，托管计划编码
        self.plan_code = plan_code
        # properties的header,其他的为ext_info,
        self.properties = properties

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.file_template, 'file_template')
        self.validate_required(self.plan_code, 'plan_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_template is not None:
            result['file_template'] = self.file_template
        if self.plan_code is not None:
            result['plan_code'] = self.plan_code
        if self.properties is not None:
            result['properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_template') is not None:
            self.file_template = m.get('file_template')
        if m.get('plan_code') is not None:
            self.plan_code = m.get('plan_code')
        if m.get('properties') is not None:
            self.properties = m.get('properties')
        return self


class UploadQmpOfflinehostplanResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        import_id: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 导入id，可以用该id来查询分层结果
        self.import_id = import_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.import_id is not None:
            result['import_id'] = self.import_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('import_id') is not None:
            self.import_id = m.get('import_id')
        return self


class QueryQmpOfflinehostplanDecisionresultRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        import_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件上传时返回的导入id
        self.import_id = import_id

    def validate(self):
        self.validate_required(self.import_id, 'import_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.import_id is not None:
            result['import_id'] = self.import_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('import_id') is not None:
            self.import_id = m.get('import_id')
        return self


class QueryQmpOfflinehostplanDecisionresultResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        plan_code: str = None,
        status: str = None,
        total_num: int = None,
        decision_num: int = None,
        file_url: str = None,
        action_confirm_status: str = None,
        action_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 安全托管计划编码
        self.plan_code = plan_code
        # EXECUTING/DECISI ON_SUCCESS/DECISION_FAIL/CANCEL。执行中/成功/失败/取消。
        self.status = status
        # 总托管数量
        self.total_num = total_num
        # 分层结果数
        self.decision_num = decision_num
        # 分层结果的oss文件路径
        self.file_url = file_url
        # 触达确认状态.Y/N,已确认，未确认，当前计划无触达则为空
        self.action_confirm_status = action_confirm_status
        # 触达时间
        self.action_time = action_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.plan_code is not None:
            result['plan_code'] = self.plan_code
        if self.status is not None:
            result['status'] = self.status
        if self.total_num is not None:
            result['total_num'] = self.total_num
        if self.decision_num is not None:
            result['decision_num'] = self.decision_num
        if self.file_url is not None:
            result['file_url'] = self.file_url
        if self.action_confirm_status is not None:
            result['action_confirm_status'] = self.action_confirm_status
        if self.action_time is not None:
            result['action_time'] = self.action_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('plan_code') is not None:
            self.plan_code = m.get('plan_code')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        if m.get('decision_num') is not None:
            self.decision_num = m.get('decision_num')
        if m.get('file_url') is not None:
            self.file_url = m.get('file_url')
        if m.get('action_confirm_status') is not None:
            self.action_confirm_status = m.get('action_confirm_status')
        if m.get('action_time') is not None:
            self.action_time = m.get('action_time')
        return self


class SyncRdaasTaxAuthinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_id: str = None,
        auth_type: str = None,
        nsrsbh: str = None,
        app_key: str = None,
        auth_status: str = None,
        pro_code: str = None,
        city_code: str = None,
        auth_callback_url: str = None,
        expire_date: str = None,
        order_no: str = None,
        auth_scene: str = None,
        auth_start_time: str = None,
        auth_create_time: str = None,
        corp_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用id
        self.app_id = app_id
        # 授权类型
        self.auth_type = auth_type
        # 税号
        self.nsrsbh = nsrsbh
        # 应用key
        self.app_key = app_key
        # 授权状态：Y-有效，N-无效
        self.auth_status = auth_status
        # 省份编码
        self.pro_code = pro_code
        # 城市编码
        self.city_code = city_code
        # 授权回调地址
        self.auth_callback_url = auth_callback_url
        # 过期时间，格式: yyyy-MM-dd HH:mm:ss
        self.expire_date = expire_date
        # 最近一次授权成功的订单号
        self.order_no = order_no
        # 授权场景
        self.auth_scene = auth_scene
        # 授权成功时间,格式：yyyy-MM-dd HH:mm:ss
        self.auth_start_time = auth_start_time
        # 授权创建时间,格式: yyyy-MM-dd HH:mm:ss
        self.auth_create_time = auth_create_time
        # 企业名称
        self.corp_name = corp_name

    def validate(self):
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.auth_type, 'auth_type')
        self.validate_required(self.nsrsbh, 'nsrsbh')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_id is not None:
            result['app_id'] = self.app_id
        if self.auth_type is not None:
            result['auth_type'] = self.auth_type
        if self.nsrsbh is not None:
            result['nsrsbh'] = self.nsrsbh
        if self.app_key is not None:
            result['app_key'] = self.app_key
        if self.auth_status is not None:
            result['auth_status'] = self.auth_status
        if self.pro_code is not None:
            result['pro_code'] = self.pro_code
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.auth_callback_url is not None:
            result['auth_callback_url'] = self.auth_callback_url
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.auth_scene is not None:
            result['auth_scene'] = self.auth_scene
        if self.auth_start_time is not None:
            result['auth_start_time'] = self.auth_start_time
        if self.auth_create_time is not None:
            result['auth_create_time'] = self.auth_create_time
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_id') is not None:
            self.app_id = m.get('app_id')
        if m.get('auth_type') is not None:
            self.auth_type = m.get('auth_type')
        if m.get('nsrsbh') is not None:
            self.nsrsbh = m.get('nsrsbh')
        if m.get('app_key') is not None:
            self.app_key = m.get('app_key')
        if m.get('auth_status') is not None:
            self.auth_status = m.get('auth_status')
        if m.get('pro_code') is not None:
            self.pro_code = m.get('pro_code')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('auth_callback_url') is not None:
            self.auth_callback_url = m.get('auth_callback_url')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('auth_scene') is not None:
            self.auth_scene = m.get('auth_scene')
        if m.get('auth_start_time') is not None:
            self.auth_start_time = m.get('auth_start_time')
        if m.get('auth_create_time') is not None:
            self.auth_create_time = m.get('auth_create_time')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        return self


class SyncRdaasTaxAuthinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncRdaasTaxAuthorderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        inst_code: str = None,
        auth_type: str = None,
        identity_id: str = None,
        factor_value: str = None,
        second_factor_value: str = None,
        order_no: str = None,
        content: str = None,
        expire_time: str = None,
        auth_scene: str = None,
        auth_status: str = None,
        auth_start_time: str = None,
        auth_create_time: str = None,
        identity_name: str = None,
        tax_zone_code: str = None,
        fail_reason: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户号
        self.inst_code = inst_code
        # 授权类型
        self.auth_type = auth_type
        # 税号
        self.identity_id = identity_id
        # 授权因子
        self.factor_value = factor_value
        # 第二授权因子
        self.second_factor_value = second_factor_value
        # 授权订单号
        self.order_no = order_no
        # 内容
        self.content = content
        # 过期时间
        self.expire_time = expire_time
        # 授权场景
        self.auth_scene = auth_scene
        # 授权状态
        self.auth_status = auth_status
        # 授权成功时间,格式：yyyy-MM-dd HH:mm:ss
        self.auth_start_time = auth_start_time
        # 授权创建时间,格式: yyyy-MM-dd HH:mm:ss
        self.auth_create_time = auth_create_time
        # 名称
        self.identity_name = identity_name
        # 企业实际所属税局地区编码
        self.tax_zone_code = tax_zone_code
        # 失败原因
        self.fail_reason = fail_reason

    def validate(self):
        self.validate_required(self.inst_code, 'inst_code')
        self.validate_required(self.auth_type, 'auth_type')
        self.validate_required(self.order_no, 'order_no')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.inst_code is not None:
            result['inst_code'] = self.inst_code
        if self.auth_type is not None:
            result['auth_type'] = self.auth_type
        if self.identity_id is not None:
            result['identity_id'] = self.identity_id
        if self.factor_value is not None:
            result['factor_value'] = self.factor_value
        if self.second_factor_value is not None:
            result['second_factor_value'] = self.second_factor_value
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.content is not None:
            result['content'] = self.content
        if self.expire_time is not None:
            result['expire_time'] = self.expire_time
        if self.auth_scene is not None:
            result['auth_scene'] = self.auth_scene
        if self.auth_status is not None:
            result['auth_status'] = self.auth_status
        if self.auth_start_time is not None:
            result['auth_start_time'] = self.auth_start_time
        if self.auth_create_time is not None:
            result['auth_create_time'] = self.auth_create_time
        if self.identity_name is not None:
            result['identity_name'] = self.identity_name
        if self.tax_zone_code is not None:
            result['tax_zone_code'] = self.tax_zone_code
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('inst_code') is not None:
            self.inst_code = m.get('inst_code')
        if m.get('auth_type') is not None:
            self.auth_type = m.get('auth_type')
        if m.get('identity_id') is not None:
            self.identity_id = m.get('identity_id')
        if m.get('factor_value') is not None:
            self.factor_value = m.get('factor_value')
        if m.get('second_factor_value') is not None:
            self.second_factor_value = m.get('second_factor_value')
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('expire_time') is not None:
            self.expire_time = m.get('expire_time')
        if m.get('auth_scene') is not None:
            self.auth_scene = m.get('auth_scene')
        if m.get('auth_status') is not None:
            self.auth_status = m.get('auth_status')
        if m.get('auth_start_time') is not None:
            self.auth_start_time = m.get('auth_start_time')
        if m.get('auth_create_time') is not None:
            self.auth_create_time = m.get('auth_create_time')
        if m.get('identity_name') is not None:
            self.identity_name = m.get('identity_name')
        if m.get('tax_zone_code') is not None:
            self.tax_zone_code = m.get('tax_zone_code')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        return self


class SyncRdaasTaxAuthorderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class NotifyRdaasTaxCallbackRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        notify_scene: str = None,
        inst_code: str = None,
        solution_id: str = None,
        callback_url: str = None,
        json_biz_params: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 通知场景
        self.notify_scene = notify_scene
        # 租户号
        self.inst_code = inst_code
        # 解决方案id
        self.solution_id = solution_id
        # 通知回调地址
        self.callback_url = callback_url
        # 业务参数
        self.json_biz_params = json_biz_params

    def validate(self):
        self.validate_required(self.notify_scene, 'notify_scene')
        self.validate_required(self.inst_code, 'inst_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.notify_scene is not None:
            result['notify_scene'] = self.notify_scene
        if self.inst_code is not None:
            result['inst_code'] = self.inst_code
        if self.solution_id is not None:
            result['solution_id'] = self.solution_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.json_biz_params is not None:
            result['json_biz_params'] = self.json_biz_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('notify_scene') is not None:
            self.notify_scene = m.get('notify_scene')
        if m.get('inst_code') is not None:
            self.inst_code = m.get('inst_code')
        if m.get('solution_id') is not None:
            self.solution_id = m.get('solution_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('json_biz_params') is not None:
            self.json_biz_params = m.get('json_biz_params')
        return self


class NotifyRdaasTaxCallbackResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 通知是否成功
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class QueryRdaasTaxRpadecisionserviceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        service_name: str = None,
        decision_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 决策服务
        self.service_name = service_name
        # 决策租户
        self.decision_tenant = decision_tenant

    def validate(self):
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.decision_tenant, 'decision_tenant')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.service_name is not None:
            result['service_name'] = self.service_name
        if self.decision_tenant is not None:
            result['decision_tenant'] = self.decision_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('service_name') is not None:
            self.service_name = m.get('service_name')
        if m.get('decision_tenant') is not None:
            self.decision_tenant = m.get('decision_tenant')
        return self


class QueryRdaasTaxRpadecisionserviceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[RdaasTaxDecsionService] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 决策服务列表
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = RdaasTaxDecsionService()
                self.data.append(temp_model.from_map(k))
        return self


class QueryRdaasTaxRpadecisionindicatorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        service_id: str = None,
        property_name: str = None,
        decision_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 决策服务id
        self.service_id = service_id
        # 决策属性名称，目前一种属性: 比重-weight
        self.property_name = property_name
        # 决策租户
        self.decision_tenant = decision_tenant

    def validate(self):
        self.validate_required(self.service_id, 'service_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.service_id is not None:
            result['service_id'] = self.service_id
        if self.property_name is not None:
            result['property_name'] = self.property_name
        if self.decision_tenant is not None:
            result['decision_tenant'] = self.decision_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('service_id') is not None:
            self.service_id = m.get('service_id')
        if m.get('property_name') is not None:
            self.property_name = m.get('property_name')
        if m.get('decision_tenant') is not None:
            self.decision_tenant = m.get('decision_tenant')
        return self


class QueryRdaasTaxRpadecisionindicatorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[RdaasTaxDecsionServiceIndicator] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 决策指标
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = RdaasTaxDecsionServiceIndicator()
                self.data.append(temp_model.from_map(k))
        return self


class QueryRdaasTaxSimpleauthdecisionRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        decision_tenant: str = None,
        auth_type: str = None,
        province_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 决策租户
        self.decision_tenant = decision_tenant
        # 授权类型
        self.auth_type = auth_type
        # 省份
        self.province_code = province_code

    def validate(self):
        self.validate_required(self.decision_tenant, 'decision_tenant')
        self.validate_required(self.auth_type, 'auth_type')
        self.validate_required(self.province_code, 'province_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.decision_tenant is not None:
            result['decision_tenant'] = self.decision_tenant
        if self.auth_type is not None:
            result['auth_type'] = self.auth_type
        if self.province_code is not None:
            result['province_code'] = self.province_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('decision_tenant') is not None:
            self.decision_tenant = m.get('decision_tenant')
        if m.get('auth_type') is not None:
            self.auth_type = m.get('auth_type')
        if m.get('province_code') is not None:
            self.province_code = m.get('province_code')
        return self


class QueryRdaasTaxSimpleauthdecisionResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # json决策结果
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ReceiveRfcParamsFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
        params: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件ID
        # 
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id
        # 参数，jsonString
        self.params = params
        # 请求类型：示例 OCR_IDENTIFY-->OCR识别业务
        self.type = type

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.params, 'params')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ReceiveRfcParamsFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        content: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 文件上传响应参数
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.content is not None:
            result['content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('content') is not None:
            self.content = m.get('content')
        return self


class UploadRfcAiboundFileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
        params: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件ID
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id
        # 参数，jsonString
        self.params = params
        # 外呼为 AI_BOUND
        self.type = type

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.params, 'params')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UploadRfcAiboundFileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        content: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 文件上传响应参数
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.content is not None:
            result['content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('content') is not None:
            self.content = m.get('content')
        return self


class QueryRfcOdpsLindormRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_code: str = None,
        key_id: str = None,
        auth_code: str = None,
        encrypt_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务编码
        self.biz_code = biz_code
        # 加密后的唯一id
        self.key_id = key_id
        # 授权码
        self.auth_code = auth_code
        # 加密方式
        self.encrypt_type = encrypt_type

    def validate(self):
        self.validate_required(self.biz_code, 'biz_code')
        self.validate_required(self.key_id, 'key_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_code is not None:
            result['biz_code'] = self.biz_code
        if self.key_id is not None:
            result['key_id'] = self.key_id
        if self.auth_code is not None:
            result['auth_code'] = self.auth_code
        if self.encrypt_type is not None:
            result['encrypt_type'] = self.encrypt_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_code') is not None:
            self.biz_code = m.get('biz_code')
        if m.get('key_id') is not None:
            self.key_id = m.get('key_id')
        if m.get('auth_code') is not None:
            self.auth_code = m.get('auth_code')
        if m.get('encrypt_type') is not None:
            self.encrypt_type = m.get('encrypt_type')
        return self


class QueryRfcOdpsLindormResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        json_res: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询结果
        self.json_res = json_res

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.json_res is not None:
            result['json_res'] = self.json_res
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('json_res') is not None:
            self.json_res = m.get('json_res')
        return self


class QueryRbbGenericInvokeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        content: str = None,
        permission: str = None,
        title: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # {"platformId":1234,"method":"riskQuery"}
        self.content = content
        # 账号的所有权限点，逗号分隔
        self.permission = permission
        # 标题备用
        self.title = title

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.title, 'title')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.content is not None:
            result['content'] = self.content
        if self.permission is not None:
            result['permission'] = self.permission
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('permission') is not None:
            self.permission = m.get('permission')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class QueryRbbGenericInvokeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回数据内容
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateRbbTokenRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        content: str = None,
        password: str = None,
        username: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 扩展字段
        self.content = content
        # 新人用户密码，用来做映射生成token
        self.password = password
        # 用户
        self.username = username

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.password, 'password')
        self.validate_required(self.username, 'username')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.content is not None:
            result['content'] = self.content
        if self.password is not None:
            result['password'] = self.password
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class CreateRbbTokenResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回数据
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CreateRbbApiGwtokenRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        extension: str = None,
        password: str = None,
        username: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 扩展字段
        self.extension = extension
        # 新人用户密码，用来做映射生成token
        self.password = password
        # 用户
        self.username = username

    def validate(self):
        self.validate_required(self.password, 'password')
        self.validate_required(self.username, 'username')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.extension is not None:
            result['extension'] = self.extension
        if self.password is not None:
            result['password'] = self.password
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class CreateRbbApiGwtokenResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        logintoken: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回登录token
        self.logintoken = logintoken

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.logintoken is not None:
            result['logintoken'] = self.logintoken
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('logintoken') is not None:
            self.logintoken = m.get('logintoken')
        return self


class QueryRbbGeneralRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        extension: str = None,
        queryname: str = None,
        queryparas: str = None,
        virtual_cloud_tenant_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 额外参数json
        self.extension = extension
        # 通用查询名称
        self.queryname = queryname
        # 查询参数JSON字符串
        self.queryparas = queryparas
        # 虚拟云租户code
        self.virtual_cloud_tenant_code = virtual_cloud_tenant_code

    def validate(self):
        self.validate_required(self.queryname, 'queryname')
        if self.queryname is not None:
            self.validate_max_length(self.queryname, 'queryname', 200)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.extension is not None:
            result['extension'] = self.extension
        if self.queryname is not None:
            result['queryname'] = self.queryname
        if self.queryparas is not None:
            result['queryparas'] = self.queryparas
        if self.virtual_cloud_tenant_code is not None:
            result['virtual_cloud_tenant_code'] = self.virtual_cloud_tenant_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('queryname') is not None:
            self.queryname = m.get('queryname')
        if m.get('queryparas') is not None:
            self.queryparas = m.get('queryparas')
        if m.get('virtual_cloud_tenant_code') is not None:
            self.virtual_cloud_tenant_code = m.get('virtual_cloud_tenant_code')
        return self


class QueryRbbGeneralResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # json字符串表示的通用查询结果
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class GetRbbLoginTokenRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        username: str = None,
        password: str = None,
        extension: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户名
        self.username = username
        # 密码
        self.password = password
        # 扩展json字符串
        self.extension = extension

    def validate(self):
        self.validate_required(self.username, 'username')
        self.validate_required(self.password, 'password')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.username is not None:
            result['username'] = self.username
        if self.password is not None:
            result['password'] = self.password
        if self.extension is not None:
            result['extension'] = self.extension
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        return self


class GetRbbLoginTokenResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        logintoken: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 登录token，5分钟有效
        self.logintoken = logintoken

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.logintoken is not None:
            result['logintoken'] = self.logintoken
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('logintoken') is not None:
            self.logintoken = m.get('logintoken')
        return self


class CreateRbbTenantRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        effective_end_date: str = None,
        tenant_code: str = None,
        tenant_name: str = None,
        tenant_property_json: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户过期时间，不填表示永不过期
        self.effective_end_date = effective_end_date
        # 租户编码，必须全局唯一
        self.tenant_code = tenant_code
        # 租户名称
        self.tenant_name = tenant_name
        # 租户自定义属性，JSON格式，可以为空
        self.tenant_property_json = tenant_property_json

    def validate(self):
        if self.effective_end_date is not None:
            self.validate_pattern(self.effective_end_date, 'effective_end_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.tenant_code, 'tenant_code')
        if self.tenant_code is not None:
            self.validate_max_length(self.tenant_code, 'tenant_code', 64)
        self.validate_required(self.tenant_name, 'tenant_name')
        if self.tenant_name is not None:
            self.validate_max_length(self.tenant_name, 'tenant_name', 64)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.effective_end_date is not None:
            result['effective_end_date'] = self.effective_end_date
        if self.tenant_code is not None:
            result['tenant_code'] = self.tenant_code
        if self.tenant_name is not None:
            result['tenant_name'] = self.tenant_name
        if self.tenant_property_json is not None:
            result['tenant_property_json'] = self.tenant_property_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('effective_end_date') is not None:
            self.effective_end_date = m.get('effective_end_date')
        if m.get('tenant_code') is not None:
            self.tenant_code = m.get('tenant_code')
        if m.get('tenant_name') is not None:
            self.tenant_name = m.get('tenant_name')
        if m.get('tenant_property_json') is not None:
            self.tenant_property_json = m.get('tenant_property_json')
        return self


class CreateRbbTenantResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateRbbUserRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        email: str = None,
        full_name: str = None,
        password: str = None,
        phone: str = None,
        tenant_code: str = None,
        user_name: str = None,
        user_property_json: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户邮箱，非必填
        self.email = email
        # 用户姓名、真实名称，不要求全局唯一
        self.full_name = full_name
        # 用户密码
        self.password = password
        # 用户电话号码，非必填
        self.phone = phone
        # 用户所属租户编码
        self.tenant_code = tenant_code
        # 用户名，必须全局唯一
        self.user_name = user_name
        # 用户属性扩展字段，json格式，可以为空
        self.user_property_json = user_property_json

    def validate(self):
        if self.email is not None:
            self.validate_max_length(self.email, 'email', 128)
        self.validate_required(self.full_name, 'full_name')
        if self.full_name is not None:
            self.validate_max_length(self.full_name, 'full_name', 64)
        self.validate_required(self.password, 'password')
        if self.password is not None:
            self.validate_max_length(self.password, 'password', 200)
        if self.phone is not None:
            self.validate_max_length(self.phone, 'phone', 64)
        if self.tenant_code is not None:
            self.validate_max_length(self.tenant_code, 'tenant_code', 64)
        self.validate_required(self.user_name, 'user_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.email is not None:
            result['email'] = self.email
        if self.full_name is not None:
            result['full_name'] = self.full_name
        if self.password is not None:
            result['password'] = self.password
        if self.phone is not None:
            result['phone'] = self.phone
        if self.tenant_code is not None:
            result['tenant_code'] = self.tenant_code
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_property_json is not None:
            result['user_property_json'] = self.user_property_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('full_name') is not None:
            self.full_name = m.get('full_name')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('tenant_code') is not None:
            self.tenant_code = m.get('tenant_code')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_property_json') is not None:
            self.user_property_json = m.get('user_property_json')
        return self


class CreateRbbUserResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ExecRbbCompanyGuardRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        keyword: str = None,
        rule_id: int = None,
        params: str = None,
        virtual_cloud_tenant_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称或统一社会信用代码
        self.keyword = keyword
        # 规则ID，在风险大脑系统中配置
        self.rule_id = rule_id
        # 额外参数，与规则有关
        self.params = params
        # 虚拟云租户code
        self.virtual_cloud_tenant_code = virtual_cloud_tenant_code

    def validate(self):
        self.validate_required(self.keyword, 'keyword')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.params is not None:
            result['params'] = self.params
        if self.virtual_cloud_tenant_code is not None:
            result['virtual_cloud_tenant_code'] = self.virtual_cloud_tenant_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('virtual_cloud_tenant_code') is not None:
            self.virtual_cloud_tenant_code = m.get('virtual_cloud_tenant_code')
        return self


class ExecRbbCompanyGuardResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        decision: str = None,
        results: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 决策结果，ACCEPT/REJECT/TBD
        self.decision = decision
        # 准入执行结果的快照
        self.results = results

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.decision is not None:
            result['decision'] = self.decision
        if self.results is not None:
            result['results'] = self.results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('results') is not None:
            self.results = m.get('results')
        return self


class ApplyRbbCompanyCreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        keyword: str = None,
        rule_id: int = None,
        params: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称、统一社会信用代码
        self.keyword = keyword
        # 规则ID，需提前在蚁盾中进行配置
        self.rule_id = rule_id
        # 额外参数，与规则有关
        self.params = params

    def validate(self):
        self.validate_required(self.keyword, 'keyword')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.params is not None:
            result['params'] = self.params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('params') is not None:
            self.params = m.get('params')
        return self


class ApplyRbbCompanyCreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        token: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询token，用于查询授信结果
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class QueryRbbCompanyCreditRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        token: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询token，从apply接口获得
        self.token = token

    def validate(self):
        self.validate_required(self.token, 'token')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class QueryRbbCompanyCreditResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        credit_amount: int = None,
        extra: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信额度，单位元
        self.credit_amount = credit_amount
        # 额外特征字段
        self.extra = extra

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.extra is not None:
            result['extra'] = self.extra
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        return self


class QueryRbbRegdatasyncPreparedRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询该bizDate数据分区的数据是否已经准备好
        self.biz_date = biz_date

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')
        if self.biz_date is not None:
            self.validate_max_length(self.biz_date, 'biz_date', 8)

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_date is not None:
            result['biz_date'] = self.biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_date') is not None:
            self.biz_date = m.get('biz_date')
        return self


class QueryRbbRegdatasyncPreparedResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        prepared: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 指定时间分区的数据是否已经准备完毕
        self.prepared = prepared

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.prepared is not None:
            result['prepared'] = self.prepared
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('prepared') is not None:
            self.prepared = m.get('prepared')
        return self


class StartRbbRegdatasyncScheduleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 同步时间分区
        self.biz_date = biz_date

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_date is not None:
            result['biz_date'] = self.biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_date') is not None:
            self.biz_date = m.get('biz_date')
        return self


class StartRbbRegdatasyncScheduleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class FinishRbbRegdatasyncScheduleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        biz_date: str = None,
        sync_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 时间分区
        self.biz_date = biz_date
        # 记录当前分区离线同步情况
        self.sync_info = sync_info

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')
        if self.biz_date is not None:
            self.validate_max_length(self.biz_date, 'biz_date', 8)
        self.validate_required(self.sync_info, 'sync_info')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.biz_date is not None:
            result['biz_date'] = self.biz_date
        if self.sync_info is not None:
            result['sync_info'] = self.sync_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('biz_date') is not None:
            self.biz_date = m.get('biz_date')
        if m.get('sync_info') is not None:
            self.sync_info = m.get('sync_info')
        return self


class FinishRbbRegdatasyncScheduleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ApplyRbbCompanyGuardRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        keyword: str = None,
        rule_id: int = None,
        params: str = None,
        virtual_cloud_tenant_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称、统一社会信用代码或注册号
        self.keyword = keyword
        # 规则ID
        self.rule_id = rule_id
        # 额外参数，与具体规则相关
        self.params = params
        # 虚拟云租户code
        self.virtual_cloud_tenant_code = virtual_cloud_tenant_code

    def validate(self):
        self.validate_required(self.keyword, 'keyword')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.params is not None:
            result['params'] = self.params
        if self.virtual_cloud_tenant_code is not None:
            result['virtual_cloud_tenant_code'] = self.virtual_cloud_tenant_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('virtual_cloud_tenant_code') is not None:
            self.virtual_cloud_tenant_code = m.get('virtual_cloud_tenant_code')
        return self


class ApplyRbbCompanyGuardResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        token: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询token
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class QueryRbbCompanyGuardRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        token: str = None,
        virtual_cloud_tenant_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询token
        self.token = token
        # 虚拟云租户code
        self.virtual_cloud_tenant_code = virtual_cloud_tenant_code

    def validate(self):
        self.validate_required(self.token, 'token')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.token is not None:
            result['token'] = self.token
        if self.virtual_cloud_tenant_code is not None:
            result['virtual_cloud_tenant_code'] = self.virtual_cloud_tenant_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('token') is not None:
            self.token = m.get('token')
        if m.get('virtual_cloud_tenant_code') is not None:
            self.virtual_cloud_tenant_code = m.get('virtual_cloud_tenant_code')
        return self


class QueryRbbCompanyGuardResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        decision: str = None,
        results: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 决策结果，ACCEPT/REJECT/TBD
        # 
        self.decision = decision
        # 准入执行结果的快照
        # 
        self.results = results

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.decision is not None:
            result['decision'] = self.decision
        if self.results is not None:
            result['results'] = self.results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('decision') is not None:
            self.decision = m.get('decision')
        if m.get('results') is not None:
            self.results = m.get('results')
        return self


class QueryRbbObtsZsearchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        index: str = None,
        type: str = None,
        operation_method: str = None,
        entity_string: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 索引名称
        self.index = index
        # 类型名称
        self.type = type
        # 操作方法
        self.operation_method = operation_method
        # 查询语句
        self.entity_string = entity_string

    def validate(self):
        self.validate_required(self.index, 'index')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.index is not None:
            result['index'] = self.index
        if self.type is not None:
            result['type'] = self.type
        if self.operation_method is not None:
            result['operation_method'] = self.operation_method
        if self.entity_string is not None:
            result['entity_string'] = self.entity_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('operation_method') is not None:
            self.operation_method = m.get('operation_method')
        if m.get('entity_string') is not None:
            self.entity_string = m.get('entity_string')
        return self


class QueryRbbObtsZsearchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        zsearch_result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # zsearch查询结果
        self.zsearch_result = zsearch_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.zsearch_result is not None:
            result['zsearch_result'] = self.zsearch_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('zsearch_result') is not None:
            self.zsearch_result = m.get('zsearch_result')
        return self


class PushRbbCustomerCompanyinfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        uc_code: str = None,
        company_name: str = None,
        type: str = None,
        content: str = None,
        virtual_cloud_tenant_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业的统一社会信用代码
        self.uc_code = uc_code
        # 企业名称
        self.company_name = company_name
        # 企业信息的类型
        self.type = type
        # 企业信息的内容
        self.content = content
        # 虚拟云租户code
        self.virtual_cloud_tenant_code = virtual_cloud_tenant_code

    def validate(self):
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.uc_code is not None:
            result['uc_code'] = self.uc_code
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.type is not None:
            result['type'] = self.type
        if self.content is not None:
            result['content'] = self.content
        if self.virtual_cloud_tenant_code is not None:
            result['virtual_cloud_tenant_code'] = self.virtual_cloud_tenant_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('uc_code') is not None:
            self.uc_code = m.get('uc_code')
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('virtual_cloud_tenant_code') is not None:
            self.virtual_cloud_tenant_code = m.get('virtual_cloud_tenant_code')
        return self


class PushRbbCustomerCompanyinfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UploadRbbFileAmapRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_object: BinaryIO = None,
        file_object_name: str = None,
        file_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 文件id
        # 待上传文件
        self.file_object = file_object
        # 待上传文件名
        self.file_object_name = file_object_name
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_object is not None:
            result['fileObject'] = self.file_object
        if self.file_object_name is not None:
            result['fileObjectName'] = self.file_object_name
        if self.file_id is not None:
            result['file_id'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('fileObject') is not None:
            self.file_object = m.get('fileObject')
        if m.get('fileObjectName') is not None:
            self.file_object_name = m.get('fileObjectName')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        return self


class UploadRbbFileAmapResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    d