from typing import Callable, Dict, List, Set, Optional
from ctypes import c_int8 as i8, c_int16 as i16, c_int32 as i32, c_int64 as i64
from ctypes import c_uint8 as u8, c_uint16 as u16, c_uint32 as u32, c_uint64 as u64
import sys
from dataclasses import dataclass


@dataclass
class Rectangle:
    height: int
    length: int

    def is_square(self) -> bool:
        return self.height == self.length


def show():
    r: Rectangle = Rectangle(height=1, length=1)
    assert r.is_square()
    r = Rectangle(height=1, length=2)
    assert not r.is_square()
    print(r.height)
    print(r.length)


if __name__ == "__main__":
    show()
