# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AnthropicModels,
    AzureOpenAIModels,
    BedrockModels,
    CerebrasModels,
    CohereModels,
    ConversationSearchTypes,
    ConversationStrategyTypes,
    DeepseekModels,
    EntityState,
    GoogleModels,
    GraphStrategyTypes,
    GroqModels,
    JinaModels,
    MistralModels,
    ModelServiceTypes,
    OpenAIModels,
    OpenAIReasoningEffortLevels,
    OpenAIVisionDetailLevels,
    PromptStrategyTypes,
    ReplicateModels,
    RerankingModelServiceTypes,
    RetrievalStrategyTypes,
    RevisionStrategyTypes,
    SpecificationTypes,
    VoyageModels,
    XAIModels,
)


class GetSpecification(BaseModel):
    specification: Optional["GetSpecificationSpecification"]


class GetSpecificationSpecification(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "GetSpecificationSpecificationOwner"
    state: EntityState
    type: Optional[SpecificationTypes]
    service_type: Optional[ModelServiceTypes] = Field(alias="serviceType")
    system_prompt: Optional[str] = Field(alias="systemPrompt")
    custom_guidance: Optional[str] = Field(alias="customGuidance")
    custom_instructions: Optional[str] = Field(alias="customInstructions")
    search_type: Optional[ConversationSearchTypes] = Field(alias="searchType")
    number_similar: Optional[int] = Field(alias="numberSimilar")
    strategy: Optional["GetSpecificationSpecificationStrategy"]
    prompt_strategy: Optional["GetSpecificationSpecificationPromptStrategy"] = Field(
        alias="promptStrategy"
    )
    retrieval_strategy: Optional["GetSpecificationSpecificationRetrievalStrategy"] = (
        Field(alias="retrievalStrategy")
    )
    reranking_strategy: Optional["GetSpecificationSpecificationRerankingStrategy"] = (
        Field(alias="rerankingStrategy")
    )
    graph_strategy: Optional["GetSpecificationSpecificationGraphStrategy"] = Field(
        alias="graphStrategy"
    )
    revision_strategy: Optional["GetSpecificationSpecificationRevisionStrategy"] = (
        Field(alias="revisionStrategy")
    )
    azure_ai: Optional["GetSpecificationSpecificationAzureAi"] = Field(alias="azureAI")
    open_ai: Optional["GetSpecificationSpecificationOpenAi"] = Field(alias="openAI")
    azure_open_ai: Optional["GetSpecificationSpecificationAzureOpenAi"] = Field(
        alias="azureOpenAI"
    )
    cohere: Optional["GetSpecificationSpecificationCohere"]
    anthropic: Optional["GetSpecificationSpecificationAnthropic"]
    google: Optional["GetSpecificationSpecificationGoogle"]
    replicate: Optional["GetSpecificationSpecificationReplicate"]
    mistral: Optional["GetSpecificationSpecificationMistral"]
    bedrock: Optional["GetSpecificationSpecificationBedrock"]
    xai: Optional["GetSpecificationSpecificationXai"]
    groq: Optional["GetSpecificationSpecificationGroq"]
    cerebras: Optional["GetSpecificationSpecificationCerebras"]
    deepseek: Optional["GetSpecificationSpecificationDeepseek"]
    jina: Optional["GetSpecificationSpecificationJina"]
    voyage: Optional["GetSpecificationSpecificationVoyage"]


class GetSpecificationSpecificationOwner(BaseModel):
    id: str


class GetSpecificationSpecificationStrategy(BaseModel):
    type: Optional[ConversationStrategyTypes]
    message_limit: Optional[int] = Field(alias="messageLimit")
    embed_citations: Optional[bool] = Field(alias="embedCitations")
    flatten_citations: Optional[bool] = Field(alias="flattenCitations")
    enable_facets: Optional[bool] = Field(alias="enableFacets")
    messages_weight: Optional[float] = Field(alias="messagesWeight")
    contents_weight: Optional[float] = Field(alias="contentsWeight")


class GetSpecificationSpecificationPromptStrategy(BaseModel):
    type: PromptStrategyTypes


class GetSpecificationSpecificationRetrievalStrategy(BaseModel):
    type: RetrievalStrategyTypes
    content_limit: Optional[int] = Field(alias="contentLimit")
    disable_fallback: Optional[bool] = Field(alias="disableFallback")


class GetSpecificationSpecificationRerankingStrategy(BaseModel):
    service_type: RerankingModelServiceTypes = Field(alias="serviceType")
    threshold: Optional[float]


class GetSpecificationSpecificationGraphStrategy(BaseModel):
    type: GraphStrategyTypes
    generate_graph: Optional[bool] = Field(alias="generateGraph")
    observable_limit: Optional[int] = Field(alias="observableLimit")


class GetSpecificationSpecificationRevisionStrategy(BaseModel):
    type: RevisionStrategyTypes
    custom_revision: Optional[str] = Field(alias="customRevision")
    count: Optional[int]


class GetSpecificationSpecificationAzureAi(BaseModel):
    token_limit: int = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    key: str
    endpoint: Any
    temperature: Optional[float]
    probability: Optional[float]
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")


class GetSpecificationSpecificationOpenAi(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: OpenAIModels
    key: Optional[str]
    endpoint: Optional[Any]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")
    detail_level: Optional[OpenAIVisionDetailLevels] = Field(alias="detailLevel")
    reasoning_effort: Optional[OpenAIReasoningEffortLevels] = Field(
        alias="reasoningEffort"
    )


class GetSpecificationSpecificationAzureOpenAi(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: AzureOpenAIModels
    key: Optional[str]
    endpoint: Optional[Any]
    deployment_name: Optional[str] = Field(alias="deploymentName")
    temperature: Optional[float]
    probability: Optional[float]
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")


class GetSpecificationSpecificationCohere(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: CohereModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")


class GetSpecificationSpecificationAnthropic(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: AnthropicModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]
    enable_thinking: Optional[bool] = Field(alias="enableThinking")
    thinking_token_limit: Optional[int] = Field(alias="thinkingTokenLimit")


class GetSpecificationSpecificationGoogle(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: GoogleModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")
    enable_thinking: Optional[bool] = Field(alias="enableThinking")
    thinking_token_limit: Optional[int] = Field(alias="thinkingTokenLimit")


class GetSpecificationSpecificationReplicate(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: ReplicateModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]


class GetSpecificationSpecificationMistral(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: MistralModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    endpoint: Optional[Any]
    temperature: Optional[float]
    probability: Optional[float]
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")


class GetSpecificationSpecificationBedrock(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: BedrockModels
    access_key: Optional[str] = Field(alias="accessKey")
    secret_access_key: Optional[str] = Field(alias="secretAccessKey")
    endpoint: Optional[Any]
    region: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]


class GetSpecificationSpecificationXai(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: XAIModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    endpoint: Optional[Any]
    temperature: Optional[float]
    probability: Optional[float]


class GetSpecificationSpecificationGroq(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: GroqModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    endpoint: Optional[Any]
    temperature: Optional[float]
    probability: Optional[float]


class GetSpecificationSpecificationCerebras(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: CerebrasModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    endpoint: Optional[Any]
    temperature: Optional[float]
    probability: Optional[float]


class GetSpecificationSpecificationDeepseek(BaseModel):
    token_limit: Optional[int] = Field(alias="tokenLimit")
    completion_token_limit: Optional[int] = Field(alias="completionTokenLimit")
    model: DeepseekModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    temperature: Optional[float]
    probability: Optional[float]


class GetSpecificationSpecificationJina(BaseModel):
    model: JinaModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")


class GetSpecificationSpecificationVoyage(BaseModel):
    model: VoyageModels
    key: Optional[str]
    model_name: Optional[str] = Field(alias="modelName")
    chunk_token_limit: Optional[int] = Field(alias="chunkTokenLimit")


GetSpecification.model_rebuild()
GetSpecificationSpecification.model_rebuild()
