# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AlertTypes,
    ContentPublishingServiceTypes,
    ContentTypes,
    ElevenLabsModels,
    EntityState,
    FileTypes,
    GoogleImageModels,
    IntegrationServiceTypes,
    MCPServerTypes,
    ObservableTypes,
    OpenAIImageModels,
    OpenAIVideoModels,
    TimedPolicyRecurrenceTypes,
    VideoSizeTypes,
)


class QueryAlerts(BaseModel):
    alerts: Optional["QueryAlertsAlerts"]


class QueryAlertsAlerts(BaseModel):
    results: Optional[List["QueryAlertsAlertsResults"]]


class QueryAlertsAlertsResults(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "QueryAlertsAlertsResultsOwner"
    state: EntityState
    correlation_id: Optional[str] = Field(alias="correlationId")
    type: AlertTypes
    summary_prompt: Optional[str] = Field(alias="summaryPrompt")
    publish_prompt: str = Field(alias="publishPrompt")
    view: Optional["QueryAlertsAlertsResultsView"]
    filter: Optional["QueryAlertsAlertsResultsFilter"]
    integration: "QueryAlertsAlertsResultsIntegration"
    publishing: "QueryAlertsAlertsResultsPublishing"
    summary_specification: Optional["QueryAlertsAlertsResultsSummarySpecification"] = (
        Field(alias="summarySpecification")
    )
    publish_specification: Optional["QueryAlertsAlertsResultsPublishSpecification"] = (
        Field(alias="publishSpecification")
    )
    schedule_policy: Optional["QueryAlertsAlertsResultsSchedulePolicy"] = Field(
        alias="schedulePolicy"
    )
    last_alert_date: Optional[Any] = Field(alias="lastAlertDate")


class QueryAlertsAlertsResultsOwner(BaseModel):
    id: str


class QueryAlertsAlertsResultsView(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilter(BaseModel):
    date_range: Optional["QueryAlertsAlertsResultsFilterDateRange"] = Field(
        alias="dateRange"
    )
    in_last: Optional[Any] = Field(alias="inLast")
    creation_date_range: Optional["QueryAlertsAlertsResultsFilterCreationDateRange"] = (
        Field(alias="creationDateRange")
    )
    created_in_last: Optional[Any] = Field(alias="createdInLast")
    types: Optional[List[ContentTypes]]
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    formats: Optional[List[str]]
    file_extensions: Optional[List[str]] = Field(alias="fileExtensions")
    file_size_range: Optional["QueryAlertsAlertsResultsFilterFileSizeRange"] = Field(
        alias="fileSizeRange"
    )
    similar_contents: Optional[
        List["QueryAlertsAlertsResultsFilterSimilarContents"]
    ] = Field(alias="similarContents")
    contents: Optional[List["QueryAlertsAlertsResultsFilterContents"]]
    feeds: Optional[List["QueryAlertsAlertsResultsFilterFeeds"]]
    workflows: Optional[List["QueryAlertsAlertsResultsFilterWorkflows"]]
    collections: Optional[List["QueryAlertsAlertsResultsFilterCollections"]]
    users: Optional[List["QueryAlertsAlertsResultsFilterUsers"]]
    observations: Optional[List["QueryAlertsAlertsResultsFilterObservations"]]
    or_: Optional[List["QueryAlertsAlertsResultsFilterOr"]] = Field(alias="or")
    and_: Optional[List["QueryAlertsAlertsResultsFilterAnd"]] = Field(alias="and")
    has_observations: Optional[bool] = Field(alias="hasObservations")
    has_feeds: Optional[bool] = Field(alias="hasFeeds")
    has_collections: Optional[bool] = Field(alias="hasCollections")
    has_workflows: Optional[bool] = Field(alias="hasWorkflows")


class QueryAlertsAlertsResultsFilterDateRange(BaseModel):
    from_: Optional[Any] = Field(alias="from")
    to: Optional[Any]


class QueryAlertsAlertsResultsFilterCreationDateRange(BaseModel):
    from_: Optional[Any] = Field(alias="from")
    to: Optional[Any]


class QueryAlertsAlertsResultsFilterFileSizeRange(BaseModel):
    from_: Optional[Any] = Field(alias="from")
    to: Optional[Any]


class QueryAlertsAlertsResultsFilterSimilarContents(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterContents(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterFeeds(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterWorkflows(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterCollections(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterUsers(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterObservations(BaseModel):
    type: ObservableTypes
    observable: "QueryAlertsAlertsResultsFilterObservationsObservable"
    states: Optional[List[EntityState]]


class QueryAlertsAlertsResultsFilterObservationsObservable(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterOr(BaseModel):
    feeds: Optional[List["QueryAlertsAlertsResultsFilterOrFeeds"]]
    workflows: Optional[List["QueryAlertsAlertsResultsFilterOrWorkflows"]]
    collections: Optional[List["QueryAlertsAlertsResultsFilterOrCollections"]]
    users: Optional[List["QueryAlertsAlertsResultsFilterOrUsers"]]
    observations: Optional[List["QueryAlertsAlertsResultsFilterOrObservations"]]


class QueryAlertsAlertsResultsFilterOrFeeds(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterOrWorkflows(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterOrCollections(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterOrUsers(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterOrObservations(BaseModel):
    type: ObservableTypes
    observable: "QueryAlertsAlertsResultsFilterOrObservationsObservable"
    states: Optional[List[EntityState]]


class QueryAlertsAlertsResultsFilterOrObservationsObservable(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterAnd(BaseModel):
    feeds: Optional[List["QueryAlertsAlertsResultsFilterAndFeeds"]]
    workflows: Optional[List["QueryAlertsAlertsResultsFilterAndWorkflows"]]
    collections: Optional[List["QueryAlertsAlertsResultsFilterAndCollections"]]
    users: Optional[List["QueryAlertsAlertsResultsFilterAndUsers"]]
    observations: Optional[List["QueryAlertsAlertsResultsFilterAndObservations"]]


class QueryAlertsAlertsResultsFilterAndFeeds(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterAndWorkflows(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterAndCollections(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterAndUsers(BaseModel):
    id: str


class QueryAlertsAlertsResultsFilterAndObservations(BaseModel):
    type: ObservableTypes
    observable: "QueryAlertsAlertsResultsFilterAndObservationsObservable"
    states: Optional[List[EntityState]]


class QueryAlertsAlertsResultsFilterAndObservationsObservable(BaseModel):
    id: str


class QueryAlertsAlertsResultsIntegration(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["QueryAlertsAlertsResultsIntegrationSlack"]
    email: Optional["QueryAlertsAlertsResultsIntegrationEmail"]
    twitter: Optional["QueryAlertsAlertsResultsIntegrationTwitter"]
    mcp: Optional["QueryAlertsAlertsResultsIntegrationMcp"]


class QueryAlertsAlertsResultsIntegrationSlack(BaseModel):
    token: str
    channel: str


class QueryAlertsAlertsResultsIntegrationEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class QueryAlertsAlertsResultsIntegrationTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class QueryAlertsAlertsResultsIntegrationMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


class QueryAlertsAlertsResultsPublishing(BaseModel):
    type: ContentPublishingServiceTypes
    eleven_labs: Optional["QueryAlertsAlertsResultsPublishingElevenLabs"] = Field(
        alias="elevenLabs"
    )
    open_ai_image: Optional["QueryAlertsAlertsResultsPublishingOpenAiImage"] = Field(
        alias="openAIImage"
    )
    google_image: Optional["QueryAlertsAlertsResultsPublishingGoogleImage"] = Field(
        alias="googleImage"
    )
    open_ai_video: Optional["QueryAlertsAlertsResultsPublishingOpenAiVideo"] = Field(
        alias="openAIVideo"
    )


class QueryAlertsAlertsResultsPublishingElevenLabs(BaseModel):
    model: Optional[ElevenLabsModels]
    voice: Optional[str]


class QueryAlertsAlertsResultsPublishingOpenAiImage(BaseModel):
    model: Optional[OpenAIImageModels]
    count: Optional[int]
    seed: Optional["QueryAlertsAlertsResultsPublishingOpenAiImageSeed"]


class QueryAlertsAlertsResultsPublishingOpenAiImageSeed(BaseModel):
    id: str


class QueryAlertsAlertsResultsPublishingGoogleImage(BaseModel):
    model: Optional[GoogleImageModels]
    count: Optional[int]
    seed: Optional["QueryAlertsAlertsResultsPublishingGoogleImageSeed"]


class QueryAlertsAlertsResultsPublishingGoogleImageSeed(BaseModel):
    id: str


class QueryAlertsAlertsResultsPublishingOpenAiVideo(BaseModel):
    model: Optional[OpenAIVideoModels]
    seconds: Optional[int]
    size: Optional[VideoSizeTypes]
    seed: Optional["QueryAlertsAlertsResultsPublishingOpenAiVideoSeed"]


class QueryAlertsAlertsResultsPublishingOpenAiVideoSeed(BaseModel):
    id: str


class QueryAlertsAlertsResultsSummarySpecification(BaseModel):
    id: str


class QueryAlertsAlertsResultsPublishSpecification(BaseModel):
    id: str


class QueryAlertsAlertsResultsSchedulePolicy(BaseModel):
    recurrence_type: Optional[TimedPolicyRecurrenceTypes] = Field(
        alias="recurrenceType"
    )
    repeat_interval: Optional[Any] = Field(alias="repeatInterval")
    cron: Optional[str]
    time_zone_id: Optional[str] = Field(alias="timeZoneId")


QueryAlerts.model_rebuild()
QueryAlertsAlerts.model_rebuild()
QueryAlertsAlertsResults.model_rebuild()
QueryAlertsAlertsResultsFilter.model_rebuild()
QueryAlertsAlertsResultsFilterObservations.model_rebuild()
QueryAlertsAlertsResultsFilterOr.model_rebuild()
QueryAlertsAlertsResultsFilterOrObservations.model_rebuild()
QueryAlertsAlertsResultsFilterAnd.model_rebuild()
QueryAlertsAlertsResultsFilterAndObservations.model_rebuild()
QueryAlertsAlertsResultsIntegration.model_rebuild()
QueryAlertsAlertsResultsPublishing.model_rebuild()
QueryAlertsAlertsResultsPublishingOpenAiImage.model_rebuild()
QueryAlertsAlertsResultsPublishingGoogleImage.model_rebuild()
QueryAlertsAlertsResultsPublishingOpenAiVideo.model_rebuild()
