# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    CalendarAttendeeResponseStatus,
    CalendarEventStatus,
    CalendarEventVisibility,
    CalendarRecurrencePattern,
    CalendarReminderMethod,
    ContentTypes,
    EntityState,
    FileTypes,
    ImageProjectionTypes,
    MailImportance,
    MailPriority,
    MailSensitivity,
    OrientationTypes,
    TextRoles,
)


class QueryContents(BaseModel):
    contents: Optional["QueryContentsContents"]


class QueryContentsContents(BaseModel):
    results: Optional[List[Optional["QueryContentsContentsResults"]]]


class QueryContentsContentsResults(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "QueryContentsContentsResultsOwner"
    state: EntityState
    original_date: Optional[Any] = Field(alias="originalDate")
    finished_date: Optional[Any] = Field(alias="finishedDate")
    workflow_duration: Optional[Any] = Field(alias="workflowDuration")
    uri: Optional[Any]
    description: Optional[str]
    identifier: Optional[str]
    address: Optional["QueryContentsContentsResultsAddress"]
    location: Optional["QueryContentsContentsResultsLocation"]
    features: Optional[str]
    type: Optional[ContentTypes]
    file_type: Optional[FileTypes] = Field(alias="fileType")
    mime_type: Optional[str] = Field(alias="mimeType")
    format: Optional[str]
    format_name: Optional[str] = Field(alias="formatName")
    file_extension: Optional[str] = Field(alias="fileExtension")
    file_name: Optional[str] = Field(alias="fileName")
    file_size: Optional[Any] = Field(alias="fileSize")
    relative_folder_path: Optional[str] = Field(alias="relativeFolderPath")
    master_uri: Optional[Any] = Field(alias="masterUri")
    image_uri: Optional[Any] = Field(alias="imageUri")
    text_uri: Optional[Any] = Field(alias="textUri")
    audio_uri: Optional[Any] = Field(alias="audioUri")
    transcript_uri: Optional[Any] = Field(alias="transcriptUri")
    snapshots_uri: Optional[Any] = Field(alias="snapshotsUri")
    snapshot_count: Optional[int] = Field(alias="snapshotCount")
    summary: Optional[str]
    custom_summary: Optional[str] = Field(alias="customSummary")
    quotes: Optional[List[str]]
    video: Optional["QueryContentsContentsResultsVideo"]
    audio: Optional["QueryContentsContentsResultsAudio"]
    image: Optional["QueryContentsContentsResultsImage"]
    document: Optional["QueryContentsContentsResultsDocument"]
    email: Optional["QueryContentsContentsResultsEmail"]
    event: Optional["QueryContentsContentsResultsEvent"]
    issue: Optional["QueryContentsContentsResultsIssue"]
    commit: Optional["QueryContentsContentsResultsCommit"]
    pull_request: Optional["QueryContentsContentsResultsPullRequest"] = Field(
        alias="pullRequest"
    )
    message: Optional["QueryContentsContentsResultsMessage"]
    post: Optional["QueryContentsContentsResultsPost"]
    package: Optional["QueryContentsContentsResultsPackage"]
    language: Optional["QueryContentsContentsResultsLanguage"]
    feed: Optional["QueryContentsContentsResultsFeed"]
    workflow: Optional["QueryContentsContentsResultsWorkflow"]
    pages: Optional[List["QueryContentsContentsResultsPages"]]
    segments: Optional[List["QueryContentsContentsResultsSegments"]]
    frames: Optional[List["QueryContentsContentsResultsFrames"]]
    error: Optional[str]


class QueryContentsContentsResultsOwner(BaseModel):
    id: str


class QueryContentsContentsResultsAddress(BaseModel):
    street_address: Optional[str] = Field(alias="streetAddress")
    city: Optional[str]
    region: Optional[str]
    country: Optional[str]
    postal_code: Optional[str] = Field(alias="postalCode")


class QueryContentsContentsResultsLocation(BaseModel):
    latitude: Optional[float]
    longitude: Optional[float]


class QueryContentsContentsResultsVideo(BaseModel):
    width: Optional[int]
    height: Optional[int]
    duration: Optional[Any]
    make: Optional[str]
    model: Optional[str]
    software: Optional[str]
    title: Optional[str]
    description: Optional[str]
    keywords: Optional[List[Optional[str]]]
    author: Optional[str]


class QueryContentsContentsResultsAudio(BaseModel):
    keywords: Optional[List[Optional[str]]]
    author: Optional[str]
    series: Optional[str]
    episode: Optional[str]
    episode_type: Optional[str] = Field(alias="episodeType")
    season: Optional[str]
    publisher: Optional[str]
    copyright: Optional[str]
    genre: Optional[str]
    title: Optional[str]
    description: Optional[str]
    bitrate: Optional[int]
    channels: Optional[int]
    sample_rate: Optional[int] = Field(alias="sampleRate")
    bits_per_sample: Optional[int] = Field(alias="bitsPerSample")
    duration: Optional[Any]


class QueryContentsContentsResultsImage(BaseModel):
    width: Optional[int]
    height: Optional[int]
    resolution_x: Optional[int] = Field(alias="resolutionX")
    resolution_y: Optional[int] = Field(alias="resolutionY")
    bits_per_component: Optional[int] = Field(alias="bitsPerComponent")
    components: Optional[int]
    projection_type: Optional[ImageProjectionTypes] = Field(alias="projectionType")
    orientation: Optional[OrientationTypes]
    description: Optional[str]
    make: Optional[str]
    model: Optional[str]
    software: Optional[str]
    lens: Optional[str]
    focal_length: Optional[float] = Field(alias="focalLength")
    exposure_time: Optional[str] = Field(alias="exposureTime")
    f_number: Optional[str] = Field(alias="fNumber")
    iso: Optional[str]
    heading: Optional[float]
    pitch: Optional[float]


class QueryContentsContentsResultsDocument(BaseModel):
    title: Optional[str]
    subject: Optional[str]
    summary: Optional[str]
    author: Optional[str]
    last_modified_by: Optional[str] = Field(alias="lastModifiedBy")
    publisher: Optional[str]
    description: Optional[str]
    keywords: Optional[List[Optional[str]]]
    page_count: Optional[int] = Field(alias="pageCount")
    worksheet_count: Optional[int] = Field(alias="worksheetCount")
    slide_count: Optional[int] = Field(alias="slideCount")
    word_count: Optional[int] = Field(alias="wordCount")
    line_count: Optional[int] = Field(alias="lineCount")
    paragraph_count: Optional[int] = Field(alias="paragraphCount")
    is_encrypted: Optional[bool] = Field(alias="isEncrypted")
    has_digital_signature: Optional[bool] = Field(alias="hasDigitalSignature")


class QueryContentsContentsResultsEmail(BaseModel):
    identifier: Optional[str]
    thread_identifier: Optional[str] = Field(alias="threadIdentifier")
    subject: Optional[str]
    labels: Optional[List[Optional[str]]]
    sensitivity: Optional[MailSensitivity]
    priority: Optional[MailPriority]
    importance: Optional[MailImportance]
    unsubscribe_url: Optional[str] = Field(alias="unsubscribeUrl")
    publication_name: Optional[str] = Field(alias="publicationName")
    publication_url: Optional[str] = Field(alias="publicationUrl")
    attachment_count: Optional[int] = Field(alias="attachmentCount")
    from_: Optional[List[Optional["QueryContentsContentsResultsEmailFrom"]]] = Field(
        alias="from"
    )
    to: Optional[List[Optional["QueryContentsContentsResultsEmailTo"]]]
    cc: Optional[List[Optional["QueryContentsContentsResultsEmailCc"]]]
    bcc: Optional[List[Optional["QueryContentsContentsResultsEmailBcc"]]]


class QueryContentsContentsResultsEmailFrom(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsEmailTo(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsEmailCc(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsEmailBcc(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsEvent(BaseModel):
    event_identifier: Optional[str] = Field(alias="eventIdentifier")
    calendar_identifier: Optional[str] = Field(alias="calendarIdentifier")
    subject: Optional[str]
    start_date_time: Optional[Any] = Field(alias="startDateTime")
    end_date_time: Optional[Any] = Field(alias="endDateTime")
    is_all_day: Optional[bool] = Field(alias="isAllDay")
    timezone: Optional[str]
    status: Optional[CalendarEventStatus]
    visibility: Optional[CalendarEventVisibility]
    meeting_link: Optional[str] = Field(alias="meetingLink")
    organizer: Optional["QueryContentsContentsResultsEventOrganizer"]
    attendees: Optional[List[Optional["QueryContentsContentsResultsEventAttendees"]]]
    categories: Optional[List[Optional[str]]]
    reminders: Optional[List[Optional["QueryContentsContentsResultsEventReminders"]]]
    recurrence: Optional["QueryContentsContentsResultsEventRecurrence"]
    recurring_event_identifier: Optional[str] = Field(alias="recurringEventIdentifier")
    is_recurring: Optional[bool] = Field(alias="isRecurring")


class QueryContentsContentsResultsEventOrganizer(BaseModel):
    name: Optional[str]
    email: Optional[str]
    is_optional: Optional[bool] = Field(alias="isOptional")
    is_organizer: Optional[bool] = Field(alias="isOrganizer")
    response_status: Optional[CalendarAttendeeResponseStatus] = Field(
        alias="responseStatus"
    )


class QueryContentsContentsResultsEventAttendees(BaseModel):
    name: Optional[str]
    email: Optional[str]
    is_optional: Optional[bool] = Field(alias="isOptional")
    is_organizer: Optional[bool] = Field(alias="isOrganizer")
    response_status: Optional[CalendarAttendeeResponseStatus] = Field(
        alias="responseStatus"
    )


class QueryContentsContentsResultsEventReminders(BaseModel):
    minutes_before: Optional[int] = Field(alias="minutesBefore")
    method: Optional[CalendarReminderMethod]


class QueryContentsContentsResultsEventRecurrence(BaseModel):
    pattern: Optional[CalendarRecurrencePattern]
    interval: Optional[int]
    count: Optional[int]
    until: Optional[Any]
    days_of_week: Optional[List[Optional[str]]] = Field(alias="daysOfWeek")
    day_of_month: Optional[int] = Field(alias="dayOfMonth")
    month_of_year: Optional[int] = Field(alias="monthOfYear")


class QueryContentsContentsResultsIssue(BaseModel):
    identifier: Optional[str]
    title: Optional[str]
    project: Optional[str]
    team: Optional[str]
    status: Optional[str]
    priority: Optional[str]
    type: Optional[str]
    labels: Optional[List[Optional[str]]]


class QueryContentsContentsResultsCommit(BaseModel):
    sha: Optional[str]
    message: Optional[str]
    project: Optional[str]
    team: Optional[str]
    branch: Optional[str]
    parent_shas: Optional[List[Optional[str]]] = Field(alias="parentShas")
    files_changed: Optional[int] = Field(alias="filesChanged")
    additions: Optional[int]
    deletions: Optional[int]
    pull_request_number: Optional[str] = Field(alias="pullRequestNumber")
    author_date: Optional[Any] = Field(alias="authorDate")
    committer_date: Optional[Any] = Field(alias="committerDate")
    labels: Optional[List[Optional[str]]]


class QueryContentsContentsResultsPullRequest(BaseModel):
    identifier: Optional[str]
    title: Optional[str]
    project: Optional[str]
    team: Optional[str]
    status: Optional[str]
    type: Optional[str]
    base_branch: Optional[str] = Field(alias="baseBranch")
    head_branch: Optional[str] = Field(alias="headBranch")
    is_draft: Optional[bool] = Field(alias="isDraft")
    is_mergeable: Optional[bool] = Field(alias="isMergeable")
    merge_commit_sha: Optional[str] = Field(alias="mergeCommitSha")
    merged_at: Optional[Any] = Field(alias="mergedAt")
    files_changed: Optional[int] = Field(alias="filesChanged")
    additions: Optional[int]
    deletions: Optional[int]
    labels: Optional[List[Optional[str]]]


class QueryContentsContentsResultsMessage(BaseModel):
    identifier: Optional[str]
    conversation_identifier: Optional[str] = Field(alias="conversationIdentifier")
    channel_identifier: Optional[str] = Field(alias="channelIdentifier")
    channel_name: Optional[str] = Field(alias="channelName")
    attachment_count: Optional[int] = Field(alias="attachmentCount")
    links: Optional[List[Optional[Any]]]
    author: Optional["QueryContentsContentsResultsMessageAuthor"]
    mentions: Optional[List[Optional["QueryContentsContentsResultsMessageMentions"]]]


class QueryContentsContentsResultsMessageAuthor(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsMessageMentions(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsPost(BaseModel):
    identifier: Optional[str]
    title: Optional[str]
    author: Optional["QueryContentsContentsResultsPostAuthor"]
    upvotes: Optional[int]
    downvotes: Optional[int]
    comment_count: Optional[int] = Field(alias="commentCount")
    links: Optional[List[Optional[Any]]]


class QueryContentsContentsResultsPostAuthor(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class QueryContentsContentsResultsPackage(BaseModel):
    file_count: Optional[int] = Field(alias="fileCount")
    folder_count: Optional[int] = Field(alias="folderCount")
    is_encrypted: Optional[bool] = Field(alias="isEncrypted")


class QueryContentsContentsResultsLanguage(BaseModel):
    languages: Optional[List[Optional[str]]]


class QueryContentsContentsResultsFeed(BaseModel):
    id: str
    name: str


class QueryContentsContentsResultsWorkflow(BaseModel):
    id: str
    name: str


class QueryContentsContentsResultsPages(BaseModel):
    index: Optional[int]
    text: Optional[str]
    relevance: Optional[float]
    images: Optional[List[Optional["QueryContentsContentsResultsPagesImages"]]]
    chunks: Optional[List[Optional["QueryContentsContentsResultsPagesChunks"]]]


class QueryContentsContentsResultsPagesImages(BaseModel):
    id: Optional[str]
    mime_type: Optional[str] = Field(alias="mimeType")
    data: Optional[str]
    left: Optional[int]
    right: Optional[int]
    top: Optional[int]
    bottom: Optional[int]


class QueryContentsContentsResultsPagesChunks(BaseModel):
    index: Optional[int]
    page_index: Optional[int] = Field(alias="pageIndex")
    row_index: Optional[int] = Field(alias="rowIndex")
    column_index: Optional[int] = Field(alias="columnIndex")
    confidence: Optional[float]
    text: Optional[str]
    role: Optional[TextRoles]
    language: Optional[str]
    relevance: Optional[float]


class QueryContentsContentsResultsSegments(BaseModel):
    start_time: Optional[Any] = Field(alias="startTime")
    end_time: Optional[Any] = Field(alias="endTime")
    text: Optional[str]
    relevance: Optional[float]


class QueryContentsContentsResultsFrames(BaseModel):
    index: Optional[int]
    description: Optional[str]
    text: Optional[str]
    relevance: Optional[float]


QueryContents.model_rebuild()
QueryContentsContents.model_rebuild()
QueryContentsContentsResults.model_rebuild()
QueryContentsContentsResultsEmail.model_rebuild()
QueryContentsContentsResultsEvent.model_rebuild()
QueryContentsContentsResultsMessage.model_rebuild()
QueryContentsContentsResultsPost.model_rebuild()
QueryContentsContentsResultsPages.model_rebuild()
