# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AssemblyAIModels,
    AzureDocumentIntelligenceModels,
    AzureDocumentIntelligenceVersions,
    ContentClassificationServiceTypes,
    ContentIndexingServiceTypes,
    ContentTypes,
    DeepgramModels,
    EmbeddingTypes,
    EntityEnrichmentServiceTypes,
    EntityExtractionServiceTypes,
    EntityState,
    FilePreparationServiceTypes,
    FileTypes,
    IntegrationServiceTypes,
    LinkTypes,
    MCPServerTypes,
    ObservableTypes,
    ReductoEnrichmentModes,
    ReductoExtractionModes,
    ReductoOcrModes,
    ReductoOcrSystems,
    RegexSourceTypes,
    StoragePolicyTypes,
    SummarizationTypes,
)


class QueryWorkflows(BaseModel):
    workflows: Optional["QueryWorkflowsWorkflows"]


class QueryWorkflowsWorkflows(BaseModel):
    results: Optional[List["QueryWorkflowsWorkflowsResults"]]


class QueryWorkflowsWorkflowsResults(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "QueryWorkflowsWorkflowsResultsOwner"
    state: EntityState
    ingestion: Optional["QueryWorkflowsWorkflowsResultsIngestion"]
    indexing: Optional["QueryWorkflowsWorkflowsResultsIndexing"]
    preparation: Optional["QueryWorkflowsWorkflowsResultsPreparation"]
    extraction: Optional["QueryWorkflowsWorkflowsResultsExtraction"]
    classification: Optional["QueryWorkflowsWorkflowsResultsClassification"]
    enrichment: Optional["QueryWorkflowsWorkflowsResultsEnrichment"]
    storage: Optional["QueryWorkflowsWorkflowsResultsStorage"]
    actions: Optional[List[Optional["QueryWorkflowsWorkflowsResultsActions"]]]


class QueryWorkflowsWorkflowsResultsOwner(BaseModel):
    id: str


class QueryWorkflowsWorkflowsResultsIngestion(BaseModel):
    if_: Optional["QueryWorkflowsWorkflowsResultsIngestionIf"] = Field(alias="if")
    collections: Optional[
        List[Optional["QueryWorkflowsWorkflowsResultsIngestionCollections"]]
    ]
    observations: Optional[
        List[Optional["QueryWorkflowsWorkflowsResultsIngestionObservations"]]
    ]
    enable_email_collections: Optional[bool] = Field(alias="enableEmailCollections")
    enable_folder_collections: Optional[bool] = Field(alias="enableFolderCollections")
    enable_message_collections: Optional[bool] = Field(alias="enableMessageCollections")


class QueryWorkflowsWorkflowsResultsIngestionIf(BaseModel):
    types: Optional[List[ContentTypes]]
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    formats: Optional[List[Optional[str]]]
    file_extensions: Optional[List[str]] = Field(alias="fileExtensions")
    allowed_paths: Optional[List[str]] = Field(alias="allowedPaths")
    excluded_paths: Optional[List[str]] = Field(alias="excludedPaths")


class QueryWorkflowsWorkflowsResultsIngestionCollections(BaseModel):
    id: str


class QueryWorkflowsWorkflowsResultsIngestionObservations(BaseModel):
    type: ObservableTypes
    observable: "QueryWorkflowsWorkflowsResultsIngestionObservationsObservable"


class QueryWorkflowsWorkflowsResultsIngestionObservationsObservable(BaseModel):
    id: str
    name: Optional[str]


class QueryWorkflowsWorkflowsResultsIndexing(BaseModel):
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsIndexingJobs"]]]


class QueryWorkflowsWorkflowsResultsIndexingJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsIndexingJobsConnector"]


class QueryWorkflowsWorkflowsResultsIndexingJobsConnector(BaseModel):
    type: Optional[ContentIndexingServiceTypes]
    content_type: Optional[ContentTypes] = Field(alias="contentType")
    file_type: Optional[FileTypes] = Field(alias="fileType")


class QueryWorkflowsWorkflowsResultsPreparation(BaseModel):
    enable_unblocked_capture: Optional[bool] = Field(alias="enableUnblockedCapture")
    disable_smart_capture: Optional[bool] = Field(alias="disableSmartCapture")
    summarizations: Optional[
        List[Optional["QueryWorkflowsWorkflowsResultsPreparationSummarizations"]]
    ]
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsPreparationJobs"]]]


class QueryWorkflowsWorkflowsResultsPreparationSummarizations(BaseModel):
    type: SummarizationTypes
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationSummarizationsSpecification"
    ]
    tokens: Optional[int]
    items: Optional[int]
    prompt: Optional[str]


class QueryWorkflowsWorkflowsResultsPreparationSummarizationsSpecification(BaseModel):
    id: str


class QueryWorkflowsWorkflowsResultsPreparationJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnector"]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnector(BaseModel):
    type: FilePreparationServiceTypes
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    azure_document: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationJobsConnectorAzureDocument"
    ] = Field(alias="azureDocument")
    deepgram: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDeepgram"]
    assembly_ai: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationJobsConnectorAssemblyAi"
    ] = Field(alias="assemblyAI")
    page: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorPage"]
    document: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDocument"]
    email: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorEmail"]
    model_document: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationJobsConnectorModelDocument"
    ] = Field(alias="modelDocument")
    reducto: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorReducto"]
    mistral: Optional["QueryWorkflowsWorkflowsResultsPreparationJobsConnectorMistral"]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorAzureDocument(BaseModel):
    version: Optional[AzureDocumentIntelligenceVersions]
    model: Optional[AzureDocumentIntelligenceModels]
    endpoint: Optional[Any]
    key: Optional[str]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDeepgram(BaseModel):
    model: Optional[DeepgramModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")
    detect_language: Optional[bool] = Field(alias="detectLanguage")
    language: Optional[str]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorAssemblyAi(BaseModel):
    model: Optional[AssemblyAIModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")
    detect_language: Optional[bool] = Field(alias="detectLanguage")
    language: Optional[str]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorPage(BaseModel):
    enable_screenshot: Optional[bool] = Field(alias="enableScreenshot")


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorDocument(BaseModel):
    include_images: Optional[bool] = Field(alias="includeImages")


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorEmail(BaseModel):
    include_attachments: Optional[bool] = Field(alias="includeAttachments")


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorModelDocument(BaseModel):
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsPreparationJobsConnectorModelDocumentSpecification"
    ]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorModelDocumentSpecification(
    BaseModel
):
    id: str


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorReducto(BaseModel):
    ocr_mode: Optional[ReductoOcrModes] = Field(alias="ocrMode")
    ocr_system: Optional[ReductoOcrSystems] = Field(alias="ocrSystem")
    extraction_mode: Optional[ReductoExtractionModes] = Field(alias="extractionMode")
    enable_enrichment: Optional[bool] = Field(alias="enableEnrichment")
    enrichment_mode: Optional[ReductoEnrichmentModes] = Field(alias="enrichmentMode")
    key: Optional[str]


class QueryWorkflowsWorkflowsResultsPreparationJobsConnectorMistral(BaseModel):
    key: Optional[str]


class QueryWorkflowsWorkflowsResultsExtraction(BaseModel):
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsExtractionJobs"]]]


class QueryWorkflowsWorkflowsResultsExtractionJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsExtractionJobsConnector"]


class QueryWorkflowsWorkflowsResultsExtractionJobsConnector(BaseModel):
    type: EntityExtractionServiceTypes
    content_types: Optional[List[ContentTypes]] = Field(alias="contentTypes")
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    extracted_types: Optional[List[ObservableTypes]] = Field(alias="extractedTypes")
    extracted_count: Optional[int] = Field(alias="extractedCount")
    azure_text: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureText"
    ] = Field(alias="azureText")
    azure_image: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureImage"
    ] = Field(alias="azureImage")
    model_image: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelImage"
    ] = Field(alias="modelImage")
    model_text: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelText"
    ] = Field(alias="modelText")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureText(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    enable_pii: Optional[bool] = Field(alias="enablePII")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorAzureImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelImage(BaseModel):
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelImageSpecification"
    ]


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelImageSpecification(
    BaseModel
):
    id: str


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelText(BaseModel):
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelTextSpecification"
    ]
    token_threshold: Optional[int] = Field(alias="tokenThreshold")


class QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelTextSpecification(
    BaseModel
):
    id: str


class QueryWorkflowsWorkflowsResultsClassification(BaseModel):
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsClassificationJobs"]]]


class QueryWorkflowsWorkflowsResultsClassificationJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsClassificationJobsConnector"]


class QueryWorkflowsWorkflowsResultsClassificationJobsConnector(BaseModel):
    type: ContentClassificationServiceTypes
    content_type: Optional[ContentTypes] = Field(alias="contentType")
    file_type: Optional[FileTypes] = Field(alias="fileType")
    model: Optional["QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModel"]
    regex: Optional["QueryWorkflowsWorkflowsResultsClassificationJobsConnectorRegex"]


class QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModel(BaseModel):
    specification: Optional[
        "QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModelSpecification"
    ]
    rules: Optional[
        List[
            Optional[
                "QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModelRules"
            ]
        ]
    ]


class QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModelSpecification(
    BaseModel
):
    id: str


class QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModelRules(BaseModel):
    then: Optional[str]
    if_: Optional[str] = Field(alias="if")


class QueryWorkflowsWorkflowsResultsClassificationJobsConnectorRegex(BaseModel):
    rules: Optional[
        List[
            Optional[
                "QueryWorkflowsWorkflowsResultsClassificationJobsConnectorRegexRules"
            ]
        ]
    ]


class QueryWorkflowsWorkflowsResultsClassificationJobsConnectorRegexRules(BaseModel):
    then: Optional[str]
    type: Optional[RegexSourceTypes]
    path: Optional[str]
    matches: Optional[str]


class QueryWorkflowsWorkflowsResultsEnrichment(BaseModel):
    link: Optional["QueryWorkflowsWorkflowsResultsEnrichmentLink"]
    jobs: Optional[List[Optional["QueryWorkflowsWorkflowsResultsEnrichmentJobs"]]]


class QueryWorkflowsWorkflowsResultsEnrichmentLink(BaseModel):
    enable_crawling: Optional[bool] = Field(alias="enableCrawling")
    allowed_domains: Optional[List[str]] = Field(alias="allowedDomains")
    excluded_domains: Optional[List[str]] = Field(alias="excludedDomains")
    allowed_paths: Optional[List[str]] = Field(alias="allowedPaths")
    excluded_paths: Optional[List[str]] = Field(alias="excludedPaths")
    allowed_links: Optional[List[LinkTypes]] = Field(alias="allowedLinks")
    excluded_links: Optional[List[LinkTypes]] = Field(alias="excludedLinks")
    allowed_files: Optional[List[FileTypes]] = Field(alias="allowedFiles")
    excluded_files: Optional[List[FileTypes]] = Field(alias="excludedFiles")
    allowed_content_types: Optional[List[ContentTypes]] = Field(
        alias="allowedContentTypes"
    )
    excluded_content_types: Optional[List[ContentTypes]] = Field(
        alias="excludedContentTypes"
    )
    allow_content_domain: Optional[bool] = Field(alias="allowContentDomain")
    maximum_links: Optional[int] = Field(alias="maximumLinks")


class QueryWorkflowsWorkflowsResultsEnrichmentJobs(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsEnrichmentJobsConnector"]


class QueryWorkflowsWorkflowsResultsEnrichmentJobsConnector(BaseModel):
    type: Optional[EntityEnrichmentServiceTypes]
    enriched_types: Optional[List[ObservableTypes]] = Field(alias="enrichedTypes")
    fhir: Optional["QueryWorkflowsWorkflowsResultsEnrichmentJobsConnectorFhir"]
    diffbot: Optional["QueryWorkflowsWorkflowsResultsEnrichmentJobsConnectorDiffbot"]


class QueryWorkflowsWorkflowsResultsEnrichmentJobsConnectorFhir(BaseModel):
    endpoint: Optional[Any]


class QueryWorkflowsWorkflowsResultsEnrichmentJobsConnectorDiffbot(BaseModel):
    key: Optional[Any]


class QueryWorkflowsWorkflowsResultsStorage(BaseModel):
    policy: Optional["QueryWorkflowsWorkflowsResultsStoragePolicy"]


class QueryWorkflowsWorkflowsResultsStoragePolicy(BaseModel):
    type: Optional[StoragePolicyTypes]
    allow_duplicates: Optional[bool] = Field(alias="allowDuplicates")
    embedding_types: Optional[List[EmbeddingTypes]] = Field(alias="embeddingTypes")
    enable_snapshots: Optional[bool] = Field(alias="enableSnapshots")
    snapshot_count: Optional[int] = Field(alias="snapshotCount")


class QueryWorkflowsWorkflowsResultsActions(BaseModel):
    connector: Optional["QueryWorkflowsWorkflowsResultsActionsConnector"]


class QueryWorkflowsWorkflowsResultsActionsConnector(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["QueryWorkflowsWorkflowsResultsActionsConnectorSlack"]
    email: Optional["QueryWorkflowsWorkflowsResultsActionsConnectorEmail"]
    twitter: Optional["QueryWorkflowsWorkflowsResultsActionsConnectorTwitter"]
    mcp: Optional["QueryWorkflowsWorkflowsResultsActionsConnectorMcp"]


class QueryWorkflowsWorkflowsResultsActionsConnectorSlack(BaseModel):
    token: str
    channel: str


class QueryWorkflowsWorkflowsResultsActionsConnectorEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class QueryWorkflowsWorkflowsResultsActionsConnectorTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class QueryWorkflowsWorkflowsResultsActionsConnectorMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


QueryWorkflows.model_rebuild()
QueryWorkflowsWorkflows.model_rebuild()
QueryWorkflowsWorkflowsResults.model_rebuild()
QueryWorkflowsWorkflowsResultsIngestion.model_rebuild()
QueryWorkflowsWorkflowsResultsIngestionObservations.model_rebuild()
QueryWorkflowsWorkflowsResultsIndexing.model_rebuild()
QueryWorkflowsWorkflowsResultsIndexingJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparation.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationSummarizations.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationJobsConnector.model_rebuild()
QueryWorkflowsWorkflowsResultsPreparationJobsConnectorModelDocument.model_rebuild()
QueryWorkflowsWorkflowsResultsExtraction.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobsConnector.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelImage.model_rebuild()
QueryWorkflowsWorkflowsResultsExtractionJobsConnectorModelText.model_rebuild()
QueryWorkflowsWorkflowsResultsClassification.model_rebuild()
QueryWorkflowsWorkflowsResultsClassificationJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsClassificationJobsConnector.model_rebuild()
QueryWorkflowsWorkflowsResultsClassificationJobsConnectorModel.model_rebuild()
QueryWorkflowsWorkflowsResultsClassificationJobsConnectorRegex.model_rebuild()
QueryWorkflowsWorkflowsResultsEnrichment.model_rebuild()
QueryWorkflowsWorkflowsResultsEnrichmentJobs.model_rebuild()
QueryWorkflowsWorkflowsResultsEnrichmentJobsConnector.model_rebuild()
QueryWorkflowsWorkflowsResultsStorage.model_rebuild()
QueryWorkflowsWorkflowsResultsActions.model_rebuild()
QueryWorkflowsWorkflowsResultsActionsConnector.model_rebuild()
