# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AssemblyAIModels,
    AzureDocumentIntelligenceModels,
    AzureDocumentIntelligenceVersions,
    ContentClassificationServiceTypes,
    ContentIndexingServiceTypes,
    ContentTypes,
    DeepgramModels,
    EmbeddingTypes,
    EntityEnrichmentServiceTypes,
    EntityExtractionServiceTypes,
    EntityState,
    FilePreparationServiceTypes,
    FileTypes,
    IntegrationServiceTypes,
    LinkTypes,
    MCPServerTypes,
    ObservableTypes,
    ReductoEnrichmentModes,
    ReductoExtractionModes,
    ReductoOcrModes,
    ReductoOcrSystems,
    RegexSourceTypes,
    StoragePolicyTypes,
    SummarizationTypes,
)


class UpdateWorkflow(BaseModel):
    update_workflow: Optional["UpdateWorkflowUpdateWorkflow"] = Field(
        alias="updateWorkflow"
    )


class UpdateWorkflowUpdateWorkflow(BaseModel):
    id: str
    name: str
    state: EntityState
    ingestion: Optional["UpdateWorkflowUpdateWorkflowIngestion"]
    indexing: Optional["UpdateWorkflowUpdateWorkflowIndexing"]
    preparation: Optional["UpdateWorkflowUpdateWorkflowPreparation"]
    extraction: Optional["UpdateWorkflowUpdateWorkflowExtraction"]
    classification: Optional["UpdateWorkflowUpdateWorkflowClassification"]
    enrichment: Optional["UpdateWorkflowUpdateWorkflowEnrichment"]
    storage: Optional["UpdateWorkflowUpdateWorkflowStorage"]
    actions: Optional[List[Optional["UpdateWorkflowUpdateWorkflowActions"]]]


class UpdateWorkflowUpdateWorkflowIngestion(BaseModel):
    if_: Optional["UpdateWorkflowUpdateWorkflowIngestionIf"] = Field(alias="if")
    collections: Optional[
        List[Optional["UpdateWorkflowUpdateWorkflowIngestionCollections"]]
    ]
    observations: Optional[
        List[Optional["UpdateWorkflowUpdateWorkflowIngestionObservations"]]
    ]
    enable_email_collections: Optional[bool] = Field(alias="enableEmailCollections")
    enable_folder_collections: Optional[bool] = Field(alias="enableFolderCollections")
    enable_message_collections: Optional[bool] = Field(alias="enableMessageCollections")


class UpdateWorkflowUpdateWorkflowIngestionIf(BaseModel):
    types: Optional[List[ContentTypes]]
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    formats: Optional[List[Optional[str]]]
    file_extensions: Optional[List[str]] = Field(alias="fileExtensions")
    allowed_paths: Optional[List[str]] = Field(alias="allowedPaths")
    excluded_paths: Optional[List[str]] = Field(alias="excludedPaths")


class UpdateWorkflowUpdateWorkflowIngestionCollections(BaseModel):
    id: str


class UpdateWorkflowUpdateWorkflowIngestionObservations(BaseModel):
    type: ObservableTypes
    observable: "UpdateWorkflowUpdateWorkflowIngestionObservationsObservable"


class UpdateWorkflowUpdateWorkflowIngestionObservationsObservable(BaseModel):
    id: str
    name: Optional[str]


class UpdateWorkflowUpdateWorkflowIndexing(BaseModel):
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowIndexingJobs"]]]


class UpdateWorkflowUpdateWorkflowIndexingJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowIndexingJobsConnector"]


class UpdateWorkflowUpdateWorkflowIndexingJobsConnector(BaseModel):
    type: Optional[ContentIndexingServiceTypes]
    content_type: Optional[ContentTypes] = Field(alias="contentType")
    file_type: Optional[FileTypes] = Field(alias="fileType")


class UpdateWorkflowUpdateWorkflowPreparation(BaseModel):
    enable_unblocked_capture: Optional[bool] = Field(alias="enableUnblockedCapture")
    disable_smart_capture: Optional[bool] = Field(alias="disableSmartCapture")
    summarizations: Optional[
        List[Optional["UpdateWorkflowUpdateWorkflowPreparationSummarizations"]]
    ]
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowPreparationJobs"]]]


class UpdateWorkflowUpdateWorkflowPreparationSummarizations(BaseModel):
    type: SummarizationTypes
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationSummarizationsSpecification"
    ]
    tokens: Optional[int]
    items: Optional[int]
    prompt: Optional[str]


class UpdateWorkflowUpdateWorkflowPreparationSummarizationsSpecification(BaseModel):
    id: str


class UpdateWorkflowUpdateWorkflowPreparationJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnector"]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnector(BaseModel):
    type: FilePreparationServiceTypes
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    azure_document: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationJobsConnectorAzureDocument"
    ] = Field(alias="azureDocument")
    deepgram: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDeepgram"]
    assembly_ai: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationJobsConnectorAssemblyAi"
    ] = Field(alias="assemblyAI")
    page: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorPage"]
    document: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDocument"]
    email: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorEmail"]
    model_document: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationJobsConnectorModelDocument"
    ] = Field(alias="modelDocument")
    reducto: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorReducto"]
    mistral: Optional["UpdateWorkflowUpdateWorkflowPreparationJobsConnectorMistral"]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorAzureDocument(BaseModel):
    version: Optional[AzureDocumentIntelligenceVersions]
    model: Optional[AzureDocumentIntelligenceModels]
    endpoint: Optional[Any]
    key: Optional[str]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDeepgram(BaseModel):
    model: Optional[DeepgramModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")
    detect_language: Optional[bool] = Field(alias="detectLanguage")
    language: Optional[str]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorAssemblyAi(BaseModel):
    model: Optional[AssemblyAIModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")
    detect_language: Optional[bool] = Field(alias="detectLanguage")
    language: Optional[str]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorPage(BaseModel):
    enable_screenshot: Optional[bool] = Field(alias="enableScreenshot")


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorDocument(BaseModel):
    include_images: Optional[bool] = Field(alias="includeImages")


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorEmail(BaseModel):
    include_attachments: Optional[bool] = Field(alias="includeAttachments")


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorModelDocument(BaseModel):
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowPreparationJobsConnectorModelDocumentSpecification"
    ]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorModelDocumentSpecification(
    BaseModel
):
    id: str


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorReducto(BaseModel):
    ocr_mode: Optional[ReductoOcrModes] = Field(alias="ocrMode")
    ocr_system: Optional[ReductoOcrSystems] = Field(alias="ocrSystem")
    extraction_mode: Optional[ReductoExtractionModes] = Field(alias="extractionMode")
    enable_enrichment: Optional[bool] = Field(alias="enableEnrichment")
    enrichment_mode: Optional[ReductoEnrichmentModes] = Field(alias="enrichmentMode")
    key: Optional[str]


class UpdateWorkflowUpdateWorkflowPreparationJobsConnectorMistral(BaseModel):
    key: Optional[str]


class UpdateWorkflowUpdateWorkflowExtraction(BaseModel):
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowExtractionJobs"]]]


class UpdateWorkflowUpdateWorkflowExtractionJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowExtractionJobsConnector"]


class UpdateWorkflowUpdateWorkflowExtractionJobsConnector(BaseModel):
    type: EntityExtractionServiceTypes
    content_types: Optional[List[ContentTypes]] = Field(alias="contentTypes")
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    extracted_types: Optional[List[ObservableTypes]] = Field(alias="extractedTypes")
    extracted_count: Optional[int] = Field(alias="extractedCount")
    azure_text: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureText"
    ] = Field(alias="azureText")
    azure_image: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureImage"
    ] = Field(alias="azureImage")
    model_image: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelImage"
    ] = Field(alias="modelImage")
    model_text: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelText"
    ] = Field(alias="modelText")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureText(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    enable_pii: Optional[bool] = Field(alias="enablePII")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorAzureImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelImage(BaseModel):
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelImageSpecification"
    ]


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelImageSpecification(
    BaseModel
):
    id: str


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelText(BaseModel):
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelTextSpecification"
    ]
    token_threshold: Optional[int] = Field(alias="tokenThreshold")


class UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelTextSpecification(
    BaseModel
):
    id: str


class UpdateWorkflowUpdateWorkflowClassification(BaseModel):
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowClassificationJobs"]]]


class UpdateWorkflowUpdateWorkflowClassificationJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowClassificationJobsConnector"]


class UpdateWorkflowUpdateWorkflowClassificationJobsConnector(BaseModel):
    type: ContentClassificationServiceTypes
    content_type: Optional[ContentTypes] = Field(alias="contentType")
    file_type: Optional[FileTypes] = Field(alias="fileType")
    model: Optional["UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModel"]
    regex: Optional["UpdateWorkflowUpdateWorkflowClassificationJobsConnectorRegex"]


class UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModel(BaseModel):
    specification: Optional[
        "UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModelSpecification"
    ]
    rules: Optional[
        List[
            Optional[
                "UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModelRules"
            ]
        ]
    ]


class UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModelSpecification(
    BaseModel
):
    id: str


class UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModelRules(BaseModel):
    then: Optional[str]
    if_: Optional[str] = Field(alias="if")


class UpdateWorkflowUpdateWorkflowClassificationJobsConnectorRegex(BaseModel):
    rules: Optional[
        List[
            Optional[
                "UpdateWorkflowUpdateWorkflowClassificationJobsConnectorRegexRules"
            ]
        ]
    ]


class UpdateWorkflowUpdateWorkflowClassificationJobsConnectorRegexRules(BaseModel):
    then: Optional[str]
    type: Optional[RegexSourceTypes]
    path: Optional[str]
    matches: Optional[str]


class UpdateWorkflowUpdateWorkflowEnrichment(BaseModel):
    link: Optional["UpdateWorkflowUpdateWorkflowEnrichmentLink"]
    jobs: Optional[List[Optional["UpdateWorkflowUpdateWorkflowEnrichmentJobs"]]]


class UpdateWorkflowUpdateWorkflowEnrichmentLink(BaseModel):
    enable_crawling: Optional[bool] = Field(alias="enableCrawling")
    allowed_domains: Optional[List[str]] = Field(alias="allowedDomains")
    excluded_domains: Optional[List[str]] = Field(alias="excludedDomains")
    allowed_paths: Optional[List[str]] = Field(alias="allowedPaths")
    excluded_paths: Optional[List[str]] = Field(alias="excludedPaths")
    allowed_links: Optional[List[LinkTypes]] = Field(alias="allowedLinks")
    excluded_links: Optional[List[LinkTypes]] = Field(alias="excludedLinks")
    allowed_files: Optional[List[FileTypes]] = Field(alias="allowedFiles")
    excluded_files: Optional[List[FileTypes]] = Field(alias="excludedFiles")
    allowed_content_types: Optional[List[ContentTypes]] = Field(
        alias="allowedContentTypes"
    )
    excluded_content_types: Optional[List[ContentTypes]] = Field(
        alias="excludedContentTypes"
    )
    allow_content_domain: Optional[bool] = Field(alias="allowContentDomain")
    maximum_links: Optional[int] = Field(alias="maximumLinks")


class UpdateWorkflowUpdateWorkflowEnrichmentJobs(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowEnrichmentJobsConnector"]


class UpdateWorkflowUpdateWorkflowEnrichmentJobsConnector(BaseModel):
    type: Optional[EntityEnrichmentServiceTypes]
    enriched_types: Optional[List[ObservableTypes]] = Field(alias="enrichedTypes")
    fhir: Optional["UpdateWorkflowUpdateWorkflowEnrichmentJobsConnectorFhir"]
    diffbot: Optional["UpdateWorkflowUpdateWorkflowEnrichmentJobsConnectorDiffbot"]


class UpdateWorkflowUpdateWorkflowEnrichmentJobsConnectorFhir(BaseModel):
    endpoint: Optional[Any]


class UpdateWorkflowUpdateWorkflowEnrichmentJobsConnectorDiffbot(BaseModel):
    key: Optional[Any]


class UpdateWorkflowUpdateWorkflowStorage(BaseModel):
    policy: Optional["UpdateWorkflowUpdateWorkflowStoragePolicy"]


class UpdateWorkflowUpdateWorkflowStoragePolicy(BaseModel):
    type: Optional[StoragePolicyTypes]
    allow_duplicates: Optional[bool] = Field(alias="allowDuplicates")
    embedding_types: Optional[List[EmbeddingTypes]] = Field(alias="embeddingTypes")
    enable_snapshots: Optional[bool] = Field(alias="enableSnapshots")
    snapshot_count: Optional[int] = Field(alias="snapshotCount")


class UpdateWorkflowUpdateWorkflowActions(BaseModel):
    connector: Optional["UpdateWorkflowUpdateWorkflowActionsConnector"]


class UpdateWorkflowUpdateWorkflowActionsConnector(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["UpdateWorkflowUpdateWorkflowActionsConnectorSlack"]
    email: Optional["UpdateWorkflowUpdateWorkflowActionsConnectorEmail"]
    twitter: Optional["UpdateWorkflowUpdateWorkflowActionsConnectorTwitter"]
    mcp: Optional["UpdateWorkflowUpdateWorkflowActionsConnectorMcp"]


class UpdateWorkflowUpdateWorkflowActionsConnectorSlack(BaseModel):
    token: str
    channel: str


class UpdateWorkflowUpdateWorkflowActionsConnectorEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class UpdateWorkflowUpdateWorkflowActionsConnectorTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class UpdateWorkflowUpdateWorkflowActionsConnectorMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


UpdateWorkflow.model_rebuild()
UpdateWorkflowUpdateWorkflow.model_rebuild()
UpdateWorkflowUpdateWorkflowIngestion.model_rebuild()
UpdateWorkflowUpdateWorkflowIngestionObservations.model_rebuild()
UpdateWorkflowUpdateWorkflowIndexing.model_rebuild()
UpdateWorkflowUpdateWorkflowIndexingJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparation.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationSummarizations.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationJobsConnector.model_rebuild()
UpdateWorkflowUpdateWorkflowPreparationJobsConnectorModelDocument.model_rebuild()
UpdateWorkflowUpdateWorkflowExtraction.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobsConnector.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelImage.model_rebuild()
UpdateWorkflowUpdateWorkflowExtractionJobsConnectorModelText.model_rebuild()
UpdateWorkflowUpdateWorkflowClassification.model_rebuild()
UpdateWorkflowUpdateWorkflowClassificationJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowClassificationJobsConnector.model_rebuild()
UpdateWorkflowUpdateWorkflowClassificationJobsConnectorModel.model_rebuild()
UpdateWorkflowUpdateWorkflowClassificationJobsConnectorRegex.model_rebuild()
UpdateWorkflowUpdateWorkflowEnrichment.model_rebuild()
UpdateWorkflowUpdateWorkflowEnrichmentJobs.model_rebuild()
UpdateWorkflowUpdateWorkflowEnrichmentJobsConnector.model_rebuild()
UpdateWorkflowUpdateWorkflowStorage.model_rebuild()
UpdateWorkflowUpdateWorkflowActions.model_rebuild()
UpdateWorkflowUpdateWorkflowActionsConnector.model_rebuild()
