# coding: utf-8

"""
    SRO Master API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.29
    Contact: info@nexium.me
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from sromaster.models.email_search_status import EmailSearchStatus
from sromaster.models.im_insurer_out import IMInsurerOut
from sromaster.models.im_mailing_invoice_summary import IMMailingInvoiceSummary
from sromaster.models.insurance_out import InsuranceOut
from sromaster.models.insurance_premium import InsurancePremium
from sromaster.models.insured_sum import InsuredSum
from sromaster.models.invoice_status import InvoiceStatus
from sromaster.models.mailing_result import MailingResult
from sromaster.models.mailing_status import MailingStatus
from sromaster.models.message_status import MessageStatus
from sromaster.models.organization_public import OrganizationPublic
from sromaster.models.sro_short import SROShort
from typing import Optional, Set
from typing_extensions import Self

class IMMailingOutInput(BaseModel):
    """
    IMMailingOutInput
    """ # noqa: E501
    id: StrictInt
    organization_id: StrictInt
    insurance_id: StrictInt
    im_insurer_id: StrictInt
    im_sro_id: Optional[StrictInt]
    dispatch_at: Optional[datetime]
    email_search_status: EmailSearchStatus
    invoice_status: InvoiceStatus
    status: Optional[MailingStatus]
    result: Optional[MailingResult]
    message_status: Optional[MessageStatus]
    insured_sum: Optional[InsuredSum]
    insurance_premium: Optional[InsurancePremium]
    has_invoice: Optional[StrictBool] = False
    invoice: Optional[IMMailingInvoiceSummary] = None
    organization: Optional[OrganizationPublic] = None
    insurance: Optional[InsuranceOut] = None
    insurer: Optional[IMInsurerOut] = None
    sro: Optional[SROShort] = None
    __properties: ClassVar[List[str]] = ["id", "organization_id", "insurance_id", "im_insurer_id", "im_sro_id", "dispatch_at", "email_search_status", "invoice_status", "status", "result", "message_status", "insured_sum", "insurance_premium", "has_invoice", "invoice", "organization", "insurance", "insurer", "sro"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IMMailingOutInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of insured_sum
        if self.insured_sum:
            _dict['insured_sum'] = self.insured_sum.to_dict()
        # override the default output from pydantic by calling `to_dict()` of insurance_premium
        if self.insurance_premium:
            _dict['insurance_premium'] = self.insurance_premium.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invoice
        if self.invoice:
            _dict['invoice'] = self.invoice.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of insurance
        if self.insurance:
            _dict['insurance'] = self.insurance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of insurer
        if self.insurer:
            _dict['insurer'] = self.insurer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sro
        if self.sro:
            _dict['sro'] = self.sro.to_dict()
        # set to None if im_sro_id (nullable) is None
        # and model_fields_set contains the field
        if self.im_sro_id is None and "im_sro_id" in self.model_fields_set:
            _dict['im_sro_id'] = None

        # set to None if dispatch_at (nullable) is None
        # and model_fields_set contains the field
        if self.dispatch_at is None and "dispatch_at" in self.model_fields_set:
            _dict['dispatch_at'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if result (nullable) is None
        # and model_fields_set contains the field
        if self.result is None and "result" in self.model_fields_set:
            _dict['result'] = None

        # set to None if message_status (nullable) is None
        # and model_fields_set contains the field
        if self.message_status is None and "message_status" in self.model_fields_set:
            _dict['message_status'] = None

        # set to None if insured_sum (nullable) is None
        # and model_fields_set contains the field
        if self.insured_sum is None and "insured_sum" in self.model_fields_set:
            _dict['insured_sum'] = None

        # set to None if insurance_premium (nullable) is None
        # and model_fields_set contains the field
        if self.insurance_premium is None and "insurance_premium" in self.model_fields_set:
            _dict['insurance_premium'] = None

        # set to None if invoice (nullable) is None
        # and model_fields_set contains the field
        if self.invoice is None and "invoice" in self.model_fields_set:
            _dict['invoice'] = None

        # set to None if organization (nullable) is None
        # and model_fields_set contains the field
        if self.organization is None and "organization" in self.model_fields_set:
            _dict['organization'] = None

        # set to None if insurance (nullable) is None
        # and model_fields_set contains the field
        if self.insurance is None and "insurance" in self.model_fields_set:
            _dict['insurance'] = None

        # set to None if insurer (nullable) is None
        # and model_fields_set contains the field
        if self.insurer is None and "insurer" in self.model_fields_set:
            _dict['insurer'] = None

        # set to None if sro (nullable) is None
        # and model_fields_set contains the field
        if self.sro is None and "sro" in self.model_fields_set:
            _dict['sro'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IMMailingOutInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organization_id": obj.get("organization_id"),
            "insurance_id": obj.get("insurance_id"),
            "im_insurer_id": obj.get("im_insurer_id"),
            "im_sro_id": obj.get("im_sro_id"),
            "dispatch_at": obj.get("dispatch_at"),
            "email_search_status": obj.get("email_search_status"),
            "invoice_status": obj.get("invoice_status"),
            "status": obj.get("status"),
            "result": obj.get("result"),
            "message_status": obj.get("message_status"),
            "insured_sum": InsuredSum.from_dict(obj["insured_sum"]) if obj.get("insured_sum") is not None else None,
            "insurance_premium": InsurancePremium.from_dict(obj["insurance_premium"]) if obj.get("insurance_premium") is not None else None,
            "has_invoice": obj.get("has_invoice") if obj.get("has_invoice") is not None else False,
            "invoice": IMMailingInvoiceSummary.from_dict(obj["invoice"]) if obj.get("invoice") is not None else None,
            "organization": OrganizationPublic.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "insurance": InsuranceOut.from_dict(obj["insurance"]) if obj.get("insurance") is not None else None,
            "insurer": IMInsurerOut.from_dict(obj["insurer"]) if obj.get("insurer") is not None else None,
            "sro": SROShort.from_dict(obj["sro"]) if obj.get("sro") is not None else None
        })
        return _obj


