# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTablesResult',
    'AwaitableGetTablesResult',
    'get_tables',
    'get_tables_output',
]

@pulumi.output_type
class GetTablesResult:
    """
    A collection of values returned by getTables.
    """
    def __init__(__self__, database=None, id=None, like_all_patterns=None, like_any_patterns=None, not_like_all_patterns=None, regex_pattern=None, schemas=None, table_types=None, tables=None):
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if like_all_patterns and not isinstance(like_all_patterns, list):
            raise TypeError("Expected argument 'like_all_patterns' to be a list")
        pulumi.set(__self__, "like_all_patterns", like_all_patterns)
        if like_any_patterns and not isinstance(like_any_patterns, list):
            raise TypeError("Expected argument 'like_any_patterns' to be a list")
        pulumi.set(__self__, "like_any_patterns", like_any_patterns)
        if not_like_all_patterns and not isinstance(not_like_all_patterns, list):
            raise TypeError("Expected argument 'not_like_all_patterns' to be a list")
        pulumi.set(__self__, "not_like_all_patterns", not_like_all_patterns)
        if regex_pattern and not isinstance(regex_pattern, str):
            raise TypeError("Expected argument 'regex_pattern' to be a str")
        pulumi.set(__self__, "regex_pattern", regex_pattern)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)
        if table_types and not isinstance(table_types, list):
            raise TypeError("Expected argument 'table_types' to be a list")
        pulumi.set(__self__, "table_types", table_types)
        if tables and not isinstance(tables, list):
            raise TypeError("Expected argument 'tables' to be a list")
        pulumi.set(__self__, "tables", tables)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="likeAllPatterns")
    def like_all_patterns(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "like_all_patterns")

    @_builtins.property
    @pulumi.getter(name="likeAnyPatterns")
    def like_any_patterns(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "like_any_patterns")

    @_builtins.property
    @pulumi.getter(name="notLikeAllPatterns")
    def not_like_all_patterns(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "not_like_all_patterns")

    @_builtins.property
    @pulumi.getter(name="regexPattern")
    def regex_pattern(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "regex_pattern")

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "schemas")

    @_builtins.property
    @pulumi.getter(name="tableTypes")
    def table_types(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "table_types")

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Sequence['outputs.GetTablesTableResult']:
        """
        A list of PostgreSQL tables retrieved by this data source. Each table consists of the fields documented below.
        ___
        """
        return pulumi.get(self, "tables")


class AwaitableGetTablesResult(GetTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTablesResult(
            database=self.database,
            id=self.id,
            like_all_patterns=self.like_all_patterns,
            like_any_patterns=self.like_any_patterns,
            not_like_all_patterns=self.not_like_all_patterns,
            regex_pattern=self.regex_pattern,
            schemas=self.schemas,
            table_types=self.table_types,
            tables=self.tables)


def get_tables(database: Optional[_builtins.str] = None,
               like_all_patterns: Optional[Sequence[_builtins.str]] = None,
               like_any_patterns: Optional[Sequence[_builtins.str]] = None,
               not_like_all_patterns: Optional[Sequence[_builtins.str]] = None,
               regex_pattern: Optional[_builtins.str] = None,
               schemas: Optional[Sequence[_builtins.str]] = None,
               table_types: Optional[Sequence[_builtins.str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTablesResult:
    """
    The ``get_tables`` data source retrieves a list of table names from a specified PostgreSQL database.

    ## Usage

    ```python
    import pulumi
    import pulumi_postgresql as postgresql

    my_tables = postgresql.get_tables(database="my_database")
    ```


    :param _builtins.str database: The PostgreSQL database which will be queried for table names.
    :param Sequence[_builtins.str] like_all_patterns: List of expressions which will be pattern matched against table names in the query using the PostgreSQL ``LIKE ALL`` operators.
    :param Sequence[_builtins.str] like_any_patterns: List of expressions which will be pattern matched against table names in the query using the PostgreSQL ``LIKE ANY`` operators.
    :param Sequence[_builtins.str] not_like_all_patterns: List of expressions which will be pattern matched against table names in the query using the PostgreSQL ``NOT LIKE ALL`` operators.
    :param _builtins.str regex_pattern: Expression which will be pattern matched against table names in the query using the PostgreSQL ``~`` (regular expression match) operator.
           
           Note that all optional arguments can be used in conjunction.
    :param Sequence[_builtins.str] schemas: List of PostgreSQL schema(s) which will be queried for table names. Queries all schemas in the database by default.
    :param Sequence[_builtins.str] table_types: List of PostgreSQL table types which will be queried for table names. Includes all table types by default (including views and temp tables). Use 'BASE TABLE' for normal tables only.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['likeAllPatterns'] = like_all_patterns
    __args__['likeAnyPatterns'] = like_any_patterns
    __args__['notLikeAllPatterns'] = not_like_all_patterns
    __args__['regexPattern'] = regex_pattern
    __args__['schemas'] = schemas
    __args__['tableTypes'] = table_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('postgresql:index/getTables:getTables', __args__, opts=opts, typ=GetTablesResult).value

    return AwaitableGetTablesResult(
        database=pulumi.get(__ret__, 'database'),
        id=pulumi.get(__ret__, 'id'),
        like_all_patterns=pulumi.get(__ret__, 'like_all_patterns'),
        like_any_patterns=pulumi.get(__ret__, 'like_any_patterns'),
        not_like_all_patterns=pulumi.get(__ret__, 'not_like_all_patterns'),
        regex_pattern=pulumi.get(__ret__, 'regex_pattern'),
        schemas=pulumi.get(__ret__, 'schemas'),
        table_types=pulumi.get(__ret__, 'table_types'),
        tables=pulumi.get(__ret__, 'tables'))
def get_tables_output(database: Optional[pulumi.Input[_builtins.str]] = None,
                      like_all_patterns: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      like_any_patterns: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      not_like_all_patterns: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      regex_pattern: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      schemas: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      table_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTablesResult]:
    """
    The ``get_tables`` data source retrieves a list of table names from a specified PostgreSQL database.

    ## Usage

    ```python
    import pulumi
    import pulumi_postgresql as postgresql

    my_tables = postgresql.get_tables(database="my_database")
    ```


    :param _builtins.str database: The PostgreSQL database which will be queried for table names.
    :param Sequence[_builtins.str] like_all_patterns: List of expressions which will be pattern matched against table names in the query using the PostgreSQL ``LIKE ALL`` operators.
    :param Sequence[_builtins.str] like_any_patterns: List of expressions which will be pattern matched against table names in the query using the PostgreSQL ``LIKE ANY`` operators.
    :param Sequence[_builtins.str] not_like_all_patterns: List of expressions which will be pattern matched against table names in the query using the PostgreSQL ``NOT LIKE ALL`` operators.
    :param _builtins.str regex_pattern: Expression which will be pattern matched against table names in the query using the PostgreSQL ``~`` (regular expression match) operator.
           
           Note that all optional arguments can be used in conjunction.
    :param Sequence[_builtins.str] schemas: List of PostgreSQL schema(s) which will be queried for table names. Queries all schemas in the database by default.
    :param Sequence[_builtins.str] table_types: List of PostgreSQL table types which will be queried for table names. Includes all table types by default (including views and temp tables). Use 'BASE TABLE' for normal tables only.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['likeAllPatterns'] = like_all_patterns
    __args__['likeAnyPatterns'] = like_any_patterns
    __args__['notLikeAllPatterns'] = not_like_all_patterns
    __args__['regexPattern'] = regex_pattern
    __args__['schemas'] = schemas
    __args__['tableTypes'] = table_types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('postgresql:index/getTables:getTables', __args__, opts=opts, typ=GetTablesResult)
    return __ret__.apply(lambda __response__: GetTablesResult(
        database=pulumi.get(__response__, 'database'),
        id=pulumi.get(__response__, 'id'),
        like_all_patterns=pulumi.get(__response__, 'like_all_patterns'),
        like_any_patterns=pulumi.get(__response__, 'like_any_patterns'),
        not_like_all_patterns=pulumi.get(__response__, 'not_like_all_patterns'),
        regex_pattern=pulumi.get(__response__, 'regex_pattern'),
        schemas=pulumi.get(__response__, 'schemas'),
        table_types=pulumi.get(__response__, 'table_types'),
        tables=pulumi.get(__response__, 'tables')))
