# -*- coding: utf-8 -*-

import oss_tool
import os
from conf  import conf
import json

# instance_id: should be start from 0 to 9
instance_count = 3

data_path = conf['data_path']

count_results = 'count_results'

filename = 'count_results/%s.json'

def main():

    if not os.path.exists(count_results):
      os.mkdir(count_results)


    pre = data_path[0: data_path.rfind('/')]

    print('download form: %s/%s/' % (pre,count_results) )

    # 1. download a part
    for i in range(0,instance_count):
        oss_tool.download_file('%s/%s/%s.json' % (pre, count_results, i), filename % i)


    # 2. parse, calculate
    m = {
        'INFO': 0,
        'WARN': 0,
        'ERROR': 0,
        'DEBUG': 0
    }
    for i in range(0,instance_count):
        with open(filename % i) as f:
            obj = json.loads(f.read())

        for (k,v) in obj.items():
            m[k] += v

    print('merge:')
    print(m)

    # 3. upload result to oss
    upload_to = '%s/merge_result.json' % pre
    print('upload to %s' % upload_to)
    oss_tool.put_data(json.dumps(m), upload_to)


if __name__ == '__main__':
    main()