window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"fastpy_rs": {"fullname": "fastpy_rs", "modulename": "fastpy_rs", "kind": "module", "doc": "<p>FastPy-RS: High-performance Python extensions written in Rust</p>\n\n<p>This crate provides optimized Python extensions for various tasks including:</p>\n\n<ul>\n<li>AI/ML utilities</li>\n<li>Data processing tools</li>\n<li>Cryptographic functions</li>\n<li>Text processing utilities</li>\n<li>JSON parsing</li>\n<li>HTTP client functionality</li>\n</ul>\n\n<h1 id=\"examples\">Examples</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">fastpy_rs</span><span class=\"w\"> </span><span class=\"k\">as</span><span class=\"w\"> </span><span class=\"nn\">fr</span>\n\n<span class=\"c1\"># Using crypto functions</span>\n<span class=\"n\">hash_result</span> <span class=\"o\">=</span> <span class=\"n\">fr</span><span class=\"o\">.</span><span class=\"n\">crypto</span><span class=\"o\">.</span><span class=\"n\">sha256_str</span><span class=\"p\">(</span><span class=\"s2\">&quot;hello&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># Using data tools</span>\n<span class=\"n\">encoded</span> <span class=\"o\">=</span> <span class=\"n\">fr</span><span class=\"o\">.</span><span class=\"n\">datatools</span><span class=\"o\">.</span><span class=\"n\">base64_encode</span><span class=\"p\">(</span><span class=\"sa\">b</span><span class=\"s2\">&quot;hello&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># Count word frequencies in a text</span>\n<span class=\"n\">text</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;Hello hello world! This is a test. Test passed!&quot;</span>\n<span class=\"n\">frequencies</span> <span class=\"o\">=</span> <span class=\"n\">fr</span><span class=\"o\">.</span><span class=\"n\">ai</span><span class=\"o\">.</span><span class=\"n\">token_frequency</span><span class=\"p\">(</span><span class=\"n\">text</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">frequencies</span><span class=\"p\">)</span>\n<span class=\"c1\"># Output: {&#39;hello&#39;: 2, &#39;world&#39;: 1, &#39;this&#39;: 1, &#39;is&#39;: 1, &#39;a&#39;: 1, &#39;test&#39;: 2, &#39;passed&#39;: 1}</span>\n\n<span class=\"c1\"># JSON parsing</span>\n<span class=\"n\">json_data</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;{&quot;name&quot;: &quot;John&quot;, &quot;age&quot;: 30, &quot;active&quot;: true}&#39;</span>\n<span class=\"n\">parsed_json</span> <span class=\"o\">=</span> <span class=\"n\">fr</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"o\">.</span><span class=\"n\">parse_json</span><span class=\"p\">(</span><span class=\"n\">json_data</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">parsed_json</span><span class=\"p\">)</span>\n<span class=\"c1\"># Output: {&#39;name&#39;: &#39;John&#39;, &#39;age&#39;: 30, &#39;active&#39;: True}</span>\n\n<span class=\"c1\"># Serialization JSON</span>\n\n<span class=\"c1\"># Serialize a simple dictionary</span>\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s2\">&quot;name&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;age&quot;</span><span class=\"p\">:</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;active&quot;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">}</span>\n<span class=\"n\">json_str</span> <span class=\"o\">=</span> <span class=\"n\">fr</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"o\">.</span><span class=\"n\">serialize_json</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">json_str</span><span class=\"p\">)</span>  <span class=\"c1\"># Output: {&quot;name&quot;:&quot;John&quot;,&quot;age&quot;:30,&quot;active&quot;:true}</span>\n</code></pre>\n</div>\n"}, "fastpy_rs.ai": {"fullname": "fastpy_rs.ai", "modulename": "fastpy_rs.ai", "kind": "module", "doc": "<p></p>\n"}, "fastpy_rs.ai.token_frequency": {"fullname": "fastpy_rs.ai.token_frequency", "modulename": "fastpy_rs.ai", "qualname": "token_frequency", "kind": "function", "doc": "<p>Counts the frequency of each word in the input text.</p>\n\n<p>This function splits the input text into words (sequences of alphanumeric characters)\nand returns a dictionary where keys are words (converted to lowercase) and values\nare their respective counts in the text.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>text</code> - The input text to analyze</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li><code>PyResult&lt;HashMap&lt;String, u32&gt;&gt;</code> - A dictionary mapping words to their counts</li>\n</ul>\n\n<h1 id=\"examples\">Examples</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">fastpy_rs</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">ai</span>\n\n<span class=\"n\">text</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;Hello hello world! This is a test. Test passed!&quot;</span>\n<span class=\"n\">result</span> <span class=\"o\">=</span> <span class=\"n\">ai</span><span class=\"o\">.</span><span class=\"n\">token_frequency</span><span class=\"p\">(</span><span class=\"n\">text</span><span class=\"p\">)</span>\n<span class=\"c1\"># Returns: {&#39;hello&#39;: 2, &#39;world&#39;: 1, &#39;this&#39;: 1, &#39;is&#39;: 1, &#39;a&#39;: 1, &#39;test&#39;: 2, &#39;passed&#39;: 1}</span>\n</code></pre>\n</div>\n\n<h1 id=\"performance\">Performance</h1>\n\n<p>This function is implemented in Rust for high performance, making it significantly\nfaster than equivalent Python implementations, especially for large texts.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.datatools": {"fullname": "fastpy_rs.datatools", "modulename": "fastpy_rs.datatools", "kind": "module", "doc": "<p></p>\n"}, "fastpy_rs.datatools.base64_encode": {"fullname": "fastpy_rs.datatools.base64_encode", "modulename": "fastpy_rs.datatools", "qualname": "base64_encode", "kind": "function", "doc": "<p>Encodes a byte slice into a base64 encoded string.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>data</code> - The byte slice to encode</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<p>A <code>String</code> containing the base64 encoded data</p>\n\n<h1 id=\"examples\">Examples</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">fastpy_rs.datatools</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">base64_encode</span>\n\n<span class=\"n\">encoded</span> <span class=\"o\">=</span> <span class=\"n\">base64_encode</span><span class=\"p\">(</span><span class=\"sa\">b</span><span class=\"s2\">&quot;hello&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">assert</span> <span class=\"n\">encoded</span> <span class=\"o\">==</span> <span class=\"s1\">&#39;aGVsbG8=&#39;</span>\n</code></pre>\n</div>\n\n<h1 id=\"panics\">Panics</h1>\n\n<p>This function will panic if the input data cannot be encoded as base64, though this is\nextremely unlikely as base64 can encode any binary data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.crypto": {"fullname": "fastpy_rs.crypto", "modulename": "fastpy_rs.crypto", "kind": "module", "doc": "<p></p>\n"}, "fastpy_rs.crypto.sha256": {"fullname": "fastpy_rs.crypto.sha256", "modulename": "fastpy_rs.crypto", "qualname": "sha256", "kind": "function", "doc": "<p>Calculate SHA-256 hash of the input bytes.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>data</code> - Input bytes to be hashed</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li>Hex-encoded SHA-256 hash string</li>\n</ul>\n\n<h1 id=\"example\">Example</h1>\n\n<pre><code>use fastpy_rs::crypto::sha256;\n\nlet result = sha256(&amp;[104, 101, 108, 108, 111]); // \"hello\" in bytes\nassert_eq!(result, \"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\");\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.crypto.sha256_str": {"fullname": "fastpy_rs.crypto.sha256_str", "modulename": "fastpy_rs.crypto", "qualname": "sha256_str", "kind": "function", "doc": "<p>Calculate SHA-256 hash of the input string.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>data</code> - Input string to be hashed</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li>Hex-encoded SHA-256 hash string</li>\n</ul>\n\n<h1 id=\"example\">Example</h1>\n\n<pre><code>assert_eq!(sha256_str(\"hello\"), \"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\");\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.textutils": {"fullname": "fastpy_rs.textutils", "modulename": "fastpy_rs.textutils", "kind": "module", "doc": "<p></p>\n"}, "fastpy_rs.textutils.regex_search": {"fullname": "fastpy_rs.textutils.regex_search", "modulename": "fastpy_rs.textutils", "qualname": "regex_search", "kind": "function", "doc": "<p>Finds all unique matches of a regex pattern in the given text.</p>\n\n<p>This function uses a cached regex engine to improve performance\nby storing compiled regex patterns. If the cache exceeds 20 entries,\nit will be cleared to free up memory.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>pattern</code> - A string slice that holds the regex pattern to search for.</li>\n<li><code>text</code> - A string slice that holds the text in which to search for the pattern.</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li>A <code>PyResult</code> containing a vector of unique matches as strings. If the pattern is invalid,\nreturns a <code>PyValueError</code> with an appropriate error message.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">pattern</span>, </span><span class=\"param\"><span class=\"n\">text</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.json": {"fullname": "fastpy_rs.json", "modulename": "fastpy_rs.json", "kind": "module", "doc": "<p></p>\n"}, "fastpy_rs.json.parse_json": {"fullname": "fastpy_rs.json.parse_json", "modulename": "fastpy_rs.json", "qualname": "parse_json", "kind": "function", "doc": "<p>Parses a JSON string into a Python dictionary.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>json_str</code> - A string containing valid JSON data</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li>A Python dictionary representing the parsed JSON data</li>\n</ul>\n\n<h1 id=\"raises\">Raises</h1>\n\n<ul>\n<li><code>ValueError</code> - If the input string is not valid JSON or if the JSON is not an object at the top level</li>\n</ul>\n\n<h1 id=\"examples\">Examples</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">fastpy_rs</span>\n\n<span class=\"c1\"># Parse a simple JSON object</span>\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"n\">fastpy_rs</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"o\">.</span><span class=\"n\">parse_json</span><span class=\"p\">(</span><span class=\"s1\">&#39;{&quot;name&quot;: &quot;John&quot;, &quot;age&quot;: 30, &quot;active&quot;: true}&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">[</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">])</span>  <span class=\"c1\"># Output: John</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">[</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">])</span>   <span class=\"c1\"># Output: 30</span>\n\n<span class=\"c1\"># Parse JSON with nested structures</span>\n<span class=\"n\">nested</span> <span class=\"o\">=</span> <span class=\"n\">fastpy_rs</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"o\">.</span><span class=\"n\">parse_json</span><span class=\"p\">(</span><span class=\"s1\">&#39;{&quot;users&quot;: [{&quot;id&quot;: 1, &quot;name&quot;: &quot;Alice&quot;}, {&quot;id&quot;: 2, &quot;name&quot;: &quot;Bob&quot;}]}&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">nested</span><span class=\"p\">[</span><span class=\"s1\">&#39;users&#39;</span><span class=\"p\">][</span><span class=\"mi\">0</span><span class=\"p\">][</span><span class=\"s1\">&#39;name&#39;</span><span class=\"p\">])</span>  <span class=\"c1\"># Output: Alice</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">json_str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.json.serialize_json": {"fullname": "fastpy_rs.json.serialize_json", "modulename": "fastpy_rs.json", "qualname": "serialize_json", "kind": "function", "doc": "<p>Serializes a Python object to a JSON string.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>obj</code> - A Python object to serialize (dict, list, str, int, float, bool, None)</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li>A JSON string representation of the input object</li>\n</ul>\n\n<h1 id=\"raises\">Raises</h1>\n\n<ul>\n<li><code>ValueError</code> - If the object contains types that cannot be serialized to JSON</li>\n</ul>\n\n<h1 id=\"examples\">Examples</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">fastpy_rs</span>\n\n<span class=\"c1\"># Serialize a simple dictionary</span>\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s2\">&quot;name&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;age&quot;</span><span class=\"p\">:</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"s2\">&quot;active&quot;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">}</span>\n<span class=\"n\">json_str</span> <span class=\"o\">=</span> <span class=\"n\">fastpy_rs</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"o\">.</span><span class=\"n\">serialize_json</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">json_str</span><span class=\"p\">)</span>  <span class=\"c1\"># Output: {&quot;name&quot;:&quot;John&quot;,&quot;age&quot;:30,&quot;active&quot;:true}</span>\n\n<span class=\"c1\"># Pretty-print the JSON</span>\n<span class=\"n\">pretty_json</span> <span class=\"o\">=</span> <span class=\"n\">fastpy_rs</span><span class=\"o\">.</span><span class=\"n\">json</span><span class=\"o\">.</span><span class=\"n\">serialize_json</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">pretty_json</span><span class=\"p\">)</span>\n<span class=\"c1\"># Output:</span>\n<span class=\"c1\"># {</span>\n<span class=\"c1\">#   &quot;name&quot;: &quot;John&quot;,</span>\n<span class=\"c1\">#   &quot;age&quot;: 30,</span>\n<span class=\"c1\">#   &quot;active&quot;: true</span>\n<span class=\"c1\"># }</span>\n</code></pre>\n</div>\n\n<p>Serializes a Python object (dict, list, str, int, float, bool, None)\nto a JSON string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "fastpy_rs.http": {"fullname": "fastpy_rs.http", "modulename": "fastpy_rs.http", "kind": "module", "doc": "<p></p>\n"}, "fastpy_rs.http.get": {"fullname": "fastpy_rs.http.get", "modulename": "fastpy_rs.http", "qualname": "get", "kind": "function", "doc": "<p>Makes an HTTP GET request to the specified URL and returns the response body as a string.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<ul>\n<li><code>url</code> - The URL to make the GET request to</li>\n</ul>\n\n<h1 id=\"returns\">Returns</h1>\n\n<ul>\n<li>A string containing the response body</li>\n</ul>\n\n<h1 id=\"raises\">Raises</h1>\n\n<ul>\n<li><code>ValueError</code> - If the request fails or the response status is not successful</li>\n</ul>\n\n<h1 id=\"examples\">Examples</h1>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">fastpy_rs</span>\n\n<span class=\"c1\"># Make a simple GET request</span>\n<span class=\"n\">response</span> <span class=\"o\">=</span> <span class=\"n\">fastpy_rs</span><span class=\"o\">.</span><span class=\"n\">http</span><span class=\"o\">.</span><span class=\"n\">get</span><span class=\"p\">(</span><span class=\"s2\">&quot;https://httpbin.org/get&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">response</span><span class=\"p\">)</span>  <span class=\"c1\"># Output: JSON response from the server</span>\n\n<span class=\"c1\"># Handle errors</span>\n<span class=\"k\">try</span><span class=\"p\">:</span>\n    <span class=\"n\">fastpy_rs</span><span class=\"o\">.</span><span class=\"n\">http</span><span class=\"o\">.</span><span class=\"n\">get</span><span class=\"p\">(</span><span class=\"s2\">&quot;https://nonexistent.url&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">except</span> <span class=\"ne\">ValueError</span> <span class=\"k\">as</span> <span class=\"n\">e</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Request failed: </span><span class=\"si\">{</span><span class=\"n\">e</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">url</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"fastpy_rs": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 512}, "fastpy_rs.ai": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fastpy_rs.ai.token_frequency": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 236}, "fastpy_rs.datatools": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fastpy_rs.datatools.base64_encode": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 149}, "fastpy_rs.crypto": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fastpy_rs.crypto.sha256": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 71}, "fastpy_rs.crypto.sha256_str": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 57}, "fastpy_rs.textutils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fastpy_rs.textutils.regex_search": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 128}, "fastpy_rs.json": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fastpy_rs.json.parse_json": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 319}, "fastpy_rs.json.serialize_json": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 345}, "fastpy_rs.http": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "fastpy_rs.http.get": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 241}}, "length": 15, "save": true}, "index": {"qualname": {"root": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"6": {"4": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"2": {"5": {"6": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "fullname": {"root": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 15}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 15}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {"fastpy_rs.ai": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.textutils": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 2}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.datatools": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 2}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"6": {"4": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"fastpy_rs.crypto": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"2": {"5": {"6": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.json": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 3}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"fastpy_rs.http": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 3.1622776601683795}, "fastpy_rs.datatools.base64_encode": {"tf": 3.1622776601683795}, "fastpy_rs.crypto.sha256": {"tf": 3.1622776601683795}, "fastpy_rs.crypto.sha256_str": {"tf": 3.1622776601683795}, "fastpy_rs.textutils.regex_search": {"tf": 3.7416573867739413}, "fastpy_rs.json.parse_json": {"tf": 3.1622776601683795}, "fastpy_rs.json.serialize_json": {"tf": 3.1622776601683795}, "fastpy_rs.http.get": {"tf": 3.1622776601683795}}, "df": 8, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 3}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "bases": {"root": {"docs": {}, "df": 0}}, "doc": {"root": {"0": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}, "1": {"0": {"1": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1}, "4": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1}, "8": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "1": {"1": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"fastpy_rs": {"tf": 2.23606797749979}, "fastpy_rs.ai.token_frequency": {"tf": 2.23606797749979}, "fastpy_rs.json.parse_json": {"tf": 1}}, "df": 3}, "2": {"0": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}, "5": {"6": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1.4142135623730951}, "fastpy_rs.crypto.sha256_str": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "f": {"2": {"4": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"5": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "b": {"0": {"docs": {}, "df": 0, "a": {"3": {"0": {"docs": {}, "df": 0, "e": {"2": {"6": {"docs": {}, "df": 0, "e": {"8": {"3": {"docs": {}, "df": 0, "b": {"2": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"5": {"docs": {}, "df": 0, "b": {"9": {"docs": {}, "df": 0, "e": {"2": {"9": {"docs": {}, "df": 0, "e": {"1": {"docs": {}, "df": 0, "b": {"1": {"6": {"1": {"docs": {}, "df": 0, "e": {"5": {"docs": {}, "df": 0, "c": {"1": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"7": {"4": {"2": {"5": {"docs": {}, "df": 0, "e": {"7": {"3": {"0": {"4": {"3": {"3": {"6": {"2": {"9": {"3": {"8": {"docs": {}, "df": 0, "b": {"9": {"8": {"2": {"4": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "3": {"0": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 3}, "9": {"docs": {"fastpy_rs": {"tf": 4.898979485566356}, "fastpy_rs.ai.token_frequency": {"tf": 3.7416573867739413}, "fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 3.4641016151377544}}, "df": 4}, "docs": {}, "df": 0}, "docs": {"fastpy_rs": {"tf": 17.349351572897472}, "fastpy_rs.ai": {"tf": 1.7320508075688772}, "fastpy_rs.ai.token_frequency": {"tf": 9.848857801796104}, "fastpy_rs.datatools": {"tf": 1.7320508075688772}, "fastpy_rs.datatools.base64_encode": {"tf": 8.888194417315589}, "fastpy_rs.crypto": {"tf": 1.7320508075688772}, "fastpy_rs.crypto.sha256": {"tf": 5.385164807134504}, "fastpy_rs.crypto.sha256_str": {"tf": 5.291502622129181}, "fastpy_rs.textutils": {"tf": 1.7320508075688772}, "fastpy_rs.textutils.regex_search": {"tf": 5.916079783099616}, "fastpy_rs.json": {"tf": 1.7320508075688772}, "fastpy_rs.json.parse_json": {"tf": 13.379088160259652}, "fastpy_rs.json.serialize_json": {"tf": 14.317821063276353}, "fastpy_rs.http": {"tf": 1.7320508075688772}, "fastpy_rs.http.get": {"tf": 12.083045973594572}}, "df": 15, "f": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1.7320508075688772}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}, "fastpy_rs.http.get": {"tf": 1.7320508075688772}}, "df": 7}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 3}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 3, "s": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "r": {"docs": {"fastpy_rs": {"tf": 2.449489742783178}}, "df": 1, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1.7320508075688772}}, "df": 1}}}, "y": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1.7320508075688772}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}, "fastpy_rs.http.get": {"tf": 1.7320508075688772}}, "df": 6, ":": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"2": {"5": {"6": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1.4142135623730951}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.http.get": {"tf": 2.449489742783178}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 8}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 2}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 2.23606797749979}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 3}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1.4142135623730951}, "fastpy_rs.crypto.sha256_str": {"tf": 1.4142135623730951}}, "df": 3, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {"fastpy_rs": {"tf": 2.23606797749979}, "fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 5}}}, "x": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 3}}}}}}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1.7320508075688772}, "fastpy_rs.json.parse_json": {"tf": 1.7320508075688772}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}, "fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 2}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 2}}, "df": 2, "d": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1}}, "df": 2}, "s": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1, "s": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 2.23606797749979}}, "df": 1, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {"fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 1, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2, "s": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 6}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 2}}, "df": 2, "d": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 2.23606797749979}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 4}, "s": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}, "q": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1, "s": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 2, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}}, "df": 1}}, "l": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 4, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1.4142135623730951}, "fastpy_rs.crypto.sha256_str": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 6}}}, "t": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1, "o": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}}, "df": 3}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 6}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.http.get": {"tf": 1}}, "df": 6}, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 2}, "f": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 5}, "d": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}}, "df": 1}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1.7320508075688772}, "fastpy_rs.ai.token_frequency": {"tf": 2}, "fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}, "fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 4}}, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 2.23606797749979}, "fastpy_rs.datatools.base64_encode": {"tf": 1.7320508075688772}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 2.449489742783178}, "fastpy_rs.json.parse_json": {"tf": 2}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}, "fastpy_rs.http.get": {"tf": 2.8284271247461903}}, "df": 8, "i": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}, "t": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 2}, "fastpy_rs.json.serialize_json": {"tf": 2}, "fastpy_rs.http.get": {"tf": 1.7320508075688772}}, "df": 7, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 2}}}, "p": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.ai.token_frequency": {"tf": 2.6457513110645907}, "fastpy_rs.textutils.regex_search": {"tf": 1.7320508075688772}}, "df": 3, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1.7320508075688772}, "fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 2}}, "df": 3}}, "y": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.7320508075688772}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 4}}}, "s": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1, "d": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 1.7320508075688772}, "fastpy_rs.json.parse_json": {"tf": 1.7320508075688772}, "fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}, "fastpy_rs.http.get": {"tf": 1}}, "df": 4}}}}}, "f": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 5}, "r": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 2, "g": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 2.23606797749979}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.ai.token_frequency": {"tf": 2}, "fastpy_rs.datatools.base64_encode": {"tf": 1.7320508075688772}, "fastpy_rs.textutils.regex_search": {"tf": 2.6457513110645907}, "fastpy_rs.json.parse_json": {"tf": 2.23606797749979}, "fastpy_rs.json.serialize_json": {"tf": 2.6457513110645907}, "fastpy_rs.http.get": {"tf": 1.7320508075688772}}, "df": 7, "i": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 2, "/": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 3}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 3}, "v": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "g": {"8": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}}, "l": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}}, "df": 1}}}}, "n": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 3, "d": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.http.get": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 1}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 8}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}, "u": {"3": {"2": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs.http.get": {"tf": 2}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"fastpy_rs": {"tf": 2.449489742783178}, "fastpy_rs.datatools.base64_encode": {"tf": 2}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 2.23606797749979}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 6, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 2}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 4}}}}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 3.605551275463989}, "fastpy_rs.json.parse_json": {"tf": 3.4641016151377544}, "fastpy_rs.json.serialize_json": {"tf": 3.605551275463989}, "fastpy_rs.http.get": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 3}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"2": {"5": {"6": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"fastpy_rs.crypto.sha256": {"tf": 1.4142135623730951}, "fastpy_rs.crypto.sha256_str": {"tf": 1.4142135623730951}}, "df": 2}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs": {"tf": 1.7320508075688772}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 2}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1.7320508075688772}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 1.7320508075688772}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}, "fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 8, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"fastpy_rs": {"tf": 1.4142135623730951}, "fastpy_rs.json.serialize_json": {"tf": 2}}, "df": 2, "s": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1}, "d": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.json.parse_json": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}, "fastpy_rs.http.get": {"tf": 1}}, "df": 4}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}, "fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs": {"tf": 5.477225575051661}, "fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}, "fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}, "fastpy_rs.json.parse_json": {"tf": 4.69041575982343}, "fastpy_rs.json.serialize_json": {"tf": 4.898979485566356}, "fastpy_rs.http.get": {"tf": 2.449489742783178}}, "df": 6}}}}, "b": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"6": {"4": {"docs": {"fastpy_rs": {"tf": 1}, "fastpy_rs.datatools.base64_encode": {"tf": 2.449489742783178}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "y": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1.7320508075688772}}, "df": 1}}}}, "e": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}, "fastpy_rs.crypto.sha256": {"tf": 1}, "fastpy_rs.crypto.sha256_str": {"tf": 1}, "fastpy_rs.textutils.regex_search": {"tf": 1}, "fastpy_rs.json.serialize_json": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.datatools.base64_encode": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1}}, "d": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs": {"tf": 2}, "fastpy_rs.json.parse_json": {"tf": 2.23606797749979}, "fastpy_rs.json.serialize_json": {"tf": 1.7320508075688772}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.4142135623730951}, "fastpy_rs.http.get": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 1}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.crypto.sha256": {"tf": 1}}, "df": 1}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"fastpy_rs.json.parse_json": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.json.serialize_json": {"tf": 1.4142135623730951}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1.4142135623730951}}, "df": 1}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"fastpy_rs.http.get": {"tf": 2.23606797749979}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"fastpy_rs.ai.token_frequency": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"fastpy_rs.http.get": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"fastpy_rs.http.get": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"fastpy_rs.textutils.regex_search": {"tf": 1}}, "df": 1}}}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();