import time
from .utils import make_request
from .exceptions import CandleAIError, AuthenticationError, RateLimitError, ConnectionError, APIError


class CandleAIClient:
    """
    Клиент для работы с CandleAI API
    """

    def __init__(self, base_url, api_key):
        self.base_url = base_url.rstrip('/')
        self.api_key = api_key
        self.user_id = f"user_{int(time.time())}"
        self._headers = {
            "X-API-Key": self.api_key,
            "Content-Type": "application/json"
        }

    def chat(self, message, user_id=None):
        """
        Отправляет сообщение ИИ и получает ответ
        """
        data = {
            "message": message,
            "user_id": user_id or self.user_id
        }

        return make_request(
            method="POST",
            url=f"{self.base_url}/chat",
            headers=self._headers,
            json_data=data
        )

    def get_server_info(self):
        """
        Получает информацию о сервере
        """
        return make_request(
            method="GET",
            url=f"{self.base_url}/info",
            headers=self._headers
        )

    def health_check(self):
        """
        Проверяет статус сервера
        """
        return make_request(
            method="GET",
            url=f"{self.base_url}/health"
        )

    def get_facts(self):
        """
        Получает список доступных фактов
        """
        return make_request(
            method="GET",
            url=f"{self.base_url}/facts"
        )