class CandleAIError(Exception):
    """Базовое исключение для CandleAI"""
    pass

class AuthenticationError(CandleAIError):
    """Ошибка аутентификации (неверный API ключ)"""
    pass

class RateLimitError(CandleAIError):
    """Превышен лимит запросов"""
    pass

class ConnectionError(CandleAIError):
    """Ошибка подключения к серверу"""
    pass

class APIError(CandleAIError):
    """Ошибка API сервера"""
    pass