import requests
from .exceptions import AuthenticationError, RateLimitError, ConnectionError, APIError


def make_request(method, url, headers=None, json_data=None, timeout=30):
    """Универсальная функция для HTTP запросов"""
    try:
        response = requests.request(
            method=method,
            url=url,
            headers=headers,
            json=json_data,
            timeout=timeout
        )

        if response.status_code == 401:
            raise AuthenticationError("Неверный API ключ")
        elif response.status_code == 429:
            raise RateLimitError("Лимит скриптов исчерпан")
        elif response.status_code >= 400:
            raise APIError(f"Ошибка API: {response.status_code} - {response.text}")

        return response.json()

    except requests.exceptions.ConnectionError:
        raise ConnectionError("Не удалось подключиться к серверу")
    except requests.exceptions.Timeout:
        raise ConnectionError("Превышено время ожидания")
    except requests.exceptions.RequestException as e:
        raise ConnectionError(f"Ошибка сети: {e}")