"""Agent Client protocol (ACP) implementation."""

from acp.client import DefaultACPClient, ClientSideConnection
from acp.agent import AgentSideConnection
from acp.debug_server import cli
from acp.filesystem import ACPFileSystem, ACPPath
from acp.agent.protocol import (
    Agent,
    AgentExtensibilityCapability,
    BaseAgent,
    SessionModeCapability,
    SessionModelCapability,
    SessionPersistenceCapability,
)
from acp.client.protocol import (
    BaseClient,
    Client,
    ExtensibilityCapability,
    FsCapability,
    TerminalCapability,
)
from acp.terminal_handle import TerminalHandle
from acp.schema import (
    AuthenticateRequest,
    AuthenticateResponse,
    CancelNotification,
    CreateTerminalRequest,
    ClientCapabilities,
    SessionMode,
    FileSystemCapability,
    AgentMessageChunk,
    UserMessageChunk,
    TextContentBlock,
    SessionModeState,
    Implementation,
    EnvVariable,
    StdioMcpServer,
    SseMcpServer,
    HttpMcpServer,
    CreateTerminalResponse,
    InitializeRequest,
    InitializeResponse,
    KillTerminalCommandRequest,
    KillTerminalCommandResponse,
    LoadSessionRequest,
    LoadSessionResponse,
    ModelInfo,
    NewSessionRequest,
    NewSessionResponse,
    PromptRequest,
    PromptResponse,
    ReadTextFileRequest,
    ReadTextFileResponse,
    ReleaseTerminalRequest,
    ReleaseTerminalResponse,
    RequestPermissionRequest,
    RequestPermissionResponse,
    SessionModelState,
    SessionNotification,
    SetSessionModelRequest,
    SetSessionModelResponse,
    SetSessionModeRequest,
    SetSessionModeResponse,
    TerminalOutputRequest,
    TerminalOutputResponse,
    WaitForTerminalExitRequest,
    WaitForTerminalExitResponse,
    WriteTextFileRequest,
    WriteTextFileResponse,
    PROTOCOL_VERSION,
    AgentMethod,
    ClientMethod,
)
from acp.stdio import stdio_streams
from acp.exceptions import RequestError

__version__ = "0.0.1"

__all__ = [  # noqa: RUF022
    # constants
    "PROTOCOL_VERSION",
    # literal types
    "AgentMethod",
    "ClientMethod",
    # types
    "InitializeRequest",
    "InitializeResponse",
    "EnvVariable",
    "HttpMcpServer",
    "StdioMcpServer",
    "SseMcpServer",
    "NewSessionRequest",
    "AgentMessageChunk",
    "FsCapability",
    "UserMessageChunk",
    "TextContentBlock",
    "NewSessionResponse",
    "LoadSessionRequest",
    "LoadSessionResponse",
    "AuthenticateRequest",
    "AuthenticateResponse",
    "PromptRequest",
    "ClientCapabilities",
    "SessionModeState",
    "SessionMode",
    "Implementation",
    "PromptResponse",
    "WriteTextFileRequest",
    "WriteTextFileResponse",
    "ReadTextFileRequest",
    "ReadTextFileResponse",
    "RequestPermissionRequest",
    "RequestPermissionResponse",
    "CancelNotification",
    "SessionNotification",
    "SetSessionModeRequest",
    "SetSessionModeResponse",
    # model types
    "ModelInfo",
    "SessionModelState",
    "SetSessionModelRequest",
    "SetSessionModelResponse",
    # terminal types
    "CreateTerminalRequest",
    "CreateTerminalResponse",
    "TerminalOutputRequest",
    "TerminalOutputResponse",
    "WaitForTerminalExitRequest",
    "WaitForTerminalExitResponse",
    "KillTerminalCommandRequest",
    "KillTerminalCommandResponse",
    "ReleaseTerminalRequest",
    "ReleaseTerminalResponse",
    # core
    "AgentSideConnection",
    "ClientSideConnection",
    "RequestError",
    "Agent",
    "Client",
    "DefaultACPClient",
    "TerminalHandle",
    # split protocols
    "BaseAgent",
    "SessionPersistenceCapability",
    "SessionModeCapability",
    "SessionModelCapability",
    "AgentExtensibilityCapability",
    "BaseClient",
    "FileSystemCapability",
    "TerminalCapability",
    "ExtensibilityCapability",
    # stdio helper
    "stdio_streams",
    # filesystem
    "ACPFileSystem",
    "ACPPath",
    # cli
    "cli",
]
