# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr, field_validator
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from pingera.models.unified_result_list import UnifiedResultList

from pingera.api_client import ApiClient, RequestSerialized
from pingera.api_response import ApiResponse
from pingera.rest import RESTResponseType


class ChecksUnifiedResultsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v1_checks_all_results_get(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination (starting from 1).")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check result status.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page (maximum 100).")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date for filtering results (ISO format).")] = None,
        check_type: Annotated[Optional[StrictStr], Field(description="Filter by check type.")] = None,
        check_id: Annotated[Optional[StrictStr], Field(description="Filter by specific check ID.")] = None,
        result_type: Annotated[Optional[StrictStr], Field(description="Filter by result type.")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by region where check was executed.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for filtering results (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UnifiedResultList:
        """Get all check results (regular and on-demand)

        Get all check results (regular and on-demand) for the organization, sorted by creation date. Supports filtering by check ID, status, type, region, and date range. Date range is limited to 6 months in the past.

        :param page: Page number for pagination (starting from 1).
        :type page: int
        :param status: Filter by check result status.
        :type status: str
        :param page_size: Number of results per page (maximum 100).
        :type page_size: int
        :param end_date: End date for filtering results (ISO format).
        :type end_date: datetime
        :param check_type: Filter by check type.
        :type check_type: str
        :param check_id: Filter by specific check ID.
        :type check_id: str
        :param result_type: Filter by result type.
        :type result_type: str
        :param region: Filter by region where check was executed.
        :type region: str
        :param start_date: Start date for filtering results (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_all_results_get_serialize(
            page=page,
            status=status,
            page_size=page_size,
            end_date=end_date,
            check_type=check_type,
            check_id=check_id,
            result_type=result_type,
            region=region,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "UnifiedResultList",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_checks_all_results_get_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination (starting from 1).")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check result status.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page (maximum 100).")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date for filtering results (ISO format).")] = None,
        check_type: Annotated[Optional[StrictStr], Field(description="Filter by check type.")] = None,
        check_id: Annotated[Optional[StrictStr], Field(description="Filter by specific check ID.")] = None,
        result_type: Annotated[Optional[StrictStr], Field(description="Filter by result type.")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by region where check was executed.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for filtering results (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UnifiedResultList]:
        """Get all check results (regular and on-demand)

        Get all check results (regular and on-demand) for the organization, sorted by creation date. Supports filtering by check ID, status, type, region, and date range. Date range is limited to 6 months in the past.

        :param page: Page number for pagination (starting from 1).
        :type page: int
        :param status: Filter by check result status.
        :type status: str
        :param page_size: Number of results per page (maximum 100).
        :type page_size: int
        :param end_date: End date for filtering results (ISO format).
        :type end_date: datetime
        :param check_type: Filter by check type.
        :type check_type: str
        :param check_id: Filter by specific check ID.
        :type check_id: str
        :param result_type: Filter by result type.
        :type result_type: str
        :param region: Filter by region where check was executed.
        :type region: str
        :param start_date: Start date for filtering results (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_all_results_get_serialize(
            page=page,
            status=status,
            page_size=page_size,
            end_date=end_date,
            check_type=check_type,
            check_id=check_id,
            result_type=result_type,
            region=region,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "UnifiedResultList",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_checks_all_results_get_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination (starting from 1).")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check result status.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page (maximum 100).")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date for filtering results (ISO format).")] = None,
        check_type: Annotated[Optional[StrictStr], Field(description="Filter by check type.")] = None,
        check_id: Annotated[Optional[StrictStr], Field(description="Filter by specific check ID.")] = None,
        result_type: Annotated[Optional[StrictStr], Field(description="Filter by result type.")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by region where check was executed.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for filtering results (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all check results (regular and on-demand)

        Get all check results (regular and on-demand) for the organization, sorted by creation date. Supports filtering by check ID, status, type, region, and date range. Date range is limited to 6 months in the past.

        :param page: Page number for pagination (starting from 1).
        :type page: int
        :param status: Filter by check result status.
        :type status: str
        :param page_size: Number of results per page (maximum 100).
        :type page_size: int
        :param end_date: End date for filtering results (ISO format).
        :type end_date: datetime
        :param check_type: Filter by check type.
        :type check_type: str
        :param check_id: Filter by specific check ID.
        :type check_id: str
        :param result_type: Filter by result type.
        :type result_type: str
        :param region: Filter by region where check was executed.
        :type region: str
        :param start_date: Start date for filtering results (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_all_results_get_serialize(
            page=page,
            status=status,
            page_size=page_size,
            end_date=end_date,
            check_type=check_type,
            check_id=check_id,
            result_type=result_type,
            region=region,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "UnifiedResultList",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_checks_all_results_get_serialize(
        self,
        page,
        status,
        page_size,
        end_date,
        check_type,
        check_id,
        result_type,
        region,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if check_type is not None:
            
            _query_params.append(('check_type', check_type))
            
        if check_id is not None:
            
            _query_params.append(('check_id', check_id))
            
        if result_type is not None:
            
            _query_params.append(('result_type', result_type))
            
        if region is not None:
            
            _query_params.append(('region', region))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'apiKeyAuth', 
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/checks/all-results',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v1_checks_check_id_response_times_get(
        self,
        check_id: Annotated[str, Field(min_length=1, strict=True)],
        end_date: Annotated[Optional[datetime], Field(description="End date for metrics (ISO format).")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by specific region.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check status.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for metrics (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Dict[str, object]:
        """Get aggregated response time metrics for a specific check

        Get aggregated response time metrics for a specific check, grouped by region. Returns average, 95th percentile, and 99th percentile response times for each time bucket and region. Time intervals are automatically determined based on the date range.

        :param check_id: (required)
        :type check_id: str
        :param end_date: End date for metrics (ISO format).
        :type end_date: datetime
        :param region: Filter by specific region.
        :type region: str
        :param status: Filter by check status.
        :type status: str
        :param start_date: Start date for metrics (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_check_id_response_times_get_serialize(
            check_id=check_id,
            end_date=end_date,
            region=region,
            status=status,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_checks_check_id_response_times_get_with_http_info(
        self,
        check_id: Annotated[str, Field(min_length=1, strict=True)],
        end_date: Annotated[Optional[datetime], Field(description="End date for metrics (ISO format).")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by specific region.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check status.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for metrics (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Dict[str, object]]:
        """Get aggregated response time metrics for a specific check

        Get aggregated response time metrics for a specific check, grouped by region. Returns average, 95th percentile, and 99th percentile response times for each time bucket and region. Time intervals are automatically determined based on the date range.

        :param check_id: (required)
        :type check_id: str
        :param end_date: End date for metrics (ISO format).
        :type end_date: datetime
        :param region: Filter by specific region.
        :type region: str
        :param status: Filter by check status.
        :type status: str
        :param start_date: Start date for metrics (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_check_id_response_times_get_serialize(
            check_id=check_id,
            end_date=end_date,
            region=region,
            status=status,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_checks_check_id_response_times_get_without_preload_content(
        self,
        check_id: Annotated[str, Field(min_length=1, strict=True)],
        end_date: Annotated[Optional[datetime], Field(description="End date for metrics (ISO format).")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by specific region.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check status.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for metrics (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get aggregated response time metrics for a specific check

        Get aggregated response time metrics for a specific check, grouped by region. Returns average, 95th percentile, and 99th percentile response times for each time bucket and region. Time intervals are automatically determined based on the date range.

        :param check_id: (required)
        :type check_id: str
        :param end_date: End date for metrics (ISO format).
        :type end_date: datetime
        :param region: Filter by specific region.
        :type region: str
        :param status: Filter by check status.
        :type status: str
        :param start_date: Start date for metrics (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_check_id_response_times_get_serialize(
            check_id=check_id,
            end_date=end_date,
            region=region,
            status=status,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_checks_check_id_response_times_get_serialize(
        self,
        check_id,
        end_date,
        region,
        status,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if check_id is not None:
            _path_params['check_id'] = check_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if region is not None:
            
            _query_params.append(('region', region))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'apiKeyAuth', 
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/checks/{check_id}/response-times',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v1_checks_status_history_get(
        self,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check status.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date for status history (ISO format).")] = None,
        check_id: Annotated[Optional[StrictStr], Field(description="Filter by specific check ID. If not provided, returns metrics for all checks.")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by specific region.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for status history (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Dict[str, object]:
        """Get time-bucketed status history metrics

        Get a time-bucketed history of check counts by status for a check or all checks. Returns counts for each status (ok, failed, degraded, timeout) grouped by region and time bucket. If no check_id is provided, returns metrics for all checks in the organization.

        :param status: Filter by check status.
        :type status: str
        :param end_date: End date for status history (ISO format).
        :type end_date: datetime
        :param check_id: Filter by specific check ID. If not provided, returns metrics for all checks.
        :type check_id: str
        :param region: Filter by specific region.
        :type region: str
        :param start_date: Start date for status history (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_status_history_get_serialize(
            status=status,
            end_date=end_date,
            check_id=check_id,
            region=region,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_checks_status_history_get_with_http_info(
        self,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check status.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date for status history (ISO format).")] = None,
        check_id: Annotated[Optional[StrictStr], Field(description="Filter by specific check ID. If not provided, returns metrics for all checks.")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by specific region.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for status history (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Dict[str, object]]:
        """Get time-bucketed status history metrics

        Get a time-bucketed history of check counts by status for a check or all checks. Returns counts for each status (ok, failed, degraded, timeout) grouped by region and time bucket. If no check_id is provided, returns metrics for all checks in the organization.

        :param status: Filter by check status.
        :type status: str
        :param end_date: End date for status history (ISO format).
        :type end_date: datetime
        :param check_id: Filter by specific check ID. If not provided, returns metrics for all checks.
        :type check_id: str
        :param region: Filter by specific region.
        :type region: str
        :param start_date: Start date for status history (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_status_history_get_serialize(
            status=status,
            end_date=end_date,
            check_id=check_id,
            region=region,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_checks_status_history_get_without_preload_content(
        self,
        status: Annotated[Optional[StrictStr], Field(description="Filter by check status.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date for status history (ISO format).")] = None,
        check_id: Annotated[Optional[StrictStr], Field(description="Filter by specific check ID. If not provided, returns metrics for all checks.")] = None,
        region: Annotated[Optional[StrictStr], Field(description="Filter by specific region.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date for status history (ISO format). Limited to 6 months in the past.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get time-bucketed status history metrics

        Get a time-bucketed history of check counts by status for a check or all checks. Returns counts for each status (ok, failed, degraded, timeout) grouped by region and time bucket. If no check_id is provided, returns metrics for all checks in the organization.

        :param status: Filter by check status.
        :type status: str
        :param end_date: End date for status history (ISO format).
        :type end_date: datetime
        :param check_id: Filter by specific check ID. If not provided, returns metrics for all checks.
        :type check_id: str
        :param region: Filter by specific region.
        :type region: str
        :param start_date: Start date for status history (ISO format). Limited to 6 months in the past.
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_checks_status_history_get_serialize(
            status=status,
            end_date=end_date,
            check_id=check_id,
            region=region,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '422': "Error",
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_checks_status_history_get_serialize(
        self,
        status,
        end_date,
        check_id,
        region,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if status is not None:
            
            _query_params.append(('status', status))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if check_id is not None:
            
            _query_params.append(('check_id', check_id))
            
        if region is not None:
            
            _query_params.append(('region', region))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'apiKeyAuth', 
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/checks/status-history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


