window.ExportManager=class{constructor(e){this.eventViewer=e,this.setupEventHandlers(),console.log("Export manager initialized")}setupEventHandlers(){const e=document.querySelector('button[onclick="clearEvents()"]'),t=document.getElementById("export-btn");e&&e.addEventListener("click",()=>{this.clearEvents()}),t&&t.addEventListener("click",()=>{this.exportEvents()})}exportEvents(){this.eventViewer?this.eventViewer.exportEvents():console.error("Cannot export events: EventViewer not available")}clearEvents(){document.dispatchEvent(new CustomEvent("eventsClearing")),this.eventViewer&&this.eventViewer.clearEvents(),document.dispatchEvent(new CustomEvent("eventsCleared")),console.log("Events cleared")}exportEventsCustom(e={}){const{format:t="json",events:n=null,filename:o=null}=e,r=n||(this.eventViewer?this.eventViewer.events:[]);if(0===r.length)return void console.warn("No events to export");const i=(new Date).toISOString().replace(/[:.]/g,"-"),s=o||`claude-mpm-events-${i}`;let l="",a="",c="";switch(t.toLowerCase()){case"json":l=JSON.stringify(r,null,2),a="application/json",c=".json";break;case"csv":l=this.convertEventsToCSV(r),a="text/csv",c=".csv";break;case"txt":l=this.convertEventsToText(r),a="text/plain",c=".txt";break;default:return void console.error("Unsupported export format:",t)}this.downloadFile(l,s+c,a)}convertEventsToCSV(e){if(0===e.length)return"";return[["timestamp","type","subtype","tool_name","agent_type","session_id","data"],...e.map(e=>[e.timestamp||"",e.type||"",e.subtype||"",e.tool_name||"",e.agent_type||"",e.session_id||"",JSON.stringify(e.data||{}).replace(/"/g,'""')])].map(e=>e.map(e=>`"${e}"`).join(",")).join("\n")}convertEventsToText(e){return 0===e.length?"No events to export.":e.map((e,t)=>{const n=this.formatTimestamp(e.timestamp);let o=`Event ${t+1}: ${e.type||"Unknown"}${e.subtype?` (${e.subtype})`:""}${e.tool_name?` - Tool: ${e.tool_name}`:""}${e.agent_type?` - Agent: ${e.agent_type}`:""}\n`;return o+=`  Time: ${n}\n`,o+=`  Session: ${e.session_id||"Unknown"}\n`,e.data&&Object.keys(e.data).length>0&&(o+=`  Data: ${JSON.stringify(e.data,null,2)}\n`),o}).join("\n"+"=".repeat(80)+"\n")}downloadFile(e,t,n){try{const o=new Blob([e],{type:n}),r=window.URL.createObjectURL(o),i=document.createElement("a");i.href=r,i.download=t,i.style.display="none",document.body.appendChild(i),i.click(),document.body.removeChild(i),window.URL.revokeObjectURL(r),console.log(`File exported: ${t}`)}catch(o){console.error("Failed to export file:",o)}}formatTimestamp(e){if(!e)return"Unknown time";try{const t=new Date(e);return isNaN(t.getTime())?"Invalid time":t.toLocaleTimeString("en-US",{hour12:!1,hour:"2-digit",minute:"2-digit",second:"2-digit"})}catch(t){return console.error("Error formatting timestamp:",t),"Error formatting time"}}formatFullTimestamp(e){if(!e)return"Unknown time";try{const t=new Date(e);return isNaN(t.getTime())?"Invalid time":t.toLocaleString("en-US",{year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:!1})}catch(t){return console.error("Error formatting full timestamp:",t),"Error formatting time"}}scrollListToBottom(e){console.log(`[DEBUG] scrollListToBottom called with listId: ${e}`),setTimeout(()=>{const t=document.getElementById(e);console.log(`[DEBUG] Element found for ${e}:`,t),t?(console.log(`[DEBUG] Scrolling ${e} - scrollHeight: ${t.scrollHeight}, scrollTop before: ${t.scrollTop}`),t.scrollTop=t.scrollHeight,console.log(`[DEBUG] Scrolled ${e} - scrollTop after: ${t.scrollTop}`)):console.warn(`[DEBUG] Element with ID '${e}' not found for scrolling`)},50)}debounce(e,t){let n;return function(...o){clearTimeout(n),n=setTimeout(()=>{clearTimeout(n),e(...o)},t)}}throttle(e,t){let n;return function(...o){n||(e.apply(this,o),n=!0,setTimeout(()=>n=!1,t))}}generateId(){return Date.now().toString(36)+Math.random().toString(36).substr(2)}deepClone(e){if(null===e||"object"!=typeof e)return e;if(e instanceof Date)return new Date(e.getTime());if(e instanceof Array)return e.map(e=>this.deepClone(e));if("object"==typeof e){const t={};for(const n in e)e.hasOwnProperty(n)&&(t[n]=this.deepClone(e[n]));return t}return e}};
//# sourceMappingURL=export-manager.js.map
