from ..imports import *
# ---------------- xrandr / wmctrl parsing ----------------
def get_monitors(self) -> List[Tuple[str, int, int, int, int]]:
    self.monitors = []
    out = self.run_command("xrandr --query | grep ' connected'")
    for line in out.splitlines():
        m = re.match(r"(\S+)\s+connected\s+(\d+)x(\d+)\+(\d+)\+(\d+)", line)
        if m:
            name, w, h, x, y = m.groups()
            self.monitors.append((name, int(x), int(y), int(w), int(h)))
    return self.monitors

def get_windows(self) -> List[Tuple[str, str, str, str, str]]:
    """Return [(id, pid, title, monitor, type), …]"""
    self.windows.clear()
    mons = self.get_monitors()
    out = self.run_command("wmctrl -l -p -G")
    for line in out.splitlines():
        parts = line.split()
        if len(parts) < 8:
            continue
        win_id, desktop, pid, x, y, w, h = parts[:7]
        title = " ".join(parts[8:])
        x, y = int(x), int(y)
        monitor = "Unknown"
        for name, mx, my, mw, mh in mons:
            if mx <= x < mx + mw and my <= y < my + mh:
                monitor = name
                break
        win_type = classify_type(title)
        self.windows.append((win_id, pid, title, monitor, win_type))
    return self.windows
