# coding: utf-8

"""
    Aignostics Platform API reference

     Pagination is done via `page` and `page_size`. Sorting via `sort` query parameter. The `sort` query parameter can be provided multiple times. The sorting direction can be indicated via `+` (ascending) or `-` (descending) (e.g. `/v1/applications?sort=+name)`.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aignx.codegen.models.input_artifact_read_response import InputArtifactReadResponse
from aignx.codegen.models.output_artifact_read_response import OutputArtifactReadResponse
from typing import Optional, Set
from typing_extensions import Self

class ApplicationVersionReadResponse(BaseModel):
    """
    ApplicationVersionReadResponse
    """ # noqa: E501
    application_version_id: StrictStr = Field(description="Application version ID")
    version: StrictStr = Field(description="Semantic version of the application")
    application_id: StrictStr = Field(description="Application ID")
    flow_id: Optional[StrictStr] = None
    changelog: StrictStr = Field(description="Description of the changes relative to the previous version")
    input_artifacts: List[InputArtifactReadResponse] = Field(description="List of the input fields, provided by the User")
    output_artifacts: List[OutputArtifactReadResponse] = Field(description="List of the output fields, generated by the application")
    created_at: datetime = Field(description="The timestamp when the application version was registered")
    __properties: ClassVar[List[str]] = ["application_version_id", "version", "application_id", "flow_id", "changelog", "input_artifacts", "output_artifacts", "created_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationVersionReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in input_artifacts (list)
        _items = []
        if self.input_artifacts:
            for _item_input_artifacts in self.input_artifacts:
                if _item_input_artifacts:
                    _items.append(_item_input_artifacts.to_dict())
            _dict['input_artifacts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in output_artifacts (list)
        _items = []
        if self.output_artifacts:
            for _item_output_artifacts in self.output_artifacts:
                if _item_output_artifacts:
                    _items.append(_item_output_artifacts.to_dict())
            _dict['output_artifacts'] = _items
        # set to None if flow_id (nullable) is None
        # and model_fields_set contains the field
        if self.flow_id is None and "flow_id" in self.model_fields_set:
            _dict['flow_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationVersionReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "application_version_id": obj.get("application_version_id"),
            "version": obj.get("version"),
            "application_id": obj.get("application_id"),
            "flow_id": obj.get("flow_id"),
            "changelog": obj.get("changelog"),
            "input_artifacts": [InputArtifactReadResponse.from_dict(_item) for _item in obj["input_artifacts"]] if obj.get("input_artifacts") is not None else None,
            "output_artifacts": [OutputArtifactReadResponse.from_dict(_item) for _item in obj["output_artifacts"]] if obj.get("output_artifacts") is not None else None,
            "created_at": obj.get("created_at")
        })
        return _obj
