# coding: utf-8

"""
    Aignostics Platform API reference

     Pagination is done via `page` and `page_size`. Sorting via `sort` query parameter. The `sort` query parameter can be provided multiple times. The sorting direction can be indicated via `+` (ascending) or `-` (descending) (e.g. `/v1/applications?sort=+name)`.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from aignx.codegen.models.input_artifact_creation_request import InputArtifactCreationRequest
from typing import Optional, Set
from typing_extensions import Self

class ItemCreationRequest(BaseModel):
    """
    ItemCreationRequest
    """ # noqa: E501
    reference: StrictStr = Field(description="The ID of the slide provided by the caller. The reference should be unique across all items of the application run")
    input_artifacts: List[InputArtifactCreationRequest] = Field(description="All the input files of the item, required by the application version")
    __properties: ClassVar[List[str]] = ["reference", "input_artifacts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ItemCreationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in input_artifacts (list)
        _items = []
        if self.input_artifacts:
            for _item_input_artifacts in self.input_artifacts:
                if _item_input_artifacts:
                    _items.append(_item_input_artifacts.to_dict())
            _dict['input_artifacts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ItemCreationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "reference": obj.get("reference"),
            "input_artifacts": [InputArtifactCreationRequest.from_dict(_item) for _item in obj["input_artifacts"]] if obj.get("input_artifacts") is not None else None
        })
        return _obj
