# coding: utf-8

"""
    Aignostics Platform API reference

     Pagination is done via `page` and `page_size`. Sorting via `sort` query parameter. The `sort` query parameter can be provided multiple times. The sorting direction can be indicated via `+` (ascending) or `-` (descending) (e.g. `/v1/applications?sort=+name)`.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from aignx.codegen.models.payload_input_artifact import PayloadInputArtifact
from aignx.codegen.models.payload_output_artifact import PayloadOutputArtifact
from typing import Optional, Set
from typing_extensions import Self

class PayloadItem(BaseModel):
    """
    PayloadItem
    """ # noqa: E501
    item_id: StrictStr
    input_artifacts: Dict[str, PayloadInputArtifact]
    output_artifacts: Dict[str, PayloadOutputArtifact]
    __properties: ClassVar[List[str]] = ["item_id", "input_artifacts", "output_artifacts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PayloadItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in input_artifacts (dict)
        _field_dict = {}
        if self.input_artifacts:
            for _key_input_artifacts in self.input_artifacts:
                if self.input_artifacts[_key_input_artifacts]:
                    _field_dict[_key_input_artifacts] = self.input_artifacts[_key_input_artifacts].to_dict()
            _dict['input_artifacts'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in output_artifacts (dict)
        _field_dict = {}
        if self.output_artifacts:
            for _key_output_artifacts in self.output_artifacts:
                if self.output_artifacts[_key_output_artifacts]:
                    _field_dict[_key_output_artifacts] = self.output_artifacts[_key_output_artifacts].to_dict()
            _dict['output_artifacts'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PayloadItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "item_id": obj.get("item_id"),
            "input_artifacts": dict(
                (_k, PayloadInputArtifact.from_dict(_v))
                for _k, _v in obj["input_artifacts"].items()
            )
            if obj.get("input_artifacts") is not None
            else None,
            "output_artifacts": dict(
                (_k, PayloadOutputArtifact.from_dict(_v))
                for _k, _v in obj["output_artifacts"].items()
            )
            if obj.get("output_artifacts") is not None
            else None
        })
        return _obj
