# coding: utf-8

"""
    Aignostics Platform API reference

     Pagination is done via `page` and `page_size`. Sorting via `sort` query parameter. The `sort` query parameter can be provided multiple times. The sorting direction can be indicated via `+` (ascending) or `-` (descending) (e.g. `/v1/applications?sort=+name)`.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserReadResponse(BaseModel):
    """
    This model corresponds to the response schema returned from Auth0 GET /v2/users/{id} endpoint. For details, see: https://auth0.com/docs/api/management/v2/users/get-users-by-id
    """ # noqa: E501
    id: StrictStr
    email: Optional[StrictStr] = None
    email_verified: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    given_name: Optional[StrictStr] = None
    family_name: Optional[StrictStr] = None
    nickname: Optional[StrictStr] = None
    picture: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "email", "email_verified", "name", "given_name", "family_name", "nickname", "picture", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if email_verified (nullable) is None
        # and model_fields_set contains the field
        if self.email_verified is None and "email_verified" in self.model_fields_set:
            _dict['email_verified'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if given_name (nullable) is None
        # and model_fields_set contains the field
        if self.given_name is None and "given_name" in self.model_fields_set:
            _dict['given_name'] = None

        # set to None if family_name (nullable) is None
        # and model_fields_set contains the field
        if self.family_name is None and "family_name" in self.model_fields_set:
            _dict['family_name'] = None

        # set to None if nickname (nullable) is None
        # and model_fields_set contains the field
        if self.nickname is None and "nickname" in self.model_fields_set:
            _dict['nickname'] = None

        # set to None if picture (nullable) is None
        # and model_fields_set contains the field
        if self.picture is None and "picture" in self.model_fields_set:
            _dict['picture'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "email_verified": obj.get("email_verified"),
            "name": obj.get("name"),
            "given_name": obj.get("given_name"),
            "family_name": obj.get("family_name"),
            "nickname": obj.get("nickname"),
            "picture": obj.get("picture"),
            "updated_at": obj.get("updated_at")
        })
        return _obj
