# file contents from https://github.com/Apollon77/ioBroker.tuya/blob/master/lib/schema.json

knownSchemas = {
    "8FAPq5h6gdV51Vcr": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "XjGNEvQmy6OXtEGF": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": "plain"},
            {"id": 3, "inputType": "plain"},
            {"id": 7, "inputType": "plain"},
            {"id": 101, "inputType": " "},
            {"id": 102, "inputType": " "},
            {"id": 103, "inputType": " "},
            {"id": 105, "inputType": " "},
        ],
    },
    "1hxNMF9lRQL2xpEA": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "fT3Ltv613pRi4WXr": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "Bright",
                "property": {
                    "unit": "",
                    "min": 11,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputType": "percent"}, {"id": 3, "inputType": ""}],
    },
    "HGZ7aIKOHk99IAoA": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": " "},
            {"id": 3, "inputType": "percent"},
            {"id": 4, "inputType": " "},
        ],
    },
    "PaYQNcPunOhPeS1X": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 2500,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": " "},
            {"id": 6, "inputType": ""},
            {"id": 7, "inputType": ""},
            {"id": 8, "inputType": ""},
            {"id": 9, "inputType": ""},
        ],
    },
    "XExf4P4bLRPKA3dw": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大1000倍之后的值，即上报56，实际值为0.056度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputType": ""},
            {"id": 3, "inputType": ""},
            {"id": 4, "inputType": ""},
            {"id": 5, "inputType": ""},
            {"id": 6, "inputType": ""},
        ],
    },
    "9p017mRuEwVchApg": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 3, "inputType": "percent"}, {"id": 4, "inputType": ""}],
    },
    "ovvg6eKhVt6sb92l": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "atomizing",
                "name": "喷雾功能",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "1:连续喷雾模式；2:间歇喷雾模式；3:关闭喷雾模式",
            },
            {
                "mode": "rw",
                "code": "moodlighting",
                "name": "氛围灯",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 102,
                "type": "obj",
                "desc": "1:循环模式\n2:选色模式\n3:关闭",
            },
            {
                "mode": "rw",
                "code": "light2",
                "name": "彩灯",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 103, "inputType": ""}],
    },
    "t0TDGBQFFw1AZG1I": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "åŸ€å…³",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "æ¨¥åŸ®",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "äºŽåºŒ",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "å†¡æ±–",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "å½Šå…‰æ¨¥åŸ®æ•°",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "æƒ…æ™¯æ¨¥åŸ®æ•°",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "æ»”å…‰æ¨¥åŸ®",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "çŸ¤çº¡æ¨¥åŸ®",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "ç‚å½Šæ¨¥åŸ®",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "æ–‘æ–“æ¨¥åŸ®",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "2fISFtnNO1j4GWU4": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": " "},
            {"id": 3, "inputType": "percent"},
            {"id": 4, "inputType": " "},
        ],
    },
    "TtXKwTMwiPpURWLJ": {
        "schema": [
            {
                "mode": "rw",
                "code": "status",
                "name": "门帘状态",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "开 关 暂停",
            }
        ],
        "schemaExt": "[]",
    },
    "VDy8SyAxa6Q83vvr": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputType": ""},
            {"id": 3, "inputType": ""},
            {"id": 4, "inputType": ""},
            {"id": 5, "inputType": ""},
            {"id": 6, "inputType": ""},
        ],
    },
    "0fHWRe8ULjtmnBNd": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 9, "inputType": ""},
            {"id": 17, "inputType": ""},
            {"id": 18, "inputType": ""},
            {"id": 19, "inputType": ""},
            {"id": 20, "inputType": ""},
            {"id": 21, "inputType": ""},
            {"id": 22, "inputType": ""},
            {"id": 23, "inputType": ""},
            {"id": 24, "inputType": ""},
            {"id": 25, "inputType": ""},
        ],
    },
    "B6GeaaNA7DTT37Gr": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "CirD9U3eqQ0YKivD": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "IGzCi97RpN2Lf9cu": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": " "},
            {"id": 9, "inputType": " "},
            {"id": 17, "inputType": " "},
        ],
    },
    "mQUhiTg9kwydBFBd": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 3000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 1, "inputType": " "}, {"id": 2, "inputType": " "}],
    },
    "n8iVBAPLFKAAAszH": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputType": ""}],
    },
    "ocNB89IgPygEpdnE": {
        "schema": [
            {
                "mode": "ro",
                "code": "switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "上报门窗开关状态",
            },
            {
                "mode": "ro",
                "code": "TamperedAlarm",
                "name": "防拆报警",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "mcu 上报拆除信息",
            },
            {
                "mode": "ro",
                "code": "Battery",
                "name": "电池电量",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 10,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "mcu 上报电池电量信息",
            },
            {
                "mode": "ro",
                "code": "state",
                "name": "状态",
                "property": {"type": "bool"},
                "id": 105,
                "type": "obj",
                "desc": "上报产品是“休眠”还是“离线”",
            },
        ],
        "schemaExt": "[]",
    },
    "PUyaDrOGMhJfCExd": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "trigger": "direct",
                "type": "obj",
                "desc": "上报的为放大1000倍之后的值，即上报56，实际值为0.056度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputType": ""},
            {"id": 3, "inputType": ""},
            {"id": 4, "inputType": ""},
            {"id": 5, "inputType": ""},
            {"id": 6, "inputType": ""},
        ],
    },
    "rGglRM3FRxUKqJSA": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "True反转，false正常",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测报警灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "获取SD卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "SD卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "格式化存储卡",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测图片/视频上传",
                "id": 115,
                "type": "raw",
                "desc": '{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "rw",
                "code": "ptz_stop",
                "name": "停止云台转动",
                "property": {"type": "bool"},
                "id": 116,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "ptz_control",
                "name": "云台控制",
                "property": {
                    "range": ["1", "2", "3", "4", "5", "6", "7", "0"],
                    "type": "enum",
                },
                "id": 119,
                "type": "obj",
                "desc": "direction：方向，共8个;0-上，1-右上，2-右，3-右下，4-下，5-左下，6-左，7-左上",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动侦测报警功能开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_switch",
                "name": "分贝检测功能开关",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_sensitivity",
                "name": "分贝检测灵敏度",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 140,
                "type": "obj",
                "desc": "0代表低灵敏度；1代表高灵敏度",
            },
            {
                "mode": "ro",
                "code": "decibel_upload",
                "name": "分贝报警通道",
                "property": {"type": "string", "maxlen": 255},
                "id": 141,
                "type": "obj",
                "desc": "用于报警消息推送，app上会显示通知",
            },
        ],
        "schemaExt": "[]",
    },
    "HPiNfakVX1Z9hWsO": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "JtCDjzmKcUNKEBzO": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_s1",
                "name": "开关1",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_s2",
                "name": "开关 2",
                "property": {"type": "bool"},
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_s3",
                "name": "开关 3",
                "property": {"type": "bool"},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB",
                "property": {"type": "bool"},
                "id": 4,
                "type": "obj",
                "desc": "switch_s4修改为switch_usb1",
            },
        ],
        "schemaExt": "[]",
    },
    "ScIEYTTGvXy1uuWt": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "IAYz2WK1th0cMLmL": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "å¼€å…³",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "TempSet",
                "name": "ç›®æ ‡æ¸©åº¦",
                "property": {
                    "unit": "â„ƒ",
                    "min": 10,
                    "max": 70,
                    "scale": 1,
                    "step": 5,
                    "type": "value",
                },
                "iconname": "icon-dp_temp",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "TempCurrent",
                "name": "å½“å‰æ¸©åº¦",
                "property": {
                    "unit": "â„ƒ",
                    "min": 0,
                    "max": 100,
                    "scale": 1,
                    "step": 5,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Mode",
                "name": "æ¨¡å¼",
                "property": {"range": ["0", "1"], "type": "enum"},
                "iconname": "icon-dp_mode",
                "id": 4,
                "type": "obj",
                "desc": "0ï¼šå‘¨ç¨‹åº\n1ï¼šæ‰‹åŠ¨\n",
            },
            {
                "mode": "rw",
                "code": "ECO",
                "name": "ECOæ¨¡å¼",
                "property": {"type": "bool"},
                "iconname": "icon-eco",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ChildLock",
                "name": "ç«¥é”",
                "property": {"type": "bool"},
                "iconname": "icon-dp_lock",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "program",
                "name": "å‘¨ç¨‹åº",
                "id": 101,
                "type": "raw",
                "desc": "å¯¹åº”æ˜ŸæœŸä¸€~æ˜ŸæœŸäº”ã€æ˜ŸæœŸå…­ã€æ˜ŸæœŸæ—¥ï¼Œæ¯å¤©å…­æ®µï¼Œå¯è®¾ç½®æ¯å°æ—¶çš„æ¸©åº¦èŒƒå›´ã€‚æ¸©åº¦èŒƒå›´ä¸º5-35æ‘„æ°åº¦ã€‚",
            },
            {
                "mode": "ro",
                "code": "floorTemp",
                "name": "åœ°æ¿æ¸©åº¦",
                "property": {
                    "unit": "â„ƒ",
                    "min": 0,
                    "max": 198,
                    "scale": 1,
                    "step": 5,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "tempSwitch",
                "name": "æ¸©åº¦åˆ‡æ¢",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 103,
                "type": "obj",
                "desc": "0ï¼šå®¤å†…æ¸©åº¦\n1ï¼šåœ°æ¸©",
            },
            {
                "mode": "ro",
                "code": "floortempFunction",
                "name": "åœ°æš–æ¸©åº¦åŠŸèƒ½",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "eyEYwtdx9VhexxLW": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "å¼€å…³",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "å»¶è¿Ÿ",
                "property": {
                    "unit": "ç§’",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "ç”µé‡",
                "property": {
                    "unit": "åº¦",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "ä¸ŠæŠ¥çš„ä¸ºæ”¾å¤§100å€ä¹‹åŽçš„å€¼ï¼Œå³ä¸ŠæŠ¥56ï¼Œå®žé™…å€¼ä¸º0.56åº¦",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "ç”µæµ",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "åŠŸçŽ‡",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "ç”µåŽ‹",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "LED",
                "name": "LEDæŽ§åˆ¶",
                "property": {"type": "bool"},
                "id": 7,
                "type": "obj",
                "desc": "è®¾å¤‡è¾“å‡ºæ—¶å¯é€šè¿‡æ­¤æŽ§ä»¶æŽ§åˆ¶çº¢ç¯äº®ç­",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": " "},
            {"id": 2, "inputType": " "},
            {"id": 7, "inputType": " "},
        ],
    },
    "gGUj6WJeZHA1QBDU": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "开关机控制。\n下发： 发送控制指令给主机，主机依据指令状态进行开关机操作。\n上报：\n当主机使用遥控器关机或者长时间静止进入关机状态后，主机会上报一个关机数据。\n当主机处于关机状态时，通过遥控器或者触摸主机的按键，主机会进入开机状态，主机会上报一个开机数据。",
            },
            {
                "mode": "ro",
                "code": "Error",
                "scope": "fault",
                "name": "故障",
                "property": {
                    "label": ["1", "2", "3", "4", "5", "6", "7", "8"],
                    "type": "bitmap",
                    "maxlen": 8,
                },
                "id": 11,
                "type": "obj",
                "desc": "0 正常；1左边扫异常 ；2右边扫异常 ；3中扫异常 ；4左轮异常；5右轮异常；6风机异常,7 跌落异常 8 主机抬起\n当主机上报后，显示错误代码，当上报0后，清楚显示。",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "剩余电量",
                "property": {
                    "unit": "％",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 14,
                "type": "obj",
                "desc": "机器定时上报电量百分比， 0% - 100%",
            },
            {
                "mode": "rw",
                "code": "open",
                "name": "开启／暂停按钮",
                "property": {"type": "bool"},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "direction",
                "name": "方向",
                "property": {"range": ["1", "2", "3", "4", "5"], "type": "enum"},
                "id": 26,
                "type": "obj",
                "desc": "向前／后／左／右／停",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "工作模式",
                "property": {"range": ["0", "1", "2", "3", "4", "5"], "type": "enum"},
                "id": 27,
                "type": "obj",
                "desc": "0: 停止 / 1:自动打扫／2:定点清扫／3:单间打扫／4:沿边打扫／5:自动回充",
            },
            {
                "mode": "rw",
                "code": "fullgo",
                "name": "充满清扫",
                "property": {"type": "bool"},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "3tDXGiKoVhBYg5zn": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 1, "inputType": "plain"}, {"id": 2, "inputType": " "}],
    },
    "W7KCgml5Qn2x5T9v": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": " "},
            {"id": 3, "inputType": "percent"},
            {"id": 4, "inputType": "percent"},
        ],
    },
    "rrOujSy4Pf1BwEgV": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 3, "inputType": ""}, {"id": 4, "inputType": ""}],
    },
    "laI556gLUEUkFd7T": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": " "},
            {"id": 3, "inputType": " "},
            {"id": 4, "inputType": " "},
        ],
    },
    "6mowdiydpq6sxur9": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "D7Hl3AxFbHDS98iO": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_4",
                "name": "开关4",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown4",
                "name": "开关4倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 101, "inputType": ""},
            {"id": 102, "inputType": ""},
            {"id": 103, "inputType": ""},
            {"id": 104, "inputType": ""},
            {"id": 105, "inputType": ""},
        ],
    },
    "DEQevYCSHLnbDube": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "power",
                "name": "power",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "插座开关",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "S",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 106,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": " "},
            {"id": 2, "inputType": " "},
            {"id": 3, "inputType": " "},
            {"id": 4, "inputType": " "},
            {"id": 101, "inputType": " "},
            {"id": 102, "inputType": " "},
            {"id": 103, "inputType": ""},
            {"id": 104, "inputType": ""},
            {"id": 105, "inputType": ""},
            {"id": 106, "inputType": ""},
        ],
    },
    "oSQljE9YDqwCwTUA": {
        "schema": [
            {
                "mode": "ro",
                "code": "status",
                "name": "开关状态",
                "property": {"range": ["open", "closed"], "type": "enum"},
                "iconname": "icon-dp_direction",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "BatteryStatus",
                "name": "电池电量",
                "property": {"range": ["0x00", "0x01", "0x02", "0x03"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "qxJSyTLEtX5WrzA9": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 3000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "Xg7AvNi7aeRqW3fD": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": "plain"},
            {"id": 9, "inputType": "plain"},
            {"id": 10, "inputType": "plain"},
            {"id": 17, "inputType": " "},
            {"id": 18, "inputType": ""},
            {"id": 19, "inputType": ""},
            {"id": 20, "inputType": ""},
            {"id": 21, "inputType": ""},
            {"id": 22, "inputType": ""},
            {"id": 23, "inputType": ""},
            {"id": 24, "inputType": ""},
            {"id": 25, "inputType": ""},
        ],
    },
    "lFJaFOExN8tbpDDC": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "VV8ZfLV6G2jY56Lx": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": [{"id": 1, "inputType": " "}, {"id": 11, "inputType": " "}],
    },
    "bX4RxnUXbwNdXWql": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "遥控器参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习按键下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习按键下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习按键下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
        ],
        "schemaExt": "[]",
    },
    "jllh2kdbGM0QTdf1": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "switch_power",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "模式",
                "property": {"range": ["0", "1", "2", "3", "4"], "type": "enum"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "temperature",
                "name": "温度",
                "property": {
                    "unit": "",
                    "min": 16,
                    "max": 30,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "fan",
                "name": "风量",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "swing",
                "name": "摆风",
                "property": {"type": "bool"},
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "MZdP3axAfnAlIc4k": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "X54enXVZyZCvH0Ar": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "pmxdTX2JLrSuJM39": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "TempSet",
                "name": "目标温度",
                "property": {
                    "unit": "℃",
                    "min": 15,
                    "max": 30,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_temp",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Mode",
                "name": "模式",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "iconname": "icon-dp_mode",
                "id": 4,
                "type": "obj",
                "desc": "低档\高档、ECO、",
            },
            {
                "mode": "rw",
                "code": "ChildLock",
                "name": "童锁",
                "property": {"type": "bool"},
                "iconname": "icon-dp_lock",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "Countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "H",
                    "min": 0,
                    "max": 12,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "TimeSet",
                "name": "定时功能",
                "property": {
                    "unit": "H",
                    "min": 0,
                    "max": 12,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "wiINnkE8ASfAJSX6": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temperature_c",
                "name": "温度",
                "property": {
                    "unit": "°C",
                    "min": 0,
                    "max": 37,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temperature_f",
                "name": "华氏温度",
                "property": {
                    "unit": "°F",
                    "min": 32,
                    "max": 99,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "exchange",
                "name": "华氏摄氏度切换",
                "property": {"type": "bool"},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "c_temperature",
                "name": "实际摄氏温度",
                "property": {
                    "unit": "°C",
                    "min": 0,
                    "max": 50,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "f_temperature",
                "name": "实际华氏温度",
                "property": {
                    "unit": "°F",
                    "min": 32,
                    "max": 122,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "appoint",
                "name": "预约",
                "property": {
                    "unit": "m",
                    "min": 0,
                    "max": 1440,
                    "range": [
                        0,
                        60,
                        120,
                        180,
                        240,
                        300,
                        360,
                        420,
                        480,
                        540,
                        600,
                        660,
                        720,
                        780,
                        840,
                        900,
                        960,
                        1020,
                        1080,
                        1140,
                        1200,
                        1260,
                        1320,
                        1380,
                        1440,
                    ],
                    "step": 1,
                    "type": "value",
                },
                "id": 7,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "appoint_flag",
                "name": "预约标志位",
                "property": {"type": "bool"},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "TimerData",
                "name": "周程序",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "smartTimer",
                "name": "定时",
                "property": {"range": ["holiday", "program"], "type": "enum"},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "YWK0ZiumXZGkb8nj": {
        "schema": [
            {
                "mode": "rw",
                "code": "status",
                "name": "窗帘状态",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "开 关 暂停",
            }
        ],
        "schemaExt": "[]",
    },
    "fcLzUB4zWk95xYdk": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            }
        ],
        "schemaExt": "[]",
    },
    "XCEjLKZzUQNuA": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputType": "percent1"},
            {"id": 4, "inputType": "percent1"},
        ],
    },
    "kcwceojngesde5xp": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 15,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": " "},
            {"id": 7, "inputType": "plain"},
            {"id": 9, "inputType": " "},
            {"id": 15, "inputType": " "},
            {"id": 17, "inputType": " "},
        ],
    },
    "heeU2AWVxpxfqP6D": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flashscreen",
                "name": "新场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_house",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputType": "plain"},
            {"id": 2, "inputType": "plain"},
            {"id": 3, "inputType": "percent"},
        ],
    },
    "U3JAXVgJIsEmht9o": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                        "music",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "增加音乐模式",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 101,
                "type": "obj",
                "desc": "音乐灯",
            },
        ],
        "schemaExt": "[]",
    },
    "MA6aYCAx1vYF4pH7": {
        "schema": [
            {
                "mode": "rw",
                "code": "status",
                "name": "窗帘状态",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "开 关 暂停",
            }
        ],
        "schemaExt": "[]",
    },
    "Okurono2XLVRV0fB": {
        "schema": [
            {
                "mode": "ro",
                "code": "PIR",
                "name": "Alarm",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "BatteryStatus",
                "name": "Battery",
                "property": {"range": ["0x00", "0x01", "0x02", "0x03"], "type": "enum"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "IRHu81DJNbMHKZSv": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "开关机控制。\n下发： 发送控制指令给主机，主机依据指令状态进行开关机操作。\n上报：\n当主机使用遥控器关机或者长时间静止进入关机状态后，主机会上报一个关机数据。\n当主机处于关机状态时，通过遥控器或者触摸主机的按键，主机会进入开机状态，主机会上报一个开机数据。",
            },
            {
                "mode": "ro",
                "code": "Error",
                "scope": "fault",
                "name": "故障",
                "property": {
                    "label": [
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        "10",
                        "11",
                        "12",
                        "13",
                        "14",
                    ],
                    "type": "bitmap",
                    "maxlen": 14,
                },
                "id": 11,
                "type": "obj",
                "desc": "0:无报警1:主动轮过载 2:前跌落触发 3:左跌落触发 4:右跌落触发 5:机器离地 6:左碰撞卡住 7:右碰撞卡住 8:边刷缠绕 9:电量低于20% 10:尘盒未安装 11:风扇异常 12:滚刷异常 13:电池故障14:水箱未安装",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "剩余电量",
                "property": {
                    "unit": "％",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 14,
                "type": "obj",
                "desc": "机器定时上报电量百分比， 0% - 100%",
            },
            {
                "mode": "rw",
                "code": "power_go",
                "name": "暂停",
                "property": {"type": "bool"},
                "id": 25,
                "type": "obj",
                "desc": "0:暂停 1:工作",
            },
            {
                "mode": "rw",
                "code": "directioncontrol",
                "name": "方向控制",
                "property": {
                    "range": ["forward", "backward", "turnleft", "turnright", "stop"],
                    "type": "enum",
                },
                "id": 26,
                "type": "obj",
                "desc": "前／后／左／右／停",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "idle",
                        "auto",
                        "spot",
                        "single",
                        "wallfollow",
                        "chargego",
                    ],
                    "type": "enum",
                },
                "id": 27,
                "type": "obj",
                "desc": "idle 空闲模式、auto 自动模式 、spot 定点模式、single 单间模式、wallfollow 沿边模式、chargego 回充模式",
            },
            {
                "mode": "ro",
                "code": "Status",
                "name": "状态",
                "property": {
                    "range": [
                        "standby",
                        "working",
                        "fault",
                        "sleep",
                        "workcompleted",
                        "charging",
                        "chargecompleted",
                        "pause",
                    ],
                    "type": "enum",
                },
                "id": 28,
                "type": "obj",
                "desc": "0: 待机 1: 工作中 2: 故障 3: 休眠 4: 工作完成 5: 充电 6: 充电完成 7:暂停",
            },
            {
                "mode": "wr",
                "code": "Find_robot",
                "name": "寻找机器人",
                "property": {"type": "bool"},
                "id": 29,
                "type": "obj",
                "desc": "App触发下发1",
            },
            {
                "mode": "rw",
                "code": "Fan_seepage",
                "name": "清扫强度",
                "property": {"range": ["low", "normal", "high"], "type": "enum"},
                "id": 30,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "2si3Y6O3K2rK9XBr": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_set",
                "name": "温度调节",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 99,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_temp",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "temp_current",
                "name": "当前温度",
                "property": {
                    "unit": "℃",
                    "min": -20,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "模式",
                "property": {
                    "range": ["auto", "cold", "hot", "wet", "wind"],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 4,
                "type": "obj",
                "desc": "auto：自动模式(feel)；cold：制冷模式；hot：制热模式；wet：除湿模式；wind：送风模式",
            },
            {
                "mode": "rw",
                "code": "windspeed",
                "name": "风量",
                "property": {"range": ["1", "2", "3", "4"], "type": "enum"},
                "iconname": "icon-dp_wind",
                "id": 5,
                "type": "obj",
                "desc": "1：高；2：中；3：低；4：自动",
            },
            {
                "mode": "rw",
                "code": "mode_ECO",
                "name": "经济模式",
                "property": {"type": "bool"},
                "iconname": "icon-eco",
                "id": 8,
                "type": "obj",
                "desc": "ECO模式",
            },
            {
                "mode": "ro",
                "code": "Fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {
                    "label": [
                        "E0",
                        "E1",
                        "E2",
                        "E3",
                        "E4",
                        "E6",
                        "E7",
                        "E8",
                        "E9",
                        "EA",
                        "EF",
                        "EU",
                    ],
                    "type": "bitmap",
                    "maxlen": 12,
                },
                "iconname": "icon-dp_warming",
                "id": 20,
                "type": "obj",
                "desc": "E0:室内外电控板通信故障;E1:室内环境温度传感器故障;E2:室内盘管温度传感器故障;E3:室外盘管温度传感器故障;E4:系统缺氟;E6:室内电机故障或内机风扇不转;E7:室外环境温度传感器故障;E8:室外排气温度传感器故障;E9:室外IPM变频模块故障/压缩机驱动故障;EA:室外电流传感器故障;EF:室外直流风机故障;EU:室外电压传感器故障（电源电压）",
            },
            {
                "mode": "rw",
                "code": "sleep",
                "name": "睡眠模式",
                "property": {"type": "bool"},
                "iconname": "icon-dp_sleep",
                "id": 101,
                "type": "obj",
                "desc": "睡眠（SLEEP）",
            },
            {
                "mode": "rw",
                "code": "turbo",
                "name": "强力模式",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "强力（TURBO）",
            },
            {
                "mode": "rw",
                "code": "cf",
                "name": "温标切换",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "温标切换，True是华氏度，fasle是摄氏度",
            },
            {
                "mode": "rw",
                "code": "wind_up",
                "name": "上下摆风",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "上下摆风",
            },
            {
                "mode": "rw",
                "code": "wind_left",
                "name": "左右摆风",
                "property": {"type": "bool"},
                "id": 105,
                "type": "obj",
                "desc": "左右摆风",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": ""},
        ],
    },
    "xaogr3mrapdrlydm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "åŒå³1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "åŒå³2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "åŒå³3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_4",
                "name": "åŒå³4",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USBåŒå³1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "åŒå³1åè®¡æ¶",
                "property": {
                    "unit": "ç§",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "åŒå³2åè®¡æ¶",
                "property": {
                    "unit": "ç§",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "åŒå³3åè®¡æ¶",
                "property": {
                    "unit": "ç§",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown4",
                "name": "åŒå³4åè®¡æ¶",
                "property": {
                    "unit": "ç§",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1åè®¡æ¶",
                "property": {
                    "unit": "ç§",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "0TmkB4TrA4et14ug": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "RW97vAmAX51GSB1w": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 7, "inputStyle": "", "inputType": " "},
        ],
    },
    "rz3vIjNqRvwnpd8m": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "wtK7fh6RgdfMoSHk": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 6, "inputStyle": "", "inputType": ""}],
    },
    "0rwvmsnhgieurwuf": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器控制",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "bright", "inputType": "percent1"},
            {"id": 4, "inputStyle": "temp", "inputType": "percent"},
            {"id": 101, "inputStyle": "", "inputType": ""},
        ],
    },
    "eZhUXk6MmN7tmCMl": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "FvoFqGMb7aKOHyNH": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "i22freyypqdcirq3": {
        "schema": [
            {
                "mode": "ro",
                "code": "doorcontact_state",
                "name": "门磁",
                "property": {"type": "bool"},
                "iconname": "icon-zanting",
                "id": 1,
                "type": "obj",
                "desc": "【必选】",
            },
            {
                "mode": "ro",
                "code": "battery_state",
                "name": "电池电量状态",
                "property": {"range": ["low", "middle", "high"], "type": "enum"},
                "id": 3,
                "type": "obj",
                "desc": "【非必选】",
            },
        ],
        "schemaExt": "[]",
    },
    "mokkxfsfgsgkahao": {
        "schema": [
            {
                "mode": "ro",
                "code": "pir_state",
                "name": "人体感应状态",
                "property": {"range": ["pir"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "【必选】\npir:表示有人经过\noff:表示没人经过（考虑到场景联动需要，加这个枚举）",
            },
            {
                "mode": "ro",
                "code": "battery_state",
                "name": "电池电量状态",
                "property": {"range": ["low", "middle", "high"], "type": "enum"},
                "id": 3,
                "type": "obj",
                "desc": "【必选】\n低电量\n中电量\n高电量",
            },
        ],
        "schemaExt": "[]",
    },
    "nfUvI4giCymq2Kco": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "SSJ3FnXaNsrwYYnF": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "排插开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "排插开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "排插开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ZnVGigq6xD5XXgO0": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 11, "inputStyle": "", "inputType": " "},
        ],
    },
    "cimRNeiseS1bvCY3": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "zakhnlpdiu0ycdxn": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器控制",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": "percent1"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "hpaeslvkx4znwzae": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "bright", "inputType": "percent1"},
            {"id": 4, "inputStyle": "temp", "inputType": "percent"},
        ],
    },
    "lmnt3uyltk1xffrt": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器控制",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": "percent1"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "rXPydNxXQS4NuSDm": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flashscreen",
                "name": "新场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_house",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
        ],
    },
    "bSCvSjRk1eCOVna6": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "基本-状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "基本-录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "True反转，false正常",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "基本-视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测-灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "移动侦测-定时设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测-OSS上传",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动侦测",
                "property": {"type": "bool"},
                "iconname": "icon-yundong",
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "移动侦测-模式选择",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "decibel_switch",
                "name": "分贝检测-总开关",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_sensitivity",
                "name": "分贝检测-灵敏度",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 140,
                "type": "obj",
                "desc": "0代表低灵敏度；1代表高灵敏度",
            },
            {
                "mode": "ro",
                "code": "decibel_upload",
                "name": "分贝检测-消息上报",
                "property": {"type": "string", "maxlen": 255},
                "id": 141,
                "type": "obj",
                "desc": "用于报警消息推送，app上会显示通知",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "XFD2nSDKxFlGV5sV": {
        "schema": [
            {
                "mode": "ro",
                "code": "PIR",
                "name": "PIR",
                "property": {"range": ["pir"], "type": "enum"},
                "id": 101,
                "trigger": "direct",
                "type": "obj",
                "desc": "pir 检测",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "电池电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 10000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "mcu 上报电池电量",
            },
        ],
        "schemaExt": "[]",
    },
    "d7ObubEu0zzlr1LH": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "单插开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 7, "inputStyle": "", "inputType": " "},
            {"id": 11, "inputStyle": "", "inputType": " "},
            {"id": 101, "inputStyle": "", "inputType": " "},
        ],
    },
    "vhjenVoes31SPqy9": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "qHLNAzmrRdA9EMXl": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            }
        ],
        "schemaExt": "[]",
    },
    "wd1rx0z7bpl5psqi": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "时间水印",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "basic_private",
                "name": "基本-设备休眠",
                "property": {"type": "bool"},
                "id": 105,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\nTrue休眠，false不休眠",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "rw",
                "code": "basic_nightvision",
                "name": "红外夜视",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 108,
                "type": "obj",
                "desc": "0:自动\n1:关\n2:开",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "检测到移动",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动报警开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": [
            {"id": 110, "inputStyle": "", "inputType": ""},
            {"id": 117, "inputStyle": "", "inputType": ""},
        ],
    },
    "o92blxrzf4ta5bx9": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 9, "inputStyle": "", "inputType": ""},
        ],
    },
    "mja3yagk2wgmkvgf": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": ""},
            {"id": 21, "inputStyle": "", "inputType": ""},
            {"id": 22, "inputStyle": "", "inputType": ""},
            {"id": 26, "inputStyle": "", "inputType": ""},
        ],
    },
    "cfxfmzyltotnocfa": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器控制",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": "percent1"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "rD7uqAAgQOpSA2Rx": {
        "schema": [
            {
                "mode": "rw",
                "code": "status",
                "name": "窗帘状态",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "开 关 暂停",
            }
        ],
        "schemaExt": "[]",
    },
    "bSXSSFArVKtc4DyC": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 11,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "cya3zxfd38g4qp8d": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 11, "inputStyle": "", "inputType": " "},
        ],
    },
    "3intussjrua4r6rx": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "eEhWmpy1Mq02OBuV": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "gl5fdiv1tc9mkvlp": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_4",
                "name": "开关4",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_4",
                "name": "开关4倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 12,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 15,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_all",
                "name": "全部开关",
                "property": {"type": "bool"},
                "id": 38,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "qHcpGiXE6DTLVSHb": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_4",
                "name": "开关4",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "倒计时1",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "倒计时2",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_3",
                "name": "倒计时3",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_4",
                "name": "倒计时4",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时1",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 101, "inputStyle": "", "inputType": ""},
            {"id": 102, "inputStyle": "", "inputType": ""},
            {"id": 103, "inputStyle": "", "inputType": ""},
            {"id": 104, "inputStyle": "", "inputType": ""},
            {"id": 105, "inputStyle": "", "inputType": ""},
        ],
    },
    "jjCFs0rMUp3ZO25u": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "trigger": "direct",
                "type": "obj",
                "desc": "上报的为放大1000倍之后的值，即上报56，实际值为0.056度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "h6MjwrnldNTu4kX3": {
        "schema": [
            {
                "mode": "rw",
                "code": "Mode",
                "name": "烧水模式",
                "property": {
                    "range": ["0", "1", "2", "3", "4", "5", "6"],
                    "type": "enum",
                },
                "id": 101,
                "type": "obj",
                "desc": "0：奶粉（45℃）\n1：蜜水 （60℃）\n2：绿茶 （85℃）\n3：红茶（除氯3分钟）\n4：煮沸\n5：保温\n6：取消",
            },
            {
                "mode": "rw",
                "code": "SetTem",
                "name": "保温温度设置",
                "property": {
                    "unit": "℃",
                    "min": 30,
                    "max": 95,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "默认70℃",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["0", "1", "2"], "type": "bitmap", "maxlen": 3},
                "id": 104,
                "type": "obj",
                "desc": "0：干烧报警\n1：水壶故障\n2：少水报警\n",
            },
            {
                "mode": "ro",
                "code": "Tem",
                "name": "当前温度",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "state",
                "name": "当前状态",
                "property": {"range": ["0", "1", "2", "3", "4", "5"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0：未连接\n1：壶座分离\n2：空闲中\n3：加热中\n4：冷却中\n5：保温中\n",
            },
            {
                "mode": "ro",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 240,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 107,
                "type": "obj",
                "desc": "mcu上报",
            },
            {
                "mode": "ro",
                "code": "timer",
                "name": "运行时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 240,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 108,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "sdkofuutdkx2wymo": {
        "schema": [
            {
                "mode": "rw",
                "code": "Mode",
                "name": "烧水模式",
                "property": {
                    "range": ["0", "1", "2", "3", "4", "5", "6"],
                    "type": "enum",
                    "translation": {
                        "0": "45_degrees",
                        "1": "60_degrees",
                        "2": "85_degrees",
                        "3": "100_degrees",
                        "4": "start",
                        "5": "keep_warm",
                        "6": "cancel",
                    },
                },
                "id": 101,
                "type": "obj",
                "desc": "0：奶粉（45℃）\n1：蜜水 （60℃）\n2：绿茶 （85℃）\n3：红茶（除氯3分钟）\n4：煮沸\n5：保温\n6：取消",
            },
            {
                "mode": "rw",
                "code": "SetTem",
                "name": "保温温度设置",
                "property": {
                    "unit": "℃",
                    "min": 30,
                    "max": 95,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "默认70℃",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["0", "1", "2"], "type": "bitmap", "maxlen": 3},
                "id": 104,
                "type": "obj",
                "desc": "0：干烧报警\n1：水壶故障\n2：少水报警\n",
            },
            {
                "mode": "ro",
                "code": "Tem",
                "name": "当前温度",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "state",
                "name": "当前状态",
                "property": {
                    "range": ["0", "1", "2", "3", "4", "5"],
                    "type": "enum",
                    "translation": {
                        "0": "Offline",
                        "1": "Removed from base",
                        "2": "Standby",
                        "3": "Heating",
                        "4": "Cooling",
                        "5": "Keep warm",
                    },
                },
                "id": 106,
                "type": "obj",
                "desc": "0：未连接\n1：壶座分离\n2：空闲中\n3：加热中\n4：冷却中\n5：保温中\n",
            },
            {
                "mode": "ro",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 240,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 107,
                "type": "obj",
                "desc": "mcu上报",
            },
            {
                "mode": "ro",
                "code": "timer",
                "name": "运行时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 240,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 108,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "MlpvUcFGEvlwJmSp": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": "plain"},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "37mnhia3pojleqfh": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "over_current_alarm",
                "name": "过流预警",
                "property": {"type": "bool"},
                "id": 7,
                "type": "obj",
                "desc": "当电流处于16.3A和18A之间时，预警，20秒后关闭电源",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "dsmjufemzocc33o0": {
        "schema": [
            {
                "mode": "ro",
                "code": "watersensor_state",
                "name": "水浸检测状态",
                "property": {"range": ["alarm", "normal"], "type": "enum"},
                "iconname": "icon-a_water",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "battery_state",
                "name": "电池电量状态",
                "property": {"range": ["low", "middle", "high"], "type": "enum"},
                "iconname": "icon-dianliang",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "yg5dcbfu": {
        "schema": [
            {
                "mode": "rw",
                "code": "prm_content",
                "name": "湿度",
                "property": {
                    "unit": "% RH",
                    "min": 0,
                    "max": 10000,
                    "scale": 2,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "trigger": "direct",
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "trigger": "direct",
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "prm_temperature",
                "name": "温度",
                "property": {
                    "unit": "",
                    "min": -2000,
                    "max": 10000,
                    "scale": 2,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "trigger": "direct",
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "LLoyXsJzzU6MX81L": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": " "},
        ],
    },
    "nhkz9w8oardyykyl": {
        "schema": [
            {
                "mode": "ro",
                "code": "upward",
                "name": "上行通道",
                "id": 101,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "down",
                "name": "下行通道",
                "id": 102,
                "type": "raw",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "vnya2spfopsh9lro": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "uuwajnna8zrelzh6": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制",
                "property": {"range": ["open", "stop", "close"], "type": "enum"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "percent_control",
                "name": "开启百分比控制",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "percent_state",
                "name": "开启百分比状态",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_warming",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "readyCal",
                "name": "已完成校准",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "如果未校准  app进度条显示灰色 不可用 已校准显示为可用",
            },
            {
                "mode": "rw",
                "code": "childLock",
                "name": "童锁",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "童锁开关",
            },
            {
                "mode": "rw",
                "code": "backLedSwitch",
                "name": "背光灯开关",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "背光灯开关",
            },
            {
                "mode": "rw",
                "code": "calControl",
                "name": "校准控制",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 104,
                "type": "obj",
                "desc": "校准控制 1 校准开始 2校准结束 3 取消校准",
            },
            {
                "mode": "rw",
                "code": "calTime",
                "name": "校准时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 1000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "校准时间即完全打开到完全关闭的时间\n用户知道时间可以直接设置  不知道时间时需要校准  ",
            },
            {
                "mode": "rw",
                "code": "clear",
                "name": "清除校准数据",
                "property": {"type": "bool"},
                "id": 106,
                "type": "obj",
                "desc": "清除校准数据",
            },
        ],
        "schemaExt": "[]",
    },
    "9ZzvEHiUp4XwJBlS": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "通断开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "mdk",
                "name": "门磁开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 7, "inputStyle": "", "inputType": ""}],
    },
    "ulv4nnue7gqp0rjk": {
        "schema": [
            {
                "mode": "rw",
                "code": "alarm_state",
                "name": "报警器状态",
                "property": {
                    "range": ["light", "voice", "light_voice", "mute"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "【必选】\n1：声音报警\n2：光亮报警\n3：声光报警\n4：报警解除",
            },
            {
                "mode": "rw",
                "code": "alarm_volume",
                "name": "报警音量",
                "property": {
                    "range": ["low", "middle", "high", "mute"],
                    "type": "enum",
                },
                "id": 5,
                "type": "obj",
                "desc": "【非必选】低量/中量/高量/静音",
            },
            {
                "mode": "rw",
                "code": "alarm_time",
                "name": "报警时长",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 30,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 7,
                "type": "obj",
                "desc": "【非必选】",
            },
            {
                "mode": "rw",
                "code": "alarm_switch",
                "name": "报警开关",
                "property": {"type": "bool"},
                "id": 13,
                "type": "obj",
                "desc": "可以手动开始报警和手动结束报警",
            },
        ],
        "schemaExt": [{"id": 7, "inputStyle": "", "inputType": ""}],
    },
    "VdDGAJHYWVj62FGM": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "GQxEe5orh45cMgA6": {
        "schema": [
            {
                "mode": "rw",
                "code": "mode",
                "name": "喷雾",
                "property": {"range": ["1", "2", "3", "4"], "type": "enum"},
                "iconname": "icon-dp_box",
                "id": 2,
                "type": "obj",
                "desc": "关闭/连续/间断/倒计时",
            },
            {
                "mode": "ro",
                "code": "countdown_left",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "min",
                    "min": 0,
                    "max": 360,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 4,
                "type": "obj",
                "desc": "显示小时+分钟",
            },
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "灯光",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "灯光模式",
                "property": {
                    "range": ["close", "colorful", "white", "color"],
                    "type": "enum",
                },
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "顺序从左到右是关闭/七彩渐变/白光/定色\n其中定色和白光界面可以调节亮度。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光值",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["lack_water"], "type": "bitmap", "maxlen": 1},
                "iconname": "icon-yanse",
                "id": 9,
                "type": "obj",
                "desc": "缺水故障",
            },
            {
                "mode": "rw",
                "code": "wuhua",
                "name": "雾量",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "大喷雾/小喷雾",
            },
            {
                "mode": "rw",
                "code": "daojishi",
                "name": "倒计时",
                "property": {
                    "unit": "min",
                    "min": 0,
                    "max": 360,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "0-6小时",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
            {"id": 5, "inputStyle": "", "inputType": ""},
            {"id": 6, "inputStyle": "", "inputType": ""},
            {"id": 7, "inputStyle": "", "inputType": ""},
            {"id": 101, "inputStyle": "", "inputType": ""},
            {"id": 102, "inputStyle": "", "inputType": ""},
        ],
    },
    "zblsf6lkbcx19cwf": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music_data",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": "plain"},
            {"id": 21, "inputStyle": "", "inputType": "plain"},
            {"id": 22, "inputStyle": "", "inputType": "plain"},
            {"id": 23, "inputStyle": "", "inputType": "plain"},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "VEtey9k09k0A1ftr": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "power",
                "name": "power",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "插座开关",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
            {"id": 102, "inputStyle": "", "inputType": ""},
        ],
    },
    "1qhlrytqcpnqmzj7": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_control",
                "name": "开关控制",
                "property": {"range": ["on", "stop", "off"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "tr_timecon",
                "name": "行程时间配置",
                "property": {
                    "unit": "s",
                    "min": 10,
                    "max": 120,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "BlackLight",
                "name": "背光开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "背光可控",
            },
        ],
        "schemaExt": "[]",
    },
    "mzdqe6ectfdaarqr": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器开关",
            },
        ],
        "schemaExt": [
            {"complexType": "", "id": 1, "inputStyle": "", "inputType": ""},
            {"complexType": "", "id": 2, "inputStyle": "", "inputType": ""},
            {
                "complexType": "",
                "id": 3,
                "inputStyle": "bright",
                "inputType": "percent1",
            },
            {"complexType": "", "id": 4, "inputStyle": "temp", "inputType": "percent"},
            {"complexType": "", "id": 101, "inputStyle": "", "inputType": ""},
        ],
    },
    "vdLB09s3DgZ0s5Gk": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
        ],
    },
    "mdxN7u3QJWwifuIR": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "插座",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 11, "inputStyle": "", "inputType": ""},
            {"id": 101, "inputStyle": "", "inputType": ""},
        ],
    },
    "At6C3S6JYzp4ez1T": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "Wall Switch 1",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "m3dn9ck8f6qcn4hj": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器控制",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": "percent1"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "5zhtsrznc7nmk6pe": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ZAx1jolkKaiu8JtM": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "switch_power",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "confirm",
                "name": "确认",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "menu",
                "name": "菜单",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "up",
                "name": "上",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "down",
                "name": "下",
                "property": {"type": "bool"},
                "id": 105,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "left",
                "name": "左",
                "property": {"type": "bool"},
                "id": 106,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "right",
                "name": "右",
                "property": {"type": "bool"},
                "id": 107,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "volume_up",
                "name": "音量+",
                "property": {"type": "bool"},
                "id": 108,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "volume_down",
                "name": "音量-",
                "property": {"type": "bool"},
                "id": 109,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "zero",
                "name": "0",
                "property": {"type": "bool"},
                "id": 110,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "one",
                "name": "1",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "two",
                "name": "2",
                "property": {"type": "bool"},
                "id": 112,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "three",
                "name": "3",
                "property": {"type": "bool"},
                "id": 113,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "four",
                "name": "4",
                "property": {"type": "bool"},
                "id": 114,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "five",
                "name": "5",
                "property": {"type": "bool"},
                "id": 115,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "six",
                "name": "6",
                "property": {"type": "bool"},
                "id": 116,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "seven",
                "name": "7",
                "property": {"type": "bool"},
                "id": 117,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "eight",
                "name": "8",
                "property": {"type": "bool"},
                "id": 118,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "nine",
                "name": "9",
                "property": {"type": "bool"},
                "id": 119,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "mute",
                "name": "静音",
                "property": {"type": "bool"},
                "id": 120,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "signal",
                "name": "信号源",
                "property": {"type": "bool"},
                "id": 121,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "back",
                "name": "返回",
                "property": {"type": "bool"},
                "id": 122,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "main_page",
                "name": "主页",
                "property": {"type": "bool"},
                "id": 123,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "underline",
                "name": "-/--",
                "property": {"type": "bool"},
                "id": 124,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "volume",
                "name": "音量",
                "property": {"type": "bool"},
                "id": 125,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "h5xA1HckHwEeD1kK": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "ocz3kopwgtw1bfbg": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "iconname": "icon-qiangli",
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "iconname": "icon-a_mode_basement",
                "id": 2,
                "type": "raw",
                "desc": "用于学习功能数据上报",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-tianjia",
                "id": 3,
                "type": "obj",
                "desc": "用于搭配按键参数解码使用",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键同时下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "namu1lshm4jrx1td": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "设备重启状态设置",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "iconname": "icon-dp_filter",
                "id": 39,
                "type": "obj",
                "desc": "0：断电；\n1：通电；\n2：记忆继电器上次状态",
            },
        ],
        "schemaExt": "[]",
    },
    "qge4qpgtumbnuxi6": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "xw0AjeWMmnX0LX7Z": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-liangdu",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "8QMq5QyBkZDiA8ME": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "fiuqhs9hunjfciaa": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_location",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music_data",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": " "},
            {"id": 21, "inputStyle": "", "inputType": " "},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "OIQxvj501JCGs6f0": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "AqHUMdcbYzIq1Of4": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "8ckpglK8mI3k5DYP": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 9, "inputStyle": "", "inputType": ""},
            {"id": 10, "inputStyle": "", "inputType": ""},
        ],
    },
    "ai7xkvpibn4gqbxt": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_powe",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光颜色",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-shoucang",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_nav_timer",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "music_data",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_mic",
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "PgYTCERTyCGCvajE": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "遥控器参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习按键下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习按键下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习按键下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "dmicpclxzikkrh1c": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "n9mt5pvhsis64b1r": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                        "music",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "增加音乐模式",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 101,
                "type": "obj",
                "desc": "音乐灯",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "Wj0vLiKhSxCZoW4w": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "4kheilyfiyazqpda": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": " "},
            {"id": 21, "inputStyle": "", "inputType": " "},
            {"id": 22, "inputStyle": "", "inputType": " "},
            {"id": 23, "inputStyle": "", "inputType": " "},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "Y2RXPYYDE9L0JRR8": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "WBrr8aqLeGaXv97z": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"complexType": "", "id": 1, "inputStyle": "", "inputType": " "},
            {"complexType": "", "id": 2, "inputStyle": "", "inputType": " "},
            {"complexType": "", "id": 3, "inputStyle": "", "inputType": " "},
            {"complexType": "", "id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "yAimpd7WEEwBi5wj": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "mPRaDY6QmEFXOTYm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 7, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "fKaXCEjLKZzUQNuA": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": "percent1"},
            {"id": 4, "inputStyle": "", "inputType": "percent1"},
        ],
    },
    "dik6z7of4nailf94": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music_data",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": " "},
            {"id": 21, "inputStyle": "", "inputType": " "},
            {"id": 22, "inputStyle": "", "inputType": " "},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "ufX6necFyMftrpih": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 11, "inputStyle": "", "inputType": " "},
        ],
    },
    "0snqC46oHpBMHZ8c": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 3, "inputStyle": "", "inputType": ""}],
    },
    "ptvX5BkawcG0ALkB": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "MOUdSQdkHy5EaV1l": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "guKRJOrrnLmdFqSI": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "Y57x9TGtsWrPjCC8": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "EJmr55ci0szFxP4x": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "BoAR5oJ8NASFBknO": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": "plain"},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "KIId874l3357QvWO": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "AUhqobAr15oIfEaL": {
        "schema": [
            {
                "mode": "ro",
                "code": "alarm",
                "name": "报警",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "电池电量",
                "property": {
                    "unit": "0.01v",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "false",
                "name": "取消报警",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "fwmrrplqzjxunvmm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 9, "inputStyle": "", "inputType": ""},
            {"id": 10, "inputStyle": "", "inputType": ""},
            {"id": 11, "inputStyle": "", "inputType": ""},
        ],
    },
    "zysiizskwm4oib1o": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 15,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 9, "inputStyle": "", "inputType": ""},
            {"id": 15, "inputStyle": "", "inputType": ""},
            {"id": 17, "inputStyle": "", "inputType": ""},
            {"id": 18, "inputStyle": "", "inputType": ""},
            {"id": 19, "inputStyle": "", "inputType": ""},
            {"id": 20, "inputStyle": "", "inputType": ""},
        ],
    },
    "a6fmwrcqhc333lso": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关 2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "倒计时 2",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "倒计时 1",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "s6ohyhbpec9nxwam": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "基本-录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "基本-视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测-灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "rw",
                "code": "basic_nightvision",
                "name": "基本-红外夜视",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 108,
                "type": "obj",
                "desc": "0:自动\n1:关\n2:开",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测-OSS上传",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动侦测-总开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "EQD8hAQw543vzh6O": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关 2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "倒计时2",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "倒计时1",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 6, "inputStyle": "", "inputType": ""}],
    },
    "dYn2mDKmgV2Zz2YX": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "情景灯开关",
                "property": {"type": "bool"},
                "iconname": "icon-deng",
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "情景灯模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_puzzle",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 29,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_mode",
                "id": 31,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_nav_function",
                "id": 32,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 33,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 34,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 35,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 36,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 29, "inputStyle": "", "inputType": ""}],
    },
    "YydZ2mQ3N5XkChex": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "66mNaBqLdsYhX5lA": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "nlxvjzy1hoeiqsg6": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用于wifi遥控器控制",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": "percent1"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "aiZa7igM16QciSZm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ON0fHlAaAf7Pt7ja": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "继电器上电状态",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "0：断电； 1：通电； 2：记忆继电器上次状态",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 101, "inputStyle": "", "inputType": " "},
            {"id": 102, "inputStyle": "", "inputType": " "},
        ],
    },
    "iapdgbaik9riugyn": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "CHLZe9HQ6QIXujVN": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 11, "inputStyle": "", "inputType": " "},
        ],
    },
    "gDYvLrWhRoqpgHMj": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 3000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "bqkefojbmb8ovvws": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "zY4uzKMEbqCjexxB": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            }
        ],
        "schemaExt": [{"id": 1, "inputStyle": "", "inputType": "plain"}],
    },
    "KhmRHEepuxV8ALfR": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "DYgId0sz6zWlmmYu": {
        "schema": [
            {
                "mode": "ro",
                "code": "BatteryStatus",
                "name": "电量状态",
                "property": {"range": ["0", "1", "2", "3", "4"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "0：满电\n1：高\n2：中\n3：低\n4：外电",
            },
            {
                "mode": "rw",
                "code": "Alarmtype",
                "name": "声音类型",
                "property": {
                    "range": ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10"],
                    "type": "enum",
                },
                "id": 102,
                "type": "obj",
                "desc": "每一种代表一种声音",
            },
            {
                "mode": "rw",
                "code": "AlarmPeriod",
                "name": "报警时长",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 60,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "AlarmSwitch",
                "name": "报警开关",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "koiGhMKwLf2ZP81g": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "KFAHKrKO9XTIV1V4": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "Ks4CzAJZxASSBCGZ": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flashscreen",
                "name": "新场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_house",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
        ],
    },
    "bh5X1lLgLopti7GD": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "继电器上电状态",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "上电后 开或  关 或 记忆断电前状态\n0 上电默认关\n1 上电默认开\n2 上电后执行断电前的状态",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 101, "inputStyle": "", "inputType": " "},
            {"id": 102, "inputStyle": "", "inputType": " "},
        ],
    },
    "3bRKXbBV747xjcKS": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 7, "inputStyle": "", "inputType": " "},
        ],
    },
    "isehgkqn5uqlrorl": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "2EzYjcFvB3W5mXuK": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "aajluzkxkuc7tyt8": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "6l4vhjl3gttstgxj": {
        "schema": [
            {
                "mode": "ro",
                "code": "status",
                "name": "开关状态",
                "property": {"range": ["open", "closed"], "type": "enum"},
                "iconname": "icon-dp_direction",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "BatteryStatus",
                "name": "电池电量",
                "property": {"range": ["0x00", "0x01", "0x02", "0x03"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "QONMSadFAkTBFBWx": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "fnxgcsysunpyxkou": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "3wqoo7xfysvsw0io": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "9kkmllwwbzyqltud": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": ""},
            {"id": 21, "inputStyle": "", "inputType": ""},
            {"id": 22, "inputStyle": "", "inputType": ""},
            {"id": 23, "inputStyle": "", "inputType": ""},
            {"id": 26, "inputStyle": "", "inputType": "countdown1"},
        ],
    },
    "rozAuCvPcosV08Ub": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "na6bptfele0ud6vy": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "基本-录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "基本-视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测-灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "移动侦测-定时设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测-OSS上传",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动侦测-总开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "移动侦测-模式选择",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "decibel_switch",
                "name": "分贝检测-总开关",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_sensitivity",
                "name": "分贝检测-灵敏度",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 140,
                "type": "obj",
                "desc": "0代表低灵敏度；1代表高灵敏度",
            },
            {
                "mode": "ro",
                "code": "decibel_upload",
                "name": "分贝检测-消息上报",
                "property": {"type": "string", "maxlen": 255},
                "id": 141,
                "type": "obj",
                "desc": "用于报警消息推送，app上会显示通知",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "mS9jU62HAUqkb1hX": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputStyle": "", "inputType": "percent1"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "a0mxFFmru5VGva7D": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "c4vOAfTrLDTEpCQZ": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "sensor",
                "name": "红外感应",
                "property": {
                    "range": [
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        "10",
                        "11",
                        "12",
                        "13",
                        "14",
                        "15",
                        "16",
                        "17",
                        "18",
                        "19",
                        "20",
                        "21",
                        "22",
                        "23",
                        "24",
                        "25",
                        "26",
                        "27",
                        "28",
                    ],
                    "type": "enum",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": "plain"},
            {"id": 4, "inputStyle": "", "inputType": "plain"},
            {"id": 101, "inputStyle": "", "inputType": " "},
        ],
    },
    "PGEkBctAbtzKOZng": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "so7sjGbNSkfGrXpn": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "I7N6VHzXnHjWTUgC": {
        "schema": [
            {
                "mode": "ro",
                "code": "upward",
                "name": "上行通道",
                "id": 101,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "down",
                "name": "下行通道",
                "id": 102,
                "type": "raw",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "fwxhqpwf": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_powe",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {"range": ["white"], "type": "enum"},
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-liangdu1",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "QP2puy93gbcNET5G": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": "percent1"},
            {"id": 4, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "zPvuY6QOEuemAlR6": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "pair_cmd",
                "name": "配对",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "clear_cmd",
                "name": "清除",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "pair_result",
                "name": "配对结果",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "clear_result",
                "name": "清除结果",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 105, "inputStyle": "", "inputType": ""},
        ],
    },
    "bot6weidzztn4m4e": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习上报参数",
                "id": 2,
                "type": "raw",
                "desc": "用于学习功能数据上报",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "遥控器解码参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "用于搭配按键参数解码使用",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键同时下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "FvuqtppKLqZ548sI": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "基本-状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "基本-录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "基本-视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测上报",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动侦测开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "xvsgeeru2i5wsd0y": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-HomeArm",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "urnj8q3elryarlan": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "开关机控制。\n下发： 发送控制指令给主机，主机依据指令状态进行开关机操作。\n上报：\n当主机使用遥控器关机或者长时间静止进入关机状态后，主机会上报一个关机数据。\n当主机处于关机状态时，通过遥控器或者触摸主机的按键，主机会进入开机状态，主机会上报一个开机数据。",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {
                    "label": [
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        "10",
                        "11",
                        "12",
                        "13",
                        "14",
                    ],
                    "type": "bitmap",
                    "maxlen": 14,
                },
                "id": 11,
                "type": "obj",
                "desc": "0:无报警1:主动轮过载 2:前跌落触发 3:左跌落触发 4:右跌落触发 5:机器离地 6:左碰撞卡住 7:右碰撞卡住 8:边刷缠绕 9:电量低于20% 10:尘盒未安装 11:风扇异常 12:滚刷异常 13:电池故障14:水箱未安装",
            },
            {
                "mode": "ro",
                "code": "electricity_left",
                "name": "电量",
                "property": {
                    "unit": "％",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 14,
                "type": "obj",
                "desc": "机器定时上报电量百分比， 0% - 100%",
            },
            {
                "mode": "rw",
                "code": "power_go",
                "name": "清扫开关",
                "property": {"type": "bool"},
                "id": 25,
                "type": "obj",
                "desc": "0:暂停 1:工作",
            },
            {
                "mode": "rw",
                "code": "direction_control",
                "name": "清扫方向",
                "property": {
                    "range": ["foward", "backward", "turn_left", "turn_right", "stop"],
                    "type": "enum",
                },
                "id": 26,
                "type": "obj",
                "desc": "前／后／左／右／停",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "standby",
                        "smart",
                        "spiral",
                        "single",
                        "wall_follow",
                        "chargego",
                    ],
                    "type": "enum",
                },
                "id": 27,
                "type": "obj",
                "desc": "空闲模式（清除选中）、自动模式、定点模式、单间模式、沿边模式、回充模式",
            },
            {
                "mode": "ro",
                "code": "status",
                "name": "工作状态",
                "property": {
                    "range": [
                        "standby",
                        "working",
                        "fault",
                        "sleep",
                        "workcompleted",
                        "charging",
                        "chargecompleted",
                        "pause",
                    ],
                    "type": "enum",
                },
                "id": 28,
                "type": "obj",
                "desc": "0: 待机 1: 工作中 2: 故障 3: 休眠 4: 工作完成 5: 充电 6: 充电完成 7:暂停",
            },
            {
                "mode": "wr",
                "code": "seek",
                "name": "定位机器人",
                "property": {"type": "bool"},
                "id": 29,
                "type": "obj",
                "desc": "App触发下发1",
            },
            {
                "mode": "rw",
                "code": "suction",
                "name": "清扫强度",
                "property": {"range": ["low", "normal", "high"], "type": "enum"},
                "id": 30,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "voice_switch",
                "name": "静音",
                "property": {"type": "bool"},
                "id": 31,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "clean_area",
                "name": "清扫面积",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 32,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "clean_time",
                "name": "清扫时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 300,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 33,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "clean_record",
                "name": "清扫记录",
                "property": {"type": "string", "maxlen": 255},
                "id": 34,
                "type": "obj",
                "desc": '清扫日期YYYYMMDDTTRR + 清扫时长XXX + 清扫面积XXX + 地图IDXXXXX 如： "20180411051102008000020" 代表2018年4月11日05点11分，清扫了20分钟，80平方米 ，id号为20 （假如MCU没有RTC，时间可不上报。记录则默认显示为数据上报时间）',
            },
        ],
        "schemaExt": "[]",
    },
    "di6v3qfv0sqo98bl": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "WindSpeed",
                "name": "风速",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "iconname": "icon-dp_wind",
                "id": 2,
                "type": "obj",
                "desc": "1-3级风速。可根据产品实际功能进行修改。",
            },
            {
                "mode": "rw",
                "code": "Windmode",
                "name": "风类",
                "property": {"range": ["standard", "sleep", "natural"], "type": "enum"},
                "iconname": "icon-dp_shake",
                "id": 3,
                "type": "obj",
                "desc": "标准风，睡眠风，自然风  开机默认是标准风",
            },
            {
                "mode": "rw",
                "code": "Windleftright",
                "name": "水平风",
                "property": {"type": "bool"},
                "iconname": "icon-dp_loop",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Timer",
                "name": "倒计时",
                "property": {
                    "range": [
                        "0",
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        "10",
                        "11",
                        "12",
                        "13",
                        "14",
                        "15",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "0:取消；0.5-7.5小时。可根据产品实际功能进行修改。",
            },
            {
                "mode": "ro",
                "code": "Countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 450,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 12,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "xetudvgwjpn1sgra": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "tsg3ba81Ikah9NrR": {
        "schema": [
            {
                "mode": "ro",
                "code": "PIR",
                "name": "PIR",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "pir 检测",
            },
            {
                "mode": "ro",
                "code": "energy",
                "name": "供电形式",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "两种供电形式：电池供电；USB 供电",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "电池电量",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 10,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "mcu 上报电池电量",
            },
            {
                "mode": "ro",
                "code": "TamperedAlarm",
                "name": "防拆报警",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "mcu 上报拆除报警",
            },
        ],
        "schemaExt": "[]",
    },
    "XcEjMsAH7cZkAJiX": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "kJzrAKNnBznojWku": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "be0dlbfuaictfdin": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": "plain"},
            {"id": 21, "inputStyle": "", "inputType": " "},
            {"id": 22, "inputStyle": "", "inputType": "plain"},
            {"id": 23, "inputStyle": "", "inputType": "plain"},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "RGFFsVVstB8xf8Uo": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_all",
                "name": "总开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "总开关",
            },
        ],
        "schemaExt": "[]",
    },
    "0flijpvhn0bu2ojj": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-fengli",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "ylxwmwwkfkwhcxsv": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_set",
                "name": "目标温度",
                "property": {
                    "unit": "",
                    "min": 50,
                    "max": 950,
                    "scale": 1,
                    "step": 5,
                    "type": "value",
                },
                "iconname": "icon-dp_temp",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "temp_current",
                "name": "当前温度",
                "property": {
                    "unit": "",
                    "min": 50,
                    "max": 990,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_unit_convert",
                "name": "温标切换",
                "property": {"range": ["c", "f"], "type": "enum"},
                "id": 19,
                "type": "obj",
                "desc": "需要配合目标温度F和当前温度F使用",
            },
            {
                "mode": "rw",
                "code": "a_key_home",
                "name": "一键离家",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_switch",
                "name": "编程开关",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_mode",
                "name": "编程模式",
                "property": {"range": ["1", "2", "3", "4"], "type": "enum"},
                "id": 103,
                "type": "obj",
                "desc": "1 为 1天编程 1-7; \n2 为 2天编程 1-5、6-7; \n3 为 3 天编程 1-5、6、7； \n4 为 7 天编程 1、2、3、4、5、6、7",
            },
            {
                "mode": "rw",
                "code": "prog_data_1",
                "name": "编程数据（周一）",
                "id": 104,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_2",
                "name": "编程数据（周二）",
                "id": 105,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_3",
                "name": "编程数据（周三）",
                "id": 106,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_4",
                "name": "编程数据（周四）",
                "id": 107,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_5",
                "name": "编程数据（周五）",
                "id": 108,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_6",
                "name": "编程数据（周六）\t",
                "id": 109,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_7",
                "name": "编程数据（周日）",
                "id": 110,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "restriction",
                "name": "温度设置上下限设置",
                "id": 111,
                "type": "raw",
                "desc": "四个字节：\n00 01：上限\n02 03：下限",
            },
            {
                "mode": "ro",
                "code": "historical_week_set",
                "name": "历史数据协议（周-设定温度）",
                "id": 112,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_month_set",
                "name": "历史数据协议（月-设定温度）",
                "id": 113,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_year_set",
                "name": "历史数据协议（年-设定温度）",
                "id": 114,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_day_now",
                "name": "历史数据协议（日-当前温度）",
                "id": 115,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_week_now",
                "name": "历史数据协议（周-当前温度）",
                "id": 116,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_month_now",
                "name": "历史数据协议（月-当前温度）",
                "id": 117,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_year_now",
                "name": "历史数据协议（年-当前温度）",
                "id": 118,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_day_pow",
                "name": "历史数据协议（日-电机开度）",
                "id": 119,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_week_pow",
                "name": "历史数据协议（周-电机开度）",
                "id": 120,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_month_pow",
                "name": "历史数据协议（月-电机开度）",
                "id": 121,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_year_pow",
                "name": "历史数据协议（年-电机开度）",
                "id": 122,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "historical_day_set",
                "name": "历史数据协议（日-设定温度)",
                "id": 123,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data",
                "name": "编程数据",
                "id": 124,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "battery_power",
                "scope": "fault",
                "name": "电池电量报警",
                "property": {"label": ["1"], "type": "bitmap", "maxlen": 1},
                "id": 125,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "pair_code",
                "name": "设备对码",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 126,
                "type": "obj",
                "desc": "开始对码、对码成功、对码失败、未对码",
            },
            {
                "mode": "rw",
                "code": "set_temp",
                "name": "设置温度（第三方）",
                "property": {
                    "unit": "C",
                    "min": 5,
                    "max": 95,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 127,
                "type": "obj",
                "desc": "目标温度_Alexa专用 DP点",
            },
            {
                "mode": "ro",
                "code": "current_temp",
                "name": "当前温度（第三方）",
                "property": {
                    "unit": "C",
                    "min": 5,
                    "max": 99,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 128,
                "type": "obj",
                "desc": "当前温度_Alexa专用DP点",
            },
            {
                "mode": "ro",
                "code": "program_num",
                "name": "编程段数选择",
                "property": {"range": ["4", "6"], "type": "enum"},
                "id": 129,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ALnnLGkhjB3Bdlwo": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "n731jh0thvakiqov": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": "[]",
    },
    "gQU2utatG2zSHMEu": {
        "schema": [
            {
                "mode": "rw",
                "code": "power",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "开关机控制。\n下发： 发送控制指令给主机，主机依据指令状态进行开关机操作。\n上报：\n当主机使用遥控器关机或者长时间静止进入关机状态后，主机会上报一个关机数据。\n当主机处于关机状态时，通过遥控器或者触摸主机的按键，主机会进入开机状态，主机会上报一个开机数据。",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {
                    "label": ["1", "2", "3", "4", "5", "6", "7", "8"],
                    "type": "bitmap",
                    "maxlen": 8,
                },
                "id": 11,
                "type": "obj",
                "desc": "0 正常；1边扫异常；2中扫异常；3左轮异常；4右轮异常；5垃圾盒异常；6 地检异常；7 碰撞异常；8其它问题\n当主机上报后，显示错误代码，当上报0后，清楚显示。",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "工作模式",
                "property": {
                    "range": ["smart", "wallfollow", "mop", "chargego", "sprial"],
                    "type": "enum",
                },
                "id": 25,
                "type": "obj",
                "desc": "1:自动清扫\n2:沿边清扫\n3:拖地功能\n4:自动充电\n5:定点清扫（新增项）",
            },
            {
                "mode": "rw",
                "code": "directioncontrol",
                "name": "清扫方向",
                "property": {
                    "range": ["forward", "backward", "turnleft", "turnright", "stop"],
                    "type": "enum",
                },
                "id": 26,
                "type": "obj",
                "desc": "前进，后退，左转，右转，停止。\n默认逻辑：按住方向键下发 前/后/左转/右转，手指抬起下发停止",
            },
            {
                "mode": "rw",
                "code": "suck",
                "name": "吸力选择",
                "property": {"range": ["strong", "normal"], "type": "enum"},
                "id": 27,
                "type": "obj",
                "desc": "0: 强力 / 1:常规",
            },
            {
                "mode": "rw",
                "code": "power_go",
                "name": "清扫开关",
                "property": {"type": "bool"},
                "id": 33,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "Equipment_state",
                "name": "当前状态",
                "property": {
                    "range": ["0", "1", "2", "3", "4", "5", "6"],
                    "type": "enum",
                },
                "id": 38,
                "type": "obj",
                "desc": "状态指示\n0：待机中\n1：自动清扫\n2：拖地\n3：沿边清扫\n4：回充中\n5：充电\n6：定点清扫",
            },
            {
                "mode": "ro",
                "code": "electricity_left",
                "name": "剩余电量",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 39,
                "type": "obj",
                "desc": "剩余电量显示",
            },
            {
                "mode": "ro",
                "code": "Clean_record",
                "name": "清扫记录",
                "property": {"type": "string", "maxlen": 255},
                "id": 40,
                "type": "obj",
                "desc": '清扫时长 +\nXXX\n清扫面积\nxxx\n清扫日期（如有）+\nYYYYMMDD\n清扫时间（如有）+\nhhmm\n如：\n"020080201804110800"\n代表清扫了20分钟，80平方米，清扫日期2018年4月11日，清扫时间8:00\n',
            },
            {
                "mode": "ro",
                "code": "Clean_area",
                "name": "清扫面积",
                "property": {
                    "unit": "㎡",
                    "min": 0,
                    "max": 9999,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 41,
                "type": "obj",
                "desc": "MCU上报本次清扫面积，实时更新\n",
            },
            {
                "mode": "ro",
                "code": "Clean_time",
                "name": "清扫时间",
                "property": {
                    "unit": "分",
                    "min": 0,
                    "max": 9999,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 42,
                "type": "obj",
                "desc": "MCU上报本次清扫时间，实时更新\n",
            },
            {
                "mode": "rw",
                "code": "volume",
                "name": "音量设置",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 43,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "song",
                "name": "声音开关",
                "property": {"type": "bool"},
                "id": 44,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 25, "inputStyle": "", "inputType": ""},
            {"id": 26, "inputStyle": "", "inputType": ""},
            {"id": 27, "inputStyle": "", "inputType": ""},
            {"id": 33, "inputStyle": "", "inputType": ""},
            {"id": 38, "inputStyle": "", "inputType": ""},
            {"id": 39, "inputStyle": "", "inputType": ""},
            {"id": 41, "inputStyle": "", "inputType": ""},
            {"id": 42, "inputStyle": "", "inputType": ""},
            {"id": 43, "inputStyle": "", "inputType": ""},
            {"id": 44, "inputStyle": "", "inputType": ""},
        ],
    },
    "U5UspDZNicoNCKO2": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": "[]",
    },
    "1AoxHItVqleAF6vy": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 10, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
            {"id": 18, "inputStyle": "", "inputType": ""},
            {"id": 19, "inputStyle": "", "inputType": ""},
            {"id": 20, "inputStyle": "", "inputType": ""},
            {"id": 21, "inputStyle": "", "inputType": ""},
            {"id": 22, "inputStyle": "", "inputType": ""},
            {"id": 23, "inputStyle": "", "inputType": ""},
            {"id": 24, "inputStyle": "", "inputType": ""},
            {"id": 25, "inputStyle": "", "inputType": ""},
        ],
    },
    "ufq2xwuzd4nb0qdr": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "remote_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "用在控制wifi遥控器",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": ""},
            {"id": 21, "inputStyle": "", "inputType": ""},
            {"id": 22, "inputStyle": "", "inputType": "percent1"},
            {"id": 23, "inputStyle": "", "inputType": "percent"},
            {"id": 26, "inputStyle": "", "inputType": ""},
        ],
    },
    "4D47uCTGNqKBSdHm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch",
                "name": "开关",
                "property": {"range": ["open", "stop", "close"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "打开窗帘：open；停止：stop；关闭窗帘：close",
            },
            {
                "mode": "rw",
                "code": "state",
                "name": "位置百分比",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "窗帘的开启程度百分比呈现，0%——100%\n全开为：0%；\n全关为：100%",
            },
            {
                "mode": "rw",
                "code": "Reverse",
                "name": "电机反转",
                "property": {"type": "bool"},
                "id": 107,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Handpulled",
                "name": "手拉启动",
                "property": {"type": "bool"},
                "id": 108,
                "type": "obj",
                "desc": "00关\n01开",
            },
            {
                "mode": "ro",
                "code": "route",
                "scope": "fault",
                "name": "行程设置提醒",
                "property": {"type": "bool"},
                "id": 109,
                "type": "obj",
                "desc": "行程设置提醒，上报1的时候表示已经进行行程设置。上报0表示没设置。行程设置：需要完整开关窗帘一次。",
            },
        ],
        "schemaExt": "[]",
    },
    "kckzepzcfqvfckzt": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "i6bAFxm8xMj5WmLK": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "遥控器参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习按键下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习按键下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习按键下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "hb4CGjpjH3hfWcEY": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "switch_power",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "confirm",
                "name": "确认",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "channel_up",
                "name": "频道+",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "channel_down",
                "name": "频道-",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "menu",
                "name": "菜单",
                "property": {"type": "bool"},
                "id": 105,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "up",
                "name": "上",
                "property": {"type": "bool"},
                "id": 106,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "down",
                "name": "下",
                "property": {"type": "bool"},
                "id": 107,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "left",
                "name": "左",
                "property": {"type": "bool"},
                "id": 108,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "right",
                "name": "右",
                "property": {"type": "bool"},
                "id": 109,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "volume_up",
                "name": "音量+",
                "property": {"type": "bool"},
                "id": 110,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "volume_down",
                "name": "音量-",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "zero",
                "name": "0",
                "property": {"type": "bool"},
                "id": 112,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "one",
                "name": "1",
                "property": {"type": "bool"},
                "id": 113,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "two",
                "name": "2",
                "property": {"type": "bool"},
                "id": 114,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "three",
                "name": "3",
                "property": {"type": "bool"},
                "id": 115,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "four",
                "name": "4",
                "property": {"type": "bool"},
                "id": 116,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "five",
                "name": "5",
                "property": {"type": "bool"},
                "id": 117,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "six",
                "name": "6",
                "property": {"type": "bool"},
                "id": 118,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "seven",
                "name": "7",
                "property": {"type": "bool"},
                "id": 119,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "eight",
                "name": "8",
                "property": {"type": "bool"},
                "id": 120,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "nine",
                "name": "9",
                "property": {"type": "bool"},
                "id": 121,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "mute",
                "name": "静音",
                "property": {"type": "bool"},
                "id": 122,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "back",
                "name": "返回",
                "property": {"type": "bool"},
                "id": 123,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "alternate",
                "name": "交替",
                "property": {"type": "bool"},
                "id": 124,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "underline",
                "name": "-/--",
                "property": {"type": "bool"},
                "id": 125,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "volume",
                "name": "音量",
                "property": {"type": "bool"},
                "id": 126,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ja9syyuzz4pbctg3": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "6ASdNwe9IdaewQEl": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "总开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Light",
                "name": "灯光",
                "property": {"type": "bool"},
                "iconname": "icon-dp_light",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["1"], "type": "bitmap", "maxlen": 1},
                "iconname": "icon-dp_warming",
                "id": 12,
                "type": "obj",
                "desc": "缺水故障",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "iconname": "icon-dp_time2",
                "id": 13,
                "type": "obj",
                "desc": "0:ON；1：1小时；2：3小时；3：6小时。可根据产品实际功能进行设置。",
            },
            {
                "mode": "ro",
                "code": "countdown_left",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 360,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 14,
                "type": "obj",
                "desc": "mcu每分钟上报",
            },
            {
                "mode": "rw",
                "code": "dp_mist_grade",
                "name": "雾量",
                "property": {"range": ["small", "big", "off"], "type": "enum"},
                "id": 103,
                "type": "obj",
                "desc": "小喷雾，大喷雾,关闭",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "id": 108,
                "type": "obj",
                "desc": 'Value: ”00112233334455”（长度为 14 的字符串） 00: R 11: G 22: B 3333: H(色调 Hue) 44: S(饱和度 Saturation) 55: V(明度 Value) 示例： {"2700000000ff27"}',
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene1",
                        "scene2",
                        "scene3",
                        "scene4",
                    ],
                    "type": "enum",
                },
                "id": 109,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "lightmode",
                "name": "灯光模式",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 110,
                "type": "obj",
                "desc": "1：七彩循环；2：定色；3：夜灯",
            },
            {
                "mode": "rw",
                "code": "setlight",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 111,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "etvtak6npdvd0vg6": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "7PaAvp4fA5nhxIUh": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "jjwg6bVTD6wizPJb": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "4UgcieKnG0gd3jO7": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ylr9R01cMWnMRqEB": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                        "music",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "增加音乐模式",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 101,
                "type": "obj",
                "desc": "音乐灯",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "hgzylixd73iycsnk": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "3HJjEy5GAr6FoURb": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 9, "inputStyle": "", "inputType": ""},
            {"id": 10, "inputStyle": "", "inputType": ""},
        ],
    },
    "xRLBlgDAoYJP2Edx": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "单插开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": "[]",
    },
    "rsAWAQ7wV3zTzcmG": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flashscreen",
                "name": "新场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_house",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
        ],
    },
    "zWqOK04ovOjw0Pcw": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "继电器上电状态",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "0：断电； 1：通电； 2：记忆继电器上次状态",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 102, "inputStyle": "", "inputType": ""}],
    },
    "x9nmfcaphvbxasgc": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "基本-录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "基本-视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测-灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测-OSS上传",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "ro",
                "code": "doorbell_active",
                "name": "门铃-呼叫",
                "property": {"type": "string", "maxlen": 255},
                "id": 136,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "wireless_electricity",
                "name": "低功耗-电池电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 100,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 145,
                "type": "obj",
                "desc": "设备主动上报当前电量，电量发生变化时上报。类型为数值型，上报0-100的整数。app会处理成百分比。\n",
            },
            {
                "mode": "ro",
                "code": "wireless_powermode",
                "name": "低功耗-供电方式",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 146,
                "type": "obj",
                "desc": "设备主动上报当前供电状态，供电状态发生变化时上报。0为电池供电状态，1为插电供电状态（或电池充电状态）",
            },
            {
                "mode": "rw",
                "code": "wireless_lowpower",
                "name": "低功耗-低电报警",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 50,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 147,
                "type": "obj",
                "desc": "若电量百分比低于该阈值，则触发报警；App端设置，设备本身无须关心该dp点。",
            },
            {
                "mode": "rw",
                "code": "wireless_awake",
                "name": "低功耗-唤醒状态",
                "property": {"type": "bool"},
                "id": 149,
                "type": "obj",
                "desc": "设备主动上报当前低功耗是否处于唤醒状态。类型为布尔型，True为唤醒状态，false为休眠状态。（设备休眠前上报false，设备唤醒后上报一次True）",
            },
            {
                "mode": "rw",
                "code": "pir_switch",
                "name": "PIR开关及灵敏度",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 152,
                "type": "obj",
                "desc": "0关闭，1灵敏度低，2灵敏度中，3灵敏度高",
            },
            {
                "mode": "ro",
                "code": "doorbell_pic",
                "name": "门铃-抓拍图片",
                "id": 154,
                "type": "raw",
                "desc": "用户按下门铃，抓拍图片并上传",
            },
        ],
        "schemaExt": "[]",
    },
    "lo8wdsdvhchvcbsn": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_4",
                "name": "开关4",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown4",
                "name": "开关4倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "XxN1tzvUbJ0eyYMY": {
        "schema": [
            {
                "mode": "ro",
                "code": "status",
                "name": "Smoke Alarm",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "BatteryStatus",
                "name": "Battery",
                "property": {"range": ["0x00", "0x01", "0x02", "0x03"], "type": "enum"},
                "id": 104,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "hx5ztlztij4yxxvg": {
        "schema": [
            {
                "mode": "ro",
                "code": "doorcontact_state",
                "name": "门磁",
                "property": {"type": "bool"},
                "iconname": "icon-zanting",
                "id": 1,
                "type": "obj",
                "desc": "【必选】",
            },
            {
                "mode": "ro",
                "code": "battery_state",
                "name": "电池电量状态",
                "property": {"range": ["low", "middle", "high"], "type": "enum"},
                "id": 3,
                "type": "obj",
                "desc": "【非必选】",
            },
        ],
        "schemaExt": "[]",
    },
    "dfl0ubhyhaaq5swo": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "iconname": "icon-qiangli",
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "iconname": "icon-a_mode_basement",
                "id": 2,
                "type": "raw",
                "desc": "用于学习功能数据上报",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-tianjia",
                "id": 3,
                "type": "obj",
                "desc": "用于搭配按键参数解码使用",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键同时下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "XN75LPulKjK0xTEs": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                        "music",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "增加音乐模式",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 101,
                "type": "obj",
                "desc": "音乐灯",
            },
        ],
        "schemaExt": "[]",
    },
    "77wjoyOTO0FzHRVm": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 3, "inputStyle": "", "inputType": "percent1"},
            {"id": 4, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "eo8zo3xdaqa0z7en": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "rgccowxgmkbe22gv": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "设备重启状态设置",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "iconname": "icon-dp_filter",
                "id": 39,
                "type": "obj",
                "desc": "0：断电；\n1：通电；\n2：记忆继电器上次状态",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
            {"id": 39, "inputStyle": "", "inputType": " "},
        ],
    },
    "jaqpf2gLCUmF7vXw": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "uitfiejlqezmwdnj": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "EYfNTuTPZln9e4cn": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "rvt5ohucbhs87wbi": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "sMk7hhVsN5KBWbwV": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "ql60m7wvk4ucjdvi": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "5vorxbbzvavwrrqs": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "继电器上电状态",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "0：断电； 1：通电； 2：记忆继电器上次状态",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "NlwoInNnQAXJ0UxR": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "pv2zrvn7vsmk0qax": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "FuhWeUBUbJpBgFnT": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "4yAeyq4rvK8AyH34": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_all",
                "name": "全部开关控制",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "0:全关；1:全开",
            },
        ],
        "schemaExt": [{"id": 5, "inputStyle": "", "inputType": ""}],
    },
    "C49XTQAxAWzQZRNL": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "zmuquaytzuth4gkp": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "kwh",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "iconname": "icon-baojing",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "oCveFaOsA0fyAB4C": {
        "schema": [
            {
                "mode": "ro",
                "code": "WaterLeakage",
                "name": "溢水检测器",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "True - Alarm On\nFALSE - Alarm Off",
            },
            {
                "mode": "ro",
                "code": "BatteryStatus",
                "name": "电池电量",
                "property": {"range": ["0x00", "0x01", "0x02", "0x03"], "type": "enum"},
                "id": 102,
                "type": "obj",
                "desc": "0x00 - Battery Full\n0x01 - Battery High\n0x02 - Battery Low\n0x03 - Battery Dead",
            },
        ],
        "schemaExt": "[]",
    },
    "41w4nwd6qj85b2gw": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
        ],
    },
    "x24s3v3iv4ehxzup": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "backLedControl",
                "name": "背光开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "aztncqeanw9yj8rt": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "backLedControl",
                "name": "背光开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "sjcgmr9bqubfjeis": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 10, "inputStyle": "", "inputType": " "},
        ],
    },
    "hj0a5c7ckzzexu8l": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": "plain"},
            {"id": 17, "inputStyle": "", "inputType": " "},
            {"id": 18, "inputStyle": "", "inputType": ""},
            {"id": 19, "inputStyle": "", "inputType": ""},
            {"id": 20, "inputStyle": "", "inputType": ""},
            {"id": 21, "inputStyle": "", "inputType": ""},
            {"id": 22, "inputStyle": "", "inputType": ""},
            {"id": 23, "inputStyle": "", "inputType": ""},
            {"id": 24, "inputStyle": "", "inputType": ""},
            {"id": 25, "inputStyle": "", "inputType": ""},
        ],
    },
    "pxphdeyqak8mxld4": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "aswMJsr7svx632Ra": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_4",
                "name": "开关4",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_4",
                "name": "开关4倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 12,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 15,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 9, "inputStyle": "", "inputType": ""},
            {"id": 10, "inputStyle": "", "inputType": ""},
            {"id": 11, "inputStyle": "", "inputType": ""},
            {"id": 12, "inputStyle": "", "inputType": ""},
            {"id": 15, "inputStyle": "", "inputType": ""},
        ],
    },
    "4nqs33emdwJxpQ8O": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "OzuEOxOGFha5cP2Z": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 11,
                "type": "obj",
                "desc": "可根据产品实际倒计时功能修改。",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 11, "inputStyle": "", "inputType": " "},
        ],
    },
    "9ivirni8wemum6cw": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "7by9ERqg60JA8wxA": {
        "schema": [
            {
                "mode": "ro",
                "code": "switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "上报门窗开关状态",
            },
            {
                "mode": "ro",
                "code": "Battery",
                "name": "电池电量",
                "property": {
                    "unit": "0.01v",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "mcu 上报电池电量信息，电压值*100，0--4.00v",
            },
        ],
        "schemaExt": "[]",
    },
    "IqSNPuPZIdL4jPz2": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "aa8l2jbp1jmmo99g": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "i6DOIjfTcNwwQNwC": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "pL8QxbxE1AnaIzqG": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "bOimjWqpRgaUUSkY": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "WuAAxvnzt9V5HYLm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大1000倍之后的值，即上报56，实际值为0.056度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
            {"id": 5, "inputStyle": "", "inputType": ""},
            {"id": 6, "inputStyle": "", "inputType": ""},
        ],
    },
    "KAdtK5c9HAC13vvM": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "7e4azRqXX7huIDvh": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "kjbMbjg6MCr5T28o": {
        "schema": [
            {
                "mode": "rw",
                "code": "Switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Lock",
                "name": "童锁",
                "property": {"type": "bool"},
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Temp_set",
                "name": "温度",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 37,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "Temp_current",
                "name": "当前温度",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 99,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Timer",
                "name": "倒计时",
                "property": {
                    "unit": "min",
                    "min": 0,
                    "max": 1440,
                    "scale": 0,
                    "step": 60,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "FAULT",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["E1"], "type": "bitmap", "maxlen": 1},
                "id": 6,
                "type": "obj",
                "desc": "E1:温度探头故障",
            },
        ],
        "schemaExt": "[]",
    },
    "juqfgowpbqcmeg6s": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制",
                "property": {"range": ["open", "stop", "close"], "type": "enum"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "percent_control",
                "name": "开启百分比控制",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "percent_state",
                "name": "开启百分比状态",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_warming",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "readyCal",
                "name": "已完成校准",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "如果未校准  app进度条显示灰色 不可用 已校准显示为可用",
            },
            {
                "mode": "rw",
                "code": "childLock",
                "name": "童锁",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "童锁开关",
            },
            {
                "mode": "rw",
                "code": "backLedSwitch",
                "name": "背光灯开关",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "背光灯开关",
            },
            {
                "mode": "rw",
                "code": "calControl",
                "name": "校准控制",
                "property": {"range": ["1", "2", "3"], "type": "enum"},
                "id": 104,
                "type": "obj",
                "desc": "校准控制 1 校准开始 2校准结束 3 取消校准",
            },
            {
                "mode": "rw",
                "code": "calTime",
                "name": "校准时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 1000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "校准时间即完全打开到完全关闭的时间\n用户知道时间可以直接设置  不知道时间时需要校准  ",
            },
            {
                "mode": "rw",
                "code": "clear",
                "name": "清除校准数据",
                "property": {"type": "bool"},
                "id": 106,
                "type": "obj",
                "desc": "清除校准数据",
            },
        ],
        "schemaExt": "[]",
    },
    "PBIklxk8MhM0dYND": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "4ukfkbat42snwtd8": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": ""},
            {"id": 21, "inputStyle": "", "inputType": ""},
            {"id": 22, "inputStyle": "", "inputType": ""},
            {"id": 26, "inputStyle": "", "inputType": "countdown1"},
        ],
    },
    "wce69x1jxCwHCepx": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "基本-录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "基本-视频osd功能",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测-灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "rw",
                "code": "basic_nightvision",
                "name": "基本-红外夜视",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 108,
                "type": "obj",
                "desc": "0:自动\n1:关\n2:开",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "存储卡-获取卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡-卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡-格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "移动侦测-定时设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测-OSS上传",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "rw",
                "code": "ptz_stop",
                "name": "云台-停止转动",
                "property": {"type": "bool"},
                "id": 116,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "存储卡-格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "ptz_control",
                "name": "云台-方向控制",
                "property": {
                    "range": ["1", "2", "3", "4", "5", "6", "7", "0"],
                    "type": "enum",
                },
                "id": 119,
                "type": "obj",
                "desc": "direction：方向，共8个;0-上，1-右上，2-右，3-右下，4-下，5-左下，6-左，7-左上",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动侦测-总开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "移动侦测-模式选择",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "decibel_switch",
                "name": "分贝检测-总开关",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_sensitivity",
                "name": "分贝检测-灵敏度",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 140,
                "type": "obj",
                "desc": "0代表低灵敏度；1代表高灵敏度",
            },
            {
                "mode": "ro",
                "code": "decibel_upload",
                "name": "分贝检测-消息上报",
                "property": {"type": "string", "maxlen": 255},
                "id": 141,
                "type": "obj",
                "desc": "用于报警消息推送，app上会显示通知",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "jQRc7Cgy8OVzwSRG": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩情景",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓情景",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": "percent1"},
            {"id": 4, "inputStyle": "", "inputType": "percent1"},
        ],
    },
    "1yncmcjwgllxw6tm": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "时间水印",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "rw",
                "code": "basic_nightvision",
                "name": "红外夜视",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 108,
                "type": "obj",
                "desc": "0:自动\n1:关\n2:开",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "获取存储卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "移动侦测定时设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "检测到移动",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动报警开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "移动侦测-模式选择",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "decibel_switch",
                "name": "声音侦测报警开关",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_sensitivity",
                "name": "声音侦测灵敏度",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 140,
                "type": "obj",
                "desc": "0代表低灵敏度；1代表高灵敏度",
            },
            {
                "mode": "ro",
                "code": "decibel_upload",
                "name": "检测到声音",
                "property": {"type": "string", "maxlen": 255},
                "id": 141,
                "type": "obj",
                "desc": "用于报警消息推送，app上会显示通知",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "QIxyB1AOzNxfoLr7": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "inudxjowamz9mnx3": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "mhq7u6zahqfqdxx9": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": "plain"},
            {"id": 17, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "jupECyrdMrUifHd8": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关 2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "bhfhmgmlfjwv31j4": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "whkaccsqldd8vu8b": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习上报参数",
                "id": 2,
                "type": "raw",
                "desc": "用于学习功能数据上报",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "遥控器解码参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "用于搭配按键参数解码使用",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键同时下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "lucrkhabau1cc6if": {
        "schema": [
            {
                "mode": "ro",
                "code": "control",
                "name": "受控信息",
                "property": {"range": ["0x03", "0x04"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "0xBB : 0x03 测试\n0x50 : 0x04 静音\n",
            },
            {
                "mode": "ro",
                "code": "signal_quality",
                "name": "信号质量",
                "property": {
                    "range": ["0x00", "0x01", "0x02", "0x03", "0x04"],
                    "type": "enum",
                },
                "id": 102,
                "type": "obj",
                "desc": "0x00 表示无信号，即离线\n0x01 表示有1格信号\n0x02 表示有2格信号\n0x03 表示有3格信号\n0x04 表示有4格信号",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 100,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "0x00-0xff\n\nelectric_quantity",
            },
            {
                "mode": "ro",
                "code": "PIR",
                "name": "工作状态",
                "property": {"range": ["0", "1", "2", "3", "4"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0x00 正常(+低压报警)\n0x01 报警\n0x02 静音\n0x03 测试\n0x04 烟感故障",
            },
        ],
        "schemaExt": "[]",
    },
    "Mb0BSSK0mbO7WBBt": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power3",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "延迟",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "电量",
                "property": {
                    "unit": "度",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大100倍之后的值，即上报56，实际值为0.56度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "wnqaw70uBCsDqgZT": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "minbright_value",
                "name": "最小亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 3, "inputStyle": "", "inputType": "plain"},
            {"id": 101, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "A0F6MxOOAt2r3OoJ": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "eba03uybrkaoqmga": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 12,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "6UkFNWLWgioHUAAO": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "4dkZ3phqgLnFKtVy": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                        "music",
                    ],
                    "type": "enum",
                },
                "id": 2,
                "type": "obj",
                "desc": "增加音乐模式",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "id": 101,
                "type": "obj",
                "desc": "音乐灯",
            },
        ],
        "schemaExt": "[]",
    },
    "O0YnvNLlDWbJd4KC": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "fZUjBNC3zoZQYd2g": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "ld4GRDxQZZ2NAnk6": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "3rpavvenp7rsxjsb": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_control",
                "name": "开关控制",
                "property": {"range": ["on", "stop", "off"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "开关暂停",
            },
            {
                "mode": "rw",
                "code": "BlackLight",
                "name": "背光",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "背光可控",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 101, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "gvsnpmrhp1ktgawm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "kwh",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "name": "过流故障上报",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "iconname": "icon-baojing",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "9769CzA8RI1wW9AU": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "KVWnN9YQ9DqSmzBt": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "TempSet",
                "name": "设定温度",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 450,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_temp",
                "id": 2,
                "type": "obj",
                "desc": "温度设定0-45摄氏度，设置精度1℃，默认15℃。",
            },
            {
                "mode": "ro",
                "code": "TempCurrent",
                "name": "当前温度",
                "property": {
                    "unit": "℃",
                    "min": -50,
                    "max": 500,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "显示温度-5-50摄氏度，精度0.1℃",
            },
            {
                "mode": "rw",
                "code": "Timer",
                "name": "倒计时",
                "property": {
                    "range": [
                        "0",
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        "10",
                        "11",
                        "12",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "0:取消倒计时；1-12小时倒计时。",
            },
            {
                "mode": "rw",
                "code": "Tempchange",
                "name": "温度转换",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "℃/℉转换，由APP来完成",
            },
        ],
        "schemaExt": "[]",
    },
    "KoAUR5fdtDso34VM": {
        "schema": [
            {
                "mode": "ro",
                "code": "alarm",
                "name": "报警",
                "property": {"type": "bool"},
                "iconname": "icon-dp_lightning",
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "battery",
                "name": "电池电量",
                "property": {
                    "unit": "0.01v",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dianliang",
                "id": 102,
                "type": "obj",
                "desc": "上报电池电量信息 电压值 *100    0--4.00V",
            },
            {
                "mode": "ro",
                "code": "battery_status",
                "name": "剩余电量",
                "property": {
                    "unit": "%",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dianliang",
                "id": 103,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 102, "inputStyle": "", "inputType": ""},
            {"id": 103, "inputStyle": "", "inputType": ""},
        ],
    },
    "kZbvCqK7zvFiCGl1": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [{"id": 2, "inputStyle": "", "inputType": ""}],
    },
    "2EmW535HvNFa4F9W": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            }
        ],
        "schemaExt": "[]",
    },
    "in5psqrrnouof32o": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 3, "inputStyle": "", "inputType": "percent"},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "PzxHfpklYcBQOEQo": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "喷雾开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Light",
                "name": "灯光开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_light",
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["1"], "type": "bitmap", "maxlen": 1},
                "iconname": "icon-dp_warming",
                "id": 12,
                "type": "obj",
                "desc": "缺水故障",
            },
            {
                "mode": "ro",
                "code": "countdown_left",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 360,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 14,
                "type": "obj",
                "desc": "数值范围：0-360, 间距：1, 倍数：0, 单位：分钟",
            },
            {
                "mode": "rw",
                "code": "dp_mist_time",
                "name": "喷雾倒计时",
                "property": {"range": ["1h", "3h", "6h", "ON"], "type": "enum"},
                "id": 102,
                "type": "obj",
                "desc": "工作1小时，工作3小时；工作6小时；ON:取消",
            },
            {
                "mode": "rw",
                "code": "dp_mist_grade",
                "name": "雾量设置",
                "property": {"range": ["small", "big"], "type": "enum"},
                "id": 103,
                "type": "obj",
                "desc": "小喷雾，大喷雾",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "id": 108,
                "type": "obj",
                "desc": 'Value: ”00112233334455”（长度为 14 的字符串） 00: R 11: G 22: B 3333: H(色调 Hue) 44: S(饱和度 Saturation) 55: V(明度 Value) 示例： {"2700000000ff27"}',
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "工作模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene1",
                        "scene2",
                        "scene3",
                        "scene4",
                    ],
                    "type": "enum",
                },
                "id": 109,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "lightmode",
                "name": "灯光模式",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 110,
                "type": "obj",
                "desc": "1：七彩循环；2：定色",
            },
        ],
        "schemaExt": "[]",
    },
    "8UhAGZyCrYqYAcEc": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_box2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_filter",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_list",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-FanSpeed",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_mode_turbo",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "tuh2eatk4hsq336s": {
        "schema": [
            {
                "mode": "rw",
                "code": "status",
                "name": "窗帘状态",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 1,
                "type": "obj",
                "desc": "开 关 暂停",
            }
        ],
        "schemaExt": "[]",
    },
    "foitasaq52xwyqmt": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_set",
                "name": "目标温度",
                "property": {
                    "unit": "°C",
                    "min": 50,
                    "max": 950,
                    "scale": 1,
                    "step": 5,
                    "type": "value",
                },
                "iconname": "icon-set",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "temp_current",
                "name": "当前温度",
                "property": {
                    "unit": "°C",
                    "min": 0,
                    "max": 990,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-fangzi",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "a_key_home",
                "name": "一键离家",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_switch",
                "name": "编程开关",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_mode",
                "name": "7 天",
                "property": {
                    "range": ["1", "2", "3", "4", "5", "6", "7"],
                    "type": "enum",
                },
                "id": 103,
                "type": "obj",
                "desc": "1 为 1天编程 1-7; 2 为 2天编程 1-5、6-7; 3 为 3 天编程 1-5、6、7； 4 为 7 天编程 1、2、3、4、5、6、7",
            },
            {
                "mode": "rw",
                "code": "prog_data_1",
                "name": "编程数据（周一）",
                "id": 104,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_2",
                "name": "编程数据（周二）",
                "id": 105,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_3",
                "name": "编程数据（周三）",
                "id": 106,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_4",
                "name": "编程数据（周四）",
                "id": 107,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_5",
                "name": "编程数据（周五）",
                "id": 108,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_6",
                "name": "编程数据（周六）",
                "id": 109,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data_7",
                "name": "编程数据（周日）",
                "id": 110,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "restriction",
                "name": "温度设置上下限设置",
                "id": 111,
                "type": "raw",
                "desc": "四个字节： 00 01：上限 02 03：下限",
            },
            {
                "mode": "rw",
                "code": "historical_week_set",
                "name": "历史数据协议（周-设定温度）",
                "id": 112,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_month_set",
                "name": "历史数据协议（月-设定温度）",
                "id": 113,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_year_set",
                "name": "历史数据协议（年-设定温度）",
                "id": 114,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_day_now",
                "name": "历史数据协议（日-当前温度）",
                "id": 115,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_week_now",
                "name": "历史数据协议（周-当前温度）",
                "id": 116,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_month_now",
                "name": "历史数据协议（月-当前温度）",
                "id": 117,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_year_now",
                "name": "历史数据协议（年-当前温度）",
                "id": 118,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_day_pow",
                "name": "历史数据协议（日-电机开度）",
                "id": 119,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_week_pow",
                "name": "历史数据协议（周-电机开度）",
                "id": 120,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_month_pow",
                "name": "历史数据协议（月-电机开度）",
                "id": 121,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_year_pow",
                "name": "历史数据协议（年-电机开度）",
                "id": 122,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "historical_day_set",
                "name": "历史数据协议（日-设定温度)",
                "id": 123,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "prog_data",
                "name": "\t编程数据",
                "id": 124,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "battery_power",
                "scope": "fault",
                "name": "电池电量报警",
                "property": {"label": ["1"], "type": "bitmap", "maxlen": 1},
                "id": 125,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "pair_code",
                "name": "设备对码",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 126,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "set_temp",
                "name": "设置温度（第三方）",
                "property": {
                    "unit": "",
                    "min": 5,
                    "max": 95,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 127,
                "type": "obj",
                "desc": "目标温度_Alexa专用 DP点",
            },
            {
                "mode": "rw",
                "code": "current_temp",
                "name": "当前温度（第三方）",
                "property": {
                    "unit": "",
                    "min": 5,
                    "max": 95,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 128,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "program_num",
                "name": "编程段数选择",
                "property": {"range": ["4", "6"], "type": "enum"},
                "id": 129,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "temp_unit_convert",
                "name": "温标切换",
                "property": {"range": ["c", "f"], "type": "enum"},
                "id": 130,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "time",
                "name": "时间校准",
                "id": 131,
                "type": "raw",
                "desc": "用户可以选择是否自动校准时间，如果选择了开启，则根据网关下发的时间进行显示，如果设置关闭，则用户需要选择一个时间进行保存，这个时间会下发到网关，作为整个网关系统的时间。修改时间精确到分， 显示精确到秒。\n",
            },
            {
                "mode": "rw",
                "code": "tem_alibration_c",
                "name": "温度校准功能（摄氏度）",
                "property": {
                    "unit": "℃",
                    "min": -6,
                    "max": 6,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 132,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "time_auto",
                "name": "自动校准时间",
                "property": {"type": "bool"},
                "id": 133,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "tem_alibration_f",
                "name": "温度校准功能（华氏度）",
                "property": {
                    "unit": "℉",
                    "min": -40,
                    "max": 40,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "error_",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["sensor_error"], "type": "bitmap", "maxlen": 1},
                "id": 135,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key",
                "name": "增减按键锁开启/关闭",
                "property": {"type": "bool"},
                "id": 136,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "window",
                "name": "开窗开启/关闭",
                "property": {"type": "bool"},
                "id": 137,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "antifreeze",
                "name": "防冻开启/关闭",
                "property": {"type": "bool"},
                "id": 138,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "waterproof_scale",
                "name": "防水垢开启/关闭",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "yW1oJg0y0PIgywO1": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB 1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "B0eP8qYAdpUo4yR9": {
        "schema": [
            {
                "mode": "ro",
                "code": "Fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {
                    "label": ["AH", "AL", "Er"],
                    "type": "bitmap",
                    "maxlen": 3,
                },
                "iconname": "icon-dp_warming",
                "id": 12,
                "type": "obj",
                "desc": "高温报警/地温报警/探头异常报警",
            },
            {
                "mode": "rw",
                "code": "CF",
                "name": "温标切换",
                "property": {"range": ["C", "F"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "CA",
                "name": "温度校准",
                "property": {
                    "unit": "",
                    "min": -150,
                    "max": 150,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "CurrentTempC",
                "name": "当前温度C",
                "property": {
                    "unit": "℃",
                    "min": -500,
                    "max": 1200,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 104,
                "trigger": "direct",
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "SetTemp",
                "name": "温度设置",
                "property": {
                    "unit": "",
                    "min": -400,
                    "max": 2120,
                    "scale": 1,
                    "step": 5,
                    "type": "value",
                },
                "id": 106,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "PT",
                "name": "制冷延时",
                "property": {
                    "unit": "分钟",
                    "min": 0,
                    "max": 10,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 108,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "AH",
                "name": "高温报警",
                "property": {
                    "unit": "",
                    "min": -400,
                    "max": 2120,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 109,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "AL",
                "name": "低温报警",
                "property": {
                    "unit": "",
                    "min": -400,
                    "max": 2120,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "hot",
                "name": "高温报警",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cold",
                "name": "低温报警",
                "property": {"type": "bool"},
                "id": 112,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "temp",
                "name": "温度异常",
                "property": {"type": "bool"},
                "id": 113,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "OutputState",
                "name": "输出状态",
                "property": {"range": ["0", "1", "2", "3"], "type": "enum"},
                "id": 115,
                "type": "obj",
                "desc": "0：制冷状态，无输出\n1：制冷状态，有输出\n2：加热状态，无输出\n3：加热状态，有输出",
            },
            {
                "mode": "rw",
                "code": "CurrentTempF",
                "name": "当前温度F",
                "property": {
                    "unit": "℉",
                    "min": -500,
                    "max": 2480,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 116,
                "trigger": "direct",
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "HD",
                "name": "加热回差温度",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 300,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "CD",
                "name": "制冷回差温度",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 300,
                    "scale": 1,
                    "step": 10,
                    "type": "value",
                },
                "id": 118,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "pyhfiskiif5lzwax": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "时间水印",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "rw",
                "code": "basic_nightvision",
                "name": "红外夜视",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 108,
                "type": "obj",
                "desc": "0:自动\n1:关\n2:开",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "获取存储卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "移动侦测定时设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动报警开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "移动侦测-模式选择",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "op2lzjcj7fdfhid8": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_spray",
                "name": "喷雾开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "mode",
                "name": "工作模式",
                "property": {"range": ["large", "interval", "small"], "type": "enum"},
                "iconname": "icon-dp_box",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {"range": ["2", "4", "cancel"], "type": "enum"},
                "iconname": "icon-dp_time2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "灯光",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "灯光模式",
                "property": {"range": ["colour", "colourful1"], "type": "enum"},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光值",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["lack_water"], "type": "bitmap", "maxlen": 1},
                "iconname": "icon-yanse",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": ""},
            {"id": 2, "inputStyle": "", "inputType": ""},
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 5, "inputStyle": "", "inputType": ""},
            {"id": 6, "inputStyle": "", "inputType": ""},
        ],
    },
    "6adns63oboy4mdcp": {
        "schema": [
            {
                "mode": "wr",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习编码",
                "id": 2,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "ir_code",
                "name": "红外编码",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "jzkpltrhwqyzoc33": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_powe",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "白光亮度",
                "property": {
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-liangdu1",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "白光色温",
                "property": {
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光颜色",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-shoucang",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_nav_timer",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "vv5gy6pg8jpuqvjl": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": "plain"},
            {"id": 10, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "wKIbgibLBL7vdEA3": {
        "schema": [
            {
                "mode": "rw",
                "code": "control",
                "name": "控制命令",
                "property": {
                    "range": ["send_ir", "study", "study_exit", "study_key"],
                    "type": "enum",
                },
                "id": 1,
                "type": "obj",
                "desc": "send_ir:码库红外码发送\nstudy:进入学习状态\nstudy_exit:退出学习状态\nstudy_key:学习获取到的红外码发送",
            },
            {
                "mode": "ro",
                "code": "study_code",
                "name": "学习上报参数",
                "id": 2,
                "type": "raw",
                "desc": "用于学习功能数据上报",
            },
            {
                "mode": "wr",
                "code": "ir_code",
                "name": "遥控器解码参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 3,
                "type": "obj",
                "desc": "用于搭配按键参数解码使用",
            },
            {
                "mode": "wr",
                "code": "key_code",
                "name": "码库按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code2",
                "name": "码库按键参数2",
                "property": {"type": "string", "maxlen": 255},
                "id": 5,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_code3",
                "name": "码库按键参数3",
                "property": {"type": "string", "maxlen": 255},
                "id": 6,
                "type": "obj",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "key_study",
                "name": "来自学习参数下发",
                "id": 7,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study2",
                "name": "来自学习参数下发2",
                "id": 8,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键同时下发",
            },
            {
                "mode": "wr",
                "code": "key_study3",
                "name": "来自学习参数下发3",
                "id": 9,
                "type": "raw",
                "desc": "仅用于机顶盒多个按键下发",
            },
            {
                "mode": "wr",
                "code": "delay_time",
                "name": "红外码发送延时",
                "property": {
                    "unit": "ms",
                    "min": 0,
                    "max": 65535,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_code4",
                "name": "新按键参数",
                "property": {"type": "string", "maxlen": 255},
                "id": 11,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "key_study4",
                "name": "新学习参数",
                "id": 12,
                "type": "raw",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "type",
                "name": "码库标识",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 13,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "pkf6ggaaofgot9bk": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value_1",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "brightness_min_1",
                "name": "最小亮度",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "led_type_1",
                "name": "光源类型",
                "property": {
                    "range": ["LED", "incandescent", "halogen"],
                    "type": "enum",
                },
                "id": 4,
                "type": "obj",
                "desc": "1:LED \n2.白炽灯\n3.节能灯\n4.其他",
            },
        ],
        "schemaExt": "[]",
    },
    "fTNOwUWf3JxHmWpQ": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": [{"complexType": "", "id": 2, "inputStyle": "", "inputType": ""}],
    },
    "apxmk1cpaagjxvz2": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "test_bit",
                "name": "产测结果位",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 5,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_direction",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "voltage_coe",
                "name": "电压校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electric_coe",
                "name": "电流校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "power_coe",
                "name": "功率校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "electricity_coe",
                "name": "电量校准系数",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-gaodiyin",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {"label": ["ov_cr"], "type": "bitmap", "maxlen": 1},
                "id": 26,
                "type": "obj",
                "desc": "ov_cr：过流保护",
            },
        ],
        "schemaExt": [
            {"complexType": "", "id": 1, "inputStyle": "", "inputType": "plain"},
            {"complexType": "", "id": 2, "inputStyle": "", "inputType": "plain"},
            {"complexType": "", "id": 9, "inputStyle": "", "inputType": " "},
            {"complexType": "", "id": 10, "inputStyle": "", "inputType": " "},
            {"complexType": "", "id": 17, "inputStyle": "", "inputType": " "},
        ],
    },
    "dKJ5A2k0BhVT27Jg": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "arslxyjlf2gzlfqv": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "FtcUIyWXINfX3BL6": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "iQG3q7IECnbkHVms": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_all",
                "name": "全部开启或关闭",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 5,
                "type": "obj",
                "desc": "0:全关；1:全开",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 5, "inputStyle": "", "inputType": " "},
        ],
    },
    "jyqwiknzooocjhqc": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_indicator",
                "name": "状态指示灯",
                "property": {"type": "bool"},
                "id": 101,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n设备指示灯是否打开，True打开，false关闭",
            },
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n使直播画面垂直翻转，True打开翻转，false关闭翻转",
            },
            {
                "mode": "rw",
                "code": "basic_osd",
                "name": "时间水印",
                "property": {"type": "bool"},
                "id": 104,
                "type": "obj",
                "desc": "设备设置页面-基本功能设置\n时间水印功能开关，True打开水印，false关闭水印",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "rw",
                "code": "basic_nightvision",
                "name": "红外夜视",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 108,
                "type": "obj",
                "desc": "0:自动\n1:关\n2:开",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "获取存储卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "存储卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "存储卡格式化",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "移动侦测定时设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "移动侦测",
                "id": 115,
                "type": "raw",
                "desc": '该功能实现请参考SDK\n---------------\n{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动报警开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "移动侦测-模式选择",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "decibel_switch",
                "name": "声音侦测报警开关",
                "property": {"type": "bool"},
                "id": 139,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "decibel_sensitivity",
                "name": "声音侦测灵敏度",
                "property": {"range": ["0", "1"], "type": "enum"},
                "id": 140,
                "type": "obj",
                "desc": "0代表低灵敏度；1代表高灵敏度",
            },
            {
                "mode": "ro",
                "code": "decibel_upload",
                "name": "检测到声音",
                "property": {"type": "string", "maxlen": 255},
                "id": 141,
                "type": "obj",
                "desc": "用于报警消息推送，app上会显示通知",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像-开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像开关，True为打开，false为关闭\n功能关闭时，不录像到SD卡",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "SD卡录像-模式选择",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "设备设置页面-存储卡设置\nSD卡录像模式选择，1为事件录像（检测到移动再录像到SD卡），2为连续录像",
            },
        ],
        "schemaExt": "[]",
    },
    "NRc2AbstIKafzROP": {
        "schema": [
            {
                "mode": "rw",
                "code": "Power",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "TempSet",
                "name": "目标温度",
                "property": {
                    "unit": "℃",
                    "min": 5,
                    "max": 1220,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_temp",
                "id": 2,
                "type": "obj",
                "desc": "目标温度设置范围=设置温度最低下限值~设置温度最高上限值",
            },
            {
                "mode": "ro",
                "code": "TempCurrent",
                "name": "当前温度",
                "property": {
                    "unit": "℃",
                    "min": 0,
                    "max": 1580,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Mode",
                "name": "模式",
                "property": {
                    "range": ["Manual", "Program", "Holiday", "TempProg"],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 4,
                "type": "obj",
                "desc": "手动、编程、离家、临时手动",
            },
            {
                "mode": "rw",
                "code": "ChildLock",
                "name": "童锁",
                "property": {"type": "bool"},
                "iconname": "icon-dp_lock",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "Fault",
                "scope": "fault",
                "name": "故障告警",
                "property": {
                    "label": ["1", "2", "3", "4", "5"],
                    "type": "bitmap",
                    "maxlen": 5,
                },
                "iconname": "icon-dp_warming",
                "id": 12,
                "type": "obj",
                "desc": "1:设备故障\n2:内置传感器报警\n3.外置传感器报警\n4.低温保护报警\n5.高温保护报警",
            },
            {
                "mode": "rw",
                "code": "C_F",
                "name": "华氏度摄氏度",
                "property": {"type": "bool"},
                "iconname": "icon-a_function_fahrenhei",
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "Heating_state",
                "name": "加热",
                "property": {"type": "bool"},
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "Ext_temperature",
                "name": "外置温度",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1580,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Days_Holiday",
                "name": "离家模式-天数",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 30,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-p7",
                "id": 104,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Settemp_Holiday",
                "name": "离家模式-设置温度",
                "property": {
                    "unit": "",
                    "min": 5,
                    "max": 122,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-set",
                "id": 105,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "Hightemp_Protect",
                "name": "高温保护功能",
                "property": {"type": "bool"},
                "id": 106,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "LowTemp_Protect",
                "name": "低温保护功能",
                "property": {"type": "bool"},
                "id": 107,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "ext_temp_display",
                "name": "外置温度显示功能",
                "property": {"type": "bool"},
                "id": 108,
                "type": "obj",
                "desc": "外置温度是否显示",
            },
            {
                "mode": "rw",
                "code": "room_temp_compensate",
                "name": "温度补偿",
                "property": {
                    "unit": "",
                    "min": -180,
                    "max": 180,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-ziyouchengxu",
                "id": 109,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "room_temp_zone",
                "name": "室内温度回差",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 180,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "low_temp_limit",
                "name": "低温保护温度",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 50,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 113,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "set_temp_max",
                "name": "设置温度最高上限",
                "property": {
                    "unit": "℃",
                    "min": 20,
                    "max": 158,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 114,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "set_temp_min",
                "name": "设置温度最低下限",
                "property": {
                    "unit": "℃",
                    "min": 1,
                    "max": 59,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 115,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "power_state",
                "name": "上电开关机状态",
                "property": {"range": ["keep", "off", "on"], "type": "enum"},
                "id": 117,
                "type": "obj",
                "desc": "keep:保持前一次状态\noff:上电设备关机\non:上电设备开机",
            },
            {
                "mode": "rw",
                "code": "Prog_Type",
                "name": "编程类型",
                "property": {"range": ["2days", "1days", "0days"], "type": "enum"},
                "id": 118,
                "type": "obj",
                "desc": "2days:5+2 5个工作日2个休息日\n1days:6+1 6个工作日1个休息日\n0days:取消编程",
            },
            {
                "mode": "rw",
                "code": "Prog_Workday1",
                "name": "编程-工作日参数1",
                "id": 119,
                "type": "raw",
                "desc": "工作日参数1:\n第一字节为第1时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第1时段分钟，第三字节为第1时段设置温度。第四字节为第2时段开始小时，第四个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第五字节为第2时段分钟，第六字节为第2时段设置温度。第七字节为第3时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第3时段分钟，第三字节为第3时段设置温度。",
            },
            {
                "mode": "rw",
                "code": "Prog_Workday2",
                "name": "编程-工作日参数2",
                "id": 120,
                "type": "raw",
                "desc": "工作日参数2:\n第一字节为第4时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第4时段分钟，第三字节为第4时段设置温度。第四字节为第5时段开始小时，第四个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第五字节为第5时段分钟，第六字节为第5时段设置温度。第七字节为第6时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第6时段分钟，第三字节为第6时段设置温度。",
            },
            {
                "mode": "rw",
                "code": "Prog_Restday1",
                "name": "编程-休息日参数1",
                "id": 121,
                "type": "raw",
                "desc": "休息日参数1:\n第一字节为第1时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第1时段分钟，第三字节为第1时段设置温度。第四字节为第2时段开始小时，第四个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第五字节为第2时段分钟，第六字节为第2时段设置温度。第七字节为第3时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第3时段分钟，第三字节为第3时段设置温度。",
            },
            {
                "mode": "rw",
                "code": "Prog_Restday2",
                "name": "编程-休息日参数2",
                "id": 122,
                "type": "raw",
                "desc": "休息日参数2:\n第一字节为第4时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第4时段分钟，第三字节为第4时段设置温度。第四字节为第5时段开始小时，第四个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第五字节为第5时段分钟，第六字节为第5时段设置温度。第七字节为第6时段开始小时，第一个字节最高位是标识位，若为1，标识设备处于该时间段的设置，若为0，则不是。第二字节为第6时段分钟，第三字节为第6时段设置温度。",
            },
        ],
        "schemaExt": "[]",
    },
    "3i480z6ds8l9rlda": {
        "schema": [
            {
                "mode": "ro",
                "code": "pir_state",
                "name": "人体感应状态",
                "property": {"range": ["pir"], "type": "enum"},
                "iconname": "icon-yundong",
                "id": 1,
                "type": "obj",
                "desc": "【必选】1：有人触发\n",
            },
            {
                "mode": "ro",
                "code": "battery_state",
                "name": "电池电量状态",
                "property": {"range": ["low", "middle", "high"], "type": "enum"},
                "iconname": "icon-dianliang",
                "id": 3,
                "type": "obj",
                "desc": "【非必选】\n低电量\n中电量\n高电量",
            },
            {
                "mode": "ro",
                "code": "battery_percentage",
                "name": "电池电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dianliang",
                "id": 4,
                "type": "obj",
                "desc": "【非必选】",
            },
            {
                "mode": "ro",
                "code": "temper_alarm",
                "name": "防拆报警",
                "property": {"type": "bool"},
                "iconname": "icon-a_selected",
                "id": 5,
                "type": "obj",
                "desc": "【非必选】如果硬件支持拆除检测，当发生拆除事件时，触发报警",
            },
        ],
        "schemaExt": "[]",
    },
    "mGOAAG11xWJqpQXm": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": "percent1"},
            {"id": 4, "inputStyle": "", "inputType": "percent"},
        ],
    },
    "jtCB35qnMWxHuSL8": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 5,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 14},
                "id": 6,
                "type": "obj",
                "desc": "rgbhsv",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 14},
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 44},
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 2, "inputStyle": "", "inputType": " "},
            {"id": 3, "inputStyle": "", "inputType": " "},
            {"id": 4, "inputStyle": "", "inputType": " "},
        ],
    },
    "RN9iPCasMEiFi3RU": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": "plain"},
            {"id": 3, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "8urvykaz4giwsbkz": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_on",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time",
                "id": 2,
                "type": "obj",
                "passive": True,
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "kwh",
                    "min": 0,
                    "max": 500000,
                    "scale": 3,
                    "step": 1,
                    "type": "value",
                },
                "id": 3,
                "type": "obj",
                "desc": "上报的为放大1000倍之后的值，即上报1000，实际值为1度",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_curve",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_flower",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 2500,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 6,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "bb1gl4lxrapnt4vo": {
        "schema": [
            {
                "mode": "ro",
                "code": "temp_value",
                "name": "当前温度",
                "property": {
                    "unit": "",
                    "min": -400,
                    "max": 2000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_celsius",
                "id": 1,
                "type": "obj",
                "desc": "【必选】产品为温度传感器或温湿度传感器时该功能必选",
            },
            {
                "mode": "ro",
                "code": "humidity_value",
                "name": "当前湿度",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-icon-percent",
                "id": 2,
                "type": "obj",
                "desc": "【必选】产品为湿度传感器或温湿度传感器时该功能必选",
            },
            {
                "mode": "ro",
                "code": "battery_state",
                "name": "电池电量状态",
                "property": {"range": ["low", "middle", "high"], "type": "enum"},
                "iconname": "icon-dianliang",
                "id": 3,
                "type": "obj",
                "desc": "【非必选】\n低电量\n中电量\n高电量",
            },
        ],
        "schemaExt": "[]",
    },
    "uyvxoqhmac1dhvlm": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
        ],
    },
    "bkc7r4doh4k8joso": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 9, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "shdbwbr7mjjdwu1f": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ufmpluqx4zcaiaoa": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 6, "inputStyle": "", "inputType": " "},
            {"id": 7, "inputStyle": "", "inputType": "percent"},
            {"id": 13, "inputStyle": "", "inputType": " "},
        ],
    },
    "qspawqbvse9z3hyu": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_3",
                "name": "开关3",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_usb1",
                "name": "USB开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 101,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown3",
                "name": "开关3倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 103,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_usb1",
                "name": "USB1倒计时",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 105,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "1zhgmbekichfveta": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": " "},
            {"id": 21, "inputStyle": "", "inputType": " "},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "zrryhdmszfg6xc6s": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-power",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "relay_status",
                "name": "继电器上电状态",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 101,
                "type": "obj",
                "desc": "0：断电； 1：通电； 2：记忆继电器上次状态",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 102,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "iyqmKowwmGNuYqkV": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 11,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 2,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": "plain"},
            {"id": 2, "inputStyle": "", "inputType": " "},
        ],
    },
    "26iRceKhfrzuQLTf": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "Switch",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "开关",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "Work_mode",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "Bright_value",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "亮度",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "Temp_value",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "冷暖",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "Colour_data",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "彩光模式数",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "Scene_data",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "情景模式数",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "Soft",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "柔光模式",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "Colours",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "缤纷模式",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "Colorful",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "炫彩模式",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "Gorgeous",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "斑斓模式",
            },
        ],
        "schemaExt": "[]",
    },
    "oylqwkwmjbwqknwv": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "情景灯开关",
                "property": {"type": "bool"},
                "iconname": "icon-deng",
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "情景灯模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_puzzle",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_mode",
                "id": 31,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-a_nav_function",
                "id": 32,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 33,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 34,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 35,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yanse",
                "id": 36,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_led",
                "name": "情景灯倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 37,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 1, "inputStyle": "", "inputType": " "},
            {"id": 9, "inputStyle": "", "inputType": " "},
            {"id": 27, "inputStyle": "", "inputType": " "},
            {"id": 28, "inputStyle": "", "inputType": " "},
            {"id": 29, "inputStyle": "", "inputType": " "},
            {"id": 30, "inputStyle": "", "inputType": " "},
            {"id": 37, "inputStyle": "", "inputType": " "},
        ],
    },
    "xz0eqflm5riksgqt": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_ratio",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_mode_heat",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "色温值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "id": 28,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "milight",
                "name": "鑫彩翼透传",
                "id": 101,
                "type": "raw",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": " "},
            {"id": 21, "inputStyle": "", "inputType": "plain"},
            {"id": 22, "inputStyle": "", "inputType": "plain"},
            {"id": 23, "inputStyle": "", "inputType": "plain"},
            {"id": 26, "inputStyle": "", "inputType": "plain"},
        ],
    },
    "fagmnmgohirnkxyg": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_1",
                "name": "开关1",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "switch_2",
                "name": "开关2",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 2,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_1",
                "name": "开关1倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown_2",
                "name": "开关2倒计时",
                "property": {
                    "unit": "s",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_time2",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "add_ele",
                "name": "增加电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 50000,
                    "scale": 3,
                    "step": 100,
                    "type": "value",
                },
                "iconname": "icon-battery",
                "id": 17,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_current",
                "name": "当前电流",
                "property": {
                    "unit": "mA",
                    "min": 0,
                    "max": 30000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-Ele",
                "id": 18,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_power",
                "name": "当前功率",
                "property": {
                    "unit": "W",
                    "min": 0,
                    "max": 50000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_tool",
                "id": 19,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "cur_voltage",
                "name": "当前电压",
                "property": {
                    "unit": "V",
                    "min": 0,
                    "max": 5000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-a_function_turbo",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "xgahfdephq2jnhav": {
        "schema": [
            {
                "mode": "rw",
                "code": "basic_flip",
                "name": "录制画面翻转",
                "property": {"type": "bool"},
                "id": 103,
                "type": "obj",
                "desc": "True反转，false正常",
            },
            {
                "mode": "rw",
                "code": "motion_sensitivity",
                "name": "移动侦测报警灵敏度",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "0-2，灵敏度依次增加；仅为灵敏度，0并不是关闭移动侦测报警；规定0为低灵敏度，1为中灵敏度，2为高灵敏度。",
            },
            {
                "mode": "ro",
                "code": "sd_storge",
                "name": "获取SD卡容量",
                "property": {"type": "string", "maxlen": 255},
                "id": 109,
                "type": "obj",
                "desc": "示例：\n---2017.07.08更新---\n单位改为kb\n---\n3503775744|778977280|2718158848\n其中第一字符串是总容量，第二个字符串是已使用的容量，第三个是剩余容量",
            },
            {
                "mode": "ro",
                "code": "sd_status",
                "name": "SD卡状态",
                "property": {
                    "unit": "",
                    "min": 1,
                    "max": 5,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 110,
                "type": "obj",
                "desc": "status：sd卡状态，1-正常，2-异常，3-空间不足，4-正在格式化，5-无SD卡；",
            },
            {
                "mode": "rw",
                "code": "sd_format",
                "name": "格式化存储卡",
                "property": {"type": "bool"},
                "id": 111,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "rw",
                "code": "motion_record",
                "name": "移动侦测录像",
                "property": {"type": "bool"},
                "id": 113,
                "type": "obj",
                "desc": "True打开，false关闭\n摄像头本地功能：功能打开的时候，只有检测到移动才开始录像。",
            },
            {
                "mode": "rw",
                "code": "motion_timer_setting",
                "name": "定时移动侦测时间设置",
                "property": {"type": "string", "maxlen": 255},
                "id": 114,
                "type": "obj",
                "desc": 't_start:开始时间；t_end:结束时间。多个时间由";"分隔',
            },
            {
                "mode": "ro",
                "code": "movement_detect_pic",
                "name": "检测到移动",
                "id": 115,
                "type": "raw",
                "desc": '{"dp_id","bucket;object;key"}/{"dp_id","bucket;object;"}\n\nbucket:根文件夹；objcet:文件路径；key:加密',
            },
            {
                "mode": "rw",
                "code": "ptz_stop",
                "name": "停止云台转动",
                "property": {"type": "bool"},
                "id": 116,
                "type": "obj",
                "desc": "无参数",
            },
            {
                "mode": "ro",
                "code": "sd_format_state",
                "name": "格式化状态",
                "property": {
                    "unit": "",
                    "min": -20000,
                    "max": 20000,
                    "scale": 1,
                    "step": 1,
                    "type": "value",
                },
                "id": 117,
                "type": "obj",
                "desc": "返回错误码：\n-2000：SD卡正在格式化\n-2001：SD卡格式化异常\n-2002：无SD卡\n-2003：SD卡错误\n\n//正数为格式化进度",
            },
            {
                "mode": "rw",
                "code": "ptz_control",
                "name": "云台控制",
                "property": {
                    "range": ["1", "2", "3", "4", "5", "6", "7", "0"],
                    "type": "enum",
                },
                "id": 119,
                "type": "obj",
                "desc": "direction：方向，共8个;0-上，1-右上，2-右，3-右下，4-下，5-左下，6-左，7-左上",
            },
            {
                "mode": "rw",
                "code": "motion_switch",
                "name": "移动报警开关",
                "property": {"type": "bool"},
                "id": 134,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "motion_timer_switch",
                "name": "定时移动侦测功能开关",
                "property": {"type": "bool"},
                "id": 135,
                "type": "obj",
                "desc": "True为定时移动侦测，false为全天移动侦测",
            },
            {
                "mode": "rw",
                "code": "record_switch",
                "name": "SD卡录像开关",
                "property": {"type": "bool"},
                "id": 150,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "record_mode",
                "name": "移动录像模式",
                "property": {"range": ["1", "2"], "type": "enum"},
                "id": 151,
                "type": "obj",
                "desc": "1事件录影，2全时录影 摄像头本地保存录像到SD卡的模式 事件录影：摄像头检测到物体移动再录制录像 全时录影：不间断录制24/7录像",
            },
            {
                "mode": "rw",
                "code": "motion_tracking",
                "name": "人体移动追踪",
                "property": {"type": "bool"},
                "id": 161,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "an3xefw05o9oi2km": {
        "schema": [
            {
                "mode": "rw",
                "code": "switch_led",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 20,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": ["white", "colour", "scene", "music"],
                    "type": "enum",
                },
                "iconname": "icon-dp_list",
                "id": 21,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度值",
                "property": {
                    "unit": "",
                    "min": 10,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 22,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖值",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 1000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_half",
                "id": 23,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light",
                "id": 24,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "场景",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_box2",
                "id": 25,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "countdown",
                "name": "倒计时剩余时间",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 86400,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-timer1",
                "id": 26,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "music_data",
                "name": "音乐灯",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-yinliang",
                "id": 27,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "wr",
                "code": "control_data",
                "name": "调节",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-setting",
                "id": 28,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 20, "inputStyle": "", "inputType": "plain"},
            {"id": 21, "inputStyle": "", "inputType": " "},
            {"id": 22, "inputStyle": "", "inputType": "plain"},
            {"id": 23, "inputStyle": "", "inputType": "plain"},
            {"id": 26, "inputStyle": "", "inputType": " "},
        ],
    },
    "FEn1xRPbTaBjyjbb": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "work_mode",
                "name": "模式",
                "property": {
                    "range": [
                        "white",
                        "colour",
                        "scene",
                        "scene_1",
                        "scene_2",
                        "scene_3",
                        "scene_4",
                    ],
                    "type": "enum",
                },
                "iconname": "icon-dp_mode",
                "id": 2,
                "type": "obj",
                "desc": "white：白光模式；colour：彩光模式；scene：场景模式；scene1-4:不同场景模式切换；可根据产品实际功能更改。",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "temp_value",
                "name": "冷暖",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_sun",
                "id": 4,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "colour_data",
                "name": "彩光模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_light2",
                "id": 5,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "scene_data",
                "name": "情景模式数",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_direction",
                "id": 6,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_1",
                "name": "柔光模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_flower",
                "id": 7,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_2",
                "name": "缤纷模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_dust",
                "id": 8,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_3",
                "name": "炫彩模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_puzzle",
                "id": 9,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "flash_scene_4",
                "name": "斑斓模式",
                "property": {"type": "string", "maxlen": 255},
                "iconname": "icon-dp_smile",
                "id": 10,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": [
            {"id": 3, "inputStyle": "", "inputType": ""},
            {"id": 4, "inputStyle": "", "inputType": ""},
        ],
    },
    "5q59q6kpkuahxnmk": {
        "schema": [
            {
                "mode": "rw",
                "code": "led_switch",
                "name": "开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power2",
                "id": 1,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "rw",
                "code": "bright_value",
                "name": "亮度",
                "property": {
                    "unit": "",
                    "min": 25,
                    "max": 255,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_light",
                "id": 3,
                "type": "obj",
                "desc": "",
            },
        ],
        "schemaExt": "[]",
    },
    "ai6HtccKFIw3dxo3": {
        "schema": [
            {
                "mode": "rw",
                "code": "power_go",
                "name": "清扫开关",
                "property": {"type": "bool"},
                "iconname": "icon-dp_power",
                "id": 2,
                "type": "obj",
                "desc": "1：启动\n2、停止",
            },
            {
                "mode": "ro",
                "code": "cleanarea",
                "name": "清洁面积",
                "property": {
                    "unit": "m",
                    "min": 0,
                    "max": 120,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "iconname": "icon-dp_house",
                "id": 14,
                "type": "obj",
                "desc": "按实际情况输入",
            },
            {
                "mode": "rw",
                "code": "remote",
                "name": "方向控制",
                "property": {
                    "range": ["up", "down", "left", "right", "stop"],
                    "type": "enum",
                },
                "id": 101,
                "type": "obj",
                "desc": "上、下、左、右、停\n\n用户按下即发上下左右，松手就发停止",
            },
            {
                "mode": "ro",
                "code": "working_condition",
                "name": "工作状态",
                "property": {
                    "range": ["0", "1", "2", "3", "4", "5", "6", "7", "8"],
                    "type": "enum",
                },
                "id": 102,
                "type": "obj",
                "desc": "休眠、待机、清扫中、清扫已完成、回充、充电中、直充中、充电已完成、休眠中\n",
            },
            {
                "mode": "rw",
                "code": "mode_work",
                "name": "工作模式",
                "property": {"range": ["0", "1", "2", "3", "4", "5"], "type": "enum"},
                "id": 103,
                "type": "obj",
                "desc": "无模式、自动清扫、定点清扫、沿边清扫、自动回充、遥控清扫\n",
            },
            {
                "mode": "ro",
                "code": "Electric_quantity",
                "name": "剩余电量",
                "property": {
                    "unit": "",
                    "min": 0,
                    "max": 100,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 104,
                "type": "obj",
                "desc": "0——100%，低于20%时显示红色\n",
            },
            {
                "mode": "ro",
                "code": "fault_",
                "name": "故障告警",
                "property": {
                    "range": [
                        "0",
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        "10",
                        "11",
                        "12",
                        "13",
                    ],
                    "type": "enum",
                },
                "id": 105,
                "type": "obj",
                "desc": "ERROR_00    无故障\nERROR_01    左轮异常\nERROR_02    右轮异常\nERROR_03    左边扫异常\nERROR_04    右边扫异常\nERROR_05    中扫异常\nERROR_06    地检异常\nERROR_07    前撞异常\nERROR_08    被困\nERROR_09    电量过低\nERROR_10    尘盒缺失\nERROR_11    找不到充电座\nERROR_12    左轮抬起\nERROR_13    右轮抬起",
            },
            {
                "mode": "rw",
                "code": "Suction_regulation",
                "name": "吸力调节",
                "property": {"range": ["0", "1", "2"], "type": "enum"},
                "id": 106,
                "type": "obj",
                "desc": "强劲、标准、安静",
            },
            {
                "mode": "ro",
                "code": "clear_time",
                "name": "清扫时间显示",
                "property": {
                    "unit": "秒",
                    "min": 0,
                    "max": 432000,
                    "scale": 0,
                    "step": 1,
                    "type": "value",
                },
                "id": 107,
                "type": "obj",
                "desc": "",
            },
            {
                "mode": "ro",
                "code": "last_time",
                "name": "【无用】距离上一次清扫时间显示",