"""Exceptions module."""

from .auth import (
    CaptchaRequiredError,
    InvalidCredentialsError,
    RateLimitError,
    SessionExpiredError,
    TwoFactorFailedError,
    TwoFactorRequiredError,
    XSRFTokenError,
)
from .base import (
    PararamioAuthenticationError,
    PararamioCaptchaAuthenticationError,
    PararamioException,
    PararamioHTTPRequestError,
    PararamioLimitExceededError,
    PararamioMethodNotAllowedError,
    PararamioPasswordAuthenticationError,
    PararamioRequestError,
    PararamioSecondFactorAuthenticationError,
    PararamioServerResponseError,
    PararamioTypeError,
    PararamioValidationError,
    PararamioValueError,
    PararamioXSRFRequestError,
    PararamModelNotLoadedError,
    PararamMultipleFoundError,
    PararamNoNextPostError,
    PararamNoPrevPostError,
    PararamNotFoundError,
)

__all__ = [
    'CaptchaRequiredError',
    'InvalidCredentialsError',
    'PararamModelNotLoadedError',
    'PararamMultipleFoundError',
    'PararamNoNextPostError',
    'PararamNoPrevPostError',
    'PararamNotFoundError',
    'PararamioAuthenticationError',
    'PararamioCaptchaAuthenticationError',
    'PararamioException',
    'PararamioHTTPRequestError',
    'PararamioLimitExceededError',
    'PararamioMethodNotAllowedError',
    'PararamioPasswordAuthenticationError',
    'PararamioRequestError',
    'PararamioSecondFactorAuthenticationError',
    'PararamioServerResponseError',
    'PararamioTypeError',
    'PararamioValidationError',
    'PararamioValueError',
    'PararamioXSRFRequestError',
    'RateLimitError',
    'SessionExpiredError',
    'TwoFactorFailedError',
    'TwoFactorRequiredError',
    'XSRFTokenError',
]
