# MD019 - No multiple spaces after hash in heading

## What this rule does

Ensures there's only one space between the # symbols and the heading text.

## Why this matters

- **Consistency**: Extra spaces create inconsistent visual spacing
- **Compatibility**: Some Markdown processors may not handle multiple spaces correctly
- **Cleanliness**: Single spacing looks professional and clean

## Examples

### ✅ Correct

```markdown
# Heading 1
## Heading 2
### Heading 3
#### Heading 4
##### Heading 5
###### Heading 6
```

### ❌ Incorrect

<!-- rumdl-disable MD019 -->

```markdown
#  Heading 1
##   Heading 2
###    Heading 3
####     Heading 4
#####      Heading 5
######       Heading 6
```

<!-- rumdl-enable MD019 -->

### 🔧 Fixed

```markdown
# Heading 1
## Heading 2
### Heading 3
#### Heading 4
##### Heading 5
###### Heading 6
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically removes extra spaces, leaving just one space after the # symbols.

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical details about heading syntax

## Related rules

- [MD018](md018.md) - No missing space after hash in heading
- [MD020](md020.md) - No missing space in closed heading
- [MD021](md021.md) - No multiple spaces in closed heading
- [MD022](md022.md) - Headings should be surrounded by blank lines
