# MD033 - No HTML tags

## What this rule does

Prevents the use of HTML tags in Markdown - use Markdown syntax instead.

## Why this matters

- **Portability**: Pure Markdown works everywhere, HTML might be blocked or stripped
- **Security**: Many platforms sanitize HTML for security reasons
- **Simplicity**: Markdown syntax is cleaner and easier to read than HTML
- **Consistency**: Mixing HTML and Markdown creates inconsistent documents

## Examples

### ✅ Correct

```markdown
# Heading

This is a paragraph with **bold** and *italic* text.

> This is a quote

- List item 1
- List item 2

[Link text](https://example.com)

![Image description](image.png)

Contact us at <support@example.com>
Visit <https://example.com>
```

### ❌ Incorrect

<!-- rumdl-disable MD033 -->

```markdown
# Heading

This is a paragraph with <strong>bold</strong> and <em>italic</em> text.

<blockquote>This is a quote</blockquote>

<ul>
  <li>List item 1</li>
  <li>List item 2</li>
</ul>

<a href="https://example.com">Link text</a>

<img src="image.png" alt="Image description">
```

<!-- rumdl-enable MD033 -->

### 🔧 Fixed

This rule cannot automatically fix HTML tags because it can't always determine the equivalent Markdown syntax. You need to manually replace HTML with Markdown.

## Configuration

```yaml
MD033:
  allowed_elements: []  # List of allowed HTML tags (default: none)
```

### Example allowing specific tags

```yaml
MD033:
  allowed_elements: ["br", "hr", "details", "summary"]
```

This would allow line breaks, horizontal rules, and collapsible sections while blocking other HTML.

## Automatic fixes

This rule does not provide automatic fixes. HTML must be manually converted to Markdown syntax.

## What's allowed

These are **not** considered HTML and are allowed:
- HTML comments: `<!-- This is a comment -->`
- Email autolinks: `<user@example.com>`
- URL autolinks: `<https://example.com>`
- FTP autolinks: `<ftp://files.example.com>`

## Learn more

- [CommonMark HTML blocks](https://spec.commonmark.org/0.31.2/#html-blocks) - When HTML is needed
- [Markdown Guide - Basic Syntax](https://www.markdownguide.org/basic-syntax/) - Markdown alternatives to HTML

## Related rules

- [MD046](md046.md) - Code block style should be consistent
- [MD034](md034.md) - URLs should be formatted as links
