# MD043 - Enforce Required Document Structure

## What this rule does

Ensures your documents contain specific required headings, helping maintain consistent structure across documentation sets.

## Why this matters

- **Consistent documentation**: All documents follow the same organizational pattern
- **Complete information**: Ensures important sections aren't forgotten
- **Better navigation**: Readers know where to find specific information
- **Team alignment**: Everyone follows the same documentation template

## Examples

### ✅ Correct

With required headings configuration:

```yaml
headings: ["# Overview", "## Installation", "## Usage", "## License"]
```

```markdown
# Overview

This tool helps you lint Markdown files...

## Installation

Install using npm:

## Usage

Run the following command...

## License

MIT License
```

### ❌ Incorrect

```markdown
# Getting Started              <!-- Wrong heading text -->

This tool helps you...

## How to Install             <!-- Should be "Installation" -->

Install using npm...

## Examples                   <!-- Should be "Usage" -->

Run the following...

## License

MIT License
```

### 🔧 Fixed

```markdown
# Overview                    <!-- Corrected heading -->

This tool helps you...

## Installation              <!-- Corrected heading -->

Install using npm...

## Usage                     <!-- Corrected heading -->

Run the following...

## License

MIT License
```

## Configuration

```yaml
MD043:
  headings:                  # Required heading patterns
    - "# Overview"
    - "## Installation"
    - "## Usage"
    - "/## .*License/"       # Regex patterns supported
  match_case: false          # Case-sensitive matching (default: false)
```

## Automatic fixes

When enabled, this rule will:
- Replace incorrect headings with the required ones
- Preserve heading content when using regex patterns
- Maintain document flow and readability

## Special cases

- Empty configuration disables this rule
- Use `/pattern/` syntax for regex matching
- Order of headings matters if specified
- Case sensitivity controlled by `match_case` option

## Learn more

- [Documentation templates best practices](https://www.writethedocs.org/guide/writing/docs-principles/)
- [Structured documentation guide](https://documentation.divio.com/)

## Related rules

- [MD001](md001.md) - Keep heading levels organized
- [MD003](md003.md) - Use consistent heading styles
- [MD025](md025.md) - Use only one main title
