# MD044 - Use Proper Capitalization for Names

## What this rule does

Ensures brand names, product names, and technical terms are consistently capitalized throughout your documents.

## Why this matters

- **Professional appearance**: Incorrect capitalization looks careless and unprofessional
- **Brand respect**: Shows you care about getting company and product names right
- **Consistency**: Readers won't be confused by different variations of the same name
- **Searchability**: Consistent naming improves search results and indexing

## Examples

### ✅ Correct

With configured names:

```yaml
names: ["JavaScript", "GitHub", "Node.js", "TypeScript"]
```

```markdown
# JavaScript Development Guide

This guide covers JavaScript best practices for GitHub projects.

We'll be using Node.js and TypeScript for our examples.
```

### ❌ Incorrect  

```markdown
# Javascript Development Guide        <!-- Should be "JavaScript" -->

This guide covers javascript best practices for github projects.
<!-- "javascript" and "github" are incorrectly capitalized -->

We'll be using NodeJS and typescript for our examples.
<!-- "NodeJS" should be "Node.js", "typescript" should be "TypeScript" -->
```

### 🔧 Fixed

```markdown
# JavaScript Development Guide

This guide covers JavaScript best practices for GitHub projects.

We'll be using Node.js and TypeScript for our examples.
```

## Configuration

```yaml
MD044:
  names:                     # List of properly capitalized names
    - "JavaScript"
    - "GitHub"  
    - "Node.js"
    - "npm"                  # Yes, npm is lowercase!
  code_blocks: false         # Check inside code blocks (default: true)
  html_elements: true        # Check inside HTML elements (default: true)
```

## Automatic fixes

When enabled, this rule will:
- Replace all incorrect capitalizations with the proper version
- Preserve the context and meaning of your text
- Work across headings, paragraphs, and lists

## Special cases

- Only checks names you've configured
- Won't check inside URLs or file paths
- Respects `code_blocks` setting for technical documentation
- Some names are intentionally lowercase (like "npm")

## Learn more

- [Writing style guides](https://developers.google.com/style/word-list)
- [Technical writing best practices](https://docs.microsoft.com/style-guide/capitalization)

## Related rules

- [MD033](md033.md) - Control HTML usage in Markdown
- [MD040](md040.md) - Identify code block languages
- [MD049](md049.md) - Use consistent emphasis markers
