# MD048 - Code fence style should be consistent

## What this rule does

Ensures all code blocks use the same fence markers - either ``` or ~~~ consistently.

## Why this matters

- **Consistency**: Mixed fence styles look unprofessional
- **Readability**: Consistent markers make code blocks easier to spot
- **Tool compatibility**: Some tools may expect one style over another

## Examples

### ✅ Correct (using ``` throughout)

````markdown
```javascript
function hello() {
  console.log("Hello, world!");
}
```

```python
def hello():
    print("Hello, world!")
```
````

### ✅ Correct (using ~~~ throughout)

````markdown
~~~javascript
function hello() {
  console.log("Hello, world!");
}
~~~

~~~python
def hello():
    print("Hello, world!")
~~~
````

### ❌ Incorrect (mixed styles)

<!-- rumdl-disable MD048 MD031 MD040 -->

````markdown
```javascript
function hello() {
  console.log("Hello, world!");
}
```

~~~python
def hello():
    print("Hello, world!")
~~~
````

<!-- rumdl-enable MD048 MD031 MD040 -->

### 🔧 Fixed

````markdown
```javascript
function hello() {
  console.log("Hello, world!");
}
```

```python
def hello():
    print("Hello, world!")
```
````

## Configuration

```yaml
MD048:
  style: "consistent"  # Options: "consistent", "backtick", "tilde"
```

### Style options

- `"consistent"` (default): Use whatever style appears first in your document
- `"backtick"`: Always use ``` markers
- `"tilde"`: Always use ~~~ markers

## Automatic fixes

This rule automatically converts all code fence markers to match your configured style or the first style found.

## Learn more

- [CommonMark code fences](https://spec.commonmark.org/0.31.2/#fenced-code-blocks) - Technical specification
- [GitHub Flavored Markdown](https://github.github.com/gfm/#fenced-code-blocks) - Code block syntax

## Related rules

- [MD031](md031.md) - Code blocks need blank lines around them
- [MD040](md040.md) - Code blocks should have a language specified
- [MD046](md046.md) - Code block style should be consistent
