! A subroutine in the style of hplog5 to make the transition easier for us
      subroutine hpoly5(x,nw,Hr1,Hr2,Hr3,Hr4,Hr5,n1,n2)
******
** x is the argument of the 1dHPL's (1 dimensional Harmonic PolyLogarithms)
**   to be evaluated;
** nw is the maximum weight of the required 1dHPL's;
**    the maximum allowed value of nw of this implementation is 5;
** Hr1,Hr2,Hr3,Hr4,Hr5 are the double precision real parts of
**    Hc1,Hc2,Hc3,Hc4,Hc5;
** n1,n2 is the required range of indices, the allowed ranges are
**    (0,1), (-1,0), (-1,1) ;
******
      implicit double precision (a-h,o-z)
      dimension Hr1(n1:n2),Hr2(n1:n2,n1:n2),Hr3(n1:n2,n1:n2,n1:n2),
     $          Hr4(n1:n2,n1:n2,n1:n2,n1:n2),
     $          Hr5(n1:n2,n1:n2,n1:n2,n1:n2,n1:n2)

      INTEGER IW
      COMMON /WEIGHT/  IW

      logical, save :: initialised = .false.

      integer i1,i2,i3,i4,i5
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8
      real* 8 xval
      
!     check on the weight nw
      if ( (nw.lt.1).or.(nw.gt.5) ) then
        print*, ' illegal call of eval1dhpl with second argument',
     $          ' (the weight) = ',nw
        print*, ' the allowed values of the weight are 1,2,3,5 '
        stop
      endif

      IW = nw
      
!     * check on the range n1:n2
      if(n1.ge.n2 .or. n1.lt.-1 .or. n1.gt.0 .or. n2.lt.0 .or. n2.gt.1)
     $     then
         print*, ' illegal call of hpoly with the two last ',
     $        'arguments = (',n1,',',n2,')'
         print*, ' the allowed values are (-1,0), (0,1), (-1,1) '
         stop
      endif

      if(.not.initialised) then
         CALL HPOLYIN
         CALL HBASIN
         initialised = .true.
      endif
      
!     Set everything to zero
      Hr1 = 0d0
      Hr2 = 0d0
      Hr3 = 0d0
      Hr4 = 0d0
      Hr5 = 0d0

      if(x.lt.0d0) then
         stop 'x must be zero or positive'
      elseif(x.gt.1d0) then
         stop 'x must be less than or equal to one'
      endif

      if(nw.ge.1) then
         call get_hplog_w1(n1,n2,Hr1,x)
      endif
      
      if(nw.ge.2) then
         call get_hplog_w2(n1,n2,Hr1,Hr2,x)
      else
         return
      endif
      
      if(nw.ge.3) then
         call get_hplog_w3(n1,n2,Hr1,Hr2,Hr3,x)
      else
         return
      endif
      
      if(nw.ge.4) then
         call get_hplog_w4(n1,n2,Hr1,Hr2,Hr3,Hr4,x)
      else
         return
      endif

      if(nw.ge.5) then
         call get_hplog_w5(n1,n2,Hr1,Hr2,Hr3,Hr4,Hr5,x)
      else
         return
      endif

      end
      
      subroutine get_hplog_w1(n1,n2,Hr1,x)
      implicit none
      integer n1,n2
      real * 8 Hr1(n1:n2), x
      integer i1
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8

      do i1 = n1,n2
         Hr1(i1) = H1(i1,x)
      enddo

      end

      subroutine get_hplog_w2(n1,n2,Hr1,Hr2,x)
      implicit none
      integer n1,n2
      real * 8 Hr1(n1:n2), Hr2(n1:n2,n1:n2), x, xlcl
      integer i1
      double precision, parameter :: ln2   = 0.6931471805599453d0
      double precision, parameter :: z2 = 1.644934066848226d0
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8, transform_x
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8, transform_x

      xlcl = transform_x(x)

      if(x.lt.sqrt(2.0d0) - 1.0d0) then
         Hr2(-1,-1) = Hr1(-1)**2/2.
         Hr2(-1,0) = H2(-1,0,x)
         Hr2(-1,1) = H2(-1,1,x)
         Hr2(0,-1) = -H2(-1,0,x) + Hr1(-1)*Hr1(0)
         Hr2(0,0) = Hr1(0)**2/2.
         Hr2(0,1) = H2(0,1,x)
         Hr2(1,-1) = -H2(-1,1,x) + Hr1(-1)*Hr1(1)
         Hr2(1,0) = -H2(0,1,x) + Hr1(0)*Hr1(1)
         Hr2(1,1) = Hr1(1)**2/2.
      elseif(x.le.1.0d0) then
         Hr2(-1,-1) = Hr1(-1)**2/2.
         Hr2(-1,0) = -0.5*z2 + H1(-1,xlcl)**2/2. + H2(-1,1,xlcl)
         Hr2(-1,1) = -0.5*H1(-1,xlcl)**2 + H2(-1,0,xlcl) + H1(-1,xlcl)
     $        *ln2 + (z2 - ln2**2)/2.
         Hr2(0,-1) = Hr1(-1)*Hr1(0) - Hr2(-1,0)
         Hr2(0,0) = Hr1(0)**2/2.
         Hr2(0,1) = z2 - H1(-1,xlcl)**2/2. + H2(-1,0,xlcl) + H2(-1,1
     $        ,xlcl) - H2(0,1,xlcl) + H1(1,xlcl)*(H1(0,xlcl) + ln2)
     $        + H1(-1,xlcl)*(-H1(1,xlcl) + ln2)
         Hr2(1,-1) = Hr1(-1)*Hr1(1) - Hr2(-1,1)
         Hr2(1,0) = Hr1(0)*Hr1(1) - Hr2(0,1)
         Hr2(1,1) = Hr1(1)**2/2.
      endif
      
      end
      
      subroutine get_hplog_w3(n1,n2,Hr1,Hr2,Hr3,x)
      implicit none
      integer n1,n2
      real * 8 Hr1(n1:n2), Hr2(n1:n2,n1:n2), Hr3(n1:n2,n1:n2,n1:n2)
      real * 8 x, xlcl
      integer i1
      double precision, parameter :: ln2   = 0.6931471805599453d0
      double precision, parameter :: z2 = 1.644934066848226d0
      double precision, parameter :: z3 = 1.202056903159594d0
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8, transform_x
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8, transform_x

      xlcl = transform_x(x)

      if(x.lt.sqrt(2.0d0) - 1.0d0) then
         Hr3(-1,-1,-1) = (Hr1(-1)*Hr2(-1,-1))/3.
         Hr3(-1,-1,0) = H3(-1,-1,0,x)
         Hr3(-1,-1,1) = H3(-1,-1,1,x)
         Hr3(-1,0,-1) = -2*H3(-1,-1,0,x) + Hr1(-1)*Hr2(-1,0)
         Hr3(-1,0,0) = H3(-1,0,0,x)
         Hr3(-1,0,1) = H3(-1,0,1,x)
         Hr3(-1,1,-1) = -2*H3(-1,-1,1,x) + Hr1(-1)*Hr2(-1,1)
         Hr3(-1,1,0) = H3(-1,1,0,x)
         Hr3(-1,1,1) = H3(-1,1,1,x)
         Hr3(0,-1,-1) = H3(-1,-1,0,x) + Hr1(0)*Hr2(-1,-1) - Hr1(-1)*Hr2(
     $        -1,0)
         Hr3(0,-1,0) = -2*H3(-1,0,0,x) + Hr1(0)*Hr2(-1,0)
         Hr3(0,-1,1) = -H3(-1,0,1,x) - H3(-1,1,0,x) + Hr1(0)*Hr2(-1,1)
         Hr3(0,0,-1) = H3(-1,0,0,x) - (Hr1(0)*Hr2(-1,0))/2. + (Hr1(0)
     $        *Hr2(0,-1))/2.
         Hr3(0,0,0) = (Hr1(0)*Hr2(0,0))/3.
         Hr3(0,0,1) = H3(0,0,1,x)
         Hr3(0,1,-1) = H3(-1,1,0,x) - Hr1(0)*Hr2(-1,1) + Hr1(-1)*Hr2(0
     $        ,1)
         Hr3(0,1,0) = -2*H3(0,0,1,x) + Hr1(0)*Hr2(0,1)
         Hr3(0,1,1) = H3(0,1,1,x)
         Hr3(1,-1,-1) = H3(-1,-1,1,x) + Hr1(1)*Hr2(-1,-1) - Hr1(-1)*Hr2(
     $        -1,1)
         Hr3(1,-1,0) = -H3(-1,0,1,x) - H3(-1,1,0,x) + Hr1(1)*Hr2(-1,0)
         Hr3(1,-1,1) = -2*H3(-1,1,1,x) + Hr1(1)*Hr2(-1,1)
         Hr3(1,0,-1) = H3(-1,0,1,x) + Hr1(1)*Hr2(0,-1) - Hr1(-1)*Hr2(0
     $        ,1)
         Hr3(1,0,0) = H3(0,0,1,x) + Hr1(1)*Hr2(0,0) - Hr1(0)*Hr2(0,1)
         Hr3(1,0,1) = -2*H3(0,1,1,x) + Hr1(1)*Hr2(0,1)
         Hr3(1,1,-1) = H3(-1,1,1,x) - (Hr1(1)*Hr2(-1,1))/2. + (Hr1(1)
     $        *Hr2(1,-1))/2.
         Hr3(1,1,0) = H3(0,1,1,x) - (Hr1(1)*Hr2(0,1))/2. + (Hr1(1)*Hr2(1
     $        ,0))/2.
         Hr3(1,1,1) = (Hr1(1)*Hr2(1,1))/3.
      elseif(x.le.1.0d0) then
         Hr3(-1,-1,-1) = (Hr1(-1)*Hr2(-1,-1))/3.
         Hr3(-1,-1,0) = (z2*H1(-1,xlcl))/2. - H1(-1,xlcl)**3/6. - H3(
     $        -1,-1,1,xlcl) + (z3 - 4*z2*ln2)/8.
         Hr3(-1,-1,1) = H1(-1,xlcl)**3/6. - H3(-1,-1,0,xlcl) - (H1(-1
     $        ,xlcl)**2*ln2)/2. + (H1(-1,xlcl)*(-z2 + ln2
     $        **2))/2. + (3*z3 - 4*ln2**3)/24.
         Hr3(-1,0,-1) = Hr1(-1)*Hr2(-1,0) - 2*Hr3(-1,-1,0)
         Hr3(-1,0,0) = (3*z3)/4. - H1(-1,xlcl)**3/6. - H1(-1,xlcl)
     $        *H2(-1,1,xlcl) + H3(-1,-1,1,xlcl) - H3(-1,1,1,xlcl)
         Hr3(-1,0,1) = H1(-1,xlcl)**3/6. + H1(-1,xlcl)*(-z2 + H2(-1,1
     $        ,xlcl)) - H3(-1,-1,0,xlcl) - 2*H3(-1,-1,1,xlcl) - H3(-1,1
     $        ,0,xlcl) - (H1(-1,xlcl)**2*ln2)/2. - H2(-1,1,xlcl)
     $        *ln2 + (-5*z3 + 8*z2*ln2)/8.
         Hr3(-1,1,-1) = Hr1(-1)*Hr2(-1,1) - 2*Hr3(-1,-1,1)
         Hr3(-1,1,0) = H1(-1,xlcl)**3/6. + H1(-1,xlcl)*(z2 - H2(-1,0
     $        ,xlcl)) + 2*H3(-1,-1,0,xlcl) + H3(-1,-1,1,xlcl) - H3(-1,0
     $        ,1,xlcl) + (-2*z3 + z2*ln2)/2.
         Hr3(-1,1,1) = -0.16666666666666666*H1(-1,xlcl)**3 - H3(-1,-1,0
     $        ,xlcl) - H3(-1,0,0,xlcl) + (H1(-1,xlcl)**2*ln2)/2. -
     $        H2(-1,0,xlcl)*ln2 + H1(-1,xlcl)*(H2(-1,0,xlcl) -
     $        ln2**2/2.) + (21*z3 - 12*z2*ln2 + 4*ln2
     $        **3)/24.
         Hr3(0,-1,-1) = Hr1(0)*Hr2(-1,-1) - Hr1(-1)*Hr2(-1,0) + Hr3(-1,
     $        -1,0)
         Hr3(0,-1,0) = Hr1(0)*Hr2(-1,0) - 2*Hr3(-1,0,0)
         Hr3(0,-1,1) = Hr1(0)*Hr2(-1,1) - Hr3(-1,0,1) - Hr3(-1,1,0)
         Hr3(0,0,-1) = -0.5*(Hr1(0)*Hr2(-1,0)) + (Hr1(0)*Hr2(0,-1))/2. +
     $        Hr3(-1,0,0)
         Hr3(0,0,0) = (Hr1(0)*Hr2(0,0))/3.
         Hr3(0,0,1) = z3 + H1(-1,xlcl)**3/6. + H1(1,xlcl)*(-z2 -
     $        H2(-1,0,xlcl) - H2(-1,1,xlcl) + H2(0,1,xlcl)) - H3(-1,-1,0
     $        ,xlcl) - H3(-1,-1,1,xlcl) + H3(-1,0,1,xlcl) + H3(-1,1,1
     $        ,xlcl) - H3(0,1,1,xlcl) + H1(1,xlcl)**2*(-0.5*H1(0,xlcl) -
     $        ln2/2.) + H1(-1,xlcl)**2*(H1(1,xlcl)/2. - ln2/2.)
     $        + H1(-1,xlcl)*(-z2 + H1(1,xlcl)**2/2. - H1(1,xlcl)
     $        *ln2)
         Hr3(0,1,-1) = -(Hr1(0)*Hr2(-1,1)) + Hr1(-1)*Hr2(0,1) + Hr3(-1,1
     $        ,0)
         Hr3(0,1,0) = Hr1(0)*Hr2(0,1) - 2*Hr3(0,0,1)
         Hr3(0,1,1) = z3 - H1(-1,xlcl)**3/6. + H1(0,xlcl)*H2(0,1
     $        ,xlcl) - H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) - H3(-1,0,0
     $        ,xlcl) - H3(-1,1,0,xlcl) - H3(0,0,1,xlcl) + H1(-1,xlcl)**2
     $        *(-0.5*H1(1,xlcl) + ln2/2.) - H2(-1,0,xlcl)*ln2 -
     $        H2(-1,1,xlcl)*ln2 + H2(0,1,xlcl)*ln2 + H1(1,xlcl)
     $        *(-0.5*H1(0,xlcl)**2 - H1(0,xlcl)*ln2 - ln2**2/2.)
     $        + H1(-1,xlcl)*(H2(-1,0,xlcl) + H2(-1,1,xlcl) - H2(0,1
     $        ,xlcl) - ln2**2/2. + H1(1,xlcl)*(H1(0,xlcl) +
     $        ln2))
         Hr3(1,-1,-1) = Hr1(1)*Hr2(-1,-1) - Hr1(-1)*Hr2(-1,1) + Hr3(-1,
     $        -1,1)
         Hr3(1,-1,0) = Hr1(1)*Hr2(-1,0) - Hr3(-1,0,1) - Hr3(-1,1,0)
         Hr3(1,-1,1) = Hr1(1)*Hr2(-1,1) - 2*Hr3(-1,1,1)
         Hr3(1,0,-1) = Hr1(1)*Hr2(0,-1) - Hr1(-1)*Hr2(0,1) + Hr3(-1,0,1)
         Hr3(1,0,0) = Hr1(1)*Hr2(0,0) - Hr1(0)*Hr2(0,1) + Hr3(0,0,1)
         Hr3(1,0,1) = Hr1(1)*Hr2(0,1) - 2*Hr3(0,1,1)
         Hr3(1,1,-1) = -0.5*(Hr1(1)*Hr2(-1,1)) + (Hr1(1)*Hr2(1,-1))/2. +
     $        Hr3(-1,1,1)
         Hr3(1,1,0) = -0.5*(Hr1(1)*Hr2(0,1)) + (Hr1(1)*Hr2(1,0))/2. +
     $        Hr3(0,1,1)
         Hr3(1,1,1) = (Hr1(1)*Hr2(1,1))/3.
      endif
      
      end
      
      subroutine get_hplog_w4(n1,n2,Hr1,Hr2,Hr3,Hr4,x)
      implicit none
      integer n1,n2
      real * 8 Hr1(n1:n2), Hr2(n1:n2,n1:n2), Hr3(n1:n2,n1:n2,n1:n2)
      real * 8 Hr4(n1:n2,n1:n2,n1:n2,n1:n2)
      real * 8 x, xlcl
      integer i1
      double precision, parameter :: ln2   = 0.6931471805599453d0
      double precision, parameter :: z2 = 1.644934066848226d0
      double precision, parameter :: z3 = 1.202056903159594d0
      double precision, parameter :: li4half = 0.5174790616738994d0
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8, transform_x
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8, transform_x

      xlcl = transform_x(x)

      if(x.lt.sqrt(2.0d0) - 1.0d0) then
         Hr4(-1,-1,-1,-1) = Hr2(-1,-1)**2/6.

         Hr4(-1,-1,-1,0) = H4(-1,-1,-1,0,x)

         Hr4(-1,-1,-1,1) = H4(-1,-1,-1,1,x)
         
         Hr4(-1,-1,0,-1) = -3*H4(-1,-1,-1,0,x) + Hr1(-1)*Hr3(-1,-1,0)

         Hr4(-1,-1,0,0) = H4(-1,-1,0,0,x)

         Hr4(-1,-1,0,1) = H4(-1,-1,0,1,x)

         Hr4(-1,-1,1,-1) = -3*H4(-1,-1,-1,1,x) + Hr1(-1)*Hr3(-1,-1,1)

         Hr4(-1,-1,1,0) = H4(-1,-1,1,0,x)

         Hr4(-1,-1,1,1) = H4(-1,-1,1,1,x)

         Hr4(-1,0,-1,-1) = 3*H4(-1,-1,-1,0,x) + Hr2(-1,-1)*Hr2(-1,0) - 2
     $        *Hr1(-1)*Hr3(-1,-1,0)

         Hr4(-1,0,-1,0) = -2*H4(-1,-1,0,0,x) + Hr2(-1,0)**2/2.

         Hr4(-1,0,-1,1) = H4(-1,0,-1,1,x)

         Hr4(-1,0,0,-1) = -0.5*Hr2(-1,0)**2 + Hr1(-1)*Hr3(-1,0,0)

         Hr4(-1,0,0,0) = H4(-1,0,0,0,x)

         Hr4(-1,0,0,1) = H4(-1,0,0,1,x)

         Hr4(-1,0,1,-1) = -2*H4(-1,-1,0,1,x) - H4(-1,0,-1,1,x) + Hr1(-1)
     $        *Hr3(-1,0,1)

         Hr4(-1,0,1,0) = H4(-1,0,1,0,x)

         Hr4(-1,0,1,1) = H4(-1,0,1,1,x)

         Hr4(-1,1,-1,-1) = 3*H4(-1,-1,-1,1,x) + Hr2(-1,-1)*Hr2(-1,1) - 2
     $        *Hr1(-1)*Hr3(-1,-1,1)

         Hr4(-1,1,-1,0) = -2*H4(-1,-1,0,1,x) - 2*H4(-1,-1,1,0,x) - H4(-1
     $        ,0,-1,1,x) + Hr2(-1,0)*Hr2(-1,1)

         Hr4(-1,1,-1,1) = -2*H4(-1,-1,1,1,x) + Hr2(-1,1)**2/2.

         Hr4(-1,1,0,-1) = 2*H4(-1,-1,0,1,x) + H4(-1,0,-1,1,x) - Hr2(-1
     $        ,0)*Hr2(-1,1) + Hr1(-1)*Hr3(-1,1,0)

         Hr4(-1,1,0,0) = H4(-1,1,0,0,x)

         Hr4(-1,1,0,1) = H4(-1,1,0,1,x)

         Hr4(-1,1,1,-1) = -0.5*Hr2(-1,1)**2 + Hr1(-1)*Hr3(-1,1,1)

         Hr4(-1,1,1,0) = H4(-1,1,1,0,x)

         Hr4(-1,1,1,1) = H4(-1,1,1,1,x)

         Hr4(0,-1,-1,-1) = -H4(-1,-1,-1,0,x) - (2*Hr2(-1,-1)*Hr2(-1,0))
     $        /3. + (Hr2(-1,-1)*Hr2(0,-1))/3. + Hr1(-1)*Hr3(-1,-1,0)

         Hr4(0,-1,-1,0) = -0.5*Hr2(-1,0)**2 + Hr1(0)*Hr3(-1,-1,0)

         Hr4(0,-1,-1,1) = -H4(-1,-1,0,1,x) - H4(-1,-1,1,0,x) - H4(-1,0,
     $        -1,1,x) + Hr1(0)*Hr3(-1,-1,1)

         Hr4(0,-1,0,-1) = 2*H4(-1,-1,0,0,x) + (3*Hr2(-1,0)**2)/2. + Hr2(
     $        -1,0)*Hr2(0,-1) - 2*Hr1(0)*Hr3(-1,-1,0) - 2*Hr1(-1)*Hr3(-1
     $        ,0,0)

         Hr4(0,-1,0,0) = -3*H4(-1,0,0,0,x) + Hr1(0)*Hr3(-1,0,0)

         Hr4(0,-1,0,1) = -2*H4(-1,0,0,1,x) - H4(-1,0,1,0,x) + Hr1(0)
     $        *Hr3(-1,0,1)

         Hr4(0,-1,1,-1) = 2*H4(-1,-1,0,1,x) + 2*H4(-1,-1,1,0,x) + H4(-1
     $        ,0,-1,1,x) + Hr2(-1,0)*Hr2(-1,1) + Hr2(-1,1)*Hr2(0,-1) - 2
     $        *Hr1(0)*Hr3(-1,-1,1) - Hr1(-1)*Hr3(-1,0,1) - Hr1(-1)*Hr3(
     $        -1,1,0)

         Hr4(0,-1,1,0) = -H4(-1,0,1,0,x) - 2*H4(-1,1,0,0,x) + Hr1(0)
     $        *Hr3(-1,1,0)

         Hr4(0,-1,1,1) = -H4(-1,0,1,1,x) - H4(-1,1,0,1,x) - H4(-1,1,1,0
     $        ,x) + Hr1(0)*Hr3(-1,1,1)

         Hr4(0,0,-1,-1) = -H4(-1,-1,0,0,x) - (3*Hr2(-1,0)**2)/4. - (Hr2(
     $        -1,0)*Hr2(0,-1))/2. + Hr2(0,-1)**2/4. + Hr1(0)*Hr3(-1,-1
     $        ,0) + Hr1(-1)*Hr3(-1,0,0)

         Hr4(0,0,-1,0) = 3*H4(-1,0,0,0,x) + Hr2(-1,0)*Hr2(0,0) - 2
     $        *Hr1(0)*Hr3(-1,0,0)

         Hr4(0,0,-1,1) = H4(-1,0,0,1,x) + H4(-1,0,1,0,x) + H4(-1,1,0,0
     $        ,x) + Hr2(-1,1)*Hr2(0,0) - Hr1(0)*Hr3(-1,0,1) - Hr1(0)
     $        *Hr3(-1,1,0)

         Hr4(0,0,0,-1) = -H4(-1,0,0,0,x) - (2*Hr2(-1,0)*Hr2(0,0))/3. +
     $        (Hr2(0,-1)*Hr2(0,0))/3. + Hr1(0)*Hr3(-1,0,0)

         Hr4(0,0,0,0) = Hr2(0,0)**2/6.

         Hr4(0,0,0,1) = H4(0,0,0,1,x)

         Hr4(0,0,1,-1) = -H4(-1,1,0,0,x) - Hr2(-1,1)*Hr2(0,0) + Hr1(0)
     $        *Hr3(-1,1,0) + Hr1(-1)*Hr3(0,0,1)

         Hr4(0,0,1,0) = -3*H4(0,0,0,1,x) + Hr1(0)*Hr3(0,0,1)

         Hr4(0,0,1,1) = H4(0,0,1,1,x)

         Hr4(0,1,-1,-1) = -H4(-1,-1,1,0,x) - Hr2(-1,0)*Hr2(-1,1) - Hr2(
     $        -1,1)*Hr2(0,-1) + Hr2(-1,-1)*Hr2(0,1) + Hr1(0)*Hr3(-1,-1
     $        ,1) + Hr1(-1)*Hr3(-1,1,0)

         Hr4(0,1,-1,0) = H4(-1,0,1,0,x) + 2*H4(-1,1,0,0,x) + Hr2(-1,0)
     $        *Hr2(0,1) - Hr1(0)*Hr3(-1,0,1) - Hr1(0)*Hr3(-1,1,0)

         Hr4(0,1,-1,1) = H4(-1,1,0,1,x) + 2*H4(-1,1,1,0,x) + Hr2(-1,1)
     $        *Hr2(0,1) - 2*Hr1(0)*Hr3(-1,1,1)

         Hr4(0,1,0,-1) = -H4(-1,0,1,0,x) + Hr2(0,-1)*Hr2(0,1) + Hr1(0)
     $        *Hr3(-1,0,1) - 2*Hr1(-1)*Hr3(0,0,1)

         Hr4(0,1,0,0) = 3*H4(0,0,0,1,x) + Hr2(0,0)*Hr2(0,1) - 2*Hr1(0)
     $        *Hr3(0,0,1)
         
         Hr4(0,1,0,1) = -2*H4(0,0,1,1,x) + Hr2(0,1)**2/2.

         Hr4(0,1,1,-1) = -H4(-1,1,1,0,x) - Hr2(-1,1)*Hr2(0,1) + Hr1(0)
     $        *Hr3(-1,1,1) + Hr1(-1)*Hr3(0,1,1)

         Hr4(0,1,1,0) = -0.5*Hr2(0,1)**2 + Hr1(0)*Hr3(0,1,1)

         Hr4(0,1,1,1) = H4(0,1,1,1,x)

         Hr4(1,-1,-1,-1) = -H4(-1,-1,-1,1,x) - (2*Hr2(-1,-1)*Hr2(-1,1))
     $        /3. + (Hr2(-1,-1)*Hr2(1,-1))/3. + Hr1(-1)*Hr3(-1,-1,1)

         Hr4(1,-1,-1,0) = H4(-1,-1,0,1,x) + H4(-1,-1,1,0,x) + H4(-1,0,-1
     $        ,1,x) - Hr2(-1,0)*Hr2(-1,1) + Hr1(1)*Hr3(-1,-1,0)

         Hr4(1,-1,-1,1) = -0.5*Hr2(-1,1)**2 + Hr1(1)*Hr3(-1,-1,1)

         Hr4(1,-1,0,-1) = -H4(-1,0,-1,1,x) + 2*Hr2(-1,0)*Hr2(-1,1) +
     $        Hr2(-1,0)*Hr2(1,-1) - 2*Hr1(1)*Hr3(-1,-1,0) - Hr1(-1)*Hr3(
     $        -1,0,1) - Hr1(-1)*Hr3(-1,1,0)

         Hr4(1,-1,0,0) = -H4(-1,0,0,1,x) - H4(-1,0,1,0,x) - H4(-1,1,0,0
     $        ,x) + Hr1(1)*Hr3(-1,0,0)

         Hr4(1,-1,0,1) = -2*H4(-1,0,1,1,x) - H4(-1,1,0,1,x) + Hr1(1)
     $        *Hr3(-1,0,1)
         
         Hr4(1,-1,1,-1) = 2*H4(-1,-1,1,1,x) + (3*Hr2(-1,1)**2)/2. + Hr2(
     $        -1,1)*Hr2(1,-1) - 2*Hr1(1)*Hr3(-1,-1,1) - 2*Hr1(-1)*Hr3(-1
     $        ,1,1)
         
         Hr4(1,-1,1,0) = -H4(-1,1,0,1,x) - 2*H4(-1,1,1,0,x) + Hr1(1)
     $        *Hr3(-1,1,0)

         Hr4(1,-1,1,1) = -3*H4(-1,1,1,1,x) + Hr1(1)*Hr3(-1,1,1)

         Hr4(1,0,-1,-1) = -H4(-1,-1,0,1,x) - (Hr2(-1,0)*Hr2(-1,1))/2. +
     $        (Hr2(-1,1)*Hr2(0,-1))/2. - Hr2(-1,-1)*Hr2(0,1) - (Hr2(-1
     $        ,0)*Hr2(1,-1))/2. + (Hr2(0,-1)*Hr2(1,-1))/2. + Hr1(1)*Hr3(
     $        -1,-1,0) + Hr1(-1)*Hr3(-1,0,1)

         Hr4(1,0,-1,0) = 2*H4(-1,0,0,1,x) + H4(-1,0,1,0,x) + Hr2(-1,0)
     $        *Hr2(1,0) - 2*Hr1(1)*Hr3(-1,0,0)

         Hr4(1,0,-1,1) = 2*H4(-1,0,1,1,x) + H4(-1,1,0,1,x) + Hr2(-1,1)
     $        *Hr2(1,0) - Hr1(1)*Hr3(-1,0,1) - Hr1(1)*Hr3(-1,1,0)

         Hr4(1,0,0,-1) = -H4(-1,0,0,1,x) + Hr2(-1,1)*Hr2(0,0) - Hr2(-1
     $        ,0)*Hr2(0,1) - Hr2(0,-1)*Hr2(0,1) + Hr2(0,0)*Hr2(1,-1) -
     $        Hr2(-1,0)*Hr2(1,0) + Hr1(1)*Hr3(-1,0,0) + Hr1(-1)*Hr3(0,0
     $        ,1)

         Hr4(1,0,0,0) = -H4(0,0,0,1,x) - (2*Hr2(0,0)*Hr2(0,1))/3. +
     $        (Hr2(0,0)*Hr2(1,0))/3. + Hr1(0)*Hr3(0,0,1)

         Hr4(1,0,0,1) = -0.5*Hr2(0,1)**2 + Hr1(1)*Hr3(0,0,1)
         
         Hr4(1,0,1,-1) = -H4(-1,1,0,1,x) + Hr2(-1,1)*Hr2(0,1) + Hr2(0,1)
     $        *Hr2(1,-1) - Hr2(-1,1)*Hr2(1,0) + Hr1(1)*Hr3(-1,1,0) - 2
     $        *Hr1(-1)*Hr3(0,1,1)

         Hr4(1,0,1,0) = 2*H4(0,0,1,1,x) + (3*Hr2(0,1)**2)/2. + Hr2(0,1)
     $        *Hr2(1,0) - 2*Hr1(1)*Hr3(0,0,1) - 2*Hr1(0)*Hr3(0,1,1)

         Hr4(1,0,1,1) = -3*H4(0,1,1,1,x) + Hr1(1)*Hr3(0,1,1)

         Hr4(1,1,-1,-1) = -H4(-1,-1,1,1,x) - (3*Hr2(-1,1)**2)/4. - (Hr2(
     $        -1,1)*Hr2(1,-1))/2. + Hr2(1,-1)**2/4. + Hr1(1)*Hr3(-1,-1
     $        ,1) + Hr1(-1)*Hr3(-1,1,1)

         Hr4(1,1,-1,0) = H4(-1,0,1,1,x) + H4(-1,1,0,1,x) + H4(-1,1,1,0
     $        ,x) + Hr2(-1,0)*Hr2(1,1) - Hr1(1)*Hr3(-1,0,1) - Hr1(1)
     $        *Hr3(-1,1,0)

         Hr4(1,1,-1,1) = 3*H4(-1,1,1,1,x) + Hr2(-1,1)*Hr2(1,1) - 2
     $        *Hr1(1)*Hr3(-1,1,1)

         Hr4(1,1,0,-1) = -H4(-1,0,1,1,x) - (Hr2(-1,1)*Hr2(0,1))/2. -
     $        (Hr2(0,1)*Hr2(1,-1))/2. + (Hr2(-1,1)*Hr2(1,0))/2. + (Hr2(1
     $        ,-1)*Hr2(1,0))/2. - Hr2(-1,0)*Hr2(1,1) + Hr1(1)*Hr3(-1,0
     $        ,1) + Hr1(-1)*Hr3(0,1,1)

         Hr4(1,1,0,0) = -H4(0,0,1,1,x) - (3*Hr2(0,1)**2)/4. - (Hr2(0,1)
     $        *Hr2(1,0))/2. + Hr2(1,0)**2/4. + Hr1(1)*Hr3(0,0,1) +
     $        Hr1(0)*Hr3(0,1,1)

         Hr4(1,1,0,1) = 3*H4(0,1,1,1,x) + Hr2(0,1)*Hr2(1,1) - 2*Hr1(1)
     $        *Hr3(0,1,1)

         Hr4(1,1,1,-1) = -H4(-1,1,1,1,x) - (2*Hr2(-1,1)*Hr2(1,1))/3. +
     $        (Hr2(1,-1)*Hr2(1,1))/3. + Hr1(1)*Hr3(-1,1,1)

         Hr4(1,1,1,0) = -H4(0,1,1,1,x) - (2*Hr2(0,1)*Hr2(1,1))/3. +
     $        (Hr2(1,0)*Hr2(1,1))/3. + Hr1(1)*Hr3(0,1,1)

         Hr4(1,1,1,1) = Hr2(1,1)**2/6.
      elseif(x.le.1.0d0) then
         Hr4(-1,-1,-1,-1) = Hr2(-1,-1)**2/6.

         Hr4(-1,-1,-1,0) = (120*li4half + 5*ln2**4 - 60*ln2**2*z2 - 48
     $        *z2**2 + 120*ln2*z3)/120. + ((4*ln2*z2 - z3)*H1(-1,xlcl))
     $        /8. - (z2*H1(-1,xlcl)**2)/4. + H1(-1,xlcl)**4/24. + H4(-1,
     $        -1,-1,1,xlcl)

         Hr4(-1,-1,-1,1) = (-120*li4half - 10*ln2**4 + 30*ln2**2*z2 + 48
     $        *z2**2 - 105*ln2*z3)/120. + ((4*ln2**3 - 3*z3)*H1(-1
     $        ,xlcl))/24. + ((-ln2**2 + z2)*H1(-1,xlcl)**2)/4. + (ln2
     $        *H1(-1,xlcl)**3)/6. - H1(-1,xlcl)**4/24. + H4(-1,-1,-1,0
     $        ,xlcl)

         Hr4(-1,-1,0,-1) = Hr1(-1)*Hr3(-1,-1,0) - 3*Hr4(-1,-1,-1,0)

         Hr4(-1,-1,0,0) = (-24*li4half - ln2**4 + 6*ln2**2*z2 + 9*z2**2
     $        - 12*ln2*z3)/12. + H1(-1,xlcl)**4/24. + H1(-1,xlcl)*((-3
     $        *z3)/4. + H3(-1,-1,1,xlcl)) - 2*H4(-1,-1,-1,1,xlcl) + H4(
     $        -1,-1,1,1,xlcl)

         Hr4(-1,-1,0,1) = (20*ln2**2*z2 + 3*z2**2 - 25*ln2*z3)/40. + (z2
     $        *H1(-1,xlcl)**2)/2. + (ln2*H1(-1,xlcl)**3)/6. - H1(-1
     $        ,xlcl)**4/24. + H1(-1,xlcl)*((-8*ln2*z2 + 5*z3)/8. - H3(-1
     $        ,-1,1,xlcl)) + ln2*H3(-1,-1,1,xlcl) + H4(-1,-1,-1,0,xlcl)
     $        + 3*H4(-1,-1,-1,1,xlcl) + H4(-1,-1,1,0,xlcl)

         Hr4(-1,-1,1,-1) = Hr1(-1)*Hr3(-1,-1,1) - 3*Hr4(-1,-1,-1,1)

         Hr4(-1,-1,1,0) = (48*li4half + 2*ln2**4 - 6*ln2**2*z2 - 21*z2
     $        **2 + 39*ln2*z3)/24. - (z2*H1(-1,xlcl)**2)/2. - H1(-1
     $        ,xlcl)**4/24. + H1(-1,xlcl)*((-(ln2*z2) + 2*z3)/2. + H3(-1
     $        ,-1,0,xlcl)) - 3*H4(-1,-1,-1,0,xlcl) - H4(-1,-1,-1,1,xlcl)
     $        + H4(-1,-1,0,1,xlcl)

         Hr4(-1,-1,1,1) = (5*ln2**4 + 6*z2**2 - 15*ln2*z3)/120. + (ln2
     $        **2*H1(-1,xlcl)**2)/4. - (ln2*H1(-1,xlcl)**3)/6. + H1(-1
     $        ,xlcl)**4/24. + H1(-1,xlcl)*((-4*ln2**3 + 12*ln2*z2 - 21
     $        *z3)/24. - H3(-1,-1,0,xlcl)) + ln2*H3(-1,-1,0,xlcl) + 2
     $        *H4(-1,-1,-1,0,xlcl) + H4(-1,-1,0,0,xlcl)

         Hr4(-1,0,-1,-1) = Hr2(-1,-1)*Hr2(-1,0) - 2*Hr1(-1)*Hr3(-1,-1,0)
     $        + 3*Hr4(-1,-1,-1,0)

         Hr4(-1,0,-1,0) = Hr2(-1,0)**2/2. - 2*Hr4(-1,-1,0,0)

         Hr4(-1,0,-1,1) = (-48*li4half - 2*ln2**4 - 6*ln2**2*z2 + 15*z2
     $        **2 - 12*ln2*z3)/12. + (ln2*H1(-1,xlcl)**3)/6. - H1(-1
     $        ,xlcl)**4/24. + H1(-1,xlcl)**2*((-ln2**2 + z2)/4. - H2(-1
     $        ,1,xlcl)/2.) + ((-ln2**2 + z2)/2. + H2(-1,0,xlcl))*H2(-1,1
     $        ,xlcl) - 2*ln2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)*((12*ln2*z2
     $        - 13*z3)/8. + ln2*H2(-1,1,xlcl) + 2*H3(-1,-1,1,xlcl)) +
     $        H4(-1,-1,-1,0,xlcl) - 3*H4(-1,-1,-1,1,xlcl) - 2*H4(-1,-1,0
     $        ,1,xlcl) - 2*H4(-1,-1,1,0,xlcl) - H4(-1,0,-1,1,xlcl)

         Hr4(-1,0,0,-1) = -0.5*Hr2(-1,0)**2 + Hr1(-1)*Hr3(-1,0,0)
         
         Hr4(-1,0,0,0) = (-7*z2**2)/20. + H1(-1,xlcl)**4/24. + (H1(-1
     $        ,xlcl)**2*H2(-1,1,xlcl))/2. + H1(-1,xlcl)*(-H3(-1,-1,1
     $        ,xlcl) + H3(-1,1,1,xlcl)) + H4(-1,-1,-1,1,xlcl) - H4(-1,-1
     $        ,1,1,xlcl) + H4(-1,1,1,1,xlcl)

         Hr4(-1,0,0,1) = (-120*li4half - 5*ln2**4 + 30*ln2**2*z2 + 36*z2
     $        **2 - 45*ln2*z3)/60. + (ln2*H1(-1,xlcl)**3)/6. - H1(-1
     $        ,xlcl)**4/24. + H1(-1,xlcl)**2*(z2/2. - H2(-1,1,xlcl)/2.)
     $        + (z2 + H2(-1,0,xlcl))*H2(-1,1,xlcl) + H2(-1,1,xlcl)**2/2.
     $        - ln2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)*(-z3 + ln2*H2(-1,1
     $        ,xlcl) + H3(-1,-1,1,xlcl) - H3(-1,1,1,xlcl)) + ln2*H3(-1,1
     $        ,1,xlcl) + H4(-1,-1,-1,0,xlcl) - 2*H4(-1,-1,0,1,xlcl) -
     $        H4(-1,-1,1,0,xlcl) - H4(-1,0,-1,1,xlcl) + H4(-1,1,1,0
     $        ,xlcl)

         Hr4(-1,0,1,-1) = Hr1(-1)*Hr3(-1,0,1) - 2*Hr4(-1,-1,0,1) - Hr4(
     $        -1,0,-1,1)

         Hr4(-1,0,1,0) = (480*li4half + 20*ln2**4 - 120*ln2**2*z2 - 153
     $        *z2**2 + 180*ln2*z3)/120. - H1(-1,xlcl)**4/24. + H1(-1
     $        ,xlcl)**2*(-0.5*z2 - H2(-1,1,xlcl)/2.) + (-z2 - H2(-1,0
     $        ,xlcl))*H2(-1,1,xlcl) - H2(-1,1,xlcl)**2/2. + H1(-1,xlcl)
     $        *(2*z3 + H3(-1,-1,0,xlcl) + 2*H3(-1,-1,1,xlcl) + H3(-1,1,0
     $        ,xlcl)) - 3*H4(-1,-1,-1,0,xlcl) - 4*H4(-1,-1,-1,1,xlcl) +
     $        3*H4(-1,-1,0,1,xlcl) + 2*H4(-1,-1,1,1,xlcl) + H4(-1,0,-1,1
     $        ,xlcl) + H4(-1,1,0,1,xlcl)

         Hr4(-1,0,1,1) = (-24*li4half - ln2**4 + 6*ln2**2*z2 + 3*z2**2 +
     $        3*ln2*z3)/24. - (ln2*H1(-1,xlcl)**3)/6. + H1(-1,xlcl)**4
     $        /24. + H1(-1,xlcl)**2*(ln2**2/4. + H2(-1,1,xlcl)/2.) +
     $        (ln2**2*H2(-1,1,xlcl))/2. + ln2*H3(-1,-1,0,xlcl) + 2*ln2
     $        *H3(-1,-1,1,xlcl) + H1(-1,xlcl)*(-z3 - ln2*H2(-1,1,xlcl) -
     $        H3(-1,-1,0,xlcl) - 2*H3(-1,-1,1,xlcl) - H3(-1,1,0,xlcl)) +
     $        ln2*H3(-1,1,0,xlcl) + 2*H4(-1,-1,-1,0,xlcl) + 3*H4(-1,-1,
     $        -1,1,xlcl) + H4(-1,-1,0,0,xlcl) + 2*H4(-1,-1,1,0,xlcl) +
     $        H4(-1,1,0,0,xlcl)

         Hr4(-1,1,-1,-1) = Hr2(-1,-1)*Hr2(-1,1) - 2*Hr1(-1)*Hr3(-1,-1,1)
     $        + 3*Hr4(-1,-1,-1,1)

         Hr4(-1,1,-1,0) = Hr2(-1,0)*Hr2(-1,1) - 2*Hr4(-1,-1,0,1) - 2
     $        *Hr4(-1,-1,1,0) - Hr4(-1,0,-1,1)

         Hr4(-1,1,-1,1) = Hr2(-1,1)**2/2. - 2*Hr4(-1,-1,1,1)

         Hr4(-1,1,0,-1) = -(Hr2(-1,0)*Hr2(-1,1)) + Hr1(-1)*Hr3(-1,1,0) +
     $        2*Hr4(-1,-1,0,1) + Hr4(-1,0,-1,1)

         Hr4(-1,1,0,0) = (19*z2**2 - 30*ln2*z3)/40. - H1(-1,xlcl)**4/24.
     $        + (H1(-1,xlcl)**2*H2(-1,0,xlcl))/2. + H1(-1,xlcl)*(-z3 - 2
     $        *H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) + H3(-1,0,1,xlcl)) +
     $        3*H4(-1,-1,-1,0,xlcl) + 2*H4(-1,-1,-1,1,xlcl) - 2*H4(-1,-1
     $        ,0,1,xlcl) - H4(-1,-1,1,1,xlcl) + H4(-1,0,1,1,xlcl)

         Hr4(-1,1,0,1) = (-120*li4half - 5*ln2**4 - 30*ln2**2*z2 + 57*z2
     $        **2 - 30*ln2*z3)/120. - (ln2*H1(-1,xlcl)**3)/6. + H1(-1
     $        ,xlcl)**4/24. + H1(-1,xlcl)**2*(-0.5*z2 - H2(-1,0,xlcl)
     $        /2.) + z2*H2(-1,0,xlcl) + H2(-1,0,xlcl)**2/2. - 2*ln2*H3(
     $        -1,-1,0,xlcl) - ln2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)*(ln2*z2
     $        + 2*z3 + ln2*H2(-1,0,xlcl) + 2*H3(-1,-1,0,xlcl) + H3(-1,-1
     $        ,1,xlcl) - H3(-1,0,1,xlcl)) + ln2*H3(-1,0,1,xlcl) - 4*H4(
     $        -1,-1,-1,0,xlcl) - 3*H4(-1,-1,-1,1,xlcl) - 2*H4(-1,-1,0,0
     $        ,xlcl) + 2*H4(-1,-1,0,1,xlcl) - H4(-1,-1,1,0,xlcl) + H4(-1
     $        ,0,-1,1,xlcl) + H4(-1,0,1,0,xlcl)

         Hr4(-1,1,1,-1) = -0.5*Hr2(-1,1)**2 + Hr1(-1)*Hr3(-1,1,1)

         Hr4(-1,1,1,0) = (-120*li4half - 5*ln2**4 - 6*z2**2 + 15*ln2*z3)
     $        /120. + H1(-1,xlcl)**4/24. + H1(-1,xlcl)**2*(z2/2. - H2(-1
     $        ,0,xlcl)/2.) - z2*H2(-1,0,xlcl) - H2(-1,0,xlcl)**2/2. +
     $        H1(-1,xlcl)*(-(ln2*z2) - z3 + H3(-1,-1,0,xlcl) + H3(-1,0,0
     $        ,xlcl)) + H4(-1,-1,-1,1,xlcl) - H4(-1,-1,0,1,xlcl) - H4(-1
     $        ,0,-1,1,xlcl) + H4(-1,0,0,1,xlcl)

         Hr4(-1,1,1,1) = li4half + (ln2*H1(-1,xlcl)**3)/6. - H1(-1,xlcl)
     $        **4/24. + H1(-1,xlcl)**2*(-0.25*ln2**2 + H2(-1,0,xlcl)/2.)
     $        + (ln2**2*H2(-1,0,xlcl))/2. + ln2*H3(-1,-1,0,xlcl) + H1(-1
     $        ,xlcl)*(ln2**3/6. - ln2*H2(-1,0,xlcl) - H3(-1,-1,0,xlcl) -
     $        H3(-1,0,0,xlcl)) + ln2*H3(-1,0,0,xlcl) + H4(-1,-1,-1,0
     $        ,xlcl) + H4(-1,-1,0,0,xlcl) + H4(-1,0,0,0,xlcl)

         Hr4(0,-1,-1,-1) = (-2*Hr2(-1,-1)*Hr2(-1,0))/3. + (Hr2(-1,-1)
     $        *Hr2(0,-1))/3. + Hr1(-1)*Hr3(-1,-1,0) - Hr4(-1,-1,-1,0)

         Hr4(0,-1,-1,0) = -0.5*Hr2(-1,0)**2 + Hr1(0)*Hr3(-1,-1,0)

         Hr4(0,-1,-1,1) = Hr1(0)*Hr3(-1,-1,1) - Hr4(-1,-1,0,1) - Hr4(-1,
     $        -1,1,0) - Hr4(-1,0,-1,1)

         Hr4(0,-1,0,-1) = (3*Hr2(-1,0)**2)/2. + Hr2(-1,0)*Hr2(0,-1) - 2
     $        *Hr1(0)*Hr3(-1,-1,0) - 2*Hr1(-1)*Hr3(-1,0,0) + 2*Hr4(-1,-1
     $        ,0,0)

         Hr4(0,-1,0,0) = Hr1(0)*Hr3(-1,0,0) - 3*Hr4(-1,0,0,0)

         Hr4(0,-1,0,1) = Hr1(0)*Hr3(-1,0,1) - 2*Hr4(-1,0,0,1) - Hr4(-1,0
     $        ,1,0)

         Hr4(0,-1,1,-1) = Hr2(-1,0)*Hr2(-1,1) + Hr2(-1,1)*Hr2(0,-1) - 2
     $        *Hr1(0)*Hr3(-1,-1,1) - Hr1(-1)*Hr3(-1,0,1) - Hr1(-1)*Hr3(
     $        -1,1,0) + 2*Hr4(-1,-1,0,1) + 2*Hr4(-1,-1,1,0) + Hr4(-1,0,
     $        -1,1)

         Hr4(0,-1,1,0) = Hr1(0)*Hr3(-1,1,0) - Hr4(-1,0,1,0) - 2*Hr4(-1,1
     $        ,0,0)

         Hr4(0,-1,1,1) = Hr1(0)*Hr3(-1,1,1) - Hr4(-1,0,1,1) - Hr4(-1,1,0
     $        ,1) - Hr4(-1,1,1,0)
         
         Hr4(0,0,-1,-1) = (-3*Hr2(-1,0)**2)/4. - (Hr2(-1,0)*Hr2(0,-1))
     $        /2. + Hr2(0,-1)**2/4. + Hr1(0)*Hr3(-1,-1,0) + Hr1(-1)*Hr3(
     $        -1,0,0) - Hr4(-1,-1,0,0)

         Hr4(0,0,-1,0) = Hr2(-1,0)*Hr2(0,0) - 2*Hr1(0)*Hr3(-1,0,0) + 3
     $        *Hr4(-1,0,0,0)

         Hr4(0,0,-1,1) = Hr2(-1,1)*Hr2(0,0) - Hr1(0)*Hr3(-1,0,1) -
     $        Hr1(0)*Hr3(-1,1,0) + Hr4(-1,0,0,1) + Hr4(-1,0,1,0) + Hr4(
     $        -1,1,0,0)

         Hr4(0,0,0,-1) = (-2*Hr2(-1,0)*Hr2(0,0))/3. + (Hr2(0,-1)*Hr2(0
     $        ,0))/3. + Hr1(0)*Hr3(-1,0,0) - Hr4(-1,0,0,0)

         Hr4(0,0,0,0) = Hr2(0,0)**2/6.

         Hr4(0,0,0,1) = (2*z2**2)/5. - H1(-1,xlcl)**4/24. + H1(-1,xlcl)
     $        **3*(ln2/6. - H1(1,xlcl)/6.) + (ln2/6. + H1(0,xlcl)/6.)
     $        *H1(1,xlcl)**3 + H1(-1,xlcl)**2*(z2/2. + (ln2*H1(1,xlcl))
     $        /2. - H1(1,xlcl)**2/4.) + H1(-1,xlcl)*(-z3 + z2*H1(1,xlcl)
     $        + (ln2*H1(1,xlcl)**2)/2. - H1(1,xlcl)**3/6.) + H1(1,xlcl)
     $        **2*(z2/2. + H2(-1,0,xlcl)/2. + H2(-1,1,xlcl)/2. - H2(0,1
     $        ,xlcl)/2.) + H1(1,xlcl)*(-z3 + H3(-1,-1,0,xlcl) + H3(-1,-1
     $        ,1,xlcl) - H3(-1,0,1,xlcl) - H3(-1,1,1,xlcl) + H3(0,1,1
     $        ,xlcl)) + H4(-1,-1,-1,0,xlcl) + H4(-1,-1,-1,1,xlcl) - H4(
     $        -1,-1,0,1,xlcl) - H4(-1,-1,1,1,xlcl) + H4(-1,0,1,1,xlcl) +
     $        H4(-1,1,1,1,xlcl) - H4(0,1,1,1,xlcl)

         Hr4(0,0,1,-1) = -(Hr2(-1,1)*Hr2(0,0)) + Hr1(0)*Hr3(-1,1,0) +
     $        Hr1(-1)*Hr3(0,0,1) - Hr4(-1,1,0,0)

         Hr4(0,0,1,0) = Hr1(0)*Hr3(0,0,1) - 3*Hr4(0,0,0,1)

         Hr4(0,0,1,1) = z2**2/10. + H1(-1,xlcl)**4/24. + H1(-1,xlcl)**3
     $        *(-0.16666666666666666*ln2 + H1(1,xlcl)/6.) + (ln2**2/4. +
     $        (ln2*H1(0,xlcl))/2. + H1(0,xlcl)**2/4.)*H1(1,xlcl)**2 +
     $        H1(-1,xlcl)**2*(ln2**2/4. - (ln2*H1(1,xlcl))/2. + H1(1
     $        ,xlcl)**2/4.) + ln2*H3(-1,-1,0,xlcl) + ln2*H3(-1,-1,1
     $        ,xlcl) - ln2*H3(-1,0,1,xlcl) - ln2*H3(-1,1,1,xlcl) + H1(1
     $        ,xlcl)*(-z3 + ln2*H2(-1,0,xlcl) + ln2*H2(-1,1,xlcl) - ln2
     $        *H2(0,1,xlcl) - H1(0,xlcl)*H2(0,1,xlcl) + H3(-1,-1,0,xlcl)
     $        + H3(-1,-1,1,xlcl) + H3(-1,0,0,xlcl) + H3(-1,1,0,xlcl) +
     $        H3(0,0,1,xlcl)) + H1(-1,xlcl)*(-z3 + (-0.5*ln2 - H1(0
     $        ,xlcl)/2.)*H1(1,xlcl)**2 + H1(1,xlcl)*(ln2**2/2. - H2(-1,0
     $        ,xlcl) - H2(-1,1,xlcl) + H2(0,1,xlcl)) - H3(-1,-1,0,xlcl)
     $        - H3(-1,-1,1,xlcl) + H3(-1,0,1,xlcl) + H3(-1,1,1,xlcl) -
     $        H3(0,1,1,xlcl)) + ln2*H3(0,1,1,xlcl) + H1(0,xlcl)*H3(0,1,1
     $        ,xlcl) + 2*H4(-1,-1,-1,0,xlcl) + 2*H4(-1,-1,-1,1,xlcl) +
     $        H4(-1,-1,0,0,xlcl) - H4(-1,-1,0,1,xlcl) + H4(-1,-1,1,0
     $        ,xlcl) - H4(-1,-1,1,1,xlcl) - H4(-1,0,0,1,xlcl) - H4(-1,0
     $        ,1,0,xlcl) - H4(-1,1,0,1,xlcl) - H4(-1,1,1,0,xlcl) - H4(0
     $        ,0,1,1,xlcl)

         Hr4(0,1,-1,-1) = -(Hr2(-1,0)*Hr2(-1,1)) - Hr2(-1,1)*Hr2(0,-1) +
     $        Hr2(-1,-1)*Hr2(0,1) + Hr1(0)*Hr3(-1,-1,1) + Hr1(-1)*Hr3(-1
     $        ,1,0) - Hr4(-1,-1,1,0)

         Hr4(0,1,-1,0) = Hr2(-1,0)*Hr2(0,1) - Hr1(0)*Hr3(-1,0,1) -
     $        Hr1(0)*Hr3(-1,1,0) + Hr4(-1,0,1,0) + 2*Hr4(-1,1,0,0)

         Hr4(0,1,-1,1) = Hr2(-1,1)*Hr2(0,1) - 2*Hr1(0)*Hr3(-1,1,1) +
     $        Hr4(-1,1,0,1) + 2*Hr4(-1,1,1,0)

         Hr4(0,1,0,-1) = Hr2(0,-1)*Hr2(0,1) + Hr1(0)*Hr3(-1,0,1) - 2
     $        *Hr1(-1)*Hr3(0,0,1) - Hr4(-1,0,1,0)

         Hr4(0,1,0,0) = Hr2(0,0)*Hr2(0,1) - 2*Hr1(0)*Hr3(0,0,1) + 3
     $        *Hr4(0,0,0,1)

         Hr4(0,1,0,1) = Hr2(0,1)**2/2. - 2*Hr4(0,0,1,1)

         Hr4(0,1,1,-1) = -(Hr2(-1,1)*Hr2(0,1)) + Hr1(0)*Hr3(-1,1,1) +
     $        Hr1(-1)*Hr3(0,1,1) - Hr4(-1,1,1,0)
         
         Hr4(0,1,1,0) = -0.5*Hr2(0,1)**2 + Hr1(0)*Hr3(0,1,1)

         Hr4(0,1,1,1) = (2*z2**2)/5. - H1(-1,xlcl)**4/24. + H1(-1,xlcl)
     $        **3*(ln2/6. - H1(1,xlcl)/6.) + (ln2**3/6. + (ln2**2*H1(0
     $        ,xlcl))/2. + (ln2*H1(0,xlcl)**2)/2. + H1(0,xlcl)**3/6.)
     $        *H1(1,xlcl) + (ln2**2*H2(-1,0,xlcl))/2. + (ln2**2*H2(-1,1
     $        ,xlcl))/2. + H1(-1,xlcl)**2*(-0.25*ln2**2 + (ln2/2. + H1(0
     $        ,xlcl)/2.)*H1(1,xlcl) + H2(-1,0,xlcl)/2. + H2(-1,1,xlcl)
     $        /2. - H2(0,1,xlcl)/2.) - (ln2**2*H2(0,1,xlcl))/2. - (H1(0
     $        ,xlcl)**2*H2(0,1,xlcl))/2. + ln2*H3(-1,-1,0,xlcl) + ln2
     $        *H3(-1,-1,1,xlcl) + ln2*H3(-1,0,0,xlcl) + ln2*H3(-1,1,0
     $        ,xlcl) + H1(-1,xlcl)*(ln2**3/6. + (-0.5*ln2**2 - ln2*H1(0
     $        ,xlcl) - H1(0,xlcl)**2/2.)*H1(1,xlcl) - ln2*H2(-1,0,xlcl)
     $        - ln2*H2(-1,1,xlcl) + ln2*H2(0,1,xlcl) + H1(0,xlcl)*H2(0,1
     $        ,xlcl) - H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) - H3(-1,0,0
     $        ,xlcl) - H3(-1,1,0,xlcl) - H3(0,0,1,xlcl)) + ln2*H3(0,0,1
     $        ,xlcl) + H1(0,xlcl)*(-(ln2*H2(0,1,xlcl)) + H3(0,0,1,xlcl))
     $        + H4(-1,-1,-1,0,xlcl) + H4(-1,-1,-1,1,xlcl) + H4(-1,-1,0,0
     $        ,xlcl) + H4(-1,-1,1,0,xlcl) + H4(-1,0,0,0,xlcl) + H4(-1,1
     $        ,0,0,xlcl) - H4(0,0,0,1,xlcl)

         Hr4(1,-1,-1,-1) = (-2*Hr2(-1,-1)*Hr2(-1,1))/3. + (Hr2(-1,-1)
     $        *Hr2(1,-1))/3. + Hr1(-1)*Hr3(-1,-1,1) - Hr4(-1,-1,-1,1)

         Hr4(1,-1,-1,0) = -(Hr2(-1,0)*Hr2(-1,1)) + Hr1(1)*Hr3(-1,-1,0) +
     $        Hr4(-1,-1,0,1) + Hr4(-1,-1,1,0) + Hr4(-1,0,-1,1)

         Hr4(1,-1,-1,1) = -0.5*Hr2(-1,1)**2 + Hr1(1)*Hr3(-1,-1,1)

         Hr4(1,-1,0,-1) = 2*Hr2(-1,0)*Hr2(-1,1) + Hr2(-1,0)*Hr2(1,-1) -
     $        2*Hr1(1)*Hr3(-1,-1,0) - Hr1(-1)*Hr3(-1,0,1) - Hr1(-1)*Hr3(
     $        -1,1,0) - Hr4(-1,0,-1,1)

         Hr4(1,-1,0,0) = Hr1(1)*Hr3(-1,0,0) - Hr4(-1,0,0,1) - Hr4(-1,0,1
     $        ,0) - Hr4(-1,1,0,0)

         Hr4(1,-1,0,1) = Hr1(1)*Hr3(-1,0,1) - 2*Hr4(-1,0,1,1) - Hr4(-1,1
     $        ,0,1)

         Hr4(1,-1,1,-1) = (3*Hr2(-1,1)**2)/2. + Hr2(-1,1)*Hr2(1,-1) - 2
     $        *Hr1(1)*Hr3(-1,-1,1) - 2*Hr1(-1)*Hr3(-1,1,1) + 2*Hr4(-1,-1
     $        ,1,1)

         Hr4(1,-1,1,0) = Hr1(1)*Hr3(-1,1,0) - Hr4(-1,1,0,1) - 2*Hr4(-1,1
     $        ,1,0)

         Hr4(1,-1,1,1) = Hr1(1)*Hr3(-1,1,1) - 3*Hr4(-1,1,1,1)

         Hr4(1,0,-1,-1) = -0.5*(Hr2(-1,0)*Hr2(-1,1)) + (Hr2(-1,1)*Hr2(0,
     $        -1))/2. - Hr2(-1,-1)*Hr2(0,1) - (Hr2(-1,0)*Hr2(1,-1))/2. +
     $        (Hr2(0,-1)*Hr2(1,-1))/2. + Hr1(1)*Hr3(-1,-1,0) + Hr1(-1)
     $        *Hr3(-1,0,1) - Hr4(-1,-1,0,1)

         Hr4(1,0,-1,0) = Hr2(-1,0)*Hr2(1,0) - 2*Hr1(1)*Hr3(-1,0,0) + 2
     $        *Hr4(-1,0,0,1) + Hr4(-1,0,1,0)

         Hr4(1,0,-1,1) = Hr2(-1,1)*Hr2(1,0) - Hr1(1)*Hr3(-1,0,1) -
     $        Hr1(1)*Hr3(-1,1,0) + 2*Hr4(-1,0,1,1) + Hr4(-1,1,0,1)

         Hr4(1,0,0,-1) = Hr2(-1,1)*Hr2(0,0) - Hr2(-1,0)*Hr2(0,1) - Hr2(0
     $        ,-1)*Hr2(0,1) + Hr2(0,0)*Hr2(1,-1) - Hr2(-1,0)*Hr2(1,0) +
     $        Hr1(1)*Hr3(-1,0,0) + Hr1(-1)*Hr3(0,0,1) - Hr4(-1,0,0,1)

         Hr4(1,0,0,0) = (-2*Hr2(0,0)*Hr2(0,1))/3. + (Hr2(0,0)*Hr2(1,0))
     $        /3. + Hr1(0)*Hr3(0,0,1) - Hr4(0,0,0,1)

         Hr4(1,0,0,1) = -0.5*Hr2(0,1)**2 + Hr1(1)*Hr3(0,0,1)

         Hr4(1,0,1,-1) = Hr2(-1,1)*Hr2(0,1) + Hr2(0,1)*Hr2(1,-1) - Hr2(
     $        -1,1)*Hr2(1,0) + Hr1(1)*Hr3(-1,1,0) - 2*Hr1(-1)*Hr3(0,1,1)
     $        - Hr4(-1,1,0,1)

         Hr4(1,0,1,0) = (3*Hr2(0,1)**2)/2. + Hr2(0,1)*Hr2(1,0) - 2
     $        *Hr1(1)*Hr3(0,0,1) - 2*Hr1(0)*Hr3(0,1,1) + 2*Hr4(0,0,1,1)

         Hr4(1,0,1,1) = Hr1(1)*Hr3(0,1,1) - 3*Hr4(0,1,1,1)

         Hr4(1,1,-1,-1) = (-3*Hr2(-1,1)**2)/4. - (Hr2(-1,1)*Hr2(1,-1))
     $        /2. + Hr2(1,-1)**2/4. + Hr1(1)*Hr3(-1,-1,1) + Hr1(-1)*Hr3(
     $        -1,1,1) - Hr4(-1,-1,1,1)

         Hr4(1,1,-1,0) = Hr2(-1,0)*Hr2(1,1) - Hr1(1)*Hr3(-1,0,1) -
     $        Hr1(1)*Hr3(-1,1,0) + Hr4(-1,0,1,1) + Hr4(-1,1,0,1) + Hr4(
     $        -1,1,1,0)

         Hr4(1,1,-1,1) = Hr2(-1,1)*Hr2(1,1) - 2*Hr1(1)*Hr3(-1,1,1) + 3
     $        *Hr4(-1,1,1,1)

         Hr4(1,1,0,-1) = -0.5*(Hr2(-1,1)*Hr2(0,1)) - (Hr2(0,1)*Hr2(1,
     $        -1))/2. + (Hr2(-1,1)*Hr2(1,0))/2. + (Hr2(1,-1)*Hr2(1,0))
     $        /2. - Hr2(-1,0)*Hr2(1,1) + Hr1(1)*Hr3(-1,0,1) + Hr1(-1)
     $        *Hr3(0,1,1) - Hr4(-1,0,1,1)
         
         Hr4(1,1,0,0) = (-3*Hr2(0,1)**2)/4. - (Hr2(0,1)*Hr2(1,0))/2. +
     $        Hr2(1,0)**2/4. + Hr1(1)*Hr3(0,0,1) + Hr1(0)*Hr3(0,1,1) -
     $        Hr4(0,0,1,1)

         Hr4(1,1,0,1) = Hr2(0,1)*Hr2(1,1) - 2*Hr1(1)*Hr3(0,1,1) + 3
     $        *Hr4(0,1,1,1)

         Hr4(1,1,1,-1) = (-2*Hr2(-1,1)*Hr2(1,1))/3. + (Hr2(1,-1)*Hr2(1
     $        ,1))/3. + Hr1(1)*Hr3(-1,1,1) - Hr4(-1,1,1,1)

         Hr4(1,1,1,0) = (-2*Hr2(0,1)*Hr2(1,1))/3. + (Hr2(1,0)*Hr2(1,1))
     $        /3. + Hr1(1)*Hr3(0,1,1) - Hr4(0,1,1,1)

         Hr4(1,1,1,1) = Hr2(1,1)**2/6.
      endif
      
      end

      subroutine get_hplog_w5(n1,n2,Hr1,Hr2,Hr3,Hr4,Hr5,x)
      implicit none
      integer n1,n2
      real * 8 Hr1(n1:n2), Hr2(n1:n2,n1:n2), Hr3(n1:n2,n1:n2,n1:n2)
      real * 8 Hr4(n1:n2,n1:n2,n1:n2,n1:n2)
      real * 8 Hr5(n1:n2,n1:n2,n1:n2,n1:n2,n1:n2)
      real * 8 x, xlcl
      integer i1
      double precision, parameter :: ln2     = 0.6931471805599453d0
      double precision, parameter :: z2      = 1.644934066848226d0
      double precision, parameter :: z3      = 1.202056903159594d0
      double precision, parameter :: z5      = 1.03692775514337d0
      double precision, parameter :: li4half = 0.5174790616738994d0
      double precision, parameter :: li5half = 0.5084005792422687d0
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8, transform_x
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8, transform_x

      xlcl = transform_x(x)

      if(x.lt.sqrt(2.0d0) - 1.0d0) then
         Hr5(-1,-1,-1,-1,-1) = (Hr2(-1,-1)*Hr3(-1,-1,-1))/10.

         Hr5(-1,-1,-1,-1,0) = H5(-1,-1,-1,-1,0,x)
         
         Hr5(-1,-1,-1,-1,1) = H5(-1,-1,-1,-1,1,x)

         Hr5(-1,-1,-1,0,-1) = -4*H5(-1,-1,-1,-1,0,x) + Hr1(-1)*Hr4(-1,-1
     $        ,-1,0)

         Hr5(-1,-1,-1,0,0) = H5(-1,-1,-1,0,0,x)

         Hr5(-1,-1,-1,0,1) = H5(-1,-1,-1,0,1,x)

         Hr5(-1,-1,-1,1,-1) = -4*H5(-1,-1,-1,-1,1,x) + Hr1(-1)*Hr4(-1,-1
     $        ,-1,1)

         Hr5(-1,-1,-1,1,0) = H5(-1,-1,-1,1,0,x)

         Hr5(-1,-1,-1,1,1) = H5(-1,-1,-1,1,1,x)

         Hr5(-1,-1,0,-1,-1) = 6*H5(-1,-1,-1,-1,0,x) + Hr2(-1,-1)*Hr3(-1,
     $        -1,0) - 3*Hr1(-1)*Hr4(-1,-1,-1,0)

         Hr5(-1,-1,0,-1,0) = H5(-1,-1,0,-1,0,x)

         Hr5(-1,-1,0,-1,1) = H5(-1,-1,0,-1,1,x)

         Hr5(-1,-1,0,0,-1) = -3*H5(-1,-1,-1,0,0,x) - H5(-1,-1,0,-1,0,x)
     $        + Hr1(-1)*Hr4(-1,-1,0,0)

         Hr5(-1,-1,0,0,0) = H5(-1,-1,0,0,0,x)

         Hr5(-1,-1,0,0,1) = H5(-1,-1,0,0,1,x)

         Hr5(-1,-1,0,1,-1) = -3*H5(-1,-1,-1,0,1,x) - H5(-1,-1,0,-1,1,x)
     $        + Hr1(-1)*Hr4(-1,-1,0,1)

         Hr5(-1,-1,0,1,0) = H5(-1,-1,0,1,0,x)

         Hr5(-1,-1,0,1,1) = H5(-1,-1,0,1,1,x)

         Hr5(-1,-1,1,-1,-1) = 6*H5(-1,-1,-1,-1,1,x) + Hr2(-1,-1)*Hr3(-1,
     $        -1,1) - 3*Hr1(-1)*Hr4(-1,-1,-1,1)

         Hr5(-1,-1,1,-1,0) = H5(-1,-1,1,-1,0,x)

         Hr5(-1,-1,1,-1,1) = H5(-1,-1,1,-1,1,x)

         Hr5(-1,-1,1,0,-1) = -3*H5(-1,-1,-1,1,0,x) - H5(-1,-1,1,-1,0,x)
     $        + Hr1(-1)*Hr4(-1,-1,1,0)

         Hr5(-1,-1,1,0,0) = H5(-1,-1,1,0,0,x)

         Hr5(-1,-1,1,0,1) = H5(-1,-1,1,0,1,x)

         Hr5(-1,-1,1,1,-1) = -3*H5(-1,-1,-1,1,1,x) - H5(-1,-1,1,-1,1,x)
     $        + Hr1(-1)*Hr4(-1,-1,1,1)

         Hr5(-1,-1,1,1,0) = H5(-1,-1,1,1,0,x)

         Hr5(-1,-1,1,1,1) = H5(-1,-1,1,1,1,x)

         Hr5(-1,0,-1,-1,-1) = -4*H5(-1,-1,-1,-1,0,x) + Hr2(-1,0)*Hr3(-1,
     $        -1,-1) - 2*Hr2(-1,-1)*Hr3(-1,-1,0) + 3*Hr1(-1)*Hr4(-1,-1,
     $        -1,0)

         Hr5(-1,0,-1,-1,0) = -6*H5(-1,-1,-1,0,0,x) - 3*H5(-1,-1,0,-1,0
     $        ,x) + Hr2(-1,0)*Hr3(-1,-1,0)

         Hr5(-1,0,-1,-1,1) = -3*H5(-1,-1,-1,0,1,x) - 3*H5(-1,-1,-1,1,0
     $        ,x) - 2*H5(-1,-1,0,-1,1,x) - H5(-1,-1,1,-1,0,x) + Hr2(-1
     $        ,0)*Hr3(-1,-1,1)

         Hr5(-1,0,-1,0,-1) = 12*H5(-1,-1,-1,0,0,x) + 4*H5(-1,-1,0,-1,0
     $        ,x) - Hr2(-1,0)*Hr3(-1,-1,0) + (Hr2(-1,0)*Hr3(-1,0,-1))/2.
     $        - 2*Hr1(-1)*Hr4(-1,-1,0,0)

         Hr5(-1,0,-1,0,0) = H5(-1,0,-1,0,0,x)

         Hr5(-1,0,-1,0,1) = H5(-1,0,-1,0,1,x)

         Hr5(-1,0,-1,1,-1) = 6*H5(-1,-1,-1,0,1,x) + 6*H5(-1,-1,-1,1,0,x)
     $        + 2*H5(-1,-1,0,-1,1,x) + 2*H5(-1,-1,1,-1,0,x) - 2*Hr2(-1
     $        ,0)*Hr3(-1,-1,1) + Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(-1,0,-1,1,0) = H5(-1,0,-1,1,0,x)

         Hr5(-1,0,-1,1,1) = H5(-1,0,-1,1,1,x)

         Hr5(-1,0,0,-1,-1) = -3*H5(-1,-1,-1,0,0,x) - H5(-1,-1,0,-1,0,x)
     $        - (Hr2(-1,0)*Hr3(-1,0,-1))/2. + Hr2(-1,-1)*Hr3(-1,0,0)

         Hr5(-1,0,0,-1,0) = -6*H5(-1,-1,0,0,0,x) - 3*H5(-1,0,-1,0,0,x) +
     $        Hr2(-1,0)*Hr3(-1,0,0)

         Hr5(-1,0,0,-1,1) = H5(-1,0,0,-1,1,x)

         Hr5(-1,0,0,0,-1) = 4*H5(-1,-1,0,0,0,x) + 2*H5(-1,0,-1,0,0,x) -
     $        Hr2(-1,0)*Hr3(-1,0,0) + Hr1(-1)*Hr4(-1,0,0,0)
         
         Hr5(-1,0,0,0,0) = H5(-1,0,0,0,0,x)

         Hr5(-1,0,0,0,1) = H5(-1,0,0,0,1,x)

         Hr5(-1,0,0,1,-1) = -2*H5(-1,-1,0,0,1,x) - H5(-1,0,-1,0,1,x) -
     $        H5(-1,0,0,-1,1,x) + Hr1(-1)*Hr4(-1,0,0,1)

         Hr5(-1,0,0,1,0) = H5(-1,0,0,1,0,x)

         Hr5(-1,0,0,1,1) = H5(-1,0,0,1,1,x)

         Hr5(-1,0,1,-1,-1) = -3*H5(-1,-1,-1,1,0,x) - H5(-1,-1,1,-1,0,x)
     $        + Hr2(-1,0)*Hr3(-1,-1,1) + Hr2(-1,-1)*Hr3(-1,0,1) - 2*Hr1(
     $        -1)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(-1,0,1,-1,0) = -4*H5(-1,-1,0,0,1,x) - 2*H5(-1,-1,0,1,0,x) -
     $        2*H5(-1,0,-1,0,1,x) - H5(-1,0,-1,1,0,x) + Hr2(-1,0)*Hr3(-1
     $        ,0,1)

         Hr5(-1,0,1,-1,1) = H5(-1,0,1,-1,1,x)

         Hr5(-1,0,1,0,-1) = 4*H5(-1,-1,0,0,1,x) + 2*H5(-1,0,-1,0,1,x) -
     $        Hr2(-1,0)*Hr3(-1,0,1) + Hr1(-1)*Hr4(-1,0,1,0)

         Hr5(-1,0,1,0,0) = H5(-1,0,1,0,0,x)

         Hr5(-1,0,1,0,1) = H5(-1,0,1,0,1,x)

         Hr5(-1,0,1,1,-1) = -2*H5(-1,-1,0,1,1,x) - H5(-1,0,-1,1,1,x) -
     $        H5(-1,0,1,-1,1,x) + Hr1(-1)*Hr4(-1,0,1,1)

         Hr5(-1,0,1,1,0) = H5(-1,0,1,1,0,x)

         Hr5(-1,0,1,1,1) = H5(-1,0,1,1,1,x)

         Hr5(-1,1,-1,-1,-1) = -4*H5(-1,-1,-1,-1,1,x) + Hr2(-1,1)*Hr3(-1,
     $        -1,-1) - 2*Hr2(-1,-1)*Hr3(-1,-1,1) + 3*Hr1(-1)*Hr4(-1,-1,
     $        -1,1)

         Hr5(-1,1,-1,-1,0) = -3*H5(-1,-1,-1,0,1,x) - 3*H5(-1,-1,-1,1,0
     $        ,x) - H5(-1,-1,0,-1,1,x) - 2*H5(-1,-1,1,-1,0,x) + Hr2(-1
     $        ,1)*Hr3(-1,-1,0)

         Hr5(-1,1,-1,-1,1) = -6*H5(-1,-1,-1,1,1,x) - 3*H5(-1,-1,1,-1,1
     $        ,x) + Hr2(-1,1)*Hr3(-1,-1,1)

         Hr5(-1,1,-1,0,-1) = 6*H5(-1,-1,-1,0,1,x) + 6*H5(-1,-1,-1,1,0,x)
     $        + 2*H5(-1,-1,0,-1,1,x) + 2*H5(-1,-1,1,-1,0,x) + Hr2(-1,1)
     $        *Hr3(-1,0,-1) - 2*Hr1(-1)*Hr4(-1,-1,0,1) - 2*Hr1(-1)*Hr4(
     $        -1,-1,1,0) - Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(-1,1,-1,0,0) = -2*H5(-1,-1,0,0,1,x) - 2*H5(-1,-1,0,1,0,x) -
     $        2*H5(-1,-1,1,0,0,x) - H5(-1,0,-1,0,1,x) - H5(-1,0,-1,1,0
     $        ,x) - H5(-1,0,0,-1,1,x) + Hr2(-1,1)*Hr3(-1,0,0)

         Hr5(-1,1,-1,0,1) = -4*H5(-1,-1,0,1,1,x) - 2*H5(-1,-1,1,0,1,x) -
     $        2*H5(-1,0,-1,1,1,x) - H5(-1,0,1,-1,1,x) + Hr2(-1,1)*Hr3(-1
     $        ,0,1)

         Hr5(-1,1,-1,1,-1) = 12*H5(-1,-1,-1,1,1,x) + 4*H5(-1,-1,1,-1,1
     $        ,x) - Hr2(-1,1)*Hr3(-1,-1,1) + (Hr2(-1,1)*Hr3(-1,1,-1))/2.
     $        - 2*Hr1(-1)*Hr4(-1,-1,1,1)

         Hr5(-1,1,-1,1,0) = H5(-1,1,-1,1,0,x)

         Hr5(-1,1,-1,1,1) = H5(-1,1,-1,1,1,x)

         Hr5(-1,1,0,-1,-1) = -3*H5(-1,-1,-1,0,1,x) - H5(-1,-1,0,-1,1,x)
     $        - Hr2(-1,1)*Hr3(-1,-1,0) - Hr2(-1,1)*Hr3(-1,0,-1) + Hr2(-1
     $        ,-1)*Hr3(-1,1,0) + 2*Hr1(-1)*Hr4(-1,-1,0,1) + Hr1(-1)*Hr4(
     $        -1,0,-1,1)

         Hr5(-1,1,0,-1,0) = 4*H5(-1,-1,0,0,1,x) + 2*H5(-1,-1,0,1,0,x) +
     $        2*H5(-1,0,-1,0,1,x) + H5(-1,0,-1,1,0,x) + 2*H5(-1,0,0,-1,1
     $        ,x) - 2*Hr2(-1,1)*Hr3(-1,0,0) + Hr2(-1,0)*Hr3(-1,1,0)

         Hr5(-1,1,0,-1,1) = 4*H5(-1,-1,0,1,1,x) - 4*H5(-1,-1,1,1,0,x) +
     $        2*H5(-1,0,-1,1,1,x) + H5(-1,0,1,-1,1,x) - 2*H5(-1,1,-1,1,0
     $        ,x) - Hr2(-1,1)*Hr3(-1,0,1) + Hr2(-1,1)*Hr3(-1,1,0)

         Hr5(-1,1,0,0,-1) = -2*H5(-1,-1,0,0,1,x) - H5(-1,0,-1,0,1,x) -
     $        H5(-1,0,0,-1,1,x) + Hr2(-1,1)*Hr3(-1,0,0) - Hr2(-1,0)*Hr3(
     $        -1,1,0) + Hr1(-1)*Hr4(-1,1,0,0)

         Hr5(-1,1,0,0,0) = H5(-1,1,0,0,0,x)

         Hr5(-1,1,0,0,1) = H5(-1,1,0,0,1,x)

         Hr5(-1,1,0,1,-1) = 4*H5(-1,-1,1,1,0,x) + 2*H5(-1,1,-1,1,0,x) -
     $        Hr2(-1,1)*Hr3(-1,1,0) + Hr1(-1)*Hr4(-1,1,0,1)

         Hr5(-1,1,0,1,0) = H5(-1,1,0,1,0,x)

         Hr5(-1,1,0,1,1) = H5(-1,1,0,1,1,x)

         Hr5(-1,1,1,-1,-1) = -3*H5(-1,-1,-1,1,1,x) - H5(-1,-1,1,-1,1,x)
     $        - (Hr2(-1,1)*Hr3(-1,1,-1))/2. + Hr2(-1,-1)*Hr3(-1,1,1)

         Hr5(-1,1,1,-1,0) = 2*H5(-1,-1,0,1,1,x) - 2*H5(-1,-1,1,1,0,x) +
     $        H5(-1,0,-1,1,1,x) + H5(-1,0,1,-1,1,x) - H5(-1,1,-1,1,0,x)
     $        - Hr2(-1,1)*Hr3(-1,0,1) + Hr2(-1,0)*Hr3(-1,1,1)

         Hr5(-1,1,1,-1,1) = -6*H5(-1,-1,1,1,1,x) - 3*H5(-1,1,-1,1,1,x) +
     $        Hr2(-1,1)*Hr3(-1,1,1)

         Hr5(-1,1,1,0,-1) = -2*H5(-1,-1,0,1,1,x) - H5(-1,0,-1,1,1,x) -
     $        H5(-1,0,1,-1,1,x) + Hr2(-1,1)*Hr3(-1,0,1) - Hr2(-1,0)*Hr3(
     $        -1,1,1) + Hr1(-1)*Hr4(-1,1,1,0)

         Hr5(-1,1,1,0,0) = H5(-1,1,1,0,0,x)

         Hr5(-1,1,1,0,1) = H5(-1,1,1,0,1,x)

         Hr5(-1,1,1,1,-1) = 4*H5(-1,-1,1,1,1,x) + 2*H5(-1,1,-1,1,1,x) -
     $        Hr2(-1,1)*Hr3(-1,1,1) + Hr1(-1)*Hr4(-1,1,1,1)

         Hr5(-1,1,1,1,0) = H5(-1,1,1,1,0,x)

         Hr5(-1,1,1,1,1) = H5(-1,1,1,1,1,x)

         Hr5(0,-1,-1,-1,-1) = H5(-1,-1,-1,-1,0,x) - (3*Hr2(-1,0)*Hr3(-1,
     $        -1,-1))/4. + (Hr2(0,-1)*Hr3(-1,-1,-1))/4. + Hr2(-1,-1)
     $        *Hr3(-1,-1,0) - Hr1(-1)*Hr4(-1,-1,-1,0)

         Hr5(0,-1,-1,-1,0) = 4*H5(-1,-1,-1,0,0,x) + 2*H5(-1,-1,0,-1,0,x)
     $        - Hr2(-1,0)*Hr3(-1,-1,0) + Hr1(0)*Hr4(-1,-1,-1,0)

         Hr5(0,-1,-1,-1,1) = 2*H5(-1,-1,-1,0,1,x) + 2*H5(-1,-1,-1,1,0,x)
     $        + H5(-1,-1,0,-1,1,x) + H5(-1,-1,1,-1,0,x) - Hr2(-1,0)*Hr3(
     $        -1,-1,1) + Hr1(0)*Hr4(-1,-1,-1,1)

         Hr5(0,-1,-1,0,-1) = -6*H5(-1,-1,-1,0,0,x) - 3*H5(-1,-1,0,-1,0
     $        ,x) + 2*Hr2(-1,0)*Hr3(-1,-1,0) + Hr2(0,-1)*Hr3(-1,-1,0) -
     $        (Hr2(-1,0)*Hr3(-1,0,-1))/2. - 3*Hr1(0)*Hr4(-1,-1,-1,0)

         Hr5(0,-1,-1,0,0) = -3*H5(-1,-1,0,0,0,x) - H5(-1,0,-1,0,0,x) +
     $        Hr1(0)*Hr4(-1,-1,0,0)

         Hr5(0,-1,-1,0,1) = -2*H5(-1,-1,0,0,1,x) - H5(-1,-1,0,1,0,x) -
     $        H5(-1,0,-1,0,1,x) + Hr1(0)*Hr4(-1,-1,0,1)

         Hr5(0,-1,-1,1,-1) = -3*H5(-1,-1,-1,0,1,x) - 3*H5(-1,-1,-1,1,0
     $        ,x) - H5(-1,-1,0,-1,1,x) - 2*H5(-1,-1,1,-1,0,x) + 3*Hr2(-1
     $        ,0)*Hr3(-1,-1,1) + Hr2(0,-1)*Hr3(-1,-1,1) - 3*Hr1(0)*Hr4(
     $        -1,-1,-1,1) - Hr1(-1)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,-1,1
     $        ,0) - Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(0,-1,-1,1,0) = -H5(-1,-1,0,1,0,x) - 2*H5(-1,-1,1,0,0,x) -
     $        H5(-1,0,-1,1,0,x) + Hr1(0)*Hr4(-1,-1,1,0)

         Hr5(0,-1,-1,1,1) = -H5(-1,-1,0,1,1,x) - H5(-1,-1,1,0,1,x) - H5(
     $        -1,-1,1,1,0,x) - H5(-1,0,-1,1,1,x) + Hr1(0)*Hr4(-1,-1,1,1)

         Hr5(0,-1,0,-1,-1) = H5(-1,-1,0,-1,0,x) - Hr2(-1,0)*Hr3(-1,-1,0)
     $        - Hr2(0,-1)*Hr3(-1,-1,0) + Hr2(-1,0)*Hr3(-1,0,-1) + (Hr2(0
     $        ,-1)*Hr3(-1,0,-1))/2. - 2*Hr2(-1,-1)*Hr3(-1,0,0) + 3
     $        *Hr1(0)*Hr4(-1,-1,-1,0) + 2*Hr1(-1)*Hr4(-1,-1,0,0)

         Hr5(0,-1,0,-1,0) = 12*H5(-1,-1,0,0,0,x) + 4*H5(-1,0,-1,0,0,x) -
     $        Hr2(-1,0)*Hr3(-1,0,0) + (Hr2(-1,0)*Hr3(0,-1,0))/2. - 2
     $        *Hr1(0)*Hr4(-1,-1,0,0)

         Hr5(0,-1,0,-1,1) = -H5(-1,0,-1,0,1,x) - H5(-1,0,-1,1,0,x) - 2
     $        *H5(-1,0,0,-1,1,x) + Hr1(0)*Hr4(-1,0,-1,1)

         Hr5(0,-1,0,0,-1) = -6*H5(-1,-1,0,0,0,x) - 3*H5(-1,0,-1,0,0,x) +
     $        2*Hr2(-1,0)*Hr3(-1,0,0) + Hr2(0,-1)*Hr3(-1,0,0) - (Hr2(-1
     $        ,0)*Hr3(0,-1,0))/2. - 3*Hr1(-1)*Hr4(-1,0,0,0)

         Hr5(0,-1,0,0,0) = -4*H5(-1,0,0,0,0,x) + Hr1(0)*Hr4(-1,0,0,0)

         Hr5(0,-1,0,0,1) = -3*H5(-1,0,0,0,1,x) - H5(-1,0,0,1,0,x) +
     $        Hr1(0)*Hr4(-1,0,0,1)

         Hr5(0,-1,0,1,-1) = 4*H5(-1,-1,0,0,1,x) + 2*H5(-1,-1,0,1,0,x) +
     $        2*H5(-1,0,-1,0,1,x) + H5(-1,0,-1,1,0,x) + 2*H5(-1,0,0,-1,1
     $        ,x) + Hr2(-1,0)*Hr3(-1,0,1) + Hr2(0,-1)*Hr3(-1,0,1) - 2
     $        *Hr1(0)*Hr4(-1,-1,0,1) - Hr1(0)*Hr4(-1,0,-1,1) - 2*Hr1(-1)
     $        *Hr4(-1,0,0,1) - Hr1(-1)*Hr4(-1,0,1,0)

         Hr5(0,-1,0,1,0) = -2*H5(-1,0,0,1,0,x) - 2*H5(-1,0,1,0,0,x) +
     $        Hr1(0)*Hr4(-1,0,1,0)

         Hr5(0,-1,0,1,1) = -2*H5(-1,0,0,1,1,x) - H5(-1,0,1,0,1,x) - H5(
     $        -1,0,1,1,0,x) + Hr1(0)*Hr4(-1,0,1,1)

         Hr5(0,-1,1,-1,-1) = H5(-1,-1,1,-1,0,x) + Hr2(-1,1)*Hr3(-1,-1,0)
     $        - 3*Hr2(-1,0)*Hr3(-1,-1,1) - Hr2(0,-1)*Hr3(-1,-1,1) +
     $        (Hr2(-1,1)*Hr3(-1,0,-1))/2. - Hr2(-1,-1)*Hr3(-1,0,1) +
     $        (Hr2(0,-1)*Hr3(-1,1,-1))/2. - Hr2(-1,-1)*Hr3(-1,1,0) + 3
     $        *Hr1(0)*Hr4(-1,-1,-1,1) + 2*Hr1(-1)*Hr4(-1,-1,0,1) + 2
     $        *Hr1(-1)*Hr4(-1,-1,1,0) + Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(0,-1,1,-1,0) = 4*H5(-1,-1,0,0,1,x) + 4*H5(-1,-1,0,1,0,x) +
     $        4*H5(-1,-1,1,0,0,x) + 2*H5(-1,0,-1,0,1,x) + 2*H5(-1,0,-1,1
     $        ,0,x) + 2*Hr2(-1,1)*Hr3(-1,0,0) - Hr2(-1,0)*Hr3(-1,0,1) -
     $        Hr2(-1,0)*Hr3(-1,1,0) + Hr2(-1,1)*Hr3(0,-1,0) - 2*Hr1(0)
     $        *Hr4(-1,-1,0,1) - 2*Hr1(0)*Hr4(-1,-1,1,0) - Hr1(0)*Hr4(-1
     $        ,0,-1,1)

         Hr5(0,-1,1,-1,1) = 2*H5(-1,-1,1,0,1,x) + 4*H5(-1,-1,1,1,0,x) -
     $        H5(-1,0,1,-1,1,x) + H5(-1,1,-1,1,0,x) + (Hr2(-1,1)*Hr3(-1
     $        ,0,1))/2. - (Hr2(-1,1)*Hr3(-1,1,0))/2. + (Hr2(-1,1)*Hr3(0,
     $        -1,1))/2. - 2*Hr1(0)*Hr4(-1,-1,1,1)

         Hr5(0,-1,1,0,-1) = -4*H5(-1,-1,0,0,1,x) - 2*H5(-1,-1,0,1,0,x) -
     $        2*H5(-1,0,-1,0,1,x) - H5(-1,0,-1,1,0,x) - 2*Hr2(-1,1)*Hr3(
     $        -1,0,0) + Hr2(-1,0)*Hr3(-1,0,1) + 2*Hr2(-1,0)*Hr3(-1,1,0)
     $        + Hr2(0,-1)*Hr3(-1,1,0) - Hr2(-1,1)*Hr3(0,-1,0) + 2*Hr1(0)
     $        *Hr4(-1,-1,0,1) + Hr1(0)*Hr4(-1,0,-1,1) - Hr1(-1)*Hr4(-1,0
     $        ,1,0) - 2*Hr1(-1)*Hr4(-1,1,0,0)

         Hr5(0,-1,1,0,0) = -H5(-1,0,1,0,0,x) - 3*H5(-1,1,0,0,0,x) +
     $        Hr1(0)*Hr4(-1,1,0,0)

         Hr5(0,-1,1,0,1) = -H5(-1,0,1,0,1,x) - 2*H5(-1,1,0,0,1,x) - H5(
     $        -1,1,0,1,0,x) + Hr1(0)*Hr4(-1,1,0,1)

         Hr5(0,-1,1,1,-1) = 2*H5(-1,-1,0,1,1,x) - 2*H5(-1,-1,1,1,0,x) +
     $        H5(-1,0,-1,1,1,x) + H5(-1,0,1,-1,1,x) - H5(-1,1,-1,1,0,x)
     $        - (Hr2(-1,1)*Hr3(-1,0,1))/2. + (Hr2(-1,1)*Hr3(-1,1,0))/2.
     $        + Hr2(-1,0)*Hr3(-1,1,1) + Hr2(0,-1)*Hr3(-1,1,1) - (Hr2(-1
     $        ,1)*Hr3(0,-1,1))/2. - Hr1(-1)*Hr4(-1,0,1,1) - Hr1(-1)*Hr4(
     $        -1,1,0,1) - Hr1(-1)*Hr4(-1,1,1,0)

         Hr5(0,-1,1,1,0) = -H5(-1,0,1,1,0,x) - H5(-1,1,0,1,0,x) - 2*H5(
     $        -1,1,1,0,0,x) + Hr1(0)*Hr4(-1,1,1,0)

         Hr5(0,-1,1,1,1) = -H5(-1,0,1,1,1,x) - H5(-1,1,0,1,1,x) - H5(-1
     $        ,1,1,0,1,x) - H5(-1,1,1,1,0,x) + Hr1(0)*Hr4(-1,1,1,1)

         Hr5(0,0,-1,-1,-1) = H5(-1,-1,-1,0,0,x) + Hr2(0,0)*Hr3(-1,-1,-1)
     $        - (Hr2(-1,0)*Hr3(-1,0,-1))/2. - (Hr2(0,-1)*Hr3(-1,0,-1))
     $        /2. + Hr2(-1,-1)*Hr3(-1,0,0) - Hr1(0)*Hr4(-1,-1,-1,0) -
     $        Hr1(-1)*Hr4(-1,-1,0,0)

         Hr5(0,0,-1,-1,0) = -3*H5(-1,-1,0,0,0,x) - H5(-1,0,-1,0,0,x) +
     $        Hr2(0,0)*Hr3(-1,-1,0) - (Hr2(-1,0)*Hr3(0,-1,0))/2.

         Hr5(0,0,-1,-1,1) = H5(-1,-1,0,0,1,x) + H5(-1,-1,0,1,0,x) + H5(
     $        -1,-1,1,0,0,x) + H5(-1,0,-1,0,1,x) + H5(-1,0,-1,1,0,x) +
     $        H5(-1,0,0,-1,1,x) + Hr2(0,0)*Hr3(-1,-1,1) - Hr1(0)*Hr4(-1,
     $        -1,0,1) - Hr1(0)*Hr4(-1,-1,1,0) - Hr1(0)*Hr4(-1,0,-1,1)

         Hr5(0,0,-1,0,-1) = H5(-1,0,-1,0,0,x) + Hr2(0,0)*Hr3(-1,0,-1) -
     $        2*Hr2(-1,0)*Hr3(-1,0,0) - 2*Hr2(0,-1)*Hr3(-1,0,0) + (Hr2(
     $        -1,0)*Hr3(0,-1,0))/2. + 2*Hr1(0)*Hr4(-1,-1,0,0) + 3*Hr1(
     $        -1)*Hr4(-1,0,0,0)

         Hr5(0,0,-1,0,0) = 6*H5(-1,0,0,0,0,x) + Hr2(0,0)*Hr3(-1,0,0) - 3
     $        *Hr1(0)*Hr4(-1,0,0,0)

         Hr5(0,0,-1,0,1) = 3*H5(-1,0,0,0,1,x) + 2*H5(-1,0,0,1,0,x) + H5(
     $        -1,0,1,0,0,x) + Hr2(0,0)*Hr3(-1,0,1) - 2*Hr1(0)*Hr4(-1,0,0
     $        ,1) - Hr1(0)*Hr4(-1,0,1,0)

         Hr5(0,0,-1,1,-1) = -2*H5(-1,-1,0,0,1,x) - 2*H5(-1,-1,0,1,0,x) -
     $        2*H5(-1,-1,1,0,0,x) - H5(-1,0,-1,0,1,x) - H5(-1,0,-1,1,0
     $        ,x) - H5(-1,0,0,-1,1,x) - Hr2(-1,0)*Hr3(-1,0,1) - Hr2(0,
     $        -1)*Hr3(-1,0,1) + Hr2(0,0)*Hr3(-1,1,-1) - Hr2(-1,0)*Hr3(-1
     $        ,1,0) - Hr2(0,-1)*Hr3(-1,1,0) + 2*Hr1(0)*Hr4(-1,-1,0,1) +
     $        2*Hr1(0)*Hr4(-1,-1,1,0) + Hr1(0)*Hr4(-1,0,-1,1) + Hr1(-1)
     $        *Hr4(-1,0,0,1) + Hr1(-1)*Hr4(-1,0,1,0) + Hr1(-1)*Hr4(-1,1
     $        ,0,0)

         Hr5(0,0,-1,1,0) = H5(-1,0,0,1,0,x) + 2*H5(-1,0,1,0,0,x) + 3*H5(
     $        -1,1,0,0,0,x) + Hr2(0,0)*Hr3(-1,1,0) - Hr1(0)*Hr4(-1,0,1
     $        ,0) - 2*Hr1(0)*Hr4(-1,1,0,0)

         Hr5(0,0,-1,1,1) = H5(-1,0,0,1,1,x) + H5(-1,0,1,0,1,x) + H5(-1,0
     $        ,1,1,0,x) + H5(-1,1,0,0,1,x) + H5(-1,1,0,1,0,x) + H5(-1,1
     $        ,1,0,0,x) + Hr2(0,0)*Hr3(-1,1,1) - Hr1(0)*Hr4(-1,0,1,1) -
     $        Hr1(0)*Hr4(-1,1,0,1) - Hr1(0)*Hr4(-1,1,1,0)

         Hr5(0,0,0,-1,-1) = H5(-1,-1,0,0,0,x) - (2*Hr2(0,0)*Hr3(-1,-1
     $        ,0))/3. - (2*Hr2(0,0)*Hr3(-1,0,-1))/3. + Hr2(-1,0)*Hr3(-1
     $        ,0,0) + Hr2(0,-1)*Hr3(-1,0,0) + (Hr2(0,0)*Hr3(0,-1,-1))/3.
     $        - Hr1(0)*Hr4(-1,-1,0,0) - Hr1(-1)*Hr4(-1,0,0,0)

         Hr5(0,0,0,-1,0) = -4*H5(-1,0,0,0,0,x) - (4*Hr2(0,0)*Hr3(-1,0
     $        ,0))/3. + (Hr2(0,0)*Hr3(0,-1,0))/3. + 3*Hr1(0)*Hr4(-1,0,0
     $        ,0)

         Hr5(0,0,0,-1,1) = -H5(-1,0,0,0,1,x) - H5(-1,0,0,1,0,x) - H5(-1
     $        ,0,1,0,0,x) - H5(-1,1,0,0,0,x) - (2*Hr2(0,0)*Hr3(-1,0,1))
     $        /3. - (2*Hr2(0,0)*Hr3(-1,1,0))/3. + (Hr2(0,0)*Hr3(0,-1,1))
     $        /3. + Hr1(0)*Hr4(-1,0,0,1) + Hr1(0)*Hr4(-1,0,1,0) + Hr1(0)
     $        *Hr4(-1,1,0,0)

         Hr5(0,0,0,0,-1) = H5(-1,0,0,0,0,x) + (Hr2(0,0)*Hr3(-1,0,0))/2.
     $        - (Hr2(0,0)*Hr3(0,-1,0))/6. + (Hr2(0,0)*Hr3(0,0,-1))/6. -
     $        Hr1(0)*Hr4(-1,0,0,0)

         Hr5(0,0,0,0,0) = (Hr2(0,0)*Hr3(0,0,0))/10.

         Hr5(0,0,0,0,1) = H5(0,0,0,0,1,x)

         Hr5(0,0,0,1,-1) = H5(-1,1,0,0,0,x) - (Hr2(0,0)*Hr3(-1,0,1))/3.
     $        + (2*Hr2(0,0)*Hr3(-1,1,0))/3. - (Hr2(0,0)*Hr3(0,-1,1))/3.
     $        - Hr1(0)*Hr4(-1,1,0,0) + Hr1(-1)*Hr4(0,0,0,1)

         Hr5(0,0,0,1,0) = -4*H5(0,0,0,0,1,x) + Hr1(0)*Hr4(0,0,0,1)

         Hr5(0,0,0,1,1) = H5(0,0,0,1,1,x)

         Hr5(0,0,1,-1,-1) = H5(-1,-1,1,0,0,x) - Hr2(0,0)*Hr3(-1,-1,1) -
     $        Hr2(0,0)*Hr3(-1,1,-1) + Hr2(-1,0)*Hr3(-1,1,0) + Hr2(0,-1)
     $        *Hr3(-1,1,0) + Hr2(-1,-1)*Hr3(0,0,1) - Hr1(0)*Hr4(-1,-1,1
     $        ,0) - Hr1(-1)*Hr4(-1,1,0,0)

         Hr5(0,0,1,-1,0) = -H5(-1,0,1,0,0,x) - 3*H5(-1,1,0,0,0,x) -
     $        Hr2(0,0)*Hr3(-1,0,1) - Hr2(0,0)*Hr3(-1,1,0) + Hr2(-1,0)
     $        *Hr3(0,0,1) + Hr1(0)*Hr4(-1,0,1,0) + 2*Hr1(0)*Hr4(-1,1,0
     $        ,0)

         Hr5(0,0,1,-1,1) = -H5(-1,1,0,0,1,x) - H5(-1,1,0,1,0,x) - 2*H5(
     $        -1,1,1,0,0,x) - 2*Hr2(0,0)*Hr3(-1,1,1) + Hr2(-1,1)*Hr3(0,0
     $        ,1) + Hr1(0)*Hr4(-1,1,0,1) + 2*Hr1(0)*Hr4(-1,1,1,0)

         Hr5(0,0,1,0,-1) = H5(-1,0,1,0,0,x) + Hr2(0,0)*Hr3(-1,0,1) +
     $        Hr2(0,-1)*Hr3(0,0,1) - Hr1(0)*Hr4(-1,0,1,0) - 3*Hr1(-1)
     $        *Hr4(0,0,0,1)

         Hr5(0,0,1,0,0) = 6*H5(0,0,0,0,1,x) + Hr2(0,0)*Hr3(0,0,1) - 3
     $        *Hr1(0)*Hr4(0,0,0,1)

         Hr5(0,0,1,0,1) = H5(0,0,1,0,1,x)

         Hr5(0,0,1,1,-1) = H5(-1,1,1,0,0,x) + Hr2(0,0)*Hr3(-1,1,1) -
     $        Hr2(-1,1)*Hr3(0,0,1) - Hr1(0)*Hr4(-1,1,1,0) + Hr1(-1)
     $        *Hr4(0,0,1,1)

         Hr5(0,0,1,1,0) = -3*H5(0,0,0,1,1,x) - H5(0,0,1,0,1,x) + Hr1(0)
     $        *Hr4(0,0,1,1)

         Hr5(0,0,1,1,1) = H5(0,0,1,1,1,x)

         Hr5(0,1,-1,-1,-1) = H5(-1,-1,-1,1,0,x) + Hr2(0,1)*Hr3(-1,-1,-1)
     $        - Hr2(-1,1)*Hr3(-1,-1,0) + Hr2(-1,0)*Hr3(-1,-1,1) - (Hr2(
     $        -1,1)*Hr3(-1,0,-1))/2. - (Hr2(0,-1)*Hr3(-1,1,-1))/2. +
     $        Hr2(-1,-1)*Hr3(-1,1,0) - Hr1(0)*Hr4(-1,-1,-1,1) - Hr1(-1)
     $        *Hr4(-1,-1,1,0)

         Hr5(0,1,-1,-1,0) = -H5(-1,-1,0,1,0,x) - 2*H5(-1,-1,1,0,0,x) -
     $        H5(-1,0,-1,1,0,x) + Hr2(0,1)*Hr3(-1,-1,0) - 2*Hr2(-1,1)
     $        *Hr3(-1,0,0) + Hr2(-1,0)*Hr3(-1,1,0) - Hr2(-1,1)*Hr3(0,-1
     $        ,0) + Hr1(0)*Hr4(-1,-1,0,1) + Hr1(0)*Hr4(-1,-1,1,0) +
     $        Hr1(0)*Hr4(-1,0,-1,1)

         Hr5(0,1,-1,-1,1) = -H5(-1,-1,1,0,1,x) - 2*H5(-1,-1,1,1,0,x) -
     $        H5(-1,1,-1,1,0,x) + Hr2(0,1)*Hr3(-1,-1,1) - (Hr2(-1,1)
     $        *Hr3(-1,0,1))/2. + (Hr2(-1,1)*Hr3(-1,1,0))/2. - (Hr2(-1,1)
     $        *Hr3(0,-1,1))/2.

         Hr5(0,1,-1,0,-1) = H5(-1,0,-1,1,0,x) + Hr2(0,1)*Hr3(-1,0,-1) +
     $        2*Hr2(-1,1)*Hr3(-1,0,0) - Hr2(-1,0)*Hr3(-1,0,1) - Hr2(0,
     $        -1)*Hr3(-1,0,1) - 2*Hr2(-1,0)*Hr3(-1,1,0) - Hr2(0,-1)*Hr3(
     $        -1,1,0) + Hr2(-1,1)*Hr3(0,-1,0) - Hr1(0)*Hr4(-1,0,-1,1) +
     $        Hr1(-1)*Hr4(-1,0,1,0) + 2*Hr1(-1)*Hr4(-1,1,0,0)

         Hr5(0,1,-1,0,0) = H5(-1,0,0,1,0,x) + 2*H5(-1,0,1,0,0,x) + 3*H5(
     $        -1,1,0,0,0,x) + Hr2(0,1)*Hr3(-1,0,0) - Hr1(0)*Hr4(-1,0,0
     $        ,1) - Hr1(0)*Hr4(-1,0,1,0) - Hr1(0)*Hr4(-1,1,0,0)

         Hr5(0,1,-1,0,1) = H5(-1,0,1,0,1,x) + 2*H5(-1,0,1,1,0,x) + 2*H5(
     $        -1,1,0,0,1,x) + H5(-1,1,0,1,0,x) + Hr2(0,1)*Hr3(-1,0,1) -
     $        2*Hr1(0)*Hr4(-1,0,1,1) - Hr1(0)*Hr4(-1,1,0,1)

         Hr5(0,1,-1,1,-1) = H5(-1,1,-1,1,0,x) + (Hr2(-1,1)*Hr3(-1,0,1))
     $        /2. + Hr2(0,1)*Hr3(-1,1,-1) - (Hr2(-1,1)*Hr3(-1,1,0))/2. -
     $        2*Hr2(-1,0)*Hr3(-1,1,1) - 2*Hr2(0,-1)*Hr3(-1,1,1) + (Hr2(
     $        -1,1)*Hr3(0,-1,1))/2. + 2*Hr1(0)*Hr4(-1,-1,1,1) + Hr1(-1)
     $        *Hr4(-1,1,0,1) + 2*Hr1(-1)*Hr4(-1,1,1,0)

         Hr5(0,1,-1,1,0) = 2*H5(-1,1,0,1,0,x) + 4*H5(-1,1,1,0,0,x) +
     $        Hr2(0,1)*Hr3(-1,1,0) - Hr1(0)*Hr4(-1,1,0,1) - 2*Hr1(0)
     $        *Hr4(-1,1,1,0)

         Hr5(0,1,-1,1,1) = H5(-1,1,0,1,1,x) + 2*H5(-1,1,1,0,1,x) + 3*H5(
     $        -1,1,1,1,0,x) + Hr2(0,1)*Hr3(-1,1,1) - 3*Hr1(0)*Hr4(-1,1,1
     $        ,1)

         Hr5(0,1,0,-1,-1) = H5(-1,-1,0,1,0,x) + Hr2(-1,0)*Hr3(-1,0,1) +
     $        Hr2(0,-1)*Hr3(-1,0,1) + Hr2(0,1)*Hr3(0,-1,-1) - 2*Hr2(-1,
     $        -1)*Hr3(0,0,1) - Hr1(0)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,0
     $        ,1,0)

         Hr5(0,1,0,-1,0) = -2*H5(-1,0,0,1,0,x) - 2*H5(-1,0,1,0,0,x) +
     $        Hr2(0,1)*Hr3(0,-1,0) - 2*Hr2(-1,0)*Hr3(0,0,1) + 2*Hr1(0)
     $        *Hr4(-1,0,0,1) + Hr1(0)*Hr4(-1,0,1,0)

         Hr5(0,1,0,-1,1) = -H5(-1,0,1,0,1,x) - 2*H5(-1,0,1,1,0,x) - H5(
     $        -1,1,0,1,0,x) + Hr2(0,1)*Hr3(0,-1,1) - 2*Hr2(-1,1)*Hr3(0,0
     $        ,1) + 2*Hr1(0)*Hr4(-1,0,1,1) + Hr1(0)*Hr4(-1,1,0,1)

         Hr5(0,1,0,0,-1) = H5(-1,0,0,1,0,x) + Hr2(0,1)*Hr3(0,0,-1) - 2
     $        *Hr2(0,-1)*Hr3(0,0,1) - Hr1(0)*Hr4(-1,0,0,1) + 3*Hr1(-1)
     $        *Hr4(0,0,0,1)

         Hr5(0,1,0,0,0) = -4*H5(0,0,0,0,1,x) + Hr2(0,1)*Hr3(0,0,0) - 2
     $        *Hr2(0,0)*Hr3(0,0,1) + 3*Hr1(0)*Hr4(0,0,0,1)

         Hr5(0,1,0,0,1) = -6*H5(0,0,0,1,1,x) - 3*H5(0,0,1,0,1,x) + Hr2(0
     $        ,1)*Hr3(0,0,1)

         Hr5(0,1,0,1,-1) = H5(-1,1,0,1,0,x) - (Hr2(0,1)*Hr3(-1,0,1))/2.
     $        - (Hr2(0,1)*Hr3(0,-1,1))/2. + 2*Hr2(-1,1)*Hr3(0,0,1) +
     $        (Hr2(0,1)*Hr3(0,1,-1))/2. - Hr1(0)*Hr4(-1,1,0,1) - 2*Hr1(
     $        -1)*Hr4(0,0,1,1)

         Hr5(0,1,0,1,0) = 12*H5(0,0,0,1,1,x) + 4*H5(0,0,1,0,1,x) - Hr2(0
     $        ,1)*Hr3(0,0,1) + (Hr2(0,1)*Hr3(0,1,0))/2. - 2*Hr1(0)*Hr4(0
     $        ,0,1,1)

         Hr5(0,1,0,1,1) = H5(0,1,0,1,1,x)

         Hr5(0,1,1,-1,-1) = H5(-1,-1,1,1,0,x) - Hr2(0,1)*Hr3(-1,-1,1) -
     $        Hr2(0,1)*Hr3(-1,1,-1) + Hr2(-1,0)*Hr3(-1,1,1) + Hr2(0,-1)
     $        *Hr3(-1,1,1) + Hr2(-1,-1)*Hr3(0,1,1) - Hr1(0)*Hr4(-1,-1,1
     $        ,1) - Hr1(-1)*Hr4(-1,1,1,0)

         Hr5(0,1,1,-1,0) = -H5(-1,0,1,1,0,x) - H5(-1,1,0,1,0,x) - 2*H5(
     $        -1,1,1,0,0,x) - Hr2(0,1)*Hr3(-1,0,1) - Hr2(0,1)*Hr3(-1,1
     $        ,0) + Hr2(-1,0)*Hr3(0,1,1) + Hr1(0)*Hr4(-1,0,1,1) + Hr1(0)
     $        *Hr4(-1,1,0,1) + Hr1(0)*Hr4(-1,1,1,0)

         Hr5(0,1,1,-1,1) = -H5(-1,1,1,0,1,x) - 3*H5(-1,1,1,1,0,x) - 2
     $        *Hr2(0,1)*Hr3(-1,1,1) + Hr2(-1,1)*Hr3(0,1,1) + 3*Hr1(0)
     $        *Hr4(-1,1,1,1)
         
         Hr5(0,1,1,0,-1) = H5(-1,0,1,1,0,x) + (Hr2(0,1)*Hr3(-1,0,1))/2.
     $        - (Hr2(0,1)*Hr3(0,-1,1))/2. - (Hr2(0,1)*Hr3(0,1,-1))/2. +
     $        Hr2(0,-1)*Hr3(0,1,1) - Hr1(0)*Hr4(-1,0,1,1)

         Hr5(0,1,1,0,0) = -3*H5(0,0,0,1,1,x) - H5(0,0,1,0,1,x) - (Hr2(0
     $        ,1)*Hr3(0,1,0))/2. + Hr2(0,0)*Hr3(0,1,1)

         Hr5(0,1,1,0,1) = -6*H5(0,0,1,1,1,x) - 3*H5(0,1,0,1,1,x) + Hr2(0
     $        ,1)*Hr3(0,1,1)

         Hr5(0,1,1,1,-1) = H5(-1,1,1,1,0,x) + Hr2(0,1)*Hr3(-1,1,1) -
     $        Hr2(-1,1)*Hr3(0,1,1) - Hr1(0)*Hr4(-1,1,1,1) + Hr1(-1)
     $        *Hr4(0,1,1,1)
         
         Hr5(0,1,1,1,0) = 4*H5(0,0,1,1,1,x) + 2*H5(0,1,0,1,1,x) - Hr2(0
     $        ,1)*Hr3(0,1,1) + Hr1(0)*Hr4(0,1,1,1)

         Hr5(0,1,1,1,1) = H5(0,1,1,1,1,x)

         Hr5(1,-1,-1,-1,-1) = H5(-1,-1,-1,-1,1,x) - (3*Hr2(-1,1)*Hr3(-1,
     $        -1,-1))/4. + (Hr2(1,-1)*Hr3(-1,-1,-1))/4. + Hr2(-1,-1)
     $        *Hr3(-1,-1,1) - Hr1(-1)*Hr4(-1,-1,-1,1)

         Hr5(1,-1,-1,-1,0) = 2*H5(-1,-1,-1,0,1,x) + 2*H5(-1,-1,-1,1,0,x)
     $        + H5(-1,-1,0,-1,1,x) + H5(-1,-1,1,-1,0,x) - Hr2(-1,1)*Hr3(
     $        -1,-1,0) + Hr1(1)*Hr4(-1,-1,-1,0)

         Hr5(1,-1,-1,-1,1) = 4*H5(-1,-1,-1,1,1,x) + 2*H5(-1,-1,1,-1,1,x)
     $        - Hr2(-1,1)*Hr3(-1,-1,1) + Hr1(1)*Hr4(-1,-1,-1,1)

         Hr5(1,-1,-1,0,-1) = -3*H5(-1,-1,-1,0,1,x) - 3*H5(-1,-1,-1,1,0
     $        ,x) - 2*H5(-1,-1,0,-1,1,x) - H5(-1,-1,1,-1,0,x) + Hr2(-1
     $        ,1)*Hr3(-1,-1,0) + Hr2(1,-1)*Hr3(-1,-1,0) - Hr2(-1,1)*Hr3(
     $        -1,0,-1) - 3*Hr1(1)*Hr4(-1,-1,-1,0) + Hr1(-1)*Hr4(-1,-1,0
     $        ,1) + Hr1(-1)*Hr4(-1,-1,1,0) + Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(1,-1,-1,0,0) = H5(-1,-1,0,0,1,x) + H5(-1,-1,0,1,0,x) + H5(
     $        -1,-1,1,0,0,x) + H5(-1,0,-1,0,1,x) + H5(-1,0,-1,1,0,x) +
     $        H5(-1,0,0,-1,1,x) - Hr2(-1,1)*Hr3(-1,0,0) + Hr1(1)*Hr4(-1,
     $        -1,0,0)

         Hr5(1,-1,-1,0,1) = 2*H5(-1,-1,0,1,1,x) + H5(-1,-1,1,0,1,x) + 2
     $        *H5(-1,0,-1,1,1,x) + H5(-1,0,1,-1,1,x) - Hr2(-1,1)*Hr3(-1
     $        ,0,1) + Hr1(1)*Hr4(-1,-1,0,1)

         Hr5(1,-1,-1,1,-1) = -6*H5(-1,-1,-1,1,1,x) - 3*H5(-1,-1,1,-1,1
     $        ,x) + 2*Hr2(-1,1)*Hr3(-1,-1,1) + Hr2(1,-1)*Hr3(-1,-1,1) -
     $        (Hr2(-1,1)*Hr3(-1,1,-1))/2. - 3*Hr1(1)*Hr4(-1,-1,-1,1)

         Hr5(1,-1,-1,1,0) = -H5(-1,-1,1,0,1,x) - 2*H5(-1,-1,1,1,0,x) -
     $        H5(-1,1,-1,1,0,x) + Hr1(1)*Hr4(-1,-1,1,0)

         Hr5(1,-1,-1,1,1) = -3*H5(-1,-1,1,1,1,x) - H5(-1,1,-1,1,1,x) +
     $        Hr1(1)*Hr4(-1,-1,1,1)

         Hr5(1,-1,0,-1,-1) = H5(-1,-1,0,-1,1,x) - Hr2(1,-1)*Hr3(-1,-1,0)
     $        + (3*Hr2(-1,1)*Hr3(-1,0,-1))/2. + (Hr2(1,-1)*Hr3(-1,0,-1))
     $        /2. - Hr2(-1,-1)*Hr3(-1,0,1) - Hr2(-1,-1)*Hr3(-1,1,0) + 3
     $        *Hr1(1)*Hr4(-1,-1,-1,0) - Hr1(-1)*Hr4(-1,0,-1,1)

         Hr5(1,-1,0,-1,0) = -H5(-1,0,-1,0,1,x) - H5(-1,0,-1,1,0,x) - 2
     $        *H5(-1,0,0,-1,1,x) + 2*Hr2(-1,1)*Hr3(-1,0,0) - (Hr2(-1,0)
     $        *Hr3(-1,0,1))/2. - (Hr2(-1,0)*Hr3(-1,1,0))/2. + (Hr2(-1,0)
     $        *Hr3(1,-1,0))/2. - 2*Hr1(1)*Hr4(-1,-1,0,0)

         Hr5(1,-1,0,-1,1) = -4*H5(-1,-1,0,1,1,x) + 4*H5(-1,-1,1,1,0,x) -
     $        4*H5(-1,0,-1,1,1,x) - 2*H5(-1,0,1,-1,1,x) + 2*H5(-1,1,-1,1
     $        ,0,x) + Hr2(-1,1)*Hr3(-1,0,1) - Hr2(-1,1)*Hr3(-1,1,0) +
     $        Hr1(1)*Hr4(-1,0,-1,1)

         Hr5(1,-1,0,0,-1) = H5(-1,0,0,-1,1,x) + Hr2(1,-1)*Hr3(-1,0,0) +
     $        (Hr2(-1,0)*Hr3(-1,0,1))/2. + (Hr2(-1,0)*Hr3(-1,1,0))/2. -
     $        (Hr2(-1,0)*Hr3(1,-1,0))/2. - Hr1(-1)*Hr4(-1,0,0,1) - Hr1(
     $        -1)*Hr4(-1,0,1,0) - Hr1(-1)*Hr4(-1,1,0,0)

         Hr5(1,-1,0,0,0) = -H5(-1,0,0,0,1,x) - H5(-1,0,0,1,0,x) - H5(-1
     $        ,0,1,0,0,x) - H5(-1,1,0,0,0,x) + Hr1(1)*Hr4(-1,0,0,0)

         Hr5(1,-1,0,0,1) = -2*H5(-1,0,0,1,1,x) - H5(-1,0,1,0,1,x) - H5(
     $        -1,1,0,0,1,x) + Hr1(1)*Hr4(-1,0,0,1)

         Hr5(1,-1,0,1,-1) = 4*H5(-1,-1,0,1,1,x) - 4*H5(-1,-1,1,1,0,x) +
     $        2*H5(-1,0,-1,1,1,x) + H5(-1,0,1,-1,1,x) - 2*H5(-1,1,-1,1,0
     $        ,x) + Hr2(-1,1)*Hr3(-1,0,1) + Hr2(1,-1)*Hr3(-1,0,1) + Hr2(
     $        -1,1)*Hr3(-1,1,0) - 2*Hr1(1)*Hr4(-1,-1,0,1) - Hr1(1)*Hr4(
     $        -1,0,-1,1) - 2*Hr1(-1)*Hr4(-1,0,1,1) - Hr1(-1)*Hr4(-1,1,0
     $        ,1)

         Hr5(1,-1,0,1,0) = -H5(-1,0,1,0,1,x) - 2*H5(-1,0,1,1,0,x) - H5(
     $        -1,1,0,1,0,x) + Hr1(1)*Hr4(-1,0,1,0)
         
         Hr5(1,-1,0,1,1) = -3*H5(-1,0,1,1,1,x) - H5(-1,1,0,1,1,x) +
     $        Hr1(1)*Hr4(-1,0,1,1)

         Hr5(1,-1,1,-1,-1) = H5(-1,-1,1,-1,1,x) - Hr2(-1,1)*Hr3(-1,-1,1)
     $        - Hr2(1,-1)*Hr3(-1,-1,1) + Hr2(-1,1)*Hr3(-1,1,-1) + (Hr2(1
     $        ,-1)*Hr3(-1,1,-1))/2. - 2*Hr2(-1,-1)*Hr3(-1,1,1) + 3
     $        *Hr1(1)*Hr4(-1,-1,-1,1) + 2*Hr1(-1)*Hr4(-1,-1,1,1)

         Hr5(1,-1,1,-1,0) = 2*H5(-1,-1,1,0,1,x) + 4*H5(-1,-1,1,1,0,x) -
     $        H5(-1,0,1,-1,1,x) + H5(-1,1,-1,1,0,x) + 2*Hr2(-1,1)*Hr3(-1
     $        ,0,1) + Hr2(-1,1)*Hr3(-1,1,0) - 2*Hr2(-1,0)*Hr3(-1,1,1) +
     $        Hr2(-1,1)*Hr3(1,-1,0) - 2*Hr1(1)*Hr4(-1,-1,0,1) - 2*Hr1(1)
     $        *Hr4(-1,-1,1,0) - Hr1(1)*Hr4(-1,0,-1,1)

         Hr5(1,-1,1,-1,1) = 12*H5(-1,-1,1,1,1,x) + 4*H5(-1,1,-1,1,1,x) -
     $        Hr2(-1,1)*Hr3(-1,1,1) + (Hr2(-1,1)*Hr3(1,-1,1))/2. - 2
     $        *Hr1(1)*Hr4(-1,-1,1,1)

         Hr5(1,-1,1,0,-1) = H5(-1,0,1,-1,1,x) - 2*Hr2(-1,1)*Hr3(-1,0,1)
     $        + Hr2(1,-1)*Hr3(-1,1,0) + 2*Hr2(-1,0)*Hr3(-1,1,1) - Hr2(-1
     $        ,1)*Hr3(1,-1,0) + 2*Hr1(1)*Hr4(-1,-1,0,1) + Hr1(1)*Hr4(-1
     $        ,0,-1,1) - Hr1(-1)*Hr4(-1,1,0,1) - 2*Hr1(-1)*Hr4(-1,1,1,0)

         Hr5(1,-1,1,0,0) = -H5(-1,1,0,0,1,x) - H5(-1,1,0,1,0,x) - 2*H5(
     $        -1,1,1,0,0,x) + Hr1(1)*Hr4(-1,1,0,0)

         Hr5(1,-1,1,0,1) = -2*H5(-1,1,0,1,1,x) - 2*H5(-1,1,1,0,1,x) +
     $        Hr1(1)*Hr4(-1,1,0,1)

         Hr5(1,-1,1,1,-1) = -6*H5(-1,-1,1,1,1,x) - 3*H5(-1,1,-1,1,1,x) +
     $        2*Hr2(-1,1)*Hr3(-1,1,1) + Hr2(1,-1)*Hr3(-1,1,1) - (Hr2(-1
     $        ,1)*Hr3(1,-1,1))/2. - 3*Hr1(-1)*Hr4(-1,1,1,1)

         Hr5(1,-1,1,1,0) = -H5(-1,1,1,0,1,x) - 3*H5(-1,1,1,1,0,x) +
     $        Hr1(1)*Hr4(-1,1,1,0)

         Hr5(1,-1,1,1,1) = -4*H5(-1,1,1,1,1,x) + Hr1(1)*Hr4(-1,1,1,1)

         Hr5(1,0,-1,-1,-1) = H5(-1,-1,-1,0,1,x) + Hr2(1,0)*Hr3(-1,-1,-1)
     $        - (Hr2(-1,1)*Hr3(-1,0,-1))/2. - (Hr2(1,-1)*Hr3(-1,0,-1))
     $        /2. + Hr2(-1,-1)*Hr3(-1,0,1) - Hr1(1)*Hr4(-1,-1,-1,0) -
     $        Hr1(-1)*Hr4(-1,-1,0,1)

         Hr5(1,0,-1,-1,0) = -2*H5(-1,-1,0,0,1,x) - H5(-1,-1,0,1,0,x) -
     $        H5(-1,0,-1,0,1,x) + Hr2(1,0)*Hr3(-1,-1,0) + (Hr2(-1,0)
     $        *Hr3(-1,0,1))/2. - (Hr2(-1,0)*Hr3(-1,1,0))/2. - (Hr2(-1,0)
     $        *Hr3(1,-1,0))/2.

         Hr5(1,0,-1,-1,1) = 2*H5(-1,-1,0,1,1,x) + H5(-1,-1,1,0,1,x) + 2
     $        *H5(-1,0,-1,1,1,x) + H5(-1,0,1,-1,1,x) + Hr2(1,0)*Hr3(-1,
     $        -1,1) - Hr1(1)*Hr4(-1,-1,0,1) - Hr1(1)*Hr4(-1,-1,1,0) -
     $        Hr1(1)*Hr4(-1,0,-1,1)

         Hr5(1,0,-1,0,-1) = H5(-1,0,-1,0,1,x) + Hr2(1,0)*Hr3(-1,0,-1) -
     $        2*Hr2(-1,1)*Hr3(-1,0,0) - 2*Hr2(1,-1)*Hr3(-1,0,0) - (Hr2(
     $        -1,0)*Hr3(-1,0,1))/2. + (Hr2(-1,0)*Hr3(-1,1,0))/2. + (Hr2(
     $        -1,0)*Hr3(1,-1,0))/2. + 2*Hr1(1)*Hr4(-1,-1,0,0) + 2*Hr1(
     $        -1)*Hr4(-1,0,0,1) + Hr1(-1)*Hr4(-1,0,1,0)

         Hr5(1,0,-1,0,0) = 3*H5(-1,0,0,0,1,x) + 2*H5(-1,0,0,1,0,x) + H5(
     $        -1,0,1,0,0,x) + Hr2(1,0)*Hr3(-1,0,0) - 3*Hr1(1)*Hr4(-1,0,0
     $        ,0)

         Hr5(1,0,-1,0,1) = 4*H5(-1,0,0,1,1,x) + 2*H5(-1,0,1,0,1,x) +
     $        Hr2(1,0)*Hr3(-1,0,1) - 2*Hr1(1)*Hr4(-1,0,0,1) - Hr1(1)
     $        *Hr4(-1,0,1,0)

         Hr5(1,0,-1,1,-1) = -4*H5(-1,-1,0,1,1,x) - 2*H5(-1,-1,1,0,1,x) -
     $        2*H5(-1,0,-1,1,1,x) - H5(-1,0,1,-1,1,x) - Hr2(-1,1)*Hr3(-1
     $        ,0,1) - Hr2(1,-1)*Hr3(-1,0,1) + Hr2(1,0)*Hr3(-1,1,-1) -
     $        Hr2(-1,1)*Hr3(-1,1,0) - Hr2(1,-1)*Hr3(-1,1,0) + 2*Hr1(1)
     $        *Hr4(-1,-1,0,1) + 2*Hr1(1)*Hr4(-1,-1,1,0) + Hr1(1)*Hr4(-1
     $        ,0,-1,1) + 2*Hr1(-1)*Hr4(-1,0,1,1) + Hr1(-1)*Hr4(-1,1,0,1)

         Hr5(1,0,-1,1,0) = H5(-1,0,1,0,1,x) + 2*H5(-1,0,1,1,0,x) + 2*H5(
     $        -1,1,0,0,1,x) + H5(-1,1,0,1,0,x) + Hr2(1,0)*Hr3(-1,1,0) -
     $        Hr1(1)*Hr4(-1,0,1,0) - 2*Hr1(1)*Hr4(-1,1,0,0)

         Hr5(1,0,-1,1,1) = 3*H5(-1,0,1,1,1,x) + 2*H5(-1,1,0,1,1,x) + H5(
     $        -1,1,1,0,1,x) + Hr2(1,0)*Hr3(-1,1,1) - Hr1(1)*Hr4(-1,0,1
     $        ,1) - Hr1(1)*Hr4(-1,1,0,1) - Hr1(1)*Hr4(-1,1,1,0)

         Hr5(1,0,0,-1,-1) = H5(-1,-1,0,0,1,x) - (Hr2(0,1)*Hr3(-1,-1,0))
     $        /2. - (Hr2(1,0)*Hr3(-1,-1,0))/2. - (Hr2(0,1)*Hr3(-1,0,-1))
     $        /2. - (Hr2(1,0)*Hr3(-1,0,-1))/2. + Hr2(-1,1)*Hr3(-1,0,0) +
     $        Hr2(1,-1)*Hr3(-1,0,0) - (Hr2(0,1)*Hr3(0,-1,-1))/2. +
     $        (Hr2(1,0)*Hr3(0,-1,-1))/2. + Hr2(-1,-1)*Hr3(0,0,1) -
     $        Hr1(1)*Hr4(-1,-1,0,0) - Hr1(-1)*Hr4(-1,0,0,1)

         Hr5(1,0,0,-1,0) = -3*H5(-1,0,0,0,1,x) - H5(-1,0,0,1,0,x) -
     $        Hr2(0,1)*Hr3(-1,0,0) - Hr2(1,0)*Hr3(-1,0,0) - (Hr2(0,1)
     $        *Hr3(0,-1,0))/2. + (Hr2(1,0)*Hr3(0,-1,0))/2. + Hr2(-1,0)
     $        *Hr3(0,0,1) + 3*Hr1(1)*Hr4(-1,0,0,0)

         Hr5(1,0,0,-1,1) = -2*H5(-1,0,0,1,1,x) - H5(-1,0,1,0,1,x) - H5(
     $        -1,1,0,0,1,x) - (Hr2(0,1)*Hr3(-1,0,1))/2. - (Hr2(1,0)*Hr3(
     $        -1,0,1))/2. - (Hr2(0,1)*Hr3(-1,1,0))/2. - (Hr2(1,0)*Hr3(-1
     $        ,1,0))/2. - (Hr2(0,1)*Hr3(0,-1,1))/2. + (Hr2(1,0)*Hr3(0,-1
     $        ,1))/2. + Hr2(-1,1)*Hr3(0,0,1) + Hr1(1)*Hr4(-1,0,0,1) +
     $        Hr1(1)*Hr4(-1,0,1,0) + Hr1(1)*Hr4(-1,1,0,0)

         Hr5(1,0,0,0,-1) = H5(-1,0,0,0,1,x) + (Hr2(0,1)*Hr3(-1,0,0))/3.
     $        + (Hr2(1,0)*Hr3(-1,0,0))/3. - (Hr2(0,1)*Hr3(0,-1,0))/6. -
     $        (Hr2(1,0)*Hr3(0,-1,0))/6. - (2*Hr2(0,1)*Hr3(0,0,-1))/3. +
     $        (Hr2(1,0)*Hr3(0,0,-1))/3. + Hr2(0,-1)*Hr3(0,0,1) - Hr1(1)
     $        *Hr4(-1,0,0,0) - Hr1(-1)*Hr4(0,0,0,1)

         Hr5(1,0,0,0,0) = H5(0,0,0,0,1,x) - (3*Hr2(0,1)*Hr3(0,0,0))/4. +
     $        (Hr2(1,0)*Hr3(0,0,0))/4. + Hr2(0,0)*Hr3(0,0,1) - Hr1(0)
     $        *Hr4(0,0,0,1)

         Hr5(1,0,0,0,1) = 4*H5(0,0,0,1,1,x) + 2*H5(0,0,1,0,1,x) - Hr2(0
     $        ,1)*Hr3(0,0,1) + Hr1(1)*Hr4(0,0,0,1)

         Hr5(1,0,0,1,-1) = H5(-1,1,0,0,1,x) - (Hr2(1,0)*Hr3(-1,0,1))/2.
     $        + (Hr2(0,1)*Hr3(-1,1,0))/2. + (Hr2(1,0)*Hr3(-1,1,0))/2. -
     $        (Hr2(1,0)*Hr3(0,-1,1))/2. + Hr2(1,-1)*Hr3(0,0,1) - (Hr2(0
     $        ,1)*Hr3(0,1,-1))/2. - Hr1(1)*Hr4(-1,1,0,0)

         Hr5(1,0,0,1,0) = -6*H5(0,0,0,1,1,x) - 3*H5(0,0,1,0,1,x) + 2
     $        *Hr2(0,1)*Hr3(0,0,1) + Hr2(1,0)*Hr3(0,0,1) - (Hr2(0,1)
     $        *Hr3(0,1,0))/2. - 3*Hr1(1)*Hr4(0,0,0,1)

         Hr5(1,0,0,1,1) = -3*H5(0,0,1,1,1,x) - H5(0,1,0,1,1,x) + Hr1(1)
     $        *Hr4(0,0,1,1)

         Hr5(1,0,1,-1,-1) = H5(-1,-1,1,0,1,x) + 2*Hr2(0,1)*Hr3(-1,-1,1)
     $        - (Hr2(-1,1)*Hr3(-1,0,1))/2. + Hr2(0,1)*Hr3(-1,1,-1) -
     $        (Hr2(1,0)*Hr3(-1,1,-1))/2. + (Hr2(-1,1)*Hr3(-1,1,0))/2. +
     $        (Hr2(1,-1)*Hr3(-1,1,0))/2. - (Hr2(-1,1)*Hr3(0,-1,1))/2. +
     $        (Hr2(1,-1)*Hr3(0,1,-1))/2. - 2*Hr2(-1,-1)*Hr3(0,1,1) -
     $        Hr1(1)*Hr4(-1,-1,1,0) - Hr1(-1)*Hr4(-1,1,0,1)

         Hr5(1,0,1,-1,0) = -H5(-1,0,1,0,1,x) - 2*H5(-1,1,0,0,1,x) - H5(
     $        -1,1,0,1,0,x) + Hr2(0,1)*Hr3(-1,0,1) - Hr2(1,0)*Hr3(-1,0
     $        ,1) + Hr2(0,1)*Hr3(-1,1,0) - Hr2(1,0)*Hr3(-1,1,0) - 2*Hr2(
     $        -1,0)*Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,0) + Hr1(1)*Hr4(-1,0
     $        ,1,0) + 2*Hr1(1)*Hr4(-1,1,0,0)

         Hr5(1,0,1,-1,1) = -2*H5(-1,1,0,1,1,x) - 2*H5(-1,1,1,0,1,x) + 2
     $        *Hr2(0,1)*Hr3(-1,1,1) - 2*Hr2(1,0)*Hr3(-1,1,1) - 2*Hr2(-1
     $        ,1)*Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,1) + Hr1(1)*Hr4(-1,1,0
     $        ,1) + 2*Hr1(1)*Hr4(-1,1,1,0)

         Hr5(1,0,1,0,-1) = H5(-1,0,1,0,1,x) + (Hr2(0,1)*Hr3(-1,0,1))/2.
     $        + 2*Hr2(1,0)*Hr3(-1,0,1) - Hr2(0,1)*Hr3(-1,1,0) + (3*Hr2(0
     $        ,1)*Hr3(0,-1,1))/2. + Hr2(1,0)*Hr3(0,-1,1) - 2*Hr2(-1,1)
     $        *Hr3(0,0,1) - 2*Hr2(1,-1)*Hr3(0,0,1) + (3*Hr2(0,1)*Hr3(0,1
     $        ,-1))/2. + Hr2(1,0)*Hr3(0,1,-1) - 2*Hr2(0,-1)*Hr3(0,1,1) -
     $        Hr2(0,1)*Hr3(1,-1,0) - Hr1(1)*Hr4(-1,0,1,0) + 2*Hr1(-1)
     $        *Hr4(0,0,1,1)

         Hr5(1,0,1,0,0) = H5(0,0,1,0,1,x) - Hr2(0,1)*Hr3(0,0,1) - Hr2(1
     $        ,0)*Hr3(0,0,1) + Hr2(0,1)*Hr3(0,1,0) + (Hr2(1,0)*Hr3(0,1
     $        ,0))/2. - 2*Hr2(0,0)*Hr3(0,1,1) + 3*Hr1(1)*Hr4(0,0,0,1) +
     $        2*Hr1(0)*Hr4(0,0,1,1)

         Hr5(1,0,1,0,1) = 12*H5(0,0,1,1,1,x) + 4*H5(0,1,0,1,1,x) - Hr2(0
     $        ,1)*Hr3(0,1,1) + (Hr2(0,1)*Hr3(1,0,1))/2. - 2*Hr1(1)*Hr4(0
     $        ,0,1,1)

         Hr5(1,0,1,1,-1) = H5(-1,1,1,0,1,x) - 2*Hr2(0,1)*Hr3(-1,1,1) +
     $        Hr2(1,0)*Hr3(-1,1,1) + 3*Hr2(-1,1)*Hr3(0,1,1) + Hr2(1,-1)
     $        *Hr3(0,1,1) - Hr2(0,1)*Hr3(1,-1,1) - Hr1(1)*Hr4(-1,1,1,0)
     $        - 3*Hr1(-1)*Hr4(0,1,1,1)

         Hr5(1,0,1,1,0) = -6*H5(0,0,1,1,1,x) - 3*H5(0,1,0,1,1,x) + 2
     $        *Hr2(0,1)*Hr3(0,1,1) + Hr2(1,0)*Hr3(0,1,1) - (Hr2(0,1)
     $        *Hr3(1,0,1))/2. - 3*Hr1(0)*Hr4(0,1,1,1)

         Hr5(1,0,1,1,1) = -4*H5(0,1,1,1,1,x) + Hr1(1)*Hr4(0,1,1,1)

         Hr5(1,1,-1,-1,-1) = H5(-1,-1,-1,1,1,x) + Hr2(1,1)*Hr3(-1,-1,-1)
     $        - (Hr2(-1,1)*Hr3(-1,1,-1))/2. - (Hr2(1,-1)*Hr3(-1,1,-1))
     $        /2. + Hr2(-1,-1)*Hr3(-1,1,1) - Hr1(1)*Hr4(-1,-1,-1,1) -
     $        Hr1(-1)*Hr4(-1,-1,1,1)

         Hr5(1,1,-1,-1,0) = -H5(-1,-1,0,1,1,x) - H5(-1,-1,1,0,1,x) - H5(
     $        -1,-1,1,1,0,x) - H5(-1,0,-1,1,1,x) + Hr2(1,1)*Hr3(-1,-1,0)
     $        - Hr2(-1,1)*Hr3(-1,0,1) - Hr2(-1,1)*Hr3(-1,1,0) + Hr2(-1
     $        ,0)*Hr3(-1,1,1) - Hr2(-1,1)*Hr3(1,-1,0) + Hr1(1)*Hr4(-1,-1
     $        ,0,1) + Hr1(1)*Hr4(-1,-1,1,0) + Hr1(1)*Hr4(-1,0,-1,1)

         Hr5(1,1,-1,-1,1) = -3*H5(-1,-1,1,1,1,x) - H5(-1,1,-1,1,1,x) +
     $        Hr2(1,1)*Hr3(-1,-1,1) - (Hr2(-1,1)*Hr3(1,-1,1))/2.

         Hr5(1,1,-1,0,-1) = H5(-1,0,-1,1,1,x) + Hr2(1,1)*Hr3(-1,0,-1) -
     $        Hr2(1,-1)*Hr3(-1,0,1) - Hr2(1,-1)*Hr3(-1,1,0) - Hr2(-1,0)
     $        *Hr3(-1,1,1) + Hr2(-1,1)*Hr3(1,-1,0) - Hr1(1)*Hr4(-1,0,-1
     $        ,1) + Hr1(-1)*Hr4(-1,0,1,1) + Hr1(-1)*Hr4(-1,1,0,1) + Hr1(
     $        -1)*Hr4(-1,1,1,0)

         Hr5(1,1,-1,0,0) = H5(-1,0,0,1,1,x) + H5(-1,0,1,0,1,x) + H5(-1,0
     $        ,1,1,0,x) + H5(-1,1,0,0,1,x) + H5(-1,1,0,1,0,x) + H5(-1,1
     $        ,1,0,0,x) + Hr2(1,1)*Hr3(-1,0,0) - Hr1(1)*Hr4(-1,0,0,1) -
     $        Hr1(1)*Hr4(-1,0,1,0) - Hr1(1)*Hr4(-1,1,0,0)

         Hr5(1,1,-1,0,1) = 3*H5(-1,0,1,1,1,x) + 2*H5(-1,1,0,1,1,x) + H5(
     $        -1,1,1,0,1,x) + Hr2(1,1)*Hr3(-1,0,1) - 2*Hr1(1)*Hr4(-1,0,1
     $        ,1) - Hr1(1)*Hr4(-1,1,0,1)

         Hr5(1,1,-1,1,-1) = H5(-1,1,-1,1,1,x) + Hr2(1,1)*Hr3(-1,1,-1) -
     $        2*Hr2(-1,1)*Hr3(-1,1,1) - 2*Hr2(1,-1)*Hr3(-1,1,1) + (Hr2(
     $        -1,1)*Hr3(1,-1,1))/2. + 2*Hr1(1)*Hr4(-1,-1,1,1) + 3*Hr1(
     $        -1)*Hr4(-1,1,1,1)

         Hr5(1,1,-1,1,0) = H5(-1,1,0,1,1,x) + 2*H5(-1,1,1,0,1,x) + 3*H5(
     $        -1,1,1,1,0,x) + Hr2(1,1)*Hr3(-1,1,0) - Hr1(1)*Hr4(-1,1,0
     $        ,1) - 2*Hr1(1)*Hr4(-1,1,1,0)

         Hr5(1,1,-1,1,1) = 6*H5(-1,1,1,1,1,x) + Hr2(1,1)*Hr3(-1,1,1) - 3
     $        *Hr1(1)*Hr4(-1,1,1,1)

         Hr5(1,1,0,-1,-1) = H5(-1,-1,0,1,1,x) - 2*Hr2(0,1)*Hr3(-1,-1,1)
     $        - Hr2(1,0)*Hr3(-1,-1,1) + (3*Hr2(-1,1)*Hr3(-1,0,1))/2. +
     $        Hr2(1,-1)*Hr3(-1,0,1) - Hr2(0,1)*Hr3(-1,1,-1) - (Hr2(1,0)
     $        *Hr3(-1,1,-1))/2. + (Hr2(-1,1)*Hr3(-1,1,0))/2. + (Hr2(1,
     $        -1)*Hr3(-1,1,0))/2. + Hr2(1,1)*Hr3(0,-1,-1) + (Hr2(-1,1)
     $        *Hr3(0,-1,1))/2. - (Hr2(1,-1)*Hr3(0,1,-1))/2. + Hr2(-1,-1)
     $        *Hr3(0,1,1) - Hr1(1)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,0,1
     $        ,1)

         Hr5(1,1,0,-1,0) = -2*H5(-1,0,0,1,1,x) - H5(-1,0,1,0,1,x) - H5(
     $        -1,0,1,1,0,x) - Hr2(0,1)*Hr3(-1,0,1) - Hr2(0,1)*Hr3(-1,1
     $        ,0) + Hr2(1,1)*Hr3(0,-1,0) + Hr2(-1,0)*Hr3(0,1,1) - Hr2(0
     $        ,1)*Hr3(1,-1,0) + 2*Hr1(1)*Hr4(-1,0,0,1) + Hr1(1)*Hr4(-1,0
     $        ,1,0)

         Hr5(1,1,0,-1,1) = -3*H5(-1,0,1,1,1,x) - H5(-1,1,0,1,1,x) - 2
     $        *Hr2(0,1)*Hr3(-1,1,1) + Hr2(1,1)*Hr3(0,-1,1) + Hr2(-1,1)
     $        *Hr3(0,1,1) - Hr2(0,1)*Hr3(1,-1,1) + 2*Hr1(1)*Hr4(-1,0,1
     $        ,1) + Hr1(1)*Hr4(-1,1,0,1)

         Hr5(1,1,0,0,-1) = H5(-1,0,0,1,1,x) - Hr2(1,0)*Hr3(-1,0,1) +
     $        Hr2(0,1)*Hr3(-1,1,0) - Hr2(0,1)*Hr3(0,-1,1) - Hr2(1,0)
     $        *Hr3(0,-1,1) + Hr2(1,1)*Hr3(0,0,-1) + Hr2(-1,1)*Hr3(0,0,1)
     $        + Hr2(1,-1)*Hr3(0,0,1) - Hr2(0,1)*Hr3(0,1,-1) - Hr2(1,0)
     $        *Hr3(0,1,-1) + Hr2(0,-1)*Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,0)
     $        - Hr1(1)*Hr4(-1,0,0,1) - Hr1(-1)*Hr4(0,0,1,1)

         Hr5(1,1,0,0,0) = H5(0,0,0,1,1,x) + Hr2(1,1)*Hr3(0,0,0) - (Hr2(0
     $        ,1)*Hr3(0,1,0))/2. - (Hr2(1,0)*Hr3(0,1,0))/2. + Hr2(0,0)
     $        *Hr3(0,1,1) - Hr1(1)*Hr4(0,0,0,1) - Hr1(0)*Hr4(0,0,1,1)

         Hr5(1,1,0,0,1) = -3*H5(0,0,1,1,1,x) - H5(0,1,0,1,1,x) + Hr2(1
     $        ,1)*Hr3(0,0,1) - (Hr2(0,1)*Hr3(1,0,1))/2.

         Hr5(1,1,0,1,-1) = H5(-1,1,0,1,1,x) + 2*Hr2(0,1)*Hr3(-1,1,1) +
     $        Hr2(1,1)*Hr3(0,1,-1) - 3*Hr2(-1,1)*Hr3(0,1,1) - 2*Hr2(1,
     $        -1)*Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,1) - Hr1(1)*Hr4(-1,1,0
     $        ,1) + 3*Hr1(-1)*Hr4(0,1,1,1)

         Hr5(1,1,0,1,0) = H5(0,1,0,1,1,x) + Hr2(1,1)*Hr3(0,1,0) - 2
     $        *Hr2(0,1)*Hr3(0,1,1) - 2*Hr2(1,0)*Hr3(0,1,1) + (Hr2(0,1)
     $        *Hr3(1,0,1))/2. + 2*Hr1(1)*Hr4(0,0,1,1) + 3*Hr1(0)*Hr4(0,1
     $        ,1,1)

         Hr5(1,1,0,1,1) = 6*H5(0,1,1,1,1,x) + Hr2(1,1)*Hr3(0,1,1) - 3
     $        *Hr1(1)*Hr4(0,1,1,1)

         Hr5(1,1,1,-1,-1) = H5(-1,-1,1,1,1,x) - (2*Hr2(1,1)*Hr3(-1,-1
     $        ,1))/3. - (2*Hr2(1,1)*Hr3(-1,1,-1))/3. + Hr2(-1,1)*Hr3(-1
     $        ,1,1) + Hr2(1,-1)*Hr3(-1,1,1) + (Hr2(1,1)*Hr3(1,-1,-1))/3.
     $        - Hr1(1)*Hr4(-1,-1,1,1) - Hr1(-1)*Hr4(-1,1,1,1)

         Hr5(1,1,1,-1,0) = -H5(-1,0,1,1,1,x) - H5(-1,1,0,1,1,x) - H5(-1
     $        ,1,1,0,1,x) - H5(-1,1,1,1,0,x) - (2*Hr2(1,1)*Hr3(-1,0,1))
     $        /3. - (2*Hr2(1,1)*Hr3(-1,1,0))/3. + (Hr2(1,1)*Hr3(1,-1,0))
     $        /3. + Hr1(1)*Hr4(-1,0,1,1) + Hr1(1)*Hr4(-1,1,0,1) + Hr1(1)
     $        *Hr4(-1,1,1,0)

         Hr5(1,1,1,-1,1) = -4*H5(-1,1,1,1,1,x) - (4*Hr2(1,1)*Hr3(-1,1
     $        ,1))/3. + (Hr2(1,1)*Hr3(1,-1,1))/3. + 3*Hr1(1)*Hr4(-1,1,1
     $        ,1)

         Hr5(1,1,1,0,-1) = H5(-1,0,1,1,1,x) - (2*Hr2(1,1)*Hr3(0,-1,1))
     $        /3. - (2*Hr2(1,1)*Hr3(0,1,-1))/3. + Hr2(-1,1)*Hr3(0,1,1) +
     $        Hr2(1,-1)*Hr3(0,1,1) + (Hr2(1,1)*Hr3(1,0,-1))/3. - Hr1(1)
     $        *Hr4(-1,0,1,1) - Hr1(-1)*Hr4(0,1,1,1)

         Hr5(1,1,1,0,0) = H5(0,0,1,1,1,x) - (2*Hr2(1,1)*Hr3(0,0,1))/3. -
     $        (2*Hr2(1,1)*Hr3(0,1,0))/3. + Hr2(0,1)*Hr3(0,1,1) + Hr2(1
     $        ,0)*Hr3(0,1,1) + (Hr2(1,1)*Hr3(1,0,0))/3. - Hr1(1)*Hr4(0,0
     $        ,1,1) - Hr1(0)*Hr4(0,1,1,1)

         Hr5(1,1,1,0,1) = -4*H5(0,1,1,1,1,x) - (4*Hr2(1,1)*Hr3(0,1,1))
     $        /3. + (Hr2(1,1)*Hr3(1,0,1))/3. + 3*Hr1(1)*Hr4(0,1,1,1)

         Hr5(1,1,1,1,-1) = H5(-1,1,1,1,1,x) + (Hr2(1,1)*Hr3(-1,1,1))/2.
     $        - (Hr2(1,1)*Hr3(1,-1,1))/6. + (Hr2(1,1)*Hr3(1,1,-1))/6. -
     $        Hr1(1)*Hr4(-1,1,1,1)

         Hr5(1,1,1,1,0) = H5(0,1,1,1,1,x) + (Hr2(1,1)*Hr3(0,1,1))/2. -
     $        (Hr2(1,1)*Hr3(1,0,1))/6. + (Hr2(1,1)*Hr3(1,1,0))/6. -
     $        Hr1(1)*Hr4(0,1,1,1)

         Hr5(1,1,1,1,1) = (Hr2(1,1)*Hr3(1,1,1))/10.
      elseif(x.le.1.0d0) then
         Hr5(-1,-1,-1,-1,-1) = (Hr2(-1,-1)*Hr3(-1,-1,-1))/10.

         Hr5(-1,-1,-1,-1,0) = (-120*li5half + ln2**5 - 20*ln2**3*z2 - 48
     $        *ln2*z2**2 + 60*ln2**2*z3 + 120*z5)/120. + ((-120*li4half
     $        - 5*ln2**4 + 60*ln2**2*z2 + 48*z2**2 - 120*ln2*z3)*H1(-1
     $        ,xlcl))/120. + ((-4*ln2*z2 + z3)*H1(-1,xlcl)**2)/16. + (z2
     $        *H1(-1,xlcl)**3)/12. - H1(-1,xlcl)**5/120. - H5(-1,-1,-1,
     $        -1,1,xlcl)

         Hr5(-1,-1,-1,-1,1) = (-48*li5half - 48*li4half*ln2 - 2*ln2**5 +
     $        8*ln2**3*z2 - 21*ln2**2*z3 + 48*z5)/48. + ((120*li4half +
     $        10*ln2**4 - 30*ln2**2*z2 - 48*z2**2 + 105*ln2*z3)*H1(-1
     $        ,xlcl))/120. + ((-4*ln2**3 + 3*z3)*H1(-1,xlcl)**2)/48. +
     $        ((ln2**2 - z2)*H1(-1,xlcl)**3)/12. - (ln2*H1(-1,xlcl)**4)
     $        /24. + H1(-1,xlcl)**5/120. - H5(-1,-1,-1,-1,0,xlcl)

         Hr5(-1,-1,-1,0,-1) = Hr1(-1)*Hr4(-1,-1,-1,0) - 4*Hr5(-1,-1,-1,
     $        -1,0)

         Hr5(-1,-1,-1,0,0) = (960*li5half - 8*ln2**5 + 80*ln2**3*z2 +
     $        360*ln2*z2**2 - 240*ln2**2*z3 - 240*z2*z3 - 495*z5)/480. +
     $        (3*z3*H1(-1,xlcl)**2)/8. - H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)*((24*li4half + ln2**4 - 6*ln2**2*z2 - 9*z2**2 + 12
     $        *ln2*z3)/12. - H4(-1,-1,-1,1,xlcl)) + 3*H5(-1,-1,-1,-1,1
     $        ,xlcl) - H5(-1,-1,-1,1,1,xlcl)

         Hr5(-1,-1,-1,0,1) = (-240*li5half - 240*li4half*ln2 - 8*ln2**5
     $        + 80*ln2**3*z2 + 18*ln2*z2**2 - 180*ln2**2*z3 + 105*z2*z3
     $        + 30*z5)/240. + ((8*ln2*z2 - 5*z3)*H1(-1,xlcl)**2)/16. -
     $        (z2*H1(-1,xlcl)**3)/6. - (ln2*H1(-1,xlcl)**4)/24. + H1(-1
     $        ,xlcl)**5/120. - ln2*H4(-1,-1,-1,1,xlcl) + H1(-1,xlcl)*((
     $        -20*ln2**2*z2 - 3*z2**2 + 25*ln2*z3)/40. + H4(-1,-1,-1,1
     $        ,xlcl)) - H5(-1,-1,-1,-1,0,xlcl) - 4*H5(-1,-1,-1,-1,1
     $        ,xlcl) - H5(-1,-1,-1,1,0,xlcl)

         Hr5(-1,-1,-1,1,-1) = Hr1(-1)*Hr4(-1,-1,-1,1) - 4*Hr5(-1,-1,-1,
     $        -1,1)

         Hr5(-1,-1,-1,1,0) = (960*li5half + 720*li4half*ln2 + 22*ln2**5
     $        - 80*ln2**3*z2 + 96*ln2*z2**2 + 195*ln2**2*z3 + 105*z2*z3
     $        - 1170*z5)/240. + ((ln2*z2 - 2*z3)*H1(-1,xlcl)**2)/4. +
     $        (z2*H1(-1,xlcl)**3)/6. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)
     $        *((-48*li4half - 2*ln2**4 + 6*ln2**2*z2 + 21*z2**2 - 39
     $        *ln2*z3)/24. - H4(-1,-1,-1,0,xlcl)) + 4*H5(-1,-1,-1,-1,0
     $        ,xlcl) + H5(-1,-1,-1,-1,1,xlcl) - H5(-1,-1,-1,0,1,xlcl)

         Hr5(-1,-1,-1,1,1) = (-480*li5half + 8*ln2**5 - 40*ln2**3*z2 -
     $        192*ln2*z2**2 + 210*ln2**2*z3 - 240*z2*z3 + 945*z5)/480. +
     $        ((4*ln2**3 - 12*ln2*z2 + 21*z3)*H1(-1,xlcl)**2)/48. - (ln2
     $        **2*H1(-1,xlcl)**3)/12. + (ln2*H1(-1,xlcl)**4)/24. - H1(-1
     $        ,xlcl)**5/120. - ln2*H4(-1,-1,-1,0,xlcl) + H1(-1,xlcl)*((
     $        -5*ln2**4 - 6*z2**2 + 15*ln2*z3)/120. + H4(-1,-1,-1,0
     $        ,xlcl)) - 3*H5(-1,-1,-1,-1,0,xlcl) - H5(-1,-1,-1,0,0,xlcl)

         Hr5(-1,-1,0,-1,-1) = Hr2(-1,-1)*Hr3(-1,-1,0) - 3*Hr1(-1)*Hr4(-1
     $        ,-1,-1,0) + 6*Hr5(-1,-1,-1,-1,0)

         Hr5(-1,-1,0,-1,0) = (-3840*li5half + 32*ln2**5 - 320*ln2**3*z2
     $        - 1320*ln2*z2**2 + 960*ln2**2*z3 + 1380*z2*z3 + 1095*z5)
     $        /960. + (z2*H1(-1,xlcl)**3)/12. - H1(-1,xlcl)**5/120. +
     $        H1(-1,xlcl)**2*((-3*z3)/4. - H3(-1,-1,1,xlcl)/2.) + (z2
     $        *H3(-1,-1,1,xlcl))/2. + H1(-1,xlcl)*((-96*li4half - 4*ln2
     $        **4 + 24*ln2**2*z2 + 33*z2**2 - 48*ln2*z3)/24. + 3*H4(-1,
     $        -1,-1,1,xlcl)) - 7*H5(-1,-1,-1,-1,1,xlcl) - H5(-1,-1,1,-1
     $        ,1,xlcl)

         Hr5(-1,-1,0,-1,1) = (-480*li4half*ln2 - 20*ln2**5 - 240*ln2**3
     $        *z2 - 12*ln2*z2**2 + 390*ln2**2*z3 - 630*z2*z3 + 1305*z5)
     $        /480. + ((ln2**2 - z2)*H1(-1,xlcl)**3)/12. - (ln2*H1(-1
     $        ,xlcl)**4)/24. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**2*((
     $        -12*ln2*z2 + 13*z3)/16. + H3(-1,-1,1,xlcl)/2.) + ((ln2**2
     $        - z2)*H3(-1,-1,1,xlcl))/2. + H1(-1,xlcl)*((48*li4half + 2
     $        *ln2**4 + 6*ln2**2*z2 - 15*z2**2 + 12*ln2*z3)/12. - ln2
     $        *H3(-1,-1,1,xlcl) - 3*H4(-1,-1,-1,1,xlcl)) + 3*ln2*H4(-1,
     $        -1,-1,1,xlcl) - H5(-1,-1,-1,-1,0,xlcl) + 6*H5(-1,-1,-1,-1
     $        ,1,xlcl) - H5(-1,-1,1,-1,0,xlcl)

         Hr5(-1,-1,0,0,-1) = Hr1(-1)*Hr4(-1,-1,0,0) - 3*Hr5(-1,-1,-1,0
     $        ,0) - Hr5(-1,-1,0,-1,0)
         
         Hr5(-1,-1,0,0,0) = (-56*ln2*z2**2 + 80*z2*z3 - 145*z5)/160. -
     $        H1(-1,xlcl)**5/120. - (H1(-1,xlcl)**2*H3(-1,-1,1,xlcl))/2.
     $        + H1(-1,xlcl)*((7*z2**2)/20. + 2*H4(-1,-1,-1,1,xlcl) - H4(
     $        -1,-1,1,1,xlcl)) - 3*H5(-1,-1,-1,-1,1,xlcl) + 2*H5(-1,-1,
     $        -1,1,1,xlcl) - H5(-1,-1,1,1,1,xlcl)

         Hr5(-1,-1,0,0,1) = (960*li5half + 480*li4half*ln2 + 12*ln2**5 -
     $        40*ln2**3*z2 + 144*ln2*z2**2 + 120*ln2**2*z3 - 180*z2*z3 -
     $        585*z5)/240. - (z2*H1(-1,xlcl)**3)/6. - (ln2*H1(-1,xlcl)
     $        **4)/24. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**2*(z3/2. +
     $        H3(-1,-1,1,xlcl)/2.) - z2*H3(-1,-1,1,xlcl) + 2*ln2*H4(-1,
     $        -1,-1,1,xlcl) - ln2*H4(-1,-1,1,1,xlcl) + H1(-1,xlcl)*((120
     $        *li4half + 5*ln2**4 - 30*ln2**2*z2 - 36*z2**2 + 45*ln2*z3)
     $        /60. - ln2*H3(-1,-1,1,xlcl) - 2*H4(-1,-1,-1,1,xlcl) + H4(
     $        -1,-1,1,1,xlcl)) - H5(-1,-1,-1,-1,0,xlcl) + 2*H5(-1,-1,-1,
     $        -1,1,xlcl) - H5(-1,-1,-1,1,0,xlcl) - 3*H5(-1,-1,-1,1,1
     $        ,xlcl) - H5(-1,-1,1,-1,0,xlcl) - H5(-1,-1,1,-1,1,xlcl) -
     $        H5(-1,-1,1,1,0,xlcl)

         Hr5(-1,-1,0,1,-1) = Hr1(-1)*Hr4(-1,-1,0,1) - 3*Hr5(-1,-1,-1,0
     $        ,1) - Hr5(-1,-1,0,-1,1)

         Hr5(-1,-1,0,1,0) = (-1920*li5half + 16*ln2**5 - 160*ln2**3*z2 -
     $        612*ln2*z2**2 + 360*ln2**2*z3 + 150*z2*z3 + 1545*z5)/480.
     $        + (z2*H1(-1,xlcl)**3)/6. + H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)**2*(-z3 + H3(-1,-1,1,xlcl)/2.) + z2*H3(-1,-1,1
     $        ,xlcl) + H1(-1,xlcl)*((-480*li4half - 20*ln2**4 + 120*ln2
     $        **2*z2 + 153*z2**2 - 180*ln2*z3)/120. - H4(-1,-1,-1,0
     $        ,xlcl) - 3*H4(-1,-1,-1,1,xlcl) - H4(-1,-1,1,0,xlcl)) + 4
     $        *H5(-1,-1,-1,-1,0,xlcl) + 7*H5(-1,-1,-1,-1,1,xlcl) - H5(-1
     $        ,-1,-1,0,1,xlcl) + 3*H5(-1,-1,-1,1,0,xlcl) + H5(-1,-1,1,-1
     $        ,0,xlcl) + H5(-1,-1,1,-1,1,xlcl) - H5(-1,-1,1,0,1,xlcl)

         Hr5(-1,-1,0,1,1) = (480*li5half - 4*ln2**5 + 40*ln2**3*z2 + 60
     $        *ln2*z2**2 + 30*ln2**2*z3 - 375*z5)/480. - (ln2**2*H1(-1
     $        ,xlcl)**3)/12. + (ln2*H1(-1,xlcl)**4)/24. - H1(-1,xlcl)**5
     $        /120. + H1(-1,xlcl)**2*(z3/2. - H3(-1,-1,1,xlcl)/2.) -
     $        (ln2**2*H3(-1,-1,1,xlcl))/2. - ln2*H4(-1,-1,-1,0,xlcl) - 3
     $        *ln2*H4(-1,-1,-1,1,xlcl) - ln2*H4(-1,-1,1,0,xlcl) + H1(-1
     $        ,xlcl)*((24*li4half + ln2**4 - 6*ln2**2*z2 - 3*z2**2 - 3
     $        *ln2*z3)/24. + ln2*H3(-1,-1,1,xlcl) + H4(-1,-1,-1,0,xlcl)
     $        + 3*H4(-1,-1,-1,1,xlcl) + H4(-1,-1,1,0,xlcl)) - 3*H5(-1,-1
     $        ,-1,-1,0,xlcl) - 6*H5(-1,-1,-1,-1,1,xlcl) - H5(-1,-1,-1,0
     $        ,0,xlcl) - 3*H5(-1,-1,-1,1,0,xlcl) - H5(-1,-1,1,0,0,xlcl)

         Hr5(-1,-1,1,-1,-1) = Hr2(-1,-1)*Hr3(-1,-1,1) - 3*Hr1(-1)*Hr4(-1
     $        ,-1,-1,1) + 6*Hr5(-1,-1,-1,-1,1)

         Hr5(-1,-1,1,-1,0) = (-480*li5half - 288*li4half*ln2 - 8*ln2**5
     $        + 40*ln2**3*z2 - 84*ln2*z2**2 - 48*ln2**2*z3 - 132*z2*z3 +
     $        741*z5)/96. - (z2*H1(-1,xlcl)**3)/12. + H1(-1,xlcl)**5
     $        /120. + H1(-1,xlcl)**2*((-8*ln2*z2 + 13*z3)/16. - H3(-1,-1
     $        ,0,xlcl)/2.) + (z2*H3(-1,-1,0,xlcl))/2. + H1(-1,xlcl)*((-5
     $        *ln2**2*z2 - 2*z2**2 + 20*ln2*z3)/20. + 3*H4(-1,-1,-1,0
     $        ,xlcl)) - 6*H5(-1,-1,-1,-1,0,xlcl) + H5(-1,-1,-1,-1,1
     $        ,xlcl) - H5(-1,-1,0,-1,1,xlcl)

         Hr5(-1,-1,1,-1,1) = (2880*li5half - 16*ln2**5 + 240*ln2**3*z2 +
     $        1152*ln2*z2**2 - 1320*ln2**2*z3 + 1440*z2*z3 - 5625*z5)
     $        /960. + ((-ln2**2 + z2)*H1(-1,xlcl)**3)/12. + (ln2*H1(-1
     $        ,xlcl)**4)/24. - H1(-1,xlcl)**5/120. + H1(-1,xlcl)**2*((2
     $        *ln2**3 + 6*ln2*z2 - 21*z3)/24. + H3(-1,-1,0,xlcl)/2.) +
     $        ((ln2**2 - z2)*H3(-1,-1,0,xlcl))/2. + H1(-1,xlcl)*((-5*ln2
     $        **4 + 30*ln2**2*z2 - 3*z2**2 - 30*ln2*z3)/120. - ln2*H3(-1
     $        ,-1,0,xlcl) - 3*H4(-1,-1,-1,0,xlcl)) + 3*ln2*H4(-1,-1,-1,0
     $        ,xlcl) + 7*H5(-1,-1,-1,-1,0,xlcl) - H5(-1,-1,0,-1,0,xlcl)

         Hr5(-1,-1,1,0,-1) = Hr1(-1)*Hr4(-1,-1,1,0) - 3*Hr5(-1,-1,-1,1
     $        ,0) - Hr5(-1,-1,1,-1,0)

         Hr5(-1,-1,1,0,0) = (-960*li5half - 480*li4half*ln2 - 12*ln2**5
     $        + 40*ln2**3*z2 - 180*ln2*z2**2 - 90*ln2**2*z3 - 195*z2*z3
     $        + 1410*z5)/240. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**2*(z3
     $        /2. - H3(-1,-1,0,xlcl)/2.) + H1(-1,xlcl)*((-19*z2**2 + 30
     $        *ln2*z3)/40. + 3*H4(-1,-1,-1,0,xlcl) + H4(-1,-1,-1,1,xlcl)
     $        - H4(-1,-1,0,1,xlcl)) - 6*H5(-1,-1,-1,-1,0,xlcl) - 3*H5(-1
     $        ,-1,-1,-1,1,xlcl) + 3*H5(-1,-1,-1,0,1,xlcl) + H5(-1,-1,-1
     $        ,1,1,xlcl) - H5(-1,-1,0,1,1,xlcl)

         Hr5(-1,-1,1,0,1) = (-3840*li5half - 3840*li4half*ln2 - 128*ln2
     $        **5 + 480*ln2**3*z2 - 72*ln2*z2**2 - 1380*ln2**2*z3 + 1380
     $        *z2*z3 + 1275*z5)/960. + (z2*H1(-1,xlcl)**3)/6. + (ln2*H1(
     $        -1,xlcl)**4)/24. - H1(-1,xlcl)**5/120. + H1(-1,xlcl)**2*((
     $        -(ln2*z2) - 2*z3)/2. + H3(-1,-1,0,xlcl)/2.) - z2*H3(-1,-1
     $        ,0,xlcl) + 3*ln2*H4(-1,-1,-1,0,xlcl) + ln2*H4(-1,-1,-1,1
     $        ,xlcl) - ln2*H4(-1,-1,0,1,xlcl) + H1(-1,xlcl)*((120
     $        *li4half + 5*ln2**4 + 30*ln2**2*z2 - 57*z2**2 + 30*ln2*z3)
     $        /120. - ln2*H3(-1,-1,0,xlcl) - 3*H4(-1,-1,-1,0,xlcl) - H4(
     $        -1,-1,-1,1,xlcl) + H4(-1,-1,0,1,xlcl)) + 7*H5(-1,-1,-1,-1
     $        ,0,xlcl) + 4*H5(-1,-1,-1,-1,1,xlcl) - 3*H5(-1,-1,-1,0,1
     $        ,xlcl) + H5(-1,-1,-1,1,0,xlcl) - H5(-1,-1,0,-1,0,xlcl) -
     $        H5(-1,-1,0,-1,1,xlcl) - H5(-1,-1,0,1,0,xlcl)

         Hr5(-1,-1,1,1,-1) = Hr1(-1)*Hr4(-1,-1,1,1) - 3*Hr5(-1,-1,-1,1
     $        ,1) - Hr5(-1,-1,1,-1,1)

         Hr5(-1,-1,1,1,0) = (1280*li5half + 640*li4half*ln2 + 16*ln2**5
     $        - 80*ln2**3*z2 + 280*ln2*z2**2 + 20*ln2**2*z3 + 20*z2*z3 -
     $        1385*z5)/320. - (z2*H1(-1,xlcl)**3)/6. - H1(-1,xlcl)**5
     $        /120. + H1(-1,xlcl)**2*((ln2*z2 + z3)/2. + H3(-1,-1,0
     $        ,xlcl)/2.) + z2*H3(-1,-1,0,xlcl) + H1(-1,xlcl)*((120
     $        *li4half + 5*ln2**4 + 6*z2**2 - 15*ln2*z3)/120. - 2*H4(-1,
     $        -1,-1,0,xlcl) - H4(-1,-1,0,0,xlcl)) + 2*H5(-1,-1,-1,-1,0
     $        ,xlcl) - H5(-1,-1,-1,-1,1,xlcl) + 3*H5(-1,-1,-1,0,0,xlcl)
     $        + H5(-1,-1,-1,0,1,xlcl) + H5(-1,-1,0,-1,0,xlcl) + H5(-1,-1
     $        ,0,-1,1,xlcl) - H5(-1,-1,0,0,1,xlcl)

         Hr5(-1,-1,1,1,1) = (480*li5half + 480*li4half*ln2 + 12*ln2**5 -
     $        80*ln2**3*z2 - 24*ln2*z2**2 + 240*ln2**2*z3 - 240*z2*z3 +
     $        15*z5)/480. + (ln2**2*H1(-1,xlcl)**3)/12. - (ln2*H1(-1
     $        ,xlcl)**4)/24. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**2*(
     $        -0.08333333333333333*ln2**3 - H3(-1,-1,0,xlcl)/2.) - (ln2
     $        **2*H3(-1,-1,0,xlcl))/2. - 2*ln2*H4(-1,-1,-1,0,xlcl) - ln2
     $        *H4(-1,-1,0,0,xlcl) + H1(-1,xlcl)*(-li4half + ln2*H3(-1,-1
     $        ,0,xlcl) + 2*H4(-1,-1,-1,0,xlcl) + H4(-1,-1,0,0,xlcl)) - 3
     $        *H5(-1,-1,-1,-1,0,xlcl) - 2*H5(-1,-1,-1,0,0,xlcl) - H5(-1,
     $        -1,0,0,0,xlcl)

         Hr5(-1,0,-1,-1,-1) = Hr2(-1,0)*Hr3(-1,-1,-1) - 2*Hr2(-1,-1)
     $        *Hr3(-1,-1,0) + 3*Hr1(-1)*Hr4(-1,-1,-1,0) - 4*Hr5(-1,-1,-1
     $        ,-1,0)

         Hr5(-1,0,-1,-1,0) = Hr2(-1,0)*Hr3(-1,-1,0) - 6*Hr5(-1,-1,-1,0
     $        ,0) - 3*Hr5(-1,-1,0,-1,0)

         Hr5(-1,0,-1,-1,1) = Hr2(-1,0)*Hr3(-1,-1,1) - 3*Hr5(-1,-1,-1,0
     $        ,1) - 3*Hr5(-1,-1,-1,1,0) - 2*Hr5(-1,-1,0,-1,1) - Hr5(-1,
     $        -1,1,-1,0)

         Hr5(-1,0,-1,0,-1) = -(Hr2(-1,0)*Hr3(-1,-1,0)) + (Hr2(-1,0)*Hr3(
     $        -1,0,-1))/2. - 2*Hr1(-1)*Hr4(-1,-1,0,0) + 12*Hr5(-1,-1,-1
     $        ,0,0) + 4*Hr5(-1,-1,0,-1,0)

         Hr5(-1,0,-1,0,0) = (168*ln2*z2**2 - 160*z2*z3 + 205*z5)/160. -
     $        H1(-1,xlcl)**5/120. - (H1(-1,xlcl)**3*H2(-1,1,xlcl))/6. +
     $        H1(-1,xlcl)**2*((3*z3)/8. + H3(-1,-1,1,xlcl)) + H2(-1,1
     $        ,xlcl)*((3*z3)/4. + H3(-1,-1,1,xlcl)) + H1(-1,xlcl)*((-21
     $        *z2**2)/20. - H2(-1,1,xlcl)**2/2. - 4*H4(-1,-1,-1,1,xlcl)
     $        + 2*H4(-1,-1,1,1,xlcl)) + 7*H5(-1,-1,-1,-1,1,xlcl) - 7*H5(
     $        -1,-1,-1,1,1,xlcl) - H5(-1,-1,1,-1,1,xlcl) - H5(-1,1,-1,1
     $        ,1,xlcl)

         Hr5(-1,0,-1,0,1) = (-1920*li5half - 1920*li4half*ln2 - 64*ln2
     $        **5 + 320*ln2**3*z2 + 36*ln2*z2**2 - 840*ln2**2*z3 + 720
     $        *z2*z3 + 495*z5)/480. - (ln2*H1(-1,xlcl)**4)/24. + H1(-1
     $        ,xlcl)**5/120. + H1(-1,xlcl)**3*(-0.16666666666666666*z2 +
     $        H2(-1,1,xlcl)/6.) - (ln2*H2(-1,1,xlcl)**2)/2. + H2(-1,1
     $        ,xlcl)*((8*ln2*z2 - 5*z3)/8. - H3(-1,-1,0,xlcl) - 2*H3(-1,
     $        -1,1,xlcl)) + H1(-1,xlcl)**2*((8*ln2*z2 - 5*z3)/16. - (ln2
     $        *H2(-1,1,xlcl))/2. - H3(-1,-1,1,xlcl)) + 2*z2*H3(-1,-1,1
     $        ,xlcl) - 4*ln2*H4(-1,-1,-1,1,xlcl) + H1(-1,xlcl)*((-3*z2
     $        **2)/40. - z2*H2(-1,1,xlcl) + H2(-1,1,xlcl)**2/2. + 2*ln2
     $        *H3(-1,-1,1,xlcl) + 4*H4(-1,-1,-1,1,xlcl) - 2*H4(-1,-1,1,1
     $        ,xlcl)) + 2*ln2*H4(-1,-1,1,1,xlcl) - H5(-1,-1,-1,-1,0
     $        ,xlcl) - 8*H5(-1,-1,-1,-1,1,xlcl) + 3*H5(-1,-1,-1,0,1
     $        ,xlcl) + 2*H5(-1,-1,-1,1,0,xlcl) + 12*H5(-1,-1,-1,1,1
     $        ,xlcl) + H5(-1,-1,0,-1,1,xlcl) + 2*H5(-1,-1,1,-1,0,xlcl) +
     $        4*H5(-1,-1,1,-1,1,xlcl) - H5(-1,1,-1,1,0,xlcl)

         Hr5(-1,0,-1,1,-1) = -2*Hr2(-1,0)*Hr3(-1,-1,1) + Hr1(-1)*Hr4(-1
     $        ,0,-1,1) + 6*Hr5(-1,-1,-1,0,1) + 6*Hr5(-1,-1,-1,1,0) + 2
     $        *Hr5(-1,-1,0,-1,1) + 2*Hr5(-1,-1,1,-1,0)

         Hr5(-1,0,-1,1,0) = (7680*li5half + 1920*li4half*ln2 + 16*ln2**5
     $        + 160*ln2**3*z2 + 1428*ln2*z2**2 + 240*z2*z3 - 7605*z5)
     $        /480. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**3*(z2/6. + H2(
     $        -1,1,xlcl)/6.) + H1(-1,xlcl)**2*((ln2*z2 - 2*z3)/4. - H3(
     $        -1,-1,1,xlcl)) - 2*z2*H3(-1,-1,1,xlcl) + H2(-1,1,xlcl)
     $        *((ln2*z2 - 2*z3)/2. + 2*H3(-1,-1,0,xlcl) + H3(-1,-1,1
     $        ,xlcl) - H3(-1,0,1,xlcl)) + H1(-1,xlcl)*((480*li4half + 20
     $        *ln2**4 - 120*ln2**2*z2 - 39*z2**2)/120. + (z2 - H2(-1,0
     $        ,xlcl))*H2(-1,1,xlcl) - H4(-1,-1,-1,0,xlcl) + 3*H4(-1,-1,
     $        -1,1,xlcl) + 2*H4(-1,-1,0,1,xlcl) + 2*H4(-1,-1,1,0,xlcl) +
     $        H4(-1,0,-1,1,xlcl)) + 4*H5(-1,-1,-1,-1,0,xlcl) - 3*H5(-1,
     $        -1,-1,-1,1,xlcl) - 7*H5(-1,-1,-1,0,1,xlcl) - 6*H5(-1,-1,-1
     $        ,1,0,xlcl) - 6*H5(-1,-1,-1,1,1,xlcl) - 2*H5(-1,-1,0,-1,1
     $        ,xlcl) + 4*H5(-1,-1,0,1,1,xlcl) - 2*H5(-1,-1,1,-1,0,xlcl)
     $        - 3*H5(-1,-1,1,-1,1,xlcl) + 2*H5(-1,-1,1,0,1,xlcl) + 2*H5(
     $        -1,0,-1,1,1,xlcl) + H5(-1,0,1,-1,1,xlcl)

         Hr5(-1,0,-1,1,1) = (-1440*li5half + 480*li4half*ln2 + 32*ln2**5
     $        - 60*ln2**3*z2 - 462*ln2*z2**2 + 315*ln2**2*z3 - 315*z2*z3
     $        + 1830*z5)/240. + (ln2*H1(-1,xlcl)**4)/24. - H1(-1,xlcl)
     $        **5/120. + H1(-1,xlcl)**3*(-0.08333333333333333*ln2**2 -
     $        H2(-1,1,xlcl)/6.) + ln2**2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)
     $        **2*((4*ln2**3 - 12*ln2*z2 + 21*z3)/48. + (ln2*H2(-1,1
     $        ,xlcl))/2. + H3(-1,-1,1,xlcl)) + H2(-1,1,xlcl)*((4*ln2**3
     $        - 12*ln2*z2 + 21*z3)/24. - ln2*H2(-1,0,xlcl) - H3(-1,-1,0
     $        ,xlcl) - H3(-1,0,0,xlcl)) - ln2*H4(-1,-1,-1,0,xlcl) + 3
     $        *ln2*H4(-1,-1,-1,1,xlcl) + 2*ln2*H4(-1,-1,0,1,xlcl) + 2
     $        *ln2*H4(-1,-1,1,0,xlcl) + H1(-1,xlcl)*((-120*li4half - 5
     $        *ln2**4 + 22*z2**2)/40. + (-0.5*ln2**2 + H2(-1,0,xlcl))
     $        *H2(-1,1,xlcl) - 2*ln2*H3(-1,-1,1,xlcl) + H4(-1,-1,-1,0
     $        ,xlcl) - 3*H4(-1,-1,-1,1,xlcl) - 2*H4(-1,-1,0,1,xlcl) - 2
     $        *H4(-1,-1,1,0,xlcl) - H4(-1,0,-1,1,xlcl)) + ln2*H4(-1,0,-1
     $        ,1,xlcl) - 3*H5(-1,-1,-1,-1,0,xlcl) + 4*H5(-1,-1,-1,-1,1
     $        ,xlcl) - H5(-1,-1,-1,0,0,xlcl) + 3*H5(-1,-1,-1,0,1,xlcl) +
     $        3*H5(-1,-1,-1,1,0,xlcl) + H5(-1,-1,0,-1,1,xlcl) + 2*H5(-1,
     $        -1,0,0,1,xlcl) + 2*H5(-1,-1,0,1,0,xlcl) + 2*H5(-1,-1,1,0,0
     $        ,xlcl) + H5(-1,0,-1,0,1,xlcl) + H5(-1,0,-1,1,0,xlcl) + H5(
     $        -1,0,0,-1,1,xlcl)

         Hr5(-1,0,0,-1,-1) = -0.5*(Hr2(-1,0)*Hr3(-1,0,-1)) + Hr2(-1,-1)
     $        *Hr3(-1,0,0) - 3*Hr5(-1,-1,-1,0,0) - Hr5(-1,-1,0,-1,0)

         Hr5(-1,0,0,-1,0) = Hr2(-1,0)*Hr3(-1,0,0) - 6*Hr5(-1,-1,0,0,0) -
     $        3*Hr5(-1,0,-1,0,0)

         Hr5(-1,0,0,-1,1) = (-480*li5half + 4*ln2**5 - 40*ln2**3*z2 - 81
     $        *ln2*z2**2 + 405*z5)/120. - (ln2*H1(-1,xlcl)**4)/24. + H1(
     $        -1,xlcl)**5/120. + H1(-1,xlcl)**3*((ln2**2 - z2)/12. + H2(
     $        -1,1,xlcl)/6.) + (ln2*H2(-1,1,xlcl)**2)/2. + ((-ln2**2 +
     $        z2)*H3(-1,-1,1,xlcl))/2. + H2(-1,1,xlcl)*((-12*ln2*z2 + 13
     $        *z3)/8. - H3(-1,-1,0,xlcl) + H3(-1,-1,1,xlcl) + H3(-1,0,1
     $        ,xlcl)) + H1(-1,xlcl)**2*((-12*ln2*z2 + 13*z3)/16. - (ln2
     $        *H2(-1,1,xlcl))/2. - H3(-1,-1,1,xlcl)/2. + H3(-1,1,1,xlcl)
     $        /2.) + ((ln2**2 - z2)/2. - H2(-1,0,xlcl))*H3(-1,1,1,xlcl)
     $        + H1(-1,xlcl)*((-120*li4half - 5*ln2**4 + 30*ln2**2*z2 +
     $        12*z2**2)/60. + ((ln2**2 - z2)*H2(-1,1,xlcl))/2. - H2(-1,1
     $        ,xlcl)**2/2. + ln2*H3(-1,-1,1,xlcl) - ln2*H3(-1,1,1,xlcl))
     $        - H5(-1,-1,-1,-1,0,xlcl) + 2*H5(-1,-1,-1,-1,1,xlcl) + 3
     $        *H5(-1,-1,-1,0,1,xlcl) + 3*H5(-1,-1,-1,1,0,xlcl) - 3*H5(-1
     $        ,-1,-1,1,1,xlcl) + H5(-1,-1,0,-1,1,xlcl) - 2*H5(-1,-1,0,1
     $        ,1,xlcl) + H5(-1,-1,1,-1,0,xlcl) - H5(-1,-1,1,-1,1,xlcl) +
     $        2*H5(-1,-1,1,1,0,xlcl) - H5(-1,0,-1,1,1,xlcl) - H5(-1,0,1,
     $        -1,1,xlcl) + H5(-1,1,-1,1,0,xlcl)

         Hr5(-1,0,0,0,-1) = -(Hr2(-1,0)*Hr3(-1,0,0)) + Hr1(-1)*Hr4(-1,0
     $        ,0,0) + 4*Hr5(-1,-1,0,0,0) + 2*Hr5(-1,0,-1,0,0)

         Hr5(-1,0,0,0,0) = (15*z5)/16. - H1(-1,xlcl)**5/120. - (H1(-1
     $        ,xlcl)**3*H2(-1,1,xlcl))/6. + H1(-1,xlcl)**2*(H3(-1,-1,1
     $        ,xlcl)/2. - H3(-1,1,1,xlcl)/2.) + H1(-1,xlcl)*(-H4(-1,-1,
     $        -1,1,xlcl) + H4(-1,-1,1,1,xlcl) - H4(-1,1,1,1,xlcl)) + H5(
     $        -1,-1,-1,-1,1,xlcl) - H5(-1,-1,-1,1,1,xlcl) + H5(-1,-1,1,1
     $        ,1,xlcl) - H5(-1,1,1,1,1,xlcl)

         Hr5(-1,0,0,0,1) = (64*ln2*z2**2 + 120*z2*z3 - 295*z5)/160. -
     $        (ln2*H1(-1,xlcl)**4)/24. + H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)**3*(-0.16666666666666666*z2 + H2(-1,1,xlcl)/6.) +
     $        z2*H3(-1,-1,1,xlcl) + H2(-1,1,xlcl)*(z3 - H3(-1,-1,0,xlcl)
     $        - H3(-1,-1,1,xlcl) + H3(-1,0,1,xlcl) - H3(-1,1,1,xlcl)) +
     $        H1(-1,xlcl)**2*(z3/2. - (ln2*H2(-1,1,xlcl))/2. - H3(-1,-1
     $        ,1,xlcl)/2. + H3(-1,1,1,xlcl)/2.) + (-z2 - H2(-1,0,xlcl))
     $        *H3(-1,1,1,xlcl) - ln2*H4(-1,-1,-1,1,xlcl) + ln2*H4(-1,-1
     $        ,1,1,xlcl) - ln2*H4(-1,1,1,1,xlcl) + H1(-1,xlcl)*((-2*z2
     $        **2)/5. - z2*H2(-1,1,xlcl) + ln2*H3(-1,-1,1,xlcl) - ln2
     $        *H3(-1,1,1,xlcl) + H4(-1,-1,-1,1,xlcl) - H4(-1,-1,1,1
     $        ,xlcl) + H4(-1,1,1,1,xlcl)) - H5(-1,-1,-1,-1,0,xlcl) - 2
     $        *H5(-1,-1,-1,-1,1,xlcl) + 3*H5(-1,-1,-1,0,1,xlcl) + 2*H5(
     $        -1,-1,-1,1,0,xlcl) + 6*H5(-1,-1,-1,1,1,xlcl) + H5(-1,-1,0,
     $        -1,1,xlcl) - 2*H5(-1,-1,0,1,1,xlcl) + H5(-1,-1,1,-1,0
     $        ,xlcl) + 2*H5(-1,-1,1,-1,1,xlcl) + H5(-1,-1,1,1,0,xlcl) +
     $        4*H5(-1,-1,1,1,1,xlcl) - H5(-1,0,-1,1,1,xlcl) - H5(-1,0,1,
     $        -1,1,xlcl) + 2*H5(-1,1,-1,1,1,xlcl) - H5(-1,1,1,1,0,xlcl)

         Hr5(-1,0,0,1,-1) = Hr1(-1)*Hr4(-1,0,0,1) - 2*Hr5(-1,-1,0,0,1) -
     $        Hr5(-1,0,-1,0,1) - Hr5(-1,0,0,-1,1)

         Hr5(-1,0,0,1,0) = (-192*ln2*z2**2 + 60*z2*z3 + 55*z5)/160. +
     $        H1(-1,xlcl)**5/120. + H1(-1,xlcl)**3*(z2/6. + H2(-1,1
     $        ,xlcl)/6.) - z2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)**2*(-z3 -
     $        H3(-1,-1,1,xlcl)/2. + H3(-1,1,1,xlcl)/2.) + z2*H3(-1,1,1
     $        ,xlcl) + H2(-1,0,xlcl)*H3(-1,1,1,xlcl) + H2(-1,1,xlcl)*(-2
     $        *z3 + 2*H3(-1,-1,0,xlcl) + 2*H3(-1,-1,1,xlcl) - 2*H3(-1,0
     $        ,1,xlcl) + H3(-1,1,1,xlcl)) + H1(-1,xlcl)*((6*z2**2)/5. +
     $        (z2 - H2(-1,0,xlcl))*H2(-1,1,xlcl) - H2(-1,1,xlcl)**2/2. -
     $        H4(-1,-1,-1,0,xlcl) + 2*H4(-1,-1,0,1,xlcl) + H4(-1,-1,1,0
     $        ,xlcl) + H4(-1,0,-1,1,xlcl) - H4(-1,1,1,0,xlcl)) + 4*H5(-1
     $        ,-1,-1,-1,0,xlcl) + 3*H5(-1,-1,-1,-1,1,xlcl) - 7*H5(-1,-1,
     $        -1,0,1,xlcl) - 3*H5(-1,-1,-1,1,0,xlcl) - 9*H5(-1,-1,-1,1,1
     $        ,xlcl) - 2*H5(-1,-1,0,-1,1,xlcl) + 6*H5(-1,-1,0,1,1,xlcl)
     $        - H5(-1,-1,1,-1,0,xlcl) - 3*H5(-1,-1,1,-1,1,xlcl) + H5(-1,
     $        -1,1,0,1,xlcl) - 6*H5(-1,-1,1,1,1,xlcl) + 3*H5(-1,0,-1,1,1
     $        ,xlcl) + 2*H5(-1,0,1,-1,1,xlcl) - 3*H5(-1,1,-1,1,1,xlcl) -
     $        H5(-1,1,1,0,1,xlcl)

         Hr5(-1,0,0,1,1) = (960*li5half + 960*li4half*ln2 + 32*ln2**5 -
     $        160*ln2**3*z2 + 48*ln2*z2**2 + 420*ln2**2*z3 - 420*z2*z3 -
     $        225*z5)/480. + (ln2*H1(-1,xlcl)**4)/24. - H1(-1,xlcl)**5
     $        /120. + H1(-1,xlcl)**3*(-0.08333333333333333*ln2**2 - H2(
     $        -1,1,xlcl)/6.) - (ln2*H2(-1,1,xlcl)**2)/2. + (ln2**2*H3(-1
     $        ,-1,1,xlcl))/2. + H2(-1,1,xlcl)*(z3 - ln2*H2(-1,0,xlcl) -
     $        H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) - H3(-1,0,0,xlcl)) +
     $        H1(-1,xlcl)**2*(z3/2. + (ln2*H2(-1,1,xlcl))/2. + H3(-1,-1
     $        ,1,xlcl)/2. - H3(-1,1,1,xlcl)/2.) - (ln2**2*H3(-1,1,1
     $        ,xlcl))/2. - ln2*H4(-1,-1,-1,0,xlcl) + 2*ln2*H4(-1,-1,0,1
     $        ,xlcl) + ln2*H4(-1,-1,1,0,xlcl) + ln2*H4(-1,0,-1,1,xlcl) -
     $        ln2*H4(-1,1,1,0,xlcl) + H1(-1,xlcl)*(-0.1*z2**2 + (-0.5
     $        *ln2**2 + H2(-1,0,xlcl))*H2(-1,1,xlcl) + H2(-1,1,xlcl)**2
     $        /2. - ln2*H3(-1,-1,1,xlcl) + ln2*H3(-1,1,1,xlcl) + H4(-1,
     $        -1,-1,0,xlcl) - 2*H4(-1,-1,0,1,xlcl) - H4(-1,-1,1,0,xlcl)
     $        - H4(-1,0,-1,1,xlcl) + H4(-1,1,1,0,xlcl)) - 3*H5(-1,-1,-1,
     $        -1,0,xlcl) - 2*H5(-1,-1,-1,-1,1,xlcl) - H5(-1,-1,-1,0,0
     $        ,xlcl) + 3*H5(-1,-1,-1,0,1,xlcl) + 3*H5(-1,-1,-1,1,1,xlcl)
     $        + H5(-1,-1,0,-1,1,xlcl) + 2*H5(-1,-1,0,0,1,xlcl) + 2*H5(-1
     $        ,-1,0,1,0,xlcl) + H5(-1,-1,1,-1,1,xlcl) + H5(-1,-1,1,0,0
     $        ,xlcl) - 2*H5(-1,-1,1,1,0,xlcl) + H5(-1,0,-1,0,1,xlcl) +
     $        H5(-1,0,-1,1,0,xlcl) + H5(-1,0,0,-1,1,xlcl) - H5(-1,1,-1,1
     $        ,0,xlcl) - H5(-1,1,1,0,0,xlcl)

         Hr5(-1,0,1,-1,-1) = Hr2(-1,0)*Hr3(-1,-1,1) + Hr2(-1,-1)*Hr3(-1
     $        ,0,1) - 2*Hr1(-1)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,0,-1,1)
     $        - 3*Hr5(-1,-1,-1,1,0) - Hr5(-1,-1,1,-1,0)

         Hr5(-1,0,1,-1,0) = Hr2(-1,0)*Hr3(-1,0,1) - 4*Hr5(-1,-1,0,0,1) -
     $        2*Hr5(-1,-1,0,1,0) - 2*Hr5(-1,0,-1,0,1) - Hr5(-1,0,-1,1,0)

         Hr5(-1,0,1,-1,1) = (10560*li5half - 88*ln2**5 - 560*ln2**3*z2 +
     $        3384*ln2*z2**2 - 1260*ln2**2*z3 + 1260*z2*z3 - 12675*z5)
     $        /960. + (ln2*H1(-1,xlcl)**4)/24. - H1(-1,xlcl)**5/120. +
     $        H1(-1,xlcl)**3*((-ln2**2 + z2)/12. - H2(-1,1,xlcl)/6.) +
     $        ((ln2**2 - z2)*H3(-1,-1,0,xlcl))/2. + (ln2**2 - z2)*H3(-1,
     $        -1,1,xlcl) + H2(-1,1,xlcl)*((2*ln2**3 + 6*ln2*z2 - 21*z3)
     $        /12. + ln2*H2(-1,0,xlcl) + 2*H3(-1,-1,0,xlcl) + 2*H3(-1,0
     $        ,0,xlcl)) + H1(-1,xlcl)**2*((2*ln2**3 + 6*ln2*z2 - 21*z3)
     $        /24. + (ln2*H2(-1,1,xlcl))/2. + H3(-1,-1,0,xlcl)/2. + H3(
     $        -1,-1,1,xlcl) + H3(-1,1,0,xlcl)/2.) + ((ln2**2 - z2)*H3(-1
     $        ,1,0,xlcl))/2. - H2(-1,0,xlcl)*H3(-1,1,0,xlcl) + 3*ln2*H4(
     $        -1,-1,-1,0,xlcl) + 3*ln2*H4(-1,-1,-1,1,xlcl) - 2*ln2*H4(-1
     $        ,-1,0,1,xlcl) - ln2*H4(-1,0,-1,1,xlcl) + H1(-1,xlcl)*((24
     $        *li4half + ln2**4 + 6*ln2**2*z2 - 7*z2**2)/8. + ((-ln2**2
     $        + z2)/2. - H2(-1,0,xlcl))*H2(-1,1,xlcl) - ln2*H3(-1,-1,0
     $        ,xlcl) - 2*ln2*H3(-1,-1,1,xlcl) - ln2*H3(-1,1,0,xlcl) - 3
     $        *H4(-1,-1,-1,0,xlcl) - 3*H4(-1,-1,-1,1,xlcl) + 2*H4(-1,-1
     $        ,0,1,xlcl) + H4(-1,0,-1,1,xlcl)) + 7*H5(-1,-1,-1,-1,0
     $        ,xlcl) + 4*H5(-1,-1,-1,-1,1,xlcl) - 6*H5(-1,-1,-1,0,1
     $        ,xlcl) - 3*H5(-1,-1,-1,1,0,xlcl) - H5(-1,-1,0,-1,0,xlcl) -
     $        2*H5(-1,-1,0,-1,1,xlcl) - 4*H5(-1,-1,0,0,1,xlcl) - 2*H5(-1
     $        ,-1,0,1,0,xlcl) - 2*H5(-1,-1,1,-1,0,xlcl) - 2*H5(-1,0,-1,0
     $        ,1,xlcl) - H5(-1,0,-1,1,0,xlcl) - 2*H5(-1,0,0,-1,1,xlcl)

         Hr5(-1,0,1,0,-1) = -(Hr2(-1,0)*Hr3(-1,0,1)) + Hr1(-1)*Hr4(-1,0
     $        ,1,0) + 4*Hr5(-1,-1,0,0,1) + 2*Hr5(-1,0,-1,0,1)

         Hr5(-1,0,1,0,0) = (3*(64*ln2*z2**2 - 40*z2*z3 + 35*z5))/160. +
     $        H1(-1,xlcl)**5/120. + (H1(-1,xlcl)**3*H2(-1,1,xlcl))/6. +
     $        H2(-1,1,xlcl)*(z3 - H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) +
     $        H3(-1,0,1,xlcl)) + H1(-1,xlcl)**2*(z3/2. - H3(-1,-1,0
     $        ,xlcl)/2. - H3(-1,-1,1,xlcl) - H3(-1,1,0,xlcl)/2.) + H1(-1
     $        ,xlcl)*((-6*z2**2)/5. + H2(-1,0,xlcl)*H2(-1,1,xlcl) + H2(
     $        -1,1,xlcl)**2/2. + 3*H4(-1,-1,-1,0,xlcl) + 4*H4(-1,-1,-1,1
     $        ,xlcl) - 3*H4(-1,-1,0,1,xlcl) - 2*H4(-1,-1,1,1,xlcl) - H4(
     $        -1,0,-1,1,xlcl) - H4(-1,1,0,1,xlcl)) - 6*H5(-1,-1,-1,-1,0
     $        ,xlcl) - 7*H5(-1,-1,-1,-1,1,xlcl) + 6*H5(-1,-1,-1,0,1
     $        ,xlcl) + 7*H5(-1,-1,-1,1,1,xlcl) + H5(-1,-1,0,-1,1,xlcl) -
     $        5*H5(-1,-1,0,1,1,xlcl) + H5(-1,-1,1,-1,1,xlcl) - 2*H5(-1,0
     $        ,-1,1,1,xlcl) - H5(-1,0,1,-1,1,xlcl) + H5(-1,1,-1,1,1
     $        ,xlcl) - H5(-1,1,0,1,1,xlcl)

         Hr5(-1,0,1,0,1) = (-3840*li5half - 3840*li4half*ln2 - 128*ln2
     $        **5 + 640*ln2**3*z2 + 288*ln2*z2**2 - 1680*ln2**2*z3 +
     $        1080*z2*z3 + 1335*z5)/960. + (ln2*H1(-1,xlcl)**4)/24. -
     $        H1(-1,xlcl)**5/120. + H1(-1,xlcl)**3*(z2/6. - H2(-1,1
     $        ,xlcl)/6.) + (ln2*H2(-1,1,xlcl)**2)/2. - z2*H3(-1,-1,0
     $        ,xlcl) - 2*z2*H3(-1,-1,1,xlcl) + H2(-1,1,xlcl)*(-(ln2*z2)
     $        - 2*z3 + ln2*H2(-1,0,xlcl) + 2*H3(-1,-1,0,xlcl) + 2*H3(-1,
     $        -1,1,xlcl) + 2*H3(-1,0,0,xlcl) - H3(-1,1,0,xlcl)) + H1(-1
     $        ,xlcl)**2*((-(ln2*z2) - 2*z3)/2. + (ln2*H2(-1,1,xlcl))/2.
     $        + H3(-1,-1,0,xlcl)/2. + H3(-1,-1,1,xlcl) + H3(-1,1,0,xlcl)
     $        /2.) - z2*H3(-1,1,0,xlcl) - H2(-1,0,xlcl)*H3(-1,1,0,xlcl)
     $        + 3*ln2*H4(-1,-1,-1,0,xlcl) + 4*ln2*H4(-1,-1,-1,1,xlcl) -
     $        3*ln2*H4(-1,-1,0,1,xlcl) - 2*ln2*H4(-1,-1,1,1,xlcl) - ln2
     $        *H4(-1,0,-1,1,xlcl) - ln2*H4(-1,1,0,1,xlcl) + H1(-1,xlcl)
     $        *((-3*z2**2)/10. + (z2 - H2(-1,0,xlcl))*H2(-1,1,xlcl) -
     $        H2(-1,1,xlcl)**2/2. - ln2*H3(-1,-1,0,xlcl) - 2*ln2*H3(-1,
     $        -1,1,xlcl) - ln2*H3(-1,1,0,xlcl) - 3*H4(-1,-1,-1,0,xlcl) -
     $        4*H4(-1,-1,-1,1,xlcl) + 3*H4(-1,-1,0,1,xlcl) + 2*H4(-1,-1
     $        ,1,1,xlcl) + H4(-1,0,-1,1,xlcl) + H4(-1,1,0,1,xlcl)) + 7
     $        *H5(-1,-1,-1,-1,0,xlcl) + 8*H5(-1,-1,-1,-1,1,xlcl) - 9*H5(
     $        -1,-1,-1,0,1,xlcl) - 2*H5(-1,-1,-1,1,0,xlcl) - 12*H5(-1,-1
     $        ,-1,1,1,xlcl) - H5(-1,-1,0,-1,0,xlcl) - 3*H5(-1,-1,0,-1,1
     $        ,xlcl) - 4*H5(-1,-1,0,0,1,xlcl) - 3*H5(-1,-1,0,1,0,xlcl) -
     $        2*H5(-1,-1,1,-1,0,xlcl) - 4*H5(-1,-1,1,-1,1,xlcl) + 4*H5(
     $        -1,-1,1,1,0,xlcl) - 2*H5(-1,0,-1,0,1,xlcl) - H5(-1,0,-1,1
     $        ,0,xlcl) - 2*H5(-1,0,0,-1,1,xlcl) + 3*H5(-1,1,-1,1,0,xlcl)
     $        - H5(-1,1,0,1,0,xlcl)

         Hr5(-1,0,1,1,-1) = Hr1(-1)*Hr4(-1,0,1,1) - 2*Hr5(-1,-1,0,1,1) -
     $        Hr5(-1,0,-1,1,1) - Hr5(-1,0,1,-1,1)

         Hr5(-1,0,1,1,0) = (-32*ln2*z2**2 - 4*z2*z3 + 53*z5)/64. - H1(-1
     $        ,xlcl)**5/120. + H1(-1,xlcl)**3*(-0.16666666666666666*z2 -
     $        H2(-1,1,xlcl)/6.) + z2*H3(-1,-1,0,xlcl) + 2*z2*H3(-1,-1,1
     $        ,xlcl) + H1(-1,xlcl)**2*((ln2*z2 + z3)/2. + H3(-1,-1,0
     $        ,xlcl)/2. + H3(-1,-1,1,xlcl) + H3(-1,1,0,xlcl)/2.) + (z2 +
     $        H2(-1,0,xlcl))*H3(-1,1,0,xlcl) + H2(-1,1,xlcl)*(ln2*z2 +
     $        z3 - H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) - H3(-1,0,0,xlcl)
     $        + H3(-1,1,0,xlcl)) + H1(-1,xlcl)*(z2**2/2. - z2*H2(-1,1
     $        ,xlcl) - 2*H4(-1,-1,-1,0,xlcl) - 3*H4(-1,-1,-1,1,xlcl) -
     $        H4(-1,-1,0,0,xlcl) - 2*H4(-1,-1,1,0,xlcl) - H4(-1,1,0,0
     $        ,xlcl)) + 2*H5(-1,-1,-1,-1,0,xlcl) + 3*H5(-1,-1,-1,-1,1
     $        ,xlcl) + 3*H5(-1,-1,-1,0,0,xlcl) + 4*H5(-1,-1,-1,0,1,xlcl)
     $        + 6*H5(-1,-1,-1,1,0,xlcl) + 6*H5(-1,-1,-1,1,1,xlcl) + H5(
     $        -1,-1,0,-1,0,xlcl) + 2*H5(-1,-1,0,-1,1,xlcl) + H5(-1,-1,0
     $        ,0,1,xlcl) + 2*H5(-1,-1,1,-1,0,xlcl) + 3*H5(-1,-1,1,-1,1
     $        ,xlcl) - 2*H5(-1,-1,1,0,1,xlcl) - 4*H5(-1,-1,1,1,0,xlcl) +
     $        H5(-1,0,-1,0,1,xlcl) + H5(-1,0,0,-1,1,xlcl) - 2*H5(-1,1,-1
     $        ,1,0,xlcl) - H5(-1,1,0,0,1,xlcl)

         Hr5(-1,0,1,1,1) = (480*li5half + 480*li4half*ln2 + 16*ln2**5 -
     $        80*ln2**3*z2 + 192*ln2*z2**2 + 210*ln2**2*z3 - 210*z2*z3 -
     $        405*z5)/480. - (ln2*H1(-1,xlcl)**4)/24. + H1(-1,xlcl)**5
     $        /120. + H1(-1,xlcl)**3*(ln2**2/12. + H2(-1,1,xlcl)/6.) -
     $        (ln2**3*H2(-1,1,xlcl))/6. - (ln2**2*H3(-1,-1,0,xlcl))/2. -
     $        ln2**2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)**2*(
     $        -0.08333333333333333*ln2**3 - (ln2*H2(-1,1,xlcl))/2. - H3(
     $        -1,-1,0,xlcl)/2. - H3(-1,-1,1,xlcl) - H3(-1,1,0,xlcl)/2.)
     $        - (ln2**2*H3(-1,1,0,xlcl))/2. - 2*ln2*H4(-1,-1,-1,0,xlcl)
     $        - 3*ln2*H4(-1,-1,-1,1,xlcl) - ln2*H4(-1,-1,0,0,xlcl) - 2
     $        *ln2*H4(-1,-1,1,0,xlcl) - ln2*H4(-1,1,0,0,xlcl) + H1(-1
     $        ,xlcl)*((-2*z2**2)/5. + (ln2**2*H2(-1,1,xlcl))/2. + ln2
     $        *H3(-1,-1,0,xlcl) + 2*ln2*H3(-1,-1,1,xlcl) + ln2*H3(-1,1,0
     $        ,xlcl) + 2*H4(-1,-1,-1,0,xlcl) + 3*H4(-1,-1,-1,1,xlcl) +
     $        H4(-1,-1,0,0,xlcl) + 2*H4(-1,-1,1,0,xlcl) + H4(-1,1,0,0
     $        ,xlcl)) - 3*H5(-1,-1,-1,-1,0,xlcl) - 4*H5(-1,-1,-1,-1,1
     $        ,xlcl) - 2*H5(-1,-1,-1,0,0,xlcl) - 3*H5(-1,-1,-1,1,0,xlcl)
     $        - H5(-1,-1,0,0,0,xlcl) - 2*H5(-1,-1,1,0,0,xlcl) - H5(-1,1
     $        ,0,0,0,xlcl)

         Hr5(-1,1,-1,-1,-1) = Hr2(-1,1)*Hr3(-1,-1,-1) - 2*Hr2(-1,-1)
     $        *Hr3(-1,-1,1) + 3*Hr1(-1)*Hr4(-1,-1,-1,1) - 4*Hr5(-1,-1,-1
     $        ,-1,1)

         Hr5(-1,1,-1,-1,0) = Hr2(-1,1)*Hr3(-1,-1,0) - 3*Hr5(-1,-1,-1,0
     $        ,1) - 3*Hr5(-1,-1,-1,1,0) - Hr5(-1,-1,0,-1,1) - 2*Hr5(-1,
     $        -1,1,-1,0)

         Hr5(-1,1,-1,-1,1) = Hr2(-1,1)*Hr3(-1,-1,1) - 6*Hr5(-1,-1,-1,1
     $        ,1) - 3*Hr5(-1,-1,1,-1,1)

         Hr5(-1,1,-1,0,-1) = Hr2(-1,1)*Hr3(-1,0,-1) - 2*Hr1(-1)*Hr4(-1,
     $        -1,0,1) - 2*Hr1(-1)*Hr4(-1,-1,1,0) - Hr1(-1)*Hr4(-1,0,-1
     $        ,1) + 6*Hr5(-1,-1,-1,0,1) + 6*Hr5(-1,-1,-1,1,0) + 2*Hr5(-1
     $        ,-1,0,-1,1) + 2*Hr5(-1,-1,1,-1,0)

         Hr5(-1,1,-1,0,0) = Hr2(-1,1)*Hr3(-1,0,0) - 2*Hr5(-1,-1,0,0,1) -
     $        2*Hr5(-1,-1,0,1,0) - 2*Hr5(-1,-1,1,0,0) - Hr5(-1,0,-1,0,1)
     $        - Hr5(-1,0,-1,1,0) - Hr5(-1,0,0,-1,1)

         Hr5(-1,1,-1,0,1) = Hr2(-1,1)*Hr3(-1,0,1) - 4*Hr5(-1,-1,0,1,1) -
     $        2*Hr5(-1,-1,1,0,1) - 2*Hr5(-1,0,-1,1,1) - Hr5(-1,0,1,-1,1)

         Hr5(-1,1,-1,1,-1) = -(Hr2(-1,1)*Hr3(-1,-1,1)) + (Hr2(-1,1)*Hr3(
     $        -1,1,-1))/2. - 2*Hr1(-1)*Hr4(-1,-1,1,1) + 12*Hr5(-1,-1,-1
     $        ,1,1) + 4*Hr5(-1,-1,1,-1,1)

         Hr5(-1,1,-1,1,0) = (-10*ln2**3*z2 - 12*ln2*z2**2 + 60*ln2**2*z3
     $        - 75*z2*z3 + 120*z5)/120. - H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)**3*(-0.16666666666666666*z2 + H2(-1,0,xlcl)/6.) +
     $        H1(-1,xlcl)**2*((-(ln2*z2) + 2*z3)/4. - H3(-1,-1,0,xlcl))
     $        - 2*z2*H3(-1,-1,0,xlcl) + H2(-1,0,xlcl)*((ln2*z2 - 2*z3)
     $        /2. + 2*H3(-1,-1,0,xlcl) + H3(-1,-1,1,xlcl)) + H1(-1,xlcl)
     $        *((-24*li4half - ln2**4 + 2*ln2**2*z2 + 3*z2**2 - 8*ln2
     $        *z3)/8. + z2*H2(-1,0,xlcl) - H2(-1,0,xlcl)**2/2. + 4*H4(-1
     $        ,-1,-1,0,xlcl) + 2*H4(-1,-1,0,0,xlcl)) - 8*H5(-1,-1,-1,-1
     $        ,0,xlcl) - H5(-1,-1,-1,-1,1,xlcl) - 12*H5(-1,-1,-1,0,0
     $        ,xlcl) - 2*H5(-1,-1,-1,0,1,xlcl) - 3*H5(-1,-1,-1,1,0,xlcl)
     $        - 4*H5(-1,-1,0,-1,0,xlcl) - 2*H5(-1,-1,0,-1,1,xlcl) - H5(
     $        -1,-1,1,-1,0,xlcl) - H5(-1,0,-1,0,1,xlcl)

         Hr5(-1,1,-1,1,1) = (-2880*li5half - 2880*li4half*ln2 - 104*ln2
     $        **5 + 560*ln2**3*z2 - 24*ln2*z2**2 - 1380*ln2**2*z3 + 1380
     $        *z2*z3 + 345*z5)/960. - (ln2*H1(-1,xlcl)**4)/24. + H1(-1
     $        ,xlcl)**5/120. + H1(-1,xlcl)**3*(ln2**2/12. - H2(-1,0
     $        ,xlcl)/6.) - (ln2*H2(-1,0,xlcl)**2)/2. + H2(-1,0,xlcl)*((4
     $        *ln2**3 - 12*ln2*z2 + 21*z3)/24. - H3(-1,-1,0,xlcl)) + ln2
     $        **2*H3(-1,-1,0,xlcl) + H1(-1,xlcl)**2*((-4*ln2**3 + 12*ln2
     $        *z2 - 21*z3)/48. + (ln2*H2(-1,0,xlcl))/2. + H3(-1,-1,0
     $        ,xlcl)) + 4*ln2*H4(-1,-1,-1,0,xlcl) + H1(-1,xlcl)*((72
     $        *li4half + 4*ln2**4 - 12*ln2**2*z2 + 21*ln2*z3)/24. - (ln2
     $        **2*H2(-1,0,xlcl))/2. + H2(-1,0,xlcl)**2/2. - 2*ln2*H3(-1,
     $        -1,0,xlcl) - 4*H4(-1,-1,-1,0,xlcl) - 2*H4(-1,-1,0,0,xlcl))
     $        + 2*ln2*H4(-1,-1,0,0,xlcl) + 7*H5(-1,-1,-1,-1,0,xlcl) + 7
     $        *H5(-1,-1,-1,0,0,xlcl) + H5(-1,-1,0,-1,0,xlcl) - H5(-1,0,
     $        -1,0,0,xlcl)

         Hr5(-1,1,0,-1,-1) = -(Hr2(-1,1)*Hr3(-1,-1,0)) - Hr2(-1,1)*Hr3(
     $        -1,0,-1) + Hr2(-1,-1)*Hr3(-1,1,0) + 2*Hr1(-1)*Hr4(-1,-1,0
     $        ,1) + Hr1(-1)*Hr4(-1,0,-1,1) - 3*Hr5(-1,-1,-1,0,1) - Hr5(
     $        -1,-1,0,-1,1)

         Hr5(-1,1,0,-1,0) = -2*Hr2(-1,1)*Hr3(-1,0,0) + Hr2(-1,0)*Hr3(-1
     $        ,1,0) + 4*Hr5(-1,-1,0,0,1) + 2*Hr5(-1,-1,0,1,0) + 2*Hr5(-1
     $        ,0,-1,0,1) + Hr5(-1,0,-1,1,0) + 2*Hr5(-1,0,0,-1,1)

         Hr5(-1,1,0,-1,1) = -(Hr2(-1,1)*Hr3(-1,0,1)) + Hr2(-1,1)*Hr3(-1
     $        ,1,0) + 4*Hr5(-1,-1,0,1,1) - 4*Hr5(-1,-1,1,1,0) + 2*Hr5(-1
     $        ,0,-1,1,1) + Hr5(-1,0,1,-1,1) - 2*Hr5(-1,1,-1,1,0)

         Hr5(-1,1,0,0,-1) = Hr2(-1,1)*Hr3(-1,0,0) - Hr2(-1,0)*Hr3(-1,1
     $        ,0) + Hr1(-1)*Hr4(-1,1,0,0) - 2*Hr5(-1,-1,0,0,1) - Hr5(-1
     $        ,0,-1,0,1) - Hr5(-1,0,0,-1,1)

         Hr5(-1,1,0,0,0) = (14*ln2*z2**2 + 15*z2*z3 - 80*z5)/40. + H1(-1
     $        ,xlcl)**5/120. - (H1(-1,xlcl)**3*H2(-1,0,xlcl))/6. + H1(-1
     $        ,xlcl)**2*(H3(-1,-1,0,xlcl) + H3(-1,-1,1,xlcl)/2. - H3(-1
     $        ,0,1,xlcl)/2.) + H1(-1,xlcl)*((2*z2**2)/5. - 3*H4(-1,-1,-1
     $        ,0,xlcl) - 2*H4(-1,-1,-1,1,xlcl) + 2*H4(-1,-1,0,1,xlcl) +
     $        H4(-1,-1,1,1,xlcl) - H4(-1,0,1,1,xlcl)) + 4*H5(-1,-1,-1,-1
     $        ,0,xlcl) + 3*H5(-1,-1,-1,-1,1,xlcl) - 3*H5(-1,-1,-1,0,1
     $        ,xlcl) - 2*H5(-1,-1,-1,1,1,xlcl) + 2*H5(-1,-1,0,1,1,xlcl)
     $        + H5(-1,-1,1,1,1,xlcl) - H5(-1,0,1,1,1,xlcl)

         Hr5(-1,1,0,0,1) = (-1920*li5half + 16*ln2**5 - 160*ln2**3*z2 -
     $        576*ln2*z2**2 + 360*ln2**2*z3 - 1320*z2*z3 + 4665*z5)/960.
     $        + (ln2*H1(-1,xlcl)**4)/24. - H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)**3*(z2/6. + H2(-1,0,xlcl)/6.) + 2*z2*H3(-1,-1,0
     $        ,xlcl) + z2*H3(-1,-1,1,xlcl) + H2(-1,0,xlcl)*(z3 - H3(-1,
     $        -1,0,xlcl) - H3(-1,-1,1,xlcl) - H3(-1,0,1,xlcl)) + H1(-1
     $        ,xlcl)**2*(-0.5*z3 - (ln2*H2(-1,0,xlcl))/2. - H3(-1,-1,0
     $        ,xlcl) - H3(-1,-1,1,xlcl)/2. + H3(-1,0,1,xlcl)/2.) - z2
     $        *H3(-1,0,1,xlcl) - 3*ln2*H4(-1,-1,-1,0,xlcl) - 2*ln2*H4(-1
     $        ,-1,-1,1,xlcl) + 2*ln2*H4(-1,-1,0,1,xlcl) + ln2*H4(-1,-1,1
     $        ,1,xlcl) - ln2*H4(-1,0,1,1,xlcl) + H1(-1,xlcl)*((z2**2 + 2
     $        *ln2*z3)/2. - z2*H2(-1,0,xlcl) + 2*ln2*H3(-1,-1,0,xlcl) +
     $        ln2*H3(-1,-1,1,xlcl) - ln2*H3(-1,0,1,xlcl) + 3*H4(-1,-1,-1
     $        ,0,xlcl) + 2*H4(-1,-1,-1,1,xlcl) - 2*H4(-1,-1,0,1,xlcl) -
     $        H4(-1,-1,1,1,xlcl) + H4(-1,0,1,1,xlcl)) - 3*H5(-1,-1,-1,-1
     $        ,0,xlcl) - 2*H5(-1,-1,-1,-1,1,xlcl) + 6*H5(-1,-1,-1,0,0
     $        ,xlcl) + 6*H5(-1,-1,-1,0,1,xlcl) + 4*H5(-1,-1,-1,1,0,xlcl)
     $        + 3*H5(-1,-1,-1,1,1,xlcl) + 3*H5(-1,-1,0,-1,0,xlcl) + 2
     $        *H5(-1,-1,0,-1,1,xlcl) + 4*H5(-1,-1,0,0,1,xlcl) + 2*H5(-1,
     $        -1,0,1,0,xlcl) - 2*H5(-1,-1,0,1,1,xlcl) + 2*H5(-1,-1,1,-1
     $        ,0,xlcl) + H5(-1,-1,1,-1,1,xlcl) + H5(-1,-1,1,1,0,xlcl) +
     $        2*H5(-1,0,-1,0,1,xlcl) - H5(-1,0,-1,1,1,xlcl) - H5(-1,0,1,
     $        -1,1,xlcl) - H5(-1,0,1,1,0,xlcl)

         Hr5(-1,1,0,1,-1) = -(Hr2(-1,1)*Hr3(-1,1,0)) + Hr1(-1)*Hr4(-1,1
     $        ,0,1) + 4*Hr5(-1,-1,1,1,0) + 2*Hr5(-1,1,-1,1,0)

         Hr5(-1,1,0,1,0) = (3840*li5half + 1920*li4half*ln2 + 48*ln2**5
     $        - 160*ln2**3*z2 + 612*ln2*z2**2 + 480*ln2**2*z3 - 420*z2
     $        *z3 - 3405*z5)/480. - H1(-1,xlcl)**5/120. + H1(-1,xlcl)**3
     $        *(-0.16666666666666666*z2 + H2(-1,0,xlcl)/6.) - 2*z2*H3(-1
     $        ,-1,0,xlcl) - z2*H3(-1,-1,1,xlcl) + H1(-1,xlcl)**2*(z3 -
     $        H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl)/2. + H3(-1,0,1,xlcl)
     $        /2.) + z2*H3(-1,0,1,xlcl) + H2(-1,0,xlcl)*(-2*z3 + 2*H3(-1
     $        ,-1,0,xlcl) + 2*H3(-1,-1,1,xlcl) + H3(-1,0,1,xlcl)) + H1(
     $        -1,xlcl)*((-7*z2**2 - 20*ln2*z3)/10. + z2*H2(-1,0,xlcl) -
     $        H2(-1,0,xlcl)**2/2. + 4*H4(-1,-1,-1,0,xlcl) + 3*H4(-1,-1,
     $        -1,1,xlcl) + 2*H4(-1,-1,0,0,xlcl) - 2*H4(-1,-1,0,1,xlcl) +
     $        H4(-1,-1,1,0,xlcl) - H4(-1,0,-1,1,xlcl) - H4(-1,0,1,0
     $        ,xlcl)) - 8*H5(-1,-1,-1,-1,0,xlcl) - 7*H5(-1,-1,-1,-1,1
     $        ,xlcl) - 12*H5(-1,-1,-1,0,0,xlcl) - 2*H5(-1,-1,-1,0,1
     $        ,xlcl) - 9*H5(-1,-1,-1,1,0,xlcl) - 4*H5(-1,-1,0,-1,0,xlcl)
     $        - 2*H5(-1,-1,0,-1,1,xlcl) - 4*H5(-1,-1,0,0,1,xlcl) - 3*H5(
     $        -1,-1,1,-1,0,xlcl) - H5(-1,-1,1,-1,1,xlcl) + H5(-1,-1,1,0
     $        ,1,xlcl) - 3*H5(-1,0,-1,0,1,xlcl) + H5(-1,0,1,-1,1,xlcl) -
     $        H5(-1,0,1,0,1,xlcl)

         Hr5(-1,1,0,1,1) = (-3840*li5half - 2880*li4half*ln2 - 88*ln2**5
     $        + 400*ln2**3*z2 - 120*ln2*z2**2 - 1320*ln2**2*z3 + 1320*z2
     $        *z3 + 1215*z5)/960. - (ln2*H1(-1,xlcl)**4)/24. + H1(-1
     $        ,xlcl)**5/120. + H1(-1,xlcl)**3*(ln2**2/12. - H2(-1,0
     $        ,xlcl)/6.) - (ln2*H2(-1,0,xlcl)**2)/2. + ln2**2*H3(-1,-1,0
     $        ,xlcl) + H2(-1,0,xlcl)*(z3 - H3(-1,-1,0,xlcl) - H3(-1,-1,1
     $        ,xlcl)) + (ln2**2*H3(-1,-1,1,xlcl))/2. + H1(-1,xlcl)**2*(
     $        -0.5*z3 + (ln2*H2(-1,0,xlcl))/2. + H3(-1,-1,0,xlcl) + H3(
     $        -1,-1,1,xlcl)/2. - H3(-1,0,1,xlcl)/2.) - (ln2**2*H3(-1,0,1
     $        ,xlcl))/2. + 4*ln2*H4(-1,-1,-1,0,xlcl) + 3*ln2*H4(-1,-1,-1
     $        ,1,xlcl) + 2*ln2*H4(-1,-1,0,0,xlcl) - 2*ln2*H4(-1,-1,0,1
     $        ,xlcl) + ln2*H4(-1,-1,1,0,xlcl) - ln2*H4(-1,0,-1,1,xlcl) -
     $        ln2*H4(-1,0,1,0,xlcl) + H1(-1,xlcl)*((6*z2**2 + 5*ln2*z3)
     $        /5. - (ln2**2*H2(-1,0,xlcl))/2. + H2(-1,0,xlcl)**2/2. - 2
     $        *ln2*H3(-1,-1,0,xlcl) - ln2*H3(-1,-1,1,xlcl) + ln2*H3(-1,0
     $        ,1,xlcl) - 4*H4(-1,-1,-1,0,xlcl) - 3*H4(-1,-1,-1,1,xlcl) -
     $        2*H4(-1,-1,0,0,xlcl) + 2*H4(-1,-1,0,1,xlcl) - H4(-1,-1,1,0
     $        ,xlcl) + H4(-1,0,-1,1,xlcl) + H4(-1,0,1,0,xlcl)) + 7*H5(-1
     $        ,-1,-1,-1,0,xlcl) + 6*H5(-1,-1,-1,-1,1,xlcl) + 7*H5(-1,-1,
     $        -1,0,0,xlcl) + 6*H5(-1,-1,-1,1,0,xlcl) + H5(-1,-1,0,-1,0
     $        ,xlcl) - 2*H5(-1,-1,0,1,0,xlcl) + H5(-1,-1,1,-1,0,xlcl) +
     $        H5(-1,-1,1,0,0,xlcl) - H5(-1,0,-1,0,0,xlcl) - H5(-1,0,-1,1
     $        ,0,xlcl) - H5(-1,0,1,0,0,xlcl)

         Hr5(-1,1,1,-1,-1) = -0.5*(Hr2(-1,1)*Hr3(-1,1,-1)) + Hr2(-1,-1)
     $        *Hr3(-1,1,1) - 3*Hr5(-1,-1,-1,1,1) - Hr5(-1,-1,1,-1,1)

         Hr5(-1,1,1,-1,0) = -(Hr2(-1,1)*Hr3(-1,0,1)) + Hr2(-1,0)*Hr3(-1
     $        ,1,1) + 2*Hr5(-1,-1,0,1,1) - 2*Hr5(-1,-1,1,1,0) + Hr5(-1,0
     $        ,-1,1,1) + Hr5(-1,0,1,-1,1) - Hr5(-1,1,-1,1,0)

         Hr5(-1,1,1,-1,1) = Hr2(-1,1)*Hr3(-1,1,1) - 6*Hr5(-1,-1,1,1,1) -
     $        3*Hr5(-1,1,-1,1,1)

         Hr5(-1,1,1,0,-1) = Hr2(-1,1)*Hr3(-1,0,1) - Hr2(-1,0)*Hr3(-1,1
     $        ,1) + Hr1(-1)*Hr4(-1,1,1,0) - 2*Hr5(-1,-1,0,1,1) - Hr5(-1
     $        ,0,-1,1,1) - Hr5(-1,0,1,-1,1)

         Hr5(-1,1,1,0,0) = (-1920*li5half - 1920*li4half*ln2 - 64*ln2**5
     $        + 320*ln2**3*z2 - 456*ln2*z2**2 - 480*ln2**2*z3 + 420*z2
     $        *z3 + 2265*z5)/960. - H1(-1,xlcl)**5/120. + (H1(-1,xlcl)
     $        **3*H2(-1,0,xlcl))/6. + H2(-1,0,xlcl)*(z3 - H3(-1,-1,0
     $        ,xlcl) - H3(-1,-1,1,xlcl)) + H1(-1,xlcl)**2*(-0.5*z3 - H3(
     $        -1,-1,0,xlcl)/2. - H3(-1,0,0,xlcl)/2.) + H1(-1,xlcl)*((z2
     $        **2 + 10*ln2*z3)/10. + H2(-1,0,xlcl)**2/2. - H4(-1,-1,-1,1
     $        ,xlcl) + H4(-1,-1,0,1,xlcl) + H4(-1,0,-1,1,xlcl) - H4(-1,0
     $        ,0,1,xlcl)) + 2*H5(-1,-1,-1,-1,0,xlcl) + 3*H5(-1,-1,-1,-1
     $        ,1,xlcl) + 3*H5(-1,-1,-1,0,0,xlcl) + 3*H5(-1,-1,-1,1,0
     $        ,xlcl) - H5(-1,-1,-1,1,1,xlcl) + H5(-1,-1,0,-1,0,xlcl) + 2
     $        *H5(-1,-1,0,0,1,xlcl) + H5(-1,-1,0,1,1,xlcl) + H5(-1,-1,1,
     $        -1,0,xlcl) + H5(-1,0,-1,0,1,xlcl) + H5(-1,0,-1,1,1,xlcl) -
     $        H5(-1,0,0,1,1,xlcl)

         Hr5(-1,1,1,0,1) = (1920*li5half + 2880*li4half*ln2 + 104*ln2**5
     $        - 400*ln2**3*z2 - 456*ln2*z2**2 + 1380*ln2**2*z3 - 540*z2
     $        *z3 - 345*z5)/960. - (ln2*H1(-1,xlcl)**4)/24. + H1(-1
     $        ,xlcl)**5/120. + H1(-1,xlcl)**3*(-0.16666666666666666*z2 -
     $        H2(-1,0,xlcl)/6.) + (ln2*H2(-1,0,xlcl)**2)/2. - z2*H3(-1,
     $        -1,0,xlcl) + H2(-1,0,xlcl)*(-(ln2*z2) - 2*z3 + 2*H3(-1,-1
     $        ,0,xlcl) + 2*H3(-1,-1,1,xlcl) - H3(-1,0,0,xlcl)) + H1(-1
     $        ,xlcl)**2*((ln2*z2 + 2*z3)/2. + (ln2*H2(-1,0,xlcl))/2. +
     $        H3(-1,-1,0,xlcl)/2. + H3(-1,0,0,xlcl)/2.) - z2*H3(-1,0,0
     $        ,xlcl) - ln2*H4(-1,-1,-1,1,xlcl) + ln2*H4(-1,-1,0,1,xlcl)
     $        + ln2*H4(-1,0,-1,1,xlcl) - ln2*H4(-1,0,0,1,xlcl) + H1(-1
     $        ,xlcl)*((-5*ln2**2*z2 - 12*z2**2 - 20*ln2*z3)/10. + z2*H2(
     $        -1,0,xlcl) - H2(-1,0,xlcl)**2/2. - ln2*H3(-1,-1,0,xlcl) -
     $        ln2*H3(-1,0,0,xlcl) + H4(-1,-1,-1,1,xlcl) - H4(-1,-1,0,1
     $        ,xlcl) - H4(-1,0,-1,1,xlcl) + H4(-1,0,0,1,xlcl)) - 3*H5(-1
     $        ,-1,-1,-1,0,xlcl) - 4*H5(-1,-1,-1,-1,1,xlcl) - 9*H5(-1,-1,
     $        -1,0,0,xlcl) - 3*H5(-1,-1,-1,0,1,xlcl) - 7*H5(-1,-1,-1,1,0
     $        ,xlcl) - 3*H5(-1,-1,0,-1,0,xlcl) - H5(-1,-1,0,-1,1,xlcl) +
     $        6*H5(-1,-1,0,0,0,xlcl) - 2*H5(-1,-1,0,0,1,xlcl) + H5(-1,-1
     $        ,0,1,0,xlcl) - 2*H5(-1,-1,1,-1,0,xlcl) + 3*H5(-1,0,-1,0,0
     $        ,xlcl) - H5(-1,0,-1,0,1,xlcl) + H5(-1,0,-1,1,0,xlcl) - H5(
     $        -1,0,0,-1,1,xlcl) - H5(-1,0,0,1,0,xlcl)

         Hr5(-1,1,1,1,-1) = -(Hr2(-1,1)*Hr3(-1,1,1)) + Hr1(-1)*Hr4(-1,1
     $        ,1,1) + 4*Hr5(-1,-1,1,1,1) + 2*Hr5(-1,1,-1,1,1)

         Hr5(-1,1,1,1,0) = (-960*li5half - 480*li4half*ln2 - 12*ln2**5 +
     $        80*ln2**3*z2 + 24*ln2*z2**2 - 240*ln2**2*z3 + 240*z2*z3 -
     $        15*z5)/480. + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**3*(z2/6.
     $        - H2(-1,0,xlcl)/6.) + z2*H3(-1,-1,0,xlcl) + H1(-1,xlcl)**2
     $        *((-(ln2*z2) - z3)/2. + H3(-1,-1,0,xlcl)/2. + H3(-1,0,0
     $        ,xlcl)/2.) + z2*H3(-1,0,0,xlcl) + H2(-1,0,xlcl)*(ln2*z2 +
     $        z3 - H3(-1,-1,0,xlcl) - H3(-1,-1,1,xlcl) + H3(-1,0,0
     $        ,xlcl)) + H1(-1,xlcl)*((5*ln2**2*z2 + 4*z2**2 + 10*ln2*z3)
     $        /10. - z2*H2(-1,0,xlcl) - H4(-1,-1,-1,0,xlcl) - H4(-1,-1,0
     $        ,0,xlcl) - H4(-1,0,0,0,xlcl)) + 2*H5(-1,-1,-1,-1,0,xlcl) +
     $        H5(-1,-1,-1,-1,1,xlcl) + 6*H5(-1,-1,-1,0,0,xlcl) + 2*H5(-1
     $        ,-1,-1,0,1,xlcl) + 3*H5(-1,-1,-1,1,0,xlcl) + 2*H5(-1,-1,0,
     $        -1,0,xlcl) + H5(-1,-1,0,-1,1,xlcl) - 4*H5(-1,-1,0,0,0
     $        ,xlcl) + H5(-1,-1,0,0,1,xlcl) + H5(-1,-1,1,-1,0,xlcl) - 2
     $        *H5(-1,0,-1,0,0,xlcl) + H5(-1,0,-1,0,1,xlcl) + H5(-1,0,0,
     $        -1,1,xlcl) - H5(-1,0,0,0,1,xlcl)

         Hr5(-1,1,1,1,1) = li5half + (ln2*H1(-1,xlcl)**4)/24. - H1(-1
     $        ,xlcl)**5/120. + H1(-1,xlcl)**3*(-0.08333333333333333*ln2
     $        **2 + H2(-1,0,xlcl)/6.) - (ln2**3*H2(-1,0,xlcl))/6. - (ln2
     $        **2*H3(-1,-1,0,xlcl))/2. + H1(-1,xlcl)**2*(ln2**3/12. -
     $        (ln2*H2(-1,0,xlcl))/2. - H3(-1,-1,0,xlcl)/2. - H3(-1,0,0
     $        ,xlcl)/2.) - (ln2**2*H3(-1,0,0,xlcl))/2. - ln2*H4(-1,-1,-1
     $        ,0,xlcl) - ln2*H4(-1,-1,0,0,xlcl) - ln2*H4(-1,0,0,0,xlcl)
     $        + H1(-1,xlcl)*(-0.041666666666666664*ln2**4 + (ln2**2*H2(
     $        -1,0,xlcl))/2. + ln2*H3(-1,-1,0,xlcl) + ln2*H3(-1,0,0
     $        ,xlcl) + H4(-1,-1,-1,0,xlcl) + H4(-1,-1,0,0,xlcl) + H4(-1
     $        ,0,0,0,xlcl)) - H5(-1,-1,-1,-1,0,xlcl) - H5(-1,-1,-1,0,0
     $        ,xlcl) - H5(-1,-1,0,0,0,xlcl) - H5(-1,0,0,0,0,xlcl)

         Hr5(0,-1,-1,-1,-1) = (-3*Hr2(-1,0)*Hr3(-1,-1,-1))/4. + (Hr2(0,
     $        -1)*Hr3(-1,-1,-1))/4. + Hr2(-1,-1)*Hr3(-1,-1,0) - Hr1(-1)
     $        *Hr4(-1,-1,-1,0) + Hr5(-1,-1,-1,-1,0)

         Hr5(0,-1,-1,-1,0) = -(Hr2(-1,0)*Hr3(-1,-1,0)) + Hr1(0)*Hr4(-1,
     $        -1,-1,0) + 4*Hr5(-1,-1,-1,0,0) + 2*Hr5(-1,-1,0,-1,0)

         Hr5(0,-1,-1,-1,1) = -(Hr2(-1,0)*Hr3(-1,-1,1)) + Hr1(0)*Hr4(-1,
     $        -1,-1,1) + 2*Hr5(-1,-1,-1,0,1) + 2*Hr5(-1,-1,-1,1,0) +
     $        Hr5(-1,-1,0,-1,1) + Hr5(-1,-1,1,-1,0)

         Hr5(0,-1,-1,0,-1) = 2*Hr2(-1,0)*Hr3(-1,-1,0) + Hr2(0,-1)*Hr3(-1
     $        ,-1,0) - (Hr2(-1,0)*Hr3(-1,0,-1))/2. - 3*Hr1(0)*Hr4(-1,-1,
     $        -1,0) - 6*Hr5(-1,-1,-1,0,0) - 3*Hr5(-1,-1,0,-1,0)

         Hr5(0,-1,-1,0,0) = Hr1(0)*Hr4(-1,-1,0,0) - 3*Hr5(-1,-1,0,0,0) -
     $        Hr5(-1,0,-1,0,0)

         Hr5(0,-1,-1,0,1) = Hr1(0)*Hr4(-1,-1,0,1) - 2*Hr5(-1,-1,0,0,1) -
     $        Hr5(-1,-1,0,1,0) - Hr5(-1,0,-1,0,1)

         Hr5(0,-1,-1,1,-1) = 3*Hr2(-1,0)*Hr3(-1,-1,1) + Hr2(0,-1)*Hr3(-1
     $        ,-1,1) - 3*Hr1(0)*Hr4(-1,-1,-1,1) - Hr1(-1)*Hr4(-1,-1,0,1)
     $        - Hr1(-1)*Hr4(-1,-1,1,0) - Hr1(-1)*Hr4(-1,0,-1,1) - 3*Hr5(
     $        -1,-1,-1,0,1) - 3*Hr5(-1,-1,-1,1,0) - Hr5(-1,-1,0,-1,1) -
     $        2*Hr5(-1,-1,1,-1,0)

         Hr5(0,-1,-1,1,0) = Hr1(0)*Hr4(-1,-1,1,0) - Hr5(-1,-1,0,1,0) - 2
     $        *Hr5(-1,-1,1,0,0) - Hr5(-1,0,-1,1,0)

         Hr5(0,-1,-1,1,1) = Hr1(0)*Hr4(-1,-1,1,1) - Hr5(-1,-1,0,1,1) -
     $        Hr5(-1,-1,1,0,1) - Hr5(-1,-1,1,1,0) - Hr5(-1,0,-1,1,1)
         
         Hr5(0,-1,0,-1,-1) = -(Hr2(-1,0)*Hr3(-1,-1,0)) - Hr2(0,-1)*Hr3(
     $        -1,-1,0) + Hr2(-1,0)*Hr3(-1,0,-1) + (Hr2(0,-1)*Hr3(-1,0,
     $        -1))/2. - 2*Hr2(-1,-1)*Hr3(-1,0,0) + 3*Hr1(0)*Hr4(-1,-1,-1
     $        ,0) + 2*Hr1(-1)*Hr4(-1,-1,0,0) + Hr5(-1,-1,0,-1,0)

         Hr5(0,-1,0,-1,0) = -(Hr2(-1,0)*Hr3(-1,0,0)) + (Hr2(-1,0)*Hr3(0,
     $        -1,0))/2. - 2*Hr1(0)*Hr4(-1,-1,0,0) + 12*Hr5(-1,-1,0,0,0)
     $        + 4*Hr5(-1,0,-1,0,0)

         Hr5(0,-1,0,-1,1) = Hr1(0)*Hr4(-1,0,-1,1) - Hr5(-1,0,-1,0,1) -
     $        Hr5(-1,0,-1,1,0) - 2*Hr5(-1,0,0,-1,1)

         Hr5(0,-1,0,0,-1) = 2*Hr2(-1,0)*Hr3(-1,0,0) + Hr2(0,-1)*Hr3(-1,0
     $        ,0) - (Hr2(-1,0)*Hr3(0,-1,0))/2. - 3*Hr1(-1)*Hr4(-1,0,0,0)
     $        - 6*Hr5(-1,-1,0,0,0) - 3*Hr5(-1,0,-1,0,0)

         Hr5(0,-1,0,0,0) = Hr1(0)*Hr4(-1,0,0,0) - 4*Hr5(-1,0,0,0,0)

         Hr5(0,-1,0,0,1) = Hr1(0)*Hr4(-1,0,0,1) - 3*Hr5(-1,0,0,0,1) -
     $        Hr5(-1,0,0,1,0)

         Hr5(0,-1,0,1,-1) = Hr2(-1,0)*Hr3(-1,0,1) + Hr2(0,-1)*Hr3(-1,0
     $        ,1) - 2*Hr1(0)*Hr4(-1,-1,0,1) - Hr1(0)*Hr4(-1,0,-1,1) - 2
     $        *Hr1(-1)*Hr4(-1,0,0,1) - Hr1(-1)*Hr4(-1,0,1,0) + 4*Hr5(-1,
     $        -1,0,0,1) + 2*Hr5(-1,-1,0,1,0) + 2*Hr5(-1,0,-1,0,1) + Hr5(
     $        -1,0,-1,1,0) + 2*Hr5(-1,0,0,-1,1)

         Hr5(0,-1,0,1,0) = Hr1(0)*Hr4(-1,0,1,0) - 2*Hr5(-1,0,0,1,0) - 2
     $        *Hr5(-1,0,1,0,0)

         Hr5(0,-1,0,1,1) = Hr1(0)*Hr4(-1,0,1,1) - 2*Hr5(-1,0,0,1,1) -
     $        Hr5(-1,0,1,0,1) - Hr5(-1,0,1,1,0)

         Hr5(0,-1,1,-1,-1) = Hr2(-1,1)*Hr3(-1,-1,0) - 3*Hr2(-1,0)*Hr3(-1
     $        ,-1,1) - Hr2(0,-1)*Hr3(-1,-1,1) + (Hr2(-1,1)*Hr3(-1,0,-1))
     $        /2. - Hr2(-1,-1)*Hr3(-1,0,1) + (Hr2(0,-1)*Hr3(-1,1,-1))/2.
     $        - Hr2(-1,-1)*Hr3(-1,1,0) + 3*Hr1(0)*Hr4(-1,-1,-1,1) + 2
     $        *Hr1(-1)*Hr4(-1,-1,0,1) + 2*Hr1(-1)*Hr4(-1,-1,1,0) + Hr1(
     $        -1)*Hr4(-1,0,-1,1) + Hr5(-1,-1,1,-1,0)

         Hr5(0,-1,1,-1,0) = 2*Hr2(-1,1)*Hr3(-1,0,0) - Hr2(-1,0)*Hr3(-1,0
     $        ,1) - Hr2(-1,0)*Hr3(-1,1,0) + Hr2(-1,1)*Hr3(0,-1,0) - 2
     $        *Hr1(0)*Hr4(-1,-1,0,1) - 2*Hr1(0)*Hr4(-1,-1,1,0) - Hr1(0)
     $        *Hr4(-1,0,-1,1) + 4*Hr5(-1,-1,0,0,1) + 4*Hr5(-1,-1,0,1,0)
     $        + 4*Hr5(-1,-1,1,0,0) + 2*Hr5(-1,0,-1,0,1) + 2*Hr5(-1,0,-1
     $        ,1,0)

         Hr5(0,-1,1,-1,1) = (Hr2(-1,1)*Hr3(-1,0,1))/2. - (Hr2(-1,1)*Hr3(
     $        -1,1,0))/2. + (Hr2(-1,1)*Hr3(0,-1,1))/2. - 2*Hr1(0)*Hr4(-1
     $        ,-1,1,1) + 2*Hr5(-1,-1,1,0,1) + 4*Hr5(-1,-1,1,1,0) - Hr5(
     $        -1,0,1,-1,1) + Hr5(-1,1,-1,1,0)

         Hr5(0,-1,1,0,-1) = -2*Hr2(-1,1)*Hr3(-1,0,0) + Hr2(-1,0)*Hr3(-1
     $        ,0,1) + 2*Hr2(-1,0)*Hr3(-1,1,0) + Hr2(0,-1)*Hr3(-1,1,0) -
     $        Hr2(-1,1)*Hr3(0,-1,0) + 2*Hr1(0)*Hr4(-1,-1,0,1) + Hr1(0)
     $        *Hr4(-1,0,-1,1) - Hr1(-1)*Hr4(-1,0,1,0) - 2*Hr1(-1)*Hr4(-1
     $        ,1,0,0) - 4*Hr5(-1,-1,0,0,1) - 2*Hr5(-1,-1,0,1,0) - 2*Hr5(
     $        -1,0,-1,0,1) - Hr5(-1,0,-1,1,0)

         Hr5(0,-1,1,0,0) = Hr1(0)*Hr4(-1,1,0,0) - Hr5(-1,0,1,0,0) - 3
     $        *Hr5(-1,1,0,0,0)

         Hr5(0,-1,1,0,1) = Hr1(0)*Hr4(-1,1,0,1) - Hr5(-1,0,1,0,1) - 2
     $        *Hr5(-1,1,0,0,1) - Hr5(-1,1,0,1,0)

         Hr5(0,-1,1,1,-1) = -0.5*(Hr2(-1,1)*Hr3(-1,0,1)) + (Hr2(-1,1)
     $        *Hr3(-1,1,0))/2. + Hr2(-1,0)*Hr3(-1,1,1) + Hr2(0,-1)*Hr3(
     $        -1,1,1) - (Hr2(-1,1)*Hr3(0,-1,1))/2. - Hr1(-1)*Hr4(-1,0,1
     $        ,1) - Hr1(-1)*Hr4(-1,1,0,1) - Hr1(-1)*Hr4(-1,1,1,0) + 2
     $        *Hr5(-1,-1,0,1,1) - 2*Hr5(-1,-1,1,1,0) + Hr5(-1,0,-1,1,1)
     $        + Hr5(-1,0,1,-1,1) - Hr5(-1,1,-1,1,0)

         Hr5(0,-1,1,1,0) = Hr1(0)*Hr4(-1,1,1,0) - Hr5(-1,0,1,1,0) - Hr5(
     $        -1,1,0,1,0) - 2*Hr5(-1,1,1,0,0)

         Hr5(0,-1,1,1,1) = Hr1(0)*Hr4(-1,1,1,1) - Hr5(-1,0,1,1,1) - Hr5(
     $        -1,1,0,1,1) - Hr5(-1,1,1,0,1) - Hr5(-1,1,1,1,0)

         Hr5(0,0,-1,-1,-1) = Hr2(0,0)*Hr3(-1,-1,-1) - (Hr2(-1,0)*Hr3(-1
     $        ,0,-1))/2. - (Hr2(0,-1)*Hr3(-1,0,-1))/2. + Hr2(-1,-1)*Hr3(
     $        -1,0,0) - Hr1(0)*Hr4(-1,-1,-1,0) - Hr1(-1)*Hr4(-1,-1,0,0)
     $        + Hr5(-1,-1,-1,0,0)

         Hr5(0,0,-1,-1,0) = Hr2(0,0)*Hr3(-1,-1,0) - (Hr2(-1,0)*Hr3(0,-1
     $        ,0))/2. - 3*Hr5(-1,-1,0,0,0) - Hr5(-1,0,-1,0,0)

         Hr5(0,0,-1,-1,1) = Hr2(0,0)*Hr3(-1,-1,1) - Hr1(0)*Hr4(-1,-1,0
     $        ,1) - Hr1(0)*Hr4(-1,-1,1,0) - Hr1(0)*Hr4(-1,0,-1,1) + Hr5(
     $        -1,-1,0,0,1) + Hr5(-1,-1,0,1,0) + Hr5(-1,-1,1,0,0) + Hr5(
     $        -1,0,-1,0,1) + Hr5(-1,0,-1,1,0) + Hr5(-1,0,0,-1,1)

         Hr5(0,0,-1,0,-1) = Hr2(0,0)*Hr3(-1,0,-1) - 2*Hr2(-1,0)*Hr3(-1,0
     $        ,0) - 2*Hr2(0,-1)*Hr3(-1,0,0) + (Hr2(-1,0)*Hr3(0,-1,0))/2.
     $        + 2*Hr1(0)*Hr4(-1,-1,0,0) + 3*Hr1(-1)*Hr4(-1,0,0,0) + Hr5(
     $        -1,0,-1,0,0)

         Hr5(0,0,-1,0,0) = Hr2(0,0)*Hr3(-1,0,0) - 3*Hr1(0)*Hr4(-1,0,0,0)
     $        + 6*Hr5(-1,0,0,0,0)

         Hr5(0,0,-1,0,1) = Hr2(0,0)*Hr3(-1,0,1) - 2*Hr1(0)*Hr4(-1,0,0,1)
     $        - Hr1(0)*Hr4(-1,0,1,0) + 3*Hr5(-1,0,0,0,1) + 2*Hr5(-1,0,0
     $        ,1,0) + Hr5(-1,0,1,0,0)

         Hr5(0,0,-1,1,-1) = -(Hr2(-1,0)*Hr3(-1,0,1)) - Hr2(0,-1)*Hr3(-1
     $        ,0,1) + Hr2(0,0)*Hr3(-1,1,-1) - Hr2(-1,0)*Hr3(-1,1,0) -
     $        Hr2(0,-1)*Hr3(-1,1,0) + 2*Hr1(0)*Hr4(-1,-1,0,1) + 2*Hr1(0)
     $        *Hr4(-1,-1,1,0) + Hr1(0)*Hr4(-1,0,-1,1) + Hr1(-1)*Hr4(-1,0
     $        ,0,1) + Hr1(-1)*Hr4(-1,0,1,0) + Hr1(-1)*Hr4(-1,1,0,0) - 2
     $        *Hr5(-1,-1,0,0,1) - 2*Hr5(-1,-1,0,1,0) - 2*Hr5(-1,-1,1,0
     $        ,0) - Hr5(-1,0,-1,0,1) - Hr5(-1,0,-1,1,0) - Hr5(-1,0,0,-1
     $        ,1)

         Hr5(0,0,-1,1,0) = Hr2(0,0)*Hr3(-1,1,0) - Hr1(0)*Hr4(-1,0,1,0) -
     $        2*Hr1(0)*Hr4(-1,1,0,0) + Hr5(-1,0,0,1,0) + 2*Hr5(-1,0,1,0
     $        ,0) + 3*Hr5(-1,1,0,0,0)

         Hr5(0,0,-1,1,1) = Hr2(0,0)*Hr3(-1,1,1) - Hr1(0)*Hr4(-1,0,1,1) -
     $        Hr1(0)*Hr4(-1,1,0,1) - Hr1(0)*Hr4(-1,1,1,0) + Hr5(-1,0,0,1
     $        ,1) + Hr5(-1,0,1,0,1) + Hr5(-1,0,1,1,0) + Hr5(-1,1,0,0,1)
     $        + Hr5(-1,1,0,1,0) + Hr5(-1,1,1,0,0)

         Hr5(0,0,0,-1,-1) = (-2*Hr2(0,0)*Hr3(-1,-1,0))/3. - (2*Hr2(0,0)
     $        *Hr3(-1,0,-1))/3. + Hr2(-1,0)*Hr3(-1,0,0) + Hr2(0,-1)*Hr3(
     $        -1,0,0) + (Hr2(0,0)*Hr3(0,-1,-1))/3. - Hr1(0)*Hr4(-1,-1,0
     $        ,0) - Hr1(-1)*Hr4(-1,0,0,0) + Hr5(-1,-1,0,0,0)

         Hr5(0,0,0,-1,0) = (-4*Hr2(0,0)*Hr3(-1,0,0))/3. + (Hr2(0,0)
     $        *Hr3(0,-1,0))/3. + 3*Hr1(0)*Hr4(-1,0,0,0) - 4*Hr5(-1,0,0,0
     $        ,0)

         Hr5(0,0,0,-1,1) = (-2*Hr2(0,0)*Hr3(-1,0,1))/3. - (2*Hr2(0,0)
     $        *Hr3(-1,1,0))/3. + (Hr2(0,0)*Hr3(0,-1,1))/3. + Hr1(0)*Hr4(
     $        -1,0,0,1) + Hr1(0)*Hr4(-1,0,1,0) + Hr1(0)*Hr4(-1,1,0,0) -
     $        Hr5(-1,0,0,0,1) - Hr5(-1,0,0,1,0) - Hr5(-1,0,1,0,0) - Hr5(
     $        -1,1,0,0,0)

         Hr5(0,0,0,0,-1) = (Hr2(0,0)*Hr3(-1,0,0))/2. - (Hr2(0,0)*Hr3(0,
     $        -1,0))/6. + (Hr2(0,0)*Hr3(0,0,-1))/6. - Hr1(0)*Hr4(-1,0,0
     $        ,0) + Hr5(-1,0,0,0,0)

         Hr5(0,0,0,0,0) = (Hr2(0,0)*Hr3(0,0,0))/10.

         Hr5(0,0,0,0,1) = z5 + H1(-1,xlcl)**5/120. + H1(-1,xlcl)**4*(
     $        -0.041666666666666664*ln2 + H1(1,xlcl)/24.) + (
     $        -0.041666666666666664*ln2 - H1(0,xlcl)/24.)*H1(1,xlcl)**4
     $        + H1(-1,xlcl)**3*(-0.16666666666666666*z2 - (ln2*H1(1
     $        ,xlcl))/6. + H1(1,xlcl)**2/12.) + H1(-1,xlcl)**2*(z3/2. -
     $        (z2*H1(1,xlcl))/2. - (ln2*H1(1,xlcl)**2)/4. + H1(1,xlcl)
     $        **3/12.) + H1(-1,xlcl)*((-2*z2**2)/5. + z3*H1(1,xlcl) -
     $        (z2*H1(1,xlcl)**2)/2. - (ln2*H1(1,xlcl)**3)/6. + H1(1
     $        ,xlcl)**4/24.) + H1(1,xlcl)**3*(-0.16666666666666666*z2 -
     $        H2(-1,0,xlcl)/6. - H2(-1,1,xlcl)/6. + H2(0,1,xlcl)/6.) +
     $        H1(1,xlcl)**2*(z3/2. - H3(-1,-1,0,xlcl)/2. - H3(-1,-1,1
     $        ,xlcl)/2. + H3(-1,0,1,xlcl)/2. + H3(-1,1,1,xlcl)/2. - H3(0
     $        ,1,1,xlcl)/2.) + H1(1,xlcl)*((-2*z2**2)/5. - H4(-1,-1,-1,0
     $        ,xlcl) - H4(-1,-1,-1,1,xlcl) + H4(-1,-1,0,1,xlcl) + H4(-1,
     $        -1,1,1,xlcl) - H4(-1,0,1,1,xlcl) - H4(-1,1,1,1,xlcl) +
     $        H4(0,1,1,1,xlcl)) - H5(-1,-1,-1,-1,0,xlcl) - H5(-1,-1,-1,
     $        -1,1,xlcl) + H5(-1,-1,-1,0,1,xlcl) + H5(-1,-1,-1,1,1,xlcl)
     $        - H5(-1,-1,0,1,1,xlcl) - H5(-1,-1,1,1,1,xlcl) + H5(-1,0,1
     $        ,1,1,xlcl) + H5(-1,1,1,1,1,xlcl) - H5(0,1,1,1,1,xlcl)

         Hr5(0,0,0,1,-1) = -0.3333333333333333*(Hr2(0,0)*Hr3(-1,0,1)) +
     $        (2*Hr2(0,0)*Hr3(-1,1,0))/3. - (Hr2(0,0)*Hr3(0,-1,1))/3. -
     $        Hr1(0)*Hr4(-1,1,0,0) + Hr1(-1)*Hr4(0,0,0,1) + Hr5(-1,1,0,0
     $        ,0)

         Hr5(0,0,0,1,0) = Hr1(0)*Hr4(0,0,0,1) - 4*Hr5(0,0,0,0,1)

         Hr5(0,0,0,1,1) = -(z2*z3) + 2*z5 - H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)**4*(ln2/24. - H1(1,xlcl)/24.) + (
     $        -0.08333333333333333*ln2**2 - (ln2*H1(0,xlcl))/6. - H1(0
     $        ,xlcl)**2/12.)*H1(1,xlcl)**3 + H1(-1,xlcl)**3*(
     $        -0.08333333333333333*ln2**2 + (ln2*H1(1,xlcl))/6. - H1(1
     $        ,xlcl)**2/12.) + H1(-1,xlcl)**2*(z3/2. - (ln2**2*H1(1
     $        ,xlcl))/4. + (ln2*H1(1,xlcl)**2)/4. - H1(1,xlcl)**3/12.) +
     $        H1(1,xlcl)**2*(z3/2. - (ln2*H2(-1,0,xlcl))/2. - (ln2*H2(-1
     $        ,1,xlcl))/2. + (ln2*H2(0,1,xlcl))/2. + (H1(0,xlcl)*H2(0,1
     $        ,xlcl))/2. - H3(-1,-1,0,xlcl)/2. - H3(-1,-1,1,xlcl)/2. -
     $        H3(-1,0,0,xlcl)/2. - H3(-1,1,0,xlcl)/2. - H3(0,0,1,xlcl)
     $        /2.) - ln2*H4(-1,-1,-1,0,xlcl) - ln2*H4(-1,-1,-1,1,xlcl) +
     $        ln2*H4(-1,-1,0,1,xlcl) + ln2*H4(-1,-1,1,1,xlcl) - ln2*H4(
     $        -1,0,1,1,xlcl) - ln2*H4(-1,1,1,1,xlcl) + H1(1,xlcl)*(-0.1
     $        *z2**2 - ln2*H3(-1,-1,0,xlcl) - ln2*H3(-1,-1,1,xlcl) + ln2
     $        *H3(-1,0,1,xlcl) + ln2*H3(-1,1,1,xlcl) - ln2*H3(0,1,1
     $        ,xlcl) - H1(0,xlcl)*H3(0,1,1,xlcl) - 2*H4(-1,-1,-1,0,xlcl)
     $        - 2*H4(-1,-1,-1,1,xlcl) - H4(-1,-1,0,0,xlcl) + H4(-1,-1,0
     $        ,1,xlcl) - H4(-1,-1,1,0,xlcl) + H4(-1,-1,1,1,xlcl) + H4(-1
     $        ,0,0,1,xlcl) + H4(-1,0,1,0,xlcl) + H4(-1,1,0,1,xlcl) + H4(
     $        -1,1,1,0,xlcl) + H4(0,0,1,1,xlcl)) + H1(-1,xlcl)*(-0.1*z2
     $        **2 + (ln2/6. + H1(0,xlcl)/6.)*H1(1,xlcl)**3 + H1(1,xlcl)
     $        **2*(-0.25*ln2**2 + H2(-1,0,xlcl)/2. + H2(-1,1,xlcl)/2. -
     $        H2(0,1,xlcl)/2.) + H1(1,xlcl)*(z3 + H3(-1,-1,0,xlcl) + H3(
     $        -1,-1,1,xlcl) - H3(-1,0,1,xlcl) - H3(-1,1,1,xlcl) + H3(0,1
     $        ,1,xlcl)) + H4(-1,-1,-1,0,xlcl) + H4(-1,-1,-1,1,xlcl) -
     $        H4(-1,-1,0,1,xlcl) - H4(-1,-1,1,1,xlcl) + H4(-1,0,1,1
     $        ,xlcl) + H4(-1,1,1,1,xlcl) - H4(0,1,1,1,xlcl)) + ln2*H4(0
     $        ,1,1,1,xlcl) + H1(0,xlcl)*H4(0,1,1,1,xlcl) - 3*H5(-1,-1,-1
     $        ,-1,0,xlcl) - 3*H5(-1,-1,-1,-1,1,xlcl) - H5(-1,-1,-1,0,0
     $        ,xlcl) + 2*H5(-1,-1,-1,0,1,xlcl) - H5(-1,-1,-1,1,0,xlcl) +
     $        2*H5(-1,-1,-1,1,1,xlcl) + H5(-1,-1,0,0,1,xlcl) + H5(-1,-1
     $        ,0,1,0,xlcl) - H5(-1,-1,0,1,1,xlcl) + H5(-1,-1,1,0,1,xlcl)
     $        + H5(-1,-1,1,1,0,xlcl) - H5(-1,-1,1,1,1,xlcl) - H5(-1,0,0
     $        ,1,1,xlcl) - H5(-1,0,1,0,1,xlcl) - H5(-1,0,1,1,0,xlcl) -
     $        H5(-1,1,0,1,1,xlcl) - H5(-1,1,1,0,1,xlcl) - H5(-1,1,1,1,0
     $        ,xlcl) - H5(0,0,1,1,1,xlcl)

         Hr5(0,0,1,-1,-1) = -(Hr2(0,0)*Hr3(-1,-1,1)) - Hr2(0,0)*Hr3(-1,1
     $        ,-1) + Hr2(-1,0)*Hr3(-1,1,0) + Hr2(0,-1)*Hr3(-1,1,0) +
     $        Hr2(-1,-1)*Hr3(0,0,1) - Hr1(0)*Hr4(-1,-1,1,0) - Hr1(-1)
     $        *Hr4(-1,1,0,0) + Hr5(-1,-1,1,0,0)

         Hr5(0,0,1,-1,0) = -(Hr2(0,0)*Hr3(-1,0,1)) - Hr2(0,0)*Hr3(-1,1
     $        ,0) + Hr2(-1,0)*Hr3(0,0,1) + Hr1(0)*Hr4(-1,0,1,0) + 2
     $        *Hr1(0)*Hr4(-1,1,0,0) - Hr5(-1,0,1,0,0) - 3*Hr5(-1,1,0,0
     $        ,0)

         Hr5(0,0,1,-1,1) = -2*Hr2(0,0)*Hr3(-1,1,1) + Hr2(-1,1)*Hr3(0,0
     $        ,1) + Hr1(0)*Hr4(-1,1,0,1) + 2*Hr1(0)*Hr4(-1,1,1,0) - Hr5(
     $        -1,1,0,0,1) - Hr5(-1,1,0,1,0) - 2*Hr5(-1,1,1,0,0)

         Hr5(0,0,1,0,-1) = Hr2(0,0)*Hr3(-1,0,1) + Hr2(0,-1)*Hr3(0,0,1) -
     $        Hr1(0)*Hr4(-1,0,1,0) - 3*Hr1(-1)*Hr4(0,0,0,1) + Hr5(-1,0,1
     $        ,0,0)

         Hr5(0,0,1,0,0) = Hr2(0,0)*Hr3(0,0,1) - 3*Hr1(0)*Hr4(0,0,0,1) +
     $        6*Hr5(0,0,0,0,1)

         Hr5(0,0,1,0,1) = (6*z2*z3 - 11*z5)/2. - H1(-1,xlcl)**5/120. +
     $        H1(-1,xlcl)**4*(ln2/24. - H1(1,xlcl)/24.) + H1(-1,xlcl)**3
     $        *(z2/6. + (ln2*H1(1,xlcl))/6. - H1(1,xlcl)**2/12.) - z2
     $        *H3(-1,-1,0,xlcl) - z2*H3(-1,-1,1,xlcl) + z2*H3(-1,0,1
     $        ,xlcl) + z2*H3(-1,1,1,xlcl) + H1(1,xlcl)**2*((-(ln2*z2) -
     $        2*z3)/2. + (ln2*H2(-1,0,xlcl))/2. + (ln2*H2(-1,1,xlcl))/2.
     $        + H1(0,xlcl)*(-0.5*z2 - H2(-1,0,xlcl)/2. - H2(-1,1,xlcl)
     $        /2. - H2(0,1,xlcl)/2.) - (ln2*H2(0,1,xlcl))/2. + H3(-1,-1
     $        ,0,xlcl) + H3(-1,-1,1,xlcl) + H3(-1,0,0,xlcl) + H3(-1,1,0
     $        ,xlcl) + H3(0,0,1,xlcl)) + H2(-1,1,xlcl)*(H3(-1,1,1,xlcl)
     $        - H3(0,1,1,xlcl)) + H2(-1,0,xlcl)*(H3(-1,0,1,xlcl) + H3(-1
     $        ,1,1,xlcl) - H3(0,1,1,xlcl)) + H1(-1,xlcl)**2*((-(ln2*z2)
     $        - 2*z3)/2. + (ln2/4. + H1(0,xlcl)/4.)*H1(1,xlcl)**2 + H1(1
     $        ,xlcl)*(z2/2. + H2(-1,0,xlcl)/2. + H2(-1,1,xlcl)/2. - H2(0
     $        ,1,xlcl)/2.) + H3(-1,-1,0,xlcl)/2. + H3(-1,-1,1,xlcl)/2. -
     $        H3(-1,0,1,xlcl)/2. - H3(-1,1,1,xlcl)/2. + H3(0,1,1,xlcl)
     $        /2.) - z2*H3(0,1,1,xlcl) + H2(0,1,xlcl)*H3(0,1,1,xlcl) + 3
     $        *ln2*H4(-1,-1,-1,0,xlcl) + 3*ln2*H4(-1,-1,-1,1,xlcl) - 3
     $        *ln2*H4(-1,-1,0,1,xlcl) - 3*ln2*H4(-1,-1,1,1,xlcl) + 3*ln2
     $        *H4(-1,0,1,1,xlcl) + 3*ln2*H4(-1,1,1,1,xlcl) + H1(1,xlcl)
     $        *((-3*z2**2)/10. - H2(-1,0,xlcl)**2/2. - H2(-1,1,xlcl)**2
     $        /2. + z2*H2(0,1,xlcl) - H2(0,1,xlcl)**2/2. + H2(-1,1,xlcl)
     $        *(-z2 + H2(0,1,xlcl)) + H2(-1,0,xlcl)*(-z2 - H2(-1,1,xlcl)
     $        + H2(0,1,xlcl)) + 2*ln2*H3(-1,-1,0,xlcl) + 2*ln2*H3(-1,-1
     $        ,1,xlcl) - 2*ln2*H3(-1,0,1,xlcl) - 2*ln2*H3(-1,1,1,xlcl) +
     $        2*ln2*H3(0,1,1,xlcl) + 2*H1(0,xlcl)*H3(0,1,1,xlcl) + 4*H4(
     $        -1,-1,-1,0,xlcl) + 4*H4(-1,-1,-1,1,xlcl) + 2*H4(-1,-1,0,0
     $        ,xlcl) - 2*H4(-1,-1,0,1,xlcl) + 2*H4(-1,-1,1,0,xlcl) - 2
     $        *H4(-1,-1,1,1,xlcl) - 2*H4(-1,0,0,1,xlcl) - 2*H4(-1,0,1,0
     $        ,xlcl) - 2*H4(-1,1,0,1,xlcl) - 2*H4(-1,1,1,0,xlcl) - 2
     $        *H4(0,0,1,1,xlcl)) - 3*ln2*H4(0,1,1,1,xlcl) - 3*H1(0,xlcl)
     $        *H4(0,1,1,1,xlcl) + H1(-1,xlcl)*((-3*z2**2)/10. + H1(1
     $        ,xlcl)**2*(z2/2. - (ln2*H1(0,xlcl))/2. - H2(-1,0,xlcl)/2.
     $        - H2(-1,1,xlcl)/2. + H2(0,1,xlcl)/2.) - ln2*H3(-1,-1,0
     $        ,xlcl) - ln2*H3(-1,-1,1,xlcl) + ln2*H3(-1,0,1,xlcl) + ln2
     $        *H3(-1,1,1,xlcl) + H1(1,xlcl)*(-(ln2*z2) - 2*z3 - ln2*H2(
     $        -1,0,xlcl) - ln2*H2(-1,1,xlcl) + ln2*H2(0,1,xlcl) - 2*H3(
     $        -1,-1,0,xlcl) - 2*H3(-1,-1,1,xlcl) + 2*H3(-1,0,1,xlcl) + 2
     $        *H3(-1,1,1,xlcl) - 2*H3(0,1,1,xlcl)) - ln2*H3(0,1,1,xlcl)
     $        - 3*H4(-1,-1,-1,0,xlcl) - 3*H4(-1,-1,-1,1,xlcl) + 3*H4(-1,
     $        -1,0,1,xlcl) + 3*H4(-1,-1,1,1,xlcl) - 3*H4(-1,0,1,1,xlcl)
     $        - 3*H4(-1,1,1,1,xlcl) + 3*H4(0,1,1,1,xlcl)) + 7*H5(-1,-1,
     $        -1,-1,0,xlcl) + 7*H5(-1,-1,-1,-1,1,xlcl) - 7*H5(-1,-1,-1,0
     $        ,1,xlcl) - 7*H5(-1,-1,-1,1,1,xlcl) - H5(-1,-1,0,-1,0,xlcl)
     $        - H5(-1,-1,0,-1,1,xlcl) - 4*H5(-1,-1,0,0,1,xlcl) - 3*H5(-1
     $        ,-1,0,1,0,xlcl) + 4*H5(-1,-1,0,1,1,xlcl) - H5(-1,-1,1,-1,0
     $        ,xlcl) - H5(-1,-1,1,-1,1,xlcl) - 2*H5(-1,-1,1,0,1,xlcl) -
     $        3*H5(-1,-1,1,1,0,xlcl) - H5(-1,0,-1,0,1,xlcl) + H5(-1,0,-1
     $        ,1,1,xlcl) + 2*H5(-1,0,0,1,1,xlcl) + H5(-1,0,1,-1,1,xlcl)
     $        + 2*H5(-1,0,1,0,1,xlcl) + 3*H5(-1,0,1,1,0,xlcl) - H5(-1,1,
     $        -1,1,1,xlcl) + 2*H5(-1,1,0,1,1,xlcl) + 2*H5(-1,1,1,0,1
     $        ,xlcl) + 3*H5(-1,1,1,1,0,xlcl) - H5(0,1,0,1,1,xlcl)

         Hr5(0,0,1,1,-1) = Hr2(0,0)*Hr3(-1,1,1) - Hr2(-1,1)*Hr3(0,0,1) -
     $        Hr1(0)*Hr4(-1,1,1,0) + Hr1(-1)*Hr4(0,0,1,1) + Hr5(-1,1,1,0
     $        ,0)

         Hr5(0,0,1,1,0) = Hr1(0)*Hr4(0,0,1,1) - 3*Hr5(0,0,0,1,1) - Hr5(0
     $        ,0,1,0,1)

         Hr5(0,0,1,1,1) = -(z2*z3) + 2*z5 + H1(-1,xlcl)**5/120. + H1(-1
     $        ,xlcl)**4*(-0.041666666666666664*ln2 + H1(1,xlcl)/24.) + (
     $        -0.08333333333333333*ln2**3 - (ln2**2*H1(0,xlcl))/4. -
     $        (ln2*H1(0,xlcl)**2)/4. - H1(0,xlcl)**3/12.)*H1(1,xlcl)**2
     $        + H1(-1,xlcl)**3*(ln2**2/12. - (ln2*H1(1,xlcl))/6. + H1(1
     $        ,xlcl)**2/12.) - (ln2**2*H3(-1,-1,0,xlcl))/2. - (ln2**2
     $        *H3(-1,-1,1,xlcl))/2. + (ln2**2*H3(-1,0,1,xlcl))/2. + (ln2
     $        **2*H3(-1,1,1,xlcl))/2. + H1(-1,xlcl)**2*(
     $        -0.08333333333333333*ln2**3 + (-0.25*ln2 - H1(0,xlcl)/4.)
     $        *H1(1,xlcl)**2 + H1(1,xlcl)*(ln2**2/4. - H2(-1,0,xlcl)/2.
     $        - H2(-1,1,xlcl)/2. + H2(0,1,xlcl)/2.) - H3(-1,-1,0,xlcl)
     $        /2. - H3(-1,-1,1,xlcl)/2. + H3(-1,0,1,xlcl)/2. + H3(-1,1,1
     $        ,xlcl)/2. - H3(0,1,1,xlcl)/2.) - (ln2**2*H3(0,1,1,xlcl))
     $        /2. - (H1(0,xlcl)**2*H3(0,1,1,xlcl))/2. - 2*ln2*H4(-1,-1,
     $        -1,0,xlcl) - 2*ln2*H4(-1,-1,-1,1,xlcl) - ln2*H4(-1,-1,0,0
     $        ,xlcl) + ln2*H4(-1,-1,0,1,xlcl) - ln2*H4(-1,-1,1,0,xlcl) +
     $        ln2*H4(-1,-1,1,1,xlcl) + ln2*H4(-1,0,0,1,xlcl) + ln2*H4(-1
     $        ,0,1,0,xlcl) + ln2*H4(-1,1,0,1,xlcl) + ln2*H4(-1,1,1,0
     $        ,xlcl) + H1(1,xlcl)*((-2*z2**2)/5. - (ln2**2*H2(-1,0
     $        ,xlcl))/2. - (ln2**2*H2(-1,1,xlcl))/2. + (ln2**2*H2(0,1
     $        ,xlcl))/2. + (H1(0,xlcl)**2*H2(0,1,xlcl))/2. - ln2*H3(-1,
     $        -1,0,xlcl) - ln2*H3(-1,-1,1,xlcl) - ln2*H3(-1,0,0,xlcl) -
     $        ln2*H3(-1,1,0,xlcl) + H1(0,xlcl)*(ln2*H2(0,1,xlcl) - H3(0
     $        ,0,1,xlcl)) - ln2*H3(0,0,1,xlcl) - H4(-1,-1,-1,0,xlcl) -
     $        H4(-1,-1,-1,1,xlcl) - H4(-1,-1,0,0,xlcl) - H4(-1,-1,1,0
     $        ,xlcl) - H4(-1,0,0,0,xlcl) - H4(-1,1,0,0,xlcl) + H4(0,0,0
     $        ,1,xlcl)) + H1(-1,xlcl)*((-2*z2**2)/5. + (ln2**2/4. + (ln2
     $        *H1(0,xlcl))/2. + H1(0,xlcl)**2/4.)*H1(1,xlcl)**2 + ln2
     $        *H3(-1,-1,0,xlcl) + ln2*H3(-1,-1,1,xlcl) - ln2*H3(-1,0,1
     $        ,xlcl) - ln2*H3(-1,1,1,xlcl) + H1(1,xlcl)*(
     $        -0.16666666666666666*ln2**3 + ln2*H2(-1,0,xlcl) + ln2*H2(
     $        -1,1,xlcl) - ln2*H2(0,1,xlcl) - H1(0,xlcl)*H2(0,1,xlcl) +
     $        H3(-1,-1,0,xlcl) + H3(-1,-1,1,xlcl) + H3(-1,0,0,xlcl) +
     $        H3(-1,1,0,xlcl) + H3(0,0,1,xlcl)) + ln2*H3(0,1,1,xlcl) +
     $        H1(0,xlcl)*H3(0,1,1,xlcl) + 2*H4(-1,-1,-1,0,xlcl) + 2*H4(
     $        -1,-1,-1,1,xlcl) + H4(-1,-1,0,0,xlcl) - H4(-1,-1,0,1,xlcl)
     $        + H4(-1,-1,1,0,xlcl) - H4(-1,-1,1,1,xlcl) - H4(-1,0,0,1
     $        ,xlcl) - H4(-1,0,1,0,xlcl) - H4(-1,1,0,1,xlcl) - H4(-1,1,1
     $        ,0,xlcl) - H4(0,0,1,1,xlcl)) + ln2*H4(0,0,1,1,xlcl) + H1(0
     $        ,xlcl)*(-(ln2*H3(0,1,1,xlcl)) + H4(0,0,1,1,xlcl)) - 3*H5(
     $        -1,-1,-1,-1,0,xlcl) - 3*H5(-1,-1,-1,-1,1,xlcl) - 2*H5(-1,
     $        -1,-1,0,0,xlcl) + H5(-1,-1,-1,0,1,xlcl) - 2*H5(-1,-1,-1,1
     $        ,0,xlcl) + H5(-1,-1,-1,1,1,xlcl) - H5(-1,-1,0,0,0,xlcl) +
     $        H5(-1,-1,0,0,1,xlcl) + H5(-1,-1,0,1,0,xlcl) - H5(-1,-1,1,0
     $        ,0,xlcl) + H5(-1,-1,1,0,1,xlcl) + H5(-1,-1,1,1,0,xlcl) +
     $        H5(-1,0,0,0,1,xlcl) + H5(-1,0,0,1,0,xlcl) + H5(-1,0,1,0,0
     $        ,xlcl) + H5(-1,1,0,0,1,xlcl) + H5(-1,1,0,1,0,xlcl) + H5(-1
     $        ,1,1,0,0,xlcl) - H5(0,0,0,1,1,xlcl)

         Hr5(0,1,-1,-1,-1) = Hr2(0,1)*Hr3(-1,-1,-1) - Hr2(-1,1)*Hr3(-1,
     $        -1,0) + Hr2(-1,0)*Hr3(-1,-1,1) - (Hr2(-1,1)*Hr3(-1,0,-1))
     $        /2. - (Hr2(0,-1)*Hr3(-1,1,-1))/2. + Hr2(-1,-1)*Hr3(-1,1,0)
     $        - Hr1(0)*Hr4(-1,-1,-1,1) - Hr1(-1)*Hr4(-1,-1,1,0) + Hr5(-1
     $        ,-1,-1,1,0)

         Hr5(0,1,-1,-1,0) = Hr2(0,1)*Hr3(-1,-1,0) - 2*Hr2(-1,1)*Hr3(-1,0
     $        ,0) + Hr2(-1,0)*Hr3(-1,1,0) - Hr2(-1,1)*Hr3(0,-1,0) +
     $        Hr1(0)*Hr4(-1,-1,0,1) + Hr1(0)*Hr4(-1,-1,1,0) + Hr1(0)
     $        *Hr4(-1,0,-1,1) - Hr5(-1,-1,0,1,0) - 2*Hr5(-1,-1,1,0,0) -
     $        Hr5(-1,0,-1,1,0)

         Hr5(0,1,-1,-1,1) = Hr2(0,1)*Hr3(-1,-1,1) - (Hr2(-1,1)*Hr3(-1,0
     $        ,1))/2. + (Hr2(-1,1)*Hr3(-1,1,0))/2. - (Hr2(-1,1)*Hr3(0,-1
     $        ,1))/2. - Hr5(-1,-1,1,0,1) - 2*Hr5(-1,-1,1,1,0) - Hr5(-1,1
     $        ,-1,1,0)

         Hr5(0,1,-1,0,-1) = Hr2(0,1)*Hr3(-1,0,-1) + 2*Hr2(-1,1)*Hr3(-1,0
     $        ,0) - Hr2(-1,0)*Hr3(-1,0,1) - Hr2(0,-1)*Hr3(-1,0,1) - 2
     $        *Hr2(-1,0)*Hr3(-1,1,0) - Hr2(0,-1)*Hr3(-1,1,0) + Hr2(-1,1)
     $        *Hr3(0,-1,0) - Hr1(0)*Hr4(-1,0,-1,1) + Hr1(-1)*Hr4(-1,0,1
     $        ,0) + 2*Hr1(-1)*Hr4(-1,1,0,0) + Hr5(-1,0,-1,1,0)

         Hr5(0,1,-1,0,0) = Hr2(0,1)*Hr3(-1,0,0) - Hr1(0)*Hr4(-1,0,0,1) -
     $        Hr1(0)*Hr4(-1,0,1,0) - Hr1(0)*Hr4(-1,1,0,0) + Hr5(-1,0,0,1
     $        ,0) + 2*Hr5(-1,0,1,0,0) + 3*Hr5(-1,1,0,0,0)

         Hr5(0,1,-1,0,1) = Hr2(0,1)*Hr3(-1,0,1) - 2*Hr1(0)*Hr4(-1,0,1,1)
     $        - Hr1(0)*Hr4(-1,1,0,1) + Hr5(-1,0,1,0,1) + 2*Hr5(-1,0,1,1
     $        ,0) + 2*Hr5(-1,1,0,0,1) + Hr5(-1,1,0,1,0)

         Hr5(0,1,-1,1,-1) = (Hr2(-1,1)*Hr3(-1,0,1))/2. + Hr2(0,1)*Hr3(-1
     $        ,1,-1) - (Hr2(-1,1)*Hr3(-1,1,0))/2. - 2*Hr2(-1,0)*Hr3(-1,1
     $        ,1) - 2*Hr2(0,-1)*Hr3(-1,1,1) + (Hr2(-1,1)*Hr3(0,-1,1))/2.
     $        + 2*Hr1(0)*Hr4(-1,-1,1,1) + Hr1(-1)*Hr4(-1,1,0,1) + 2*Hr1(
     $        -1)*Hr4(-1,1,1,0) + Hr5(-1,1,-1,1,0)

         Hr5(0,1,-1,1,0) = Hr2(0,1)*Hr3(-1,1,0) - Hr1(0)*Hr4(-1,1,0,1) -
     $        2*Hr1(0)*Hr4(-1,1,1,0) + 2*Hr5(-1,1,0,1,0) + 4*Hr5(-1,1,1
     $        ,0,0)

         Hr5(0,1,-1,1,1) = Hr2(0,1)*Hr3(-1,1,1) - 3*Hr1(0)*Hr4(-1,1,1,1)
     $        + Hr5(-1,1,0,1,1) + 2*Hr5(-1,1,1,0,1) + 3*Hr5(-1,1,1,1,0)

         Hr5(0,1,0,-1,-1) = Hr2(-1,0)*Hr3(-1,0,1) + Hr2(0,-1)*Hr3(-1,0
     $        ,1) + Hr2(0,1)*Hr3(0,-1,-1) - 2*Hr2(-1,-1)*Hr3(0,0,1) -
     $        Hr1(0)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,0,1,0) + Hr5(-1,-1
     $        ,0,1,0)

         Hr5(0,1,0,-1,0) = Hr2(0,1)*Hr3(0,-1,0) - 2*Hr2(-1,0)*Hr3(0,0,1)
     $        + 2*Hr1(0)*Hr4(-1,0,0,1) + Hr1(0)*Hr4(-1,0,1,0) - 2*Hr5(-1
     $        ,0,0,1,0) - 2*Hr5(-1,0,1,0,0)

         Hr5(0,1,0,-1,1) = Hr2(0,1)*Hr3(0,-1,1) - 2*Hr2(-1,1)*Hr3(0,0,1)
     $        + 2*Hr1(0)*Hr4(-1,0,1,1) + Hr1(0)*Hr4(-1,1,0,1) - Hr5(-1,0
     $        ,1,0,1) - 2*Hr5(-1,0,1,1,0) - Hr5(-1,1,0,1,0)

         Hr5(0,1,0,0,-1) = Hr2(0,1)*Hr3(0,0,-1) - 2*Hr2(0,-1)*Hr3(0,0,1)
     $        - Hr1(0)*Hr4(-1,0,0,1) + 3*Hr1(-1)*Hr4(0,0,0,1) + Hr5(-1,0
     $        ,0,1,0)

         Hr5(0,1,0,0,0) = Hr2(0,1)*Hr3(0,0,0) - 2*Hr2(0,0)*Hr3(0,0,1) +
     $        3*Hr1(0)*Hr4(0,0,0,1) - 4*Hr5(0,0,0,0,1)

         Hr5(0,1,0,0,1) = Hr2(0,1)*Hr3(0,0,1) - 6*Hr5(0,0,0,1,1) - 3
     $        *Hr5(0,0,1,0,1)

         Hr5(0,1,0,1,-1) = -0.5*(Hr2(0,1)*Hr3(-1,0,1)) - (Hr2(0,1)*Hr3(0
     $        ,-1,1))/2. + 2*Hr2(-1,1)*Hr3(0,0,1) + (Hr2(0,1)*Hr3(0,1,
     $        -1))/2. - Hr1(0)*Hr4(-1,1,0,1) - 2*Hr1(-1)*Hr4(0,0,1,1) +
     $        Hr5(-1,1,0,1,0)

         Hr5(0,1,0,1,0) = -(Hr2(0,1)*Hr3(0,0,1)) + (Hr2(0,1)*Hr3(0,1,0))
     $        /2. - 2*Hr1(0)*Hr4(0,0,1,1) + 12*Hr5(0,0,0,1,1) + 4*Hr5(0
     $        ,0,1,0,1)

         Hr5(0,1,0,1,1) = (6*z2*z3 - 11*z5)/2. + H1(-1,xlcl)**5/120. +
     $        H1(-1,xlcl)**4*(-0.041666666666666664*ln2 + H1(1,xlcl)
     $        /24.) - (ln2*H2(-1,0,xlcl)**2)/2. - (ln2*H2(-1,1,xlcl)**2)
     $        /2. + H1(-1,xlcl)**3*(ln2**2/12. + (-0.16666666666666666
     $        *ln2 - H1(0,xlcl)/6.)*H1(1,xlcl) - H2(-1,0,xlcl)/6. - H2(
     $        -1,1,xlcl)/6. + H2(0,1,xlcl)/6.) - (ln2*H2(0,1,xlcl)**2)
     $        /2. + ln2**2*H3(-1,-1,0,xlcl) + H2(-1,0,xlcl)*(z3 - ln2
     $        *H2(-1,1,xlcl) + ln2*H2(0,1,xlcl) - H3(-1,-1,0,xlcl) - H3(
     $        -1,-1,1,xlcl)) + ln2**2*H3(-1,-1,1,xlcl) + H2(-1,1,xlcl)
     $        *(z3 + ln2*H2(0,1,xlcl) - H3(-1,-1,0,xlcl) - H3(-1,-1,1
     $        ,xlcl) - H3(-1,0,0,xlcl)) - ln2**2*H3(-1,0,1,xlcl) - ln2
     $        **2*H3(-1,1,1,xlcl) + H2(0,1,xlcl)*(-z3 + H3(-1,-1,0,xlcl)
     $        + H3(-1,-1,1,xlcl) + H3(-1,0,0,xlcl) + H3(-1,1,0,xlcl) +
     $        H3(0,0,1,xlcl)) + ln2**2*H3(0,1,1,xlcl) + H1(0,xlcl)**2
     $        *H3(0,1,1,xlcl) + H1(-1,xlcl)**2*(-0.5*z3 + (ln2*H2(-1,0
     $        ,xlcl))/2. + (ln2*H2(-1,1,xlcl))/2. + H1(1,xlcl)*(ln2**2
     $        /4. + (ln2*H1(0,xlcl))/2. + H2(-1,0,xlcl)/2. + H2(-1,1
     $        ,xlcl)/2. - H2(0,1,xlcl)/2.) - (ln2*H2(0,1,xlcl))/2. + H3(
     $        -1,-1,0,xlcl) + H3(-1,-1,1,xlcl) - H3(-1,0,1,xlcl) - H3(-1
     $        ,1,1,xlcl) + H3(0,1,1,xlcl)) + 4*ln2*H4(-1,-1,-1,0,xlcl) +
     $        4*ln2*H4(-1,-1,-1,1,xlcl) + 2*ln2*H4(-1,-1,0,0,xlcl) - 2
     $        *ln2*H4(-1,-1,0,1,xlcl) + 2*ln2*H4(-1,-1,1,0,xlcl) - 2*ln2
     $        *H4(-1,-1,1,1,xlcl) - 2*ln2*H4(-1,0,0,1,xlcl) - 2*ln2*H4(
     $        -1,0,1,0,xlcl) - 2*ln2*H4(-1,1,0,1,xlcl) - 2*ln2*H4(-1,1,1
     $        ,0,xlcl) + H1(1,xlcl)*((6*z2**2 + 5*ln2*z3)/5. + (ln2**2
     $        *H2(-1,0,xlcl))/2. + (ln2**2*H2(-1,1,xlcl))/2. - (ln2**2
     $        *H2(0,1,xlcl))/2. - (H1(0,xlcl)**2*H2(0,1,xlcl))/2. + 2
     $        *ln2*H3(-1,-1,0,xlcl) + 2*ln2*H3(-1,-1,1,xlcl) + 2*ln2*H3(
     $        -1,0,0,xlcl) + 2*ln2*H3(-1,1,0,xlcl) + 2*ln2*H3(0,0,1
     $        ,xlcl) + H1(0,xlcl)*(z3 - ln2*H2(-1,0,xlcl) - ln2*H2(-1,1
     $        ,xlcl) - ln2*H2(0,1,xlcl) - H3(-1,-1,0,xlcl) - H3(-1,-1,1
     $        ,xlcl) - H3(-1,0,0,xlcl) - H3(-1,1,0,xlcl) + 2*H3(0,0,1
     $        ,xlcl)) + 3*H4(-1,-1,-1,0,xlcl) + 3*H4(-1,-1,-1,1,xlcl) +
     $        3*H4(-1,-1,0,0,xlcl) + 3*H4(-1,-1,1,0,xlcl) + 3*H4(-1,0,0
     $        ,0,xlcl) + 3*H4(-1,1,0,0,xlcl) - 3*H4(0,0,0,1,xlcl)) +
     $        H1(0,xlcl)*(-0.5*H2(0,1,xlcl)**2 + 2*ln2*H3(0,1,1,xlcl) -
     $        2*H4(0,0,1,1,xlcl)) - 2*ln2*H4(0,0,1,1,xlcl) + H1(-1,xlcl)
     $        *((6*z2**2 + 5*ln2*z3)/5. + H2(-1,0,xlcl)**2/2. + H2(-1,1
     $        ,xlcl)**2/2. + H2(-1,1,xlcl)*(-0.5*ln2**2 - H2(0,1,xlcl))
     $        + H2(-1,0,xlcl)*(-0.5*ln2**2 + H2(-1,1,xlcl) - H2(0,1
     $        ,xlcl)) + (ln2**2*H2(0,1,xlcl))/2. + H2(0,1,xlcl)**2/2. -
     $        2*ln2*H3(-1,-1,0,xlcl) - 2*ln2*H3(-1,-1,1,xlcl) + 2*ln2
     $        *H3(-1,0,1,xlcl) + 2*ln2*H3(-1,1,1,xlcl) + H1(1,xlcl)*(-z3
     $        - ln2*H2(-1,0,xlcl) - ln2*H2(-1,1,xlcl) + ln2*H2(0,1,xlcl)
     $        + H1(0,xlcl)*(-0.5*ln2**2 + H2(-1,0,xlcl) + H2(-1,1,xlcl)
     $        + H2(0,1,xlcl)) - 2*H3(-1,-1,0,xlcl) - 2*H3(-1,-1,1,xlcl)
     $        - 2*H3(-1,0,0,xlcl) - 2*H3(-1,1,0,xlcl) - 2*H3(0,0,1
     $        ,xlcl)) - 2*ln2*H3(0,1,1,xlcl) - 2*H1(0,xlcl)*H3(0,1,1
     $        ,xlcl) - 4*H4(-1,-1,-1,0,xlcl) - 4*H4(-1,-1,-1,1,xlcl) - 2
     $        *H4(-1,-1,0,0,xlcl) + 2*H4(-1,-1,0,1,xlcl) - 2*H4(-1,-1,1
     $        ,0,xlcl) + 2*H4(-1,-1,1,1,xlcl) + 2*H4(-1,0,0,1,xlcl) + 2
     $        *H4(-1,0,1,0,xlcl) + 2*H4(-1,1,0,1,xlcl) + 2*H4(-1,1,1,0
     $        ,xlcl) + 2*H4(0,0,1,1,xlcl)) + 7*H5(-1,-1,-1,-1,0,xlcl) +
     $        7*H5(-1,-1,-1,-1,1,xlcl) + 7*H5(-1,-1,-1,0,0,xlcl) + 7*H5(
     $        -1,-1,-1,1,0,xlcl) + H5(-1,-1,0,-1,0,xlcl) + H5(-1,-1,0,-1
     $        ,1,xlcl) - H5(-1,-1,0,0,1,xlcl) - 2*H5(-1,-1,0,1,0,xlcl) +
     $        H5(-1,-1,1,-1,0,xlcl) + H5(-1,-1,1,-1,1,xlcl) + 2*H5(-1,-1
     $        ,1,0,0,xlcl) - 3*H5(-1,-1,1,0,1,xlcl) - 4*H5(-1,-1,1,1,0
     $        ,xlcl) - H5(-1,0,-1,0,0,xlcl) + H5(-1,0,-1,0,1,xlcl) + H5(
     $        -1,0,0,-1,1,xlcl) - 3*H5(-1,0,0,0,1,xlcl) - 2*H5(-1,0,0,1
     $        ,0,xlcl) - 2*H5(-1,0,1,0,0,xlcl) - H5(-1,1,-1,1,0,xlcl) -
     $        3*H5(-1,1,0,0,1,xlcl) - 2*H5(-1,1,0,1,0,xlcl) - 2*H5(-1,1
     $        ,1,0,0,xlcl) - H5(0,0,1,0,1,xlcl)

         Hr5(0,1,1,-1,-1) = -(Hr2(0,1)*Hr3(-1,-1,1)) - Hr2(0,1)*Hr3(-1,1
     $        ,-1) + Hr2(-1,0)*Hr3(-1,1,1) + Hr2(0,-1)*Hr3(-1,1,1) +
     $        Hr2(-1,-1)*Hr3(0,1,1) - Hr1(0)*Hr4(-1,-1,1,1) - Hr1(-1)
     $        *Hr4(-1,1,1,0) + Hr5(-1,-1,1,1,0)

         Hr5(0,1,1,-1,0) = -(Hr2(0,1)*Hr3(-1,0,1)) - Hr2(0,1)*Hr3(-1,1
     $        ,0) + Hr2(-1,0)*Hr3(0,1,1) + Hr1(0)*Hr4(-1,0,1,1) + Hr1(0)
     $        *Hr4(-1,1,0,1) + Hr1(0)*Hr4(-1,1,1,0) - Hr5(-1,0,1,1,0) -
     $        Hr5(-1,1,0,1,0) - 2*Hr5(-1,1,1,0,0)

         Hr5(0,1,1,-1,1) = -2*Hr2(0,1)*Hr3(-1,1,1) + Hr2(-1,1)*Hr3(0,1
     $        ,1) + 3*Hr1(0)*Hr4(-1,1,1,1) - Hr5(-1,1,1,0,1) - 3*Hr5(-1
     $        ,1,1,1,0)

         Hr5(0,1,1,0,-1) = (Hr2(0,1)*Hr3(-1,0,1))/2. - (Hr2(0,1)*Hr3(0,
     $        -1,1))/2. - (Hr2(0,1)*Hr3(0,1,-1))/2. + Hr2(0,-1)*Hr3(0,1
     $        ,1) - Hr1(0)*Hr4(-1,0,1,1) + Hr5(-1,0,1,1,0)

         Hr5(0,1,1,0,0) = -0.5*(Hr2(0,1)*Hr3(0,1,0)) + Hr2(0,0)*Hr3(0,1
     $        ,1) - 3*Hr5(0,0,0,1,1) - Hr5(0,0,1,0,1)

         Hr5(0,1,1,0,1) = Hr2(0,1)*Hr3(0,1,1) - 6*Hr5(0,0,1,1,1) - 3
     $        *Hr5(0,1,0,1,1)

         Hr5(0,1,1,1,-1) = Hr2(0,1)*Hr3(-1,1,1) - Hr2(-1,1)*Hr3(0,1,1) -
     $        Hr1(0)*Hr4(-1,1,1,1) + Hr1(-1)*Hr4(0,1,1,1) + Hr5(-1,1,1,1
     $        ,0)

         Hr5(0,1,1,1,0) = -(Hr2(0,1)*Hr3(0,1,1)) + Hr1(0)*Hr4(0,1,1,1) +
     $        4*Hr5(0,0,1,1,1) + 2*Hr5(0,1,0,1,1)

         Hr5(0,1,1,1,1) = z5 - H1(-1,xlcl)**5/120. + H1(-1,xlcl)**4*(ln2
     $        /24. - H1(1,xlcl)/24.) + (-0.041666666666666664*ln2**4 -
     $        (ln2**3*H1(0,xlcl))/6. - (ln2**2*H1(0,xlcl)**2)/4. - (ln2
     $        *H1(0,xlcl)**3)/6. - H1(0,xlcl)**4/24.)*H1(1,xlcl) - (ln2
     $        **3*H2(-1,0,xlcl))/6. - (ln2**3*H2(-1,1,xlcl))/6. + H1(-1
     $        ,xlcl)**3*(-0.08333333333333333*ln2**2 + (ln2/6. + H1(0
     $        ,xlcl)/6.)*H1(1,xlcl) + H2(-1,0,xlcl)/6. + H2(-1,1,xlcl)
     $        /6. - H2(0,1,xlcl)/6.) + (ln2**3*H2(0,1,xlcl))/6. + (H1(0
     $        ,xlcl)**3*H2(0,1,xlcl))/6. - (ln2**2*H3(-1,-1,0,xlcl))/2.
     $        - (ln2**2*H3(-1,-1,1,xlcl))/2. - (ln2**2*H3(-1,0,0,xlcl))
     $        /2. - (ln2**2*H3(-1,1,0,xlcl))/2. + H1(0,xlcl)**2*((ln2
     $        *H2(0,1,xlcl))/2. - H3(0,0,1,xlcl)/2.) + H1(-1,xlcl)**2
     $        *(ln2**3/12. + (-0.25*ln2**2 - (ln2*H1(0,xlcl))/2. - H1(0
     $        ,xlcl)**2/4.)*H1(1,xlcl) - (ln2*H2(-1,0,xlcl))/2. - (ln2
     $        *H2(-1,1,xlcl))/2. + (ln2*H2(0,1,xlcl))/2. + (H1(0,xlcl)
     $        *H2(0,1,xlcl))/2. - H3(-1,-1,0,xlcl)/2. - H3(-1,-1,1,xlcl)
     $        /2. - H3(-1,0,0,xlcl)/2. - H3(-1,1,0,xlcl)/2. - H3(0,0,1
     $        ,xlcl)/2.) - (ln2**2*H3(0,0,1,xlcl))/2. - ln2*H4(-1,-1,-1
     $        ,0,xlcl) - ln2*H4(-1,-1,-1,1,xlcl) - ln2*H4(-1,-1,0,0
     $        ,xlcl) - ln2*H4(-1,-1,1,0,xlcl) - ln2*H4(-1,0,0,0,xlcl) -
     $        ln2*H4(-1,1,0,0,xlcl) + H1(-1,xlcl)*(-0.041666666666666664
     $        *ln2**4 + (ln2**3/6. + (ln2**2*H1(0,xlcl))/2. + (ln2*H1(0
     $        ,xlcl)**2)/2. + H1(0,xlcl)**3/6.)*H1(1,xlcl) + (ln2**2*H2(
     $        -1,0,xlcl))/2. + (ln2**2*H2(-1,1,xlcl))/2. - (ln2**2*H2(0
     $        ,1,xlcl))/2. - (H1(0,xlcl)**2*H2(0,1,xlcl))/2. + ln2*H3(-1
     $        ,-1,0,xlcl) + ln2*H3(-1,-1,1,xlcl) + ln2*H3(-1,0,0,xlcl) +
     $        ln2*H3(-1,1,0,xlcl) + ln2*H3(0,0,1,xlcl) + H1(0,xlcl)*(
     $        -(ln2*H2(0,1,xlcl)) + H3(0,0,1,xlcl)) + H4(-1,-1,-1,0
     $        ,xlcl) + H4(-1,-1,-1,1,xlcl) + H4(-1,-1,0,0,xlcl) + H4(-1,
     $        -1,1,0,xlcl) + H4(-1,0,0,0,xlcl) + H4(-1,1,0,0,xlcl) -
     $        H4(0,0,0,1,xlcl)) + ln2*H4(0,0,0,1,xlcl) + H1(0,xlcl)
     $        *((ln2**2*H2(0,1,xlcl))/2. - ln2*H3(0,0,1,xlcl) + H4(0,0,0
     $        ,1,xlcl)) - H5(-1,-1,-1,-1,0,xlcl) - H5(-1,-1,-1,-1,1
     $        ,xlcl) - H5(-1,-1,-1,0,0,xlcl) - H5(-1,-1,-1,1,0,xlcl) -
     $        H5(-1,-1,0,0,0,xlcl) - H5(-1,-1,1,0,0,xlcl) - H5(-1,0,0,0
     $        ,0,xlcl) - H5(-1,1,0,0,0,xlcl) - H5(0,0,0,0,1,xlcl)

         Hr5(1,-1,-1,-1,-1) = (-3*Hr2(-1,1)*Hr3(-1,-1,-1))/4. + (Hr2(1,
     $        -1)*Hr3(-1,-1,-1))/4. + Hr2(-1,-1)*Hr3(-1,-1,1) - Hr1(-1)
     $        *Hr4(-1,-1,-1,1) + Hr5(-1,-1,-1,-1,1)

         Hr5(1,-1,-1,-1,0) = -(Hr2(-1,1)*Hr3(-1,-1,0)) + Hr1(1)*Hr4(-1,
     $        -1,-1,0) + 2*Hr5(-1,-1,-1,0,1) + 2*Hr5(-1,-1,-1,1,0) +
     $        Hr5(-1,-1,0,-1,1) + Hr5(-1,-1,1,-1,0)

         Hr5(1,-1,-1,-1,1) = -(Hr2(-1,1)*Hr3(-1,-1,1)) + Hr1(1)*Hr4(-1,
     $        -1,-1,1) + 4*Hr5(-1,-1,-1,1,1) + 2*Hr5(-1,-1,1,-1,1)

         Hr5(1,-1,-1,0,-1) = Hr2(-1,1)*Hr3(-1,-1,0) + Hr2(1,-1)*Hr3(-1,
     $        -1,0) - Hr2(-1,1)*Hr3(-1,0,-1) - 3*Hr1(1)*Hr4(-1,-1,-1,0)
     $        + Hr1(-1)*Hr4(-1,-1,0,1) + Hr1(-1)*Hr4(-1,-1,1,0) + Hr1(
     $        -1)*Hr4(-1,0,-1,1) - 3*Hr5(-1,-1,-1,0,1) - 3*Hr5(-1,-1,-1
     $        ,1,0) - 2*Hr5(-1,-1,0,-1,1) - Hr5(-1,-1,1,-1,0)

         Hr5(1,-1,-1,0,0) = -(Hr2(-1,1)*Hr3(-1,0,0)) + Hr1(1)*Hr4(-1,-1
     $        ,0,0) + Hr5(-1,-1,0,0,1) + Hr5(-1,-1,0,1,0) + Hr5(-1,-1,1
     $        ,0,0) + Hr5(-1,0,-1,0,1) + Hr5(-1,0,-1,1,0) + Hr5(-1,0,0,
     $        -1,1)

         Hr5(1,-1,-1,0,1) = -(Hr2(-1,1)*Hr3(-1,0,1)) + Hr1(1)*Hr4(-1,-1
     $        ,0,1) + 2*Hr5(-1,-1,0,1,1) + Hr5(-1,-1,1,0,1) + 2*Hr5(-1,0
     $        ,-1,1,1) + Hr5(-1,0,1,-1,1)

         Hr5(1,-1,-1,1,-1) = 2*Hr2(-1,1)*Hr3(-1,-1,1) + Hr2(1,-1)*Hr3(-1
     $        ,-1,1) - (Hr2(-1,1)*Hr3(-1,1,-1))/2. - 3*Hr1(1)*Hr4(-1,-1,
     $        -1,1) - 6*Hr5(-1,-1,-1,1,1) - 3*Hr5(-1,-1,1,-1,1)

         Hr5(1,-1,-1,1,0) = Hr1(1)*Hr4(-1,-1,1,0) - Hr5(-1,-1,1,0,1) - 2
     $        *Hr5(-1,-1,1,1,0) - Hr5(-1,1,-1,1,0)

         Hr5(1,-1,-1,1,1) = Hr1(1)*Hr4(-1,-1,1,1) - 3*Hr5(-1,-1,1,1,1) -
     $        Hr5(-1,1,-1,1,1)

         Hr5(1,-1,0,-1,-1) = -(Hr2(1,-1)*Hr3(-1,-1,0)) + (3*Hr2(-1,1)
     $        *Hr3(-1,0,-1))/2. + (Hr2(1,-1)*Hr3(-1,0,-1))/2. - Hr2(-1,
     $        -1)*Hr3(-1,0,1) - Hr2(-1,-1)*Hr3(-1,1,0) + 3*Hr1(1)*Hr4(-1
     $        ,-1,-1,0) - Hr1(-1)*Hr4(-1,0,-1,1) + Hr5(-1,-1,0,-1,1)

         Hr5(1,-1,0,-1,0) = 2*Hr2(-1,1)*Hr3(-1,0,0) - (Hr2(-1,0)*Hr3(-1
     $        ,0,1))/2. - (Hr2(-1,0)*Hr3(-1,1,0))/2. + (Hr2(-1,0)*Hr3(1,
     $        -1,0))/2. - 2*Hr1(1)*Hr4(-1,-1,0,0) - Hr5(-1,0,-1,0,1) -
     $        Hr5(-1,0,-1,1,0) - 2*Hr5(-1,0,0,-1,1)

         Hr5(1,-1,0,-1,1) = Hr2(-1,1)*Hr3(-1,0,1) - Hr2(-1,1)*Hr3(-1,1
     $        ,0) + Hr1(1)*Hr4(-1,0,-1,1) - 4*Hr5(-1,-1,0,1,1) + 4*Hr5(
     $        -1,-1,1,1,0) - 4*Hr5(-1,0,-1,1,1) - 2*Hr5(-1,0,1,-1,1) + 2
     $        *Hr5(-1,1,-1,1,0)

         Hr5(1,-1,0,0,-1) = Hr2(1,-1)*Hr3(-1,0,0) + (Hr2(-1,0)*Hr3(-1,0
     $        ,1))/2. + (Hr2(-1,0)*Hr3(-1,1,0))/2. - (Hr2(-1,0)*Hr3(1,-1
     $        ,0))/2. - Hr1(-1)*Hr4(-1,0,0,1) - Hr1(-1)*Hr4(-1,0,1,0) -
     $        Hr1(-1)*Hr4(-1,1,0,0) + Hr5(-1,0,0,-1,1)

         Hr5(1,-1,0,0,0) = Hr1(1)*Hr4(-1,0,0,0) - Hr5(-1,0,0,0,1) - Hr5(
     $        -1,0,0,1,0) - Hr5(-1,0,1,0,0) - Hr5(-1,1,0,0,0)

         Hr5(1,-1,0,0,1) = Hr1(1)*Hr4(-1,0,0,1) - 2*Hr5(-1,0,0,1,1) -
     $        Hr5(-1,0,1,0,1) - Hr5(-1,1,0,0,1)

         Hr5(1,-1,0,1,-1) = Hr2(-1,1)*Hr3(-1,0,1) + Hr2(1,-1)*Hr3(-1,0
     $        ,1) + Hr2(-1,1)*Hr3(-1,1,0) - 2*Hr1(1)*Hr4(-1,-1,0,1) -
     $        Hr1(1)*Hr4(-1,0,-1,1) - 2*Hr1(-1)*Hr4(-1,0,1,1) - Hr1(-1)
     $        *Hr4(-1,1,0,1) + 4*Hr5(-1,-1,0,1,1) - 4*Hr5(-1,-1,1,1,0) +
     $        2*Hr5(-1,0,-1,1,1) + Hr5(-1,0,1,-1,1) - 2*Hr5(-1,1,-1,1,0)

         Hr5(1,-1,0,1,0) = Hr1(1)*Hr4(-1,0,1,0) - Hr5(-1,0,1,0,1) - 2
     $        *Hr5(-1,0,1,1,0) - Hr5(-1,1,0,1,0)

         Hr5(1,-1,0,1,1) = Hr1(1)*Hr4(-1,0,1,1) - 3*Hr5(-1,0,1,1,1) -
     $        Hr5(-1,1,0,1,1)

         Hr5(1,-1,1,-1,-1) = -(Hr2(-1,1)*Hr3(-1,-1,1)) - Hr2(1,-1)*Hr3(
     $        -1,-1,1) + Hr2(-1,1)*Hr3(-1,1,-1) + (Hr2(1,-1)*Hr3(-1,1,
     $        -1))/2. - 2*Hr2(-1,-1)*Hr3(-1,1,1) + 3*Hr1(1)*Hr4(-1,-1,-1
     $        ,1) + 2*Hr1(-1)*Hr4(-1,-1,1,1) + Hr5(-1,-1,1,-1,1)

         Hr5(1,-1,1,-1,0) = 2*Hr2(-1,1)*Hr3(-1,0,1) + Hr2(-1,1)*Hr3(-1,1
     $        ,0) - 2*Hr2(-1,0)*Hr3(-1,1,1) + Hr2(-1,1)*Hr3(1,-1,0) - 2
     $        *Hr1(1)*Hr4(-1,-1,0,1) - 2*Hr1(1)*Hr4(-1,-1,1,0) - Hr1(1)
     $        *Hr4(-1,0,-1,1) + 2*Hr5(-1,-1,1,0,1) + 4*Hr5(-1,-1,1,1,0)
     $        - Hr5(-1,0,1,-1,1) + Hr5(-1,1,-1,1,0)

         Hr5(1,-1,1,-1,1) = -(Hr2(-1,1)*Hr3(-1,1,1)) + (Hr2(-1,1)*Hr3(1,
     $        -1,1))/2. - 2*Hr1(1)*Hr4(-1,-1,1,1) + 12*Hr5(-1,-1,1,1,1)
     $        + 4*Hr5(-1,1,-1,1,1)
         
         Hr5(1,-1,1,0,-1) = -2*Hr2(-1,1)*Hr3(-1,0,1) + Hr2(1,-1)*Hr3(-1
     $        ,1,0) + 2*Hr2(-1,0)*Hr3(-1,1,1) - Hr2(-1,1)*Hr3(1,-1,0) +
     $        2*Hr1(1)*Hr4(-1,-1,0,1) + Hr1(1)*Hr4(-1,0,-1,1) - Hr1(-1)
     $        *Hr4(-1,1,0,1) - 2*Hr1(-1)*Hr4(-1,1,1,0) + Hr5(-1,0,1,-1
     $        ,1)

         Hr5(1,-1,1,0,0) = Hr1(1)*Hr4(-1,1,0,0) - Hr5(-1,1,0,0,1) - Hr5(
     $        -1,1,0,1,0) - 2*Hr5(-1,1,1,0,0)

         Hr5(1,-1,1,0,1) = Hr1(1)*Hr4(-1,1,0,1) - 2*Hr5(-1,1,0,1,1) - 2
     $        *Hr5(-1,1,1,0,1)

         Hr5(1,-1,1,1,-1) = 2*Hr2(-1,1)*Hr3(-1,1,1) + Hr2(1,-1)*Hr3(-1,1
     $        ,1) - (Hr2(-1,1)*Hr3(1,-1,1))/2. - 3*Hr1(-1)*Hr4(-1,1,1,1)
     $        - 6*Hr5(-1,-1,1,1,1) - 3*Hr5(-1,1,-1,1,1)

         Hr5(1,-1,1,1,0) = Hr1(1)*Hr4(-1,1,1,0) - Hr5(-1,1,1,0,1) - 3
     $        *Hr5(-1,1,1,1,0)

         Hr5(1,-1,1,1,1) = Hr1(1)*Hr4(-1,1,1,1) - 4*Hr5(-1,1,1,1,1)

         Hr5(1,0,-1,-1,-1) = Hr2(1,0)*Hr3(-1,-1,-1) - (Hr2(-1,1)*Hr3(-1
     $        ,0,-1))/2. - (Hr2(1,-1)*Hr3(-1,0,-1))/2. + Hr2(-1,-1)*Hr3(
     $        -1,0,1) - Hr1(1)*Hr4(-1,-1,-1,0) - Hr1(-1)*Hr4(-1,-1,0,1)
     $        + Hr5(-1,-1,-1,0,1)

         Hr5(1,0,-1,-1,0) = Hr2(1,0)*Hr3(-1,-1,0) + (Hr2(-1,0)*Hr3(-1,0
     $        ,1))/2. - (Hr2(-1,0)*Hr3(-1,1,0))/2. - (Hr2(-1,0)*Hr3(1,-1
     $        ,0))/2. - 2*Hr5(-1,-1,0,0,1) - Hr5(-1,-1,0,1,0) - Hr5(-1,0
     $        ,-1,0,1)

         Hr5(1,0,-1,-1,1) = Hr2(1,0)*Hr3(-1,-1,1) - Hr1(1)*Hr4(-1,-1,0
     $        ,1) - Hr1(1)*Hr4(-1,-1,1,0) - Hr1(1)*Hr4(-1,0,-1,1) + 2
     $        *Hr5(-1,-1,0,1,1) + Hr5(-1,-1,1,0,1) + 2*Hr5(-1,0,-1,1,1)
     $        + Hr5(-1,0,1,-1,1)

         Hr5(1,0,-1,0,-1) = Hr2(1,0)*Hr3(-1,0,-1) - 2*Hr2(-1,1)*Hr3(-1,0
     $        ,0) - 2*Hr2(1,-1)*Hr3(-1,0,0) - (Hr2(-1,0)*Hr3(-1,0,1))/2.
     $        + (Hr2(-1,0)*Hr3(-1,1,0))/2. + (Hr2(-1,0)*Hr3(1,-1,0))/2.
     $        + 2*Hr1(1)*Hr4(-1,-1,0,0) + 2*Hr1(-1)*Hr4(-1,0,0,1) + Hr1(
     $        -1)*Hr4(-1,0,1,0) + Hr5(-1,0,-1,0,1)

         Hr5(1,0,-1,0,0) = Hr2(1,0)*Hr3(-1,0,0) - 3*Hr1(1)*Hr4(-1,0,0,0)
     $        + 3*Hr5(-1,0,0,0,1) + 2*Hr5(-1,0,0,1,0) + Hr5(-1,0,1,0,0)

         Hr5(1,0,-1,0,1) = Hr2(1,0)*Hr3(-1,0,1) - 2*Hr1(1)*Hr4(-1,0,0,1)
     $        - Hr1(1)*Hr4(-1,0,1,0) + 4*Hr5(-1,0,0,1,1) + 2*Hr5(-1,0,1
     $        ,0,1)

         Hr5(1,0,-1,1,-1) = -(Hr2(-1,1)*Hr3(-1,0,1)) - Hr2(1,-1)*Hr3(-1
     $        ,0,1) + Hr2(1,0)*Hr3(-1,1,-1) - Hr2(-1,1)*Hr3(-1,1,0) -
     $        Hr2(1,-1)*Hr3(-1,1,0) + 2*Hr1(1)*Hr4(-1,-1,0,1) + 2*Hr1(1)
     $        *Hr4(-1,-1,1,0) + Hr1(1)*Hr4(-1,0,-1,1) + 2*Hr1(-1)*Hr4(-1
     $        ,0,1,1) + Hr1(-1)*Hr4(-1,1,0,1) - 4*Hr5(-1,-1,0,1,1) - 2
     $        *Hr5(-1,-1,1,0,1) - 2*Hr5(-1,0,-1,1,1) - Hr5(-1,0,1,-1,1)

         Hr5(1,0,-1,1,0) = Hr2(1,0)*Hr3(-1,1,0) - Hr1(1)*Hr4(-1,0,1,0) -
     $        2*Hr1(1)*Hr4(-1,1,0,0) + Hr5(-1,0,1,0,1) + 2*Hr5(-1,0,1,1
     $        ,0) + 2*Hr5(-1,1,0,0,1) + Hr5(-1,1,0,1,0)

         Hr5(1,0,-1,1,1) = Hr2(1,0)*Hr3(-1,1,1) - Hr1(1)*Hr4(-1,0,1,1) -
     $        Hr1(1)*Hr4(-1,1,0,1) - Hr1(1)*Hr4(-1,1,1,0) + 3*Hr5(-1,0,1
     $        ,1,1) + 2*Hr5(-1,1,0,1,1) + Hr5(-1,1,1,0,1)

         Hr5(1,0,0,-1,-1) = -0.5*(Hr2(0,1)*Hr3(-1,-1,0)) - (Hr2(1,0)
     $        *Hr3(-1,-1,0))/2. - (Hr2(0,1)*Hr3(-1,0,-1))/2. - (Hr2(1,0)
     $        *Hr3(-1,0,-1))/2. + Hr2(-1,1)*Hr3(-1,0,0) + Hr2(1,-1)*Hr3(
     $        -1,0,0) - (Hr2(0,1)*Hr3(0,-1,-1))/2. + (Hr2(1,0)*Hr3(0,-1,
     $        -1))/2. + Hr2(-1,-1)*Hr3(0,0,1) - Hr1(1)*Hr4(-1,-1,0,0) -
     $        Hr1(-1)*Hr4(-1,0,0,1) + Hr5(-1,-1,0,0,1)

         Hr5(1,0,0,-1,0) = -(Hr2(0,1)*Hr3(-1,0,0)) - Hr2(1,0)*Hr3(-1,0
     $        ,0) - (Hr2(0,1)*Hr3(0,-1,0))/2. + (Hr2(1,0)*Hr3(0,-1,0))
     $        /2. + Hr2(-1,0)*Hr3(0,0,1) + 3*Hr1(1)*Hr4(-1,0,0,0) - 3
     $        *Hr5(-1,0,0,0,1) - Hr5(-1,0,0,1,0)

         Hr5(1,0,0,-1,1) = -0.5*(Hr2(0,1)*Hr3(-1,0,1)) - (Hr2(1,0)*Hr3(
     $        -1,0,1))/2. - (Hr2(0,1)*Hr3(-1,1,0))/2. - (Hr2(1,0)*Hr3(-1
     $        ,1,0))/2. - (Hr2(0,1)*Hr3(0,-1,1))/2. + (Hr2(1,0)*Hr3(0,-1
     $        ,1))/2. + Hr2(-1,1)*Hr3(0,0,1) + Hr1(1)*Hr4(-1,0,0,1) +
     $        Hr1(1)*Hr4(-1,0,1,0) + Hr1(1)*Hr4(-1,1,0,0) - 2*Hr5(-1,0,0
     $        ,1,1) - Hr5(-1,0,1,0,1) - Hr5(-1,1,0,0,1)

         Hr5(1,0,0,0,-1) = (Hr2(0,1)*Hr3(-1,0,0))/3. + (Hr2(1,0)*Hr3(-1
     $        ,0,0))/3. - (Hr2(0,1)*Hr3(0,-1,0))/6. - (Hr2(1,0)*Hr3(0,-1
     $        ,0))/6. - (2*Hr2(0,1)*Hr3(0,0,-1))/3. + (Hr2(1,0)*Hr3(0,0,
     $        -1))/3. + Hr2(0,-1)*Hr3(0,0,1) - Hr1(1)*Hr4(-1,0,0,0) -
     $        Hr1(-1)*Hr4(0,0,0,1) + Hr5(-1,0,0,0,1)

         Hr5(1,0,0,0,0) = (-3*Hr2(0,1)*Hr3(0,0,0))/4. + (Hr2(1,0)*Hr3(0
     $        ,0,0))/4. + Hr2(0,0)*Hr3(0,0,1) - Hr1(0)*Hr4(0,0,0,1) +
     $        Hr5(0,0,0,0,1)

         Hr5(1,0,0,0,1) = -(Hr2(0,1)*Hr3(0,0,1)) + Hr1(1)*Hr4(0,0,0,1) +
     $        4*Hr5(0,0,0,1,1) + 2*Hr5(0,0,1,0,1)

         Hr5(1,0,0,1,-1) = -0.5*(Hr2(1,0)*Hr3(-1,0,1)) + (Hr2(0,1)*Hr3(
     $        -1,1,0))/2. + (Hr2(1,0)*Hr3(-1,1,0))/2. - (Hr2(1,0)*Hr3(0,
     $        -1,1))/2. + Hr2(1,-1)*Hr3(0,0,1) - (Hr2(0,1)*Hr3(0,1,-1))
     $        /2. - Hr1(1)*Hr4(-1,1,0,0) + Hr5(-1,1,0,0,1)

         Hr5(1,0,0,1,0) = 2*Hr2(0,1)*Hr3(0,0,1) + Hr2(1,0)*Hr3(0,0,1) -
     $        (Hr2(0,1)*Hr3(0,1,0))/2. - 3*Hr1(1)*Hr4(0,0,0,1) - 6*Hr5(0
     $        ,0,0,1,1) - 3*Hr5(0,0,1,0,1)

         Hr5(1,0,0,1,1) = Hr1(1)*Hr4(0,0,1,1) - 3*Hr5(0,0,1,1,1) - Hr5(0
     $        ,1,0,1,1)

         Hr5(1,0,1,-1,-1) = 2*Hr2(0,1)*Hr3(-1,-1,1) - (Hr2(-1,1)*Hr3(-1
     $        ,0,1))/2. + Hr2(0,1)*Hr3(-1,1,-1) - (Hr2(1,0)*Hr3(-1,1,
     $        -1))/2. + (Hr2(-1,1)*Hr3(-1,1,0))/2. + (Hr2(1,-1)*Hr3(-1,1
     $        ,0))/2. - (Hr2(-1,1)*Hr3(0,-1,1))/2. + (Hr2(1,-1)*Hr3(0,1,
     $        -1))/2. - 2*Hr2(-1,-1)*Hr3(0,1,1) - Hr1(1)*Hr4(-1,-1,1,0)
     $        - Hr1(-1)*Hr4(-1,1,0,1) + Hr5(-1,-1,1,0,1)

         Hr5(1,0,1,-1,0) = Hr2(0,1)*Hr3(-1,0,1) - Hr2(1,0)*Hr3(-1,0,1) +
     $        Hr2(0,1)*Hr3(-1,1,0) - Hr2(1,0)*Hr3(-1,1,0) - 2*Hr2(-1,0)
     $        *Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,0) + Hr1(1)*Hr4(-1,0,1,0)
     $        + 2*Hr1(1)*Hr4(-1,1,0,0) - Hr5(-1,0,1,0,1) - 2*Hr5(-1,1,0
     $        ,0,1) - Hr5(-1,1,0,1,0)

         Hr5(1,0,1,-1,1) = 2*Hr2(0,1)*Hr3(-1,1,1) - 2*Hr2(1,0)*Hr3(-1,1
     $        ,1) - 2*Hr2(-1,1)*Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,1) +
     $        Hr1(1)*Hr4(-1,1,0,1) + 2*Hr1(1)*Hr4(-1,1,1,0) - 2*Hr5(-1,1
     $        ,0,1,1) - 2*Hr5(-1,1,1,0,1)

         Hr5(1,0,1,0,-1) = (Hr2(0,1)*Hr3(-1,0,1))/2. + 2*Hr2(1,0)*Hr3(-1
     $        ,0,1) - Hr2(0,1)*Hr3(-1,1,0) + (3*Hr2(0,1)*Hr3(0,-1,1))/2.
     $        + Hr2(1,0)*Hr3(0,-1,1) - 2*Hr2(-1,1)*Hr3(0,0,1) - 2*Hr2(1,
     $        -1)*Hr3(0,0,1) + (3*Hr2(0,1)*Hr3(0,1,-1))/2. + Hr2(1,0)
     $        *Hr3(0,1,-1) - 2*Hr2(0,-1)*Hr3(0,1,1) - Hr2(0,1)*Hr3(1,-1
     $        ,0) - Hr1(1)*Hr4(-1,0,1,0) + 2*Hr1(-1)*Hr4(0,0,1,1) + Hr5(
     $        -1,0,1,0,1)

         Hr5(1,0,1,0,0) = -(Hr2(0,1)*Hr3(0,0,1)) - Hr2(1,0)*Hr3(0,0,1) +
     $        Hr2(0,1)*Hr3(0,1,0) + (Hr2(1,0)*Hr3(0,1,0))/2. - 2*Hr2(0
     $        ,0)*Hr3(0,1,1) + 3*Hr1(1)*Hr4(0,0,0,1) + 2*Hr1(0)*Hr4(0,0
     $        ,1,1) + Hr5(0,0,1,0,1)

         Hr5(1,0,1,0,1) = -(Hr2(0,1)*Hr3(0,1,1)) + (Hr2(0,1)*Hr3(1,0,1))
     $        /2. - 2*Hr1(1)*Hr4(0,0,1,1) + 12*Hr5(0,0,1,1,1) + 4*Hr5(0
     $        ,1,0,1,1)

         Hr5(1,0,1,1,-1) = -2*Hr2(0,1)*Hr3(-1,1,1) + Hr2(1,0)*Hr3(-1,1
     $        ,1) + 3*Hr2(-1,1)*Hr3(0,1,1) + Hr2(1,-1)*Hr3(0,1,1) -
     $        Hr2(0,1)*Hr3(1,-1,1) - Hr1(1)*Hr4(-1,1,1,0) - 3*Hr1(-1)
     $        *Hr4(0,1,1,1) + Hr5(-1,1,1,0,1)
         
         Hr5(1,0,1,1,0) = 2*Hr2(0,1)*Hr3(0,1,1) + Hr2(1,0)*Hr3(0,1,1) -
     $        (Hr2(0,1)*Hr3(1,0,1))/2. - 3*Hr1(0)*Hr4(0,1,1,1) - 6*Hr5(0
     $        ,0,1,1,1) - 3*Hr5(0,1,0,1,1)
         
         Hr5(1,0,1,1,1) = Hr1(1)*Hr4(0,1,1,1) - 4*Hr5(0,1,1,1,1)

         Hr5(1,1,-1,-1,-1) = Hr2(1,1)*Hr3(-1,-1,-1) - (Hr2(-1,1)*Hr3(-1
     $        ,1,-1))/2. - (Hr2(1,-1)*Hr3(-1,1,-1))/2. + Hr2(-1,-1)*Hr3(
     $        -1,1,1) - Hr1(1)*Hr4(-1,-1,-1,1) - Hr1(-1)*Hr4(-1,-1,1,1)
     $        + Hr5(-1,-1,-1,1,1)

         Hr5(1,1,-1,-1,0) = Hr2(1,1)*Hr3(-1,-1,0) - Hr2(-1,1)*Hr3(-1,0
     $        ,1) - Hr2(-1,1)*Hr3(-1,1,0) + Hr2(-1,0)*Hr3(-1,1,1) - Hr2(
     $        -1,1)*Hr3(1,-1,0) + Hr1(1)*Hr4(-1,-1,0,1) + Hr1(1)*Hr4(-1,
     $        -1,1,0) + Hr1(1)*Hr4(-1,0,-1,1) - Hr5(-1,-1,0,1,1) - Hr5(
     $        -1,-1,1,0,1) - Hr5(-1,-1,1,1,0) - Hr5(-1,0,-1,1,1)

         Hr5(1,1,-1,-1,1) = Hr2(1,1)*Hr3(-1,-1,1) - (Hr2(-1,1)*Hr3(1,-1
     $        ,1))/2. - 3*Hr5(-1,-1,1,1,1) - Hr5(-1,1,-1,1,1)

         Hr5(1,1,-1,0,-1) = Hr2(1,1)*Hr3(-1,0,-1) - Hr2(1,-1)*Hr3(-1,0
     $        ,1) - Hr2(1,-1)*Hr3(-1,1,0) - Hr2(-1,0)*Hr3(-1,1,1) + Hr2(
     $        -1,1)*Hr3(1,-1,0) - Hr1(1)*Hr4(-1,0,-1,1) + Hr1(-1)*Hr4(-1
     $        ,0,1,1) + Hr1(-1)*Hr4(-1,1,0,1) + Hr1(-1)*Hr4(-1,1,1,0) +
     $        Hr5(-1,0,-1,1,1)
         
         Hr5(1,1,-1,0,0) = Hr2(1,1)*Hr3(-1,0,0) - Hr1(1)*Hr4(-1,0,0,1) -
     $        Hr1(1)*Hr4(-1,0,1,0) - Hr1(1)*Hr4(-1,1,0,0) + Hr5(-1,0,0,1
     $        ,1) + Hr5(-1,0,1,0,1) + Hr5(-1,0,1,1,0) + Hr5(-1,1,0,0,1)
     $        + Hr5(-1,1,0,1,0) + Hr5(-1,1,1,0,0)

         Hr5(1,1,-1,0,1) = Hr2(1,1)*Hr3(-1,0,1) - 2*Hr1(1)*Hr4(-1,0,1,1)
     $        - Hr1(1)*Hr4(-1,1,0,1) + 3*Hr5(-1,0,1,1,1) + 2*Hr5(-1,1,0
     $        ,1,1) + Hr5(-1,1,1,0,1)

         Hr5(1,1,-1,1,-1) = Hr2(1,1)*Hr3(-1,1,-1) - 2*Hr2(-1,1)*Hr3(-1,1
     $        ,1) - 2*Hr2(1,-1)*Hr3(-1,1,1) + (Hr2(-1,1)*Hr3(1,-1,1))/2.
     $        + 2*Hr1(1)*Hr4(-1,-1,1,1) + 3*Hr1(-1)*Hr4(-1,1,1,1) + Hr5(
     $        -1,1,-1,1,1)

         Hr5(1,1,-1,1,0) = Hr2(1,1)*Hr3(-1,1,0) - Hr1(1)*Hr4(-1,1,0,1) -
     $        2*Hr1(1)*Hr4(-1,1,1,0) + Hr5(-1,1,0,1,1) + 2*Hr5(-1,1,1,0
     $        ,1) + 3*Hr5(-1,1,1,1,0)

         Hr5(1,1,-1,1,1) = Hr2(1,1)*Hr3(-1,1,1) - 3*Hr1(1)*Hr4(-1,1,1,1)
     $        + 6*Hr5(-1,1,1,1,1)

         Hr5(1,1,0,-1,-1) = -2*Hr2(0,1)*Hr3(-1,-1,1) - Hr2(1,0)*Hr3(-1,
     $        -1,1) + (3*Hr2(-1,1)*Hr3(-1,0,1))/2. + Hr2(1,-1)*Hr3(-1,0
     $        ,1) - Hr2(0,1)*Hr3(-1,1,-1) - (Hr2(1,0)*Hr3(-1,1,-1))/2. +
     $        (Hr2(-1,1)*Hr3(-1,1,0))/2. + (Hr2(1,-1)*Hr3(-1,1,0))/2. +
     $        Hr2(1,1)*Hr3(0,-1,-1) + (Hr2(-1,1)*Hr3(0,-1,1))/2. -
     $        (Hr2(1,-1)*Hr3(0,1,-1))/2. + Hr2(-1,-1)*Hr3(0,1,1) -
     $        Hr1(1)*Hr4(-1,-1,0,1) - Hr1(-1)*Hr4(-1,0,1,1) + Hr5(-1,-1
     $        ,0,1,1)

         Hr5(1,1,0,-1,0) = -(Hr2(0,1)*Hr3(-1,0,1)) - Hr2(0,1)*Hr3(-1,1
     $        ,0) + Hr2(1,1)*Hr3(0,-1,0) + Hr2(-1,0)*Hr3(0,1,1) - Hr2(0
     $        ,1)*Hr3(1,-1,0) + 2*Hr1(1)*Hr4(-1,0,0,1) + Hr1(1)*Hr4(-1,0
     $        ,1,0) - 2*Hr5(-1,0,0,1,1) - Hr5(-1,0,1,0,1) - Hr5(-1,0,1,1
     $        ,0)

         Hr5(1,1,0,-1,1) = -2*Hr2(0,1)*Hr3(-1,1,1) + Hr2(1,1)*Hr3(0,-1
     $        ,1) + Hr2(-1,1)*Hr3(0,1,1) - Hr2(0,1)*Hr3(1,-1,1) + 2
     $        *Hr1(1)*Hr4(-1,0,1,1) + Hr1(1)*Hr4(-1,1,0,1) - 3*Hr5(-1,0
     $        ,1,1,1) - Hr5(-1,1,0,1,1)

         Hr5(1,1,0,0,-1) = -(Hr2(1,0)*Hr3(-1,0,1)) + Hr2(0,1)*Hr3(-1,1
     $        ,0) - Hr2(0,1)*Hr3(0,-1,1) - Hr2(1,0)*Hr3(0,-1,1) + Hr2(1
     $        ,1)*Hr3(0,0,-1) + Hr2(-1,1)*Hr3(0,0,1) + Hr2(1,-1)*Hr3(0,0
     $        ,1) - Hr2(0,1)*Hr3(0,1,-1) - Hr2(1,0)*Hr3(0,1,-1) + Hr2(0,
     $        -1)*Hr3(0,1,1) + Hr2(0,1)*Hr3(1,-1,0) - Hr1(1)*Hr4(-1,0,0
     $        ,1) - Hr1(-1)*Hr4(0,0,1,1) + Hr5(-1,0,0,1,1)

         Hr5(1,1,0,0,0) = Hr2(1,1)*Hr3(0,0,0) - (Hr2(0,1)*Hr3(0,1,0))/2.
     $        - (Hr2(1,0)*Hr3(0,1,0))/2. + Hr2(0,0)*Hr3(0,1,1) - Hr1(1)
     $        *Hr4(0,0,0,1) - Hr1(0)*Hr4(0,0,1,1) + Hr5(0,0,0,1,1)

         Hr5(1,1,0,0,1) = Hr2(1,1)*Hr3(0,0,1) - (Hr2(0,1)*Hr3(1,0,1))/2.
     $        - 3*Hr5(0,0,1,1,1) - Hr5(0,1,0,1,1)

         Hr5(1,1,0,1,-1) = 2*Hr2(0,1)*Hr3(-1,1,1) + Hr2(1,1)*Hr3(0,1,-1)
     $        - 3*Hr2(-1,1)*Hr3(0,1,1) - 2*Hr2(1,-1)*Hr3(0,1,1) + Hr2(0
     $        ,1)*Hr3(1,-1,1) - Hr1(1)*Hr4(-1,1,0,1) + 3*Hr1(-1)*Hr4(0,1
     $        ,1,1) + Hr5(-1,1,0,1,1)

         Hr5(1,1,0,1,0) = Hr2(1,1)*Hr3(0,1,0) - 2*Hr2(0,1)*Hr3(0,1,1) -
     $        2*Hr2(1,0)*Hr3(0,1,1) + (Hr2(0,1)*Hr3(1,0,1))/2. + 2
     $        *Hr1(1)*Hr4(0,0,1,1) + 3*Hr1(0)*Hr4(0,1,1,1) + Hr5(0,1,0,1
     $        ,1)

         Hr5(1,1,0,1,1) = Hr2(1,1)*Hr3(0,1,1) - 3*Hr1(1)*Hr4(0,1,1,1) +
     $        6*Hr5(0,1,1,1,1)

         Hr5(1,1,1,-1,-1) = (-2*Hr2(1,1)*Hr3(-1,-1,1))/3. - (2*Hr2(1,1)
     $        *Hr3(-1,1,-1))/3. + Hr2(-1,1)*Hr3(-1,1,1) + Hr2(1,-1)*Hr3(
     $        -1,1,1) + (Hr2(1,1)*Hr3(1,-1,-1))/3. - Hr1(1)*Hr4(-1,-1,1
     $        ,1) - Hr1(-1)*Hr4(-1,1,1,1) + Hr5(-1,-1,1,1,1)

         Hr5(1,1,1,-1,0) = (-2*Hr2(1,1)*Hr3(-1,0,1))/3. - (2*Hr2(1,1)
     $        *Hr3(-1,1,0))/3. + (Hr2(1,1)*Hr3(1,-1,0))/3. + Hr1(1)*Hr4(
     $        -1,0,1,1) + Hr1(1)*Hr4(-1,1,0,1) + Hr1(1)*Hr4(-1,1,1,0) -
     $        Hr5(-1,0,1,1,1) - Hr5(-1,1,0,1,1) - Hr5(-1,1,1,0,1) - Hr5(
     $        -1,1,1,1,0)

         Hr5(1,1,1,-1,1) = (-4*Hr2(1,1)*Hr3(-1,1,1))/3. + (Hr2(1,1)
     $        *Hr3(1,-1,1))/3. + 3*Hr1(1)*Hr4(-1,1,1,1) - 4*Hr5(-1,1,1,1
     $        ,1)

         Hr5(1,1,1,0,-1) = (-2*Hr2(1,1)*Hr3(0,-1,1))/3. - (2*Hr2(1,1)
     $        *Hr3(0,1,-1))/3. + Hr2(-1,1)*Hr3(0,1,1) + Hr2(1,-1)*Hr3(0
     $        ,1,1) + (Hr2(1,1)*Hr3(1,0,-1))/3. - Hr1(1)*Hr4(-1,0,1,1) -
     $        Hr1(-1)*Hr4(0,1,1,1) + Hr5(-1,0,1,1,1)

         Hr5(1,1,1,0,0) = (-2*Hr2(1,1)*Hr3(0,0,1))/3. - (2*Hr2(1,1)
     $        *Hr3(0,1,0))/3. + Hr2(0,1)*Hr3(0,1,1) + Hr2(1,0)*Hr3(0,1
     $        ,1) + (Hr2(1,1)*Hr3(1,0,0))/3. - Hr1(1)*Hr4(0,0,1,1) -
     $        Hr1(0)*Hr4(0,1,1,1) + Hr5(0,0,1,1,1)

         Hr5(1,1,1,0,1) = (-4*Hr2(1,1)*Hr3(0,1,1))/3. + (Hr2(1,1)*Hr3(1
     $        ,0,1))/3. + 3*Hr1(1)*Hr4(0,1,1,1) - 4*Hr5(0,1,1,1,1)

         Hr5(1,1,1,1,-1) = (Hr2(1,1)*Hr3(-1,1,1))/2. - (Hr2(1,1)*Hr3(1,
     $        -1,1))/6. + (Hr2(1,1)*Hr3(1,1,-1))/6. - Hr1(1)*Hr4(-1,1,1
     $        ,1) + Hr5(-1,1,1,1,1)
         
         Hr5(1,1,1,1,0) = (Hr2(1,1)*Hr3(0,1,1))/2. - (Hr2(1,1)*Hr3(1,0
     $        ,1))/6. + (Hr2(1,1)*Hr3(1,1,0))/6. - Hr1(1)*Hr4(0,1,1,1) +
     $        Hr5(0,1,1,1,1)
         
         Hr5(1,1,1,1,1) = (Hr2(1,1)*Hr3(1,1,1))/10.
      endif
      end

      
      double precision function transform_x(x)
      implicit none
      double precision x
      
      if(x.lt.sqrt(2.0d0) - 1.0d0) then
         transform_x = x
      elseif(x.le.1.0d0) then
         transform_x = (1.0d0 - x) / (1.0d0 + x)
      endif
      end
*--------------------------------------------------------------
      SUBROUTINE UHPOLYIN
*--------------------------------------------------------------
*     
*     USER INPUT, IW setting mandatory 
*     
*--------------------------------------------------------------
* 
      IMPLICIT NONE
      INTEGER   IW 
      COMMON/WEIGHT/ IW
*
      IW = 8
      WRITE(6,*) '**** HPLs up to weight w =', IW
* 
      RETURN
      END  
*--------------------------------------------------------------    
      SUBROUTINE XHPOLY
*--------------------------------------------------------------    
* 
*     TEST HPL calculation
* 
*--------------------------------------------------------------    
* 
      IMPLICIT NONE
*
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8
      REAL*8   X,TT,START,END
      INTEGER  K
      INTEGER  IW,JJ 
      COMMON/WEIGHT/ IW
      COMMON /JJ/ JJ
*  
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8 
*
      CALL CPU_TIME(START) 
      X   =  0.3D0
* 
       OPEN(UNIT=14,FILE="o1",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      CALL CPU_TIME(START) 
      TT  =  H1(1,X)
      WRITE(14,*) 'T(1):=',TT,';'
      TT  =  H1(0,X) 
      WRITE(14,*) 'T(2):=',TT,';'
      TT  =  H1(-1,X) 
      WRITE(14,*) 'T(3):=',TT,';'
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o2",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 101 JJ = 1,3
      TT  =  H2(0,1,X)
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
101   CONTINUE
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o3",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 102 JJ = 1,8
      TT  =  H3(0,0,1,X)
*      WRITE(14,*) X,TT
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
102   CONTINUE
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o4",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 103 JJ = 1,18
      TT  =  H4(0,0,0,1,X)
*      WRITE(14,*) X,TT
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
103   CONTINUE
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o5",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 104 JJ = 1,48
      TT  =  H5(0,0,0,0,1,X)
*      WRITE(14,*) X,TT
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
104   CONTINUE
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o6",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 105 JJ = 1,116
      TT  =  H6(0,0,0,0,0,1,X)
*      WRITE(14,*) X,TT
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
105   CONTINUE
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o7",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 106 JJ = 1,312
      TT  =  H7(0,0,0,0,0,0,1,X)
*      WRITE(14,*) X,TT
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
106   CONTINUE
      CLOSE(14)
*---------------------------------------------
       OPEN(UNIT=14,FILE="o8",FORM="FORMATTED",STATUS="OLD",
     &     ACTION="WRITE")
      DO 107 JJ = 1,810
      TT  =  H8(0,0,0,0,0,0,0,1,X)
*      WRITE(14,*) X,TT
      WRITE(14,*) 'T(',JJ,'):=',TT,';'
107   CONTINUE
      CLOSE(14)
*---------------------------------------------
      CALL CPU_TIME(END) 
      WRITE(6,*) 'CPU TIME=', END-START, 'SEC'
      STOP 
      END  
*--------------------------------------------------------------    
      SUBROUTINE UHPOLY
*--------------------------------------------------------------    
* 
*     USER HPL calculation
* 
*--------------------------------------------------------------    
* 
      IMPLICIT NONE
*
      REAL*8   H1,H2,H3,H4,H5,H6,H7,H8
      REAL*8   HH3
      REAL*8   T(8),X,TT,START,END
      INTEGER  K
      INTEGER  IW 
      COMMON/WEIGHT/ IW
*  
      EXTERNAL H1,H2,H3,H4,H5,H6,H7,H8 
*
      CALL CPU_TIME(START) 
      X   =  0.3D0
      IF(X.EQ.0) GOTO 100
* 
      T(1)  =  H1(-1,X) 
      T(2)  =  H2(0,1,X) 
      T(3)  =  H3(-1,0,0,X) 
      T(4)  =  H4(-1,-1,1,0,X) 
      T(5)  =  H5(-1,-1,1,0,1,X) 
      T(6)  =  H6(-1,0,-1,1,1,1,X)
      T(7)  =  H7(-1,-1,1,1,0,1,0,X)
      T(8)  =  H8(-1,0,-1,0,-1,0,1,1,X)
*
      DO 1 K = 1,8
      WRITE(6,*) 'K,X,T=', K,X,T(K)
1     CONTINUE
*
      CALL CPU_TIME(END)
      WRITE(6,*) 'CPU TIME=', END-START, '   SEC' 
* 
      RETURN
100   TT=0.0D0
*
      RETURN
      END  
*--------------------------------------------------------------    
      SUBROUTINE HPOLYIN
*--------------------------------------------------------------    
*
*     READ IN THE CONSTANT FIELDS 
*
*--------------------------------------------------------------    
      IMPLICIT NONE
*
      INTEGER   IW 
      INTEGER   LEN(7),K
      INTEGER   I1,I2,I3,I4,I5,I6,I7,I8,J
      REAL*8 DA2,DA3,DA4,DA5,DA6,DA7,DA8
      REAL*8 START,FINISH
*
      COMMON /WEIGHT/  IW
      COMMON /DLIST2/  DA2(360)
      COMMON /DLIST3/  DA3(1600)
      COMMON /DLIST4/  DA4(5040)
      COMMON /DLIST5/  DA5(17280)
      COMMON /DLIST6/  DA6(51040)
      COMMON /DLIST7/  DA7(162240)
      COMMON /DLIST8/  DA8(486000)

*
      DATA LEN/360,1600,5040,17280,51040,162240,486000/

*
      CALL CPU_TIME(START) 
      IF(IW.EQ.1) GOTO 10      
      IF(IW.EQ.2) GOTO 11     
      IF(IW.EQ.3) GOTO 12      
      IF(IW.EQ.4) GOTO 13      
      IF(IW.EQ.5) GOTO 14      
      IF(IW.EQ.6) GOTO 15      
      IF(IW.EQ.7) GOTO 16      
      IF(IW.EQ.8) GOTO 17      
*
      WRITE(6,*) '**** IW = ',IW,'  NOT ALLOWED, STOP: HPOLYIN ***' 
*     
10    GOTO 100
*
 11   OPEN(UNIT=14,FILE="HPOLYinput/TTT2.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 21  K=1,LEN(1)
      READ(UNIT=14,FMT=*) DA2(K)
*     WRITE(6,*), K,DA2(K)
      DA2(K)=DA2(K)*1.0D0 
21    CONTINUE
      CLOSE(14)
      GOTO 100
*
 12   OPEN(UNIT=14,FILE="HPOLYinput/TTT3.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 22  K=1,LEN(2)
      READ(UNIT=14,FMT=*) DA3(K)
      DA3(K)=DA3(K)*1.0D0 
*     WRITE(6,*), K,DA3(K)
22    CONTINUE
      CLOSE(14)
      GOTO 11
*
 13   OPEN(UNIT=14,FILE="HPOLYinput/TTT4.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 23  K=1,LEN(3)
      READ(UNIT=14,FMT=*) DA4(K)
      DA4(K)=DA4(K)*1.0D0 
*     WRITE(6,*), K,DA4(K)
23    CONTINUE
      CLOSE(14)
      GOTO 12
 14   OPEN(UNIT=14,FILE="HPOLYinput/TTT5.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 24  K=1,LEN(4)
      READ(UNIT=14,FMT=*) DA5(K)
      DA5(K)=DA5(K)*1.0D0 
*     WRITE(6,*), K,DA5(K)
24    CONTINUE
      CLOSE(14)
      GOTO 13
*
 15   OPEN(UNIT=14,FILE="HPOLYinput/TTT6.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 25  K=1,LEN(5)
      READ(UNIT=14,FMT=*) DA6(K)
      DA6(K)=DA6(K)*1.0D0 
*     WRITE(6,*), K,DA6(K)
25    CONTINUE
      CLOSE(14)
      GOTO 14
*
 16   OPEN(UNIT=14,FILE="HPOLYinput/TTT7.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 26  K=1,LEN(6)
      READ(UNIT=14,FMT=*) DA7(K)
      DA7(K)=DA7(K)*1.0D0 
*     WRITE(6,*), K,DA7(K)
26    CONTINUE
      CLOSE(14)
      GOTO 15
*
 17   OPEN(UNIT=14,FILE="HPOLYinput/TTT8.m",FORM="FORMATTED",STATUS
     $     ="OLD",ACTION="READ")
      DO 27  K=1,LEN(7)
      READ(UNIT=14,FMT=*) DA8(K)
      DA8(K)=DA8(K)*1.0D0 
*     WRITE(6,*), K,DA8(K)
27    CONTINUE
      CLOSE(14)
      GOTO 16
*
100   CONTINUE
      CALL CPU_TIME(FINISH)
!      WRITE(6,*) 'READ-IN TIME=',-START+FINISH, ' SEC'  
      RETURN
      END
*--------------------------------------------------------------    
      SUBROUTINE HBASIN
*--------------------------------------------------------------    
*
*     READ IN THE CHOSEN BASIS FOR w = 5...8 
*
*--------------------------------------------------------------    
      IMPLICIT NONE
*
      INTEGER   IW,K 
      INTEGER   II15,II25,II35,II45,II55
      INTEGER   II16,II26,II36,II46,II56,II66
      INTEGER   II17,II27,II37,II47,II57,II67,II77
      INTEGER   II18,II28,II38,II48,II58,II68,II78,II88
*
      COMMON /WEIGHT/  IW
      COMMON/BAS5/ II15(48),II25(48),II35(48),II45(48),II55(48)
      COMMON/BAS6/ II16(116),II26(116),II36(116),II46(116),II56(116),
     &             II66(116)
      COMMON/BAS7/ II17(312),II27(312),II37(312),II47(312),II57(312),
     &             II67(312),II77(312)    
      COMMON/BAS8/ II18(810),II28(810),II38(810),II48(810),II58(810),
     &             II68(810),II78(810),II88(810)    
*
      IF(IW.GE.1.AND.IW.LE.4) RETURN
*
      IF(IW.EQ.5) GOTO 10      
      IF(IW.EQ.6) GOTO 11     
      IF(IW.EQ.7) GOTO 12      
      IF(IW.EQ.8) GOTO 13      
*
      WRITE(6,*) '**** IW = ',IW,'  NOT ALLOWED, STOP: HBASIN ***' 
*     
10    CONTINUE
      OPEN(UNIT=14,FILE="HPOLYinput/B51.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=15,FILE="HPOLYinput/B52.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=16,FILE="HPOLYinput/B53.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=17,FILE="HPOLYinput/B54.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=18,FILE="HPOLYinput/B55.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      DO 20  K=1,48
      READ(UNIT=14,FMT=*) II15(K)
      READ(UNIT=15,FMT=*) II25(K)
      READ(UNIT=16,FMT=*) II35(K)
      READ(UNIT=17,FMT=*) II45(K)
      READ(UNIT=18,FMT=*) II55(K)
20    CONTINUE
      CLOSE(14)
      CLOSE(15)
      CLOSE(16)
      CLOSE(17)
      CLOSE(18)
      RETURN
*
11    CONTINUE
      OPEN(UNIT=14,FILE="HPOLYinput/B61.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=15,FILE="HPOLYinput/B62.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=16,FILE="HPOLYinput/B63.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=17,FILE="HPOLYinput/B64.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=18,FILE="HPOLYinput/B65.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=19,FILE="HPOLYinput/B66.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      DO 21  K=1,116
      READ(UNIT=14,FMT=*) II16(K)
      READ(UNIT=15,FMT=*) II26(K)
      READ(UNIT=16,FMT=*) II36(K)
      READ(UNIT=17,FMT=*) II46(K)
      READ(UNIT=18,FMT=*) II56(k)
      READ(UNIT=19,FMT=*) II66(k)
21    CONTINUE
      CLOSE(14)
      CLOSE(15)
      CLOSE(16)
      CLOSE(17)
      CLOSE(18)
      CLOSE(19)
      GOTO  10
12    CONTINUE
      OPEN(UNIT=14,FILE="HPOLYinput/B71.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=15,FILE="HPOLYinput/B72.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=16,FILE="HPOLYinput/B73.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=17,FILE="HPOLYinput/B74.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=18,FILE="HPOLYinput/B75.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=19,FILE="HPOLYinput/B76.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=30,FILE="HPOLYinput/B77.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      DO 22  K=1,312
      READ(UNIT=14,FMT=*) II17(K)
      READ(UNIT=15,FMT=*) II27(K)
      READ(UNIT=16,FMT=*) II37(K)
      READ(UNIT=17,FMT=*) II47(K)
      READ(UNIT=18,FMT=*) II57(k)
      READ(UNIT=19,FMT=*) II67(k)
      READ(UNIT=30,FMT=*) II77(k)
22    CONTINUE
      CLOSE(14)
      CLOSE(15)
      CLOSE(16)
      CLOSE(17)
      CLOSE(18)
      CLOSE(19)
      CLOSE(30)
      GOTO 11
13    CONTINUE
      OPEN(UNIT=14,FILE="HPOLYinput/B81.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=15,FILE="HPOLYinput/B82.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=16,FILE="HPOLYinput/B83.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=17,FILE="HPOLYinput/B84.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=18,FILE="HPOLYinput/B85.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=19,FILE="HPOLYinput/B86.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=30,FILE="HPOLYinput/B87.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      OPEN(UNIT=31,FILE="HPOLYinput/B88.m",FORM="FORMATTED",STATUS="OLD"
     $     ,ACTION="READ")
      DO 23  K=1,810
      READ(UNIT=14,FMT=*) II18(K)
      READ(UNIT=15,FMT=*) II28(K)
      READ(UNIT=16,FMT=*) II38(K)
      READ(UNIT=17,FMT=*) II48(K)
      READ(UNIT=18,FMT=*) II58(k)
      READ(UNIT=19,FMT=*) II68(k)
      READ(UNIT=30,FMT=*) II78(k)
      READ(UNIT=31,FMT=*) II88(k)
23    CONTINUE
      CLOSE(14)
      CLOSE(15)
      CLOSE(16)
      CLOSE(17)
      CLOSE(18)
      CLOSE(19)
      CLOSE(30)
      CLOSE(31)
      GOTO 12
*
      END
*--------------------------------------------------------------    
      SUBROUTINE HPOLYC(X)
*--------------------------------------------------------------    
*
*     CHECK whether x is in range or not  
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      REAL*8 X
*  
      IF(X.GE.0.0D0.AND.X.LE.DSQRT(2.0D0)-1.0D0) GOTO 1
*
      WRITE(6,*) 'X=',X,' *** NOT IN RANGE, STOP: HPOLYC ***'
      STOP
1     RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H1(I1,X)
*--------------------------------------------------------------    
*
*     Weight w = 1 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1
      REAL*8 X,T
*  
      IF(I1.EQ.-1) GOTO 1
      IF(I1.EQ. 0) GOTO 2
      IF(I1.EQ. 1) GOTO 3
*
      WRITE(6,*) 'I1=',I1,' *** W=1, NOT IN RANGE, STOP: H1 ***'
      STOP
*
1     T = DLOG(1.0D0+X)
      GOTO 10
2     T = DLOG(X)
      GOTO 10
3     T = -DLOG(1.0D0-X)
*
10    H1 = T
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H2(I1,I2,X)
*--------------------------------------------------------------    
*
*     Weight w = 2 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,J,K,JJ
      REAL*8 X,T1,T2,T3,U,V
      REAL*8 DA2
*
      COMMON /JJ/ JJ
      COMMON /DLIST2/  DA2(360)
*
      CALL HPOLYC(X)
*
      CALL CHECKB2(I1,I2,J)
*     J = JJ

      U= DLOG(1.0D0+X)
      V=-DLOG(1.0D0-X)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA2((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA2(120+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLOG(U)
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+V**K*DA2(240+(J-1)*40+K)
3     CONTINUE
*
      H2=T1+T2+T3
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H3(I1,I2,I3,X)
*--------------------------------------------------------------    
*
*     Weight w = 3 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,I3,J,K,JJ
      REAL*8 X,T1,T2,T3,T4,T5,U,V,DLU,DLV
      REAL*8 DA3
*
      COMMON /DLIST3/  DA3(1600)
      COMMON /JJ/ JJ
*
      H3=0.0D0
      CALL HPOLYC(X)
*
      CALL CHECKB3(I1,I2,I3,J)
*     J=JJ
*
      U  =  DLOG(1.0D0+X)
      V  = -DLOG(1.0D0-X)
      DLU=  DLOG(U)
      DLV=  DLOG(V)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA3((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA3(320+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLU
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+U**K*DA3(640+(J-1)*40+K)
3     CONTINUE
      T3=T3*DLU*DLU
      T4=0.0D0
      DO 4 K=1,40
      T4=T4+V**K*DA3(960+(J-1)*40+K)
4     CONTINUE
      T5=0.0D0
      DO 5 K=1,40
      T5=T5+V**K*DA3(1280+(J-1)*40+K)
5     CONTINUE
      T5=T5*DLV
*
      H3=T1+T2+T3+T4+T5
*      WRITE(6,*) 'H3=',H3
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H4(I1,I2,I3,I4,X)
*--------------------------------------------------------------    
*
*     Weight w = 4 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,I3,I4,J,K,JJ
      REAL*8 X,T1,T2,T3,T4,T5,T6,T7,U,V,DLU,DLV
      REAL*8 DA4
*
      COMMON /JJ/ JJ
      COMMON /DLIST4/  DA4(5040)
*
      CALL HPOLYC(X)
*
      CALL CHECKB4(I1,I2,I3,I4,J)
*     J = JJ
*
      U  =  DLOG(1.0D0+X)
      V  = -DLOG(1.0D0-X)
      DLU=  DLOG(U)
      DLV=  DLOG(V)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA4((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA4(720+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLU
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+U**K*DA4(1440+(J-1)*40+K)
3     CONTINUE
      T3=T3*DLU*DLU
      T4=0.0D0
      DO 4 K=1,40
      T4=T4+U**K*DA4(2160+(J-1)*40+K)
4     CONTINUE
      T4=T4*DLU*DLU*DLU
      T5=0.0D0
      DO 5 K=1,40
      T5=T5+V**K*DA4(2880+(J-1)*40+K)
5     CONTINUE
      T6=0.0D0
      DO 6 K=1,40
      T6=T6+V**K*DA4(3600+(J-1)*40+K)
6     CONTINUE
      T6=T6*DLV
      T7=0.0D0
      DO 7 K=1,40
      T7=T7+V**K*DA4(4320+(J-1)*40+K)
7     CONTINUE
      T7=T7*DLV*DLV
*
      H4=T1+T2+T3+T4+T5+T6+T7
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H5(I1,I2,I3,I4,I5,X)
*--------------------------------------------------------------    
*
*     Weight w = 5 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,I3,I4,I5,J,K,JJ
      REAL*8 X,T1,T2,T3,T4,T5,T6,T7,T8,T9,U,V,DLU,DLV
      REAL*8 DA5
*
      COMMON /DLIST5/  DA5(17280)
      COMMON /JJ/ JJ
*
      CALL HPOLYC(X)
*
      CALL CHECKB5(I1,I2,I3,I4,I5,J)
*     J = JJ
*
      U  =  DLOG(1.0D0+X)
      V  = -DLOG(1.0D0-X)
      DLU=  DLOG(U)
      DLV=  DLOG(V)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA5((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA5(1920+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLU
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+U**K*DA5(3840+(J-1)*40+K)
3     CONTINUE
      T3=T3*DLU*DLU
      T4=0.0D0
      DO 4 K=1,40
      T4=T4+U**K*DA5(5760+(J-1)*40+K)
4     CONTINUE
      T4=T4*DLU*DLU*DLU
      T5=0.0D0
      DO 5 K=1,40
      T5=T5+U**K*DA5(7680+(J-1)*40+K)
5     CONTINUE
      T5=T5*DLU*DLU*DLU*DLU
      T6=0.0D0
      DO 6 K=1,40
      T6=T6+V**K*DA5(9600+(J-1)*40+K)
6     CONTINUE
      T7=0.0D0
      DO 7 K=1,40
      T7=T7+V**K*DA5(11520+(J-1)*40+K)
7     CONTINUE
      T7=T7*DLV
      T8=0.0D0
      DO 8 K=1,40
      T8=T8+V**K*DA5(13440+(J-1)*40+K)
8     CONTINUE
      T8=T8*DLV*DLV
      T9=0.0D0
      DO 9 K=1,40
      T9=T9+V**K*DA5(15360+(J-1)*40+K)
9     CONTINUE
      T9=T9*DLV*DLV*DLV
*
      H5=T1+T2+T3+T4+T5+T6+T7+T8+T9
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H6(I1,I2,I3,I4,I5,I6,X)
*--------------------------------------------------------------    
*
*     Weight w = 6 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,I3,I4,I5,I6,J,K,JJ
      REAL*8 X,T1,T2,T3,T4,T5,T6,T7,T8,T9,U,V,DLU,DLV
      REAL*8 T10,T11  
      REAL*8 DA6
*
      COMMON /DLIST6/  DA6(51040)
      COMMON /JJ/ JJ
*
      CALL HPOLYC(X)
*
      CALL CHECKB6(I1,I2,I3,I4,I5,I6,J)
*     J = JJ
*
      U  =  DLOG(1.0D0+X)
      V  = -DLOG(1.0D0-X)
      DLU=  DLOG(U)
      DLV=  DLOG(V)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA6((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA6(4640+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLU
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+U**K*DA6(9280+(J-1)*40+K)
3     CONTINUE
      T3=T3*DLU*DLU
      T4=0.0D0
      DO 4 K=1,40
      T4=T4+U**K*DA6(13920+(J-1)*40+K)
4     CONTINUE
      T4=T4*DLU*DLU*DLU
      T5=0.0D0
      DO 5 K=1,40
      T5=T5+U**K*DA6(18560+(J-1)*40+K)
5     CONTINUE
      T5=T5*DLU*DLU*DLU*DLU
      T6=0.0D0
      DO 6 K=1,40
      T6=T6+U**K*DA6(23200+(J-1)*40+K)
6     CONTINUE
      T6=T6*DLU*DLU*DLU*DLU*DLU
      T7=0.0D0
      DO 7 K=1,40
      T7=T7+V**K*DA6(27840+(J-1)*40+K)
7     CONTINUE
      T7=T7
      T8=0.0D0
      DO 8 K=1,40
      T8=T8+V**K*DA6(32480+(J-1)*40+K)
8     CONTINUE
      T8=T8*DLV
      T9=0.0D0
      DO 9 K=1,40
      T9=T9+V**K*DA6(37120+(J-1)*40+K)
9     CONTINUE
      T9=T9*DLV*DLV
      T10=0.0D0
      DO 10 K=1,40
      T10=T10+V**K*DA6(41760+(J-1)*40+K)
10    CONTINUE
      T10=T10*DLV*DLV*DLV
      T11=0.0D0
      DO 11 K=1,40
      T11=T11+V**K*DA6(46400+(J-1)*40+K)
11    CONTINUE
      T11=T11*DLV*DLV*DLV*DLV
*
      H6=T1+T2+T3+T4+T5+T6+T7+T8+T9+T10+T11
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H7(I1,I2,I3,I4,I5,I6,I7,X)
*--------------------------------------------------------------    
*
*     Weight w = 7 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,I3,I4,I5,I6,I7,J,K,JJ
      REAL*8 X,T1,T2,T3,T4,T5,T6,T7,T8,T9,U,V,DLU,DLV
      REAL*8 T10,T11,T12,T13  
      REAL*8 DA7
*
      COMMON /DLIST7/  DA7(162240)
      COMMON /JJ/ JJ
*
      CALL HPOLYC(X)
*
      CALL CHECKB7(I1,I2,I3,I4,I5,I6,I7,J)
*     J = JJ
*
      U  =  DLOG(1.0D0+X)
      V  = -DLOG(1.0D0-X)
      DLU=  DLOG(U)
      DLV=  DLOG(V)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA7((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA7(12480+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLU
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+U**K*DA7(24960+(J-1)*40+K)
3     CONTINUE
      T3=T3*DLU*DLU
      T4=0.0D0
      DO 4 K=1,40
      T4=T4+U**K*DA7(37440+(J-1)*40+K)
4     CONTINUE
      T4=T4*DLU*DLU*DLU
      T5=0.0D0
      DO 5 K=1,40
      T5=T5+U**K*DA7(49920+(J-1)*40+K)
5     CONTINUE
      T5=T5*DLU*DLU*DLU*DLU
      T6=0.0D0
      DO 6 K=1,40
      T6=T6+U**K*DA7(62400+(J-1)*40+K)
6     CONTINUE
      T6=T6*DLU*DLU*DLU*DLU*DLU
      T7=0.0D0
      DO 7 K=1,40
      T7=T7+U**K*DA7(74880+(J-1)*40+K)
7     CONTINUE
      T7=T7*DLU*DLU*DLU*DLU*DLU*DLU
      T8=0.0D0
      DO 8 K=1,40
      T8=T8+V**K*DA7(87360+(J-1)*40+K)
8     CONTINUE
      T8=T8
      T9=0.0D0
      DO 9 K=1,40
      T9=T9+V**K*DA7(99840+(J-1)*40+K)
9     CONTINUE
      T9=T9*DLV
      T10=0.0D0
      DO 10 K=1,40
      T10=T10+V**K*DA7(112320+(J-1)*40+K)
10    CONTINUE
      T10=T10*DLV*DLV
      T11=0.0D0
      DO 11 K=1,40
      T11=T11+V**K*DA7(124800+(J-1)*40+K)
11    CONTINUE
      T11=T11*DLV*DLV*DLV
      T12=0.0D0
      DO 12 K=1,40
      T12=T12+V**K*DA7(137280+(J-1)*40+K)
12    CONTINUE
      T12=T12*DLV*DLV*DLV*DLV
      T13=0.0D0
      DO 13 K=1,40
      T13=T13+V**K*DA7(149760+(J-1)*40+K)
13    CONTINUE
      T13=T13*DLV*DLV*DLV*DLV*DLV
*
      H7=T1+T2+T3+T4+T5+T6+T7+T8+T9+T10+T11+T12+T13
*
      RETURN
      END
*--------------------------------------------------------------    
      REAL*8 FUNCTION H8(I1,I2,I3,I4,I5,I6,I7,I8,X)
*--------------------------------------------------------------    
*
*     Weight w = 8 HPLs     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER I1,I2,I3,I4,I5,I6,I7,I8,J,K,JJ
      REAL*8 X,T1,T2,T3,T4,T5,T6,T7,T8,T9,U,V,DLU,DLV
      REAL*8 T10,T11,T12,T13,T14,T15  
      REAL*8 DA8
*
      COMMON /DLIST8/  DA8(486000)
      COMMON /JJ/ JJ
*
      CALL HPOLYC(X)
*
      CALL CHECKB8(I1,I2,I3,I4,I5,I6,I7,I8,J)
*     J=JJ
*
      U  =  DLOG(1.0D0+X)
      V  = -DLOG(1.0D0-X)
      DLU=  DLOG(U)
      DLV=  DLOG(V)
*
      T1=0.0D0
      DO 1 K=1,40
      T1=T1+U**K*DA8((J-1)*40+K)
1     CONTINUE
      T2=0.0D0
      DO 2 K=1,40
      T2=T2+U**K*DA8(32400+(J-1)*40+K)
2     CONTINUE
      T2=T2*DLU
      T3=0.0D0
      DO 3 K=1,40
      T3=T3+U**K*DA8(64800+(J-1)*40+K)
3     CONTINUE
      T3=T3*DLU*DLU
      T4=0.0D0
      DO 4 K=1,40
      T4=T4+U**K*DA8(97200+(J-1)*40+K)
4     CONTINUE
      T4=T4*DLU*DLU*DLU
      T5=0.0D0
      DO 5 K=1,40
      T5=T5+U**K*DA8(129600+(J-1)*40+K)
5     CONTINUE
      T5=T5*DLU*DLU*DLU*DLU
      T6=0.0D0
      DO 6 K=1,40
      T6=T6+U**K*DA8(162000+(J-1)*40+K)
6     CONTINUE
      T6=T6*DLU*DLU*DLU*DLU*DLU
      T7=0.0D0
      DO 7 K=1,40
      T7=T7+U**K*DA8(194400+(J-1)*40+K)
7     CONTINUE
      T7=T7*DLU*DLU*DLU*DLU*DLU*DLU
      T8=0.0D0
      DO 8 K=1,40
      T8=T8+U**K*DA8(226800+(J-1)*40+K)
8     CONTINUE
      T8=T8*DLU*DLU*DLU*DLU*DLU*DLU*DLU
      T9=0.0D0
      DO 9 K=1,40
      T9=T9+V**K*DA8(259200+(J-1)*40+K)
9     CONTINUE
      T9=T9
      T10=0.0D0
      DO 10 K=1,40
      T10=T10+V**K*DA8(291600+(J-1)*40+K)
10    CONTINUE
      T10=T10*DLV
      T11=0.0D0
      DO 11 K=1,40
      T11=T11+V**K*DA8(324000+(J-1)*40+K)
11    CONTINUE
      T11=T11*DLV*DLV
      T12=0.0D0
      DO 12 K=1,40
      T12=T12+V**K*DA8(356400+(J-1)*40+K)
12    CONTINUE
      T12=T12*DLV*DLV*DLV
      T13=0.0D0
      DO 13 K=1,40
      T13=T13+V**K*DA8(388800+(J-1)*40+K)
13    CONTINUE
      T13=T13*DLV*DLV*DLV*DLV
      T14=0.0D0
      DO 14 K=1,40
      T14=T14+V**K*DA8(421200+(J-1)*40+K)
14    CONTINUE
      T14=T14*DLV*DLV*DLV*DLV*DLV
      T15=0.0D0
      DO 15 K=1,40
      T15=T15+V**K*DA8(453600+(J-1)*40+K)
15    CONTINUE
      T15=T15*DLV*DLV*DLV*DLV*DLV*DLV
*
      H8=T1+T2+T3+T4+T5+T6+T7+T8+T9+T10+T11+T12+T13
     &  +T14+T15
*
      RETURN
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB2(I1,I2,J)
*--------------------------------------------------------------    
*
*     Weight w = 2 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,I1,I2,J,K,L
*        
      DIMENSION II1(3),II2(3)
      DATA II1/0,-1,-1/
      DATA II2/1, 1, 0/
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,3
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K)) J=K
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2 =',I1,I2,'not in basis STOP: H2 ****'
      STOP
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB3(I1,I2,I3,J)
*--------------------------------------------------------------    
*
*     Weight w = 3 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,II3,I1,I2,I3,J,K
*        
      DIMENSION II1(8),II2(8),II3(8)
      DATA II1/0, 0,-1,-1,-1,-1,-1,-1/
      DATA II2/1, 0, 1, 1, 0, 0,-1,-1/
      DATA II3/1, 1, 1, 0, 1, 0, 1, 0/
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,8
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K).AND.
     &I3.EQ.II3(K)) J=K
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2,I3 =',I1,I2,I3,' not in basis STOP:H3 ****'
      STOP
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB4(I1,I2,I3,I4,J)
*--------------------------------------------------------------    
*
*     Weight w = 4 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,II3,II4,I1,I2,I3,I4,J,K
*        
      DIMENSION II1(18),II2(18),II3(18),II4(18)
      DATA II1/0, 0, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1/
      DATA II2/1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0,-1,-1,-1,-1,-1,-1/
      DATA II3/1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0,-1, 1, 1, 0, 0,-1,-1/
      DATA II4/1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0/
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,18
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K).AND.
     &I3.EQ.II3(K).AND.II4(K).EQ.I4) J=K
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2,I3,I4 =',I1,I2,I3,I4,'not in basis STOP:H4 ****'
      STOP
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB5(I1,I2,I3,I4,I5,J)
*--------------------------------------------------------------    
*
*     Weight w = 5 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,II3,II4,II5,I1,I2,I3,I4,I5,J,K
*        
*
      COMMON/BAS5/ II1(48),II2(48),II3(48),II4(48),II5(48)
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,48
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K).AND.
     &I3.EQ.II3(K).AND.II4(K).EQ.I4.AND.II5(K).EQ.I5) J=K
*      WRITE(6,*) 'J,I1,I2,I3,I4,I5 =',J,I1,I2,I3,I4,I5 
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2,I3,I4,I5 =',I1,I2,I3,I4,I5,
     &'not in basis STOP: CHECKB5 ****'
      STOP
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB6(I1,I2,I3,I4,I5,I6,J)
*--------------------------------------------------------------    
*
*     Weight w = 6 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,II3,II4,II5,II6,I1,I2,I3,I4,I5,I6,J,K
*        
*
      COMMON/BAS6/ II1(116),II2(116),II3(116),II4(116),II5(116),
     &             II6(116)
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,116
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K).AND.
     &I3.EQ.II3(K).AND.II4(K).EQ.I4.AND.II5(K).EQ.I5.
     &AND.II6(K).EQ.I6) J=K
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2,I3,I4,I5,I6 =',I1,I2,I3,I4,I5,I6,
     &'not in basis STOP: CHECKB6 ****'
      STOP
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB7(I1,I2,I3,I4,I5,I6,I7,J)
*--------------------------------------------------------------    
*
*     Weight w = 7 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,II3,II4,II5,II6,II7,I1,I2,I3,I4,I5,I6,I7,J,K
*        
*
      COMMON/BAS7/ II1(312),II2(312),II3(312),II4(312),II5(312),
     &             II6(312),II7(312)
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,312
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K).AND.
     &I3.EQ.II3(K).AND.II4(K).EQ.I4.AND.II5(K).EQ.I5.
     &AND.II6(K).EQ.I6.AND.II7(K).EQ.I7) J=K
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2,I3,I4,I5,I6,I7 =',
     &I1,I2,I3,I4,I5,I6,I7,
     &'not in basis STOP: CHECKB7 ****'
      STOP
      END
*--------------------------------------------------------------    
      SUBROUTINE CHECKB8(I1,I2,I3,I4,I5,I6,I7,I8,J)
*--------------------------------------------------------------    
*
*     Weight w = 8 basis check     
*
*--------------------------------------------------------------    
*
      IMPLICIT NONE
*
      INTEGER II1,II2,II3,II4,II5,II6,II7,II8,I1,I2,I3,I4,I5,I6
      INTEGER I7,I8,J,K
*        
*
      COMMON/BAS8/ II1(810),II2(810),II3(810),II4(810),II5(810),
     &             II6(810),II7(810),II8(810)
*
*     columns denote the HPL index pattern
*
*
      J = 0
      DO 1 K=1,810
      IF(I1.EQ.II1(K).AND.I2.EQ.II2(K).AND.
     &I3.EQ.II3(K).AND.II4(K).EQ.I4.AND.II5(K).EQ.I5.
     &AND.II6(K).EQ.I6.AND.II7(K).EQ.I7.AND.
     &II8(K).EQ.I8) J=K
1     CONTINUE
      IF(J.EQ.0) GOTO 10
*
      RETURN
*
10    WRITE(6,*) 'I1,I2,I3,I4,I5,I6,I7,I8 =',
     &I1,I2,I3,I4,I5,I6,I7,I8,
     &'not in basis STOP: CHECKB8 ****'
      STOP
      END
