      MODULE XC2GL3E
      CONTAINS
*     
* ..File: xc2gl3e.f    F2_G
*
*
* ..The exact 3-loop MS(bar) gluonic coefficient functions for the 
*    structure function F_2 in electromagnetic DIS at mu_r = mu_f = Q. 
*    Expansion parameter: alpha_s/(4 pi).
* 
* ..The distributions (in the mathematical sense) are given as in eq.
*    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.
*    The name-endings A, B, and C of the functions below correspond to 
*    the kernel superscripts [2], [3], and [1] in that equation.
*
* ..The code uses the package of Gehrmann and Remiddi for the harmonic
*    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296,
*    upgraded to weight 5 (T. Gehrmann, private communication).
*
* ..Reference: J. Vermaseren, A. Vogt and S. Moch
*              hep-ph/0504242 = Nucl. Phys. B724 (2005) 3
*
* =====================================================================
*
*
* ..There is only a regular piece. 
*
       FUNCTION X2G3A (X, NF, CC)
*
       IMPLICIT REAL*8 (A - Z)
       COMPLEX*16 HC1, HC2, HC3, HC4, HC5
       INTEGER NF, NF2, N1, N2, NW, CC
       PARAMETER ( N1 = -1, N2 = 1, NW = 5 )
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),
     ,           HC4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HC5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),
     ,           HR4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HR5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),
     ,           HI4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HI5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0,
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
       DIMENSION FLG(6)
       DATA FLG / 1.d0, 0.1d0, 0.d0, 0.1d0, 0.01818181818d0, 0.1d0 /
*
* ...Colour factors and abbreviations
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
       DABC2A = 5./48.D0 * NF2
* 
       FLG11 = FLG(NF)
*
* ...Some abbreviations
*
       DX = 1.D0/X
       DM = 1.D0/(1.D0-X)
       DP = 1.D0/(1.D0+X)
       DL  = LOG(X)
       DL1 = LOG(1.D0-X)
*
* ...Harmonic polylogs (HPLs) up to weight 5 by Gehrmann and Remiddi
*
       CALL HPLOG5 (X, NW, HC1,HC2,HC3,HC4,HC5, HR1,HR2,HR3,HR4,HR5,
     ,             HI1,HI2,HI3,HI4,HI5, N1, N2)
*
* ...The coefficient function in terms of the HPLs, flg11 part
*
       if(CC.eq.0) then
      c2gg3 =
     &  + flg11*dabc2a * (  - 4288.D0/225.D0 - 45184.D0/75.D0*x + 51968.
     &    D0/75.D0*x**2 - 3808.D0/15.D0*z4 + 53248.D0/15.D0*z4*x - 
     &    56576.D0/15.D0*z4*x**2 + 21504.D0/5.D0*z4*x**3 + 1696.D0/225.D
     &    0*dx + 1568.D0/5.D0*dp*z4 - 896.D0/15.D0*dm*z4 + 448.D0/15.D0
     &    *z3 - 20608.D0/15.D0*z3*x - 63392.D0/45.D0*z3*x**2 - 6272.D0/
     &    5.D0*z3*x**3 + 896.D0/15.D0*z3*dx + 10048.D0/225.D0*z2 - 
     &    50048.D0/75.D0*z2*x - 167552.D0/75.D0*z2*x**2 - 1152.D0/5.D0*
     &    z2*x**3 + 7168.D0/225.D0*z2*dx - 1024.D0/45.D0*z2*dp + 1024.D0
     &    /3.D0*Hr1(-1)*z3 + 3584.D0/3.D0*Hr1(-1)*z3*x + 3328.D0/3.D0*
     &    Hr1(-1)*z3*x**2 + 25024.D0/15.D0*Hr1(-1)*z2 + 9344.D0/15.D0*
     &    Hr1(-1)*z2*x - 13216.D0/45.D0*Hr1(-1)*z2*x**2 + 18816.D0/25.D0
     &    *Hr1(-1)*z2*x**3 + 1568.D0/75.D0*Hr1(-1)*z2*dx**2 + 832.D0/
     &    225.D0*Hr1(0) - 86272.D0/225.D0*Hr1(0)*x + 28928.D0/15.D0*
     &    Hr1(0)*x**2 - 1696.D0/225.D0*Hr1(0)*dx - 512.D0/45.D0*Hr1(0)*
     &    dp + 896.D0/15.D0*Hr1(0)*z3 + 5632.D0/3.D0*Hr1(0)*z3*x - 
     &    38528.D0/15.D0*Hr1(0)*z3*x**2 )
      c2gg3 = c2gg3 + flg11*dabc2a * ( 10752.D0/5.D0*Hr1(0)*z3*x**3 + 
     &    1792.D0/15.D0*Hr1(0)*z3*dp - 896.D0/5.D0*Hr1(0)*z3*dm - 448.D0
     &    /15.D0*Hr1(0)*z2 - 36224.D0/15.D0*Hr1(0)*z2*x + 36160.D0/9.D0
     &    *Hr1(0)*z2*x**2 - 25088.D0/25.D0*Hr1(0)*z2*x**3 - 896.D0/15.D0
     &    *Hr1(0)*z2*dx + 80704.D0/225.D0*Hr1(1) - 600064.D0/225.D0*
     &    Hr1(1)*x + 164992.D0/75.D0*Hr1(1)*x**2 - 1024.D0*Hr1(1)*z4 + 
     &    5120.D0*Hr1(1)*z4*x - 4608.D0*Hr1(1)*z4*x**2 + 10304.D0/225.D0
     &    *Hr1(1)*dx - 896.D0*Hr1(1)*z3 + 2560.D0/3.D0*Hr1(1)*z3*x - 
     &    640.D0*Hr1(1)*z3*x**2 + 10752.D0/5.D0*Hr1(1)*z3*x**3 - 896.D0/
     &    15.D0*Hr1(1)*z3*dx**2 + 34624.D0/45.D0*Hr1(1)*z2 - 11136.D0/5.
     &    D0*Hr1(1)*z2*x + 70816.D0/45.D0*Hr1(1)*z2*x**2 - 6272.D0/25.D0
     &    *Hr1(1)*z2*x**3 + 1568.D0/225.D0*Hr1(1)*z2*dx**2 - 1024.D0/3.D
     &    0*Hr2(-1,-1)*z2 - 3584.D0/3.D0*Hr2(-1,-1)*z2*x - 3328.D0/3.D0
     &    *Hr2(-1,-1)*z2*x**2 - 468832.D0/225.D0*Hr2(-1,0) - 569152.D0/
     &    225.D0*Hr2(-1,0)*x - 84032.D0/75.D0*Hr2(-1,0)*x**2 - 1152.D0/
     &    5.D0*Hr2(-1,0)*x**3 )
      c2gg3 = c2gg3 + flg11*dabc2a * (  - 3136.D0/225.D0*Hr2(-1,0)*dx
     &     - 32.D0/5.D0*Hr2(-1,0)*dx**2 + 512.D0/3.D0*Hr2(-1,0)*z2 + 
     &    2560.D0/3.D0*Hr2(-1,0)*z2*x + 2816.D0/3.D0*Hr2(-1,0)*z2*x**2
     &     + 6784.D0/15.D0*Hr2(0,-1)*z2 - 22784.D0/15.D0*Hr2(0,-1)*z2*x
     &     + 28928.D0/15.D0*Hr2(0,-1)*z2*x**2 + 3584.D0/15.D0*Hr2(0,-1)
     &    *z2*dm + 288.D0/25.D0*Hr2(0,0) + 154624.D0/75.D0*Hr2(0,0)*x
     &     + 22784.D0/25.D0*Hr2(0,0)*x**2 + 1152.D0/5.D0*Hr2(0,0)*x**3
     &     + 3136.D0/225.D0*Hr2(0,0)*dx + 512.D0/45.D0*Hr2(0,0)*dp + 
     &    1792.D0/15.D0*Hr2(0,0)*z2 - 5888.D0/15.D0*Hr2(0,0)*z2*x + 
     &    43904.D0/15.D0*Hr2(0,0)*z2*x**2 - 10752.D0/5.D0*Hr2(0,0)*z2*
     &    x**3 + 896.D0/15.D0*Hr2(0,0)*z2*dp - 896.D0/5.D0*Hr2(0,0)*z2*
     &    dm - 10048.D0/225.D0*Hr2(0,1) - 419008.D0/225.D0*Hr2(0,1)*x
     &     + 167552.D0/75.D0*Hr2(0,1)*x**2 - 10304.D0/225.D0*Hr2(0,1)*
     &    dx + 1024.D0/45.D0*Hr2(0,1)*dp - 512.D0*Hr2(0,1)*z3 + 2560.D0
     &    *Hr2(0,1)*z3*x - 2304.D0*Hr2(0,1)*z3*x**2 + 1152.D0/5.D0*Hr2(
     &    0,1)*z2 )
      c2gg3 = c2gg3 + flg11*dabc2a * (  - 4352.D0/15.D0*Hr2(0,1)*z2*x
     &     + 4352.D0/15.D0*Hr2(0,1)*z2*x**2 + 1216.D0/3.D0*Hr2(1,0) - 
     &    6656.D0/3.D0*Hr2(1,0)*x + 5824.D0/3.D0*Hr2(1,0)*x**2 - 512.D0
     &    *Hr2(1,0)*z3 + 2560.D0*Hr2(1,0)*z3*x - 2304.D0*Hr2(1,0)*z3*
     &    x**2 + 1920.D0*Hr2(1,0)*z2 - 16384.D0/3.D0*Hr2(1,0)*z2*x + 
     &    5504.D0*Hr2(1,0)*z2*x**2 - 10752.D0/5.D0*Hr2(1,0)*z2*x**3 + 
     &    896.D0/15.D0*Hr2(1,0)*z2*dx**2 + 2432.D0/3.D0*Hr2(1,1) - 
     &    13312.D0/3.D0*Hr2(1,1)*x + 11648.D0/3.D0*Hr2(1,1)*x**2 - 1024.
     &    D0*Hr2(1,1)*z3 + 5120.D0*Hr2(1,1)*z3*x - 4608.D0*Hr2(1,1)*z3*
     &    x**2 + 1024.D0/3.D0*Hr2(1,1)*z2 - 3584.D0/3.D0*Hr2(1,1)*z2*x
     &     + 3328.D0/3.D0*Hr2(1,1)*z2*x**2 + 69248.D0/45.D0*Hr3(-1,-1,0
     &    ) + 22272.D0/5.D0*Hr3(-1,-1,0)*x + 141632.D0/45.D0*Hr3(-1,-1,
     &    0)*x**2 + 12544.D0/25.D0*Hr3(-1,-1,0)*x**3 + 3136.D0/225.D0*
     &    Hr3(-1,-1,0)*dx**2 - 54848.D0/45.D0*Hr3(-1,0,0) - 21376.D0/15.
     &    D0*Hr3(-1,0,0)*x - 640.D0*Hr3(-1,0,0)*x**2 - 12544.D0/25.D0*
     &    Hr3(-1,0,0)*x**3 )
      c2gg3 = c2gg3 + flg11*dabc2a * (  - 3136.D0/225.D0*Hr3(-1,0,0)*
     &    dx**2 - 40448.D0/45.D0*Hr3(-1,0,1) + 24064.D0/15.D0*Hr3(-1,0,
     &    1)*x + 84032.D0/45.D0*Hr3(-1,0,1)*x**2 - 12544.D0/25.D0*Hr3(
     &    -1,0,1)*x**3 - 3136.D0/225.D0*Hr3(-1,0,1)*dx**2 - 640.D0*Hr3(
     &    0,-1,0) - 7936.D0/15.D0*Hr3(0,-1,0)*x - 141632.D0/45.D0*Hr3(0
     &    ,-1,0)*x**2 - 12544.D0/25.D0*Hr3(0,-1,0)*x**3 + 7936.D0/15.D0
     &    *Hr3(0,0,0)*x + 12544.D0/25.D0*Hr3(0,0,0)*x**3 + 448.D0/15.D0
     &    *Hr3(0,0,1) + 28288.D0/15.D0*Hr3(0,0,1)*x - 36160.D0/9.D0*
     &    Hr3(0,0,1)*x**2 + 12544.D0/25.D0*Hr3(0,0,1)*x**3 + 896.D0/15.D
     &    0*Hr3(0,0,1)*dx + 512.D0*Hr3(0,1,0)*z2 - 2560.D0*Hr3(0,1,0)*
     &    z2*x + 2304.D0*Hr3(0,1,0)*z2*x**2 - 5248.D0/15.D0*Hr3(1,0,0)
     &     - 2304.D0/5.D0*Hr3(1,0,0)*x + 7552.D0/5.D0*Hr3(1,0,0)*x**2
     &     - 896.D0/15.D0*Hr3(1,0,0)*dx + 512.D0*Hr3(1,0,0)*z2 - 2560.D0
     &    *Hr3(1,0,0)*z2*x + 2304.D0*Hr3(1,0,0)*z2*x**2 + 1024.D0*Hr3(1
     &    ,1,0)*z2 - 5120.D0*Hr3(1,1,0)*z2*x + 4608.D0*Hr3(1,1,0)*z2*
     &    x**2 )
      c2gg3 = c2gg3 + flg11*dabc2a * (  - 2048.D0/3.D0*Hr4(-1,-1,-1,0)
     &     - 7168.D0/3.D0*Hr4(-1,-1,-1,0)*x - 6656.D0/3.D0*Hr4(-1,-1,-1
     &    ,0)*x**2 + 1024.D0/3.D0*Hr4(-1,-1,0,0) + 3584.D0/3.D0*Hr4(-1,
     &    -1,0,0)*x + 3328.D0/3.D0*Hr4(-1,-1,0,0)*x**2 + 1024.D0/3.D0*
     &    Hr4(-1,0,-1,0) + 3584.D0/3.D0*Hr4(-1,0,-1,0)*x + 3328.D0/3.D0
     &    *Hr4(-1,0,-1,0)*x**2 - 512.D0/3.D0*Hr4(-1,0,0,0) - 2560.D0/3.D
     &    0*Hr4(-1,0,0,0)*x - 2816.D0/3.D0*Hr4(-1,0,0,0)*x**2 + 2304.D0/
     &    5.D0*Hr4(0,-1,-1,0) + 8704.D0/15.D0*Hr4(0,-1,-1,0)*x + 8704.D0
     &    /15.D0*Hr4(0,-1,-1,0)*x**2 - 1024.D0/3.D0*Hr4(0,-1,0,0) + 
     &    3072.D0/5.D0*Hr4(0,-1,0,0)*x - 3328.D0/3.D0*Hr4(0,-1,0,0)*
     &    x**2 - 1792.D0/15.D0*Hr4(0,-1,0,0)*dm - 3328.D0/15.D0*Hr4(0,
     &    -1,0,1) + 27136.D0/15.D0*Hr4(0,-1,0,1)*x - 8192.D0/5.D0*Hr4(0
     &    ,-1,0,1)*x**2 - 3584.D0/15.D0*Hr4(0,-1,0,1)*dm - 1792.D0/15.D0
     &    *Hr4(0,0,-1,0) + 512.D0/5.D0*Hr4(0,0,-1,0)*x + 19456.D0/15.D0
     &    *Hr4(0,0,-1,0)*x**2 + 1792.D0/15.D0*Hr4(0,0,-1,0)*dp - 512.D0/
     &    5.D0*Hr4(0,0,0,0)*x )
      c2gg3 = c2gg3 + flg11*dabc2a * (  - 896.D0/15.D0*Hr4(0,0,0,0)*dp
     &     + 896.D0/15.D0*Hr4(0,0,0,0)*dm - 1792.D0/15.D0*Hr4(0,0,0,1)
     &     + 7424.D0/15.D0*Hr4(0,0,0,1)*x - 43904.D0/15.D0*Hr4(0,0,0,1)
     &    *x**2 + 10752.D0/5.D0*Hr4(0,0,0,1)*x**3 + 1792.D0/15.D0*Hr4(0
     &    ,0,0,1)*dm - 3328.D0/3.D0*Hr4(0,1,0,0)*x + 3456.D0*Hr4(0,1,0,
     &    0)*x**2 - 10752.D0/5.D0*Hr4(0,1,0,0)*x**3 - 512.D0*Hr4(1,0,-1
     &    ,0)*x + 768.D0*Hr4(1,0,-1,0)*x**2 - 512.D0/3.D0*Hr4(1,0,0,0)
     &     + 2560.D0/3.D0*Hr4(1,0,0,0)*x - 2816.D0/3.D0*Hr4(1,0,0,0)*
     &    x**2 - 5248.D0/3.D0*Hr4(1,0,0,1) + 4608.D0*Hr4(1,0,0,1)*x - 
     &    13696.D0/3.D0*Hr4(1,0,0,1)*x**2 + 10752.D0/5.D0*Hr4(1,0,0,1)*
     &    x**3 - 896.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 1408.D0*Hr4(1,1,0,0)
     &     - 10240.D0/3.D0*Hr4(1,1,0,0)*x + 3456.D0*Hr4(1,1,0,0)*x**2
     &     - 10752.D0/5.D0*Hr4(1,1,0,0)*x**3 + 896.D0/15.D0*Hr4(1,1,0,0
     &    )*dx**2 - 512.D0*Hr5(0,1,0,0,1) + 2560.D0*Hr5(0,1,0,0,1)*x - 
     &    2304.D0*Hr5(0,1,0,0,1)*x**2 + 512.D0*Hr5(0,1,1,0,0) - 2560.D0
     &    *Hr5(0,1,1,0,0)*x )
      c2gg3 = c2gg3 + flg11*dabc2a * ( 2304.D0*Hr5(0,1,1,0,0)*x**2 - 
     &    512.D0*Hr5(1,0,0,0,1) + 2560.D0*Hr5(1,0,0,0,1)*x - 2304.D0*
     &    Hr5(1,0,0,0,1)*x**2 + 512.D0*Hr5(1,0,1,0,0) - 2560.D0*Hr5(1,0
     &    ,1,0,0)*x + 2304.D0*Hr5(1,0,1,0,0)*x**2 - 1024.D0*Hr5(1,1,0,0
     &    ,1) + 5120.D0*Hr5(1,1,0,0,1)*x - 4608.D0*Hr5(1,1,0,0,1)*x**2
     &     + 1024.D0*Hr5(1,1,1,0,0) - 5120.D0*Hr5(1,1,1,0,0)*x + 4608.D0
     &    *Hr5(1,1,1,0,0)*x**2 )
*
* ...The `special' contributions to the flg11 part.
*
      SP1 =
     &  + dm * (  - 6.D0*z3 + 4.D0/5.D0*z2**2 + 8.D0*Hr1(-1)*z2 + 6.D0*
     &    Hr1(0)*z3 - 6.D0*Hr1(0)*z2 - 8.D0*Hr2(0,-1)*z2 + 6.D0*Hr2(0,0
     &    )*z2 - 4.D0*Hr3(-1,0,0) - 8.D0*Hr3(-1,0,1) + 2.D0*Hr3(0,0,0)
     &     + 4.D0*Hr3(0,0,1) + 4.D0*Hr4(0,-1,0,0) + 8.D0*Hr4(0,-1,0,1)
     &     - 2.D0*Hr4(0,0,0,0) - 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + dm**2 * (  - 4.D0/5.D0*z2**2 - 6.D0*Hr1(0)*z3 + 8.D0*
     &    Hr2(0,-1)*z2 - 6.D0*Hr2(0,0)*z2 - 4.D0*Hr4(0,-1,0,0) - 8.D0*
     &    Hr4(0,-1,0,1) + 2.D0*Hr4(0,0,0,0) + 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + 2.D0*z3 + 4.D0*z3*dp - 21.D0/5.D0*z2**2*dp + 21.D0/5.D
     &    0*z2**2*dp**2 - 8.D0*Hr1(-1)*z2 - 4.D0*Hr1(0)*z3*dp + 4.D0*
     &    Hr1(0)*z3*dp**2 + 4.D0*Hr1(0)*z2 + 2.D0*Hr1(0)*z2*dp - 2.D0*
     &    Hr2(0,0)*z2*dp + 2.D0*Hr2(0,0)*z2*dp**2 + 4.D0*Hr3(-1,0,0) +
     &    8.D0*Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 4.D0*Hr3(0,-1,0)*dp - 2.
     &    D0*Hr3(0,0,0)*dp - 4.D0*Hr3(0,0,1) - 4.D0*Hr4(0,0,-1,0)*dp +
     &    4.D0*Hr4(0,0,-1,0)*dp**2 + 2.D0*Hr4(0,0,0,0)*dp - 2.D0*Hr4(0,
     &    0,0,0)*dp**2
       if (x .gt. 0.99995D0) then 
         SP1 = x*(z2+z3) 
* ...For 5-digit accuracy down to x=0.9
c    ,         + (1.-x)**2 * (-0.5*DL1-0.25*z2-0.5*z3+5./8.d0)
       endif
*
      SP2 =
     &  + dm * (  - 18.D0*z3 + 2.D0*z2 + 8.D0/5.D0*z2**2 + 24.D0*Hr1(-1
     &    )*z2 + 12.D0*Hr1(0)*z3 - 18.D0*Hr1(0)*z2 - 16.D0*Hr2(0,-1)*z2
     &     + 12.D0*Hr2(0,0)*z2 - 12.D0*Hr3(-1,0,0) - 24.D0*Hr3(-1,0,1)
     &     + 6.D0*Hr3(0,0,0) + 12.D0*Hr3(0,0,1) + 8.D0*Hr4(0,-1,0,0) +
     &    16.D0*Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2 = SP2 + dm**2 * ( 12.D0*z3 - 16.D0/5.D0*z2**2 - 16.D0*Hr1(-1)
     &    *z2 - 24.D0*Hr1(0)*z3 + 12.D0*Hr1(0)*z2 + 32.D0*Hr2(0,-1)*z2
     &     - 24.D0*Hr2(0,0)*z2 + 8.D0*Hr3(-1,0,0) + 16.D0*Hr3(-1,0,1)
     &     - 4.D0*Hr3(0,0,0) - 8.D0*Hr3(0,0,1) - 16.D0*Hr4(0,-1,0,0) -
     &    32.D0*Hr4(0,-1,0,1) + 8.D0*Hr4(0,0,0,0) + 16.D0*Hr4(0,0,0,1)
     &     )
      SP2 = SP2 + dm**3 * ( 8.D0/5.D0*z2**2 + 12.D0*Hr1(0)*z3 - 16.D0*
     &    Hr2(0,-1)*z2 + 12.D0*Hr2(0,0)*z2 + 8.D0*Hr4(0,-1,0,0) + 16.D0
     &    *Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2 = SP2 + 2.D0*z3 + 12.D0*z3*dp - 8.D0*z3*dp**2 + 4.D0*z2 - 6.D0
     &    *z2*dp - 42.D0/5.D0*z2**2*dp + 84.D0/5.D0*z2**2*dp**2 - 42.D0/
     &    5.D0*z2**2*dp**3 - 8.D0*Hr1(-1)*z2 - 8.D0*Hr1(0)*z3*dp + 16.D0
     &    *Hr1(0)*z3*dp**2 - 8.D0*Hr1(0)*z3*dp**3 + 4.D0*Hr1(0)*z2 + 6.D
     &    0*Hr1(0)*z2*dp - 4.D0*Hr1(0)*z2*dp**2 + 4.D0*Hr2(-1,0) - 4.D0
     &    *Hr2(-1,0)*dp - 4.D0*Hr2(0,0) + 4.D0*Hr2(0,0)*dp - 4.D0*Hr2(0
     &    ,0)*z2*dp + 8.D0*Hr2(0,0)*z2*dp**2 - 4.D0*Hr2(0,0)*z2*dp**3
     &     - 4.D0*Hr2(0,1) + 4.D0*Hr2(0,1)*dp + 4.D0*Hr3(-1,0,0) + 8.D0
     &    *Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 12.D0*Hr3(0,-1,0)*dp - 8.D0
     &    *Hr3(0,-1,0)*dp**2 - 6.D0*Hr3(0,0,0)*dp + 4.D0*Hr3(0,0,0)*
     &    dp**2 - 4.D0*Hr3(0,0,1) - 8.D0*Hr4(0,0,-1,0)*dp + 16.D0*Hr4(0
     &    ,0,-1,0)*dp**2 - 8.D0*Hr4(0,0,-1,0)*dp**3 + 4.D0*Hr4(0,0,0,0)
     &    *dp - 8.D0*Hr4(0,0,0,0)*dp**2 + 4.D0*Hr4(0,0,0,0)*dp**3
       if (x .gt. 0.995D0) then
         SP2 =    (1.-x)* (-DL1-0.5*z2-z3+0.75D0)
     ,          + (1.-x)**2 * (-0.5)
* ...For 5-digit accuracy down to x=0.9
c    ,          + (1.-x)**3 * (DL1/3.d0+z2/18.d0+z3/3.d0-0.75)
c    ,          + (1.-x)**4 * (DL1/3.d0+z2/18.d0+z3/3.d0-0.5)
c    ,          + (1.-x)**5 * (31./120.d0*DL1+17./360.d0*z2+7./30.d0*z3
c    ,                         -1103./4800.d0)
       endif
*
      SP3 =
     &  + dm * ( 66.D0*z3 - 8.D0*z2 - 24.D0/5.D0*z2**2 - 88.D0*Hr1(-1)*
     &    z2 - 36.D0*Hr1(0)*z3 + 66.D0*Hr1(0)*z2 + 48.D0*Hr2(0,-1)*z2
     &     - 2.D0*Hr2(0,0) - 36.D0*Hr2(0,0)*z2 - 4.D0*Hr2(0,1) + 44.D0*
     &    Hr3(-1,0,0) + 88.D0*Hr3(-1,0,1) - 22.D0*Hr3(0,0,0) - 44.D0*
     &    Hr3(0,0,1) - 24.D0*Hr4(0,-1,0,0) - 48.D0*Hr4(0,-1,0,1) + 12.D0
     &    *Hr4(0,0,0,0) + 24.D0*Hr4(0,0,0,1) )
      SP3 = SP3 + dm**2 * (  - 90.D0*z3 + 6.D0*z2 + 72.D0/5.D0*z2**2 +
     &    120.D0*Hr1(-1)*z2 + 108.D0*Hr1(0)*z3 - 90.D0*Hr1(0)*z2 - 144.D
     &    0*Hr2(0,-1)*z2 + 108.D0*Hr2(0,0)*z2 - 60.D0*Hr3(-1,0,0) - 120.
     &    D0*Hr3(-1,0,1) + 30.D0*Hr3(0,0,0) + 60.D0*Hr3(0,0,1) + 72.D0*
     &    Hr4(0,-1,0,0) + 144.D0*Hr4(0,-1,0,1) - 36.D0*Hr4(0,0,0,0) -
     &    72.D0*Hr4(0,0,0,1) )
      SP3 = SP3 + dm**3 * ( 36.D0*z3 - 72.D0/5.D0*z2**2 - 48.D0*Hr1(-1)
     &    *z2 - 108.D0*Hr1(0)*z3 + 36.D0*Hr1(0)*z2 + 144.D0*Hr2(0,-1)*
     &    z2 - 108.D0*Hr2(0,0)*z2 + 24.D0*Hr3(-1,0,0) + 48.D0*Hr3(-1,0,
     &    1) - 12.D0*Hr3(0,0,0) - 24.D0*Hr3(0,0,1) - 72.D0*Hr4(0,-1,0,0
     &    ) - 144.D0*Hr4(0,-1,0,1) + 36.D0*Hr4(0,0,0,0) + 72.D0*Hr4(0,0
     &    ,0,1) )
      SP3 = SP3 + dm**4 * ( 24.D0/5.D0*z2**2 + 36.D0*Hr1(0)*z3 - 48.D0*
     &    Hr2(0,-1)*z2 + 36.D0*Hr2(0,0)*z2 + 24.D0*Hr4(0,-1,0,0) + 48.D0
     &    *Hr4(0,-1,0,1) - 12.D0*Hr4(0,0,0,0) - 24.D0*Hr4(0,0,0,1) )
      SP3 = SP3 - 4.D0*z3 - 44.D0*z3*dp + 60.D0*z3*dp**2 - 24.D0*z3*
     &    dp**3 - 12.D0*z2 + 24.D0*z2*dp - 10.D0*z2*dp**2 + 126.D0/5.D0
     &    *z2**2*dp - 378.D0/5.D0*z2**2*dp**2 + 378.D0/5.D0*z2**2*dp**3
     &     - 126.D0/5.D0*z2**2*dp**4 + 16.D0*Hr1(-1)*z2 - 4.D0*Hr1(0)*
     &    dp + 4.D0*Hr1(0)*dp**2 + 24.D0*Hr1(0)*z3*dp - 72.D0*Hr1(0)*z3
     &    *dp**2 + 72.D0*Hr1(0)*z3*dp**3 - 24.D0*Hr1(0)*z3*dp**4 - 8.D0
     &    *Hr1(0)*z2 - 22.D0*Hr1(0)*z2*dp + 30.D0*Hr1(0)*z2*dp**2 - 12.D
     &    0*Hr1(0)*z2*dp**3 - 4.D0*Hr1(1) + 4.D0*Hr1(1)*dp - 12.D0*Hr2(
     &    -1,0) + 24.D0*Hr2(-1,0)*dp - 12.D0*Hr2(-1,0)*dp**2 + 12.D0*
     &    Hr2(0,0) - 18.D0*Hr2(0,0)*dp + 8.D0*Hr2(0,0)*dp**2 + 12.D0*
     &    Hr2(0,0)*z2*dp - 36.D0*Hr2(0,0)*z2*dp**2 + 36.D0*Hr2(0,0)*z2*
     &    dp**3 - 12.D0*Hr2(0,0)*z2*dp**4 + 12.D0*Hr2(0,1) - 12.D0*Hr2(
     &    0,1)*dp + 4.D0*Hr2(0,1)*dp**2 - 8.D0*Hr3(-1,0,0) - 16.D0*Hr3(
     &    -1,0,1) + 8.D0*Hr3(0,-1,0) - 44.D0*Hr3(0,-1,0)*dp + 60.D0*
     &    Hr3(0,-1,0)*dp**2 - 24.D0*Hr3(0,-1,0)*dp**3 + 22.D0*Hr3(0,0,0
     &    )*dp
      SP3 = SP3 - 30.D0*Hr3(0,0,0)*dp**2 + 12.D0*Hr3(0,0,0)*dp**3 + 8.D0
     &    *Hr3(0,0,1) + 24.D0*Hr4(0,0,-1,0)*dp - 72.D0*Hr4(0,0,-1,0)*
     &    dp**2 + 72.D0*Hr4(0,0,-1,0)*dp**3 - 24.D0*Hr4(0,0,-1,0)*dp**4
     &     - 12.D0*Hr4(0,0,0,0)*dp + 36.D0*Hr4(0,0,0,0)*dp**2 - 36.D0*
     &    Hr4(0,0,0,0)*dp**3 + 12.D0*Hr4(0,0,0,0)*dp**4
       if (x .gt. 0.992D0) then
         SP3 = - (-DL1-0.5*z2-z3-0.25) 
     ,         - (1.-x) * (-DL1-0.5*z2-z3+0.75)
     ,         - (1.-x)**2 * (DL1+z2/6.d0+z3-23./12.d0)
* ...For 5-digit accuracy down to x=0.9
c    ,         - (1.-x)**3 * (DL1+z2/6.d0+z3-5./4.d0)
c    ,         - (1.-x)**4 * (5./8.d0*DL1+z2/8.d0+z3/2.d0-43./192.d0)
       endif
      SPX =
     &  + 2.D0 - 2.D0*dp + 4.D0*z2*dp - 4.D0*z2*dp**2 - 2.D0*Hr1(0) + 4.
     &    D0*Hr1(0)*dp - 2.D0*Hr1(0)*dp**2 - 4.D0*Hr1(1) + 4.D0*Hr1(1)*
     &    dp - 2.D0*Hr2(0,0)*dp + 2.D0*Hr2(0,0)*dp**2 - 4.D0*Hr2(0,1)*
     &    dp + 4.D0*Hr2(0,1)*dp**2
*
       C2GG3 = 64./45.D0 * (27.* SP1 - 6.* SP2 - SP3 + SPX)* 
     ,         DABC2A * FLG11 + C2GG3
       X2G3A = C2GG3
       endif
*
* ...The coefficient function in terms of the HPLs, standard parts
*
       if(CC.eq.1) then
      c2gg3 = nf*ca**2 * ( 271171.D0/486.D0 + 2812798.D0/243.D0
     &    *x - 79819747.D0/7290.D0*x**2 - 2612.D0/3.D0*z5 - 1624.D0*z5*
     &    x - 1744.D0/3.D0*z5*x**2 + 227.D0/3.D0*z4 + 17690.D0/9.D0*z4*
     &    x - 4936.D0/3.D0*z4*x**2 - 2592.D0/5.D0*z4*x**3 - 5017249.D0/
     &    3645.D0*dx + 1984.D0/9.D0*dx*z4 - 5302.D0/15.D0*z3 - 30292.D0/
     &    9.D0*z3*x + 82799.D0/15.D0*z3*x**2 + 60.D0*z3*x**3 + 1904.D0/
     &    27.D0*z3*dx - 1628.D0/3.D0*z2 - 3029684.D0/405.D0*z2*x + 
     &    2479774.D0/405.D0*z2*x**2 + 228.D0/5.D0*z2*x**3 + 80588.D0/
     &    405.D0*z2*dx + 644.D0/3.D0*z2*z3 + 1448.D0*z2*z3*x - 688.D0/3.
     &    D0*z2*z3*x**2 + 340.D0/3.D0*Hr1(-1)*z4 + 1832.D0/3.D0*Hr1(-1)
     &    *z4*x + 1484.D0/3.D0*Hr1(-1)*z4*x**2 + 2120.D0/3.D0*Hr1(-1)*
     &    z3 + 772.D0/3.D0*Hr1(-1)*z3*x - 532.D0*Hr1(-1)*z3*x**2 + 576.D
     &    0/5.D0*Hr1(-1)*z3*x**3 + 48.D0*Hr1(-1)*z3*dx + 16.D0/5.D0*
     &    Hr1(-1)*z3*dx**2 - 8836.D0/45.D0*Hr1(-1)*z2 - 15512.D0/15.D0*
     &    Hr1(-1)*z2*x - 105449.D0/135.D0*Hr1(-1)*z2*x**2 - 36.D0*Hr1(
     &    -1)*z2*x**3 )
      c2gg3 = c2gg3 + nf*ca**2 * ( 42976.D0/135.D0*Hr1(-1)*z2*dx - Hr1(
     &    -1)*z2*dx**2 - 3220177.D0/1215.D0*Hr1(0) + 13320758.D0/1215.D0
     &    *Hr1(0)*x - 13259914.D0/1215.D0*Hr1(0)*x**2 - 608.D0/3.D0*
     &    Hr1(0)*z4 + 4984.D0/3.D0*Hr1(0)*z4*x - 920.D0/3.D0*Hr1(0)*z4*
     &    x**2 - 195577.D0/1215.D0*Hr1(0)*dx - 416.D0/9.D0*Hr1(0)*z3 - 
     &    53144.D0/9.D0*Hr1(0)*z3*x + 19496.D0/9.D0*Hr1(0)*z3*x**2 - 
     &    384.D0*Hr1(0)*z3*x**3 - 128.D0/9.D0*Hr1(0)*z3*dx + 33848.D0/
     &    45.D0*Hr1(0)*z2 - 242624.D0/45.D0*Hr1(0)*z2*x + 881432.D0/135.
     &    D0*Hr1(0)*z2*x**2 + 48.D0*Hr1(0)*z2*x**3 + 2128.D0/45.D0*Hr1(
     &    0)*z2*dx - 311806.D0/243.D0*Hr1(1) + 2653214.D0/243.D0*Hr1(1)
     &    *x - 12973432.D0/1215.D0*Hr1(1)*x**2 + 32.D0*Hr1(1)*z4 - 64.D0
     &    *Hr1(1)*z4*x - 20.D0*Hr1(1)*z4*x**2 + 306254.D0/405.D0*Hr1(1)
     &    *dx + 2444.D0/3.D0*Hr1(1)*z3 - 6152.D0/3.D0*Hr1(1)*z3*x + 
     &    16340.D0/9.D0*Hr1(1)*z3*x**2 - 1344.D0/5.D0*Hr1(1)*z3*x**3 - 
     &    944.D0/9.D0*Hr1(1)*z3*dx + 112.D0/15.D0*Hr1(1)*z3*dx**2 - 
     &    2110.D0/27.D0*Hr1(1)*z2 )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 94852.D0/27.D0*Hr1(1)*z2*x + 
     &    34045.D0/9.D0*Hr1(1)*z2*x**2 + 12.D0*Hr1(1)*z2*x**3 - 3704.D0/
     &    27.D0*Hr1(1)*z2*dx - 1.D0/3.D0*Hr1(1)*z2*dx**2 - 1456.D0/3.D0
     &    *Hr2(-1,-1)*z3 - 2912.D0/3.D0*Hr2(-1,-1)*z3*x - 1040.D0/3.D0*
     &    Hr2(-1,-1)*z3*x**2 - 936.D0*Hr2(-1,-1)*z2 - 2192.D0/3.D0*Hr2(
     &    -1,-1)*z2*x + 1876.D0/9.D0*Hr2(-1,-1)*z2*x**2 - 768.D0/5.D0*
     &    Hr2(-1,-1)*z2*x**3 - 896.D0/9.D0*Hr2(-1,-1)*z2*dx - 64.D0/15.D
     &    0*Hr2(-1,-1)*z2*dx**2 + 487361.D0/405.D0*Hr2(-1,0) + 740146.D0
     &    /405.D0*Hr2(-1,0)*x + 487654.D0/405.D0*Hr2(-1,0)*x**2 + 228.D0
     &    /5.D0*Hr2(-1,0)*x**3 + 15646.D0/45.D0*Hr2(-1,0)*dx + 19.D0/15.
     &    D0*Hr2(-1,0)*dx**2 + 664.D0/3.D0*Hr2(-1,0)*z3 + 1904.D0/3.D0*
     &    Hr2(-1,0)*z3*x + 608.D0/3.D0*Hr2(-1,0)*z3*x**2 + 748.D0*Hr2(
     &    -1,0)*z2 - 424.D0*Hr2(-1,0)*z2*x - 12164.D0/9.D0*Hr2(-1,0)*z2
     &    *x**2 + 576.D0/5.D0*Hr2(-1,0)*z2*x**3 - 224.D0/9.D0*Hr2(-1,0)
     &    *z2*dx + 16.D0/5.D0*Hr2(-1,0)*z2*dx**2 + 676.D0/3.D0*Hr2(0,-1
     &    )*z3 )
      c2gg3 = c2gg3 + nf*ca**2 * ( 1016.D0/3.D0*Hr2(0,-1)*z3*x - 112.D0/
     &    3.D0*Hr2(0,-1)*z3*x**2 - 160.D0/3.D0*Hr2(0,-1)*z2 + 2552.D0/3.
     &    D0*Hr2(0,-1)*z2*x - 3676.D0/3.D0*Hr2(0,-1)*z2*x**2 + 768.D0/5.
     &    D0*Hr2(0,-1)*z2*x**3 + 64.D0*Hr2(0,-1)*z2*dx + 423067.D0/405.D
     &    0*Hr2(0,0) + 1068164.D0/135.D0*Hr2(0,0)*x - 689798.D0/135.D0*
     &    Hr2(0,0)*x**2 - 228.D0/5.D0*Hr2(0,0)*x**3 - 14.D0/5.D0*Hr2(0,
     &    0)*dx - 1136.D0/3.D0*Hr2(0,0)*z3 - 4432.D0/3.D0*Hr2(0,0)*z3*x
     &     - 32.D0*Hr2(0,0)*z2 - 12932.D0/3.D0*Hr2(0,0)*z2*x + 14704.D0/
     &    9.D0*Hr2(0,0)*z2*x**2 + 192.D0/5.D0*Hr2(0,0)*z2*x**3 + 1628.D0
     &    /3.D0*Hr2(0,1) + 83774.D0/9.D0*Hr2(0,1)*x - 2479774.D0/405.D0
     &    *Hr2(0,1)*x**2 + 60226.D0/405.D0*Hr2(0,1)*dx + 1240.D0/3.D0*
     &    Hr2(0,1)*z3 - 3440.D0/3.D0*Hr2(0,1)*z3*x + 992.D0*Hr2(0,1)*z3
     &    *x**2 - 136.D0/3.D0*Hr2(0,1)*z2 - 8528.D0/3.D0*Hr2(0,1)*z2*x
     &     + 3280.D0/3.D0*Hr2(0,1)*z2*x**2 - 224.D0/3.D0*Hr2(0,1)*z2*dx
     &     + 602.D0/27.D0*Hr2(1,0) + 16262.D0/3.D0*Hr2(1,0)*x - 435044.D
     &    0/81.D0*Hr2(1,0)*x**2 )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 25084.D0/81.D0*Hr2(1,0)*dx + 1864.
     &    D0/3.D0*Hr2(1,0)*z3 - 3728.D0/3.D0*Hr2(1,0)*z3*x + 2480.D0/3.D
     &    0*Hr2(1,0)*z3*x**2 - 4468.D0/9.D0*Hr2(1,0)*z2 - 11176.D0/9.D0
     &    *Hr2(1,0)*z2*x + 16180.D0/9.D0*Hr2(1,0)*z2*x**2 + 768.D0/5.D0
     &    *Hr2(1,0)*z2*x**3 - 352.D0/3.D0*Hr2(1,0)*z2*dx - 64.D0/15.D0*
     &    Hr2(1,0)*z2*dx**2 - 22454.D0/81.D0*Hr2(1,1) + 507886.D0/81.D0
     &    *Hr2(1,1)*x - 486118.D0/81.D0*Hr2(1,1)*x**2 - 332.D0*Hr2(1,1)
     &    *dx + 656.D0*Hr2(1,1)*z3 - 1312.D0*Hr2(1,1)*z3*x + 848.D0*
     &    Hr2(1,1)*z3*x**2 + 472.D0/9.D0*Hr2(1,1)*z2 - 11672.D0/9.D0*
     &    Hr2(1,1)*z2*x + 13048.D0/9.D0*Hr2(1,1)*z2*x**2 - 896.D0/9.D0*
     &    Hr2(1,1)*z2*dx + 664.D0*Hr3(-1,-1,-1)*z2 + 1328.D0*Hr3(-1,-1,
     &    -1)*z2*x + 592.D0*Hr3(-1,-1,-1)*z2*x**2 - 3464.D0/9.D0*Hr3(-1
     &    ,-1,0) - 256.D0/3.D0*Hr3(-1,-1,0)*x + 5618.D0/27.D0*Hr3(-1,-1
     &    ,0)*x**2 - 24.D0*Hr3(-1,-1,0)*x**3 + 3584.D0/27.D0*Hr3(-1,-1,
     &    0)*dx - 2.D0/3.D0*Hr3(-1,-1,0)*dx**2 - 336.D0*Hr3(-1,-1,0)*z2
     &     - 672.D0*Hr3(-1,-1,0)*z2*x )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 32.D0*Hr3(-1,-1,0)*z2*x**2 - 1072.
     &    D0/3.D0*Hr3(-1,0,-1)*z2 - 2144.D0/3.D0*Hr3(-1,0,-1)*z2*x - 
     &    704.D0/3.D0*Hr3(-1,0,-1)*z2*x**2 - 5516.D0/135.D0*Hr3(-1,0,0)
     &     + 148964.D0/135.D0*Hr3(-1,0,0)*x + 44954.D0/45.D0*Hr3(-1,0,0
     &    )*x**2 + 24.D0*Hr3(-1,0,0)*x**3 - 67088.D0/135.D0*Hr3(-1,0,0)
     &    *dx + 2.D0/3.D0*Hr3(-1,0,0)*dx**2 - 64.D0*Hr3(-1,0,0)*z2 - 
     &    320.D0*Hr3(-1,0,0)*z2*x - 544.D0*Hr3(-1,0,0)*z2*x**2 + 176.D0/
     &    45.D0*Hr3(-1,0,1) + 14872.D0/15.D0*Hr3(-1,0,1)*x + 119494.D0/
     &    135.D0*Hr3(-1,0,1)*x**2 + 24.D0*Hr3(-1,0,1)*x**3 - 34016.D0/
     &    135.D0*Hr3(-1,0,1)*dx + 2.D0/3.D0*Hr3(-1,0,1)*dx**2 - 24.D0*
     &    Hr3(-1,0,1)*z2 - 48.D0*Hr3(-1,0,1)*z2*x - 16.D0*Hr3(-1,0,1)*
     &    z2*x**2 - 288.D0*Hr3(0,-1,-1)*z2 - 640.D0*Hr3(0,-1,-1)*z2*x
     &     - 256.D0/3.D0*Hr3(0,-1,-1)*z2*x**2 - 812.D0/5.D0*Hr3(0,-1,0)
     &     + 2992.D0/5.D0*Hr3(0,-1,0)*x + 19118.D0/135.D0*Hr3(0,-1,0)*
     &    x**2 + 24.D0*Hr3(0,-1,0)*x**3 + 1984.D0/45.D0*Hr3(0,-1,0)*dx
     &     + 824.D0/3.D0*Hr3(0,-1,0)*z2 )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 272.D0*Hr3(0,-1,0)*z2*x - 496.D0/
     &    3.D0*Hr3(0,-1,0)*z2*x**2 + 92.D0/3.D0*Hr3(0,0,-1)*z2 - 280.D0/
     &    3.D0*Hr3(0,0,-1)*z2*x - 192.D0*Hr3(0,0,-1)*z2*x**2 - 32618.D0/
     &    27.D0*Hr3(0,0,0) + 743056.D0/135.D0*Hr3(0,0,0)*x - 152792.D0/
     &    27.D0*Hr3(0,0,0)*x**2 - 24.D0*Hr3(0,0,0)*x**3 + 32.D0/15.D0*
     &    Hr3(0,0,0)*dx + 56.D0*Hr3(0,0,0)*z2 - 1312.D0*Hr3(0,0,0)*z2*x
     &     + 192.D0*Hr3(0,0,0)*z2*x**2 - 33848.D0/45.D0*Hr3(0,0,1) + 
     &    269552.D0/45.D0*Hr3(0,0,1)*x - 881432.D0/135.D0*Hr3(0,0,1)*
     &    x**2 - 24.D0*Hr3(0,0,1)*x**3 - 16.D0/5.D0*Hr3(0,0,1)*dx - 244.
     &    D0/3.D0*Hr3(0,0,1)*z2 - 1368.D0*Hr3(0,0,1)*z2*x + 320.D0/3.D0
     &    *Hr3(0,0,1)*z2*x**2 - 964.D0/3.D0*Hr3(0,1,0) + 43292.D0/9.D0*
     &    Hr3(0,1,0)*x - 4906.D0*Hr3(0,1,0)*x**2 - 832.D0/9.D0*Hr3(0,1,
     &    0)*dx - 712.D0/3.D0*Hr3(0,1,0)*z2 - 5360.D0/3.D0*Hr3(0,1,0)*
     &    z2*x - 176.D0/3.D0*Hr3(0,1,0)*z2*x**2 - 4436.D0/9.D0*Hr3(0,1,
     &    1) + 46388.D0/9.D0*Hr3(0,1,1)*x - 140176.D0/27.D0*Hr3(0,1,1)*
     &    x**2 )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 3280.D0/27.D0*Hr3(0,1,1)*dx - 8.D0
     &    *Hr3(0,1,1)*z2 - 3152.D0/3.D0*Hr3(0,1,1)*z2*x + 736.D0/3.D0*
     &    Hr3(0,1,1)*z2*x**2 - 104.D0*Hr3(1,0,-1)*z2 + 208.D0*Hr3(1,0,
     &    -1)*z2*x - 112.D0*Hr3(1,0,-1)*z2*x**2 + 3758.D0/27.D0*Hr3(1,0
     &    ,0) + 91832.D0/27.D0*Hr3(1,0,0)*x - 100910.D0/27.D0*Hr3(1,0,0
     &    )*x**2 + 136.D0/3.D0*Hr3(1,0,0)*dx + 1120.D0/3.D0*Hr3(1,0,0)*
     &    z2 - 2240.D0/3.D0*Hr3(1,0,0)*z2*x + 1520.D0/3.D0*Hr3(1,0,0)*
     &    z2*x**2 - 3086.D0/27.D0*Hr3(1,0,1) + 96004.D0/27.D0*Hr3(1,0,1
     &    )*x - 99326.D0/27.D0*Hr3(1,0,1)*x**2 + 1912.D0/27.D0*Hr3(1,0,
     &    1)*dx + 536.D0/3.D0*Hr3(1,0,1)*z2 - 1072.D0/3.D0*Hr3(1,0,1)*
     &    z2*x + 784.D0/3.D0*Hr3(1,0,1)*z2*x**2 - 2314.D0/27.D0*Hr3(1,1
     &    ,0) + 100208.D0/27.D0*Hr3(1,1,0)*x - 107626.D0/27.D0*Hr3(1,1,
     &    0)*x**2 + 968.D0/27.D0*Hr3(1,1,0)*dx + 728.D0/3.D0*Hr3(1,1,0)
     &    *z2 - 1456.D0/3.D0*Hr3(1,1,0)*z2*x + 1168.D0/3.D0*Hr3(1,1,0)*
     &    z2*x**2 - 4300.D0/27.D0*Hr3(1,1,1) + 94736.D0/27.D0*Hr3(1,1,1
     &    )*x )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 98716.D0/27.D0*Hr3(1,1,1)*x**2 + 
     &    2168.D0/27.D0*Hr3(1,1,1)*dx + 592.D0/3.D0*Hr3(1,1,1)*z2 - 
     &    1184.D0/3.D0*Hr3(1,1,1)*z2*x + 896.D0/3.D0*Hr3(1,1,1)*z2*x**2
     &     + 80.D0*Hr4(-1,-1,-1,0) - 304.D0*Hr4(-1,-1,-1,0)*x - 3416.D0/
     &    9.D0*Hr4(-1,-1,-1,0)*x**2 - 512.D0/9.D0*Hr4(-1,-1,-1,0)*dx + 
     &    528.D0*Hr4(-1,-1,0,0) + 580.D0/3.D0*Hr4(-1,-1,0,0)*x - 1412.D0
     &    /3.D0*Hr4(-1,-1,0,0)*x**2 + 384.D0/5.D0*Hr4(-1,-1,0,0)*x**3
     &     + 256.D0/3.D0*Hr4(-1,-1,0,0)*dx + 32.D0/15.D0*Hr4(-1,-1,0,0)
     &    *dx**2 + 976.D0*Hr4(-1,-1,0,1) + 1736.D0/3.D0*Hr4(-1,-1,0,1)*
     &    x - 3584.D0/9.D0*Hr4(-1,-1,0,1)*x**2 + 768.D0/5.D0*Hr4(-1,-1,
     &    0,1)*x**3 + 640.D0/9.D0*Hr4(-1,-1,0,1)*dx + 64.D0/15.D0*Hr4(
     &    -1,-1,0,1)*dx**2 - 112.D0/3.D0*Hr4(-1,0,-1,0) + 472.D0/3.D0*
     &    Hr4(-1,0,-1,0)*x + 1504.D0/9.D0*Hr4(-1,0,-1,0)*x**2 + 448.D0/
     &    9.D0*Hr4(-1,0,-1,0)*dx - 1964.D0/9.D0*Hr4(-1,0,0,0) + 9248.D0/
     &    9.D0*Hr4(-1,0,0,0)*x + 13784.D0/9.D0*Hr4(-1,0,0,0)*x**2 - 192.
     &    D0/5.D0*Hr4(-1,0,0,0)*x**3 )
      c2gg3 = c2gg3 + nf*ca**2 * ( 224.D0/3.D0*Hr4(-1,0,0,0)*dx - 16.D0/
     &    15.D0*Hr4(-1,0,0,0)*dx**2 - 1796.D0/3.D0*Hr4(-1,0,0,1) + 628.D
     &    0*Hr4(-1,0,0,1)*x + 4376.D0/3.D0*Hr4(-1,0,0,1)*x**2 - 384.D0/
     &    5.D0*Hr4(-1,0,0,1)*x**3 + 128.D0/3.D0*Hr4(-1,0,0,1)*dx - 32.D0
     &    /15.D0*Hr4(-1,0,0,1)*dx**2 - 16.D0*Hr4(-1,0,1,0) + 1384.D0/3.D
     &    0*Hr4(-1,0,1,0)*x + 1744.D0/3.D0*Hr4(-1,0,1,0)*x**2 + 128.D0/
     &    3.D0*Hr4(-1,0,1,0)*dx + 8.D0*Hr4(-1,0,1,1) + 528.D0*Hr4(-1,0,
     &    1,1)*x + 5744.D0/9.D0*Hr4(-1,0,1,1)*x**2 + 512.D0/9.D0*Hr4(-1
     &    ,0,1,1)*dx - 352.D0/3.D0*Hr4(0,-1,-1,0) + 2176.D0/3.D0*Hr4(0,
     &    -1,-1,0)*x - 1208.D0/3.D0*Hr4(0,-1,-1,0)*x**2 + 128.D0/3.D0*
     &    Hr4(0,-1,-1,0)*dx + 824.D0/3.D0*Hr4(0,-1,0,0) - 644.D0/3.D0*
     &    Hr4(0,-1,0,0)*x + 14092.D0/9.D0*Hr4(0,-1,0,0)*x**2 - 384.D0/5.
     &    D0*Hr4(0,-1,0,0)*x**3 - 256.D0/3.D0*Hr4(0,-1,0,0)*dx - 16.D0/
     &    3.D0*Hr4(0,-1,0,1) - 488.D0*Hr4(0,-1,0,1)*x + 1024.D0*Hr4(0,
     &    -1,0,1)*x**2 - 768.D0/5.D0*Hr4(0,-1,0,1)*x**3 - 128.D0/3.D0*
     &    Hr4(0,-1,0,1)*dx )
      c2gg3 = c2gg3 + nf*ca**2 * ( 384.D0*Hr4(0,0,-1,0) + 8456.D0/9.D0*
     &    Hr4(0,0,-1,0)*x**2 - 384.D0/5.D0*Hr4(0,0,-1,0)*x**3 + 1436.D0/
     &    9.D0*Hr4(0,0,0,0) + 11224.D0/3.D0*Hr4(0,0,0,0)*x - 360.D0*
     &    Hr4(0,0,0,0)*x**2 + 384.D0/5.D0*Hr4(0,0,0,0)*x**3 + 32.D0*
     &    Hr4(0,0,0,1) + 12932.D0/3.D0*Hr4(0,0,0,1)*x - 14704.D0/9.D0*
     &    Hr4(0,0,0,1)*x**2 - 576.D0/5.D0*Hr4(0,0,0,1)*x**3 - 4.D0*Hr4(
     &    0,0,1,0) + 3316.D0*Hr4(0,0,1,0)*x - 1296.D0*Hr4(0,0,1,0)*x**2
     &     - 100.D0/3.D0*Hr4(0,0,1,1) + 11140.D0/3.D0*Hr4(0,0,1,1)*x - 
     &    13540.D0/9.D0*Hr4(0,0,1,1)*x**2 + 72.D0*Hr4(0,1,0,0) + 9628.D0
     &    /3.D0*Hr4(0,1,0,0)*x - 9212.D0/9.D0*Hr4(0,1,0,0)*x**2 + 192.D0
     &    *Hr4(0,1,0,0)*x**3 + 128.D0/3.D0*Hr4(0,1,0,0)*dx - 40.D0/3.D0
     &    *Hr4(0,1,0,1) + 2480.D0*Hr4(0,1,0,1)*x - 3884.D0/3.D0*Hr4(0,1
     &    ,0,1)*x**2 + 160.D0/3.D0*Hr4(0,1,0,1)*dx - 24.D0*Hr4(0,1,1,0)
     &     + 2672.D0*Hr4(0,1,1,0)*x - 15080.D0/9.D0*Hr4(0,1,1,0)*x**2
     &     + 160.D0/3.D0*Hr4(0,1,1,0)*dx + 7264.D0/3.D0*Hr4(0,1,1,1)*x
     &     - 10808.D0/9.D0*Hr4(0,1,1,1)*x**2 )
      c2gg3 = c2gg3 + nf*ca**2 * ( 512.D0/9.D0*Hr4(0,1,1,1)*dx + 336.D0
     &    *Hr4(1,0,-1,0) - 752.D0/3.D0*Hr4(1,0,-1,0)*x + 424.D0/9.D0*
     &    Hr4(1,0,-1,0)*x**2 - 384.D0/5.D0*Hr4(1,0,-1,0)*x**3 + 128.D0/
     &    9.D0*Hr4(1,0,-1,0)*dx + 32.D0/15.D0*Hr4(1,0,-1,0)*dx**2 + 64.D
     &    0/3.D0*Hr4(1,0,0,0) + 3584.D0/3.D0*Hr4(1,0,0,0)*x - 13256.D0/
     &    9.D0*Hr4(1,0,0,0)*x**2 + 192.D0/5.D0*Hr4(1,0,0,0)*x**3 + 1088.
     &    D0/9.D0*Hr4(1,0,0,0)*dx - 16.D0/15.D0*Hr4(1,0,0,0)*dx**2 + 
     &    5812.D0/9.D0*Hr4(1,0,0,1) + 9340.D0/9.D0*Hr4(1,0,0,1)*x - 
     &    5072.D0/3.D0*Hr4(1,0,0,1)*x**2 - 192.D0*Hr4(1,0,0,1)*x**3 + 
     &    896.D0/9.D0*Hr4(1,0,0,1)*dx + 16.D0/3.D0*Hr4(1,0,0,1)*dx**2
     &     - 412.D0/9.D0*Hr4(1,0,1,0) + 9836.D0/9.D0*Hr4(1,0,1,0)*x - 
     &    11432.D0/9.D0*Hr4(1,0,1,0)*x**2 + 256.D0/3.D0*Hr4(1,0,1,0)*dx
     &     - 520.D0/9.D0*Hr4(1,0,1,1) + 9440.D0/9.D0*Hr4(1,0,1,1)*x - 
     &    10460.D0/9.D0*Hr4(1,0,1,1)*x**2 + 64.D0*Hr4(1,0,1,1)*dx - 
     &    5884.D0/9.D0*Hr4(1,1,0,0) + 14156.D0/9.D0*Hr4(1,1,0,0)*x - 
     &    12388.D0/9.D0*Hr4(1,1,0,0)*x**2 )
      c2gg3 = c2gg3 + nf*ca**2 * ( 192.D0*Hr4(1,1,0,0)*x**3 + 896.D0/9.D
     &    0*Hr4(1,1,0,0)*dx - 16.D0/3.D0*Hr4(1,1,0,0)*dx**2 - 832.D0/9.D
     &    0*Hr4(1,1,0,1) + 10304.D0/9.D0*Hr4(1,1,0,1)*x - 1260.D0*Hr4(1
     &    ,1,0,1)*x**2 + 640.D0/9.D0*Hr4(1,1,0,1)*dx - 1028.D0/9.D0*
     &    Hr4(1,1,1,0) + 10456.D0/9.D0*Hr4(1,1,1,0)*x - 11648.D0/9.D0*
     &    Hr4(1,1,1,0)*x**2 + 640.D0/9.D0*Hr4(1,1,1,0)*dx - 860.D0/9.D0
     &    *Hr4(1,1,1,1) + 8488.D0/9.D0*Hr4(1,1,1,1)*x - 1024.D0*Hr4(1,1
     &    ,1,1)*x**2 + 416.D0/9.D0*Hr4(1,1,1,1)*dx + 208.D0*Hr5(-1,-1,
     &    -1,-1,0) + 416.D0*Hr5(-1,-1,-1,-1,0)*x + 224.D0*Hr5(-1,-1,-1,
     &    -1,0)*x**2 - 1600.D0/3.D0*Hr5(-1,-1,-1,0,0) - 3200.D0/3.D0*
     &    Hr5(-1,-1,-1,0,0)*x - 1184.D0/3.D0*Hr5(-1,-1,-1,0,0)*x**2 - 
     &    560.D0*Hr5(-1,-1,-1,0,1) - 1120.D0*Hr5(-1,-1,-1,0,1)*x - 480.D
     &    0*Hr5(-1,-1,-1,0,1)*x**2 - 512.D0/3.D0*Hr5(-1,-1,0,-1,0) - 
     &    1024.D0/3.D0*Hr5(-1,-1,0,-1,0)*x - 448.D0/3.D0*Hr5(-1,-1,0,-1
     &    ,0)*x**2 + 80.D0*Hr5(-1,-1,0,0,0) + 160.D0*Hr5(-1,-1,0,0,0)*x
     &     - 224.D0*Hr5(-1,-1,0,0,0)*x**2 )
      c2gg3 = c2gg3 + nf*ca**2 * ( 536.D0/3.D0*Hr5(-1,-1,0,0,1) + 1072.D
     &    0/3.D0*Hr5(-1,-1,0,0,1)*x - 368.D0/3.D0*Hr5(-1,-1,0,0,1)*x**2
     &     - 80.D0*Hr5(-1,-1,0,1,0) - 160.D0*Hr5(-1,-1,0,1,0)*x - 224.D0
     &    *Hr5(-1,-1,0,1,0)*x**2 - 256.D0/3.D0*Hr5(-1,-1,0,1,1) - 512.D0
     &    /3.D0*Hr5(-1,-1,0,1,1)*x - 704.D0/3.D0*Hr5(-1,-1,0,1,1)*x**2
     &     - 512.D0/3.D0*Hr5(-1,0,-1,-1,0) - 1024.D0/3.D0*Hr5(-1,0,-1,
     &    -1,0)*x - 448.D0/3.D0*Hr5(-1,0,-1,-1,0)*x**2 + 808.D0/3.D0*
     &    Hr5(-1,0,-1,0,0) + 1616.D0/3.D0*Hr5(-1,0,-1,0,0)*x + 368.D0/3.
     &    D0*Hr5(-1,0,-1,0,0)*x**2 + 272.D0*Hr5(-1,0,-1,0,1) + 544.D0*
     &    Hr5(-1,0,-1,0,1)*x + 160.D0*Hr5(-1,0,-1,0,1)*x**2 + 48.D0*
     &    Hr5(-1,0,0,-1,0) + 96.D0*Hr5(-1,0,0,-1,0)*x - 64.D0*Hr5(-1,0,
     &    0,-1,0)*x**2 + 32.D0/3.D0*Hr5(-1,0,0,0,0) + 64.D0/3.D0*Hr5(-1
     &    ,0,0,0,0)*x + 544.D0/3.D0*Hr5(-1,0,0,0,0)*x**2 + 440.D0/3.D0*
     &    Hr5(-1,0,0,0,1) + 1456.D0/3.D0*Hr5(-1,0,0,0,1)*x + 1840.D0/3.D
     &    0*Hr5(-1,0,0,0,1)*x**2 + 112.D0*Hr5(-1,0,0,1,0) + 224.D0*Hr5(
     &    -1,0,0,1,0)*x )
      c2gg3 = c2gg3 + nf*ca**2 * ( 256.D0*Hr5(-1,0,0,1,0)*x**2 + 400.D0/
     &    3.D0*Hr5(-1,0,0,1,1) + 800.D0/3.D0*Hr5(-1,0,0,1,1)*x + 896.D0/
     &    3.D0*Hr5(-1,0,0,1,1)*x**2 - 80.D0*Hr5(-1,0,1,0,0) - 352.D0*
     &    Hr5(-1,0,1,0,0)*x - 256.D0*Hr5(-1,0,1,0,0)*x**2 + 80.D0/3.D0*
     &    Hr5(-1,0,1,0,1) + 160.D0/3.D0*Hr5(-1,0,1,0,1)*x + 160.D0/3.D0
     &    *Hr5(-1,0,1,0,1)*x**2 + 112.D0/3.D0*Hr5(-1,0,1,1,0) + 224.D0/
     &    3.D0*Hr5(-1,0,1,1,0)*x + 224.D0/3.D0*Hr5(-1,0,1,1,0)*x**2 + 
     &    32.D0/3.D0*Hr5(-1,0,1,1,1) + 64.D0/3.D0*Hr5(-1,0,1,1,1)*x + 
     &    64.D0/3.D0*Hr5(-1,0,1,1,1)*x**2 + 16.D0*Hr5(0,-1,-1,-1,0) - 
     &    800.D0*Hr5(0,-1,-1,-1,0)*x - 64.D0*Hr5(0,-1,-1,-1,0)*x**2 + 
     &    172.D0/3.D0*Hr5(0,-1,-1,0,0) + 1864.D0/3.D0*Hr5(0,-1,-1,0,0)*
     &    x - 368.D0/3.D0*Hr5(0,-1,-1,0,0)*x**2 + 296.D0*Hr5(0,-1,-1,0,
     &    1) + 240.D0*Hr5(0,-1,-1,0,1)*x + 160.D0/3.D0*Hr5(0,-1,-1,0,1)
     &    *x**2 - 184.D0/3.D0*Hr5(0,-1,0,-1,0) + 1712.D0/3.D0*Hr5(0,-1,
     &    0,-1,0)*x - 32.D0/3.D0*Hr5(0,-1,0,-1,0)*x**2 - 440.D0/3.D0*
     &    Hr5(0,-1,0,0,0) )
      c2gg3 = c2gg3 + nf*ca**2 * ( 432.D0*Hr5(0,-1,0,0,0)*x + 512.D0/3.D
     &    0*Hr5(0,-1,0,0,0)*x**2 - 644.D0/3.D0*Hr5(0,-1,0,0,1) + 1640.D0
     &    /3.D0*Hr5(0,-1,0,0,1)*x + 784.D0/3.D0*Hr5(0,-1,0,0,1)*x**2 - 
     &    24.D0*Hr5(0,-1,0,1,0) + 304.D0*Hr5(0,-1,0,1,0)*x + 416.D0/3.D0
     &    *Hr5(0,-1,0,1,0)*x**2 - 32.D0/3.D0*Hr5(0,-1,0,1,1) + 1088.D0/
     &    3.D0*Hr5(0,-1,0,1,1)*x + 512.D0/3.D0*Hr5(0,-1,0,1,1)*x**2 - 
     &    104.D0*Hr5(0,0,-1,-1,0) + 1520.D0/3.D0*Hr5(0,0,-1,-1,0)*x - 
     &    640.D0/3.D0*Hr5(0,0,-1,-1,0)*x**2 - 272.D0/3.D0*Hr5(0,0,-1,0,
     &    0) + 208.D0/3.D0*Hr5(0,0,-1,0,0)*x + 448.D0/3.D0*Hr5(0,0,-1,0
     &    ,0)*x**2 - 248.D0/3.D0*Hr5(0,0,-1,0,1) + 1040.D0/3.D0*Hr5(0,0
     &    ,-1,0,1)*x + 256.D0/3.D0*Hr5(0,0,-1,0,1)*x**2 - 328.D0/3.D0*
     &    Hr5(0,0,0,-1,0) + 400.D0/3.D0*Hr5(0,0,0,-1,0)*x + 256.D0/3.D0
     &    *Hr5(0,0,0,-1,0)*x**2 - 240.D0*Hr5(0,0,0,0,0) + 1056.D0*Hr5(0
     &    ,0,0,0,0)*x - 56.D0*Hr5(0,0,0,0,1) + 4336.D0/3.D0*Hr5(0,0,0,0
     &    ,1)*x - 192.D0*Hr5(0,0,0,0,1)*x**2 + 36.D0*Hr5(0,0,0,1,0) + 
     &    1256.D0*Hr5(0,0,0,1,0)*x )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 160.D0*Hr5(0,0,0,1,0)*x**2 + 12.D0
     &    *Hr5(0,0,0,1,1) + 1432.D0*Hr5(0,0,0,1,1)*x - 288.D0*Hr5(0,0,0
     &    ,1,1)*x**2 + 460.D0/3.D0*Hr5(0,0,1,0,0) + 3544.D0/3.D0*Hr5(0,
     &    0,1,0,0)*x - 32.D0*Hr5(0,0,1,0,0)*x**2 + 88.D0/3.D0*Hr5(0,0,1
     &    ,0,1) + 3344.D0/3.D0*Hr5(0,0,1,0,1)*x - 640.D0/3.D0*Hr5(0,0,1
     &    ,0,1)*x**2 + 296.D0/3.D0*Hr5(0,0,1,1,0) + 3568.D0/3.D0*Hr5(0,
     &    0,1,1,0)*x - 512.D0/3.D0*Hr5(0,0,1,1,0)*x**2 + 32.D0*Hr5(0,0,
     &    1,1,1) + 3200.D0/3.D0*Hr5(0,0,1,1,1)*x - 192.D0*Hr5(0,0,1,1,1
     &    )*x**2 + 544.D0/3.D0*Hr5(0,1,0,-1,0) + 64.D0/3.D0*Hr5(0,1,0,
     &    -1,0)*x + 608.D0/3.D0*Hr5(0,1,0,-1,0)*x**2 + 464.D0/3.D0*Hr5(
     &    0,1,0,0,0) + 3616.D0/3.D0*Hr5(0,1,0,0,0)*x - 352.D0/3.D0*Hr5(
     &    0,1,0,0,0)*x**2 + 892.D0/3.D0*Hr5(0,1,0,0,1) + 1512.D0*Hr5(0,
     &    1,0,0,1)*x + 464.D0/3.D0*Hr5(0,1,0,0,1)*x**2 + 124.D0/3.D0*
     &    Hr5(0,1,0,1,0) + 2072.D0/3.D0*Hr5(0,1,0,1,0)*x - 176.D0*Hr5(0
     &    ,1,0,1,0)*x**2 - 56.D0/3.D0*Hr5(0,1,0,1,1) + 1840.D0/3.D0*
     &    Hr5(0,1,0,1,1)*x )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 688.D0/3.D0*Hr5(0,1,0,1,1)*x**2
     &     - 652.D0/3.D0*Hr5(0,1,1,0,0) + 440.D0*Hr5(0,1,1,0,0)*x - 
     &    1856.D0/3.D0*Hr5(0,1,1,0,0)*x**2 + 1952.D0/3.D0*Hr5(0,1,1,0,1
     &    )*x - 640.D0/3.D0*Hr5(0,1,1,0,1)*x**2 - 8.D0*Hr5(0,1,1,1,0)
     &     + 1936.D0/3.D0*Hr5(0,1,1,1,0)*x - 688.D0/3.D0*Hr5(0,1,1,1,0)
     &    *x**2 - 80.D0/3.D0*Hr5(0,1,1,1,1) + 1408.D0/3.D0*Hr5(0,1,1,1,
     &    1)*x - 192.D0*Hr5(0,1,1,1,1)*x**2 - 16.D0/3.D0*Hr5(1,0,-1,-1,
     &    0) + 32.D0/3.D0*Hr5(1,0,-1,-1,0)*x - 224.D0/3.D0*Hr5(1,0,-1,
     &    -1,0)*x**2 + 96.D0*Hr5(1,0,-1,0,0) - 192.D0*Hr5(1,0,-1,0,0)*x
     &     + 160.D0*Hr5(1,0,-1,0,0)*x**2 + 304.D0/3.D0*Hr5(1,0,-1,0,1)
     &     - 608.D0/3.D0*Hr5(1,0,-1,0,1)*x + 224.D0/3.D0*Hr5(1,0,-1,0,1
     &    )*x**2 + 352.D0/3.D0*Hr5(1,0,0,-1,0) - 704.D0/3.D0*Hr5(1,0,0,
     &    -1,0)*x + 608.D0/3.D0*Hr5(1,0,0,-1,0)*x**2 - 688.D0/3.D0*Hr5(
     &    1,0,0,0,0) + 1376.D0/3.D0*Hr5(1,0,0,0,0)*x - 896.D0/3.D0*Hr5(
     &    1,0,0,0,0)*x**2 - 872.D0/3.D0*Hr5(1,0,0,0,1) + 1744.D0/3.D0*
     &    Hr5(1,0,0,0,1)*x )
      c2gg3 = c2gg3 + nf*ca**2 * (  - 1312.D0/3.D0*Hr5(1,0,0,0,1)*x**2
     &     - 448.D0/3.D0*Hr5(1,0,0,1,0) + 896.D0/3.D0*Hr5(1,0,0,1,0)*x
     &     - 800.D0/3.D0*Hr5(1,0,0,1,0)*x**2 - 584.D0/3.D0*Hr5(1,0,0,1,
     &    1) + 1168.D0/3.D0*Hr5(1,0,0,1,1)*x - 1072.D0/3.D0*Hr5(1,0,0,1
     &    ,1)*x**2 - 488.D0/3.D0*Hr5(1,0,1,0,0) + 976.D0/3.D0*Hr5(1,0,1
     &    ,0,0)*x - 736.D0/3.D0*Hr5(1,0,1,0,0)*x**2 - 280.D0/3.D0*Hr5(1
     &    ,0,1,0,1) + 560.D0/3.D0*Hr5(1,0,1,0,1)*x - 560.D0/3.D0*Hr5(1,
     &    0,1,0,1)*x**2 - 352.D0/3.D0*Hr5(1,0,1,1,0) + 704.D0/3.D0*Hr5(
     &    1,0,1,1,0)*x - 704.D0/3.D0*Hr5(1,0,1,1,0)*x**2 - 320.D0/3.D0*
     &    Hr5(1,0,1,1,1) + 640.D0/3.D0*Hr5(1,0,1,1,1)*x - 640.D0/3.D0*
     &    Hr5(1,0,1,1,1)*x**2 + 144.D0*Hr5(1,1,0,-1,0) - 288.D0*Hr5(1,1
     &    ,0,-1,0)*x + 160.D0*Hr5(1,1,0,-1,0)*x**2 - 896.D0/3.D0*Hr5(1,
     &    1,0,0,0) + 1792.D0/3.D0*Hr5(1,1,0,0,0)*x - 1216.D0/3.D0*Hr5(1
     &    ,1,0,0,0)*x**2 - 256.D0/3.D0*Hr5(1,1,0,0,1) + 512.D0/3.D0*
     &    Hr5(1,1,0,0,1)*x - 704.D0/3.D0*Hr5(1,1,0,0,1)*x**2 - 344.D0/3.
     &    D0*Hr5(1,1,0,1,0) )
      c2gg3 = c2gg3 + nf*ca**2 * ( 688.D0/3.D0*Hr5(1,1,0,1,0)*x - 688.D0
     &    /3.D0*Hr5(1,1,0,1,0)*x**2 - 304.D0/3.D0*Hr5(1,1,0,1,1) + 608.D
     &    0/3.D0*Hr5(1,1,0,1,1)*x - 608.D0/3.D0*Hr5(1,1,0,1,1)*x**2 - 
     &    784.D0/3.D0*Hr5(1,1,1,0,0) + 1568.D0/3.D0*Hr5(1,1,1,0,0)*x - 
     &    1184.D0/3.D0*Hr5(1,1,1,0,0)*x**2 - 280.D0/3.D0*Hr5(1,1,1,0,1)
     &     + 560.D0/3.D0*Hr5(1,1,1,0,1)*x - 560.D0/3.D0*Hr5(1,1,1,0,1)*
     &    x**2 - 248.D0/3.D0*Hr5(1,1,1,1,0) + 496.D0/3.D0*Hr5(1,1,1,1,0
     &    )*x - 496.D0/3.D0*Hr5(1,1,1,1,0)*x**2 - 80.D0*Hr5(1,1,1,1,1)
     &     + 160.D0*Hr5(1,1,1,1,1)*x - 160.D0*Hr5(1,1,1,1,1)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 54088421.D0/48600.D0 - 87245687.D0
     &    /24300.D0*x + 3237022.D0/675.D0*x**2 + 926.D0/3.D0*z5 + 24604.
     &    D0/3.D0*z5*x + 712.D0/3.D0*z5*x**2 - 3266.D0/9.D0*z4 + 24610.D
     &    0/9.D0*z4*x + 9832.D0/9.D0*z4*x**2 + 1200.D0*z4*x**3 + 40238.D
     &    0/675.D0*dx + 96.D0*dx*z4 + 12712.D0/135.D0*z3 - 601292.D0/
     &    135.D0*z3*x + 71092.D0/45.D0*z3*x**2 + 3824.D0/5.D0*z3*x**3
     &     - 2032.D0/45.D0*z3*dx + 867496.D0/2025.D0*z2 - 6576608.D0/
     &    2025.D0*z2*x - 1045922.D0/2025.D0*z2*x**2 + 58736.D0/75.D0*z2
     &    *x**3 + 1744.D0/225.D0*z2*dx - 176.D0*z2*z3 - 1168.D0/3.D0*z2
     &    *z3*x - 1600.D0/3.D0*z2*z3*x**2 - 1436.D0/3.D0*Hr1(-1)*z4 - 
     &    7480.D0/3.D0*Hr1(-1)*z4*x - 5296.D0/3.D0*Hr1(-1)*z4*x**2 - 
     &    7250.D0/3.D0*Hr1(-1)*z3 - 10840.D0/3.D0*Hr1(-1)*z3*x - 6668.D0
     &    /3.D0*Hr1(-1)*z3*x**2 - 672.D0*Hr1(-1)*z3*x**3 - 320.D0/3.D0*
     &    Hr1(-1)*z3*dx - 56.D0/3.D0*Hr1(-1)*z3*dx**2 + 83854.D0/45.D0*
     &    Hr1(-1)*z2 + 144164.D0/45.D0*Hr1(-1)*z2*x + 36782.D0/45.D0*
     &    Hr1(-1)*z2*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 19392.D0/25.D0*Hr1(-1)*z2*x**3 + 
     &    3232.D0/45.D0*Hr1(-1)*z2*dx - 1276.D0/75.D0*Hr1(-1)*z2*dx**2
     &     - 462887.D0/1215.D0*Hr1(0) - 15858079.D0/6075.D0*Hr1(0)*x + 
     &    5542108.D0/2025.D0*Hr1(0)*x**2 - 544.D0/3.D0*Hr1(0)*z4 + 1184.
     &    D0/3.D0*Hr1(0)*z4*x - 1568.D0/3.D0*Hr1(0)*z4*x**2 - 9148.D0/
     &    675.D0*Hr1(0)*dx + 1316.D0/9.D0*Hr1(0)*z3 + 62888.D0/9.D0*
     &    Hr1(0)*z3*x + 21392.D0/9.D0*Hr1(0)*z3*x**2 + 7872.D0/5.D0*
     &    Hr1(0)*z3*x**3 - 1334.D0/45.D0*Hr1(0)*z2 - 21616.D0/15.D0*
     &    Hr1(0)*z2*x + 26818.D0/45.D0*Hr1(0)*z2*x**2 + 30256.D0/25.D0*
     &    Hr1(0)*z2*x**3 + 112.D0/15.D0*Hr1(0)*z2*dx - 5471951.D0/6075.D
     &    0*Hr1(1) - 18941999.D0/6075.D0*Hr1(1)*x + 8390392.D0/2025.D0*
     &    Hr1(1)*x**2 - 1204.D0/3.D0*Hr1(1)*z4 + 2408.D0/3.D0*Hr1(1)*z4
     &    *x - 992.D0/3.D0*Hr1(1)*z4*x**2 + 66974.D0/6075.D0*Hr1(1)*dx
     &     - 19994.D0/9.D0*Hr1(1)*z3 + 14416.D0/9.D0*Hr1(1)*z3*x - 6908.
     &    D0/9.D0*Hr1(1)*z3*x**2 + 4512.D0/5.D0*Hr1(1)*z3*x**3 + 448.D0/
     &    9.D0*Hr1(1)*z3*dx )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 376.D0/15.D0*Hr1(1)*z3*dx**2 + 
     &    36224.D0/45.D0*Hr1(1)*z2 - 36244.D0/45.D0*Hr1(1)*z2*x + 3016.D
     &    0/135.D0*Hr1(1)*z2*x**2 + 10864.D0/25.D0*Hr1(1)*z2*x**3 - 
     &    2176.D0/135.D0*Hr1(1)*z2*dx - 1276.D0/225.D0*Hr1(1)*z2*dx**2
     &     + 5728.D0/3.D0*Hr2(-1,-1)*z3 + 11456.D0/3.D0*Hr2(-1,-1)*z3*x
     &     + 7136.D0/3.D0*Hr2(-1,-1)*z3*x**2 + 8756.D0/3.D0*Hr2(-1,-1)*
     &    z2 + 12856.D0/3.D0*Hr2(-1,-1)*z2*x + 7616.D0/3.D0*Hr2(-1,-1)*
     &    z2*x**2 + 4032.D0/5.D0*Hr2(-1,-1)*z2*x**3 + 128.D0*Hr2(-1,-1)
     &    *z2*dx + 112.D0/5.D0*Hr2(-1,-1)*z2*dx**2 - 1010516.D0/225.D0*
     &    Hr2(-1,0) - 4132988.D0/675.D0*Hr2(-1,0)*x - 24232.D0/25.D0*
     &    Hr2(-1,0)*x**2 + 58736.D0/75.D0*Hr2(-1,0)*x**3 - 2008.D0/225.D
     &    0*Hr2(-1,0)*dx + 13924.D0/675.D0*Hr2(-1,0)*dx**2 - 4936.D0/3.D
     &    0*Hr2(-1,0)*z3 - 12176.D0/3.D0*Hr2(-1,0)*z3*x - 8528.D0/3.D0*
     &    Hr2(-1,0)*z3*x**2 - 2672.D0*Hr2(-1,0)*z2 - 3320.D0*Hr2(-1,0)*
     &    z2*x - 5456.D0/3.D0*Hr2(-1,0)*z2*x**2 - 3648.D0/5.D0*Hr2(-1,0
     &    )*z2*x**3 )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 256.D0/3.D0*Hr2(-1,0)*z2*dx - 304.
     &    D0/15.D0*Hr2(-1,0)*z2*dx**2 - 4604.D0/3.D0*Hr2(0,-1)*z3 - 
     &    2088.D0*Hr2(0,-1)*z3*x - 2272.D0*Hr2(0,-1)*z3*x**2 - 776.D0/3.
     &    D0*Hr2(0,-1)*z2 - 12448.D0/3.D0*Hr2(0,-1)*z2*x - 7648.D0/3.D0
     &    *Hr2(0,-1)*z2*x**2 - 4032.D0/5.D0*Hr2(0,-1)*z2*x**3 - 32.D0/5.
     &    D0*Hr2(0,-1)*z2*dx**2 - 334411.D0/2025.D0*Hr2(0,0) + 6805949.D
     &    0/2025.D0*Hr2(0,0)*x + 11442.D0/25.D0*Hr2(0,0)*x**2 - 58736.D0
     &    /75.D0*Hr2(0,0)*x**3 - 2872.D0/225.D0*Hr2(0,0)*dx - 320.D0/3.D
     &    0*Hr2(0,0)*z3 + 2032.D0/3.D0*Hr2(0,0)*z3*x + 224.D0/3.D0*Hr2(
     &    0,0)*z3*x**2 + 284.D0/3.D0*Hr2(0,0)*z2 + 256.D0*Hr2(0,0)*z2*x
     &     + 11296.D0/9.D0*Hr2(0,0)*z2*x**2 + 1344.D0/5.D0*Hr2(0,0)*z2*
     &    x**3 - 867496.D0/2025.D0*Hr2(0,1) - 5822356.D0/2025.D0*Hr2(0,
     &    1)*x + 1045922.D0/2025.D0*Hr2(0,1)*x**2 - 3752.D0/225.D0*Hr2(
     &    0,1)*dx - 3988.D0/3.D0*Hr2(0,1)*z3 + 696.D0*Hr2(0,1)*z3*x - 
     &    2672.D0*Hr2(0,1)*z3*x**2 + 556.D0/3.D0*Hr2(0,1)*z2 - 104.D0/3.
     &    D0*Hr2(0,1)*z2*x )
      c2gg3 = c2gg3 + nf*cf*ca * ( 768.D0*Hr2(0,1)*z2*x**2 + 192.D0/5.D0
     &    *Hr2(0,1)*z2*x**3 - 32.D0/15.D0*Hr2(0,1)*z2*dx**2 - 145171.D0/
     &    405.D0*Hr2(1,0) - 143044.D0/405.D0*Hr2(1,0)*x + 181286.D0/405.
     &    D0*Hr2(1,0)*x**2 + 6104.D0/405.D0*Hr2(1,0)*dx - 1328.D0*Hr2(1
     &    ,0)*z3 + 2656.D0*Hr2(1,0)*z3*x - 1568.D0*Hr2(1,0)*z3*x**2 + 
     &    1948.D0*Hr2(1,0)*z2 - 464.D0/3.D0*Hr2(1,0)*z2*x - 10664.D0/9.D
     &    0*Hr2(1,0)*z2*x**2 - 2304.D0/5.D0*Hr2(1,0)*z2*x**3 + 128.D0/9.
     &    D0*Hr2(1,0)*z2*dx + 64.D0/5.D0*Hr2(1,0)*z2*dx**2 - 69101.D0/
     &    405.D0*Hr2(1,1) - 562724.D0/405.D0*Hr2(1,1)*x + 63254.D0/45.D0
     &    *Hr2(1,1)*x**2 + 2324.D0/405.D0*Hr2(1,1)*dx - 4544.D0/3.D0*
     &    Hr2(1,1)*z3 + 9088.D0/3.D0*Hr2(1,1)*z3*x - 5344.D0/3.D0*Hr2(1
     &    ,1)*z3*x**2 + 356.D0*Hr2(1,1)*z2 - 1184.D0/3.D0*Hr2(1,1)*z2*x
     &     + 1928.D0/9.D0*Hr2(1,1)*z2*x**2 + 192.D0/5.D0*Hr2(1,1)*z2*
     &    x**3 - 320.D0/9.D0*Hr2(1,1)*z2*dx - 16.D0/15.D0*Hr2(1,1)*z2*
     &    dx**2 - 6712.D0/3.D0*Hr3(-1,-1,-1)*z2 - 13424.D0/3.D0*Hr3(-1,
     &    -1,-1)*z2*x )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 8240.D0/3.D0*Hr3(-1,-1,-1)*z2*
     &    x**2 + 68468.D0/45.D0*Hr3(-1,-1,0) + 6616.D0/15.D0*Hr3(-1,-1,
     &    0)*x - 63356.D0/45.D0*Hr3(-1,-1,0)*x**2 - 12928.D0/25.D0*Hr3(
     &    -1,-1,0)*x**3 + 5504.D0/45.D0*Hr3(-1,-1,0)*dx - 2552.D0/225.D0
     &    *Hr3(-1,-1,0)*dx**2 + 5792.D0/3.D0*Hr3(-1,-1,0)*z2 + 11584.D0/
     &    3.D0*Hr3(-1,-1,0)*z2*x + 7168.D0/3.D0*Hr3(-1,-1,0)*z2*x**2 + 
     &    1400.D0*Hr3(-1,0,-1)*z2 + 2800.D0*Hr3(-1,0,-1)*z2*x + 1712.D0
     &    *Hr3(-1,0,-1)*z2*x**2 - 23540.D0/9.D0*Hr3(-1,0,0) - 3628.D0*
     &    Hr3(-1,0,0)*x - 3448.D0/9.D0*Hr3(-1,0,0)*x**2 + 21888.D0/25.D0
     &    *Hr3(-1,0,0)*x**3 - 560.D0/9.D0*Hr3(-1,0,0)*dx + 4792.D0/225.D
     &    0*Hr3(-1,0,0)*dx**2 - 1816.D0/3.D0*Hr3(-1,0,0)*z2 - 1328.D0/3.
     &    D0*Hr3(-1,0,0)*z2*x - 176.D0/3.D0*Hr3(-1,0,0)*z2*x**2 - 3308.D
     &    0/3.D0*Hr3(-1,0,1) - 26848.D0/9.D0*Hr3(-1,0,1)*x - 4564.D0/3.D
     &    0*Hr3(-1,0,1)*x**2 + 12928.D0/25.D0*Hr3(-1,0,1)*x**3 - 32.D0/
     &    3.D0*Hr3(-1,0,1)*dx + 2552.D0/225.D0*Hr3(-1,0,1)*dx**2 - 64.D0
     &    *Hr3(-1,0,1)*z2*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * ( 1792.D0*Hr3(0,-1,-1)*z2 + 2368.D0*
     &    Hr3(0,-1,-1)*z2*x + 2592.D0*Hr3(0,-1,-1)*z2*x**2 - 103424.D0/
     &    45.D0*Hr3(0,-1,0) - 11512.D0/45.D0*Hr3(0,-1,0)*x + 50828.D0/
     &    45.D0*Hr3(0,-1,0)*x**2 + 12928.D0/25.D0*Hr3(0,-1,0)*x**3 + 
     &    128.D0/15.D0*Hr3(0,-1,0)*dx + 448.D0/45.D0*Hr3(0,-1,0)*dx**2
     &     - 4768.D0/3.D0*Hr3(0,-1,0)*z2 - 1632.D0*Hr3(0,-1,0)*z2*x - 
     &    2224.D0*Hr3(0,-1,0)*z2*x**2 - 664.D0/3.D0*Hr3(0,0,-1)*z2 - 
     &    560.D0/3.D0*Hr3(0,0,-1)*z2*x - 3232.D0/3.D0*Hr3(0,0,-1)*z2*
     &    x**2 + 18097.D0/135.D0*Hr3(0,0,0) + 188434.D0/135.D0*Hr3(0,0,
     &    0)*x - 75448.D0/45.D0*Hr3(0,0,0)*x**2 - 21888.D0/25.D0*Hr3(0,
     &    0,0)*x**3 - 64.D0/5.D0*Hr3(0,0,0)*dx - 656.D0/3.D0*Hr3(0,0,0)
     &    *z2 - 1952.D0/3.D0*Hr3(0,0,0)*z2*x + 160.D0/3.D0*Hr3(0,0,0)*
     &    z2*x**2 + 1334.D0/45.D0*Hr3(0,0,1) + 53336.D0/45.D0*Hr3(0,0,1
     &    )*x - 26818.D0/45.D0*Hr3(0,0,1)*x**2 - 17328.D0/25.D0*Hr3(0,0
     &    ,1)*x**3 + 16.D0/15.D0*Hr3(0,0,1)*dx - 64.D0*Hr3(0,0,1)*z2 - 
     &    160.D0*Hr3(0,0,1)*z2*x )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 1102.D0/45.D0*Hr3(0,1,0) - 11792.D
     &    0/45.D0*Hr3(0,1,0)*x - 215798.D0/135.D0*Hr3(0,1,0)*x**2 + 176.
     &    D0*Hr3(0,1,0)*x**3 - 32.D0/15.D0*Hr3(0,1,0)*dx + 1888.D0/3.D0
     &    *Hr3(0,1,0)*z2 + 8320.D0/3.D0*Hr3(0,1,0)*z2*x + 3632.D0/3.D0*
     &    Hr3(0,1,0)*z2*x**2 + 3494.D0/135.D0*Hr3(0,1,1) - 66376.D0/135.
     &    D0*Hr3(0,1,1)*x - 160708.D0/135.D0*Hr3(0,1,1)*x**2 - 32.D0/15.
     &    D0*Hr3(0,1,1)*dx - 40.D0*Hr3(0,1,1)*z2 + 976.D0/3.D0*Hr3(0,1,
     &    1)*z2*x - 32.D0/3.D0*Hr3(0,1,1)*z2*x**2 + 336.D0*Hr3(1,0,-1)*
     &    z2 - 672.D0*Hr3(1,0,-1)*z2*x + 352.D0*Hr3(1,0,-1)*z2*x**2 - 
     &    74332.D0/135.D0*Hr3(1,0,0) + 122552.D0/135.D0*Hr3(1,0,0)*x - 
     &    102736.D0/135.D0*Hr3(1,0,0)*x**2 + 2576.D0/135.D0*Hr3(1,0,0)*
     &    dx - 1792.D0/3.D0*Hr3(1,0,0)*z2 + 3584.D0/3.D0*Hr3(1,0,0)*z2*
     &    x - 2048.D0/3.D0*Hr3(1,0,0)*z2*x**2 - 398.D0/9.D0*Hr3(1,0,1)
     &     + 5264.D0/9.D0*Hr3(1,0,1)*x - 19610.D0/27.D0*Hr3(1,0,1)*x**2
     &     - 176.D0*Hr3(1,0,1)*x**3 - 1216.D0/27.D0*Hr3(1,0,1)*dx - 304.
     &    D0/3.D0*Hr3(1,0,1)*z2 )
      c2gg3 = c2gg3 + nf*cf*ca * ( 608.D0/3.D0*Hr3(1,0,1)*z2*x - 32.D0/
     &    3.D0*Hr3(1,0,1)*z2*x**2 - 34.D0*Hr3(1,1,0) + 3820.D0/9.D0*
     &    Hr3(1,1,0)*x - 21326.D0/27.D0*Hr3(1,1,0)*x**2 + 176.D0*Hr3(1,
     &    1,0)*x**3 - 352.D0/27.D0*Hr3(1,1,0)*dx - 232.D0/3.D0*Hr3(1,1,
     &    0)*z2 + 464.D0/3.D0*Hr3(1,1,0)*z2*x - 272.D0/3.D0*Hr3(1,1,0)*
     &    z2*x**2 + 2032.D0/27.D0*Hr3(1,1,1) + 2536.D0/27.D0*Hr3(1,1,1)
     &    *x - 3556.D0/9.D0*Hr3(1,1,1)*x**2 - 784.D0/27.D0*Hr3(1,1,1)*
     &    dx - 400.D0/3.D0*Hr3(1,1,1)*z2 + 800.D0/3.D0*Hr3(1,1,1)*z2*x
     &     - 224.D0/3.D0*Hr3(1,1,1)*z2*x**2 - 808.D0/3.D0*Hr4(-1,-1,-1,
     &    0) + 3248.D0/3.D0*Hr4(-1,-1,-1,0)*x + 1696.D0*Hr4(-1,-1,-1,0)
     &    *x**2 + 384.D0/5.D0*Hr4(-1,-1,-1,0)*x**3 + 256.D0/3.D0*Hr4(-1
     &    ,-1,-1,0)*dx + 32.D0/15.D0*Hr4(-1,-1,-1,0)*dx**2 - 1464.D0*
     &    Hr4(-1,-1,0,0) - 10136.D0/3.D0*Hr4(-1,-1,0,0)*x - 8728.D0/3.D0
     &    *Hr4(-1,-1,0,0)*x**2 - 576.D0*Hr4(-1,-1,0,0)*x**3 - 512.D0/3.D
     &    0*Hr4(-1,-1,0,0)*dx - 16.D0*Hr4(-1,-1,0,0)*dx**2 - 9160.D0/3.D
     &    0*Hr4(-1,-1,0,1) )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 3744.D0*Hr4(-1,-1,0,1)*x - 5072.D0
     &    /3.D0*Hr4(-1,-1,0,1)*x**2 - 768.D0*Hr4(-1,-1,0,1)*x**3 - 256.D
     &    0/3.D0*Hr4(-1,-1,0,1)*dx - 64.D0/3.D0*Hr4(-1,-1,0,1)*dx**2 + 
     &    512.D0/3.D0*Hr4(-1,0,-1,0) - 3136.D0/3.D0*Hr4(-1,0,-1,0)*x - 
     &    1520.D0*Hr4(-1,0,-1,0)*x**2 - 384.D0/5.D0*Hr4(-1,0,-1,0)*x**3
     &     - 256.D0/3.D0*Hr4(-1,0,-1,0)*dx - 32.D0/15.D0*Hr4(-1,0,-1,0)
     &    *dx**2 + 796.D0*Hr4(-1,0,0,0) + 4448.D0/3.D0*Hr4(-1,0,0,0)*x
     &     + 1384.D0*Hr4(-1,0,0,0)*x**2 + 1728.D0/5.D0*Hr4(-1,0,0,0)*
     &    x**3 + 256.D0/3.D0*Hr4(-1,0,0,0)*dx + 48.D0/5.D0*Hr4(-1,0,0,0
     &    )*dx**2 + 6752.D0/3.D0*Hr4(-1,0,0,1) + 7480.D0/3.D0*Hr4(-1,0,
     &    0,1)*x + 3208.D0/3.D0*Hr4(-1,0,0,1)*x**2 + 576.D0*Hr4(-1,0,0,
     &    1)*x**3 + 128.D0/3.D0*Hr4(-1,0,0,1)*dx + 16.D0*Hr4(-1,0,0,1)*
     &    dx**2 + 1208.D0/3.D0*Hr4(-1,0,1,0) + 1408.D0/3.D0*Hr4(-1,0,1,
     &    0)*x + 736.D0/3.D0*Hr4(-1,0,1,0)*x**2 + 384.D0/5.D0*Hr4(-1,0,
     &    1,0)*x**3 + 32.D0/15.D0*Hr4(-1,0,1,0)*dx**2 + 1352.D0/3.D0*
     &    Hr4(-1,0,1,1) )
      c2gg3 = c2gg3 + nf*cf*ca * ( 1648.D0/3.D0*Hr4(-1,0,1,1)*x + 832.D0
     &    /3.D0*Hr4(-1,0,1,1)*x**2 + 384.D0/5.D0*Hr4(-1,0,1,1)*x**3 + 
     &    32.D0/15.D0*Hr4(-1,0,1,1)*dx**2 + 208.D0/3.D0*Hr4(0,-1,-1,0)
     &     - 6656.D0/3.D0*Hr4(0,-1,-1,0)*x - 6688.D0/3.D0*Hr4(0,-1,-1,0
     &    )*x**2 - 384.D0/5.D0*Hr4(0,-1,-1,0)*x**3 - 64.D0/15.D0*Hr4(0,
     &    -1,-1,0)*dx**2 - 968.D0/3.D0*Hr4(0,-1,0,0) + 8528.D0/3.D0*
     &    Hr4(0,-1,0,0)*x + 3048.D0*Hr4(0,-1,0,0)*x**2 + 576.D0*Hr4(0,
     &    -1,0,0)*x**3 + 64.D0/15.D0*Hr4(0,-1,0,0)*dx**2 + 880.D0/3.D0*
     &    Hr4(0,-1,0,1) + 3040.D0*Hr4(0,-1,0,1)*x + 4304.D0/3.D0*Hr4(0,
     &    -1,0,1)*x**2 + 768.D0*Hr4(0,-1,0,1)*x**3 + 64.D0/15.D0*Hr4(0,
     &    -1,0,1)*dx**2 - 2528.D0/3.D0*Hr4(0,0,-1,0) + 656.D0*Hr4(0,0,
     &    -1,0)*x + 6224.D0/3.D0*Hr4(0,0,-1,0)*x**2 + 1536.D0/5.D0*Hr4(
     &    0,0,-1,0)*x**3 - 1636.D0/9.D0*Hr4(0,0,0,0) - 1864.D0/9.D0*
     &    Hr4(0,0,0,0)*x - 1712.D0*Hr4(0,0,0,0)*x**2 - 2304.D0/5.D0*
     &    Hr4(0,0,0,0)*x**3 - 284.D0/3.D0*Hr4(0,0,0,1) + 400.D0*Hr4(0,0
     &    ,0,1)*x )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 11296.D0/9.D0*Hr4(0,0,0,1)*x**2
     &     + 192.D0/5.D0*Hr4(0,0,0,1)*x**3 - 244.D0/3.D0*Hr4(0,0,1,0)
     &     + 816.D0*Hr4(0,0,1,0)*x - 19216.D0/9.D0*Hr4(0,0,1,0)*x**2 - 
     &    384.D0/5.D0*Hr4(0,0,1,0)*x**3 - 356.D0/3.D0*Hr4(0,0,1,1) + 
     &    2224.D0/3.D0*Hr4(0,0,1,1)*x - 21008.D0/9.D0*Hr4(0,0,1,1)*x**2
     &     - 384.D0/5.D0*Hr4(0,0,1,1)*x**3 - 352.D0*Hr4(0,1,0,0) - 1560.
     &    D0*Hr4(0,1,0,0)*x - 7168.D0/3.D0*Hr4(0,1,0,0)*x**2 - 3072.D0/
     &    5.D0*Hr4(0,1,0,0)*x**3 - 452.D0/3.D0*Hr4(0,1,0,1) + 1144.D0*
     &    Hr4(0,1,0,1)*x - 5648.D0/3.D0*Hr4(0,1,0,1)*x**2 - 508.D0/3.D0
     &    *Hr4(0,1,1,0) + 3080.D0/3.D0*Hr4(0,1,1,0)*x - 4952.D0/3.D0*
     &    Hr4(0,1,1,0)*x**2 - 1312.D0/9.D0*Hr4(0,1,1,1) + 8744.D0/9.D0*
     &    Hr4(0,1,1,1)*x - 14800.D0/9.D0*Hr4(0,1,1,1)*x**2 - 3040.D0/3.D
     &    0*Hr4(1,0,-1,0) + 608.D0*Hr4(1,0,-1,0)*x + 64.D0/3.D0*Hr4(1,0
     &    ,-1,0)*x**2 + 1152.D0/5.D0*Hr4(1,0,-1,0)*x**3 - 32.D0/5.D0*
     &    Hr4(1,0,-1,0)*dx**2 - 3188.D0/9.D0*Hr4(1,0,0,0) + 1576.D0/9.D0
     &    *Hr4(1,0,0,0)*x )
      c2gg3 = c2gg3 + nf*cf*ca * ( 1480.D0/9.D0*Hr4(1,0,0,0)*x**2 - 576.
     &    D0/5.D0*Hr4(1,0,0,0)*x**3 - 416.D0/9.D0*Hr4(1,0,0,0)*dx + 16.D
     &    0/5.D0*Hr4(1,0,0,0)*dx**2 - 7108.D0/3.D0*Hr4(1,0,0,1) + 2944.D
     &    0/3.D0*Hr4(1,0,0,1)*x + 3920.D0/9.D0*Hr4(1,0,0,1)*x**2 + 3072.
     &    D0/5.D0*Hr4(1,0,0,1)*x**3 + 256.D0/9.D0*Hr4(1,0,0,1)*dx - 256.
     &    D0/15.D0*Hr4(1,0,0,1)*dx**2 - 908.D0/3.D0*Hr4(1,0,1,0) + 3632.
     &    D0/3.D0*Hr4(1,0,1,0)*x - 11624.D0/9.D0*Hr4(1,0,1,0)*x**2 + 
     &    704.D0/9.D0*Hr4(1,0,1,0)*dx - 628.D0/3.D0*Hr4(1,0,1,1) + 880.D
     &    0*Hr4(1,0,1,1)*x - 3104.D0/3.D0*Hr4(1,0,1,1)*x**2 + 256.D0/3.D
     &    0*Hr4(1,0,1,1)*dx + 4432.D0/3.D0*Hr4(1,1,0,0) + 808.D0*Hr4(1,
     &    1,0,0)*x - 17776.D0/9.D0*Hr4(1,1,0,0)*x**2 - 3072.D0/5.D0*
     &    Hr4(1,1,0,0)*x**3 + 640.D0/9.D0*Hr4(1,1,0,0)*dx + 256.D0/15.D0
     &    *Hr4(1,1,0,0)*dx**2 - 664.D0/3.D0*Hr4(1,1,0,1) + 936.D0*Hr4(1
     &    ,1,0,1)*x - 9560.D0/9.D0*Hr4(1,1,0,1)*x**2 + 704.D0/9.D0*Hr4(
     &    1,1,0,1)*dx - 220.D0*Hr4(1,1,1,0) + 2896.D0/3.D0*Hr4(1,1,1,0)
     &    *x )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 9632.D0/9.D0*Hr4(1,1,1,0)*x**2 + 
     &    704.D0/9.D0*Hr4(1,1,1,0)*dx - 1048.D0/9.D0*Hr4(1,1,1,1) + 
     &    5480.D0/9.D0*Hr4(1,1,1,1)*x - 2272.D0/3.D0*Hr4(1,1,1,1)*x**2
     &     + 736.D0/9.D0*Hr4(1,1,1,1)*dx - 1424.D0/3.D0*Hr5(-1,-1,-1,-1
     &    ,0) - 2848.D0/3.D0*Hr5(-1,-1,-1,-1,0)*x - 1696.D0/3.D0*Hr5(-1
     &    ,-1,-1,-1,0)*x**2 + 5344.D0/3.D0*Hr5(-1,-1,-1,0,0) + 10688.D0/
     &    3.D0*Hr5(-1,-1,-1,0,0)*x + 6272.D0/3.D0*Hr5(-1,-1,-1,0,0)*
     &    x**2 + 2000.D0*Hr5(-1,-1,-1,0,1) + 4000.D0*Hr5(-1,-1,-1,0,1)*
     &    x + 2464.D0*Hr5(-1,-1,-1,0,1)*x**2 + 1360.D0/3.D0*Hr5(-1,-1,0
     &    ,-1,0) + 2720.D0/3.D0*Hr5(-1,-1,0,-1,0)*x + 1568.D0/3.D0*Hr5(
     &    -1,-1,0,-1,0)*x**2 - 968.D0*Hr5(-1,-1,0,0,0) - 1936.D0*Hr5(-1
     &    ,-1,0,0,0)*x - 1104.D0*Hr5(-1,-1,0,0,0)*x**2 - 4408.D0/3.D0*
     &    Hr5(-1,-1,0,0,1) - 8816.D0/3.D0*Hr5(-1,-1,0,0,1)*x - 5552.D0/
     &    3.D0*Hr5(-1,-1,0,0,1)*x**2 - 752.D0/3.D0*Hr5(-1,-1,0,1,0) - 
     &    1504.D0/3.D0*Hr5(-1,-1,0,1,0)*x - 1120.D0/3.D0*Hr5(-1,-1,0,1,
     &    0)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 288.D0*Hr5(-1,-1,0,1,1) - 576.D0*
     &    Hr5(-1,-1,0,1,1)*x - 448.D0*Hr5(-1,-1,0,1,1)*x**2 + 432.D0*
     &    Hr5(-1,0,-1,-1,0) + 864.D0*Hr5(-1,0,-1,-1,0)*x + 480.D0*Hr5(
     &    -1,0,-1,-1,0)*x**2 - 3176.D0/3.D0*Hr5(-1,0,-1,0,0) - 6352.D0/
     &    3.D0*Hr5(-1,0,-1,0,0)*x - 3664.D0/3.D0*Hr5(-1,0,-1,0,0)*x**2
     &     - 1184.D0*Hr5(-1,0,-1,0,1) - 2368.D0*Hr5(-1,0,-1,0,1)*x - 
     &    1472.D0*Hr5(-1,0,-1,0,1)*x**2 - 896.D0/3.D0*Hr5(-1,0,0,-1,0)
     &     - 1792.D0/3.D0*Hr5(-1,0,0,-1,0)*x - 640.D0/3.D0*Hr5(-1,0,0,
     &    -1,0)*x**2 + 552.D0*Hr5(-1,0,0,0,0) + 1104.D0*Hr5(-1,0,0,0,0)
     &    *x + 720.D0*Hr5(-1,0,0,0,0)*x**2 + 928.D0/3.D0*Hr5(-1,0,0,0,1
     &    ) - 448.D0/3.D0*Hr5(-1,0,0,0,1)*x - 832.D0/3.D0*Hr5(-1,0,0,0,
     &    1)*x**2 + 208.D0*Hr5(-1,0,0,1,0) + 416.D0*Hr5(-1,0,0,1,0)*x
     &     + 352.D0*Hr5(-1,0,0,1,0)*x**2 + 240.D0*Hr5(-1,0,0,1,1) + 480.
     &    D0*Hr5(-1,0,0,1,1)*x + 416.D0*Hr5(-1,0,0,1,1)*x**2 + 1712.D0/
     &    3.D0*Hr5(-1,0,1,0,0) + 5728.D0/3.D0*Hr5(-1,0,1,0,0)*x + 4576.D
     &    0/3.D0*Hr5(-1,0,1,0,0)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * ( 272.D0/3.D0*Hr5(-1,0,1,0,1) + 544.D0/
     &    3.D0*Hr5(-1,0,1,0,1)*x + 544.D0/3.D0*Hr5(-1,0,1,0,1)*x**2 + 
     &    80.D0*Hr5(-1,0,1,1,0) + 160.D0*Hr5(-1,0,1,1,0)*x + 160.D0*
     &    Hr5(-1,0,1,1,0)*x**2 + 256.D0/3.D0*Hr5(-1,0,1,1,1) + 512.D0/3.
     &    D0*Hr5(-1,0,1,1,1)*x + 512.D0/3.D0*Hr5(-1,0,1,1,1)*x**2 + 448.
     &    D0/3.D0*Hr5(0,-1,-1,-1,0) + 6400.D0/3.D0*Hr5(0,-1,-1,-1,0)*x
     &     + 640.D0*Hr5(0,-1,-1,-1,0)*x**2 - 896.D0*Hr5(0,-1,-1,0,0) - 
     &    9152.D0/3.D0*Hr5(0,-1,-1,0,0)*x - 5168.D0/3.D0*Hr5(0,-1,-1,0,
     &    0)*x**2 - 5152.D0/3.D0*Hr5(0,-1,-1,0,1) - 3904.D0/3.D0*Hr5(0,
     &    -1,-1,0,1)*x - 2272.D0*Hr5(0,-1,-1,0,1)*x**2 - 5248.D0/3.D0*
     &    Hr5(0,-1,0,-1,0)*x - 1216.D0/3.D0*Hr5(0,-1,0,-1,0)*x**2 + 
     &    1472.D0/3.D0*Hr5(0,-1,0,0,0) + 4736.D0/3.D0*Hr5(0,-1,0,0,0)*x
     &     + 880.D0*Hr5(0,-1,0,0,0)*x**2 + 4016.D0/3.D0*Hr5(0,-1,0,0,1)
     &     + 736.D0*Hr5(0,-1,0,0,1)*x + 5264.D0/3.D0*Hr5(0,-1,0,0,1)*
     &    x**2 + 256.D0*Hr5(0,-1,0,1,0) + 256.D0/3.D0*Hr5(0,-1,0,1,0)*x
     &     + 1120.D0/3.D0*Hr5(0,-1,0,1,0)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * ( 288.D0*Hr5(0,-1,0,1,1) + 320.D0/3.D0
     &    *Hr5(0,-1,0,1,1)*x + 448.D0*Hr5(0,-1,0,1,1)*x**2 + 176.D0/3.D0
     &    *Hr5(0,0,-1,-1,0) - 4256.D0/3.D0*Hr5(0,0,-1,-1,0)*x - 1600.D0/
     &    3.D0*Hr5(0,0,-1,-1,0)*x**2 - 944.D0/3.D0*Hr5(0,0,-1,0,0) + 
     &    1568.D0/3.D0*Hr5(0,0,-1,0,0)*x + 928.D0/3.D0*Hr5(0,0,-1,0,0)*
     &    x**2 + 752.D0/3.D0*Hr5(0,0,-1,0,1) - 1568.D0/3.D0*Hr5(0,0,-1,
     &    0,1)*x + 2432.D0/3.D0*Hr5(0,0,-1,0,1)*x**2 - 2176.D0/3.D0*
     &    Hr5(0,0,0,-1,0) + 128.D0/3.D0*Hr5(0,0,0,-1,0)*x - 1792.D0/3.D0
     &    *Hr5(0,0,0,-1,0)*x**2 + 120.D0*Hr5(0,0,0,0,0) + 1168.D0/3.D0*
     &    Hr5(0,0,0,0,0)*x + 656.D0/3.D0*Hr5(0,0,0,0,1) + 2080.D0/3.D0*
     &    Hr5(0,0,0,0,1)*x - 160.D0/3.D0*Hr5(0,0,0,0,1)*x**2 + 472.D0/3.
     &    D0*Hr5(0,0,0,1,0) + 2288.D0/3.D0*Hr5(0,0,0,1,0)*x - 160.D0*
     &    Hr5(0,0,0,1,0)*x**2 + 168.D0*Hr5(0,0,0,1,1) + 2608.D0/3.D0*
     &    Hr5(0,0,0,1,1)*x - 544.D0/3.D0*Hr5(0,0,0,1,1)*x**2 - 304.D0/3.
     &    D0*Hr5(0,0,1,0,0) + 896.D0/3.D0*Hr5(0,0,1,0,0)*x - 1184.D0/3.D
     &    0*Hr5(0,0,1,0,0)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * ( 280.D0/3.D0*Hr5(0,0,1,0,1) + 2608.D0/
     &    3.D0*Hr5(0,0,1,0,1)*x - 800.D0/3.D0*Hr5(0,0,1,0,1)*x**2 + 24.D
     &    0*Hr5(0,0,1,1,0) + 2384.D0/3.D0*Hr5(0,0,1,1,0)*x - 1120.D0/3.D
     &    0*Hr5(0,0,1,1,0)*x**2 + 248.D0/3.D0*Hr5(0,0,1,1,1) + 816.D0*
     &    Hr5(0,0,1,1,1)*x - 736.D0/3.D0*Hr5(0,0,1,1,1)*x**2 - 1504.D0/
     &    3.D0*Hr5(0,1,0,-1,0) + 128.D0/3.D0*Hr5(0,1,0,-1,0)*x - 1600.D0
     &    /3.D0*Hr5(0,1,0,-1,0)*x**2 - 344.D0/3.D0*Hr5(0,1,0,0,0) - 
     &    1040.D0*Hr5(0,1,0,0,0)*x - 272.D0/3.D0*Hr5(0,1,0,0,0)*x**2 - 
     &    880.D0*Hr5(0,1,0,0,1) - 5632.D0/3.D0*Hr5(0,1,0,0,1)*x - 1680.D
     &    0*Hr5(0,1,0,0,1)*x**2 - 80.D0/3.D0*Hr5(0,1,0,1,0) + 2368.D0/3.
     &    D0*Hr5(0,1,0,1,0)*x - 976.D0/3.D0*Hr5(0,1,0,1,0)*x**2 + 112.D0
     &    /3.D0*Hr5(0,1,0,1,1) + 2080.D0/3.D0*Hr5(0,1,0,1,1)*x - 176.D0
     &    *Hr5(0,1,0,1,1)*x**2 + 808.D0*Hr5(0,1,1,0,0) + 6416.D0/3.D0*
     &    Hr5(0,1,1,0,0)*x + 3968.D0/3.D0*Hr5(0,1,1,0,0)*x**2 - 104.D0/
     &    3.D0*Hr5(0,1,1,0,1) + 2224.D0/3.D0*Hr5(0,1,1,0,1)*x - 928.D0/
     &    3.D0*Hr5(0,1,1,0,1)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 80.D0/3.D0*Hr5(0,1,1,1,0) + 2368.D
     &    0/3.D0*Hr5(0,1,1,1,0)*x - 976.D0/3.D0*Hr5(0,1,1,1,0)*x**2 + 
     &    40.D0*Hr5(0,1,1,1,1) + 656.D0*Hr5(0,1,1,1,1)*x - 160.D0*Hr5(0
     &    ,1,1,1,1)*x**2 - 544.D0/3.D0*Hr5(1,0,-1,-1,0) + 1088.D0/3.D0*
     &    Hr5(1,0,-1,-1,0)*x - 704.D0/3.D0*Hr5(1,0,-1,-1,0)*x**2 - 272.D
     &    0*Hr5(1,0,-1,0,0) + 544.D0*Hr5(1,0,-1,0,0)*x - 416.D0*Hr5(1,0
     &    ,-1,0,0)*x**2 - 1280.D0/3.D0*Hr5(1,0,-1,0,1) + 2560.D0/3.D0*
     &    Hr5(1,0,-1,0,1)*x - 1408.D0/3.D0*Hr5(1,0,-1,0,1)*x**2 - 880.D0
     &    /3.D0*Hr5(1,0,0,-1,0) + 1760.D0/3.D0*Hr5(1,0,0,-1,0)*x - 1376.
     &    D0/3.D0*Hr5(1,0,0,-1,0)*x**2 + 312.D0*Hr5(1,0,0,0,0) - 624.D0
     &    *Hr5(1,0,0,0,0)*x + 240.D0*Hr5(1,0,0,0,0)*x**2 + 904.D0/3.D0*
     &    Hr5(1,0,0,0,1) - 1808.D0/3.D0*Hr5(1,0,0,0,1)*x + 1040.D0/3.D0
     &    *Hr5(1,0,0,0,1)*x**2 - 80.D0/3.D0*Hr5(1,0,0,1,0) + 160.D0/3.D0
     &    *Hr5(1,0,0,1,0)*x - 352.D0/3.D0*Hr5(1,0,0,1,0)*x**2 + 296.D0/
     &    3.D0*Hr5(1,0,0,1,1) - 592.D0/3.D0*Hr5(1,0,0,1,1)*x + 400.D0/3.
     &    D0*Hr5(1,0,0,1,1)*x**2 )
      c2gg3 = c2gg3 + nf*cf*ca * ( 128.D0/3.D0*Hr5(1,0,1,0,0) - 256.D0/
     &    3.D0*Hr5(1,0,1,0,0)*x - 512.D0/3.D0*Hr5(1,0,1,0,0)*x**2 - 344.
     &    D0/3.D0*Hr5(1,0,1,0,1) + 688.D0/3.D0*Hr5(1,0,1,0,1)*x - 688.D0
     &    /3.D0*Hr5(1,0,1,0,1)*x**2 - 128.D0*Hr5(1,0,1,1,0) + 256.D0*
     &    Hr5(1,0,1,1,0)*x - 256.D0*Hr5(1,0,1,1,0)*x**2 - 1408.D0/3.D0*
     &    Hr5(1,1,0,-1,0) + 2816.D0/3.D0*Hr5(1,1,0,-1,0)*x - 1664.D0/3.D
     &    0*Hr5(1,1,0,-1,0)*x**2 + 856.D0/3.D0*Hr5(1,1,0,0,0) - 1712.D0/
     &    3.D0*Hr5(1,1,0,0,0)*x + 368.D0/3.D0*Hr5(1,1,0,0,0)*x**2 - 384.
     &    D0*Hr5(1,1,0,0,1) + 768.D0*Hr5(1,1,0,0,1)*x - 448.D0*Hr5(1,1,
     &    0,0,1)*x**2 - 184.D0*Hr5(1,1,0,1,0) + 368.D0*Hr5(1,1,0,1,0)*x
     &     - 368.D0*Hr5(1,1,0,1,0)*x**2 - 32.D0*Hr5(1,1,0,1,1) + 64.D0*
     &    Hr5(1,1,0,1,1)*x - 64.D0*Hr5(1,1,0,1,1)*x**2 + 832.D0/3.D0*
     &    Hr5(1,1,1,0,0) - 1664.D0/3.D0*Hr5(1,1,1,0,0)*x + 320.D0/3.D0*
     &    Hr5(1,1,1,0,0)*x**2 - 104.D0*Hr5(1,1,1,0,1) + 208.D0*Hr5(1,1,
     &    1,0,1)*x - 208.D0*Hr5(1,1,1,0,1)*x**2 - 136.D0*Hr5(1,1,1,1,0)
     &     + 272.D0*Hr5(1,1,1,1,0)*x )
      c2gg3 = c2gg3 + nf*cf*ca * (  - 272.D0*Hr5(1,1,1,1,0)*x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * ( 149023.D0/600.D0 + 399401.D0/300.D0*
     &    x - 115586.D0/75.D0*x**2 - 124.D0*z5 - 23032.D0/3.D0*z5*x + 
     &    368.D0*z5*x**2 + 544.D0/3.D0*z4 + 1354.D0/3.D0*z4*x - 10088.D0
     &    /3.D0*z4*x**2 - 6336.D0/5.D0*z4*x**3 - 964.D0/75.D0*dx + 
     &    11107.D0/15.D0*z3 + 267682.D0/45.D0*z3*x + 3956.D0/15.D0*z3*
     &    x**2 - 352.D0*z3*x**3 - 368.D0/15.D0*z3*dx - 4598.D0/45.D0*z2
     &     + 166993.D0/45.D0*z2*x + 14444.D0/15.D0*z2*x**2 - 8528.D0/25.
     &    D0*z2*x**3 - 592.D0/45.D0*z2*dx - 160.D0*z2*z3 + 256.D0/3.D0*
     &    z2*z3*x - 832.D0*z2*z3*x**2 + 2336.D0/3.D0*Hr1(-1)*z4 + 9280.D
     &    0/3.D0*Hr1(-1)*z4*x + 6304.D0/3.D0*Hr1(-1)*z4*x**2 - 184.D0*
     &    Hr1(-1)*z3 - 352.D0*Hr1(-1)*z3*x + 104.D0*Hr1(-1)*z3*x**2 + 
     &    1152.D0/5.D0*Hr1(-1)*z3*x**3 + 32.D0/5.D0*Hr1(-1)*z3*dx**2 - 
     &    49604.D0/15.D0*Hr1(-1)*z2 - 73544.D0/15.D0*Hr1(-1)*z2*x - 
     &    8364.D0/5.D0*Hr1(-1)*z2*x**2 + 1056.D0/5.D0*Hr1(-1)*z2*x**3
     &     + 128.D0/15.D0*Hr1(-1)*z2*dx + 88.D0/15.D0*Hr1(-1)*z2*dx**2
     &     + 13594.D0/225.D0*Hr1(0) )
      c2gg3 = c2gg3 + nf*cf**2 * ( 37658.D0/75.D0*Hr1(0)*x - 61902.D0/
     &    25.D0*Hr1(0)*x**2 - 14.D0/3.D0*Hr1(0)*z4 + 3308.D0/3.D0*Hr1(0
     &    )*z4*x - 224.D0*Hr1(0)*z4*x**2 + 644.D0/75.D0*Hr1(0)*dx + 300.
     &    D0*Hr1(0)*z3 - 12284.D0/3.D0*Hr1(0)*z3*x + 2456.D0/3.D0*Hr1(0
     &    )*z3*x**2 - 4416.D0/5.D0*Hr1(0)*z3*x**3 + 1511.D0/15.D0*Hr1(0
     &    )*z2 + 14602.D0/9.D0*Hr1(0)*z2*x + 13516.D0/5.D0*Hr1(0)*z2*
     &    x**2 - 1408.D0/5.D0*Hr1(0)*z2*x**3 + 16.D0/3.D0*Hr1(0)*z2*dx
     &     + 32906.D0/45.D0*Hr1(1) + 10906.D0/5.D0*Hr1(1)*x - 14918.D0/
     &    5.D0*Hr1(1)*x**2 + 328.D0/3.D0*Hr1(1)*z4 - 656.D0/3.D0*Hr1(1)
     &    *z4*x - 1168.D0/3.D0*Hr1(1)*z4*x**2 - 608.D0/45.D0*Hr1(1)*dx
     &     + 4912.D0/3.D0*Hr1(1)*z3 - 3088.D0/3.D0*Hr1(1)*z3*x + 2384.D0
     &    /3.D0*Hr1(1)*z3*x**2 - 3264.D0/5.D0*Hr1(1)*z3*x**3 + 272.D0/
     &    15.D0*Hr1(1)*z3*dx**2 - 2230.D0/3.D0*Hr1(1)*z2 - 5324.D0/9.D0
     &    *Hr1(1)*z2*x + 1376.D0*Hr1(1)*z2*x**2 - 352.D0/5.D0*Hr1(1)*z2
     &    *x**3 + 88.D0/45.D0*Hr1(1)*z2*dx**2 - 400.D0/3.D0*Hr2(-1,-1)*
     &    z3 )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 800.D0/3.D0*Hr2(-1,-1)*z3*x + 352.
     &    D0/3.D0*Hr2(-1,-1)*z3*x**2 + 8.D0*Hr2(-1,-1)*z2 + 320.D0/3.D0
     &    *Hr2(-1,-1)*z2*x - 264.D0*Hr2(-1,-1)*z2*x**2 - 1536.D0/5.D0*
     &    Hr2(-1,-1)*z2*x**3 - 128.D0/15.D0*Hr2(-1,-1)*z2*dx**2 + 
     &    224536.D0/45.D0*Hr2(-1,0) + 281416.D0/45.D0*Hr2(-1,0)*x + 
     &    17032.D0/15.D0*Hr2(-1,0)*x**2 - 8528.D0/25.D0*Hr2(-1,0)*x**3
     &     + 16.D0/45.D0*Hr2(-1,0)*dx - 1852.D0/225.D0*Hr2(-1,0)*dx**2
     &     + 1904.D0/3.D0*Hr2(-1,0)*z3 + 6112.D0/3.D0*Hr2(-1,0)*z3*x + 
     &    4000.D0/3.D0*Hr2(-1,0)*z3*x**2 + 248.D0/3.D0*Hr2(-1,0)*z2 - 
     &    496.D0/3.D0*Hr2(-1,0)*z2*x + 120.D0*Hr2(-1,0)*z2*x**2 + 1152.D
     &    0/5.D0*Hr2(-1,0)*z2*x**3 + 32.D0/5.D0*Hr2(-1,0)*z2*dx**2 + 96.
     &    D0*Hr2(0,-1)*z3 + 320.D0*Hr2(0,-1)*z3*x - 352.D0/3.D0*Hr2(0,
     &    -1)*z3*x**2 - 1160.D0*Hr2(0,-1)*z2 + 1728.D0*Hr2(0,-1)*z2*x
     &     + 136.D0*Hr2(0,-1)*z2*x**2 + 1536.D0/5.D0*Hr2(0,-1)*z2*x**3
     &     - 872.D0/9.D0*Hr2(0,0) - 36848.D0/9.D0*Hr2(0,0)*x - 5008.D0/
     &    3.D0*Hr2(0,0)*x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * ( 8528.D0/25.D0*Hr2(0,0)*x**3 + 176.D0/
     &    45.D0*Hr2(0,0)*dx + 284.D0*Hr2(0,0)*z3 - 760.D0*Hr2(0,0)*z3*x
     &     + 3712.D0/3.D0*Hr2(0,0)*z3*x**2 + 284.D0/3.D0*Hr2(0,0)*z2 - 
     &    540.D0*Hr2(0,0)*z2*x + 8336.D0/3.D0*Hr2(0,0)*z2*x**2 + 192.D0
     &    *Hr2(0,0)*z2*x**3 + 4598.D0/45.D0*Hr2(0,1) + 38141.D0/15.D0*
     &    Hr2(0,1)*x - 14444.D0/15.D0*Hr2(0,1)*x**2 + 608.D0/45.D0*Hr2(
     &    0,1)*dx + 3152.D0/3.D0*Hr2(0,1)*z3 - 160.D0/3.D0*Hr2(0,1)*z3*
     &    x + 6976.D0/3.D0*Hr2(0,1)*z3*x**2 - 700.D0/3.D0*Hr2(0,1)*z2
     &     - 1576.D0*Hr2(0,1)*z2*x + 3904.D0/3.D0*Hr2(0,1)*z2*x**2 - 
     &    239.D0/3.D0*Hr2(1,0) + 3650.D0/3.D0*Hr2(1,0)*x - 3560.D0/3.D0
     &    *Hr2(1,0)*x**2 + 2896.D0/3.D0*Hr2(1,0)*z3 - 5792.D0/3.D0*Hr2(
     &    1,0)*z3*x + 4256.D0/3.D0*Hr2(1,0)*z3*x**2 - 1276.D0*Hr2(1,0)*
     &    z2 - 4336.D0/3.D0*Hr2(1,0)*z2*x + 7928.D0/3.D0*Hr2(1,0)*z2*
     &    x**2 + 2112.D0/5.D0*Hr2(1,0)*z2*x**3 - 176.D0/15.D0*Hr2(1,0)*
     &    z2*dx**2 - 55.D0/3.D0*Hr2(1,1) + 4198.D0/3.D0*Hr2(1,1)*x - 
     &    4348.D0/3.D0*Hr2(1,1)*x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * ( 2720.D0/3.D0*Hr2(1,1)*z3 - 5440.D0/3.
     &    D0*Hr2(1,1)*z3*x + 3520.D0/3.D0*Hr2(1,1)*z3*x**2 - 124.D0/3.D0
     &    *Hr2(1,1)*z2 - 832.D0*Hr2(1,1)*z2*x + 3520.D0/3.D0*Hr2(1,1)*
     &    z2*x**2 + 832.D0/3.D0*Hr3(-1,-1,-1)*z2 + 1664.D0/3.D0*Hr3(-1,
     &    -1,-1)*z2*x + 128.D0/3.D0*Hr3(-1,-1,-1)*z2*x**2 - 7288.D0/3.D0
     &    *Hr3(-1,-1,0) - 15920.D0/9.D0*Hr3(-1,-1,0)*x + 728.D0*Hr3(-1,
     &    -1,0)*x**2 + 704.D0/5.D0*Hr3(-1,-1,0)*x**3 + 176.D0/45.D0*
     &    Hr3(-1,-1,0)*dx**2 - 96.D0*Hr3(-1,-1,0)*z2 - 192.D0*Hr3(-1,-1
     &    ,0)*z2*x + 192.D0*Hr3(-1,-1,0)*z2*x**2 - 32.D0/3.D0*Hr3(-1,0,
     &    -1)*z2 - 64.D0/3.D0*Hr3(-1,0,-1)*z2*x + 704.D0/3.D0*Hr3(-1,0,
     &    -1)*z2*x**2 + 57512.D0/15.D0*Hr3(-1,0,0) + 216856.D0/45.D0*
     &    Hr3(-1,0,0)*x + 14296.D0/15.D0*Hr3(-1,0,0)*x**2 - 1472.D0/5.D0
     &    *Hr3(-1,0,0)*x**3 - 64.D0/15.D0*Hr3(-1,0,0)*dx - 368.D0/45.D0
     &    *Hr3(-1,0,0)*dx**2 - 256.D0*Hr3(-1,0,0)*z2 - 1280.D0*Hr3(-1,0
     &    ,0)*z2*x - 1152.D0*Hr3(-1,0,0)*z2*x**2 + 31384.D0/15.D0*Hr3(
     &    -1,0,1) )
      c2gg3 = c2gg3 + nf*cf**2 * ( 180832.D0/45.D0*Hr3(-1,0,1)*x + 
     &    10184.D0/5.D0*Hr3(-1,0,1)*x**2 - 704.D0/5.D0*Hr3(-1,0,1)*x**3
     &     - 128.D0/15.D0*Hr3(-1,0,1)*dx - 176.D0/45.D0*Hr3(-1,0,1)*
     &    dx**2 + 64.D0*Hr3(-1,0,1)*z2 + 128.D0*Hr3(-1,0,1)*z2*x + 128.D
     &    0*Hr3(-1,0,1)*z2*x**2 - 208.D0*Hr3(0,-1,-1)*z2 - 416.D0*Hr3(0
     &    ,-1,-1)*z2*x - 128.D0/3.D0*Hr3(0,-1,-1)*z2*x**2 + 39088.D0/15.
     &    D0*Hr3(0,-1,0) + 29776.D0/45.D0*Hr3(0,-1,0)*x - 2872.D0/5.D0*
     &    Hr3(0,-1,0)*x**2 - 704.D0/5.D0*Hr3(0,-1,0)*x**3 - 64.D0/15.D0
     &    *Hr3(0,-1,0)*dx - 64.D0/15.D0*Hr3(0,-1,0)*dx**2 + 160.D0*Hr3(
     &    0,-1,0)*z2 + 640.D0/3.D0*Hr3(0,-1,0)*z2*x - 192.D0*Hr3(0,-1,0
     &    )*z2*x**2 - 1264.D0/3.D0*Hr3(0,0,-1)*z2 - 32.D0*Hr3(0,0,-1)*
     &    z2*x - 2624.D0/3.D0*Hr3(0,0,-1)*z2*x**2 - 178.D0/3.D0*Hr3(0,0
     &    ,0) - 74476.D0/45.D0*Hr3(0,0,0)*x - 1128.D0*Hr3(0,0,0)*x**2
     &     + 1472.D0/5.D0*Hr3(0,0,0)*x**3 + 64.D0/15.D0*Hr3(0,0,0)*dx
     &     + 524.D0/3.D0*Hr3(0,0,0)*z2 - 664.D0/3.D0*Hr3(0,0,0)*z2*x + 
     &    2624.D0/3.D0*Hr3(0,0,0)*z2*x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 1511.D0/15.D0*Hr3(0,0,1) - 43234.D
     &    0/45.D0*Hr3(0,0,1)*x - 13516.D0/5.D0*Hr3(0,0,1)*x**2 + 704.D0/
     &    5.D0*Hr3(0,0,1)*x**3 - 48.D0/5.D0*Hr3(0,0,1)*dx + 160.D0/3.D0
     &    *Hr3(0,0,1)*z2 - 2368.D0/3.D0*Hr3(0,0,1)*z2*x + 1504.D0/3.D0*
     &    Hr3(0,0,1)*z2*x**2 - 464.D0/3.D0*Hr3(0,1,0) + 1592.D0*Hr3(0,1
     &    ,0)*x - 3268.D0/3.D0*Hr3(0,1,0)*x**2 - 376.D0*Hr3(0,1,0)*z2
     &     - 7856.D0/3.D0*Hr3(0,1,0)*z2*x - 800.D0*Hr3(0,1,0)*z2*x**2
     &     - 628.D0/3.D0*Hr3(0,1,1) + 5272.D0/3.D0*Hr3(0,1,1)*x - 1212.D
     &    0*Hr3(0,1,1)*x**2 + 376.D0/3.D0*Hr3(0,1,1)*z2 - 784.D0*Hr3(0,
     &    1,1)*z2*x + 544.D0*Hr3(0,1,1)*z2*x**2 - 448.D0*Hr3(1,0,-1)*z2
     &     + 896.D0*Hr3(1,0,-1)*z2*x - 640.D0*Hr3(1,0,-1)*z2*x**2 - 
     &    1066.D0/15.D0*Hr3(1,0,0) + 9316.D0/15.D0*Hr3(1,0,0)*x - 7808.D
     &    0/15.D0*Hr3(1,0,0)*x**2 + 208.D0/15.D0*Hr3(1,0,0)*dx + 464.D0
     &    *Hr3(1,0,0)*z2 - 928.D0*Hr3(1,0,0)*z2*x + 864.D0*Hr3(1,0,0)*
     &    z2*x**2 - 1414.D0/3.D0*Hr3(1,0,1) + 1476.D0*Hr3(1,0,1)*x - 
     &    1012.D0*Hr3(1,0,1)*x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * ( 944.D0/3.D0*Hr3(1,0,1)*z2 - 1888.D0/
     &    3.D0*Hr3(1,0,1)*z2*x + 1888.D0/3.D0*Hr3(1,0,1)*z2*x**2 - 482.D
     &    0*Hr3(1,1,0) + 4564.D0/3.D0*Hr3(1,1,0)*x - 3268.D0/3.D0*Hr3(1
     &    ,1,0)*x**2 + 128.D0/3.D0*Hr3(1,1,0)*z2 - 256.D0/3.D0*Hr3(1,1,
     &    0)*z2*x + 1024.D0/3.D0*Hr3(1,1,0)*z2*x**2 - 522.D0*Hr3(1,1,1)
     &     + 4948.D0/3.D0*Hr3(1,1,1)*x - 1212.D0*Hr3(1,1,1)*x**2 + 272.D
     &    0*Hr3(1,1,1)*z2 - 544.D0*Hr3(1,1,1)*z2*x + 544.D0*Hr3(1,1,1)*
     &    z2*x**2 + 1040.D0*Hr4(-1,-1,-1,0) + 1216.D0*Hr4(-1,-1,-1,0)*x
     &     + 176.D0*Hr4(-1,-1,-1,0)*x**2 - 984.D0*Hr4(-1,-1,0,0) - 1072.
     &    D0*Hr4(-1,-1,0,0)*x + 280.D0/3.D0*Hr4(-1,-1,0,0)*x**2 + 768.D0
     &    /5.D0*Hr4(-1,-1,0,0)*x**3 + 64.D0/15.D0*Hr4(-1,-1,0,0)*dx**2
     &     + 512.D0*Hr4(-1,-1,0,1) + 1504.D0/3.D0*Hr4(-1,-1,0,1)*x + 
     &    352.D0*Hr4(-1,-1,0,1)*x**2 + 1536.D0/5.D0*Hr4(-1,-1,0,1)*x**3
     &     + 128.D0/15.D0*Hr4(-1,-1,0,1)*dx**2 - 848.D0*Hr4(-1,0,-1,0)
     &     - 2656.D0/3.D0*Hr4(-1,0,-1,0)*x - 112.D0/3.D0*Hr4(-1,0,-1,0)
     &    *x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * ( 640.D0*Hr4(-1,0,0,0) + 3088.D0/3.D0*
     &    Hr4(-1,0,0,0)*x + 608.D0/3.D0*Hr4(-1,0,0,0)*x**2 - 384.D0/5.D0
     &    *Hr4(-1,0,0,0)*x**3 - 32.D0/15.D0*Hr4(-1,0,0,0)*dx**2 - 96.D0
     &    *Hr4(-1,0,0,1) + 448.D0/3.D0*Hr4(-1,0,0,1)*x + 64.D0*Hr4(-1,0
     &    ,0,1)*x**2 - 768.D0/5.D0*Hr4(-1,0,0,1)*x**3 - 64.D0/15.D0*
     &    Hr4(-1,0,0,1)*dx**2 + 64.D0*Hr4(-1,0,1,0) + 160.D0*Hr4(-1,0,1
     &    ,0)*x + 96.D0*Hr4(-1,0,1,0)*x**2 + 64.D0*Hr4(-1,0,1,1) + 160.D
     &    0*Hr4(-1,0,1,1)*x + 96.D0*Hr4(-1,0,1,1)*x**2 - 1072.D0*Hr4(0,
     &    -1,-1,0) + 1024.D0*Hr4(0,-1,-1,0)*x + 80.D0*Hr4(0,-1,-1,0)*
     &    x**2 + 4592.D0/3.D0*Hr4(0,-1,0,0) - 3040.D0/3.D0*Hr4(0,-1,0,0
     &    )*x - 280.D0/3.D0*Hr4(0,-1,0,0)*x**2 - 768.D0/5.D0*Hr4(0,-1,0
     &    ,0)*x**3 + 624.D0*Hr4(0,-1,0,1) - 1216.D0*Hr4(0,-1,0,1)*x - 
     &    96.D0*Hr4(0,-1,0,1)*x**2 - 1536.D0/5.D0*Hr4(0,-1,0,1)*x**3 + 
     &    3488.D0/3.D0*Hr4(0,0,-1,0) - 384.D0*Hr4(0,0,-1,0)*x + 560.D0/
     &    3.D0*Hr4(0,0,-1,0)*x**2 - 768.D0/5.D0*Hr4(0,0,-1,0)*x**3 + 44.
     &    D0/3.D0*Hr4(0,0,0,0) )
      c2gg3 = c2gg3 + nf*cf**2 * ( 244.D0/3.D0*Hr4(0,0,0,0)*x - 3680.D0/
     &    3.D0*Hr4(0,0,0,0)*x**2 + 768.D0/5.D0*Hr4(0,0,0,0)*x**3 - 284.D
     &    0/3.D0*Hr4(0,0,0,1) + 156.D0*Hr4(0,0,0,1)*x - 8336.D0/3.D0*
     &    Hr4(0,0,0,1)*x**2 - 1728.D0/5.D0*Hr4(0,0,0,1)*x**3 - 532.D0/3.
     &    D0*Hr4(0,0,1,0) + 1880.D0/3.D0*Hr4(0,0,1,0)*x - 1280.D0*Hr4(0
     &    ,0,1,0)*x**2 - 248.D0*Hr4(0,0,1,1) + 2536.D0/3.D0*Hr4(0,0,1,1
     &    )*x - 1504.D0*Hr4(0,0,1,1)*x**2 + 140.D0/3.D0*Hr4(0,1,0,0) + 
     &    2184.D0*Hr4(0,1,0,0)*x + 760.D0/3.D0*Hr4(0,1,0,0)*x**2 + 2496.
     &    D0/5.D0*Hr4(0,1,0,0)*x**3 - 908.D0/3.D0*Hr4(0,1,0,1) + 1064.D0
     &    *Hr4(0,1,0,1)*x - 3784.D0/3.D0*Hr4(0,1,0,1)*x**2 - 964.D0/3.D0
     &    *Hr4(0,1,1,0) + 1032.D0*Hr4(0,1,1,0)*x - 3800.D0/3.D0*Hr4(0,1
     &    ,1,0)*x**2 - 364.D0*Hr4(0,1,1,1) + 3488.D0/3.D0*Hr4(0,1,1,1)*
     &    x - 4096.D0/3.D0*Hr4(0,1,1,1)*x**2 + 2464.D0/3.D0*Hr4(1,0,-1,
     &    0) - 2560.D0/3.D0*Hr4(1,0,-1,0)*x + 1216.D0/3.D0*Hr4(1,0,-1,0
     &    )*x**2 - 768.D0/5.D0*Hr4(1,0,-1,0)*x**3 + 64.D0/15.D0*Hr4(1,0
     &    ,-1,0)*dx**2 )
      c2gg3 = c2gg3 + nf*cf**2 * ( 92.D0/3.D0*Hr4(1,0,0,0) + 1952.D0/3.D
     &    0*Hr4(1,0,0,0)*x - 1024.D0*Hr4(1,0,0,0)*x**2 + 384.D0/5.D0*
     &    Hr4(1,0,0,0)*x**3 - 32.D0/15.D0*Hr4(1,0,0,0)*dx**2 + 3788.D0/
     &    3.D0*Hr4(1,0,0,1) + 4384.D0/3.D0*Hr4(1,0,0,1)*x - 7376.D0/3.D0
     &    *Hr4(1,0,0,1)*x**2 - 2496.D0/5.D0*Hr4(1,0,0,1)*x**3 + 208.D0/
     &    15.D0*Hr4(1,0,0,1)*dx**2 - 1472.D0/3.D0*Hr4(1,0,1,0) + 4256.D0
     &    /3.D0*Hr4(1,0,1,0)*x - 1184.D0*Hr4(1,0,1,0)*x**2 - 1652.D0/3.D
     &    0*Hr4(1,0,1,1) + 4928.D0/3.D0*Hr4(1,0,1,1)*x - 1408.D0*Hr4(1,
     &    0,1,1)*x**2 - 1604.D0*Hr4(1,1,0,0) + 1792.D0/3.D0*Hr4(1,1,0,0
     &    )*x + 760.D0/3.D0*Hr4(1,1,0,0)*x**2 + 2496.D0/5.D0*Hr4(1,1,0,
     &    0)*x**3 - 208.D0/15.D0*Hr4(1,1,0,0)*dx**2 - 1436.D0/3.D0*Hr4(
     &    1,1,0,1) + 1440.D0*Hr4(1,1,0,1)*x - 3784.D0/3.D0*Hr4(1,1,0,1)
     &    *x**2 - 1516.D0/3.D0*Hr4(1,1,1,0) + 1488.D0*Hr4(1,1,1,0)*x - 
     &    3800.D0/3.D0*Hr4(1,1,1,0)*x**2 - 1588.D0/3.D0*Hr4(1,1,1,1) + 
     &    4688.D0/3.D0*Hr4(1,1,1,1)*x - 4096.D0/3.D0*Hr4(1,1,1,1)*x**2
     &     - 640.D0/3.D0*Hr5(-1,-1,-1,-1,0) )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 1280.D0/3.D0*Hr5(-1,-1,-1,-1,0)*x
     &     - 1280.D0/3.D0*Hr5(-1,-1,-1,-1,0)*x**2 + 192.D0*Hr5(-1,-1,-1
     &    ,0,0) + 384.D0*Hr5(-1,-1,-1,0,0)*x + 640.D0*Hr5(-1,-1,-1,0,0)
     &    *x**2 - 384.D0*Hr5(-1,-1,-1,0,1) - 768.D0*Hr5(-1,-1,-1,0,1)*x
     &     - 256.D0*Hr5(-1,-1,-1,0,1)*x**2 + 640.D0/3.D0*Hr5(-1,-1,0,-1
     &    ,0) + 1280.D0/3.D0*Hr5(-1,-1,0,-1,0)*x + 1280.D0/3.D0*Hr5(-1,
     &    -1,0,-1,0)*x**2 - 320.D0*Hr5(-1,-1,0,0,0) - 640.D0*Hr5(-1,-1,
     &    0,0,0)*x - 768.D0*Hr5(-1,-1,0,0,0)*x**2 + 32.D0*Hr5(-1,-1,0,0
     &    ,1) + 64.D0*Hr5(-1,-1,0,0,1)*x - 192.D0*Hr5(-1,-1,0,0,1)*x**2
     &     - 64.D0*Hr5(-1,-1,0,1,0) - 128.D0*Hr5(-1,-1,0,1,0)*x - 128.D0
     &    *Hr5(-1,-1,0,1,0)*x**2 - 64.D0*Hr5(-1,-1,0,1,1) - 128.D0*Hr5(
     &    -1,-1,0,1,1)*x - 128.D0*Hr5(-1,-1,0,1,1)*x**2 + 704.D0/3.D0*
     &    Hr5(-1,0,-1,-1,0) + 1408.D0/3.D0*Hr5(-1,0,-1,-1,0)*x + 1408.D0
     &    /3.D0*Hr5(-1,0,-1,-1,0)*x**2 - 288.D0*Hr5(-1,0,-1,0,0) - 576.D
     &    0*Hr5(-1,0,-1,0,0)*x - 704.D0*Hr5(-1,0,-1,0,0)*x**2 + 128.D0*
     &    Hr5(-1,0,-1,0,1) )
      c2gg3 = c2gg3 + nf*cf**2 * ( 256.D0*Hr5(-1,0,-1,0,1)*x - 640.D0/3.
     &    D0*Hr5(-1,0,0,-1,0) - 1280.D0/3.D0*Hr5(-1,0,0,-1,0)*x - 1664.D
     &    0/3.D0*Hr5(-1,0,0,-1,0)*x**2 - 112.D0/3.D0*Hr5(-1,0,0,0,0) - 
     &    224.D0/3.D0*Hr5(-1,0,0,0,0)*x + 160.D0/3.D0*Hr5(-1,0,0,0,0)*
     &    x**2 + 384.D0*Hr5(-1,0,0,0,1) + 1536.D0*Hr5(-1,0,0,0,1)*x + 
     &    1280.D0*Hr5(-1,0,0,0,1)*x**2 + 32.D0*Hr5(-1,0,0,1,0) + 64.D0*
     &    Hr5(-1,0,0,1,0)*x + 64.D0*Hr5(-1,0,0,1,0)*x**2 + 32.D0*Hr5(-1
     &    ,0,0,1,1) + 64.D0*Hr5(-1,0,0,1,1)*x + 64.D0*Hr5(-1,0,0,1,1)*
     &    x**2 - 1376.D0/3.D0*Hr5(-1,0,1,0,0) - 5056.D0/3.D0*Hr5(-1,0,1
     &    ,0,0)*x - 3904.D0/3.D0*Hr5(-1,0,1,0,0)*x**2 + 288.D0*Hr5(0,-1
     &    ,-1,-1,0) - 448.D0*Hr5(0,-1,-1,-1,0)*x + 1280.D0/3.D0*Hr5(0,
     &    -1,-1,-1,0)*x**2 - 224.D0*Hr5(0,-1,-1,0,0) + 1984.D0/3.D0*
     &    Hr5(0,-1,-1,0,0)*x - 640.D0*Hr5(0,-1,-1,0,0)*x**2 + 352.D0*
     &    Hr5(0,-1,-1,0,1) + 192.D0*Hr5(0,-1,-1,0,1)*x + 256.D0*Hr5(0,
     &    -1,-1,0,1)*x**2 - 256.D0*Hr5(0,-1,0,-1,0) + 1280.D0/3.D0*Hr5(
     &    0,-1,0,-1,0)*x )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 1280.D0/3.D0*Hr5(0,-1,0,-1,0)*
     &    x**2 + 592.D0/3.D0*Hr5(0,-1,0,0,0) - 608.D0/3.D0*Hr5(0,-1,0,0
     &    ,0)*x + 768.D0*Hr5(0,-1,0,0,0)*x**2 - 96.D0*Hr5(0,-1,0,0,1)
     &     + 64.D0*Hr5(0,-1,0,0,1)*x + 192.D0*Hr5(0,-1,0,0,1)*x**2 + 32.
     &    D0*Hr5(0,-1,0,1,0) + 64.D0*Hr5(0,-1,0,1,0)*x + 128.D0*Hr5(0,
     &    -1,0,1,0)*x**2 + 32.D0*Hr5(0,-1,0,1,1) + 64.D0*Hr5(0,-1,0,1,1
     &    )*x + 128.D0*Hr5(0,-1,0,1,1)*x**2 - 1184.D0/3.D0*Hr5(0,0,-1,
     &    -1,0) + 576.D0*Hr5(0,0,-1,-1,0)*x - 2176.D0/3.D0*Hr5(0,0,-1,
     &    -1,0)*x**2 + 1888.D0/3.D0*Hr5(0,0,-1,0,0) - 128.D0*Hr5(0,0,-1
     &    ,0,0)*x + 4672.D0/3.D0*Hr5(0,0,-1,0,0)*x**2 + 224.D0*Hr5(0,0,
     &    -1,0,1) + 320.D0*Hr5(0,0,-1,0,1)*x + 512.D0*Hr5(0,0,-1,0,1)*
     &    x**2 + 1600.D0/3.D0*Hr5(0,0,0,-1,0) + 4096.D0/3.D0*Hr5(0,0,0,
     &    -1,0)*x**2 - 60.D0*Hr5(0,0,0,0,0) - 184.D0/3.D0*Hr5(0,0,0,0,0
     &    )*x - 480.D0*Hr5(0,0,0,0,0)*x**2 - 524.D0/3.D0*Hr5(0,0,0,0,1)
     &     + 664.D0/3.D0*Hr5(0,0,0,0,1)*x - 2624.D0/3.D0*Hr5(0,0,0,0,1)
     &    *x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 608.D0/3.D0*Hr5(0,0,0,1,0) + 1024.
     &    D0/3.D0*Hr5(0,0,0,1,0)*x - 2528.D0/3.D0*Hr5(0,0,0,1,0)*x**2
     &     - 808.D0/3.D0*Hr5(0,0,0,1,1) + 1424.D0/3.D0*Hr5(0,0,0,1,1)*x
     &     - 3136.D0/3.D0*Hr5(0,0,0,1,1)*x**2 - 224.D0/3.D0*Hr5(0,0,1,0
     &    ,0) + 1472.D0/3.D0*Hr5(0,0,1,0,0)*x - 1568.D0/3.D0*Hr5(0,0,1,
     &    0,0)*x**2 - 752.D0/3.D0*Hr5(0,0,1,0,1) + 1504.D0/3.D0*Hr5(0,0
     &    ,1,0,1)*x - 864.D0*Hr5(0,0,1,0,1)*x**2 - 704.D0/3.D0*Hr5(0,0,
     &    1,1,0) + 1408.D0/3.D0*Hr5(0,0,1,1,0)*x - 800.D0*Hr5(0,0,1,1,0
     &    )*x**2 - 872.D0/3.D0*Hr5(0,0,1,1,1) + 1744.D0/3.D0*Hr5(0,0,1,
     &    1,1)*x - 2816.D0/3.D0*Hr5(0,0,1,1,1)*x**2 + 384.D0*Hr5(0,1,0,
     &    -1,0) - 128.D0*Hr5(0,1,0,-1,0)*x + 1280.D0/3.D0*Hr5(0,1,0,-1,
     &    0)*x**2 - 344.D0/3.D0*Hr5(0,1,0,0,0) + 2480.D0/3.D0*Hr5(0,1,0
     &    ,0,0)*x - 928.D0/3.D0*Hr5(0,1,0,0,0)*x**2 + 440.D0*Hr5(0,1,0,
     &    0,1) + 7024.D0/3.D0*Hr5(0,1,0,0,1)*x + 800.D0*Hr5(0,1,0,0,1)*
     &    x**2 - 704.D0/3.D0*Hr5(0,1,0,1,0) + 448.D0*Hr5(0,1,0,1,0)*x
     &     - 2048.D0/3.D0*Hr5(0,1,0,1,0)*x**2 )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 968.D0/3.D0*Hr5(0,1,0,1,1) + 1936.
     &    D0/3.D0*Hr5(0,1,0,1,1)*x - 2624.D0/3.D0*Hr5(0,1,0,1,1)*x**2
     &     - 2392.D0/3.D0*Hr5(0,1,1,0,0) - 3152.D0/3.D0*Hr5(0,1,1,0,0)*
     &    x - 6208.D0/3.D0*Hr5(0,1,1,0,0)*x**2 - 808.D0/3.D0*Hr5(0,1,1,
     &    0,1) + 560.D0*Hr5(0,1,1,0,1)*x - 2272.D0/3.D0*Hr5(0,1,1,0,1)*
     &    x**2 - 808.D0/3.D0*Hr5(0,1,1,1,0) + 1552.D0/3.D0*Hr5(0,1,1,1,
     &    0)*x - 2176.D0/3.D0*Hr5(0,1,1,1,0)*x**2 - 904.D0/3.D0*Hr5(0,1
     &    ,1,1,1) + 1808.D0/3.D0*Hr5(0,1,1,1,1)*x - 800.D0*Hr5(0,1,1,1,
     &    1)*x**2 - 128.D0*Hr5(1,0,-1,-1,0) + 256.D0*Hr5(1,0,-1,-1,0)*x
     &     - 256.D0*Hr5(1,0,-1,-1,0)*x**2 + 1472.D0/3.D0*Hr5(1,0,-1,0,0
     &    ) - 2944.D0/3.D0*Hr5(1,0,-1,0,0)*x + 2560.D0/3.D0*Hr5(1,0,-1,
     &    0,0)*x**2 + 384.D0*Hr5(1,0,-1,0,1) - 768.D0*Hr5(1,0,-1,0,1)*x
     &     + 512.D0*Hr5(1,0,-1,0,1)*x**2 + 1408.D0/3.D0*Hr5(1,0,0,-1,0)
     &     - 2816.D0/3.D0*Hr5(1,0,0,-1,0)*x + 2432.D0/3.D0*Hr5(1,0,0,-1
     &    ,0)*x**2 - 832.D0/3.D0*Hr5(1,0,0,0,0) + 1664.D0/3.D0*Hr5(1,0,
     &    0,0,0)*x )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 1280.D0/3.D0*Hr5(1,0,0,0,0)*x**2
     &     - 336.D0*Hr5(1,0,0,0,1) + 672.D0*Hr5(1,0,0,0,1)*x - 736.D0*
     &    Hr5(1,0,0,0,1)*x**2 - 1168.D0/3.D0*Hr5(1,0,0,1,0) + 2336.D0/3.
     &    D0*Hr5(1,0,0,1,0)*x - 2336.D0/3.D0*Hr5(1,0,0,1,0)*x**2 - 496.D
     &    0*Hr5(1,0,0,1,1) + 992.D0*Hr5(1,0,0,1,1)*x - 992.D0*Hr5(1,0,0
     &    ,1,1)*x**2 - 1312.D0/3.D0*Hr5(1,0,1,0,0) + 2624.D0/3.D0*Hr5(1
     &    ,0,1,0,0)*x - 2048.D0/3.D0*Hr5(1,0,1,0,0)*x**2 - 432.D0*Hr5(1
     &    ,0,1,0,1) + 864.D0*Hr5(1,0,1,0,1)*x - 864.D0*Hr5(1,0,1,0,1)*
     &    x**2 - 1184.D0/3.D0*Hr5(1,0,1,1,0) + 2368.D0/3.D0*Hr5(1,0,1,1
     &    ,0)*x - 2368.D0/3.D0*Hr5(1,0,1,1,0)*x**2 - 1408.D0/3.D0*Hr5(1
     &    ,0,1,1,1) + 2816.D0/3.D0*Hr5(1,0,1,1,1)*x - 2816.D0/3.D0*Hr5(
     &    1,0,1,1,1)*x**2 + 1024.D0/3.D0*Hr5(1,1,0,-1,0) - 2048.D0/3.D0
     &    *Hr5(1,1,0,-1,0)*x + 1280.D0/3.D0*Hr5(1,1,0,-1,0)*x**2 - 656.D
     &    0/3.D0*Hr5(1,1,0,0,0) + 1312.D0/3.D0*Hr5(1,1,0,0,0)*x - 928.D0
     &    /3.D0*Hr5(1,1,0,0,0)*x**2 + 64.D0/3.D0*Hr5(1,1,0,0,1) - 128.D0
     &    /3.D0*Hr5(1,1,0,0,1)*x )
      c2gg3 = c2gg3 + nf*cf**2 * (  - 1024.D0/3.D0*Hr5(1,1,0,0,1)*x**2
     &     - 1024.D0/3.D0*Hr5(1,1,0,1,0) + 2048.D0/3.D0*Hr5(1,1,0,1,0)*
     &    x - 2048.D0/3.D0*Hr5(1,1,0,1,0)*x**2 - 1328.D0/3.D0*Hr5(1,1,0
     &    ,1,1) + 2656.D0/3.D0*Hr5(1,1,0,1,1)*x - 2656.D0/3.D0*Hr5(1,1,
     &    0,1,1)*x**2 - 656.D0*Hr5(1,1,1,0,0) + 1312.D0*Hr5(1,1,1,0,0)*
     &    x - 928.D0*Hr5(1,1,1,0,0)*x**2 - 1136.D0/3.D0*Hr5(1,1,1,0,1)
     &     + 2272.D0/3.D0*Hr5(1,1,1,0,1)*x - 2272.D0/3.D0*Hr5(1,1,1,0,1
     &    )*x**2 - 1072.D0/3.D0*Hr5(1,1,1,1,0) + 2144.D0/3.D0*Hr5(1,1,1
     &    ,1,0)*x - 2144.D0/3.D0*Hr5(1,1,1,1,0)*x**2 - 400.D0*Hr5(1,1,1
     &    ,1,1) + 800.D0*Hr5(1,1,1,1,1)*x - 800.D0*Hr5(1,1,1,1,1)*x**2
     &     )
      c2gg3 = c2gg3 + nf2*ca * (  - 78049.D0/1215.D0 - 1441136.D0/
     &    1215.D0*x + 4708987.D0/3645.D0*x**2 + 28.D0/3.D0*z4 - 344.D0/
     &    9.D0*z4*x + 52.D0/3.D0*z4*x**2 - 3832.D0/3645.D0*dx - 268.D0/
     &    9.D0*z3 + 2768.D0/9.D0*z3*x - 2992.D0/27.D0*z3*x**2 + 64.D0/
     &    27.D0*z3*dx - 100.D0/9.D0*z2 + 48460.D0/81.D0*z2*x - 360.D0*
     &    z2*x**2 - 48.D0/5.D0*z2*x**3 + 160.D0/27.D0*z2*dx - 8.D0*Hr1(
     &    -1)*z3 - 16.D0*Hr1(-1)*z3*x + 8.D0/3.D0*Hr1(-1)*z3*x**2 - 248.
     &    D0/9.D0*Hr1(-1)*z2 - 136.D0/9.D0*Hr1(-1)*z2*x + 256.D0/9.D0*
     &    Hr1(-1)*z2*x**2 - 16.D0/3.D0*Hr1(-1)*z2*dx - 58412.D0/1215.D0
     &    *Hr1(0) - 1363772.D0/1215.D0*Hr1(0)*x + 285488.D0/405.D0*Hr1(
     &    0)*x**2 + 4.D0/15.D0*Hr1(0)*dx - 64.D0/9.D0*Hr1(0)*z3 + 704.D0
     &    /9.D0*Hr1(0)*z3*x - 16.D0*Hr1(0)*z3*x**2 + 28.D0/9.D0*Hr1(0)*
     &    z2 + 932.D0/3.D0*Hr1(0)*z2*x - 952.D0/9.D0*Hr1(0)*z2*x**2 + 
     &    862.D0/243.D0*Hr1(1) - 181160.D0/243.D0*Hr1(1)*x + 190376.D0/
     &    243.D0*Hr1(1)*x**2 + 80.D0/27.D0*Hr1(1)*dx + 8.D0*Hr1(1)*z3
     &     - 16.D0*Hr1(1)*z3*x )
      c2gg3 = c2gg3 + nf2*ca * ( 56.D0/3.D0*Hr1(1)*z3*x**2 - 560.D0/
     &    27.D0*Hr1(1)*z2 + 1432.D0/27.D0*Hr1(1)*z2*x - 904.D0/27.D0*
     &    Hr1(1)*z2*x**2 + 16.D0/3.D0*Hr1(1)*z2*dx + 40.D0/3.D0*Hr2(-1,
     &    -1)*z2 + 80.D0/3.D0*Hr2(-1,-1)*z2*x + 16.D0/3.D0*Hr2(-1,-1)*
     &    z2*x**2 + 5888.D0/81.D0*Hr2(-1,0) + 2656.D0/81.D0*Hr2(-1,0)*x
     &     - 5036.D0/81.D0*Hr2(-1,0)*x**2 - 48.D0/5.D0*Hr2(-1,0)*x**3
     &     + 160.D0/27.D0*Hr2(-1,0)*dx - 4.D0/15.D0*Hr2(-1,0)*dx**2 + 8.
     &    D0*Hr2(-1,0)*z2 + 16.D0*Hr2(-1,0)*z2*x + 80.D0/3.D0*Hr2(-1,0)
     &    *z2*x**2 - 16.D0/3.D0*Hr2(0,-1)*z2 - 32.D0/3.D0*Hr2(0,-1)*z2*
     &    x + 32.D0/3.D0*Hr2(0,-1)*z2*x**2 - 1088.D0/81.D0*Hr2(0,0) - 
     &    7244.D0/9.D0*Hr2(0,0)*x + 20348.D0/81.D0*Hr2(0,0)*x**2 + 48.D0
     &    /5.D0*Hr2(0,0)*x**3 - 8.D0/3.D0*Hr2(0,0)*z2 + 80.D0*Hr2(0,0)*
     &    z2*x - 32.D0/3.D0*Hr2(0,0)*z2*x**2 + 100.D0/9.D0*Hr2(0,1) - 
     &    15268.D0/27.D0*Hr2(0,1)*x + 360.D0*Hr2(0,1)*x**2 + 32.D0*Hr2(
     &    0,1)*z2*x + 320.D0/27.D0*Hr2(1,0) - 7168.D0/27.D0*Hr2(1,0)*x
     &     + 7640.D0/27.D0*Hr2(1,0)*x**2 )
      c2gg3 = c2gg3 + nf2*ca * (  - 160.D0/27.D0*Hr2(1,0)*dx - 32.D0/
     &    9.D0*Hr2(1,0)*z2 + 64.D0/9.D0*Hr2(1,0)*z2*x + 80.D0/9.D0*Hr2(
     &    1,0)*z2*x**2 + 1112.D0/81.D0*Hr2(1,1) - 21832.D0/81.D0*Hr2(1,
     &    1)*x + 23392.D0/81.D0*Hr2(1,1)*x**2 - 160.D0/27.D0*Hr2(1,1)*
     &    dx - 160.D0/9.D0*Hr2(1,1)*z2 + 320.D0/9.D0*Hr2(1,1)*z2*x - 
     &    176.D0/9.D0*Hr2(1,1)*z2*x**2 - 368.D0/9.D0*Hr3(-1,-1,0) - 496.
     &    D0/9.D0*Hr3(-1,-1,0)*x - 32.D0/9.D0*Hr3(-1,-1,0)*x**2 - 32.D0/
     &    9.D0*Hr3(-1,-1,0)*dx + 1192.D0/27.D0*Hr3(-1,0,0) + 128.D0/27.D
     &    0*Hr3(-1,0,0)*x - 1768.D0/27.D0*Hr3(-1,0,0)*x**2 + 32.D0/3.D0
     &    *Hr3(-1,0,0)*dx + 64.D0/9.D0*Hr3(-1,0,1) - 112.D0/9.D0*Hr3(-1
     &    ,0,1)*x - 272.D0/9.D0*Hr3(-1,0,1)*x**2 + 32.D0/9.D0*Hr3(-1,0,
     &    1)*dx + 112.D0/3.D0*Hr3(0,-1,0) + 136.D0/9.D0*Hr3(0,-1,0)*x
     &     - 272.D0/9.D0*Hr3(0,-1,0)*x**2 - 532.D0/27.D0*Hr3(0,0,0) - 
     &    10280.D0/27.D0*Hr3(0,0,0)*x + 1880.D0/27.D0*Hr3(0,0,0)*x**2
     &     - 28.D0/9.D0*Hr3(0,0,1) - 2660.D0/9.D0*Hr3(0,0,1)*x + 952.D0/
     &    9.D0*Hr3(0,0,1)*x**2 )
      c2gg3 = c2gg3 + nf2*ca * ( 8.D0/3.D0*Hr3(0,1,0) - 1556.D0/9.D0*
     &    Hr3(0,1,0)*x + 280.D0/3.D0*Hr3(0,1,0)*x**2 + 8.D0/3.D0*Hr3(0,
     &    1,1) - 1576.D0/9.D0*Hr3(0,1,1)*x + 280.D0/3.D0*Hr3(0,1,1)*
     &    x**2 + 688.D0/27.D0*Hr3(1,0,0) - 2720.D0/27.D0*Hr3(1,0,0)*x
     &     + 2432.D0/27.D0*Hr3(1,0,0)*x**2 - 32.D0/9.D0*Hr3(1,0,0)*dx
     &     + 8.D0/27.D0*Hr3(1,0,1) - 688.D0/27.D0*Hr3(1,0,1)*x + 856.D0/
     &    27.D0*Hr3(1,0,1)*x**2 - 32.D0/9.D0*Hr3(1,0,1)*dx + 616.D0/27.D
     &    0*Hr3(1,1,0) - 3152.D0/27.D0*Hr3(1,1,0)*x + 3320.D0/27.D0*
     &    Hr3(1,1,0)*x**2 - 32.D0/9.D0*Hr3(1,1,0)*dx + 232.D0/27.D0*
     &    Hr3(1,1,1) - 1808.D0/27.D0*Hr3(1,1,1)*x + 1976.D0/27.D0*Hr3(1
     &    ,1,1)*x**2 - 32.D0/9.D0*Hr3(1,1,1)*dx + 16.D0*Hr4(-1,-1,-1,0)
     &     + 32.D0*Hr4(-1,-1,-1,0)*x + 32.D0/3.D0*Hr4(-1,-1,-1,0)*x**2
     &     - 64.D0/3.D0*Hr4(-1,-1,0,0) - 128.D0/3.D0*Hr4(-1,-1,0,0)*x
     &     - 16.D0/3.D0*Hr4(-1,-1,0,0)*x**2 - 16.D0/3.D0*Hr4(-1,-1,0,1)
     &     - 32.D0/3.D0*Hr4(-1,-1,0,1)*x - 16.D0*Hr4(-1,0,-1,0) - 32.D0
     &    *Hr4(-1,0,-1,0)*x )
      c2gg3 = c2gg3 + nf2*ca * (  - 32.D0/3.D0*Hr4(-1,0,-1,0)*x**2 - 
     &    112.D0/9.D0*Hr4(-1,0,0,0) - 224.D0/9.D0*Hr4(-1,0,0,0)*x - 368.
     &    D0/9.D0*Hr4(-1,0,0,0)*x**2 - 32.D0/3.D0*Hr4(-1,0,0,1) - 64.D0/
     &    3.D0*Hr4(-1,0,0,1)*x - 80.D0/3.D0*Hr4(-1,0,0,1)*x**2 - 16.D0/
     &    3.D0*Hr4(-1,0,1,0) - 32.D0/3.D0*Hr4(-1,0,1,0)*x - 32.D0/3.D0*
     &    Hr4(-1,0,1,0)*x**2 - 16.D0/3.D0*Hr4(-1,0,1,1) - 32.D0/3.D0*
     &    Hr4(-1,0,1,1)*x - 32.D0/3.D0*Hr4(-1,0,1,1)*x**2 - 32.D0/3.D0*
     &    Hr4(0,-1,-1,0) - 64.D0/3.D0*Hr4(0,-1,-1,0)*x + 16.D0/3.D0*
     &    Hr4(0,-1,0,0) + 32.D0/3.D0*Hr4(0,-1,0,0)*x - 80.D0/3.D0*Hr4(0
     &    ,-1,0,0)*x**2 - 32.D0/3.D0*Hr4(0,-1,0,1)*x**2 + 32.D0/3.D0*
     &    Hr4(0,0,-1,0) - 32.D0/3.D0*Hr4(0,0,-1,0)*x**2 - 8.D0/9.D0*
     &    Hr4(0,0,0,0) - 272.D0/3.D0*Hr4(0,0,0,0)*x + 8.D0/3.D0*Hr4(0,0
     &    ,0,1) - 80.D0*Hr4(0,0,0,1)*x + 32.D0/3.D0*Hr4(0,0,0,1)*x**2
     &     - 160.D0/3.D0*Hr4(0,0,1,0)*x + 32.D0/3.D0*Hr4(0,0,1,0)*x**2
     &     - 160.D0/3.D0*Hr4(0,0,1,1)*x + 32.D0/3.D0*Hr4(0,0,1,1)*x**2
     &     + 16.D0/3.D0*Hr4(0,1,0,0) )
      c2gg3 = c2gg3 + nf2*ca * (  - 128.D0/3.D0*Hr4(0,1,0,0)*x + 16.D0
     &    *Hr4(0,1,0,0)*x**2 - 16.D0/3.D0*Hr4(0,1,0,1) - 64.D0/3.D0*
     &    Hr4(0,1,0,1)*x + 16.D0/3.D0*Hr4(0,1,1,0) - 128.D0/3.D0*Hr4(0,
     &    1,1,0)*x + 64.D0/3.D0*Hr4(0,1,1,0)*x**2 - 32.D0*Hr4(0,1,1,1)*
     &    x + 32.D0/3.D0*Hr4(0,1,1,1)*x**2 + 32.D0/3.D0*Hr4(1,0,-1,0)
     &     - 64.D0/3.D0*Hr4(1,0,-1,0)*x + 32.D0/3.D0*Hr4(1,0,-1,0)*x**2
     &     + 56.D0/3.D0*Hr4(1,0,0,0) - 112.D0/3.D0*Hr4(1,0,0,0)*x + 64.D
     &    0/3.D0*Hr4(1,0,0,0)*x**2 + 8.D0/9.D0*Hr4(1,0,0,1) - 16.D0/9.D0
     &    *Hr4(1,0,0,1)*x - 80.D0/9.D0*Hr4(1,0,0,1)*x**2 + 40.D0/9.D0*
     &    Hr4(1,0,1,0) - 80.D0/9.D0*Hr4(1,0,1,0)*x + 128.D0/9.D0*Hr4(1,
     &    0,1,0)*x**2 - 8.D0/9.D0*Hr4(1,0,1,1) + 16.D0/9.D0*Hr4(1,0,1,1
     &    )*x - 16.D0/9.D0*Hr4(1,0,1,1)*x**2 + 184.D0/9.D0*Hr4(1,1,0,0)
     &     - 368.D0/9.D0*Hr4(1,1,0,0)*x + 320.D0/9.D0*Hr4(1,1,0,0)*x**2
     &     + 88.D0/9.D0*Hr4(1,1,0,1) - 176.D0/9.D0*Hr4(1,1,0,1)*x + 128.
     &    D0/9.D0*Hr4(1,1,0,1)*x**2 + 56.D0/9.D0*Hr4(1,1,1,0) - 112.D0/
     &    9.D0*Hr4(1,1,1,0)*x )
      c2gg3 = c2gg3 + nf2*ca * ( 160.D0/9.D0*Hr4(1,1,1,0)*x**2 + 56.D0
     &    /9.D0*Hr4(1,1,1,1) - 112.D0/9.D0*Hr4(1,1,1,1)*x + 112.D0/9.D0
     &    *Hr4(1,1,1,1)*x**2 )
      c2gg3 = c2gg3 + nf2*cf * ( 54984209.D0/24300.D0 - 39073417.D0/
     &    12150.D0*x + 16071037.D0/18225.D0*x**2 - 24.D0*z5 + 48.D0*z5*
     &    x - 454.D0/9.D0*z4 - 3376.D0/9.D0*z4*x - 632.D0/9.D0*z4*x**2
     &     + 1100288.D0/18225.D0*dx - 10436.D0/27.D0*z3 + 18364.D0/27.D0
     &    *z3*x - 1112.D0/3.D0*z3*x**2 + 64.D0*z3*x**3 + 128.D0/27.D0*
     &    z3*dx - 282608.D0/405.D0*z2 + 90604.D0/405.D0*z2*x - 82984.D0/
     &    405.D0*z2*x**2 - 3424.D0/75.D0*z2*x**3 - 2656.D0/135.D0*z2*dx
     &     + 32.D0*z2*z3 - 64.D0*z2*z3*x + 112.D0/3.D0*Hr1(-1)*z3 + 224.
     &    D0/3.D0*Hr1(-1)*z3*x + 112.D0/3.D0*Hr1(-1)*z3*x**2 + 1384.D0/
     &    9.D0*Hr1(-1)*z2 + 800.D0/9.D0*Hr1(-1)*z2*x - 440.D0/9.D0*Hr1(
     &    -1)*z2*x**2 + 96.D0/5.D0*Hr1(-1)*z2*x**3 - 32.D0/3.D0*Hr1(-1)
     &    *z2*dx + 8.D0/15.D0*Hr1(-1)*z2*dx**2 + 10607848.D0/6075.D0*
     &    Hr1(0) - 8642522.D0/6075.D0*Hr1(0)*x + 1049188.D0/2025.D0*
     &    Hr1(0)*x**2 + 28.D0*Hr1(0)*z4 - 56.D0*Hr1(0)*z4*x + 776.D0/
     &    675.D0*Hr1(0)*dx - 1268.D0/9.D0*Hr1(0)*z3 + 3376.D0/9.D0*Hr1(
     &    0)*z3*x )
      c2gg3 = c2gg3 + nf2*cf * (  - 64.D0/3.D0*Hr1(0)*z3*x**2 - 4408.D
     &    0/9.D0*Hr1(0)*z2 + 5524.D0/9.D0*Hr1(0)*z2*x - 304.D0/3.D0*
     &    Hr1(0)*z2*x**2 - 288.D0/5.D0*Hr1(0)*z2*x**3 + 1348858.D0/1215.
     &    D0*Hr1(1) - 1830218.D0/1215.D0*Hr1(1)*x + 507692.D0/1215.D0*
     &    Hr1(1)*x**2 - 13904.D0/405.D0*Hr1(1)*dx - 112.D0/9.D0*Hr1(1)*
     &    z3 + 224.D0/9.D0*Hr1(1)*z3*x - 272.D0/9.D0*Hr1(1)*z3*x**2 - 
     &    608.D0/9.D0*Hr1(1)*z2 + 216.D0*Hr1(1)*z2*x - 1544.D0/9.D0*
     &    Hr1(1)*z2*x**2 - 192.D0/5.D0*Hr1(1)*z2*x**3 + 32.D0/3.D0*Hr1(
     &    1)*z2*dx + 8.D0/45.D0*Hr1(1)*z2*dx**2 - 128.D0/3.D0*Hr2(-1,-1
     &    )*z2 - 256.D0/3.D0*Hr2(-1,-1)*z2*x - 128.D0/3.D0*Hr2(-1,-1)*
     &    z2*x**2 - 23312.D0/45.D0*Hr2(-1,0) - 38176.D0/135.D0*Hr2(-1,0
     &    )*x + 20912.D0/135.D0*Hr2(-1,0)*x**2 - 3424.D0/75.D0*Hr2(-1,0
     &    )*x**3 - 2608.D0/135.D0*Hr2(-1,0)*dx - 1016.D0/675.D0*Hr2(-1,
     &    0)*dx**2 + 64.D0/3.D0*Hr2(-1,0)*z2 + 128.D0/3.D0*Hr2(-1,0)*z2
     &    *x + 64.D0/3.D0*Hr2(-1,0)*z2*x**2 + 272.D0/3.D0*Hr2(0,-1)*z2
     &     - 224.D0/3.D0*Hr2(0,-1)*z2*x )
      c2gg3 = c2gg3 + nf2*cf * ( 224.D0/3.D0*Hr2(0,-1)*z2*x**2 + 
     &    385274.D0/405.D0*Hr2(0,0) - 277906.D0/405.D0*Hr2(0,0)*x - 
     &    28088.D0/405.D0*Hr2(0,0)*x**2 + 3424.D0/75.D0*Hr2(0,0)*x**3
     &     + 16.D0/15.D0*Hr2(0,0)*dx - 152.D0/3.D0*Hr2(0,0)*z3 + 304.D0/
     &    3.D0*Hr2(0,0)*z3*x - 436.D0/3.D0*Hr2(0,0)*z2 + 1520.D0/3.D0*
     &    Hr2(0,0)*z2*x + 160.D0/3.D0*Hr2(0,0)*z2*x**2 + 282608.D0/405.D
     &    0*Hr2(0,1) - 205132.D0/405.D0*Hr2(0,1)*x + 82984.D0/405.D0*
     &    Hr2(0,1)*x**2 + 16.D0/45.D0*Hr2(0,1)*dx + 8.D0/3.D0*Hr2(0,1)*
     &    z2 + 32.D0*Hr2(0,1)*z2*x + 64.D0/3.D0*Hr2(0,1)*z2*x**2 + 
     &    33758.D0/81.D0*Hr2(1,0) - 58504.D0/81.D0*Hr2(1,0)*x + 26728.D0
     &    /81.D0*Hr2(1,0)*x**2 + 512.D0/27.D0*Hr2(1,0)*dx - 32.D0/3.D0*
     &    Hr2(1,0)*z2 + 64.D0/3.D0*Hr2(1,0)*z2*x - 160.D0/3.D0*Hr2(1,0)
     &    *z2*x**2 + 33766.D0/81.D0*Hr2(1,1) - 55556.D0/81.D0*Hr2(1,1)*
     &    x + 23384.D0/81.D0*Hr2(1,1)*x**2 + 512.D0/27.D0*Hr2(1,1)*dx
     &     + 32.D0/3.D0*Hr2(1,1)*z2 - 64.D0/3.D0*Hr2(1,1)*z2*x - 32.D0/
     &    3.D0*Hr2(1,1)*z2*x**2 )
      c2gg3 = c2gg3 + nf2*cf * ( 1328.D0/9.D0*Hr3(-1,-1,0) + 448.D0/3.
     &    D0*Hr3(-1,-1,0)*x + 112.D0/9.D0*Hr3(-1,-1,0)*x**2 + 64.D0/5.D0
     &    *Hr3(-1,-1,0)*x**3 - 64.D0/9.D0*Hr3(-1,-1,0)*dx + 16.D0/45.D0
     &    *Hr3(-1,-1,0)*dx**2 - 2464.D0/9.D0*Hr3(-1,0,0) - 992.D0/9.D0*
     &    Hr3(-1,0,0)*x + 1184.D0/9.D0*Hr3(-1,0,0)*x**2 - 192.D0/5.D0*
     &    Hr3(-1,0,0)*x**3 + 64.D0/3.D0*Hr3(-1,0,0)*dx - 16.D0/15.D0*
     &    Hr3(-1,0,0)*dx**2 - 80.D0*Hr3(-1,0,1) - 128.D0/9.D0*Hr3(-1,0,
     &    1)*x + 496.D0/9.D0*Hr3(-1,0,1)*x**2 - 64.D0/5.D0*Hr3(-1,0,1)*
     &    x**3 + 64.D0/9.D0*Hr3(-1,0,1)*dx - 16.D0/45.D0*Hr3(-1,0,1)*
     &    dx**2 - 2480.D0/9.D0*Hr3(0,-1,0) + 2176.D0/9.D0*Hr3(0,-1,0)*x
     &     - 176.D0/9.D0*Hr3(0,-1,0)*x**2 - 64.D0/5.D0*Hr3(0,-1,0)*x**3
     &     - 32.D0/45.D0*Hr3(0,-1,0)*dx**2 + 17782.D0/27.D0*Hr3(0,0,0)
     &     - 27200.D0/27.D0*Hr3(0,0,0)*x + 64.D0/9.D0*Hr3(0,0,0)*x**2
     &     + 192.D0/5.D0*Hr3(0,0,0)*x**3 - 88.D0*Hr3(0,0,0)*z2 + 176.D0
     &    *Hr3(0,0,0)*z2*x + 4408.D0/9.D0*Hr3(0,0,1) - 372.D0*Hr3(0,0,1
     &    )*x )
      c2gg3 = c2gg3 + nf2*cf * ( 304.D0/3.D0*Hr3(0,0,1)*x**2 + 224.D0/
     &    5.D0*Hr3(0,0,1)*x**3 - 16.D0*Hr3(0,0,1)*z2 + 32.D0*Hr3(0,0,1)
     &    *z2*x + 812.D0/3.D0*Hr3(0,1,0) - 400.D0/3.D0*Hr3(0,1,0)*x + 
     &    1568.D0/9.D0*Hr3(0,1,0)*x**2 - 32.D0*Hr3(0,1,0)*x**3 + 7388.D0
     &    /27.D0*Hr3(0,1,1) - 3856.D0/27.D0*Hr3(0,1,1)*x + 3952.D0/27.D0
     &    *Hr3(0,1,1)*x**2 + 3080.D0/27.D0*Hr3(1,0,0) - 6472.D0/27.D0*
     &    Hr3(1,0,0)*x + 5344.D0/27.D0*Hr3(1,0,0)*x**2 - 64.D0/9.D0*
     &    Hr3(1,0,0)*dx + 424.D0/3.D0*Hr3(1,0,1) - 872.D0/3.D0*Hr3(1,0,
     &    1)*x + 1600.D0/9.D0*Hr3(1,0,1)*x**2 + 32.D0*Hr3(1,0,1)*x**3
     &     - 64.D0/9.D0*Hr3(1,0,1)*dx + 1048.D0/9.D0*Hr3(1,1,0) - 1976.D
     &    0/9.D0*Hr3(1,1,0)*x + 544.D0/3.D0*Hr3(1,1,0)*x**2 - 32.D0*
     &    Hr3(1,1,0)*x**3 - 64.D0/9.D0*Hr3(1,1,0)*dx + 3224.D0/27.D0*
     &    Hr3(1,1,1) - 6184.D0/27.D0*Hr3(1,1,1)*x + 4144.D0/27.D0*Hr3(1
     &    ,1,1)*x**2 - 64.D0/9.D0*Hr3(1,1,1)*dx - 128.D0/3.D0*Hr4(-1,-1
     &    ,-1,0) - 256.D0/3.D0*Hr4(-1,-1,-1,0)*x - 128.D0/3.D0*Hr4(-1,
     &    -1,-1,0)*x**2 )
      c2gg3 = c2gg3 + nf2*cf * ( 224.D0/3.D0*Hr4(-1,-1,0,0) + 448.D0/
     &    3.D0*Hr4(-1,-1,0,0)*x + 224.D0/3.D0*Hr4(-1,-1,0,0)*x**2 + 64.D
     &    0/3.D0*Hr4(-1,-1,0,1) + 128.D0/3.D0*Hr4(-1,-1,0,1)*x + 64.D0/
     &    3.D0*Hr4(-1,-1,0,1)*x**2 + 128.D0/3.D0*Hr4(-1,0,-1,0) + 256.D0
     &    /3.D0*Hr4(-1,0,-1,0)*x + 128.D0/3.D0*Hr4(-1,0,-1,0)*x**2 - 32.
     &    D0*Hr4(-1,0,0,0) - 64.D0*Hr4(-1,0,0,0)*x - 32.D0*Hr4(-1,0,0,0
     &    )*x**2 - 32.D0/3.D0*Hr4(-1,0,0,1) - 64.D0/3.D0*Hr4(-1,0,0,1)*
     &    x - 32.D0/3.D0*Hr4(-1,0,0,1)*x**2 + 224.D0/3.D0*Hr4(0,-1,-1,0
     &    ) - 64.D0/3.D0*Hr4(0,-1,-1,0)*x + 64.D0*Hr4(0,-1,-1,0)*x**2
     &     - 512.D0/3.D0*Hr4(0,-1,0,0) + 512.D0/3.D0*Hr4(0,-1,0,0)*x - 
     &    416.D0/3.D0*Hr4(0,-1,0,0)*x**2 - 160.D0/3.D0*Hr4(0,-1,0,1) + 
     &    64.D0*Hr4(0,-1,0,1)*x - 128.D0/3.D0*Hr4(0,-1,0,1)*x**2 - 160.D
     &    0*Hr4(0,0,-1,0) + 64.D0*Hr4(0,0,-1,0)*x - 128.D0*Hr4(0,0,-1,0
     &    )*x**2 + 1636.D0/9.D0*Hr4(0,0,0,0) - 7232.D0/9.D0*Hr4(0,0,0,0
     &    )*x - 928.D0/9.D0*Hr4(0,0,0,0)*x**2 + 436.D0/3.D0*Hr4(0,0,0,1
     &    ) )
      c2gg3 = c2gg3 + nf2*cf * (  - 1328.D0/3.D0*Hr4(0,0,0,1)*x - 160.
     &    D0/3.D0*Hr4(0,0,0,1)*x**2 + 88.D0*Hr4(0,0,1,0) - 160.D0*Hr4(0
     &    ,0,1,0)*x - 32.D0/3.D0*Hr4(0,0,1,0)*x**2 + 88.D0*Hr4(0,0,1,1)
     &     - 160.D0*Hr4(0,0,1,1)*x - 32.D0/3.D0*Hr4(0,0,1,1)*x**2 + 24.D
     &    0*Hr4(0,1,0,0) + 104.D0/3.D0*Hr4(0,1,0,1) - 64.D0/3.D0*Hr4(0,
     &    1,0,1)*x + 32.D0/3.D0*Hr4(0,1,0,1)*x**2 + 104.D0/3.D0*Hr4(0,1
     &    ,1,0) - 64.D0/3.D0*Hr4(0,1,1,0)*x + 32.D0/3.D0*Hr4(0,1,1,0)*
     &    x**2 + 304.D0/9.D0*Hr4(0,1,1,1) - 176.D0/9.D0*Hr4(0,1,1,1)*x
     &     + 80.D0/9.D0*Hr4(0,1,1,1)*x**2 - 64.D0/3.D0*Hr4(1,0,-1,0) + 
     &    128.D0/3.D0*Hr4(1,0,-1,0)*x - 64.D0/3.D0*Hr4(1,0,-1,0)*x**2
     &     + 80.D0/9.D0*Hr4(1,0,0,0) - 160.D0/9.D0*Hr4(1,0,0,0)*x + 448.
     &    D0/9.D0*Hr4(1,0,0,0)*x**2 + 64.D0/3.D0*Hr4(1,0,0,1) - 128.D0/
     &    3.D0*Hr4(1,0,0,1)*x + 64.D0*Hr4(1,0,0,1)*x**2 + 32.D0*Hr4(1,0
     &    ,1,0) - 64.D0*Hr4(1,0,1,0)*x + 160.D0/3.D0*Hr4(1,0,1,0)*x**2
     &     + 80.D0/3.D0*Hr4(1,0,1,1) - 160.D0/3.D0*Hr4(1,0,1,1)*x + 160.
     &    D0/3.D0*Hr4(1,0,1,1)*x**2 )
      c2gg3 = c2gg3 + nf2*cf * ( 16.D0/3.D0*Hr4(1,1,0,0) - 32.D0/3.D0
     &    *Hr4(1,1,0,0)*x + 64.D0/3.D0*Hr4(1,1,0,0)*x**2 + 32.D0/3.D0*
     &    Hr4(1,1,0,1) - 64.D0/3.D0*Hr4(1,1,0,1)*x + 32.D0*Hr4(1,1,0,1)
     &    *x**2 + 64.D0/3.D0*Hr4(1,1,1,0) - 128.D0/3.D0*Hr4(1,1,1,0)*x
     &     + 32.D0*Hr4(1,1,1,0)*x**2 + 136.D0/9.D0*Hr4(1,1,1,1) - 272.D0
     &    /9.D0*Hr4(1,1,1,1)*x + 272.D0/9.D0*Hr4(1,1,1,1)*x**2 + 120.D0
     &    *Hr5(0,0,0,0,0) - 240.D0*Hr5(0,0,0,0,0)*x + 88.D0*Hr5(0,0,0,0
     &    ,1) - 176.D0*Hr5(0,0,0,0,1)*x + 48.D0*Hr5(0,0,0,1,0) - 96.D0*
     &    Hr5(0,0,0,1,0)*x + 48.D0*Hr5(0,0,0,1,1) - 96.D0*Hr5(0,0,0,1,1
     &    )*x + 16.D0*Hr5(0,0,1,0,0) - 32.D0*Hr5(0,0,1,0,0)*x + 16.D0*
     &    Hr5(0,0,1,0,1) - 32.D0*Hr5(0,0,1,0,1)*x + 16.D0*Hr5(0,0,1,1,0
     &    ) - 32.D0*Hr5(0,0,1,1,0)*x + 16.D0*Hr5(0,0,1,1,1) - 32.D0*
     &    Hr5(0,0,1,1,1)*x )
*
* ...Output; if commented out, only the flg11 part is returned
*
       X2G3A = C2GG3 
       endif
*
       RETURN
       END
*
* =================================================================av==
      END MODULE XC2GL3E
