      MODULE XC2NS3E
      USE XC2NS3P
      CONTAINS
*     
* ..File: xc2ns3e.f    F2_NS
*
*
* ..The exact 3-loop MS(bar) non-singlet coefficient functions for the
*    structure function F_2 in electromagnetic DIS at mu_r = mu_f = Q.
*    Expansion parameter: alpha_s/(4 pi).
*
* ..The distributions (in the mathematical sense) are given as in eq.
*    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.
*    The name-endings A, B, and C of the functions below correspond to 
*    the kernel superscripts [2], [3], and [1] in that equation.
*    The regular piece  X2NP3A  has to be called first.
*
* ..The code uses the package of Gehrmann and Remiddi for the harmonic
*    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296,
*    upgraded to weight 5 (T. Gehrmann, private communication)
*
* ..References: S. Moch, J. Vermaseren and A. Vogt, hep-ph/0209100
*               J. Vermaseren, A. Vogt and S. Moch, hep-ph/0504242
*
*
* =====================================================================
*
*
*
       SUBROUTINE SET_C2SOFT_N3LO(NF)
       IMPLICIT REAL*8 (A - Z)
       INTEGER NF
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0, 
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
*
* ..The soft-gluon coefficients for use in X3NS3B and X3NS3C
*
       COMMON / C3SOFT / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5 

       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
* 


       C3A5 = 
     &     + 8.D0*cf**3
       C3A4 =
     &     - 30.D0*cf**3
     &     - 220.D0/9.D0*ca*cf**2
     &     + 40.D0/9.D0*cf**2*nf
       C3A3 =
     &     - 36.D0*cf**3
     &     - 96.D0*z2*cf**3
     &     + 1732.D0/9.D0*ca*cf**2
     &     - 32.D0*z2*ca*cf**2
     &     + 484.D0/27.D0*ca**2*cf
     &     - 280.D0/9.D0*cf**2*nf
     &     - 176.D0/27.D0*ca*cf*nf
     &     + 16.D0/27.D0*cf*nf2
       C3A2 =
     &     + 279.D0/2.D0*cf**3
     &     + 288.D0*z2*cf**3
     &     + 16.D0*z3*cf**3
     &     - 8425.D0/18.D0*ca*cf**2
     &     + 724.D0/3.D0*z2*ca*cf**2
     &     + 240.D0*z3*ca*cf**2
     &     - 4649.D0/27.D0*ca**2*cf
     &     + 88.D0/3.D0*z2*ca**2*cf
     &     + 683.D0/9.D0*cf**2*nf
     &     - 112.D0/3.D0*z2*cf**2*nf
     &     + 1552.D0/27.D0*ca*cf*nf
     &     - 16.D0/3.D0*z2*ca*cf*nf
     &     - 116.D0/27.D0*cf*nf2
       C3A1 =
     &     + 187.D0/2.D0*cf**3
     &     + 240.D0*z2*cf**3
     &     - 360.D0*z3*cf**3
     &     + 188.D0*z4*cf**3
     &     - 5563.D0/18.D0*ca*cf**2
     &     - 972.D0*z2*ca*cf**2
     &     - 160.D0/3.D0*z3*ca*cf**2
     &     + 382.D0*z4*ca*cf**2
     &     + 50689.D0/81.D0*ca**2*cf
     &     - 680.D0/3.D0*z2*ca**2*cf
     &     - 264.D0*z3*ca**2*cf
     &     + 88.D0*z4*ca**2*cf
     &     + 83.D0/9.D0*cf**2*nf
     &     + 168.D0*z2*cf**2*nf
     &     + 112.D0/3.D0*z3*cf**2*nf
     &     - 15062.D0/81.D0*ca*cf*nf
     &     + 512.D0/9.D0*z2*ca*cf*nf
     &     + 16.D0*z3*ca*cf*nf
     &     + 940.D0/81.D0*cf*nf2
     &     - 32.D0/9.D0*z2*cf*nf2
       C3A0 =
     &     - 1001.D0/8.D0*cf**3
     &     - 429.D0*z2*cf**3
     &     + 274.D0*z3*cf**3
     &     - 525.D0*z4*cf**3
     &     + 32.D0*z2*z3*cf**3
     &     + 432.D0*z5*cf**3
     &     + 16981.D0/24.D0*ca*cf**2
     &     + 26885.D0/27.D0*z2*ca*cf**2
     &     - 3304.D0/9.D0*z3*ca*cf**2
     &     - 1045.D0/2.D0*z4*ca*cf**2
     &     - 400.D0*z2*z3*ca*cf**2
     &     - 120.D0*z5*ca*cf**2
     &     - 599375.D0/729.D0*ca**2*cf
     &     + 32126.D0/81.D0*z2*ca**2*cf
     &     + 21032.D0/27.D0*z3*ca**2*cf
     &     - 326.D0/3.D0*z4*ca**2*cf
     &     - 176.D0/3.D0*z2*z3*ca**2*cf
     &     - 232.D0*z5*ca**2*cf
     &     - 2003.D0/108.D0*cf**2*nf
     &     - 4226.D0/27.D0*z2*cf**2*nf
     &     - 60.D0*z3*cf**2*nf
     &     + 40.D0*z4*cf**2*nf
     &     + 160906.D0/729.D0*ca*cf*nf
     &     - 9920.D0/81.D0*z2*ca*cf*nf
     &     - 776.D0/9.D0*z3*ca*cf*nf
     &     + 104.D0/3.D0*z4*ca*cf*nf
     &     - 8714.D0/729.D0*cf*nf2
     &     + 232.D0/27.D0*z2*cf*nf2
     &     - 32.D0/27.D0*z3*cf*nf2

       END SUBROUTINE

* ..The regular piece 
       FUNCTION X2NP3A (X, DL, NF, CC)
*
       IMPLICIT REAL*8 (A - Z)
       COMPLEX*16 HC1, HC2, HC3, HC4, HC5 
       INTEGER NF, NF2, N1, N2, NW, CC
       PARAMETER ( N1 = -1, N2 = 1, NW = 5 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2), 
     ,           HC4(N1:N2,N1:N2,N1:N2,N1:N2), 
     ,           HC5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2) 
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2), 
     ,           HR4(N1:N2,N1:N2,N1:N2,N1:N2), 
     ,           HR5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2) 
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2), 
     ,           HI4(N1:N2,N1:N2,N1:N2,N1:N2), 
     ,           HI5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2) 
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0, 
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
       DIMENSION FL(6)
       DATA FL  / -1.d0, 0.5d0, 0.d0, 0.5d0, 0.2d0, 0.5d0 /
*
* ..The soft-gluon coefficients for use in X3NS3B and X3NS3C
*
       COMMON / C3SOFT / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5 

*       
* ...Colour factors
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
* 
       DABC2N = 5.D0/18.D0 * NF
       FL11 = FL(NF)
*
* ...Some abbreviations
*
       DX = 1.D0/X
       DM = DMVAL(X,DL) !1.D0/(1.D0-X)
       DP = 1.D0/(1.D0+X)
       !DL  = LOG (X)
       DL1 = LOG (1.D0-X)
       
!     Use large x expansion when close to x=1
       if((1.0d0-x.lt.1d-6).and.(CC.eq.1)) then
          X2NP3A =  X2NP3A_large_x(X, DL, NF)
          return
       endif
*     
* ...Harmonic polylogs (HPLs) up to weight 5 by Gehrmann and Remiddi
*
       CALL HPLOG5 (X, NW, HC1,HC2,HC3,HC4,HC5, HR1,HR2,HR3,HR4,HR5,
     ,             HI1,HI2,HI3,HI4,HI5, N1, N2)
*
* ...The coefficient function in terms of the harmonic polylogs
*    (without the delta(1-x) part, but with the soft contribution)
*
       c2qq3 = zero
       if(CC.eq.0) then
      c2qq3 =
     &  + fl11*dabc2n * (  - 192.D0/5.D0 - 1728.D0/5.D0*x + 1152.D0/5.D0
     &    *x**2 + 5120.D0*z5*x + 1312.D0*z4*x + 1536.D0*z4*x**2 - 2304.D
     &    0/5.D0*z4*x**3 + 128.D0/5.D0*dx - 3136.D0/15.D0*z3 - 51712.D0/
     &    15.D0*z3*x + 1344.D0/5.D0*z3*x**2 - 1920.D0*z3*x**3 + 1024.D0/
     &    15.D0*z3*dx + 192.D0*z3*dm - 7552.D0/15.D0*z2 + 11648.D0/15.D0
     &    *z2*x - 768.D0*z2*x**2 - 4992.D0/5.D0*z2*x**3 + 512.D0/3.D0*
     &    z2*dx + 512.D0*z2*dp + 512.D0*z2*z3*x - 1024.D0*Hr1(-1)*z4 - 
     &    2048.D0*Hr1(-1)*z4*x - 512.D0*Hr1(-1)*z3*x + 2304.D0/5.D0*
     &    Hr1(-1)*z3*x**3 - 256.D0/5.D0*Hr1(-1)*z3*dx**2 + 11072.D0/15.D
     &    0*Hr1(-1)*z2 + 8064.D0/5.D0*Hr1(-1)*z2*x + 192.D0/5.D0*Hr1(-1
     &    )*z2*x**2 + 1152.D0*Hr1(-1)*z2*x**3 - 1024.D0/15.D0*Hr1(-1)*
     &    z2*dx - 128.D0*Hr1(-1)*z2*dx**2 + 4672.D0/15.D0*Hr1(0) - 384.D
     &    0/5.D0*Hr1(0)*x + 4992.D0/5.D0*Hr1(0)*x**2 - 128.D0/5.D0*Hr1(
     &    0)*dx - 320.D0*Hr1(0)*dp + 2048.D0/3.D0*Hr1(0)*z3*x + 768.D0*
     &    Hr1(0)*z3*x**2 - 3072.D0/5.D0*Hr1(0)*z3*x**3 - 512.D0/15.D0*
     &    Hr1(0)*z2 )
      c2qq3 = c2qq3 + fl11*dabc2n * (  - 2944.D0/3.D0*Hr1(0)*z2*x + 
     &    2688.D0/5.D0*Hr1(0)*z2*x**2 - 1536.D0*Hr1(0)*z2*x**3 - 64.D0*
     &    Hr1(0)*z2*dp + 64.D0*Hr1(0)*z2*dm - 10496.D0/15.D0*Hr1(1) - 
     &    768.D0/5.D0*Hr1(1)*x + 768.D0*Hr1(1)*x**2 + 256.D0/3.D0*Hr1(1
     &    )*dx - 1024.D0*Hr1(1)*z3 + 2432.D0/3.D0*Hr1(1)*z3*x + 768.D0*
     &    Hr1(1)*z3*x**2 - 768.D0/5.D0*Hr1(1)*z3*x**3 - 256.D0/15.D0*
     &    Hr1(1)*z3*dx**2 + 64.D0*Hr1(1)*z2 - 640.D0/3.D0*Hr1(1)*z2*x
     &     + 576.D0*Hr1(1)*z2*x**2 - 384.D0*Hr1(1)*z2*x**3 - 128.D0/3.D0
     &    *Hr1(1)*z2*dx**2 + 2048.D0/3.D0*Hr2(-1,-1)*z2*x - 3072.D0/5.D0
     &    *Hr2(-1,-1)*z2*x**3 + 1024.D0/15.D0*Hr2(-1,-1)*z2*dx**2 - 
     &    1280.D0/3.D0*Hr2(-1,0) - 3200.D0/3.D0*Hr2(-1,0)*x - 768.D0*
     &    Hr2(-1,0)*x**2 - 4992.D0/5.D0*Hr2(-1,0)*x**3 + 256.D0/3.D0*
     &    Hr2(-1,0)*dx + 1664.D0/15.D0*Hr2(-1,0)*dx**2 - 512.D0*Hr2(-1,
     &    0)*z3 - 1024.D0*Hr2(-1,0)*z3*x - 1408.D0/3.D0*Hr2(-1,0)*z2*x
     &     + 1536.D0/5.D0*Hr2(-1,0)*z2*x**3 - 512.D0/15.D0*Hr2(-1,0)*z2
     &    *dx**2 )
      c2qq3 = c2qq3 + fl11*dabc2n * (  - 896.D0/3.D0*Hr2(0,-1)*z2*x + 
     &    3072.D0/5.D0*Hr2(0,-1)*z2*x**3 + 512.D0/3.D0*Hr2(0,0) - 5888.D
     &    0/15.D0*Hr2(0,0)*x + 768.D0*Hr2(0,0)*x**2 + 4992.D0/5.D0*Hr2(
     &    0,0)*x**3 - 256.D0/3.D0*Hr2(0,0)*dx - 256.D0*Hr2(0,0)*dp + 
     &    128.D0*Hr2(0,0)*dm - 512.D0*Hr2(0,0)*z2*x - 768.D0*Hr2(0,0)*
     &    z2*x**2 + 7552.D0/15.D0*Hr2(0,1) - 9216.D0/5.D0*Hr2(0,1)*x + 
     &    768.D0*Hr2(0,1)*x**2 - 256.D0/3.D0*Hr2(0,1)*dx - 512.D0*Hr2(0
     &    ,1)*dp - 512.D0*Hr2(0,1)*z3 - 1024.D0*Hr2(0,1)*z3*x - 128.D0*
     &    Hr2(0,1)*z2*x + 1024.D0*Hr2(1,0)*z2 - 1408.D0/3.D0*Hr2(1,0)*
     &    z2*x - 768.D0*Hr2(1,0)*z2*x**2 + 1536.D0/5.D0*Hr2(1,0)*z2*
     &    x**3 + 512.D0/15.D0*Hr2(1,0)*z2*dx**2 + 128.D0*Hr3(-1,-1,0)
     &     + 1280.D0/3.D0*Hr3(-1,-1,0)*x + 1152.D0*Hr3(-1,-1,0)*x**2 + 
     &    768.D0*Hr3(-1,-1,0)*x**3 - 256.D0/3.D0*Hr3(-1,-1,0)*dx**2 - 
     &    6016.D0/15.D0*Hr3(-1,0,0) - 13696.D0/15.D0*Hr3(-1,0,0)*x - 
     &    1536.D0/5.D0*Hr3(-1,0,0)*x**2 - 768.D0*Hr3(-1,0,0)*x**3 + 512.
     &    D0/15.D0*Hr3(-1,0,0)*dx )
      c2qq3 = c2qq3 + fl11*dabc2n * ( 256.D0/3.D0*Hr3(-1,0,0)*dx**2 + 
     &    512.D0*Hr3(-1,0,0)*z2 + 1024.D0*Hr3(-1,0,0)*z2*x - 10112.D0/
     &    15.D0*Hr3(-1,0,1) - 20992.D0/15.D0*Hr3(-1,0,1)*x + 2688.D0/5.D
     &    0*Hr3(-1,0,1)*x**2 - 768.D0*Hr3(-1,0,1)*x**3 + 1024.D0/15.D0*
     &    Hr3(-1,0,1)*dx + 256.D0/3.D0*Hr3(-1,0,1)*dx**2 - 384.D0*Hr3(0
     &    ,-1,0) - 128.D0/3.D0*Hr3(0,-1,0)*x - 1152.D0*Hr3(0,-1,0)*x**2
     &     - 768.D0*Hr3(0,-1,0)*x**3 + 128.D0*Hr3(0,-1,0)*dm + 128.D0/3.
     &    D0*Hr3(0,0,0)*x + 768.D0*Hr3(0,0,0)*x**3 + 64.D0*Hr3(0,0,0)*
     &    dp - 64.D0*Hr3(0,0,0)*dm + 512.D0/15.D0*Hr3(0,0,1) + 2816.D0/
     &    3.D0*Hr3(0,0,1)*x - 2688.D0/5.D0*Hr3(0,0,1)*x**2 + 768.D0*
     &    Hr3(0,0,1)*x**3 + 512.D0*Hr3(0,1,0)*z2 + 1024.D0*Hr3(0,1,0)*
     &    z2*x + 3584.D0/15.D0*Hr3(1,0,0) - 128.D0/5.D0*Hr3(1,0,0)*x - 
     &    1536.D0/5.D0*Hr3(1,0,0)*x**2 - 512.D0/15.D0*Hr3(1,0,0)*dx - 
     &    1024.D0/3.D0*Hr4(-1,-1,0,0)*x + 1536.D0/5.D0*Hr4(-1,-1,0,0)*
     &    x**3 - 512.D0/15.D0*Hr4(-1,-1,0,0)*dx**2 - 2048.D0/3.D0*Hr4(
     &    -1,-1,0,1)*x )
      c2qq3 = c2qq3 + fl11*dabc2n * ( 3072.D0/5.D0*Hr4(-1,-1,0,1)*x**3
     &     - 1024.D0/15.D0*Hr4(-1,-1,0,1)*dx**2 + 128.D0*Hr4(-1,0,0,0)*
     &    x + 1024.D0/3.D0*Hr4(-1,0,0,1)*x - 1536.D0/5.D0*Hr4(-1,0,0,1)
     &    *x**3 + 512.D0/15.D0*Hr4(-1,0,0,1)*dx**2 + 256.D0*Hr4(0,-1,-1
     &    ,0)*x + 256.D0/3.D0*Hr4(0,-1,0,0)*x - 1536.D0/5.D0*Hr4(0,-1,0
     &    ,0)*x**3 + 1280.D0/3.D0*Hr4(0,-1,0,1)*x - 3072.D0/5.D0*Hr4(0,
     &    -1,0,1)*x**3 + 512.D0*Hr4(0,0,0,1)*x + 768.D0*Hr4(0,0,0,1)*
     &    x**2 - 1792.D0/3.D0*Hr4(0,1,0,0)*x - 768.D0*Hr4(0,1,0,0)*x**2
     &     + 1536.D0/5.D0*Hr4(0,1,0,0)*x**3 + 256.D0*Hr4(1,0,-1,0)*x - 
     &    128.D0*Hr4(1,0,0,0)*x - 1024.D0*Hr4(1,0,0,1) + 1792.D0/3.D0*
     &    Hr4(1,0,0,1)*x + 768.D0*Hr4(1,0,0,1)*x**2 - 1536.D0/5.D0*Hr4(
     &    1,0,0,1)*x**3 - 512.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 1024.D0*
     &    Hr4(1,1,0,0) - 1792.D0/3.D0*Hr4(1,1,0,0)*x - 768.D0*Hr4(1,1,0
     &    ,0)*x**2 + 1536.D0/5.D0*Hr4(1,1,0,0)*x**3 + 512.D0/15.D0*Hr4(
     &    1,1,0,0)*dx**2 - 512.D0*Hr5(-1,0,0,0,1) - 1024.D0*Hr5(-1,0,0,
     &    0,1)*x )
      c2qq3 = c2qq3 + fl11*dabc2n * ( 512.D0*Hr5(-1,0,1,0,0) + 1024.D0*
     &    Hr5(-1,0,1,0,0)*x - 512.D0*Hr5(0,1,0,0,1) - 1024.D0*Hr5(0,1,0
     &    ,0,1)*x + 512.D0*Hr5(0,1,1,0,0) + 1024.D0*Hr5(0,1,1,0,0)*x )
      
       X2NP3A = C2QQ3 
       return
       endif

       if(CC.eq.1) then
       c2qq3 =  cf*ca**2 * (  - 13824157.D0/36450.D0 + 117537107.D
     &    0/36450.D0*x - 13216.D0/25.D0*x**2 - 88.D0/3.D0*z5 - 560.D0/3.
     &    D0*z5*x - 617.D0/3.D0*z4 + 895.D0/3.D0*z4*x - 752.D0*z4*x**2
     &     + 168.D0*z4*x**3 - 11456.D0/225.D0*dx + 472.D0/3.D0*dp*z5 + 
     &    205.D0/3.D0*dp*z4 - 599375.D0/729.D0*dm - 536.D0/3.D0*dm*z5
     &     + 14.D0*dm*z4 - 8182.D0/135.D0*z3 + 98762.D0/135.D0*z3*x - 
     &    808.D0/5.D0*z3*x**2 - 934.D0*z3*x**3 + 284.D0/15.D0*z3*dx - 
     &    760.D0/3.D0*z3*dp + 5908.D0/27.D0*z3*dm - 20408.D0/135.D0*z2
     &     - 1219324.D0/405.D0*z2*x - 248.D0/5.D0*z2*x**2 + 7476.D0/25.D
     &    0*z2*x**3 - 196.D0/9.D0*z2*dx - 17696.D0/81.D0*z2*dp + 76418.D
     &    0/81.D0*z2*dm + 132.D0*z2*z3 - 1820.D0/3.D0*z2*z3*x - 1040.D0/
     &    3.D0*z2*z3*dp + 208.D0/3.D0*z2*z3*dm - 118.D0/3.D0*Hr1(-1)*z4
     &     - 26.D0/3.D0*Hr1(-1)*z4*x + 188.D0/3.D0*Hr1(-1)*dp*z4 - 
     &    12344.D0/9.D0*Hr1(-1)*z3 - 8812.D0/9.D0*Hr1(-1)*z3*x + 288.D0
     &    *Hr1(-1)*z3*x**3 - 32.D0*Hr1(-1)*z3*dx**2 + 1408.D0/9.D0*Hr1(
     &    -1)*z3*dp )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 14120.D0/27.D0*Hr1(-1)*z2 - 12052.
     &    D0/27.D0*Hr1(-1)*z2*x + 140.D0*Hr1(-1)*z2*x**2 + 426.D0/5.D0*
     &    Hr1(-1)*z2*x**3 - 128.D0/3.D0*Hr1(-1)*z2*dx - 142.D0/15.D0*
     &    Hr1(-1)*z2*dx**2 + 6976.D0/27.D0*Hr1(-1)*z2*dp + 89927.D0/225.
     &    D0*Hr1(0) + 6983873.D0/2025.D0*Hr1(0)*x - 11976.D0/25.D0*Hr1(
     &    0)*x**2 + 20.D0/3.D0*Hr1(0)*z4 + 72.D0*Hr1(0)*z4*x + 6176.D0/
     &    225.D0*Hr1(0)*dx + 2362.D0/9.D0*Hr1(0)*dp + 320.D0/3.D0*Hr1(0
     &    )*dp*z4 - 132599.D0/81.D0*Hr1(0)*dm - 520.D0/3.D0*Hr1(0)*dm*
     &    z4 - 232.D0/3.D0*Hr1(0)*z3 + 2176.D0/9.D0*Hr1(0)*z3*x - 376.D0
     &    *Hr1(0)*z3*x**2 - 852.D0/5.D0*Hr1(0)*z3*x**3 - 2216.D0/9.D0*
     &    Hr1(0)*z3*dp + 3200.D0/9.D0*Hr1(0)*z3*dm - 3692.D0/45.D0*Hr1(
     &    0)*z2 + 143608.D0/135.D0*Hr1(0)*z2*x + 1876.D0/5.D0*Hr1(0)*z2
     &    *x**2 + 752.D0/5.D0*Hr1(0)*z2*x**3 + 172.D0/5.D0*Hr1(0)*z2*dx
     &     - 2176.D0/27.D0*Hr1(0)*z2*dp + 13396.D0/27.D0*Hr1(0)*z2*dm
     &     - 35567.D0/405.D0*Hr1(1) + 786547.D0/405.D0*Hr1(1)*x + 248.D0
     &    /5.D0*Hr1(1)*x**2 )
      c2qq3 = c2qq3 + cf*ca**2 * ( 366.D0*Hr1(1)*z4 + 798.D0*Hr1(1)*z4*
     &    x - 1072.D0/45.D0*Hr1(1)*dx - 50689.D0/81.D0*Hr1(1)*dm - 812.D
     &    0*Hr1(1)*dm*z4 - 4216.D0/9.D0*Hr1(1)*z3 + 6080.D0/9.D0*Hr1(1)
     &    *z3*x - 376.D0*Hr1(1)*z3*x**2 + 588.D0/5.D0*Hr1(1)*z3*x**3 + 
     &    196.D0/15.D0*Hr1(1)*z3*dx**2 + 800.D0/9.D0*Hr1(1)*z3*dm - 
     &    1744.D0/9.D0*Hr1(1)*z2 - 2104.D0/3.D0*Hr1(1)*z2*x + 244.D0*
     &    Hr1(1)*z2*x**2 + 1178.D0/5.D0*Hr1(1)*z2*x**3 - 142.D0/45.D0*
     &    Hr1(1)*z2*dx**2 + 4184.D0/9.D0*Hr1(1)*z2*dm - 2320.D0/3.D0*
     &    Hr2(-1,-1)*z3 + 5776.D0/3.D0*Hr2(-1,-1)*z3*x + 5792.D0/3.D0*
     &    Hr2(-1,-1)*z3*dp + 15160.D0/9.D0*Hr2(-1,-1)*z2 + 11084.D0/9.D0
     &    *Hr2(-1,-1)*z2*x - 384.D0*Hr2(-1,-1)*z2*x**3 + 128.D0/3.D0*
     &    Hr2(-1,-1)*z2*dx**2 - 1760.D0/9.D0*Hr2(-1,-1)*z2*dp - 101908.D
     &    0/81.D0*Hr2(-1,0) - 84956.D0/81.D0*Hr2(-1,0)*x - 92.D0/5.D0*
     &    Hr2(-1,0)*x**2 + 7476.D0/25.D0*Hr2(-1,0)*x**3 + 92.D0/45.D0*
     &    Hr2(-1,0)*dx - 5716.D0/225.D0*Hr2(-1,0)*dx**2 - 17032.D0/81.D0
     &    *Hr2(-1,0)*dp )
      c2qq3 = c2qq3 + cf*ca**2 * ( 1040.D0/3.D0*Hr2(-1,0)*z3 - 2768.D0/
     &    3.D0*Hr2(-1,0)*z3*x - 2656.D0/3.D0*Hr2(-1,0)*z3*dp - 11152.D0/
     &    9.D0*Hr2(-1,0)*z2 - 9452.D0/9.D0*Hr2(-1,0)*z2*x + 1056.D0/5.D0
     &    *Hr2(-1,0)*z2*x**3 - 352.D0/15.D0*Hr2(-1,0)*z2*dx**2 + 1160.D0
     &    /9.D0*Hr2(-1,0)*z2*dp + 636.D0*Hr2(0,-1)*z3 - 444.D0*Hr2(0,-1
     &    )*z3*x - 3664.D0/3.D0*Hr2(0,-1)*z3*dp - 384.D0*Hr2(0,-1)*z3*
     &    dm - 1936.D0/9.D0*Hr2(0,-1)*z2 - 5540.D0/9.D0*Hr2(0,-1)*z2*x
     &     + 384.D0*Hr2(0,-1)*z2*x**3 + 2288.D0/9.D0*Hr2(0,-1)*z2*dp - 
     &    560.D0/3.D0*Hr2(0,-1)*z2*dm + 148084.D0/405.D0*Hr2(0,0) + 
     &    1299656.D0/405.D0*Hr2(0,0)*x - 2128.D0/5.D0*Hr2(0,0)*x**2 - 
     &    7476.D0/25.D0*Hr2(0,0)*x**3 + 964.D0/45.D0*Hr2(0,0)*dx + 
     &    24554.D0/81.D0*Hr2(0,0)*dp - 34070.D0/27.D0*Hr2(0,0)*dm + 728.
     &    D0/3.D0*Hr2(0,0)*z3*x + 192.D0*Hr2(0,0)*z3*dp - 192.D0*Hr2(0,
     &    0)*z3*dm - 44.D0/3.D0*Hr2(0,0)*z2 + 712.D0/9.D0*Hr2(0,0)*z2*x
     &     + 376.D0*Hr2(0,0)*z2*x**2 - 1548.D0/5.D0*Hr2(0,0)*z2*x**3 - 
     &    2324.D0/9.D0*Hr2(0,0)*z2*dp )
      c2qq3 = c2qq3 + cf*ca**2 * ( 3968.D0/9.D0*Hr2(0,0)*z2*dm + 20408.D
     &    0/135.D0*Hr2(0,1) + 264848.D0/135.D0*Hr2(0,1)*x + 248.D0/5.D0
     &    *Hr2(0,1)*x**2 + 1072.D0/45.D0*Hr2(0,1)*dx + 340.D0/3.D0*Hr2(
     &    0,1)*dp - 22634.D0/27.D0*Hr2(0,1)*dm + 432.D0*Hr2(0,1)*z3 + 
     &    1136.D0/3.D0*Hr2(0,1)*z3*x - 736.D0/3.D0*Hr2(0,1)*z3*dp - 576.
     &    D0*Hr2(0,1)*z3*dm - 1252.D0/9.D0*Hr2(0,1)*z2 - 5716.D0/9.D0*
     &    Hr2(0,1)*z2*x - 144.D0*Hr2(0,1)*z2*dp + 2780.D0/9.D0*Hr2(0,1)
     &    *z2*dm - 5470.D0/27.D0*Hr2(1,0) + 22634.D0/27.D0*Hr2(1,0)*x
     &     - 264.D0*Hr2(1,0)*x**2 - 7870.D0/27.D0*Hr2(1,0)*dm + 1016.D0/
     &    3.D0*Hr2(1,0)*z3 + 3320.D0/3.D0*Hr2(1,0)*z3*x - 2704.D0/3.D0*
     &    Hr2(1,0)*z3*dm - 3116.D0/9.D0*Hr2(1,0)*z2 - 4004.D0/9.D0*Hr2(
     &    1,0)*z2*x + 376.D0*Hr2(1,0)*z2*x**2 - 492.D0/5.D0*Hr2(1,0)*z2
     &    *x**3 - 164.D0/15.D0*Hr2(1,0)*z2*dx**2 + 3640.D0/9.D0*Hr2(1,0
     &    )*z2*dm - 7276.D0/27.D0*Hr2(1,1) + 26084.D0/27.D0*Hr2(1,1)*x
     &     - 9298.D0/27.D0*Hr2(1,1)*dm + 352.D0*Hr2(1,1)*z3 + 736.D0*
     &    Hr2(1,1)*z3*x )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 768.D0*Hr2(1,1)*z3*dm - 1304.D0/9.
     &    D0*Hr2(1,1)*z2 - 3032.D0/9.D0*Hr2(1,1)*z2*x + 2200.D0/9.D0*
     &    Hr2(1,1)*z2*dm + 704.D0*Hr3(-1,-1,-1)*z2 - 2240.D0*Hr3(-1,-1,
     &    -1)*z2*x - 1920.D0*Hr3(-1,-1,-1)*z2*dp - 256.D0*Hr3(-1,-1,0)
     &     + 9592.D0/9.D0*Hr3(-1,-1,0)*x + 488.D0*Hr3(-1,-1,0)*x**2 + 
     &    284.D0/5.D0*Hr3(-1,-1,0)*x**3 - 284.D0/45.D0*Hr3(-1,-1,0)*
     &    dx**2 + 4288.D0/9.D0*Hr3(-1,-1,0)*dp - 2848.D0/3.D0*Hr3(-1,-1
     &    ,0)*z2 + 5728.D0/3.D0*Hr3(-1,-1,0)*z2*x + 6656.D0/3.D0*Hr3(-1
     &    ,-1,0)*z2*dp - 520.D0*Hr3(-1,0,-1)*z2 + 1288.D0*Hr3(-1,0,-1)*
     &    z2*x + 1296.D0*Hr3(-1,0,-1)*z2*dp - 2428.D0/27.D0*Hr3(-1,0,0)
     &     - 14984.D0/27.D0*Hr3(-1,0,0)*x - 192.D0*Hr3(-1,0,0)*x**2 + 
     &    772.D0/5.D0*Hr3(-1,0,0)*x**3 + 64.D0/3.D0*Hr3(-1,0,0)*dx - 
     &    772.D0/45.D0*Hr3(-1,0,0)*dx**2 - 15568.D0/27.D0*Hr3(-1,0,0)*
     &    dp + 1040.D0/3.D0*Hr3(-1,0,0)*z2 - 3056.D0/3.D0*Hr3(-1,0,0)*
     &    z2*x - 2752.D0/3.D0*Hr3(-1,0,0)*z2*dp + 10664.D0/27.D0*Hr3(-1
     &    ,0,1) )
      c2qq3 = c2qq3 + cf*ca**2 * ( 26440.D0/27.D0*Hr3(-1,0,1)*x + 104.D0
     &    *Hr3(-1,0,1)*x**2 - 284.D0/5.D0*Hr3(-1,0,1)*x**3 + 128.D0/3.D0
     &    *Hr3(-1,0,1)*dx + 284.D0/45.D0*Hr3(-1,0,1)*dx**2 - 544.D0/27.D
     &    0*Hr3(-1,0,1)*dp - 256.D0/3.D0*Hr3(-1,0,1)*z2 + 256.D0/3.D0*
     &    Hr3(-1,0,1)*z2*x + 512.D0/3.D0*Hr3(-1,0,1)*z2*dp - 2096.D0/3.D
     &    0*Hr3(0,-1,-1)*z2 + 1232.D0/3.D0*Hr3(0,-1,-1)*z2*x + 1312.D0*
     &    Hr3(0,-1,-1)*z2*dp + 544.D0*Hr3(0,-1,-1)*z2*dm - 79172.D0/135.
     &    D0*Hr3(0,-1,0) + 43892.D0/135.D0*Hr3(0,-1,0)*x - 2248.D0/5.D0
     &    *Hr3(0,-1,0)*x**2 - 284.D0/5.D0*Hr3(0,-1,0)*x**3 + 64.D0/15.D0
     &    *Hr3(0,-1,0)*dx - 352.D0/15.D0*Hr3(0,-1,0)*dx**2 - 10864.D0/
     &    27.D0*Hr3(0,-1,0)*dp - 784.D0/3.D0*Hr3(0,-1,0)*dm + 1880.D0/3.
     &    D0*Hr3(0,-1,0)*z2 - 1784.D0/3.D0*Hr3(0,-1,0)*z2*x - 4048.D0/3.
     &    D0*Hr3(0,-1,0)*z2*dp - 192.D0*Hr3(0,-1,0)*z2*dm + 1100.D0/3.D0
     &    *Hr3(0,0,-1)*z2 - 1084.D0/3.D0*Hr3(0,0,-1)*z2*x - 2048.D0/3.D0
     &    *Hr3(0,0,-1)*z2*dp + 128.D0/3.D0*Hr3(0,0,-1)*z2*dm + 5566.D0/
     &    27.D0*Hr3(0,0,0) )
      c2qq3 = c2qq3 + cf*ca**2 * ( 30058.D0/135.D0*Hr3(0,0,0)*x - 772.D0
     &    /5.D0*Hr3(0,0,0)*x**3 - 64.D0/15.D0*Hr3(0,0,0)*dx + 7408.D0/
     &    27.D0*Hr3(0,0,0)*dp - 2060.D0/3.D0*Hr3(0,0,0)*dm - 72.D0*Hr3(
     &    0,0,0)*z2 + 320.D0/3.D0*Hr3(0,0,0)*z2*x + 512.D0/3.D0*Hr3(0,0
     &    ,0)*z2*dp + 64.D0/3.D0*Hr3(0,0,0)*z2*dm + 3692.D0/45.D0*Hr3(0
     &    ,0,1) - 99716.D0/135.D0*Hr3(0,0,1)*x - 1876.D0/5.D0*Hr3(0,0,1
     &    )*x**2 - 1036.D0/5.D0*Hr3(0,0,1)*x**3 - 452.D0/15.D0*Hr3(0,0,
     &    1)*dx + 272.D0/27.D0*Hr3(0,0,1)*dp - 11492.D0/27.D0*Hr3(0,0,1
     &    )*dm + 380.D0/3.D0*Hr3(0,0,1)*z2 - 340.D0/3.D0*Hr3(0,0,1)*z2*
     &    x - 704.D0/3.D0*Hr3(0,0,1)*z2*dp + 64.D0/3.D0*Hr3(0,0,1)*z2*
     &    dm + 668.D0/9.D0*Hr3(0,1,0) + 424.D0/9.D0*Hr3(0,1,0)*x + 264.D
     &    0*Hr3(0,1,0)*x**3 - 2644.D0/9.D0*Hr3(0,1,0)*dm + 32.D0/3.D0*
     &    Hr3(0,1,0)*z2 - 288.D0*Hr3(0,1,0)*z2*x - 512.D0/3.D0*Hr3(0,1,
     &    0)*z2*dp + 176.D0/3.D0*Hr3(0,1,0)*z2*dm - 712.D0/9.D0*Hr3(0,1
     &    ,1) - 724.D0/9.D0*Hr3(0,1,1)*x - 1936.D0/9.D0*Hr3(0,1,1)*dm
     &     + 248.D0/3.D0*Hr3(0,1,1)*z2 )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 136.D0/3.D0*Hr3(0,1,1)*z2*x - 128.
     &    D0*Hr3(0,1,1)*z2*dp - 32.D0/3.D0*Hr3(0,1,1)*z2*dm - 560.D0/3.D
     &    0*Hr3(1,0,-1)*z2 - 2864.D0/3.D0*Hr3(1,0,-1)*z2*x + 1888.D0/3.D
     &    0*Hr3(1,0,-1)*z2*dm - 2644.D0/15.D0*Hr3(1,0,0) + 31532.D0/45.D
     &    0*Hr3(1,0,0)*x + 396.D0/5.D0*Hr3(1,0,0)*x**2 + 44.D0/5.D0*
     &    Hr3(1,0,0)*dx - 2192.D0/9.D0*Hr3(1,0,0)*dm - 184.D0/3.D0*Hr3(
     &    1,0,0)*z2 + 1256.D0/3.D0*Hr3(1,0,0)*z2*x - 208.D0/3.D0*Hr3(1,
     &    0,0)*z2*dm + 592.D0/9.D0*Hr3(1,0,1) + 1516.D0/9.D0*Hr3(1,0,1)
     &    *x - 264.D0*Hr3(1,0,1)*x**3 - 680.D0/3.D0*Hr3(1,0,1)*dm - 40.D
     &    0/3.D0*Hr3(1,0,1)*z2 - 40.D0/3.D0*Hr3(1,0,1)*z2*x + 80.D0/3.D0
     &    *Hr3(1,0,1)*z2*dm + 376.D0/9.D0*Hr3(1,1,0) - 536.D0/9.D0*Hr3(
     &    1,1,0)*x + 264.D0*Hr3(1,1,0)*x**3 + 104.D0/9.D0*Hr3(1,1,0)*dm
     &     - 80.D0*Hr3(1,1,0)*z2 - 80.D0*Hr3(1,1,0)*z2*x + 96.D0*Hr3(1,
     &    1,0)*z2*dm + 484.D0/9.D0*Hr3(1,1,1) + 484.D0/9.D0*Hr3(1,1,1)*
     &    x - 968.D0/9.D0*Hr3(1,1,1)*dm + 32.D0/3.D0*Hr3(1,1,1)*z2 + 32.
     &    D0/3.D0*Hr3(1,1,1)*z2*x )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 64.D0/3.D0*Hr3(1,1,1)*z2*dm + 
     &    2288.D0/9.D0*Hr4(-1,-1,-1,0) - 4328.D0/9.D0*Hr4(-1,-1,-1,0)*x
     &     - 3520.D0/9.D0*Hr4(-1,-1,-1,0)*dp - 9928.D0/9.D0*Hr4(-1,-1,0
     &    ,0) + 2332.D0/9.D0*Hr4(-1,-1,0,0)*x + 192.D0*Hr4(-1,-1,0,0)*
     &    x**3 - 64.D0/3.D0*Hr4(-1,-1,0,0)*dx**2 + 5984.D0/9.D0*Hr4(-1,
     &    -1,0,0)*dp - 4672.D0/3.D0*Hr4(-1,-1,0,1) - 1472.D0*Hr4(-1,-1,
     &    0,1)*x + 384.D0*Hr4(-1,-1,0,1)*x**3 - 128.D0/3.D0*Hr4(-1,-1,0
     &    ,1)*dx**2 - 1744.D0/9.D0*Hr4(-1,0,-1,0) + 5848.D0/9.D0*Hr4(-1
     &    ,0,-1,0)*x + 3872.D0/9.D0*Hr4(-1,0,-1,0)*dp + 5536.D0/9.D0*
     &    Hr4(-1,0,0,0) - 2704.D0/9.D0*Hr4(-1,0,0,0)*x - 96.D0/5.D0*
     &    Hr4(-1,0,0,0)*x**3 + 32.D0/15.D0*Hr4(-1,0,0,0)*dx**2 - 5912.D0
     &    /9.D0*Hr4(-1,0,0,0)*dp + 8960.D0/9.D0*Hr4(-1,0,0,1) + 8224.D0/
     &    9.D0*Hr4(-1,0,0,1)*x - 192.D0*Hr4(-1,0,0,1)*x**3 + 64.D0/3.D0
     &    *Hr4(-1,0,0,1)*dx**2 - 352.D0/9.D0*Hr4(-1,0,0,1)*dp + 320.D0/
     &    3.D0*Hr4(-1,0,1,0) + 320.D0/3.D0*Hr4(-1,0,1,0)*x + 1088.D0/9.D
     &    0*Hr4(-1,0,1,1) )
      c2qq3 = c2qq3 + cf*ca**2 * ( 1792.D0/9.D0*Hr4(-1,0,1,1)*x + 704.D0
     &    /9.D0*Hr4(-1,0,1,1)*dp - 1600.D0/9.D0*Hr4(0,-1,-1,0) + 10408.D
     &    0/9.D0*Hr4(0,-1,-1,0)*x + 3872.D0/9.D0*Hr4(0,-1,-1,0)*dp - 
     &    288.D0*Hr4(0,-1,-1,0)*dm + 3976.D0/9.D0*Hr4(0,-1,0,0) - 40.D0/
     &    9.D0*Hr4(0,-1,0,0)*x - 192.D0*Hr4(0,-1,0,0)*x**3 - 6128.D0/9.D
     &    0*Hr4(0,-1,0,0)*dp - 416.D0/3.D0*Hr4(0,-1,0,0)*dm + 1136.D0/9.
     &    D0*Hr4(0,-1,0,1) + 10744.D0/9.D0*Hr4(0,-1,0,1)*x - 384.D0*
     &    Hr4(0,-1,0,1)*x**3 - 352.D0/9.D0*Hr4(0,-1,0,1)*dp + 128.D0/3.D
     &    0*Hr4(0,-1,0,1)*dm + 2128.D0/9.D0*Hr4(0,0,-1,0) + 704.D0/9.D0
     &    *Hr4(0,0,-1,0)*x - 192.D0/5.D0*Hr4(0,0,-1,0)*x**3 - 3920.D0/9.
     &    D0*Hr4(0,0,-1,0)*dp - 856.D0/3.D0*Hr4(0,0,-1,0)*dm + 1040.D0/
     &    9.D0*Hr4(0,0,0,0)*x + 192.D0/5.D0*Hr4(0,0,0,0)*x**3 + 2972.D0/
     &    9.D0*Hr4(0,0,0,0)*dp - 2972.D0/9.D0*Hr4(0,0,0,0)*dm + 44.D0/3.
     &    D0*Hr4(0,0,0,1) - 8.D0/9.D0*Hr4(0,0,0,1)*x - 376.D0*Hr4(0,0,0
     &    ,1)*x**2 + 1356.D0/5.D0*Hr4(0,0,0,1)*x**3 + 1648.D0/9.D0*Hr4(
     &    0,0,0,1)*dp )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 3292.D0/9.D0*Hr4(0,0,0,1)*dm - 8.D
     &    0*Hr4(0,0,1,0) - 52.D0/3.D0*Hr4(0,0,1,0)*x - 84.D0*Hr4(0,0,1,
     &    0)*dm - 44.D0/3.D0*Hr4(0,0,1,1) - 448.D0/9.D0*Hr4(0,0,1,1)*x
     &     - 352.D0/9.D0*Hr4(0,0,1,1)*dp - 896.D0/9.D0*Hr4(0,0,1,1)*dm
     &     + 164.D0/9.D0*Hr4(0,1,0,0) + 116.D0/9.D0*Hr4(0,1,0,0)*x + 
     &    376.D0*Hr4(0,1,0,0)*x**2 - 396.D0/5.D0*Hr4(0,1,0,0)*x**3 + 16.
     &    D0*Hr4(0,1,0,0)*dp - 544.D0/9.D0*Hr4(0,1,0,0)*dm + 452.D0/9.D0
     &    *Hr4(0,1,0,1) + 512.D0/9.D0*Hr4(0,1,0,1)*x - 844.D0/9.D0*Hr4(
     &    0,1,0,1)*dm - 380.D0/9.D0*Hr4(0,1,1,0) - 476.D0/9.D0*Hr4(0,1,
     &    1,0)*x + 772.D0/9.D0*Hr4(0,1,1,0)*dm - 880.D0/3.D0*Hr4(1,0,-1
     &    ,0) + 2768.D0/3.D0*Hr4(1,0,-1,0)*x - 192.D0/5.D0*Hr4(1,0,-1,0
     &    )*x**3 - 64.D0/15.D0*Hr4(1,0,-1,0)*dx**2 - 752.D0/3.D0*Hr4(1,
     &    0,-1,0)*dm + 2384.D0/9.D0*Hr4(1,0,0,0) + 1280.D0/9.D0*Hr4(1,0
     &    ,0,0)*x + 96.D0/5.D0*Hr4(1,0,0,0)*x**3 + 32.D0/15.D0*Hr4(1,0,
     &    0,0)*dx**2 - 1336.D0/9.D0*Hr4(1,0,0,0)*dm + 308.D0/3.D0*Hr4(1
     &    ,0,0,1) )
      c2qq3 = c2qq3 + cf*ca**2 * ( 1744.D0/3.D0*Hr4(1,0,0,1)*x - 376.D0
     &    *Hr4(1,0,0,1)*x**2 + 396.D0/5.D0*Hr4(1,0,0,1)*x**3 + 44.D0/5.D
     &    0*Hr4(1,0,0,1)*dx**2 - 944.D0/3.D0*Hr4(1,0,0,1)*dm - 104.D0/3.
     &    D0*Hr4(1,0,1,0) - 328.D0/3.D0*Hr4(1,0,1,0)*x + 80.D0*Hr4(1,0,
     &    1,0)*dm + 124.D0/3.D0*Hr4(1,0,1,1) + 40.D0*Hr4(1,0,1,1)*x - 
     &    88.D0*Hr4(1,0,1,1)*dm + 328.D0/9.D0*Hr4(1,1,0,0) - 2672.D0/9.D
     &    0*Hr4(1,1,0,0)*x + 376.D0*Hr4(1,1,0,0)*x**2 - 396.D0/5.D0*
     &    Hr4(1,1,0,0)*x**3 - 44.D0/5.D0*Hr4(1,1,0,0)*dx**2 + 1144.D0/9.
     &    D0*Hr4(1,1,0,0)*dm + 160.D0/9.D0*Hr4(1,1,0,1) + 868.D0/9.D0*
     &    Hr4(1,1,0,1)*x - 440.D0/9.D0*Hr4(1,1,0,1)*dm - 532.D0/9.D0*
     &    Hr4(1,1,1,0) - 1228.D0/9.D0*Hr4(1,1,1,0)*x + 1232.D0/9.D0*
     &    Hr4(1,1,1,0)*dm - 416.D0*Hr5(-1,-1,-1,0,0) + 1184.D0*Hr5(-1,
     &    -1,-1,0,0)*x + 1088.D0*Hr5(-1,-1,-1,0,0)*dp - 704.D0*Hr5(-1,
     &    -1,-1,0,1) + 2240.D0*Hr5(-1,-1,-1,0,1)*x + 1920.D0*Hr5(-1,-1,
     &    -1,0,1)*dp + 32.D0*Hr5(-1,-1,0,-1,0) - 32.D0*Hr5(-1,-1,0,-1,0
     &    )*x )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 64.D0*Hr5(-1,-1,0,-1,0)*dp + 1120.
     &    D0/3.D0*Hr5(-1,-1,0,0,0) - 1696.D0/3.D0*Hr5(-1,-1,0,0,0)*x - 
     &    2432.D0/3.D0*Hr5(-1,-1,0,0,0)*dp + 864.D0*Hr5(-1,-1,0,0,1) - 
     &    1632.D0*Hr5(-1,-1,0,0,1)*x - 1984.D0*Hr5(-1,-1,0,0,1)*dp + 
     &    896.D0/3.D0*Hr5(-1,-1,0,1,0) - 896.D0/3.D0*Hr5(-1,-1,0,1,0)*x
     &     - 1792.D0/3.D0*Hr5(-1,-1,0,1,0)*dp + 1280.D0/3.D0*Hr5(-1,-1,
     &    0,1,1) - 1280.D0/3.D0*Hr5(-1,-1,0,1,1)*x - 2560.D0/3.D0*Hr5(
     &    -1,-1,0,1,1)*dp + 16.D0*Hr5(-1,0,-1,-1,0) - 16.D0*Hr5(-1,0,-1
     &    ,-1,0)*x - 32.D0*Hr5(-1,0,-1,-1,0)*dp + 288.D0*Hr5(-1,0,-1,0,
     &    0) - 672.D0*Hr5(-1,0,-1,0,0)*x - 704.D0*Hr5(-1,0,-1,0,0)*dp
     &     + 528.D0*Hr5(-1,0,-1,0,1) - 1296.D0*Hr5(-1,0,-1,0,1)*x - 
     &    1312.D0*Hr5(-1,0,-1,0,1)*dp - 32.D0/3.D0*Hr5(-1,0,0,-1,0) - 
     &    544.D0/3.D0*Hr5(-1,0,0,-1,0)*x - 128.D0/3.D0*Hr5(-1,0,0,-1,0)
     &    *dp - 368.D0/3.D0*Hr5(-1,0,0,0,0) + 944.D0/3.D0*Hr5(-1,0,0,0,
     &    0)*x + 928.D0/3.D0*Hr5(-1,0,0,0,0)*dp - 304.D0*Hr5(-1,0,0,0,1
     &    ) )
      c2qq3 = c2qq3 + cf*ca**2 * ( 784.D0*Hr5(-1,0,0,0,1)*x + 768.D0*
     &    Hr5(-1,0,0,0,1)*dp - 392.D0/3.D0*Hr5(-1,0,0,1,0) + 392.D0/3.D0
     &    *Hr5(-1,0,0,1,0)*x + 784.D0/3.D0*Hr5(-1,0,0,1,0)*dp - 640.D0/
     &    3.D0*Hr5(-1,0,0,1,1) + 640.D0/3.D0*Hr5(-1,0,0,1,1)*x + 1280.D0
     &    /3.D0*Hr5(-1,0,0,1,1)*dp - 272.D0/3.D0*Hr5(-1,0,1,0,0) - 16.D0
     &    /3.D0*Hr5(-1,0,1,0,0)*x + 448.D0/3.D0*Hr5(-1,0,1,0,0)*dp - 80.
     &    D0/3.D0*Hr5(-1,0,1,0,1) + 80.D0/3.D0*Hr5(-1,0,1,0,1)*x + 160.D
     &    0/3.D0*Hr5(-1,0,1,0,1)*dp + 80.D0/3.D0*Hr5(-1,0,1,1,0) - 80.D0
     &    /3.D0*Hr5(-1,0,1,1,0)*x - 160.D0/3.D0*Hr5(-1,0,1,1,0)*dp - 
     &    144.D0*Hr5(0,-1,-1,-1,0) - 272.D0/3.D0*Hr5(0,-1,-1,-1,0)*x + 
     &    704.D0/3.D0*Hr5(0,-1,-1,-1,0)*dm + 484.D0*Hr5(0,-1,-1,0,0) - 
     &    524.D0/3.D0*Hr5(0,-1,-1,0,0)*x - 2128.D0/3.D0*Hr5(0,-1,-1,0,0
     &    )*dp - 1312.D0/3.D0*Hr5(0,-1,-1,0,0)*dm + 1880.D0/3.D0*Hr5(0,
     &    -1,-1,0,1) - 456.D0*Hr5(0,-1,-1,0,1)*x - 1312.D0*Hr5(0,-1,-1,
     &    0,1)*dp - 1280.D0/3.D0*Hr5(0,-1,-1,0,1)*dm + 280.D0/3.D0*Hr5(
     &    0,-1,0,-1,0) )
      c2qq3 = c2qq3 + cf*ca**2 * ( 232.D0/3.D0*Hr5(0,-1,0,-1,0)*x + 64.D
     &    0/3.D0*Hr5(0,-1,0,-1,0)*dp - 512.D0/3.D0*Hr5(0,-1,0,-1,0)*dm
     &     - 832.D0/3.D0*Hr5(0,-1,0,0,0) + 608.D0/3.D0*Hr5(0,-1,0,0,0)*
     &    x + 1424.D0/3.D0*Hr5(0,-1,0,0,0)*dp + 320.D0/3.D0*Hr5(0,-1,0,
     &    0,0)*dm - 508.D0*Hr5(0,-1,0,0,1) + 540.D0*Hr5(0,-1,0,0,1)*x
     &     + 3472.D0/3.D0*Hr5(0,-1,0,0,1)*dp + 96.D0*Hr5(0,-1,0,0,1)*dm
     &     - 328.D0/3.D0*Hr5(0,-1,0,1,0) + 584.D0/3.D0*Hr5(0,-1,0,1,0)*
     &    x + 928.D0/3.D0*Hr5(0,-1,0,1,0)*dp - 256.D0/3.D0*Hr5(0,-1,0,1
     &    ,0)*dm - 160.D0*Hr5(0,-1,0,1,1) + 800.D0/3.D0*Hr5(0,-1,0,1,1)
     &    *x + 1280.D0/3.D0*Hr5(0,-1,0,1,1)*dp - 320.D0/3.D0*Hr5(0,-1,0
     &    ,1,1)*dm + 808.D0/3.D0*Hr5(0,0,-1,-1,0) + 728.D0/3.D0*Hr5(0,0
     &    ,-1,-1,0)*x + 128.D0/3.D0*Hr5(0,0,-1,-1,0)*dp - 512.D0*Hr5(0,
     &    0,-1,-1,0)*dm - 256.D0*Hr5(0,0,-1,0,0) + 520.D0/3.D0*Hr5(0,0,
     &    -1,0,0)*x + 1120.D0/3.D0*Hr5(0,0,-1,0,0)*dp + 64.D0*Hr5(0,0,
     &    -1,0,0)*dm - 232.D0*Hr5(0,0,-1,0,1) + 1448.D0/3.D0*Hr5(0,0,-1
     &    ,0,1)*x )
      c2qq3 = c2qq3 + cf*ca**2 * ( 704.D0*Hr5(0,0,-1,0,1)*dp - 896.D0/3.
     &    D0*Hr5(0,0,-1,0,1)*dm - 56.D0*Hr5(0,0,0,-1,0) + 40.D0/3.D0*
     &    Hr5(0,0,0,-1,0)*x + 160.D0/3.D0*Hr5(0,0,0,-1,0)*dp + 32.D0*
     &    Hr5(0,0,0,-1,0)*dm - 80.D0*Hr5(0,0,0,0,0)*x - 64.D0*Hr5(0,0,0
     &    ,0,0)*dp + 64.D0*Hr5(0,0,0,0,0)*dm + 72.D0*Hr5(0,0,0,0,1) - 
     &    280.D0/3.D0*Hr5(0,0,0,0,1)*x - 160.D0*Hr5(0,0,0,0,1)*dp - 32.D
     &    0*Hr5(0,0,0,0,1)*dm + 36.D0*Hr5(0,0,0,1,0) - 28.D0*Hr5(0,0,0,
     &    1,0)*x - 64.D0*Hr5(0,0,0,1,0)*dp - 32.D0*Hr5(0,0,0,1,0)*dm + 
     &    60.D0*Hr5(0,0,0,1,1) - 140.D0/3.D0*Hr5(0,0,0,1,1)*x - 320.D0/
     &    3.D0*Hr5(0,0,0,1,1)*dp - 160.D0/3.D0*Hr5(0,0,0,1,1)*dm - 100.D
     &    0/3.D0*Hr5(0,0,1,0,0) - 260.D0/3.D0*Hr5(0,0,1,0,0)*x - 160.D0/
     &    3.D0*Hr5(0,0,1,0,0)*dp + 352.D0/3.D0*Hr5(0,0,1,0,0)*dm + 8.D0
     &    *Hr5(0,0,1,0,1) - 8.D0*Hr5(0,0,1,0,1)*x - 64.D0/3.D0*Hr5(0,0,
     &    1,0,1)*dp - 8.D0*Hr5(0,0,1,1,0) + 8.D0*Hr5(0,0,1,1,0)*x + 64.D
     &    0/3.D0*Hr5(0,0,1,1,0)*dp + 144.D0*Hr5(0,1,0,-1,0) + 560.D0/3.D
     &    0*Hr5(0,1,0,-1,0)*x )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 64.D0/3.D0*Hr5(0,1,0,-1,0)*dp - 
     &    1216.D0/3.D0*Hr5(0,1,0,-1,0)*dm - 472.D0/3.D0*Hr5(0,1,0,0,0)
     &     - 440.D0/3.D0*Hr5(0,1,0,0,0)*x + 128.D0/3.D0*Hr5(0,1,0,0,0)*
     &    dp + 1040.D0/3.D0*Hr5(0,1,0,0,0)*dm + 108.D0*Hr5(0,1,0,0,1)
     &     + 1028.D0/3.D0*Hr5(0,1,0,0,1)*x + 224.D0/3.D0*Hr5(0,1,0,0,1)
     &    *dp - 752.D0/3.D0*Hr5(0,1,0,0,1)*dm + 4.D0*Hr5(0,1,0,1,0) - 
     &    52.D0/3.D0*Hr5(0,1,0,1,0)*x - 64.D0/3.D0*Hr5(0,1,0,1,0)*dp + 
     &    16.D0*Hr5(0,1,0,1,0)*dm + 8.D0/3.D0*Hr5(0,1,0,1,1) + 8.D0/3.D0
     &    *Hr5(0,1,0,1,1)*x - 16.D0/3.D0*Hr5(0,1,0,1,1)*dm - 596.D0/3.D0
     &    *Hr5(0,1,1,0,0) - 316.D0*Hr5(0,1,1,0,0)*x + 128.D0/3.D0*Hr5(0
     &    ,1,1,0,0)*dp + 896.D0/3.D0*Hr5(0,1,1,0,0)*dm - 32.D0/3.D0*
     &    Hr5(0,1,1,0,1) + 32.D0/3.D0*Hr5(0,1,1,0,1)*dp + 32.D0/3.D0*
     &    Hr5(0,1,1,0,1)*dm + 8.D0*Hr5(0,1,1,1,0) - 8.D0/3.D0*Hr5(0,1,1
     &    ,1,0)*x - 32.D0/3.D0*Hr5(0,1,1,1,0)*dp - 16.D0/3.D0*Hr5(0,1,1
     &    ,1,0)*dm + 224.D0*Hr5(1,0,-1,-1,0) + 224.D0*Hr5(1,0,-1,-1,0)*
     &    x )
      c2qq3 = c2qq3 + cf*ca**2 * (  - 448.D0*Hr5(1,0,-1,-1,0)*dm + 400.D
     &    0/3.D0*Hr5(1,0,-1,0,0) + 1552.D0/3.D0*Hr5(1,0,-1,0,0)*x - 
     &    1184.D0/3.D0*Hr5(1,0,-1,0,0)*dm + 896.D0/3.D0*Hr5(1,0,-1,0,1)
     &     + 3200.D0/3.D0*Hr5(1,0,-1,0,1)*x - 2560.D0/3.D0*Hr5(1,0,-1,0
     &    ,1)*dm + 96.D0*Hr5(1,0,0,-1,0) + 288.D0*Hr5(1,0,0,-1,0)*x - 
     &    256.D0*Hr5(1,0,0,-1,0)*dm - 368.D0/3.D0*Hr5(1,0,0,0,0) - 944.D
     &    0/3.D0*Hr5(1,0,0,0,0)*x + 928.D0/3.D0*Hr5(1,0,0,0,0)*dm + 104.
     &    D0*Hr5(1,0,0,0,1) - 184.D0*Hr5(1,0,0,0,1)*x - 80.D0*Hr5(1,0,0
     &    ,0,1)*dm + 208.D0/3.D0*Hr5(1,0,0,1,0) + 208.D0/3.D0*Hr5(1,0,0
     &    ,1,0)*x - 416.D0/3.D0*Hr5(1,0,0,1,0)*dm + 320.D0/3.D0*Hr5(1,0
     &    ,0,1,1) + 320.D0/3.D0*Hr5(1,0,0,1,1)*x - 640.D0/3.D0*Hr5(1,0,
     &    0,1,1)*dm - 144.D0*Hr5(1,0,1,0,0) - 240.D0*Hr5(1,0,1,0,0)*x
     &     + 288.D0*Hr5(1,0,1,0,0)*dm + 16.D0/3.D0*Hr5(1,0,1,0,1) + 16.D
     &    0/3.D0*Hr5(1,0,1,0,1)*x - 32.D0/3.D0*Hr5(1,0,1,0,1)*dm - 16.D0
     &    /3.D0*Hr5(1,0,1,1,0) - 16.D0/3.D0*Hr5(1,0,1,1,0)*x + 32.D0/3.D
     &    0*Hr5(1,0,1,1,0)*dm )
      c2qq3 = c2qq3 + cf*ca**2 * ( 608.D0/3.D0*Hr5(1,1,0,-1,0) + 1760.D0
     &    /3.D0*Hr5(1,1,0,-1,0)*x - 1600.D0/3.D0*Hr5(1,1,0,-1,0)*dm - 
     &    736.D0/3.D0*Hr5(1,1,0,0,0) - 1312.D0/3.D0*Hr5(1,1,0,0,0)*x + 
     &    1664.D0/3.D0*Hr5(1,1,0,0,0)*dm + 496.D0/3.D0*Hr5(1,1,0,0,1)
     &     + 1072.D0/3.D0*Hr5(1,1,0,0,1)*x - 992.D0/3.D0*Hr5(1,1,0,0,1)
     &    *dm - 16.D0*Hr5(1,1,0,1,0) - 16.D0*Hr5(1,1,0,1,0)*x + 32.D0*
     &    Hr5(1,1,0,1,0)*dm + 32.D0/3.D0*Hr5(1,1,0,1,1) + 32.D0/3.D0*
     &    Hr5(1,1,0,1,1)*x - 64.D0/3.D0*Hr5(1,1,0,1,1)*dm - 640.D0/3.D0
     &    *Hr5(1,1,1,0,0) - 1216.D0/3.D0*Hr5(1,1,1,0,0)*x + 1280.D0/3.D0
     &    *Hr5(1,1,1,0,0)*dm - 32.D0/3.D0*Hr5(1,1,1,0,1) - 32.D0/3.D0*
     &    Hr5(1,1,1,0,1)*x + 64.D0/3.D0*Hr5(1,1,1,0,1)*dm )
      c2qq3 = c2qq3 + cf**2*ca * (  - 765211.D0/1620.D0 - 2448601.D0/
     &    810.D0*x + 31844.D0/25.D0*x**2 + 442.D0/3.D0*z5 + 2218.D0/3.D0
     &    *z5*x + 14089.D0/9.D0*z4 + 1270.D0/9.D0*z4*x + 2688.D0*z4*
     &    x**2 - 10284.D0/5.D0*z4*x**3 + 8948.D0/75.D0*dx - 976.D0*dp*
     &    z5 - 1226.D0/3.D0*dp*z4 + 16981.D0/24.D0*dm + 4456.D0/3.D0*dm
     &    *z5 - 12128.D0/9.D0*dm*z4 - 95801.D0/135.D0*z3 - 1039919.D0/
     &    135.D0*z3*x + 8816.D0/5.D0*z3*x**2 + 12748.D0/5.D0*z3*x**3 - 
     &    368.D0/15.D0*z3*dx + 1460.D0/3.D0*z3*dp + 22334.D0/27.D0*z3*
     &    dm - 1534313.D0/2025.D0*z2 + 6908669.D0/2025.D0*z2*x - 12224.D
     &    0/25.D0*z2*x**2 - 10908.D0/25.D0*z2*x**3 + 18608.D0/225.D0*z2
     &    *dx + 36904.D0/81.D0*z2*dp + 8753.D0/27.D0*z2*dm - 2200.D0/3.D
     &    0*z2*z3 + 7480.D0/3.D0*z2*z3*x + 5008.D0/3.D0*z2*z3*dp - 416.D
     &    0*z2*z3*dm + 358.D0/3.D0*Hr1(-1)*z4 - 2194.D0/3.D0*Hr1(-1)*z4
     &    *x - 1328.D0/3.D0*Hr1(-1)*dp*z4 + 47338.D0/9.D0*Hr1(-1)*z3 + 
     &    48074.D0/9.D0*Hr1(-1)*z3*x - 1152.D0*Hr1(-1)*z3*x**3 + 128.D0
     &    *Hr1(-1)*z3*dx**2 )
      c2qq3 = c2qq3 + cf**2*ca * ( 2116.D0/9.D0*Hr1(-1)*z3*dp + 477494.D
     &    0/135.D0*Hr1(-1)*z2 + 499114.D0/135.D0*Hr1(-1)*z2*x - 3104.D0/
     &    5.D0*Hr1(-1)*z2*x**2 - 18444.D0/25.D0*Hr1(-1)*z2*x**3 + 816.D0
     &    /5.D0*Hr1(-1)*z2*dx + 5668.D0/75.D0*Hr1(-1)*z2*dx**2 - 12944.D
     &    0/27.D0*Hr1(-1)*z2*dp - 4555529.D0/8100.D0*Hr1(0) - 11139971.D
     &    0/2700.D0*Hr1(0)*x + 45508.D0/25.D0*Hr1(0)*x**2 + 1112.D0/3.D0
     &    *Hr1(0)*z4 - 188.D0/3.D0*Hr1(0)*z4*x - 5108.D0/75.D0*Hr1(0)*
     &    dx - 6170.D0/9.D0*Hr1(0)*dp - 1412.D0/3.D0*Hr1(0)*dp*z4 + 
     &    85535.D0/54.D0*Hr1(0)*dm + 628.D0/3.D0*Hr1(0)*dm*z4 + 442.D0/
     &    3.D0*Hr1(0)*z3 - 27074.D0/9.D0*Hr1(0)*z3*x + 1344.D0*Hr1(0)*
     &    z3*x**2 + 1104.D0/5.D0*Hr1(0)*z3*x**3 + 4444.D0/9.D0*Hr1(0)*
     &    z3*dp - 4516.D0/9.D0*Hr1(0)*z3*dm - 61027.D0/45.D0*Hr1(0)*z2
     &     - 1165913.D0/135.D0*Hr1(0)*z2*x - 9264.D0/5.D0*Hr1(0)*z2*
     &    x**2 + 13592.D0/25.D0*Hr1(0)*z2*x**3 - 3136.D0/15.D0*Hr1(0)*
     &    z2*dx + 2354.D0/27.D0*Hr1(0)*z2*dp + 36088.D0/27.D0*Hr1(0)*z2
     &    *dm )
      c2qq3 = c2qq3 + cf**2*ca * ( 94531.D0/900.D0*Hr1(1) - 5746343.D0/
     &    2700.D0*Hr1(1)*x + 13664.D0/25.D0*Hr1(1)*x**2 - 674.D0*Hr1(1)
     &    *z4 - 1022.D0*Hr1(1)*z4*x + 25624.D0/225.D0*Hr1(1)*dx + 5563.D
     &    0/18.D0*Hr1(1)*dm + 1208.D0*Hr1(1)*dm*z4 + 12986.D0/9.D0*Hr1(
     &    1)*z3 - 31714.D0/9.D0*Hr1(1)*z3*x + 1344.D0*Hr1(1)*z3*x**2 - 
     &    4656.D0/5.D0*Hr1(1)*z3*x**3 - 1552.D0/15.D0*Hr1(1)*z3*dx**2
     &     + 5108.D0/9.D0*Hr1(1)*z3*dm + 22738.D0/45.D0*Hr1(1)*z2 - 
     &    8566.D0/15.D0*Hr1(1)*z2*x - 5264.D0/5.D0*Hr1(1)*z2*x**2 - 
     &    4852.D0/25.D0*Hr1(1)*z2*x**3 - 16.D0/5.D0*Hr1(1)*z2*dx + 5668.
     &    D0/225.D0*Hr1(1)*z2*dx**2 + 6448.D0/9.D0*Hr1(1)*z2*dm + 9536.D
     &    0/3.D0*Hr2(-1,-1)*z3 - 23792.D0/3.D0*Hr2(-1,-1)*z3*x - 23824.D
     &    0/3.D0*Hr2(-1,-1)*z3*dp - 56540.D0/9.D0*Hr2(-1,-1)*z2 - 57004.
     &    D0/9.D0*Hr2(-1,-1)*z2*x + 7344.D0/5.D0*Hr2(-1,-1)*z2*x**3 - 
     &    816.D0/5.D0*Hr2(-1,-1)*z2*dx**2 - 1232.D0/9.D0*Hr2(-1,-1)*z2*
     &    dp + 4850402.D0/2025.D0*Hr2(-1,0) + 3401962.D0/2025.D0*Hr2(-1
     &    ,0)*x )
      c2qq3 = c2qq3 + cf**2*ca * ( 9416.D0/25.D0*Hr2(-1,0)*x**2 - 10908.
     &    D0/25.D0*Hr2(-1,0)*x**3 - 9896.D0/225.D0*Hr2(-1,0)*dx + 5428.D
     &    0/225.D0*Hr2(-1,0)*dx**2 + 31472.D0/81.D0*Hr2(-1,0)*dp - 5296.
     &    D0/3.D0*Hr2(-1,0)*z3 + 11776.D0/3.D0*Hr2(-1,0)*z3*x + 12752.D0
     &    /3.D0*Hr2(-1,0)*z3*dp + 45944.D0/9.D0*Hr2(-1,0)*z2 + 47056.D0/
     &    9.D0*Hr2(-1,0)*z2*x - 4752.D0/5.D0*Hr2(-1,0)*z2*x**3 + 528.D0/
     &    5.D0*Hr2(-1,0)*z2*dx**2 + 1496.D0/9.D0*Hr2(-1,0)*z2*dp - 2940.
     &    D0*Hr2(0,-1)*z3 + 6940.D0/3.D0*Hr2(0,-1)*z3*x + 5376.D0*Hr2(0
     &    ,-1)*z3*dp + 5600.D0/3.D0*Hr2(0,-1)*z3*dm + 11612.D0/9.D0*
     &    Hr2(0,-1)*z2 + 29020.D0/9.D0*Hr2(0,-1)*z2*x - 7344.D0/5.D0*
     &    Hr2(0,-1)*z2*x**3 + 96.D0/5.D0*Hr2(0,-1)*z2*dx**2 - 1912.D0/9.
     &    D0*Hr2(0,-1)*z2*dp + 916.D0*Hr2(0,-1)*z2*dm + 446366.D0/675.D0
     &    *Hr2(0,0) - 6780067.D0/2025.D0*Hr2(0,0)*x + 34744.D0/25.D0*
     &    Hr2(0,0)*x**2 + 10908.D0/25.D0*Hr2(0,0)*x**3 - 1624.D0/225.D0
     &    *Hr2(0,0)*dx - 55048.D0/81.D0*Hr2(0,0)*dp + 8711.D0/27.D0*
     &    Hr2(0,0)*dm )
      c2qq3 = c2qq3 + cf**2*ca * ( 384.D0*Hr2(0,0)*z3 - 3568.D0/3.D0*
     &    Hr2(0,0)*z3*x - 3440.D0/3.D0*Hr2(0,0)*z3*dp + 1904.D0/3.D0*
     &    Hr2(0,0)*z3*dm - 5938.D0/9.D0*Hr2(0,0)*z2 - 2054.D0*Hr2(0,0)*
     &    z2*x - 1344.D0*Hr2(0,0)*z2*x**2 + 9408.D0/5.D0*Hr2(0,0)*z2*
     &    x**3 + 5932.D0/9.D0*Hr2(0,0)*z2*dp - 524.D0/9.D0*Hr2(0,0)*z2*
     &    dm + 1534313.D0/2025.D0*Hr2(0,1) - 3506707.D0/2025.D0*Hr2(0,1
     &    )*x + 12224.D0/25.D0*Hr2(0,1)*x**2 - 28504.D0/225.D0*Hr2(0,1)
     &    *dx - 784.D0/3.D0*Hr2(0,1)*dp - 41995.D0/81.D0*Hr2(0,1)*dm - 
     &    5164.D0/3.D0*Hr2(0,1)*z3 - 1836.D0*Hr2(0,1)*z3*x + 2704.D0/3.D
     &    0*Hr2(0,1)*z3*dp + 2336.D0*Hr2(0,1)*z3*dm + 200.D0/9.D0*Hr2(0
     &    ,1)*z2 + 8432.D0/9.D0*Hr2(0,1)*z2*x + 144.D0/5.D0*Hr2(0,1)*z2
     &    *x**3 + 32.D0/5.D0*Hr2(0,1)*z2*dx**2 + 532.D0*Hr2(0,1)*z2*dp
     &     + 3500.D0/9.D0*Hr2(0,1)*z2*dm + 548128.D0/405.D0*Hr2(1,0) + 
     &    120892.D0/405.D0*Hr2(1,0)*x + 1912.D0/5.D0*Hr2(1,0)*x**2 - 32.
     &    D0/5.D0*Hr2(1,0)*dx - 96391.D0/81.D0*Hr2(1,0)*dm - 1144.D0*
     &    Hr2(1,0)*z3 )
      c2qq3 = c2qq3 + cf**2*ca * (  - 3784.D0*Hr2(1,0)*z3*x + 3040.D0*
     &    Hr2(1,0)*z3*dm + 3076.D0/3.D0*Hr2(1,0)*z2 - 92.D0*Hr2(1,0)*z2
     &    *x - 1344.D0*Hr2(1,0)*z2*x**2 + 4656.D0/5.D0*Hr2(1,0)*z2*x**3
     &     + 1552.D0/15.D0*Hr2(1,0)*z2*dx**2 + 464.D0/3.D0*Hr2(1,0)*z2*
     &    dm + 62702.D0/45.D0*Hr2(1,1) - 8812.D0/45.D0*Hr2(1,1)*x - 288.
     &    D0/5.D0*Hr2(1,1)*x**2 - 32.D0/5.D0*Hr2(1,1)*dx - 8425.D0/9.D0
     &    *Hr2(1,1)*dm - 1472.D0*Hr2(1,1)*z3 - 2768.D0*Hr2(1,1)*z3*x + 
     &    3120.D0*Hr2(1,1)*z3*dm + 848.D0/9.D0*Hr2(1,1)*z2 - 2080.D0/9.D
     &    0*Hr2(1,1)*z2*x + 144.D0/5.D0*Hr2(1,1)*z2*x**3 + 16.D0/5.D0*
     &    Hr2(1,1)*z2*dx**2 + 3416.D0/9.D0*Hr2(1,1)*z2*dm - 2928.D0*
     &    Hr3(-1,-1,-1)*z2 + 8976.D0*Hr3(-1,-1,-1)*z2*x + 7872.D0*Hr3(
     &    -1,-1,-1)*z2*dp + 10204.D0/5.D0*Hr3(-1,-1,0) - 74764.D0/45.D0
     &    *Hr3(-1,-1,0)*x - 8768.D0/5.D0*Hr3(-1,-1,0)*x**2 - 12296.D0/
     &    25.D0*Hr3(-1,-1,0)*x**3 + 32.D0/5.D0*Hr3(-1,-1,0)*dx + 11336.D
     &    0/225.D0*Hr3(-1,-1,0)*dx**2 - 10880.D0/9.D0*Hr3(-1,-1,0)*dp
     &     + 11696.D0/3.D0*Hr3(-1,-1,0)*z2 )
      c2qq3 = c2qq3 + cf**2*ca * (  - 24368.D0/3.D0*Hr3(-1,-1,0)*z2*x
     &     - 27616.D0/3.D0*Hr3(-1,-1,0)*z2*dp + 2240.D0*Hr3(-1,0,-1)*z2
     &     - 5600.D0*Hr3(-1,0,-1)*z2*x - 5600.D0*Hr3(-1,0,-1)*z2*dp - 
     &    51448.D0/27.D0*Hr3(-1,0,0) - 22916.D0/27.D0*Hr3(-1,0,0)*x + 
     &    864.D0*Hr3(-1,0,0)*x**2 + 3656.D0/25.D0*Hr3(-1,0,0)*x**3 - 96.
     &    D0*Hr3(-1,0,0)*dx - 2696.D0/225.D0*Hr3(-1,0,0)*dx**2 + 36824.D
     &    0/27.D0*Hr3(-1,0,0)*dp - 4984.D0/3.D0*Hr3(-1,0,0)*z2 + 13048.D
     &    0/3.D0*Hr3(-1,0,0)*z2*x + 12656.D0/3.D0*Hr3(-1,0,0)*z2*dp - 
     &    67948.D0/27.D0*Hr3(-1,0,1) - 122252.D0/27.D0*Hr3(-1,0,1)*x - 
     &    256.D0*Hr3(-1,0,1)*x**2 + 12296.D0/25.D0*Hr3(-1,0,1)*x**3 - 
     &    160.D0*Hr3(-1,0,1)*dx - 11336.D0/225.D0*Hr3(-1,0,1)*dx**2 - 
     &    3376.D0/27.D0*Hr3(-1,0,1)*dp + 264.D0*Hr3(-1,0,1)*z2 - 360.D0
     &    *Hr3(-1,0,1)*z2*x - 560.D0*Hr3(-1,0,1)*z2*dp + 3104.D0*Hr3(0,
     &    -1,-1)*z2 - 2240.D0*Hr3(0,-1,-1)*z2*x - 5648.D0*Hr3(0,-1,-1)*
     &    z2*dp - 2384.D0*Hr3(0,-1,-1)*z2*dm + 120148.D0/135.D0*Hr3(0,
     &    -1,0) )
      c2qq3 = c2qq3 + cf**2*ca * (  - 255544.D0/135.D0*Hr3(0,-1,0)*x + 
     &    8192.D0/5.D0*Hr3(0,-1,0)*x**2 + 12296.D0/25.D0*Hr3(0,-1,0)*
     &    x**3 - 96.D0/5.D0*Hr3(0,-1,0)*dx + 192.D0/5.D0*Hr3(0,-1,0)*
     &    dx**2 + 27848.D0/27.D0*Hr3(0,-1,0)*dp + 572.D0*Hr3(0,-1,0)*dm
     &     - 9136.D0/3.D0*Hr3(0,-1,0)*z2 + 2688.D0*Hr3(0,-1,0)*z2*x + 
     &    5856.D0*Hr3(0,-1,0)*z2*dp + 4048.D0/3.D0*Hr3(0,-1,0)*z2*dm - 
     &    6464.D0/3.D0*Hr3(0,0,-1)*z2 + 3632.D0/3.D0*Hr3(0,0,-1)*z2*x
     &     + 3232.D0*Hr3(0,0,-1)*z2*dp + 832.D0*Hr3(0,0,-1)*z2*dm + 
     &    39083.D0/45.D0*Hr3(0,0,0) + 98053.D0/27.D0*Hr3(0,0,0)*x - 864.
     &    D0/5.D0*Hr3(0,0,0)*x**2 - 3656.D0/25.D0*Hr3(0,0,0)*x**3 + 32.D
     &    0*Hr3(0,0,0)*dx - 19118.D0/27.D0*Hr3(0,0,0)*dp - 7096.D0/27.D0
     &    *Hr3(0,0,0)*dm + 192.D0*Hr3(0,0,0)*z2 - 872.D0*Hr3(0,0,0)*z2*
     &    x - 944.D0*Hr3(0,0,0)*z2*dp + 368.D0*Hr3(0,0,0)*z2*dm + 61027.
     &    D0/45.D0*Hr3(0,0,1) + 910369.D0/135.D0*Hr3(0,0,1)*x + 9264.D0/
     &    5.D0*Hr3(0,0,1)*x**2 - 1296.D0/25.D0*Hr3(0,0,1)*x**3 + 2848.D0
     &    /15.D0*Hr3(0,0,1)*dx )
      c2qq3 = c2qq3 + cf**2*ca * ( 3848.D0/27.D0*Hr3(0,0,1)*dp - 42290.D
     &    0/27.D0*Hr3(0,0,1)*dm - 792.D0*Hr3(0,0,1)*z2 + 24.D0*Hr3(0,0,
     &    1)*z2*x + 2720.D0/3.D0*Hr3(0,0,1)*z2*dp + 544.D0*Hr3(0,0,1)*
     &    z2*dm + 133928.D0/135.D0*Hr3(0,1,0) + 278828.D0/135.D0*Hr3(0,
     &    1,0)*x - 1168.D0/5.D0*Hr3(0,1,0)*x**2 - 440.D0*Hr3(0,1,0)*
     &    x**3 + 32.D0/5.D0*Hr3(0,1,0)*dx + 32.D0*Hr3(0,1,0)*dp - 36896.
     &    D0/27.D0*Hr3(0,1,0)*dm - 1088.D0/3.D0*Hr3(0,1,0)*z2 + 208.D0/
     &    3.D0*Hr3(0,1,0)*z2*x + 624.D0*Hr3(0,1,0)*z2*dp + 576.D0*Hr3(0
     &    ,1,0)*z2*dm + 53996.D0/45.D0*Hr3(0,1,1) + 115576.D0/45.D0*
     &    Hr3(0,1,1)*x - 288.D0/5.D0*Hr3(0,1,1)*x**2 + 32.D0/5.D0*Hr3(0
     &    ,1,1)*dx + 32.D0*Hr3(0,1,1)*dp - 4304.D0/3.D0*Hr3(0,1,1)*dm
     &     - 1408.D0/3.D0*Hr3(0,1,1)*z2 - 288.D0*Hr3(0,1,1)*z2*x + 1456.
     &    D0/3.D0*Hr3(0,1,1)*z2*dp + 464.D0*Hr3(0,1,1)*z2*dm + 376.D0*
     &    Hr3(1,0,-1)*z2 + 2584.D0*Hr3(1,0,-1)*z2*x - 1488.D0*Hr3(1,0,
     &    -1)*z2*dm + 166384.D0/135.D0*Hr3(1,0,0) - 60284.D0/135.D0*
     &    Hr3(1,0,0)*x )
      c2qq3 = c2qq3 + cf**2*ca * (  - 4224.D0/5.D0*Hr3(1,0,0)*x**2 - 
     &    1408.D0/15.D0*Hr3(1,0,0)*dx - 30610.D0/27.D0*Hr3(1,0,0)*dm - 
     &    560.D0/3.D0*Hr3(1,0,0)*z2 - 7184.D0/3.D0*Hr3(1,0,0)*z2*x + 
     &    3712.D0/3.D0*Hr3(1,0,0)*z2*dm + 4636.D0/9.D0*Hr3(1,0,1) + 
     &    12616.D0/9.D0*Hr3(1,0,1)*x + 176.D0*Hr3(1,0,1)*x**2 + 440.D0*
     &    Hr3(1,0,1)*x**3 - 11888.D0/9.D0*Hr3(1,0,1)*dm - 560.D0/3.D0*
     &    Hr3(1,0,1)*z2 - 1424.D0/3.D0*Hr3(1,0,1)*z2*x + 1408.D0/3.D0*
     &    Hr3(1,0,1)*z2*dm + 5116.D0/9.D0*Hr3(1,1,0) + 1660.D0*Hr3(1,1,
     &    0)*x - 176.D0*Hr3(1,1,0)*x**2 - 440.D0*Hr3(1,1,0)*x**3 - 
     &    14188.D0/9.D0*Hr3(1,1,0)*dm + 16.D0/3.D0*Hr3(1,1,0)*z2 - 2864.
     &    D0/3.D0*Hr3(1,1,0)*z2*x + 1696.D0/3.D0*Hr3(1,1,0)*z2*dm + 
     &    1156.D0/3.D0*Hr3(1,1,1) + 1348.D0*Hr3(1,1,1)*x - 3464.D0/3.D0
     &    *Hr3(1,1,1)*dm - 464.D0/3.D0*Hr3(1,1,1)*z2 - 1328.D0/3.D0*
     &    Hr3(1,1,1)*z2*x + 1216.D0/3.D0*Hr3(1,1,1)*z2*dm - 8152.D0/9.D0
     &    *Hr4(-1,-1,-1,0) - 728.D0/9.D0*Hr4(-1,-1,-1,0)*x + 288.D0/5.D0
     &    *Hr4(-1,-1,-1,0)*x**3 )
      c2qq3 = c2qq3 + cf**2*ca * (  - 32.D0/5.D0*Hr4(-1,-1,-1,0)*dx**2
     &     + 4448.D0/9.D0*Hr4(-1,-1,-1,0)*dp + 40100.D0/9.D0*Hr4(-1,-1,
     &    0,0) + 18556.D0/9.D0*Hr4(-1,-1,0,0)*x - 864.D0*Hr4(-1,-1,0,0)
     &    *x**3 + 96.D0*Hr4(-1,-1,0,0)*dx**2 - 9808.D0/9.D0*Hr4(-1,-1,0
     &    ,0)*dp + 17488.D0/3.D0*Hr4(-1,-1,0,1) + 18880.D0/3.D0*Hr4(-1,
     &    -1,0,1)*x - 1440.D0*Hr4(-1,-1,0,1)*x**3 + 160.D0*Hr4(-1,-1,0,
     &    1)*dx**2 + 384.D0*Hr4(-1,-1,0,1)*dp + 6920.D0/9.D0*Hr4(-1,0,
     &    -1,0) - 6248.D0/9.D0*Hr4(-1,0,-1,0)*x - 288.D0/5.D0*Hr4(-1,0,
     &    -1,0)*x**3 + 32.D0/5.D0*Hr4(-1,0,-1,0)*dx**2 - 6664.D0/9.D0*
     &    Hr4(-1,0,-1,0)*dp - 23900.D0/9.D0*Hr4(-1,0,0,0) - 6532.D0/9.D0
     &    *Hr4(-1,0,0,0)*x + 1152.D0/5.D0*Hr4(-1,0,0,0)*x**3 - 128.D0/5.
     &    D0*Hr4(-1,0,0,0)*dx**2 + 12148.D0/9.D0*Hr4(-1,0,0,0)*dp - 
     &    37144.D0/9.D0*Hr4(-1,0,0,1) - 38960.D0/9.D0*Hr4(-1,0,0,1)*x
     &     + 864.D0*Hr4(-1,0,0,1)*x**3 - 96.D0*Hr4(-1,0,0,1)*dx**2 - 
     &    2896.D0/9.D0*Hr4(-1,0,0,1)*dp - 1616.D0/3.D0*Hr4(-1,0,1,0) - 
     &    2000.D0/3.D0*Hr4(-1,0,1,0)*x )
      c2qq3 = c2qq3 + cf**2*ca * ( 288.D0/5.D0*Hr4(-1,0,1,0)*x**3 - 32.D
     &    0/5.D0*Hr4(-1,0,1,0)*dx**2 - 192.D0*Hr4(-1,0,1,0)*dp - 5776.D0
     &    /9.D0*Hr4(-1,0,1,1) - 8912.D0/9.D0*Hr4(-1,0,1,1)*x + 288.D0/5.
     &    D0*Hr4(-1,0,1,1)*x**3 - 32.D0/5.D0*Hr4(-1,0,1,1)*dx**2 - 3712.
     &    D0/9.D0*Hr4(-1,0,1,1)*dp + 8072.D0/9.D0*Hr4(0,-1,-1,0) - 
     &    24056.D0/9.D0*Hr4(0,-1,-1,0)*x - 288.D0/5.D0*Hr4(0,-1,-1,0)*
     &    x**3 + 64.D0/5.D0*Hr4(0,-1,-1,0)*dx**2 - 6736.D0/9.D0*Hr4(0,
     &    -1,-1,0)*dp + 1080.D0*Hr4(0,-1,-1,0)*dm - 16376.D0/9.D0*Hr4(0
     &    ,-1,0,0) - 11368.D0/9.D0*Hr4(0,-1,0,0)*x + 864.D0*Hr4(0,-1,0,
     &    0)*x**3 - 64.D0/5.D0*Hr4(0,-1,0,0)*dx**2 + 12112.D0/9.D0*Hr4(
     &    0,-1,0,0)*dp + 8.D0*Hr4(0,-1,0,0)*dm - 7576.D0/9.D0*Hr4(0,-1,
     &    0,1) - 41048.D0/9.D0*Hr4(0,-1,0,1)*x + 1440.D0*Hr4(0,-1,0,1)*
     &    x**3 - 64.D0/5.D0*Hr4(0,-1,0,1)*dx**2 - 1456.D0/9.D0*Hr4(0,-1
     &    ,0,1)*dp - 376.D0*Hr4(0,-1,0,1)*dm - 4736.D0/9.D0*Hr4(0,0,-1,
     &    0) - 3568.D0/9.D0*Hr4(0,0,-1,0)*x + 864.D0/5.D0*Hr4(0,0,-1,0)
     &    *x**3 )
      c2qq3 = c2qq3 + cf**2*ca * ( 8176.D0/9.D0*Hr4(0,0,-1,0)*dp + 1280.
     &    D0/3.D0*Hr4(0,0,-1,0)*dm + 2002.D0/3.D0*Hr4(0,0,0,0) + 10346.D
     &    0/9.D0*Hr4(0,0,0,0)*x - 288.D0*Hr4(0,0,0,0)*x**3 - 7732.D0/9.D
     &    0*Hr4(0,0,0,0)*dp - 92.D0/3.D0*Hr4(0,0,0,0)*dm + 5938.D0/9.D0
     &    *Hr4(0,0,0,1) + 14918.D0/9.D0*Hr4(0,0,0,1)*x + 1344.D0*Hr4(0,
     &    0,0,1)*x**2 - 8544.D0/5.D0*Hr4(0,0,0,1)*x**3 - 3764.D0/9.D0*
     &    Hr4(0,0,0,1)*dp - 548.D0/3.D0*Hr4(0,0,0,1)*dm + 5912.D0/9.D0*
     &    Hr4(0,0,1,0) + 9608.D0/9.D0*Hr4(0,0,1,0)*x - 288.D0/5.D0*Hr4(
     &    0,0,1,0)*x**3 + 84.D0*Hr4(0,0,1,0)*dp - 8068.D0/9.D0*Hr4(0,0,
     &    1,0)*dm + 2080.D0/3.D0*Hr4(0,0,1,1) + 10880.D0/9.D0*Hr4(0,0,1
     &    ,1)*x - 288.D0/5.D0*Hr4(0,0,1,1)*x**3 + 1856.D0/9.D0*Hr4(0,0,
     &    1,1)*dp - 8024.D0/9.D0*Hr4(0,0,1,1)*dm + 5068.D0/9.D0*Hr4(0,1
     &    ,0,0) + 9028.D0/9.D0*Hr4(0,1,0,0)*x - 1344.D0*Hr4(0,1,0,0)*
     &    x**2 + 4224.D0/5.D0*Hr4(0,1,0,0)*x**3 - 32.D0*Hr4(0,1,0,0)*dp
     &     - 8048.D0/9.D0*Hr4(0,1,0,0)*dm + 3836.D0/9.D0*Hr4(0,1,0,1)
     &     + 3596.D0/9.D0*Hr4(0,1,0,1)*x )
      c2qq3 = c2qq3 + cf**2*ca * ( 8.D0*Hr4(0,1,0,1)*dp - 6868.D0/9.D0*
     &    Hr4(0,1,0,1)*dm + 516.D0*Hr4(0,1,1,0) + 1612.D0/3.D0*Hr4(0,1,
     &    1,0)*x - 8.D0*Hr4(0,1,1,0)*dp - 2884.D0/3.D0*Hr4(0,1,1,0)*dm
     &     + 4004.D0/9.D0*Hr4(0,1,1,1) + 4004.D0/9.D0*Hr4(0,1,1,1)*x - 
     &    7216.D0/9.D0*Hr4(0,1,1,1)*dm + 3560.D0/3.D0*Hr4(1,0,-1,0) - 
     &    7480.D0/3.D0*Hr4(1,0,-1,0)*x + 576.D0/5.D0*Hr4(1,0,-1,0)*x**3
     &     + 64.D0/5.D0*Hr4(1,0,-1,0)*dx**2 + 1288.D0/3.D0*Hr4(1,0,-1,0
     &    )*dm - 4748.D0/9.D0*Hr4(1,0,0,0) + 7252.D0/9.D0*Hr4(1,0,0,0)*
     &    x - 288.D0/5.D0*Hr4(1,0,0,0)*x**3 - 32.D0/5.D0*Hr4(1,0,0,0)*
     &    dx**2 - 5996.D0/9.D0*Hr4(1,0,0,0)*dm - 428.D0/9.D0*Hr4(1,0,0,
     &    1) - 7268.D0/9.D0*Hr4(1,0,0,1)*x + 1344.D0*Hr4(1,0,0,1)*x**2
     &     - 4224.D0/5.D0*Hr4(1,0,0,1)*x**3 - 1408.D0/15.D0*Hr4(1,0,0,1
     &    )*dx**2 - 2792.D0/9.D0*Hr4(1,0,0,1)*dm + 4060.D0/9.D0*Hr4(1,0
     &    ,1,0) + 5164.D0/9.D0*Hr4(1,0,1,0)*x - 8096.D0/9.D0*Hr4(1,0,1,
     &    0)*dm + 2884.D0/9.D0*Hr4(1,0,1,1) + 3508.D0/9.D0*Hr4(1,0,1,1)
     &    *x )
      c2qq3 = c2qq3 + cf**2*ca * (  - 6272.D0/9.D0*Hr4(1,0,1,1)*dm + 
     &    4916.D0/9.D0*Hr4(1,1,0,0) + 14420.D0/9.D0*Hr4(1,1,0,0)*x - 
     &    1344.D0*Hr4(1,1,0,0)*x**2 + 4224.D0/5.D0*Hr4(1,1,0,0)*x**3 + 
     &    1408.D0/15.D0*Hr4(1,1,0,0)*dx**2 - 10672.D0/9.D0*Hr4(1,1,0,0)
     &    *dm + 1076.D0/3.D0*Hr4(1,1,0,1) + 572.D0/3.D0*Hr4(1,1,0,1)*x
     &     - 1880.D0/3.D0*Hr4(1,1,0,1)*dm + 3128.D0/9.D0*Hr4(1,1,1,0)
     &     + 4016.D0/9.D0*Hr4(1,1,1,0)*x - 6568.D0/9.D0*Hr4(1,1,1,0)*dm
     &     + 880.D0/3.D0*Hr4(1,1,1,1) + 880.D0/3.D0*Hr4(1,1,1,1)*x - 
     &    1760.D0/3.D0*Hr4(1,1,1,1)*dm - 288.D0*Hr5(-1,-1,-1,-1,0) + 
     &    864.D0*Hr5(-1,-1,-1,-1,0)*x + 768.D0*Hr5(-1,-1,-1,-1,0)*dp + 
     &    2144.D0*Hr5(-1,-1,-1,0,0) - 6080.D0*Hr5(-1,-1,-1,0,0)*x - 
     &    5600.D0*Hr5(-1,-1,-1,0,0)*dp + 2784.D0*Hr5(-1,-1,-1,0,1) - 
     &    8544.D0*Hr5(-1,-1,-1,0,1)*x - 7488.D0*Hr5(-1,-1,-1,0,1)*dp + 
     &    208.D0*Hr5(-1,-1,0,-1,0) - 784.D0*Hr5(-1,-1,0,-1,0)*x - 608.D0
     &    *Hr5(-1,-1,0,-1,0)*dp - 2008.D0*Hr5(-1,-1,0,0,0) + 3544.D0*
     &    Hr5(-1,-1,0,0,0)*x )
      c2qq3 = c2qq3 + cf**2*ca * ( 4528.D0*Hr5(-1,-1,0,0,0)*dp - 10496.D
     &    0/3.D0*Hr5(-1,-1,0,0,1) + 20576.D0/3.D0*Hr5(-1,-1,0,0,1)*x + 
     &    24352.D0/3.D0*Hr5(-1,-1,0,0,1)*dp - 3680.D0/3.D0*Hr5(-1,-1,0,
     &    1,0) + 4256.D0/3.D0*Hr5(-1,-1,0,1,0)*x + 7552.D0/3.D0*Hr5(-1,
     &    -1,0,1,0)*dp - 4960.D0/3.D0*Hr5(-1,-1,0,1,1) + 5536.D0/3.D0*
     &    Hr5(-1,-1,0,1,1)*x + 10112.D0/3.D0*Hr5(-1,-1,0,1,1)*dp + 256.D
     &    0*Hr5(-1,0,-1,-1,0) - 832.D0*Hr5(-1,0,-1,-1,0)*x - 704.D0*
     &    Hr5(-1,0,-1,-1,0)*dp - 4768.D0/3.D0*Hr5(-1,0,-1,0,0) + 11392.D
     &    0/3.D0*Hr5(-1,0,-1,0,0)*x + 11744.D0/3.D0*Hr5(-1,0,-1,0,0)*dp
     &     - 2112.D0*Hr5(-1,0,-1,0,1) + 5184.D0*Hr5(-1,0,-1,0,1)*x + 
     &    5248.D0*Hr5(-1,0,-1,0,1)*dp - 336.D0*Hr5(-1,0,0,-1,0) + 1200.D
     &    0*Hr5(-1,0,0,-1,0)*x + 960.D0*Hr5(-1,0,0,-1,0)*dp + 2392.D0/3.
     &    D0*Hr5(-1,0,0,0,0) - 4984.D0/3.D0*Hr5(-1,0,0,0,0)*x - 5648.D0/
     &    3.D0*Hr5(-1,0,0,0,0)*dp + 1480.D0*Hr5(-1,0,0,0,1) - 3496.D0*
     &    Hr5(-1,0,0,0,1)*x - 3632.D0*Hr5(-1,0,0,0,1)*dp + 712.D0*Hr5(
     &    -1,0,0,1,0) )
      c2qq3 = c2qq3 + cf**2*ca * (  - 808.D0*Hr5(-1,0,0,1,0)*x - 1456.D0
     &    *Hr5(-1,0,0,1,0)*dp + 3040.D0/3.D0*Hr5(-1,0,0,1,1) - 3328.D0/
     &    3.D0*Hr5(-1,0,0,1,1)*x - 6176.D0/3.D0*Hr5(-1,0,0,1,1)*dp + 
     &    416.D0*Hr5(-1,0,1,0,0) - 32.D0*Hr5(-1,0,1,0,0)*x - 704.D0*
     &    Hr5(-1,0,1,0,0)*dp + 592.D0/3.D0*Hr5(-1,0,1,0,1) - 592.D0/3.D0
     &    *Hr5(-1,0,1,0,1)*x - 1184.D0/3.D0*Hr5(-1,0,1,0,1)*dp + 112.D0/
     &    3.D0*Hr5(-1,0,1,1,0) - 112.D0/3.D0*Hr5(-1,0,1,1,0)*x - 224.D0/
     &    3.D0*Hr5(-1,0,1,1,0)*dp + 96.D0*Hr5(-1,0,1,1,1) - 96.D0*Hr5(
     &    -1,0,1,1,1)*x - 192.D0*Hr5(-1,0,1,1,1)*dp + 2528.D0/3.D0*Hr5(
     &    0,-1,-1,-1,0) - 544.D0*Hr5(0,-1,-1,-1,0)*x - 800.D0*Hr5(0,-1,
     &    -1,-1,0)*dp - 2720.D0/3.D0*Hr5(0,-1,-1,-1,0)*dm - 7624.D0/3.D0
     &    *Hr5(0,-1,-1,0,0) + 5144.D0/3.D0*Hr5(0,-1,-1,0,0)*x + 11792.D0
     &    /3.D0*Hr5(0,-1,-1,0,0)*dp + 5984.D0/3.D0*Hr5(0,-1,-1,0,0)*dm
     &     - 8048.D0/3.D0*Hr5(0,-1,-1,0,1) + 1968.D0*Hr5(0,-1,-1,0,1)*x
     &     + 5248.D0*Hr5(0,-1,-1,0,1)*dp + 5792.D0/3.D0*Hr5(0,-1,-1,0,1
     &    )*dm )
      c2qq3 = c2qq3 + cf**2*ca * (  - 1952.D0/3.D0*Hr5(0,-1,0,-1,0) + 
     &    1120.D0/3.D0*Hr5(0,-1,0,-1,0)*x + 1792.D0/3.D0*Hr5(0,-1,0,-1,
     &    0)*dp + 2080.D0/3.D0*Hr5(0,-1,0,-1,0)*dm + 5240.D0/3.D0*Hr5(0
     &    ,-1,0,0,0) - 4408.D0/3.D0*Hr5(0,-1,0,0,0)*x - 8416.D0/3.D0*
     &    Hr5(0,-1,0,0,0)*dp - 2272.D0/3.D0*Hr5(0,-1,0,0,0)*dm + 7576.D0
     &    /3.D0*Hr5(0,-1,0,0,1) - 6728.D0/3.D0*Hr5(0,-1,0,0,1)*x - 
     &    14992.D0/3.D0*Hr5(0,-1,0,0,1)*dp - 2912.D0/3.D0*Hr5(0,-1,0,0,
     &    1)*dm + 1936.D0/3.D0*Hr5(0,-1,0,1,0) - 752.D0*Hr5(0,-1,0,1,0)
     &    *x - 4160.D0/3.D0*Hr5(0,-1,0,1,0)*dp + 224.D0/3.D0*Hr5(0,-1,0
     &    ,1,0)*dm + 2560.D0/3.D0*Hr5(0,-1,0,1,1) - 3008.D0/3.D0*Hr5(0,
     &    -1,0,1,1)*x - 1824.D0*Hr5(0,-1,0,1,1)*dp + 352.D0/3.D0*Hr5(0,
     &    -1,0,1,1)*dm - 4544.D0/3.D0*Hr5(0,0,-1,-1,0) - 1312.D0/3.D0*
     &    Hr5(0,0,-1,-1,0)*x + 704.D0*Hr5(0,0,-1,-1,0)*dp + 2176.D0*
     &    Hr5(0,0,-1,-1,0)*dm + 5632.D0/3.D0*Hr5(0,0,-1,0,0) - 2144.D0/
     &    3.D0*Hr5(0,0,-1,0,0)*x - 2240.D0*Hr5(0,0,-1,0,0)*dp - 1088.D0
     &    *Hr5(0,0,-1,0,0)*dm )
      c2qq3 = c2qq3 + cf**2*ca * ( 4192.D0/3.D0*Hr5(0,0,-1,0,1) - 4288.D
     &    0/3.D0*Hr5(0,0,-1,0,1)*x - 2880.D0*Hr5(0,0,-1,0,1)*dp + 256.D0
     &    *Hr5(0,0,-1,0,1)*dm + 2320.D0/3.D0*Hr5(0,0,0,-1,0) - 272.D0/3.
     &    D0*Hr5(0,0,0,-1,0)*x - 1856.D0/3.D0*Hr5(0,0,0,-1,0)*dp - 1472.
     &    D0/3.D0*Hr5(0,0,0,-1,0)*dm + 568.D0*Hr5(0,0,0,0,0)*x + 400.D0
     &    *Hr5(0,0,0,0,0)*dp - 400.D0*Hr5(0,0,0,0,0)*dm - 192.D0*Hr5(0,
     &    0,0,0,1) + 2344.D0/3.D0*Hr5(0,0,0,0,1)*x + 880.D0*Hr5(0,0,0,0
     &    ,1)*dp - 304.D0*Hr5(0,0,0,0,1)*dm - 96.D0*Hr5(0,0,0,1,0) + 
     &    1168.D0/3.D0*Hr5(0,0,0,1,0)*x + 1360.D0/3.D0*Hr5(0,0,0,1,0)*
     &    dp - 496.D0/3.D0*Hr5(0,0,0,1,0)*dm - 160.D0*Hr5(0,0,0,1,1) + 
     &    1552.D0/3.D0*Hr5(0,0,0,1,1)*x + 1936.D0/3.D0*Hr5(0,0,0,1,1)*
     &    dp - 496.D0/3.D0*Hr5(0,0,0,1,1)*dm + 472.D0/3.D0*Hr5(0,0,1,0,
     &    0) + 472.D0*Hr5(0,0,1,0,0)*x + 832.D0/3.D0*Hr5(0,0,1,0,0)*dp
     &     - 576.D0*Hr5(0,0,1,0,0)*dm + 104.D0/3.D0*Hr5(0,0,1,0,1) + 
     &    584.D0/3.D0*Hr5(0,0,1,0,1)*x + 544.D0/3.D0*Hr5(0,0,1,0,1)*dp
     &     - 192.D0*Hr5(0,0,1,0,1)*dm )
      c2qq3 = c2qq3 + cf**2*ca * (  - 104.D0/3.D0*Hr5(0,0,1,1,0) + 40.D0
     &    *Hr5(0,0,1,1,0)*x + 160.D0/3.D0*Hr5(0,0,1,1,0)*dp - 128.D0/3.D
     &    0*Hr5(0,0,1,1,0)*dm + 96.D0*Hr5(0,0,1,1,1)*x + 96.D0*Hr5(0,0,
     &    1,1,1)*dp - 96.D0*Hr5(0,0,1,1,1)*dm - 1168.D0/3.D0*Hr5(0,1,0,
     &    -1,0) - 1552.D0/3.D0*Hr5(0,1,0,-1,0)*x + 64.D0*Hr5(0,1,0,-1,0
     &    )*dp + 1120.D0*Hr5(0,1,0,-1,0)*dm + 1808.D0/3.D0*Hr5(0,1,0,0,
     &    0) + 2512.D0/3.D0*Hr5(0,1,0,0,0)*x - 448.D0/3.D0*Hr5(0,1,0,0,
     &    0)*dp - 4000.D0/3.D0*Hr5(0,1,0,0,0)*dm - 472.D0/3.D0*Hr5(0,1,
     &    0,0,1) - 1544.D0/3.D0*Hr5(0,1,0,0,1)*x - 736.D0/3.D0*Hr5(0,1,
     &    0,0,1)*dp + 848.D0/3.D0*Hr5(0,1,0,0,1)*dm - 24.D0*Hr5(0,1,0,1
     &    ,0) + 40.D0*Hr5(0,1,0,1,0)*x + 64.D0*Hr5(0,1,0,1,0)*dp - 112.D
     &    0/3.D0*Hr5(0,1,0,1,0)*dm + 200.D0/3.D0*Hr5(0,1,0,1,1) + 200.D0
     &    /3.D0*Hr5(0,1,0,1,1)*x - 304.D0/3.D0*Hr5(0,1,0,1,1)*dm + 1744.
     &    D0/3.D0*Hr5(0,1,1,0,0) + 832.D0*Hr5(0,1,1,0,0)*x - 448.D0/3.D0
     &    *Hr5(0,1,1,0,0)*dp - 768.D0*Hr5(0,1,1,0,0)*dm + 48.D0*Hr5(0,1
     &    ,1,0,1) )
      c2qq3 = c2qq3 + cf**2*ca * ( 16.D0*Hr5(0,1,1,0,1)*x - 32.D0*Hr5(0
     &    ,1,1,0,1)*dp - 64.D0*Hr5(0,1,1,0,1)*dm - 344.D0/3.D0*Hr5(0,1,
     &    1,1,0) - 248.D0/3.D0*Hr5(0,1,1,1,0)*x + 32.D0*Hr5(0,1,1,1,0)*
     &    dp + 496.D0/3.D0*Hr5(0,1,1,1,0)*dm - 2768.D0/3.D0*Hr5(1,0,-1,
     &    -1,0) - 3344.D0/3.D0*Hr5(1,0,-1,-1,0)*x + 5728.D0/3.D0*Hr5(1,
     &    0,-1,-1,0)*dm - 352.D0/3.D0*Hr5(1,0,-1,0,0) - 3520.D0/3.D0*
     &    Hr5(1,0,-1,0,0)*x + 1760.D0/3.D0*Hr5(1,0,-1,0,0)*dm - 2512.D0/
     &    3.D0*Hr5(1,0,-1,0,1) - 9424.D0/3.D0*Hr5(1,0,-1,0,1)*x + 7328.D
     &    0/3.D0*Hr5(1,0,-1,0,1)*dm - 80.D0/3.D0*Hr5(1,0,0,-1,0) - 1520.
     &    D0/3.D0*Hr5(1,0,0,-1,0)*x + 640.D0/3.D0*Hr5(1,0,0,-1,0)*dm + 
     &    1576.D0/3.D0*Hr5(1,0,0,0,0) + 4168.D0/3.D0*Hr5(1,0,0,0,0)*x
     &     - 4016.D0/3.D0*Hr5(1,0,0,0,0)*dm + 16.D0/3.D0*Hr5(1,0,0,0,1)
     &     + 4624.D0/3.D0*Hr5(1,0,0,0,1)*x - 1952.D0/3.D0*Hr5(1,0,0,0,1
     &    )*dm - 160.D0/3.D0*Hr5(1,0,0,1,0) + 128.D0/3.D0*Hr5(1,0,0,1,0
     &    )*x + 224.D0/3.D0*Hr5(1,0,0,1,0)*dm - 80.D0*Hr5(1,0,0,1,1) + 
     &    16.D0*Hr5(1,0,0,1,1)*x )
      c2qq3 = c2qq3 + cf**2*ca * ( 128.D0*Hr5(1,0,0,1,1)*dm + 1376.D0/3.
     &    D0*Hr5(1,0,1,0,0) + 1664.D0/3.D0*Hr5(1,0,1,0,0)*x - 2464.D0/3.
     &    D0*Hr5(1,0,1,0,0)*dm + 176.D0/3.D0*Hr5(1,0,1,0,1) + 176.D0/3.D
     &    0*Hr5(1,0,1,0,1)*x - 352.D0/3.D0*Hr5(1,0,1,0,1)*dm - 16.D0*
     &    Hr5(1,0,1,1,0) - 16.D0*Hr5(1,0,1,1,0)*x + 32.D0*Hr5(1,0,1,1,0
     &    )*dm + 48.D0*Hr5(1,0,1,1,1) + 48.D0*Hr5(1,0,1,1,1)*x - 96.D0*
     &    Hr5(1,0,1,1,1)*dm - 592.D0*Hr5(1,1,0,-1,0) - 1744.D0*Hr5(1,1,
     &    0,-1,0)*x + 1568.D0*Hr5(1,1,0,-1,0)*dm + 808.D0*Hr5(1,1,0,0,0
     &    ) + 1768.D0*Hr5(1,1,0,0,0)*x - 1936.D0*Hr5(1,1,0,0,0)*dm - 
     &    1216.D0/3.D0*Hr5(1,1,0,0,1) - 928.D0/3.D0*Hr5(1,1,0,0,1)*x + 
     &    1568.D0/3.D0*Hr5(1,1,0,0,1)*dm - 16.D0*Hr5(1,1,0,1,0) - 16.D0
     &    *Hr5(1,1,0,1,0)*x + 32.D0*Hr5(1,1,0,1,0)*dm + 112.D0/3.D0*
     &    Hr5(1,1,0,1,1) + 112.D0/3.D0*Hr5(1,1,0,1,1)*x - 224.D0/3.D0*
     &    Hr5(1,1,0,1,1)*dm + 1696.D0/3.D0*Hr5(1,1,1,0,0) + 1984.D0/3.D0
     &    *Hr5(1,1,1,0,0)*x - 2720.D0/3.D0*Hr5(1,1,1,0,0)*dm + 32.D0/3.D
     &    0*Hr5(1,1,1,0,1) )
      c2qq3 = c2qq3 + cf**2*ca * ( 32.D0/3.D0*Hr5(1,1,1,0,1)*x - 64.D0/
     &    3.D0*Hr5(1,1,1,0,1)*dm - 96.D0*Hr5(1,1,1,1,0) - 96.D0*Hr5(1,1
     &    ,1,1,0)*x + 192.D0*Hr5(1,1,1,1,0)*dm )
      c2qq3 = c2qq3 + cf**3 * ( 346981.D0/900.D0 + 32773.D0/50.D0*x - 
     &    10824.D0/25.D0*x**2 - 408.D0*z5 - 2888.D0/3.D0*z5*x - 1862.D0/
     &    3.D0*z4 + 636.D0*z4*x - 1600.D0*z4*x**2 + 10872.D0/5.D0*z4*
     &    x**3 - 7864.D0/225.D0*dx + 3968.D0/3.D0*dp*z5 + 544.D0*dp*z4
     &     - 1001.D0/8.D0*dm - 5360.D0/3.D0*dm*z5 + 196.D0/3.D0*dm*z4
     &     + 2168.D0/15.D0*z3 + 45744.D0/5.D0*z3*x - 5952.D0/5.D0*z3*
     &    x**2 - 9456.D0/5.D0*z3*x**3 + 656.D0/15.D0*z3*dx + 40.D0*z3*
     &    dp + 286.D0*z3*dm + 41048.D0/75.D0*z2 + 53498.D0/225.D0*z2*x
     &     + 9168.D0/25.D0*z2*x**2 - 8088.D0/25.D0*z2*x**3 - 592.D0/75.D
     &    0*z2*dx - 112.D0/3.D0*z2*dp - 887.D0/3.D0*z2*dm + 5000.D0/3.D0
     &    *z2*z3 - 1832.D0*z2*z3*x - 1952.D0*z2*z3*dp - 1856.D0/3.D0*z2
     &    *z3*dm - 244.D0/3.D0*Hr1(-1)*z4 + 4492.D0/3.D0*Hr1(-1)*z4*x
     &     + 1904.D0/3.D0*Hr1(-1)*dp*z4 - 15100.D0/3.D0*Hr1(-1)*z3 - 
     &    20300.D0/3.D0*Hr1(-1)*z3*x + 1152.D0*Hr1(-1)*z3*x**3 - 128.D0
     &    *Hr1(-1)*z3*dx**2 - 1096.D0*Hr1(-1)*z3*dp - 74732.D0/15.D0*
     &    Hr1(-1)*z2 )
      c2qq3 = c2qq3 + cf**3 * (  - 28044.D0/5.D0*Hr1(-1)*z2*x + 3408.D0/
     &    5.D0*Hr1(-1)*z2*x**2 + 28368.D0/25.D0*Hr1(-1)*z2*x**3 - 2336.D
     &    0/15.D0*Hr1(-1)*z2*dx - 2832.D0/25.D0*Hr1(-1)*z2*dx**2 - 224.D
     &    0/3.D0*Hr1(-1)*z2*dp + 38783.D0/180.D0*Hr1(0) + 482609.D0/300.
     &    D0*Hr1(0)*x - 22872.D0/25.D0*Hr1(0)*x**2 + 262.D0*Hr1(0)*z4
     &     + 2602.D0/3.D0*Hr1(0)*z4*x + 5944.D0/225.D0*Hr1(0)*dx + 964.D
     &    0/3.D0*Hr1(0)*dp + 1544.D0/3.D0*Hr1(0)*dp*z4 - 2407.D0/6.D0*
     &    Hr1(0)*dm - 1240.D0*Hr1(0)*dm*z4 - 3706.D0/3.D0*Hr1(0)*z3 + 
     &    9254.D0/3.D0*Hr1(0)*z3*x - 800.D0*Hr1(0)*z3*x**2 - 1968.D0/5.D
     &    0*Hr1(0)*z3*x**3 - 8.D0/3.D0*Hr1(0)*z3*dp + 1392.D0*Hr1(0)*z3
     &    *dm + 9526.D0/15.D0*Hr1(0)*z2 + 134714.D0/15.D0*Hr1(0)*z2*x
     &     + 6096.D0/5.D0*Hr1(0)*z2*x**2 - 37824.D0/25.D0*Hr1(0)*z2*
     &    x**3 + 3152.D0/15.D0*Hr1(0)*z2*dx + 148.D0*Hr1(0)*z2*dp - 
     &    1622.D0/3.D0*Hr1(0)*z2*dm - 94759.D0/300.D0*Hr1(1) + 114403.D0
     &    /100.D0*Hr1(1)*x - 12048.D0/25.D0*Hr1(1)*x**2 + 868.D0*Hr1(1)
     &    *z4 )
      c2qq3 = c2qq3 + cf**3 * (  - 164.D0*Hr1(1)*z4*x - 1552.D0/25.D0*
     &    Hr1(1)*dx - 187.D0/2.D0*Hr1(1)*dm - 1136.D0*Hr1(1)*dm*z4 - 
     &    5788.D0/3.D0*Hr1(1)*z3 + 2996.D0*Hr1(1)*z3*x - 800.D0*Hr1(1)*
     &    z3*x**2 + 3792.D0/5.D0*Hr1(1)*z3*x**3 + 1264.D0/15.D0*Hr1(1)*
     &    z3*dx**2 + 144.D0*Hr1(1)*z3*dm - 23582.D0/15.D0*Hr1(1)*z2 + 
     &    18362.D0/15.D0*Hr1(1)*z2*x + 3888.D0/5.D0*Hr1(1)*z2*x**2 - 
     &    9456.D0/25.D0*Hr1(1)*z2*x**3 + 32.D0/5.D0*Hr1(1)*z2*dx - 944.D
     &    0/25.D0*Hr1(1)*z2*dx**2 - 380.D0/3.D0*Hr1(1)*z2*dm - 3264.D0*
     &    Hr2(-1,-1)*z3 + 8160.D0*Hr2(-1,-1)*z3*x + 8160.D0*Hr2(-1,-1)*
     &    z3*dp + 17480.D0/3.D0*Hr2(-1,-1)*z2 + 23224.D0/3.D0*Hr2(-1,-1
     &    )*z2*x - 7008.D0/5.D0*Hr2(-1,-1)*z2*x**3 + 2336.D0/15.D0*Hr2(
     &    -1,-1)*z2*dx**2 + 1056.D0*Hr2(-1,-1)*z2*dp + 18148.D0/75.D0*
     &    Hr2(-1,0) + 187964.D0/225.D0*Hr2(-1,0)*x - 16992.D0/25.D0*
     &    Hr2(-1,0)*x**2 - 8088.D0/25.D0*Hr2(-1,0)*x**3 + 5984.D0/75.D0
     &    *Hr2(-1,0)*dx + 12008.D0/225.D0*Hr2(-1,0)*dx**2 + 64.D0*Hr2(
     &    -1,0)*dp )
      c2qq3 = c2qq3 + cf**3 * ( 2144.D0*Hr2(-1,0)*z3 - 4160.D0*Hr2(-1,0
     &    )*z3*x - 4960.D0*Hr2(-1,0)*z3*dp - 15760.D0/3.D0*Hr2(-1,0)*z2
     &     - 6256.D0*Hr2(-1,0)*z2*x + 1056.D0*Hr2(-1,0)*z2*x**3 - 352.D0
     &    /3.D0*Hr2(-1,0)*z2*dx**2 - 848.D0*Hr2(-1,0)*z2*dp + 3336.D0*
     &    Hr2(0,-1)*z3 - 8552.D0/3.D0*Hr2(0,-1)*z3*x - 17600.D0/3.D0*
     &    Hr2(0,-1)*z3*dp - 6592.D0/3.D0*Hr2(0,-1)*z3*dm - 1720.D0*Hr2(
     &    0,-1)*z2 - 11960.D0/3.D0*Hr2(0,-1)*z2*x + 7008.D0/5.D0*Hr2(0,
     &    -1)*z2*x**3 - 192.D0/5.D0*Hr2(0,-1)*z2*dx**2 - 592.D0*Hr2(0,
     &    -1)*z2*dp - 3256.D0/3.D0*Hr2(0,-1)*z2*dm - 26098.D0/75.D0*
     &    Hr2(0,0) - 143084.D0/225.D0*Hr2(0,0)*x - 11088.D0/25.D0*Hr2(0
     &    ,0)*x**2 + 8088.D0/25.D0*Hr2(0,0)*x**3 - 5344.D0/75.D0*Hr2(0,
     &    0)*dx + 440.D0/3.D0*Hr2(0,0)*dp + 337.D0/3.D0*Hr2(0,0)*dm - 
     &    4180.D0/3.D0*Hr2(0,0)*z3 + 2348.D0/3.D0*Hr2(0,0)*z3*x + 4576.D
     &    0/3.D0*Hr2(0,0)*z3*dp + 896.D0/3.D0*Hr2(0,0)*z3*dm - 1378.D0/
     &    3.D0*Hr2(0,0)*z2 + 4630.D0/3.D0*Hr2(0,0)*z2*x + 800.D0*Hr2(0,
     &    0)*z2*x**2 )
      c2qq3 = c2qq3 + cf**3 * (  - 9456.D0/5.D0*Hr2(0,0)*z2*x**3 - 856.D
     &    0/3.D0*Hr2(0,0)*z2*dp + 944.D0*Hr2(0,0)*z2*dm - 41048.D0/75.D0
     &    *Hr2(0,1) + 44822.D0/75.D0*Hr2(0,1)*x - 9168.D0/25.D0*Hr2(0,1
     &    )*x**2 + 2192.D0/25.D0*Hr2(0,1)*dx + 208.D0/3.D0*Hr2(0,1)*dp
     &     + 791.D0/3.D0*Hr2(0,1)*dm + 3088.D0/3.D0*Hr2(0,1)*z3 + 1472.D
     &    0*Hr2(0,1)*z3*x - 2464.D0/3.D0*Hr2(0,1)*z3*dp - 3712.D0/3.D0*
     &    Hr2(0,1)*z3*dm - 2960.D0/3.D0*Hr2(0,1)*z2 - 3776.D0/3.D0*Hr2(
     &    0,1)*z2*x - 288.D0/5.D0*Hr2(0,1)*z2*x**3 - 64.D0/5.D0*Hr2(0,1
     &    )*z2*dx**2 - 488.D0*Hr2(0,1)*z2*dp + 376.D0*Hr2(0,1)*z2*dm - 
     &    3566.D0/5.D0*Hr2(1,0) - 1222.D0/15.D0*Hr2(1,0)*x + 576.D0/5.D0
     &    *Hr2(1,0)*x**2 + 64.D0/5.D0*Hr2(1,0)*dx + 397.D0*Hr2(1,0)*dm
     &     + 1280.D0/3.D0*Hr2(1,0)*z3 + 7904.D0/3.D0*Hr2(1,0)*z3*x - 
     &    4384.D0/3.D0*Hr2(1,0)*z3*dm - 6176.D0/3.D0*Hr2(1,0)*z2 + 1184.
     &    D0/3.D0*Hr2(1,0)*z2*x + 800.D0*Hr2(1,0)*z2*x**2 - 4176.D0/5.D0
     &    *Hr2(1,0)*z2*x**3 - 464.D0/5.D0*Hr2(1,0)*z2*dx**2 + 704.D0*
     &    Hr2(1,0)*z2*dm )
      c2qq3 = c2qq3 + cf**3 * (  - 13148.D0/15.D0*Hr2(1,1) + 5318.D0/15.
     &    D0*Hr2(1,1)*x + 576.D0/5.D0*Hr2(1,1)*x**2 + 64.D0/5.D0*Hr2(1,
     &    1)*dx + 279.D0*Hr2(1,1)*dm + 1008.D0*Hr2(1,1)*z3 + 2064.D0*
     &    Hr2(1,1)*z3*x - 2112.D0*Hr2(1,1)*z3*dm - 2320.D0/3.D0*Hr2(1,1
     &    )*z2 + 1072.D0/3.D0*Hr2(1,1)*z2*x - 288.D0/5.D0*Hr2(1,1)*z2*
     &    x**3 - 32.D0/5.D0*Hr2(1,1)*z2*dx**2 + 432.D0*Hr2(1,1)*z2*dm
     &     + 3040.D0*Hr3(-1,-1,-1)*z2 - 8992.D0*Hr3(-1,-1,-1)*z2*x - 
     &    8064.D0*Hr3(-1,-1,-1)*z2*dp - 15288.D0/5.D0*Hr3(-1,-1,0) - 
     &    14104.D0/15.D0*Hr3(-1,-1,0)*x + 7776.D0/5.D0*Hr3(-1,-1,0)*
     &    x**2 + 18912.D0/25.D0*Hr3(-1,-1,0)*x**3 - 64.D0/5.D0*Hr3(-1,
     &    -1,0)*dx - 1888.D0/25.D0*Hr3(-1,-1,0)*dx**2 + 512.D0*Hr3(-1,
     &    -1,0)*dp - 4000.D0*Hr3(-1,-1,0)*z2 + 8608.D0*Hr3(-1,-1,0)*z2*
     &    x + 9536.D0*Hr3(-1,-1,0)*z2*dp - 2400.D0*Hr3(-1,0,-1)*z2 + 
     &    6048.D0*Hr3(-1,0,-1)*z2*x + 6016.D0*Hr3(-1,0,-1)*z2*dp + 
     &    12512.D0/3.D0*Hr3(-1,0,0) + 11752.D0/3.D0*Hr3(-1,0,0)*x - 960.
     &    D0*Hr3(-1,0,0)*x**2 )
      c2qq3 = c2qq3 + cf**3 * (  - 22752.D0/25.D0*Hr3(-1,0,0)*x**3 + 
     &    320.D0/3.D0*Hr3(-1,0,0)*dx + 6944.D0/75.D0*Hr3(-1,0,0)*dx**2
     &     - 1264.D0/3.D0*Hr3(-1,0,0)*dp + 1936.D0*Hr3(-1,0,0)*z2 - 
     &    4624.D0*Hr3(-1,0,0)*z2*x - 4768.D0*Hr3(-1,0,0)*z2*dp + 10360.D
     &    0/3.D0*Hr3(-1,0,1) + 15416.D0/3.D0*Hr3(-1,0,1)*x + 96.D0*Hr3(
     &    -1,0,1)*x**2 - 18912.D0/25.D0*Hr3(-1,0,1)*x**3 + 448.D0/3.D0*
     &    Hr3(-1,0,1)*dx + 1888.D0/25.D0*Hr3(-1,0,1)*dx**2 + 992.D0/3.D0
     &    *Hr3(-1,0,1)*dp - 560.D0/3.D0*Hr3(-1,0,1)*z2 + 1136.D0/3.D0*
     &    Hr3(-1,0,1)*z2*x + 1312.D0/3.D0*Hr3(-1,0,1)*z2*dp - 10240.D0/
     &    3.D0*Hr3(0,-1,-1)*z2 + 8512.D0/3.D0*Hr3(0,-1,-1)*z2*x + 6048.D
     &    0*Hr3(0,-1,-1)*z2*dp + 2592.D0*Hr3(0,-1,-1)*z2*dm + 8488.D0/
     &    15.D0*Hr3(0,-1,0) + 7456.D0/3.D0*Hr3(0,-1,0)*x - 7392.D0/5.D0
     &    *Hr3(0,-1,0)*x**2 - 18912.D0/25.D0*Hr3(0,-1,0)*x**3 + 64.D0/3.
     &    D0*Hr3(0,-1,0)*dx + 256.D0/15.D0*Hr3(0,-1,0)*dx**2 - 1360.D0/
     &    3.D0*Hr3(0,-1,0)*dp - 296.D0/3.D0*Hr3(0,-1,0)*dm + 3584.D0*
     &    Hr3(0,-1,0)*z2 )
      c2qq3 = c2qq3 + cf**3 * (  - 8992.D0/3.D0*Hr3(0,-1,0)*z2*x - 
     &    18944.D0/3.D0*Hr3(0,-1,0)*z2*dp - 5792.D0/3.D0*Hr3(0,-1,0)*z2
     &    *dm + 8528.D0/3.D0*Hr3(0,0,-1)*z2 - 976.D0*Hr3(0,0,-1)*z2*x
     &     - 11200.D0/3.D0*Hr3(0,0,-1)*z2*dp - 5504.D0/3.D0*Hr3(0,0,-1)
     &    *z2*dm - 2024.D0/5.D0*Hr3(0,0,0) - 71278.D0/15.D0*Hr3(0,0,0)*
     &    x + 1728.D0/5.D0*Hr3(0,0,0)*x**2 + 22752.D0/25.D0*Hr3(0,0,0)*
     &    x**3 - 704.D0/15.D0*Hr3(0,0,0)*dx + 956.D0/3.D0*Hr3(0,0,0)*dp
     &     + 406.D0/3.D0*Hr3(0,0,0)*dm - 980.D0*Hr3(0,0,0)*z2 + 1300.D0/
     &    3.D0*Hr3(0,0,0)*z2*x + 3616.D0/3.D0*Hr3(0,0,0)*z2*dp + 896.D0/
     &    3.D0*Hr3(0,0,0)*z2*dm - 9526.D0/15.D0*Hr3(0,0,1) - 32478.D0/5.
     &    D0*Hr3(0,0,1)*x - 6096.D0/5.D0*Hr3(0,0,1)*x**2 + 18912.D0/25.D
     &    0*Hr3(0,0,1)*x**3 - 944.D0/5.D0*Hr3(0,0,1)*dx - 976.D0/3.D0*
     &    Hr3(0,0,1)*dp + 718.D0*Hr3(0,0,1)*dm + 144.D0*Hr3(0,0,1)*z2
     &     - 528.D0*Hr3(0,0,1)*z2*x - 2624.D0/3.D0*Hr3(0,0,1)*z2*dp + 
     &    736.D0/3.D0*Hr3(0,0,1)*z2*dm - 8854.D0/15.D0*Hr3(0,1,0) - 
     &    18454.D0/15.D0*Hr3(0,1,0)*x )
      c2qq3 = c2qq3 + cf**3 * ( 576.D0/5.D0*Hr3(0,1,0)*x**2 - 64.D0/5.D0
     &    *Hr3(0,1,0)*dx - 64.D0*Hr3(0,1,0)*dp + 740.D0*Hr3(0,1,0)*dm
     &     - 184.D0*Hr3(0,1,0)*z2 + 440.D0/3.D0*Hr3(0,1,0)*z2*x - 1696.D
     &    0/3.D0*Hr3(0,1,0)*z2*dp + 352.D0/3.D0*Hr3(0,1,0)*z2*dm - 7594.
     &    D0/15.D0*Hr3(0,1,1) - 23714.D0/15.D0*Hr3(0,1,1)*x + 576.D0/5.D
     &    0*Hr3(0,1,1)*x**2 - 64.D0/5.D0*Hr3(0,1,1)*dx - 64.D0*Hr3(0,1,
     &    1)*dp + 1504.D0/3.D0*Hr3(0,1,1)*dm - 160.D0*Hr3(0,1,1)*z2 - 
     &    32.D0/3.D0*Hr3(0,1,1)*z2*x - 1376.D0/3.D0*Hr3(0,1,1)*z2*dp + 
     &    1280.D0/3.D0*Hr3(0,1,1)*z2*dm - 16.D0/3.D0*Hr3(1,0,-1)*z2 - 
     &    4048.D0/3.D0*Hr3(1,0,-1)*z2*x + 1376.D0/3.D0*Hr3(1,0,-1)*z2*
     &    dm - 9094.D0/15.D0*Hr3(1,0,0) + 8654.D0/15.D0*Hr3(1,0,0)*x + 
     &    3696.D0/5.D0*Hr3(1,0,0)*x**2 + 1232.D0/15.D0*Hr3(1,0,0)*dx + 
     &    370.D0*Hr3(1,0,0)*dm - 240.D0*Hr3(1,0,0)*z2 + 2256.D0*Hr3(1,0
     &    ,0)*z2*x - 480.D0*Hr3(1,0,0)*z2*dm + 130.D0/3.D0*Hr3(1,0,1)
     &     - 754.D0*Hr3(1,0,1)*x + 1148.D0/3.D0*Hr3(1,0,1)*dm - 288.D0*
     &    Hr3(1,0,1)*z2 )
      c2qq3 = c2qq3 + cf**3 * ( 288.D0*Hr3(1,0,1)*z2*x + 384.D0*Hr3(1,0
     &    ,1)*z2*dm - 134.D0/3.D0*Hr3(1,1,0) - 2390.D0/3.D0*Hr3(1,1,0)*
     &    x + 496.D0*Hr3(1,1,0)*dm - 1312.D0/3.D0*Hr3(1,1,0)*z2 + 4448.D
     &    0/3.D0*Hr3(1,1,0)*z2*x - 64.D0/3.D0*Hr3(1,1,0)*z2*dm + 126.D0
     &    *Hr3(1,1,1) - 642.D0*Hr3(1,1,1)*x + 216.D0*Hr3(1,1,1)*dm - 
     &    288.D0*Hr3(1,1,1)*z2 + 288.D0*Hr3(1,1,1)*z2*x + 384.D0*Hr3(1,
     &    1,1)*z2*dm + 2384.D0/3.D0*Hr4(-1,-1,-1,0) + 6256.D0/3.D0*Hr4(
     &    -1,-1,-1,0)*x - 576.D0/5.D0*Hr4(-1,-1,-1,0)*x**3 + 64.D0/5.D0
     &    *Hr4(-1,-1,-1,0)*dx**2 + 576.D0*Hr4(-1,-1,-1,0)*dp - 13496.D0/
     &    3.D0*Hr4(-1,-1,0,0) - 5160.D0*Hr4(-1,-1,0,0)*x + 960.D0*Hr4(
     &    -1,-1,0,0)*x**3 - 320.D0/3.D0*Hr4(-1,-1,0,0)*dx**2 - 480.D0*
     &    Hr4(-1,-1,0,0)*dp - 16288.D0/3.D0*Hr4(-1,-1,0,1) - 20096.D0/3.
     &    D0*Hr4(-1,-1,0,1)*x + 1344.D0*Hr4(-1,-1,0,1)*x**3 - 448.D0/3.D
     &    0*Hr4(-1,-1,0,1)*dx**2 - 768.D0*Hr4(-1,-1,0,1)*dp - 2288.D0/3.
     &    D0*Hr4(-1,0,-1,0) - 3632.D0/3.D0*Hr4(-1,0,-1,0)*x + 576.D0/5.D
     &    0*Hr4(-1,0,-1,0)*x**3 )
      c2qq3 = c2qq3 + cf**3 * (  - 64.D0/5.D0*Hr4(-1,0,-1,0)*dx**2 - 
     &    240.D0*Hr4(-1,0,-1,0)*dp + 8552.D0/3.D0*Hr4(-1,0,0,0) + 7960.D
     &    0/3.D0*Hr4(-1,0,0,0)*x - 384.D0*Hr4(-1,0,0,0)*x**3 + 128.D0/3.
     &    D0*Hr4(-1,0,0,0)*dx**2 - 72.D0*Hr4(-1,0,0,0)*dp + 4272.D0*
     &    Hr4(-1,0,0,1) + 15008.D0/3.D0*Hr4(-1,0,0,1)*x - 960.D0*Hr4(-1
     &    ,0,0,1)*x**3 + 320.D0/3.D0*Hr4(-1,0,0,1)*dx**2 + 800.D0*Hr4(
     &    -1,0,0,1)*dp + 1952.D0/3.D0*Hr4(-1,0,1,0) + 2720.D0/3.D0*Hr4(
     &    -1,0,1,0)*x - 576.D0/5.D0*Hr4(-1,0,1,0)*x**3 + 64.D0/5.D0*
     &    Hr4(-1,0,1,0)*dx**2 + 384.D0*Hr4(-1,0,1,0)*dp + 800.D0*Hr4(-1
     &    ,0,1,1) + 1184.D0*Hr4(-1,0,1,1)*x - 576.D0/5.D0*Hr4(-1,0,1,1)
     &    *x**3 + 64.D0/5.D0*Hr4(-1,0,1,1)*dx**2 + 512.D0*Hr4(-1,0,1,1)
     &    *dp - 3248.D0/3.D0*Hr4(0,-1,-1,0) + 720.D0*Hr4(0,-1,-1,0)*x
     &     + 576.D0/5.D0*Hr4(0,-1,-1,0)*x**3 - 128.D0/5.D0*Hr4(0,-1,-1,
     &    0)*dx**2 - 224.D0*Hr4(0,-1,-1,0)*dp - 1008.D0*Hr4(0,-1,-1,0)*
     &    dm + 1872.D0*Hr4(0,-1,0,0) + 2544.D0*Hr4(0,-1,0,0)*x - 960.D0
     &    *Hr4(0,-1,0,0)*x**3 )
      c2qq3 = c2qq3 + cf**3 * ( 128.D0/5.D0*Hr4(0,-1,0,0)*dx**2 + 32.D0
     &    *Hr4(0,-1,0,0)*dp + 1616.D0/3.D0*Hr4(0,-1,0,0)*dm + 3536.D0/3.
     &    D0*Hr4(0,-1,0,1) + 13040.D0/3.D0*Hr4(0,-1,0,1)*x - 1344.D0*
     &    Hr4(0,-1,0,1)*x**3 + 128.D0/5.D0*Hr4(0,-1,0,1)*dx**2 + 480.D0
     &    *Hr4(0,-1,0,1)*dp + 1744.D0/3.D0*Hr4(0,-1,0,1)*dm + 320.D0/3.D
     &    0*Hr4(0,0,-1,0) + 480.D0*Hr4(0,0,-1,0)*x - 192.D0*Hr4(0,0,-1,
     &    0)*x**3 - 224.D0/3.D0*Hr4(0,0,-1,0)*dp + 288.D0*Hr4(0,0,-1,0)
     &    *dm - 10.D0*Hr4(0,0,0,0) - 3230.D0/3.D0*Hr4(0,0,0,0)*x + 2112.
     &    D0/5.D0*Hr4(0,0,0,0)*x**3 + 1192.D0/3.D0*Hr4(0,0,0,0)*dp - 
     &    760.D0/3.D0*Hr4(0,0,0,0)*dm + 1378.D0/3.D0*Hr4(0,0,0,1) - 
     &    3190.D0/3.D0*Hr4(0,0,0,1)*x - 800.D0*Hr4(0,0,0,1)*x**2 + 8496.
     &    D0/5.D0*Hr4(0,0,0,1)*x**3 + 104.D0*Hr4(0,0,0,1)*dp - 2288.D0/
     &    3.D0*Hr4(0,0,0,1)*dm + 300.D0*Hr4(0,0,1,0) + 92.D0*Hr4(0,0,1,
     &    0)*x + 576.D0/5.D0*Hr4(0,0,1,0)*x**3 - 168.D0*Hr4(0,0,1,0)*dp
     &     - 240.D0*Hr4(0,0,1,0)*dm + 1288.D0/3.D0*Hr4(0,0,1,1) + 584.D0
     &    /3.D0*Hr4(0,0,1,1)*x )
      c2qq3 = c2qq3 + cf**3 * ( 576.D0/5.D0*Hr4(0,0,1,1)*x**3 - 256.D0*
     &    Hr4(0,0,1,1)*dp - 512.D0*Hr4(0,0,1,1)*dm + 148.D0/3.D0*Hr4(0,
     &    1,0,0) - 844.D0/3.D0*Hr4(0,1,0,0)*x + 800.D0*Hr4(0,1,0,0)*
     &    x**2 - 3696.D0/5.D0*Hr4(0,1,0,0)*x**3 + 56.D0*Hr4(0,1,0,0)*dm
     &     + 1336.D0/3.D0*Hr4(0,1,0,1) + 2696.D0/3.D0*Hr4(0,1,0,1)*x - 
     &    16.D0*Hr4(0,1,0,1)*dp - 488.D0*Hr4(0,1,0,1)*dm + 1576.D0/3.D0
     &    *Hr4(0,1,1,0) + 2872.D0/3.D0*Hr4(0,1,1,0)*x + 16.D0*Hr4(0,1,1
     &    ,0)*dp - 600.D0*Hr4(0,1,1,0)*dm + 504.D0*Hr4(0,1,1,1) + 936.D0
     &    *Hr4(0,1,1,1)*x - 648.D0*Hr4(0,1,1,1)*dm - 1200.D0*Hr4(1,0,-1
     &    ,0) + 1296.D0*Hr4(1,0,-1,0)*x - 384.D0/5.D0*Hr4(1,0,-1,0)*
     &    x**3 - 128.D0/15.D0*Hr4(1,0,-1,0)*dx**2 + 144.D0*Hr4(1,0,-1,0
     &    )*dm + 3248.D0/3.D0*Hr4(1,0,0,0) - 2752.D0/3.D0*Hr4(1,0,0,0)*
     &    x + 192.D0/5.D0*Hr4(1,0,0,0)*x**3 + 64.D0/15.D0*Hr4(1,0,0,0)*
     &    dx**2 - 144.D0*Hr4(1,0,0,0)*dm + 3232.D0/3.D0*Hr4(1,0,0,1) + 
     &    2576.D0/3.D0*Hr4(1,0,0,1)*x - 800.D0*Hr4(1,0,0,1)*x**2 + 3696.
     &    D0/5.D0*Hr4(1,0,0,1)*x**3 )
      c2qq3 = c2qq3 + cf**3 * ( 1232.D0/15.D0*Hr4(1,0,0,1)*dx**2 - 752.D
     &    0*Hr4(1,0,0,1)*dm + 992.D0/3.D0*Hr4(1,0,1,0) + 1952.D0/3.D0*
     &    Hr4(1,0,1,0)*x - 640.D0*Hr4(1,0,1,0)*dm + 1184.D0/3.D0*Hr4(1,
     &    0,1,1) + 1904.D0/3.D0*Hr4(1,0,1,1)*x - 648.D0*Hr4(1,0,1,1)*dm
     &     - 680.D0/3.D0*Hr4(1,1,0,0) - 632.D0*Hr4(1,1,0,0)*x + 800.D0*
     &    Hr4(1,1,0,0)*x**2 - 3696.D0/5.D0*Hr4(1,1,0,0)*x**3 - 1232.D0/
     &    15.D0*Hr4(1,1,0,0)*dx**2 - 24.D0*Hr4(1,1,0,0)*dm + 376.D0*
     &    Hr4(1,1,0,1) + 2056.D0/3.D0*Hr4(1,1,0,1)*x - 720.D0*Hr4(1,1,0
     &    ,1)*dm + 1432.D0/3.D0*Hr4(1,1,1,0) + 840.D0*Hr4(1,1,1,0)*x - 
     &    864.D0*Hr4(1,1,1,0)*dm + 384.D0*Hr4(1,1,1,1) + 672.D0*Hr4(1,1
     &    ,1,1)*x - 720.D0*Hr4(1,1,1,1)*dm + 576.D0*Hr5(-1,-1,-1,-1,0)
     &     - 1728.D0*Hr5(-1,-1,-1,-1,0)*x - 1536.D0*Hr5(-1,-1,-1,-1,0)*
     &    dp - 2624.D0*Hr5(-1,-1,-1,0,0) + 7424.D0*Hr5(-1,-1,-1,0,0)*x
     &     + 6848.D0*Hr5(-1,-1,-1,0,0)*dp - 2752.D0*Hr5(-1,-1,-1,0,1)
     &     + 8128.D0*Hr5(-1,-1,-1,0,1)*x + 7296.D0*Hr5(-1,-1,-1,0,1)*dp
     &     - 544.D0*Hr5(-1,-1,0,-1,0) )
      c2qq3 = c2qq3 + cf**3 * ( 1696.D0*Hr5(-1,-1,0,-1,0)*x + 1472.D0*
     &    Hr5(-1,-1,0,-1,0)*dp + 7568.D0/3.D0*Hr5(-1,-1,0,0,0) - 14480.D
     &    0/3.D0*Hr5(-1,-1,0,0,0)*x - 17440.D0/3.D0*Hr5(-1,-1,0,0,0)*dp
     &     + 10624.D0/3.D0*Hr5(-1,-1,0,0,1) - 21568.D0/3.D0*Hr5(-1,-1,0
     &    ,0,1)*x - 24896.D0/3.D0*Hr5(-1,-1,0,0,1)*dp + 3776.D0/3.D0*
     &    Hr5(-1,-1,0,1,0) - 4928.D0/3.D0*Hr5(-1,-1,0,1,0)*x - 7936.D0/
     &    3.D0*Hr5(-1,-1,0,1,0)*dp + 1600.D0*Hr5(-1,-1,0,1,1) - 1984.D0
     &    *Hr5(-1,-1,0,1,1)*x - 3328.D0*Hr5(-1,-1,0,1,1)*dp - 576.D0*
     &    Hr5(-1,0,-1,-1,0) + 1728.D0*Hr5(-1,0,-1,-1,0)*x + 1536.D0*
     &    Hr5(-1,0,-1,-1,0)*dp + 6080.D0/3.D0*Hr5(-1,0,-1,0,0) - 14720.D
     &    0/3.D0*Hr5(-1,0,-1,0,0)*x - 15040.D0/3.D0*Hr5(-1,0,-1,0,0)*dp
     &     + 2112.D0*Hr5(-1,0,-1,0,1) - 5184.D0*Hr5(-1,0,-1,0,1)*x - 
     &    5248.D0*Hr5(-1,0,-1,0,1)*dp + 2144.D0/3.D0*Hr5(-1,0,0,-1,0)
     &     - 5024.D0/3.D0*Hr5(-1,0,0,-1,0)*x - 5248.D0/3.D0*Hr5(-1,0,0,
     &    -1,0)*dp - 1104.D0*Hr5(-1,0,0,0,0) + 2064.D0*Hr5(-1,0,0,0,0)*
     &    x )
      c2qq3 = c2qq3 + cf**3 * ( 2528.D0*Hr5(-1,0,0,0,0)*dp - 1744.D0*
     &    Hr5(-1,0,0,0,1) + 3856.D0*Hr5(-1,0,0,0,1)*x + 4192.D0*Hr5(-1,
     &    0,0,0,1)*dp - 2704.D0/3.D0*Hr5(-1,0,0,1,0) + 3280.D0/3.D0*
     &    Hr5(-1,0,0,1,0)*x + 5600.D0/3.D0*Hr5(-1,0,0,1,0)*dp - 3520.D0/
     &    3.D0*Hr5(-1,0,0,1,1) + 4096.D0/3.D0*Hr5(-1,0,0,1,1)*x + 7232.D
     &    0/3.D0*Hr5(-1,0,0,1,1)*dp - 1408.D0/3.D0*Hr5(-1,0,1,0,0) + 
     &    256.D0/3.D0*Hr5(-1,0,1,0,0)*x + 2432.D0/3.D0*Hr5(-1,0,1,0,0)*
     &    dp - 288.D0*Hr5(-1,0,1,0,1) + 288.D0*Hr5(-1,0,1,0,1)*x + 576.D
     &    0*Hr5(-1,0,1,0,1)*dp - 544.D0/3.D0*Hr5(-1,0,1,1,0) + 544.D0/3.
     &    D0*Hr5(-1,0,1,1,0)*x + 1088.D0/3.D0*Hr5(-1,0,1,1,0)*dp - 192.D
     &    0*Hr5(-1,0,1,1,1) + 192.D0*Hr5(-1,0,1,1,1)*x + 384.D0*Hr5(-1,
     &    0,1,1,1)*dp - 3328.D0/3.D0*Hr5(0,-1,-1,-1,0) + 4352.D0/3.D0*
     &    Hr5(0,-1,-1,-1,0)*x + 1600.D0*Hr5(0,-1,-1,-1,0)*dp + 2624.D0/
     &    3.D0*Hr5(0,-1,-1,-1,0)*dm + 9440.D0/3.D0*Hr5(0,-1,-1,0,0) - 
     &    8192.D0/3.D0*Hr5(0,-1,-1,0,0)*x - 5024.D0*Hr5(0,-1,-1,0,0)*dp
     &     - 2240.D0*Hr5(0,-1,-1,0,0)*dm )
      c2qq3 = c2qq3 + cf**3 * ( 8576.D0/3.D0*Hr5(0,-1,-1,0,1) - 2112.D0
     &    *Hr5(0,-1,-1,0,1)*x - 5248.D0*Hr5(0,-1,-1,0,1)*dp - 6464.D0/3.
     &    D0*Hr5(0,-1,-1,0,1)*dm + 928.D0*Hr5(0,-1,0,-1,0) - 1056.D0*
     &    Hr5(0,-1,0,-1,0)*x - 1280.D0*Hr5(0,-1,0,-1,0)*dp - 704.D0*
     &    Hr5(0,-1,0,-1,0)*dm - 2384.D0*Hr5(0,-1,0,0,0) + 2128.D0*Hr5(0
     &    ,-1,0,0,0)*x + 3712.D0*Hr5(0,-1,0,0,0)*dp + 1088.D0*Hr5(0,-1,
     &    0,0,0)*dm - 9056.D0/3.D0*Hr5(0,-1,0,0,1) + 6976.D0/3.D0*Hr5(0
     &    ,-1,0,0,1)*x + 16096.D0/3.D0*Hr5(0,-1,0,0,1)*dp + 4672.D0/3.D0
     &    *Hr5(0,-1,0,0,1)*dm - 2560.D0/3.D0*Hr5(0,-1,0,1,0) + 2176.D0/
     &    3.D0*Hr5(0,-1,0,1,0)*x + 1536.D0*Hr5(0,-1,0,1,0)*dp + 192.D0*
     &    Hr5(0,-1,0,1,0)*dm - 3200.D0/3.D0*Hr5(0,-1,0,1,1) + 2816.D0/3.
     &    D0*Hr5(0,-1,0,1,1)*x + 5824.D0/3.D0*Hr5(0,-1,0,1,1)*dp + 192.D
     &    0*Hr5(0,-1,0,1,1)*dm + 1952.D0*Hr5(0,0,-1,-1,0) - 96.D0*Hr5(0
     &    ,0,-1,-1,0)*x - 4736.D0/3.D0*Hr5(0,0,-1,-1,0)*dp - 2304.D0*
     &    Hr5(0,0,-1,-1,0)*dm - 8192.D0/3.D0*Hr5(0,0,-1,0,0) + 736.D0*
     &    Hr5(0,0,-1,0,0)*x )
      c2qq3 = c2qq3 + cf**3 * ( 8960.D0/3.D0*Hr5(0,0,-1,0,0)*dp + 1920.D
     &    0*Hr5(0,0,-1,0,0)*dm - 5600.D0/3.D0*Hr5(0,0,-1,0,1) + 928.D0*
     &    Hr5(0,0,-1,0,1)*x + 2944.D0*Hr5(0,0,-1,0,1)*dp + 2048.D0/3.D0
     &    *Hr5(0,0,-1,0,1)*dm - 3968.D0/3.D0*Hr5(0,0,0,-1,0) + 128.D0*
     &    Hr5(0,0,0,-1,0)*x + 1024.D0*Hr5(0,0,0,-1,0)*dp + 2560.D0/3.D0
     &    *Hr5(0,0,0,-1,0)*dm + 420.D0*Hr5(0,0,0,0,0) - 396.D0*Hr5(0,0,
     &    0,0,0)*x - 544.D0*Hr5(0,0,0,0,0)*dp + 64.D0*Hr5(0,0,0,0,0)*dm
     &     + 980.D0*Hr5(0,0,0,0,1) - 916.D0/3.D0*Hr5(0,0,0,0,1)*x - 
     &    1120.D0*Hr5(0,0,0,0,1)*dp - 384.D0*Hr5(0,0,0,0,1)*dm + 896.D0
     &    *Hr5(0,0,0,1,0) + 544.D0/3.D0*Hr5(0,0,0,1,0)*x - 1952.D0/3.D0
     &    *Hr5(0,0,0,1,0)*dp - 704.D0*Hr5(0,0,0,1,0)*dm + 1144.D0*Hr5(0
     &    ,0,0,1,1) + 216.D0*Hr5(0,0,0,1,1)*x - 864.D0*Hr5(0,0,0,1,1)*
     &    dp - 2912.D0/3.D0*Hr5(0,0,0,1,1)*dm + 1600.D0/3.D0*Hr5(0,0,1,
     &    0,0) + 352.D0/3.D0*Hr5(0,0,1,0,0)*x - 1024.D0/3.D0*Hr5(0,0,1,
     &    0,0)*dp - 1120.D0/3.D0*Hr5(0,0,1,0,0)*dm + 832.D0*Hr5(0,0,1,0
     &    ,1) )
      c2qq3 = c2qq3 + cf**3 * ( 576.D0*Hr5(0,0,1,0,1)*x - 832.D0/3.D0*
     &    Hr5(0,0,1,0,1)*dp - 3104.D0/3.D0*Hr5(0,0,1,0,1)*dm + 2768.D0/
     &    3.D0*Hr5(0,0,1,1,0) + 2128.D0/3.D0*Hr5(0,0,1,1,0)*x - 192.D0*
     &    Hr5(0,0,1,1,0)*dp - 1184.D0*Hr5(0,0,1,1,0)*dm + 880.D0*Hr5(0,
     &    0,1,1,1) + 688.D0*Hr5(0,0,1,1,1)*x - 192.D0*Hr5(0,0,1,1,1)*dp
     &     - 1184.D0*Hr5(0,0,1,1,1)*dm + 608.D0/3.D0*Hr5(0,1,0,-1,0) + 
     &    288.D0*Hr5(0,1,0,-1,0)*x - 128.D0/3.D0*Hr5(0,1,0,-1,0)*dp - 
     &    1856.D0/3.D0*Hr5(0,1,0,-1,0)*dm - 72.D0*Hr5(0,1,0,0,0) - 584.D
     &    0*Hr5(0,1,0,0,0)*x + 128.D0*Hr5(0,1,0,0,0)*dp + 448.D0*Hr5(0,
     &    1,0,0,0)*dm + 2248.D0/3.D0*Hr5(0,1,0,0,1) + 1576.D0/3.D0*Hr5(
     &    0,1,0,0,1)*x + 192.D0*Hr5(0,1,0,0,1)*dp - 3200.D0/3.D0*Hr5(0,
     &    1,0,0,1)*dm + 736.D0*Hr5(0,1,0,1,0) + 2080.D0/3.D0*Hr5(0,1,0,
     &    1,0)*x - 128.D0/3.D0*Hr5(0,1,0,1,0)*dp - 3488.D0/3.D0*Hr5(0,1
     &    ,0,1,0)*dm + 2048.D0/3.D0*Hr5(0,1,0,1,1) + 2048.D0/3.D0*Hr5(0
     &    ,1,0,1,1)*x - 3520.D0/3.D0*Hr5(0,1,0,1,1)*dm + 712.D0/3.D0*
     &    Hr5(0,1,1,0,0) )
      c2qq3 = c2qq3 + cf**3 * ( 616.D0/3.D0*Hr5(0,1,1,0,0)*x + 128.D0*
     &    Hr5(0,1,1,0,0)*dp - 1888.D0/3.D0*Hr5(0,1,1,0,0)*dm + 2144.D0/
     &    3.D0*Hr5(0,1,1,0,1) + 736.D0*Hr5(0,1,1,0,1)*x + 64.D0/3.D0*
     &    Hr5(0,1,1,0,1)*dp - 3680.D0/3.D0*Hr5(0,1,1,0,1)*dm + 2576.D0/
     &    3.D0*Hr5(0,1,1,1,0) + 2512.D0/3.D0*Hr5(0,1,1,1,0)*x - 64.D0/3.
     &    D0*Hr5(0,1,1,1,0)*dp - 1440.D0*Hr5(0,1,1,1,0)*dm + 672.D0*
     &    Hr5(0,1,1,1,1) + 672.D0*Hr5(0,1,1,1,1)*x - 1152.D0*Hr5(0,1,1,
     &    1,1)*dm + 2848.D0/3.D0*Hr5(1,0,-1,-1,0) + 4000.D0/3.D0*Hr5(1,
     &    0,-1,-1,0)*x - 6080.D0/3.D0*Hr5(1,0,-1,-1,0)*dm - 896.D0/3.D0
     &    *Hr5(1,0,-1,0,0) + 832.D0/3.D0*Hr5(1,0,-1,0,0)*x + 1216.D0/3.D
     &    0*Hr5(1,0,-1,0,0)*dm + 480.D0*Hr5(1,0,-1,0,1) + 2016.D0*Hr5(1
     &    ,0,-1,0,1)*x - 1472.D0*Hr5(1,0,-1,0,1)*dm - 992.D0/3.D0*Hr5(1
     &    ,0,0,-1,0) - 416.D0/3.D0*Hr5(1,0,0,-1,0)*x + 1792.D0/3.D0*
     &    Hr5(1,0,0,-1,0)*dm - 112.D0*Hr5(1,0,0,0,0) - 1072.D0*Hr5(1,0,
     &    0,0,0)*x + 544.D0*Hr5(1,0,0,0,0)*dm + 432.D0*Hr5(1,0,0,0,1)
     &     - 1488.D0*Hr5(1,0,0,0,1)*x )
      c2qq3 = c2qq3 + cf**3 * (  - 96.D0*Hr5(1,0,0,0,1)*dm + 1744.D0/3.D
     &    0*Hr5(1,0,0,1,0) + 1168.D0/3.D0*Hr5(1,0,0,1,0)*x - 3296.D0/3.D
     &    0*Hr5(1,0,0,1,0)*dm + 1792.D0/3.D0*Hr5(1,0,0,1,1) + 1216.D0/3.
     &    D0*Hr5(1,0,0,1,1)*x - 3392.D0/3.D0*Hr5(1,0,0,1,1)*dm + 560.D0/
     &    3.D0*Hr5(1,0,1,0,0) + 1136.D0/3.D0*Hr5(1,0,1,0,0)*x - 1696.D0/
     &    3.D0*Hr5(1,0,1,0,0)*dm + 576.D0*Hr5(1,0,1,0,1) + 576.D0*Hr5(1
     &    ,0,1,0,1)*x - 1152.D0*Hr5(1,0,1,0,1)*dm + 1984.D0/3.D0*Hr5(1,
     &    0,1,1,0) + 1984.D0/3.D0*Hr5(1,0,1,1,0)*x - 3968.D0/3.D0*Hr5(1
     &    ,0,1,1,0)*dm + 528.D0*Hr5(1,0,1,1,1) + 528.D0*Hr5(1,0,1,1,1)*
     &    x - 1056.D0*Hr5(1,0,1,1,1)*dm + 1120.D0/3.D0*Hr5(1,1,0,-1,0)
     &     + 3424.D0/3.D0*Hr5(1,1,0,-1,0)*x - 3008.D0/3.D0*Hr5(1,1,0,-1
     &    ,0)*dm - 608.D0/3.D0*Hr5(1,1,0,0,0) - 4064.D0/3.D0*Hr5(1,1,0,
     &    0,0)*x + 2368.D0/3.D0*Hr5(1,1,0,0,0)*dm + 896.D0*Hr5(1,1,0,0,
     &    1) - 64.D0*Hr5(1,1,0,0,1)*x - 1216.D0*Hr5(1,1,0,0,1)*dm + 672.
     &    D0*Hr5(1,1,0,1,0) + 672.D0*Hr5(1,1,0,1,0)*x - 1344.D0*Hr5(1,1
     &    ,0,1,0)*dm )
      c2qq3 = c2qq3 + cf**3 * ( 528.D0*Hr5(1,1,0,1,1) + 528.D0*Hr5(1,1,
     &    0,1,1)*x - 1056.D0*Hr5(1,1,0,1,1)*dm + 144.D0*Hr5(1,1,1,0,0)
     &     + 720.D0*Hr5(1,1,1,0,0)*x - 736.D0*Hr5(1,1,1,0,0)*dm + 576.D0
     &    *Hr5(1,1,1,0,1) + 576.D0*Hr5(1,1,1,0,1)*x - 1152.D0*Hr5(1,1,1
     &    ,0,1)*dm + 672.D0*Hr5(1,1,1,1,0) + 672.D0*Hr5(1,1,1,1,0)*x - 
     &    1344.D0*Hr5(1,1,1,1,0)*dm + 480.D0*Hr5(1,1,1,1,1) + 480.D0*
     &    Hr5(1,1,1,1,1)*x - 960.D0*Hr5(1,1,1,1,1)*dm )
      c2qq3 = c2qq3 + nf*cf*ca * ( 1585417.D0/18225.D0 - 15559367.D0/
     &    18225.D0*x + 1752.D0/25.D0*x**2 - 88.D0/3.D0*z4 + 76.D0/3.D0*
     &    z4*x - 64.D0*z4*x**2 + 96.D0*z4*x**3 + 1432.D0/225.D0*dx + 
     &    152.D0/3.D0*dp*z4 + 160906.D0/729.D0*dm + 112.D0/3.D0*dm*z4
     &     - 1088.D0/27.D0*z3 + 5284.D0/27.D0*z3*x - 80.D0*z3*x**2 + 96.
     &    D0*z3*x**3 - 16.D0/3.D0*z3*dx + 160.D0/3.D0*z3*dp + 988.D0/27.
     &    D0*z3*dm + 13456.D0/135.D0*z2 + 216556.D0/405.D0*z2*x + 384.D0
     &    /5.D0*z2*x**2 - 1272.D0/25.D0*z2*x**3 - 16.D0/15.D0*z2*dx + 
     &    1328.D0/81.D0*z2*dp - 23156.D0/81.D0*z2*dm + 32.D0/9.D0*Hr1(
     &    -1)*z3 - 608.D0/9.D0*Hr1(-1)*z3*x - 256.D0/9.D0*Hr1(-1)*z3*dp
     &     - 1888.D0/27.D0*Hr1(-1)*z2 - 3872.D0/27.D0*Hr1(-1)*z2*x + 32.
     &    D0*Hr1(-1)*z2*x**2 + 144.D0/5.D0*Hr1(-1)*z2*x**3 - 16.D0/5.D0
     &    *Hr1(-1)*z2*dx**2 - 1600.D0/27.D0*Hr1(-1)*z2*dp - 408806.D0/
     &    2025.D0*Hr1(0) - 640222.D0/675.D0*Hr1(0)*x - 168.D0/25.D0*
     &    Hr1(0)*x**2 - 472.D0/225.D0*Hr1(0)*dx - 232.D0/9.D0*Hr1(0)*dp
     &     + 39818.D0/81.D0*Hr1(0)*dm )
      c2qq3 = c2qq3 + nf*cf*ca * (  - 128.D0/3.D0*Hr1(0)*z3 + 440.D0/9.D
     &    0*Hr1(0)*z3*x - 32.D0*Hr1(0)*z3*x**2 + 48.D0*Hr1(0)*z3*x**3
     &     + 176.D0/9.D0*Hr1(0)*z3*dp + 592.D0/9.D0*Hr1(0)*z3*dm + 316.D
     &    0/9.D0*Hr1(0)*z2 + 1984.D0/27.D0*Hr1(0)*z2*x - 16.D0*Hr1(0)*
     &    z2*x**2 - 432.D0/5.D0*Hr1(0)*z2*x**3 + 16.D0/3.D0*Hr1(0)*z2*
     &    dx + 184.D0/27.D0*Hr1(0)*z2*dp - 3124.D0/27.D0*Hr1(0)*z2*dm
     &     + 26734.D0/405.D0*Hr1(1) - 208814.D0/405.D0*Hr1(1)*x - 384.D0
     &    /5.D0*Hr1(1)*x**2 - 16.D0/5.D0*Hr1(1)*dx + 15062.D0/81.D0*
     &    Hr1(1)*dm - 104.D0/9.D0*Hr1(1)*z3 + 424.D0/9.D0*Hr1(1)*z3*x
     &     - 32.D0*Hr1(1)*z3*x**2 + 48.D0*Hr1(1)*z3*x**3 + 16.D0/3.D0*
     &    Hr1(1)*z3*dx**2 + 64.D0/9.D0*Hr1(1)*z3*dm - 124.D0/9.D0*Hr1(1
     &    )*z2 + 160.D0*Hr1(1)*z2*x - 32.D0*Hr1(1)*z2*x**2 - 288.D0/5.D0
     &    *Hr1(1)*z2*x**3 - 16.D0/15.D0*Hr1(1)*z2*dx**2 - 832.D0/9.D0*
     &    Hr1(1)*z2*dm - 64.D0/9.D0*Hr2(-1,-1)*z2 + 640.D0/9.D0*Hr2(-1,
     &    -1)*z2*x + 320.D0/9.D0*Hr2(-1,-1)*z2*dp + 92528.D0/405.D0*
     &    Hr2(-1,0) )
      c2qq3 = c2qq3 + nf*cf*ca * ( 90688.D0/405.D0*Hr2(-1,0)*x - 96.D0/
     &    5.D0*Hr2(-1,0)*x**2 - 1272.D0/25.D0*Hr2(-1,0)*x**3 + 32.D0/15.
     &    D0*Hr2(-1,0)*dx + 952.D0/225.D0*Hr2(-1,0)*dx**2 + 2656.D0/81.D
     &    0*Hr2(-1,0)*dp + 64.D0/9.D0*Hr2(-1,0)*z2 - 352.D0/9.D0*Hr2(-1
     &    ,0)*z2*x - 224.D0/9.D0*Hr2(-1,0)*z2*dp + 208.D0/9.D0*Hr2(0,-1
     &    )*z2 - 16.D0/9.D0*Hr2(0,-1)*z2*x - 416.D0/9.D0*Hr2(0,-1)*z2*
     &    dp - 128.D0/3.D0*Hr2(0,-1)*z2*dm - 75044.D0/405.D0*Hr2(0,0)
     &     - 30116.D0/45.D0*Hr2(0,0)*x + 48.D0/5.D0*Hr2(0,0)*x**2 + 
     &    1272.D0/25.D0*Hr2(0,0)*x**3 - 32.D0/5.D0*Hr2(0,0)*dx - 3056.D0
     &    /81.D0*Hr2(0,0)*dp + 32500.D0/81.D0*Hr2(0,0)*dm + 16.D0*Hr2(0
     &    ,0)*z2 + 104.D0/9.D0*Hr2(0,0)*z2*x + 32.D0*Hr2(0,0)*z2*x**2
     &     - 48.D0*Hr2(0,0)*z2*x**3 + 80.D0/9.D0*Hr2(0,0)*z2*dp - 368.D0
     &    /9.D0*Hr2(0,0)*z2*dm - 13456.D0/135.D0*Hr2(0,1) - 41956.D0/
     &    135.D0*Hr2(0,1)*x - 384.D0/5.D0*Hr2(0,1)*x**2 + 16.D0/5.D0*
     &    Hr2(0,1)*dx + 7276.D0/27.D0*Hr2(0,1)*dm + 160.D0/9.D0*Hr2(0,1
     &    )*z2 )
      c2qq3 = c2qq3 + nf*cf*ca * ( 712.D0/9.D0*Hr2(0,1)*z2*x - 512.D0/9.
     &    D0*Hr2(0,1)*z2*dm - 220.D0/27.D0*Hr2(1,0) - 5284.D0/27.D0*
     &    Hr2(1,0)*x + 48.D0*Hr2(1,0)*x**2 + 2864.D0/27.D0*Hr2(1,0)*dm
     &     + 176.D0/9.D0*Hr2(1,0)*z2 + 1088.D0/9.D0*Hr2(1,0)*z2*x + 32.D
     &    0*Hr2(1,0)*z2*x**2 - 48.D0*Hr2(1,0)*z2*x**3 - 16.D0/3.D0*Hr2(
     &    1,0)*z2*dx**2 - 688.D0/9.D0*Hr2(1,0)*z2*dm - 160.D0/27.D0*
     &    Hr2(1,1) - 5548.D0/27.D0*Hr2(1,1)*x + 3104.D0/27.D0*Hr2(1,1)*
     &    dm + 80.D0/9.D0*Hr2(1,1)*z2 + 800.D0/9.D0*Hr2(1,1)*z2*x - 400.
     &    D0/9.D0*Hr2(1,1)*z2*dm - 64.D0*Hr3(-1,-1,0) - 2240.D0/9.D0*
     &    Hr3(-1,-1,0)*x - 64.D0*Hr3(-1,-1,0)*x**2 + 96.D0/5.D0*Hr3(-1,
     &    -1,0)*x**3 - 32.D0/15.D0*Hr3(-1,-1,0)*dx**2 - 640.D0/9.D0*
     &    Hr3(-1,-1,0)*dp + 3712.D0/27.D0*Hr3(-1,0,0) + 6080.D0/27.D0*
     &    Hr3(-1,0,0)*x - 288.D0/5.D0*Hr3(-1,0,0)*x**3 + 32.D0/5.D0*
     &    Hr3(-1,0,0)*dx**2 + 2560.D0/27.D0*Hr3(-1,0,0)*dp + 1024.D0/27.
     &    D0*Hr3(-1,0,1) + 512.D0/27.D0*Hr3(-1,0,1)*x - 64.D0*Hr3(-1,0,
     &    1)*x**2 )
      c2qq3 = c2qq3 + nf*cf*ca * (  - 96.D0/5.D0*Hr3(-1,0,1)*x**3 + 32.D
     &    0/15.D0*Hr3(-1,0,1)*dx**2 + 640.D0/27.D0*Hr3(-1,0,1)*dp + 
     &    2560.D0/27.D0*Hr3(0,-1,0) + 368.D0/27.D0*Hr3(0,-1,0)*x + 64.D0
     &    *Hr3(0,-1,0)*x**2 - 96.D0/5.D0*Hr3(0,-1,0)*x**3 + 64.D0/15.D0
     &    *Hr3(0,-1,0)*dx**2 + 1600.D0/27.D0*Hr3(0,-1,0)*dp + 208.D0/3.D
     &    0*Hr3(0,-1,0)*dm - 2024.D0/27.D0*Hr3(0,0,0) - 520.D0/3.D0*
     &    Hr3(0,0,0)*x + 288.D0/5.D0*Hr3(0,0,0)*x**3 - 664.D0/27.D0*
     &    Hr3(0,0,0)*dp + 4712.D0/27.D0*Hr3(0,0,0)*dm - 316.D0/9.D0*
     &    Hr3(0,0,1) - 1616.D0/27.D0*Hr3(0,0,1)*x + 16.D0*Hr3(0,0,1)*
     &    x**2 + 336.D0/5.D0*Hr3(0,0,1)*x**3 - 16.D0/3.D0*Hr3(0,0,1)*dx
     &     - 320.D0/27.D0*Hr3(0,0,1)*dp + 3260.D0/27.D0*Hr3(0,0,1)*dm
     &     - 436.D0/9.D0*Hr3(0,1,0) - 40.D0*Hr3(0,1,0)*x - 48.D0*Hr3(0,
     &    1,0)*x**3 + 860.D0/9.D0*Hr3(0,1,0)*dm - 232.D0/9.D0*Hr3(0,1,1
     &    ) - 232.D0/9.D0*Hr3(0,1,1)*x + 704.D0/9.D0*Hr3(0,1,1)*dm - 16.
     &    D0/9.D0*Hr3(1,0,0) - 1184.D0/9.D0*Hr3(1,0,0)*x + 48.D0*Hr3(1,
     &    0,0)*x**2 )
      c2qq3 = c2qq3 + nf*cf*ca * ( 16.D0/3.D0*Hr3(1,0,0)*dx + 592.D0/9.D
     &    0*Hr3(1,0,0)*dm - 164.D0/9.D0*Hr3(1,0,1) - 320.D0/9.D0*Hr3(1,
     &    0,1)*x + 48.D0*Hr3(1,0,1)*x**3 + 512.D0/9.D0*Hr3(1,0,1)*dm - 
     &    188.D0/9.D0*Hr3(1,1,0) - 32.D0/9.D0*Hr3(1,1,0)*x - 48.D0*Hr3(
     &    1,1,0)*x**3 + 64.D0/3.D0*Hr3(1,1,0)*dm - 176.D0/9.D0*Hr3(1,1,
     &    1) - 176.D0/9.D0*Hr3(1,1,1)*x + 352.D0/9.D0*Hr3(1,1,1)*dm - 
     &    128.D0/9.D0*Hr4(-1,-1,-1,0) + 1280.D0/9.D0*Hr4(-1,-1,-1,0)*x
     &     + 640.D0/9.D0*Hr4(-1,-1,-1,0)*dp + 256.D0/9.D0*Hr4(-1,-1,0,0
     &    ) - 1984.D0/9.D0*Hr4(-1,-1,0,0)*x - 1088.D0/9.D0*Hr4(-1,-1,0,
     &    0)*dp + 160.D0/9.D0*Hr4(-1,0,-1,0) - 1312.D0/9.D0*Hr4(-1,0,-1
     &    ,0)*x - 704.D0/9.D0*Hr4(-1,0,-1,0)*dp - 400.D0/9.D0*Hr4(-1,0,
     &    0,0) + 1264.D0/9.D0*Hr4(-1,0,0,0)*x + 1088.D0/9.D0*Hr4(-1,0,0
     &    ,0)*dp - 32.D0/9.D0*Hr4(-1,0,0,1) + 32.D0/9.D0*Hr4(-1,0,0,1)*
     &    x + 64.D0/9.D0*Hr4(-1,0,0,1)*dp + 64.D0/9.D0*Hr4(-1,0,1,1) - 
     &    64.D0/9.D0*Hr4(-1,0,1,1)*x - 128.D0/9.D0*Hr4(-1,0,1,1)*dp + 
     &    160.D0/9.D0*Hr4(0,-1,-1,0) )
      c2qq3 = c2qq3 + nf*cf*ca * (  - 1312.D0/9.D0*Hr4(0,-1,-1,0)*x - 
     &    704.D0/9.D0*Hr4(0,-1,-1,0)*dp - 592.D0/9.D0*Hr4(0,-1,0,0) + 
     &    400.D0/9.D0*Hr4(0,-1,0,0)*x + 1088.D0/9.D0*Hr4(0,-1,0,0)*dp
     &     + 256.D0/3.D0*Hr4(0,-1,0,0)*dm - 128.D0/9.D0*Hr4(0,-1,0,1)
     &     - 640.D0/9.D0*Hr4(0,-1,0,1)*x + 64.D0/9.D0*Hr4(0,-1,0,1)*dp
     &     + 128.D0/3.D0*Hr4(0,-1,0,1)*dm - 496.D0/9.D0*Hr4(0,0,-1,0)
     &     + 16.D0/9.D0*Hr4(0,0,-1,0)*x + 800.D0/9.D0*Hr4(0,0,-1,0)*dp
     &     + 256.D0/3.D0*Hr4(0,0,-1,0)*dm - 368.D0/9.D0*Hr4(0,0,0,0)*x
     &     - 368.D0/9.D0*Hr4(0,0,0,0)*dp + 368.D0/9.D0*Hr4(0,0,0,0)*dm
     &     - 16.D0*Hr4(0,0,0,1) - 88.D0/9.D0*Hr4(0,0,0,1)*x - 32.D0*
     &    Hr4(0,0,0,1)*x**2 + 48.D0*Hr4(0,0,0,1)*x**3 - 64.D0/9.D0*Hr4(
     &    0,0,0,1)*dp + 352.D0/9.D0*Hr4(0,0,0,1)*dm - 8.D0*Hr4(0,0,1,0)
     &     - 32.D0/3.D0*Hr4(0,0,1,0)*x + 16.D0*Hr4(0,0,1,0)*dm - 40.D0/
     &    3.D0*Hr4(0,0,1,1) - 56.D0/9.D0*Hr4(0,0,1,1)*x + 64.D0/9.D0*
     &    Hr4(0,0,1,1)*dp + 176.D0/9.D0*Hr4(0,0,1,1)*dm - 8.D0/9.D0*
     &    Hr4(0,1,0,0) )
      c2qq3 = c2qq3 + nf*cf*ca * (  - 392.D0/9.D0*Hr4(0,1,0,0)*x + 32.D0
     &    *Hr4(0,1,0,0)*x**2 - 48.D0*Hr4(0,1,0,0)*x**3 + 112.D0/9.D0*
     &    Hr4(0,1,0,0)*dm - 80.D0/9.D0*Hr4(0,1,0,1) - 56.D0/9.D0*Hr4(0,
     &    1,0,1)*x + 160.D0/9.D0*Hr4(0,1,0,1)*dm + 80.D0/9.D0*Hr4(0,1,1
     &    ,0) + 56.D0/9.D0*Hr4(0,1,1,0)*x - 160.D0/9.D0*Hr4(0,1,1,0)*dm
     &     - 32.D0/3.D0*Hr4(1,0,-1,0) - 224.D0/3.D0*Hr4(1,0,-1,0)*x + 
     &    128.D0/3.D0*Hr4(1,0,-1,0)*dm + 16.D0/9.D0*Hr4(1,0,0,0) - 848.D
     &    0/9.D0*Hr4(1,0,0,0)*x + 256.D0/9.D0*Hr4(1,0,0,0)*dm - 16.D0*
     &    Hr4(1,0,0,1) - 256.D0/3.D0*Hr4(1,0,0,1)*x - 32.D0*Hr4(1,0,0,1
     &    )*x**2 + 48.D0*Hr4(1,0,0,1)*x**3 + 16.D0/3.D0*Hr4(1,0,0,1)*
     &    dx**2 + 176.D0/3.D0*Hr4(1,0,0,1)*dm + 16.D0/3.D0*Hr4(1,0,1,0)
     &     + 64.D0/3.D0*Hr4(1,0,1,0)*x - 16.D0*Hr4(1,0,1,0)*dm - 8.D0*
     &    Hr4(1,0,1,1) - 8.D0*Hr4(1,0,1,1)*x + 16.D0*Hr4(1,0,1,1)*dm + 
     &    104.D0/9.D0*Hr4(1,1,0,0) + 8.D0/9.D0*Hr4(1,1,0,0)*x + 32.D0*
     &    Hr4(1,1,0,0)*x**2 - 48.D0*Hr4(1,1,0,0)*x**3 - 16.D0/3.D0*Hr4(
     &    1,1,0,0)*dx**2 )
      c2qq3 = c2qq3 + nf*cf*ca * (  - 208.D0/9.D0*Hr4(1,1,0,0)*dm - 16.D
     &    0/9.D0*Hr4(1,1,0,1) - 160.D0/9.D0*Hr4(1,1,0,1)*x + 80.D0/9.D0
     &    *Hr4(1,1,0,1)*dm + 88.D0/9.D0*Hr4(1,1,1,0) + 232.D0/9.D0*Hr4(
     &    1,1,1,0)*x - 224.D0/9.D0*Hr4(1,1,1,0)*dm )
      c2qq3 = c2qq3 + nf*cf**2 * ( 27074.D0/2025.D0 + 1183877.D0/4050.D0
     &    *x - 3504.D0/25.D0*x**2 - 544.D0/9.D0*z4 - 1312.D0/9.D0*z4*x
     &     - 2864.D0/225.D0*dx - 304.D0/3.D0*dp*z4 - 2003.D0/108.D0*dm
     &     + 1244.D0/9.D0*dm*z4 + 6646.D0/27.D0*z3 - 2882.D0/27.D0*z3*x
     &     - 32.D0*z3*x**2 - 144.D0*z3*x**3 - 320.D0/3.D0*z3*dp - 9668.D
     &    0/27.D0*z3*dm + 39574.D0/405.D0*z2 - 156622.D0/405.D0*z2*x - 
     &    208.D0/5.D0*z2*x**2 + 2544.D0/25.D0*z2*x**3 - 128.D0/15.D0*z2
     &    *dx - 2656.D0/81.D0*z2*dp - 1538.D0/27.D0*z2*dm - 64.D0/9.D0*
     &    Hr1(-1)*z3 + 1216.D0/9.D0*Hr1(-1)*z3*x + 512.D0/9.D0*Hr1(-1)*
     &    z3*dp + 3776.D0/27.D0*Hr1(-1)*z2 + 7744.D0/27.D0*Hr1(-1)*z2*x
     &     - 64.D0*Hr1(-1)*z2*x**2 - 288.D0/5.D0*Hr1(-1)*z2*x**3 + 32.D0
     &    /5.D0*Hr1(-1)*z2*dx**2 + 3200.D0/27.D0*Hr1(-1)*z2*dp + 431299.
     &    D0/4050.D0*Hr1(0) + 780913.D0/1350.D0*Hr1(0)*x - 2464.D0/25.D0
     &    *Hr1(0)*x**2 + 944.D0/225.D0*Hr1(0)*dx + 464.D0/9.D0*Hr1(0)*
     &    dp - 4795.D0/27.D0*Hr1(0)*dm + 500.D0/3.D0*Hr1(0)*z3 + 188.D0/
     &    9.D0*Hr1(0)*z3*x )
      c2qq3 = c2qq3 + nf*cf**2 * (  - 352.D0/9.D0*Hr1(0)*z3*dp - 2336.D0
     &    /9.D0*Hr1(0)*z3*dm + 2450.D0/9.D0*Hr1(0)*z2 + 7534.D0/27.D0*
     &    Hr1(0)*z2*x + 160.D0*Hr1(0)*z2*x**2 + 784.D0/5.D0*Hr1(0)*z2*
     &    x**3 - 368.D0/27.D0*Hr1(0)*z2*dp - 8428.D0/27.D0*Hr1(0)*z2*dm
     &     - 14609.D0/90.D0*Hr1(1) + 76157.D0/270.D0*Hr1(1)*x + 208.D0/
     &    5.D0*Hr1(1)*x**2 - 64.D0/15.D0*Hr1(1)*dx - 83.D0/9.D0*Hr1(1)*
     &    dm + 664.D0/9.D0*Hr1(1)*z3 - 200.D0/9.D0*Hr1(1)*z3*x - 1040.D0
     &    /9.D0*Hr1(1)*z3*dm + 1768.D0/9.D0*Hr1(1)*z2 - 568.D0/9.D0*
     &    Hr1(1)*z2*x + 96.D0*Hr1(1)*z2*x**2 + 496.D0/5.D0*Hr1(1)*z2*
     &    x**3 + 32.D0/15.D0*Hr1(1)*z2*dx**2 - 1408.D0/9.D0*Hr1(1)*z2*
     &    dm + 128.D0/9.D0*Hr2(-1,-1)*z2 - 1280.D0/9.D0*Hr2(-1,-1)*z2*x
     &     - 640.D0/9.D0*Hr2(-1,-1)*z2*dp - 185056.D0/405.D0*Hr2(-1,0)
     &     - 181376.D0/405.D0*Hr2(-1,0)*x + 192.D0/5.D0*Hr2(-1,0)*x**2
     &     + 2544.D0/25.D0*Hr2(-1,0)*x**3 - 64.D0/15.D0*Hr2(-1,0)*dx - 
     &    1904.D0/225.D0*Hr2(-1,0)*dx**2 - 5312.D0/81.D0*Hr2(-1,0)*dp
     &     - 128.D0/9.D0*Hr2(-1,0)*z2 )
      c2qq3 = c2qq3 + nf*cf**2 * ( 704.D0/9.D0*Hr2(-1,0)*z2*x + 448.D0/
     &    9.D0*Hr2(-1,0)*z2*dp - 416.D0/9.D0*Hr2(0,-1)*z2 + 32.D0/9.D0*
     &    Hr2(0,-1)*z2*x + 832.D0/9.D0*Hr2(0,-1)*z2*dp + 256.D0/3.D0*
     &    Hr2(0,-1)*z2*dm - 10024.D0/135.D0*Hr2(0,0) + 198278.D0/405.D0
     &    *Hr2(0,0)*x - 576.D0/5.D0*Hr2(0,0)*x**2 - 2544.D0/25.D0*Hr2(0
     &    ,0)*x**3 + 64.D0/5.D0*Hr2(0,0)*dx + 6112.D0/81.D0*Hr2(0,0)*dp
     &     - 1082.D0/27.D0*Hr2(0,0)*dm + 1084.D0/9.D0*Hr2(0,0)*z2 + 308.
     &    D0/3.D0*Hr2(0,0)*z2*x - 160.D0/9.D0*Hr2(0,0)*z2*dp - 1456.D0/
     &    9.D0*Hr2(0,0)*z2*dm - 39574.D0/405.D0*Hr2(0,1) - 24754.D0/405.
     &    D0*Hr2(0,1)*x + 208.D0/5.D0*Hr2(0,1)*x**2 + 64.D0/15.D0*Hr2(0
     &    ,1)*dx + 7270.D0/81.D0*Hr2(0,1)*dm + 520.D0/9.D0*Hr2(0,1)*z2
     &     - 632.D0/9.D0*Hr2(0,1)*z2*x - 512.D0/9.D0*Hr2(0,1)*z2*dm - 
     &    14180.D0/81.D0*Hr2(1,0) - 6464.D0/81.D0*Hr2(1,0)*x - 80.D0*
     &    Hr2(1,0)*x**2 + 15334.D0/81.D0*Hr2(1,0)*dm + 152.D0/3.D0*Hr2(
     &    1,0)*z2 - 520.D0/3.D0*Hr2(1,0)*z2*x - 80.D0/3.D0*Hr2(1,0)*z2*
     &    dm )
      c2qq3 = c2qq3 + nf*cf**2 * (  - 1240.D0/9.D0*Hr2(1,1) - 484.D0/9.D
     &    0*Hr2(1,1)*x + 1366.D0/9.D0*Hr2(1,1)*dm + 400.D0/9.D0*Hr2(1,1
     &    )*z2 - 1040.D0/9.D0*Hr2(1,1)*z2*x - 320.D0/9.D0*Hr2(1,1)*z2*
     &    dm + 128.D0*Hr3(-1,-1,0) + 4480.D0/9.D0*Hr3(-1,-1,0)*x + 128.D
     &    0*Hr3(-1,-1,0)*x**2 - 192.D0/5.D0*Hr3(-1,-1,0)*x**3 + 64.D0/
     &    15.D0*Hr3(-1,-1,0)*dx**2 + 1280.D0/9.D0*Hr3(-1,-1,0)*dp - 
     &    7424.D0/27.D0*Hr3(-1,0,0) - 12160.D0/27.D0*Hr3(-1,0,0)*x + 
     &    576.D0/5.D0*Hr3(-1,0,0)*x**3 - 64.D0/5.D0*Hr3(-1,0,0)*dx**2
     &     - 5120.D0/27.D0*Hr3(-1,0,0)*dp - 2048.D0/27.D0*Hr3(-1,0,1)
     &     - 1024.D0/27.D0*Hr3(-1,0,1)*x + 128.D0*Hr3(-1,0,1)*x**2 + 
     &    192.D0/5.D0*Hr3(-1,0,1)*x**3 - 64.D0/15.D0*Hr3(-1,0,1)*dx**2
     &     - 1280.D0/27.D0*Hr3(-1,0,1)*dp - 5120.D0/27.D0*Hr3(0,-1,0)
     &     - 736.D0/27.D0*Hr3(0,-1,0)*x - 128.D0*Hr3(0,-1,0)*x**2 + 192.
     &    D0/5.D0*Hr3(0,-1,0)*x**3 - 128.D0/15.D0*Hr3(0,-1,0)*dx**2 - 
     &    3200.D0/27.D0*Hr3(0,-1,0)*dp - 416.D0/3.D0*Hr3(0,-1,0)*dm - 
     &    1522.D0/9.D0*Hr3(0,0,0) )
      c2qq3 = c2qq3 + nf*cf**2 * (  - 1510.D0/27.D0*Hr3(0,0,0)*x - 576.D
     &    0/5.D0*Hr3(0,0,0)*x**3 + 1328.D0/27.D0*Hr3(0,0,0)*dp + 3268.D0
     &    /27.D0*Hr3(0,0,0)*dm - 2450.D0/9.D0*Hr3(0,0,1) - 8270.D0/27.D0
     &    *Hr3(0,0,1)*x - 160.D0*Hr3(0,0,1)*x**2 - 592.D0/5.D0*Hr3(0,0,
     &    1)*x**3 + 640.D0/27.D0*Hr3(0,0,1)*dp + 8156.D0/27.D0*Hr3(0,0,
     &    1)*dm - 3640.D0/27.D0*Hr3(0,1,0) - 6520.D0/27.D0*Hr3(0,1,0)*x
     &     + 32.D0*Hr3(0,1,0)*x**2 + 80.D0*Hr3(0,1,0)*x**3 + 5552.D0/27.
     &    D0*Hr3(0,1,0)*dm - 1432.D0/9.D0*Hr3(0,1,1) - 2408.D0/9.D0*
     &    Hr3(0,1,1)*x + 688.D0/3.D0*Hr3(0,1,1)*dm - 3920.D0/27.D0*Hr3(
     &    1,0,0) + 280.D0/27.D0*Hr3(1,0,0)*x + 5020.D0/27.D0*Hr3(1,0,0)
     &    *dm - 1192.D0/9.D0*Hr3(1,0,1) - 1672.D0/9.D0*Hr3(1,0,1)*x - 
     &    32.D0*Hr3(1,0,1)*x**2 - 80.D0*Hr3(1,0,1)*x**3 + 2048.D0/9.D0*
     &    Hr3(1,0,1)*dm - 952.D0/9.D0*Hr3(1,1,0) - 632.D0/3.D0*Hr3(1,1,
     &    0)*x + 32.D0*Hr3(1,1,0)*x**2 + 80.D0*Hr3(1,1,0)*x**3 + 2152.D0
     &    /9.D0*Hr3(1,1,0)*dm - 280.D0/3.D0*Hr3(1,1,1) - 168.D0*Hr3(1,1
     &    ,1)*x )
      c2qq3 = c2qq3 + nf*cf**2 * ( 560.D0/3.D0*Hr3(1,1,1)*dm + 256.D0/9.
     &    D0*Hr4(-1,-1,-1,0) - 2560.D0/9.D0*Hr4(-1,-1,-1,0)*x - 1280.D0/
     &    9.D0*Hr4(-1,-1,-1,0)*dp - 512.D0/9.D0*Hr4(-1,-1,0,0) + 3968.D0
     &    /9.D0*Hr4(-1,-1,0,0)*x + 2176.D0/9.D0*Hr4(-1,-1,0,0)*dp - 320.
     &    D0/9.D0*Hr4(-1,0,-1,0) + 2624.D0/9.D0*Hr4(-1,0,-1,0)*x + 1408.
     &    D0/9.D0*Hr4(-1,0,-1,0)*dp + 800.D0/9.D0*Hr4(-1,0,0,0) - 2528.D
     &    0/9.D0*Hr4(-1,0,0,0)*x - 2176.D0/9.D0*Hr4(-1,0,0,0)*dp + 64.D0
     &    /9.D0*Hr4(-1,0,0,1) - 64.D0/9.D0*Hr4(-1,0,0,1)*x - 128.D0/9.D0
     &    *Hr4(-1,0,0,1)*dp - 128.D0/9.D0*Hr4(-1,0,1,1) + 128.D0/9.D0*
     &    Hr4(-1,0,1,1)*x + 256.D0/9.D0*Hr4(-1,0,1,1)*dp - 320.D0/9.D0*
     &    Hr4(0,-1,-1,0) + 2624.D0/9.D0*Hr4(0,-1,-1,0)*x + 1408.D0/9.D0
     &    *Hr4(0,-1,-1,0)*dp + 1184.D0/9.D0*Hr4(0,-1,0,0) - 800.D0/9.D0
     &    *Hr4(0,-1,0,0)*x - 2176.D0/9.D0*Hr4(0,-1,0,0)*dp - 512.D0/3.D0
     &    *Hr4(0,-1,0,0)*dm + 256.D0/9.D0*Hr4(0,-1,0,1) + 1280.D0/9.D0*
     &    Hr4(0,-1,0,1)*x - 128.D0/9.D0*Hr4(0,-1,0,1)*dp - 256.D0/3.D0*
     &    Hr4(0,-1,0,1)*dm )
      c2qq3 = c2qq3 + nf*cf**2 * ( 992.D0/9.D0*Hr4(0,0,-1,0) - 32.D0/9.D
     &    0*Hr4(0,0,-1,0)*x - 1600.D0/9.D0*Hr4(0,0,-1,0)*dp - 512.D0/3.D
     &    0*Hr4(0,0,-1,0)*dm - 364.D0/3.D0*Hr4(0,0,0,0) - 356.D0/9.D0*
     &    Hr4(0,0,0,0)*x + 736.D0/9.D0*Hr4(0,0,0,0)*dp + 80.D0*Hr4(0,0,
     &    0,0)*dm - 1084.D0/9.D0*Hr4(0,0,0,1) - 956.D0/9.D0*Hr4(0,0,0,1
     &    )*x + 128.D0/9.D0*Hr4(0,0,0,1)*dp + 496.D0/3.D0*Hr4(0,0,0,1)*
     &    dm - 944.D0/9.D0*Hr4(0,0,1,0) - 944.D0/9.D0*Hr4(0,0,1,0)*x + 
     &    1552.D0/9.D0*Hr4(0,0,1,0)*dm - 304.D0/3.D0*Hr4(0,0,1,1) - 
     &    1040.D0/9.D0*Hr4(0,0,1,1)*x - 128.D0/9.D0*Hr4(0,0,1,1)*dp + 
     &    1616.D0/9.D0*Hr4(0,0,1,1)*dm - 736.D0/9.D0*Hr4(0,1,0,0) - 160.
     &    D0/9.D0*Hr4(0,1,0,0)*x + 1136.D0/9.D0*Hr4(0,1,0,0)*dm - 680.D0
     &    /9.D0*Hr4(0,1,0,1) - 680.D0/9.D0*Hr4(0,1,0,1)*x + 1216.D0/9.D0
     &    *Hr4(0,1,0,1)*dm - 296.D0/3.D0*Hr4(0,1,1,0) - 296.D0/3.D0*
     &    Hr4(0,1,1,0)*x + 544.D0/3.D0*Hr4(0,1,1,0)*dm - 728.D0/9.D0*
     &    Hr4(0,1,1,1) - 728.D0/9.D0*Hr4(0,1,1,1)*x + 1312.D0/9.D0*Hr4(
     &    0,1,1,1)*dm )
      c2qq3 = c2qq3 + nf*cf**2 * ( 64.D0/3.D0*Hr4(1,0,-1,0) + 448.D0/3.D
     &    0*Hr4(1,0,-1,0)*x - 256.D0/3.D0*Hr4(1,0,-1,0)*dm - 712.D0/9.D0
     &    *Hr4(1,0,0,0) + 1016.D0/9.D0*Hr4(1,0,0,0)*x + 848.D0/9.D0*
     &    Hr4(1,0,0,0)*dm - 520.D0/9.D0*Hr4(1,0,0,1) + 920.D0/9.D0*Hr4(
     &    1,0,0,1)*x + 560.D0/9.D0*Hr4(1,0,0,1)*dm - 688.D0/9.D0*Hr4(1,
     &    0,1,0) - 976.D0/9.D0*Hr4(1,0,1,0)*x + 1472.D0/9.D0*Hr4(1,0,1,
     &    0)*dm - 544.D0/9.D0*Hr4(1,0,1,1) - 544.D0/9.D0*Hr4(1,0,1,1)*x
     &     + 1088.D0/9.D0*Hr4(1,0,1,1)*dm - 728.D0/9.D0*Hr4(1,1,0,0) - 
     &    728.D0/9.D0*Hr4(1,1,0,0)*x + 1456.D0/9.D0*Hr4(1,1,0,0)*dm - 
     &    176.D0/3.D0*Hr4(1,1,0,1) - 80.D0/3.D0*Hr4(1,1,0,1)*x + 320.D0/
     &    3.D0*Hr4(1,1,0,1)*dm - 608.D0/9.D0*Hr4(1,1,1,0) - 896.D0/9.D0
     &    *Hr4(1,1,1,0)*x + 1312.D0/9.D0*Hr4(1,1,1,0)*dm - 160.D0/3.D0*
     &    Hr4(1,1,1,1) - 160.D0/3.D0*Hr4(1,1,1,1)*x + 320.D0/3.D0*Hr4(1
     &    ,1,1,1)*dm )
      c2qq3 = c2qq3 + nf2*cf * (  - 2456.D0/729.D0 + 36748.D0/729.D0*
     &    x - 8714.D0/729.D0*dm - 32.D0/27.D0*z3 - 32.D0/27.D0*z3*x + 
     &    64.D0/27.D0*z3*dm - 304.D0/27.D0*z2 - 544.D0/27.D0*z2*x + 536.
     &    D0/27.D0*z2*dm + 1376.D0/81.D0*Hr1(0) + 4384.D0/81.D0*Hr1(0)*
     &    x - 860.D0/27.D0*Hr1(0)*dm - 16.D0/3.D0*Hr1(0)*z2 - 16.D0/3.D0
     &    *Hr1(0)*z2*x + 32.D0/3.D0*Hr1(0)*z2*dm + 296.D0/81.D0*Hr1(1)
     &     + 2240.D0/81.D0*Hr1(1)*x - 940.D0/81.D0*Hr1(1)*dm - 16.D0/9.D
     &    0*Hr1(1)*z2 - 16.D0/9.D0*Hr1(1)*z2*x + 32.D0/9.D0*Hr1(1)*z2*
     &    dm + 1448.D0/81.D0*Hr2(0,0) + 2360.D0/81.D0*Hr2(0,0)*x - 2440.
     &    D0/81.D0*Hr2(0,0)*dm + 304.D0/27.D0*Hr2(0,1) + 544.D0/27.D0*
     &    Hr2(0,1)*x - 536.D0/27.D0*Hr2(0,1)*dm + 128.D0/27.D0*Hr2(1,0)
     &     + 272.D0/27.D0*Hr2(1,0)*x - 232.D0/27.D0*Hr2(1,0)*dm + 128.D0
     &    /27.D0*Hr2(1,1) + 272.D0/27.D0*Hr2(1,1)*x - 232.D0/27.D0*Hr2(
     &    1,1)*dm + 184.D0/27.D0*Hr3(0,0,0) + 184.D0/27.D0*Hr3(0,0,0)*x
     &     - 368.D0/27.D0*Hr3(0,0,0)*dm + 16.D0/3.D0*Hr3(0,0,1) + 16.D0/
     &    3.D0*Hr3(0,0,1)*x )
      c2qq3 = c2qq3 + nf2*cf * (  - 32.D0/3.D0*Hr3(0,0,1)*dm + 32.D0/
     &    9.D0*Hr3(0,1,0) + 32.D0/9.D0*Hr3(0,1,0)*x - 64.D0/9.D0*Hr3(0,
     &    1,0)*dm + 32.D0/9.D0*Hr3(0,1,1) + 32.D0/9.D0*Hr3(0,1,1)*x - 
     &    64.D0/9.D0*Hr3(0,1,1)*dm + 16.D0/9.D0*Hr3(1,0,0) + 16.D0/9.D0
     &    *Hr3(1,0,0)*x - 32.D0/9.D0*Hr3(1,0,0)*dm + 16.D0/9.D0*Hr3(1,0
     &    ,1) + 16.D0/9.D0*Hr3(1,0,1)*x - 32.D0/9.D0*Hr3(1,0,1)*dm + 16.
     &    D0/9.D0*Hr3(1,1,0) + 16.D0/9.D0*Hr3(1,1,0)*x - 32.D0/9.D0*
     &    Hr3(1,1,0)*dm + 16.D0/9.D0*Hr3(1,1,1) + 16.D0/9.D0*Hr3(1,1,1)
     &    *x - 32.D0/9.D0*Hr3(1,1,1)*dm )
*
* ...The special contributions
*
      SP1 =
     &  + dm * (  - 6.D0*z3 + 4.D0/5.D0*z2**2 + 8.D0*Hr1(-1)*z2 + 6.D0*
     &    Hr1(0)*z3 - 6.D0*Hr1(0)*z2 - 8.D0*Hr2(0,-1)*z2 + 6.D0*Hr2(0,0
     &    )*z2 - 4.D0*Hr3(-1,0,0) - 8.D0*Hr3(-1,0,1) + 2.D0*Hr3(0,0,0)
     &     + 4.D0*Hr3(0,0,1) + 4.D0*Hr4(0,-1,0,0) + 8.D0*Hr4(0,-1,0,1)
     &     - 2.D0*Hr4(0,0,0,0) - 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + dm**2 * (  - 4.D0/5.D0*z2**2 - 6.D0*Hr1(0)*z3 + 8.D0*
     &    Hr2(0,-1)*z2 - 6.D0*Hr2(0,0)*z2 - 4.D0*Hr4(0,-1,0,0) - 8.D0*
     &    Hr4(0,-1,0,1) + 2.D0*Hr4(0,0,0,0) + 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + 2.D0*z3 + 4.D0*z3*dp - 21.D0/5.D0*z2**2*dp + 21.D0/5.D
     &    0*z2**2*dp**2 - 8.D0*Hr1(-1)*z2 - 4.D0*Hr1(0)*z3*dp + 4.D0*
     &    Hr1(0)*z3*dp**2 + 4.D0*Hr1(0)*z2 + 2.D0*Hr1(0)*z2*dp - 2.D0*
     &    Hr2(0,0)*z2*dp + 2.D0*Hr2(0,0)*z2*dp**2 + 4.D0*Hr3(-1,0,0) +
     &    8.D0*Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 4.D0*Hr3(0,-1,0)*dp - 2.
     &    D0*Hr3(0,0,0)*dp - 4.D0*Hr3(0,0,1) - 4.D0*Hr4(0,0,-1,0)*dp +
     &    4.D0*Hr4(0,0,-1,0)*dp**2 + 2.D0*Hr4(0,0,0,0)*dp - 2.D0*Hr4(0,
     &    0,0,0)*dp**2
       if (x .gt. 0.99995D0) then
         SP1 = x*(z2+z3)
* ...For 5-digit accuracy down to x=0.9
c    ,         + (1.-x)**2 * (-0.5*DL1-0.25*z2-0.5*z3+5./8.d0)
       endif
*
      SP2 =
     &  + dm * (  - 18.D0*z3 + 2.D0*z2 + 8.D0/5.D0*z2**2 + 24.D0*Hr1(-1
     &    )*z2 + 12.D0*Hr1(0)*z3 - 18.D0*Hr1(0)*z2 - 16.D0*Hr2(0,-1)*z2
     &     + 12.D0*Hr2(0,0)*z2 - 12.D0*Hr3(-1,0,0) - 24.D0*Hr3(-1,0,1)
     &     + 6.D0*Hr3(0,0,0) + 12.D0*Hr3(0,0,1) + 8.D0*Hr4(0,-1,0,0) +
     &    16.D0*Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2 = SP2 + dm**2 * ( 12.D0*z3 - 16.D0/5.D0*z2**2 - 16.D0*Hr1(-1)
     &    *z2 - 24.D0*Hr1(0)*z3 + 12.D0*Hr1(0)*z2 + 32.D0*Hr2(0,-1)*z2
     &     - 24.D0*Hr2(0,0)*z2 + 8.D0*Hr3(-1,0,0) + 16.D0*Hr3(-1,0,1)
     &     - 4.D0*Hr3(0,0,0) - 8.D0*Hr3(0,0,1) - 16.D0*Hr4(0,-1,0,0) -
     &    32.D0*Hr4(0,-1,0,1) + 8.D0*Hr4(0,0,0,0) + 16.D0*Hr4(0,0,0,1)
     &     )
      SP2 = SP2 + dm**3 * ( 8.D0/5.D0*z2**2 + 12.D0*Hr1(0)*z3 - 16.D0*
     &    Hr2(0,-1)*z2 + 12.D0*Hr2(0,0)*z2 + 8.D0*Hr4(0,-1,0,0) + 16.D0
     &    *Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2 = SP2 + 2.D0*z3 + 12.D0*z3*dp - 8.D0*z3*dp**2 + 4.D0*z2 - 6.D0
     &    *z2*dp - 42.D0/5.D0*z2**2*dp + 84.D0/5.D0*z2**2*dp**2 - 42.D0/
     &    5.D0*z2**2*dp**3 - 8.D0*Hr1(-1)*z2 - 8.D0*Hr1(0)*z3*dp + 16.D0
     &    *Hr1(0)*z3*dp**2 - 8.D0*Hr1(0)*z3*dp**3 + 4.D0*Hr1(0)*z2 + 6.D
     &    0*Hr1(0)*z2*dp - 4.D0*Hr1(0)*z2*dp**2 + 4.D0*Hr2(-1,0) - 4.D0
     &    *Hr2(-1,0)*dp - 4.D0*Hr2(0,0) + 4.D0*Hr2(0,0)*dp - 4.D0*Hr2(0
     &    ,0)*z2*dp + 8.D0*Hr2(0,0)*z2*dp**2 - 4.D0*Hr2(0,0)*z2*dp**3
     &     - 4.D0*Hr2(0,1) + 4.D0*Hr2(0,1)*dp + 4.D0*Hr3(-1,0,0) + 8.D0
     &    *Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 12.D0*Hr3(0,-1,0)*dp - 8.D0
     &    *Hr3(0,-1,0)*dp**2 - 6.D0*Hr3(0,0,0)*dp + 4.D0*Hr3(0,0,0)*
     &    dp**2 - 4.D0*Hr3(0,0,1) - 8.D0*Hr4(0,0,-1,0)*dp + 16.D0*Hr4(0
     &    ,0,-1,0)*dp**2 - 8.D0*Hr4(0,0,-1,0)*dp**3 + 4.D0*Hr4(0,0,0,0)
     &    *dp - 8.D0*Hr4(0,0,0,0)*dp**2 + 4.D0*Hr4(0,0,0,0)*dp**3
       if (x .gt. 0.995D0) then
         SP2 =    (1.-x)* (-DL1-0.5*z2-z3+0.75D0)
     ,          + (1.-x)**2 * (-0.5)
* ...For 5-digit accuracy down to x=0.9
c    ,          + (1.-x)**3 * (DL1/3.d0+z2/18.d0+z3/3.d0-0.75)
c    ,          + (1.-x)**4 * (DL1/3.d0+z2/18.d0+z3/3.d0-0.5)
c    ,          + (1.-x)**5 * (31./120.d0*DL1+17./360.d0*z2+7./30.d0*z3
c    ,                         -1103./4800.d0)
       endif
*
* ...The soft (`+'-distribution) part of the coefficient function
*
       
*
       C2QQ3L = DM * ( DL1**5 * C3A5 + DL1**4 * C3A4 + DL1**3 * C3A3
     ,               + DL1**2 * C3A2 + DL1    * C3A1 + C3A0 )

*
* ...The regular piece of the coefficient function
       X2NP3A = C2QQ3 + CF*(CA-2.*CF)**2 * (8.*SP1 - SP2/3.D0) - C2QQ3L
       endif
*
*
       RETURN
       END

      FUNCTION X2NP3A_large_x (Y, DL, NF)
      IMPLICIT REAL*8 (A - Z)
      INTEGER NF
      DOUBLE PRECISION Y, DL, DL1
      
      DL1 = DL1VAL(Y, DL)
      
      X2NP3A_large_x = 5894.634952596363d0*DL1 + 2319.655820717043d0
     $     *DL1**2 -1787.0418273217867d0*DL1**3 + 348.44444444444446d0
     $     *DL1**4 -18.962962962962962d0*DL1**5 +(1199.690656381538d0
     $     *DL1 -787.5420539087113d0*DL1**2 +146.69958847736626d0*DL1
     $     **3 -7.901234567901234d0*DL1**4) *NF +(-65.15652656374832d0
     $     *DL1 +14.617283950617283d0*DL1 **2 -0.7901234567901234d0*DL1
     $     **3)*NF**2
      
      RETURN
      END FUNCTION
*
* ---------------------------------------------------------------------
*
*
* ..The singular (soft) piece. It receives no d_abc d_abc contribution.
*
       FUNCTION X2NS3B (Y, DL, NF)
       IMPLICIT REAL*8 (A - Z)
       INTEGER NF
*
       COMMON / C3SOFT / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5
*
       DL1 = DL1VAL(Y, DL) !LOG (1.D0-Y)
       DM  = DMVAL(Y, DL) !1.D0/(1.D0-Y)
*
       X2NS3B = DM * ( DL1**5 * C3A5 + DL1**4 * C3A4 + DL1**3 * C3A3
     ,               + DL1**2 * C3A2 + DL1    * C3A1 + C3A0 )
*
       RETURN
       END
*
* ---------------------------------------------------------------------
*
*
* ..The 'local' piece. Here the d_abc d_abc part does contribute.
*
       FUNCTION X2NP3C (Y, NF, CC)
*
       IMPLICIT REAL*8 (A - Z)
       INTEGER NF, NF2, CC
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0, 
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
       DIMENSION FL(6)
       DATA FL  / -1.d0, 0.5d0, 0.d0, 0.5d0, 0.2d0, 0.5d0 /
*
       COMMON / C3SOFT / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5
*
* ...Colour factors
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
       DABC2N = 5.D0/18.D0 * NF
       FL11 = FL(NF)
*
* ...The coefficient of delta(1-x)
*
       if(CC.eq.1) then
       C3DELT =
     &     - 7255.D0/24.D0*cf**3
     &     - 1129.D0/2.D0*z2*cf**3
     &     - 950.D0/3.D0*z3*cf**3
     &     - 1074.D0*z4*cf**3
     &     + 808.D0*z2*z3*cf**3
     &     + 1240.D0*z5*cf**3
     &     + 2092.D0/63.D0*z2*z4*cf**3
     &     - 304.D0/3.D0*z3**2*cf**3
     &     + 9161.D0/12.D0*ca*cf**2
     &     + 104189.D0/54.D0*z2*ca*cf**2
     &     - 2141.D0*z3*ca*cf**2
     &     + 43816.D0/27.D0*z4*ca*cf**2
     &     - 6644.D0/9.D0*z2*z3*ca*cf**2
     &     - 4952.D0/9.D0*z5*ca*cf**2
     &     - 16778.D0/63.D0*z2*z4*ca*cf**2
     &     + 1016.D0/3.D0*z3**2*ca*cf**2
     &     - 1909753.D0/1944.D0*ca**2*cf
     &     - 143282.D0/81.D0*z2*ca**2*cf
     &     + 105739.D0/81.D0*z3*ca**2*cf
     &     + 12592.D0/27.D0*z4*ca**2*cf
     &     + 540.D0*z2*z3*ca**2*cf
     &     - 416.D0/3.D0*z5*ca**2*cf
     &     - 8780.D0/63.D0*z2*z4*ca**2*cf
     &     - 248.D0/3.D0*z3**2*ca**2*cf
     &     + 1./3.D0* CF*(CA-2.*CF)**2 *(z2-z3)
*
     &     - 341.D0/36.D0*cf**2*nf
     &     - 5491.D0/27.D0*z2*cf**2*nf
     &     + 1348.D0/3.D0*z3*cf**2*nf
     &     - 8236.D0/27.D0*z4*cf**2*nf
     &     - 352.D0/9.D0*z2*z3*cf**2*nf
     &     - 592.D0/9.D0*z5*cf**2*nf
     &     + 142883.D0/486.D0*ca*cf*nf
     &     + 40862.D0/81.D0*z2*ca*cf*nf
     &     - 18314.D0/81.D0*z3*ca*cf*nf
     &     - 1244.D0/27.D0*z4*ca*cf*nf
     &     - 56.D0/3.D0*z2*z3*ca*cf*nf
     &     + 8.D0/3.D0*z5*ca*cf*nf
*

*
     &     - 9517.D0/486.D0*cf*nf2
     &     - 860.D0/27.D0*z2*cf*nf2
     &     - 152.D0/81.D0*z3*cf*nf2
     &     - 80.D0/27.D0*z4*cf*nf2
*
       DL1 = LOG (1.D0-Y)
*
       X2NP3C =   DL1**6 * C3A5/6.D0 + DL1**5 * C3A4/5.D0 
     ,          + DL1**4 * C3A3/4.D0 + DL1**3 * C3A2/3.D0 
     ,          + DL1**2 * C3A1/2.D0 + DL1 * C3A0 + C3DELT
       else
       X2NP3C = 64.D0*dabc2n*fl11
     &     + 160.D0*z2*dabc2n*fl11
     &     + 224.D0/3.D0*z3*dabc2n*fl11
     &     - 16.D0*z4*dabc2n*fl11
     &     - 1280.D0/3.D0*z5*dabc2n*fl11
       endif
*
       RETURN
       END
*
* =================================================================av==
      END MODULE XC2NS3E
