       MODULE xc3ns3e
       USE XC2NS3P
       USE XC3NS3P
       CONTAINS
*
* ..File: xc3ns3e.f    F3 NU+NU(BAR) ETC  
*
*
* ..The exact 3-loop MS(bar) coefficient function for the non-singlet
*    structure function  F_3^(W^(+)+W^(-))  in charged-current DIS 
*    at  mu_r = mu_f = Q.  The expansion parameter is  alpha_s/(4 pi).
* 
* ..The distributions (in the mathematical sense) are given as in eq.
*    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.
*    The name-endings A, B, and C of the functions below correspond to 
*    the kernel superscripts [2], [3], and [1] in that equation.
*
* ..The code uses the package of Gehrmann and Remiddi for the harmonic
*    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296,
*    upgraded to weight 5 (T. Gehrmann, private communication)
* 
* ..Reference:  A. Vogt, J. Vermaseren and S. Moch,
*               arXiv:0812.4168 [hep-ph]
*
* =====================================================================
*
       SUBROUTINE SET_C3SOFT_N3LO(NF)
       IMPLICIT REAL*8 (A - Z)
       INTEGER NF
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0, 
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
*
* ..The soft-gluon coefficients for use in X3NS3B and X3NS3C
*
       COMMON / C3SOFTN3LO / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5 

       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
* 


       C3A5 = 
     &     + 8.D0*cf**3
       C3A4 =
     &     - 30.D0*cf**3
     &     - 220.D0/9.D0*ca*cf**2
     &     + 40.D0/9.D0*cf**2*nf
       C3A3 =
     &     - 36.D0*cf**3
     &     - 96.D0*z2*cf**3
     &     + 1732.D0/9.D0*ca*cf**2
     &     - 32.D0*z2*ca*cf**2
     &     + 484.D0/27.D0*ca**2*cf
     &     - 280.D0/9.D0*cf**2*nf
     &     - 176.D0/27.D0*ca*cf*nf
     &     + 16.D0/27.D0*cf*nf2
       C3A2 =
     &     + 279.D0/2.D0*cf**3
     &     + 288.D0*z2*cf**3
     &     + 16.D0*z3*cf**3
     &     - 8425.D0/18.D0*ca*cf**2
     &     + 724.D0/3.D0*z2*ca*cf**2
     &     + 240.D0*z3*ca*cf**2
     &     - 4649.D0/27.D0*ca**2*cf
     &     + 88.D0/3.D0*z2*ca**2*cf
     &     + 683.D0/9.D0*cf**2*nf
     &     - 112.D0/3.D0*z2*cf**2*nf
     &     + 1552.D0/27.D0*ca*cf*nf
     &     - 16.D0/3.D0*z2*ca*cf*nf
     &     - 116.D0/27.D0*cf*nf2
       C3A1 =
     &     + 187.D0/2.D0*cf**3
     &     + 240.D0*z2*cf**3
     &     - 360.D0*z3*cf**3
     &     + 188.D0*z4*cf**3
     &     - 5563.D0/18.D0*ca*cf**2
     &     - 972.D0*z2*ca*cf**2
     &     - 160.D0/3.D0*z3*ca*cf**2
     &     + 382.D0*z4*ca*cf**2
     &     + 50689.D0/81.D0*ca**2*cf
     &     - 680.D0/3.D0*z2*ca**2*cf
     &     - 264.D0*z3*ca**2*cf
     &     + 88.D0*z4*ca**2*cf
     &     + 83.D0/9.D0*cf**2*nf
     &     + 168.D0*z2*cf**2*nf
     &     + 112.D0/3.D0*z3*cf**2*nf
     &     - 15062.D0/81.D0*ca*cf*nf
     &     + 512.D0/9.D0*z2*ca*cf*nf
     &     + 16.D0*z3*ca*cf*nf
     &     + 940.D0/81.D0*cf*nf2
     &     - 32.D0/9.D0*z2*cf*nf2
       C3A0 =
     &     - 1001.D0/8.D0*cf**3
     &     - 429.D0*z2*cf**3
     &     + 274.D0*z3*cf**3
     &     - 525.D0*z4*cf**3
     &     + 32.D0*z2*z3*cf**3
     &     + 432.D0*z5*cf**3
     &     + 16981.D0/24.D0*ca*cf**2
     &     + 26885.D0/27.D0*z2*ca*cf**2
     &     - 3304.D0/9.D0*z3*ca*cf**2
     &     - 1045.D0/2.D0*z4*ca*cf**2
     &     - 400.D0*z2*z3*ca*cf**2
     &     - 120.D0*z5*ca*cf**2
     &     - 599375.D0/729.D0*ca**2*cf
     &     + 32126.D0/81.D0*z2*ca**2*cf
     &     + 21032.D0/27.D0*z3*ca**2*cf
     &     - 326.D0/3.D0*z4*ca**2*cf
     &     - 176.D0/3.D0*z2*z3*ca**2*cf
     &     - 232.D0*z5*ca**2*cf
     &     - 2003.D0/108.D0*cf**2*nf
     &     - 4226.D0/27.D0*z2*cf**2*nf
     &     - 60.D0*z3*cf**2*nf
     &     + 40.D0*z4*cf**2*nf
     &     + 160906.D0/729.D0*ca*cf*nf
     &     - 9920.D0/81.D0*z2*ca*cf*nf
     &     - 776.D0/9.D0*z3*ca*cf*nf
     &     + 104.D0/3.D0*z4*ca*cf*nf
     &     - 8714.D0/729.D0*cf*nf2
     &     + 232.D0/27.D0*z2*cf*nf2
     &     - 32.D0/27.D0*z3*cf*nf2

       END SUBROUTINE
*
* ..This is the regular piece, using the HPLOG5 code. The `M' in the
*    name, for `minus', refers to its basis on odd Mellin-N moments.
*
       FUNCTION X3NM3A (X, DL, NF, V)
*
       IMPLICIT REAL*8 (A - Z)
       COMPLEX*16 HC1, HC2, HC3, HC4, HC5 
       INTEGER NF, NF2, N1, N2, NW, V
       PARAMETER ( N1 = -1, N2 = 1, NW = 5 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2), 
     ,           HC4(N1:N2,N1:N2,N1:N2,N1:N2), 
     ,           HC5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2) 
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2), 
     ,           HR4(N1:N2,N1:N2,N1:N2,N1:N2), 
     ,           HR5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2) 
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2), 
     ,           HI4(N1:N2,N1:N2,N1:N2,N1:N2), 
     ,           HI5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2) 
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0, 
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
*
* ..The soft-gluon coefficients for use in X3NS3B and X3NS3C
*
       COMMON / C3SOFTN3LO / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5 
*
* ...Colour factors
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF

       ! V = 1 is the valence contribution. V = 0 is the minus. 
       ! In the paper it is stated that the fl02 term in the parametrised 
       ! version has to be turned off to make it a minus. It is also 
       ! stated that the fl02 term arrives due to the dabc strucutre.
       DABC2N = 5.D0/18.D0 * NF

*
* ...Some abbreviations
*
       DX = 1.D0/X
       DM = DMVAL(X, DL) !1.D0/(1.D0-X)
       DP = 1.D0/(1.D0+X)
       !DL  = LOG (X)
       DL1 = DL1VAL(X, DL) !LOG (1.D0-X)

!     Use large x expansion when close to x=1
      if(((1.0d0-x).lt.1d-6)) then
         X3NM3A =  X3NM3A_large_x(X, DL, NF)
      return
      endif

*
* ...Harmonic polylogs (HPLs) up to weight 5 by Gehrmann and Remiddi
*
       CALL HPLOG5 (X, NW, HC1,HC2,HC3,HC4,HC5, HR1,HR2,HR3,HR4,HR5,
     ,             HI1,HI2,HI3,HI4,HI5, N1, N2)
*
* ...The coefficient function in terms of the harmonic polylogs
*    (without the delta(1-x) part, but with the soft contribution)
*
       if(V.eq.1) then
      c3qq3 =
     &  + dabc2n * (  - 70016.D0/27.D0 + 70016.D0/27.D0*x - 3584.D0/
     &    3.D0*z5 - 640.D0*z5*x - 1552.D0/3.D0*z4 - 1072.D0/3.D0*z4*x
     &     + 5824.D0/9.D0*z4*x**2 + 704.D0/3.D0*z3 - 3200.D0/9.D0*z3*x
     &     - 42880.D0/27.D0*z3*x**2 + 37504.D0/27.D0*z2 - 32608.D0/27.D0
     &    *z2*x + 64.D0/3.D0*z2*x**2 - 1856.D0/3.D0*z2*z3 - 320.D0/3.D0
     &    *z2*z3*x + 1184.D0/3.D0*Hr1(-1)*z3 + 1184.D0/3.D0*Hr1(-1)*z3*
     &    x + 6016.D0/9.D0*Hr1(-1)*z3*x**2 + 6016.D0/9.D0*Hr1(-1)*z3*dx
     &     + 3776.D0/3.D0*Hr1(-1)*z2 + 3776.D0/3.D0*Hr1(-1)*z2*x + 8576.
     &    D0/9.D0*Hr1(-1)*z2*x**2 + 8576.D0/9.D0*Hr1(-1)*z2*dx - 67072.D
     &    0/27.D0*Hr1(0) + 6544.D0/3.D0*Hr1(0)*x - 1088.D0*Hr1(0)*z4 - 
     &    1280.D0/3.D0*Hr1(0)*z4*x + 1088.D0/3.D0*Hr1(0)*z3 - 64.D0*
     &    Hr1(0)*z3*x - 7040.D0/9.D0*Hr1(0)*z3*x**2 - 3968.D0/9.D0*Hr1(
     &    0)*z2 + 1472.D0/9.D0*Hr1(0)*z2*x - 34304.D0/27.D0*Hr1(0)*z2*
     &    x**2 - 61840.D0/27.D0*Hr1(1) + 61840.D0/27.D0*Hr1(1)*x + 896.D
     &    0/3.D0*Hr1(1)*z3 - 896.D0/3.D0*Hr1(1)*z3*x - 3584.D0/9.D0*
     &    Hr1(1)*z3*x**2 )
      c3qq3 = c3qq3 + dabc2n * ( 3584.D0/9.D0*Hr1(1)*z3*dx + 1312.D0
     &    /9.D0*Hr1(1)*z2 - 1312.D0/9.D0*Hr1(1)*z2*x - 8576.D0/27.D0*
     &    Hr1(1)*z2*x**2 + 8576.D0/27.D0*Hr1(1)*z2*dx - 256.D0*Hr2(-1,
     &    -1)*z2 - 256.D0*Hr2(-1,-1)*z2*x - 1792.D0/3.D0*Hr2(-1,-1)*z2*
     &    x**2 - 1792.D0/3.D0*Hr2(-1,-1)*z2*dx - 7072.D0/27.D0*Hr2(-1,0
     &    ) - 7072.D0/27.D0*Hr2(-1,0)*x + 64.D0/3.D0*Hr2(-1,0)*x**2 + 
     &    64.D0/3.D0*Hr2(-1,0)*dx + 640.D0*Hr2(-1,0)*z2 + 640.D0*Hr2(-1
     &    ,0)*z2*x + 2048.D0/3.D0*Hr2(-1,0)*z2*x**2 + 2048.D0/3.D0*Hr2(
     &    -1,0)*z2*dx - 1216.D0/3.D0*Hr2(0,-1)*z3 + 1216.D0/3.D0*Hr2(0,
     &    -1)*z3*x + 480.D0*Hr2(0,-1)*z2 + 160.D0/3.D0*Hr2(0,-1)*z2*x
     &     + 1280.D0/3.D0*Hr2(0,-1)*z2*x**2 + 512.D0*Hr2(0,-1)*z2*dx - 
     &    42944.D0/27.D0*Hr2(0,0) + 2464.D0/27.D0*Hr2(0,0)*x - 64.D0/3.D
     &    0*Hr2(0,0)*x**2 + 2432.D0/3.D0*Hr2(0,0)*z3 + 192.D0*Hr2(0,0)*
     &    z2 - 512.D0/3.D0*Hr2(0,0)*z2*x - 1664.D0/3.D0*Hr2(0,0)*z2*
     &    x**2 - 44576.D0/27.D0*Hr2(0,1) + 32608.D0/27.D0*Hr2(0,1)*x + 
     &    1792.D0/3.D0*Hr2(0,1)*z3 )
      c3qq3 = c3qq3 + dabc2n * ( 1792.D0/3.D0*Hr2(0,1)*z3*x + 288.D0
     &    *Hr2(0,1)*z2 + 96.D0*Hr2(0,1)*z2*x - 256.D0/3.D0*Hr2(0,1)*z2*
     &    x**2 + 512.D0/3.D0*Hr2(0,1)*z2*dx - 1024.D0*Hr2(1,0) + 1024.D0
     &    *Hr2(1,0)*x - 256.D0/3.D0*Hr2(1,0)*z2 + 256.D0/3.D0*Hr2(1,0)*
     &    z2*x - 896.D0/9.D0*Hr2(1,0)*z2*x**2 + 896.D0/9.D0*Hr2(1,0)*z2
     &    *dx - 14560.D0/9.D0*Hr2(1,1) + 14560.D0/9.D0*Hr2(1,1)*x + 320.
     &    D0/3.D0*Hr2(1,1)*z2 - 320.D0/3.D0*Hr2(1,1)*z2*x - 1280.D0/9.D0
     &    *Hr2(1,1)*z2*x**2 + 1280.D0/9.D0*Hr2(1,1)*z2*dx - 4736.D0/9.D0
     &    *Hr3(-1,-1,0) - 4736.D0/9.D0*Hr3(-1,-1,0)*x + 17152.D0/27.D0*
     &    Hr3(-1,-1,0)*x**2 + 17152.D0/27.D0*Hr3(-1,-1,0)*dx - 128.D0*
     &    Hr3(-1,0,0) - 128.D0*Hr3(-1,0,0)*x - 17152.D0/27.D0*Hr3(-1,0,
     &    0)*x**2 - 17152.D0/27.D0*Hr3(-1,0,0)*dx - 13696.D0/9.D0*Hr3(
     &    -1,0,1) - 13696.D0/9.D0*Hr3(-1,0,1)*x - 17152.D0/27.D0*Hr3(-1
     &    ,0,1)*x**2 - 17152.D0/27.D0*Hr3(-1,0,1)*dx + 1280.D0/3.D0*
     &    Hr3(0,-1,-1)*z2 - 1280.D0/3.D0*Hr3(0,-1,-1)*z2*x - 704.D0*
     &    Hr3(0,-1,0) )
      c3qq3 = c3qq3 + dabc2n * ( 4544.D0/3.D0*Hr3(0,-1,0)*x - 17152.
     &    D0/27.D0*Hr3(0,-1,0)*x**2 - 256.D0*Hr3(0,-1,0)*z2 + 256.D0*
     &    Hr3(0,-1,0)*z2*x + 64.D0/3.D0*Hr3(0,0,-1)*z2 + 2240.D0/3.D0*
     &    Hr3(0,0,-1)*z2*x - 128.D0/9.D0*Hr3(0,0,0) - 1856.D0/3.D0*Hr3(
     &    0,0,0)*x + 17152.D0/27.D0*Hr3(0,0,0)*x**2 + 512.D0*Hr3(0,0,0)
     &    *z2 + 384.D0*Hr3(0,0,0)*z2*x - 2368.D0/9.D0*Hr3(0,0,1) - 1472.
     &    D0/9.D0*Hr3(0,0,1)*x + 17152.D0/27.D0*Hr3(0,0,1)*x**2 + 704.D0
     &    /3.D0*Hr3(0,0,1)*z2 + 320.D0*Hr3(0,0,1)*z2*x - 1312.D0/3.D0*
     &    Hr3(0,1,0) - 384.D0*Hr3(0,1,0)*x + 128.D0/3.D0*Hr3(0,1,0)*z2
     &     + 128.D0/3.D0*Hr3(0,1,0)*z2*x - 6560.D0/9.D0*Hr3(0,1,1) - 
     &    6560.D0/9.D0*Hr3(0,1,1)*x + 640.D0/3.D0*Hr3(0,1,1)*z2 + 640.D0
     &    /3.D0*Hr3(0,1,1)*z2*x - 1696.D0/9.D0*Hr3(1,0,0) + 1696.D0/9.D0
     &    *Hr3(1,0,0)*x + 352.D0/3.D0*Hr3(1,0,1) - 352.D0/3.D0*Hr3(1,0,
     &    1)*x - 352.D0/3.D0*Hr3(1,1,0) + 352.D0/3.D0*Hr3(1,1,0)*x + 
     &    640.D0/3.D0*Hr4(-1,-1,-1,0) + 640.D0/3.D0*Hr4(-1,-1,-1,0)*x
     &     - 2560.D0/9.D0*Hr4(-1,-1,-1,0)*x**2 )
      c3qq3 = c3qq3 + dabc2n * (  - 2560.D0/9.D0*Hr4(-1,-1,-1,0)*dx
     &     - 32.D0*Hr4(-1,-1,0,0) - 32.D0*Hr4(-1,-1,0,0)*x + 1792.D0/3.D
     &    0*Hr4(-1,-1,0,0)*x**2 + 1792.D0/3.D0*Hr4(-1,-1,0,0)*dx + 1088.
     &    D0/3.D0*Hr4(-1,-1,0,1) + 1088.D0/3.D0*Hr4(-1,-1,0,1)*x + 4096.
     &    D0/9.D0*Hr4(-1,-1,0,1)*x**2 + 4096.D0/9.D0*Hr4(-1,-1,0,1)*dx
     &     - 192.D0*Hr4(-1,0,-1,0) - 192.D0*Hr4(-1,0,-1,0)*x + 512.D0/3.
     &    D0*Hr4(-1,0,-1,0)*x**2 + 512.D0/3.D0*Hr4(-1,0,-1,0)*dx - 448.D
     &    0/3.D0*Hr4(-1,0,0,0) - 448.D0/3.D0*Hr4(-1,0,0,0)*x - 3584.D0/
     &    9.D0*Hr4(-1,0,0,0)*x**2 - 3584.D0/9.D0*Hr4(-1,0,0,0)*dx - 672.
     &    D0*Hr4(-1,0,0,1) - 672.D0*Hr4(-1,0,0,1)*x - 1792.D0/3.D0*Hr4(
     &    -1,0,0,1)*x**2 - 1792.D0/3.D0*Hr4(-1,0,0,1)*dx - 320.D0*Hr4(
     &    -1,0,1,0) - 320.D0*Hr4(-1,0,1,0)*x - 512.D0/3.D0*Hr4(-1,0,1,0
     &    )*x**2 - 512.D0/3.D0*Hr4(-1,0,1,0)*dx - 1280.D0/3.D0*Hr4(-1,0
     &    ,1,1) - 1280.D0/3.D0*Hr4(-1,0,1,1)*x - 2560.D0/9.D0*Hr4(-1,0,
     &    1,1)*x**2 - 2560.D0/9.D0*Hr4(-1,0,1,1)*dx - 704.D0*Hr4(0,-1,
     &    -1,0) )
      c3qq3 = c3qq3 + dabc2n * ( 320.D0*Hr4(0,-1,-1,0)*x + 512.D0/3.
     &    D0*Hr4(0,-1,-1,0)*x**2 + 1024.D0/3.D0*Hr4(0,-1,-1,0)*dx - 448.
     &    D0/3.D0*Hr4(0,-1,0,0) + 64.D0*Hr4(0,-1,0,0)*x - 4352.D0/9.D0*
     &    Hr4(0,-1,0,0)*x**2 - 1024.D0/3.D0*Hr4(0,-1,0,0)*dx - 832.D0*
     &    Hr4(0,-1,0,1) + 320.D0/3.D0*Hr4(0,-1,0,1)*x - 1024.D0/3.D0*
     &    Hr4(0,-1,0,1)*x**2 - 1024.D0/3.D0*Hr4(0,-1,0,1)*dx + 320.D0/3.
     &    D0*Hr4(0,0,-1,0) - 64.D0/3.D0*Hr4(0,0,-1,0)*x - 512.D0/9.D0*
     &    Hr4(0,0,-1,0)*x**2 + 1024.D0/3.D0*Hr4(0,0,0,0)*x**2 - 256.D0/
     &    3.D0*Hr4(0,0,0,1) + 512.D0/3.D0*Hr4(0,0,0,1)*x + 4480.D0/9.D0
     &    *Hr4(0,0,0,1)*x**2 - 32.D0*Hr4(0,0,1,0) + 928.D0/3.D0*Hr4(0,0
     &    ,1,0)*x + 512.D0/3.D0*Hr4(0,0,1,0)*x**2 - 160.D0/3.D0*Hr4(0,0
     &    ,1,1) + 480.D0*Hr4(0,0,1,1)*x + 2560.D0/9.D0*Hr4(0,0,1,1)*
     &    x**2 + 352.D0/3.D0*Hr4(0,1,0,0) + 416.D0/3.D0*Hr4(0,1,0,0)*x
     &     + 896.D0/9.D0*Hr4(0,1,0,0)*x**2 + 64.D0*Hr4(0,1,0,1) + 64.D0
     &    *Hr4(0,1,0,1)*x - 64.D0*Hr4(0,1,1,0) - 64.D0*Hr4(0,1,1,0)*x
     &     - 128.D0*Hr4(1,0,-1,0) )
      c3qq3 = c3qq3 + dabc2n * ( 128.D0*Hr4(1,0,-1,0)*x + 640.D0/3.D
     &    0*Hr4(1,0,0,0) - 640.D0/3.D0*Hr4(1,0,0,0)*x + 512.D0/9.D0*
     &    Hr4(1,0,0,0)*x**2 - 512.D0/9.D0*Hr4(1,0,0,0)*dx + 352.D0/3.D0
     &    *Hr4(1,0,0,1) - 352.D0/3.D0*Hr4(1,0,0,1)*x + 128.D0/9.D0*Hr4(
     &    1,0,0,1)*x**2 - 128.D0/9.D0*Hr4(1,0,0,1)*dx + 32.D0*Hr4(1,0,1
     &    ,0) - 32.D0*Hr4(1,0,1,0)*x - 416.D0/3.D0*Hr4(1,1,0,0) + 416.D0
     &    /3.D0*Hr4(1,1,0,0)*x + 896.D0/9.D0*Hr4(1,1,0,0)*x**2 - 896.D0/
     &    9.D0*Hr4(1,1,0,0)*dx + 1280.D0/3.D0*Hr5(0,-1,-1,-1,0) - 1280.D
     &    0/3.D0*Hr5(0,-1,-1,-1,0)*x - 1856.D0/3.D0*Hr5(0,-1,-1,0,0) + 
     &    1856.D0/3.D0*Hr5(0,-1,-1,0,0)*x - 640.D0/3.D0*Hr5(0,-1,-1,0,1
     &    ) + 640.D0/3.D0*Hr5(0,-1,-1,0,1)*x - 896.D0/3.D0*Hr5(0,-1,0,
     &    -1,0) + 896.D0/3.D0*Hr5(0,-1,0,-1,0)*x + 896.D0/3.D0*Hr5(0,-1
     &    ,0,0,0) - 896.D0/3.D0*Hr5(0,-1,0,0,0)*x + 448.D0/3.D0*Hr5(0,
     &    -1,0,0,1) - 448.D0/3.D0*Hr5(0,-1,0,0,1)*x - 128.D0/3.D0*Hr5(0
     &    ,-1,0,1,0) + 128.D0/3.D0*Hr5(0,-1,0,1,0)*x - 1664.D0/3.D0*
     &    Hr5(0,0,-1,-1,0) )
      c3qq3 = c3qq3 + dabc2n * ( 1664.D0/3.D0*Hr5(0,0,-1,-1,0)*x + 
     &    896.D0/3.D0*Hr5(0,0,-1,0,0) - 1792.D0/3.D0*Hr5(0,0,-1,0,0)*x
     &     - 896.D0/3.D0*Hr5(0,0,-1,0,1) - 1408.D0/3.D0*Hr5(0,0,-1,0,1)
     &    *x + 128.D0/3.D0*Hr5(0,0,0,-1,0) - 640.D0/3.D0*Hr5(0,0,0,-1,0
     &    )*x - 256.D0*Hr5(0,0,0,0,0) - 1408.D0/3.D0*Hr5(0,0,0,0,1) - 
     &    384.D0*Hr5(0,0,0,0,1)*x - 192.D0*Hr5(0,0,0,1,0) - 192.D0*Hr5(
     &    0,0,0,1,0)*x - 320.D0*Hr5(0,0,0,1,1) - 320.D0*Hr5(0,0,0,1,1)*
     &    x - 64.D0/3.D0*Hr5(0,0,1,0,0) - 64.D0/3.D0*Hr5(0,0,1,0,0)*x
     &     + 128.D0/3.D0*Hr5(0,0,1,0,1) - 128.D0/3.D0*Hr5(0,0,1,0,1)*x
     &     - 128.D0/3.D0*Hr5(0,0,1,1,0) + 128.D0/3.D0*Hr5(0,0,1,1,0)*x
     &     - 256.D0/3.D0*Hr5(0,1,0,-1,0) - 256.D0/3.D0*Hr5(0,1,0,-1,0)*
     &    x + 256.D0/3.D0*Hr5(0,1,0,0,0) + 256.D0/3.D0*Hr5(0,1,0,0,0)*x
     &     + 64.D0*Hr5(0,1,0,0,1) + 64.D0*Hr5(0,1,0,0,1)*x + 64.D0/3.D0
     &    *Hr5(0,1,0,1,0) + 64.D0/3.D0*Hr5(0,1,0,1,0)*x - 192.D0*Hr5(0,
     &     1,1,0,0) - 192.D0*Hr5(0,1,1,0,0)*x )
      else
         c3qq3 = 0d0
      endif

      c3qq3 = c3qq3 + cf*ca**2 * ( 593903.D0/1458.D0 + 1498007.D0/1458.D
     &    0*x + 112.D0/3.D0*z5 - 88.D0/3.D0*z5*x - 466.D0/3.D0*z4 + 62.D
     &    0*z4*x - 216.D0*z4*x**2 - 472.D0/3.D0*dp*z5 - 205.D0/3.D0*dp*
     &    z4 - 599375.D0/729.D0*dm - 536.D0/3.D0*dm*z5 + 14.D0*dm*z4 - 
     &    10700.D0/27.D0*z3 - 11744.D0/27.D0*z3*x - 3046.D0/9.D0*z3*
     &    x**2 + 760.D0/3.D0*z3*dp + 5908.D0/27.D0*z3*dm - 36680.D0/81.D
     &    0*z2 - 12152.D0/27.D0*z2*x + 1828.D0/9.D0*z2*x**2 + 17696.D0/
     &    81.D0*z2*dp + 76418.D0/81.D0*z2*dm - 956.D0/3.D0*z2*z3 + 132.D
     &    0*z2*z3*x + 1040.D0/3.D0*z2*z3*dp + 208.D0/3.D0*z2*z3*dm + 70.
     &    D0/3.D0*Hr1(-1)*z4 - 118.D0/3.D0*Hr1(-1)*z4*x - 188.D0/3.D0*
     &    Hr1(-1)*dp*z4 + 4328.D0/9.D0*Hr1(-1)*z3 + 2908.D0/9.D0*Hr1(-1
     &    )*z3*x + 192.D0*Hr1(-1)*z3*x**2 + 192.D0*Hr1(-1)*z3*dx - 1408.
     &    D0/9.D0*Hr1(-1)*z3*dp + 10856.D0/27.D0*Hr1(-1)*z2 + 4060.D0/
     &    27.D0*Hr1(-1)*z2*x + 134.D0/3.D0*Hr1(-1)*z2*x**2 + 134.D0/3.D0
     &    *Hr1(-1)*z2*dx - 6976.D0/27.D0*Hr1(-1)*z2*dp + 87283.D0/81.D0
     &    *Hr1(0) )
      c3qq3 = c3qq3 + cf*ca**2 * ( 17675.D0/27.D0*Hr1(0)*x + 72.D0*Hr1(
     &    0)*z4 + 20.D0/3.D0*Hr1(0)*z4*x - 2374.D0/9.D0*Hr1(0)*dp - 320.
     &    D0/3.D0*Hr1(0)*dp*z4 - 132599.D0/81.D0*Hr1(0)*dm - 520.D0/3.D0
     &    *Hr1(0)*dm*z4 - 7112.D0/9.D0*Hr1(0)*z3 - 184.D0/3.D0*Hr1(0)*
     &    z3*x - 292.D0*Hr1(0)*z3*x**2 + 2216.D0/9.D0*Hr1(0)*z3*dp + 
     &    3200.D0/9.D0*Hr1(0)*z3*dm - 7660.D0/27.D0*Hr1(0)*z2 - 500.D0*
     &    Hr1(0)*z2*x + 256.D0/9.D0*Hr1(0)*z2*x**2 + 2176.D0/27.D0*Hr1(
     &    0)*z2*dp + 13396.D0/27.D0*Hr1(0)*z2*dm + 85403.D0/81.D0*Hr1(1
     &    ) - 10387.D0/81.D0*Hr1(1)*x + 446.D0*Hr1(1)*z4 + 366.D0*Hr1(1
     &    )*z4*x - 50689.D0/81.D0*Hr1(1)*dm - 812.D0*Hr1(1)*dm*z4 + 8.D0
     &    /9.D0*Hr1(1)*z3 - 640.D0/9.D0*Hr1(1)*z3*x - 100.D0*Hr1(1)*z3*
     &    x**2 + 100.D0*Hr1(1)*z3*dx + 800.D0/9.D0*Hr1(1)*z3*dm - 1088.D
     &    0/9.D0*Hr1(1)*z2 - 2576.D0/9.D0*Hr1(1)*z2*x + 658.D0/9.D0*
     &    Hr1(1)*z2*x**2 + 134.D0/9.D0*Hr1(1)*z2*dx + 4184.D0/9.D0*Hr1(
     &    1)*z2*dm + 3472.D0/3.D0*Hr2(-1,-1)*z3 - 2320.D0/3.D0*Hr2(-1,
     &    -1)*z3*x )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 5792.D0/3.D0*Hr2(-1,-1)*z3*dp - 
     &    3976.D0/9.D0*Hr2(-1,-1)*z2 - 2204.D0/9.D0*Hr2(-1,-1)*z2*x - 
     &    256.D0*Hr2(-1,-1)*z2*x**2 - 256.D0*Hr2(-1,-1)*z2*dx + 1760.D0/
     &    9.D0*Hr2(-1,-1)*z2*dp + 28648.D0/81.D0*Hr2(-1,0) + 46328.D0/
     &    81.D0*Hr2(-1,0)*x + 1828.D0/9.D0*Hr2(-1,0)*x**2 + 1756.D0/9.D0
     &    *Hr2(-1,0)*dx + 17032.D0/81.D0*Hr2(-1,0)*dp - 1616.D0/3.D0*
     &    Hr2(-1,0)*z3 + 1040.D0/3.D0*Hr2(-1,0)*z3*x + 2656.D0/3.D0*
     &    Hr2(-1,0)*z3*dp + 5056.D0/9.D0*Hr2(-1,0)*z2 + 3884.D0/9.D0*
     &    Hr2(-1,0)*z2*x + 160.D0*Hr2(-1,0)*z2*x**2 + 160.D0*Hr2(-1,0)*
     &    z2*dx - 1160.D0/9.D0*Hr2(-1,0)*z2*dp - 444.D0*Hr2(0,-1)*z3 + 
     &    636.D0*Hr2(0,-1)*z3*x + 3664.D0/3.D0*Hr2(0,-1)*z3*dp - 384.D0
     &    *Hr2(0,-1)*z3*dm + 7144.D0/9.D0*Hr2(0,-1)*z2 - 340.D0/9.D0*
     &    Hr2(0,-1)*z2*x + 256.D0*Hr2(0,-1)*z2*x**2 - 2288.D0/9.D0*Hr2(
     &    0,-1)*z2*dp - 560.D0/3.D0*Hr2(0,-1)*z2*dm + 37204.D0/81.D0*
     &    Hr2(0,0) + 70292.D0/81.D0*Hr2(0,0)*x - 1828.D0/9.D0*Hr2(0,0)*
     &    x**2 )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 24554.D0/81.D0*Hr2(0,0)*dp - 
     &    34070.D0/27.D0*Hr2(0,0)*dm + 728.D0/3.D0*Hr2(0,0)*z3 - 192.D0
     &    *Hr2(0,0)*z3*dp - 192.D0*Hr2(0,0)*z3*dm - 5840.D0/9.D0*Hr2(0,
     &    0)*z2 - 1076.D0/3.D0*Hr2(0,0)*z2*x - 124.D0*Hr2(0,0)*z2*x**2
     &     + 2324.D0/9.D0*Hr2(0,0)*z2*dp + 3968.D0/9.D0*Hr2(0,0)*z2*dm
     &     + 21776.D0/27.D0*Hr2(0,1) + 12152.D0/27.D0*Hr2(0,1)*x - 340.D
     &    0/3.D0*Hr2(0,1)*dp - 22634.D0/27.D0*Hr2(0,1)*dm + 656.D0/3.D0
     &    *Hr2(0,1)*z3 + 432.D0*Hr2(0,1)*z3*x + 736.D0/3.D0*Hr2(0,1)*z3
     &    *dp - 576.D0*Hr2(0,1)*z3*dm - 2044.D0/9.D0*Hr2(0,1)*z2 - 940.D
     &    0/9.D0*Hr2(0,1)*z2*x + 144.D0*Hr2(0,1)*z2*dp + 2780.D0/9.D0*
     &    Hr2(0,1)*z2*dm + 6866.D0/27.D0*Hr2(1,0) + 266.D0/27.D0*Hr2(1,
     &    0)*x - 7870.D0/27.D0*Hr2(1,0)*dm + 1688.D0/3.D0*Hr2(1,0)*z3
     &     + 1016.D0/3.D0*Hr2(1,0)*z3*x - 2704.D0/3.D0*Hr2(1,0)*z3*dm
     &     - 1772.D0/9.D0*Hr2(1,0)*z2 - 1988.D0/9.D0*Hr2(1,0)*z2*x + 36.
     &    D0*Hr2(1,0)*z2*x**2 - 36.D0*Hr2(1,0)*z2*dx + 3640.D0/9.D0*
     &    Hr2(1,0)*z2*dm )
      c3qq3 = c3qq3 + cf*ca**2 * ( 12248.D0/27.D0*Hr2(1,1) - 1096.D0/27.
     &    D0*Hr2(1,1)*x - 9298.D0/27.D0*Hr2(1,1)*dm + 416.D0*Hr2(1,1)*
     &    z3 + 352.D0*Hr2(1,1)*z3*x - 768.D0*Hr2(1,1)*z3*dm - 1040.D0/9.
     &    D0*Hr2(1,1)*z2 - 1232.D0/9.D0*Hr2(1,1)*z2*x + 2200.D0/9.D0*
     &    Hr2(1,1)*z2*dm - 1216.D0*Hr3(-1,-1,-1)*z2 + 704.D0*Hr3(-1,-1,
     &    -1)*z2*x + 1920.D0*Hr3(-1,-1,-1)*z2*dp + 752.D0/9.D0*Hr3(-1,
     &    -1,0) - 3416.D0/9.D0*Hr3(-1,-1,0)*x + 268.D0/9.D0*Hr3(-1,-1,0
     &    )*x**2 + 268.D0/9.D0*Hr3(-1,-1,0)*dx - 4288.D0/9.D0*Hr3(-1,-1
     &    ,0)*dp + 3808.D0/3.D0*Hr3(-1,-1,0)*z2 - 2848.D0/3.D0*Hr3(-1,
     &    -1,0)*z2*x - 6656.D0/3.D0*Hr3(-1,-1,0)*z2*dp + 776.D0*Hr3(-1,
     &    0,-1)*z2 - 520.D0*Hr3(-1,0,-1)*z2*x - 1296.D0*Hr3(-1,0,-1)*z2
     &    *dp - 8456.D0/27.D0*Hr3(-1,0,0) + 7004.D0/27.D0*Hr3(-1,0,0)*x
     &     + 788.D0/9.D0*Hr3(-1,0,0)*x**2 + 788.D0/9.D0*Hr3(-1,0,0)*dx
     &     + 15568.D0/27.D0*Hr3(-1,0,0)*dp - 1712.D0/3.D0*Hr3(-1,0,0)*
     &    z2 + 1040.D0/3.D0*Hr3(-1,0,0)*z2*x + 2752.D0/3.D0*Hr3(-1,0,0)
     &    *z2*dp )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 9728.D0/27.D0*Hr3(-1,0,1) - 9184.D
     &    0/27.D0*Hr3(-1,0,1)*x - 268.D0/9.D0*Hr3(-1,0,1)*x**2 - 268.D0/
     &    9.D0*Hr3(-1,0,1)*dx + 544.D0/27.D0*Hr3(-1,0,1)*dp + 256.D0/3.D
     &    0*Hr3(-1,0,1)*z2 - 256.D0/3.D0*Hr3(-1,0,1)*z2*x - 512.D0/3.D0
     &    *Hr3(-1,0,1)*z2*dp + 1232.D0/3.D0*Hr3(0,-1,-1)*z2 - 2096.D0/3.
     &    D0*Hr3(0,-1,-1)*z2*x - 1312.D0*Hr3(0,-1,-1)*z2*dp + 544.D0*
     &    Hr3(0,-1,-1)*z2*dm - 1544.D0/27.D0*Hr3(0,-1,0) + 15824.D0/27.D
     &    0*Hr3(0,-1,0)*x - 268.D0/9.D0*Hr3(0,-1,0)*x**2 + 352.D0/3.D0*
     &    Hr3(0,-1,0)*dx + 10864.D0/27.D0*Hr3(0,-1,0)*dp - 784.D0/3.D0*
     &    Hr3(0,-1,0)*dm - 1784.D0/3.D0*Hr3(0,-1,0)*z2 + 1880.D0/3.D0*
     &    Hr3(0,-1,0)*z2*x + 4048.D0/3.D0*Hr3(0,-1,0)*z2*dp - 192.D0*
     &    Hr3(0,-1,0)*z2*dm - 1084.D0/3.D0*Hr3(0,0,-1)*z2 + 1100.D0/3.D0
     &    *Hr3(0,0,-1)*z2*x + 2048.D0/3.D0*Hr3(0,0,-1)*z2*dp + 128.D0/3.
     &    D0*Hr3(0,0,-1)*z2*dm + 8078.D0/27.D0*Hr3(0,0,0) - 218.D0/27.D0
     &    *Hr3(0,0,0)*x - 788.D0/9.D0*Hr3(0,0,0)*x**2 - 7408.D0/27.D0*
     &    Hr3(0,0,0)*dp )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 2060.D0/3.D0*Hr3(0,0,0)*dm + 320.D
     &    0/3.D0*Hr3(0,0,0)*z2 - 72.D0*Hr3(0,0,0)*z2*x - 512.D0/3.D0*
     &    Hr3(0,0,0)*z2*dp + 64.D0/3.D0*Hr3(0,0,0)*z2*dm + 6116.D0/27.D0
     &    *Hr3(0,0,1) + 500.D0*Hr3(0,0,1)*x - 524.D0/9.D0*Hr3(0,0,1)*
     &    x**2 - 272.D0/27.D0*Hr3(0,0,1)*dp - 11492.D0/27.D0*Hr3(0,0,1)
     &    *dm - 340.D0/3.D0*Hr3(0,0,1)*z2 + 380.D0/3.D0*Hr3(0,0,1)*z2*x
     &     + 704.D0/3.D0*Hr3(0,0,1)*z2*dp + 64.D0/3.D0*Hr3(0,0,1)*z2*dm
     &     + 1796.D0/9.D0*Hr3(0,1,0) + 1864.D0/9.D0*Hr3(0,1,0)*x + 88.D0
     &    *Hr3(0,1,0)*x**2 - 2644.D0/9.D0*Hr3(0,1,0)*dm - 128.D0*Hr3(0,
     &    1,0)*z2 + 32.D0/3.D0*Hr3(0,1,0)*z2*x + 512.D0/3.D0*Hr3(0,1,0)
     &    *z2*dp + 176.D0/3.D0*Hr3(0,1,0)*z2*dm + 520.D0/3.D0*Hr3(0,1,1
     &    ) + 172.D0*Hr3(0,1,1)*x - 1936.D0/9.D0*Hr3(0,1,1)*dm - 136.D0/
     &    3.D0*Hr3(0,1,1)*z2 + 248.D0/3.D0*Hr3(0,1,1)*z2*x + 128.D0*
     &    Hr3(0,1,1)*z2*dp - 32.D0/3.D0*Hr3(0,1,1)*z2*dm - 1328.D0/3.D0
     &    *Hr3(1,0,-1)*z2 - 560.D0/3.D0*Hr3(1,0,-1)*z2*x + 1888.D0/3.D0
     &    *Hr3(1,0,-1)*z2*dm )
      c3qq3 = c3qq3 + cf*ca**2 * ( 1912.D0/9.D0*Hr3(1,0,0) + 208.D0/9.D0
     &    *Hr3(1,0,0)*x - 2192.D0/9.D0*Hr3(1,0,0)*dm + 392.D0/3.D0*Hr3(
     &    1,0,0)*z2 - 184.D0/3.D0*Hr3(1,0,0)*z2*x - 208.D0/3.D0*Hr3(1,0
     &    ,0)*z2*dm + 712.D0/9.D0*Hr3(1,0,1) + 868.D0/9.D0*Hr3(1,0,1)*x
     &     - 88.D0*Hr3(1,0,1)*x**2 - 680.D0/3.D0*Hr3(1,0,1)*dm - 40.D0/
     &    3.D0*Hr3(1,0,1)*z2 - 40.D0/3.D0*Hr3(1,0,1)*z2*x + 80.D0/3.D0*
     &    Hr3(1,0,1)*z2*dm + 256.D0/9.D0*Hr3(1,1,0) + 112.D0/9.D0*Hr3(1
     &    ,1,0)*x + 88.D0*Hr3(1,1,0)*x**2 + 104.D0/9.D0*Hr3(1,1,0)*dm
     &     - 16.D0*Hr3(1,1,0)*z2 - 80.D0*Hr3(1,1,0)*z2*x + 96.D0*Hr3(1,
     &    1,0)*z2*dm + 484.D0/9.D0*Hr3(1,1,1) + 484.D0/9.D0*Hr3(1,1,1)*
     &    x - 968.D0/9.D0*Hr3(1,1,1)*dm + 32.D0/3.D0*Hr3(1,1,1)*z2 + 32.
     &    D0/3.D0*Hr3(1,1,1)*z2*x - 64.D0/3.D0*Hr3(1,1,1)*z2*dm - 1424.D
     &    0/9.D0*Hr4(-1,-1,-1,0) + 2120.D0/9.D0*Hr4(-1,-1,-1,0)*x + 
     &    3520.D0/9.D0*Hr4(-1,-1,-1,0)*dp + 5272.D0/9.D0*Hr4(-1,-1,0,0)
     &     - 844.D0/9.D0*Hr4(-1,-1,0,0)*x + 128.D0*Hr4(-1,-1,0,0)*x**2
     &     + 128.D0*Hr4(-1,-1,0,0)*dx )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 5984.D0/9.D0*Hr4(-1,-1,0,0)*dp + 
     &    1088.D0/3.D0*Hr4(-1,-1,0,1) + 1088.D0/3.D0*Hr4(-1,-1,0,1)*x
     &     + 256.D0*Hr4(-1,-1,0,1)*x**2 + 256.D0*Hr4(-1,-1,0,1)*dx + 
     &    1888.D0/9.D0*Hr4(-1,0,-1,0) - 2056.D0/9.D0*Hr4(-1,0,-1,0)*x
     &     - 3872.D0/9.D0*Hr4(-1,0,-1,0)*dp - 4720.D0/9.D0*Hr4(-1,0,0,0
     &    ) + 1264.D0/9.D0*Hr4(-1,0,0,0)*x - 32.D0*Hr4(-1,0,0,0)*x**2
     &     - 32.D0*Hr4(-1,0,0,0)*dx + 5912.D0/9.D0*Hr4(-1,0,0,0)*dp - 
     &    4640.D0/9.D0*Hr4(-1,0,0,1) - 4288.D0/9.D0*Hr4(-1,0,0,1)*x - 
     &    128.D0*Hr4(-1,0,0,1)*x**2 - 128.D0*Hr4(-1,0,0,1)*dx + 352.D0/
     &    9.D0*Hr4(-1,0,0,1)*dp - 192.D0*Hr4(-1,0,1,0) - 192.D0*Hr4(-1,
     &    0,1,0)*x - 2048.D0/9.D0*Hr4(-1,0,1,1) - 2752.D0/9.D0*Hr4(-1,0
     &    ,1,1)*x - 704.D0/9.D0*Hr4(-1,0,1,1)*dp + 2800.D0/9.D0*Hr4(0,
     &    -1,-1,0) - 280.D0/9.D0*Hr4(0,-1,-1,0)*x - 3872.D0/9.D0*Hr4(0,
     &    -1,-1,0)*dp - 288.D0*Hr4(0,-1,-1,0)*dm - 5584.D0/9.D0*Hr4(0,
     &    -1,0,0) + 3472.D0/9.D0*Hr4(0,-1,0,0)*x - 128.D0*Hr4(0,-1,0,0)
     &    *x**2 )
      c3qq3 = c3qq3 + cf*ca**2 * ( 6128.D0/9.D0*Hr4(0,-1,0,0)*dp - 416.D
     &    0/3.D0*Hr4(0,-1,0,0)*dm - 5744.D0/9.D0*Hr4(0,-1,0,1) + 200.D0/
     &    9.D0*Hr4(0,-1,0,1)*x - 256.D0*Hr4(0,-1,0,1)*x**2 + 352.D0/9.D0
     &    *Hr4(0,-1,0,1)*dp + 128.D0/3.D0*Hr4(0,-1,0,1)*dm - 1480.D0/9.D
     &    0*Hr4(0,0,-1,0) + 2920.D0/9.D0*Hr4(0,0,-1,0)*x - 64.D0*Hr4(0,
     &    0,-1,0)*x**2 + 3920.D0/9.D0*Hr4(0,0,-1,0)*dp - 856.D0/3.D0*
     &    Hr4(0,0,-1,0)*dm + 4616.D0/9.D0*Hr4(0,0,0,0) + 64.D0*Hr4(0,0,
     &    0,0)*x**2 - 2972.D0/9.D0*Hr4(0,0,0,0)*dp - 2972.D0/9.D0*Hr4(0
     &    ,0,0,0)*dm + 4360.D0/9.D0*Hr4(0,0,0,1) + 1076.D0/3.D0*Hr4(0,0
     &    ,0,1)*x + 60.D0*Hr4(0,0,0,1)*x**2 - 1648.D0/9.D0*Hr4(0,0,0,1)
     &    *dp - 3292.D0/9.D0*Hr4(0,0,0,1)*dm + 56.D0*Hr4(0,0,1,0) + 188.
     &    D0*Hr4(0,0,1,0)*x - 84.D0*Hr4(0,0,1,0)*dm + 476.D0/9.D0*Hr4(0
     &    ,0,1,1) + 928.D0/3.D0*Hr4(0,0,1,1)*x + 352.D0/9.D0*Hr4(0,0,1,
     &    1)*dp - 896.D0/9.D0*Hr4(0,0,1,1)*dm + 1352.D0/9.D0*Hr4(0,1,0,
     &    0) + 8.D0/9.D0*Hr4(0,1,0,0)*x + 68.D0*Hr4(0,1,0,0)*x**2 - 16.D
     &    0*Hr4(0,1,0,0)*dp )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 544.D0/9.D0*Hr4(0,1,0,0)*dm + 644.
     &    D0/9.D0*Hr4(0,1,0,1) + 800.D0/9.D0*Hr4(0,1,0,1)*x - 844.D0/9.D
     &    0*Hr4(0,1,0,1)*dm - 572.D0/9.D0*Hr4(0,1,1,0) - 764.D0/9.D0*
     &    Hr4(0,1,1,0)*x + 772.D0/9.D0*Hr4(0,1,1,0)*dm + 352.D0/3.D0*
     &    Hr4(1,0,-1,0) + 416.D0/3.D0*Hr4(1,0,-1,0)*x - 64.D0*Hr4(1,0,
     &    -1,0)*x**2 + 64.D0*Hr4(1,0,-1,0)*dx - 752.D0/3.D0*Hr4(1,0,-1,
     &    0)*dm + 2144.D0/9.D0*Hr4(1,0,0,0) - 736.D0/9.D0*Hr4(1,0,0,0)*
     &    x + 32.D0*Hr4(1,0,0,0)*x**2 - 32.D0*Hr4(1,0,0,0)*dx - 1336.D0/
     &    9.D0*Hr4(1,0,0,0)*dm + 452.D0/3.D0*Hr4(1,0,0,1) + 176.D0*Hr4(
     &    1,0,0,1)*x - 68.D0*Hr4(1,0,0,1)*x**2 + 68.D0*Hr4(1,0,0,1)*dx
     &     - 944.D0/3.D0*Hr4(1,0,0,1)*dm - 128.D0/3.D0*Hr4(1,0,1,0) - 
     &    128.D0/3.D0*Hr4(1,0,1,0)*x + 80.D0*Hr4(1,0,1,0)*dm + 124.D0/3.
     &    D0*Hr4(1,0,1,1) + 40.D0*Hr4(1,0,1,1)*x - 88.D0*Hr4(1,0,1,1)*
     &    dm - 272.D0/9.D0*Hr4(1,1,0,0) - 920.D0/9.D0*Hr4(1,1,0,0)*x + 
     &    68.D0*Hr4(1,1,0,0)*x**2 - 68.D0*Hr4(1,1,0,0)*dx + 1144.D0/9.D0
     &    *Hr4(1,1,0,0)*dm )
      c3qq3 = c3qq3 + cf*ca**2 * ( 328.D0/9.D0*Hr4(1,1,0,1) + 172.D0/9.D
     &    0*Hr4(1,1,0,1)*x - 440.D0/9.D0*Hr4(1,1,0,1)*dm - 700.D0/9.D0*
     &    Hr4(1,1,1,0) - 532.D0/9.D0*Hr4(1,1,1,0)*x + 1232.D0/9.D0*Hr4(
     &    1,1,1,0)*dm + 672.D0*Hr5(-1,-1,-1,0,0) - 416.D0*Hr5(-1,-1,-1,
     &    0,0)*x - 1088.D0*Hr5(-1,-1,-1,0,0)*dp + 1216.D0*Hr5(-1,-1,-1,
     &    0,1) - 704.D0*Hr5(-1,-1,-1,0,1)*x - 1920.D0*Hr5(-1,-1,-1,0,1)
     &    *dp - 32.D0*Hr5(-1,-1,0,-1,0) + 32.D0*Hr5(-1,-1,0,-1,0)*x + 
     &    64.D0*Hr5(-1,-1,0,-1,0)*dp - 1312.D0/3.D0*Hr5(-1,-1,0,0,0) + 
     &    1120.D0/3.D0*Hr5(-1,-1,0,0,0)*x + 2432.D0/3.D0*Hr5(-1,-1,0,0,
     &    0)*dp - 1120.D0*Hr5(-1,-1,0,0,1) + 864.D0*Hr5(-1,-1,0,0,1)*x
     &     + 1984.D0*Hr5(-1,-1,0,0,1)*dp - 896.D0/3.D0*Hr5(-1,-1,0,1,0)
     &     + 896.D0/3.D0*Hr5(-1,-1,0,1,0)*x + 1792.D0/3.D0*Hr5(-1,-1,0,
     &    1,0)*dp - 1280.D0/3.D0*Hr5(-1,-1,0,1,1) + 1280.D0/3.D0*Hr5(-1
     &    ,-1,0,1,1)*x + 2560.D0/3.D0*Hr5(-1,-1,0,1,1)*dp - 16.D0*Hr5(
     &    -1,0,-1,-1,0) + 16.D0*Hr5(-1,0,-1,-1,0)*x + 32.D0*Hr5(-1,0,-1
     &    ,-1,0)*dp )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 416.D0*Hr5(-1,0,-1,0,0) + 288.D0*
     &    Hr5(-1,0,-1,0,0)*x + 704.D0*Hr5(-1,0,-1,0,0)*dp - 784.D0*Hr5(
     &    -1,0,-1,0,1) + 528.D0*Hr5(-1,0,-1,0,1)*x + 1312.D0*Hr5(-1,0,
     &    -1,0,1)*dp - 160.D0/3.D0*Hr5(-1,0,0,-1,0) - 32.D0/3.D0*Hr5(-1
     &    ,0,0,-1,0)*x + 128.D0/3.D0*Hr5(-1,0,0,-1,0)*dp + 560.D0/3.D0*
     &    Hr5(-1,0,0,0,0) - 368.D0/3.D0*Hr5(-1,0,0,0,0)*x - 928.D0/3.D0
     &    *Hr5(-1,0,0,0,0)*dp + 464.D0*Hr5(-1,0,0,0,1) - 304.D0*Hr5(-1,
     &    0,0,0,1)*x - 768.D0*Hr5(-1,0,0,0,1)*dp + 392.D0/3.D0*Hr5(-1,0
     &    ,0,1,0) - 392.D0/3.D0*Hr5(-1,0,0,1,0)*x - 784.D0/3.D0*Hr5(-1,
     &    0,0,1,0)*dp + 640.D0/3.D0*Hr5(-1,0,0,1,1) - 640.D0/3.D0*Hr5(
     &    -1,0,0,1,1)*x - 1280.D0/3.D0*Hr5(-1,0,0,1,1)*dp + 176.D0/3.D0
     &    *Hr5(-1,0,1,0,0) - 272.D0/3.D0*Hr5(-1,0,1,0,0)*x - 448.D0/3.D0
     &    *Hr5(-1,0,1,0,0)*dp + 80.D0/3.D0*Hr5(-1,0,1,0,1) - 80.D0/3.D0
     &    *Hr5(-1,0,1,0,1)*x - 160.D0/3.D0*Hr5(-1,0,1,0,1)*dp - 80.D0/3.
     &    D0*Hr5(-1,0,1,1,0) + 80.D0/3.D0*Hr5(-1,0,1,1,0)*x + 160.D0/3.D
     &    0*Hr5(-1,0,1,1,0)*dp )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 272.D0/3.D0*Hr5(0,-1,-1,-1,0) - 
     &    144.D0*Hr5(0,-1,-1,-1,0)*x + 704.D0/3.D0*Hr5(0,-1,-1,-1,0)*dm
     &     - 524.D0/3.D0*Hr5(0,-1,-1,0,0) + 484.D0*Hr5(0,-1,-1,0,0)*x
     &     + 2128.D0/3.D0*Hr5(0,-1,-1,0,0)*dp - 1312.D0/3.D0*Hr5(0,-1,
     &    -1,0,0)*dm - 456.D0*Hr5(0,-1,-1,0,1) + 1880.D0/3.D0*Hr5(0,-1,
     &    -1,0,1)*x + 1312.D0*Hr5(0,-1,-1,0,1)*dp - 1280.D0/3.D0*Hr5(0,
     &    -1,-1,0,1)*dm + 232.D0/3.D0*Hr5(0,-1,0,-1,0) + 280.D0/3.D0*
     &    Hr5(0,-1,0,-1,0)*x - 64.D0/3.D0*Hr5(0,-1,0,-1,0)*dp - 512.D0/
     &    3.D0*Hr5(0,-1,0,-1,0)*dm + 608.D0/3.D0*Hr5(0,-1,0,0,0) - 832.D
     &    0/3.D0*Hr5(0,-1,0,0,0)*x - 1424.D0/3.D0*Hr5(0,-1,0,0,0)*dp + 
     &    320.D0/3.D0*Hr5(0,-1,0,0,0)*dm + 540.D0*Hr5(0,-1,0,0,1) - 508.
     &    D0*Hr5(0,-1,0,0,1)*x - 3472.D0/3.D0*Hr5(0,-1,0,0,1)*dp + 96.D0
     &    *Hr5(0,-1,0,0,1)*dm + 584.D0/3.D0*Hr5(0,-1,0,1,0) - 328.D0/3.D
     &    0*Hr5(0,-1,0,1,0)*x - 928.D0/3.D0*Hr5(0,-1,0,1,0)*dp - 256.D0/
     &    3.D0*Hr5(0,-1,0,1,0)*dm + 800.D0/3.D0*Hr5(0,-1,0,1,1) - 160.D0
     &    *Hr5(0,-1,0,1,1)*x )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 1280.D0/3.D0*Hr5(0,-1,0,1,1)*dp
     &     - 320.D0/3.D0*Hr5(0,-1,0,1,1)*dm + 728.D0/3.D0*Hr5(0,0,-1,-1
     &    ,0) + 808.D0/3.D0*Hr5(0,0,-1,-1,0)*x - 128.D0/3.D0*Hr5(0,0,-1
     &    ,-1,0)*dp - 512.D0*Hr5(0,0,-1,-1,0)*dm + 520.D0/3.D0*Hr5(0,0,
     &    -1,0,0) - 256.D0*Hr5(0,0,-1,0,0)*x - 1120.D0/3.D0*Hr5(0,0,-1,
     &    0,0)*dp + 64.D0*Hr5(0,0,-1,0,0)*dm + 1448.D0/3.D0*Hr5(0,0,-1,
     &    0,1) - 232.D0*Hr5(0,0,-1,0,1)*x - 704.D0*Hr5(0,0,-1,0,1)*dp
     &     - 896.D0/3.D0*Hr5(0,0,-1,0,1)*dm + 40.D0/3.D0*Hr5(0,0,0,-1,0
     &    ) - 56.D0*Hr5(0,0,0,-1,0)*x - 160.D0/3.D0*Hr5(0,0,0,-1,0)*dp
     &     + 32.D0*Hr5(0,0,0,-1,0)*dm - 80.D0*Hr5(0,0,0,0,0) + 64.D0*
     &    Hr5(0,0,0,0,0)*dp + 64.D0*Hr5(0,0,0,0,0)*dm - 280.D0/3.D0*
     &    Hr5(0,0,0,0,1) + 72.D0*Hr5(0,0,0,0,1)*x + 160.D0*Hr5(0,0,0,0,
     &    1)*dp - 32.D0*Hr5(0,0,0,0,1)*dm - 28.D0*Hr5(0,0,0,1,0) + 36.D0
     &    *Hr5(0,0,0,1,0)*x + 64.D0*Hr5(0,0,0,1,0)*dp - 32.D0*Hr5(0,0,0
     &    ,1,0)*dm - 140.D0/3.D0*Hr5(0,0,0,1,1) + 60.D0*Hr5(0,0,0,1,1)*
     &    x )
      c3qq3 = c3qq3 + cf*ca**2 * ( 320.D0/3.D0*Hr5(0,0,0,1,1)*dp - 160.D
     &    0/3.D0*Hr5(0,0,0,1,1)*dm - 260.D0/3.D0*Hr5(0,0,1,0,0) - 100.D0
     &    /3.D0*Hr5(0,0,1,0,0)*x + 160.D0/3.D0*Hr5(0,0,1,0,0)*dp + 352.D
     &    0/3.D0*Hr5(0,0,1,0,0)*dm - 8.D0*Hr5(0,0,1,0,1) + 8.D0*Hr5(0,0
     &    ,1,0,1)*x + 64.D0/3.D0*Hr5(0,0,1,0,1)*dp + 8.D0*Hr5(0,0,1,1,0
     &    ) - 8.D0*Hr5(0,0,1,1,0)*x - 64.D0/3.D0*Hr5(0,0,1,1,0)*dp + 
     &    560.D0/3.D0*Hr5(0,1,0,-1,0) + 144.D0*Hr5(0,1,0,-1,0)*x + 64.D0
     &    /3.D0*Hr5(0,1,0,-1,0)*dp - 1216.D0/3.D0*Hr5(0,1,0,-1,0)*dm - 
     &    440.D0/3.D0*Hr5(0,1,0,0,0) - 472.D0/3.D0*Hr5(0,1,0,0,0)*x - 
     &    128.D0/3.D0*Hr5(0,1,0,0,0)*dp + 1040.D0/3.D0*Hr5(0,1,0,0,0)*
     &    dm + 548.D0/3.D0*Hr5(0,1,0,0,1) + 108.D0*Hr5(0,1,0,0,1)*x - 
     &    224.D0/3.D0*Hr5(0,1,0,0,1)*dp - 752.D0/3.D0*Hr5(0,1,0,0,1)*dm
     &     - 52.D0/3.D0*Hr5(0,1,0,1,0) + 4.D0*Hr5(0,1,0,1,0)*x + 64.D0/
     &    3.D0*Hr5(0,1,0,1,0)*dp + 16.D0*Hr5(0,1,0,1,0)*dm + 8.D0/3.D0*
     &    Hr5(0,1,0,1,1) + 8.D0/3.D0*Hr5(0,1,0,1,1)*x - 16.D0/3.D0*Hr5(
     &    0,1,0,1,1)*dm )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 156.D0*Hr5(0,1,1,0,0) - 596.D0/3.D
     &    0*Hr5(0,1,1,0,0)*x - 128.D0/3.D0*Hr5(0,1,1,0,0)*dp + 896.D0/3.
     &    D0*Hr5(0,1,1,0,0)*dm - 32.D0/3.D0*Hr5(0,1,1,0,1)*x - 32.D0/3.D
     &    0*Hr5(0,1,1,0,1)*dp + 32.D0/3.D0*Hr5(0,1,1,0,1)*dm - 8.D0/3.D0
     &    *Hr5(0,1,1,1,0) + 8.D0*Hr5(0,1,1,1,0)*x + 32.D0/3.D0*Hr5(0,1,
     &    1,1,0)*dp - 16.D0/3.D0*Hr5(0,1,1,1,0)*dm + 224.D0*Hr5(1,0,-1,
     &    -1,0) + 224.D0*Hr5(1,0,-1,-1,0)*x - 448.D0*Hr5(1,0,-1,-1,0)*
     &    dm + 784.D0/3.D0*Hr5(1,0,-1,0,0) + 400.D0/3.D0*Hr5(1,0,-1,0,0
     &    )*x - 1184.D0/3.D0*Hr5(1,0,-1,0,0)*dm + 1664.D0/3.D0*Hr5(1,0,
     &    -1,0,1) + 896.D0/3.D0*Hr5(1,0,-1,0,1)*x - 2560.D0/3.D0*Hr5(1,
     &    0,-1,0,1)*dm + 160.D0*Hr5(1,0,0,-1,0) + 96.D0*Hr5(1,0,0,-1,0)
     &    *x - 256.D0*Hr5(1,0,0,-1,0)*dm - 560.D0/3.D0*Hr5(1,0,0,0,0)
     &     - 368.D0/3.D0*Hr5(1,0,0,0,0)*x + 928.D0/3.D0*Hr5(1,0,0,0,0)*
     &    dm - 24.D0*Hr5(1,0,0,0,1) + 104.D0*Hr5(1,0,0,0,1)*x - 80.D0*
     &    Hr5(1,0,0,0,1)*dm + 208.D0/3.D0*Hr5(1,0,0,1,0) + 208.D0/3.D0*
     &    Hr5(1,0,0,1,0)*x )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 416.D0/3.D0*Hr5(1,0,0,1,0)*dm + 
     &    320.D0/3.D0*Hr5(1,0,0,1,1) + 320.D0/3.D0*Hr5(1,0,0,1,1)*x - 
     &    640.D0/3.D0*Hr5(1,0,0,1,1)*dm - 144.D0*Hr5(1,0,1,0,0) - 144.D0
     &    *Hr5(1,0,1,0,0)*x + 288.D0*Hr5(1,0,1,0,0)*dm + 16.D0/3.D0*
     &    Hr5(1,0,1,0,1) + 16.D0/3.D0*Hr5(1,0,1,0,1)*x - 32.D0/3.D0*
     &    Hr5(1,0,1,0,1)*dm - 16.D0/3.D0*Hr5(1,0,1,1,0) - 16.D0/3.D0*
     &    Hr5(1,0,1,1,0)*x + 32.D0/3.D0*Hr5(1,0,1,1,0)*dm + 992.D0/3.D0
     &    *Hr5(1,1,0,-1,0) + 608.D0/3.D0*Hr5(1,1,0,-1,0)*x - 1600.D0/3.D
     &    0*Hr5(1,1,0,-1,0)*dm - 928.D0/3.D0*Hr5(1,1,0,0,0) - 736.D0/3.D
     &    0*Hr5(1,1,0,0,0)*x + 1664.D0/3.D0*Hr5(1,1,0,0,0)*dm + 496.D0/
     &    3.D0*Hr5(1,1,0,0,1) + 496.D0/3.D0*Hr5(1,1,0,0,1)*x - 992.D0/3.
     &    D0*Hr5(1,1,0,0,1)*dm - 16.D0*Hr5(1,1,0,1,0) - 16.D0*Hr5(1,1,0
     &    ,1,0)*x + 32.D0*Hr5(1,1,0,1,0)*dm + 32.D0/3.D0*Hr5(1,1,0,1,1)
     &     + 32.D0/3.D0*Hr5(1,1,0,1,1)*x - 64.D0/3.D0*Hr5(1,1,0,1,1)*dm
     &     - 640.D0/3.D0*Hr5(1,1,1,0,0) - 640.D0/3.D0*Hr5(1,1,1,0,0)*x
     &     + 1280.D0/3.D0*Hr5(1,1,1,0,0)*dm )
      c3qq3 = c3qq3 + cf*ca**2 * (  - 32.D0/3.D0*Hr5(1,1,1,0,1) - 32.D0/
     &    3.D0*Hr5(1,1,1,0,1)*x + 64.D0/3.D0*Hr5(1,1,1,0,1)*dm )
      c3qq3 = c3qq3 + cf**2*ca * (  - 200323.D0/54.D0 + 268193.D0/108.D0
     &    *x - 2078.D0/3.D0*z5 + 442.D0/3.D0*z5*x + 9076.D0/9.D0*z4 + 
     &    8479.D0/9.D0*z4*x + 796.D0/3.D0*z4*x**2 + 976.D0*dp*z5 + 1226.
     &    D0/3.D0*dp*z4 + 16981.D0/24.D0*dm + 4456.D0/3.D0*dm*z5 - 
     &    12128.D0/9.D0*dm*z4 + 14717.D0/27.D0*z3 - 7453.D0/27.D0*z3*x
     &     + 11764.D0/9.D0*z3*x**2 - 1460.D0/3.D0*z3*dp + 22334.D0/27.D0
     &    *z3*dm + 66641.D0/81.D0*z2 - 193733.D0/81.D0*z2*x - 3284.D0/9.
     &    D0*z2*x**2 - 36904.D0/81.D0*z2*dp + 8753.D0/27.D0*z2*dm + 
     &    4312.D0/3.D0*z2*z3 - 2200.D0/3.D0*z2*z3*x - 5008.D0/3.D0*z2*
     &    z3*dp - 416.D0*z2*z3*dm - 970.D0/3.D0*Hr1(-1)*z4 + 358.D0/3.D0
     &    *Hr1(-1)*z4*x + 1328.D0/3.D0*Hr1(-1)*dp*z4 - 9718.D0/9.D0*
     &    Hr1(-1)*z3 - 12590.D0/9.D0*Hr1(-1)*z3*x - 736.D0*Hr1(-1)*z3*
     &    x**2 - 736.D0*Hr1(-1)*z3*dx - 2116.D0/9.D0*Hr1(-1)*z3*dp - 
     &    30766.D0/27.D0*Hr1(-1)*z2 - 18362.D0/27.D0*Hr1(-1)*z2*x - 
     &    1244.D0/3.D0*Hr1(-1)*z2*x**2 - 1244.D0/3.D0*Hr1(-1)*z2*dx + 
     &    12944.D0/27.D0*Hr1(-1)*z2*dp )
      c3qq3 = c3qq3 + cf**2*ca * (  - 1010281.D0/324.D0*Hr1(0) + 479407.
     &    D0/324.D0*Hr1(0)*x - 332.D0/3.D0*Hr1(0)*z4 + 1112.D0/3.D0*
     &    Hr1(0)*z4*x + 6218.D0/9.D0*Hr1(0)*dp + 1412.D0/3.D0*Hr1(0)*dp
     &    *z4 + 85535.D0/54.D0*Hr1(0)*dm + 628.D0/3.D0*Hr1(0)*dm*z4 + 
     &    18166.D0/9.D0*Hr1(0)*z3 + 1130.D0/3.D0*Hr1(0)*z3*x + 2864.D0/
     &    3.D0*Hr1(0)*z3*x**2 - 4444.D0/9.D0*Hr1(0)*z3*dp - 4516.D0/9.D0
     &    *Hr1(0)*z3*dm + 395.D0/27.D0*Hr1(0)*z2 - 583.D0*Hr1(0)*z2*x
     &     + 3128.D0/9.D0*Hr1(0)*z2*x**2 - 2354.D0/27.D0*Hr1(0)*z2*dp
     &     + 36088.D0/27.D0*Hr1(0)*z2*dm - 35255.D0/12.D0*Hr1(1) + 
     &    33449.D0/12.D0*Hr1(1)*x - 534.D0*Hr1(1)*z4 - 674.D0*Hr1(1)*z4
     &    *x + 5563.D0/18.D0*Hr1(1)*dm + 1208.D0*Hr1(1)*dm*z4 - 4234.D0/
     &    9.D0*Hr1(1)*z3 - 1414.D0/9.D0*Hr1(1)*z3*x + 656.D0/3.D0*Hr1(1
     &    )*z3*x**2 - 656.D0/3.D0*Hr1(1)*z3*dx + 5108.D0/9.D0*Hr1(1)*z3
     &    *dm - 2294.D0/9.D0*Hr1(1)*z2 - 6386.D0/9.D0*Hr1(1)*z2*x - 604.
     &    D0/9.D0*Hr1(1)*z2*x**2 - 1244.D0/9.D0*Hr1(1)*z2*dx + 6448.D0/
     &    9.D0*Hr1(1)*z2*dm )
      c3qq3 = c3qq3 + cf**2*ca * (  - 14288.D0/3.D0*Hr2(-1,-1)*z3 + 
     &    9536.D0/3.D0*Hr2(-1,-1)*z3*x + 23824.D0/3.D0*Hr2(-1,-1)*z3*dp
     &     + 7676.D0/9.D0*Hr2(-1,-1)*z2 + 9772.D0/9.D0*Hr2(-1,-1)*z2*x
     &     + 944.D0*Hr2(-1,-1)*z2*x**2 + 944.D0*Hr2(-1,-1)*z2*dx + 1232.
     &    D0/9.D0*Hr2(-1,-1)*z2*dp - 39782.D0/81.D0*Hr2(-1,0) - 75574.D0
     &    /81.D0*Hr2(-1,0)*x - 3284.D0/9.D0*Hr2(-1,0)*x**2 - 2588.D0/9.D
     &    0*Hr2(-1,0)*dx - 31472.D0/81.D0*Hr2(-1,0)*dp + 7456.D0/3.D0*
     &    Hr2(-1,0)*z3 - 5296.D0/3.D0*Hr2(-1,0)*z3*x - 12752.D0/3.D0*
     &    Hr2(-1,0)*z3*dp - 14696.D0/9.D0*Hr2(-1,0)*z2 - 16336.D0/9.D0*
     &    Hr2(-1,0)*z2*x - 656.D0*Hr2(-1,0)*z2*x**2 - 656.D0*Hr2(-1,0)*
     &    z2*dx - 1496.D0/9.D0*Hr2(-1,0)*z2*dp + 5932.D0/3.D0*Hr2(0,-1)
     &    *z3 - 2940.D0*Hr2(0,-1)*z3*x - 5376.D0*Hr2(0,-1)*z3*dp + 5600.
     &    D0/3.D0*Hr2(0,-1)*z3*dm - 19988.D0/9.D0*Hr2(0,-1)*z2 - 4996.D0
     &    /9.D0*Hr2(0,-1)*z2*x - 944.D0*Hr2(0,-1)*z2*x**2 - 96.D0*Hr2(0
     &    ,-1)*z2*dx + 1912.D0/9.D0*Hr2(0,-1)*z2*dp + 916.D0*Hr2(0,-1)*
     &    z2*dm )
      c3qq3 = c3qq3 + cf**2*ca * (  - 26530.D0/81.D0*Hr2(0,0) + 43987.D0
     &    /27.D0*Hr2(0,0)*x + 3284.D0/9.D0*Hr2(0,0)*x**2 + 55048.D0/81.D
     &    0*Hr2(0,0)*dp + 8711.D0/27.D0*Hr2(0,0)*dm - 3376.D0/3.D0*Hr2(
     &    0,0)*z3 + 384.D0*Hr2(0,0)*z3*x + 3440.D0/3.D0*Hr2(0,0)*z3*dp
     &     + 1904.D0/3.D0*Hr2(0,0)*z3*dm + 4558.D0/3.D0*Hr2(0,0)*z2 + 
     &    6110.D0/9.D0*Hr2(0,0)*z2*x + 1984.D0/3.D0*Hr2(0,0)*z2*x**2 - 
     &    5932.D0/9.D0*Hr2(0,0)*z2*dp - 524.D0/9.D0*Hr2(0,0)*z2*dm - 
     &    106423.D0/81.D0*Hr2(0,1) + 193733.D0/81.D0*Hr2(0,1)*x + 784.D0
     &    /3.D0*Hr2(0,1)*dp - 41995.D0/81.D0*Hr2(0,1)*dm - 1020.D0*Hr2(
     &    0,1)*z3 - 5164.D0/3.D0*Hr2(0,1)*z3*x - 2704.D0/3.D0*Hr2(0,1)*
     &    z3*dp + 2336.D0*Hr2(0,1)*z3*dm + 608.D0/9.D0*Hr2(0,1)*z2 - 
     &    3208.D0/9.D0*Hr2(0,1)*z2*x + 16.D0*Hr2(0,1)*z2*x**2 - 32.D0*
     &    Hr2(0,1)*z2*dx - 532.D0*Hr2(0,1)*z2*dp + 3500.D0/9.D0*Hr2(0,1
     &    )*z2*dm - 26386.D0/81.D0*Hr2(1,0) + 171170.D0/81.D0*Hr2(1,0)*
     &    x - 96391.D0/81.D0*Hr2(1,0)*dm - 1896.D0*Hr2(1,0)*z3 - 1144.D0
     &    *Hr2(1,0)*z3*x )
      c3qq3 = c3qq3 + cf**2*ca * ( 3040.D0*Hr2(1,0)*z3*dm - 84.D0*Hr2(1
     &    ,0)*z2 - 196.D0/3.D0*Hr2(1,0)*z2*x + 16.D0/3.D0*Hr2(1,0)*z2*
     &    x**2 - 16.D0/3.D0*Hr2(1,0)*z2*dx + 464.D0/3.D0*Hr2(1,0)*z2*dm
     &     - 10372.D0/9.D0*Hr2(1,1) + 21634.D0/9.D0*Hr2(1,1)*x - 8425.D0
     &    /9.D0*Hr2(1,1)*dm - 1648.D0*Hr2(1,1)*z3 - 1472.D0*Hr2(1,1)*z3
     &    *x + 3120.D0*Hr2(1,1)*z3*dm - 3040.D0/9.D0*Hr2(1,1)*z2 - 880.D
     &    0/9.D0*Hr2(1,1)*z2*x + 16.D0*Hr2(1,1)*z2*x**2 - 16.D0*Hr2(1,1
     &    )*z2*dx + 3416.D0/9.D0*Hr2(1,1)*z2*dm + 4944.D0*Hr3(-1,-1,-1)
     &    *z2 - 2928.D0*Hr3(-1,-1,-1)*z2*x - 7872.D0*Hr3(-1,-1,-1)*z2*
     &    dp - 1612.D0/9.D0*Hr3(-1,-1,0) + 8908.D0/9.D0*Hr3(-1,-1,0)*x
     &     - 2488.D0/9.D0*Hr3(-1,-1,0)*x**2 - 2488.D0/9.D0*Hr3(-1,-1,0)
     &    *dx + 10880.D0/9.D0*Hr3(-1,-1,0)*dp - 15920.D0/3.D0*Hr3(-1,-1
     &    ,0)*z2 + 11696.D0/3.D0*Hr3(-1,-1,0)*z2*x + 27616.D0/3.D0*Hr3(
     &    -1,-1,0)*z2*dp - 3360.D0*Hr3(-1,0,-1)*z2 + 2240.D0*Hr3(-1,0,
     &    -1)*z2*x + 5600.D0*Hr3(-1,0,-1)*z2*dp + 22960.D0/27.D0*Hr3(-1
     &    ,0,0) )
      c3qq3 = c3qq3 + cf**2*ca * (  - 13540.D0/27.D0*Hr3(-1,0,0)*x + 
     &    376.D0/9.D0*Hr3(-1,0,0)*x**2 + 376.D0/9.D0*Hr3(-1,0,0)*dx - 
     &    36824.D0/27.D0*Hr3(-1,0,0)*dp + 7672.D0/3.D0*Hr3(-1,0,0)*z2
     &     - 4984.D0/3.D0*Hr3(-1,0,0)*z2*x - 12656.D0/3.D0*Hr3(-1,0,0)*
     &    z2*dp + 28348.D0/27.D0*Hr3(-1,0,1) + 31724.D0/27.D0*Hr3(-1,0,
     &    1)*x + 2488.D0/9.D0*Hr3(-1,0,1)*x**2 + 2488.D0/9.D0*Hr3(-1,0,
     &    1)*dx + 3376.D0/27.D0*Hr3(-1,0,1)*dp - 296.D0*Hr3(-1,0,1)*z2
     &     + 264.D0*Hr3(-1,0,1)*z2*x + 560.D0*Hr3(-1,0,1)*z2*dp - 1856.D
     &    0*Hr3(0,-1,-1)*z2 + 3104.D0*Hr3(0,-1,-1)*z2*x + 5648.D0*Hr3(0
     &    ,-1,-1)*z2*dp - 2384.D0*Hr3(0,-1,-1)*z2*dm + 9496.D0/27.D0*
     &    Hr3(0,-1,0) - 45148.D0/27.D0*Hr3(0,-1,0)*x + 2488.D0/9.D0*
     &    Hr3(0,-1,0)*x**2 - 704.D0/3.D0*Hr3(0,-1,0)*dx - 27848.D0/27.D0
     &    *Hr3(0,-1,0)*dp + 572.D0*Hr3(0,-1,0)*dm + 2464.D0*Hr3(0,-1,0)
     &    *z2 - 9136.D0/3.D0*Hr3(0,-1,0)*z2*x - 5856.D0*Hr3(0,-1,0)*z2*
     &    dp + 4048.D0/3.D0*Hr3(0,-1,0)*z2*dm + 3632.D0/3.D0*Hr3(0,0,-1
     &    )*z2 )
      c3qq3 = c3qq3 + cf**2*ca * (  - 6464.D0/3.D0*Hr3(0,0,-1)*z2*x - 
     &    3232.D0*Hr3(0,0,-1)*z2*dp + 832.D0*Hr3(0,0,-1)*z2*dm + 4447.D0
     &    /27.D0*Hr3(0,0,0) + 14665.D0/9.D0*Hr3(0,0,0)*x - 376.D0/9.D0*
     &    Hr3(0,0,0)*x**2 + 19118.D0/27.D0*Hr3(0,0,0)*dp - 7096.D0/27.D0
     &    *Hr3(0,0,0)*dm - 872.D0*Hr3(0,0,0)*z2 + 192.D0*Hr3(0,0,0)*z2*
     &    x + 944.D0*Hr3(0,0,0)*z2*dp + 368.D0*Hr3(0,0,0)*z2*dm + 9101.D
     &    0/27.D0*Hr3(0,0,1) + 583.D0*Hr3(0,0,1)*x - 640.D0/9.D0*Hr3(0,
     &    0,1)*x**2 - 3848.D0/27.D0*Hr3(0,0,1)*dp - 42290.D0/27.D0*Hr3(
     &    0,0,1)*dm + 88.D0*Hr3(0,0,1)*z2 - 792.D0*Hr3(0,0,1)*z2*x - 
     &    2720.D0/3.D0*Hr3(0,0,1)*z2*dp + 544.D0*Hr3(0,0,1)*z2*dm + 
     &    9052.D0/27.D0*Hr3(0,1,0) + 25792.D0/27.D0*Hr3(0,1,0)*x - 616.D
     &    0/3.D0*Hr3(0,1,0)*x**2 - 32.D0*Hr3(0,1,0)*dp - 36896.D0/27.D0
     &    *Hr3(0,1,0)*dm - 272.D0/3.D0*Hr3(0,1,0)*z2 - 1088.D0/3.D0*
     &    Hr3(0,1,0)*z2*x - 624.D0*Hr3(0,1,0)*z2*dp + 576.D0*Hr3(0,1,0)
     &    *z2*dm + 1520.D0/9.D0*Hr3(0,1,1) + 2948.D0/3.D0*Hr3(0,1,1)*x
     &     - 32.D0*Hr3(0,1,1)*dp )
      c3qq3 = c3qq3 + cf**2*ca * (  - 4304.D0/3.D0*Hr3(0,1,1)*dm - 96.D0
     &    *Hr3(0,1,1)*z2 - 1408.D0/3.D0*Hr3(0,1,1)*z2*x - 1456.D0/3.D0*
     &    Hr3(0,1,1)*z2*dp + 464.D0*Hr3(0,1,1)*z2*dm + 1112.D0*Hr3(1,0,
     &    -1)*z2 + 376.D0*Hr3(1,0,-1)*z2*x - 1488.D0*Hr3(1,0,-1)*z2*dm
     &     + 3020.D0/27.D0*Hr3(1,0,0) + 33152.D0/27.D0*Hr3(1,0,0)*x - 
     &    30610.D0/27.D0*Hr3(1,0,0)*dm - 3152.D0/3.D0*Hr3(1,0,0)*z2 - 
     &    560.D0/3.D0*Hr3(1,0,0)*z2*x + 3712.D0/3.D0*Hr3(1,0,0)*z2*dm
     &     + 3100.D0/9.D0*Hr3(1,0,1) + 10840.D0/9.D0*Hr3(1,0,1)*x + 616.
     &    D0/3.D0*Hr3(1,0,1)*x**2 - 11888.D0/9.D0*Hr3(1,0,1)*dm - 848.D0
     &    /3.D0*Hr3(1,0,1)*z2 - 560.D0/3.D0*Hr3(1,0,1)*z2*x + 1408.D0/3.
     &    D0*Hr3(1,0,1)*z2*dm + 5236.D0/9.D0*Hr3(1,1,0) + 3308.D0/3.D0*
     &    Hr3(1,1,0)*x - 616.D0/3.D0*Hr3(1,1,0)*x**2 - 14188.D0/9.D0*
     &    Hr3(1,1,0)*dm - 1712.D0/3.D0*Hr3(1,1,0)*z2 + 16.D0/3.D0*Hr3(1
     &    ,1,0)*z2*x + 1696.D0/3.D0*Hr3(1,1,0)*z2*dm + 364.D0*Hr3(1,1,1
     &    ) + 2828.D0/3.D0*Hr3(1,1,1)*x - 3464.D0/3.D0*Hr3(1,1,1)*dm - 
     &    752.D0/3.D0*Hr3(1,1,1)*z2 )
      c3qq3 = c3qq3 + cf**2*ca * (  - 464.D0/3.D0*Hr3(1,1,1)*z2*x + 
     &    1216.D0/3.D0*Hr3(1,1,1)*z2*dm - 392.D0/9.D0*Hr4(-1,-1,-1,0)
     &     - 3976.D0/9.D0*Hr4(-1,-1,-1,0)*x + 32.D0*Hr4(-1,-1,-1,0)*
     &    x**2 + 32.D0*Hr4(-1,-1,-1,0)*dx - 4448.D0/9.D0*Hr4(-1,-1,-1,0
     &    )*dp - 10844.D0/9.D0*Hr4(-1,-1,0,0) - 1828.D0/9.D0*Hr4(-1,-1,
     &    0,0)*x - 544.D0*Hr4(-1,-1,0,0)*x**2 - 544.D0*Hr4(-1,-1,0,0)*
     &    dx + 9808.D0/9.D0*Hr4(-1,-1,0,0)*dp - 2624.D0/3.D0*Hr4(-1,-1,
     &    0,1) - 3920.D0/3.D0*Hr4(-1,-1,0,1)*x - 928.D0*Hr4(-1,-1,0,1)*
     &    x**2 - 928.D0*Hr4(-1,-1,0,1)*dx - 384.D0*Hr4(-1,-1,0,1)*dp - 
     &    1880.D0/9.D0*Hr4(-1,0,-1,0) + 4280.D0/9.D0*Hr4(-1,0,-1,0)*x
     &     - 32.D0*Hr4(-1,0,-1,0)*x**2 - 32.D0*Hr4(-1,0,-1,0)*dx + 6664.
     &    D0/9.D0*Hr4(-1,0,-1,0)*dp + 13196.D0/9.D0*Hr4(-1,0,0,0) + 
     &    1156.D0/9.D0*Hr4(-1,0,0,0)*x + 192.D0*Hr4(-1,0,0,0)*x**2 + 
     &    192.D0*Hr4(-1,0,0,0)*dx - 12148.D0/9.D0*Hr4(-1,0,0,0)*dp + 
     &    14080.D0/9.D0*Hr4(-1,0,0,1) + 17192.D0/9.D0*Hr4(-1,0,0,1)*x
     &     + 544.D0*Hr4(-1,0,0,1)*x**2 )
      c3qq3 = c3qq3 + cf**2*ca * ( 544.D0*Hr4(-1,0,0,1)*dx + 2896.D0/9.D
     &    0*Hr4(-1,0,0,1)*dp + 1744.D0/3.D0*Hr4(-1,0,1,0) + 2320.D0/3.D0
     &    *Hr4(-1,0,1,0)*x + 32.D0*Hr4(-1,0,1,0)*x**2 + 32.D0*Hr4(-1,0,
     &    1,0)*dx + 192.D0*Hr4(-1,0,1,0)*dp + 6544.D0/9.D0*Hr4(-1,0,1,1
     &    ) + 10256.D0/9.D0*Hr4(-1,0,1,1)*x + 32.D0*Hr4(-1,0,1,1)*x**2
     &     + 32.D0*Hr4(-1,0,1,1)*dx + 3712.D0/9.D0*Hr4(-1,0,1,1)*dp - 
     &    5624.D0/9.D0*Hr4(0,-1,-1,0) - 3352.D0/9.D0*Hr4(0,-1,-1,0)*x
     &     - 32.D0*Hr4(0,-1,-1,0)*x**2 - 64.D0*Hr4(0,-1,-1,0)*dx + 6736.
     &    D0/9.D0*Hr4(0,-1,-1,0)*dp + 1080.D0*Hr4(0,-1,-1,0)*dm + 14288.
     &    D0/9.D0*Hr4(0,-1,0,0) - 2624.D0/9.D0*Hr4(0,-1,0,0)*x + 544.D0
     &    *Hr4(0,-1,0,0)*x**2 + 64.D0*Hr4(0,-1,0,0)*dx - 12112.D0/9.D0*
     &    Hr4(0,-1,0,0)*dp + 8.D0*Hr4(0,-1,0,0)*dm + 17176.D0/9.D0*Hr4(
     &    0,-1,0,1) + 3320.D0/9.D0*Hr4(0,-1,0,1)*x + 928.D0*Hr4(0,-1,0,
     &    1)*x**2 + 64.D0*Hr4(0,-1,0,1)*dx + 1456.D0/9.D0*Hr4(0,-1,0,1)
     &    *dp - 376.D0*Hr4(0,-1,0,1)*dm + 4736.D0/9.D0*Hr4(0,0,-1,0) - 
     &    2480.D0/9.D0*Hr4(0,0,-1,0)*x )
      c3qq3 = c3qq3 + cf**2*ca * ( 224.D0*Hr4(0,0,-1,0)*x**2 - 8176.D0/
     &    9.D0*Hr4(0,0,-1,0)*dp + 1280.D0/3.D0*Hr4(0,0,-1,0)*dm - 7198.D
     &    0/9.D0*Hr4(0,0,0,0) + 1186.D0/3.D0*Hr4(0,0,0,0)*x - 288.D0*
     &    Hr4(0,0,0,0)*x**2 + 7732.D0/9.D0*Hr4(0,0,0,0)*dp - 92.D0/3.D0
     &    *Hr4(0,0,0,0)*dm - 8938.D0/9.D0*Hr4(0,0,0,1) - 6110.D0/9.D0*
     &    Hr4(0,0,0,1)*x - 1312.D0/3.D0*Hr4(0,0,0,1)*x**2 + 3764.D0/9.D0
     &    *Hr4(0,0,0,1)*dp - 548.D0/3.D0*Hr4(0,0,0,1)*dm + 2960.D0/9.D0
     &    *Hr4(0,0,1,0) - 688.D0/9.D0*Hr4(0,0,1,0)*x - 32.D0*Hr4(0,0,1,
     &    0)*x**2 - 84.D0*Hr4(0,0,1,0)*dp - 8068.D0/9.D0*Hr4(0,0,1,0)*
     &    dm + 2624.D0/9.D0*Hr4(0,0,1,1) - 480.D0*Hr4(0,0,1,1)*x - 32.D0
     &    *Hr4(0,0,1,1)*x**2 - 1856.D0/9.D0*Hr4(0,0,1,1)*dp - 8024.D0/9.
     &    D0*Hr4(0,0,1,1)*dm + 1516.D0/9.D0*Hr4(0,1,0,0) + 3988.D0/9.D0
     &    *Hr4(0,1,0,0)*x - 320.D0/3.D0*Hr4(0,1,0,0)*x**2 + 32.D0*Hr4(0
     &    ,1,0,0)*dp - 8048.D0/9.D0*Hr4(0,1,0,0)*dm + 2204.D0/9.D0*Hr4(
     &    0,1,0,1) + 1532.D0/9.D0*Hr4(0,1,0,1)*x - 8.D0*Hr4(0,1,0,1)*dp
     &     - 6868.D0/9.D0*Hr4(0,1,0,1)*dm )
      c3qq3 = c3qq3 + cf**2*ca * ( 1388.D0/3.D0*Hr4(0,1,1,0) + 532.D0*
     &    Hr4(0,1,1,0)*x + 8.D0*Hr4(0,1,1,0)*dp - 2884.D0/3.D0*Hr4(0,1,
     &    1,0)*dm + 3140.D0/9.D0*Hr4(0,1,1,1) + 3140.D0/9.D0*Hr4(0,1,1,
     &    1)*x - 7216.D0/9.D0*Hr4(0,1,1,1)*dm - 72.D0*Hr4(1,0,-1,0) - 
     &    856.D0/3.D0*Hr4(1,0,-1,0)*x + 192.D0*Hr4(1,0,-1,0)*x**2 - 192.
     &    D0*Hr4(1,0,-1,0)*dx + 1288.D0/3.D0*Hr4(1,0,-1,0)*dm - 380.D0/
     &    9.D0*Hr4(1,0,0,0) + 6484.D0/9.D0*Hr4(1,0,0,0)*x - 96.D0*Hr4(1
     &    ,0,0,0)*x**2 + 96.D0*Hr4(1,0,0,0)*dx - 5996.D0/9.D0*Hr4(1,0,0
     &    ,0)*dm + 1372.D0/9.D0*Hr4(1,0,0,1) + 1444.D0/9.D0*Hr4(1,0,0,1
     &    )*x + 320.D0/3.D0*Hr4(1,0,0,1)*x**2 - 320.D0/3.D0*Hr4(1,0,0,1
     &    )*dx - 2792.D0/9.D0*Hr4(1,0,0,1)*dm + 4012.D0/9.D0*Hr4(1,0,1,
     &    0) + 4156.D0/9.D0*Hr4(1,0,1,0)*x - 8096.D0/9.D0*Hr4(1,0,1,0)*
     &    dm + 2884.D0/9.D0*Hr4(1,0,1,1) + 3508.D0/9.D0*Hr4(1,0,1,1)*x
     &     - 6272.D0/9.D0*Hr4(1,0,1,1)*dm + 6044.D0/9.D0*Hr4(1,1,0,0)
     &     + 5180.D0/9.D0*Hr4(1,1,0,0)*x - 320.D0/3.D0*Hr4(1,1,0,0)*
     &    x**2 )
      c3qq3 = c3qq3 + cf**2*ca * ( 320.D0/3.D0*Hr4(1,1,0,0)*dx - 10672.D
     &    0/9.D0*Hr4(1,1,0,0)*dm + 316.D0*Hr4(1,1,0,1) + 956.D0/3.D0*
     &    Hr4(1,1,0,1)*x - 1880.D0/3.D0*Hr4(1,1,0,1)*dm + 3512.D0/9.D0*
     &    Hr4(1,1,1,0) + 2864.D0/9.D0*Hr4(1,1,1,0)*x - 6568.D0/9.D0*
     &    Hr4(1,1,1,0)*dm + 880.D0/3.D0*Hr4(1,1,1,1) + 880.D0/3.D0*Hr4(
     &    1,1,1,1)*x - 1760.D0/3.D0*Hr4(1,1,1,1)*dm + 480.D0*Hr5(-1,-1,
     &    -1,-1,0) - 288.D0*Hr5(-1,-1,-1,-1,0)*x - 768.D0*Hr5(-1,-1,-1,
     &    -1,0)*dp - 3456.D0*Hr5(-1,-1,-1,0,0) + 2144.D0*Hr5(-1,-1,-1,0
     &    ,0)*x + 5600.D0*Hr5(-1,-1,-1,0,0)*dp - 4704.D0*Hr5(-1,-1,-1,0
     &    ,1) + 2784.D0*Hr5(-1,-1,-1,0,1)*x + 7488.D0*Hr5(-1,-1,-1,0,1)
     &    *dp - 400.D0*Hr5(-1,-1,0,-1,0) + 208.D0*Hr5(-1,-1,0,-1,0)*x
     &     + 608.D0*Hr5(-1,-1,0,-1,0)*dp + 2520.D0*Hr5(-1,-1,0,0,0) - 
     &    2008.D0*Hr5(-1,-1,0,0,0)*x - 4528.D0*Hr5(-1,-1,0,0,0)*dp + 
     &    13856.D0/3.D0*Hr5(-1,-1,0,0,1) - 10496.D0/3.D0*Hr5(-1,-1,0,0,
     &    1)*x - 24352.D0/3.D0*Hr5(-1,-1,0,0,1)*dp + 3872.D0/3.D0*Hr5(
     &    -1,-1,0,1,0) )
      c3qq3 = c3qq3 + cf**2*ca * (  - 3680.D0/3.D0*Hr5(-1,-1,0,1,0)*x
     &     - 7552.D0/3.D0*Hr5(-1,-1,0,1,0)*dp + 5152.D0/3.D0*Hr5(-1,-1,
     &    0,1,1) - 4960.D0/3.D0*Hr5(-1,-1,0,1,1)*x - 10112.D0/3.D0*Hr5(
     &    -1,-1,0,1,1)*dp - 448.D0*Hr5(-1,0,-1,-1,0) + 256.D0*Hr5(-1,0,
     &    -1,-1,0)*x + 704.D0*Hr5(-1,0,-1,-1,0)*dp + 6976.D0/3.D0*Hr5(
     &    -1,0,-1,0,0) - 4768.D0/3.D0*Hr5(-1,0,-1,0,0)*x - 11744.D0/3.D0
     &    *Hr5(-1,0,-1,0,0)*dp + 3136.D0*Hr5(-1,0,-1,0,1) - 2112.D0*
     &    Hr5(-1,0,-1,0,1)*x - 5248.D0*Hr5(-1,0,-1,0,1)*dp + 624.D0*
     &    Hr5(-1,0,0,-1,0) - 336.D0*Hr5(-1,0,0,-1,0)*x - 960.D0*Hr5(-1,
     &    0,0,-1,0)*dp - 3256.D0/3.D0*Hr5(-1,0,0,0,0) + 2392.D0/3.D0*
     &    Hr5(-1,0,0,0,0)*x + 5648.D0/3.D0*Hr5(-1,0,0,0,0)*dp - 2152.D0
     &    *Hr5(-1,0,0,0,1) + 1480.D0*Hr5(-1,0,0,0,1)*x + 3632.D0*Hr5(-1
     &    ,0,0,0,1)*dp - 744.D0*Hr5(-1,0,0,1,0) + 712.D0*Hr5(-1,0,0,1,0
     &    )*x + 1456.D0*Hr5(-1,0,0,1,0)*dp - 3136.D0/3.D0*Hr5(-1,0,0,1,
     &    1) + 3040.D0/3.D0*Hr5(-1,0,0,1,1)*x + 6176.D0/3.D0*Hr5(-1,0,0
     &    ,1,1)*dp )
      c3qq3 = c3qq3 + cf**2*ca * (  - 288.D0*Hr5(-1,0,1,0,0) + 416.D0*
     &    Hr5(-1,0,1,0,0)*x + 704.D0*Hr5(-1,0,1,0,0)*dp - 592.D0/3.D0*
     &    Hr5(-1,0,1,0,1) + 592.D0/3.D0*Hr5(-1,0,1,0,1)*x + 1184.D0/3.D0
     &    *Hr5(-1,0,1,0,1)*dp - 112.D0/3.D0*Hr5(-1,0,1,1,0) + 112.D0/3.D
     &    0*Hr5(-1,0,1,1,0)*x + 224.D0/3.D0*Hr5(-1,0,1,1,0)*dp - 96.D0*
     &    Hr5(-1,0,1,1,1) + 96.D0*Hr5(-1,0,1,1,1)*x + 192.D0*Hr5(-1,0,1
     &    ,1,1)*dp - 160.D0*Hr5(0,-1,-1,-1,0) + 2528.D0/3.D0*Hr5(0,-1,
     &    -1,-1,0)*x + 800.D0*Hr5(0,-1,-1,-1,0)*dp - 2720.D0/3.D0*Hr5(0
     &    ,-1,-1,-1,0)*dm + 3896.D0/3.D0*Hr5(0,-1,-1,0,0) - 7624.D0/3.D0
     &    *Hr5(0,-1,-1,0,0)*x - 11792.D0/3.D0*Hr5(0,-1,-1,0,0)*dp + 
     &    5984.D0/3.D0*Hr5(0,-1,-1,0,0)*dm + 1776.D0*Hr5(0,-1,-1,0,1)
     &     - 8048.D0/3.D0*Hr5(0,-1,-1,0,1)*x - 5248.D0*Hr5(0,-1,-1,0,1)
     &    *dp + 5792.D0/3.D0*Hr5(0,-1,-1,0,1)*dm + 352.D0/3.D0*Hr5(0,-1
     &    ,0,-1,0) - 1952.D0/3.D0*Hr5(0,-1,0,-1,0)*x - 1792.D0/3.D0*
     &    Hr5(0,-1,0,-1,0)*dp + 2080.D0/3.D0*Hr5(0,-1,0,-1,0)*dm - 3832.
     &    D0/3.D0*Hr5(0,-1,0,0,0) )
      c3qq3 = c3qq3 + cf**2*ca * ( 5240.D0/3.D0*Hr5(0,-1,0,0,0)*x + 
     &    8416.D0/3.D0*Hr5(0,-1,0,0,0)*dp - 2272.D0/3.D0*Hr5(0,-1,0,0,0
     &    )*dm - 6440.D0/3.D0*Hr5(0,-1,0,0,1) + 7576.D0/3.D0*Hr5(0,-1,0
     &    ,0,1)*x + 14992.D0/3.D0*Hr5(0,-1,0,0,1)*dp - 2912.D0/3.D0*
     &    Hr5(0,-1,0,0,1)*dm - 752.D0*Hr5(0,-1,0,1,0) + 1936.D0/3.D0*
     &    Hr5(0,-1,0,1,0)*x + 4160.D0/3.D0*Hr5(0,-1,0,1,0)*dp + 224.D0/
     &    3.D0*Hr5(0,-1,0,1,0)*dm - 3008.D0/3.D0*Hr5(0,-1,0,1,1) + 2560.
     &    D0/3.D0*Hr5(0,-1,0,1,1)*x + 1824.D0*Hr5(0,-1,0,1,1)*dp + 352.D
     &    0/3.D0*Hr5(0,-1,0,1,1)*dm - 1696.D0/3.D0*Hr5(0,0,-1,-1,0) - 
     &    4544.D0/3.D0*Hr5(0,0,-1,-1,0)*x - 704.D0*Hr5(0,0,-1,-1,0)*dp
     &     + 2176.D0*Hr5(0,0,-1,-1,0)*dm - 2048.D0/3.D0*Hr5(0,0,-1,0,0)
     &     + 5632.D0/3.D0*Hr5(0,0,-1,0,0)*x + 2240.D0*Hr5(0,0,-1,0,0)*
     &    dp - 1088.D0*Hr5(0,0,-1,0,0)*dm - 4480.D0/3.D0*Hr5(0,0,-1,0,1
     &    ) + 4192.D0/3.D0*Hr5(0,0,-1,0,1)*x + 2880.D0*Hr5(0,0,-1,0,1)*
     &    dp + 256.D0*Hr5(0,0,-1,0,1)*dm - 272.D0/3.D0*Hr5(0,0,0,-1,0)
     &     + 2320.D0/3.D0*Hr5(0,0,0,-1,0)*x )
      c3qq3 = c3qq3 + cf**2*ca * ( 1856.D0/3.D0*Hr5(0,0,0,-1,0)*dp - 
     &    1472.D0/3.D0*Hr5(0,0,0,-1,0)*dm + 568.D0*Hr5(0,0,0,0,0) - 400.
     &    D0*Hr5(0,0,0,0,0)*dp - 400.D0*Hr5(0,0,0,0,0)*dm + 2344.D0/3.D0
     &    *Hr5(0,0,0,0,1) - 192.D0*Hr5(0,0,0,0,1)*x - 880.D0*Hr5(0,0,0,
     &    0,1)*dp - 304.D0*Hr5(0,0,0,0,1)*dm + 1168.D0/3.D0*Hr5(0,0,0,1
     &    ,0) - 96.D0*Hr5(0,0,0,1,0)*x - 1360.D0/3.D0*Hr5(0,0,0,1,0)*dp
     &     - 496.D0/3.D0*Hr5(0,0,0,1,0)*dm + 1552.D0/3.D0*Hr5(0,0,0,1,1
     &    ) - 160.D0*Hr5(0,0,0,1,1)*x - 1936.D0/3.D0*Hr5(0,0,0,1,1)*dp
     &     - 496.D0/3.D0*Hr5(0,0,0,1,1)*dm + 440.D0*Hr5(0,0,1,0,0) + 
     &    472.D0/3.D0*Hr5(0,0,1,0,0)*x - 832.D0/3.D0*Hr5(0,0,1,0,0)*dp
     &     - 576.D0*Hr5(0,0,1,0,0)*dm + 584.D0/3.D0*Hr5(0,0,1,0,1) + 
     &    104.D0/3.D0*Hr5(0,0,1,0,1)*x - 544.D0/3.D0*Hr5(0,0,1,0,1)*dp
     &     - 192.D0*Hr5(0,0,1,0,1)*dm + 40.D0*Hr5(0,0,1,1,0) - 104.D0/3.
     &    D0*Hr5(0,0,1,1,0)*x - 160.D0/3.D0*Hr5(0,0,1,1,0)*dp - 128.D0/
     &    3.D0*Hr5(0,0,1,1,0)*dm + 96.D0*Hr5(0,0,1,1,1) - 96.D0*Hr5(0,0
     &    ,1,1,1)*dp )
      c3qq3 = c3qq3 + cf**2*ca * (  - 96.D0*Hr5(0,0,1,1,1)*dm - 1552.D0/
     &    3.D0*Hr5(0,1,0,-1,0) - 1168.D0/3.D0*Hr5(0,1,0,-1,0)*x - 64.D0
     &    *Hr5(0,1,0,-1,0)*dp + 1120.D0*Hr5(0,1,0,-1,0)*dm + 1936.D0/3.D
     &    0*Hr5(0,1,0,0,0) + 1808.D0/3.D0*Hr5(0,1,0,0,0)*x + 448.D0/3.D0
     &    *Hr5(0,1,0,0,0)*dp - 4000.D0/3.D0*Hr5(0,1,0,0,0)*dm - 680.D0/
     &    3.D0*Hr5(0,1,0,0,1) - 472.D0/3.D0*Hr5(0,1,0,0,1)*x + 736.D0/3.
     &    D0*Hr5(0,1,0,0,1)*dp + 848.D0/3.D0*Hr5(0,1,0,0,1)*dm + 40.D0*
     &    Hr5(0,1,0,1,0) - 24.D0*Hr5(0,1,0,1,0)*x - 64.D0*Hr5(0,1,0,1,0
     &    )*dp - 112.D0/3.D0*Hr5(0,1,0,1,0)*dm + 200.D0/3.D0*Hr5(0,1,0,
     &    1,1) + 200.D0/3.D0*Hr5(0,1,0,1,1)*x - 304.D0/3.D0*Hr5(0,1,0,1
     &    ,1)*dm + 352.D0*Hr5(0,1,1,0,0) + 1744.D0/3.D0*Hr5(0,1,1,0,0)*
     &    x + 448.D0/3.D0*Hr5(0,1,1,0,0)*dp - 768.D0*Hr5(0,1,1,0,0)*dm
     &     + 16.D0*Hr5(0,1,1,0,1) + 48.D0*Hr5(0,1,1,0,1)*x + 32.D0*Hr5(
     &    0,1,1,0,1)*dp - 64.D0*Hr5(0,1,1,0,1)*dm - 248.D0/3.D0*Hr5(0,1
     &    ,1,1,0) - 344.D0/3.D0*Hr5(0,1,1,1,0)*x - 32.D0*Hr5(0,1,1,1,0)
     &    *dp )
      c3qq3 = c3qq3 + cf**2*ca * ( 496.D0/3.D0*Hr5(0,1,1,1,0)*dm - 2960.
     &    D0/3.D0*Hr5(1,0,-1,-1,0) - 2768.D0/3.D0*Hr5(1,0,-1,-1,0)*x + 
     &    5728.D0/3.D0*Hr5(1,0,-1,-1,0)*dm - 1408.D0/3.D0*Hr5(1,0,-1,0,
     &    0) - 352.D0/3.D0*Hr5(1,0,-1,0,0)*x + 1760.D0/3.D0*Hr5(1,0,-1,
     &    0,0)*dm - 4816.D0/3.D0*Hr5(1,0,-1,0,1) - 2512.D0/3.D0*Hr5(1,0
     &    ,-1,0,1)*x + 7328.D0/3.D0*Hr5(1,0,-1,0,1)*dm - 560.D0/3.D0*
     &    Hr5(1,0,0,-1,0) - 80.D0/3.D0*Hr5(1,0,0,-1,0)*x + 640.D0/3.D0*
     &    Hr5(1,0,0,-1,0)*dm + 2440.D0/3.D0*Hr5(1,0,0,0,0) + 1576.D0/3.D
     &    0*Hr5(1,0,0,0,0)*x - 4016.D0/3.D0*Hr5(1,0,0,0,0)*dm + 1936.D0/
     &    3.D0*Hr5(1,0,0,0,1) + 16.D0/3.D0*Hr5(1,0,0,0,1)*x - 1952.D0/3.
     &    D0*Hr5(1,0,0,0,1)*dm - 64.D0/3.D0*Hr5(1,0,0,1,0) - 160.D0/3.D0
     &    *Hr5(1,0,0,1,0)*x + 224.D0/3.D0*Hr5(1,0,0,1,0)*dm - 48.D0*
     &    Hr5(1,0,0,1,1) - 80.D0*Hr5(1,0,0,1,1)*x + 128.D0*Hr5(1,0,0,1,
     &    1)*dm + 1088.D0/3.D0*Hr5(1,0,1,0,0) + 1376.D0/3.D0*Hr5(1,0,1,
     &    0,0)*x - 2464.D0/3.D0*Hr5(1,0,1,0,0)*dm + 176.D0/3.D0*Hr5(1,0
     &    ,1,0,1) )
      c3qq3 = c3qq3 + cf**2*ca * ( 176.D0/3.D0*Hr5(1,0,1,0,1)*x - 352.D0
     &    /3.D0*Hr5(1,0,1,0,1)*dm - 16.D0*Hr5(1,0,1,1,0) - 16.D0*Hr5(1,
     &    0,1,1,0)*x + 32.D0*Hr5(1,0,1,1,0)*dm + 48.D0*Hr5(1,0,1,1,1)
     &     + 48.D0*Hr5(1,0,1,1,1)*x - 96.D0*Hr5(1,0,1,1,1)*dm - 976.D0*
     &    Hr5(1,1,0,-1,0) - 592.D0*Hr5(1,1,0,-1,0)*x + 1568.D0*Hr5(1,1,
     &    0,-1,0)*dm + 1128.D0*Hr5(1,1,0,0,0) + 808.D0*Hr5(1,1,0,0,0)*x
     &     - 1936.D0*Hr5(1,1,0,0,0)*dm - 352.D0/3.D0*Hr5(1,1,0,0,1) - 
     &    1216.D0/3.D0*Hr5(1,1,0,0,1)*x + 1568.D0/3.D0*Hr5(1,1,0,0,1)*
     &    dm - 16.D0*Hr5(1,1,0,1,0) - 16.D0*Hr5(1,1,0,1,0)*x + 32.D0*
     &    Hr5(1,1,0,1,0)*dm + 112.D0/3.D0*Hr5(1,1,0,1,1) + 112.D0/3.D0*
     &    Hr5(1,1,0,1,1)*x - 224.D0/3.D0*Hr5(1,1,0,1,1)*dm + 1024.D0/3.D
     &    0*Hr5(1,1,1,0,0) + 1696.D0/3.D0*Hr5(1,1,1,0,0)*x - 2720.D0/3.D
     &    0*Hr5(1,1,1,0,0)*dm + 32.D0/3.D0*Hr5(1,1,1,0,1) + 32.D0/3.D0*
     &    Hr5(1,1,1,0,1)*x - 64.D0/3.D0*Hr5(1,1,1,0,1)*dm - 96.D0*Hr5(1
     &    ,1,1,1,0) - 96.D0*Hr5(1,1,1,1,0)*x + 192.D0*Hr5(1,1,1,1,0)*dm
     &     )
      c3qq3 = c3qq3 + cf**3 * ( 61349.D0/18.D0 - 113689.D0/36.D0*x + 
     &    3016.D0/3.D0*z5 - 408.D0*z5*x + 104.D0*z4 + 526.D0/3.D0*z4*x
     &     + 296.D0/3.D0*z4*x**2 - 3968.D0/3.D0*dp*z5 - 544.D0*dp*z4 - 
     &    1001.D0/8.D0*dm - 5360.D0/3.D0*dm*z5 + 196.D0/3.D0*dm*z4 - 
     &    868.D0*z3 - 556.D0*z3*x - 9760.D0/9.D0*z3*x**2 - 40.D0*z3*dp
     &     + 286.D0*z3*dm - 9086.D0/9.D0*z2 + 16760.D0/9.D0*z2*x - 248.D
     &    0/3.D0*z2*x**2 + 112.D0/3.D0*z2*dp - 887.D0/3.D0*z2*dm - 872.D
     &    0*z2*z3 + 5000.D0/3.D0*z2*z3*x + 1952.D0*z2*z3*dp - 1856.D0/3.
     &    D0*z2*z3*dm + 1660.D0/3.D0*Hr1(-1)*z4 - 244.D0/3.D0*Hr1(-1)*
     &    z4*x - 1904.D0/3.D0*Hr1(-1)*dp*z4 + 236.D0*Hr1(-1)*z3 + 4516.D
     &    0/3.D0*Hr1(-1)*z3*x + 704.D0*Hr1(-1)*z3*x**2 + 704.D0*Hr1(-1)
     &    *z3*dx + 1096.D0*Hr1(-1)*z3*dp + 2012.D0/3.D0*Hr1(-1)*z2 + 
     &    2276.D0/3.D0*Hr1(-1)*z2*x + 1952.D0/3.D0*Hr1(-1)*z2*x**2 + 
     &    1952.D0/3.D0*Hr1(-1)*z2*dx + 224.D0/3.D0*Hr1(-1)*z2*dp + 
     &    70259.D0/36.D0*Hr1(0) + 1763.D0/4.D0*Hr1(0)*x + 2890.D0/3.D0*
     &    Hr1(0)*z4 )
      c3qq3 = c3qq3 + cf**3 * ( 262.D0*Hr1(0)*z4*x - 980.D0/3.D0*Hr1(0)
     &    *dp - 1544.D0/3.D0*Hr1(0)*dp*z4 - 2407.D0/6.D0*Hr1(0)*dm - 
     &    1240.D0*Hr1(0)*dm*z4 - 2054.D0*Hr1(0)*z3 - 6626.D0/3.D0*Hr1(0
     &    )*z3*x - 2576.D0/3.D0*Hr1(0)*z3*x**2 + 8.D0/3.D0*Hr1(0)*z3*dp
     &     + 1392.D0*Hr1(0)*z3*dm - 790.D0*Hr1(0)*z2 - 578.D0*Hr1(0)*z2
     &    *x - 7808.D0/9.D0*Hr1(0)*z2*x**2 - 148.D0*Hr1(0)*z2*dp - 1622.
     &    D0/3.D0*Hr1(0)*z2*dm + 33203.D0/36.D0*Hr1(1) - 32477.D0/36.D0
     &    *Hr1(1)*x + 268.D0*Hr1(1)*z4 + 868.D0*Hr1(1)*z4*x - 187.D0/2.D
     &    0*Hr1(1)*dm - 1136.D0*Hr1(1)*dm*z4 + 132.D0*Hr1(1)*z3 - 1340.D
     &    0/3.D0*Hr1(1)*z3*x - 464.D0/3.D0*Hr1(1)*z3*x**2 + 464.D0/3.D0
     &    *Hr1(1)*z3*dx + 144.D0*Hr1(1)*z3*dm - 146.D0*Hr1(1)*z2 + 134.D
     &    0*Hr1(1)*z2*x - 1952.D0/9.D0*Hr1(1)*z2*x**2 + 1952.D0/9.D0*
     &    Hr1(1)*z2*dx - 380.D0/3.D0*Hr1(1)*z2*dm + 4896.D0*Hr2(-1,-1)*
     &    z3 - 3264.D0*Hr2(-1,-1)*z3*x - 8160.D0*Hr2(-1,-1)*z3*dp + 184.
     &    D0/3.D0*Hr2(-1,-1)*z2 - 1192.D0*Hr2(-1,-1)*z2*x - 864.D0*Hr2(
     &    -1,-1)*z2*x**2 )
      c3qq3 = c3qq3 + cf**3 * (  - 864.D0*Hr2(-1,-1)*z2*dx - 1056.D0*
     &    Hr2(-1,-1)*z2*dp - 3892.D0/9.D0*Hr2(-1,0) - 3796.D0/9.D0*Hr2(
     &    -1,0)*x - 248.D0/3.D0*Hr2(-1,0)*x**2 - 616.D0/3.D0*Hr2(-1,0)*
     &    dx - 64.D0*Hr2(-1,0)*dp - 2816.D0*Hr2(-1,0)*z3 + 2144.D0*Hr2(
     &    -1,0)*z3*x + 4960.D0*Hr2(-1,0)*z3*dp + 3056.D0/3.D0*Hr2(-1,0)
     &    *z2 + 1904.D0*Hr2(-1,0)*z2*x + 672.D0*Hr2(-1,0)*z2*x**2 + 672.
     &    D0*Hr2(-1,0)*z2*dx + 848.D0*Hr2(-1,0)*z2*dp - 6536.D0/3.D0*
     &    Hr2(0,-1)*z3 + 3336.D0*Hr2(0,-1)*z3*x + 17600.D0/3.D0*Hr2(0,
     &    -1)*z3*dp - 6592.D0/3.D0*Hr2(0,-1)*z3*dm + 3800.D0/3.D0*Hr2(0
     &    ,-1)*z2 + 3784.D0/3.D0*Hr2(0,-1)*z2*x + 864.D0*Hr2(0,-1)*z2*
     &    x**2 + 192.D0*Hr2(0,-1)*z2*dx + 592.D0*Hr2(0,-1)*z2*dp - 3256.
     &    D0/3.D0*Hr2(0,-1)*z2*dm + 5740.D0/9.D0*Hr2(0,0) - 15842.D0/9.D
     &    0*Hr2(0,0)*x + 248.D0/3.D0*Hr2(0,0)*x**2 - 440.D0/3.D0*Hr2(0,
     &    0)*dp + 337.D0/3.D0*Hr2(0,0)*dm + 1964.D0/3.D0*Hr2(0,0)*z3 - 
     &    4180.D0/3.D0*Hr2(0,0)*z3*x - 4576.D0/3.D0*Hr2(0,0)*z3*dp + 
     &    896.D0/3.D0*Hr2(0,0)*z3*dm )
      c3qq3 = c3qq3 + cf**3 * (  - 6434.D0/3.D0*Hr2(0,0)*z2 - 6682.D0/3.
     &    D0*Hr2(0,0)*z2*x - 2128.D0/3.D0*Hr2(0,0)*z2*x**2 + 856.D0/3.D0
     &    *Hr2(0,0)*z2*dp + 944.D0*Hr2(0,0)*z2*dm + 5194.D0/9.D0*Hr2(0,
     &    1) - 16760.D0/9.D0*Hr2(0,1)*x - 208.D0/3.D0*Hr2(0,1)*dp + 791.
     &    D0/3.D0*Hr2(0,1)*dm + 480.D0*Hr2(0,1)*z3 + 3088.D0/3.D0*Hr2(0
     &    ,1)*z3*x + 2464.D0/3.D0*Hr2(0,1)*z3*dp - 3712.D0/3.D0*Hr2(0,1
     &    )*z3*dm - 1696.D0/3.D0*Hr2(0,1)*z2 - 1904.D0/3.D0*Hr2(0,1)*z2
     &    *x - 32.D0*Hr2(0,1)*z2*x**2 + 64.D0*Hr2(0,1)*z2*dx + 488.D0*
     &    Hr2(0,1)*z2*dp + 376.D0*Hr2(0,1)*z2*dm + 492.D0*Hr2(1,0) - 
     &    3248.D0/3.D0*Hr2(1,0)*x + 397.D0*Hr2(1,0)*dm + 3104.D0/3.D0*
     &    Hr2(1,0)*z3 + 1280.D0/3.D0*Hr2(1,0)*z3*x - 4384.D0/3.D0*Hr2(1
     &    ,0)*z3*dm - 832.D0/3.D0*Hr2(1,0)*z2 - 1760.D0/3.D0*Hr2(1,0)*
     &    z2*x - 112.D0/3.D0*Hr2(1,0)*z2*x**2 + 112.D0/3.D0*Hr2(1,0)*z2
     &    *dx + 704.D0*Hr2(1,0)*z2*dm + 3146.D0/3.D0*Hr2(1,1) - 4124.D0/
     &    3.D0*Hr2(1,1)*x + 279.D0*Hr2(1,1)*dm + 1104.D0*Hr2(1,1)*z3 + 
     &    1008.D0*Hr2(1,1)*z3*x )
      c3qq3 = c3qq3 + cf**3 * (  - 2112.D0*Hr2(1,1)*z3*dm + 304.D0/3.D0
     &    *Hr2(1,1)*z2 - 1744.D0/3.D0*Hr2(1,1)*z2*x - 32.D0*Hr2(1,1)*z2
     &    *x**2 + 32.D0*Hr2(1,1)*z2*dx + 432.D0*Hr2(1,1)*z2*dm - 5024.D0
     &    *Hr3(-1,-1,-1)*z2 + 3040.D0*Hr3(-1,-1,-1)*z2*x + 8064.D0*Hr3(
     &    -1,-1,-1)*z2*dp + 24.D0*Hr3(-1,-1,0) - 1384.D0/3.D0*Hr3(-1,-1
     &    ,0)*x + 3904.D0/9.D0*Hr3(-1,-1,0)*x**2 + 3904.D0/9.D0*Hr3(-1,
     &    -1,0)*dx - 512.D0*Hr3(-1,-1,0)*dp + 5536.D0*Hr3(-1,-1,0)*z2
     &     - 4000.D0*Hr3(-1,-1,0)*z2*x - 9536.D0*Hr3(-1,-1,0)*z2*dp + 
     &    3616.D0*Hr3(-1,0,-1)*z2 - 2400.D0*Hr3(-1,0,-1)*z2*x - 6016.D0
     &    *Hr3(-1,0,-1)*z2*dp - 448.D0*Hr3(-1,0,0) - 104.D0/3.D0*Hr3(-1
     &    ,0,0)*x - 3904.D0/9.D0*Hr3(-1,0,0)*x**2 - 3904.D0/9.D0*Hr3(-1
     &    ,0,0)*dx + 1264.D0/3.D0*Hr3(-1,0,0)*dp - 2832.D0*Hr3(-1,0,0)*
     &    z2 + 1936.D0*Hr3(-1,0,0)*z2*x + 4768.D0*Hr3(-1,0,0)*z2*dp - 
     &    1976.D0/3.D0*Hr3(-1,0,1) - 2968.D0/3.D0*Hr3(-1,0,1)*x - 3904.D
     &    0/9.D0*Hr3(-1,0,1)*x**2 - 3904.D0/9.D0*Hr3(-1,0,1)*dx - 992.D0
     &    /3.D0*Hr3(-1,0,1)*dp )
      c3qq3 = c3qq3 + cf**3 * ( 752.D0/3.D0*Hr3(-1,0,1)*z2 - 560.D0/3.D0
     &    *Hr3(-1,0,1)*z2*x - 1312.D0/3.D0*Hr3(-1,0,1)*z2*dp + 6208.D0/
     &    3.D0*Hr3(0,-1,-1)*z2 - 10240.D0/3.D0*Hr3(0,-1,-1)*z2*x - 6048.
     &    D0*Hr3(0,-1,-1)*z2*dp + 2592.D0*Hr3(0,-1,-1)*z2*dm - 1424.D0/
     &    3.D0*Hr3(0,-1,0) + 1000.D0*Hr3(0,-1,0)*x - 3904.D0/9.D0*Hr3(0
     &    ,-1,0)*x**2 + 1360.D0/3.D0*Hr3(0,-1,0)*dp - 296.D0/3.D0*Hr3(0
     &    ,-1,0)*dm - 7648.D0/3.D0*Hr3(0,-1,0)*z2 + 3584.D0*Hr3(0,-1,0)
     &    *z2*x + 18944.D0/3.D0*Hr3(0,-1,0)*z2*dp - 5792.D0/3.D0*Hr3(0,
     &    -1,0)*z2*dm - 976.D0*Hr3(0,0,-1)*z2 + 8528.D0/3.D0*Hr3(0,0,-1
     &    )*z2*x + 11200.D0/3.D0*Hr3(0,0,-1)*z2*dp - 5504.D0/3.D0*Hr3(0
     &    ,0,-1)*z2*dm + 1216.D0/3.D0*Hr3(0,0,0) - 82.D0*Hr3(0,0,0)*x
     &     + 3904.D0/9.D0*Hr3(0,0,0)*x**2 - 956.D0/3.D0*Hr3(0,0,0)*dp
     &     + 406.D0/3.D0*Hr3(0,0,0)*dm + 1300.D0/3.D0*Hr3(0,0,0)*z2 - 
     &    980.D0*Hr3(0,0,0)*z2*x - 3616.D0/3.D0*Hr3(0,0,0)*z2*dp + 896.D
     &    0/3.D0*Hr3(0,0,0)*z2*dm + 946.D0/3.D0*Hr3(0,0,1) + 578.D0*
     &    Hr3(0,0,1)*x )
      c3qq3 = c3qq3 + cf**3 * ( 3904.D0/9.D0*Hr3(0,0,1)*x**2 + 976.D0/3.
     &    D0*Hr3(0,0,1)*dp + 718.D0*Hr3(0,0,1)*dm - 656.D0*Hr3(0,0,1)*
     &    z2 + 144.D0*Hr3(0,0,1)*z2*x + 2624.D0/3.D0*Hr3(0,0,1)*z2*dp
     &     + 736.D0/3.D0*Hr3(0,0,1)*z2*dm - 118.D0/3.D0*Hr3(0,1,0) - 70.
     &    D0/3.D0*Hr3(0,1,0)*x + 64.D0*Hr3(0,1,0)*dp + 740.D0*Hr3(0,1,0
     &    )*dm - 520.D0/3.D0*Hr3(0,1,0)*z2 - 184.D0*Hr3(0,1,0)*z2*x + 
     &    1696.D0/3.D0*Hr3(0,1,0)*z2*dp + 352.D0/3.D0*Hr3(0,1,0)*z2*dm
     &     + 854.D0/3.D0*Hr3(0,1,1) + 574.D0/3.D0*Hr3(0,1,1)*x + 64.D0*
     &    Hr3(0,1,1)*dp + 1504.D0/3.D0*Hr3(0,1,1)*dm - 1184.D0/3.D0*
     &    Hr3(0,1,1)*z2 - 160.D0*Hr3(0,1,1)*z2*x + 1376.D0/3.D0*Hr3(0,1
     &    ,1)*z2*dp + 1280.D0/3.D0*Hr3(0,1,1)*z2*dm - 1360.D0/3.D0*Hr3(
     &    1,0,-1)*z2 - 16.D0/3.D0*Hr3(1,0,-1)*z2*x + 1376.D0/3.D0*Hr3(1
     &    ,0,-1)*z2*dm + 262.D0/3.D0*Hr3(1,0,0) - 1318.D0/3.D0*Hr3(1,0,
     &    0)*x + 370.D0*Hr3(1,0,0)*dm + 720.D0*Hr3(1,0,0)*z2 - 240.D0*
     &    Hr3(1,0,0)*z2*x - 480.D0*Hr3(1,0,0)*z2*dm + 134.D0*Hr3(1,0,1)
     &     - 1094.D0/3.D0*Hr3(1,0,1)*x )
      c3qq3 = c3qq3 + cf**3 * ( 1148.D0/3.D0*Hr3(1,0,1)*dm - 96.D0*Hr3(
     &    1,0,1)*z2 - 288.D0*Hr3(1,0,1)*z2*x + 384.D0*Hr3(1,0,1)*z2*dm
     &     - 542.D0/3.D0*Hr3(1,1,0) - 686.D0/3.D0*Hr3(1,1,0)*x + 496.D0
     &    *Hr3(1,1,0)*dm + 1376.D0/3.D0*Hr3(1,1,0)*z2 - 1312.D0/3.D0*
     &    Hr3(1,1,0)*z2*x - 64.D0/3.D0*Hr3(1,1,0)*z2*dm + 6.D0*Hr3(1,1,
     &    1) - 90.D0*Hr3(1,1,1)*x + 216.D0*Hr3(1,1,1)*dm - 96.D0*Hr3(1,
     &    1,1)*z2 - 288.D0*Hr3(1,1,1)*z2*x + 384.D0*Hr3(1,1,1)*z2*dm + 
     &    720.D0*Hr4(-1,-1,-1,0) - 176.D0/3.D0*Hr4(-1,-1,-1,0)*x - 64.D0
     &    *Hr4(-1,-1,-1,0)*x**2 - 64.D0*Hr4(-1,-1,-1,0)*dx - 576.D0*
     &    Hr4(-1,-1,-1,0)*dp + 200.D0/3.D0*Hr4(-1,-1,0,0) + 2344.D0/3.D0
     &    *Hr4(-1,-1,0,0)*x + 576.D0*Hr4(-1,-1,0,0)*x**2 + 576.D0*Hr4(
     &    -1,-1,0,0)*dx + 480.D0*Hr4(-1,-1,0,0)*dp + 896.D0/3.D0*Hr4(-1
     &    ,-1,0,1) + 3488.D0/3.D0*Hr4(-1,-1,0,1)*x + 832.D0*Hr4(-1,-1,0
     &    ,1)*x**2 + 832.D0*Hr4(-1,-1,0,1)*dx + 768.D0*Hr4(-1,-1,0,1)*
     &    dp - 1264.D0/3.D0*Hr4(-1,0,-1,0) - 112.D0/3.D0*Hr4(-1,0,-1,0)
     &    *x )
      c3qq3 = c3qq3 + cf**3 * ( 64.D0*Hr4(-1,0,-1,0)*x**2 + 64.D0*Hr4(
     &    -1,0,-1,0)*dx + 240.D0*Hr4(-1,0,-1,0)*dp - 2504.D0/3.D0*Hr4(
     &    -1,0,0,0) - 2456.D0/3.D0*Hr4(-1,0,0,0)*x - 256.D0*Hr4(-1,0,0,
     &    0)*x**2 - 256.D0*Hr4(-1,0,0,0)*dx + 72.D0*Hr4(-1,0,0,0)*dp - 
     &    3200.D0/3.D0*Hr4(-1,0,0,1) - 5744.D0/3.D0*Hr4(-1,0,0,1)*x - 
     &    576.D0*Hr4(-1,0,0,1)*x**2 - 576.D0*Hr4(-1,0,0,1)*dx - 800.D0*
     &    Hr4(-1,0,0,1)*dp - 1184.D0/3.D0*Hr4(-1,0,1,0) - 2336.D0/3.D0*
     &    Hr4(-1,0,1,0)*x - 64.D0*Hr4(-1,0,1,0)*x**2 - 64.D0*Hr4(-1,0,1
     &    ,0)*dx - 384.D0*Hr4(-1,0,1,0)*dp - 544.D0*Hr4(-1,0,1,1) - 
     &    1056.D0*Hr4(-1,0,1,1)*x - 64.D0*Hr4(-1,0,1,1)*x**2 - 64.D0*
     &    Hr4(-1,0,1,1)*dx - 512.D0*Hr4(-1,0,1,1)*dp + 16.D0/3.D0*Hr4(0
     &    ,-1,-1,0) + 2608.D0/3.D0*Hr4(0,-1,-1,0)*x + 64.D0*Hr4(0,-1,-1
     &    ,0)*x**2 + 128.D0*Hr4(0,-1,-1,0)*dx + 224.D0*Hr4(0,-1,-1,0)*
     &    dp - 1008.D0*Hr4(0,-1,-1,0)*dm - 2080.D0/3.D0*Hr4(0,-1,0,0)
     &     - 960.D0*Hr4(0,-1,0,0)*x - 576.D0*Hr4(0,-1,0,0)*x**2 - 128.D0
     &    *Hr4(0,-1,0,0)*dx )
      c3qq3 = c3qq3 + cf**3 * (  - 32.D0*Hr4(0,-1,0,0)*dp + 1616.D0/3.D0
     &    *Hr4(0,-1,0,0)*dm - 1264.D0*Hr4(0,-1,0,1) - 2480.D0/3.D0*Hr4(
     &    0,-1,0,1)*x - 832.D0*Hr4(0,-1,0,1)*x**2 - 128.D0*Hr4(0,-1,0,1
     &    )*dx - 480.D0*Hr4(0,-1,0,1)*dp + 1744.D0/3.D0*Hr4(0,-1,0,1)*
     &    dm - 1184.D0/3.D0*Hr4(0,0,-1,0) - 2240.D0/3.D0*Hr4(0,0,-1,0)*
     &    x - 192.D0*Hr4(0,0,-1,0)*x**2 + 224.D0/3.D0*Hr4(0,0,-1,0)*dp
     &     + 288.D0*Hr4(0,0,-1,0)*dm + 2486.D0/3.D0*Hr4(0,0,0,0) + 850.D
     &    0*Hr4(0,0,0,0)*x + 320.D0*Hr4(0,0,0,0)*x**2 - 1192.D0/3.D0*
     &    Hr4(0,0,0,0)*dp - 760.D0/3.D0*Hr4(0,0,0,0)*dm + 1750.D0*Hr4(0
     &    ,0,0,1) + 6682.D0/3.D0*Hr4(0,0,0,1)*x + 1552.D0/3.D0*Hr4(0,0,
     &    0,1)*x**2 - 104.D0*Hr4(0,0,0,1)*dp - 2288.D0/3.D0*Hr4(0,0,0,1
     &    )*dm + 580.D0*Hr4(0,0,1,0) + 4316.D0/3.D0*Hr4(0,0,1,0)*x + 64.
     &    D0*Hr4(0,0,1,0)*x**2 + 168.D0*Hr4(0,0,1,0)*dp - 240.D0*Hr4(0,
     &    0,1,0)*dm + 2408.D0/3.D0*Hr4(0,0,1,1) + 1976.D0*Hr4(0,0,1,1)*
     &    x + 64.D0*Hr4(0,0,1,1)*x**2 + 256.D0*Hr4(0,0,1,1)*dp - 512.D0
     &    *Hr4(0,0,1,1)*dm )
      c3qq3 = c3qq3 + cf**3 * ( 620.D0/3.D0*Hr4(0,1,0,0) + 1772.D0/3.D0
     &    *Hr4(0,1,0,0)*x + 176.D0/3.D0*Hr4(0,1,0,0)*x**2 + 56.D0*Hr4(0
     &    ,1,0,0)*dm + 1688.D0/3.D0*Hr4(0,1,0,1) + 3208.D0/3.D0*Hr4(0,1
     &    ,0,1)*x + 16.D0*Hr4(0,1,0,1)*dp - 488.D0*Hr4(0,1,0,1)*dm + 
     &    1720.D0/3.D0*Hr4(0,1,1,0) + 952.D0*Hr4(0,1,1,0)*x - 16.D0*
     &    Hr4(0,1,1,0)*dp - 600.D0*Hr4(0,1,1,0)*dm + 552.D0*Hr4(0,1,1,1
     &    ) + 984.D0*Hr4(0,1,1,1)*x - 648.D0*Hr4(0,1,1,1)*dm - 976.D0/3.
     &    D0*Hr4(1,0,-1,0) + 16.D0*Hr4(1,0,-1,0)*x - 128.D0*Hr4(1,0,-1,
     &    0)*x**2 + 128.D0*Hr4(1,0,-1,0)*dx + 144.D0*Hr4(1,0,-1,0)*dm
     &     + 416.D0/3.D0*Hr4(1,0,0,0) + 208.D0/3.D0*Hr4(1,0,0,0)*x + 64.
     &    D0*Hr4(1,0,0,0)*x**2 - 64.D0*Hr4(1,0,0,0)*dx - 144.D0*Hr4(1,0
     &    ,0,0)*dm + 976.D0/3.D0*Hr4(1,0,0,1) + 576.D0*Hr4(1,0,0,1)*x
     &     - 176.D0/3.D0*Hr4(1,0,0,1)*x**2 + 176.D0/3.D0*Hr4(1,0,0,1)*
     &    dx - 752.D0*Hr4(1,0,0,1)*dm + 832.D0/3.D0*Hr4(1,0,1,0) + 512.D
     &    0*Hr4(1,0,1,0)*x - 640.D0*Hr4(1,0,1,0)*dm + 848.D0/3.D0*Hr4(1
     &    ,0,1,1) )
      c3qq3 = c3qq3 + cf**3 * ( 1568.D0/3.D0*Hr4(1,0,1,1)*x - 648.D0*
     &    Hr4(1,0,1,1)*dm - 872.D0/3.D0*Hr4(1,1,0,0) + 1112.D0/3.D0*
     &    Hr4(1,1,0,0)*x + 176.D0/3.D0*Hr4(1,1,0,0)*x**2 - 176.D0/3.D0*
     &    Hr4(1,1,0,0)*dx - 24.D0*Hr4(1,1,0,0)*dm + 776.D0/3.D0*Hr4(1,1
     &    ,0,1) + 1832.D0/3.D0*Hr4(1,1,0,1)*x - 720.D0*Hr4(1,1,0,1)*dm
     &     + 1112.D0/3.D0*Hr4(1,1,1,0) + 2072.D0/3.D0*Hr4(1,1,1,0)*x - 
     &    864.D0*Hr4(1,1,1,0)*dm + 288.D0*Hr4(1,1,1,1) + 576.D0*Hr4(1,1
     &    ,1,1)*x - 720.D0*Hr4(1,1,1,1)*dm - 960.D0*Hr5(-1,-1,-1,-1,0)
     &     + 576.D0*Hr5(-1,-1,-1,-1,0)*x + 1536.D0*Hr5(-1,-1,-1,-1,0)*
     &    dp + 4224.D0*Hr5(-1,-1,-1,0,0) - 2624.D0*Hr5(-1,-1,-1,0,0)*x
     &     - 6848.D0*Hr5(-1,-1,-1,0,0)*dp + 4544.D0*Hr5(-1,-1,-1,0,1)
     &     - 2752.D0*Hr5(-1,-1,-1,0,1)*x - 7296.D0*Hr5(-1,-1,-1,0,1)*dp
     &     + 928.D0*Hr5(-1,-1,0,-1,0) - 544.D0*Hr5(-1,-1,0,-1,0)*x - 
     &    1472.D0*Hr5(-1,-1,0,-1,0)*dp - 9872.D0/3.D0*Hr5(-1,-1,0,0,0)
     &     + 7568.D0/3.D0*Hr5(-1,-1,0,0,0)*x + 17440.D0/3.D0*Hr5(-1,-1,
     &    0,0,0)*dp )
      c3qq3 = c3qq3 + cf**3 * (  - 14272.D0/3.D0*Hr5(-1,-1,0,0,1) + 
     &    10624.D0/3.D0*Hr5(-1,-1,0,0,1)*x + 24896.D0/3.D0*Hr5(-1,-1,0,
     &    0,1)*dp - 4160.D0/3.D0*Hr5(-1,-1,0,1,0) + 3776.D0/3.D0*Hr5(-1
     &    ,-1,0,1,0)*x + 7936.D0/3.D0*Hr5(-1,-1,0,1,0)*dp - 1728.D0*
     &    Hr5(-1,-1,0,1,1) + 1600.D0*Hr5(-1,-1,0,1,1)*x + 3328.D0*Hr5(
     &    -1,-1,0,1,1)*dp + 960.D0*Hr5(-1,0,-1,-1,0) - 576.D0*Hr5(-1,0,
     &    -1,-1,0)*x - 1536.D0*Hr5(-1,0,-1,-1,0)*dp - 8960.D0/3.D0*Hr5(
     &    -1,0,-1,0,0) + 6080.D0/3.D0*Hr5(-1,0,-1,0,0)*x + 15040.D0/3.D0
     &    *Hr5(-1,0,-1,0,0)*dp - 3136.D0*Hr5(-1,0,-1,0,1) + 2112.D0*
     &    Hr5(-1,0,-1,0,1)*x + 5248.D0*Hr5(-1,0,-1,0,1)*dp - 3104.D0/3.D
     &    0*Hr5(-1,0,0,-1,0) + 2144.D0/3.D0*Hr5(-1,0,0,-1,0)*x + 5248.D0
     &    /3.D0*Hr5(-1,0,0,-1,0)*dp + 1424.D0*Hr5(-1,0,0,0,0) - 1104.D0
     &    *Hr5(-1,0,0,0,0)*x - 2528.D0*Hr5(-1,0,0,0,0)*dp + 2448.D0*
     &    Hr5(-1,0,0,0,1) - 1744.D0*Hr5(-1,0,0,0,1)*x - 4192.D0*Hr5(-1,
     &    0,0,0,1)*dp + 2896.D0/3.D0*Hr5(-1,0,0,1,0) - 2704.D0/3.D0*
     &    Hr5(-1,0,0,1,0)*x )
      c3qq3 = c3qq3 + cf**3 * (  - 5600.D0/3.D0*Hr5(-1,0,0,1,0)*dp + 
     &    3712.D0/3.D0*Hr5(-1,0,0,1,1) - 3520.D0/3.D0*Hr5(-1,0,0,1,1)*x
     &     - 7232.D0/3.D0*Hr5(-1,0,0,1,1)*dp + 1024.D0/3.D0*Hr5(-1,0,1,
     &    0,0) - 1408.D0/3.D0*Hr5(-1,0,1,0,0)*x - 2432.D0/3.D0*Hr5(-1,0
     &    ,1,0,0)*dp + 288.D0*Hr5(-1,0,1,0,1) - 288.D0*Hr5(-1,0,1,0,1)*
     &    x - 576.D0*Hr5(-1,0,1,0,1)*dp + 544.D0/3.D0*Hr5(-1,0,1,1,0)
     &     - 544.D0/3.D0*Hr5(-1,0,1,1,0)*x - 1088.D0/3.D0*Hr5(-1,0,1,1,
     &    0)*dp + 192.D0*Hr5(-1,0,1,1,1) - 192.D0*Hr5(-1,0,1,1,1)*x - 
     &    384.D0*Hr5(-1,0,1,1,1)*dp + 2048.D0/3.D0*Hr5(0,-1,-1,-1,0) - 
     &    3328.D0/3.D0*Hr5(0,-1,-1,-1,0)*x - 1600.D0*Hr5(0,-1,-1,-1,0)*
     &    dp + 2624.D0/3.D0*Hr5(0,-1,-1,-1,0)*dm - 5696.D0/3.D0*Hr5(0,
     &    -1,-1,0,0) + 9440.D0/3.D0*Hr5(0,-1,-1,0,0)*x + 5024.D0*Hr5(0,
     &    -1,-1,0,0)*dp - 2240.D0*Hr5(0,-1,-1,0,0)*dm - 1728.D0*Hr5(0,
     &    -1,-1,0,1) + 8576.D0/3.D0*Hr5(0,-1,-1,0,1)*x + 5248.D0*Hr5(0,
     &    -1,-1,0,1)*dp - 6464.D0/3.D0*Hr5(0,-1,-1,0,1)*dm - 544.D0*
     &    Hr5(0,-1,0,-1,0) )
      c3qq3 = c3qq3 + cf**3 * ( 928.D0*Hr5(0,-1,0,-1,0)*x + 1280.D0*
     &    Hr5(0,-1,0,-1,0)*dp - 704.D0*Hr5(0,-1,0,-1,0)*dm + 1744.D0*
     &    Hr5(0,-1,0,0,0) - 2384.D0*Hr5(0,-1,0,0,0)*x - 3712.D0*Hr5(0,
     &    -1,0,0,0)*dp + 1088.D0*Hr5(0,-1,0,0,0)*dm + 6400.D0/3.D0*Hr5(
     &    0,-1,0,0,1) - 9056.D0/3.D0*Hr5(0,-1,0,0,1)*x - 16096.D0/3.D0*
     &    Hr5(0,-1,0,0,1)*dp + 4672.D0/3.D0*Hr5(0,-1,0,0,1)*dm + 2176.D0
     &    /3.D0*Hr5(0,-1,0,1,0) - 2560.D0/3.D0*Hr5(0,-1,0,1,0)*x - 1536.
     &    D0*Hr5(0,-1,0,1,0)*dp + 192.D0*Hr5(0,-1,0,1,0)*dm + 2816.D0/3.
     &    D0*Hr5(0,-1,0,1,1) - 3200.D0/3.D0*Hr5(0,-1,0,1,1)*x - 5824.D0/
     &    3.D0*Hr5(0,-1,0,1,1)*dp + 192.D0*Hr5(0,-1,0,1,1)*dm + 160.D0*
     &    Hr5(0,0,-1,-1,0) + 1952.D0*Hr5(0,0,-1,-1,0)*x + 4736.D0/3.D0*
     &    Hr5(0,0,-1,-1,0)*dp - 2304.D0*Hr5(0,0,-1,-1,0)*dm + 672.D0*
     &    Hr5(0,0,-1,0,0) - 8192.D0/3.D0*Hr5(0,0,-1,0,0)*x - 8960.D0/3.D
     &    0*Hr5(0,0,-1,0,0)*dp + 1920.D0*Hr5(0,0,-1,0,0)*dm + 1056.D0*
     &    Hr5(0,0,-1,0,1) - 5600.D0/3.D0*Hr5(0,0,-1,0,1)*x - 2944.D0*
     &    Hr5(0,0,-1,0,1)*dp )
      c3qq3 = c3qq3 + cf**3 * ( 2048.D0/3.D0*Hr5(0,0,-1,0,1)*dm + 128.D0
     &    *Hr5(0,0,0,-1,0) - 3968.D0/3.D0*Hr5(0,0,0,-1,0)*x - 1024.D0*
     &    Hr5(0,0,0,-1,0)*dp + 2560.D0/3.D0*Hr5(0,0,0,-1,0)*dm - 396.D0
     &    *Hr5(0,0,0,0,0) + 420.D0*Hr5(0,0,0,0,0)*x + 544.D0*Hr5(0,0,0,
     &    0,0)*dp + 64.D0*Hr5(0,0,0,0,0)*dm - 916.D0/3.D0*Hr5(0,0,0,0,1
     &    ) + 980.D0*Hr5(0,0,0,0,1)*x + 1120.D0*Hr5(0,0,0,0,1)*dp - 384.
     &    D0*Hr5(0,0,0,0,1)*dm + 544.D0/3.D0*Hr5(0,0,0,1,0) + 896.D0*
     &    Hr5(0,0,0,1,0)*x + 1952.D0/3.D0*Hr5(0,0,0,1,0)*dp - 704.D0*
     &    Hr5(0,0,0,1,0)*dm + 216.D0*Hr5(0,0,0,1,1) + 1144.D0*Hr5(0,0,0
     &    ,1,1)*x + 864.D0*Hr5(0,0,0,1,1)*dp - 2912.D0/3.D0*Hr5(0,0,0,1
     &    ,1)*dm + 544.D0/3.D0*Hr5(0,0,1,0,0) + 1600.D0/3.D0*Hr5(0,0,1,
     &    0,0)*x + 1024.D0/3.D0*Hr5(0,0,1,0,0)*dp - 1120.D0/3.D0*Hr5(0,
     &    0,1,0,0)*dm + 576.D0*Hr5(0,0,1,0,1) + 832.D0*Hr5(0,0,1,0,1)*x
     &     + 832.D0/3.D0*Hr5(0,0,1,0,1)*dp - 3104.D0/3.D0*Hr5(0,0,1,0,1
     &    )*dm + 2128.D0/3.D0*Hr5(0,0,1,1,0) + 2768.D0/3.D0*Hr5(0,0,1,1
     &    ,0)*x )
      c3qq3 = c3qq3 + cf**3 * ( 192.D0*Hr5(0,0,1,1,0)*dp - 1184.D0*Hr5(
     &    0,0,1,1,0)*dm + 688.D0*Hr5(0,0,1,1,1) + 880.D0*Hr5(0,0,1,1,1)
     &    *x + 192.D0*Hr5(0,0,1,1,1)*dp - 1184.D0*Hr5(0,0,1,1,1)*dm + 
     &    288.D0*Hr5(0,1,0,-1,0) + 608.D0/3.D0*Hr5(0,1,0,-1,0)*x + 128.D
     &    0/3.D0*Hr5(0,1,0,-1,0)*dp - 1856.D0/3.D0*Hr5(0,1,0,-1,0)*dm
     &     - 200.D0*Hr5(0,1,0,0,0) - 72.D0*Hr5(0,1,0,0,0)*x - 128.D0*
     &    Hr5(0,1,0,0,0)*dp + 448.D0*Hr5(0,1,0,0,0)*dm + 1768.D0/3.D0*
     &    Hr5(0,1,0,0,1) + 2248.D0/3.D0*Hr5(0,1,0,0,1)*x - 192.D0*Hr5(0
     &    ,1,0,0,1)*dp - 3200.D0/3.D0*Hr5(0,1,0,0,1)*dm + 2080.D0/3.D0*
     &    Hr5(0,1,0,1,0) + 736.D0*Hr5(0,1,0,1,0)*x + 128.D0/3.D0*Hr5(0,
     &    1,0,1,0)*dp - 3488.D0/3.D0*Hr5(0,1,0,1,0)*dm + 2048.D0/3.D0*
     &    Hr5(0,1,0,1,1) + 2048.D0/3.D0*Hr5(0,1,0,1,1)*x - 3520.D0/3.D0
     &    *Hr5(0,1,0,1,1)*dm + 1576.D0/3.D0*Hr5(0,1,1,0,0) + 712.D0/3.D0
     &    *Hr5(0,1,1,0,0)*x - 128.D0*Hr5(0,1,1,0,0)*dp - 1888.D0/3.D0*
     &    Hr5(0,1,1,0,0)*dm + 736.D0*Hr5(0,1,1,0,1) + 2144.D0/3.D0*Hr5(
     &    0,1,1,0,1)*x )
      c3qq3 = c3qq3 + cf**3 * (  - 64.D0/3.D0*Hr5(0,1,1,0,1)*dp - 3680.D
     &    0/3.D0*Hr5(0,1,1,0,1)*dm + 2512.D0/3.D0*Hr5(0,1,1,1,0) + 2576.
     &    D0/3.D0*Hr5(0,1,1,1,0)*x + 64.D0/3.D0*Hr5(0,1,1,1,0)*dp - 
     &    1440.D0*Hr5(0,1,1,1,0)*dm + 672.D0*Hr5(0,1,1,1,1) + 672.D0*
     &    Hr5(0,1,1,1,1)*x - 1152.D0*Hr5(0,1,1,1,1)*dm + 3232.D0/3.D0*
     &    Hr5(1,0,-1,-1,0) + 2848.D0/3.D0*Hr5(1,0,-1,-1,0)*x - 6080.D0/
     &    3.D0*Hr5(1,0,-1,-1,0)*dm - 320.D0/3.D0*Hr5(1,0,-1,0,0) - 896.D
     &    0/3.D0*Hr5(1,0,-1,0,0)*x + 1216.D0/3.D0*Hr5(1,0,-1,0,0)*dm + 
     &    992.D0*Hr5(1,0,-1,0,1) + 480.D0*Hr5(1,0,-1,0,1)*x - 1472.D0*
     &    Hr5(1,0,-1,0,1)*dm - 800.D0/3.D0*Hr5(1,0,0,-1,0) - 992.D0/3.D0
     &    *Hr5(1,0,0,-1,0)*x + 1792.D0/3.D0*Hr5(1,0,0,-1,0)*dm - 432.D0
     &    *Hr5(1,0,0,0,0) - 112.D0*Hr5(1,0,0,0,0)*x + 544.D0*Hr5(1,0,0,
     &    0,0)*dm - 336.D0*Hr5(1,0,0,0,1) + 432.D0*Hr5(1,0,0,0,1)*x - 
     &    96.D0*Hr5(1,0,0,0,1)*dm + 1552.D0/3.D0*Hr5(1,0,0,1,0) + 1744.D
     &    0/3.D0*Hr5(1,0,0,1,0)*x - 3296.D0/3.D0*Hr5(1,0,0,1,0)*dm + 
     &    1600.D0/3.D0*Hr5(1,0,0,1,1) )
      c3qq3 = c3qq3 + cf**3 * ( 1792.D0/3.D0*Hr5(1,0,0,1,1)*x - 3392.D0/
     &    3.D0*Hr5(1,0,0,1,1)*dm + 1136.D0/3.D0*Hr5(1,0,1,0,0) + 560.D0/
     &    3.D0*Hr5(1,0,1,0,0)*x - 1696.D0/3.D0*Hr5(1,0,1,0,0)*dm + 576.D
     &    0*Hr5(1,0,1,0,1) + 576.D0*Hr5(1,0,1,0,1)*x - 1152.D0*Hr5(1,0,
     &    1,0,1)*dm + 1984.D0/3.D0*Hr5(1,0,1,1,0) + 1984.D0/3.D0*Hr5(1,
     &    0,1,1,0)*x - 3968.D0/3.D0*Hr5(1,0,1,1,0)*dm + 528.D0*Hr5(1,0,
     &    1,1,1) + 528.D0*Hr5(1,0,1,1,1)*x - 1056.D0*Hr5(1,0,1,1,1)*dm
     &     + 1888.D0/3.D0*Hr5(1,1,0,-1,0) + 1120.D0/3.D0*Hr5(1,1,0,-1,0
     &    )*x - 3008.D0/3.D0*Hr5(1,1,0,-1,0)*dm - 1760.D0/3.D0*Hr5(1,1,
     &    0,0,0) - 608.D0/3.D0*Hr5(1,1,0,0,0)*x + 2368.D0/3.D0*Hr5(1,1,
     &    0,0,0)*dm + 320.D0*Hr5(1,1,0,0,1) + 896.D0*Hr5(1,1,0,0,1)*x
     &     - 1216.D0*Hr5(1,1,0,0,1)*dm + 672.D0*Hr5(1,1,0,1,0) + 672.D0
     &    *Hr5(1,1,0,1,0)*x - 1344.D0*Hr5(1,1,0,1,0)*dm + 528.D0*Hr5(1,
     &    1,0,1,1) + 528.D0*Hr5(1,1,0,1,1)*x - 1056.D0*Hr5(1,1,0,1,1)*
     &    dm + 592.D0*Hr5(1,1,1,0,0) + 144.D0*Hr5(1,1,1,0,0)*x - 736.D0
     &    *Hr5(1,1,1,0,0)*dm )
      c3qq3 = c3qq3 + cf**3 * ( 576.D0*Hr5(1,1,1,0,1) + 576.D0*Hr5(1,1,
     &    1,0,1)*x - 1152.D0*Hr5(1,1,1,0,1)*dm + 672.D0*Hr5(1,1,1,1,0)
     &     + 672.D0*Hr5(1,1,1,1,0)*x - 1344.D0*Hr5(1,1,1,1,0)*dm + 480.D
     &    0*Hr5(1,1,1,1,1) + 480.D0*Hr5(1,1,1,1,1)*x - 960.D0*Hr5(1,1,1
     &    ,1,1)*dm )
      c3qq3 = c3qq3 + nf*cf*ca * ( 17593.D0/729.D0 - 327431.D0/729.D0*x
     &     + 8.D0*z4 - 116.D0/3.D0*z4*x + 32.D0/3.D0*z4*x**2 - 152.D0/3.
     &    D0*dp*z4 + 160906.D0/729.D0*dm + 112.D0/3.D0*dm*z4 + 1240.D0/
     &    27.D0*z3 - 1892.D0/27.D0*z3*x + 64.D0/3.D0*z3*x**2 - 160.D0/3.
     &    D0*z3*dp + 988.D0/27.D0*z3*dm + 4448.D0/81.D0*z2 + 1660.D0/9.D
     &    0*z2*x - 376.D0/9.D0*z2*x**2 - 1328.D0/81.D0*z2*dp - 23156.D0/
     &    81.D0*z2*dm - 224.D0/9.D0*Hr1(-1)*z3 + 32.D0/9.D0*Hr1(-1)*z3*
     &    x + 256.D0/9.D0*Hr1(-1)*z3*dp - 320.D0/27.D0*Hr1(-1)*z2 + 
     &    1280.D0/27.D0*Hr1(-1)*z2*x + 16.D0*Hr1(-1)*z2*x**2 + 16.D0*
     &    Hr1(-1)*z2*dx + 1600.D0/27.D0*Hr1(-1)*z2*dp - 1478.D0/9.D0*
     &    Hr1(0) - 42442.D0/81.D0*Hr1(0)*x + 232.D0/9.D0*Hr1(0)*dp + 
     &    39818.D0/81.D0*Hr1(0)*dm - 112.D0/9.D0*Hr1(0)*z3 - 104.D0/3.D0
     &    *Hr1(0)*z3*x + 16.D0/3.D0*Hr1(0)*z3*x**2 - 176.D0/9.D0*Hr1(0)
     &    *z3*dp + 592.D0/9.D0*Hr1(0)*z3*dm + 52.D0/27.D0*Hr1(0)*z2 + 
     &    64.D0/3.D0*Hr1(0)*z2*x - 112.D0/3.D0*Hr1(0)*z2*x**2 - 184.D0/
     &    27.D0*Hr1(0)*z2*dp )
      c3qq3 = c3qq3 + nf*cf*ca * (  - 3124.D0/27.D0*Hr1(0)*z2*dm - 1966.
     &    D0/81.D0*Hr1(1) - 21610.D0/81.D0*Hr1(1)*x + 15062.D0/81.D0*
     &    Hr1(1)*dm + 40.D0/9.D0*Hr1(1)*z3 - 104.D0/9.D0*Hr1(1)*z3*x + 
     &    16.D0/3.D0*Hr1(1)*z3*x**2 - 16.D0/3.D0*Hr1(1)*z3*dx + 64.D0/9.
     &    D0*Hr1(1)*z3*dm + 124.D0/3.D0*Hr1(1)*z2 + 112.D0/3.D0*Hr1(1)*
     &    z2*x - 64.D0/3.D0*Hr1(1)*z2*x**2 + 16.D0/3.D0*Hr1(1)*z2*dx - 
     &    832.D0/9.D0*Hr1(1)*z2*dm + 256.D0/9.D0*Hr2(-1,-1)*z2 - 64.D0/
     &    9.D0*Hr2(-1,-1)*z2*x - 320.D0/9.D0*Hr2(-1,-1)*z2*dp - 2464.D0/
     &    81.D0*Hr2(-1,0) - 5120.D0/81.D0*Hr2(-1,0)*x - 376.D0/9.D0*
     &    Hr2(-1,0)*x**2 - 376.D0/9.D0*Hr2(-1,0)*dx - 2656.D0/81.D0*
     &    Hr2(-1,0)*dp - 160.D0/9.D0*Hr2(-1,0)*z2 + 64.D0/9.D0*Hr2(-1,0
     &    )*z2*x + 224.D0/9.D0*Hr2(-1,0)*z2*dp - 16.D0/9.D0*Hr2(0,-1)*
     &    z2 + 208.D0/9.D0*Hr2(0,-1)*z2*x + 416.D0/9.D0*Hr2(0,-1)*z2*dp
     &     - 128.D0/3.D0*Hr2(0,-1)*z2*dm - 284.D0/3.D0*Hr2(0,0) - 22036.
     &    D0/81.D0*Hr2(0,0)*x + 376.D0/9.D0*Hr2(0,0)*x**2 + 3056.D0/81.D
     &    0*Hr2(0,0)*dp )
      c3qq3 = c3qq3 + nf*cf*ca * ( 32500.D0/81.D0*Hr2(0,0)*dm + 224.D0/
     &    9.D0*Hr2(0,0)*z2 + 40.D0/3.D0*Hr2(0,0)*z2*x - 16.D0/3.D0*Hr2(
     &    0,0)*z2*x**2 - 80.D0/9.D0*Hr2(0,0)*z2*dp - 368.D0/9.D0*Hr2(0,
     &    0)*z2*dm - 256.D0/3.D0*Hr2(0,1) - 1660.D0/9.D0*Hr2(0,1)*x + 
     &    7276.D0/27.D0*Hr2(0,1)*dm + 352.D0/9.D0*Hr2(0,1)*z2 + 136.D0/
     &    9.D0*Hr2(0,1)*z2*x - 512.D0/9.D0*Hr2(0,1)*z2*dm - 988.D0/27.D0
     &    *Hr2(1,0) - 2164.D0/27.D0*Hr2(1,0)*x + 2864.D0/27.D0*Hr2(1,0)
     &    *dm + 512.D0/9.D0*Hr2(1,0)*z2 + 176.D0/9.D0*Hr2(1,0)*z2*x - 
     &    16.D0/3.D0*Hr2(1,0)*z2*x**2 + 16.D0/3.D0*Hr2(1,0)*z2*dx - 688.
     &    D0/9.D0*Hr2(1,0)*z2*dm - 1312.D0/27.D0*Hr2(1,1) - 2476.D0/27.D
     &    0*Hr2(1,1)*x + 3104.D0/27.D0*Hr2(1,1)*dm + 320.D0/9.D0*Hr2(1,
     &    1)*z2 + 80.D0/9.D0*Hr2(1,1)*z2*x - 400.D0/9.D0*Hr2(1,1)*z2*dm
     &     - 512.D0/9.D0*Hr3(-1,-1,0) + 128.D0/9.D0*Hr3(-1,-1,0)*x + 32.
     &    D0/3.D0*Hr3(-1,-1,0)*x**2 + 32.D0/3.D0*Hr3(-1,-1,0)*dx + 640.D
     &    0/9.D0*Hr3(-1,-1,0)*dp + 512.D0/27.D0*Hr3(-1,0,0) - 2048.D0/
     &    27.D0*Hr3(-1,0,0)*x )
      c3qq3 = c3qq3 + nf*cf*ca * (  - 32.D0*Hr3(-1,0,0)*x**2 - 32.D0*
     &    Hr3(-1,0,0)*dx - 2560.D0/27.D0*Hr3(-1,0,0)*dp - 448.D0/27.D0*
     &    Hr3(-1,0,1) - 1088.D0/27.D0*Hr3(-1,0,1)*x - 32.D0/3.D0*Hr3(-1
     &    ,0,1)*x**2 - 32.D0/3.D0*Hr3(-1,0,1)*dx - 640.D0/27.D0*Hr3(-1,
     &    0,1)*dp - 496.D0/27.D0*Hr3(0,-1,0) - 1472.D0/27.D0*Hr3(0,-1,0
     &    )*x - 32.D0/3.D0*Hr3(0,-1,0)*x**2 - 64.D0/3.D0*Hr3(0,-1,0)*dx
     &     - 1600.D0/27.D0*Hr3(0,-1,0)*dp + 208.D0/3.D0*Hr3(0,-1,0)*dm
     &     - 248.D0/9.D0*Hr3(0,0,0) - 776.D0/27.D0*Hr3(0,0,0)*x + 32.D0
     &    *Hr3(0,0,0)*x**2 + 664.D0/27.D0*Hr3(0,0,0)*dp + 4712.D0/27.D0
     &    *Hr3(0,0,0)*dm - 548.D0/27.D0*Hr3(0,0,1) - 64.D0/3.D0*Hr3(0,0
     &    ,1)*x + 80.D0/3.D0*Hr3(0,0,1)*x**2 + 320.D0/27.D0*Hr3(0,0,1)*
     &    dp + 3260.D0/27.D0*Hr3(0,0,1)*dm - 436.D0/9.D0*Hr3(0,1,0) - 
     &    40.D0*Hr3(0,1,0)*x - 16.D0*Hr3(0,1,0)*x**2 + 860.D0/9.D0*Hr3(
     &    0,1,0)*dm - 296.D0/9.D0*Hr3(0,1,1) - 296.D0/9.D0*Hr3(0,1,1)*x
     &     + 704.D0/9.D0*Hr3(0,1,1)*dm - 416.D0/9.D0*Hr3(1,0,0) - 176.D0
     &    /9.D0*Hr3(1,0,0)*x )
      c3qq3 = c3qq3 + nf*cf*ca * ( 592.D0/9.D0*Hr3(1,0,0)*dm - 116.D0/9.
     &    D0*Hr3(1,0,1) - 272.D0/9.D0*Hr3(1,0,1)*x + 16.D0*Hr3(1,0,1)*
     &    x**2 + 512.D0/9.D0*Hr3(1,0,1)*dm - 236.D0/9.D0*Hr3(1,1,0) - 
     &    80.D0/9.D0*Hr3(1,1,0)*x - 16.D0*Hr3(1,1,0)*x**2 + 64.D0/3.D0*
     &    Hr3(1,1,0)*dm - 176.D0/9.D0*Hr3(1,1,1) - 176.D0/9.D0*Hr3(1,1,
     &    1)*x + 352.D0/9.D0*Hr3(1,1,1)*dm + 512.D0/9.D0*Hr4(-1,-1,-1,0
     &    ) - 128.D0/9.D0*Hr4(-1,-1,-1,0)*x - 640.D0/9.D0*Hr4(-1,-1,-1,
     &    0)*dp - 832.D0/9.D0*Hr4(-1,-1,0,0) + 256.D0/9.D0*Hr4(-1,-1,0,
     &    0)*x + 1088.D0/9.D0*Hr4(-1,-1,0,0)*dp - 544.D0/9.D0*Hr4(-1,0,
     &    -1,0) + 160.D0/9.D0*Hr4(-1,0,-1,0)*x + 704.D0/9.D0*Hr4(-1,0,
     &    -1,0)*dp + 688.D0/9.D0*Hr4(-1,0,0,0) - 400.D0/9.D0*Hr4(-1,0,0
     &    ,0)*x - 1088.D0/9.D0*Hr4(-1,0,0,0)*dp + 32.D0/9.D0*Hr4(-1,0,0
     &    ,1) - 32.D0/9.D0*Hr4(-1,0,0,1)*x - 64.D0/9.D0*Hr4(-1,0,0,1)*
     &    dp - 64.D0/9.D0*Hr4(-1,0,1,1) + 64.D0/9.D0*Hr4(-1,0,1,1)*x + 
     &    128.D0/9.D0*Hr4(-1,0,1,1)*dp - 544.D0/9.D0*Hr4(0,-1,-1,0) + 
     &    160.D0/9.D0*Hr4(0,-1,-1,0)*x )
      c3qq3 = c3qq3 + nf*cf*ca * ( 704.D0/9.D0*Hr4(0,-1,-1,0)*dp + 208.D
     &    0/9.D0*Hr4(0,-1,0,0) - 592.D0/9.D0*Hr4(0,-1,0,0)*x - 1088.D0/
     &    9.D0*Hr4(0,-1,0,0)*dp + 256.D0/3.D0*Hr4(0,-1,0,0)*dm - 256.D0/
     &    9.D0*Hr4(0,-1,0,1) - 128.D0/9.D0*Hr4(0,-1,0,1)*x - 64.D0/9.D0
     &    *Hr4(0,-1,0,1)*dp + 128.D0/3.D0*Hr4(0,-1,0,1)*dm + 16.D0/9.D0
     &    *Hr4(0,0,-1,0) - 496.D0/9.D0*Hr4(0,0,-1,0)*x - 800.D0/9.D0*
     &    Hr4(0,0,-1,0)*dp + 256.D0/3.D0*Hr4(0,0,-1,0)*dm - 368.D0/9.D0
     &    *Hr4(0,0,0,0) + 368.D0/9.D0*Hr4(0,0,0,0)*dp + 368.D0/9.D0*
     &    Hr4(0,0,0,0)*dm - 208.D0/9.D0*Hr4(0,0,0,1) - 40.D0/3.D0*Hr4(0
     &    ,0,0,1)*x + 16.D0/3.D0*Hr4(0,0,0,1)*x**2 + 64.D0/9.D0*Hr4(0,0
     &    ,0,1)*dp + 352.D0/9.D0*Hr4(0,0,0,1)*dm - 8.D0*Hr4(0,0,1,0) - 
     &    32.D0/3.D0*Hr4(0,0,1,0)*x + 16.D0*Hr4(0,0,1,0)*dm - 56.D0/9.D0
     &    *Hr4(0,0,1,1) - 40.D0/3.D0*Hr4(0,0,1,1)*x - 64.D0/9.D0*Hr4(0,
     &    0,1,1)*dp + 176.D0/9.D0*Hr4(0,0,1,1)*dm - 104.D0/9.D0*Hr4(0,1
     &    ,0,0) - 8.D0/9.D0*Hr4(0,1,0,0)*x - 16.D0/3.D0*Hr4(0,1,0,0)*
     &    x**2 )
      c3qq3 = c3qq3 + nf*cf*ca * ( 112.D0/9.D0*Hr4(0,1,0,0)*dm - 80.D0/
     &    9.D0*Hr4(0,1,0,1) - 56.D0/9.D0*Hr4(0,1,0,1)*x + 160.D0/9.D0*
     &    Hr4(0,1,0,1)*dm + 80.D0/9.D0*Hr4(0,1,1,0) + 56.D0/9.D0*Hr4(0,
     &    1,1,0)*x - 160.D0/9.D0*Hr4(0,1,1,0)*dm - 32.D0*Hr4(1,0,-1,0)
     &     - 32.D0/3.D0*Hr4(1,0,-1,0)*x + 128.D0/3.D0*Hr4(1,0,-1,0)*dm
     &     - 272.D0/9.D0*Hr4(1,0,0,0) + 16.D0/9.D0*Hr4(1,0,0,0)*x + 256.
     &    D0/9.D0*Hr4(1,0,0,0)*dm - 128.D0/3.D0*Hr4(1,0,0,1) - 16.D0*
     &    Hr4(1,0,0,1)*x + 16.D0/3.D0*Hr4(1,0,0,1)*x**2 - 16.D0/3.D0*
     &    Hr4(1,0,0,1)*dx + 176.D0/3.D0*Hr4(1,0,0,1)*dm + 32.D0/3.D0*
     &    Hr4(1,0,1,0) + 16.D0/3.D0*Hr4(1,0,1,0)*x - 16.D0*Hr4(1,0,1,0)
     &    *dm - 8.D0*Hr4(1,0,1,1) - 8.D0*Hr4(1,0,1,1)*x + 16.D0*Hr4(1,0
     &    ,1,1)*dm + 104.D0/9.D0*Hr4(1,1,0,0) + 104.D0/9.D0*Hr4(1,1,0,0
     &    )*x - 16.D0/3.D0*Hr4(1,1,0,0)*x**2 + 16.D0/3.D0*Hr4(1,1,0,0)*
     &    dx - 208.D0/9.D0*Hr4(1,1,0,0)*dm - 64.D0/9.D0*Hr4(1,1,0,1) - 
     &    16.D0/9.D0*Hr4(1,1,0,1)*x + 80.D0/9.D0*Hr4(1,1,0,1)*dm + 136.D
     &    0/9.D0*Hr4(1,1,1,0) )
      c3qq3 = c3qq3 + nf*cf*ca * ( 88.D0/9.D0*Hr4(1,1,1,0)*x - 224.D0/9.
     &    D0*Hr4(1,1,1,0)*dm )
      c3qq3 = c3qq3 + nf*cf**2 * ( 2909.D0/18.D0 - 2371.D0/27.D0*x - 
     &    1216.D0/9.D0*z4 - 544.D0/9.D0*z4*x + 304.D0/3.D0*dp*z4 - 2003.
     &    D0/108.D0*dm + 1244.D0/9.D0*dm*z4 + 1846.D0/27.D0*z3 + 10174.D
     &    0/27.D0*z3*x - 176.D0/3.D0*z3*x**2 + 320.D0/3.D0*z3*dp - 9668.
     &    D0/27.D0*z3*dm + 9586.D0/81.D0*z2 + 20486.D0/81.D0*z2*x + 752.
     &    D0/9.D0*z2*x**2 + 2656.D0/81.D0*z2*dp - 1538.D0/27.D0*z2*dm
     &     + 448.D0/9.D0*Hr1(-1)*z3 - 64.D0/9.D0*Hr1(-1)*z3*x - 512.D0/
     &    9.D0*Hr1(-1)*z3*dp + 640.D0/27.D0*Hr1(-1)*z2 - 2560.D0/27.D0*
     &    Hr1(-1)*z2*x - 32.D0*Hr1(-1)*z2*x**2 - 32.D0*Hr1(-1)*z2*dx - 
     &    3200.D0/27.D0*Hr1(-1)*z2*dp + 26771.D0/162.D0*Hr1(0) + 4387.D0
     &    /162.D0*Hr1(0)*x - 464.D0/9.D0*Hr1(0)*dp - 4795.D0/27.D0*Hr1(
     &    0)*dm + 956.D0/9.D0*Hr1(0)*z3 + 500.D0/3.D0*Hr1(0)*z3*x + 352.
     &    D0/9.D0*Hr1(0)*z3*dp - 2336.D0/9.D0*Hr1(0)*z3*dm + 7342.D0/27.
     &    D0*Hr1(0)*z2 + 1078.D0/3.D0*Hr1(0)*z2*x + 80.D0*Hr1(0)*z2*
     &    x**2 + 368.D0/27.D0*Hr1(0)*z2*dp - 8428.D0/27.D0*Hr1(0)*z2*dm
     &     + 1283.D0/18.D0*Hr1(1) )
      c3qq3 = c3qq3 + nf*cf**2 * (  - 1613.D0/18.D0*Hr1(1)*x - 83.D0/9.D
     &    0*Hr1(1)*dm + 376.D0/9.D0*Hr1(1)*z3 + 664.D0/9.D0*Hr1(1)*z3*x
     &     - 1040.D0/9.D0*Hr1(1)*z3*dm + 536.D0/9.D0*Hr1(1)*z2 + 1400.D0
     &    /9.D0*Hr1(1)*z2*x + 48.D0*Hr1(1)*z2*x**2 - 32.D0/3.D0*Hr1(1)*
     &    z2*dx - 1408.D0/9.D0*Hr1(1)*z2*dm - 512.D0/9.D0*Hr2(-1,-1)*z2
     &     + 128.D0/9.D0*Hr2(-1,-1)*z2*x + 640.D0/9.D0*Hr2(-1,-1)*z2*dp
     &     + 4928.D0/81.D0*Hr2(-1,0) + 10240.D0/81.D0*Hr2(-1,0)*x + 752.
     &    D0/9.D0*Hr2(-1,0)*x**2 + 752.D0/9.D0*Hr2(-1,0)*dx + 5312.D0/
     &    81.D0*Hr2(-1,0)*dp + 320.D0/9.D0*Hr2(-1,0)*z2 - 128.D0/9.D0*
     &    Hr2(-1,0)*z2*x - 448.D0/9.D0*Hr2(-1,0)*z2*dp + 32.D0/9.D0*
     &    Hr2(0,-1)*z2 - 416.D0/9.D0*Hr2(0,-1)*z2*x - 832.D0/9.D0*Hr2(0
     &    ,-1)*z2*dp + 256.D0/3.D0*Hr2(0,-1)*z2*dm - 11948.D0/81.D0*
     &    Hr2(0,0) - 4954.D0/27.D0*Hr2(0,0)*x - 752.D0/9.D0*Hr2(0,0)*
     &    x**2 - 6112.D0/81.D0*Hr2(0,0)*dp - 1082.D0/27.D0*Hr2(0,0)*dm
     &     + 308.D0/3.D0*Hr2(0,0)*z2 + 1084.D0/9.D0*Hr2(0,0)*z2*x + 160.
     &    D0/9.D0*Hr2(0,0)*z2*dp )
      c3qq3 = c3qq3 + nf*cf**2 * (  - 1456.D0/9.D0*Hr2(0,0)*z2*dm - 
     &    4658.D0/81.D0*Hr2(0,1) - 20486.D0/81.D0*Hr2(0,1)*x + 7270.D0/
     &    81.D0*Hr2(0,1)*dm + 136.D0/9.D0*Hr2(0,1)*z2 + 520.D0/9.D0*
     &    Hr2(0,1)*z2*x - 512.D0/9.D0*Hr2(0,1)*z2*dm - 5792.D0/81.D0*
     &    Hr2(1,0) - 17516.D0/81.D0*Hr2(1,0)*x + 15334.D0/81.D0*Hr2(1,0
     &    )*dm - 24.D0*Hr2(1,0)*z2 + 152.D0/3.D0*Hr2(1,0)*z2*x - 80.D0/
     &    3.D0*Hr2(1,0)*z2*dm - 92.D0/9.D0*Hr2(1,1) - 1816.D0/9.D0*Hr2(
     &    1,1)*x + 1366.D0/9.D0*Hr2(1,1)*dm - 80.D0/9.D0*Hr2(1,1)*z2 + 
     &    400.D0/9.D0*Hr2(1,1)*z2*x - 320.D0/9.D0*Hr2(1,1)*z2*dm + 1024.
     &    D0/9.D0*Hr3(-1,-1,0) - 256.D0/9.D0*Hr3(-1,-1,0)*x - 64.D0/3.D0
     &    *Hr3(-1,-1,0)*x**2 - 64.D0/3.D0*Hr3(-1,-1,0)*dx - 1280.D0/9.D0
     &    *Hr3(-1,-1,0)*dp - 1024.D0/27.D0*Hr3(-1,0,0) + 4096.D0/27.D0*
     &    Hr3(-1,0,0)*x + 64.D0*Hr3(-1,0,0)*x**2 + 64.D0*Hr3(-1,0,0)*dx
     &     + 5120.D0/27.D0*Hr3(-1,0,0)*dp + 896.D0/27.D0*Hr3(-1,0,1) + 
     &    2176.D0/27.D0*Hr3(-1,0,1)*x + 64.D0/3.D0*Hr3(-1,0,1)*x**2 + 
     &    64.D0/3.D0*Hr3(-1,0,1)*dx )
      c3qq3 = c3qq3 + nf*cf**2 * ( 1280.D0/27.D0*Hr3(-1,0,1)*dp + 992.D0
     &    /27.D0*Hr3(0,-1,0) + 2944.D0/27.D0*Hr3(0,-1,0)*x + 64.D0/3.D0
     &    *Hr3(0,-1,0)*x**2 + 128.D0/3.D0*Hr3(0,-1,0)*dx + 3200.D0/27.D0
     &    *Hr3(0,-1,0)*dp - 416.D0/3.D0*Hr3(0,-1,0)*dm - 6298.D0/27.D0*
     &    Hr3(0,0,0) - 2830.D0/9.D0*Hr3(0,0,0)*x - 64.D0*Hr3(0,0,0)*
     &    x**2 - 1328.D0/27.D0*Hr3(0,0,0)*dp + 3268.D0/27.D0*Hr3(0,0,0)
     &    *dm - 6350.D0/27.D0*Hr3(0,0,1) - 1078.D0/3.D0*Hr3(0,0,1)*x - 
     &    176.D0/3.D0*Hr3(0,0,1)*x**2 - 640.D0/27.D0*Hr3(0,0,1)*dp + 
     &    8156.D0/27.D0*Hr3(0,0,1)*dm - 2704.D0/27.D0*Hr3(0,1,0) - 5584.
     &    D0/27.D0*Hr3(0,1,0)*x + 112.D0/3.D0*Hr3(0,1,0)*x**2 + 5552.D0/
     &    27.D0*Hr3(0,1,0)*dm - 992.D0/9.D0*Hr3(0,1,1) - 656.D0/3.D0*
     &    Hr3(0,1,1)*x + 688.D0/3.D0*Hr3(0,1,1)*dm - 1448.D0/27.D0*Hr3(
     &    1,0,0) - 4544.D0/27.D0*Hr3(1,0,0)*x + 5020.D0/27.D0*Hr3(1,0,0
     &    )*dm - 1048.D0/9.D0*Hr3(1,0,1) - 1528.D0/9.D0*Hr3(1,0,1)*x - 
     &    112.D0/3.D0*Hr3(1,0,1)*x**2 + 2048.D0/9.D0*Hr3(1,0,1)*dm - 
     &    664.D0/9.D0*Hr3(1,1,0) )
      c3qq3 = c3qq3 + nf*cf**2 * (  - 536.D0/3.D0*Hr3(1,1,0)*x + 112.D0/
     &    3.D0*Hr3(1,1,0)*x**2 + 2152.D0/9.D0*Hr3(1,1,0)*dm - 72.D0*
     &    Hr3(1,1,1) - 440.D0/3.D0*Hr3(1,1,1)*x + 560.D0/3.D0*Hr3(1,1,1
     &    )*dm - 1024.D0/9.D0*Hr4(-1,-1,-1,0) + 256.D0/9.D0*Hr4(-1,-1,
     &    -1,0)*x + 1280.D0/9.D0*Hr4(-1,-1,-1,0)*dp + 1664.D0/9.D0*Hr4(
     &    -1,-1,0,0) - 512.D0/9.D0*Hr4(-1,-1,0,0)*x - 2176.D0/9.D0*Hr4(
     &    -1,-1,0,0)*dp + 1088.D0/9.D0*Hr4(-1,0,-1,0) - 320.D0/9.D0*
     &    Hr4(-1,0,-1,0)*x - 1408.D0/9.D0*Hr4(-1,0,-1,0)*dp - 1376.D0/9.
     &    D0*Hr4(-1,0,0,0) + 800.D0/9.D0*Hr4(-1,0,0,0)*x + 2176.D0/9.D0
     &    *Hr4(-1,0,0,0)*dp - 64.D0/9.D0*Hr4(-1,0,0,1) + 64.D0/9.D0*
     &    Hr4(-1,0,0,1)*x + 128.D0/9.D0*Hr4(-1,0,0,1)*dp + 128.D0/9.D0*
     &    Hr4(-1,0,1,1) - 128.D0/9.D0*Hr4(-1,0,1,1)*x - 256.D0/9.D0*
     &    Hr4(-1,0,1,1)*dp + 1088.D0/9.D0*Hr4(0,-1,-1,0) - 320.D0/9.D0*
     &    Hr4(0,-1,-1,0)*x - 1408.D0/9.D0*Hr4(0,-1,-1,0)*dp - 416.D0/9.D
     &    0*Hr4(0,-1,0,0) + 1184.D0/9.D0*Hr4(0,-1,0,0)*x + 2176.D0/9.D0
     &    *Hr4(0,-1,0,0)*dp )
      c3qq3 = c3qq3 + nf*cf**2 * (  - 512.D0/3.D0*Hr4(0,-1,0,0)*dm + 
     &    512.D0/9.D0*Hr4(0,-1,0,1) + 256.D0/9.D0*Hr4(0,-1,0,1)*x + 128.
     &    D0/9.D0*Hr4(0,-1,0,1)*dp - 256.D0/3.D0*Hr4(0,-1,0,1)*dm - 32.D
     &    0/9.D0*Hr4(0,0,-1,0) + 992.D0/9.D0*Hr4(0,0,-1,0)*x + 1600.D0/
     &    9.D0*Hr4(0,0,-1,0)*dp - 512.D0/3.D0*Hr4(0,0,-1,0)*dm - 356.D0/
     &    9.D0*Hr4(0,0,0,0) - 364.D0/3.D0*Hr4(0,0,0,0)*x - 736.D0/9.D0*
     &    Hr4(0,0,0,0)*dp + 80.D0*Hr4(0,0,0,0)*dm - 956.D0/9.D0*Hr4(0,0
     &    ,0,1) - 1084.D0/9.D0*Hr4(0,0,0,1)*x - 128.D0/9.D0*Hr4(0,0,0,1
     &    )*dp + 496.D0/3.D0*Hr4(0,0,0,1)*dm - 944.D0/9.D0*Hr4(0,0,1,0)
     &     - 944.D0/9.D0*Hr4(0,0,1,0)*x + 1552.D0/9.D0*Hr4(0,0,1,0)*dm
     &     - 1040.D0/9.D0*Hr4(0,0,1,1) - 304.D0/3.D0*Hr4(0,0,1,1)*x + 
     &    128.D0/9.D0*Hr4(0,0,1,1)*dp + 1616.D0/9.D0*Hr4(0,0,1,1)*dm - 
     &    544.D0/9.D0*Hr4(0,1,0,0) - 736.D0/9.D0*Hr4(0,1,0,0)*x + 1136.D
     &    0/9.D0*Hr4(0,1,0,0)*dm - 680.D0/9.D0*Hr4(0,1,0,1) - 680.D0/9.D
     &    0*Hr4(0,1,0,1)*x + 1216.D0/9.D0*Hr4(0,1,0,1)*dm - 296.D0/3.D0
     &    *Hr4(0,1,1,0) )
      c3qq3 = c3qq3 + nf*cf**2 * (  - 296.D0/3.D0*Hr4(0,1,1,0)*x + 544.D
     &    0/3.D0*Hr4(0,1,1,0)*dm - 728.D0/9.D0*Hr4(0,1,1,1) - 728.D0/9.D
     &    0*Hr4(0,1,1,1)*x + 1312.D0/9.D0*Hr4(0,1,1,1)*dm + 64.D0*Hr4(1
     &    ,0,-1,0) + 64.D0/3.D0*Hr4(1,0,-1,0)*x - 256.D0/3.D0*Hr4(1,0,
     &    -1,0)*dm - 136.D0/9.D0*Hr4(1,0,0,0) - 712.D0/9.D0*Hr4(1,0,0,0
     &    )*x + 848.D0/9.D0*Hr4(1,0,0,0)*dm - 40.D0/9.D0*Hr4(1,0,0,1)
     &     - 520.D0/9.D0*Hr4(1,0,0,1)*x + 560.D0/9.D0*Hr4(1,0,0,1)*dm
     &     - 784.D0/9.D0*Hr4(1,0,1,0) - 688.D0/9.D0*Hr4(1,0,1,0)*x + 
     &    1472.D0/9.D0*Hr4(1,0,1,0)*dm - 544.D0/9.D0*Hr4(1,0,1,1) - 544.
     &    D0/9.D0*Hr4(1,0,1,1)*x + 1088.D0/9.D0*Hr4(1,0,1,1)*dm - 728.D0
     &    /9.D0*Hr4(1,1,0,0) - 728.D0/9.D0*Hr4(1,1,0,0)*x + 1456.D0/9.D0
     &    *Hr4(1,1,0,0)*dm - 48.D0*Hr4(1,1,0,1) - 176.D0/3.D0*Hr4(1,1,0
     &    ,1)*x + 320.D0/3.D0*Hr4(1,1,0,1)*dm - 704.D0/9.D0*Hr4(1,1,1,0
     &    ) - 608.D0/9.D0*Hr4(1,1,1,0)*x + 1312.D0/9.D0*Hr4(1,1,1,0)*dm
     &     - 160.D0/3.D0*Hr4(1,1,1,1) - 160.D0/3.D0*Hr4(1,1,1,1)*x + 
     &    320.D0/3.D0*Hr4(1,1,1,1)*dm )
      c3qq3 = c3qq3 + nf**2*cf * (  - 260.D0/729.D0 + 19936.D0/729.D0*x
     &     - 8714.D0/729.D0*dm - 32.D0/27.D0*z3 - 32.D0/27.D0*z3*x + 64.
     &    D0/27.D0*z3*dm - 208.D0/27.D0*z2 - 448.D0/27.D0*z2*x + 536.D0/
     &    27.D0*z2*dm + 896.D0/81.D0*Hr1(0) + 2896.D0/81.D0*Hr1(0)*x - 
     &    860.D0/27.D0*Hr1(0)*dm - 16.D0/3.D0*Hr1(0)*z2 - 16.D0/3.D0*
     &    Hr1(0)*z2*x + 32.D0/3.D0*Hr1(0)*z2*dm + 128.D0/81.D0*Hr1(1)
     &     + 1496.D0/81.D0*Hr1(1)*x - 940.D0/81.D0*Hr1(1)*dm - 16.D0/9.D
     &    0*Hr1(1)*z2 - 16.D0/9.D0*Hr1(1)*z2*x + 32.D0/9.D0*Hr1(1)*z2*
     &    dm + 1016.D0/81.D0*Hr2(0,0) + 1928.D0/81.D0*Hr2(0,0)*x - 2440.
     &    D0/81.D0*Hr2(0,0)*dm + 208.D0/27.D0*Hr2(0,1) + 448.D0/27.D0*
     &    Hr2(0,1)*x - 536.D0/27.D0*Hr2(0,1)*dm + 80.D0/27.D0*Hr2(1,0)
     &     + 224.D0/27.D0*Hr2(1,0)*x - 232.D0/27.D0*Hr2(1,0)*dm + 80.D0/
     &    27.D0*Hr2(1,1) + 224.D0/27.D0*Hr2(1,1)*x - 232.D0/27.D0*Hr2(1
     &    ,1)*dm + 184.D0/27.D0*Hr3(0,0,0) + 184.D0/27.D0*Hr3(0,0,0)*x
     &     - 368.D0/27.D0*Hr3(0,0,0)*dm + 16.D0/3.D0*Hr3(0,0,1) + 16.D0/
     &    3.D0*Hr3(0,0,1)*x )
      c3qq3 = c3qq3 + nf**2*cf * (  - 32.D0/3.D0*Hr3(0,0,1)*dm + 32.D0/
     &    9.D0*Hr3(0,1,0) + 32.D0/9.D0*Hr3(0,1,0)*x - 64.D0/9.D0*Hr3(0,
     &    1,0)*dm + 32.D0/9.D0*Hr3(0,1,1) + 32.D0/9.D0*Hr3(0,1,1)*x - 
     &    64.D0/9.D0*Hr3(0,1,1)*dm + 16.D0/9.D0*Hr3(1,0,0) + 16.D0/9.D0
     &    *Hr3(1,0,0)*x - 32.D0/9.D0*Hr3(1,0,0)*dm + 16.D0/9.D0*Hr3(1,0
     &    ,1) + 16.D0/9.D0*Hr3(1,0,1)*x - 32.D0/9.D0*Hr3(1,0,1)*dm + 16.
     &    D0/9.D0*Hr3(1,1,0) + 16.D0/9.D0*Hr3(1,1,0)*x - 32.D0/9.D0*
     &    Hr3(1,1,0)*dm + 16.D0/9.D0*Hr3(1,1,1) + 16.D0/9.D0*Hr3(1,1,1)
     &    *x - 32.D0/9.D0*Hr3(1,1,1)*dm )
*
* ...The special contribution (from the odd moments)
*
      SP2M =
     &  + dm * (  - 18.D0*z3 + 2.D0*z2 + 8.D0/5.D0*z2**2 + 24.D0*Hr1(-1
     &    )*z2 + 12.D0*Hr1(0)*z3 - 18.D0*Hr1(0)*z2 - 16.D0*Hr2(0,-1)*z2
     &     + 12.D0*Hr2(0,0)*z2 - 12.D0*Hr3(-1,0,0) - 24.D0*Hr3(-1,0,1)
     &     + 6.D0*Hr3(0,0,0) + 12.D0*Hr3(0,0,1) + 8.D0*Hr4(0,-1,0,0) +
     &    16.D0*Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2M = SP2M + dm**3 * ( 8.D0/5.D0*z2**2 + 12.D0*Hr1(0)*z3 - 16.D0
     &    *Hr2(0,-1)*z2 + 12.D0*Hr2(0,0)*z2 + 8.D0*Hr4(0,-1,0,0) + 16.D0
     &    *Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2M = SP2M + dm**2 * ( 12.D0*z3 - 16.D0/5.D0*z2**2 - 16.D0*Hr1(
     &    -1)*z2 - 24.D0*Hr1(0)*z3 + 12.D0*Hr1(0)*z2 + 32.D0*Hr2(0,-1)*
     &    z2 - 24.D0*Hr2(0,0)*z2 + 8.D0*Hr3(-1,0,0) + 16.D0*Hr3(-1,0,1)
     &     - 4.D0*Hr3(0,0,0) - 8.D0*Hr3(0,0,1) - 16.D0*Hr4(0,-1,0,0) -
     &    32.D0*Hr4(0,-1,0,1) + 8.D0*Hr4(0,0,0,0) + 16.D0*Hr4(0,0,0,1))
      SP2M = SP2M + 10.D0*z3 - 12.D0*z3*dp + 8.D0*z3*dp**2 - 2.D0*z2*dp
     &     + 42.D0/5.D0*z2**2*dp - 84.D0/5.D0*z2**2*dp**2 + 42.D0/5.D0*
     &    z2**2*dp**3 - 8.D0*Hr1(-1)*z2 + 8.D0*Hr1(0)*z3*dp - 16.D0*
     &    Hr1(0)*z3*dp**2 + 8.D0*Hr1(0)*z3*dp**3 + 8.D0*Hr1(0)*z2 - 6.D0
     &    *Hr1(0)*z2*dp + 4.D0*Hr1(0)*z2*dp**2 - 4.D0*Hr2(-1,0) + 4.D0*
     &    Hr2(-1,0)*dp + 4.D0*Hr2(0,0)*z2*dp - 8.D0*Hr2(0,0)*z2*dp**2
     &     + 4.D0*Hr2(0,0)*z2*dp**3 - 4.D0*Hr2(0,1) + 4.D0*Hr2(0,1)*dp
     &     + 4.D0*Hr3(-1,0,0) + 8.D0*Hr3(-1,0,1) + 4.D0*Hr3(0,-1,0) -
     &    12.D0*Hr3(0,-1,0)*dp + 8.D0*Hr3(0,-1,0)*dp**2 - 4.D0*Hr3(0,0,
     &    0) + 6.D0*Hr3(0,0,0)*dp - 4.D0*Hr3(0,0,0)*dp**2 - 4.D0*Hr3(0,
     &    0,1) + 8.D0*Hr4(0,0,-1,0)*dp - 16.D0*Hr4(0,0,-1,0)*dp**2 + 8.D
     &    0*Hr4(0,0,-1,0)*dp**3 - 4.D0*Hr4(0,0,0,0)*dp + 8.D0*Hr4(0,0,0
     &    ,0)*dp**2 - 4.D0*Hr4(0,0,0,0)*dp**3
       if (x .gt. 0.995D0) then
         SP2M =   (1.-x)* (-DL1-0.5*z2+z3+0.75D0)
     ,          + (1.-x)**2 * (-0.5)
* ...For 5-digit accuracy down to x=0.9
c    ,          + (1.-x)**3 * (DL1/3.d0+z2/18.d0-z3/3.d0-5./12.d0)
c    ,          + (1.-x)**4 * (DL1/3.d0+z2/18.d0-z3/3.d0-1./6.d0)
c    ,          + (1.-x)**5 * (31./120.d0*DL1+17./360.d0*z2-7./30.d0*z3
c    ,                         -223./4800.d0)
       endif
*
* ...The soft (`+'-distribution) part of the coefficient function
*
*
       C3QQ3L = DM * ( DL1**5 * C3A5 + DL1**4 * C3A4 + DL1**3 * C3A3
     ,               + DL1**2 * C3A2 + DL1    * C3A1 + C3A0 )
*
* ...The regular piece of the coefficient function
*
       X3NM3A = C3QQ3 + SP2M/3.D0* CF*(CA-2.*CF)**2 - C3QQ3L
*
       RETURN
       END

      FUNCTION X3NM3A_large_x (Y, DL, NF)
      IMPLICIT REAL*8 (A - Z)
      INTEGER NF

      DL1 = DL1VAL(Y, DL)
      
      X3NM3A_large_x = 6889.89378009207d0*DL1 + 1581.208087862925d0*DL1
     $     **2 -1609.6420585153533d0*DL1**3 + 329.48148148148147d0*DL1
     $     **4 -18.962962962962962d0*DL1**5 +(859.380948706157d0*DL1 -
     $     675.1899801124716d0*DL1**2 +134.0576131687243d0*DL1**3 -
     $     7.901234567901234d0*DL1**4)*NF +(-50.144180884735974d0*DL1 +
     $     12.246913580246913d0*DL1**2 -0.7901234567901234d0*DL1**3)*NF
     $     **2
      
      END FUNCTION
*
* ---------------------------------------------------------------------
*
*
* ..This is the singular (soft) piece. Note that this function receives
*    its coefficients from X3NM3A, hence that needs to be called first.
*
       FUNCTION X3NS3B (Y, DL, NF)
       IMPLICIT REAL*8 (A - Z)
       INTEGER NF
*
       COMMON / C3SOFTN3LO / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5
*
       DL1 = DL1VAL(Y, DL) !LOG (1.D0-Y)
       DM  = DMVAL(Y, DL) !1.D0/(1.D0-Y)
*
       X3NS3B = DM * ( DL1**5 * C3A5 + DL1**4 * C3A4 + DL1**3 * C3A3
     ,               + DL1**2 * C3A2 + DL1    * C3A1 + C3A0 )
*
       RETURN
       END
*
* ---------------------------------------------------------------------
*
*
* ..This is the 'local' piece. Same comment as for X3NS3B above.
*
       FUNCTION X3NS3C (Y, DL, NF)
*
       IMPLICIT REAL*8 (A - Z)
       INTEGER NF, NF2
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0, 
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
*
       COMMON / C3SOFTN3LO / C3A0, C3A1, C3A2, C3A3, C3A4, C3A5
*
* ...Colour factors
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
*
* ...The coefficient of delta(1-x)
*
       C3DELT =
     &     - 7255.D0/24.D0*cf**3
     &     - 1129.D0/2.D0*z2*cf**3
     &     - 950.D0/3.D0*z3*cf**3
     &     - 1074.D0*z4*cf**3
     &     + 808.D0*z2*z3*cf**3
     &     + 1240.D0*z5*cf**3
     &     + 2092.D0/63.D0*z2*z4*cf**3
     &     - 304.D0/3.D0*z3**2*cf**3
     &     + 9161.D0/12.D0*ca*cf**2
     &     + 104189.D0/54.D0*z2*ca*cf**2
     &     - 2141.D0*z3*ca*cf**2
     &     + 43816.D0/27.D0*z4*ca*cf**2
     &     - 6644.D0/9.D0*z2*z3*ca*cf**2
     &     - 4952.D0/9.D0*z5*ca*cf**2
     &     - 16778.D0/63.D0*z2*z4*ca*cf**2
     &     + 1016.D0/3.D0*z3**2*ca*cf**2
     &     - 1909753.D0/1944.D0*ca**2*cf
     &     - 143282.D0/81.D0*z2*ca**2*cf
     &     + 105739.D0/81.D0*z3*ca**2*cf
     &     + 12592.D0/27.D0*z4*ca**2*cf
     &     + 540.D0*z2*z3*ca**2*cf
     &     - 416.D0/3.D0*z5*ca**2*cf
     &     - 8780.D0/63.D0*z2*z4*ca**2*cf
     &     - 248.D0/3.D0*z3**2*ca**2*cf
     &     + 1./3.D0* CF*(CA-2.*CF)**2 *(z2-z3)
*
     &     - 341.D0/36.D0*cf**2*nf
     &     - 5491.D0/27.D0*z2*cf**2*nf
     &     + 1348.D0/3.D0*z3*cf**2*nf
     &     - 8236.D0/27.D0*z4*cf**2*nf
     &     - 352.D0/9.D0*z2*z3*cf**2*nf
     &     - 592.D0/9.D0*z5*cf**2*nf
     &     + 142883.D0/486.D0*ca*cf*nf
     &     + 40862.D0/81.D0*z2*ca*cf*nf
     &     - 18314.D0/81.D0*z3*ca*cf*nf
     &     - 1244.D0/27.D0*z4*ca*cf*nf
     &     - 56.D0/3.D0*z2*z3*ca*cf*nf
     &     + 8.D0/3.D0*z5*ca*cf*nf
*
     &     - 9517.D0/486.D0*cf*nf2
     &     - 860.D0/27.D0*z2*cf*nf2
     &     - 152.D0/81.D0*z3*cf*nf2
     &     - 80.D0/27.D0*z4*cf*nf2
*
       DL1 = LOG (1.D0-Y)
*
       X3NS3C =   DL1**6 * C3A5/6.D0 + DL1**5 * C3A4/5.D0 
     ,          + DL1**4 * C3A3/4.D0 + DL1**3 * C3A2/3.D0 
     ,          + DL1**2 * C3A1/2.D0 + DL1 * C3A0 + C3DELT 
*
       RETURN
       END
*
* =================================================================av==
       END MODULE xc3ns3e
