      MODULE XCLGL3E
      CONTAINS
*     
* ..File: xclgl3e.f    FL_G
*
*
* ..The exact 3-loop MS(bar) gluonic coefficient functions for the 
*    structure function F_L in electromagnetic DIS at mu_r = mu_f = Q. 
*    Expansion parameter: alpha_s/(4 pi).
* 
* ..The distributions (in the mathematical sense) are given as in eq.
*    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.
*    The name-endings A, B, and C of the functions below correspond to 
*    the kernel superscripts [2], [3], and [1] in that equation.
*
* ..The code uses the package of Gehrmann and Remiddi for the harmonic
*    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296,
*    upgraded to weight 5 (T. Gehrmann, private communication).
*
* ..Reference: J. Vermaseren, A. Vogt and S. Moch
*              hep-ph/0504242 = Nucl. Phys. B724 (2005) 3
*
* =====================================================================
*
*
* ..There is only a regular piece. 
*
       FUNCTION XLG3A (X, NF, CC)
*
       IMPLICIT REAL*8 (A - Z)
       COMPLEX*16 HC1, HC2, HC3, HC4, HC5
       INTEGER NF, NF2, N1, N2, NW, CC
       PARAMETER ( N1 = -1, N2 = 1, NW = 5 )
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),
     ,           HC4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HC5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),
     ,           HR4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HR5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),
     ,           HI4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HI5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0,
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
       DIMENSION FLG(6)
       DATA FLG / 1.d0, 0.1d0, 0.d0, 0.1d0, 0.01818181818d0, 0.1d0 /
*
* ...Colour factors and abbreviations
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
       DABC2A = 5./48.D0 * NF2
       FLG11 = FLG(NF)
*
* ...Some abbreviations
*
       DX = 1.D0/X
       DM = 1.D0/(1.D0-X)
       DP = 1.D0/(1.D0+X)
       DL1 = LOG(1.D0-X)
*
* ...Harmonic polylogs (HPLs) up to weight 5 by Gehrmann and Remiddi
*
       CALL HPLOG5 (X, NW, HC1,HC2,HC3,HC4,HC5, HR1,HR2,HR3,HR4,HR5,
     ,             HI1,HI2,HI3,HI4,HI5, N1, N2)
*
* ...The coefficient function in terms of the HPLs, flg11 part
*
       if(CC.eq.0) then
      cLgg3 =
     &  + dabc2a*flg11 * (  - 17152.D0/225.D0 - 20352.D0/25.D0*x + 
     &    21504.D0/25.D0*x**2 + 6784.D0/225.D0*dx + 5632.D0/15.D0*z3 - 
     &    8576.D0/45.D0*z3*x - 57472.D0/45.D0*z3*x**2 - 12544.D0/15.D0*
     &    z3*x**3 + 3584.D0/15.D0*z3*dx + 40192.D0/225.D0*z2 - 6144.D0/
     &    25.D0*z2*x - 128768.D0/75.D0*z2*x**2 - 768.D0/5.D0*z2*x**3 + 
     &    28672.D0/225.D0*z2*dx - 256.D0/15.D0*z2*dp + 36992.D0/75.D0*
     &    z2**2*x - 60928.D0/75.D0*z2**2*x**2 + 28672.D0/25.D0*z2**2*
     &    x**3 + 512.D0*Hr1(-1)*z3*x + 512.D0*Hr1(-1)*z3*x**2 + 3328.D0/
     &    5.D0*Hr1(-1)*z2 + 1408.D0/15.D0*Hr1(-1)*z2*x - 256.D0/9.D0*
     &    Hr1(-1)*z2*x**2 + 12544.D0/25.D0*Hr1(-1)*z2*x**3 + 4096.D0/45.
     &    D0*Hr1(-1)*z2*dx + 6272.D0/75.D0*Hr1(-1)*z2*dx**2 - 1664.D0/
     &    75.D0*Hr1(0) - 147968.D0/225.D0*Hr1(0)*x + 25472.D0/15.D0*
     &    Hr1(0)*x**2 - 6784.D0/225.D0*Hr1(0)*dx - 128.D0/15.D0*Hr1(0)*
     &    dp + 768.D0*Hr1(0)*z3*x - 27392.D0/15.D0*Hr1(0)*z3*x**2 + 
     &    7168.D0/5.D0*Hr1(0)*z3*x**3 - 5632.D0/15.D0*Hr1(0)*z2 - 50176.
     &    D0/45.D0*Hr1(0)*z2*x )
      cLgg3 = cLgg3 + dabc2a*flg11 * ( 113152.D0/45.D0*Hr1(0)*z2*
     &    x**2 - 50176.D0/75.D0*Hr1(0)*z2*x**3 - 3584.D0/15.D0*Hr1(0)*
     &    z2*dx + 2944.D0/25.D0*Hr1(1) - 490496.D0/225.D0*Hr1(1)*x + 
     &    46976.D0/25.D0*Hr1(1)*x**2 + 41216.D0/225.D0*Hr1(1)*dx - 768.D
     &    0*Hr1(1)*z3 + 1792.D0/3.D0*Hr1(1)*z3*x - 768.D0*Hr1(1)*z3*
     &    x**2 + 7168.D0/5.D0*Hr1(1)*z3*x**3 - 256.D0*Hr1(1)*z3*dx - 
     &    3584.D0/15.D0*Hr1(1)*z3*dx**2 + 3328.D0/15.D0*Hr1(1)*z2 - 
     &    55168.D0/45.D0*Hr1(1)*z2*x + 9472.D0/9.D0*Hr1(1)*z2*x**2 - 
     &    12544.D0/75.D0*Hr1(1)*z2*x**3 + 4096.D0/45.D0*Hr1(1)*z2*dx + 
     &    6272.D0/225.D0*Hr1(1)*z2*dx**2 + 6144.D0/5.D0*Hr1(1)*z2**2*x
     &     - 6144.D0/5.D0*Hr1(1)*z2**2*x**2 - 512.D0*Hr2(-1,-1)*z2*x - 
     &    512.D0*Hr2(-1,-1)*z2*x**2 - 23552.D0/25.D0*Hr2(-1,0) - 316928.
     &    D0/225.D0*Hr2(-1,0)*x - 47488.D0/75.D0*Hr2(-1,0)*x**2 - 768.D0
     &    /5.D0*Hr2(-1,0)*x**3 - 12544.D0/225.D0*Hr2(-1,0)*dx - 128.D0/
     &    5.D0*Hr2(-1,0)*dx**2 + 512.D0*Hr2(-1,0)*z2*x + 512.D0*Hr2(-1,
     &    0)*z2*x**2 )
      cLgg3 = cLgg3 + dabc2a*flg11 * (  - 4096.D0/5.D0*Hr2(0,-1)*z2
     &    *x + 15872.D0/15.D0*Hr2(0,-1)*z2*x**2 + 18688.D0/225.D0*Hr2(0
     &    ,0) + 82816.D0/75.D0*Hr2(0,0)*x + 45568.D0/75.D0*Hr2(0,0)*
     &    x**2 + 768.D0/5.D0*Hr2(0,0)*x**3 + 12544.D0/225.D0*Hr2(0,0)*
     &    dx + 128.D0/15.D0*Hr2(0,0)*dp - 1792.D0/5.D0*Hr2(0,0)*z2*x + 
     &    25856.D0/15.D0*Hr2(0,0)*z2*x**2 - 7168.D0/5.D0*Hr2(0,0)*z2*
     &    x**3 - 40192.D0/225.D0*Hr2(0,1) - 261632.D0/225.D0*Hr2(0,1)*x
     &     + 128768.D0/75.D0*Hr2(0,1)*x**2 - 41216.D0/225.D0*Hr2(0,1)*
     &    dx + 256.D0/15.D0*Hr2(0,1)*dp + 1536.D0*Hr2(0,1)*z3*x - 1536.D
     &    0*Hr2(0,1)*z3*x**2 - 1024.D0/15.D0*Hr2(0,1)*z2*x - 512.D0/15.D
     &    0*Hr2(0,1)*z2*x**2 - 1408.D0*Hr2(1,0)*x + 1408.D0*Hr2(1,0)*
     &    x**2 + 1536.D0*Hr2(1,0)*z3*x - 1536.D0*Hr2(1,0)*z3*x**2 + 768.
     &    D0*Hr2(1,0)*z2 - 9472.D0/3.D0*Hr2(1,0)*z2*x + 3328.D0*Hr2(1,0
     &    )*z2*x**2 - 7168.D0/5.D0*Hr2(1,0)*z2*x**3 + 256.D0*Hr2(1,0)*
     &    z2*dx + 3584.D0/15.D0*Hr2(1,0)*z2*dx**2 - 2816.D0*Hr2(1,1)*x
     &     + 2816.D0*Hr2(1,1)*x**2 )
      cLgg3 = cLgg3 + dabc2a*flg11 * ( 3072.D0*Hr2(1,1)*z3*x - 3072.
     &    D0*Hr2(1,1)*z3*x**2 - 512.D0*Hr2(1,1)*z2*x + 512.D0*Hr2(1,1)*
     &    z2*x**2 + 6656.D0/15.D0*Hr3(-1,-1,0) + 110336.D0/45.D0*Hr3(-1
     &    ,-1,0)*x + 18944.D0/9.D0*Hr3(-1,-1,0)*x**2 + 25088.D0/75.D0*
     &    Hr3(-1,-1,0)*x**3 - 8192.D0/45.D0*Hr3(-1,-1,0)*dx + 12544.D0/
     &    225.D0*Hr3(-1,-1,0)*dx**2 - 6656.D0/15.D0*Hr3(-1,0,0) - 29696.
     &    D0/45.D0*Hr3(-1,0,0)*x - 512.D0*Hr3(-1,0,0)*x**2 - 25088.D0/
     &    75.D0*Hr3(-1,0,0)*x**3 - 12544.D0/225.D0*Hr3(-1,0,0)*dx**2 - 
     &    6656.D0/15.D0*Hr3(-1,0,1) + 50944.D0/45.D0*Hr3(-1,0,1)*x + 
     &    9728.D0/9.D0*Hr3(-1,0,1)*x**2 - 25088.D0/75.D0*Hr3(-1,0,1)*
     &    x**3 - 8192.D0/45.D0*Hr3(-1,0,1)*dx - 12544.D0/225.D0*Hr3(-1,
     &    0,1)*dx**2 - 6656.D0/45.D0*Hr3(0,-1,0)*x - 18944.D0/9.D0*Hr3(
     &    0,-1,0)*x**2 - 25088.D0/75.D0*Hr3(0,-1,0)*x**3 + 6656.D0/45.D0
     &    *Hr3(0,0,0)*x + 25088.D0/75.D0*Hr3(0,0,0)*x**3 + 5632.D0/15.D0
     &    *Hr3(0,0,1) + 8704.D0/9.D0*Hr3(0,0,1)*x - 113152.D0/45.D0*
     &    Hr3(0,0,1)*x**2 )
      cLgg3 = cLgg3 + dabc2a*flg11 * ( 25088.D0/75.D0*Hr3(0,0,1)*
     &    x**3 + 3584.D0/15.D0*Hr3(0,0,1)*dx - 1536.D0*Hr3(0,1,0)*z2*x
     &     + 1536.D0*Hr3(0,1,0)*z2*x**2 - 5632.D0/15.D0*Hr3(1,0,0) - 
     &    1536.D0/5.D0*Hr3(1,0,0)*x + 4608.D0/5.D0*Hr3(1,0,0)*x**2 - 
     &    3584.D0/15.D0*Hr3(1,0,0)*dx - 1536.D0*Hr3(1,0,0)*z2*x + 1536.D
     &    0*Hr3(1,0,0)*z2*x**2 - 3072.D0*Hr3(1,1,0)*z2*x + 3072.D0*Hr3(
     &    1,1,0)*z2*x**2 - 1024.D0*Hr4(-1,-1,-1,0)*x - 1024.D0*Hr4(-1,
     &    -1,-1,0)*x**2 + 512.D0*Hr4(-1,-1,0,0)*x + 512.D0*Hr4(-1,-1,0,
     &    0)*x**2 + 512.D0*Hr4(-1,0,-1,0)*x + 512.D0*Hr4(-1,0,-1,0)*
     &    x**2 - 512.D0*Hr4(-1,0,0,0)*x - 512.D0*Hr4(-1,0,0,0)*x**2 + 
     &    2048.D0/15.D0*Hr4(0,-1,-1,0)*x - 1024.D0/15.D0*Hr4(0,-1,-1,0)
     &    *x**2 + 5632.D0/15.D0*Hr4(0,-1,0,0)*x - 512.D0*Hr4(0,-1,0,0)*
     &    x**2 + 13312.D0/15.D0*Hr4(0,-1,0,1)*x - 16384.D0/15.D0*Hr4(0,
     &    -1,0,1)*x**2 - 2048.D0/15.D0*Hr4(0,0,-1,0)*x + 16384.D0/15.D0
     &    *Hr4(0,0,-1,0)*x**2 + 2048.D0/15.D0*Hr4(0,0,0,0)*x + 3328.D0/
     &    15.D0*Hr4(0,0,0,1)*x )
      cLgg3 = cLgg3 + dabc2a*flg11 * (  - 25856.D0/15.D0*Hr4(0,0,0,
     &    1)*x**2 + 7168.D0/5.D0*Hr4(0,0,0,1)*x**3 - 1792.D0/3.D0*Hr4(0
     &    ,1,0,0)*x + 2304.D0*Hr4(0,1,0,0)*x**2 - 7168.D0/5.D0*Hr4(0,1,
     &    0,0)*x**3 - 512.D0*Hr4(1,0,-1,0)*x + 512.D0*Hr4(1,0,-1,0)*
     &    x**2 + 512.D0*Hr4(1,0,0,0)*x - 512.D0*Hr4(1,0,0,0)*x**2 - 768.
     &    D0*Hr4(1,0,0,1) + 7936.D0/3.D0*Hr4(1,0,0,1)*x - 2816.D0*Hr4(1
     &    ,0,0,1)*x**2 + 7168.D0/5.D0*Hr4(1,0,0,1)*x**3 - 256.D0*Hr4(1,
     &    0,0,1)*dx - 3584.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 768.D0*Hr4(1,1
     &    ,0,0) - 6400.D0/3.D0*Hr4(1,1,0,0)*x + 2304.D0*Hr4(1,1,0,0)*
     &    x**2 - 7168.D0/5.D0*Hr4(1,1,0,0)*x**3 + 256.D0*Hr4(1,1,0,0)*
     &    dx + 3584.D0/15.D0*Hr4(1,1,0,0)*dx**2 + 1536.D0*Hr5(0,1,0,0,1
     &    )*x - 1536.D0*Hr5(0,1,0,0,1)*x**2 - 1536.D0*Hr5(0,1,1,0,0)*x
     &     + 1536.D0*Hr5(0,1,1,0,0)*x**2 + 1536.D0*Hr5(1,0,0,0,1)*x - 
     &    1536.D0*Hr5(1,0,0,0,1)*x**2 - 1536.D0*Hr5(1,0,1,0,0)*x + 1536.
     &    D0*Hr5(1,0,1,0,0)*x**2 + 3072.D0*Hr5(1,1,0,0,1)*x - 3072.D0*
     &    Hr5(1,1,0,0,1)*x**2 )
      cLgg3 = cLgg3 + dabc2a*flg11 * (  - 3072.D0*Hr5(1,1,1,0,0)*x
     &     + 3072.D0*Hr5(1,1,1,0,0)*x**2 )
*
* ...The `special' contributions to the flg11 part
*
      SP1 =
     &  + dm * (  - 6.D0*z3 + 4.D0/5.D0*z2**2 + 8.D0*Hr1(-1)*z2 + 6.D0*
     &    Hr1(0)*z3 - 6.D0*Hr1(0)*z2 - 8.D0*Hr2(0,-1)*z2 + 6.D0*Hr2(0,0
     &    )*z2 - 4.D0*Hr3(-1,0,0) - 8.D0*Hr3(-1,0,1) + 2.D0*Hr3(0,0,0)
     &     + 4.D0*Hr3(0,0,1) + 4.D0*Hr4(0,-1,0,0) + 8.D0*Hr4(0,-1,0,1)
     &     - 2.D0*Hr4(0,0,0,0) - 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + dm**2 * (  - 4.D0/5.D0*z2**2 - 6.D0*Hr1(0)*z3 + 8.D0*
     &    Hr2(0,-1)*z2 - 6.D0*Hr2(0,0)*z2 - 4.D0*Hr4(0,-1,0,0) - 8.D0*
     &    Hr4(0,-1,0,1) + 2.D0*Hr4(0,0,0,0) + 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + 2.D0*z3 + 4.D0*z3*dp - 21.D0/5.D0*z2**2*dp + 21.D0/5.D
     &    0*z2**2*dp**2 - 8.D0*Hr1(-1)*z2 - 4.D0*Hr1(0)*z3*dp + 4.D0*
     &    Hr1(0)*z3*dp**2 + 4.D0*Hr1(0)*z2 + 2.D0*Hr1(0)*z2*dp - 2.D0*
     &    Hr2(0,0)*z2*dp + 2.D0*Hr2(0,0)*z2*dp**2 + 4.D0*Hr3(-1,0,0) +
     &    8.D0*Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 4.D0*Hr3(0,-1,0)*dp - 2.
     &    D0*Hr3(0,0,0)*dp - 4.D0*Hr3(0,0,1) - 4.D0*Hr4(0,0,-1,0)*dp +
     &    4.D0*Hr4(0,0,-1,0)*dp**2 + 2.D0*Hr4(0,0,0,0)*dp - 2.D0*Hr4(0,
     &    0,0,0)*dp**2
       if (x .gt. 0.99995D0) then
         SP1 = x*(z2+z3)
* ...For 5-digit accuracy down to x=0.9
c    ,         + (1.-x)**2 * (-0.5*DL1-0.25*z2-0.5*z3+5./8.d0)
       endif
*
      SP2 =
     &  + dm * (  - 18.D0*z3 + 2.D0*z2 + 8.D0/5.D0*z2**2 + 24.D0*Hr1(-1
     &    )*z2 + 12.D0*Hr1(0)*z3 - 18.D0*Hr1(0)*z2 - 16.D0*Hr2(0,-1)*z2
     &     + 12.D0*Hr2(0,0)*z2 - 12.D0*Hr3(-1,0,0) - 24.D0*Hr3(-1,0,1)
     &     + 6.D0*Hr3(0,0,0) + 12.D0*Hr3(0,0,1) + 8.D0*Hr4(0,-1,0,0) +
     &    16.D0*Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2 = SP2 + dm**2 * ( 12.D0*z3 - 16.D0/5.D0*z2**2 - 16.D0*Hr1(-1)
     &    *z2 - 24.D0*Hr1(0)*z3 + 12.D0*Hr1(0)*z2 + 32.D0*Hr2(0,-1)*z2
     &     - 24.D0*Hr2(0,0)*z2 + 8.D0*Hr3(-1,0,0) + 16.D0*Hr3(-1,0,1)
     &     - 4.D0*Hr3(0,0,0) - 8.D0*Hr3(0,0,1) - 16.D0*Hr4(0,-1,0,0) -
     &    32.D0*Hr4(0,-1,0,1) + 8.D0*Hr4(0,0,0,0) + 16.D0*Hr4(0,0,0,1)
     &     )
      SP2 = SP2 + dm**3 * ( 8.D0/5.D0*z2**2 + 12.D0*Hr1(0)*z3 - 16.D0*
     &    Hr2(0,-1)*z2 + 12.D0*Hr2(0,0)*z2 + 8.D0*Hr4(0,-1,0,0) + 16.D0
     &    *Hr4(0,-1,0,1) - 4.D0*Hr4(0,0,0,0) - 8.D0*Hr4(0,0,0,1) )
      SP2 = SP2 + 2.D0*z3 + 12.D0*z3*dp - 8.D0*z3*dp**2 + 4.D0*z2 - 6.D0
     &    *z2*dp - 42.D0/5.D0*z2**2*dp + 84.D0/5.D0*z2**2*dp**2 - 42.D0/
     &    5.D0*z2**2*dp**3 - 8.D0*Hr1(-1)*z2 - 8.D0*Hr1(0)*z3*dp + 16.D0
     &    *Hr1(0)*z3*dp**2 - 8.D0*Hr1(0)*z3*dp**3 + 4.D0*Hr1(0)*z2 + 6.D
     &    0*Hr1(0)*z2*dp - 4.D0*Hr1(0)*z2*dp**2 + 4.D0*Hr2(-1,0) - 4.D0
     &    *Hr2(-1,0)*dp - 4.D0*Hr2(0,0) + 4.D0*Hr2(0,0)*dp - 4.D0*Hr2(0
     &    ,0)*z2*dp + 8.D0*Hr2(0,0)*z2*dp**2 - 4.D0*Hr2(0,0)*z2*dp**3
     &     - 4.D0*Hr2(0,1) + 4.D0*Hr2(0,1)*dp + 4.D0*Hr3(-1,0,0) + 8.D0
     &    *Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 12.D0*Hr3(0,-1,0)*dp - 8.D0
     &    *Hr3(0,-1,0)*dp**2 - 6.D0*Hr3(0,0,0)*dp + 4.D0*Hr3(0,0,0)*
     &    dp**2 - 4.D0*Hr3(0,0,1) - 8.D0*Hr4(0,0,-1,0)*dp + 16.D0*Hr4(0
     &    ,0,-1,0)*dp**2 - 8.D0*Hr4(0,0,-1,0)*dp**3 + 4.D0*Hr4(0,0,0,0)
     &    *dp - 8.D0*Hr4(0,0,0,0)*dp**2 + 4.D0*Hr4(0,0,0,0)*dp**3
       if (x .gt. 0.995D0) then
         SP2 =    (1.-x)* (-DL1-0.5*z2-z3+0.75D0)
     ,          + (1.-x)**2 * (-0.5)
* ...For 5-digit accuracy down to x=0.9
c    ,          + (1.-x)**3 * (DL1/3.d0+z2/18.d0+z3/3.d0-0.75)
c    ,          + (1.-x)**4 * (DL1/3.d0+z2/18.d0+z3/3.d0-0.5)
c    ,          + (1.-x)**5 * (31./120.d0*DL1+17./360.d0*z2+7./30.d0*z3
c    ,                         -1103./4800.d0)
       endif
*
       CLGG3 = 64./15.D0 * (2.* SP1 - SP2) * DABC2A * FLG11 + CLGG3
       XLG3A = CLGG3
       endif
*
* ...The coefficient function in terms of the HPLs, standard parts
*
       if(CC.eq.1) then
      cLgg3 = cLgg3 + nf*ca**2 * ( 6472.D0/27.D0 + 301316.D0/27.D0*x - 
     &    4393856.D0/405.D0*x**2 - 960.D0*z5*x - 222964.D0/405.D0*dx - 
     &    4928.D0/15.D0*z3 - 1720.D0*z3*x + 146308.D0/45.D0*z3*x**2 + 
     &    40.D0*z3*x**3 + 64.D0*z3*dx - 56.D0/9.D0*z2 - 210824.D0/45.D0
     &    *z2*x + 319184.D0/45.D0*z2*x**2 + 152.D0/5.D0*z2*x**3 + 5248.D
     &    0/45.D0*z2*dx - 96.D0*z2*z3*x - 192.D0/5.D0*z2**2*x - 7672.D0/
     &    15.D0*z2**2*x**2 - 3456.D0/25.D0*z2**2*x**3 - 704.D0*Hr1(-1)*
     &    z3*x - 640.D0*Hr1(-1)*z3*x**2 + 384.D0/5.D0*Hr1(-1)*z3*x**3
     &     + 64.D0/5.D0*Hr1(-1)*z3*dx**2 - 3848.D0/15.D0*Hr1(-1)*z2 - 
     &    9416.D0/5.D0*Hr1(-1)*z2*x - 71332.D0/45.D0*Hr1(-1)*z2*x**2 - 
     &    24.D0*Hr1(-1)*z2*x**3 + 2768.D0/45.D0*Hr1(-1)*z2*dx - 4.D0*
     &    Hr1(-1)*z2*dx**2 + 768.D0/5.D0*Hr1(-1)*z2**2*x + 768.D0/5.D0*
     &    Hr1(-1)*z2**2*x**2 - 20944.D0/45.D0*Hr1(0) + 1012088.D0/135.D0
     &    *Hr1(0)*x - 24628.D0/45.D0*Hr1(0)*x**2 - 10052.D0/135.D0*Hr1(
     &    0)*dx - 5888.D0/3.D0*Hr1(0)*z3*x - 752.D0/3.D0*Hr1(0)*z3*x**2
     &     - 256.D0*Hr1(0)*z3*x**3 )
      cLgg3 = cLgg3 + nf*ca**2 * ( 1544.D0/15.D0*Hr1(0)*z2 - 49792.D0/
     &    15.D0*Hr1(0)*z2*x + 99416.D0/45.D0*Hr1(0)*z2*x**2 + 32.D0*
     &    Hr1(0)*z2*x**3 + 128.D0/5.D0*Hr1(0)*z2*dx - 356.D0*Hr1(1) + 
     &    122360.D0/27.D0*Hr1(1)*x - 550852.D0/135.D0*Hr1(1)*x**2 - 
     &    1432.D0/15.D0*Hr1(1)*dx + 96.D0*Hr1(1)*z3 - 752.D0/3.D0*Hr1(1
     &    )*z3*x + 336.D0*Hr1(1)*z3*x**2 - 896.D0/5.D0*Hr1(1)*z3*x**3
     &     - 32.D0*Hr1(1)*z3*dx + 448.D0/15.D0*Hr1(1)*z3*dx**2 - 360.D0
     &    *Hr1(1)*z2 - 1512.D0*Hr1(1)*z2*x + 16100.D0/9.D0*Hr1(1)*z2*
     &    x**2 + 8.D0*Hr1(1)*z2*x**3 + 688.D0/9.D0*Hr1(1)*z2*dx - 4.D0/
     &    3.D0*Hr1(1)*z2*dx**2 + 2368.D0/3.D0*Hr2(-1,-1)*z2*x + 704.D0*
     &    Hr2(-1,-1)*z2*x**2 - 512.D0/5.D0*Hr2(-1,-1)*z2*x**3 - 256.D0/
     &    15.D0*Hr2(-1,-1)*z2*dx**2 + 19876.D0/45.D0*Hr2(-1,0) + 3536.D0
     &    /45.D0*Hr2(-1,0)*x - 10136.D0/45.D0*Hr2(-1,0)*x**2 + 152.D0/5.
     &    D0*Hr2(-1,0)*x**3 + 1688.D0/15.D0*Hr2(-1,0)*dx + 76.D0/15.D0*
     &    Hr2(-1,0)*dx**2 + 192.D0*Hr2(-1,0)*z3*x + 192.D0*Hr2(-1,0)*z3
     &    *x**2 )
      cLgg3 = cLgg3 + nf*ca**2 * (  - 816.D0*Hr2(-1,0)*z2*x - 752.D0*
     &    Hr2(-1,0)*z2*x**2 + 384.D0/5.D0*Hr2(-1,0)*z2*x**3 + 64.D0/5.D0
     &    *Hr2(-1,0)*z2*dx**2 - 1648.D0/3.D0*Hr2(0,-1)*z2*x - 2080.D0/3.
     &    D0*Hr2(0,-1)*z2*x**2 + 512.D0/5.D0*Hr2(0,-1)*z2*x**3 + 2764.D0
     &    /15.D0*Hr2(0,0) + 197672.D0/45.D0*Hr2(0,0)*x - 385064.D0/45.D0
     &    *Hr2(0,0)*x**2 - 152.D0/5.D0*Hr2(0,0)*x**3 - 56.D0/5.D0*Hr2(0
     &    ,0)*dx - 5392.D0/3.D0*Hr2(0,0)*z2*x + 800.D0/3.D0*Hr2(0,0)*z2
     &    *x**2 + 128.D0/5.D0*Hr2(0,0)*z2*x**3 + 56.D0/9.D0*Hr2(0,1) + 
     &    42872.D0/9.D0*Hr2(0,1)*x - 319184.D0/45.D0*Hr2(0,1)*x**2 - 
     &    184.D0/45.D0*Hr2(0,1)*dx + 192.D0*Hr2(0,1)*z3*x + 192.D0*Hr2(
     &    0,1)*z3*x**2 - 1360.D0*Hr2(0,1)*z2*x + 544.D0/3.D0*Hr2(0,1)*
     &    z2*x**2 + 688.D0/3.D0*Hr2(1,0) + 40064.D0/9.D0*Hr2(1,0)*x - 
     &    13472.D0/3.D0*Hr2(1,0)*x**2 - 1712.D0/9.D0*Hr2(1,0)*dx - 96.D0
     &    *Hr2(1,0)*z2 - 1360.D0/3.D0*Hr2(1,0)*z2*x + 432.D0*Hr2(1,0)*
     &    z2*x**2 + 512.D0/5.D0*Hr2(1,0)*z2*x**3 + 32.D0*Hr2(1,0)*z2*dx
     &     - 256.D0/15.D0*Hr2(1,0)*z2*dx**2 )
      cLgg3 = cLgg3 + nf*ca**2 * ( 896.D0/3.D0*Hr2(1,1) + 43040.D0/9.D0
     &    *Hr2(1,1)*x - 43936.D0/9.D0*Hr2(1,1)*x**2 - 1792.D0/9.D0*Hr2(
     &    1,1)*dx - 384.D0*Hr2(1,1)*z2*x + 384.D0*Hr2(1,1)*z2*x**2 - 
     &    272.D0*Hr3(-1,-1,0) - 752.D0*Hr3(-1,-1,0)*x - 4472.D0/9.D0*
     &    Hr3(-1,-1,0)*x**2 - 16.D0*Hr3(-1,-1,0)*x**3 - 32.D0/9.D0*Hr3(
     &    -1,-1,0)*dx - 8.D0/3.D0*Hr3(-1,-1,0)*dx**2 + 64.D0/15.D0*Hr3(
     &    -1,0,0) + 34864.D0/15.D0*Hr3(-1,0,0)*x + 33592.D0/15.D0*Hr3(
     &    -1,0,0)*x**2 + 16.D0*Hr3(-1,0,0)*x**3 - 1408.D0/15.D0*Hr3(-1,
     &    0,0)*dx + 8.D0/3.D0*Hr3(-1,0,0)*dx**2 - 192.D0*Hr3(-1,0,0)*z2
     &    *x - 192.D0*Hr3(-1,0,0)*z2*x**2 + 1808.D0/15.D0*Hr3(-1,0,1)
     &     + 7536.D0/5.D0*Hr3(-1,0,1)*x + 60152.D0/45.D0*Hr3(-1,0,1)*
     &    x**2 + 16.D0*Hr3(-1,0,1)*x**3 - 2848.D0/45.D0*Hr3(-1,0,1)*dx
     &     + 8.D0/3.D0*Hr3(-1,0,1)*dx**2 - 1264.D0/15.D0*Hr3(0,-1,0) + 
     &    5504.D0/15.D0*Hr3(0,-1,0)*x + 76024.D0/45.D0*Hr3(0,-1,0)*x**2
     &     + 16.D0*Hr3(0,-1,0)*x**3 + 64.D0/5.D0*Hr3(0,-1,0)*dx - 160.D0
     &    *Hr3(0,0,0) )
      cLgg3 = cLgg3 + nf*ca**2 * ( 45296.D0/15.D0*Hr3(0,0,0)*x - 704.D0
     &    *Hr3(0,0,0)*x**2 - 16.D0*Hr3(0,0,0)*x**3 + 128.D0/15.D0*Hr3(0
     &    ,0,0)*dx - 1544.D0/15.D0*Hr3(0,0,1) + 18432.D0/5.D0*Hr3(0,0,1
     &    )*x - 99416.D0/45.D0*Hr3(0,0,1)*x**2 - 16.D0*Hr3(0,0,1)*x**3
     &     - 64.D0/5.D0*Hr3(0,0,1)*dx + 64.D0*Hr3(0,1,0) + 3264.D0*Hr3(
     &    0,1,0)*x - 2048.D0*Hr3(0,1,0)*x**2 - 128.D0/3.D0*Hr3(0,1,0)*
     &    dx - 192.D0*Hr3(0,1,0)*z2*x - 192.D0*Hr3(0,1,0)*z2*x**2 + 96.D
     &    0*Hr3(0,1,1) + 3680.D0*Hr3(0,1,1)*x - 6752.D0/3.D0*Hr3(0,1,1)
     &    *x**2 - 160.D0/3.D0*Hr3(0,1,1)*dx + 1112.D0/3.D0*Hr3(1,0,0)
     &     + 5008.D0/3.D0*Hr3(1,0,0)*x - 1976.D0*Hr3(1,0,0)*x**2 - 64.D0
     &    *Hr3(1,0,0)*dx + 224.D0*Hr3(1,0,1) + 1888.D0*Hr3(1,0,1)*x - 
     &    6112.D0/3.D0*Hr3(1,0,1)*x**2 - 224.D0/3.D0*Hr3(1,0,1)*dx + 
     &    224.D0*Hr3(1,1,0) + 6368.D0/3.D0*Hr3(1,1,0)*x - 2272.D0*Hr3(1
     &    ,1,0)*x**2 - 224.D0/3.D0*Hr3(1,1,0)*dx + 192.D0*Hr3(1,1,1) + 
     &    5536.D0/3.D0*Hr3(1,1,1)*x - 5920.D0/3.D0*Hr3(1,1,1)*x**2 - 64.
     &    D0*Hr3(1,1,1)*dx )
      cLgg3 = cLgg3 + nf*ca**2 * ( 128.D0*Hr4(-1,-1,-1,0)*x + 128.D0*
     &    Hr4(-1,-1,-1,0)*x**2 - 2432.D0/3.D0*Hr4(-1,-1,0,0)*x - 768.D0
     &    *Hr4(-1,-1,0,0)*x**2 + 256.D0/5.D0*Hr4(-1,-1,0,0)*x**3 + 128.D
     &    0/15.D0*Hr4(-1,-1,0,0)*dx**2 - 2176.D0/3.D0*Hr4(-1,-1,0,1)*x
     &     - 640.D0*Hr4(-1,-1,0,1)*x**2 + 512.D0/5.D0*Hr4(-1,-1,0,1)*
     &    x**3 + 256.D0/15.D0*Hr4(-1,-1,0,1)*dx**2 - 192.D0*Hr4(-1,0,-1
     &    ,0)*x - 192.D0*Hr4(-1,0,-1,0)*x**2 + 1648.D0/3.D0*Hr4(-1,0,0,
     &    0)*x + 528.D0*Hr4(-1,0,0,0)*x**2 - 128.D0/5.D0*Hr4(-1,0,0,0)*
     &    x**3 - 64.D0/15.D0*Hr4(-1,0,0,0)*dx**2 + 2048.D0/3.D0*Hr4(-1,
     &    0,0,1)*x + 640.D0*Hr4(-1,0,0,1)*x**2 - 256.D0/5.D0*Hr4(-1,0,0
     &    ,1)*x**3 - 128.D0/15.D0*Hr4(-1,0,0,1)*dx**2 + 128.D0*Hr4(-1,0
     &    ,1,0)*x + 128.D0*Hr4(-1,0,1,0)*x**2 + 128.D0*Hr4(-1,0,1,1)*x
     &     + 128.D0*Hr4(-1,0,1,1)*x**2 + 160.D0*Hr4(0,-1,-1,0)*x - 1216.
     &    D0/3.D0*Hr4(0,-1,-1,0)*x**2 + 3008.D0/3.D0*Hr4(0,-1,0,0)*x + 
     &    448.D0*Hr4(0,-1,0,0)*x**2 - 256.D0/5.D0*Hr4(0,-1,0,0)*x**3 + 
     &    1888.D0/3.D0*Hr4(0,-1,0,1)*x )
      cLgg3 = cLgg3 + nf*ca**2 * ( 1472.D0/3.D0*Hr4(0,-1,0,1)*x**2 - 
     &    512.D0/5.D0*Hr4(0,-1,0,1)*x**3 + 992.D0/3.D0*Hr4(0,0,-1,0)*x
     &     - 608.D0/3.D0*Hr4(0,0,-1,0)*x**2 - 256.D0/5.D0*Hr4(0,0,-1,0)
     &    *x**3 + 4768.D0/3.D0*Hr4(0,0,0,0)*x + 256.D0/5.D0*Hr4(0,0,0,0
     &    )*x**3 + 2128.D0*Hr4(0,0,0,1)*x - 800.D0/3.D0*Hr4(0,0,0,1)*
     &    x**2 - 384.D0/5.D0*Hr4(0,0,0,1)*x**3 + 1792.D0*Hr4(0,0,1,0)*x
     &     - 128.D0*Hr4(0,0,1,0)*x**2 + 2048.D0*Hr4(0,0,1,1)*x - 256.D0
     &    *Hr4(0,0,1,1)*x**2 + 4432.D0/3.D0*Hr4(0,1,0,0)*x - 32.D0*Hr4(
     &    0,1,0,0)*x**2 + 128.D0*Hr4(0,1,0,0)*x**3 + 1280.D0*Hr4(0,1,0,
     &    1)*x - 384.D0*Hr4(0,1,0,1)*x**2 + 1280.D0*Hr4(0,1,1,0)*x - 
     &    384.D0*Hr4(0,1,1,0)*x**2 + 1152.D0*Hr4(0,1,1,1)*x - 384.D0*
     &    Hr4(0,1,1,1)*x**2 + 224.D0/3.D0*Hr4(1,0,-1,0)*x - 32.D0*Hr4(1
     &    ,0,-1,0)*x**2 - 256.D0/5.D0*Hr4(1,0,-1,0)*x**3 + 128.D0/15.D0
     &    *Hr4(1,0,-1,0)*dx**2 + 464.D0/3.D0*Hr4(1,0,0,0)*x - 176.D0*
     &    Hr4(1,0,0,0)*x**2 + 128.D0/5.D0*Hr4(1,0,0,0)*x**3 - 64.D0/15.D
     &    0*Hr4(1,0,0,0)*dx**2 )
      cLgg3 = cLgg3 + nf*ca**2 * ( 96.D0*Hr4(1,0,0,1) + 1760.D0/3.D0*
     &    Hr4(1,0,0,1)*x - 544.D0*Hr4(1,0,0,1)*x**2 - 128.D0*Hr4(1,0,0,
     &    1)*x**3 - 32.D0*Hr4(1,0,0,1)*dx + 64.D0/3.D0*Hr4(1,0,0,1)*
     &    dx**2 + 384.D0*Hr4(1,0,1,0)*x - 384.D0*Hr4(1,0,1,0)*x**2 + 
     &    448.D0*Hr4(1,0,1,1)*x - 448.D0*Hr4(1,0,1,1)*x**2 - 96.D0*Hr4(
     &    1,1,0,0) + 928.D0/3.D0*Hr4(1,1,0,0)*x - 352.D0*Hr4(1,1,0,0)*
     &    x**2 + 128.D0*Hr4(1,1,0,0)*x**3 + 32.D0*Hr4(1,1,0,0)*dx - 64.D
     &    0/3.D0*Hr4(1,1,0,0)*dx**2 + 448.D0*Hr4(1,1,0,1)*x - 448.D0*
     &    Hr4(1,1,0,1)*x**2 + 448.D0*Hr4(1,1,1,0)*x - 448.D0*Hr4(1,1,1,
     &    0)*x**2 + 384.D0*Hr4(1,1,1,1)*x - 384.D0*Hr4(1,1,1,1)*x**2 + 
     &    192.D0*Hr5(-1,0,0,0,1)*x + 192.D0*Hr5(-1,0,0,0,1)*x**2 - 192.D
     &    0*Hr5(-1,0,1,0,0)*x - 192.D0*Hr5(-1,0,1,0,0)*x**2 + 192.D0*
     &    Hr5(0,1,0,0,1)*x + 192.D0*Hr5(0,1,0,0,1)*x**2 - 192.D0*Hr5(0,
     &    1,1,0,0)*x - 192.D0*Hr5(0,1,1,0,0)*x**2 )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 137812.D0/675.D0 - 84264.D0/25.D0
     &    *x + 2312348.D0/675.D0*x**2 + 3920.D0*z5*x + 100592.D0/675.D0
     &    *dx - 416.D0/5.D0*z3 - 121616.D0/45.D0*z3*x + 69248.D0/45.D0*
     &    z3*x**2 + 7648.D0/15.D0*z3*x**3 + 1984.D0/15.D0*z3*dx - 46304.
     &    D0/225.D0*z2 - 123824.D0/675.D0*z2*x - 38208.D0/25.D0*z2*x**2
     &     + 117472.D0/225.D0*z2*x**3 + 20896.D0/225.D0*z2*dx + 256.D0*
     &    z2*z3*x - 3712.D0/15.D0*z2**2*x + 14176.D0/15.D0*z2**2*x**2
     &     + 320.D0*z2**2*x**3 + 112.D0*Hr1(-1)*z3 + 112.D0/3.D0*Hr1(-1
     &    )*z3*x - 448.D0*Hr1(-1)*z3*x**2 - 448.D0*Hr1(-1)*z3*x**3 - 
     &    224.D0/3.D0*Hr1(-1)*z3*dx**2 + 5104.D0/5.D0*Hr1(-1)*z2 + 
     &    26032.D0/15.D0*Hr1(-1)*z2*x + 10048.D0/45.D0*Hr1(-1)*z2*x**2
     &     - 12928.D0/25.D0*Hr1(-1)*z2*x**3 - 2192.D0/45.D0*Hr1(-1)*z2*
     &    dx - 5584.D0/75.D0*Hr1(-1)*z2*dx**2 - 3072.D0/5.D0*Hr1(-1)*
     &    z2**2*x - 3072.D0/5.D0*Hr1(-1)*z2**2*x**2 - 6572.D0/135.D0*
     &    Hr1(0) - 231856.D0/75.D0*Hr1(0)*x + 703408.D0/225.D0*Hr1(0)*
     &    x**2 )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 40432.D0/675.D0*Hr1(0)*dx + 2208.D
     &    0*Hr1(0)*z3*x + 2624.D0/3.D0*Hr1(0)*z3*x**2 + 5248.D0/5.D0*
     &    Hr1(0)*z3*x**3 - 1232.D0/15.D0*Hr1(0)*z2 - 3824.D0/15.D0*Hr1(
     &    0)*z2*x - 33488.D0/45.D0*Hr1(0)*z2*x**2 + 60512.D0/75.D0*Hr1(
     &    0)*z2*x**3 + 448.D0/15.D0*Hr1(0)*z2*dx - 192.D0/5.D0*Hr1(0)*
     &    z2**2*x - 28892.D0/225.D0*Hr1(1) - 737108.D0/225.D0*Hr1(1)*x
     &     + 742192.D0/225.D0*Hr1(1)*x**2 + 7936.D0/75.D0*Hr1(1)*dx - 
     &    240.D0*Hr1(1)*z3 - 2800.D0/3.D0*Hr1(1)*z3*x + 544.D0*Hr1(1)*
     &    z3*x**2 + 3008.D0/5.D0*Hr1(1)*z3*x**3 + 128.D0*Hr1(1)*z3*dx
     &     - 1504.D0/15.D0*Hr1(1)*z3*dx**2 + 7072.D0/15.D0*Hr1(1)*z2 + 
     &    10064.D0/45.D0*Hr1(1)*z2*x - 43312.D0/45.D0*Hr1(1)*z2*x**2 + 
     &    21728.D0/75.D0*Hr1(1)*z2*x**3 + 112.D0/45.D0*Hr1(1)*z2*dx - 
     &    5584.D0/225.D0*Hr1(1)*z2*dx**2 - 128.D0*Hr2(-1,-1)*z2 - 64.D0
     &    *Hr2(-1,-1)*z2*x + 512.D0*Hr2(-1,-1)*z2*x**2 + 2688.D0/5.D0*
     &    Hr2(-1,-1)*z2*x**3 + 448.D0/5.D0*Hr2(-1,-1)*z2*dx**2 - 388144.
     &    D0/225.D0*Hr2(-1,0) )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 1862192.D0/675.D0*Hr2(-1,0)*x - 
     &    43664.D0/75.D0*Hr2(-1,0)*x**2 + 117472.D0/225.D0*Hr2(-1,0)*
     &    x**3 + 4928.D0/225.D0*Hr2(-1,0)*dx + 62416.D0/675.D0*Hr2(-1,0
     &    )*dx**2 - 768.D0*Hr2(-1,0)*z3*x - 768.D0*Hr2(-1,0)*z3*x**2 + 
     &    96.D0*Hr2(-1,0)*z2 + 1216.D0/3.D0*Hr2(-1,0)*z2*x - 96.D0*Hr2(
     &    -1,0)*z2*x**2 - 2432.D0/5.D0*Hr2(-1,0)*z2*x**3 - 1216.D0/15.D0
     &    *Hr2(-1,0)*z2*dx**2 - 224.D0*Hr2(0,-1)*z3*x + 192.D0*Hr2(0,-1
     &    )*z2 - 1056.D0*Hr2(0,-1)*z2*x - 800.D0/3.D0*Hr2(0,-1)*z2*x**2
     &     - 2688.D0/5.D0*Hr2(0,-1)*z2*x**3 - 128.D0/5.D0*Hr2(0,-1)*z2*
     &    dx**2 - 1336.D0/225.D0*Hr2(0,0) - 123328.D0/675.D0*Hr2(0,0)*x
     &     + 41728.D0/25.D0*Hr2(0,0)*x**2 - 117472.D0/225.D0*Hr2(0,0)*
     &    x**3 - 12448.D0/225.D0*Hr2(0,0)*dx + 128.D0*Hr2(0,0)*z3*x + 
     &    224.D0*Hr2(0,0)*z2*x - 2240.D0/3.D0*Hr2(0,0)*z2*x**2 + 896.D0/
     &    5.D0*Hr2(0,0)*z2*x**3 + 46304.D0/225.D0*Hr2(0,1) - 64384.D0/
     &    25.D0*Hr2(0,1)*x + 38208.D0/25.D0*Hr2(0,1)*x**2 - 15968.D0/
     &    225.D0*Hr2(0,1)*dx )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 480.D0*Hr2(0,1)*z3*x - 768.D0*
     &    Hr2(0,1)*z3*x**2 + 64.D0*Hr2(0,1)*z2 + 960.D0*Hr2(0,1)*z2*x
     &     - 736.D0/3.D0*Hr2(0,1)*z2*x**2 + 128.D0/5.D0*Hr2(0,1)*z2*
     &    x**3 - 128.D0/15.D0*Hr2(0,1)*z2*dx**2 - 864.D0/5.D0*Hr2(1,0)
     &     - 17968.D0/15.D0*Hr2(1,0)*x + 19952.D0/15.D0*Hr2(1,0)*x**2
     &     + 608.D0/15.D0*Hr2(1,0)*dx + 544.D0*Hr2(1,0)*z2 + 448.D0*
     &    Hr2(1,0)*z2*x - 608.D0*Hr2(1,0)*z2*x**2 - 1536.D0/5.D0*Hr2(1,
     &    0)*z2*x**3 - 128.D0*Hr2(1,0)*z2*dx + 256.D0/5.D0*Hr2(1,0)*z2*
     &    dx**2 - 864.D0/5.D0*Hr2(1,1) - 22208.D0/15.D0*Hr2(1,1)*x + 
     &    8064.D0/5.D0*Hr2(1,1)*x**2 + 608.D0/15.D0*Hr2(1,1)*dx + 64.D0
     &    *Hr2(1,1)*z2 + 512.D0/3.D0*Hr2(1,1)*z2*x - 256.D0*Hr2(1,1)*z2
     &    *x**2 + 128.D0/5.D0*Hr2(1,1)*z2*x**3 - 64.D0/15.D0*Hr2(1,1)*
     &    z2*dx**2 + 13664.D0/15.D0*Hr3(-1,-1,0) - 6688.D0/45.D0*Hr3(-1
     &    ,-1,0)*x - 61184.D0/45.D0*Hr3(-1,-1,0)*x**2 - 25856.D0/75.D0*
     &    Hr3(-1,-1,0)*x**3 - 224.D0/45.D0*Hr3(-1,-1,0)*dx - 11168.D0/
     &    225.D0*Hr3(-1,-1,0)*dx**2 )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 992.D0*Hr3(-1,0,0) - 12512.D0/9.D0
     &    *Hr3(-1,0,0)*x + 416.D0/3.D0*Hr3(-1,0,0)*x**2 + 14592.D0/25.D0
     &    *Hr3(-1,0,0)*x**3 + 128.D0/3.D0*Hr3(-1,0,0)*dx + 20128.D0/225.
     &    D0*Hr3(-1,0,0)*dx**2 + 768.D0*Hr3(-1,0,0)*z2*x + 768.D0*Hr3(
     &    -1,0,0)*z2*x**2 - 1696.D0/3.D0*Hr3(-1,0,1) - 16288.D0/9.D0*
     &    Hr3(-1,0,1)*x - 8128.D0/9.D0*Hr3(-1,0,1)*x**2 + 25856.D0/75.D0
     &    *Hr3(-1,0,1)*x**3 + 416.D0/9.D0*Hr3(-1,0,1)*dx + 11168.D0/225.
     &    D0*Hr3(-1,0,1)*dx**2 + 256.D0*Hr3(0,-1,-1)*z2*x - 3264.D0/5.D0
     &    *Hr3(0,-1,0) - 17728.D0/45.D0*Hr3(0,-1,0)*x + 51392.D0/45.D0*
     &    Hr3(0,-1,0)*x**2 + 25856.D0/75.D0*Hr3(0,-1,0)*x**3 + 512.D0/
     &    15.D0*Hr3(0,-1,0)*dx + 1792.D0/45.D0*Hr3(0,-1,0)*dx**2 - 192.D
     &    0*Hr3(0,-1,0)*z2*x + 464.D0/5.D0*Hr3(0,0,0) - 2352.D0/5.D0*
     &    Hr3(0,0,0)*x + 192.D0/5.D0*Hr3(0,0,0)*x**2 - 14592.D0/25.D0*
     &    Hr3(0,0,0)*x**3 - 256.D0/5.D0*Hr3(0,0,0)*dx + 1232.D0/15.D0*
     &    Hr3(0,0,1) - 6256.D0/45.D0*Hr3(0,0,1)*x + 33488.D0/45.D0*Hr3(
     &    0,0,1)*x**2 )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 11552.D0/25.D0*Hr3(0,0,1)*x**3 + 
     &    64.D0/15.D0*Hr3(0,0,1)*dx + 128.D0*Hr3(0,0,1)*z2*x + 64.D0/15.
     &    D0*Hr3(0,1,0) - 4192.D0/5.D0*Hr3(0,1,0)*x + 1232.D0/15.D0*
     &    Hr3(0,1,0)*x**2 + 352.D0/3.D0*Hr3(0,1,0)*x**3 - 128.D0/15.D0*
     &    Hr3(0,1,0)*dx + 1088.D0*Hr3(0,1,0)*z2*x + 768.D0*Hr3(0,1,0)*
     &    z2*x**2 + 64.D0/15.D0*Hr3(0,1,1) - 12656.D0/15.D0*Hr3(0,1,1)*
     &    x + 1024.D0/5.D0*Hr3(0,1,1)*x**2 - 128.D0/15.D0*Hr3(0,1,1)*dx
     &     + 128.D0*Hr3(0,1,1)*z2*x - 3392.D0/15.D0*Hr3(1,0,0) - 2176.D0
     &    /5.D0*Hr3(1,0,0)*x + 10624.D0/15.D0*Hr3(1,0,0)*x**2 - 704.D0/
     &    15.D0*Hr3(1,0,0)*dx - 16.D0*Hr3(1,0,1) - 448.D0/3.D0*Hr3(1,0,
     &    1)*x + 848.D0/3.D0*Hr3(1,0,1)*x**2 - 352.D0/3.D0*Hr3(1,0,1)*
     &    x**3 - 48.D0*Hr3(1,1,0) - 896.D0/3.D0*Hr3(1,1,0)*x + 688.D0/3.
     &    D0*Hr3(1,1,0)*x**2 + 352.D0/3.D0*Hr3(1,1,0)*x**3 - 16.D0*Hr3(
     &    1,1,1) - 208.D0*Hr3(1,1,1)*x + 224.D0*Hr3(1,1,1)*x**2 - 128.D0
     &    *Hr4(-1,-1,-1,0) + 1024.D0/3.D0*Hr4(-1,-1,-1,0)*x + 512.D0*
     &    Hr4(-1,-1,-1,0)*x**2 )
      cLgg3 = cLgg3 + nf*cf*ca * ( 256.D0/5.D0*Hr4(-1,-1,-1,0)*x**3 + 
     &    128.D0/15.D0*Hr4(-1,-1,-1,0)*dx**2 + 224.D0*Hr4(-1,-1,0,0) - 
     &    96.D0*Hr4(-1,-1,0,0)*x - 640.D0*Hr4(-1,-1,0,0)*x**2 - 384.D0*
     &    Hr4(-1,-1,0,0)*x**3 - 64.D0*Hr4(-1,-1,0,0)*dx**2 + 64.D0*Hr4(
     &    -1,-1,0,1) + 704.D0/3.D0*Hr4(-1,-1,0,1)*x - 256.D0*Hr4(-1,-1,
     &    0,1)*x**2 - 512.D0*Hr4(-1,-1,0,1)*x**3 - 256.D0/3.D0*Hr4(-1,
     &    -1,0,1)*dx**2 + 128.D0*Hr4(-1,0,-1,0) - 640.D0/3.D0*Hr4(-1,0,
     &    -1,0)*x - 384.D0*Hr4(-1,0,-1,0)*x**2 - 256.D0/5.D0*Hr4(-1,0,
     &    -1,0)*x**3 - 128.D0/15.D0*Hr4(-1,0,-1,0)*dx**2 - 128.D0*Hr4(
     &    -1,0,0,0) - 224.D0*Hr4(-1,0,0,0)*x + 96.D0*Hr4(-1,0,0,0)*x**2
     &     + 1152.D0/5.D0*Hr4(-1,0,0,0)*x**3 + 192.D0/5.D0*Hr4(-1,0,0,0
     &    )*dx**2 - 32.D0*Hr4(-1,0,0,1) - 224.D0*Hr4(-1,0,0,1)*x + 128.D
     &    0*Hr4(-1,0,0,1)*x**2 + 384.D0*Hr4(-1,0,0,1)*x**3 + 64.D0*Hr4(
     &    -1,0,0,1)*dx**2 - 128.D0/3.D0*Hr4(-1,0,1,0)*x + 256.D0/5.D0*
     &    Hr4(-1,0,1,0)*x**3 + 128.D0/15.D0*Hr4(-1,0,1,0)*dx**2 - 128.D0
     &    /3.D0*Hr4(-1,0,1,1)*x )
      cLgg3 = cLgg3 + nf*cf*ca * ( 256.D0/5.D0*Hr4(-1,0,1,1)*x**3 + 128.
     &    D0/15.D0*Hr4(-1,0,1,1)*dx**2 + 128.D0*Hr4(0,-1,-1,0) - 1856.D0
     &    *Hr4(0,-1,-1,0)*x - 1472.D0/3.D0*Hr4(0,-1,-1,0)*x**2 - 256.D0/
     &    5.D0*Hr4(0,-1,-1,0)*x**3 - 256.D0/15.D0*Hr4(0,-1,-1,0)*dx**2
     &     - 256.D0*Hr4(0,-1,0,0) + 2656.D0/3.D0*Hr4(0,-1,0,0)*x + 512.D
     &    0*Hr4(0,-1,0,0)*x**2 + 384.D0*Hr4(0,-1,0,0)*x**3 + 256.D0/15.D
     &    0*Hr4(0,-1,0,0)*dx**2 - 128.D0*Hr4(0,-1,0,1) + 128.D0*Hr4(0,
     &    -1,0,1)*x + 64.D0/3.D0*Hr4(0,-1,0,1)*x**2 + 512.D0*Hr4(0,-1,0
     &    ,1)*x**3 + 256.D0/15.D0*Hr4(0,-1,0,1)*dx**2 - 128.D0*Hr4(0,0,
     &    -1,0) - 128.D0*Hr4(0,0,-1,0)*x + 2432.D0/3.D0*Hr4(0,0,-1,0)*
     &    x**2 + 1024.D0/5.D0*Hr4(0,0,-1,0)*x**3 - 1312.D0/3.D0*Hr4(0,0
     &    ,0,0)*x - 1536.D0/5.D0*Hr4(0,0,0,0)*x**3 - 352.D0*Hr4(0,0,0,1
     &    )*x + 2240.D0/3.D0*Hr4(0,0,0,1)*x**2 + 128.D0/5.D0*Hr4(0,0,0,
     &    1)*x**3 - 640.D0/3.D0*Hr4(0,0,1,0)*x - 256.D0/5.D0*Hr4(0,0,1,
     &    0)*x**3 - 640.D0/3.D0*Hr4(0,0,1,1)*x - 256.D0/5.D0*Hr4(0,0,1,
     &    1)*x**3 )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 3488.D0/3.D0*Hr4(0,1,0,0)*x - 512.
     &    D0*Hr4(0,1,0,0)*x**2 - 2048.D0/5.D0*Hr4(0,1,0,0)*x**3 - 32.D0
     &    *Hr4(0,1,0,1)*x - 96.D0*Hr4(0,1,1,0)*x - 32.D0*Hr4(0,1,1,1)*x
     &     - 576.D0*Hr4(1,0,-1,0)*x + 448.D0*Hr4(1,0,-1,0)*x**2 + 768.D0
     &    /5.D0*Hr4(1,0,-1,0)*x**3 - 128.D0/5.D0*Hr4(1,0,-1,0)*dx**2 - 
     &    128.D0*Hr4(1,0,0,0) + 96.D0*Hr4(1,0,0,0)*x + 96.D0*Hr4(1,0,0,
     &    0)*x**2 - 384.D0/5.D0*Hr4(1,0,0,0)*x**3 + 64.D0/5.D0*Hr4(1,0,
     &    0,0)*dx**2 - 480.D0*Hr4(1,0,0,1) - 1888.D0/3.D0*Hr4(1,0,0,1)*
     &    x + 640.D0*Hr4(1,0,0,1)*x**2 + 2048.D0/5.D0*Hr4(1,0,0,1)*x**3
     &     + 128.D0*Hr4(1,0,0,1)*dx - 1024.D0/15.D0*Hr4(1,0,0,1)*dx**2
     &     + 416.D0*Hr4(1,1,0,0) + 1312.D0/3.D0*Hr4(1,1,0,0)*x - 384.D0
     &    *Hr4(1,1,0,0)*x**2 - 2048.D0/5.D0*Hr4(1,1,0,0)*x**3 - 128.D0*
     &    Hr4(1,1,0,0)*dx + 1024.D0/15.D0*Hr4(1,1,0,0)*dx**2 - 768.D0*
     &    Hr5(-1,0,0,0,1)*x - 768.D0*Hr5(-1,0,0,0,1)*x**2 + 768.D0*Hr5(
     &    -1,0,1,0,0)*x + 768.D0*Hr5(-1,0,1,0,0)*x**2 + 256.D0*Hr5(0,-1
     &    ,-1,-1,0)*x )
      cLgg3 = cLgg3 + nf*cf*ca * (  - 448.D0*Hr5(0,-1,-1,0,0)*x - 128.D0
     &    *Hr5(0,-1,-1,0,1)*x - 256.D0*Hr5(0,-1,0,-1,0)*x + 256.D0*Hr5(
     &    0,-1,0,0,0)*x + 64.D0*Hr5(0,-1,0,0,1)*x - 256.D0*Hr5(0,0,-1,
     &    -1,0)*x + 64.D0*Hr5(0,0,-1,0,0)*x - 128.D0*Hr5(0,0,-1,0,1)*x
     &     - 64.D0*Hr5(0,0,1,0,0)*x - 256.D0*Hr5(0,1,0,0,0)*x - 960.D0*
     &    Hr5(0,1,0,0,1)*x - 768.D0*Hr5(0,1,0,0,1)*x**2 + 832.D0*Hr5(0,
     &    1,1,0,0)*x + 768.D0*Hr5(0,1,1,0,0)*x**2 )
      cLgg3 = cLgg3 + nf*cf**2 * ( 1504.D0/75.D0 + 134096.D0/75.D0*x - 
     &    43808.D0/25.D0*x**2 - 4000.D0*z5*x - 1392.D0/25.D0*dx + 4448.D
     &    0/15.D0*z3 + 127408.D0/45.D0*z3*x - 63008.D0/45.D0*z3*x**2 - 
     &    704.D0/3.D0*z3*x**3 - 1472.D0/15.D0*z3*dx + 3856.D0/15.D0*z2
     &     + 56872.D0/45.D0*z2*x - 2944.D0/15.D0*z2*x**2 - 17056.D0/75.D
     &    0*z2*x**3 - 2368.D0/45.D0*z2*dx - 128.D0*z2*z3*x + 1888.D0/5.D
     &    0*z2**2*x - 2624.D0/3.D0*z2**2*x**2 - 8448.D0/25.D0*z2**2*
     &    x**3 - 224.D0*Hr1(-1)*z3 + 288.D0*Hr1(-1)*z3*x + 640.D0*Hr1(
     &    -1)*z3*x**2 + 768.D0/5.D0*Hr1(-1)*z3*x**3 + 128.D0/5.D0*Hr1(
     &    -1)*z3*dx**2 - 18976.D0/15.D0*Hr1(-1)*z2 - 28256.D0/15.D0*
     &    Hr1(-1)*z2*x - 21664.D0/45.D0*Hr1(-1)*z2*x**2 + 704.D0/5.D0*
     &    Hr1(-1)*z2*x**3 + 896.D0/45.D0*Hr1(-1)*z2*dx + 352.D0/15.D0*
     &    Hr1(-1)*z2*dx**2 + 3072.D0/5.D0*Hr1(-1)*z2**2*x + 3072.D0/5.D0
     &    *Hr1(-1)*z2**2*x**2 + 2296.D0/225.D0*Hr1(0) + 294116.D0/225.D0
     &    *Hr1(0)*x - 32768.D0/25.D0*Hr1(0)*x**2 + 2896.D0/75.D0*Hr1(0)
     &    *dx )
      cLgg3 = cLgg3 + nf*cf**2 * (  - 1696.D0*Hr1(0)*z3*x - 2624.D0/3.D0
     &    *Hr1(0)*z3*x**2 - 2944.D0/5.D0*Hr1(0)*z3*x**3 + 64.D0/15.D0*
     &    Hr1(0)*z2 + 8224.D0/9.D0*Hr1(0)*z2*x + 30656.D0/45.D0*Hr1(0)*
     &    z2*x**2 - 2816.D0/15.D0*Hr1(0)*z2*x**3 + 64.D0/3.D0*Hr1(0)*z2
     &    *dx + 384.D0/5.D0*Hr1(0)*z2**2*x + 6604.D0/45.D0*Hr1(1) + 
     &    70036.D0/45.D0*Hr1(1)*x - 24736.D0/15.D0*Hr1(1)*x**2 - 2432.D0
     &    /45.D0*Hr1(1)*dx + 96.D0*Hr1(1)*z3 + 2144.D0/3.D0*Hr1(1)*z3*x
     &     - 320.D0*Hr1(1)*z3*x**2 - 2176.D0/5.D0*Hr1(1)*z3*x**3 - 128.D
     &    0*Hr1(1)*z3*dx + 1088.D0/15.D0*Hr1(1)*z3*dx**2 - 1088.D0/3.D0
     &    *Hr1(1)*z2 - 128.D0/9.D0*Hr1(1)*z2*x + 3872.D0/9.D0*Hr1(1)*z2
     &    *x**2 - 704.D0/15.D0*Hr1(1)*z2*x**3 - 128.D0/9.D0*Hr1(1)*z2*
     &    dx + 352.D0/45.D0*Hr1(1)*z2*dx**2 + 256.D0*Hr2(-1,-1)*z2 - 
     &    1024.D0/3.D0*Hr2(-1,-1)*z2*x - 768.D0*Hr2(-1,-1)*z2*x**2 - 
     &    1024.D0/5.D0*Hr2(-1,-1)*z2*x**3 - 512.D0/15.D0*Hr2(-1,-1)*z2*
     &    dx**2 + 78944.D0/45.D0*Hr2(-1,0) + 107024.D0/45.D0*Hr2(-1,0)*
     &    x )
      cLgg3 = cLgg3 + nf*cf**2 * ( 2176.D0/5.D0*Hr2(-1,0)*x**2 - 17056.D
     &    0/75.D0*Hr2(-1,0)*x**3 + 64.D0/45.D0*Hr2(-1,0)*dx - 8368.D0/
     &    225.D0*Hr2(-1,0)*dx**2 + 768.D0*Hr2(-1,0)*z3*x + 768.D0*Hr2(
     &    -1,0)*z3*x**2 - 192.D0*Hr2(-1,0)*z2 + 64.D0*Hr2(-1,0)*z2*x + 
     &    384.D0*Hr2(-1,0)*z2*x**2 + 768.D0/5.D0*Hr2(-1,0)*z2*x**3 + 
     &    128.D0/5.D0*Hr2(-1,0)*z2*dx**2 + 448.D0*Hr2(0,-1)*z3*x - 384.D
     &    0*Hr2(0,-1)*z2 + 3904.D0/3.D0*Hr2(0,-1)*z2*x + 2048.D0/3.D0*
     &    Hr2(0,-1)*z2*x**2 + 1024.D0/5.D0*Hr2(0,-1)*z2*x**3 - 500.D0/9.
     &    D0*Hr2(0,0) - 8900.D0/9.D0*Hr2(0,0)*x - 48.D0*Hr2(0,0)*x**2
     &     + 17056.D0/75.D0*Hr2(0,0)*x**3 + 704.D0/45.D0*Hr2(0,0)*dx - 
     &    256.D0*Hr2(0,0)*z3*x - 32.D0*Hr2(0,0)*z2*x + 2240.D0/3.D0*
     &    Hr2(0,0)*z2*x**2 + 128.D0*Hr2(0,0)*z2*x**3 - 3856.D0/15.D0*
     &    Hr2(0,1) + 50152.D0/45.D0*Hr2(0,1)*x + 2944.D0/15.D0*Hr2(0,1)
     &    *x**2 + 2432.D0/45.D0*Hr2(0,1)*dx + 192.D0*Hr2(0,1)*z3*x + 
     &    768.D0*Hr2(0,1)*z3*x**2 - 128.D0*Hr2(0,1)*z2 - 1792.D0/3.D0*
     &    Hr2(0,1)*z2*x )
      cLgg3 = cLgg3 + nf*cf**2 * ( 1024.D0/3.D0*Hr2(0,1)*z2*x**2 + 104.D
     &    0*Hr2(1,0) - 56.D0*Hr2(1,0)*x - 48.D0*Hr2(1,0)*x**2 - 704.D0*
     &    Hr2(1,0)*z2 - 1856.D0/3.D0*Hr2(1,0)*z2*x + 960.D0*Hr2(1,0)*z2
     &    *x**2 + 1408.D0/5.D0*Hr2(1,0)*z2*x**3 + 128.D0*Hr2(1,0)*z2*dx
     &     - 704.D0/15.D0*Hr2(1,0)*z2*dx**2 + 88.D0*Hr2(1,1) + 40.D0*
     &    Hr2(1,1)*x - 128.D0*Hr2(1,1)*x**2 - 128.D0*Hr2(1,1)*z2 - 128.D
     &    0*Hr2(1,1)*z2*x + 256.D0*Hr2(1,1)*z2*x**2 - 2752.D0/3.D0*Hr3(
     &    -1,-1,0) + 1984.D0/9.D0*Hr3(-1,-1,0)*x + 11200.D0/9.D0*Hr3(-1
     &    ,-1,0)*x**2 + 1408.D0/15.D0*Hr3(-1,-1,0)*x**3 + 256.D0/9.D0*
     &    Hr3(-1,-1,0)*dx + 704.D0/45.D0*Hr3(-1,-1,0)*dx**2 + 22528.D0/
     &    15.D0*Hr3(-1,0,0) + 66784.D0/45.D0*Hr3(-1,0,0)*x - 992.D0/5.D0
     &    *Hr3(-1,0,0)*x**2 - 2944.D0/15.D0*Hr3(-1,0,0)*x**3 - 256.D0/
     &    15.D0*Hr3(-1,0,0)*dx - 1472.D0/45.D0*Hr3(-1,0,0)*dx**2 - 768.D
     &    0*Hr3(-1,0,0)*z2*x - 768.D0*Hr3(-1,0,0)*z2*x**2 + 4032.D0/5.D0
     &    *Hr3(-1,0,1) + 89728.D0/45.D0*Hr3(-1,0,1)*x + 49664.D0/45.D0*
     &    Hr3(-1,0,1)*x**2 )
      cLgg3 = cLgg3 + nf*cf**2 * (  - 1408.D0/15.D0*Hr3(-1,0,1)*x**3 - 
     &    256.D0/45.D0*Hr3(-1,0,1)*dx - 704.D0/45.D0*Hr3(-1,0,1)*dx**2
     &     - 512.D0*Hr3(0,-1,-1)*z2*x + 12352.D0/15.D0*Hr3(0,-1,0) + 
     &    2944.D0/45.D0*Hr3(0,-1,0)*x - 51392.D0/45.D0*Hr3(0,-1,0)*x**2
     &     - 1408.D0/15.D0*Hr3(0,-1,0)*x**3 - 256.D0/15.D0*Hr3(0,-1,0)*
     &    dx - 256.D0/15.D0*Hr3(0,-1,0)*dx**2 + 384.D0*Hr3(0,-1,0)*z2*x
     &     - 40.D0*Hr3(0,0,0) - 16864.D0/45.D0*Hr3(0,0,0)*x + 352.D0*
     &    Hr3(0,0,0)*x**2 + 2944.D0/15.D0*Hr3(0,0,0)*x**3 + 256.D0/15.D0
     &    *Hr3(0,0,0)*dx - 64.D0/15.D0*Hr3(0,0,1) - 38176.D0/45.D0*Hr3(
     &    0,0,1)*x - 30656.D0/45.D0*Hr3(0,0,1)*x**2 + 1408.D0/15.D0*
     &    Hr3(0,0,1)*x**3 - 192.D0/5.D0*Hr3(0,0,1)*dx - 256.D0*Hr3(0,0,
     &    1)*z2*x - 48.D0*Hr3(0,1,0) + 64.D0*Hr3(0,1,0)*x + 128.D0*Hr3(
     &    0,1,0)*x**2 - 1408.D0*Hr3(0,1,0)*z2*x - 768.D0*Hr3(0,1,0)*z2*
     &    x**2 - 64.D0*Hr3(0,1,1) + 80.D0*Hr3(0,1,1)*x + 160.D0*Hr3(0,1
     &    ,1)*x**2 - 256.D0*Hr3(0,1,1)*z2*x - 1264.D0/15.D0*Hr3(1,0,0)
     &     + 528.D0/5.D0*Hr3(1,0,0)*x )
      cLgg3 = cLgg3 + nf*cf**2 * (  - 384.D0/5.D0*Hr3(1,0,0)*x**2 + 832.
     &    D0/15.D0*Hr3(1,0,0)*dx - 96.D0*Hr3(1,0,1) - 96.D0*Hr3(1,0,1)*
     &    x + 192.D0*Hr3(1,0,1)*x**2 - 64.D0*Hr3(1,1,0) - 64.D0*Hr3(1,1
     &    ,0)*x + 128.D0*Hr3(1,1,0)*x**2 - 80.D0*Hr3(1,1,1) - 80.D0*
     &    Hr3(1,1,1)*x + 160.D0*Hr3(1,1,1)*x**2 + 256.D0*Hr4(-1,-1,-1,0
     &    ) - 256.D0*Hr4(-1,-1,-1,0)*x - 512.D0*Hr4(-1,-1,-1,0)*x**2 - 
     &    448.D0*Hr4(-1,-1,0,0) + 1472.D0/3.D0*Hr4(-1,-1,0,0)*x + 1024.D
     &    0*Hr4(-1,-1,0,0)*x**2 + 512.D0/5.D0*Hr4(-1,-1,0,0)*x**3 + 256.
     &    D0/15.D0*Hr4(-1,-1,0,0)*dx**2 - 128.D0*Hr4(-1,-1,0,1) + 640.D0
     &    /3.D0*Hr4(-1,-1,0,1)*x + 512.D0*Hr4(-1,-1,0,1)*x**2 + 1024.D0/
     &    5.D0*Hr4(-1,-1,0,1)*x**3 + 512.D0/15.D0*Hr4(-1,-1,0,1)*dx**2
     &     - 256.D0*Hr4(-1,0,-1,0) + 256.D0*Hr4(-1,0,-1,0)*x + 512.D0*
     &    Hr4(-1,0,-1,0)*x**2 + 256.D0*Hr4(-1,0,0,0) - 256.D0/3.D0*Hr4(
     &    -1,0,0,0)*x - 384.D0*Hr4(-1,0,0,0)*x**2 - 256.D0/5.D0*Hr4(-1,
     &    0,0,0)*x**3 - 128.D0/15.D0*Hr4(-1,0,0,0)*dx**2 + 64.D0*Hr4(-1
     &    ,0,0,1) )
      cLgg3 = cLgg3 + nf*cf**2 * (  - 320.D0/3.D0*Hr4(-1,0,0,1)*x - 256.
     &    D0*Hr4(-1,0,0,1)*x**2 - 512.D0/5.D0*Hr4(-1,0,0,1)*x**3 - 256.D
     &    0/15.D0*Hr4(-1,0,0,1)*dx**2 - 256.D0*Hr4(0,-1,-1,0) + 4736.D0/
     &    3.D0*Hr4(0,-1,-1,0)*x + 2048.D0/3.D0*Hr4(0,-1,-1,0)*x**2 + 
     &    512.D0*Hr4(0,-1,0,0) - 3904.D0/3.D0*Hr4(0,-1,0,0)*x - 1024.D0
     &    *Hr4(0,-1,0,0)*x**2 - 512.D0/5.D0*Hr4(0,-1,0,0)*x**3 + 256.D0
     &    *Hr4(0,-1,0,1) - 512.D0*Hr4(0,-1,0,1)*x - 1024.D0/3.D0*Hr4(0,
     &    -1,0,1)*x**2 - 1024.D0/5.D0*Hr4(0,-1,0,1)*x**3 + 256.D0*Hr4(0
     &    ,0,-1,0) - 256.D0/3.D0*Hr4(0,0,-1,0)*x - 2816.D0/3.D0*Hr4(0,0
     &    ,-1,0)*x**2 - 512.D0/5.D0*Hr4(0,0,-1,0)*x**3 + 496.D0/3.D0*
     &    Hr4(0,0,0,0)*x + 512.D0/5.D0*Hr4(0,0,0,0)*x**3 - 160.D0/3.D0*
     &    Hr4(0,0,0,1)*x - 2240.D0/3.D0*Hr4(0,0,0,1)*x**2 - 1152.D0/5.D0
     &    *Hr4(0,0,0,1)*x**3 - 224.D0*Hr4(0,0,1,0)*x - 256.D0*Hr4(0,0,1
     &    ,1)*x + 1952.D0/3.D0*Hr4(0,1,0,0)*x + 576.D0*Hr4(0,1,0,0)*
     &    x**2 + 1664.D0/5.D0*Hr4(0,1,0,0)*x**3 - 192.D0*Hr4(0,1,0,1)*x
     &     - 128.D0*Hr4(0,1,1,0)*x )
      cLgg3 = cLgg3 + nf*cf**2 * (  - 160.D0*Hr4(0,1,1,1)*x + 1024.D0/3.
     &    D0*Hr4(1,0,-1,0)*x - 256.D0*Hr4(1,0,-1,0)*x**2 - 512.D0/5.D0*
     &    Hr4(1,0,-1,0)*x**3 + 256.D0/15.D0*Hr4(1,0,-1,0)*dx**2 + 256.D0
     &    *Hr4(1,0,0,0) + 256.D0/3.D0*Hr4(1,0,0,0)*x - 384.D0*Hr4(1,0,0
     &    ,0)*x**2 + 256.D0/5.D0*Hr4(1,0,0,0)*x**3 - 128.D0/15.D0*Hr4(1
     &    ,0,0,0)*dx**2 + 576.D0*Hr4(1,0,0,1) + 1984.D0/3.D0*Hr4(1,0,0,
     &    1)*x - 832.D0*Hr4(1,0,0,1)*x**2 - 1664.D0/5.D0*Hr4(1,0,0,1)*
     &    x**3 - 128.D0*Hr4(1,0,0,1)*dx + 832.D0/15.D0*Hr4(1,0,0,1)*
     &    dx**2 - 448.D0*Hr4(1,1,0,0) - 1600.D0/3.D0*Hr4(1,1,0,0)*x + 
     &    576.D0*Hr4(1,1,0,0)*x**2 + 1664.D0/5.D0*Hr4(1,1,0,0)*x**3 + 
     &    128.D0*Hr4(1,1,0,0)*dx - 832.D0/15.D0*Hr4(1,1,0,0)*dx**2 + 
     &    768.D0*Hr5(-1,0,0,0,1)*x + 768.D0*Hr5(-1,0,0,0,1)*x**2 - 768.D
     &    0*Hr5(-1,0,1,0,0)*x - 768.D0*Hr5(-1,0,1,0,0)*x**2 - 512.D0*
     &    Hr5(0,-1,-1,-1,0)*x + 896.D0*Hr5(0,-1,-1,0,0)*x + 256.D0*Hr5(
     &    0,-1,-1,0,1)*x + 512.D0*Hr5(0,-1,0,-1,0)*x - 512.D0*Hr5(0,-1,
     &    0,0,0)*x )
      cLgg3 = cLgg3 + nf*cf**2 * (  - 128.D0*Hr5(0,-1,0,0,1)*x + 512.D0
     &    *Hr5(0,0,-1,-1,0)*x - 128.D0*Hr5(0,0,-1,0,0)*x + 256.D0*Hr5(0
     &    ,0,-1,0,1)*x + 128.D0*Hr5(0,0,1,0,0)*x + 512.D0*Hr5(0,1,0,0,0
     &    )*x + 1152.D0*Hr5(0,1,0,0,1)*x + 768.D0*Hr5(0,1,0,0,1)*x**2
     &     - 896.D0*Hr5(0,1,1,0,0)*x - 768.D0*Hr5(0,1,1,0,0)*x**2 )
      cLgg3 = cLgg3 + nf2*ca * (  - 6364.D0/135.D0 - 97376.D0/135.D0*
     &    x + 99844.D0/135.D0*x**2 + 3896.D0/135.D0*dx + 224.D0/3.D0*z3
     &    *x - 48.D0*z3*x**2 + 2128.D0/9.D0*z2*x - 512.D0/3.D0*z2*x**2
     &     - 32.D0/5.D0*z2*x**3 - 32.D0/9.D0*z2*dx + 32.D0*Hr1(-1)*z2*x
     &     + 32.D0*Hr1(-1)*z2*x**2 - 424.D0/45.D0*Hr1(0) - 86912.D0/135.
     &    D0*Hr1(0)*x + 51584.D0/135.D0*Hr1(0)*x**2 + 16.D0/15.D0*Hr1(0
     &    )*dx + 96.D0*Hr1(0)*z2*x - 64.D0/3.D0*Hr1(0)*z2*x**2 - 64.D0/
     &    3.D0*Hr1(1) - 12032.D0/27.D0*Hr1(1)*x + 12208.D0/27.D0*Hr1(1)
     &    *x**2 + 400.D0/27.D0*Hr1(1)*dx - 32.D0/3.D0*Hr1(1)*z2*x + 32.D
     &    0/3.D0*Hr1(1)*z2*x**2 - 16.D0/3.D0*Hr2(-1,0) - 512.D0/9.D0*
     &    Hr2(-1,0)*x - 544.D0/9.D0*Hr2(-1,0)*x**2 - 32.D0/5.D0*Hr2(-1,
     &    0)*x**3 - 32.D0/9.D0*Hr2(-1,0)*dx - 16.D0/15.D0*Hr2(-1,0)*
     &    dx**2 + 16.D0/3.D0*Hr2(0,0) - 3040.D0/9.D0*Hr2(0,0)*x + 416.D0
     &    /3.D0*Hr2(0,0)*x**2 + 32.D0/5.D0*Hr2(0,0)*x**3 - 880.D0/3.D0*
     &    Hr2(0,1)*x + 512.D0/3.D0*Hr2(0,1)*x**2 - 32.D0/3.D0*Hr2(1,0)
     &     - 1184.D0/9.D0*Hr2(1,0)*x )
      cLgg3 = cLgg3 + nf2*ca * ( 416.D0/3.D0*Hr2(1,0)*x**2 + 32.D0/9.D
     &    0*Hr2(1,0)*dx - 32.D0/3.D0*Hr2(1,1) - 1184.D0/9.D0*Hr2(1,1)*x
     &     + 416.D0/3.D0*Hr2(1,1)*x**2 + 32.D0/9.D0*Hr2(1,1)*dx + 64.D0/
     &    3.D0*Hr3(-1,-1,0)*x + 64.D0/3.D0*Hr3(-1,-1,0)*x**2 - 64.D0*
     &    Hr3(-1,0,0)*x - 64.D0*Hr3(-1,0,0)*x**2 - 64.D0/3.D0*Hr3(-1,0,
     &    1)*x - 64.D0/3.D0*Hr3(-1,0,1)*x**2 - 32.D0/3.D0*Hr3(0,-1,0)*x
     &     - 128.D0/3.D0*Hr3(0,-1,0)*x**2 - 128.D0*Hr3(0,0,0)*x - 320.D0
     &    /3.D0*Hr3(0,0,1)*x + 64.D0/3.D0*Hr3(0,0,1)*x**2 - 64.D0*Hr3(0
     &    ,1,0)*x + 64.D0/3.D0*Hr3(0,1,0)*x**2 - 64.D0*Hr3(0,1,1)*x + 
     &    64.D0/3.D0*Hr3(0,1,1)*x**2 - 64.D0/3.D0*Hr3(1,0,0)*x + 64.D0/
     &    3.D0*Hr3(1,0,0)*x**2 - 128.D0/3.D0*Hr3(1,1,0)*x + 128.D0/3.D0
     &    *Hr3(1,1,0)*x**2 - 64.D0/3.D0*Hr3(1,1,1)*x + 64.D0/3.D0*Hr3(1
     &    ,1,1)*x**2 )
      cLgg3 = cLgg3 + nf2*cf * ( 393496.D0/675.D0 - 771296.D0/675.D0*
     &    x + 1101512.D0/2025.D0*x**2 + 31888.D0/2025.D0*dx - 32.D0*z3
     &     + 3712.D0/9.D0*z3*x - 224.D0/3.D0*z3*x**2 + 128.D0/3.D0*z3*
     &    x**3 - 6208.D0/45.D0*z2 + 27152.D0/135.D0*z2*x - 1568.D0/15.D0
     &    *z2*x**2 - 6848.D0/225.D0*z2*x**3 - 448.D0/45.D0*z2*dx + 32.D0
     &    /5.D0*z2**2*x - 32.D0/3.D0*Hr1(-1)*z2*x + 64.D0/5.D0*Hr1(-1)*
     &    z2*x**3 + 32.D0/15.D0*Hr1(-1)*z2*dx**2 + 254648.D0/675.D0*
     &    Hr1(0) - 105824.D0/225.D0*Hr1(0)*x - 8512.D0/225.D0*Hr1(0)*
     &    x**2 + 3584.D0/675.D0*Hr1(0)*dx + 128.D0*Hr1(0)*z3*x - 64.D0*
     &    Hr1(0)*z2 + 3008.D0/9.D0*Hr1(0)*z2*x + 416.D0/3.D0*Hr1(0)*z2*
     &    x**2 - 192.D0/5.D0*Hr1(0)*z2*x**3 + 1464.D0/5.D0*Hr1(1) - 
     &    16696.D0/45.D0*Hr1(1)*x + 10912.D0/135.D0*Hr1(1)*x**2 - 352.D0
     &    /135.D0*Hr1(1)*dx + 128.D0/9.D0*Hr1(1)*z2*x + 32.D0/3.D0*Hr1(
     &    1)*z2*x**2 - 128.D0/5.D0*Hr1(1)*z2*x**3 + 32.D0/45.D0*Hr1(1)*
     &    z2*dx**2 - 2848.D0/45.D0*Hr2(-1,0) + 10976.D0/135.D0*Hr2(-1,0
     &    )*x )
      cLgg3 = cLgg3 + nf2*cf * ( 5056.D0/45.D0*Hr2(-1,0)*x**2 - 6848.D
     &    0/225.D0*Hr2(-1,0)*x**3 - 128.D0/15.D0*Hr2(-1,0)*dx - 4544.D0/
     &    675.D0*Hr2(-1,0)*dx**2 + 2288.D0/15.D0*Hr2(0,0) - 57008.D0/
     &    135.D0*Hr2(0,0)*x + 1024.D0/15.D0*Hr2(0,0)*x**2 + 6848.D0/225.
     &    D0*Hr2(0,0)*x**3 + 64.D0/15.D0*Hr2(0,0)*dx + 192.D0*Hr2(0,0)*
     &    z2*x + 6208.D0/45.D0*Hr2(0,1) - 5392.D0/45.D0*Hr2(0,1)*x + 
     &    1568.D0/15.D0*Hr2(0,1)*x**2 + 64.D0/45.D0*Hr2(0,1)*dx + 224.D0
     &    /3.D0*Hr2(1,0) - 544.D0/3.D0*Hr2(1,0)*x + 896.D0/9.D0*Hr2(1,0
     &    )*x**2 + 64.D0/9.D0*Hr2(1,0)*dx + 224.D0/3.D0*Hr2(1,1) - 512.D
     &    0/3.D0*Hr2(1,1)*x + 800.D0/9.D0*Hr2(1,1)*x**2 + 64.D0/9.D0*
     &    Hr2(1,1)*dx - 64.D0/9.D0*Hr3(-1,-1,0)*x + 128.D0/15.D0*Hr3(-1
     &    ,-1,0)*x**3 + 64.D0/45.D0*Hr3(-1,-1,0)*dx**2 + 64.D0/3.D0*
     &    Hr3(-1,0,0)*x - 128.D0/5.D0*Hr3(-1,0,0)*x**3 - 64.D0/15.D0*
     &    Hr3(-1,0,0)*dx**2 + 64.D0/9.D0*Hr3(-1,0,1)*x - 128.D0/15.D0*
     &    Hr3(-1,0,1)*x**3 - 64.D0/45.D0*Hr3(-1,0,1)*dx**2 + 1216.D0/9.D
     &    0*Hr3(0,-1,0)*x )
      cLgg3 = cLgg3 + nf2*cf * (  - 128.D0/3.D0*Hr3(0,-1,0)*x**2 - 
     &    128.D0/15.D0*Hr3(0,-1,0)*x**3 - 128.D0/45.D0*Hr3(0,-1,0)*
     &    dx**2 + 80.D0*Hr3(0,0,0) - 1648.D0/3.D0*Hr3(0,0,0)*x - 256.D0
     &    *Hr3(0,0,0)*x**2 + 128.D0/5.D0*Hr3(0,0,0)*x**3 + 64.D0*Hr3(0,
     &    0,1) - 1792.D0/9.D0*Hr3(0,0,1)*x - 416.D0/3.D0*Hr3(0,0,1)*
     &    x**2 + 448.D0/15.D0*Hr3(0,0,1)*x**3 + 32.D0*Hr3(0,1,0) - 32.D0
     &    *Hr3(0,1,0)*x**2 - 64.D0/3.D0*Hr3(0,1,0)*x**3 + 32.D0*Hr3(0,1
     &    ,1) - 32.D0/3.D0*Hr3(0,1,1)*x - 128.D0/3.D0*Hr3(0,1,1)*x**2
     &     - 32.D0/3.D0*Hr3(1,0,1)*x - 32.D0/3.D0*Hr3(1,0,1)*x**2 + 64.D
     &    0/3.D0*Hr3(1,0,1)*x**3 + 32.D0/3.D0*Hr3(1,1,0)*x + 32.D0/3.D0
     &    *Hr3(1,1,0)*x**2 - 64.D0/3.D0*Hr3(1,1,0)*x**3 - 352.D0*Hr4(0,
     &    0,0,0)*x - 192.D0*Hr4(0,0,0,1)*x - 64.D0*Hr4(0,0,1,0)*x - 64.D
     &    0*Hr4(0,0,1,1)*x )
*
* ...Output; if commented out, only the flg11 part is returned
*
       XLG3A = CLGG3 
       endif
*
       RETURN
       END
*
* =================================================================av==
      END MODULE XCLGL3E
