      MODULE XCLNS3E
      CONTAINS
*     
* ..File: xclns3e.f    FL_NS
*
*
* ..The exact 3-loop MS(bar) non-singlet coefficient functions for the 
*    structure function F_L in electromagnetic DIS at mu_r = mu_f = Q. 
*    Expansion parameter: alpha_s/(4 pi).
* 
* ..The distributions (in the mathematical sense) are given as in eq.
*    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.
*    The name-endings A, B, and C of the functions below correspond to 
*    the kernel superscripts [2], [3], and [1] in that equation.
*
* ..The code uses the package of Gehrmann and Remiddi for the harmonic
*    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296,
*    upgraded to weight 5 (T. Gehrmann, private communication).
*
* ..References: S. Moch, J. Vermaseren and A. Vogt, hep-ph/0209100
*               J. Vermaseren, A. Vogt and S. Moch, hep-ph/0504242
*
* =====================================================================
*
*
* ..There is only a regular piece. 
*
       FUNCTION XLNP3A (X, NF, CC)
*
       IMPLICIT REAL*8 (A - Z)
       COMPLEX*16 HC1, HC2, HC3, HC4, HC5
       INTEGER NF, NF2, N1, N2, NW, CC
       PARAMETER ( N1 = -1, N2 = 1, NW = 5 )
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),
     ,           HC4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HC5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),
     ,           HR4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HR5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),
     ,           HI4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HI5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0,
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
       DIMENSION FL(6)
       DATA FL  / -1.d0, 0.5d0, 0.d0, 0.5d0, 0.2d0, 0.5d0 /
*
* ...Colour factors 
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
       DABC2N = 5./18.D0 * NF
       FL11 = FL(NF)
*
* ...Some abbreviations 
*
       DX = 1.D0/X
       DM = 1.D0/(1.D0-X)
       DP = 1.D0/(1.D0+X)
*
* ...Harmonic polylogs (HPLs) up to weight 5 by Gehrmann and Remiddi
*
       CALL HPLOG5 (X, NW, HC1,HC2,HC3,HC4,HC5, HR1,HR2,HR3,HR4,HR5,
     ,              HI1,HI2,HI3,HI4,HI5, N1, N2)
*
* ...The coefficient function in terms of the HPLs, fl11 part
*
       if(CC.eq.0) then
      cLqq3 =
     &  + dabc2n * fl11 * (  - 768.D0/5.D0 - 1152.D0/5.D0*x + 768.D0/
     &    5.D0*x**2 + 2560.D0*z5*x + 512.D0/5.D0*dx - 4864.D0/15.D0*z3
     &     - 23488.D0/15.D0*z3*x + 896.D0/5.D0*z3*x**2 - 1280.D0*z3*
     &    x**3 + 4096.D0/15.D0*z3*dx - 9088.D0/15.D0*z2 + 10112.D0/15.D0
     &    *z2*x - 512.D0*z2*x**2 - 3328.D0/5.D0*z2*x**3 + 2048.D0/3.D0*
     &    z2*dx + 256.D0*z2*z3*x + 576.D0/5.D0*z2**2*x + 2048.D0/5.D0*
     &    z2**2*x**2 - 3072.D0/25.D0*z2**2*x**3 - 512.D0*Hr1(-1)*z3*x
     &     + 1536.D0/5.D0*Hr1(-1)*z3*x**3 - 1024.D0/5.D0*Hr1(-1)*z3*
     &    dx**2 - 3712.D0/15.D0*Hr1(-1)*z2 + 3136.D0/5.D0*Hr1(-1)*z2*x
     &     + 128.D0/5.D0*Hr1(-1)*z2*x**2 + 768.D0*Hr1(-1)*z2*x**3 - 
     &    1216.D0/15.D0*Hr1(-1)*z2*dx - 512.D0*Hr1(-1)*z2*dx**2 - 2048.D
     &    0/5.D0*Hr1(-1)*z2**2*x - 512.D0/15.D0*Hr1(0) - 896.D0/5.D0*
     &    Hr1(0)*x + 3328.D0/5.D0*Hr1(0)*x**2 - 512.D0/5.D0*Hr1(0)*dx
     &     + 512.D0/3.D0*Hr1(0)*z3*x + 512.D0*Hr1(0)*z3*x**2 - 2048.D0/
     &    5.D0*Hr1(0)*z3*x**3 + 1792.D0/15.D0*Hr1(0)*z2 - 640.D0/3.D0*
     &    Hr1(0)*z2*x )
      cLqq3 = cLqq3 + dabc2n *fl11 * ( 1792.D0/5.D0*Hr1(0)*z2*x**2
     &     - 1024.D0*Hr1(0)*z2*x**3 - 9344.D0/15.D0*Hr1(1) - 1152.D0/5.D
     &    0*Hr1(1)*x + 512.D0*Hr1(1)*x**2 + 1024.D0/3.D0*Hr1(1)*dx - 
     &    512.D0*Hr1(1)*z3 + 896.D0/3.D0*Hr1(1)*z3*x + 512.D0*Hr1(1)*z3
     &    *x**2 - 512.D0/5.D0*Hr1(1)*z3*x**3 + 256.D0*Hr1(1)*z3*dx - 
     &    1024.D0/15.D0*Hr1(1)*z3*dx**2 - 128.D0*Hr1(1)*z2 - 64.D0/3.D0
     &    *Hr1(1)*z2*x + 384.D0*Hr1(1)*z2*x**2 - 256.D0*Hr1(1)*z2*x**3
     &     + 192.D0*Hr1(1)*z2*dx - 512.D0/3.D0*Hr1(1)*z2*dx**2 + 2048.D0
     &    /3.D0*Hr2(-1,-1)*z2*x - 2048.D0/5.D0*Hr2(-1,-1)*z2*x**3 + 
     &    4096.D0/15.D0*Hr2(-1,-1)*z2*dx**2 + 256.D0/3.D0*Hr2(-1,0) - 
     &    1664.D0/3.D0*Hr2(-1,0)*x - 512.D0*Hr2(-1,0)*x**2 - 3328.D0/5.D
     &    0*Hr2(-1,0)*x**3 + 1024.D0/3.D0*Hr2(-1,0)*dx + 6656.D0/15.D0*
     &    Hr2(-1,0)*dx**2 - 512.D0*Hr2(-1,0)*z3*x - 1408.D0/3.D0*Hr2(-1
     &    ,0)*z2*x + 1024.D0/5.D0*Hr2(-1,0)*z2*x**3 - 2048.D0/15.D0*
     &    Hr2(-1,0)*z2*dx**2 - 896.D0/3.D0*Hr2(0,-1)*z2*x + 2048.D0/5.D0
     &    *Hr2(0,-1)*z2*x**3 )
      cLqq3 = cLqq3 + dabc2n * fl11 * ( 512.D0/3.D0*Hr2(0,0) - 6272.D0
     &    /15.D0*Hr2(0,0)*x + 512.D0*Hr2(0,0)*x**2 + 3328.D0/5.D0*Hr2(0
     &    ,0)*x**3 - 1024.D0/3.D0*Hr2(0,0)*dx - 512.D0*Hr2(0,0)*z2*x**2
     &     + 9088.D0/15.D0*Hr2(0,1) - 6144.D0/5.D0*Hr2(0,1)*x + 512.D0*
     &    Hr2(0,1)*x**2 - 1024.D0/3.D0*Hr2(0,1)*dx - 512.D0*Hr2(0,1)*z3
     &    *x - 128.D0*Hr2(0,1)*z2*x + 512.D0*Hr2(1,0)*z2 + 128.D0/3.D0*
     &    Hr2(1,0)*z2*x - 512.D0*Hr2(1,0)*z2*x**2 + 1024.D0/5.D0*Hr2(1,
     &    0)*z2*x**3 - 256.D0*Hr2(1,0)*z2*dx + 2048.D0/15.D0*Hr2(1,0)*
     &    z2*dx**2 - 256.D0*Hr3(-1,-1,0) + 128.D0/3.D0*Hr3(-1,-1,0)*x
     &     + 768.D0*Hr3(-1,-1,0)*x**2 + 512.D0*Hr3(-1,-1,0)*x**3 - 384.D
     &    0*Hr3(-1,-1,0)*dx - 1024.D0/3.D0*Hr3(-1,-1,0)*dx**2 + 2816.D0/
     &    15.D0*Hr3(-1,0,0) - 4864.D0/15.D0*Hr3(-1,0,0)*x - 1024.D0/5.D0
     &    *Hr3(-1,0,0)*x**2 - 512.D0*Hr3(-1,0,0)*x**3 + 2048.D0/15.D0*
     &    Hr3(-1,0,0)*dx + 1024.D0/3.D0*Hr3(-1,0,0)*dx**2 + 512.D0*Hr3(
     &    -1,0,0)*z2*x + 1792.D0/15.D0*Hr3(-1,0,1) - 9088.D0/15.D0*Hr3(
     &    -1,0,1)*x )
      cLqq3 = cLqq3 + dabc2n * fl11 * ( 1792.D0/5.D0*Hr3(-1,0,1)*x**2
     &     - 512.D0*Hr3(-1,0,1)*x**3 - 1664.D0/15.D0*Hr3(-1,0,1)*dx + 
     &    1024.D0/3.D0*Hr3(-1,0,1)*dx**2 + 256.D0/3.D0*Hr3(0,-1,0)*x - 
     &    768.D0*Hr3(0,-1,0)*x**2 - 512.D0*Hr3(0,-1,0)*x**3 - 256.D0/3.D
     &    0*Hr3(0,0,0)*x + 512.D0*Hr3(0,0,0)*x**3 - 1792.D0/15.D0*Hr3(0
     &    ,0,1) + 896.D0/3.D0*Hr3(0,0,1)*x - 1792.D0/5.D0*Hr3(0,0,1)*
     &    x**2 + 512.D0*Hr3(0,0,1)*x**3 + 512.D0*Hr3(0,1,0)*z2*x + 2816.
     &    D0/15.D0*Hr3(1,0,0) + 128.D0/5.D0*Hr3(1,0,0)*x - 1024.D0/5.D0
     &    *Hr3(1,0,0)*x**2 - 2048.D0/15.D0*Hr3(1,0,0)*dx - 1024.D0/3.D0
     &    *Hr4(-1,-1,0,0)*x + 1024.D0/5.D0*Hr4(-1,-1,0,0)*x**3 - 2048.D0
     &    /15.D0*Hr4(-1,-1,0,0)*dx**2 - 2048.D0/3.D0*Hr4(-1,-1,0,1)*x
     &     + 2048.D0/5.D0*Hr4(-1,-1,0,1)*x**3 - 4096.D0/15.D0*Hr4(-1,-1
     &    ,0,1)*dx**2 + 128.D0*Hr4(-1,0,0,0)*x + 1024.D0/3.D0*Hr4(-1,0,
     &    0,1)*x - 1024.D0/5.D0*Hr4(-1,0,0,1)*x**3 + 2048.D0/15.D0*Hr4(
     &    -1,0,0,1)*dx**2 + 256.D0*Hr4(0,-1,-1,0)*x + 256.D0/3.D0*Hr4(0
     &    ,-1,0,0)*x )
      cLqq3 = cLqq3 + dabc2n * fl11 * (  - 1024.D0/5.D0*Hr4(0,-1,0,0)
     &    *x**3 + 1280.D0/3.D0*Hr4(0,-1,0,1)*x - 2048.D0/5.D0*Hr4(0,-1,
     &    0,1)*x**3 + 512.D0*Hr4(0,0,0,1)*x**2 - 256.D0/3.D0*Hr4(0,1,0,
     &    0)*x - 512.D0*Hr4(0,1,0,0)*x**2 + 1024.D0/5.D0*Hr4(0,1,0,0)*
     &    x**3 + 256.D0*Hr4(1,0,-1,0)*x - 128.D0*Hr4(1,0,0,0)*x - 512.D0
     &    *Hr4(1,0,0,1) + 256.D0/3.D0*Hr4(1,0,0,1)*x + 512.D0*Hr4(1,0,0
     &    ,1)*x**2 - 1024.D0/5.D0*Hr4(1,0,0,1)*x**3 + 256.D0*Hr4(1,0,0,
     &    1)*dx - 2048.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 512.D0*Hr4(1,1,0,0
     &    ) - 256.D0/3.D0*Hr4(1,1,0,0)*x - 512.D0*Hr4(1,1,0,0)*x**2 + 
     &    1024.D0/5.D0*Hr4(1,1,0,0)*x**3 - 256.D0*Hr4(1,1,0,0)*dx + 
     &    2048.D0/15.D0*Hr4(1,1,0,0)*dx**2 - 512.D0*Hr5(-1,0,0,0,1)*x
     &     + 512.D0*Hr5(-1,0,1,0,0)*x - 512.D0*Hr5(0,1,0,0,1)*x + 512.D0
     &    *Hr5(0,1,1,0,0)*x )
*
       XLNP3A = CLQQ3
       endif
*
* ...The coefficient function in terms of the HPLs, standard parts
*
       if(CC.eq.1) then
      cLqq3 = cf*ca**2 * (  - 271972.D0/675.D0 + 3672316.D0/
     &    2025.D0*x - 26432.D0/75.D0*x**2 - 224.D0*z5*x - 51104.D0/225.D
     &    0*dx + 176.D0/5.D0*z3 + 8372.D0/15.D0*z3*x - 1616.D0/15.D0*z3
     &    *x**2 - 1868.D0/3.D0*z3*x**3 + 1136.D0/15.D0*z3*dx + 13136.D0/
     &    45.D0*z2 - 53464.D0/45.D0*z2*x - 496.D0/15.D0*z2*x**2 + 4984.D
     &    0/25.D0*z2*x**3 - 784.D0/9.D0*z2*dx - 288.D0*z2*z3*x + 116.D0
     &    *z2**2*x - 3008.D0/15.D0*z2**2*x**2 + 224.D0/5.D0*z2**2*x**3
     &     - 768.D0*Hr1(-1)*z3 - 1600.D0/3.D0*Hr1(-1)*z3*x + 192.D0*
     &    Hr1(-1)*z3*x**3 - 128.D0*Hr1(-1)*z3*dx**2 - 656.D0/3.D0*Hr1(
     &    -1)*z2 - 3544.D0/9.D0*Hr1(-1)*z2*x + 280.D0/3.D0*Hr1(-1)*z2*
     &    x**2 + 284.D0/5.D0*Hr1(-1)*z2*x**3 - 268.D0/3.D0*Hr1(-1)*z2*
     &    dx - 568.D0/15.D0*Hr1(-1)*z2*dx**2 - 64.D0/5.D0*Hr1(-1)*z2**2
     &    *x - 33832.D0/225.D0*Hr1(0) + 1558544.D0/675.D0*Hr1(0)*x - 
     &    7984.D0/25.D0*Hr1(0)*x**2 + 29984.D0/225.D0*Hr1(0)*dx + 208.D0
     &    /3.D0*Hr1(0)*z3*x - 752.D0/3.D0*Hr1(0)*z3*x**2 - 568.D0/5.D0*
     &    Hr1(0)*z3*x**3 )
      cLqq3 = cLqq3 + cf*ca**2 * (  - 152.D0/5.D0*Hr1(0)*z2 + 25264.D0/
     &    45.D0*Hr1(0)*z2*x + 3752.D0/15.D0*Hr1(0)*z2*x**2 + 1504.D0/15.
     &    D0*Hr1(0)*z2*x**3 + 688.D0/5.D0*Hr1(0)*z2*dx - 7624.D0/15.D0*
     &    Hr1(1) + 205796.D0/135.D0*Hr1(1)*x + 496.D0/15.D0*Hr1(1)*x**2
     &     - 4288.D0/45.D0*Hr1(1)*dx - 160.D0*Hr1(1)*z3 + 1312.D0/3.D0*
     &    Hr1(1)*z3*x - 752.D0/3.D0*Hr1(1)*z3*x**2 + 392.D0/5.D0*Hr1(1)
     &    *z3*x**3 - 376.D0/3.D0*Hr1(1)*z3*dx + 784.D0/15.D0*Hr1(1)*z3*
     &    dx**2 - 208.D0/3.D0*Hr1(1)*z2 - 1256.D0/3.D0*Hr1(1)*z2*x + 
     &    488.D0/3.D0*Hr1(1)*z2*x**2 + 2356.D0/15.D0*Hr1(1)*z2*x**3 + 
     &    244.D0/3.D0*Hr1(1)*z2*dx - 568.D0/45.D0*Hr1(1)*z2*dx**2 + 704.
     &    D0/5.D0*Hr1(1)*z2**2*x + 768.D0*Hr2(-1,-1)*z3*x + 1024.D0*
     &    Hr2(-1,-1)*z2 + 768.D0*Hr2(-1,-1)*z2*x - 256.D0*Hr2(-1,-1)*z2
     &    *x**3 + 512.D0/3.D0*Hr2(-1,-1)*z2*dx**2 - 3448.D0/3.D0*Hr2(-1
     &    ,0) - 6568.D0/9.D0*Hr2(-1,0)*x - 184.D0/15.D0*Hr2(-1,0)*x**2
     &     + 4984.D0/25.D0*Hr2(-1,0)*x**3 + 368.D0/45.D0*Hr2(-1,0)*dx
     &     - 28144.D0/225.D0*Hr2(-1,0)*dx**2 )
      cLqq3 = cLqq3 + cf*ca**2 * (  - 384.D0*Hr2(-1,0)*z3*x - 640.D0*
     &    Hr2(-1,0)*z2 - 1744.D0/3.D0*Hr2(-1,0)*z2*x + 704.D0/5.D0*Hr2(
     &    -1,0)*z2*x**3 - 1408.D0/15.D0*Hr2(-1,0)*z2*dx**2 - 1040.D0/3.D
     &    0*Hr2(0,-1)*z2*x + 256.D0*Hr2(0,-1)*z2*x**3 - 4256.D0/45.D0*
     &    Hr2(0,0) + 58256.D0/45.D0*Hr2(0,0)*x - 4256.D0/15.D0*Hr2(0,0)
     &    *x**2 - 4984.D0/25.D0*Hr2(0,0)*x**3 + 3856.D0/45.D0*Hr2(0,0)*
     &    dx + 280.D0/3.D0*Hr2(0,0)*z2*x + 752.D0/3.D0*Hr2(0,0)*z2*x**2
     &     - 1032.D0/5.D0*Hr2(0,0)*z2*x**3 - 13136.D0/45.D0*Hr2(0,1) + 
     &    20624.D0/45.D0*Hr2(0,1)*x + 496.D0/15.D0*Hr2(0,1)*x**2 + 4288.
     &    D0/45.D0*Hr2(0,1)*dx + 160.D0*Hr2(0,1)*z3*x - 1072.D0/3.D0*
     &    Hr2(0,1)*z2*x + 2552.D0/9.D0*Hr2(1,0)*x - 176.D0*Hr2(1,0)*
     &    x**2 + 544.D0*Hr2(1,0)*z3*x - 96.D0*Hr2(1,0)*z2 - 832.D0/3.D0
     &    *Hr2(1,0)*z2*x + 752.D0/3.D0*Hr2(1,0)*z2*x**2 - 328.D0/5.D0*
     &    Hr2(1,0)*z2*x**3 + 376.D0/3.D0*Hr2(1,0)*z2*dx - 656.D0/15.D0*
     &    Hr2(1,0)*z2*dx**2 + 2552.D0/9.D0*Hr2(1,1)*x + 320.D0*Hr2(1,1)
     &    *z3*x )
      cLqq3 = cLqq3 + cf*ca**2 * (  - 688.D0/3.D0*Hr2(1,1)*z2*x - 1024.D
     &    0*Hr3(-1,-1,-1)*z2*x - 416.D0/3.D0*Hr3(-1,-1,0) + 720.D0*Hr3(
     &    -1,-1,0)*x + 976.D0/3.D0*Hr3(-1,-1,0)*x**2 + 568.D0/15.D0*
     &    Hr3(-1,-1,0)*x**3 - 488.D0/3.D0*Hr3(-1,-1,0)*dx - 1136.D0/45.D
     &    0*Hr3(-1,-1,0)*dx**2 + 640.D0*Hr3(-1,-1,0)*z2*x + 512.D0*Hr3(
     &    -1,0,-1)*z2*x - 976.D0/3.D0*Hr3(-1,0,0) - 1960.D0/9.D0*Hr3(-1
     &    ,0,0)*x - 128.D0*Hr3(-1,0,0)*x**2 + 1544.D0/15.D0*Hr3(-1,0,0)
     &    *x**3 + 256.D0/3.D0*Hr3(-1,0,0)*dx - 3088.D0/45.D0*Hr3(-1,0,0
     &    )*dx**2 - 448.D0*Hr3(-1,0,0)*z2*x + 448.D0/3.D0*Hr3(-1,0,1)
     &     + 6784.D0/9.D0*Hr3(-1,0,1)*x + 208.D0/3.D0*Hr3(-1,0,1)*x**2
     &     - 568.D0/15.D0*Hr3(-1,0,1)*x**3 + 8.D0*Hr3(-1,0,1)*dx + 1136.
     &    D0/45.D0*Hr3(-1,0,1)*dx**2 - 2384.D0/5.D0*Hr3(0,-1,0) + 9896.D
     &    0/45.D0*Hr3(0,-1,0)*x - 4496.D0/15.D0*Hr3(0,-1,0)*x**2 - 568.D
     &    0/15.D0*Hr3(0,-1,0)*x**3 + 256.D0/15.D0*Hr3(0,-1,0)*dx - 1408.
     &    D0/15.D0*Hr3(0,-1,0)*dx**2 + 664.D0/45.D0*Hr3(0,0,0)*x - 1544.
     &    D0/15.D0*Hr3(0,0,0)*x**3 )
      cLqq3 = cLqq3 + cf*ca**2 * (  - 256.D0/15.D0*Hr3(0,0,0)*dx + 152.D
     &    0/5.D0*Hr3(0,0,1) - 15368.D0/45.D0*Hr3(0,0,1)*x - 3752.D0/15.D
     &    0*Hr3(0,0,1)*x**2 - 2072.D0/15.D0*Hr3(0,0,1)*x**3 - 1808.D0/
     &    15.D0*Hr3(0,0,1)*dx + 176.D0*Hr3(0,1,0)*x**3 - 160.D0*Hr3(0,1
     &    ,0)*z2*x - 512.D0*Hr3(1,0,-1)*z2*x - 536.D0/15.D0*Hr3(1,0,0)
     &     + 14608.D0/45.D0*Hr3(1,0,0)*x + 264.D0/5.D0*Hr3(1,0,0)*x**2
     &     + 176.D0/5.D0*Hr3(1,0,0)*dx + 288.D0*Hr3(1,0,0)*z2*x + 176.D0
     &    /3.D0*Hr3(1,0,1)*x - 176.D0*Hr3(1,0,1)*x**3 - 176.D0/3.D0*
     &    Hr3(1,1,0)*x + 176.D0*Hr3(1,1,0)*x**3 - 64.D0*Hr3(1,1,0)*z2*x
     &     - 1024.D0/3.D0*Hr4(-1,-1,-1,0)*x - 512.D0*Hr4(-1,-1,0,0) + 
     &    512.D0/3.D0*Hr4(-1,-1,0,0)*x + 128.D0*Hr4(-1,-1,0,0)*x**3 - 
     &    256.D0/3.D0*Hr4(-1,-1,0,0)*dx**2 - 1024.D0*Hr4(-1,-1,0,1) - 
     &    2816.D0/3.D0*Hr4(-1,-1,0,1)*x + 256.D0*Hr4(-1,-1,0,1)*x**3 - 
     &    512.D0/3.D0*Hr4(-1,-1,0,1)*dx**2 + 1216.D0/3.D0*Hr4(-1,0,-1,0
     &    )*x + 128.D0*Hr4(-1,0,0,0) - 368.D0/3.D0*Hr4(-1,0,0,0)*x - 64.
     &    D0/5.D0*Hr4(-1,0,0,0)*x**3 )
      cLqq3 = cLqq3 + cf*ca**2 * ( 128.D0/15.D0*Hr4(-1,0,0,0)*dx**2 + 
     &    512.D0*Hr4(-1,0,0,1) + 1408.D0/3.D0*Hr4(-1,0,0,1)*x - 128.D0*
     &    Hr4(-1,0,0,1)*x**3 + 256.D0/3.D0*Hr4(-1,0,0,1)*dx**2 + 2144.D0
     &    /3.D0*Hr4(0,-1,-1,0)*x - 16.D0/3.D0*Hr4(0,-1,0,0)*x - 128.D0*
     &    Hr4(0,-1,0,0)*x**3 + 704.D0*Hr4(0,-1,0,1)*x - 256.D0*Hr4(0,-1
     &    ,0,1)*x**3 + 208.D0/3.D0*Hr4(0,0,-1,0)*x - 128.D0/5.D0*Hr4(0,
     &    0,-1,0)*x**3 - 208.D0/3.D0*Hr4(0,0,0,0)*x + 128.D0/5.D0*Hr4(0
     &    ,0,0,0)*x**3 - 24.D0*Hr4(0,0,0,1)*x - 752.D0/3.D0*Hr4(0,0,0,1
     &    )*x**2 + 904.D0/5.D0*Hr4(0,0,0,1)*x**3 + 88.D0/3.D0*Hr4(0,1,0
     &    ,0)*x + 752.D0/3.D0*Hr4(0,1,0,0)*x**2 - 264.D0/5.D0*Hr4(0,1,0
     &    ,0)*x**3 - 256.D0*Hr4(1,0,-1,0) + 1888.D0/3.D0*Hr4(1,0,-1,0)*
     &    x - 128.D0/5.D0*Hr4(1,0,-1,0)*x**3 - 256.D0/15.D0*Hr4(1,0,-1,
     &    0)*dx**2 + 128.D0*Hr4(1,0,0,0) + 368.D0/3.D0*Hr4(1,0,0,0)*x
     &     + 64.D0/5.D0*Hr4(1,0,0,0)*x**3 + 128.D0/15.D0*Hr4(1,0,0,0)*
     &    dx**2 - 32.D0*Hr4(1,0,0,1) + 1168.D0/3.D0*Hr4(1,0,0,1)*x - 
     &    752.D0/3.D0*Hr4(1,0,0,1)*x**2 )
      cLqq3 = cLqq3 + cf*ca**2 * ( 264.D0/5.D0*Hr4(1,0,0,1)*x**3 - 376.D
     &    0/3.D0*Hr4(1,0,0,1)*dx + 176.D0/5.D0*Hr4(1,0,0,1)*dx**2 - 176.
     &    D0/3.D0*Hr4(1,0,1,0)*x + 32.D0*Hr4(1,1,0,0) - 160.D0*Hr4(1,1,
     &    0,0)*x + 752.D0/3.D0*Hr4(1,1,0,0)*x**2 - 264.D0/5.D0*Hr4(1,1,
     &    0,0)*x**3 + 376.D0/3.D0*Hr4(1,1,0,0)*dx - 176.D0/5.D0*Hr4(1,1
     &    ,0,0)*dx**2 + 176.D0/3.D0*Hr4(1,1,0,1)*x - 176.D0/3.D0*Hr4(1,
     &    1,1,0)*x + 512.D0*Hr5(-1,-1,-1,0,0)*x + 1024.D0*Hr5(-1,-1,-1,
     &    0,1)*x - 128.D0*Hr5(-1,-1,0,0,0)*x - 512.D0*Hr5(-1,-1,0,0,1)*
     &    x - 256.D0*Hr5(-1,0,-1,0,0)*x - 512.D0*Hr5(-1,0,-1,0,1)*x - 
     &    128.D0*Hr5(-1,0,0,-1,0)*x + 128.D0*Hr5(-1,0,0,0,0)*x + 320.D0
     &    *Hr5(-1,0,0,0,1)*x - 64.D0*Hr5(-1,0,1,0,0)*x + 160.D0*Hr5(0,1
     &    ,0,0,1)*x - 160.D0*Hr5(0,1,1,0,0)*x + 256.D0*Hr5(1,0,-1,0,0)*
     &    x + 512.D0*Hr5(1,0,-1,0,1)*x + 128.D0*Hr5(1,0,0,-1,0)*x - 128.
     &    D0*Hr5(1,0,0,0,0)*x - 160.D0*Hr5(1,0,0,0,1)*x - 96.D0*Hr5(1,0
     &    ,1,0,0)*x + 256.D0*Hr5(1,1,0,-1,0)*x - 128.D0*Hr5(1,1,0,0,0)*
     &    x )
      cLqq3 = cLqq3 + cf*ca**2 * ( 192.D0*Hr5(1,1,0,0,1)*x - 192.D0*
     &    Hr5(1,1,1,0,0)*x )
      cLqq3 = cLqq3 + cf**2*ca * (  - 6712.D0/135.D0 - 595003.D0/270.D0
     &    *x + 63688.D0/75.D0*x**2 + 1432.D0*z5*x + 39632.D0/75.D0*dx
     &     - 1216.D0/15.D0*z3 - 19448.D0/5.D0*z3*x + 17632.D0/15.D0*z3*
     &    x**2 + 25496.D0/15.D0*z3*x**3 - 1472.D0/15.D0*z3*dx - 146288.D
     &    0/225.D0*z2 + 263044.D0/225.D0*z2*x - 24448.D0/75.D0*z2*x**2
     &     - 7272.D0/25.D0*z2*x**3 + 68672.D0/225.D0*z2*dx + 1056.D0*z2
     &    *z3*x - 416.D0*z2**2*x + 3584.D0/5.D0*z2**2*x**2 - 13712.D0/
     &    25.D0*z2**2*x**3 + 3056.D0*Hr1(-1)*z3 + 8456.D0/3.D0*Hr1(-1)*
     &    z3*x - 768.D0*Hr1(-1)*z3*x**3 + 512.D0*Hr1(-1)*z3*dx**2 + 
     &    9568.D0/5.D0*Hr1(-1)*z2 + 113992.D0/45.D0*Hr1(-1)*z2*x - 6208.
     &    D0/15.D0*Hr1(-1)*z2*x**2 - 12296.D0/25.D0*Hr1(-1)*z2*x**3 + 
     &    5552.D0/15.D0*Hr1(-1)*z2*dx + 24112.D0/75.D0*Hr1(-1)*z2*dx**2
     &     - 816.D0/5.D0*Hr1(-1)*z2**2*x - 11192.D0/75.D0*Hr1(0) - 
     &    2757916.D0/675.D0*Hr1(0)*x + 91016.D0/75.D0*Hr1(0)*x**2 - 
     &    24272.D0/75.D0*Hr1(0)*dx - 3088.D0/3.D0*Hr1(0)*z3*x + 896.D0*
     &    Hr1(0)*z3*x**2 )
      cLqq3 = cLqq3 + cf**2*ca * ( 736.D0/5.D0*Hr1(0)*z3*x**3 + 1024.D0/
     &    15.D0*Hr1(0)*z2 - 172904.D0/45.D0*Hr1(0)*z2*x - 6176.D0/5.D0*
     &    Hr1(0)*z2*x**2 + 27184.D0/75.D0*Hr1(0)*z2*x**3 - 12544.D0/15.D
     &    0*Hr1(0)*z2*dx + 96.D0/5.D0*Hr1(0)*z2**2*x + 216376.D0/225.D0
     &    *Hr1(1) - 2012228.D0/675.D0*Hr1(1)*x + 27328.D0/75.D0*Hr1(1)*
     &    x**2 + 99616.D0/225.D0*Hr1(1)*dx + 528.D0*Hr1(1)*z3 - 5944.D0/
     &    3.D0*Hr1(1)*z3*x + 896.D0*Hr1(1)*z3*x**2 - 3104.D0/5.D0*Hr1(1
     &    )*z3*x**3 + 448.D0*Hr1(1)*z3*dx - 6208.D0/15.D0*Hr1(1)*z3*
     &    dx**2 + 9424.D0/15.D0*Hr1(1)*z2 + 1352.D0/5.D0*Hr1(1)*z2*x - 
     &    10528.D0/15.D0*Hr1(1)*z2*x**2 - 9704.D0/75.D0*Hr1(1)*z2*x**3
     &     - 4432.D0/15.D0*Hr1(1)*z2*dx + 24112.D0/225.D0*Hr1(1)*z2*
     &    dx**2 - 976.D0/5.D0*Hr1(1)*z2**2*x - 3168.D0*Hr2(-1,-1)*z3*x
     &     - 3904.D0*Hr2(-1,-1)*z2 - 11168.D0/3.D0*Hr2(-1,-1)*z2*x + 
     &    4896.D0/5.D0*Hr2(-1,-1)*z2*x**3 - 3264.D0/5.D0*Hr2(-1,-1)*z2*
     &    dx**2 + 183184.D0/75.D0*Hr2(-1,0) + 303112.D0/225.D0*Hr2(-1,0
     &    )*x )
      cLqq3 = cLqq3 + cf**2*ca * ( 18832.D0/75.D0*Hr2(-1,0)*x**2 - 7272.
     &    D0/25.D0*Hr2(-1,0)*x**3 - 42464.D0/225.D0*Hr2(-1,0)*dx + 
     &    30352.D0/225.D0*Hr2(-1,0)*dx**2 + 1440.D0*Hr2(-1,0)*z3*x + 
     &    2720.D0*Hr2(-1,0)*z2 + 7984.D0/3.D0*Hr2(-1,0)*z2*x - 3168.D0/
     &    5.D0*Hr2(-1,0)*z2*x**3 + 2112.D0/5.D0*Hr2(-1,0)*z2*dx**2 + 
     &    336.D0*Hr2(0,-1)*z3*x + 576.D0*Hr2(0,-1)*z2 + 1664.D0*Hr2(0,
     &    -1)*z2*x - 4896.D0/5.D0*Hr2(0,-1)*z2*x**3 + 384.D0/5.D0*Hr2(0
     &    ,-1)*z2*dx**2 + 50348.D0/225.D0*Hr2(0,0) - 293392.D0/225.D0*
     &    Hr2(0,0)*x + 69488.D0/75.D0*Hr2(0,0)*x**2 + 7272.D0/25.D0*
     &    Hr2(0,0)*x**3 - 3616.D0/225.D0*Hr2(0,0)*dx - 64.D0*Hr2(0,0)*
     &    z3*x - 1504.D0/3.D0*Hr2(0,0)*z2*x - 896.D0*Hr2(0,0)*z2*x**2
     &     + 6272.D0/5.D0*Hr2(0,0)*z2*x**3 + 146288.D0/225.D0*Hr2(0,1)
     &     + 4452.D0/25.D0*Hr2(0,1)*x + 24448.D0/75.D0*Hr2(0,1)*x**2 - 
     &    111136.D0/225.D0*Hr2(0,1)*dx - 816.D0*Hr2(0,1)*z3*x + 192.D0*
     &    Hr2(0,1)*z2 + 2480.D0/3.D0*Hr2(0,1)*z2*x + 96.D0/5.D0*Hr2(0,1
     &    )*z2*x**3 )
      cLqq3 = cLqq3 + cf**2*ca * ( 128.D0/5.D0*Hr2(0,1)*z2*dx**2 - 3064.
     &    D0/15.D0*Hr2(1,0) + 9692.D0/45.D0*Hr2(1,0)*x + 3824.D0/15.D0*
     &    Hr2(1,0)*x**2 - 128.D0/5.D0*Hr2(1,0)*dx - 1888.D0*Hr2(1,0)*z3
     &    *x + 672.D0*Hr2(1,0)*z2 + 1232.D0/3.D0*Hr2(1,0)*z2*x - 896.D0
     &    *Hr2(1,0)*z2*x**2 + 3104.D0/5.D0*Hr2(1,0)*z2*x**3 - 448.D0*
     &    Hr2(1,0)*z2*dx + 6208.D0/15.D0*Hr2(1,0)*z2*dx**2 - 3064.D0/15.
     &    D0*Hr2(1,1) + 6772.D0/45.D0*Hr2(1,1)*x - 192.D0/5.D0*Hr2(1,1)
     &    *x**2 - 128.D0/5.D0*Hr2(1,1)*dx - 1120.D0*Hr2(1,1)*z3*x + 128.
     &    D0*Hr2(1,1)*z2 + 512.D0/3.D0*Hr2(1,1)*z2*x + 96.D0/5.D0*Hr2(1
     &    ,1)*z2*x**3 + 64.D0/5.D0*Hr2(1,1)*z2*dx**2 + 4032.D0*Hr3(-1,
     &    -1,-1)*z2*x + 18368.D0/15.D0*Hr3(-1,-1,0) - 6544.D0/5.D0*Hr3(
     &    -1,-1,0)*x - 17536.D0/15.D0*Hr3(-1,-1,0)*x**2 - 24592.D0/75.D0
     &    *Hr3(-1,-1,0)*x**3 + 8864.D0/15.D0*Hr3(-1,-1,0)*dx + 48224.D0/
     &    225.D0*Hr3(-1,-1,0)*dx**2 - 2816.D0*Hr3(-1,-1,0)*z2*x - 2240.D
     &    0*Hr3(-1,0,-1)*z2*x - 1376.D0/3.D0*Hr3(-1,0,0) - 6784.D0/9.D0
     &    *Hr3(-1,0,0)*x )
      cLqq3 = cLqq3 + cf**2*ca * ( 576.D0*Hr3(-1,0,0)*x**2 + 7312.D0/75.
     &    D0*Hr3(-1,0,0)*x**3 - 384.D0*Hr3(-1,0,0)*dx - 13664.D0/225.D0
     &    *Hr3(-1,0,0)*dx**2 + 1792.D0*Hr3(-1,0,0)*z2*x - 3904.D0/3.D0*
     &    Hr3(-1,0,1) - 28688.D0/9.D0*Hr3(-1,0,1)*x - 512.D0/3.D0*Hr3(
     &    -1,0,1)*x**2 + 24592.D0/75.D0*Hr3(-1,0,1)*x**3 - 224.D0/3.D0*
     &    Hr3(-1,0,1)*dx - 48224.D0/225.D0*Hr3(-1,0,1)*dx**2 - 64.D0*
     &    Hr3(-1,0,1)*z2*x - 384.D0*Hr3(0,-1,-1)*z2*x + 12448.D0/15.D0*
     &    Hr3(0,-1,0) - 50032.D0/45.D0*Hr3(0,-1,0)*x + 16384.D0/15.D0*
     &    Hr3(0,-1,0)*x**2 + 24592.D0/75.D0*Hr3(0,-1,0)*x**3 - 384.D0/5.
     &    D0*Hr3(0,-1,0)*dx + 768.D0/5.D0*Hr3(0,-1,0)*dx**2 + 224.D0*
     &    Hr3(0,-1,0)*z2*x - 192.D0/5.D0*Hr3(0,0,0) + 12380.D0/9.D0*
     &    Hr3(0,0,0)*x - 576.D0/5.D0*Hr3(0,0,0)*x**2 - 7312.D0/75.D0*
     &    Hr3(0,0,0)*x**3 + 128.D0*Hr3(0,0,0)*dx - 1024.D0/15.D0*Hr3(0,
     &    0,1) + 122872.D0/45.D0*Hr3(0,0,1)*x + 6176.D0/5.D0*Hr3(0,0,1)
     &    *x**2 - 864.D0/25.D0*Hr3(0,0,1)*x**3 + 11392.D0/15.D0*Hr3(0,0
     &    ,1)*dx )
      cLqq3 = cLqq3 + cf**2*ca * (  - 64.D0*Hr3(0,0,1)*z2*x - 64.D0/5.D0
     &    *Hr3(0,1,0) + 8648.D0/15.D0*Hr3(0,1,0)*x - 2336.D0/15.D0*Hr3(
     &    0,1,0)*x**2 - 880.D0/3.D0*Hr3(0,1,0)*x**3 + 128.D0/5.D0*Hr3(0
     &    ,1,0)*dx + 160.D0*Hr3(0,1,0)*z2*x - 64.D0/5.D0*Hr3(0,1,1) + 
     &    9848.D0/15.D0*Hr3(0,1,1)*x - 192.D0/5.D0*Hr3(0,1,1)*x**2 + 
     &    128.D0/5.D0*Hr3(0,1,1)*dx - 192.D0*Hr3(0,1,1)*z2*x + 1472.D0*
     &    Hr3(1,0,-1)*z2*x + 784.D0/15.D0*Hr3(1,0,0) - 27272.D0/45.D0*
     &    Hr3(1,0,0)*x - 2816.D0/5.D0*Hr3(1,0,0)*x**2 - 5632.D0/15.D0*
     &    Hr3(1,0,0)*dx - 1344.D0*Hr3(1,0,0)*z2*x - 16.D0*Hr3(1,0,1) + 
     &    384.D0*Hr3(1,0,1)*x + 352.D0/3.D0*Hr3(1,0,1)*x**2 + 880.D0/3.D
     &    0*Hr3(1,0,1)*x**3 - 192.D0*Hr3(1,0,1)*z2*x + 16.D0*Hr3(1,1,0)
     &     + 528.D0*Hr3(1,1,0)*x - 352.D0/3.D0*Hr3(1,1,0)*x**2 - 880.D0/
     &    3.D0*Hr3(1,1,0)*x**3 - 384.D0*Hr3(1,1,0)*z2*x + 1280.D0/3.D0*
     &    Hr3(1,1,1)*x - 192.D0*Hr3(1,1,1)*z2*x - 256.D0*Hr4(-1,-1,-1,0
     &    ) + 512.D0/3.D0*Hr4(-1,-1,-1,0)*x + 192.D0/5.D0*Hr4(-1,-1,-1,
     &    0)*x**3 )
      cLqq3 = cLqq3 + cf**2*ca * (  - 128.D0/5.D0*Hr4(-1,-1,-1,0)*dx**2
     &     + 2400.D0*Hr4(-1,-1,0,0) + 1008.D0*Hr4(-1,-1,0,0)*x - 576.D0
     &    *Hr4(-1,-1,0,0)*x**3 + 384.D0*Hr4(-1,-1,0,0)*dx**2 + 3776.D0*
     &    Hr4(-1,-1,0,1) + 3808.D0*Hr4(-1,-1,0,1)*x - 960.D0*Hr4(-1,-1,
     &    0,1)*x**3 + 640.D0*Hr4(-1,-1,0,1)*dx**2 + 256.D0*Hr4(-1,0,-1,
     &    0) - 1568.D0/3.D0*Hr4(-1,0,-1,0)*x - 192.D0/5.D0*Hr4(-1,0,-1,
     &    0)*x**3 + 128.D0/5.D0*Hr4(-1,0,-1,0)*dx**2 - 896.D0*Hr4(-1,0,
     &    0,0) - 304.D0*Hr4(-1,0,0,0)*x + 768.D0/5.D0*Hr4(-1,0,0,0)*
     &    x**3 - 512.D0/5.D0*Hr4(-1,0,0,0)*dx**2 - 2208.D0*Hr4(-1,0,0,1
     &    ) - 2064.D0*Hr4(-1,0,0,1)*x + 576.D0*Hr4(-1,0,0,1)*x**3 - 384.
     &    D0*Hr4(-1,0,0,1)*dx**2 - 128.D0*Hr4(-1,0,1,0) - 64.D0*Hr4(-1,
     &    0,1,0)*x + 192.D0/5.D0*Hr4(-1,0,1,0)*x**3 - 128.D0/5.D0*Hr4(
     &    -1,0,1,0)*dx**2 - 128.D0*Hr4(-1,0,1,1) - 64.D0*Hr4(-1,0,1,1)*
     &    x + 192.D0/5.D0*Hr4(-1,0,1,1)*x**3 - 128.D0/5.D0*Hr4(-1,0,1,1
     &    )*dx**2 + 384.D0*Hr4(0,-1,-1,0) - 5056.D0/3.D0*Hr4(0,-1,-1,0)
     &    *x )
      cLqq3 = cLqq3 + cf**2*ca * (  - 192.D0/5.D0*Hr4(0,-1,-1,0)*x**3
     &     + 256.D0/5.D0*Hr4(0,-1,-1,0)*dx**2 - 512.D0*Hr4(0,-1,0,0) - 
     &    1520.D0/3.D0*Hr4(0,-1,0,0)*x + 576.D0*Hr4(0,-1,0,0)*x**3 - 
     &    256.D0/5.D0*Hr4(0,-1,0,0)*dx**2 - 384.D0*Hr4(0,-1,0,1) - 7520.
     &    D0/3.D0*Hr4(0,-1,0,1)*x + 960.D0*Hr4(0,-1,0,1)*x**3 - 256.D0/
     &    5.D0*Hr4(0,-1,0,1)*dx**2 - 128.D0*Hr4(0,0,-1,0) - 736.D0/3.D0
     &    *Hr4(0,0,-1,0)*x + 576.D0/5.D0*Hr4(0,0,-1,0)*x**3 + 1072.D0/3.
     &    D0*Hr4(0,0,0,0)*x - 192.D0*Hr4(0,0,0,0)*x**3 + 256.D0*Hr4(0,0
     &    ,0,1)*x + 896.D0*Hr4(0,0,0,1)*x**2 - 5696.D0/5.D0*Hr4(0,0,0,1
     &    )*x**3 + 64.D0*Hr4(0,0,1,0)*x - 192.D0/5.D0*Hr4(0,0,1,0)*x**3
     &     + 64.D0*Hr4(0,0,1,1)*x - 192.D0/5.D0*Hr4(0,0,1,1)*x**3 + 896.
     &    D0/3.D0*Hr4(0,1,0,0)*x - 896.D0*Hr4(0,1,0,0)*x**2 + 2816.D0/5.
     &    D0*Hr4(0,1,0,0)*x**3 + 16.D0*Hr4(0,1,0,1)*x - 16.D0*Hr4(0,1,1
     &    ,0)*x + 768.D0*Hr4(1,0,-1,0) - 5152.D0/3.D0*Hr4(1,0,-1,0)*x
     &     + 384.D0/5.D0*Hr4(1,0,-1,0)*x**3 + 256.D0/5.D0*Hr4(1,0,-1,0)
     &    *dx**2 )
      cLqq3 = cLqq3 + cf**2*ca * (  - 512.D0*Hr4(1,0,0,0) + 112.D0*Hr4(
     &    1,0,0,0)*x - 192.D0/5.D0*Hr4(1,0,0,0)*x**3 - 128.D0/5.D0*Hr4(
     &    1,0,0,0)*dx**2 - 160.D0*Hr4(1,0,0,1) - 1008.D0*Hr4(1,0,0,1)*x
     &     + 896.D0*Hr4(1,0,0,1)*x**2 - 2816.D0/5.D0*Hr4(1,0,0,1)*x**3
     &     + 448.D0*Hr4(1,0,0,1)*dx - 5632.D0/15.D0*Hr4(1,0,0,1)*dx**2
     &     + 352.D0/3.D0*Hr4(1,0,1,0)*x + 96.D0*Hr4(1,1,0,0) + 2416.D0/
     &    3.D0*Hr4(1,1,0,0)*x - 896.D0*Hr4(1,1,0,0)*x**2 + 2816.D0/5.D0
     &    *Hr4(1,1,0,0)*x**3 - 448.D0*Hr4(1,1,0,0)*dx + 5632.D0/15.D0*
     &    Hr4(1,1,0,0)*dx**2 - 256.D0/3.D0*Hr4(1,1,0,1)*x + 256.D0/3.D0
     &    *Hr4(1,1,1,0)*x + 384.D0*Hr5(-1,-1,-1,-1,0)*x - 2624.D0*Hr5(
     &    -1,-1,-1,0,0)*x - 3840.D0*Hr5(-1,-1,-1,0,1)*x - 384.D0*Hr5(-1
     &    ,-1,0,-1,0)*x + 1024.D0*Hr5(-1,-1,0,0,0)*x + 2240.D0*Hr5(-1,
     &    -1,0,0,1)*x + 128.D0*Hr5(-1,-1,0,1,0)*x + 128.D0*Hr5(-1,-1,0,
     &    1,1)*x - 384.D0*Hr5(-1,0,-1,-1,0)*x + 1472.D0*Hr5(-1,0,-1,0,0
     &    )*x + 2048.D0*Hr5(-1,0,-1,0,1)*x + 576.D0*Hr5(-1,0,0,-1,0)*x
     &     - 576.D0*Hr5(-1,0,0,0,0)*x )
      cLqq3 = cLqq3 + cf**2*ca * (  - 1344.D0*Hr5(-1,0,0,0,1)*x - 64.D0
     &    *Hr5(-1,0,0,1,0)*x - 64.D0*Hr5(-1,0,0,1,1)*x + 256.D0*Hr5(-1,
     &    0,1,0,0)*x - 384.D0*Hr5(0,-1,-1,-1,0)*x + 416.D0*Hr5(0,-1,-1,
     &    0,0)*x + 192.D0*Hr5(0,-1,-1,0,1)*x + 256.D0*Hr5(0,-1,0,-1,0)*
     &    x - 192.D0*Hr5(0,-1,0,0,0)*x - 96.D0*Hr5(0,-1,0,0,1)*x + 128.D
     &    0*Hr5(0,0,-1,-1,0)*x - 32.D0*Hr5(0,0,-1,0,0)*x + 64.D0*Hr5(0,
     &    0,-1,0,1)*x + 32.D0*Hr5(0,0,1,0,0)*x + 192.D0*Hr5(0,1,0,0,0)*
     &    x - 288.D0*Hr5(0,1,0,0,1)*x + 480.D0*Hr5(0,1,1,0,0)*x - 128.D0
     &    *Hr5(1,0,-1,-1,0)*x - 704.D0*Hr5(1,0,-1,0,0)*x - 1536.D0*Hr5(
     &    1,0,-1,0,1)*x - 320.D0*Hr5(1,0,0,-1,0)*x + 576.D0*Hr5(1,0,0,0
     &    ,0)*x + 896.D0*Hr5(1,0,0,0,1)*x + 64.D0*Hr5(1,0,0,1,0)*x + 64.
     &    D0*Hr5(1,0,0,1,1)*x + 192.D0*Hr5(1,0,1,0,0)*x - 768.D0*Hr5(1,
     &    1,0,-1,0)*x + 640.D0*Hr5(1,1,0,0,0)*x - 192.D0*Hr5(1,1,0,0,1)
     &    *x + 320.D0*Hr5(1,1,1,0,0)*x )
      cLqq3 = cLqq3 + cf**3 * ( 22576.D0/225.D0 + 98921.D0/150.D0*x - 
     &    7216.D0/25.D0*x**2 - 1968.D0*z5*x - 33376.D0/225.D0*dx + 1952.
     &    D0/15.D0*z3 + 71408.D0/15.D0*z3*x - 3968.D0/5.D0*z3*x**2 - 
     &    6304.D0/5.D0*z3*x**3 + 2624.D0/15.D0*z3*dx + 39632.D0/75.D0*
     &    z2 + 273332.D0/225.D0*z2*x + 6112.D0/25.D0*z2*x**2 - 5392.D0/
     &    25.D0*z2*x**3 + 1472.D0/75.D0*z2*dx - 960.D0*z2*z3*x + 1824.D0
     &    /5.D0*z2**2*x - 1280.D0/3.D0*z2**2*x**2 + 14496.D0/25.D0*
     &    z2**2*x**3 - 3040.D0*Hr1(-1)*z3 - 3504.D0*Hr1(-1)*z3*x + 768.D
     &    0*Hr1(-1)*z3*x**3 - 512.D0*Hr1(-1)*z3*dx**2 - 44288.D0/15.D0*
     &    Hr1(-1)*z2 - 17456.D0/5.D0*Hr1(-1)*z2*x + 2272.D0/5.D0*Hr1(-1
     &    )*z2*x**2 + 18912.D0/25.D0*Hr1(-1)*z2*x**3 - 5744.D0/15.D0*
     &    Hr1(-1)*z2*dx - 12288.D0/25.D0*Hr1(-1)*z2*dx**2 + 1888.D0/5.D0
     &    *Hr1(-1)*z2**2*x + 7208.D0/45.D0*Hr1(0) + 161464.D0/75.D0*
     &    Hr1(0)*x - 15248.D0/25.D0*Hr1(0)*x**2 + 25696.D0/225.D0*Hr1(0
     &    )*dx + 4336.D0/3.D0*Hr1(0)*z3*x - 1600.D0/3.D0*Hr1(0)*z3*x**2
     &     - 1312.D0/5.D0*Hr1(0)*z3*x**3 )
      cLqq3 = cLqq3 + cf**3 * ( 1504.D0/15.D0*Hr1(0)*z2 + 65776.D0/15.D0
     &    *Hr1(0)*z2*x + 4064.D0/5.D0*Hr1(0)*z2*x**2 - 25216.D0/25.D0*
     &    Hr1(0)*z2*x**3 + 12608.D0/15.D0*Hr1(0)*z2*dx - 192.D0/5.D0*
     &    Hr1(0)*z2**2*x - 85864.D0/75.D0*Hr1(1) + 146464.D0/75.D0*Hr1(
     &    1)*x - 8032.D0/25.D0*Hr1(1)*x**2 - 5568.D0/25.D0*Hr1(1)*dx - 
     &    416.D0*Hr1(1)*z3 + 5392.D0/3.D0*Hr1(1)*z3*x - 1600.D0/3.D0*
     &    Hr1(1)*z3*x**2 + 2528.D0/5.D0*Hr1(1)*z3*x**3 - 800.D0/3.D0*
     &    Hr1(1)*z3*dx + 5056.D0/15.D0*Hr1(1)*z3*dx**2 - 4256.D0/5.D0*
     &    Hr1(1)*z2 + 2576.D0/5.D0*Hr1(1)*z2*x + 2592.D0/5.D0*Hr1(1)*z2
     &    *x**2 - 6304.D0/25.D0*Hr1(1)*z2*x**3 + 1328.D0/5.D0*Hr1(1)*z2
     &    *dx - 4096.D0/25.D0*Hr1(1)*z2*dx**2 - 864.D0/5.D0*Hr1(1)*
     &    z2**2*x + 3264.D0*Hr2(-1,-1)*z3*x + 3712.D0*Hr2(-1,-1)*z2 + 
     &    13120.D0/3.D0*Hr2(-1,-1)*z2*x - 4672.D0/5.D0*Hr2(-1,-1)*z2*
     &    x**3 + 9344.D0/15.D0*Hr2(-1,-1)*z2*dx**2 - 21568.D0/75.D0*
     &    Hr2(-1,0) + 50576.D0/225.D0*Hr2(-1,0)*x - 11328.D0/25.D0*Hr2(
     &    -1,0)*x**2 )
      cLqq3 = cLqq3 + cf**3 * (  - 5392.D0/25.D0*Hr2(-1,0)*x**3 + 25856.
     &    D0/75.D0*Hr2(-1,0)*dx + 51872.D0/225.D0*Hr2(-1,0)*dx**2 - 
     &    1344.D0*Hr2(-1,0)*z3*x - 2880.D0*Hr2(-1,0)*z2 - 8992.D0/3.D0*
     &    Hr2(-1,0)*z2*x + 704.D0*Hr2(-1,0)*z2*x**3 - 1408.D0/3.D0*Hr2(
     &    -1,0)*z2*dx**2 - 672.D0*Hr2(0,-1)*z3*x - 1152.D0*Hr2(0,-1)*z2
     &     - 5824.D0/3.D0*Hr2(0,-1)*z2*x + 4672.D0/5.D0*Hr2(0,-1)*z2*
     &    x**3 - 768.D0/5.D0*Hr2(0,-1)*z2*dx**2 - 9632.D0/75.D0*Hr2(0,0
     &    ) - 267356.D0/225.D0*Hr2(0,0)*x - 7392.D0/25.D0*Hr2(0,0)*x**2
     &     + 5392.D0/25.D0*Hr2(0,0)*x**3 - 23296.D0/75.D0*Hr2(0,0)*dx
     &     + 128.D0*Hr2(0,0)*z3*x + 1648.D0/3.D0*Hr2(0,0)*z2*x + 1600.D0
     &    /3.D0*Hr2(0,0)*z2*x**2 - 6304.D0/5.D0*Hr2(0,0)*z2*x**3 - 
     &    39632.D0/75.D0*Hr2(0,1) - 74252.D0/75.D0*Hr2(0,1)*x - 6112.D0/
     &    25.D0*Hr2(0,1)*x**2 + 8128.D0/25.D0*Hr2(0,1)*dx + 992.D0*Hr2(
     &    0,1)*z3*x - 384.D0*Hr2(0,1)*z2 - 544.D0*Hr2(0,1)*z2*x - 192.D0
     &    /5.D0*Hr2(0,1)*z2*x**3 - 256.D0/5.D0*Hr2(0,1)*z2*dx**2 + 896.D
     &    0/5.D0*Hr2(1,0) )
      cLqq3 = cLqq3 + cf**3 * (  - 1916.D0/5.D0*Hr2(1,0)*x + 384.D0/5.D0
     &    *Hr2(1,0)*x**2 + 256.D0/5.D0*Hr2(1,0)*dx + 1600.D0*Hr2(1,0)*
     &    z3*x - 960.D0*Hr2(1,0)*z2 + 160.D0*Hr2(1,0)*z2*x + 1600.D0/3.D
     &    0*Hr2(1,0)*z2*x**2 - 2784.D0/5.D0*Hr2(1,0)*z2*x**3 + 800.D0/3.
     &    D0*Hr2(1,0)*z2*dx - 1856.D0/5.D0*Hr2(1,0)*z2*dx**2 + 736.D0/5.
     &    D0*Hr2(1,1) - 1716.D0/5.D0*Hr2(1,1)*x + 384.D0/5.D0*Hr2(1,1)*
     &    x**2 + 256.D0/5.D0*Hr2(1,1)*dx + 960.D0*Hr2(1,1)*z3*x - 256.D0
     &    *Hr2(1,1)*z2 + 320.D0*Hr2(1,1)*z2*x - 192.D0/5.D0*Hr2(1,1)*z2
     &    *x**3 - 128.D0/5.D0*Hr2(1,1)*z2*dx**2 - 3968.D0*Hr3(-1,-1,-1)
     &    *z2*x - 9472.D0/5.D0*Hr3(-1,-1,0) - 1312.D0/5.D0*Hr3(-1,-1,0)
     &    *x + 5184.D0/5.D0*Hr3(-1,-1,0)*x**2 + 12608.D0/25.D0*Hr3(-1,
     &    -1,0)*x**3 - 2656.D0/5.D0*Hr3(-1,-1,0)*dx - 8192.D0/25.D0*
     &    Hr3(-1,-1,0)*dx**2 + 3072.D0*Hr3(-1,-1,0)*z2*x + 2432.D0*Hr3(
     &    -1,0,-1)*z2*x + 6656.D0/3.D0*Hr3(-1,0,0) + 7136.D0/3.D0*Hr3(
     &    -1,0,0)*x - 640.D0*Hr3(-1,0,0)*x**2 - 15168.D0/25.D0*Hr3(-1,0
     &    ,0)*x**3 )
      cLqq3 = cLqq3 + cf**3 * ( 1280.D0/3.D0*Hr3(-1,0,0)*dx + 29696.D0/
     &    75.D0*Hr3(-1,0,0)*dx**2 - 1792.D0*Hr3(-1,0,0)*z2*x + 6016.D0/
     &    3.D0*Hr3(-1,0,1) + 3360.D0*Hr3(-1,0,1)*x + 64.D0*Hr3(-1,0,1)*
     &    x**2 - 12608.D0/25.D0*Hr3(-1,0,1)*x**3 + 352.D0/3.D0*Hr3(-1,0
     &    ,1)*dx + 8192.D0/25.D0*Hr3(-1,0,1)*dx**2 + 128.D0*Hr3(-1,0,1)
     &    *z2*x + 768.D0*Hr3(0,-1,-1)*z2*x + 3712.D0/15.D0*Hr3(0,-1,0)
     &     + 1344.D0*Hr3(0,-1,0)*x - 4928.D0/5.D0*Hr3(0,-1,0)*x**2 - 
     &    12608.D0/25.D0*Hr3(0,-1,0)*x**3 + 256.D0/3.D0*Hr3(0,-1,0)*dx
     &     + 1024.D0/15.D0*Hr3(0,-1,0)*dx**2 - 448.D0*Hr3(0,-1,0)*z2*x
     &     + 184.D0/5.D0*Hr3(0,0,0) - 32632.D0/15.D0*Hr3(0,0,0)*x + 
     &    1152.D0/5.D0*Hr3(0,0,0)*x**2 + 15168.D0/25.D0*Hr3(0,0,0)*x**3
     &     - 2816.D0/15.D0*Hr3(0,0,0)*dx - 1504.D0/15.D0*Hr3(0,0,1) - 
     &    45616.D0/15.D0*Hr3(0,0,1)*x - 4064.D0/5.D0*Hr3(0,0,1)*x**2 + 
     &    12608.D0/25.D0*Hr3(0,0,1)*x**3 - 3776.D0/5.D0*Hr3(0,0,1)*dx
     &     + 128.D0*Hr3(0,0,1)*z2*x - 272.D0/5.D0*Hr3(0,1,0) - 1792.D0/
     &    5.D0*Hr3(0,1,0)*x )
      cLqq3 = cLqq3 + cf**3 * ( 384.D0/5.D0*Hr3(0,1,0)*x**2 - 256.D0/5.D
     &    0*Hr3(0,1,0)*dx + 320.D0*Hr3(0,1,0)*z2*x - 352.D0/5.D0*Hr3(0,
     &    1,1) - 2512.D0/5.D0*Hr3(0,1,1)*x + 384.D0/5.D0*Hr3(0,1,1)*
     &    x**2 - 256.D0/5.D0*Hr3(0,1,1)*dx + 384.D0*Hr3(0,1,1)*z2*x - 
     &    896.D0*Hr3(1,0,-1)*z2*x - 272.D0/5.D0*Hr3(1,0,0) + 5656.D0/15.
     &    D0*Hr3(1,0,0)*x + 2464.D0/5.D0*Hr3(1,0,0)*x**2 + 4928.D0/15.D0
     &    *Hr3(1,0,0)*dx + 1536.D0*Hr3(1,0,0)*z2*x - 96.D0*Hr3(1,0,1)
     &     - 384.D0*Hr3(1,0,1)*x + 384.D0*Hr3(1,0,1)*z2*x - 128.D0*Hr3(
     &    1,1,0) - 304.D0*Hr3(1,1,0)*x + 1024.D0*Hr3(1,1,0)*z2*x - 96.D0
     &    *Hr3(1,1,1) - 336.D0*Hr3(1,1,1)*x + 384.D0*Hr3(1,1,1)*z2*x + 
     &    512.D0*Hr4(-1,-1,-1,0) + 1024.D0*Hr4(-1,-1,-1,0)*x - 384.D0/5.
     &    D0*Hr4(-1,-1,-1,0)*x**3 + 256.D0/5.D0*Hr4(-1,-1,-1,0)*dx**2
     &     - 2752.D0*Hr4(-1,-1,0,0) - 8096.D0/3.D0*Hr4(-1,-1,0,0)*x + 
     &    640.D0*Hr4(-1,-1,0,0)*x**3 - 1280.D0/3.D0*Hr4(-1,-1,0,0)*
     &    dx**2 - 3456.D0*Hr4(-1,-1,0,1) - 11584.D0/3.D0*Hr4(-1,-1,0,1)
     &    *x )
      cLqq3 = cLqq3 + cf**3 * ( 896.D0*Hr4(-1,-1,0,1)*x**3 - 1792.D0/3.D
     &    0*Hr4(-1,-1,0,1)*dx**2 - 512.D0*Hr4(-1,0,-1,0) - 576.D0*Hr4(
     &    -1,0,-1,0)*x + 384.D0/5.D0*Hr4(-1,0,-1,0)*x**3 - 256.D0/5.D0*
     &    Hr4(-1,0,-1,0)*dx**2 + 1280.D0*Hr4(-1,0,0,0) + 3296.D0/3.D0*
     &    Hr4(-1,0,0,0)*x - 256.D0*Hr4(-1,0,0,0)*x**3 + 512.D0/3.D0*
     &    Hr4(-1,0,0,0)*dx**2 + 2368.D0*Hr4(-1,0,0,1) + 6752.D0/3.D0*
     &    Hr4(-1,0,0,1)*x - 640.D0*Hr4(-1,0,0,1)*x**3 + 1280.D0/3.D0*
     &    Hr4(-1,0,0,1)*dx**2 + 256.D0*Hr4(-1,0,1,0) + 128.D0*Hr4(-1,0,
     &    1,0)*x - 384.D0/5.D0*Hr4(-1,0,1,0)*x**3 + 256.D0/5.D0*Hr4(-1,
     &    0,1,0)*dx**2 + 256.D0*Hr4(-1,0,1,1) + 128.D0*Hr4(-1,0,1,1)*x
     &     - 384.D0/5.D0*Hr4(-1,0,1,1)*x**3 + 256.D0/5.D0*Hr4(-1,0,1,1)
     &    *dx**2 - 768.D0*Hr4(0,-1,-1,0) + 512.D0*Hr4(0,-1,-1,0)*x + 
     &    384.D0/5.D0*Hr4(0,-1,-1,0)*x**3 - 512.D0/5.D0*Hr4(0,-1,-1,0)*
     &    dx**2 + 1024.D0*Hr4(0,-1,0,0) + 3104.D0/3.D0*Hr4(0,-1,0,0)*x
     &     - 640.D0*Hr4(0,-1,0,0)*x**3 + 512.D0/5.D0*Hr4(0,-1,0,0)*
     &    dx**2 )
      cLqq3 = cLqq3 + cf**3 * ( 768.D0*Hr4(0,-1,0,1) + 6592.D0/3.D0*
     &    Hr4(0,-1,0,1)*x - 896.D0*Hr4(0,-1,0,1)*x**3 + 512.D0/5.D0*
     &    Hr4(0,-1,0,1)*dx**2 + 256.D0*Hr4(0,0,-1,0) + 640.D0/3.D0*Hr4(
     &    0,0,-1,0)*x - 128.D0*Hr4(0,0,-1,0)*x**3 - 1048.D0/3.D0*Hr4(0,
     &    0,0,0)*x + 1408.D0/5.D0*Hr4(0,0,0,0)*x**3 - 336.D0*Hr4(0,0,0,
     &    1)*x - 1600.D0/3.D0*Hr4(0,0,0,1)*x**2 + 5664.D0/5.D0*Hr4(0,0,
     &    0,1)*x**3 + 112.D0*Hr4(0,0,1,0)*x + 384.D0/5.D0*Hr4(0,0,1,0)*
     &    x**3 + 192.D0*Hr4(0,0,1,1)*x + 384.D0/5.D0*Hr4(0,0,1,1)*x**3
     &     - 944.D0/3.D0*Hr4(0,1,0,0)*x + 1600.D0/3.D0*Hr4(0,1,0,0)*
     &    x**2 - 2464.D0/5.D0*Hr4(0,1,0,0)*x**3 + 288.D0*Hr4(0,1,0,1)*x
     &     + 320.D0*Hr4(0,1,1,0)*x + 288.D0*Hr4(0,1,1,1)*x - 512.D0*
     &    Hr4(1,0,-1,0) + 2752.D0/3.D0*Hr4(1,0,-1,0)*x - 256.D0/5.D0*
     &    Hr4(1,0,-1,0)*x**3 - 512.D0/15.D0*Hr4(1,0,-1,0)*dx**2 + 512.D0
     &    *Hr4(1,0,0,0) - 1664.D0/3.D0*Hr4(1,0,0,0)*x + 128.D0/5.D0*
     &    Hr4(1,0,0,0)*x**3 + 256.D0/15.D0*Hr4(1,0,0,0)*dx**2 + 448.D0*
     &    Hr4(1,0,0,1) )
      cLqq3 = cLqq3 + cf**3 * ( 1760.D0/3.D0*Hr4(1,0,0,1)*x - 1600.D0/3.
     &    D0*Hr4(1,0,0,1)*x**2 + 2464.D0/5.D0*Hr4(1,0,0,1)*x**3 - 800.D0
     &    /3.D0*Hr4(1,0,0,1)*dx + 4928.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 
     &    192.D0*Hr4(1,0,1,0)*x + 224.D0*Hr4(1,0,1,1)*x - 320.D0*Hr4(1,
     &    1,0,0) - 1856.D0/3.D0*Hr4(1,1,0,0)*x + 1600.D0/3.D0*Hr4(1,1,0
     &    ,0)*x**2 - 2464.D0/5.D0*Hr4(1,1,0,0)*x**3 + 800.D0/3.D0*Hr4(1
     &    ,1,0,0)*dx - 4928.D0/15.D0*Hr4(1,1,0,0)*dx**2 + 192.D0*Hr4(1,
     &    1,0,1)*x + 256.D0*Hr4(1,1,1,0)*x + 192.D0*Hr4(1,1,1,1)*x - 
     &    768.D0*Hr5(-1,-1,-1,-1,0)*x + 3200.D0*Hr5(-1,-1,-1,0,0)*x + 
     &    3584.D0*Hr5(-1,-1,-1,0,1)*x + 768.D0*Hr5(-1,-1,0,-1,0)*x - 
     &    1536.D0*Hr5(-1,-1,0,0,0)*x - 2432.D0*Hr5(-1,-1,0,0,1)*x - 256.
     &    D0*Hr5(-1,-1,0,1,0)*x - 256.D0*Hr5(-1,-1,0,1,1)*x + 768.D0*
     &    Hr5(-1,0,-1,-1,0)*x - 1920.D0*Hr5(-1,0,-1,0,0)*x - 2048.D0*
     &    Hr5(-1,0,-1,0,1)*x - 640.D0*Hr5(-1,0,0,-1,0)*x + 640.D0*Hr5(
     &    -1,0,0,0,0)*x + 1408.D0*Hr5(-1,0,0,0,1)*x + 128.D0*Hr5(-1,0,0
     &    ,1,0)*x )
      cLqq3 = cLqq3 + cf**3 * ( 128.D0*Hr5(-1,0,0,1,1)*x - 256.D0*Hr5(
     &    -1,0,1,0,0)*x + 768.D0*Hr5(0,-1,-1,-1,0)*x - 832.D0*Hr5(0,-1,
     &    -1,0,0)*x - 384.D0*Hr5(0,-1,-1,0,1)*x - 512.D0*Hr5(0,-1,0,-1,
     &    0)*x + 384.D0*Hr5(0,-1,0,0,0)*x + 192.D0*Hr5(0,-1,0,0,1)*x - 
     &    256.D0*Hr5(0,0,-1,-1,0)*x + 64.D0*Hr5(0,0,-1,0,0)*x - 128.D0*
     &    Hr5(0,0,-1,0,1)*x - 64.D0*Hr5(0,0,1,0,0)*x - 384.D0*Hr5(0,1,0
     &    ,0,0)*x - 64.D0*Hr5(0,1,0,0,1)*x - 320.D0*Hr5(0,1,1,0,0)*x + 
     &    256.D0*Hr5(1,0,-1,-1,0)*x + 384.D0*Hr5(1,0,-1,0,0)*x + 1024.D0
     &    *Hr5(1,0,-1,0,1)*x + 128.D0*Hr5(1,0,0,-1,0)*x - 640.D0*Hr5(1,
     &    0,0,0,0)*x - 1152.D0*Hr5(1,0,0,0,1)*x - 128.D0*Hr5(1,0,0,1,0)
     &    *x - 128.D0*Hr5(1,0,0,1,1)*x + 512.D0*Hr5(1,1,0,-1,0)*x - 768.
     &    D0*Hr5(1,1,0,0,0)*x - 384.D0*Hr5(1,1,0,0,1)*x + 128.D0*Hr5(1,
     &    1,1,0,0)*x )
      cLqq3 = cLqq3 + nf*cf*ca * ( 104264.D0/675.D0 - 1004792.D0/2025.D0
     &    *x + 1168.D0/25.D0*x**2 + 6688.D0/225.D0*dx + 880.D0/9.D0*z3*
     &    x - 160.D0/3.D0*z3*x**2 + 64.D0*z3*x**3 - 64.D0/3.D0*z3*dx + 
     &    32.D0/5.D0*z2 + 3472.D0/15.D0*z2*x + 256.D0/5.D0*z2*x**2 - 
     &    848.D0/25.D0*z2*x**3 - 64.D0/15.D0*z2*dx + 32.D0/3.D0*z2**2*x
     &     - 256.D0/15.D0*z2**2*x**2 + 128.D0/5.D0*z2**2*x**3 - 128.D0/
     &    3.D0*Hr1(-1)*z3*x - 64.D0*Hr1(-1)*z2 - 704.D0/9.D0*Hr1(-1)*z2
     &    *x + 64.D0/3.D0*Hr1(-1)*z2*x**2 + 96.D0/5.D0*Hr1(-1)*z2*x**3
     &     - 32.D0/3.D0*Hr1(-1)*z2*dx - 64.D0/5.D0*Hr1(-1)*z2*dx**2 + 
     &    1216.D0/25.D0*Hr1(0) - 335248.D0/675.D0*Hr1(0)*x - 112.D0/25.D
     &    0*Hr1(0)*x**2 - 2848.D0/225.D0*Hr1(0)*dx + 160.D0/3.D0*Hr1(0)
     &    *z3*x - 64.D0/3.D0*Hr1(0)*z3*x**2 + 32.D0*Hr1(0)*z3*x**3 + 64.
     &    D0/3.D0*Hr1(0)*z2*x - 32.D0/3.D0*Hr1(0)*z2*x**2 - 288.D0/5.D0
     &    *Hr1(0)*z2*x**3 + 64.D0/3.D0*Hr1(0)*z2*dx + 4064.D0/45.D0*
     &    Hr1(1) - 35752.D0/135.D0*Hr1(1)*x - 256.D0/5.D0*Hr1(1)*x**2
     &     - 64.D0/5.D0*Hr1(1)*dx )
      cLqq3 = cLqq3 + nf*cf*ca * ( 128.D0/3.D0*Hr1(1)*z3*x - 64.D0/3.D0
     &    *Hr1(1)*z3*x**2 + 32.D0*Hr1(1)*z3*x**3 - 32.D0/3.D0*Hr1(1)*z3
     &    *dx + 64.D0/3.D0*Hr1(1)*z3*dx**2 - 64.D0/3.D0*Hr1(1)*z2 + 800.
     &    D0/9.D0*Hr1(1)*z2*x - 64.D0/3.D0*Hr1(1)*z2*x**2 - 192.D0/5.D0
     &    *Hr1(1)*z2*x**3 - 32.D0/3.D0*Hr1(1)*z2*dx - 64.D0/15.D0*Hr1(1
     &    )*z2*dx**2 + 128.D0/3.D0*Hr2(-1,-1)*z2*x + 8288.D0/45.D0*Hr2(
     &    -1,0) + 6608.D0/45.D0*Hr2(-1,0)*x - 64.D0/5.D0*Hr2(-1,0)*x**2
     &     - 848.D0/25.D0*Hr2(-1,0)*x**3 + 128.D0/15.D0*Hr2(-1,0)*dx + 
     &    4768.D0/225.D0*Hr2(-1,0)*dx**2 - 64.D0/3.D0*Hr2(-1,0)*z2*x + 
     &    32.D0/15.D0*Hr2(0,0) - 13184.D0/45.D0*Hr2(0,0)*x + 32.D0/5.D0
     &    *Hr2(0,0)*x**2 + 848.D0/25.D0*Hr2(0,0)*x**3 - 128.D0/5.D0*
     &    Hr2(0,0)*dx - 32.D0/3.D0*Hr2(0,0)*z2*x + 64.D0/3.D0*Hr2(0,0)*
     &    z2*x**2 - 32.D0*Hr2(0,0)*z2*x**3 - 32.D0/5.D0*Hr2(0,1) - 3808.
     &    D0/45.D0*Hr2(0,1)*x - 256.D0/5.D0*Hr2(0,1)*x**2 + 64.D0/5.D0*
     &    Hr2(0,1)*dx + 128.D0/3.D0*Hr2(0,1)*z2*x - 640.D0/9.D0*Hr2(1,0
     &    )*x )
      cLqq3 = cLqq3 + nf*cf*ca * ( 32.D0*Hr2(1,0)*x**2 + 64.D0*Hr2(1,0)
     &    *z2*x + 64.D0/3.D0*Hr2(1,0)*z2*x**2 - 32.D0*Hr2(1,0)*z2*x**3
     &     + 32.D0/3.D0*Hr2(1,0)*z2*dx - 64.D0/3.D0*Hr2(1,0)*z2*dx**2
     &     - 640.D0/9.D0*Hr2(1,1)*x + 160.D0/3.D0*Hr2(1,1)*z2*x - 128.D0
     &    /3.D0*Hr3(-1,-1,0) - 1408.D0/9.D0*Hr3(-1,-1,0)*x - 128.D0/3.D0
     &    *Hr3(-1,-1,0)*x**2 + 64.D0/5.D0*Hr3(-1,-1,0)*x**3 + 64.D0/3.D0
     &    *Hr3(-1,-1,0)*dx - 128.D0/15.D0*Hr3(-1,-1,0)*dx**2 + 128.D0*
     &    Hr3(-1,0,0) + 1088.D0/9.D0*Hr3(-1,0,0)*x - 192.D0/5.D0*Hr3(-1
     &    ,0,0)*x**3 + 128.D0/5.D0*Hr3(-1,0,0)*dx**2 + 128.D0/3.D0*Hr3(
     &    -1,0,1) - 128.D0/3.D0*Hr3(-1,0,1)*x**2 - 64.D0/5.D0*Hr3(-1,0,
     &    1)*x**3 + 64.D0/3.D0*Hr3(-1,0,1)*dx + 128.D0/15.D0*Hr3(-1,0,1
     &    )*dx**2 + 256.D0/3.D0*Hr3(0,-1,0) + 32.D0/3.D0*Hr3(0,-1,0)*x
     &     + 128.D0/3.D0*Hr3(0,-1,0)*x**2 - 64.D0/5.D0*Hr3(0,-1,0)*x**3
     &     + 256.D0/15.D0*Hr3(0,-1,0)*dx**2 - 160.D0/3.D0*Hr3(0,0,0)*x
     &     + 192.D0/5.D0*Hr3(0,0,0)*x**3 - 32.D0/3.D0*Hr3(0,0,1)*x + 32.
     &    D0/3.D0*Hr3(0,0,1)*x**2 )
      cLqq3 = cLqq3 + nf*cf*ca * ( 224.D0/5.D0*Hr3(0,0,1)*x**3 - 64.D0/
     &    3.D0*Hr3(0,0,1)*dx - 32.D0*Hr3(0,1,0)*x**3 - 608.D0/9.D0*Hr3(
     &    1,0,0)*x + 32.D0*Hr3(1,0,0)*x**2 + 64.D0/3.D0*Hr3(1,0,0)*dx
     &     - 32.D0/3.D0*Hr3(1,0,1)*x + 32.D0*Hr3(1,0,1)*x**3 + 32.D0/3.D
     &    0*Hr3(1,1,0)*x - 32.D0*Hr3(1,1,0)*x**3 + 256.D0/3.D0*Hr4(-1,
     &    -1,-1,0)*x - 128.D0*Hr4(-1,-1,0,0)*x - 256.D0/3.D0*Hr4(-1,0,
     &    -1,0)*x + 64.D0*Hr4(-1,0,0,0)*x - 256.D0/3.D0*Hr4(0,-1,-1,0)*
     &    x + 64.D0/3.D0*Hr4(0,-1,0,0)*x - 128.D0/3.D0*Hr4(0,-1,0,1)*x
     &     + 32.D0/3.D0*Hr4(0,0,0,1)*x - 64.D0/3.D0*Hr4(0,0,0,1)*x**2
     &     + 32.D0*Hr4(0,0,0,1)*x**3 - 32.D0*Hr4(0,1,0,0)*x + 64.D0/3.D0
     &    *Hr4(0,1,0,0)*x**2 - 32.D0*Hr4(0,1,0,0)*x**3 - 128.D0/3.D0*
     &    Hr4(1,0,-1,0)*x - 64.D0*Hr4(1,0,0,0)*x - 128.D0/3.D0*Hr4(1,0,
     &    0,1)*x - 64.D0/3.D0*Hr4(1,0,0,1)*x**2 + 32.D0*Hr4(1,0,0,1)*
     &    x**3 - 32.D0/3.D0*Hr4(1,0,0,1)*dx + 64.D0/3.D0*Hr4(1,0,0,1)*
     &    dx**2 + 32.D0/3.D0*Hr4(1,0,1,0)*x - 32.D0/3.D0*Hr4(1,1,0,0)*x
     &     + 64.D0/3.D0*Hr4(1,1,0,0)*x**2 )
      cLqq3 = cLqq3 + nf*cf*ca * (  - 32.D0*Hr4(1,1,0,0)*x**3 + 32.D0/3.
     &    D0*Hr4(1,1,0,0)*dx - 64.D0/3.D0*Hr4(1,1,0,0)*dx**2 - 32.D0/3.D
     &    0*Hr4(1,1,0,1)*x + 32.D0/3.D0*Hr4(1,1,1,0)*x )
      cLqq3 = cLqq3 + nf*cf**2 * (  - 17128.D0/675.D0 + 173653.D0/675.D0
     &    *x - 2336.D0/25.D0*x**2 - 13376.D0/225.D0*dx - 1280.D0/9.D0*
     &    z3*x - 64.D0/3.D0*z3*x**2 - 96.D0*z3*x**3 - 224.D0/5.D0*z2 - 
     &    11992.D0/45.D0*z2*x - 416.D0/15.D0*z2*x**2 + 1696.D0/25.D0*z2
     &    *x**3 - 512.D0/15.D0*z2*dx - 64.D0/15.D0*z2**2*x + 256.D0/3.D0
     &    *Hr1(-1)*z3*x + 128.D0*Hr1(-1)*z2 + 1408.D0/9.D0*Hr1(-1)*z2*x
     &     - 128.D0/3.D0*Hr1(-1)*z2*x**2 - 192.D0/5.D0*Hr1(-1)*z2*x**3
     &     + 64.D0/3.D0*Hr1(-1)*z2*dx + 128.D0/5.D0*Hr1(-1)*z2*dx**2 + 
     &    3712.D0/225.D0*Hr1(0) + 245896.D0/675.D0*Hr1(0)*x - 4928.D0/
     &    75.D0*Hr1(0)*x**2 + 5696.D0/225.D0*Hr1(0)*dx - 256.D0/3.D0*
     &    Hr1(0)*z3*x + 48.D0*Hr1(0)*z2*x + 320.D0/3.D0*Hr1(0)*z2*x**2
     &     + 1568.D0/15.D0*Hr1(0)*z2*x**3 - 1168.D0/45.D0*Hr1(1) + 
     &    25744.D0/135.D0*Hr1(1)*x + 416.D0/15.D0*Hr1(1)*x**2 - 256.D0/
     &    15.D0*Hr1(1)*dx - 64.D0*Hr1(1)*z3*x + 128.D0/3.D0*Hr1(1)*z2
     &     - 1120.D0/9.D0*Hr1(1)*z2*x + 64.D0*Hr1(1)*z2*x**2 + 992.D0/
     &    15.D0*Hr1(1)*z2*x**3 )
      cLqq3 = cLqq3 + nf*cf**2 * ( 64.D0/3.D0*Hr1(1)*z2*dx + 128.D0/15.D
     &    0*Hr1(1)*z2*dx**2 - 256.D0/3.D0*Hr2(-1,-1)*z2*x - 16576.D0/45.
     &    D0*Hr2(-1,0) - 13216.D0/45.D0*Hr2(-1,0)*x + 128.D0/5.D0*Hr2(
     &    -1,0)*x**2 + 1696.D0/25.D0*Hr2(-1,0)*x**3 - 256.D0/15.D0*Hr2(
     &    -1,0)*dx - 9536.D0/225.D0*Hr2(-1,0)*dx**2 + 128.D0/3.D0*Hr2(
     &    -1,0)*z2*x - 8.D0/5.D0*Hr2(0,0) + 14608.D0/45.D0*Hr2(0,0)*x
     &     - 384.D0/5.D0*Hr2(0,0)*x**2 - 1696.D0/25.D0*Hr2(0,0)*x**3 + 
     &    256.D0/5.D0*Hr2(0,0)*dx + 224.D0/5.D0*Hr2(0,1) - 136.D0/5.D0*
     &    Hr2(0,1)*x + 416.D0/15.D0*Hr2(0,1)*x**2 + 256.D0/15.D0*Hr2(0,
     &    1)*dx - 256.D0/3.D0*Hr2(0,1)*z2*x + 80.D0/3.D0*Hr2(1,0) - 184.
     &    D0/9.D0*Hr2(1,0)*x - 160.D0/3.D0*Hr2(1,0)*x**2 - 448.D0/3.D0*
     &    Hr2(1,0)*z2*x + 80.D0/3.D0*Hr2(1,1) - 56.D0/9.D0*Hr2(1,1)*x
     &     - 320.D0/3.D0*Hr2(1,1)*z2*x + 256.D0/3.D0*Hr3(-1,-1,0) + 
     &    2816.D0/9.D0*Hr3(-1,-1,0)*x + 256.D0/3.D0*Hr3(-1,-1,0)*x**2
     &     - 128.D0/5.D0*Hr3(-1,-1,0)*x**3 - 128.D0/3.D0*Hr3(-1,-1,0)*
     &    dx )
      cLqq3 = cLqq3 + nf*cf**2 * ( 256.D0/15.D0*Hr3(-1,-1,0)*dx**2 - 
     &    256.D0*Hr3(-1,0,0) - 2176.D0/9.D0*Hr3(-1,0,0)*x + 384.D0/5.D0
     &    *Hr3(-1,0,0)*x**3 - 256.D0/5.D0*Hr3(-1,0,0)*dx**2 - 256.D0/3.D
     &    0*Hr3(-1,0,1) + 256.D0/3.D0*Hr3(-1,0,1)*x**2 + 128.D0/5.D0*
     &    Hr3(-1,0,1)*x**3 - 128.D0/3.D0*Hr3(-1,0,1)*dx - 256.D0/15.D0*
     &    Hr3(-1,0,1)*dx**2 - 512.D0/3.D0*Hr3(0,-1,0) - 64.D0/3.D0*Hr3(
     &    0,-1,0)*x - 256.D0/3.D0*Hr3(0,-1,0)*x**2 + 128.D0/5.D0*Hr3(0,
     &    -1,0)*x**3 - 512.D0/15.D0*Hr3(0,-1,0)*dx**2 + 136.D0/3.D0*
     &    Hr3(0,0,0)*x - 384.D0/5.D0*Hr3(0,0,0)*x**3 - 208.D0/3.D0*Hr3(
     &    0,0,1)*x - 320.D0/3.D0*Hr3(0,0,1)*x**2 - 1184.D0/15.D0*Hr3(0,
     &    0,1)*x**3 - 208.D0/3.D0*Hr3(0,1,0)*x + 64.D0/3.D0*Hr3(0,1,0)*
     &    x**2 + 160.D0/3.D0*Hr3(0,1,0)*x**3 - 208.D0/3.D0*Hr3(0,1,1)*x
     &     + 784.D0/9.D0*Hr3(1,0,0)*x - 32.D0*Hr3(1,0,1)*x - 64.D0/3.D0
     &    *Hr3(1,0,1)*x**2 - 160.D0/3.D0*Hr3(1,0,1)*x**3 - 64.D0*Hr3(1,
     &    1,0)*x + 64.D0/3.D0*Hr3(1,1,0)*x**2 + 160.D0/3.D0*Hr3(1,1,0)*
     &    x**3 )
      cLqq3 = cLqq3 + nf*cf**2 * (  - 128.D0/3.D0*Hr3(1,1,1)*x - 512.D0/
     &    3.D0*Hr4(-1,-1,-1,0)*x + 256.D0*Hr4(-1,-1,0,0)*x + 512.D0/3.D0
     &    *Hr4(-1,0,-1,0)*x - 128.D0*Hr4(-1,0,0,0)*x + 512.D0/3.D0*Hr4(
     &    0,-1,-1,0)*x - 128.D0/3.D0*Hr4(0,-1,0,0)*x + 256.D0/3.D0*Hr4(
     &    0,-1,0,1)*x + 128.D0/3.D0*Hr4(0,1,0,0)*x + 256.D0/3.D0*Hr4(1,
     &    0,-1,0)*x + 128.D0*Hr4(1,0,0,0)*x + 320.D0/3.D0*Hr4(1,0,0,1)*
     &    x - 64.D0/3.D0*Hr4(1,0,1,0)*x + 64.D0/3.D0*Hr4(1,1,0,1)*x - 
     &    64.D0/3.D0*Hr4(1,1,1,0)*x )
      cLqq3 = cLqq3 + nf**2*cf * (  - 304.D0/27.D0 + 2536.D0/81.D0*x - 
     &    64.D0/9.D0*z2*x - 32.D0/9.D0*Hr1(0) + 800.D0/27.D0*Hr1(0)*x
     &     - 32.D0/9.D0*Hr1(1) + 400.D0/27.D0*Hr1(1)*x + 32.D0/3.D0*
     &    Hr2(0,0)*x + 64.D0/9.D0*Hr2(0,1)*x + 32.D0/9.D0*Hr2(1,0)*x + 
     &    32.D0/9.D0*Hr2(1,1)*x )
*
* ...The special contribution
*
      SP1 =
     &  + dm * (  - 6.D0*z3 + 4.D0/5.D0*z2**2 + 8.D0*Hr1(-1)*z2 + 6.D0*
     &    Hr1(0)*z3 - 6.D0*Hr1(0)*z2 - 8.D0*Hr2(0,-1)*z2 + 6.D0*Hr2(0,0
     &    )*z2 - 4.D0*Hr3(-1,0,0) - 8.D0*Hr3(-1,0,1) + 2.D0*Hr3(0,0,0)
     &     + 4.D0*Hr3(0,0,1) + 4.D0*Hr4(0,-1,0,0) + 8.D0*Hr4(0,-1,0,1)
     &     - 2.D0*Hr4(0,0,0,0) - 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + dm**2 * (  - 4.D0/5.D0*z2**2 - 6.D0*Hr1(0)*z3 + 8.D0*
     &    Hr2(0,-1)*z2 - 6.D0*Hr2(0,0)*z2 - 4.D0*Hr4(0,-1,0,0) - 8.D0*
     &    Hr4(0,-1,0,1) + 2.D0*Hr4(0,0,0,0) + 4.D0*Hr4(0,0,0,1) )
      SP1 = SP1 + 2.D0*z3 + 4.D0*z3*dp - 21.D0/5.D0*z2**2*dp + 21.D0/5.D
     &    0*z2**2*dp**2 - 8.D0*Hr1(-1)*z2 - 4.D0*Hr1(0)*z3*dp + 4.D0*
     &    Hr1(0)*z3*dp**2 + 4.D0*Hr1(0)*z2 + 2.D0*Hr1(0)*z2*dp - 2.D0*
     &    Hr2(0,0)*z2*dp + 2.D0*Hr2(0,0)*z2*dp**2 + 4.D0*Hr3(-1,0,0) +
     &    8.D0*Hr3(-1,0,1) - 4.D0*Hr3(0,-1,0) + 4.D0*Hr3(0,-1,0)*dp - 2.
     &    D0*Hr3(0,0,0)*dp - 4.D0*Hr3(0,0,1) - 4.D0*Hr4(0,0,-1,0)*dp +
     &    4.D0*Hr4(0,0,-1,0)*dp**2 + 2.D0*Hr4(0,0,0,0)*dp - 2.D0*Hr4(0,
     &    0,0,0)*dp**2
       if (x .gt. 0.99995D0) then
         SP1 = x*(z2+z3)
* ...For 5-digit accuracy down to x=0.9
c    ,         + (1.-x)**2 * (-0.5*DL1-0.25*z2-0.5*z3+5./8.d0)
       endif
*
* ...Output; if commented out, only the fl11 part is returned
*
       XLNP3A = CLQQ3 + SP1 * 8.D0 * CF*(CA-2.*CF)**2
       endif
*
       RETURN
       END FUNCTION
*
* =================================================================av==
       END MODULE XCLNS3E
