      MODULE XCLPS3E
      CONTAINS
*     
* ..File: xclps3e.f    FL_PS
*
*
* ..The exact 3-loop MS(bar) pure-singlet coefficient functions for the 
*    structure function F_L in electromagnetic DIS at mu_r = mu_f = Q. 
*    Expansion parameter: alpha_s/(4 pi).
* 
* ..The distributions (in the mathematical sense) are given as in eq.
*    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.
*    The name-endings A, B, and C of the functions below correspond to 
*    the kernel superscripts [2], [3], and [1] in that equation.
*
* ..The code uses the package of Gehrmann and Remiddi for the harmonic
*    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296,
*    upgraded to weight 5 (T. Gehrmann, private communication).
*
* ..Reference: J. Vermaseren, A. Vogt and S. Moch
*              hep-ph/0504242 = Nucl. Phys. B724 (2005) 3
*
* =====================================================================
*
*
* ..There is only a regular piece. 
*
       FUNCTION XLS3A (X, NF, CC)
*
       IMPLICIT REAL*8 (A - Z)
       COMPLEX*16 HC1, HC2, HC3, HC4, HC5
       INTEGER NF, NF2, N1, N2, NW, CC
       PARAMETER ( N1 = -1, N2 = 1, NW = 5 )
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),
     ,           HC4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HC5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),
     ,           HR4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HR5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),
     ,           HI4(N1:N2,N1:N2,N1:N2,N1:N2),
     ,           HI5(N1:N2,N1:N2,N1:N2,N1:N2,N1:N2)
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,
     ,             Z3 = 1.2020 56903 15959 42854 D0,
     ,             Z4 = 1.0823 23233 71113 81916 D0,
     ,             Z5 = 1.0369 27755 14336 99263 D0 )
       DIMENSION FL(6), FLS(6)
       DATA FL  / -1.d0, 0.5d0, 0.d0, 0.5d0, 0.2d0, 0.5d0 /
       DATA FLS / 1.d0, 0.1d0, 0.d0, 0.1d0, 0.01818181818d0, 0.1d0 /
*
* ...Colour factors and abbreviations
*
       CF  = 4./3.D0
       CA  = 3.D0
       NF2 = NF*NF
       DABC2N = 5./18.D0 * NF
       FL11 = FLS(NF) - FL(NF)
*
       DX = 1.D0/X
*
* ...Harmonic polylogs (HPLs) up to weight 5 by Gehrmann and Remiddi
*
       CALL HPLOG5 (X, NW, HC1,HC2,HC3,HC4,HC5, HR1,HR2,HR3,HR4,HR5,
     ,              HI1,HI2,HI3,HI4,HI5, N1, N2)
*
* ...The coefficient function in terms of the HPLs, fl11 part
*
       if(CC.eq.0) then
      cLqq3 =
     &  + dabc2n * fl11 * (  - 768.D0/5.D0 - 1152.D0/5.D0*x + 768.D0/
     &    5.D0*x**2 + 2560.D0*z5*x + 512.D0/5.D0*dx - 4864.D0/15.D0*z3
     &     - 23488.D0/15.D0*z3*x + 896.D0/5.D0*z3*x**2 - 1280.D0*z3*
     &    x**3 + 4096.D0/15.D0*z3*dx - 9088.D0/15.D0*z2 + 10112.D0/15.D0
     &    *z2*x - 512.D0*z2*x**2 - 3328.D0/5.D0*z2*x**3 + 2048.D0/3.D0*
     &    z2*dx + 256.D0*z2*z3*x + 576.D0/5.D0*z2**2*x + 2048.D0/5.D0*
     &    z2**2*x**2 - 3072.D0/25.D0*z2**2*x**3 - 512.D0*Hr1(-1)*z3*x
     &     + 1536.D0/5.D0*Hr1(-1)*z3*x**3 - 1024.D0/5.D0*Hr1(-1)*z3*
     &    dx**2 - 3712.D0/15.D0*Hr1(-1)*z2 + 3136.D0/5.D0*Hr1(-1)*z2*x
     &     + 128.D0/5.D0*Hr1(-1)*z2*x**2 + 768.D0*Hr1(-1)*z2*x**3 - 
     &    1216.D0/15.D0*Hr1(-1)*z2*dx - 512.D0*Hr1(-1)*z2*dx**2 - 2048.D
     &    0/5.D0*Hr1(-1)*z2**2*x - 512.D0/15.D0*Hr1(0) - 896.D0/5.D0*
     &    Hr1(0)*x + 3328.D0/5.D0*Hr1(0)*x**2 - 512.D0/5.D0*Hr1(0)*dx
     &     + 512.D0/3.D0*Hr1(0)*z3*x + 512.D0*Hr1(0)*z3*x**2 - 2048.D0/
     &    5.D0*Hr1(0)*z3*x**3 + 1792.D0/15.D0*Hr1(0)*z2 - 640.D0/3.D0*
     &    Hr1(0)*z2*x )
      cLqq3 = cLqq3 + dabc2n *fl11 * ( 1792.D0/5.D0*Hr1(0)*z2*x**2
     &     - 1024.D0*Hr1(0)*z2*x**3 - 9344.D0/15.D0*Hr1(1) - 1152.D0/5.D
     &    0*Hr1(1)*x + 512.D0*Hr1(1)*x**2 + 1024.D0/3.D0*Hr1(1)*dx - 
     &    512.D0*Hr1(1)*z3 + 896.D0/3.D0*Hr1(1)*z3*x + 512.D0*Hr1(1)*z3
     &    *x**2 - 512.D0/5.D0*Hr1(1)*z3*x**3 + 256.D0*Hr1(1)*z3*dx - 
     &    1024.D0/15.D0*Hr1(1)*z3*dx**2 - 128.D0*Hr1(1)*z2 - 64.D0/3.D0
     &    *Hr1(1)*z2*x + 384.D0*Hr1(1)*z2*x**2 - 256.D0*Hr1(1)*z2*x**3
     &     + 192.D0*Hr1(1)*z2*dx - 512.D0/3.D0*Hr1(1)*z2*dx**2 + 2048.D0
     &    /3.D0*Hr2(-1,-1)*z2*x - 2048.D0/5.D0*Hr2(-1,-1)*z2*x**3 + 
     &    4096.D0/15.D0*Hr2(-1,-1)*z2*dx**2 + 256.D0/3.D0*Hr2(-1,0) - 
     &    1664.D0/3.D0*Hr2(-1,0)*x - 512.D0*Hr2(-1,0)*x**2 - 3328.D0/5.D
     &    0*Hr2(-1,0)*x**3 + 1024.D0/3.D0*Hr2(-1,0)*dx + 6656.D0/15.D0*
     &    Hr2(-1,0)*dx**2 - 512.D0*Hr2(-1,0)*z3*x - 1408.D0/3.D0*Hr2(-1
     &    ,0)*z2*x + 1024.D0/5.D0*Hr2(-1,0)*z2*x**3 - 2048.D0/15.D0*
     &    Hr2(-1,0)*z2*dx**2 - 896.D0/3.D0*Hr2(0,-1)*z2*x + 2048.D0/5.D0
     &    *Hr2(0,-1)*z2*x**3 )
      cLqq3 = cLqq3 + dabc2n * fl11 * ( 512.D0/3.D0*Hr2(0,0) - 6272.D0
     &    /15.D0*Hr2(0,0)*x + 512.D0*Hr2(0,0)*x**2 + 3328.D0/5.D0*Hr2(0
     &    ,0)*x**3 - 1024.D0/3.D0*Hr2(0,0)*dx - 512.D0*Hr2(0,0)*z2*x**2
     &     + 9088.D0/15.D0*Hr2(0,1) - 6144.D0/5.D0*Hr2(0,1)*x + 512.D0*
     &    Hr2(0,1)*x**2 - 1024.D0/3.D0*Hr2(0,1)*dx - 512.D0*Hr2(0,1)*z3
     &    *x - 128.D0*Hr2(0,1)*z2*x + 512.D0*Hr2(1,0)*z2 + 128.D0/3.D0*
     &    Hr2(1,0)*z2*x - 512.D0*Hr2(1,0)*z2*x**2 + 1024.D0/5.D0*Hr2(1,
     &    0)*z2*x**3 - 256.D0*Hr2(1,0)*z2*dx + 2048.D0/15.D0*Hr2(1,0)*
     &    z2*dx**2 - 256.D0*Hr3(-1,-1,0) + 128.D0/3.D0*Hr3(-1,-1,0)*x
     &     + 768.D0*Hr3(-1,-1,0)*x**2 + 512.D0*Hr3(-1,-1,0)*x**3 - 384.D
     &    0*Hr3(-1,-1,0)*dx - 1024.D0/3.D0*Hr3(-1,-1,0)*dx**2 + 2816.D0/
     &    15.D0*Hr3(-1,0,0) - 4864.D0/15.D0*Hr3(-1,0,0)*x - 1024.D0/5.D0
     &    *Hr3(-1,0,0)*x**2 - 512.D0*Hr3(-1,0,0)*x**3 + 2048.D0/15.D0*
     &    Hr3(-1,0,0)*dx + 1024.D0/3.D0*Hr3(-1,0,0)*dx**2 + 512.D0*Hr3(
     &    -1,0,0)*z2*x + 1792.D0/15.D0*Hr3(-1,0,1) - 9088.D0/15.D0*Hr3(
     &    -1,0,1)*x )
      cLqq3 = cLqq3 + dabc2n * fl11 * ( 1792.D0/5.D0*Hr3(-1,0,1)*x**2
     &     - 512.D0*Hr3(-1,0,1)*x**3 - 1664.D0/15.D0*Hr3(-1,0,1)*dx + 
     &    1024.D0/3.D0*Hr3(-1,0,1)*dx**2 + 256.D0/3.D0*Hr3(0,-1,0)*x - 
     &    768.D0*Hr3(0,-1,0)*x**2 - 512.D0*Hr3(0,-1,0)*x**3 - 256.D0/3.D
     &    0*Hr3(0,0,0)*x + 512.D0*Hr3(0,0,0)*x**3 - 1792.D0/15.D0*Hr3(0
     &    ,0,1) + 896.D0/3.D0*Hr3(0,0,1)*x - 1792.D0/5.D0*Hr3(0,0,1)*
     &    x**2 + 512.D0*Hr3(0,0,1)*x**3 + 512.D0*Hr3(0,1,0)*z2*x + 2816.
     &    D0/15.D0*Hr3(1,0,0) + 128.D0/5.D0*Hr3(1,0,0)*x - 1024.D0/5.D0
     &    *Hr3(1,0,0)*x**2 - 2048.D0/15.D0*Hr3(1,0,0)*dx - 1024.D0/3.D0
     &    *Hr4(-1,-1,0,0)*x + 1024.D0/5.D0*Hr4(-1,-1,0,0)*x**3 - 2048.D0
     &    /15.D0*Hr4(-1,-1,0,0)*dx**2 - 2048.D0/3.D0*Hr4(-1,-1,0,1)*x
     &     + 2048.D0/5.D0*Hr4(-1,-1,0,1)*x**3 - 4096.D0/15.D0*Hr4(-1,-1
     &    ,0,1)*dx**2 + 128.D0*Hr4(-1,0,0,0)*x + 1024.D0/3.D0*Hr4(-1,0,
     &    0,1)*x - 1024.D0/5.D0*Hr4(-1,0,0,1)*x**3 + 2048.D0/15.D0*Hr4(
     &    -1,0,0,1)*dx**2 + 256.D0*Hr4(0,-1,-1,0)*x + 256.D0/3.D0*Hr4(0
     &    ,-1,0,0)*x )
      cLqq3 = cLqq3 + dabc2n * fl11 * (  - 1024.D0/5.D0*Hr4(0,-1,0,0)
     &    *x**3 + 1280.D0/3.D0*Hr4(0,-1,0,1)*x - 2048.D0/5.D0*Hr4(0,-1,
     &    0,1)*x**3 + 512.D0*Hr4(0,0,0,1)*x**2 - 256.D0/3.D0*Hr4(0,1,0,
     &    0)*x - 512.D0*Hr4(0,1,0,0)*x**2 + 1024.D0/5.D0*Hr4(0,1,0,0)*
     &    x**3 + 256.D0*Hr4(1,0,-1,0)*x - 128.D0*Hr4(1,0,0,0)*x - 512.D0
     &    *Hr4(1,0,0,1) + 256.D0/3.D0*Hr4(1,0,0,1)*x + 512.D0*Hr4(1,0,0
     &    ,1)*x**2 - 1024.D0/5.D0*Hr4(1,0,0,1)*x**3 + 256.D0*Hr4(1,0,0,
     &    1)*dx - 2048.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 512.D0*Hr4(1,1,0,0
     &    ) - 256.D0/3.D0*Hr4(1,1,0,0)*x - 512.D0*Hr4(1,1,0,0)*x**2 + 
     &    1024.D0/5.D0*Hr4(1,1,0,0)*x**3 - 256.D0*Hr4(1,1,0,0)*dx + 
     &    2048.D0/15.D0*Hr4(1,1,0,0)*dx**2 - 512.D0*Hr5(-1,0,0,0,1)*x
     &     + 512.D0*Hr5(-1,0,1,0,0)*x - 512.D0*Hr5(0,1,0,0,1)*x + 512.D0
     &    *Hr5(0,1,1,0,0)*x )
       endif
*
* ...The coefficient function in terms of the HPLs: standard parts
*
       if(CC.eq.1) then
      cLqps3 =
     &  + nf*cf*ca * ( 6272.D0/9.D0 + 30944.D0/27.D0*x - 59152.D0/45.D0
     &    *x**2 - 71344.D0/135.D0*dx - 1824.D0/5.D0*z3 - 4384.D0/45.D0*
     &    z3*x + 2208.D0/5.D0*z3*x**2 + 64.D0/3.D0*z3*x**3 + 1856.D0/15.
     &    D0*z3*dx - 992.D0/9.D0*z2 - 1024.D0/15.D0*z2*x + 3408.D0/5.D0
     &    *z2*x**2 + 32.D0/15.D0*z2*x**3 + 5296.D0/45.D0*z2*dx - 1384.D0
     &    /15.D0*z2**2*x + 512.D0/15.D0*z2**2*x**2 - 512.D0/25.D0*z2**2
     &    *x**3 + 64.D0*Hr1(-1)*z2 - 464.D0/3.D0*Hr1(-1)*z2*x - 160.D0*
     &    Hr1(-1)*z2*x**2 - 64.D0/5.D0*Hr1(-1)*z2*x**3 + 80.D0*Hr1(-1)*
     &    z2*dx + 128.D0/15.D0*Hr1(-1)*z2*dx**2 - 6832.D0/45.D0*Hr1(0)
     &     + 101824.D0/135.D0*Hr1(0)*x + 161648.D0/135.D0*Hr1(0)*x**2
     &     - 11456.D0/135.D0*Hr1(0)*dx - 1568.D0/3.D0*Hr1(0)*z3*x + 128.
     &    D0/3.D0*Hr1(0)*z3*x**2 - 128.D0/5.D0*Hr1(0)*z3*x**3 + 624.D0/
     &    5.D0*Hr1(0)*z2 - 7376.D0/45.D0*Hr1(0)*z2*x + 512.D0/5.D0*Hr1(
     &    0)*z2*x**2 + 256.D0/15.D0*Hr1(0)*z2*x**3 + 64.D0/15.D0*Hr1(0)
     &    *z2*dx - 2528.D0/9.D0*Hr1(1) - 3424.D0/9.D0*Hr1(1)*x + 81104.D
     &    0/135.D0*Hr1(1)*x**2 )
      cLqps3 = cLqps3 + nf*cf*ca * ( 8176.D0/135.D0*Hr1(1)*dx - 64.D0/
     &    3.D0*Hr1(1)*z3*x + 128.D0/3.D0*Hr1(1)*z3*x**2 - 128.D0/5.D0*
     &    Hr1(1)*z3*x**3 + 64.D0/3.D0*Hr1(1)*z3*dx - 256.D0/15.D0*Hr1(1
     &    )*z3*dx**2 - 608.D0/3.D0*Hr1(1)*z2 + 464.D0/9.D0*Hr1(1)*z2*x
     &     + 96.D0*Hr1(1)*z2*x**2 + 64.D0/15.D0*Hr1(1)*z2*x**3 + 48.D0*
     &    Hr1(1)*z2*dx + 128.D0/45.D0*Hr1(1)*z2*dx**2 + 9728.D0/45.D0*
     &    Hr2(-1,0) - 10192.D0/45.D0*Hr2(-1,0)*x - 15616.D0/45.D0*Hr2(
     &    -1,0)*x**2 + 32.D0/15.D0*Hr2(-1,0)*x**3 + 4144.D0/45.D0*Hr2(
     &    -1,0)*dx - 64.D0/45.D0*Hr2(-1,0)*dx**2 - 64.D0*Hr2(0,-1)*z2*x
     &     + 15376.D0/45.D0*Hr2(0,0) + 8192.D0/15.D0*Hr2(0,0)*x - 61472.
     &    D0/45.D0*Hr2(0,0)*x**2 - 32.D0/15.D0*Hr2(0,0)*x**3 + 256.D0/
     &    45.D0*Hr2(0,0)*dx - 976.D0/3.D0*Hr2(0,0)*z2*x - 128.D0/3.D0*
     &    Hr2(0,0)*z2*x**2 + 128.D0/5.D0*Hr2(0,0)*z2*x**3 + 992.D0/9.D0
     &    *Hr2(0,1) - 1424.D0/9.D0*Hr2(0,1)*x - 3408.D0/5.D0*Hr2(0,1)*
     &    x**2 - 128.D0/5.D0*Hr2(0,1)*dx - 608.D0/3.D0*Hr2(0,1)*z2*x + 
     &    256.D0/3.D0*Hr2(1,0) )
      cLqps3 = cLqps3 + nf*cf*ca * ( 752.D0/3.D0*Hr2(1,0)*x - 1760.D0/
     &    9.D0*Hr2(1,0)*x**2 - 1264.D0/9.D0*Hr2(1,0)*dx + 64.D0/3.D0*
     &    Hr2(1,0)*z2*x - 128.D0/3.D0*Hr2(1,0)*z2*x**2 + 128.D0/5.D0*
     &    Hr2(1,0)*z2*x**3 - 64.D0/3.D0*Hr2(1,0)*z2*dx + 256.D0/15.D0*
     &    Hr2(1,0)*z2*dx**2 + 224.D0/3.D0*Hr2(1,1) + 704.D0/3.D0*Hr2(1,
     &    1)*x - 1616.D0/9.D0*Hr2(1,1)*x**2 - 1168.D0/9.D0*Hr2(1,1)*dx
     &     - 256.D0/3.D0*Hr3(-1,-1,0) - 928.D0/9.D0*Hr3(-1,-1,0)*x - 64.
     &    D0/3.D0*Hr3(-1,-1,0)*x**2 - 128.D0/15.D0*Hr3(-1,-1,0)*x**3 + 
     &    32.D0/3.D0*Hr3(-1,-1,0)*dx + 256.D0/45.D0*Hr3(-1,-1,0)*dx**2
     &     - 608.D0/3.D0*Hr3(-1,0,0) + 928.D0/9.D0*Hr3(-1,0,0)*x + 640.D
     &    0/3.D0*Hr3(-1,0,0)*x**2 + 128.D0/15.D0*Hr3(-1,0,0)*x**3 - 320.
     &    D0/3.D0*Hr3(-1,0,0)*dx - 256.D0/45.D0*Hr3(-1,0,0)*dx**2 - 320.
     &    D0/3.D0*Hr3(-1,0,1) + 928.D0/9.D0*Hr3(-1,0,1)*x + 448.D0/3.D0
     &    *Hr3(-1,0,1)*x**2 + 128.D0/15.D0*Hr3(-1,0,1)*x**3 - 224.D0/3.D
     &    0*Hr3(-1,0,1)*dx - 256.D0/45.D0*Hr3(-1,0,1)*dx**2 - 96.D0*
     &    Hr3(0,-1,0) )
      cLqps3 = cLqps3 + nf*cf*ca * (  - 1664.D0/9.D0*Hr3(0,-1,0)*x + 
     &    704.D0/3.D0*Hr3(0,-1,0)*x**2 + 128.D0/15.D0*Hr3(0,-1,0)*x**3
     &     + 64.D0/3.D0*Hr3(0,-1,0)*dx - 160.D0*Hr3(0,0,0) + 3536.D0/9.D
     &    0*Hr3(0,0,0)*x - 128.D0/15.D0*Hr3(0,0,0)*x**3 - 624.D0/5.D0*
     &    Hr3(0,0,1) - 944.D0/45.D0*Hr3(0,0,1)*x - 512.D0/5.D0*Hr3(0,0,
     &    1)*x**2 - 128.D0/15.D0*Hr3(0,0,1)*x**3 + 256.D0/15.D0*Hr3(0,0
     &    ,1)*dx + 32.D0*Hr3(0,1,0)*x - 448.D0/3.D0*Hr3(0,1,0)*x**2 - 
     &    128.D0/3.D0*Hr3(0,1,0)*dx + 32.D0*Hr3(0,1,1) + 16.D0/3.D0*
     &    Hr3(0,1,1)*x - 448.D0/3.D0*Hr3(0,1,1)*x**2 - 160.D0/3.D0*Hr3(
     &    0,1,1)*dx + 1424.D0/5.D0*Hr3(1,0,0) - 752.D0/15.D0*Hr3(1,0,0)
     &    *x - 768.D0/5.D0*Hr3(1,0,0)*x**2 - 1216.D0/15.D0*Hr3(1,0,0)*
     &    dx + 160.D0*Hr3(1,0,1) - 320.D0/3.D0*Hr3(1,0,1)*x**2 - 160.D0/
     &    3.D0*Hr3(1,0,1)*dx + 160.D0*Hr3(1,1,0) - 320.D0/3.D0*Hr3(1,1,
     &    0)*x**2 - 160.D0/3.D0*Hr3(1,1,0)*dx + 160.D0*Hr3(1,1,1) - 320.
     &    D0/3.D0*Hr3(1,1,1)*x**2 - 160.D0/3.D0*Hr3(1,1,1)*dx + 256.D0/
     &    3.D0*Hr4(0,-1,-1,0)*x )
      cLqps3 = cLqps3 + nf*cf*ca * ( 608.D0/3.D0*Hr4(0,-1,0,0)*x + 
     &    320.D0/3.D0*Hr4(0,-1,0,1)*x + 224.D0/3.D0*Hr4(0,0,-1,0)*x + 
     &    1216.D0/3.D0*Hr4(0,0,0,0)*x + 400.D0*Hr4(0,0,0,1)*x + 128.D0/
     &    3.D0*Hr4(0,0,0,1)*x**2 - 128.D0/5.D0*Hr4(0,0,0,1)*x**3 + 320.D
     &    0*Hr4(0,0,1,0)*x + 352.D0*Hr4(0,0,1,1)*x + 880.D0/3.D0*Hr4(0,
     &    1,0,0)*x - 128.D0/3.D0*Hr4(0,1,0,0)*x**2 + 128.D0/5.D0*Hr4(0,
     &    1,0,0)*x**3 + 160.D0*Hr4(0,1,0,1)*x + 160.D0*Hr4(0,1,1,0)*x
     &     + 160.D0*Hr4(0,1,1,1)*x - 64.D0/3.D0*Hr4(1,0,0,1)*x + 128.D0/
     &    3.D0*Hr4(1,0,0,1)*x**2 - 128.D0/5.D0*Hr4(1,0,0,1)*x**3 + 64.D0
     &    /3.D0*Hr4(1,0,0,1)*dx - 256.D0/15.D0*Hr4(1,0,0,1)*dx**2 + 64.D
     &    0/3.D0*Hr4(1,1,0,0)*x - 128.D0/3.D0*Hr4(1,1,0,0)*x**2 + 128.D0
     &    /5.D0*Hr4(1,1,0,0)*x**3 - 64.D0/3.D0*Hr4(1,1,0,0)*dx + 256.D0/
     &    15.D0*Hr4(1,1,0,0)*dx**2 )
      cLqps3 = cLqps3 + nf*cf**2 * ( 25648.D0/225.D0 - 108544.D0/675.D
     &    0*x + 1136.D0/675.D0*x**2 + 30464.D0/675.D0*dx + 128.D0/5.D0*
     &    z3 - 23152.D0/45.D0*z3*x - 128.D0/15.D0*z3*x**2 - 32.D0/3.D0*
     &    z3*x**3 - 384.D0/5.D0*z3*dx - 11488.D0/45.D0*z2 - 80176.D0/
     &    135.D0*z2*x + 1984.D0/15.D0*z2*x**2 + 1088.D0/225.D0*z2*x**3
     &     - 352.D0/9.D0*z2*dx + 1424.D0/15.D0*z2**2*x - 1024.D0/15.D0*
     &    z2**2*x**2 + 1024.D0/25.D0*z2**2*x**3 + 96.D0*Hr1(-1)*z2 + 
     &    352.D0/3.D0*Hr1(-1)*z2*x + 64.D0/3.D0*Hr1(-1)*z2*x**2 + 32.D0/
     &    5.D0*Hr1(-1)*z2*x**3 - 32.D0/3.D0*Hr1(-1)*z2*dx - 64.D0/15.D0
     &    *Hr1(-1)*z2*dx**2 + 67952.D0/675.D0*Hr1(0) - 11904.D0/25.D0*
     &    Hr1(0)*x - 12944.D0/675.D0*Hr1(0)*x**2 + 6656.D0/675.D0*Hr1(0
     &    )*dx + 736.D0/3.D0*Hr1(0)*z3*x - 256.D0/3.D0*Hr1(0)*z3*x**2
     &     + 256.D0/5.D0*Hr1(0)*z3*x**3 - 1408.D0/5.D0*Hr1(0)*z2 - 5696.
     &    D0/15.D0*Hr1(0)*z2*x + 1536.D0/5.D0*Hr1(0)*z2*x**2 - 128.D0/
     &    15.D0*Hr1(0)*z2*x**3 + 512.D0/15.D0*Hr1(0)*z2*dx + 3344.D0/5.D
     &    0*Hr1(1) )
      cLqps3 = cLqps3 + nf*cf**2 * (  - 13856.D0/45.D0*Hr1(1)*x - 
     &    28816.D0/135.D0*Hr1(1)*x**2 - 19904.D0/135.D0*Hr1(1)*dx + 128.
     &    D0/3.D0*Hr1(1)*z3*x - 256.D0/3.D0*Hr1(1)*z3*x**2 + 256.D0/5.D0
     &    *Hr1(1)*z3*x**3 - 128.D0/3.D0*Hr1(1)*z3*dx + 512.D0/15.D0*
     &    Hr1(1)*z3*dx**2 + 160.D0/3.D0*Hr1(1)*z2 - 736.D0/9.D0*Hr1(1)*
     &    z2*x + 64.D0/3.D0*Hr1(1)*z2*x**2 - 32.D0/15.D0*Hr1(1)*z2*x**3
     &     + 32.D0/3.D0*Hr1(1)*z2*dx - 64.D0/45.D0*Hr1(1)*z2*dx**2 - 
     &    2176.D0/5.D0*Hr2(-1,0) - 56992.D0/135.D0*Hr2(-1,0)*x + 256.D0/
     &    15.D0*Hr2(-1,0)*x**2 + 1088.D0/225.D0*Hr2(-1,0)*x**3 - 352.D0/
     &    45.D0*Hr2(-1,0)*dx - 4736.D0/675.D0*Hr2(-1,0)*dx**2 - 96.D0*
     &    Hr2(0,-1)*z2*x - 112.D0/3.D0*Hr2(0,0) + 4544.D0/27.D0*Hr2(0,0
     &    )*x - 64.D0*Hr2(0,0)*x**2 - 1088.D0/225.D0*Hr2(0,0)*x**3 + 
     &    128.D0/15.D0*Hr2(0,0)*dx - 1024.D0/3.D0*Hr2(0,0)*z2*x + 256.D0
     &    /3.D0*Hr2(0,0)*z2*x**2 - 256.D0/5.D0*Hr2(0,0)*z2*x**3 + 11488.
     &    D0/45.D0*Hr2(0,1) + 2576.D0/15.D0*Hr2(0,1)*x - 1984.D0/15.D0*
     &    Hr2(0,1)*x**2 )
      cLqps3 = cLqps3 + nf*cf**2 * ( 1408.D0/45.D0*Hr2(0,1)*dx + 160.D
     &    0/3.D0*Hr2(0,1)*z2*x + 544.D0/3.D0*Hr2(1,0) - 544.D0/3.D0*
     &    Hr2(1,0)*x + 64.D0/9.D0*Hr2(1,0)*x**2 - 64.D0/9.D0*Hr2(1,0)*
     &    dx - 128.D0/3.D0*Hr2(1,0)*z2*x + 256.D0/3.D0*Hr2(1,0)*z2*x**2
     &     - 256.D0/5.D0*Hr2(1,0)*z2*x**3 + 128.D0/3.D0*Hr2(1,0)*z2*dx
     &     - 512.D0/15.D0*Hr2(1,0)*z2*dx**2 + 752.D0/3.D0*Hr2(1,1) - 
     &    512.D0/3.D0*Hr2(1,1)*x - 512.D0/9.D0*Hr2(1,1)*x**2 - 208.D0/9.
     &    D0*Hr2(1,1)*dx + 704.D0/3.D0*Hr3(-1,-1,0) + 1472.D0/9.D0*Hr3(
     &    -1,-1,0)*x - 128.D0/3.D0*Hr3(-1,-1,0)*x**2 + 64.D0/15.D0*Hr3(
     &    -1,-1,0)*x**3 + 64.D0/3.D0*Hr3(-1,-1,0)*dx - 128.D0/45.D0*
     &    Hr3(-1,-1,0)*dx**2 - 64.D0*Hr3(-1,0,0) - 256.D0/3.D0*Hr3(-1,0
     &    ,0)*x + 64.D0/5.D0*Hr3(-1,0,0)*x**3 - 128.D0/15.D0*Hr3(-1,0,0
     &    )*dx**2 + 64.D0/3.D0*Hr3(-1,0,1) - 320.D0/9.D0*Hr3(-1,0,1)*x
     &     - 128.D0/3.D0*Hr3(-1,0,1)*x**2 - 64.D0/15.D0*Hr3(-1,0,1)*
     &    x**3 + 64.D0/3.D0*Hr3(-1,0,1)*dx + 128.D0/45.D0*Hr3(-1,0,1)*
     &    dx**2 )
      cLqps3 = cLqps3 + nf*cf**2 * (  - 640.D0/3.D0*Hr3(0,-1,0) + 320.
     &    D0/9.D0*Hr3(0,-1,0)*x + 128.D0/3.D0*Hr3(0,-1,0)*x**2 - 64.D0/
     &    15.D0*Hr3(0,-1,0)*x**3 - 512.D0/45.D0*Hr3(0,-1,0)*dx**2 + 160.
     &    D0*Hr3(0,0,0) + 2000.D0/9.D0*Hr3(0,0,0)*x - 256.D0*Hr3(0,0,0)
     &    *x**2 - 64.D0/5.D0*Hr3(0,0,0)*x**3 + 1408.D0/5.D0*Hr3(0,0,1)
     &     + 18688.D0/45.D0*Hr3(0,0,1)*x - 1536.D0/5.D0*Hr3(0,0,1)*x**2
     &     + 64.D0/15.D0*Hr3(0,0,1)*x**3 - 512.D0/15.D0*Hr3(0,0,1)*dx
     &     + 128.D0*Hr3(0,1,0) + 96.D0*Hr3(0,1,0)*x - 128.D0*Hr3(0,1,0)
     &    *x**2 + 128.D0*Hr3(0,1,1) + 208.D0*Hr3(0,1,1)*x - 320.D0/3.D0
     &    *Hr3(0,1,1)*x**2 - 768.D0/5.D0*Hr3(1,0,0) + 1024.D0/15.D0*
     &    Hr3(1,0,0)*x + 256.D0/5.D0*Hr3(1,0,0)*x**2 + 512.D0/15.D0*
     &    Hr3(1,0,0)*dx + 64.D0*Hr3(1,0,1) - 128.D0/3.D0*Hr3(1,0,1)*
     &    x**2 - 64.D0/3.D0*Hr3(1,0,1)*dx + 64.D0*Hr3(1,1,0) - 128.D0/3.
     &    D0*Hr3(1,1,0)*x**2 - 64.D0/3.D0*Hr3(1,1,0)*dx + 32.D0*Hr3(1,1
     &    ,1) - 64.D0/3.D0*Hr3(1,1,1)*x**2 - 32.D0/3.D0*Hr3(1,1,1)*dx
     &     - 704.D0/3.D0*Hr4(0,-1,-1,0)*x )
      cLqps3 = cLqps3 + nf*cf**2 * ( 64.D0*Hr4(0,-1,0,0)*x - 64.D0/3.D
     &    0*Hr4(0,-1,0,1)*x - 64.D0/3.D0*Hr4(0,0,-1,0)*x + 64.D0*Hr4(0,
     &    0,0,0)*x + 320.D0*Hr4(0,0,0,1)*x - 256.D0/3.D0*Hr4(0,0,0,1)*
     &    x**2 + 256.D0/5.D0*Hr4(0,0,0,1)*x**3 + 128.D0*Hr4(0,0,1,0)*x
     &     + 128.D0*Hr4(0,0,1,1)*x - 512.D0/3.D0*Hr4(0,1,0,0)*x + 256.D0
     &    /3.D0*Hr4(0,1,0,0)*x**2 - 256.D0/5.D0*Hr4(0,1,0,0)*x**3 + 64.D
     &    0*Hr4(0,1,0,1)*x + 64.D0*Hr4(0,1,1,0)*x + 32.D0*Hr4(0,1,1,1)*
     &    x + 128.D0/3.D0*Hr4(1,0,0,1)*x - 256.D0/3.D0*Hr4(1,0,0,1)*
     &    x**2 + 256.D0/5.D0*Hr4(1,0,0,1)*x**3 - 128.D0/3.D0*Hr4(1,0,0,
     &    1)*dx + 512.D0/15.D0*Hr4(1,0,0,1)*dx**2 - 128.D0/3.D0*Hr4(1,1
     &    ,0,0)*x + 256.D0/3.D0*Hr4(1,1,0,0)*x**2 - 256.D0/5.D0*Hr4(1,1
     &    ,0,0)*x**3 + 128.D0/3.D0*Hr4(1,1,0,0)*dx - 512.D0/15.D0*Hr4(1
     &    ,1,0,0)*dx**2 )
      cLqps3 = cLqps3 + nf2*cf * (  - 5248.D0/45.D0 + 3584.D0/135.D0
     &    *x + 20672.D0/405.D0*x**2 + 15808.D0/405.D0*dx - 32.D0/3.D0*
     &    z3*x + 160.D0/3.D0*z2*x + 64.D0/9.D0*z2*x**2 + 64.D0/15.D0*z2
     &    *x**3 - 64.D0/9.D0*z2*dx - 256.D0/5.D0*Hr1(0) - 8992.D0/135.D0
     &    *Hr1(0)*x + 8224.D0/135.D0*Hr1(0)*x**2 + 128.D0/45.D0*Hr1(0)*
     &    dx - 224.D0/9.D0*Hr1(1) - 32.D0/9.D0*Hr1(1)*x + 608.D0/27.D0*
     &    Hr1(1)*x**2 + 160.D0/27.D0*Hr1(1)*dx + 128.D0/9.D0*Hr2(-1,0)*
     &    x + 128.D0/9.D0*Hr2(-1,0)*x**2 + 64.D0/15.D0*Hr2(-1,0)*x**3
     &     - 64.D0/9.D0*Hr2(-1,0)*dx - 128.D0/45.D0*Hr2(-1,0)*dx**2 - 
     &    64.D0/3.D0*Hr2(0,0) - 128.D0*Hr2(0,0)*x + 128.D0/3.D0*Hr2(0,0
     &    )*x**2 - 64.D0/15.D0*Hr2(0,0)*x**3 - 352.D0/9.D0*Hr2(0,1)*x
     &     - 64.D0/9.D0*Hr2(0,1)*x**2 + 32.D0/3.D0*Hr2(1,1) - 64.D0/9.D0
     &    *Hr2(1,1)*x**2 - 32.D0/9.D0*Hr2(1,1)*dx - 64.D0*Hr3(0,0,0)*x
     &     + 32.D0/3.D0*Hr3(0,1,1)*x )
       endif
*
       if(CC.eq.0) then
              XLS3A = CLQQ3
       else
              XLS3A = CLQPS3 
       endif
*
       RETURN
       END
*
* =================================================================av==
      END MODULE XCLPS3E
