      module momnsmod
      use daind_fake

      private
      
      public ODDNSsub

      public ODEL, OPLUS1, OPLUS2, OREG, MOMREG, MOMPLUS
      public ODDMOMNS

      contains

      subroutine ODDNSsub
*     -------------
*
********************************************************************
*     J. Bluemlein, 09.05.2025:
*     all rights reserved; same credentials as for VFNS.f 
*     
*     z-space massive OMEs to 3-loops for nonsinglet minus [odd moments]
*
*     ODEL      delta part (a constant)
*     OPLUS1    1/(1-x) plus part
*     OPLUS2    1/(1-x)^2 plus part
*     OREG      regular part
*     compile:  gfortran -- moment checks are provided: N=1,3,...11
*     The OMEs apply to the NS-matching for f - fbar
*
********************************************************************
*
      IMPLICIT NONE
      REAL*8 TT(6),UU(6),RR(6),LL,as,NF,T!ODDMOMNS,T
!      REAL*8 ODEL,OPLUS1,OPLUS2,OREG,z
!      REAL*8 OMOM1,MOMREG,MOMPLUS
      REAL*8 z
!      REAL*8 OMOM1
      INTEGER N,K
*
      LL =10.0D0
      as =0.1D0
      NF =3.0D0
      z  =0.1D0
      DO 1 K = 1,6
      N=2*K-1
      TT(K) = ODDMOMNS(N,as,LL,NF)
      IF(K.EQ.1) UU(K)=MOMREG(as,LL,NF,N)+ODEL(as,LL,NF)-1.0D0
      IF(K.NE.1)
     &UU(K)=MOMREG(as,LL,NF,N)+ODEL(as,LL,NF)+MOMPLUS(as,LL,NF,N)
      IF(K.EQ.1) RR(K)=TT(K)/UU(K)
      IF(K.NE.1) RR(K)=TT(K)/UU(K)-1.0D0
      WRITE(6,*) 'N,MOM,ACC=',N,TT(K),RR(K)
1     CONTINUE
      T =ODEL(as,LL,NF)
      WRITE(6,*) 'ODEL,as,LL,NF =',T,as,LL,NF
      T =OPLUS2(as,LL,NF,z)
      WRITE(6,*) 'OPLUS2,as,LL,NF =',T,as,LL,NF
      T =OPLUS1(as,LL,NF,z)
      WRITE(6,*) 'OPLUS1,as,LL,NF =',T,as,LL,NF
      T =OREG(as,LL,NF,z)
      WRITE(6,*) 'OREG,as,LL,NF =',T,as,LL,NF
      T=OMOM1(as,LL,NF)-1.0D0      
      WRITE(6,*) 'MOM1=',T
      T=MOMREG(as,LL,NF,1)
      WRITE(6,*) 'MOMREG1=',T
      T=MOMREG(as,LL,NF,11)
      WRITE(6,*) 'MOMREG11=',T
      T=MOMPLUS(as,LL,NF,3)
      WRITE(6,*) 'MOMPLUS3=',T
      T=MOMPLUS(as,LL,NF,11)
      WRITE(6,*) 'MOMPLUS11=',T
      STOP
      END SUBROUTINE
      
      REAL*8 FUNCTION ODDMOMNS(N,as,LL,NF)
*     ------------------------------------
* 
*     The moments N=1,3,...,11 for ANSqq
*
      IMPLICIT NONE
      INTEGER N
      REAL*8 G,as, LL, z2,z3,z4,B4,ln2,li4half,NF
      REAL*8 w(4)
*
      ln2     = 0.69314718055994530942D0
      z2      = 1.6449340668482264365D0
      z3      = 1.2020569031595942854D0
      z4      = 1.0823232337111381915D0
      li4half = 0.51747906167389938633D0
      B4      = -1.7628000870737708641D0
*
      IF(N.EQ.1)  GOTO 1
      IF(N.EQ.3)  GOTO 3
      IF(N.EQ.5)  GOTO 5
      IF(N.EQ.7)  GOTO 7
      IF(N.EQ.9)  GOTO 9
      IF(N.EQ.11) GOTO 11
      GOTO 101
*
1     CONTINUE
      G = 0.0D0
      GOTO 100
3     CONTINUE
      w(1)=5*LL
      w(2)= - 83.D0/3.D0 - 10*LL
      w(2)=w(2)*w(1)
      w(2)= - 3277.D0/24.D0 + w(2)
      w(3)= - 4301.D0/3.D0 + 580*LL
      w(1)=w(3)*w(1)
      w(1)=79087.D0/18.D0 + w(1)
      w(1)=LL*w(1)
      w(3)=LL**2
      w(3)= - 14969.D0/6.D0 - 200*w(3)
      w(3)=LL*w(3)
      w(3)= - 291613.D0/108.D0 + w(3)
      w(3)=NF*w(3)
      w(1)=w(3) + 14955607.D0/1296.D0 + w(1)
      w(3)=1600.D0/9.D0*NF + 9251.D0/9.D0 - 2000*LL
      w(3)=z3*w(3)
      w(1)=200.D0/9.D0*B4 + 1.D0/3.D0*w(3) + 1.D0/27.D0*w(1) - 1000*z4
      w(1)=as*w(1)
      w(1)=1.D0/3.D0*w(2) + w(1)
      w(1)=1.D0/9.D0*w(1)*as**2
      G = 1.0D0+w(1)
      GOTO 100
5     CONTINUE
      w(1)=182*LL
      w(2)=29 - 2*NF
      w(2)=w(2)*w(1)
      w(2)= - 282977.D0/25.D0 + w(2)
      w(2)=LL*w(2)
      w(2)=4.D0/45.D0*w(2) - 448007.D0/1125.D0*NF + 74916103.D0/67500.D0
     &  - 2912*z3
      w(2)=LL*w(2)
      w(3)=17766495341.D0/162000.D0 + 173962*z3
      w(4)= - 14816797.D0/750.D0 + 11648*z3
      w(4)=NF*w(4)
      w(2)=1456.D0/45.D0*B4 + 1.D0/3.D0*w(2) + 1.D0/135.D0*w(4) + 1.D0/
     & 225.D0*w(3) - 1456*z4
      w(2)=as*w(2)
      w(1)= - 7783.D0/15.D0 - w(1)
      w(1)=LL*w(1)
      w(1)= - 912779.D0/900.D0 + 2*w(1)
      w(1)=1.D0/15.D0*w(1) + w(2)
      w(1)=1.D0/9.D0*w(1)*as**2
      G = 1.0D0+w(1)
      GOTO 100
7     CONTINUE
      w(1)= - 3503677573.D0/29400.D0 + 59566*LL
      w(1)=LL*w(1)
      w(1)=4055066972087.D0/24696000.D0 + w(1)
      w(1)=LL*w(1)
      w(2)=LL**2
      w(2)= - 8857998911.D0/176400.D0 - 4108*w(2)
      w(2)=LL*w(2)
      w(2)=32864*z3 - 12421023670777.D0/222264000.D0 + w(2)
      w(2)=NF*w(2)
      w(1)=w(1) + w(2)
      w(2)=84971851.D0/9450.D0 - 8216*LL
      w(2)=z3*w(2)
      w(1)=4108.D0/45.D0*B4 + 1.D0/3.D0*w(2) + 787413977506973.D0/
     & 1200225600000.D0 - 4108*z4 + 1.D0/135.D0*w(1)
      w(1)=as*w(1)
      w(2)= - 3745727.D0/1260.D0 - 1027*LL
      w(2)=LL*w(2)
      w(2)= - 6118125889.D0/2116800.D0 + w(2)
      w(1)=1.D0/15.D0*w(2) + w(1)
      w(1)=1.D0/21.D0*w(1)*as**2
      G=1.0D0+w(1)
      GOTO 100
9     CONTINUE
      w(1)= - 153824374673.D0/661500.D0 + 121220*LL
      w(1)=LL*w(1)
      w(1)=11144154487217.D0/30870000.D0 + w(1)
      w(1)=LL*w(1)
      w(2)=LL**2
      w(2)= - 134586889837.D0/1323000.D0 - 8360*w(2)
      w(2)=LL*w(2)
      w(2)= - 569734315843529.D0/5000940000.D0 + w(2)
      w(2)=NF*w(2)
      w(1)=w(2) - 3039408688422977.D0/64297800000.D0 + w(1)
      w(2)=66880.D0/9.D0*NF + 550386527.D0/4725.D0 - 83600*LL
      w(2)=z3*w(2)
      w(1)=8360.D0/9.D0*B4 + 1.D0/3.D0*w(2) - 41800*z4 + 1.D0/27.D0*
     & w(1)
      w(1)=as*w(1)
      w(2)= - 19247947.D0/3150.D0 - 2090*LL
      w(2)=LL*w(2)
      w(2)= - 93992230163.D0/15876000.D0 + w(2)
      w(1)=1.D0/3.D0*w(2) + w(1)
      w(1)=1.D0/189.D0*w(1)*as**2
      G = 1.0D0+w(1)
      GOTO 100
11    CONTINUE
      w(1)= - 54370544172799.D0/4002075.D0 + 7286656*LL
      w(1)=LL*w(1)
      w(1)=6724213287267551843.D0/295833384000.D0 + w(1)
      w(1)=LL*w(1)
      w(2)=LL**2
      w(2)= - 195125070512443.D0/32016600.D0 - 502528*w(2)
      w(2)=LL*w(2)
      w(2)=4020224*z3 - 9128352673014156577.D0/1331250228000.D0 + w(2)
      w(2)=NF*w(2)
      w(1)=w(1) + w(2)
      w(2)=88276341919.D0/51975.D0 - 1005056*LL
      w(2)=z3*w(2)
      w(1)=502528.D0/45.D0*B4 + 1.D0/3.D0*w(2) - 
     & 25958071458158864777099.D0/203338963396800000.D0 - 502528*z4 + 1.
     & D0/135.D0*w(1)
      w(1)=as*w(1)
      w(2)= - 512808781.D0/1386.D0 - 125632*LL
      w(2)=LL*w(2)
      w(2)= - 137385847426757.D0/384199200.D0 + w(2)
      w(1)=1.D0/15.D0*w(2) + w(1)
      w(1)=1.D0/2079.D0*w(1)*as**2
      G = 1.0D0+w(1)
      GOTO 100
*
101   WRITE(6,*) '*** N=',N,'*** NOT ALLOWED, STOP'
      STOP
100   ODDMOMNS = G
      RETURN
      END
      REAL*8 FUNCTION OMOM1(as,LL,NF)
*     -------------------------------
* 
      IMPLICIT NONE
      REAL*8 as,LL,NF!,ODEL,MOMREG
      INTEGER N
      N=1
*
      OMOM1=ODEL(as,LL,NF) + MOMREG(as,LL,NF,N)
      RETURN
      END
      REAL*8 FUNCTION OMOM3(as,LL,NF)
*     -------------------------------
* 
      IMPLICIT NONE
      REAL*8 as,LL,NF!,ODEL,MOMREG,MOMPLUS
      INTEGER N
      N=3
*
      OMOM3=ODEL(as,LL,NF) + MOMREG(as,LL,NF,N)
     &      +MOMPLUS(as,LL,NF,N)
      RETURN
      END
      REAL*8 FUNCTION OMOM5(as,LL,NF)
*     -------------------------------
* 
      IMPLICIT NONE
      REAL*8 as,LL,NF!,ODEL,MOMREG,MOMPLUS
      INTEGER N
      N=5
*
      OMOM5=ODEL(as,LL,NF) + MOMREG(as,LL,NF,N)
     &      +MOMPLUS(as,LL,NF,N)
      RETURN
      END
      REAL*8 FUNCTION OMOM7(as,LL,NF)
*     -------------------------------
* 
      IMPLICIT NONE
      REAL*8 as,LL,NF!,ODEL,MOMREG,MOMPLUS
      INTEGER N
      N=7
*
      OMOM7=ODEL(as,LL,NF) + MOMREG(as,LL,NF,N)
     &      +MOMPLUS(as,LL,NF,N)
      RETURN
      END
      REAL*8 FUNCTION OMOM9(as,LL,NF)
*     -------------------------------
* 
      IMPLICIT NONE
      REAL*8 as,LL,NF!,ODEL,MOMREG,MOMPLUS
      INTEGER N
      N=9
*
      OMOM9=ODEL(as,LL,NF) + MOMREG(as,LL,NF,N)
     &      +MOMPLUS(as,LL,NF,N)
      RETURN
      END
      REAL*8 FUNCTION OMOM11(as,LL,NF)
*     --------------------------------
* 
      IMPLICIT NONE
      REAL*8 as,LL,NF!,ODEL,MOMREG,MOMPLUS
      INTEGER N
      N=3
*
      OMOM11=ODEL(as,LL,NF) + MOMREG(as,LL,NF,N)
     &      +MOMPLUS(as,LL,NF,N)
      RETURN
      END
      REAL*8 FUNCTION ODEL(as,LL,NF)
*     ------------------------------
*
      IMPLICIT NONE
*  
      REAL*8 w(7),G
      REAL*8 as,LL,NF,z2,z3,z4,B4,ln2,CF,CA,TF,li4half,z5
*
      ln2     = 0.69314718055994530942D0
      z2      = 1.6449340668482264365D0
      z3      = 1.2020569031595942854D0
      z4      = 1.0823232337111381915D0
      z5      = 1.0369277551433699263D0
      li4half = 0.51747906167389938633D0
      B4      = -1.7628000870737708641D0
*
      CF=4.0D0/3.0D0
      CA=3.0D0
      TF=1.0D0/2.0D0
*
*     WRITE(6,*) 'as,LL,NF',as,LL,NF
      w(1)=2*LL
      w(2)=1.D0/3.D0 + LL
      w(2)=w(2)*w(1)
      w(2)=73.D0/18.D0 + w(2)
      w(2)=w(2)*as**2
      w(3)= - 22.D0/3.D0*LL + 17 - 8*z3
      w(1)=w(3)*w(1)
      w(3)=z2**2
      w(1)=w(1) + 272.D0/3.D0*z3 - 1595.D0/9.D0 + 136.D0/5.D0*w(3)
      w(1)=LL*w(1)
      w(4)=72*z4
      w(5)=16*z2
      w(6)= - 10045.D0/9.D0 - w(5)
      w(6)=z3*w(6)
      w(1)=w(4) - 176.D0/9.D0*z5 + 1.D0/3.D0*w(1) + 1.D0/9.D0*w(6) + 
     & 272.D0/27.D0*w(3) + 55.D0/243.D0 - 8*B4
      w(6)=as**3
      w(1)=w(1)*w(6)
      w(7)=1 + 4.D0/3.D0*z3
      w(7)=LL*w(7)
      w(7)=8*w(7) - 112.D0/9.D0*z3 + 1 - 272.D0/15.D0*w(3)
      w(7)=LL*w(7)
      w(5)=6841.D0/9.D0 + w(5)
      w(5)=z3*w(5)
      w(3)= - w(4) + 352.D0/9.D0*z5 + w(7) + 2.D0/9.D0*w(5) - 544.D0/27.
     & D0*w(3) - 691.D0/9.D0 + 16*B4
      w(3)=w(3)*w(6)
      w(4)=4*LL
      w(5)=1 + w(4)
      w(5)=LL*w(5)
      w(5)=62.D0/3.D0 + w(5)
      w(4)=w(5)*w(4)
      w(5)=LL**2
      w(5)=175.D0/3.D0 + 4*w(5)
      w(5)=LL*w(5)
      w(5)=w(5) + 1183.D0/27.D0 - 32*z3
      w(5)=NF*w(5)
      w(4)=2*w(5) + w(4) - 1829.D0/27.D0 + 112*z3
      w(4)=2.D0/9.D0*w(4)*w(6)
*
      G = 1 + TF*CF*w(2) + TF*CF*CA*w(1) + TF*CF**2*w(3) + TF**2*CF*
     & w(4)
*
      ODEL = G
*
      RETURN
      END
      REAL*8 FUNCTION OPLUS1(as,LL,NF,z)
*     ----------------------------------
*
      IMPLICIT NONE
*  
      INTEGER nw
      REAL*8 w(64),G,z,x
      REAL*8 as,LL,NF,z2,z3,z4,B4,ln2,CF,CA,TF,li4half,z5
      complex*16 Hc1,Hc2,Hc3,Hc4,Hc5
      real*8 Hr1,Hr2,Hr3,Hr4,Hr5
      real*8 Hi1,Hi2,Hi3,Hi4,Hi5
      dimension Hc1(-1:1),Hc2(-1:1,-1:1),Hc3(-1:1,-1:1,-1:1),
     $          Hc4(-1:1,-1:1,-1:1,-1:1),
     $          Hc5(-1:1,-1:1,-1:1,-1:1,-1:1)
      dimension Hr1(-1:1),Hr2(-1:1,-1:1),Hr3(-1:1,-1:1,-1:1),
     $          Hr4(-1:1,-1:1,-1:1,-1:1),
     $          Hr5(-1:1,-1:1,-1:1,-1:1,-1:1)
      dimension Hi1(-1:1),Hi2(-1:1,-1:1),Hi3(-1:1,-1:1,-1:1),
     $          Hi4(-1:1,-1:1,-1:1,-1:1),
     $          Hi5(-1:1,-1:1,-1:1,-1:1,-1:1)
      nw = 5
*
      ln2     = 0.69314718055994530942D0
      z2      = 1.6449340668482264365D0
      z3      = 1.2020569031595942854D0
      z4      = 1.0823232337111381915D0
      z5      = 1.0369277551433699263D0
      li4half = 0.51747906167389938633D0
      B4      = -1.7628000870737708641D0
*
      CF=4.0D0/3.0D0
      CA=3.0D0
      TF=1.0D0/2.0D0
*
      x=z
      call hplog5(z,nw,Hc1,Hc2,Hc3,Hc4,Hc5,
     $                       Hr1,Hr2,Hr3,Hr4,Hr5,
     $                       Hi1,Hi2,Hi3,Hi4,Hi5,-1,1)
      w(1)=1.0D0/(1.0D0 - x)
      w(2)=Hr1(0)
      w(3)=Hr1(1)
      w(4)=Hr2(0,1)
      w(5)=Hr3(0,0,1)
      w(6)=Hr3(0,1,1)
      w(7)=Hr4(0,0,0,1)
      w(8)=Hr4(0,0,1,1)
      w(9)=Hr4(0,1,1,1)
      w(10)=as**2
      w(11)=LL*w(1)
      w(12)=w(10)*w(11)
      w(13)=w(10)*w(1)
      w(12)=10.D0/3.D0*w(13) + w(12)
      w(12)=LL*w(12)
      w(12)=28.D0/9.D0*w(13) + w(12)
      w(12)=8.D0/3.D0*w(12)
      w(14)=2*w(11)
      w(10)=w(10)*w(14)
      w(10)=5.D0/3.D0*w(13) + w(10)
      w(10)=8.D0/3.D0*w(10)
      w(13)=4.D0/3.D0*w(13)
      w(14)=as**3
      w(11)=w(11)*w(14)
      w(15)=w(14)*w(1)
      w(16)=23*w(15) - 22.D0/3.D0*w(11)
      w(16)=LL*w(16)
      w(17)=z3*w(15)
      w(16)=1.D0/9.D0*w(16) + 155.D0/81.D0*w(15) + 12*w(17)
      w(18)=2*LL
      w(16)=w(16)*w(18)
      w(19)=w(11) + 10.D0/3.D0*w(15)
      w(19)=w(19)*LL
      w(20)= - 94.D0/27.D0*w(15) - w(19)
      w(20)=z2*w(20)
      w(21)=w(15)*B4
      w(20)=w(21) - w(20)
      w(22)=10807.D0/243.D0 + 74*z4
      w(22)=w(22)*w(15)
      w(22)=w(22) - 299.D0/9.D0*w(17)
      w(16)=1.D0/3.D0*w(22) + w(16) - 8.D0/3.D0*w(20)
      w(16)=4*w(16)
      w(20)=224.D0/3.D0*w(11) + 407.D0/9.D0*w(15) + 20*w(17)
      w(22)=4*w(11)
      w(23)=31.D0/9.D0*w(15)
      w(24)=w(23) + w(22)
      w(24)=w(24)*z2
      w(20)=1.D0/3.D0*w(20) - 2*w(24)
      w(20)=8.D0/3.D0*w(20)
      w(25)=2*w(11)
      w(26)=31.D0/3.D0*w(15)
      w(27)=w(26) + w(25)
      w(27)=LL*w(27)
      w(28)=z2*w(15)
      w(27)= - 14.D0/3.D0*w(28) + 400.D0/27.D0*w(15) + w(27)
      w(27)=8.D0/3.D0*w(27)
      w(23)=w(23) + w(25)
      w(23)=16.D0/9.D0*w(23)
      w(29)=16.D0/27.D0*w(15)
      w(30)=w(15) - 1.D0/3.D0*w(17)
      w(30)=4.D0/3.D0*w(30) + w(28)
      w(30)=8*w(30)
      w(31)= - w(15) - 5*w(28)
      w(31)=32.D0/9.D0*w(31)
      w(32)=w(11) + 10.D0/9.D0*w(15)
      w(33)= - 16*w(32)
      w(34)=112.D0/27.D0*w(15)
      w(35)=128.D0/9.D0*w(28)
      w(36)=8.D0/9.D0*w(15)
      w(37)= - 64.D0/27.D0*w(15)
      w(38)= - w(15) + w(28)
      w(38)=32.D0/9.D0*w(38)
      w(39)=23.D0/9.D0*w(15) + w(25)
      w(39)=16*w(39)
      w(40)=16.D0/3.D0*w(15)
      w(41)= - 8*w(15)
      w(42)=128.D0/9.D0*w(1)
      w(42)=w(42)*w(14)
      w(43)=32.D0/9.D0*w(15)
      w(44)= - 67.D0/9.D0*w(15) - w(22)
      w(44)=16.D0/3.D0*w(44)
      w(45)=320.D0/9.D0*w(15)
      w(46)=24*w(15)
      w(47)=160.D0/9.D0*w(15)
      w(48)= - 32*w(15)
      w(49)=224.D0/9.D0*w(15)
      w(50)=8*w(17)
      w(51)=w(15) - w(50)
      w(51)=5.D0/3.D0*w(51) + w(11)
      w(52)=4*LL
      w(51)=w(51)*w(52)
      w(52)= - 2377.D0/3.D0 - 272*z4
      w(52)=w(52)*w(15)
      w(52)=w(52) + 1172.D0/3.D0*w(17)
      w(21)= - 56.D0/9.D0*w(28) + 32.D0/3.D0*w(21) + 1.D0/9.D0*w(52) + 
     & w(51)
      w(21)=2*w(21)
      w(50)= - 151.D0/3.D0*w(15) - w(50)
      w(51)= - 5.D0/3.D0*w(15) - w(25)
      w(51)=LL*w(51)
      w(24)= - 2.D0/3.D0*w(24) + 2.D0/9.D0*w(50) + w(51)
      w(24)=8*w(24)
      w(50)= - 8.D0/9.D0*w(28) - w(15) - w(22)
      w(50)=4*w(50)
      w(51)=1.D0/9.D0*w(15) + w(11)
      w(51)=32.D0/9.D0*w(51)
      w(52)=256.D0/9.D0*w(17)
      w(19)=w(28) + w(34) + w(19)
      w(19)=64.D0/3.D0*w(19)
      w(53)=128.D0/3.D0*w(32)
      w(54)=256.D0/27.D0*w(15)
      w(55)=128.D0/27.D0*w(15)
      w(28)=7*w(15) - 8*w(28)
      w(28)=16.D0/9.D0*w(28)
      w(22)= - 49.D0/9.D0*w(15) - w(22)
      w(22)=32.D0/3.D0*w(22)
      w(56)= - 32.D0/3.D0*w(15)
      w(57)=256.D0/9.D0*w(15)
      w(58)=107.D0/9.D0*w(15) + 8*w(11)
      w(58)=16.D0/3.D0*w(58)
      w(59)= - 448.D0/9.D0*w(15)
      w(60)= - 16*w(15)
      w(61)=64.D0/3.D0*w(15)
      w(62)=47.D0/27.D0*w(15) - w(17)
      w(63)=LL**2
      w(64)=34.D0/3.D0 + w(63)
      w(64)=LL*w(15)*w(64)
      w(62)=8*w(62) + w(64)
      w(62)=NF*w(62)
      w(25)=5*w(15) + w(25)
      w(25)=LL*w(25)
      w(25)=w(26) + w(25)
      w(18)=w(25)*w(18)
      w(17)=2*w(62) + w(18) - 377.D0/27.D0*w(15) + 28*w(17)
      w(17)=32.D0/27.D0*w(17)
      w(18)=1.D0/9.D0 + w(63)
      w(18)=w(15)*w(18)
      w(11)=2.D0/3.D0*w(15) - 5*w(11)
      w(11)=NF*w(11)
      w(11)=1.D0/3.D0*w(11) + w(18)
      w(11)=64.D0/9.D0*w(11)
      w(18)= - NF*w(32)
      w(18)= - 5.D0/9.D0*w(15) + w(18)
      w(18)=32.D0/9.D0*w(18)
      w(25)=2*w(1)
      w(14)= - NF*w(14)*w(25)
      w(14)= - w(15) + w(14)
      w(14)=32.D0/81.D0*w(14)

      G = TF*CF*w(10)*w(2) + TF*CF*w(12) + TF*CF*w(13)*w(2)**2 + TF*CF*
     & CA*w(16) + TF*CF*CA*w(20)*w(2) + TF*CF*CA*w(23)*w(2)**3 + TF*CF*
     & CA*w(27)*w(2)**2 + TF*CF*CA*w(29)*w(2)**4 + TF*CF*CA*w(30)*w(3)
     &  + TF*CF*CA*w(31)*w(3)*w(2) + TF*CF*CA*w(33)*w(3)*w(2)**2 - TF*
     & CF*CA*w(34)*w(3)*w(2)**3 - TF*CF*CA*w(35)*w(3)**2 + TF*CF*CA*
     & w(36)*w(3)**2*w(2)**2 + TF*CF*CA*w(37)*w(3)**3*w(2) + TF*CF*CA*
     & w(38)*w(4) + TF*CF*CA*w(39)*w(4)*w(2) + TF*CF*CA*w(40)*w(4)*
     & w(2)**2 + TF*CF*CA*w(41)*w(4)*w(3) - TF*CF*CA*w(42)*w(4)*w(3)*
     & w(2) + TF*CF*CA*w(42)*w(4)*w(3)**2 - TF*CF*CA*w(43)*w(4)**2 + TF
     & *CF*CA*w(43)*w(5)*w(2) + TF*CF*CA*w(44)*w(5) + TF*CF*CA*w(45)*
     & w(5)*w(3) + TF*CF*CA*w(46)*w(6) + TF*CF*CA*w(47)*w(6)*w(2) + TF*
     & CF*CA*w(48)*w(6)*w(3) - TF*CF*CA*w(49)*w(8) + TF*CF*CA*w(49)*
     & w(9) + TF*CF**2*w(19)*w(3)*w(2) + TF*CF**2*w(21) + TF*CF**2*
     & w(22)*w(4)*w(2) + TF*CF**2*w(24)*w(2) + TF*CF**2*w(28)*w(4) + TF
     & *CF**2*w(35)*w(3)**2 + TF*CF**2*w(36)*w(2)**4 - TF*CF**2*w(42)*
     & w(4)*w(3)**2
      G = G + TF*CF**2*w(42)*w(5)*w(2) - TF*CF**2*w(42)*w(7) - TF*CF**2
     & *w(43)*w(3)**2*w(2)**2 + TF*CF**2*w(43)*w(4)**2 + TF*CF**2*w(50)
     & *w(2)**2 + TF*CF**2*w(51)*w(2)**3 + TF*CF**2*w(52)*w(3) + TF*
     & CF**2*w(53)*w(3)*w(2)**2 + TF*CF**2*w(54)*w(3)*w(2)**3 + TF*
     & CF**2*w(55)*w(3)**3*w(2) + TF*CF**2*w(56)*w(4)*w(2)**2 + TF*
     & CF**2*w(57)*w(4)*w(3)*w(2) + TF*CF**2*w(58)*w(5) + TF*CF**2*
     & w(59)*w(5)*w(3) + TF*CF**2*w(60)*w(6) - TF*CF**2*w(61)*w(6)*w(2)
     &  + TF*CF**2*w(61)*w(6)*w(3) + TF*CF**2*w(61)*w(8) + TF**2*CF*
     & w(11)*w(2) + TF**2*CF*w(14)*w(2)**3 + TF**2*CF*w(17) + TF**2*CF*
     & w(18)*w(2)**2
*
      OPLUS1 = G
*
      RETURN
      END
      REAL*8 FUNCTION OPLUS2(as,LL,NF,z)
*     ----------------------------------
*
      IMPLICIT NONE
*  
      INTEGER nw
      REAL*8 w(6),G,z,x
      REAL*8 as,LL,NF,z2,z3,z4,B4,ln2,CF,CA,TF,li4half,z5
      complex*16 Hc1,Hc2,Hc3,Hc4,Hc5
      real*8 Hr1,Hr2,Hr3,Hr4,Hr5
      real*8 Hi1,Hi2,Hi3,Hi4,Hi5
      dimension Hc1(-1:1),Hc2(-1:1,-1:1),Hc3(-1:1,-1:1,-1:1),
     $          Hc4(-1:1,-1:1,-1:1,-1:1),
     $          Hc5(-1:1,-1:1,-1:1,-1:1,-1:1)
      dimension Hr1(-1:1),Hr2(-1:1,-1:1),Hr3(-1:1,-1:1,-1:1),
     $          Hr4(-1:1,-1:1,-1:1,-1:1),
     $          Hr5(-1:1,-1:1,-1:1,-1:1,-1:1)
      dimension Hi1(-1:1),Hi2(-1:1,-1:1),Hi3(-1:1,-1:1,-1:1),
     $          Hi4(-1:1,-1:1,-1:1,-1:1),
     $          Hi5(-1:1,-1:1,-1:1,-1:1,-1:1)
      nw = 5
*
      ln2     = 0.69314718055994530942D0
      z2      = 1.6449340668482264365D0
      z3      = 1.2020569031595942854D0
      z4      = 1.0823232337111381915D0
      z5      = 1.0369277551433699263D0
      li4half = 0.51747906167389938633D0
      B4      = -1.7628000870737708641D0
*
      CF=4.0D0/3.0D0
      CA=3.0D0
      TF=1.0D0/2.0D0
*
      x=z
      call hplog5(z,nw,Hc1,Hc2,Hc3,Hc4,Hc5,
     $                       Hr1,Hr2,Hr3,Hr4,Hr5,
     $                       Hi1,Hi2,Hi3,Hi4,Hi5,-1,1)
      w(1)=1.0D0/(1.0D0-x)**2
      w(2)=Hr1(0)
      w(3)=Hr2(0,1)
      w(4)=32.D0/3.D0*w(1)
      w(5)=as**3
      w(4)=w(4)*w(5)
      w(6)= - z2*w(4)
      w(5)= - 4.D0/3.D0*w(1)*w(5)
*
      G = TF*CF*CA*w(4)*w(3) + TF*CF*CA*w(5)*w(2)**2 + TF*CF*CA*w(6)
*
      OPLUS2 = G
*
      RETURN
      END
      REAL*8 FUNCTION OREG(as,LL,NF,z)
*     --------------------------------
*
      IMPLICIT NONE
*  
      INTEGER nw
      REAL*8 w(122),G,z,x
      REAL*8 as,LL,NF,z2,z3,z4,B4,ln2,CF,CA,TF,li4half,z5
      complex*16 Hc1,Hc2,Hc3,Hc4,Hc5
      real*8 Hr1,Hr2,Hr3,Hr4,Hr5
      real*8 Hi1,Hi2,Hi3,Hi4,Hi5
      dimension Hc1(-1:1),Hc2(-1:1,-1:1),Hc3(-1:1,-1:1,-1:1),
     $          Hc4(-1:1,-1:1,-1:1,-1:1),
     $          Hc5(-1:1,-1:1,-1:1,-1:1,-1:1)
      dimension Hr1(-1:1),Hr2(-1:1,-1:1),Hr3(-1:1,-1:1,-1:1),
     $          Hr4(-1:1,-1:1,-1:1,-1:1),
     $          Hr5(-1:1,-1:1,-1:1,-1:1,-1:1)
      dimension Hi1(-1:1),Hi2(-1:1,-1:1),Hi3(-1:1,-1:1,-1:1),
     $          Hi4(-1:1,-1:1,-1:1,-1:1),
     $          Hi5(-1:1,-1:1,-1:1,-1:1,-1:1)
      nw = 5
*
      ln2     = 0.69314718055994530942D0
      z2      = 1.6449340668482264365D0
      z3      = 1.2020569031595942854D0
      z4      = 1.0823232337111381915D0
      z5      = 1.0369277551433699263D0
      li4half = 0.51747906167389938633D0
      B4      = -1.7628000870737708641D0
*
      CF=4.0D0/3.0D0
      CA=3.0D0
      TF=1.0D0/2.0D0
*
      x=z
      call hplog5(z,nw,Hc1,Hc2,Hc3,Hc4,Hc5,
     $                       Hr1,Hr2,Hr3,Hr4,Hr5,
     $                       Hi1,Hi2,Hi3,Hi4,Hi5,-1,1)
*
      w(1)=1.0D0/(1.0D0 + x)
      w(2)=w(1)/3.0D0
      w(3)=w(1)/9.0D0
      w(4)=w(1)/81.0D0
      w(5)=Hr1(-1)
      w(6)=w(1)/27.0D0
      w(7)=Hr1(0)
      w(8)=Hr2(0,-1)
      w(9)=Hr3(0,-1,-1)
      w(10)=Hr3(0,0,-1)
      w(11)=Hr3(0,0,1)
      w(12)=Hr2(0,1)
      w(13)=Hr3(0,1,1)
      w(14)=Hr1(1)
      w(15)=Hr4(0,-1,-1,-1)
      w(16)=Hr3(0,-1,1)
      w(17)=Hr4(0,-1,1,1)
      w(18)=Hr4(0,0,-1,-1)
      w(19)=Hr4(0,0,-1,1)
      w(20)=Hr4(0,0,0,-1)
      w(21)=Hr4(0,0,0,1)
      w(22)=Hr4(0,0,1,-1)
      w(23)=Hr4(0,0,1,1)
      w(24)=Hr3(0,1,-1)
      w(25)=Hr4(0,1,-1,1)
      w(26)=Hr4(0,1,1,-1)
      w(27)=Hr4(0,1,1,1)
      w(28)=11*x
      w(29)=w(28) - 1
      w(30)=x + 1
      w(31)=w(30)*LL
      w(32)= - 2.D0/3.D0*w(29) - w(31)
      w(32)=LL*w(32)
      w(33)=11 - 67*x
      w(32)=1.D0/9.D0*w(33) + w(32)
      w(33)=as**2
      w(34)=4.D0/3.D0*w(33)
      w(32)=w(32)*w(34)
      w(35)=2*LL
      w(36)=w(35)*w(30)
      w(37)= - 1.D0/3.D0*w(29) - w(36)
      w(34)=w(37)*w(34)
      w(37)=2.D0/3.D0*w(30)
      w(33)= - w(33)*w(37)
      w(38)=4267 - 4577*x
      w(39)=22.D0/3.D0*w(31) + 37 - 83*x
      w(39)=LL*w(39)
      w(38)=1.D0/9.D0*w(38) + w(39)
      w(38)=LL*w(38)
      w(39)=w(30)*B4
      w(40)=86681 - 108295*x
      w(38)=2.D0/3.D0*w(38) + 1.D0/243.D0*w(40) + 8*w(39)
      w(40)=1 + 3*x
      w(40)=w(40)*x
      w(40)=w(40) + 3
      w(41)=32*w(3)
      w(40)=w(40)*w(41)
      w(41)=x**2
      w(41)=w(41) + 1
      w(42)=w(41)*LL
      w(43)=w(1)*w(42)
      w(40)=w(40) + 8*w(43)
      w(43)=797 + 209*x
      w(43)= - 24*w(31) + 1.D0/27.D0*w(43) + w(40)
      w(43)=z3*w(43)
      w(44)=w(41)*w(2)
      w(45)=1.D0/3.D0*w(30)
      w(46)=w(45) - w(44)
      w(47)=w(46)*LL
      w(48)=w(41)*w(3)
      w(49)=10*w(48)
      w(50)=13*x
      w(51)=1 + w(50)
      w(51)=w(47) + 1.D0/9.D0*w(51) - w(49)
      w(51)=LL*w(51)
      w(52)=19*x
      w(53)=w(52) - 18
      w(53)=w(53)*x
      w(53)=w(53) + 19
      w(54)=4*w(4)
      w(53)=w(53)*w(54)
      w(54)= - 113 + 250*x
      w(51)=w(51) + 1.D0/81.D0*w(54) - w(53)
      w(51)=z2*w(51)
      w(54)=7*w(44)
      w(55)=65*x
      w(56)= - 37 - w(55)
      w(56)=1.D0/3.D0*w(56) - w(54)
      w(56)=z4*w(56)
      w(38)=8*w(51) + w(43) + 1.D0/3.D0*w(38) + 2*w(56)
      w(43)=as**3
      w(51)=2*w(43)
      w(38)=w(38)*w(51)
      w(56)=29*x
      w(57)=w(56) + 18
      w(57)=w(57)*x
      w(57)=w(57) + 29
      w(57)=w(57)*w(6)
      w(42)=w(2)*w(42)
      w(57)=w(57) + 2*w(42)
      w(57)=w(57)*z2
      w(58)=4*w(3)
      w(59)=w(41)*w(58)
      w(60)=w(59)*z3
      w(57)=w(57) - w(60)
      w(60)=32*w(43)
      w(61)= - w(57)*w(60)
      w(62)=w(41)*w(43)
      w(63)=w(3)*w(62)
      w(64)=32*w(63)
      w(65)= - z2*w(64)
      w(37)=w(37) + w(44)
      w(37)=w(37)*w(35)
      w(66)=w(52) + 18
      w(66)=w(66)*x
      w(66)=w(66) + 19
      w(67)=w(66)*w(6)
      w(68)= - 32 + 25*x
      w(37)=2*w(67) + 1.D0/27.D0*w(68) + w(37)
      w(68)=2*z2
      w(37)=w(37)*w(68)
      w(56)=109 - w(56)
      w(56)=1.D0/9.D0*w(56) + w(36)
      w(69)=4*LL
      w(56)=w(56)*w(69)
      w(70)=2807 - 995*x
      w(56)=1.D0/27.D0*w(70) + w(56)
      w(50)= - 5 + w(50)
      w(50)=1.D0/9.D0*w(50) - w(48)
      w(70)=4*z3
      w(50)=w(50)*w(70)
      w(37)=w(37) + 1.D0/3.D0*w(56) + w(50)
      w(50)=4*w(43)
      w(37)=w(37)*w(50)
      w(56)=4*x
      w(71)=w(56) + 3
      w(71)=w(71)*x
      w(71)=w(71) + 4
      w(58)=w(71)*w(58)
      w(58)=w(58) + w(42)
      w(58)=w(58)*LL
      w(72)=174 + 199*x
      w(72)=w(72)*x
      w(72)=w(72) + 199
      w(72)=w(72)*w(4)
      w(58)=w(72) + w(58)
      w(72)=w(48)*z2
      w(72)=w(58) + w(72)
      w(73)= - w(72)*w(60)
      w(74)=w(30)*w(43)
      w(75)=32.D0/9.D0*w(74)
      w(41)=w(41)*w(6)
      w(76)=64*w(43)
      w(77)=w(76)*w(41)
      w(78)= - w(46)*w(35)
      w(79)= - 13 - w(52)
      w(80)=2*w(66)
      w(81)=w(3)*w(80)
      w(78)=w(78) + 1.D0/9.D0*w(79) + w(81)
      w(78)=LL*w(78)
      w(79)=x + 7
      w(81)=2*w(48)
      w(82)=1.D0/9.D0*w(79) + w(81)
      w(68)=w(82)*w(68)
      w(82)=594 + 521*x
      w(82)=w(82)*x
      w(82)=w(82) + 521
      w(82)=w(82)*w(4)
      w(83)=65 - 268*x
      w(68)=w(68) + w(78) + 1.D0/81.D0*w(83) + w(82)
      w(68)=w(68)*w(50)
      w(78)=w(67) + w(42)
      w(83)=16*w(43)
      w(84)= - w(78)*w(83)
      w(85)=16*w(63)
      w(86)=1.D0/9.D0*w(30)
      w(87)= - w(86) + w(48)
      w(87)=w(87)*w(35)
      w(80)=w(80)*w(4)
      w(88)= - 13 - 16*x
      w(87)=w(87) + 1.D0/81.D0*w(88) + w(80)
      w(88)=8*w(43)
      w(87)=w(87)*w(88)
      w(89)= - w(60)*w(41)
      w(90)= - 1.D0/27.D0*w(30) + w(41)
      w(90)=w(90)*w(88)
      w(91)=w(58)*w(60)
      w(92)=64.D0/9.D0*w(74)
      w(93)=w(48)*w(76)
      w(94)=128*w(3)
      w(62)=w(94)*w(62)
      w(94)=w(78)*w(60)
      w(46)=w(46)*w(69)
      w(95)=4*w(6)
      w(96)= - w(66)*w(95)
      w(97)=88 + 85*x
      w(46)=w(96) + 1.D0/27.D0*w(97) + w(46)
      w(46)=w(46)*w(88)
      w(96)=7*x
      w(97)=w(96) + 1
      w(98)=16.D0/9.D0*w(43)
      w(99)=w(97)*w(98)
      w(100)= - 2 - 143*x
      w(101)=z2*w(97)
      w(100)= - 2.D0/3.D0*w(101) + 1.D0/9.D0*w(100) - w(36)
      w(101)=8.D0/3.D0*w(43)
      w(100)=w(100)*w(101)
      w(71)=w(95)*w(71)
      w(71)=w(71) + w(42)
      w(95)=w(71)*w(76)
      w(102)= - 2 - 13.D0/3.D0*x
      w(102)=1.D0/3.D0*w(102) - w(31)
      w(102)=w(102)*w(83)
      w(103)= - 8.D0/3.D0*w(74)
      w(79)= - w(79)*w(98)
      w(104)= - 5 - w(28)
      w(104)=w(104)*w(98)
      w(105)=x - 1
      w(106)=w(105)*w(69)
      w(107)=w(30)*z3
      w(55)=29 - w(55)
      w(108)= - 14.D0/3.D0 - x
      w(108)=z2*w(108)
      w(55)=w(108) + 2.D0/3.D0*w(107) + 1.D0/9.D0*w(55) + w(106)
      w(55)=w(55)*w(101)
      w(106)=w(30)*z2
      w(108)=10.D0/9.D0*w(106) + 4.D0/9.D0 + x
      w(108)=w(108)*w(88)
      w(109)=1 + 14.D0/3.D0*x
      w(109)=1.D0/3.D0*w(109) + w(31)
      w(109)=w(109)*w(88)
      w(110)=56.D0/27.D0*w(74)
      w(111)= - 160.D0/9.D0*w(74)
      w(112)=8.D0/9.D0*w(43)
      w(113)=20 + w(28)
      w(113)=w(113)*w(112)
      w(114)=16*w(74)
      w(115)=16*w(106) + 46 - 43*x
      w(115)=4.D0/9.D0*w(115)*w(43)
      w(116)=2*x
      w(117)= - 5 - w(116)
      w(112)=w(117)*w(112)
      w(117)= - 4.D0/9.D0*w(74)
      w(118)=32.D0/27.D0*w(74)
      w(119)=2.D0/3.D0*x - w(48)
      w(119)=w(119)*w(76)
      w(120)=5*x
      w(121)=7 - w(120)
      w(121)=1.D0/9.D0*w(121) + w(59)
      w(83)=w(121)*w(83)
      w(121)= - 112.D0/9.D0*w(74)
      w(122)= - 485 - 101*x
      w(40)=40.D0/3.D0*w(31) + 1.D0/27.D0*w(122) - w(40)
      w(40)=w(40)*w(70)
      w(42)=w(49) + w(42)
      w(42)=LL*w(42)
      w(49)=8 - w(96)
      w(42)=w(42) + 1.D0/9.D0*w(49) + w(53)
      w(42)=z2*w(42)
      w(49)= - 1957 + 10625.D0/3.D0*x
      w(39)=1.D0/3.D0*w(49) - 32*w(39)
      w(28)= - 13 + w(28)
      w(28)=LL*w(28)
      w(28)=w(28) - 47 + 131.D0/3.D0*x
      w(28)=w(28)*w(69)
      w(49)=34.D0/9.D0*w(30) + w(54)
      w(49)=z4*w(49)
      w(28)=32*w(42) + w(40) + 8*w(49) + 1.D0/3.D0*w(39) + w(28)
      w(28)=w(28)*w(43)
      w(39)=w(57)*w(76)
      w(40)=z2*w(93)
      w(42)= - 1 - w(116)
      w(42)=w(42)*w(69)
      w(49)= - 127 - 119*x
      w(42)=1.D0/3.D0*w(49) + w(42)
      w(42)=LL*w(42)
      w(49)= - 142 - 167*x
      w(42)=7.D0/27.D0*w(49) + w(42)
      w(48)=2.D0/9.D0*w(30) + w(48)
      w(48)=w(48)*w(70)
      w(47)=w(47) - w(67)
      w(49)=5 + 8*x
      w(49)=2.D0/27.D0*w(49) + w(47)
      w(53)=4*z2
      w(49)=w(49)*w(53)
      w(42)=w(49) + 1.D0/3.D0*w(42) + w(48)
      w(42)=w(42)*w(88)
      w(48)=w(72)*w(76)
      w(49)=128*w(43)
      w(54)=w(41)*w(49)
      w(57)= - w(3)*w(66)
      w(57)= - 2.D0/9.D0*w(97) + w(57)
      w(44)= - w(45) - 2*w(44)
      w(44)=LL*w(44)
      w(44)=2*w(57) + w(44)
      w(44)=w(44)*w(35)
      w(57)=w(86) - w(81)
      w(53)=w(57)*w(53)
      w(57)= - 221 - 575*x
      w(44)=w(53) + w(44) + 1.D0/81.D0*w(57) - 2*w(82)
      w(44)=w(44)*w(50)
      w(50)= - 13 - 49*x
      w(50)=1.D0/81.D0*w(50) - w(80)
      w(53)= - 5.D0/9.D0*w(30) - w(59)
      w(53)=LL*w(53)
      w(50)=2*w(50) + w(53)
      w(50)=w(50)*w(88)
      w(41)= - 13.D0/27.D0*w(30) - 8*w(41)
      w(41)=w(41)*w(51)
      w(51)= - w(58)*w(76)
      w(53)=128.D0/9.D0*w(74)
      w(57)=256*w(63)
      w(58)= - w(78)*w(76)
      w(63)= - 7 - w(56)
      w(47)=1.D0/27.D0*w(63) - w(47)
      w(47)=w(47)*w(76)
      w(63)=4*w(31)
      w(66)=82 + 79*x
      w(66)=4.D0/3.D0*w(106) + 1.D0/9.D0*w(66) + w(63)
      w(67)=16.D0/3.D0*w(43)
      w(66)=w(66)*w(67)
      w(49)=w(49)*w(71)
      w(69)=11 + 17*x
      w(69)=1.D0/9.D0*w(69) + w(36)
      w(69)=32.D0/3.D0*w(69)*w(43)
      w(70)=16.D0/3.D0*w(74)
      w(71)=16.D0/9.D0*w(74)
      w(72)=64.D0/9.D0*w(43)
      w(78)= - 2 - w(120)
      w(78)=w(78)*w(72)
      w(80)=32.D0/3.D0*w(74)
      w(82)= - 8.D0/3.D0*z2 - 16*LL
      w(82)=w(105)*w(82)
      w(88)=160 - 151*x
      w(82)= - 16.D0/3.D0*w(107) + 1.D0/9.D0*w(88) + w(82)
      w(82)=w(82)*w(101)
      w(56)= - 1 - w(56)
      w(56)=4.D0/3.D0*w(56) - w(31)
      w(56)=w(56)*w(35)
      w(88)= - 194 - 263*x
      w(56)= - 2*w(106) + 1.D0/27.D0*w(88) + w(56)
      w(56)=w(56)*w(67)
      w(88)= - 19 - 61*x
      w(63)=1.D0/9.D0*w(88) - w(63)
      w(63)=w(63)*w(67)
      w(67)= - 128.D0/27.D0*w(74)
      w(88)=224.D0/9.D0*w(74)
      w(72)=w(105)*w(72)
      w(52)= - 4*w(106) - 20 + w(52)
      w(52)=w(52)*w(98)
      w(96)=32.D0/9.D0*w(43)
      w(97)= - w(105)*w(96)
      w(101)= - 64.D0/27.D0*w(74)
      w(81)=w(86) + w(81)
      w(76)=w(81)*w(76)
      w(45)= - w(45) - w(59)
      w(45)=w(45)*w(60)
      w(59)=w(30)*LL**2
      w(60)= - 73 + w(120)
      w(60)=1.D0/3.D0*w(60) - w(59)
      w(60)=LL*w(60)
      w(81)= - 215 - 161*x
      w(60)=8*w(107) + 2.D0/27.D0*w(81) + w(60)
      w(81)=2*NF
      w(60)=w(60)*w(81)
      w(36)= - w(36) - w(29)
      w(36)=LL*w(36)
      w(30)= - 31.D0/3.D0*w(30) + w(36)
      w(30)=w(30)*w(35)
      w(35)=323 + 431*x
      w(30)=w(60) - 28*w(107) + 1.D0/27.D0*w(35) + w(30)
      w(30)=16.D0/27.D0*w(30)*w(43)
      w(35)=w(116) - 7.D0/3.D0
      w(36)=LL*w(29)
      w(36)=4*w(35) + w(36)
      w(36)=NF*w(36)
      w(35)=1.D0/3.D0*w(36) + 2.D0/3.D0*w(35) - w(59)
      w(35)=w(35)*w(96)
      w(31)=2.D0/9.D0*w(29) + w(31)
      w(31)=NF*w(31)
      w(29)=1.D0/9.D0*w(29) + w(31)
      w(29)=w(29)*w(98)
      w(31)=w(81) + 1
      w(31)=16.D0/81.D0*w(31)*w(74)

      G = TF*CF*w(32) + TF*CF*w(33)*w(7)**2 + TF*CF*w(34)*w(7) + TF*CF*
     & CA*w(37)*w(7) + TF*CF*CA*w(38) + TF*CF*CA*w(46)*w(11) + TF*CF*CA
     & *w(55)*w(14) + TF*CF*CA*w(61)*w(5) - TF*CF*CA*w(62)*w(9)*w(5) - 
     & TF*CF*CA*w(62)*w(13)*w(5) + TF*CF*CA*w(62)*w(15) + TF*CF*CA*
     & w(62)*w(17) + TF*CF*CA*w(62)*w(25) + TF*CF*CA*w(62)*w(26) + TF*
     & CF*CA*w(65)*w(5)**2 + TF*CF*CA*w(68)*w(7)**2 + TF*CF*CA*w(73)*
     & w(7)*w(5) + TF*CF*CA*w(75)*w(7)*w(5)**2 - TF*CF*CA*w(77)*w(7)*
     & w(5)**3 + TF*CF*CA*w(79)*w(13) + TF*CF*CA*w(83)*w(23) + TF*CF*CA
     & *w(84)*w(7)**2*w(5) + TF*CF*CA*w(85)*w(7)**2*w(5)**2 + TF*CF*CA*
     & w(87)*w(7)**3 + TF*CF*CA*w(89)*w(7)**3*w(5) + TF*CF*CA*w(90)*
     & w(7)**4 + TF*CF*CA*w(91)*w(8) - TF*CF*CA*w(92)*w(8)*w(5) + TF*CF
     & *CA*w(92)*w(9) + TF*CF*CA*w(92)*w(14)*w(12)*w(7) - TF*CF*CA*
     & w(92)*w(14)**2*w(12) + TF*CF*CA*w(93)*w(8)*w(5)**2 - TF*CF*CA*
     & w(93)*w(10)*w(5) + TF*CF*CA*w(93)*w(11)*w(5) + TF*CF*CA*w(93)*
     & w(18) - TF*CF*CA*w(93)*w(19) + TF*CF*CA*w(93)*w(20) - TF*CF*CA*
     & w(93)*w(22)
      G = G + TF*CF*CA*w(94)*w(10) + TF*CF*CA*w(95)*w(12)*w(5) - TF*CF*
     & CA*w(95)*w(16) - TF*CF*CA*w(95)*w(24) - TF*CF*CA*w(99)*w(11)*
     & w(7) + TF*CF*CA*w(99)*w(12)**2 + TF*CF*CA*w(100)*w(12) + TF*CF*
     & CA*w(102)*w(12)*w(7) + TF*CF*CA*w(103)*w(12)*w(7)**2 + TF*CF*CA*
     & w(104)*w(13)*w(7) + TF*CF*CA*w(108)*w(14)*w(7) + TF*CF*CA*w(109)
     & *w(14)*w(7)**2 + TF*CF*CA*w(110)*w(14)*w(7)**3 + TF*CF*CA*w(111)
     & *w(14)*w(11) + TF*CF*CA*w(112)*w(14)**2*w(7) + TF*CF*CA*w(113)*
     & w(14)*w(12) + TF*CF*CA*w(114)*w(14)*w(13) + TF*CF*CA*w(115)*
     & w(14)**2 + TF*CF*CA*w(117)*w(14)**2*w(7)**2 + TF*CF*CA*w(118)*
     & w(14)**3*w(7) + TF*CF*CA*w(119)*w(21) + TF*CF*CA*w(121)*w(27) + 
     & TF*CF**2*w(28) + TF*CF**2*w(39)*w(5) + TF*CF**2*w(40)*w(5)**2 + 
     & TF*CF**2*w(41)*w(7)**4 + TF*CF**2*w(42)*w(7) + TF*CF**2*w(44)*
     & w(7)**2 + TF*CF**2*w(45)*w(23) + TF*CF**2*w(47)*w(11) + TF*CF**2
     & *w(48)*w(7)*w(5) - TF*CF**2*w(49)*w(12)*w(5) + TF*CF**2*w(49)*
     & w(16) + TF*CF**2*w(49)*w(24) + TF*CF**2*w(50)*w(7)**3 + TF*CF**2
     & *w(51)*w(8)
      G = G + TF*CF**2*w(52)*w(14)**2 + TF*CF**2*w(53)*w(8)*w(5) - TF*
     & CF**2*w(53)*w(9) - TF*CF**2*w(53)*w(14)*w(12)*w(7) + TF*CF**2*
     & w(54)*w(7)*w(5)**3 + TF*CF**2*w(56)*w(14)*w(7) + TF*CF**2*w(57)*
     & w(9)*w(5) + TF*CF**2*w(57)*w(13)*w(5) - TF*CF**2*w(57)*w(15) - 
     & TF*CF**2*w(57)*w(17) - TF*CF**2*w(57)*w(25) - TF*CF**2*w(57)*
     & w(26) + TF*CF**2*w(58)*w(10) - TF*CF**2*w(62)*w(8)*w(5)**2 + TF*
     & CF**2*w(62)*w(10)*w(5) - TF*CF**2*w(62)*w(11)*w(5) - TF*CF**2*
     & w(62)*w(18) + TF*CF**2*w(62)*w(19) - TF*CF**2*w(62)*w(20) + TF*
     & CF**2*w(62)*w(22) + TF*CF**2*w(63)*w(14)*w(7)**2 - TF*CF**2*
     & w(64)*w(7)**2*w(5)**2 + TF*CF**2*w(66)*w(12) + TF*CF**2*w(67)*
     & w(14)*w(7)**3 + TF*CF**2*w(69)*w(12)*w(7) + TF*CF**2*w(70)*w(12)
     & *w(7)**2 - TF*CF**2*w(71)*w(12)**2 + TF*CF**2*w(71)*w(14)**2*
     & w(7)**2 + TF*CF**2*w(72)*w(14)*w(12) + TF*CF**2*w(76)*w(21) + TF
     & *CF**2*w(77)*w(7)**3*w(5) + TF*CF**2*w(78)*w(13) + TF*CF**2*
     & w(80)*w(13)*w(7) - TF*CF**2*w(80)*w(14)*w(13) + TF*CF**2*w(82)*
     & w(14)
      G = G + TF*CF**2*w(88)*w(14)*w(11) - TF*CF**2*w(92)*w(7)*w(5)**2
     &  - TF*CF**2*w(92)*w(11)*w(7) + TF*CF**2*w(92)*w(14)**2*w(12) + 
     & TF*CF**2*w(94)*w(7)**2*w(5) + TF*CF**2*w(97)*w(14)**2*w(7) + TF*
     & CF**2*w(101)*w(14)**3*w(7) + TF**2*CF*w(29)*w(7)**2 + TF**2*CF*
     & w(30) + TF**2*CF*w(31)*w(7)**3 + TF**2*CF*w(35)*w(7)
*
      OREG = G
*
      RETURN
      END
      REAL*8 FUNCTION MOMREG(as,LL,NF,N)
*     ----------------------------------
*
      IMPLICIT NONE
      REAL*8 A,B,EPS,EST,as,LL!,MOREG!,DAIND
      REAL*8 AAS,LLL,NNF,NF
      INTEGER N,KEY,MAX,KOU,NN
!      EXTERNAL MOREG
      COMMON/PAR/ aas, LLL, NNF, NN
*
      aas=as
      LLL=LL
      NNF=NF
      NN=N
      A=0.0D0
      B=1.0D0
      EPS=1d-8 ! AK+GPS mod from original 1.0D-12
      KEY=2
      MAX=10000
*
      MOMREG=DAIND(A,B,MOREG,EPS,KEY,MAX,KOU,EST)
*
      RETURN
      END
      REAL*8 FUNCTION MOMPLUS(as,LL,NF,N)
*     -----------------------------------
*
      IMPLICIT NONE
      REAL*8 A,B,EPS,EST,as,LL!,MOPLUS!,DAIND
      REAL*8 AAS,LLL,NNF,NF
      INTEGER N,KEY,MAX,KOU,NN
!      EXTERNAL MOPLUS
      COMMON/PAR/ aas, LLL, NNF, NN
*
      aas=as
      LLL=LL
      NNF=NF
      NN=N
      A=0.0D0
      B=1.0D0
      EPS=1d-8 ! AK+GPS mod from original 1.0D-12
      KEY=2
      MAX=10000
*
      MOMPLUS=DAIND(A,B,MOPLUS,EPS,KEY,MAX,KOU,EST)
*
      RETURN
      END
      REAL*8 FUNCTION MOREG(Y)
*     ------------------------
*
      IMPLICIT NONE
*
      REAL*8 as,LL,NF,Y,aas,LLL,NNF!,OREG
      INTEGER N,NN
      COMMON/PAR/ aas, LLL, NNF, NN
      N=NN
      as=aas
      LL=LLL
      NF=NNF
*
      MOREG=OREG(as,LL,NF,Y)*Y**(N-1)
*
      RETURN
      END
      REAL*8 FUNCTION MOPLUS(Y)
*     -------------------------
*
      IMPLICIT NONE
*
      REAL*8 as,LL,NF,Y,aas,LLL,NNF!,OPLUS1,OPLUS2
      INTEGER N,NN
      COMMON/PAR/ aas, LLL, NNF, NN
      N=NN
      as=aas
      LL=LLL
      NF=NNF
*
      MOPLUS=(OPLUS1(as,LL,NF,Y)+OPLUS2(as,LL,NF,Y))*(Y**(N-1)-1)
*
      RETURN
      END
!      include 'hplog5.f'
!      include 'daind_fake.f'

      end module
