!  $Id: xpij2e.f,v 1.2 2004/09/18 14:39:34 salam Exp $ 
!  Automatically generated from f77 file, with inclusion of modules
!  and the placement inside a module (and some other stuff).
      module xpij2e
      use qcd, only: cf, ca, A3G => mvv_A3G
      character(len=*), parameter :: name_xpij2 = "xpij2e"
      contains
!                                                                       
! ..File: xpij2e.f                                                      
!                                                                       
!                                                                       
! ..The exact 3-loop MS(bar) singlet splitting functions  P_ij^(2)      
!    for the evolution of unpolarized partons densities, mu_r = mu_f.   
!    The expansion parameter is alpha_s/(4 pi).                         
!                                                                       
! ..The distributions (in the mathematical sense) are given as in eq.   
!    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.  
!    The name-endings A, B, and C of the functions below correspond to  
!    the kernel superscripts [2], [3], and [1] in that equation.        
!                                                                       
! ..The code uses the package of Gehrmann and Remiddi for the harmonic  
!    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296.   
!                                                                       
! ..References: S. Moch, J. Vermaseren and A. Vogt,                     
!               hep-ph/0403192 (to appear in Nucl. Phys. B)             
!               A. Vogt, S. Moch and J. Vermaseren,                     
!               hep-ph/0404111 (submitted to Nucl. Phys. B)             
!                                                                       
! ===================================================================== 
!                                                                       
!                                                                       
! ..The (regular) pure-singlet splitting functions P_ps^(2).            
!    P_qq^(2) is obtained by adding the non-singlet quantity P_NS^(2)+. 
!                                                                       
       FUNCTION X2PSA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0 )                   
!                                                                       
! ...Colour factors and an abbreviation                                 
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
       DX = 1.D0/X 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!                                                                       
      gqqps2 =                                                          &
     &  + nf*cf*ca * ( 484.D0/3.D0 - 2528.D0/3.D0*x + 82232.D0/81.D0*   &
     &    x**2 - 27044.D0/81.D0*dx - 16.D0/3.D0*z3 + 248.D0/3.D0*z3*x   &
     &     - 416.D0/3.D0*z3*x**2 + 96.D0*z3*dx - 1916.D0/9.D0*z2 + 904.D&
     &    0/9.D0*z2*x + 448.D0/9.D0*z2*x**2 + 512.D0/9.D0*z2*dx + 428.D0&
     &    /5.D0*z2**2 + 468.D0/5.D0*z2**2*x + 40.D0*Hr1(-1)*z2 + 40.D0* &
     &    Hr1(-1)*z2*x + 32.D0/3.D0*Hr1(-1)*z2*x**2 + 32.D0/3.D0*Hr1(-1 &
     &    )*z2*dx - 14260.D0/27.D0*Hr1(0) - 13216.D0/27.D0*Hr1(0)*x -   &
     &    18392.D0/27.D0*Hr1(0)*x**2 - 896.D0/27.D0*Hr1(0)*dx + 208.D0* &
     &    Hr1(0)*z3 + 144.D0*Hr1(0)*z3*x - 236.D0/3.D0*Hr1(0)*z2 + 28.D0&
     &    /3.D0*Hr1(0)*z2*x - 32.D0/3.D0*Hr1(0)*z2*x**2 + 1748.D0/9.D0* &
     &    Hr1(1) - 2912.D0/9.D0*Hr1(1)*x + 1208.D0/27.D0*Hr1(1)*x**2 +  &
     &    2284.D0/27.D0*Hr1(1)*dx + 8.D0*Hr1(1)*z2 - 8.D0*Hr1(1)*z2*x   &
     &     - 32.D0/3.D0*Hr1(1)*z2*x**2 + 32.D0/3.D0*Hr1(1)*z2*dx + 256.D&
     &    0/3.D0*Hr2(-1,0) + 544.D0/3.D0*Hr2(-1,0)*x + 1696.D0/9.D0*    &
     &    Hr2(-1,0)*x**2 + 832.D0/9.D0*Hr2(-1,0)*dx + 16.D0*Hr2(0,-1)*  &
     &    z2 )                                                          
      gqqps2 = gqqps2 + nf*cf*ca * (  - 16.D0*Hr2(0,-1)*z2*x + 1076.D0/ &
     &    9.D0*Hr2(0,0) - 1588.D0/9.D0*Hr2(0,0)*x + 664.D0/3.D0*Hr2(0,0 &
     &    )*x**2 + 8.D0*Hr2(0,0)*z2 - 8.D0*Hr2(0,0)*z2*x + 1916.D0/9.D0 &
     &    *Hr2(0,1) + 728.D0/9.D0*Hr2(0,1)*x - 448.D0/9.D0*Hr2(0,1)*    &
     &    x**2 + 320.D0/9.D0*Hr2(0,1)*dx + 16.D0*Hr2(0,1)*z2 + 16.D0*   &
     &    Hr2(0,1)*z2*x + 104.D0/3.D0*Hr2(1,0) + 40.D0/3.D0*Hr2(1,0)*x  &
     &     - 72.D0*Hr2(1,0)*x**2 + 24.D0*Hr2(1,0)*dx - 12.D0*Hr2(1,1)   &
     &     + 12.D0*Hr2(1,1)*x + 16.D0/9.D0*Hr2(1,1)*x**2 - 16.D0/9.D0*  &
     &    Hr2(1,1)*dx + 16.D0*Hr3(-1,-1,0) + 16.D0*Hr3(-1,-1,0)*x - 64.D&
     &    0/3.D0*Hr3(-1,-1,0)*x**2 - 64.D0/3.D0*Hr3(-1,-1,0)*dx + 8.D0* &
     &    Hr3(-1,0,0) + 8.D0*Hr3(-1,0,0)*x - 128.D0/3.D0*Hr3(-1,0,0)*   &
     &    x**2 - 128.D0/3.D0*Hr3(-1,0,0)*dx - 32.D0*Hr3(-1,0,1) - 32.D0 &
     &    *Hr3(-1,0,1)*x - 64.D0/3.D0*Hr3(-1,0,1)*x**2 - 64.D0/3.D0*    &
     &    Hr3(-1,0,1)*dx - 24.D0*Hr3(0,-1,0) + 104.D0*Hr3(0,-1,0)*x -   &
     &    64.D0*Hr3(0,-1,0)*x**2 - 232.D0/3.D0*Hr3(0,0,0) + 248.D0/3.D0 &
     &    *Hr3(0,0,0)*x )                                               
      gqqps2 = gqqps2 + nf*cf*ca * ( 236.D0/3.D0*Hr3(0,0,1) + 284.D0/3.D&
     &    0*Hr3(0,0,1)*x + 32.D0/3.D0*Hr3(0,0,1)*x**2 + 16.D0*Hr3(0,1,0 &
     &    ) + 40.D0*Hr3(0,1,0)*x + 32.D0/3.D0*Hr3(0,1,0)*x**2 - 88.D0/3.&
     &    D0*Hr3(0,1,1) - 136.D0/3.D0*Hr3(0,1,1)*x - 32.D0/3.D0*Hr3(0,1 &
     &    ,1)*x**2 + 32.D0/3.D0*Hr3(0,1,1)*dx - 36.D0*Hr3(1,0,0) + 36.D0&
     &    *Hr3(1,0,0)*x + 32.D0*Hr3(1,0,0)*x**2 - 32.D0*Hr3(1,0,0)*dx   &
     &     + 16.D0*Hr3(1,1,0) - 16.D0*Hr3(1,1,0)*x - 64.D0/3.D0*Hr3(1,1 &
     &    ,0)*x**2 + 64.D0/3.D0*Hr3(1,1,0)*dx + 16.D0*Hr3(1,1,1) - 16.D0&
     &    *Hr3(1,1,1)*x - 64.D0/3.D0*Hr3(1,1,1)*x**2 + 64.D0/3.D0*Hr3(1 &
     &    ,1,1)*dx + 32.D0*Hr4(0,-1,-1,0) - 32.D0*Hr4(0,-1,-1,0)*x + 48.&
     &    D0*Hr4(0,-1,0,0) - 48.D0*Hr4(0,-1,0,0)*x + 80.D0*Hr4(0,0,-1,0 &
     &    ) - 16.D0*Hr4(0,0,-1,0)*x + 64.D0*Hr4(0,0,0,0) - 48.D0*Hr4(0, &
     &    0,0,0)*x - 8.D0*Hr4(0,0,0,1) - 8.D0*Hr4(0,0,0,1)*x + 16.D0*   &
     &    Hr4(0,0,1,1) + 16.D0*Hr4(0,0,1,1)*x - 56.D0*Hr4(0,1,0,0) - 56.&
     &    D0*Hr4(0,1,0,0)*x + 32.D0*Hr4(0,1,1,0) + 32.D0*Hr4(0,1,1,0)*x &
     &     + 32.D0*Hr4(0,1,1,1) )                                       
      gqqps2 = gqqps2 + nf*cf*ca * ( 32.D0*Hr4(0,1,1,1)*x ) 
      gqqps2 = gqqps2 + nf*cf**2 * ( 2530.D0/27.D0 + 3338.D0/27.D0*x -  &
     &    872.D0/3.D0*x**2 + 220.D0/3.D0*dx + 160.D0*z3*x + 256.D0/3.D0 &
     &    *z3*x**2 - 64.D0*z3*dx + 272.D0*z2 + 20.D0*z2*x + 448.D0/9.D0 &
     &    *z2*x**2 - 296.D0/5.D0*z2**2 - 296.D0/5.D0*z2**2*x + 1510.D0/ &
     &    9.D0*Hr1(0) + 5486.D0/9.D0*Hr1(0)*x - 104.D0/27.D0*Hr1(0)*    &
     &    x**2 - 112.D0*Hr1(0)*z3 - 112.D0*Hr1(0)*z3*x + 32.D0*Hr1(0)*  &
     &    z2 - 48.D0*Hr1(0)*z2*x - 256.D0/3.D0*Hr1(0)*z2*x**2 - 664.D0/ &
     &    3.D0*Hr1(1) + 1004.D0/3.D0*Hr1(1)*x - 968.D0/27.D0*Hr1(1)*    &
     &    x**2 - 2092.D0/27.D0*Hr1(1)*dx - 512.D0/3.D0*Hr2(0,0) + 212.D0&
     &    /3.D0*Hr2(0,0)*x - 352.D0/3.D0*Hr2(0,0)*x**2 + 96.D0*Hr2(0,0) &
     &    *z2 + 96.D0*Hr2(0,0)*z2*x - 272.D0*Hr2(0,1) - 20.D0*Hr2(0,1)* &
     &    x - 448.D0/9.D0*Hr2(0,1)*x**2 - 128.D0/3.D0*Hr2(1,0) + 272.D0/&
     &    3.D0*Hr2(1,0)*x - 800.D0/9.D0*Hr2(1,0)*x**2 + 368.D0/9.D0*    &
     &    Hr2(1,0)*dx + 28.D0/3.D0*Hr2(1,1) - 28.D0/3.D0*Hr2(1,1)*x -   &
     &    64.D0/3.D0*Hr2(1,1)*x**2 + 64.D0/3.D0*Hr2(1,1)*dx + 24.D0*    &
     &    Hr3(0,0,0) )                                                  
      gqqps2 = gqqps2 + nf*cf**2 * ( 40.D0*Hr3(0,0,0)*x + 352.D0/3.D0*  &
     &    Hr3(0,0,0)*x**2 - 32.D0*Hr3(0,0,1) + 48.D0*Hr3(0,0,1)*x + 256.&
     &    D0/3.D0*Hr3(0,0,1)*x**2 + 32.D0*Hr3(0,1,0) + 112.D0*Hr3(0,1,0 &
     &    )*x + 64.D0*Hr3(0,1,0)*x**2 + 48.D0*Hr3(0,1,1) + 64.D0*Hr3(0, &
     &    1,1)*x + 64.D0/3.D0*Hr3(0,1,1)*x**2 + 8.D0*Hr3(1,0,0) - 8.D0* &
     &    Hr3(1,0,0)*x - 32.D0/3.D0*Hr3(1,0,0)*x**2 + 32.D0/3.D0*Hr3(1, &
     &    0,0)*dx - 16.D0*Hr3(1,1,0) + 16.D0*Hr3(1,1,0)*x + 64.D0/3.D0* &
     &    Hr3(1,1,0)*x**2 - 64.D0/3.D0*Hr3(1,1,0)*dx - 16.D0*Hr3(1,1,1) &
     &     + 16.D0*Hr3(1,1,1)*x + 64.D0/3.D0*Hr3(1,1,1)*x**2 - 64.D0/3.D&
     &    0*Hr3(1,1,1)*dx - 64.D0*Hr4(0,0,0,0) - 64.D0*Hr4(0,0,0,0)*x   &
     &     - 96.D0*Hr4(0,0,0,1) - 96.D0*Hr4(0,0,0,1)*x - 64.D0*Hr4(0,0, &
     &    1,0) - 64.D0*Hr4(0,0,1,0)*x - 16.D0*Hr4(0,0,1,1) - 16.D0*Hr4( &
     &    0,0,1,1)*x + 16.D0*Hr4(0,1,0,0) + 16.D0*Hr4(0,1,0,0)*x - 32.D0&
     &    *Hr4(0,1,1,0) - 32.D0*Hr4(0,1,1,0)*x - 32.D0*Hr4(0,1,1,1) -   &
     &    32.D0*Hr4(0,1,1,1)*x )                                        
      gqqps2 = gqqps2 + nf2*cf * ( 616.D0/27.D0 - 1480.D0/27.D0*x +     &
     &    800.D0/27.D0*x**2 + 64.D0/27.D0*dx + 16.D0/3.D0*z3 + 16.D0/3.D&
     &    0*z3*x + 80.D0/9.D0*z2 - 64.D0/9.D0*z2*x - 32.D0/3.D0*z2*x**2 &
     &     + 592.D0/27.D0*Hr1(0) - 560.D0/27.D0*Hr1(0)*x - 304.D0/9.D0* &
     &    Hr1(0)*x**2 + 32.D0/3.D0*Hr1(0)*z2 + 32.D0/3.D0*Hr1(0)*z2*x   &
     &     - 56.D0/3.D0*Hr1(1) + 104.D0/3.D0*Hr1(1)*x - 592.D0/27.D0*   &
     &    Hr1(1)*x**2 + 160.D0/27.D0*Hr1(1)*dx + 232.D0/9.D0*Hr2(0,0)   &
     &     + 232.D0/9.D0*Hr2(0,0)*x - 80.D0/9.D0*Hr2(0,1) + 64.D0/9.D0* &
     &    Hr2(0,1)*x + 32.D0/3.D0*Hr2(0,1)*x**2 + 8.D0/3.D0*Hr2(1,1) -  &
     &    8.D0/3.D0*Hr2(1,1)*x - 32.D0/9.D0*Hr2(1,1)*x**2 + 32.D0/9.D0* &
     &    Hr2(1,1)*dx + 16.D0/3.D0*Hr3(0,0,0) + 16.D0/3.D0*Hr3(0,0,0)*x &
     &     - 32.D0/3.D0*Hr3(0,0,1) - 32.D0/3.D0*Hr3(0,0,1)*x + 16.D0/3.D&
     &    0*Hr3(0,1,1) + 16.D0/3.D0*Hr3(0,1,1)*x )                      
!                                                                       
       X2PSA = GQQPS2 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..The gluon->quark splitting functions P_qg^(2).                      
!                                                                       
       FUNCTION X2QGA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0 )                   
!                                                                       
! ...Colour factors and an abbreviation                                 
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
       DX = 1.D0/X 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!                                                                       
      gqg2 =                                                            &
     &  + nf*ca**2 * ( 10454.D0/27.D0 - 102608.D0/27.D0*x + 103040.D0/  &
     &    27.D0*x**2 - 9404.D0/27.D0*dx + 48.D0*z3 + 1000.D0*z3*x -     &
     &    2768.D0/3.D0*z3*x**2 + 96.D0*z3*dx - 628.D0/3.D0*z2 + 2096.D0/&
     &    9.D0*z2*x - 620.D0/9.D0*z2*x**2 + 512.D0/9.D0*z2*dx + 538.D0/ &
     &    5.D0*z2**2 + 396.D0*z2**2*x + 224.D0/5.D0*z2**2*x**2 - 40.D0* &
     &    Hr1(-1)*z3 - 80.D0*Hr1(-1)*z3*x - 80.D0*Hr1(-1)*z3*x**2 + 120.&
     &    D0*Hr1(-1)*z2 + 88.D0*Hr1(-1)*z2*x - 64.D0/3.D0*Hr1(-1)*z2*   &
     &    x**2 + 32.D0/3.D0*Hr1(-1)*z2*dx - 8696.D0/27.D0*Hr1(0) -      &
     &    30962.D0/27.D0*Hr1(0)*x - 3040.D0*Hr1(0)*x**2 - 896.D0/27.D0* &
     &    Hr1(0)*dx + 192.D0*Hr1(0)*z3 + 576.D0*Hr1(0)*z3*x - 44.D0*    &
     &    Hr1(0)*z2 + 108.D0*Hr1(0)*z2*x - 248.D0/3.D0*Hr1(0)*z2*x**2   &
     &     + 8288.D0/27.D0*Hr1(1) - 7750.D0/27.D0*Hr1(1)*x - 1520.D0/27.&
     &    D0*Hr1(1)*x**2 + 644.D0/9.D0*Hr1(1)*dx - 248.D0*Hr1(1)*z3 +   &
     &    496.D0*Hr1(1)*z3*x - 496.D0*Hr1(1)*z3*x**2 + 212.D0/3.D0*Hr1( &
     &    1)*z2 - 64.D0/3.D0*Hr1(1)*z2*x - 136.D0/3.D0*Hr1(1)*z2*x**2   &
     &     + 32.D0/3.D0*Hr1(1)*z2*dx )                                  
      gqg2 = gqg2 + nf*ca**2 * ( 16.D0*Hr2(-1,-1)*z2 + 32.D0*Hr2(-1,-1) &
     &    *z2*x + 32.D0*Hr2(-1,-1)*z2*x**2 - 704.D0/9.D0*Hr2(-1,0) +    &
     &    5864.D0/9.D0*Hr2(-1,0)*x + 2216.D0/3.D0*Hr2(-1,0)*x**2 + 832.D&
     &    0/9.D0*Hr2(-1,0)*dx + 56.D0*Hr2(0,-1)*z2 - 16.D0*Hr2(0,-1)*z2 &
     &    *x + 64.D0*Hr2(0,-1)*z2*x**2 + 2396.D0/9.D0*Hr2(0,0) + 200.D0 &
     &    *Hr2(0,0)*x + 10244.D0/9.D0*Hr2(0,0)*x**2 - 12.D0*Hr2(0,0)*z2 &
     &     + 56.D0*Hr2(0,0)*z2*x - 96.D0*Hr2(0,0)*z2*x**2 + 628.D0/3.D0 &
     &    *Hr2(0,1) + 1256.D0/3.D0*Hr2(0,1)*x + 620.D0/9.D0*Hr2(0,1)*   &
     &    x**2 + 320.D0/9.D0*Hr2(0,1)*dx + 24.D0*Hr2(0,1)*z2 + 80.D0*   &
     &    Hr2(0,1)*z2*x + 92.D0/3.D0*Hr2(1,0) + 688.D0/3.D0*Hr2(1,0)*x  &
     &     - 276.D0*Hr2(1,0)*x**2 + 24.D0*Hr2(1,0)*dx - 80.D0*Hr2(1,0)* &
     &    z2 + 160.D0*Hr2(1,0)*z2*x - 160.D0*Hr2(1,0)*z2*x**2 - 164.D0/ &
     &    9.D0*Hr2(1,1) - 1904.D0/9.D0*Hr2(1,1)*x + 188.D0*Hr2(1,1)*    &
     &    x**2 - 160.D0/9.D0*Hr2(1,1)*dx - 16.D0*Hr2(1,1)*z2 + 32.D0*   &
     &    Hr2(1,1)*z2*x - 32.D0*Hr2(1,1)*z2*x**2 + 112.D0*Hr3(-1,-1,0)  &
     &     - 80.D0*Hr3(-1,-1,0)*x )                                     
      gqg2 = gqg2 + nf*ca**2 * (  - 640.D0/3.D0*Hr3(-1,-1,0)*x**2 - 64.D&
     &    0/3.D0*Hr3(-1,-1,0)*dx - 256.D0/3.D0*Hr3(-1,0,0) - 1016.D0/3.D&
     &    0*Hr3(-1,0,0)*x - 976.D0/3.D0*Hr3(-1,0,0)*x**2 - 128.D0/3.D0* &
     &    Hr3(-1,0,0)*dx - 64.D0*Hr3(-1,0,1) - 128.D0*Hr3(-1,0,1)*x -   &
     &    256.D0/3.D0*Hr3(-1,0,1)*x**2 - 64.D0/3.D0*Hr3(-1,0,1)*dx - 72.&
     &    D0*Hr3(0,-1,0) + 216.D0*Hr3(0,-1,0)*x - 400.D0*Hr3(0,-1,0)*   &
     &    x**2 - 56.D0/3.D0*Hr3(0,0,0) + 56.D0/3.D0*Hr3(0,0,0)*x + 96.D0&
     &    *Hr3(0,0,0)*x**2 + 44.D0*Hr3(0,0,1) + 108.D0*Hr3(0,0,1)*x +   &
     &    248.D0/3.D0*Hr3(0,0,1)*x**2 + 16.D0*Hr3(0,1,0) + 96.D0*Hr3(0, &
     &    1,0)*x - 40.D0/3.D0*Hr3(0,1,0)*x**2 - 32.D0*Hr3(0,1,1)*x -    &
     &    848.D0/3.D0*Hr3(0,1,1)*x**2 + 32.D0/3.D0*Hr3(0,1,1)*dx - 304.D&
     &    0/3.D0*Hr3(1,0,0) - 148.D0/3.D0*Hr3(1,0,0)*x + 592.D0/3.D0*   &
     &    Hr3(1,0,0)*x**2 - 32.D0*Hr3(1,0,0)*dx - 44.D0/3.D0*Hr3(1,0,1) &
     &     + 184.D0/3.D0*Hr3(1,0,1)*x - 184.D0/3.D0*Hr3(1,0,1)*x**2 +   &
     &    92.D0/3.D0*Hr3(1,1,0) + 392.D0/3.D0*Hr3(1,1,0)*x - 168.D0*    &
     &    Hr3(1,1,0)*x**2 )                                             
      gqg2 = gqg2 + nf*ca**2 * ( 64.D0/3.D0*Hr3(1,1,0)*dx + 68.D0/3.D0* &
     &    Hr3(1,1,1) - 184.D0/3.D0*Hr3(1,1,1)*x + 128.D0/3.D0*Hr3(1,1,1 &
     &    )*x**2 + 32.D0/3.D0*Hr3(1,1,1)*dx + 96.D0*Hr4(-1,-1,-1,0) +   &
     &    192.D0*Hr4(-1,-1,-1,0)*x + 192.D0*Hr4(-1,-1,-1,0)*x**2 + 32.D0&
     &    *Hr4(-1,-1,0,0) + 64.D0*Hr4(-1,-1,0,0)*x + 64.D0*Hr4(-1,-1,0, &
     &    0)*x**2 + 32.D0*Hr4(-1,-1,0,1) + 64.D0*Hr4(-1,-1,0,1)*x + 64.D&
     &    0*Hr4(-1,-1,0,1)*x**2 - 16.D0*Hr4(-1,0,-1,0) - 32.D0*Hr4(-1,0 &
     &    ,-1,0)*x - 32.D0*Hr4(-1,0,-1,0)*x**2 - 24.D0*Hr4(-1,0,0,0) -  &
     &    48.D0*Hr4(-1,0,0,0)*x - 48.D0*Hr4(-1,0,0,0)*x**2 - 32.D0*Hr4( &
     &    -1,0,0,1) - 64.D0*Hr4(-1,0,0,1)*x - 64.D0*Hr4(-1,0,0,1)*x**2  &
     &     + 32.D0*Hr4(-1,0,1,1) + 64.D0*Hr4(-1,0,1,1)*x + 64.D0*Hr4(-1 &
     &    ,0,1,1)*x**2 + 48.D0*Hr4(0,-1,-1,0) - 160.D0*Hr4(0,-1,-1,0)*x &
     &     + 24.D0*Hr4(0,-1,0,0) - 208.D0*Hr4(0,-1,0,0)*x - 32.D0*Hr4(0 &
     &    ,-1,0,0)*x**2 - 32.D0*Hr4(0,-1,0,1) - 64.D0*Hr4(0,-1,0,1)*x   &
     &     - 64.D0*Hr4(0,-1,0,1)*x**2 + 72.D0*Hr4(0,0,-1,0) - 16.D0*    &
     &    Hr4(0,0,-1,0)*x )                                             
      gqg2 = gqg2 + nf*ca**2 * ( 64.D0*Hr4(0,0,0,0) - 240.D0*Hr4(0,0,0, &
     &    0)*x + 12.D0*Hr4(0,0,0,1) - 72.D0*Hr4(0,0,0,1)*x + 96.D0*Hr4( &
     &    0,0,0,1)*x**2 + 48.D0*Hr4(0,0,1,1) + 128.D0*Hr4(0,0,1,1)*x -  &
     &    84.D0*Hr4(0,1,0,0) - 200.D0*Hr4(0,1,0,0)*x - 64.D0*Hr4(0,1,0, &
     &    0)*x**2 + 32.D0*Hr4(0,1,1,0) + 128.D0*Hr4(0,1,1,0)*x + 16.D0* &
     &    Hr4(0,1,1,1) + 64.D0*Hr4(0,1,1,1)*x - 48.D0*Hr4(1,0,-1,0) +   &
     &    96.D0*Hr4(1,0,-1,0)*x - 96.D0*Hr4(1,0,-1,0)*x**2 + 40.D0*Hr4( &
     &    1,0,0,0) - 80.D0*Hr4(1,0,0,0)*x + 80.D0*Hr4(1,0,0,0)*x**2 +   &
     &    48.D0*Hr4(1,0,0,1) - 96.D0*Hr4(1,0,0,1)*x + 96.D0*Hr4(1,0,0,1 &
     &    )*x**2 - 32.D0*Hr4(1,0,1,0) + 64.D0*Hr4(1,0,1,0)*x - 64.D0*   &
     &    Hr4(1,0,1,0)*x**2 - 16.D0*Hr4(1,1,0,0) + 32.D0*Hr4(1,1,0,0)*x &
     &     - 32.D0*Hr4(1,1,0,0)*x**2 - 32.D0*Hr4(1,1,0,1) + 64.D0*Hr4(1 &
     &    ,1,0,1)*x - 64.D0*Hr4(1,1,0,1)*x**2 - 64.D0*Hr4(1,1,1,0) +    &
     &    128.D0*Hr4(1,1,1,0)*x - 128.D0*Hr4(1,1,1,0)*x**2 + 32.D0*Hr4( &
     &    1,1,1,1) - 64.D0*Hr4(1,1,1,1)*x + 64.D0*Hr4(1,1,1,1)*x**2 )   
      gqg2 = gqg2 + nf*cf*ca * ( 1429.D0/12.D0 + 2303.D0/2.D0*x - 3997.D&
     &    0/3.D0*x**2 + 220.D0/3.D0*dx - 100.D0/3.D0*z3 - 1792.D0/3.D0* &
     &    z3*x + 2240.D0/3.D0*z3*x**2 - 64.D0*z3*dx + 688.D0/9.D0*z2 +  &
     &    268.D0/9.D0*z2*x + 392.D0*z2*x**2 - 292.D0/5.D0*z2**2 - 808.D0&
     &    /5.D0*z2**2*x - 32.D0*z2**2*x**2 + 136.D0*Hr1(-1)*z3 + 272.D0 &
     &    *Hr1(-1)*z3*x + 272.D0*Hr1(-1)*z3*x**2 + 40.D0*Hr1(-1)*z2 +   &
     &    80.D0*Hr1(-1)*z2*x + 40.D0*Hr1(-1)*z2*x**2 + 2696.D0/27.D0*   &
     &    Hr1(0) + 24569.D0/27.D0*Hr1(0)*x + 11332.D0/27.D0*Hr1(0)*x**2 &
     &     - 88.D0*Hr1(0)*z3 - 656.D0*Hr1(0)*z3*x + 32.D0*Hr1(0)*z3*    &
     &    x**2 - 40.D0*Hr1(0)*z2 - 360.D0*Hr1(0)*z2*x - 1384.D0/3.D0*   &
     &    Hr1(0)*z2*x**2 - 3692.D0/27.D0*Hr1(1) + 12892.D0/27.D0*Hr1(1) &
     &    *x - 9620.D0/27.D0*Hr1(1)*x**2 - 1484.D0/27.D0*Hr1(1)*dx +    &
     &    312.D0*Hr1(1)*z3 - 624.D0*Hr1(1)*z3*x + 624.D0*Hr1(1)*z3*x**2 &
     &     - 52.D0*Hr1(1)*z2 - 40.D0*Hr1(1)*z2*x + 80.D0*Hr1(1)*z2*x**2 &
     &     - 144.D0*Hr2(-1,-1)*z2 - 288.D0*Hr2(-1,-1)*z2*x - 288.D0*    &
     &    Hr2(-1,-1)*z2*x**2 )                                          
      gqg2 = gqg2 + nf*cf*ca * ( 296.D0*Hr2(-1,0) + 152.D0*Hr2(-1,0)*x  &
     &     - 144.D0*Hr2(-1,0)*x**2 + 144.D0*Hr2(-1,0)*z2 + 288.D0*Hr2(  &
     &    -1,0)*z2*x + 288.D0*Hr2(-1,0)*z2*x**2 + 112.D0*Hr2(0,-1)*z2   &
     &     + 128.D0*Hr2(0,-1)*z2*x + 288.D0*Hr2(0,-1)*z2*x**2 - 1267.D0/&
     &    9.D0*Hr2(0,0) - 3190.D0/9.D0*Hr2(0,0)*x - 2204.D0/9.D0*Hr2(0, &
     &    0)*x**2 + 96.D0*Hr2(0,0)*z2 + 96.D0*Hr2(0,0)*z2*x + 64.D0*    &
     &    Hr2(0,0)*z2*x**2 - 688.D0/9.D0*Hr2(0,1) + 1100.D0/9.D0*Hr2(0, &
     &    1)*x - 392.D0*Hr2(0,1)*x**2 + 16.D0*Hr2(0,1)*z2 - 64.D0*Hr2(0 &
     &    ,1)*z2*x + 128.D0*Hr2(0,1)*z2*x**2 - 116.D0/9.D0*Hr2(1,0) +   &
     &    1888.D0/9.D0*Hr2(1,0)*x - 212.D0*Hr2(1,0)*x**2 + 368.D0/9.D0* &
     &    Hr2(1,0)*dx + 144.D0*Hr2(1,0)*z2 - 288.D0*Hr2(1,0)*z2*x + 288.&
     &    D0*Hr2(1,0)*z2*x**2 - 808.D0/9.D0*Hr2(1,1) + 4568.D0/9.D0*    &
     &    Hr2(1,1)*x - 4096.D0/9.D0*Hr2(1,1)*x**2 + 368.D0/9.D0*Hr2(1,1 &
     &    )*dx + 96.D0*Hr2(1,1)*z2 - 192.D0*Hr2(1,1)*z2*x + 192.D0*Hr2( &
     &    1,1)*z2*x**2 - 144.D0*Hr3(-1,-1,0) - 224.D0*Hr3(-1,-1,0)*x -  &
     &    80.D0*Hr3(-1,-1,0)*x**2 )                                     
      gqg2 = gqg2 + nf*cf*ca * ( 40.D0*Hr3(-1,0,0) + 64.D0*Hr3(-1,0,0)* &
     &    x + 48.D0*Hr3(-1,0,0)*x**2 - 112.D0*Hr3(-1,0,1) - 192.D0*Hr3( &
     &    -1,0,1)*x - 80.D0*Hr3(-1,0,1)*x**2 + 208.D0*Hr3(0,-1,0) - 64.D&
     &    0*Hr3(0,-1,0)*x + 80.D0*Hr3(0,-1,0)*x**2 + 44.D0/3.D0*Hr3(0,0 &
     &    ,0) + 344.D0/3.D0*Hr3(0,0,0)*x + 1264.D0/3.D0*Hr3(0,0,0)*x**2 &
     &     + 40.D0*Hr3(0,0,1) + 296.D0*Hr3(0,0,1)*x + 1384.D0/3.D0*Hr3( &
     &    0,0,1)*x**2 + 32.D0*Hr3(0,1,0) + 72.D0*Hr3(0,1,0)*x + 392.D0* &
     &    Hr3(0,1,0)*x**2 - 44.D0/3.D0*Hr3(0,1,1) + 496.D0/3.D0*Hr3(0,1 &
     &    ,1)*x + 192.D0*Hr3(0,1,1)*x**2 + 472.D0/3.D0*Hr3(1,0,0) - 488.&
     &    D0/3.D0*Hr3(1,0,0)*x + 32.D0/3.D0*Hr3(1,0,0)*dx - 20.D0*Hr3(1 &
     &    ,0,1) + 152.D0*Hr3(1,0,1)*x - 120.D0*Hr3(1,0,1)*x**2 + 4.D0*  &
     &    Hr3(1,1,0) - 88.D0*Hr3(1,1,0)*x + 280.D0/3.D0*Hr3(1,1,0)*x**2 &
     &     - 64.D0/3.D0*Hr3(1,1,0)*dx - 56.D0/3.D0*Hr3(1,1,1) + 424.D0/ &
     &    3.D0*Hr3(1,1,1)*x - 416.D0/3.D0*Hr3(1,1,1)*x**2 - 32.D0/3.D0* &
     &    Hr3(1,1,1)*dx - 96.D0*Hr4(-1,-1,-1,0) - 192.D0*Hr4(-1,-1,-1,0 &
     &    )*x )                                                         
      gqg2 = gqg2 + nf*cf*ca * (  - 192.D0*Hr4(-1,-1,-1,0)*x**2 + 96.D0 &
     &    *Hr4(-1,-1,0,0) + 192.D0*Hr4(-1,-1,0,0)*x + 192.D0*Hr4(-1,-1, &
     &    0,0)*x**2 + 96.D0*Hr4(-1,-1,0,1) + 192.D0*Hr4(-1,-1,0,1)*x +  &
     &    192.D0*Hr4(-1,-1,0,1)*x**2 + 48.D0*Hr4(-1,0,-1,0) + 96.D0*    &
     &    Hr4(-1,0,-1,0)*x + 96.D0*Hr4(-1,0,-1,0)*x**2 - 88.D0*Hr4(-1,0 &
     &    ,0,0) - 176.D0*Hr4(-1,0,0,0)*x - 176.D0*Hr4(-1,0,0,0)*x**2 -  &
     &    96.D0*Hr4(-1,0,0,1) - 192.D0*Hr4(-1,0,0,1)*x - 192.D0*Hr4(-1, &
     &    0,0,1)*x**2 - 32.D0*Hr4(-1,0,1,0) - 64.D0*Hr4(-1,0,1,0)*x -   &
     &    64.D0*Hr4(-1,0,1,0)*x**2 - 32.D0*Hr4(-1,0,1,1) - 64.D0*Hr4(-1 &
     &    ,0,1,1)*x - 64.D0*Hr4(-1,0,1,1)*x**2 + 32.D0*Hr4(0,-1,-1,0)   &
     &     + 128.D0*Hr4(0,-1,-1,0)*x + 192.D0*Hr4(0,-1,-1,0)*x**2 - 64.D&
     &    0*Hr4(0,-1,0,0) - 96.D0*Hr4(0,-1,0,0)*x - 192.D0*Hr4(0,-1,0,0 &
     &    )*x**2 - 96.D0*Hr4(0,-1,0,1) - 64.D0*Hr4(0,-1,0,1)*x - 192.D0 &
     &    *Hr4(0,-1,0,1)*x**2 + 48.D0*Hr4(0,0,-1,0) - 32.D0*Hr4(0,0,-1, &
     &    0)*x - 32.D0*Hr4(0,0,0,0) - 64.D0*Hr4(0,0,0,0)*x - 96.D0*Hr4( &
     &    0,0,0,1) )                                                    
      gqg2 = gqg2 + nf*cf*ca * (  - 128.D0*Hr4(0,0,0,1)*x - 64.D0*Hr4(0 &
     &    ,0,0,1)*x**2 - 64.D0*Hr4(0,0,1,0) - 192.D0*Hr4(0,0,1,0)*x -   &
     &    64.D0*Hr4(0,0,1,1) - 96.D0*Hr4(0,0,1,1)*x - 64.D0*Hr4(0,0,1,1 &
     &    )*x**2 + 88.D0*Hr4(0,1,0,0) + 16.D0*Hr4(0,1,0,0)*x + 96.D0*   &
     &    Hr4(0,1,0,0)*x**2 - 32.D0*Hr4(0,1,0,1)*x**2 - 192.D0*Hr4(0,1, &
     &    1,0)*x + 96.D0*Hr4(0,1,1,0)*x**2 - 56.D0*Hr4(0,1,1,1) + 16.D0 &
     &    *Hr4(0,1,1,1)*x - 64.D0*Hr4(0,1,1,1)*x**2 + 48.D0*Hr4(1,0,-1, &
     &    0) - 96.D0*Hr4(1,0,-1,0)*x + 96.D0*Hr4(1,0,-1,0)*x**2 - 24.D0 &
     &    *Hr4(1,0,0,0) + 48.D0*Hr4(1,0,0,0)*x - 48.D0*Hr4(1,0,0,0)*    &
     &    x**2 - 96.D0*Hr4(1,0,0,1) + 192.D0*Hr4(1,0,0,1)*x - 192.D0*   &
     &    Hr4(1,0,0,1)*x**2 - 96.D0*Hr4(1,0,1,1) + 192.D0*Hr4(1,0,1,1)* &
     &    x - 192.D0*Hr4(1,0,1,1)*x**2 + 16.D0*Hr4(1,1,0,0) - 32.D0*    &
     &    Hr4(1,1,0,0)*x + 32.D0*Hr4(1,1,0,0)*x**2 - 48.D0*Hr4(1,1,0,1) &
     &     + 96.D0*Hr4(1,1,0,1)*x - 96.D0*Hr4(1,1,0,1)*x**2 + 48.D0*    &
     &    Hr4(1,1,1,0) - 96.D0*Hr4(1,1,1,0)*x + 96.D0*Hr4(1,1,1,0)*x**2 &
     &     - 64.D0*Hr4(1,1,1,1) )                                       
      gqg2 = gqg2 + nf*cf*ca * ( 128.D0*Hr4(1,1,1,1)*x - 128.D0*Hr4(1,1 &
     &    ,1,1)*x**2 )                                                  
      gqg2 = gqg2 + nf*cf**2 * ( 963.D0/4.D0 - 641.D0/2.D0*x + 81.D0*   &
     &    x**2 - 24.D0*z3 + 136.D0*z3*x - 304.D0*z3*x**2 - 68.D0*z2 +   &
     &    48.D0*z2*x - 244.D0*z2*x**2 + 32.D0*z2**2 - 192.D0/5.D0*z2**2 &
     &    *x + 352.D0/5.D0*z2**2*x**2 + 64.D0*Hr1(-1)*z2 + 128.D0*Hr1(  &
     &    -1)*z2*x + 64.D0*Hr1(-1)*z2*x**2 + 170.D0*Hr1(0) + 57.D0*Hr1( &
     &    0)*x + 348.D0*Hr1(0)*x**2 - 56.D0*Hr1(0)*z3 + 208.D0*Hr1(0)*  &
     &    z3*x - 224.D0*Hr1(0)*z3*x**2 - 36.D0*Hr1(0)*z2 + 128.D0*Hr1(0 &
     &    )*z2*x - 176.D0*Hr1(0)*z2*x**2 - 32.D0*Hr1(1) - 282.D0*Hr1(1) &
     &    *x + 348.D0*Hr1(1)*x**2 - 112.D0*Hr1(1)*z3 + 224.D0*Hr1(1)*z3 &
     &    *x - 224.D0*Hr1(1)*z3*x**2 + 32.D0*Hr1(1)*z2 + 80.D0*Hr1(1)*  &
     &    z2*x - 112.D0*Hr1(1)*z2*x**2 - 320.D0*Hr2(-1,0) - 368.D0*Hr2( &
     &    -1,0)*x - 80.D0*Hr2(-1,0)*x**2 + 32.D0*Hr2(0,-1)*z2 + 89.D0*  &
     &    Hr2(0,0) + 126.D0*Hr2(0,0)*x + 352.D0*Hr2(0,0)*x**2 - 56.D0*  &
     &    Hr2(0,0)*z2 + 112.D0*Hr2(0,0)*z2*x - 224.D0*Hr2(0,0)*z2*x**2  &
     &     + 68.D0*Hr2(0,1) - 416.D0*Hr2(0,1)*x + 244.D0*Hr2(0,1)*x**2  &
     &     - 32.D0*Hr2(0,1)*z2 )                                        
      gqg2 = gqg2 + nf*cf**2 * ( 128.D0*Hr2(0,1)*z2*x - 160.D0*Hr2(0,1) &
     &    *z2*x**2 + 160.D0*Hr2(1,0) - 352.D0*Hr2(1,0)*x + 272.D0*Hr2(1 &
     &    ,0)*x**2 - 112.D0*Hr2(1,0)*z2 + 224.D0*Hr2(1,0)*z2*x - 224.D0 &
     &    *Hr2(1,0)*z2*x**2 + 108.D0*Hr2(1,1) - 296.D0*Hr2(1,1)*x + 244.&
     &    D0*Hr2(1,1)*x**2 - 80.D0*Hr2(1,1)*z2 + 160.D0*Hr2(1,1)*z2*x   &
     &     - 160.D0*Hr2(1,1)*z2*x**2 + 128.D0*Hr3(-1,-1,0) + 256.D0*    &
     &    Hr3(-1,-1,0)*x + 128.D0*Hr3(-1,-1,0)*x**2 - 128.D0*Hr3(-1,0,0 &
     &    ) - 288.D0*Hr3(-1,0,0)*x - 160.D0*Hr3(-1,0,0)*x**2 - 176.D0*  &
     &    Hr3(0,-1,0) - 32.D0*Hr3(0,-1,0)*x - 128.D0*Hr3(0,-1,0)*x**2   &
     &     + 12.D0*Hr3(0,0,0) + 64.D0*Hr3(0,0,0)*x + 240.D0*Hr3(0,0,0)* &
     &    x**2 + 36.D0*Hr3(0,0,1) - 160.D0*Hr3(0,0,1)*x + 176.D0*Hr3(0, &
     &    0,1)*x**2 + 48.D0*Hr3(0,1,0) - 80.D0*Hr3(0,1,0)*x + 80.D0*    &
     &    Hr3(0,1,0)*x**2 + 36.D0*Hr3(0,1,1) - 104.D0*Hr3(0,1,1)*x + 96.&
     &    D0*Hr3(0,1,1)*x**2 - 32.D0*Hr3(1,0,0) - 48.D0*Hr3(1,0,0)*x +  &
     &    80.D0*Hr3(1,0,0)*x**2 + 32.D0*Hr3(1,0,1) - 208.D0*Hr3(1,0,1)* &
     &    x )                                                           
      gqg2 = gqg2 + nf*cf**2 * ( 176.D0*Hr3(1,0,1)*x**2 - 32.D0*Hr3(1,1 &
     &    ,0) - 48.D0*Hr3(1,1,0)*x + 80.D0*Hr3(1,1,0)*x**2 - 4.D0*Hr3(1 &
     &    ,1,1) - 80.D0*Hr3(1,1,1)*x + 96.D0*Hr3(1,1,1)*x**2 + 64.D0*   &
     &    Hr4(-1,-1,0,0) + 128.D0*Hr4(-1,-1,0,0)*x + 128.D0*Hr4(-1,-1,0 &
     &    ,0)*x**2 + 32.D0*Hr4(-1,0,-1,0) + 64.D0*Hr4(-1,0,-1,0)*x + 64.&
     &    D0*Hr4(-1,0,-1,0)*x**2 - 16.D0*Hr4(-1,0,0,0) - 32.D0*Hr4(-1,0 &
     &    ,0,0)*x - 32.D0*Hr4(-1,0,0,0)*x**2 + 64.D0*Hr4(0,-1,-1,0) -   &
     &    64.D0*Hr4(0,-1,0,0) - 64.D0*Hr4(0,-1,0,0)*x - 128.D0*Hr4(0,-1 &
     &    ,0,0)*x**2 - 64.D0*Hr4(0,0,-1,0) - 128.D0*Hr4(0,0,-1,0)*x**2  &
     &     + 16.D0*Hr4(0,0,0,0) + 128.D0*Hr4(0,0,0,0)*x**2 + 56.D0*Hr4( &
     &    0,0,0,1) - 112.D0*Hr4(0,0,0,1)*x + 224.D0*Hr4(0,0,0,1)*x**2   &
     &     + 64.D0*Hr4(0,0,1,0) - 128.D0*Hr4(0,0,1,0)*x + 192.D0*Hr4(0, &
     &    0,1,0)*x**2 + 80.D0*Hr4(0,0,1,1) - 160.D0*Hr4(0,0,1,1)*x +    &
     &    192.D0*Hr4(0,0,1,1)*x**2 + 16.D0*Hr4(0,1,0,0) - 96.D0*Hr4(0,1 &
     &    ,0,0)*x + 128.D0*Hr4(0,1,0,0)*x**2 + 64.D0*Hr4(0,1,0,1) - 128.&
     &    D0*Hr4(0,1,0,1)*x )                                           
      gqg2 = gqg2 + nf*cf**2 * ( 160.D0*Hr4(0,1,0,1)*x**2 + 32.D0*Hr4(0 &
     &    ,1,1,0) - 64.D0*Hr4(0,1,1,0)*x + 32.D0*Hr4(0,1,1,0)*x**2 + 40.&
     &    D0*Hr4(0,1,1,1) - 80.D0*Hr4(0,1,1,1)*x + 64.D0*Hr4(0,1,1,1)*  &
     &    x**2 - 32.D0*Hr4(1,0,-1,0) + 64.D0*Hr4(1,0,-1,0)*x - 64.D0*   &
     &    Hr4(1,0,-1,0)*x**2 + 48.D0*Hr4(1,0,0,0) - 96.D0*Hr4(1,0,0,0)* &
     &    x + 96.D0*Hr4(1,0,0,0)*x**2 + 112.D0*Hr4(1,0,0,1) - 224.D0*   &
     &    Hr4(1,0,0,1)*x + 224.D0*Hr4(1,0,0,1)*x**2 + 96.D0*Hr4(1,0,1,0 &
     &    ) - 192.D0*Hr4(1,0,1,0)*x + 192.D0*Hr4(1,0,1,0)*x**2 + 96.D0* &
     &    Hr4(1,0,1,1) - 192.D0*Hr4(1,0,1,1)*x + 192.D0*Hr4(1,0,1,1)*   &
     &    x**2 + 64.D0*Hr4(1,1,0,0) - 128.D0*Hr4(1,1,0,0)*x + 128.D0*   &
     &    Hr4(1,1,0,0)*x**2 + 80.D0*Hr4(1,1,0,1) - 160.D0*Hr4(1,1,0,1)* &
     &    x + 160.D0*Hr4(1,1,0,1)*x**2 + 16.D0*Hr4(1,1,1,0) - 32.D0*    &
     &    Hr4(1,1,1,0)*x + 32.D0*Hr4(1,1,1,0)*x**2 + 32.D0*Hr4(1,1,1,1) &
     &     - 64.D0*Hr4(1,1,1,1)*x + 64.D0*Hr4(1,1,1,1)*x**2 )           
      gqg2 = gqg2 + nf2*ca * ( 226.D0/27.D0 - 1348.D0/27.D0*x + 2800.D  &
     &    0/81.D0*x**2 - 424.D0/81.D0*dx - 16.D0*z3*x + 88.D0/9.D0*z2*x &
     &     - 160.D0/27.D0*Hr1(0) + 560.D0/27.D0*Hr1(0)*x - 1832.D0/27.D0&
     &    *Hr1(0)*x**2 - 152.D0/27.D0*Hr1(1) + 112.D0/27.D0*Hr1(1)*x -  &
     &    112.D0/27.D0*Hr1(1)*x**2 - 8.D0/3.D0*Hr1(1)*z2 + 16.D0/3.D0*  &
     &    Hr1(1)*z2*x - 16.D0/3.D0*Hr1(1)*z2*x**2 + 80.D0/9.D0*Hr2(-1,0 &
     &    ) + 112.D0/9.D0*Hr2(-1,0)*x + 112.D0/9.D0*Hr2(-1,0)*x**2 + 64.&
     &    D0/9.D0*Hr2(0,0) + 104.D0/3.D0*Hr2(0,0)*x + 64.D0/9.D0*Hr2(0, &
     &    0)*x**2 + 8.D0/3.D0*Hr2(0,1)*x + 80.D0/9.D0*Hr2(1,1) - 112.D0/&
     &    9.D0*Hr2(1,1)*x + 112.D0/9.D0*Hr2(1,1)*x**2 + 16.D0/3.D0*Hr3( &
     &    -1,0,0) + 32.D0/3.D0*Hr3(-1,0,0)*x + 32.D0/3.D0*Hr3(-1,0,0)*  &
     &    x**2 - 16.D0/3.D0*Hr3(0,0,0) + 64.D0/3.D0*Hr3(0,0,0)*x - 8.D0/&
     &    3.D0*Hr3(1,0,0) + 16.D0/3.D0*Hr3(1,0,0)*x - 16.D0/3.D0*Hr3(1, &
     &    0,0)*x**2 + 8.D0/3.D0*Hr3(1,0,1) - 16.D0/3.D0*Hr3(1,0,1)*x +  &
     &    16.D0/3.D0*Hr3(1,0,1)*x**2 - 8.D0/3.D0*Hr3(1,1,0) + 16.D0/3.D0&
     &    *Hr3(1,1,0)*x )                                               
      gqg2 = gqg2 + nf2*ca * (  - 16.D0/3.D0*Hr3(1,1,0)*x**2 - 8.D0/3.  &
     &    D0*Hr3(1,1,1) + 16.D0/3.D0*Hr3(1,1,1)*x - 16.D0/3.D0*Hr3(1,1, &
     &    1)*x**2 )                                                     
      gqg2 = gqg2 + nf2*cf * (  - 13025.D0/54.D0 - 89.D0/27.D0*x +      &
     &    18424.D0/81.D0*x**2 + 1232.D0/81.D0*dx - 8.D0/3.D0*z3 + 16.D0/&
     &    3.D0*z3*x - 16.D0/3.D0*z3*x**2 + 80.D0/9.D0*z2 - 112.D0/9.D0* &
     &    z2*x + 112.D0/9.D0*z2*x**2 - 4856.D0/27.D0*Hr1(0) - 5270.D0/  &
     &    27.D0*Hr1(0)*x - 560.D0/9.D0*Hr1(0)*x**2 + 224.D0/27.D0*Hr1(1 &
     &    ) - 148.D0/27.D0*Hr1(1)*x + 112.D0/27.D0*Hr1(1)*x**2 - 1370.D0&
     &    /9.D0*Hr2(0,0) - 884.D0/9.D0*Hr2(0,0)*x - 352.D0/9.D0*Hr2(0,0 &
     &    )*x**2 - 80.D0/9.D0*Hr2(0,1) + 112.D0/9.D0*Hr2(0,1)*x - 112.D0&
     &    /9.D0*Hr2(0,1)*x**2 - 40.D0/9.D0*Hr2(1,0) + 128.D0/9.D0*Hr2(1 &
     &    ,0)*x - 128.D0/9.D0*Hr2(1,0)*x**2 - 80.D0/9.D0*Hr2(1,1) + 112.&
     &    D0/9.D0*Hr2(1,1)*x - 112.D0/9.D0*Hr2(1,1)*x**2 - 152.D0/3.D0* &
     &    Hr3(0,0,0) + 160.D0/3.D0*Hr3(0,0,0)*x + 32.D0*Hr3(0,0,0)*x**2 &
     &     + 8.D0/3.D0*Hr3(0,1,1) - 16.D0/3.D0*Hr3(0,1,1)*x + 16.D0/3.D0&
     &    *Hr3(0,1,1)*x**2 - 16.D0/3.D0*Hr3(1,0,0) + 32.D0/3.D0*Hr3(1,0 &
     &    ,0)*x - 32.D0/3.D0*Hr3(1,0,0)*x**2 + 8.D0/3.D0*Hr3(1,1,1) -   &
     &    16.D0/3.D0*Hr3(1,1,1)*x )                                     
      gqg2 = gqg2 + nf2*cf * ( 16.D0/3.D0*Hr3(1,1,1)*x**2 - 32.D0*      &
     &    Hr4(0,0,0,0) + 64.D0*Hr4(0,0,0,0)*x )                         
!                                                                       
       X2QGA = GQG2 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..The quark->gluon splitting functions P_gq^(2).                      
!                                                                       
       FUNCTION X2GQA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0 )                   
!                                                                       
! ...Colour factors and an abbreviation                                 
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
       DX = 1.D0/X 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!                                                                       
      ggq2 =                                                            &
     &  + cf*ca**2 * (  - 12710.D0/9.D0 + 1789.D0/3.D0*x - 33680.D0/81.D&
     &    0*x**2 + 138305.D0/81.D0*dx + 1424.D0/3.D0*z3 + 700.D0/3.D0*  &
     &    z3*x + 256.D0/3.D0*z3*x**2 - 336.D0*z3*dx + 568.D0/9.D0*z2 +  &
     &    568.D0/9.D0*z2*x - 1664.D0/9.D0*z2*x**2 - 872.D0/3.D0*z2*dx   &
     &     - 772.D0/5.D0*z2**2 - 366.D0/5.D0*z2**2*x - 544.D0/5.D0*     &
     &    z2**2*dx - 368.D0*Hr1(-1)*z3 - 184.D0*Hr1(-1)*z3*x - 368.D0*  &
     &    Hr1(-1)*z3*dx - 520.D0/3.D0*Hr1(-1)*z2 - 392.D0/3.D0*Hr1(-1)* &
     &    z2*x - 32.D0/3.D0*Hr1(-1)*z2*x**2 + 104.D0*Hr1(-1)*z2*dx +    &
     &    38224.D0/27.D0*Hr1(0) + 3202.D0/27.D0*Hr1(0)*x + 9344.D0/27.D0&
     &    *Hr1(0)*x**2 + 6320.D0/27.D0*Hr1(0)*dx - 224.D0*Hr1(0)*z3 -   &
     &    80.D0*Hr1(0)*z3*x - 32.D0*Hr1(0)*z3*dx + 2140.D0/3.D0*Hr1(0)* &
     &    z2 + 1028.D0/3.D0*Hr1(0)*z2*x + 96.D0*Hr1(0)*z2*x**2 - 176.D0/&
     &    3.D0*Hr1(0)*z2*dx + 6260.D0/27.D0*Hr1(1) - 766.D0/27.D0*Hr1(1 &
     &    )*x - 1744.D0/27.D0*Hr1(1)*x**2 - 13516.D0/27.D0*Hr1(1)*dx -  &
     &    112.D0*Hr1(1)*z3 + 56.D0*Hr1(1)*z3*x + 112.D0*Hr1(1)*z3*dx -  &
     &    352.D0/3.D0*Hr1(1)*z2 )                                       
      ggq2 = ggq2 + cf*ca**2 * ( 500.D0/3.D0*Hr1(1)*z2*x + 32.D0/3.D0*  &
     &    Hr1(1)*z2*x**2 - 16.D0/3.D0*Hr1(1)*z2*dx + 416.D0*Hr2(-1,-1)* &
     &    z2 + 208.D0*Hr2(-1,-1)*z2*x + 416.D0*Hr2(-1,-1)*z2*dx - 920.D0&
     &    /3.D0*Hr2(-1,0) + 212.D0/3.D0*Hr2(-1,0)*x - 160.D0*Hr2(-1,0)* &
     &    x**2 - 872.D0/3.D0*Hr2(-1,0)*dx - 320.D0*Hr2(-1,0)*z2 - 160.D0&
     &    *Hr2(-1,0)*z2*x - 320.D0*Hr2(-1,0)*z2*dx - 432.D0*Hr2(0,-1)*  &
     &    z2 - 56.D0*Hr2(0,-1)*z2*x - 160.D0*Hr2(0,-1)*z2*dx - 5080.D0/ &
     &    9.D0*Hr2(0,0) + 392.D0/9.D0*Hr2(0,0)*x - 616.D0/9.D0*Hr2(0,0) &
     &    *x**2 - 104.D0*Hr2(0,0)*z2 - 92.D0*Hr2(0,0)*z2*x - 568.D0/9.D0&
     &    *Hr2(0,1) + 68.D0/9.D0*Hr2(0,1)*x + 1664.D0/9.D0*Hr2(0,1)*    &
     &    x**2 - 80.D0*Hr2(0,1)*z2 - 56.D0*Hr2(0,1)*z2*x - 64.D0*Hr2(0, &
     &    1)*z2*dx + 1096.D0/9.D0*Hr2(1,0) + 400.D0/9.D0*Hr2(1,0)*x +   &
     &    1160.D0/9.D0*Hr2(1,0)*x**2 - 284.D0/3.D0*Hr2(1,0)*dx + 64.D0* &
     &    Hr2(1,0)*z2 - 32.D0*Hr2(1,0)*z2*x - 64.D0*Hr2(1,0)*z2*dx -    &
     &    100.D0/9.D0*Hr2(1,1) + 914.D0/9.D0*Hr2(1,1)*x + 592.D0/9.D0*  &
     &    Hr2(1,1)*x**2 )                                               
      ggq2 = ggq2 + cf*ca**2 * ( 260.D0/3.D0*Hr2(1,1)*dx + 32.D0*Hr2(1, &
     &    1)*z2 - 16.D0*Hr2(1,1)*z2*x - 32.D0*Hr2(1,1)*z2*dx + 176.D0/3.&
     &    D0*Hr3(-1,-1,0) - 176.D0/3.D0*Hr3(-1,-1,0)*x + 64.D0/3.D0*    &
     &    Hr3(-1,-1,0)*x**2 + 304.D0*Hr3(-1,-1,0)*dx + 1160.D0/3.D0*    &
     &    Hr3(-1,0,0) + 232.D0/3.D0*Hr3(-1,0,0)*x + 128.D0/3.D0*Hr3(-1, &
     &    0,0)*x**2 + 784.D0/3.D0*Hr3(-1,0,0)*dx + 608.D0/3.D0*Hr3(-1,0 &
     &    ,1) + 304.D0/3.D0*Hr3(-1,0,1)*x + 64.D0/3.D0*Hr3(-1,0,1)*x**2 &
     &     + 48.D0*Hr3(-1,0,1)*dx + 1160.D0/3.D0*Hr3(0,-1,0) + 16.D0*   &
     &    Hr3(0,-1,0)*x + 64.D0*Hr3(0,-1,0)*x**2 - 176.D0/3.D0*Hr3(0,-1 &
     &    ,0)*dx - 272.D0/3.D0*Hr3(0,0,0) - 224.D0*Hr3(0,0,0)*x - 224.D0&
     &    /3.D0*Hr3(0,0,0)*x**2 - 2140.D0/3.D0*Hr3(0,0,1) - 980.D0/3.D0 &
     &    *Hr3(0,0,1)*x - 96.D0*Hr3(0,0,1)*x**2 - 784.D0/3.D0*Hr3(0,1,0 &
     &    ) - 592.D0/3.D0*Hr3(0,1,0)*x - 224.D0/3.D0*Hr3(0,1,0)*x**2 -  &
     &    32.D0/3.D0*Hr3(0,1,0)*dx + 104.D0*Hr3(0,1,1) - 132.D0*Hr3(0,1 &
     &    ,1)*x - 128.D0/3.D0*Hr3(0,1,1)*x**2 - 544.D0/3.D0*Hr3(0,1,1)* &
     &    dx )                                                          
      ggq2 = ggq2 + cf*ca**2 * (  - 140.D0/3.D0*Hr3(1,0,0) - 332.D0/3.D0&
     &    *Hr3(1,0,0)*x - 64.D0/3.D0*Hr3(1,0,0)*x**2 + 176.D0*Hr3(1,0,0 &
     &    )*dx + 440.D0/3.D0*Hr3(1,0,1) - 412.D0/3.D0*Hr3(1,0,1)*x -    &
     &    440.D0/3.D0*Hr3(1,0,1)*dx + 440.D0/3.D0*Hr3(1,1,0) - 412.D0/3.&
     &    D0*Hr3(1,1,0)*x - 440.D0/3.D0*Hr3(1,1,0)*dx + 632.D0/3.D0*    &
     &    Hr3(1,1,1) - 340.D0/3.D0*Hr3(1,1,1)*x + 32.D0/3.D0*Hr3(1,1,1) &
     &    *x**2 - 688.D0/3.D0*Hr3(1,1,1)*dx + 192.D0*Hr4(-1,-1,-1,0) +  &
     &    96.D0*Hr4(-1,-1,-1,0)*x + 192.D0*Hr4(-1,-1,-1,0)*dx - 384.D0* &
     &    Hr4(-1,-1,0,0) - 192.D0*Hr4(-1,-1,0,0)*x - 384.D0*Hr4(-1,-1,0 &
     &    ,0)*dx - 320.D0*Hr4(-1,-1,0,1) - 160.D0*Hr4(-1,-1,0,1)*x -    &
     &    320.D0*Hr4(-1,-1,0,1)*dx - 160.D0*Hr4(-1,0,-1,0) - 80.D0*Hr4( &
     &    -1,0,-1,0)*x - 160.D0*Hr4(-1,0,-1,0)*dx + 176.D0*Hr4(-1,0,0,0 &
     &    ) + 88.D0*Hr4(-1,0,0,0)*x + 176.D0*Hr4(-1,0,0,0)*dx + 256.D0* &
     &    Hr4(-1,0,0,1) + 128.D0*Hr4(-1,0,0,1)*x + 256.D0*Hr4(-1,0,0,1) &
     &    *dx + 64.D0*Hr4(-1,0,1,0) + 32.D0*Hr4(-1,0,1,0)*x + 64.D0*    &
     &    Hr4(-1,0,1,0)*dx )                                            
      ggq2 = ggq2 + cf*ca**2 * ( 64.D0*Hr4(-1,0,1,1) + 32.D0*Hr4(-1,0,1 &
     &    ,1)*x + 64.D0*Hr4(-1,0,1,1)*dx - 352.D0*Hr4(0,-1,-1,0) + 16.D0&
     &    *Hr4(0,-1,-1,0)*x - 64.D0*Hr4(0,-1,-1,0)*dx + 176.D0*Hr4(0,-1 &
     &    ,0,0) + 152.D0*Hr4(0,-1,0,0)*x + 224.D0*Hr4(0,-1,0,0)*dx +    &
     &    256.D0*Hr4(0,-1,0,1) + 64.D0*Hr4(0,-1,0,1)*x + 128.D0*Hr4(0,  &
     &    -1,0,1)*dx - 144.D0*Hr4(0,0,-1,0) + 8.D0*Hr4(0,0,-1,0)*x -    &
     &    128.D0*Hr4(0,0,0,0) + 120.D0*Hr4(0,0,0,0)*x + 104.D0*Hr4(0,0, &
     &    0,1) + 100.D0*Hr4(0,0,0,1)*x + 64.D0*Hr4(0,0,1,0) + 128.D0*   &
     &    Hr4(0,0,1,0)*x + 128.D0*Hr4(0,0,1,0)*dx - 64.D0*Hr4(0,0,1,1)  &
     &     + 96.D0*Hr4(0,0,1,1)*x + 128.D0*Hr4(0,0,1,1)*dx + 104.D0*    &
     &    Hr4(0,1,0,0) + 84.D0*Hr4(0,1,0,0)*x + 96.D0*Hr4(0,1,0,0)*dx   &
     &     - 96.D0*Hr4(0,1,0,1) + 48.D0*Hr4(0,1,0,1)*x + 96.D0*Hr4(0,1, &
     &    0,1)*dx - 96.D0*Hr4(0,1,1,0) + 48.D0*Hr4(0,1,1,0)*x + 96.D0*  &
     &    Hr4(0,1,1,0)*dx - 128.D0*Hr4(0,1,1,1) + 16.D0*Hr4(0,1,1,1)*x  &
     &     + 64.D0*Hr4(0,1,1,1)*dx + 32.D0*Hr4(1,0,-1,0) - 16.D0*Hr4(1, &
     &    0,-1,0)*x )                                                   
      ggq2 = ggq2 + cf*ca**2 * (  - 32.D0*Hr4(1,0,-1,0)*dx - 48.D0*Hr4( &
     &    1,0,0,0) + 24.D0*Hr4(1,0,0,0)*x + 48.D0*Hr4(1,0,0,0)*dx - 128.&
     &    D0*Hr4(1,0,0,1) + 64.D0*Hr4(1,0,0,1)*x + 128.D0*Hr4(1,0,0,1)* &
     &    dx - 192.D0*Hr4(1,0,1,0) + 96.D0*Hr4(1,0,1,0)*x + 192.D0*Hr4( &
     &    1,0,1,0)*dx - 128.D0*Hr4(1,0,1,1) + 64.D0*Hr4(1,0,1,1)*x +    &
     &    128.D0*Hr4(1,0,1,1)*dx - 64.D0*Hr4(1,1,0,0) + 32.D0*Hr4(1,1,0 &
     &    ,0)*x + 64.D0*Hr4(1,1,0,0)*dx - 128.D0*Hr4(1,1,0,1) + 64.D0*  &
     &    Hr4(1,1,0,1)*x + 128.D0*Hr4(1,1,0,1)*dx - 128.D0*Hr4(1,1,1,0) &
     &     + 64.D0*Hr4(1,1,1,0)*x + 128.D0*Hr4(1,1,1,0)*dx - 64.D0*Hr4( &
     &    1,1,1,1) + 32.D0*Hr4(1,1,1,1)*x + 64.D0*Hr4(1,1,1,1)*dx )     
      ggq2 = ggq2 + cf**2*ca * (  - 11629.D0/18.D0 + 3589.D0/36.D0*x +  &
     &    56.D0*x**2 + 163.D0*dx - 1472.D0/3.D0*z3 - 884.D0/3.D0*z3*x   &
     &     - 32.D0*z3*x**2 + 216.D0*z3*dx + 2456.D0/9.D0*z2 - 5356.D0/9.&
     &    D0*z2*x + 96.D0*z2*x**2 - 160.D0*z2*dx - 784.D0/5.D0*z2**2 -  &
     &    184.D0/5.D0*z2**2*x - 432.D0/5.D0*z2**2*dx + 176.D0*Hr1(-1)*  &
     &    z3 + 88.D0*Hr1(-1)*z3*x + 176.D0*Hr1(-1)*z3*dx + 144.D0*Hr1(  &
     &    -1)*z2 + 88.D0*Hr1(-1)*z2*x - 48.D0*Hr1(-1)*z2*dx - 9925.D0/  &
     &    27.D0*Hr1(0) + 7061.D0/27.D0*Hr1(0)*x + 2680.D0/27.D0*Hr1(0)* &
     &    x**2 - 64.D0*Hr1(0)*z3 + 64.D0*Hr1(0)*z3*x - 752.D0/3.D0*Hr1( &
     &    0)*z2 - 440.D0/3.D0*Hr1(0)*z2*x - 16148.D0/27.D0*Hr1(1) +     &
     &    10936.D0/27.D0*Hr1(1)*x + 1384.D0/27.D0*Hr1(1)*x**2 + 13006.D0&
     &    /27.D0*Hr1(1)*dx - 48.D0*Hr1(1)*z3 + 24.D0*Hr1(1)*z3*x + 48.D0&
     &    *Hr1(1)*z3*dx + 1144.D0/3.D0*Hr1(1)*z2 - 788.D0/3.D0*Hr1(1)*  &
     &    z2*x - 472.D0/3.D0*Hr1(1)*z2*dx - 160.D0*Hr2(-1,-1)*z2 - 80.D0&
     &    *Hr2(-1,-1)*z2*x - 160.D0*Hr2(-1,-1)*z2*dx - 608.D0*Hr2(-1,0) &
     &     - 700.D0*Hr2(-1,0)*x )                                       
      ggq2 = ggq2 + cf**2*ca * (  - 32.D0*Hr2(-1,0)*dx - 32.D0*Hr2(-1,0 &
     &    )*z2 - 16.D0*Hr2(-1,0)*z2*x - 32.D0*Hr2(-1,0)*z2*dx + 96.D0*  &
     &    Hr2(0,-1)*z2 - 2590.D0/9.D0*Hr2(0,0) + 4631.D0/9.D0*Hr2(0,0)* &
     &    x - 448.D0/9.D0*Hr2(0,0)*x**2 - 16.D0*Hr2(0,0)*z2*x - 2456.D0/&
     &    9.D0*Hr2(0,1) - 944.D0/9.D0*Hr2(0,1)*x - 96.D0*Hr2(0,1)*x**2  &
     &     + 128.D0*Hr2(0,1)*dx + 160.D0*Hr2(0,1)*z2 - 32.D0*Hr2(0,1)*  &
     &    z2*x - 32.D0*Hr2(0,1)*z2*dx - 224.D0*Hr2(1,0) + 80.D0/3.D0*   &
     &    Hr2(1,0)*x + 764.D0/3.D0*Hr2(1,0)*dx - 32.D0*Hr2(1,0)*z2 + 16.&
     &    D0*Hr2(1,0)*z2*x + 32.D0*Hr2(1,0)*z2*dx - 884.D0/9.D0*Hr2(1,1 &
     &    ) - 1448.D0/9.D0*Hr2(1,1)*x - 416.D0/9.D0*Hr2(1,1)*x**2 + 64.D&
     &    0/9.D0*Hr2(1,1)*dx + 64.D0*Hr2(1,1)*z2 - 32.D0*Hr2(1,1)*z2*x  &
     &     - 64.D0*Hr2(1,1)*z2*dx + 480.D0*Hr3(-1,-1,0) + 304.D0*Hr3(-1 &
     &    ,-1,0)*x + 96.D0*Hr3(-1,-1,0)*dx - 240.D0*Hr3(-1,0,0) - 144.D0&
     &    *Hr3(-1,0,0)*x - 48.D0*Hr3(-1,0,0)*dx + 96.D0*Hr3(-1,0,1) +   &
     &    64.D0*Hr3(-1,0,1)*x + 96.D0*Hr3(-1,0,1)*dx - 576.D0*Hr3(0,-1, &
     &    0) )                                                          
      ggq2 = ggq2 + cf**2*ca * (  - 16.D0*Hr3(0,-1,0)*x - 760.D0/3.D0*  &
     &    Hr3(0,0,0) + 608.D0/3.D0*Hr3(0,0,0)*x - 128.D0/3.D0*Hr3(0,0,0 &
     &    )*x**2 + 752.D0/3.D0*Hr3(0,0,1) + 392.D0/3.D0*Hr3(0,0,1)*x -  &
     &    16.D0/3.D0*Hr3(0,1,0) + 224.D0/3.D0*Hr3(0,1,0)*x + 96.D0*Hr3( &
     &    0,1,0)*dx - 176.D0/3.D0*Hr3(0,1,1) + 448.D0/3.D0*Hr3(0,1,1)*x &
     &     + 32.D0*Hr3(0,1,1)*x**2 + 144.D0*Hr3(0,1,1)*dx - 384.D0*Hr3( &
     &    1,0,0) + 232.D0*Hr3(1,0,0)*x + 128.D0*Hr3(1,0,0)*dx - 424.D0/ &
     &    3.D0*Hr3(1,0,1) + 332.D0/3.D0*Hr3(1,0,1)*x + 328.D0/3.D0*Hr3( &
     &    1,0,1)*dx - 8.D0/3.D0*Hr3(1,1,0) + 148.D0/3.D0*Hr3(1,1,0)*x   &
     &     + 8.D0/3.D0*Hr3(1,1,0)*dx - 1112.D0/3.D0*Hr3(1,1,1) + 712.D0/&
     &    3.D0*Hr3(1,1,1)*x - 32.D0/3.D0*Hr3(1,1,1)*x**2 + 1120.D0/3.D0 &
     &    *Hr3(1,1,1)*dx - 192.D0*Hr4(-1,-1,-1,0) - 96.D0*Hr4(-1,-1,-1, &
     &    0)*x - 192.D0*Hr4(-1,-1,-1,0)*dx + 128.D0*Hr4(-1,-1,0,0) + 64.&
     &    D0*Hr4(-1,-1,0,0)*x + 128.D0*Hr4(-1,-1,0,0)*dx + 64.D0*Hr4(-1 &
     &    ,-1,0,1) + 32.D0*Hr4(-1,-1,0,1)*x + 64.D0*Hr4(-1,-1,0,1)*dx   &
     &     + 96.D0*Hr4(-1,0,-1,0) )                                     
      ggq2 = ggq2 + cf**2*ca * ( 48.D0*Hr4(-1,0,-1,0)*x + 96.D0*Hr4(-1, &
     &    0,-1,0)*dx + 48.D0*Hr4(-1,0,0,0) + 24.D0*Hr4(-1,0,0,0)*x + 48.&
     &    D0*Hr4(-1,0,0,0)*dx - 64.D0*Hr4(-1,0,1,1) - 32.D0*Hr4(-1,0,1, &
     &    1)*x - 64.D0*Hr4(-1,0,1,1)*dx + 192.D0*Hr4(0,-1,-1,0) - 96.D0 &
     &    *Hr4(0,-1,0,0) - 224.D0*Hr4(0,0,-1,0) + 16.D0*Hr4(0,0,-1,0)*x &
     &     + 64.D0*Hr4(0,0,0,0) + 64.D0*Hr4(0,0,0,0)*x + 32.D0*Hr4(0,0, &
     &    0,1)*x - 64.D0*Hr4(0,0,1,0) + 32.D0*Hr4(0,0,1,0)*x - 112.D0*  &
     &    Hr4(0,0,1,1) - 8.D0*Hr4(0,0,1,1)*x - 224.D0*Hr4(0,1,0,0) + 64.&
     &    D0*Hr4(0,1,0,0)*x + 64.D0*Hr4(0,1,0,0)*dx - 64.D0*Hr4(0,1,0,1 &
     &    ) + 32.D0*Hr4(0,1,0,1)*x + 32.D0*Hr4(0,1,0,1)*dx - 32.D0*Hr4( &
     &    0,1,1,0) + 16.D0*Hr4(0,1,1,0)*x + 32.D0*Hr4(0,1,1,0)*dx + 112.&
     &    D0*Hr4(0,1,1,1) - 8.D0*Hr4(0,1,1,1)*x - 64.D0*Hr4(0,1,1,1)*dx &
     &     - 160.D0*Hr4(1,0,-1,0) + 80.D0*Hr4(1,0,-1,0)*x + 160.D0*Hr4( &
     &    1,0,-1,0)*dx - 80.D0*Hr4(1,0,0,0) + 40.D0*Hr4(1,0,0,0)*x + 80.&
     &    D0*Hr4(1,0,0,0)*dx + 64.D0*Hr4(1,0,1,1) - 32.D0*Hr4(1,0,1,1)* &
     &    x )                                                           
      ggq2 = ggq2 + cf**2*ca * (  - 64.D0*Hr4(1,0,1,1)*dx - 160.D0*Hr4( &
     &    1,1,0,0) + 80.D0*Hr4(1,1,0,0)*x + 160.D0*Hr4(1,1,0,0)*dx + 32.&
     &    D0*Hr4(1,1,0,1) - 16.D0*Hr4(1,1,0,1)*x - 32.D0*Hr4(1,1,0,1)*  &
     &    dx + 96.D0*Hr4(1,1,1,0) - 48.D0*Hr4(1,1,1,0)*x - 96.D0*Hr4(1, &
     &    1,1,0)*dx + 128.D0*Hr4(1,1,1,1) - 64.D0*Hr4(1,1,1,1)*x - 128.D&
     &    0*Hr4(1,1,1,1)*dx )                                           
      ggq2 = ggq2 + cf**3 * ( 475.D0/2.D0 - 363.D0/4.D0*x - 94.D0*dx +  &
     &    416.D0*z3 + 208.D0*z3*x - 240.D0*z3*dx - 164.D0*z2 + 520.D0*  &
     &    z2*x + 112.D0*z2*dx + 744.D0/5.D0*z2**2 + 12.D0*z2**2*x + 512.&
     &    D0/5.D0*z2**2*dx - 224.D0*Hr1(-1)*z2 - 160.D0*Hr1(-1)*z2*x -  &
     &    96.D0*Hr1(-1)*z2*dx + 91.D0*Hr1(0) - 245.D0*Hr1(0)*x + 192.D0 &
     &    *Hr1(0)*z3 - 48.D0*Hr1(0)*z3*x + 64.D0*Hr1(0)*z2 + 36.D0*Hr1( &
     &    0)*z2*x + 316.D0*Hr1(1) - 258.D0*Hr1(1)*x - 94.D0*Hr1(1)*dx   &
     &     + 256.D0*Hr1(1)*z3 - 128.D0*Hr1(1)*z3*x - 256.D0*Hr1(1)*z3*  &
     &    dx - 256.D0*Hr1(1)*z2 + 152.D0*Hr1(1)*z2*x + 96.D0*Hr1(1)*z2* &
     &    dx + 688.D0*Hr2(-1,0) + 608.D0*Hr2(-1,0)*x + 112.D0*Hr2(-1,0) &
     &    *dx + 64.D0*Hr2(-1,0)*z2 + 32.D0*Hr2(-1,0)*z2*x + 64.D0*Hr2(  &
     &    -1,0)*z2*dx - 64.D0*Hr2(0,-1)*z2 - 70.D0*Hr2(0,0) - 555.D0*   &
     &    Hr2(0,0)*x + 48.D0*Hr2(0,0)*z2 - 24.D0*Hr2(0,0)*z2*x + 164.D0 &
     &    *Hr2(0,1) + 88.D0*Hr2(0,1)*x - 96.D0*Hr2(0,1)*z2 + 16.D0*Hr2( &
     &    0,1)*z2*x - 16.D0*Hr2(1,0) - 24.D0*Hr2(1,0)*x - 56.D0*Hr2(1,0 &
     &    )*dx )                                                        
      ggq2 = ggq2 + cf**3 * ( 64.D0*Hr2(1,0)*z2 - 32.D0*Hr2(1,0)*z2*x   &
     &     - 64.D0*Hr2(1,0)*z2*dx + 96.D0*Hr2(1,1) + 54.D0*Hr2(1,1)*x   &
     &     - 92.D0*Hr2(1,1)*dx - 96.D0*Hr2(1,1)*z2 + 48.D0*Hr2(1,1)*z2* &
     &    x + 96.D0*Hr2(1,1)*z2*dx - 448.D0*Hr3(-1,-1,0) - 320.D0*Hr3(  &
     &    -1,-1,0)*x - 192.D0*Hr3(-1,-1,0)*dx + 384.D0*Hr3(-1,0,0) +    &
     &    224.D0*Hr3(-1,0,0)*x + 192.D0*Hr3(-1,0,0)*dx + 480.D0*Hr3(0,  &
     &    -1,0) + 80.D0*Hr3(0,-1,0)*x + 16.D0*Hr3(0,0,0) - 132.D0*Hr3(0 &
     &    ,0,0)*x - 64.D0*Hr3(0,0,1) + 44.D0*Hr3(0,0,1)*x + 48.D0*Hr3(0 &
     &    ,1,0)*x - 16.D0*Hr3(0,1,1) - 52.D0*Hr3(0,1,1)*x + 192.D0*Hr3( &
     &    1,0,0) - 108.D0*Hr3(1,0,0)*x - 48.D0*Hr3(1,0,0)*dx + 32.D0*   &
     &    Hr3(1,0,1) + 8.D0*Hr3(1,0,1)*x - 96.D0*Hr3(1,1,0) + 64.D0*    &
     &    Hr3(1,1,0)*x + 96.D0*Hr3(1,1,0)*dx + 160.D0*Hr3(1,1,1) - 124.D&
     &    0*Hr3(1,1,1)*x - 144.D0*Hr3(1,1,1)*dx - 128.D0*Hr4(-1,-1,0,0) &
     &     - 64.D0*Hr4(-1,-1,0,0)*x - 128.D0*Hr4(-1,-1,0,0)*dx - 64.D0* &
     &    Hr4(-1,0,-1,0) - 32.D0*Hr4(-1,0,-1,0)*x - 64.D0*Hr4(-1,0,-1,0 &
     &    )*dx )                                                        
      ggq2 = ggq2 + cf**3 * ( 32.D0*Hr4(-1,0,0,0) + 16.D0*Hr4(-1,0,0,0) &
     &    *x + 32.D0*Hr4(-1,0,0,0)*dx - 128.D0*Hr4(0,-1,-1,0) + 128.D0* &
     &    Hr4(0,-1,0,0) + 32.D0*Hr4(0,-1,0,0)*x + 256.D0*Hr4(0,0,-1,0)  &
     &     - 32.D0*Hr4(0,0,0,0) - 32.D0*Hr4(0,0,0,0)*x - 48.D0*Hr4(0,0, &
     &    0,1) + 24.D0*Hr4(0,0,0,1)*x + 48.D0*Hr4(0,0,1,1) - 24.D0*Hr4( &
     &    0,0,1,1)*x + 80.D0*Hr4(0,1,0,0) - 8.D0*Hr4(0,1,0,0)*x + 32.D0 &
     &    *Hr4(0,1,0,1) - 16.D0*Hr4(0,1,0,1)*x + 16.D0*Hr4(0,1,1,1) - 8.&
     &    D0*Hr4(0,1,1,1)*x + 192.D0*Hr4(1,0,-1,0) - 96.D0*Hr4(1,0,-1,0 &
     &    )*x - 192.D0*Hr4(1,0,-1,0)*dx + 64.D0*Hr4(1,0,1,0) - 32.D0*   &
     &    Hr4(1,0,1,0)*x - 64.D0*Hr4(1,0,1,0)*dx + 64.D0*Hr4(1,0,1,1)   &
     &     - 32.D0*Hr4(1,0,1,1)*x - 64.D0*Hr4(1,0,1,1)*dx + 96.D0*Hr4(1 &
     &    ,1,0,0) - 48.D0*Hr4(1,1,0,0)*x - 96.D0*Hr4(1,1,0,0)*dx + 96.D0&
     &    *Hr4(1,1,0,1) - 48.D0*Hr4(1,1,0,1)*x - 96.D0*Hr4(1,1,0,1)*dx  &
     &     + 32.D0*Hr4(1,1,1,0) - 16.D0*Hr4(1,1,1,0)*x - 32.D0*Hr4(1,1, &
     &    1,0)*dx - 64.D0*Hr4(1,1,1,1) + 32.D0*Hr4(1,1,1,1)*x + 64.D0*  &
     &    Hr4(1,1,1,1)*dx )                                             
      ggq2 = ggq2 + nf*cf*ca * (  - 2320.D0/9.D0 + 148.D0/3.D0*x - 1048.&
     &    D0/9.D0*x**2 + 1934.D0/9.D0*dx + 448.D0/3.D0*z3 - 184.D0/3.D0 &
     &    *z3*x - 80.D0*z3*dx - 256.D0/9.D0*z2 + 308.D0/9.D0*z2*x + 32.D&
     &    0/3.D0*z2*x**2 - 112.D0/3.D0*z2*dx - 128.D0/3.D0*Hr1(-1)*z2   &
     &     - 64.D0/3.D0*Hr1(-1)*z2*x - 128.D0/3.D0*Hr1(-1)*z2*dx + 6656.&
     &    D0/27.D0*Hr1(0) + 1688.D0/27.D0*Hr1(0)*x + 2000.D0/27.D0*Hr1( &
     &    0)*x**2 + 1208.D0/27.D0*Hr1(0)*dx - 64.D0/3.D0*Hr1(0)*z2 - 80.&
     &    D0/3.D0*Hr1(0)*z2*x - 32.D0/3.D0*Hr1(0)*z2*dx - 1184.D0/27.D0 &
     &    *Hr1(1) + 1720.D0/27.D0*Hr1(1)*x + 400.D0/27.D0*Hr1(1)*x**2   &
     &     + 2008.D0/27.D0*Hr1(1)*dx + 16.D0/3.D0*Hr1(1)*z2 - 8.D0/3.D0 &
     &    *Hr1(1)*z2*x - 16.D0/3.D0*Hr1(1)*z2*dx - 80.D0/3.D0*Hr2(-1,0) &
     &     + 8.D0*Hr2(-1,0)*x - 32.D0/9.D0*Hr2(-1,0)*x**2 - 656.D0/9.D0 &
     &    *Hr2(-1,0)*dx - 1088.D0/9.D0*Hr2(0,0) - 668.D0/9.D0*Hr2(0,0)* &
     &    x - 32.D0/9.D0*Hr2(0,0)*x**2 + 256.D0/9.D0*Hr2(0,1) - 236.D0/ &
     &    9.D0*Hr2(0,1)*x - 32.D0/3.D0*Hr2(0,1)*x**2 - 320.D0/9.D0*Hr2( &
     &    0,1)*dx )                                                     
      ggq2 = ggq2 + nf*cf*ca * ( 320.D0/9.D0*Hr2(1,0) - 280.D0/9.D0*    &
     &    Hr2(1,0)*x - 320.D0/9.D0*Hr2(1,0)*dx + 880.D0/9.D0*Hr2(1,1)   &
     &     - 488.D0/9.D0*Hr2(1,1)*x + 32.D0/9.D0*Hr2(1,1)*x**2 - 104.D0 &
     &    *Hr2(1,1)*dx - 128.D0/3.D0*Hr3(-1,-1,0) - 64.D0/3.D0*Hr3(-1,  &
     &    -1,0)*x - 128.D0/3.D0*Hr3(-1,-1,0)*dx + 64.D0/3.D0*Hr3(-1,0,0 &
     &    ) + 32.D0/3.D0*Hr3(-1,0,0)*x + 64.D0/3.D0*Hr3(-1,0,0)*dx + 64.&
     &    D0/3.D0*Hr3(-1,0,1) + 32.D0/3.D0*Hr3(-1,0,1)*x + 64.D0/3.D0*  &
     &    Hr3(-1,0,1)*dx + 160.D0/3.D0*Hr3(0,-1,0) - 16.D0*Hr3(0,-1,0)* &
     &    x - 32.D0/3.D0*Hr3(0,-1,0)*dx + 32.D0/3.D0*Hr3(0,0,0) + 64.D0/&
     &    3.D0*Hr3(0,0,1) + 32.D0/3.D0*Hr3(0,0,1)*x - 32.D0/3.D0*Hr3(0, &
     &    1,0) + 16.D0/3.D0*Hr3(0,1,0)*x + 32.D0/3.D0*Hr3(0,1,0)*dx -   &
     &    48.D0*Hr3(0,1,1) + 8.D0*Hr3(0,1,1)*x + 80.D0/3.D0*Hr3(0,1,1)* &
     &    dx + 32.D0/3.D0*Hr3(1,0,0) - 16.D0/3.D0*Hr3(1,0,0)*x - 32.D0/ &
     &    3.D0*Hr3(1,0,0)*dx - 80.D0/3.D0*Hr3(1,0,1) + 40.D0/3.D0*Hr3(1 &
     &    ,0,1)*x + 80.D0/3.D0*Hr3(1,0,1)*dx - 80.D0/3.D0*Hr3(1,1,0) +  &
     &    40.D0/3.D0*Hr3(1,1,0)*x )                                     
      ggq2 = ggq2 + nf*cf*ca * ( 80.D0/3.D0*Hr3(1,1,0)*dx - 80.D0/3.D0* &
     &    Hr3(1,1,1) + 40.D0/3.D0*Hr3(1,1,1)*x + 80.D0/3.D0*Hr3(1,1,1)* &
     &    dx )                                                          
      ggq2 = ggq2 + nf*cf**2 * ( 8707.D0/27.D0 + 3301.D0/54.D0*x - 224.D&
     &    0/9.D0*x**2 - 3250.D0/9.D0*dx - 496.D0/3.D0*z3 + 248.D0/3.D0* &
     &    z3*x + 96.D0*z3*dx - 128.D0/9.D0*z2 - 560.D0/9.D0*z2*x + 496.D&
     &    0/9.D0*z2*dx - 5174.D0/27.D0*Hr1(0) - 3134.D0/27.D0*Hr1(0)*x  &
     &     - 352.D0/27.D0*Hr1(0)*x**2 - 1520.D0/27.D0*Hr1(0)*dx + 32.D0/&
     &    3.D0*Hr1(0)*z2 + 80.D0/3.D0*Hr1(0)*z2*x + 64.D0/3.D0*Hr1(0)*  &
     &    z2*dx + 8.D0/27.D0*Hr1(1) - 1360.D0/27.D0*Hr1(1)*x - 56.D0/27.&
     &    D0*Hr1(1)*dx + 32.D0/3.D0*Hr1(1)*z2 - 16.D0/3.D0*Hr1(1)*z2*x  &
     &     - 32.D0/3.D0*Hr1(1)*z2*dx - 48.D0*Hr2(-1,0)*x + 64.D0/9.D0*  &
     &    Hr2(-1,0)*x**2 + 496.D0/9.D0*Hr2(-1,0)*dx + 2236.D0/9.D0*Hr2( &
     &    0,0) + 1306.D0/9.D0*Hr2(0,0)*x + 64.D0/9.D0*Hr2(0,0)*x**2 +   &
     &    128.D0/9.D0*Hr2(0,1) + 128.D0/9.D0*Hr2(0,1)*x - 8.D0/3.D0*    &
     &    Hr2(1,0)*x - 32.D0/3.D0*Hr2(1,0)*dx - 712.D0/9.D0*Hr2(1,1) +  &
     &    512.D0/9.D0*Hr2(1,1)*x + 664.D0/9.D0*Hr2(1,1)*dx - 64.D0*Hr3( &
     &    0,-1,0) + 32.D0*Hr3(0,-1,0)*x + 64.D0/3.D0*Hr3(0,-1,0)*dx +   &
     &    16.D0/3.D0*Hr3(0,0,0) )                                       
      ggq2 = ggq2 + nf*cf**2 * (  - 32.D0/3.D0*Hr3(0,0,0)*x - 32.D0/3.D0&
     &    *Hr3(0,0,1) + 16.D0/3.D0*Hr3(0,0,1)*x - 32.D0/3.D0*Hr3(0,1,0) &
     &     + 16.D0/3.D0*Hr3(0,1,0)*x - 16.D0/3.D0*Hr3(0,1,1) + 8.D0/3.D0&
     &    *Hr3(0,1,1)*x - 16.D0*Hr3(1,0,0) + 8.D0*Hr3(1,0,0)*x + 16.D0* &
     &    Hr3(1,0,0)*dx - 32.D0/3.D0*Hr3(1,0,1) + 16.D0/3.D0*Hr3(1,0,1) &
     &    *x + 32.D0/3.D0*Hr3(1,0,1)*dx - 64.D0/3.D0*Hr3(1,1,0) + 32.D0/&
     &    3.D0*Hr3(1,1,0)*x + 64.D0/3.D0*Hr3(1,1,0)*dx + 80.D0/3.D0*    &
     &    Hr3(1,1,1) - 40.D0/3.D0*Hr3(1,1,1)*x - 80.D0/3.D0*Hr3(1,1,1)* &
     &    dx + 64.D0*Hr4(0,0,0,0) - 32.D0*Hr4(0,0,0,0)*x )              
      ggq2 = ggq2 + nf2*cf * ( 16.D0/9.D0 + 32.D0/9.D0*x - 16.D0/9.D0   &
     &    *dx + 80.D0/9.D0*Hr1(1) - 64.D0/9.D0*Hr1(1)*x - 80.D0/9.D0*   &
     &    Hr1(1)*dx - 16.D0/3.D0*Hr2(1,1) + 8.D0/3.D0*Hr2(1,1)*x + 16.D0&
     &    /3.D0*Hr2(1,1)*dx )                                           
!                                                                       
       X2GQA = GGQ2 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..The regular piece of the gg splitting functions P_gg^(2).           
!                                                                       
       FUNCTION X2GGA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0,                    &
     &             Z5 = 1.0369 27755 14336 99263 D0 )                   
!                                                                       
! ..The soft coefficient for use in X2GGB and X2GGC                     
!                                                                       
!       COMMON / P2GSOFT / A3G 
!                                                                       
! ...Colour factors                                                     
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
! ...Some abbreviations                                                 
!                                                                       
       DX = 1.D0/X 
       DM = 1.D0/(1.D0-X) 
       DP = 1.D0/(1.D0+X) 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!    (without the delta(1-x) part, but with the soft contribution)      
!                                                                       
      ggg2 =                                                            &
     &  + ca**3 * (  - 54088.D0/27.D0 + 49678.D0/27.D0*x - 146182.D0/81.&
     &    D0*x**2 + 146182.D0/81.D0*dx + 490.D0/3.D0*dm + 1064.D0/3.D0* &
     &    z3 + 704.D0/3.D0*z3*x + 1408.D0/3.D0*z3*x**2 - 1144.D0/3.D0*  &
     &    z3*dx + 176.D0/3.D0*z3*dm + 976.D0/3.D0*z2 - 2632.D0/9.D0*z2* &
     &    x + 1072.D0/9.D0*z2*x**2 - 3112.D0/9.D0*z2*dx - 1072.D0/9.D0* &
     &    z2*dp - 1072.D0/9.D0*z2*dm - 272.D0*z2**2 - 1152.D0/5.D0*     &
     &    z2**2*x - 416.D0/5.D0*z2**2*x**2 - 464.D0/5.D0*z2**2*dx + 88.D&
     &    0*z2**2*dp - 24.D0/5.D0*z2**2*dm - 384.D0*Hr1(-1)*z3 - 192.D0 &
     &    *Hr1(-1)*z3*x - 192.D0*Hr1(-1)*z3*x**2 - 192.D0*Hr1(-1)*z3*dx &
     &     + 192.D0*Hr1(-1)*z3*dp - 424.D0*Hr1(-1)*z2 - 424.D0*Hr1(-1)* &
     &    z2*x - 88.D0*Hr1(-1)*z2*x**2 - 88.D0*Hr1(-1)*z2*dx + 30794.D0/&
     &    27.D0*Hr1(0) + 9374.D0/27.D0*Hr1(0)*x + 10604.D0/9.D0*Hr1(0)* &
     &    x**2 + 6320.D0/27.D0*Hr1(0)*dx + 8.D0/3.D0*Hr1(0)*dm - 160.D0 &
     &    *Hr1(0)*z3*x + 192.D0*Hr1(0)*z3*x**2 - 32.D0*Hr1(0)*z3*dx -   &
     &    80.D0*Hr1(0)*z3*dp - 112.D0*Hr1(0)*z3*dm + 1480.D0/3.D0*Hr1(0 &
     &    )*z2 )                                                        
      ggg2 = ggg2 + ca**3 * ( 736.D0/3.D0*Hr1(0)*z2*x + 1936.D0/3.D0*   &
     &    Hr1(0)*z2*x**2 - 176.D0/3.D0*Hr1(0)*z2*dx - 88.D0/3.D0*Hr1(0) &
     &    *z2*dp + 124.D0/9.D0*Hr1(1) - 124.D0/9.D0*Hr1(1)*x + 1652.D0/ &
     &    27.D0*Hr1(1)*x**2 - 1652.D0/27.D0*Hr1(1)*dx + 192.D0*Hr1(1)*  &
     &    z3 - 96.D0*Hr1(1)*z3*x + 96.D0*Hr1(1)*z3*x**2 - 96.D0*Hr1(1)* &
     &    z3*dx - 96.D0*Hr1(1)*z3*dm - 24.D0*Hr1(1)*z2 + 24.D0*Hr1(1)*  &
     &    z2*x + 88.D0*Hr1(1)*z2*x**2 - 88.D0*Hr1(1)*z2*dx + 512.D0*    &
     &    Hr2(-1,-1)*z2 + 256.D0*Hr2(-1,-1)*z2*x + 256.D0*Hr2(-1,-1)*z2 &
     &    *x**2 + 256.D0*Hr2(-1,-1)*z2*dx - 256.D0*Hr2(-1,-1)*z2*dp -   &
     &    872.D0/9.D0*Hr2(-1,0) - 3016.D0/9.D0*Hr2(-1,0)*x - 680.D0/3.D0&
     &    *Hr2(-1,0)*x**2 - 680.D0/3.D0*Hr2(-1,0)*dx - 2144.D0/9.D0*    &
     &    Hr2(-1,0)*dp - 576.D0*Hr2(-1,0)*z2 - 288.D0*Hr2(-1,0)*z2*x -  &
     &    288.D0*Hr2(-1,0)*z2*x**2 - 288.D0*Hr2(-1,0)*z2*dx + 288.D0*   &
     &    Hr2(-1,0)*z2*dp - 768.D0*Hr2(0,-1)*z2 - 96.D0*Hr2(0,-1)*z2*x  &
     &     - 352.D0*Hr2(0,-1)*z2*x**2 - 160.D0*Hr2(0,-1)*z2*dx + 256.D0 &
     &    *Hr2(0,-1)*z2*dp )                                            
      ggg2 = ggg2 + ca**3 * ( 96.D0*Hr2(0,-1)*z2*dm - 11620.D0/9.D0*    &
     &    Hr2(0,0) + 1052.D0/3.D0*Hr2(0,0)*x - 12136.D0/9.D0*Hr2(0,0)*  &
     &    x**2 + 1072.D0/9.D0*Hr2(0,0)*dp + 1072.D0/9.D0*Hr2(0,0)*dm +  &
     &    96.D0*Hr2(0,0)*z2 - 352.D0*Hr2(0,0)*z2*x + 256.D0*Hr2(0,0)*z2 &
     &    *x**2 - 128.D0*Hr2(0,0)*z2*dp - 128.D0*Hr2(0,0)*z2*dm - 976.D0&
     &    /3.D0*Hr2(0,1) - 128.D0/3.D0*Hr2(0,1)*x - 1072.D0/9.D0*Hr2(0, &
     &    1)*x**2 + 1072.D0/9.D0*Hr2(0,1)*dx + 2144.D0/9.D0*Hr2(0,1)*dm &
     &     - 160.D0*Hr2(0,1)*z2*x + 32.D0*Hr2(0,1)*z2*x**2 - 96.D0*Hr2( &
     &    0,1)*z2*dx + 32.D0*Hr2(0,1)*z2*dp - 64.D0*Hr2(0,1)*z2*dm -    &
     &    2344.D0/9.D0*Hr2(1,0) + 200.D0/9.D0*Hr2(1,0)*x - 1072.D0/9.D0 &
     &    *Hr2(1,0)*x**2 + 1072.D0/9.D0*Hr2(1,0)*dx + 2144.D0/9.D0*Hr2( &
     &    1,0)*dm + 192.D0*Hr2(1,0)*z2 - 96.D0*Hr2(1,0)*z2*x + 96.D0*   &
     &    Hr2(1,0)*z2*x**2 - 96.D0*Hr2(1,0)*z2*dx - 96.D0*Hr2(1,0)*z2*  &
     &    dm - 48.D0*Hr3(-1,-1,0) - 48.D0*Hr3(-1,-1,0)*x + 176.D0*Hr3(  &
     &    -1,-1,0)*x**2 + 176.D0*Hr3(-1,-1,0)*dx + 608.D0*Hr3(-1,0,0)   &
     &     + 608.D0*Hr3(-1,0,0)*x )                                     
      ggg2 = ggg2 + ca**3 * ( 1408.D0/3.D0*Hr3(-1,0,0)*x**2 + 1408.D0/3.&
     &    D0*Hr3(-1,0,0)*dx + 400.D0*Hr3(-1,0,1) + 400.D0*Hr3(-1,0,1)*x &
     &     + 176.D0*Hr3(-1,0,1)*x**2 + 176.D0*Hr3(-1,0,1)*dx + 640.D0/3.&
     &    D0*Hr3(0,-1,0) + 160.D0*Hr3(0,-1,0)*x + 352.D0*Hr3(0,-1,0)*   &
     &    x**2 - 176.D0/3.D0*Hr3(0,-1,0)*dx + 176.D0/3.D0*Hr3(0,-1,0)*  &
     &    dm - 368.D0*Hr3(0,0,0) + 464.D0/3.D0*Hr3(0,0,0)*x - 704.D0*   &
     &    Hr3(0,0,0)*x**2 - 1480.D0/3.D0*Hr3(0,0,1) - 256.D0/3.D0*Hr3(0 &
     &    ,0,1)*x - 1936.D0/3.D0*Hr3(0,0,1)*x**2 + 88.D0/3.D0*Hr3(0,0,1 &
     &    )*dm - 688.D0/3.D0*Hr3(0,1,0) + 464.D0/3.D0*Hr3(0,1,0)*x -    &
     &    352.D0*Hr3(0,1,0)*x**2 + 352.D0/3.D0*Hr3(0,1,0)*dx - 776.D0/3.&
     &    D0*Hr3(1,0,0) + 688.D0/3.D0*Hr3(1,0,0)*x - 880.D0/3.D0*Hr3(1, &
     &    0,0)*x**2 + 880.D0/3.D0*Hr3(1,0,0)*dx + 88.D0/3.D0*Hr3(1,0,0) &
     &    *dm - 768.D0*Hr4(-1,-1,0,0) - 384.D0*Hr4(-1,-1,0,0)*x - 384.D0&
     &    *Hr4(-1,-1,0,0)*x**2 - 384.D0*Hr4(-1,-1,0,0)*dx + 384.D0*Hr4( &
     &    -1,-1,0,0)*dp - 512.D0*Hr4(-1,-1,0,1) - 256.D0*Hr4(-1,-1,0,1) &
     &    *x )                                                          
      ggg2 = ggg2 + ca**3 * (  - 256.D0*Hr4(-1,-1,0,1)*x**2 - 256.D0*   &
     &    Hr4(-1,-1,0,1)*dx + 256.D0*Hr4(-1,-1,0,1)*dp - 256.D0*Hr4(-1, &
     &    0,-1,0) - 128.D0*Hr4(-1,0,-1,0)*x - 128.D0*Hr4(-1,0,-1,0)*    &
     &    x**2 - 128.D0*Hr4(-1,0,-1,0)*dx + 128.D0*Hr4(-1,0,-1,0)*dp +  &
     &    512.D0*Hr4(-1,0,0,0) + 256.D0*Hr4(-1,0,0,0)*x + 256.D0*Hr4(-1 &
     &    ,0,0,0)*x**2 + 256.D0*Hr4(-1,0,0,0)*dx - 256.D0*Hr4(-1,0,0,0) &
     &    *dp + 512.D0*Hr4(-1,0,0,1) + 256.D0*Hr4(-1,0,0,1)*x + 256.D0* &
     &    Hr4(-1,0,0,1)*x**2 + 256.D0*Hr4(-1,0,0,1)*dx - 256.D0*Hr4(-1, &
     &    0,0,1)*dp + 128.D0*Hr4(-1,0,1,0) + 64.D0*Hr4(-1,0,1,0)*x + 64.&
     &    D0*Hr4(-1,0,1,0)*x**2 + 64.D0*Hr4(-1,0,1,0)*dx - 64.D0*Hr4(-1 &
     &    ,0,1,0)*dp - 512.D0*Hr4(0,-1,-1,0) + 64.D0*Hr4(0,-1,-1,0)*x   &
     &     - 192.D0*Hr4(0,-1,-1,0)*x**2 - 64.D0*Hr4(0,-1,-1,0)*dx + 128.&
     &    D0*Hr4(0,-1,-1,0)*dp + 64.D0*Hr4(0,-1,-1,0)*dm + 512.D0*Hr4(0 &
     &    ,-1,0,0) + 416.D0*Hr4(0,-1,0,0)*x + 352.D0*Hr4(0,-1,0,0)*x**2 &
     &     + 224.D0*Hr4(0,-1,0,0)*dx - 288.D0*Hr4(0,-1,0,0)*dp - 64.D0* &
     &    Hr4(0,-1,0,0)*dm )                                            
      ggg2 = ggg2 + ca**3 * ( 512.D0*Hr4(0,-1,0,1) + 128.D0*Hr4(0,-1,0, &
     &    1)*x + 256.D0*Hr4(0,-1,0,1)*x**2 + 128.D0*Hr4(0,-1,0,1)*dx -  &
     &    192.D0*Hr4(0,-1,0,1)*dp - 64.D0*Hr4(0,-1,0,1)*dm - 64.D0*Hr4( &
     &    0,0,-1,0) + 64.D0*Hr4(0,0,-1,0)*x + 128.D0*Hr4(0,0,-1,0)*x**2 &
     &     - 64.D0*Hr4(0,0,-1,0)*dp - 64.D0*Hr4(0,0,-1,0)*dm - 256.D0*  &
     &    Hr4(0,0,0,0) + 448.D0*Hr4(0,0,0,0)*x - 128.D0*Hr4(0,0,0,0)*   &
     &    x**2 + 64.D0*Hr4(0,0,0,0)*dp + 64.D0*Hr4(0,0,0,0)*dm - 96.D0* &
     &    Hr4(0,0,0,1) + 416.D0*Hr4(0,0,0,1)*x - 256.D0*Hr4(0,0,0,1)*   &
     &    x**2 + 128.D0*Hr4(0,0,0,1)*dp + 128.D0*Hr4(0,0,0,1)*dm - 128.D&
     &    0*Hr4(0,0,1,0) + 384.D0*Hr4(0,0,1,0)*x - 192.D0*Hr4(0,0,1,0)* &
     &    x**2 + 128.D0*Hr4(0,0,1,0)*dx + 32.D0*Hr4(0,0,1,0)*dp + 160.D0&
     &    *Hr4(0,0,1,0)*dm - 256.D0*Hr4(0,0,1,1) + 128.D0*Hr4(0,0,1,1)* &
     &    x - 128.D0*Hr4(0,0,1,1)*x**2 + 128.D0*Hr4(0,0,1,1)*dx + 128.D0&
     &    *Hr4(0,0,1,1)*dm - 160.D0*Hr4(0,1,0,0) + 320.D0*Hr4(0,1,0,0)* &
     &    x - 160.D0*Hr4(0,1,0,0)*x**2 + 160.D0*Hr4(0,1,0,0)*dx + 160.D0&
     &    *Hr4(0,1,0,0)*dm )                                            
      ggg2 = ggg2 + ca**3 * (  - 256.D0*Hr4(0,1,0,1) + 128.D0*Hr4(0,1,0 &
     &    ,1)*x - 128.D0*Hr4(0,1,0,1)*x**2 + 128.D0*Hr4(0,1,0,1)*dx +   &
     &    128.D0*Hr4(0,1,0,1)*dm - 256.D0*Hr4(0,1,1,0) + 128.D0*Hr4(0,1 &
     &    ,1,0)*x - 128.D0*Hr4(0,1,1,0)*x**2 + 128.D0*Hr4(0,1,1,0)*dx   &
     &     + 128.D0*Hr4(0,1,1,0)*dm + 128.D0*Hr4(1,0,-1,0) - 64.D0*Hr4( &
     &    1,0,-1,0)*x + 64.D0*Hr4(1,0,-1,0)*x**2 - 64.D0*Hr4(1,0,-1,0)* &
     &    dx - 64.D0*Hr4(1,0,-1,0)*dm - 256.D0*Hr4(1,0,0,0) + 128.D0*   &
     &    Hr4(1,0,0,0)*x - 128.D0*Hr4(1,0,0,0)*x**2 + 128.D0*Hr4(1,0,0, &
     &    0)*dx + 128.D0*Hr4(1,0,0,0)*dm - 256.D0*Hr4(1,0,0,1) + 128.D0 &
     &    *Hr4(1,0,0,1)*x - 128.D0*Hr4(1,0,0,1)*x**2 + 128.D0*Hr4(1,0,0 &
     &    ,1)*dx + 128.D0*Hr4(1,0,0,1)*dm - 256.D0*Hr4(1,0,1,0) + 128.D0&
     &    *Hr4(1,0,1,0)*x - 128.D0*Hr4(1,0,1,0)*x**2 + 128.D0*Hr4(1,0,1 &
     &    ,0)*dx + 128.D0*Hr4(1,0,1,0)*dm - 256.D0*Hr4(1,1,0,0) + 128.D0&
     &    *Hr4(1,1,0,0)*x - 128.D0*Hr4(1,1,0,0)*x**2 + 128.D0*Hr4(1,1,0 &
     &    ,0)*dx + 128.D0*Hr4(1,1,0,0)*dm )                             
      ggg2 = ggg2 + nf*ca**2 * (  - 2174.D0/9.D0 + 7358.D0/27.D0*x -    &
     &    19264.D0/81.D0*x**2 + 19264.D0/81.D0*dx - 836.D0/27.D0*dm +   &
     &    496.D0/3.D0*z3 + 112.D0/3.D0*z3*x + 128.D0/3.D0*z3*x**2 - 176.&
     &    D0/3.D0*z3*dx - 128.D0/3.D0*z3*dm - 1700.D0/9.D0*z2 + 1076.D0/&
     &    9.D0*z2*x - 176.D0/3.D0*z2*x**2 - 128.D0/3.D0*z2*dx + 160.D0/ &
     &    9.D0*z2*dp + 160.D0/9.D0*z2*dm + 276.D0/5.D0*z2**2 + 156.D0/5.&
     &    D0*z2**2*x - 88.D0*Hr1(-1)*z2 - 88.D0*Hr1(-1)*z2*x + 16.D0/3.D&
     &    0*Hr1(-1)*z2*x**2 + 16.D0/3.D0*Hr1(-1)*z2*dx + 7472.D0/27.D0* &
     &    Hr1(0) - 3958.D0/27.D0*Hr1(0)*x + 2612.D0/9.D0*Hr1(0)*x**2 +  &
     &    1136.D0/27.D0*Hr1(0)*dx - 8.D0/3.D0*Hr1(0)*dm - 96.D0*Hr1(0)* &
     &    z3*x - 4.D0/3.D0*Hr1(0)*z2 + 140.D0/3.D0*Hr1(0)*z2*x + 32.D0/ &
     &    3.D0*Hr1(0)*z2*x**2 - 32.D0/3.D0*Hr1(0)*z2*dx + 16.D0/3.D0*   &
     &    Hr1(0)*z2*dp + 1354.D0/9.D0*Hr1(1) - 1354.D0/9.D0*Hr1(1)*x -  &
     &    820.D0/27.D0*Hr1(1)*x**2 + 820.D0/27.D0*Hr1(1)*dx - 56.D0*    &
     &    Hr1(1)*z2 + 56.D0*Hr1(1)*z2*x + 16.D0*Hr1(1)*z2*x**2 - 16.D0* &
     &    Hr1(1)*z2*dx )                                                
      ggg2 = ggg2 + nf*ca**2 * ( 1208.D0/9.D0*Hr2(-1,0) + 1528.D0/9.D0* &
     &    Hr2(-1,0)*x - 304.D0/3.D0*Hr2(-1,0)*x**2 - 304.D0/3.D0*Hr2(-1 &
     &    ,0)*dx + 320.D0/9.D0*Hr2(-1,0)*dp - 48.D0*Hr2(0,-1)*z2 + 48.D0&
     &    *Hr2(0,-1)*z2*x - 208.D0/9.D0*Hr2(0,0) - 2420.D0/9.D0*Hr2(0,0 &
     &    )*x + 496.D0/9.D0*Hr2(0,0)*x**2 - 160.D0/9.D0*Hr2(0,0)*dp -   &
     &    160.D0/9.D0*Hr2(0,0)*dm - 24.D0*Hr2(0,0)*z2 - 40.D0*Hr2(0,0)* &
     &    z2*x + 1700.D0/9.D0*Hr2(0,1) + 452.D0/9.D0*Hr2(0,1)*x + 176.D0&
     &    /3.D0*Hr2(0,1)*x**2 - 176.D0/3.D0*Hr2(0,1)*dx - 320.D0/9.D0*  &
     &    Hr2(0,1)*dm - 48.D0*Hr2(0,1)*z2 - 48.D0*Hr2(0,1)*z2*x + 784.D0&
     &    /9.D0*Hr2(1,0) - 464.D0/9.D0*Hr2(1,0)*x + 176.D0/3.D0*Hr2(1,0 &
     &    )*x**2 - 176.D0/3.D0*Hr2(1,0)*dx - 320.D0/9.D0*Hr2(1,0)*dm -  &
     &    112.D0*Hr3(-1,-1,0) - 112.D0*Hr3(-1,-1,0)*x + 32.D0*Hr3(-1,-1 &
     &    ,0)*x**2 + 32.D0*Hr3(-1,-1,0)*dx + 72.D0*Hr3(-1,0,0) + 72.D0* &
     &    Hr3(-1,0,0)*x - 32.D0/3.D0*Hr3(-1,0,0)*x**2 - 32.D0/3.D0*Hr3( &
     &    -1,0,0)*dx + 32.D0*Hr3(-1,0,1) + 32.D0*Hr3(-1,0,1)*x + 32.D0/ &
     &    3.D0*Hr3(-1,0,1)*x**2 )                                       
      ggg2 = ggg2 + nf*ca**2 * ( 32.D0/3.D0*Hr3(-1,0,1)*dx + 440.D0/3.D0&
     &    *Hr3(0,-1,0) - 24.D0*Hr3(0,-1,0)*x - 64.D0/3.D0*Hr3(0,-1,0)*  &
     &    x**2 - 32.D0/3.D0*Hr3(0,-1,0)*dx - 32.D0/3.D0*Hr3(0,-1,0)*dm  &
     &     + 32.D0*Hr3(0,0,0) - 152.D0/3.D0*Hr3(0,0,0)*x + 4.D0/3.D0*   &
     &    Hr3(0,0,1) - 212.D0/3.D0*Hr3(0,0,1)*x - 32.D0/3.D0*Hr3(0,0,1) &
     &    *x**2 - 16.D0/3.D0*Hr3(0,0,1)*dm - 32.D0/3.D0*Hr3(0,1,0) - 32.&
     &    D0/3.D0*Hr3(0,1,0)*x + 116.D0/3.D0*Hr3(1,0,0) - 100.D0/3.D0*  &
     &    Hr3(1,0,0)*x - 16.D0/3.D0*Hr3(1,0,0)*dm - 96.D0*Hr4(0,-1,-1,0 &
     &    ) + 96.D0*Hr4(0,-1,-1,0)*x + 48.D0*Hr4(0,-1,0,0) - 48.D0*Hr4( &
     &    0,-1,0,0)*x + 80.D0*Hr4(0,0,-1,0) - 16.D0*Hr4(0,0,-1,0)*x +   &
     &    16.D0*Hr4(0,0,0,0)*x + 24.D0*Hr4(0,0,0,1) + 24.D0*Hr4(0,0,0,1 &
     &    )*x + 24.D0*Hr4(0,1,0,0) + 24.D0*Hr4(0,1,0,0)*x )             
      ggg2 = ggg2 + nf*cf*ca * ( 19204.D0/27.D0 + 182.D0/27.D0*x -      &
     &    24526.D0/81.D0*x**2 - 30662.D0/81.D0*dx - 110.D0/3.D0*dm -    &
     &    464.D0/3.D0*z3 - 1208.D0/3.D0*z3*x + 32.D0/3.D0*z3*x**2 + 224.&
     &    D0/3.D0*z3*dx + 32.D0*z3*dm + 2696.D0/9.D0*z2 - 3964.D0/9.D0* &
     &    z2*x - 160.D0/9.D0*z2*x**2 + 608.D0/9.D0*z2*dx - 664.D0/5.D0* &
     &    z2**2 - 344.D0/5.D0*z2**2*x + 208.D0*Hr1(-1)*z2 + 208.D0*Hr1( &
     &    -1)*z2*x - 64.D0/3.D0*Hr1(-1)*z2*x**2 - 64.D0/3.D0*Hr1(-1)*z2 &
     &    *dx + 3220.D0/27.D0*Hr1(0) + 13804.D0/27.D0*Hr1(0)*x + 112.D0 &
     &    *Hr1(0)*x**2 - 1376.D0/27.D0*Hr1(0)*dx - 16.D0*Hr1(0)*z3 +    &
     &    144.D0*Hr1(0)*z3*x + 64.D0/3.D0*Hr1(0)*z2 - 488.D0/3.D0*Hr1(0 &
     &    )*z2*x - 32.D0*Hr1(0)*z2*x**2 + 64.D0/3.D0*Hr1(0)*z2*dx -     &
     &    2264.D0/9.D0*Hr1(1) + 3428.D0/9.D0*Hr1(1)*x - 1408.D0/27.D0*  &
     &    Hr1(1)*x**2 - 2084.D0/27.D0*Hr1(1)*dx + 144.D0*Hr1(1)*z2 -    &
     &    144.D0*Hr1(1)*z2*x - 128.D0/3.D0*Hr1(1)*z2*x**2 + 128.D0/3.D0 &
     &    *Hr1(1)*z2*dx - 1232.D0/3.D0*Hr2(-1,0) - 1520.D0/3.D0*Hr2(-1, &
     &    0)*x )                                                        
      ggg2 = ggg2 + nf*cf*ca * (  - 160.D0/9.D0*Hr2(-1,0)*x**2 + 704.D0/&
     &    9.D0*Hr2(-1,0)*dx + 128.D0*Hr2(0,-1)*z2 - 128.D0*Hr2(0,-1)*z2 &
     &    *x + 4028.D0/9.D0*Hr2(0,0) + 4832.D0/9.D0*Hr2(0,0)*x + 1016.D0&
     &    /9.D0*Hr2(0,0)*x**2 + 96.D0*Hr2(0,0)*z2 + 96.D0*Hr2(0,0)*z2*x &
     &     - 2696.D0/9.D0*Hr2(0,1) - 596.D0/9.D0*Hr2(0,1)*x + 160.D0/9.D&
     &    0*Hr2(0,1)*x**2 + 32.D0/3.D0*Hr2(0,1)*dx + 128.D0*Hr2(0,1)*z2 &
     &     + 128.D0*Hr2(0,1)*z2*x - 256.D0/3.D0*Hr2(1,0) + 112.D0/3.D0* &
     &    Hr2(1,0)*x + 296.D0/9.D0*Hr2(1,0)*x**2 + 136.D0/9.D0*Hr2(1,0) &
     &    *dx + 12.D0*Hr2(1,1) - 12.D0*Hr2(1,1)*x - 16.D0/9.D0*Hr2(1,1) &
     &    *x**2 + 16.D0/9.D0*Hr2(1,1)*dx + 288.D0*Hr3(-1,-1,0) + 288.D0 &
     &    *Hr3(-1,-1,0)*x - 256.D0/3.D0*Hr3(-1,-1,0)*x**2 - 256.D0/3.D0 &
     &    *Hr3(-1,-1,0)*dx - 144.D0*Hr3(-1,0,0) - 144.D0*Hr3(-1,0,0)*x  &
     &     - 32.D0/3.D0*Hr3(-1,0,0)*x**2 - 32.D0/3.D0*Hr3(-1,0,0)*dx -  &
     &    64.D0*Hr3(-1,0,1) - 64.D0*Hr3(-1,0,1)*x - 64.D0/3.D0*Hr3(-1,0 &
     &    ,1)*x**2 - 64.D0/3.D0*Hr3(-1,0,1)*dx - 208.D0*Hr3(0,-1,0) -   &
     &    112.D0*Hr3(0,-1,0)*x )                                        
      ggg2 = ggg2 + nf*cf*ca * ( 64.D0*Hr3(0,-1,0)*x**2 + 64.D0/3.D0*   &
     &    Hr3(0,-1,0)*dx + 232.D0/3.D0*Hr3(0,0,0) - 560.D0/3.D0*Hr3(0,0 &
     &    ,0)*x - 64.D0/3.D0*Hr3(0,0,1) + 152.D0/3.D0*Hr3(0,0,1)*x + 32.&
     &    D0*Hr3(0,0,1)*x**2 - 16.D0/3.D0*Hr3(0,1,0) + 8.D0/3.D0*Hr3(0, &
     &    1,0)*x + 32.D0/3.D0*Hr3(0,1,0)*x**2 - 64.D0/3.D0*Hr3(0,1,0)*  &
     &    dx + 88.D0/3.D0*Hr3(0,1,1) + 136.D0/3.D0*Hr3(0,1,1)*x + 32.D0/&
     &    3.D0*Hr3(0,1,1)*x**2 - 32.D0/3.D0*Hr3(0,1,1)*dx - 104.D0*Hr3( &
     &    1,0,0) + 104.D0*Hr3(1,0,0)*x + 128.D0/3.D0*Hr3(1,0,0)*x**2 -  &
     &    128.D0/3.D0*Hr3(1,0,0)*dx - 16.D0*Hr3(1,1,0) + 16.D0*Hr3(1,1, &
     &    0)*x + 64.D0/3.D0*Hr3(1,1,0)*x**2 - 64.D0/3.D0*Hr3(1,1,0)*dx  &
     &     - 16.D0*Hr3(1,1,1) + 16.D0*Hr3(1,1,1)*x + 64.D0/3.D0*Hr3(1,1 &
     &    ,1)*x**2 - 64.D0/3.D0*Hr3(1,1,1)*dx + 256.D0*Hr4(0,-1,-1,0)   &
     &     - 256.D0*Hr4(0,-1,-1,0)*x - 64.D0*Hr4(0,-1,0,0) + 64.D0*Hr4( &
     &    0,-1,0,0)*x - 128.D0*Hr4(0,0,-1,0) + 128.D0*Hr4(0,0,0,0) -    &
     &    192.D0*Hr4(0,0,0,0)*x - 96.D0*Hr4(0,0,0,1) - 96.D0*Hr4(0,0,0, &
     &    1)*x )                                                        
      ggg2 = ggg2 + nf*cf*ca * (  - 64.D0*Hr4(0,0,1,0) - 64.D0*Hr4(0,0, &
     &    1,0)*x - 16.D0*Hr4(0,0,1,1) - 16.D0*Hr4(0,0,1,1)*x - 112.D0*  &
     &    Hr4(0,1,0,0) - 112.D0*Hr4(0,1,0,0)*x - 32.D0*Hr4(0,1,1,0) -   &
     &    32.D0*Hr4(0,1,1,0)*x - 32.D0*Hr4(0,1,1,1) - 32.D0*Hr4(0,1,1,1 &
     &    )*x )                                                         
      ggg2 = ggg2 + nf*cf**2 * (  - 850.D0/3.D0 + 66.D0*x + 232.D0*x**2 &
     &     - 44.D0/3.D0*dx - 32.D0*z3*x - 256.D0/3.D0*z3*x**2 + 64.D0/3.&
     &    D0*z3*dx - 64.D0*z2 + 1012.D0/3.D0*z2*x - 64.D0/3.D0*z2*x**2  &
     &     + 104.D0*z2**2 + 72.D0*z2**2*x - 64.D0*Hr1(-1)*z2 - 64.D0*   &
     &    Hr1(-1)*z2*x + 64.D0/3.D0*Hr1(-1)*z2*x**2 + 64.D0/3.D0*Hr1(-1 &
     &    )*z2*dx - 254.D0*Hr1(0) - 1082.D0/3.D0*Hr1(0)*x + 72.D0*Hr1(0 &
     &    )*x**2 + 112.D0*Hr1(0)*z3 - 16.D0*Hr1(0)*z3*x + 64.D0*Hr1(0)* &
     &    z2 + 80.D0*Hr1(0)*z2*x + 88.D0/3.D0*Hr1(1) - 428.D0/3.D0*Hr1( &
     &    1)*x + 72.D0*Hr1(1)*x**2 + 124.D0/3.D0*Hr1(1)*dx - 64.D0*Hr1( &
     &    1)*z2 + 64.D0*Hr1(1)*z2*x + 64.D0/3.D0*Hr1(1)*z2*x**2 - 64.D0/&
     &    3.D0*Hr1(1)*z2*dx + 1072.D0/3.D0*Hr2(-1,0) + 1072.D0/3.D0*    &
     &    Hr2(-1,0)*x - 64.D0*Hr2(0,-1)*z2 + 64.D0*Hr2(0,-1)*z2*x - 328.&
     &    D0/3.D0*Hr2(0,0) - 396.D0*Hr2(0,0)*x + 224.D0/3.D0*Hr2(0,0)*  &
     &    x**2 + 32.D0*Hr2(0,0)*z2 + 32.D0*Hr2(0,0)*z2*x + 64.D0*Hr2(0, &
     &    1) + 20.D0*Hr2(0,1)*x + 64.D0/3.D0*Hr2(0,1)*x**2 - 64.D0*Hr2( &
     &    0,1)*z2 )                                                     
      ggg2 = ggg2 + nf*cf**2 * (  - 64.D0*Hr2(0,1)*z2*x - 184.D0/3.D0*  &
     &    Hr2(1,0) + 40.D0/3.D0*Hr2(1,0)*x + 224.D0/3.D0*Hr2(1,0)*x**2  &
     &     - 80.D0/3.D0*Hr2(1,0)*dx - 28.D0/3.D0*Hr2(1,1) + 28.D0/3.D0* &
     &    Hr2(1,1)*x + 64.D0/3.D0*Hr2(1,1)*x**2 - 64.D0/3.D0*Hr2(1,1)*  &
     &    dx - 128.D0*Hr3(-1,-1,0) - 128.D0*Hr3(-1,-1,0)*x + 128.D0/3.D0&
     &    *Hr3(-1,-1,0)*x**2 + 128.D0/3.D0*Hr3(-1,-1,0)*dx + 64.D0*Hr3( &
     &    -1,0,0) + 64.D0*Hr3(-1,0,0)*x - 64.D0/3.D0*Hr3(-1,0,0)*x**2   &
     &     - 64.D0/3.D0*Hr3(-1,0,0)*dx + 128.D0*Hr3(0,-1,0) - 128.D0/3.D&
     &    0*Hr3(0,-1,0)*x**2 - 24.D0*Hr3(0,0,0) - 88.D0*Hr3(0,0,0)*x +  &
     &    32.D0/3.D0*Hr3(0,0,0)*x**2 - 64.D0*Hr3(0,0,1) - 80.D0*Hr3(0,0 &
     &    ,1)*x - 80.D0*Hr3(0,1,0) - 128.D0*Hr3(0,1,0)*x - 64.D0/3.D0*  &
     &    Hr3(0,1,0)*x**2 - 48.D0*Hr3(0,1,1) - 64.D0*Hr3(0,1,1)*x - 64.D&
     &    0/3.D0*Hr3(0,1,1)*x**2 + 56.D0*Hr3(1,0,0) - 56.D0*Hr3(1,0,0)* &
     &    x - 32.D0/3.D0*Hr3(1,0,0)*x**2 + 32.D0/3.D0*Hr3(1,0,0)*dx +   &
     &    16.D0*Hr3(1,1,0) - 16.D0*Hr3(1,1,0)*x - 64.D0/3.D0*Hr3(1,1,0) &
     &    *x**2 )                                                       
      ggg2 = ggg2 + nf*cf**2 * ( 64.D0/3.D0*Hr3(1,1,0)*dx + 16.D0*Hr3(1 &
     &    ,1,1) - 16.D0*Hr3(1,1,1)*x - 64.D0/3.D0*Hr3(1,1,1)*x**2 + 64.D&
     &    0/3.D0*Hr3(1,1,1)*dx - 128.D0*Hr4(0,-1,-1,0) + 128.D0*Hr4(0,  &
     &    -1,-1,0)*x + 64.D0*Hr4(0,-1,0,0) - 64.D0*Hr4(0,-1,0,0)*x +    &
     &    128.D0*Hr4(0,0,-1,0) - 32.D0*Hr4(0,0,0,0) - 32.D0*Hr4(0,0,0,0 &
     &    )*x - 32.D0*Hr4(0,0,0,1) - 32.D0*Hr4(0,0,0,1)*x + 16.D0*Hr4(0 &
     &    ,0,1,1) + 16.D0*Hr4(0,0,1,1)*x + 48.D0*Hr4(0,1,0,0) + 48.D0*  &
     &    Hr4(0,1,0,0)*x + 32.D0*Hr4(0,1,1,0) + 32.D0*Hr4(0,1,1,0)*x +  &
     &    32.D0*Hr4(0,1,1,1) + 32.D0*Hr4(0,1,1,1)*x )                   
      ggg2 = ggg2 + nf2*ca * (  - 110.D0/27.D0 + 14.D0/3.D0*x - 472.D0  &
     &    /81.D0*x**2 + 472.D0/81.D0*dx - 16.D0/27.D0*dm + 32.D0/9.D0*  &
     &    z2 + 32.D0/9.D0*z2*x + 152.D0/27.D0*Hr1(0) + 86.D0/27.D0*Hr1( &
     &    0)*x + 104.D0/27.D0*Hr1(0)*x**2 + 22.D0/9.D0*Hr1(1) - 22.D0/9.&
     &    D0*Hr1(1)*x + 104.D0/27.D0*Hr1(1)*x**2 - 104.D0/27.D0*Hr1(1)* &
     &    dx - 16.D0/9.D0*Hr2(0,0) - 16.D0/9.D0*Hr2(0,0)*x - 32.D0/9.D0 &
     &    *Hr2(0,1) - 32.D0/9.D0*Hr2(0,1)*x )                           
      ggg2 = ggg2 + nf2*cf * ( 224.D0/9.D0 + 64.D0/9.D0*x - 1360.D0/    &
     &    81.D0*x**2 - 1232.D0/81.D0*dx - 16.D0/3.D0*z3 - 16.D0/3.D0*z3 &
     &    *x + 16.D0/9.D0*z2 + 64.D0/9.D0*z2*x - 32.D0/9.D0*z2*x**2 -   &
     &    352.D0/27.D0*Hr1(0) + 1088.D0/27.D0*Hr1(0)*x + 176.D0/27.D0*  &
     &    Hr1(0)*x**2 + 32.D0/3.D0*Hr1(0)*z2 + 32.D0/3.D0*Hr1(0)*z2*x   &
     &     - 104.D0/3.D0*Hr1(1) + 56.D0/3.D0*Hr1(1)*x + 176.D0/27.D0*   &
     &    Hr1(1)*x**2 + 256.D0/27.D0*Hr1(1)*dx + 184.D0/9.D0*Hr2(0,0)   &
     &     + 232.D0/9.D0*Hr2(0,0)*x + 64.D0/9.D0*Hr2(0,0)*x**2 - 16.D0/ &
     &    9.D0*Hr2(0,1) - 64.D0/9.D0*Hr2(0,1)*x + 32.D0/9.D0*Hr2(0,1)*  &
     &    x**2 - 16.D0/3.D0*Hr2(1,0) + 16.D0/3.D0*Hr2(1,0)*x + 64.D0/9.D&
     &    0*Hr2(1,0)*x**2 - 64.D0/9.D0*Hr2(1,0)*dx - 8.D0/3.D0*Hr2(1,1) &
     &     + 8.D0/3.D0*Hr2(1,1)*x + 32.D0/9.D0*Hr2(1,1)*x**2 - 32.D0/9.D&
     &    0*Hr2(1,1)*dx - 16.D0/3.D0*Hr3(0,0,0) - 16.D0/3.D0*Hr3(0,0,0) &
     &    *x - 32.D0/3.D0*Hr3(0,0,1) - 32.D0/3.D0*Hr3(0,0,1)*x - 32.D0/ &
     &    3.D0*Hr3(0,1,0) - 32.D0/3.D0*Hr3(0,1,0)*x - 16.D0/3.D0*Hr3(0, &
     &    1,1) )                                                        
      ggg2 = ggg2 + nf2*cf * (  - 16.D0/3.D0*Hr3(0,1,1)*x ) 
!                                                                       
! ...The soft (`+'-distribution) part of the splitting function         
!
      ! GPS: how included from module QCD
!       A3G =                                                            &
!     &      ca**3    * ( + 490.D0/3.D0 + 88.D0/3.D0*z3 - 1072.D0/9.D0*z2&
!     &                   + 176.D0/5.D0*z2**2 )                          &
!     &    + ca**2*nf * ( - 836./27.D0 + 160./9.D0*z2 - 112./3.D0*z3 )   &
!     &    + ca*cf*nf * ( - 110./3.D0 + 32.*z3 ) - ca*nf2 * 16./27.D0    
!                                                                       
       GGG2L = DM * A3G 
!                                                                       
! ...The regular piece of the splitting function                        
!                                                                       
       X2GGA = GGG2 - GGG2L 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..The singular (soft) piece of P_gg^(2).                              
!                                                                       
       FUNCTION X2GGB (Y, NF) 
       IMPLICIT REAL*8 (A - Z) 
       INTEGER NF 
!                                                                       
!       COMMON / P2GSOFT / A3G 
!                                                                       
       X2GGB  = A3G/(1.D0-Y) 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..The 'local' piece of P_gg^(2).                                      
!                                                                       
       FUNCTION X2GGC (Y, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       INTEGER NF, NF2 
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0,                    &
     &             Z5 = 1.0369 27755 14336 99263 D0 )                   
!                                                                       
!       COMMON / P2GSOFT / A3G 
!                                                                       
! ...Colour factors                                                     
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
! ...The coefficient of delta(1-x)                                      
!                                                                       
       P2GDELT =                                                        &
     &    + 79.D0/2.D0*ca**3                                            &
     &    + 8.D0/3.D0*z2*ca**3                                          &
     &    + 22.D0/3.D0*z2**2*ca**3                                      &
     &    + 536.D0/3.D0*z3*ca**3                                        &
     &    - 16.D0*z2*z3*ca**3                                           &
     &    - 80.D0*z5*ca**3                                              &
     &    + cf**2*nf                                                    &
     &    - 233.D0/18*ca**2*nf                                          &
     &    - 8.D0/3.D0*z2*ca**2*nf                                       &
     &    - 80.D0/3.D0*z3*ca**2*nf                                      &
     &    - 4.D0/3.D0*z2**2*ca**2*nf                                    &
     &    - 241.D0/18.D0*ca*cf*nf                                       &
     &    + 29.D0/18.D0*ca*nf2                                          &
     &    + 11.D0/9.D0*cf*nf2                                           
!                                                                       
       X2GGC = LOG (1.D0-Y) * A3G + P2GDELT 
!                                                                       
       RETURN 
      END FUNCTION
      end module xpij2e
