!  $Id: xpns2e.f,v 1.2 2004/09/18 14:39:38 salam Exp $ 
!  Automatically generated from f77 file, with inclusion of modules
!  and the placement inside a module (and some other stuff).
      module xpns2e
      use qcd, only: cf, ca, A3 => mvv_A3
      character(len=*), parameter :: name_xpns2 = "xpns2e"
      contains
!                                                                       
! ..File: xpns2e.f                                                      
!                                                                       
!                                                                       
! ..The exact 3-loop MS(bar) non-singlet splitting functions P_NS^(2)   
!    for the evolution of unpolarized partons densities, mu_r = mu_f.   
!    The expansion parameter is alpha_s/(4 pi).                         
!                                                                       
! ..The distributions (in the mathematical sense) are given as in eq.   
!    (B.26) of Floratos, Kounnas, Lacaze: Nucl. Phys. B192 (1981) 417.  
!    The name-endings A, B, and C of the functions below correspond to  
!    the kernel superscripts [2], [3], and [1] in that equation.        
!                                                                       
! ..The code uses the package of Gehrmann and Remiddi for the harmonic  
!    polylogarithms published in hep-ph/0107173 = CPC 141 (2001) 296.   
!                                                                       
! ..References: S. Moch, J. Vermaseren and A. Vogt,                     
!               hep-ph/0209100 = Nucl. Phys. B646 (2002) 181,           
!               hep-ph/0403192 (submitted to Nucl. Phys. B)             
!                                                                       
! ===================================================================== 
!                                                                       
!                                                                       
! ..This is the regular piece of P_NS+                                  
!                                                                       
       FUNCTION X2NSPA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0,                    &
     &             Z5 = 1.0369 27755 14336 99263 D0 )                   
!                                                                       
! ..The soft coefficient for use in X2NSPB and X2NSPC                   
!                                                                       
!       COMMON / P2SOFT / A3 
!                                                                       
! ...Colour factors                                                     
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
! ...Some abbreviations                                                 
!                                                                       
       DX = 1.D0/X 
       DM = 1.D0/(1.D0-X) 
       DP = 1.D0/(1.D0+X) 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!    (without the delta(1-x) part, but with the soft contribution)      
!                                                                       
      gqq2 =                                                            &
     &  + cf*ca**2 * ( 5327.D0/27.D0 - 9737.D0/27.D0*x + 490.D0/3.D0*dm &
     &     - 224.D0*z3*x - 88.D0*z3*dp + 16.D0*z3*dm - 112.D0*z2 + 448.D&
     &    0/9.D0*z2*x + 1072.D0/9.D0*z2*dp - 1072.D0/9.D0*z2*dm - 62.D0/&
     &    5.D0*z2**2 - 242.D0/5.D0*z2**2*x - 32.D0*z2**2*dp + 384.D0/5.D&
     &    0*z2**2*dm - 192.D0*Hr1(-1)*z3 + 192.D0*Hr1(-1)*z3*x + 384.D0 &
     &    *Hr1(-1)*z3*dp + 208.D0/3.D0*Hr1(-1)*z2 + 560.D0/3.D0*Hr1(-1) &
     &    *z2*x + 352.D0/3.D0*Hr1(-1)*z2*dp + 410.D0/27.D0*Hr1(0) -     &
     &    8686.D0/27.D0*Hr1(0)*x - 24.D0*Hr1(0)*dp + 4172.D0/27.D0*Hr1( &
     &    0)*dm - 144.D0*Hr1(0)*z3*x - 128.D0*Hr1(0)*z3*dp + 128.D0*    &
     &    Hr1(0)*z3*dm - 4.D0*Hr1(0)*z2 - 148.D0/3.D0*Hr1(0)*z2*x - 16.D&
     &    0/3.D0*Hr1(0)*z2*dp - 248.D0/3.D0*Hr1(0)*z2*dm + 176.D0*Hr1(1 &
     &    ) - 176.D0*Hr1(1)*x - 144.D0*Hr1(1)*z3 - 144.D0*Hr1(1)*z3*x   &
     &     + 288.D0*Hr1(1)*z3*dm + 32.D0*Hr1(1)*z2 - 32.D0*Hr1(1)*z2*x  &
     &     + 256.D0*Hr2(-1,-1)*z2 - 256.D0*Hr2(-1,-1)*z2*x - 512.D0*    &
     &    Hr2(-1,-1)*z2*dp - 688.D0/9.D0*Hr2(-1,0) + 1456.D0/9.D0*Hr2(  &
     &    -1,0)*x )                                                     
      gqq2 = gqq2 + cf*ca**2 * ( 2144.D0/9.D0*Hr2(-1,0)*dp - 176.D0*    &
     &    Hr2(-1,0)*z2 + 176.D0*Hr2(-1,0)*z2*x + 352.D0*Hr2(-1,0)*z2*dp &
     &     - 136.D0*Hr2(0,-1)*z2 + 136.D0*Hr2(0,-1)*z2*x + 256.D0*Hr2(0 &
     &    ,-1)*z2*dp - 242.D0/9.D0*Hr2(0,0) - 230.D0/3.D0*Hr2(0,0)*x -  &
     &    1072.D0/9.D0*Hr2(0,0)*dp + 1556.D0/9.D0*Hr2(0,0)*dm + 36.D0*  &
     &    Hr2(0,0)*z2 - 68.D0*Hr2(0,0)*z2*x - 96.D0*Hr2(0,0)*z2*dp +    &
     &    112.D0*Hr2(0,1) + 112.D0*Hr2(0,1)*x - 40.D0*Hr2(0,1)*z2 + 24.D&
     &    0*Hr2(0,1)*z2*x + 64.D0*Hr2(0,1)*z2*dp + 16.D0*Hr2(1,0)*z2 +  &
     &    16.D0*Hr2(1,0)*z2*x - 32.D0*Hr2(1,0)*z2*dm + 64.D0*Hr3(-1,-1, &
     &    0) + 64.D0*Hr3(-1,-1,0)*x - 328.D0/3.D0*Hr3(-1,0,0) - 152.D0/ &
     &    3.D0*Hr3(-1,0,0)*x + 176.D0/3.D0*Hr3(-1,0,0)*dp - 112.D0/3.D0 &
     &    *Hr3(-1,0,1) - 464.D0/3.D0*Hr3(-1,0,1)*x - 352.D0/3.D0*Hr3(-1 &
     &    ,0,1)*dp - 88.D0/3.D0*Hr3(0,-1,0) + 40.D0/3.D0*Hr3(0,-1,0)*x  &
     &     + 176.D0/3.D0*Hr3(0,-1,0)*dp - 48.D0*Hr3(0,-1,0)*dm - 128.D0/&
     &    3.D0*Hr3(0,0,0)*x - 248.D0/3.D0*Hr3(0,0,0)*dp + 248.D0/3.D0*  &
     &    Hr3(0,0,0)*dm )                                               
      gqq2 = gqq2 + cf*ca**2 * ( 4.D0*Hr3(0,0,1) + 188.D0/3.D0*Hr3(0,0, &
     &    1)*x + 176.D0/3.D0*Hr3(0,0,1)*dp + 88.D0/3.D0*Hr3(0,0,1)*dm   &
     &     + 12.D0*Hr3(1,0,0) + 76.D0*Hr3(1,0,0)*x - 88.D0*Hr3(1,0,0)*  &
     &    dm - 128.D0*Hr4(-1,-1,0,0) + 128.D0*Hr4(-1,-1,0,0)*x + 256.D0 &
     &    *Hr4(-1,-1,0,0)*dp - 256.D0*Hr4(-1,-1,0,1) + 256.D0*Hr4(-1,-1 &
     &    ,0,1)*x + 512.D0*Hr4(-1,-1,0,1)*dp + 48.D0*Hr4(-1,0,0,0) - 48.&
     &    D0*Hr4(-1,0,0,0)*x - 96.D0*Hr4(-1,0,0,0)*dp + 128.D0*Hr4(-1,0 &
     &    ,0,1) - 128.D0*Hr4(-1,0,0,1)*x - 256.D0*Hr4(-1,0,0,1)*dp - 80.&
     &    D0*Hr4(0,-1,-1,0) - 48.D0*Hr4(0,-1,-1,0)*x + 128.D0*Hr4(0,-1, &
     &    -1,0)*dm + 88.D0*Hr4(0,-1,0,0) - 56.D0*Hr4(0,-1,0,0)*x - 128.D&
     &    0*Hr4(0,-1,0,0)*dp - 32.D0*Hr4(0,-1,0,0)*dm + 96.D0*Hr4(0,-1, &
     &    0,1) - 160.D0*Hr4(0,-1,0,1)*x - 256.D0*Hr4(0,-1,0,1)*dp + 64.D&
     &    0*Hr4(0,-1,0,1)*dm + 8.D0*Hr4(0,0,-1,0) - 40.D0*Hr4(0,0,-1,0) &
     &    *x - 32.D0*Hr4(0,0,-1,0)*dp + 32.D0*Hr4(0,0,-1,0)*dm + 40.D0* &
     &    Hr4(0,0,0,0)*x + 32.D0*Hr4(0,0,0,0)*dp - 32.D0*Hr4(0,0,0,0)*  &
     &    dm )                                                          
      gqq2 = gqq2 + cf*ca**2 * (  - 36.D0*Hr4(0,0,0,1) + 28.D0*Hr4(0,0, &
     &    0,1)*x + 64.D0*Hr4(0,0,0,1)*dp + 32.D0*Hr4(0,0,0,1)*dm + 28.D0&
     &    *Hr4(0,1,0,0) + 28.D0*Hr4(0,1,0,0)*x - 64.D0*Hr4(0,1,0,0)*dm  &
     &     - 96.D0*Hr4(1,0,-1,0) - 96.D0*Hr4(1,0,-1,0)*x + 192.D0*Hr4(1 &
     &    ,0,-1,0)*dm + 48.D0*Hr4(1,0,0,0) + 48.D0*Hr4(1,0,0,0)*x - 96.D&
     &    0*Hr4(1,0,0,0)*dm - 64.D0*Hr4(1,0,0,1) - 64.D0*Hr4(1,0,0,1)*x &
     &     + 128.D0*Hr4(1,0,0,1)*dm + 64.D0*Hr4(1,1,0,0) + 64.D0*Hr4(1, &
     &    1,0,0)*x - 128.D0*Hr4(1,1,0,0)*dm )                           
      gqq2 = gqq2 + cf**2*ca * ( 532.D0/9.D0 - 532.D0/9.D0*x - 16.D0/3.D&
     &    0*z3 + 2336.D0/3.D0*z3*x + 248.D0*z3*dp + 80.D0/3.D0*z3*dm +  &
     &    3448.D0/9.D0*z2 + 2024.D0/9.D0*z2*x - 2144.D0/9.D0*z2*dp - 24.&
     &    D0/5.D0*z2**2 + 56.D0/5.D0*z2**2*x + 8.D0*z2**2*dp - 552.D0/5.&
     &    D0*z2**2*dm + 672.D0*Hr1(-1)*z3 - 672.D0*Hr1(-1)*z3*x - 1344.D&
     &    0*Hr1(-1)*z3*dp - 992.D0/3.D0*Hr1(-1)*z2 - 1984.D0/3.D0*Hr1(  &
     &    -1)*z2*x - 992.D0/3.D0*Hr1(-1)*z2*dp + 628.D0/9.D0*Hr1(0) +   &
     &    572.D0*Hr1(0)*x + 72.D0*Hr1(0)*dp - 302.D0/3.D0*Hr1(0)*dm -   &
     &    144.D0*Hr1(0)*z3 + 400.D0*Hr1(0)*z3*x + 464.D0*Hr1(0)*z3*dp   &
     &     - 272.D0*Hr1(0)*z3*dm + 72.D0*Hr1(0)*z2 + 1208.D0/3.D0*Hr1(0 &
     &    )*z2*x + 104.D0/3.D0*Hr1(0)*z2*dp + 328.D0/3.D0*Hr1(0)*z2*dm  &
     &     - 1672.D0/3.D0*Hr1(1) + 1672.D0/3.D0*Hr1(1)*x + 384.D0*Hr1(1 &
     &    )*z3 + 384.D0*Hr1(1)*z3*x - 768.D0*Hr1(1)*z3*dm - 112.D0*Hr1( &
     &    1)*z2 + 112.D0*Hr1(1)*z2*x - 896.D0*Hr2(-1,-1)*z2 + 896.D0*   &
     &    Hr2(-1,-1)*z2*x + 1792.D0*Hr2(-1,-1)*z2*dp + 1520.D0/9.D0*    &
     &    Hr2(-1,0) )                                                   
      gqq2 = gqq2 + cf**2*ca * (  - 2768.D0/9.D0*Hr2(-1,0)*x - 4288.D0/ &
     &    9.D0*Hr2(-1,0)*dp + 672.D0*Hr2(-1,0)*z2 - 672.D0*Hr2(-1,0)*z2 &
     &    *x - 1344.D0*Hr2(-1,0)*z2*dp + 576.D0*Hr2(0,-1)*z2 - 480.D0*  &
     &    Hr2(0,-1)*z2*x - 1024.D0*Hr2(0,-1)*z2*dp - 96.D0*Hr2(0,-1)*z2 &
     &    *dm - 88.D0/3.D0*Hr2(0,0) - 2560.D0/9.D0*Hr2(0,0)*x + 2144.D0/&
     &    9.D0*Hr2(0,0)*dp - 104.D0*Hr2(0,0)*dm - 96.D0*Hr2(0,0)*z2 +   &
     &    352.D0*Hr2(0,0)*z2*x + 416.D0*Hr2(0,0)*z2*dp - 128.D0*Hr2(0,0 &
     &    )*z2*dm - 3448.D0/9.D0*Hr2(0,1) - 4792.D0/9.D0*Hr2(0,1)*x +   &
     &    2144.D0/9.D0*Hr2(0,1)*dm + 160.D0*Hr2(0,1)*z2 - 64.D0*Hr2(0,1 &
     &    )*z2*x - 224.D0*Hr2(0,1)*z2*dp - 64.D0*Hr2(0,1)*z2*dm - 400.D0&
     &    /9.D0*Hr2(1,0) - 1744.D0/9.D0*Hr2(1,0)*x + 2144.D0/9.D0*Hr2(1 &
     &    ,0)*dm + 32.D0*Hr2(1,0)*z2 + 32.D0*Hr2(1,0)*z2*x - 64.D0*Hr2( &
     &    1,0)*z2*dm - 224.D0*Hr3(-1,-1,0) - 224.D0*Hr3(-1,-1,0)*x +    &
     &    1352.D0/3.D0*Hr3(-1,0,0) + 856.D0/3.D0*Hr3(-1,0,0)*x - 496.D0/&
     &    3.D0*Hr3(-1,0,0)*dp + 656.D0/3.D0*Hr3(-1,0,1) + 1648.D0/3.D0* &
     &    Hr3(-1,0,1)*x )                                               
      gqq2 = gqq2 + cf**2*ca * ( 992.D0/3.D0*Hr3(-1,0,1)*dp + 368.D0/3.D&
     &    0*Hr3(0,-1,0) + 208.D0/3.D0*Hr3(0,-1,0)*x - 496.D0/3.D0*Hr3(0 &
     &    ,-1,0)*dp + 96.D0*Hr3(0,-1,0)*dm - 132.D0*Hr3(0,0,0) - 476.D0/&
     &    3.D0*Hr3(0,0,0)*x + 712.D0/3.D0*Hr3(0,0,0)*dp - 184.D0/3.D0*  &
     &    Hr3(0,0,0)*dm - 72.D0*Hr3(0,0,1) - 1000.D0/3.D0*Hr3(0,0,1)*x  &
     &     - 496.D0/3.D0*Hr3(0,0,1)*dp + 64.D0/3.D0*Hr3(0,0,1)*dm - 176.&
     &    D0/3.D0*Hr3(0,1,0) - 176.D0/3.D0*Hr3(0,1,0)*x + 352.D0/3.D0*  &
     &    Hr3(0,1,0)*dm - 304.D0/3.D0*Hr3(1,0,0) - 688.D0/3.D0*Hr3(1,0, &
     &    0)*x + 992.D0/3.D0*Hr3(1,0,0)*dm + 576.D0*Hr4(-1,-1,0,0) -    &
     &    576.D0*Hr4(-1,-1,0,0)*x - 1152.D0*Hr4(-1,-1,0,0)*dp + 896.D0* &
     &    Hr4(-1,-1,0,1) - 896.D0*Hr4(-1,-1,0,1)*x - 1792.D0*Hr4(-1,-1, &
     &    0,1)*dp + 64.D0*Hr4(-1,0,-1,0) - 64.D0*Hr4(-1,0,-1,0)*x - 128.&
     &    D0*Hr4(-1,0,-1,0)*dp - 272.D0*Hr4(-1,0,0,0) + 272.D0*Hr4(-1,0 &
     &    ,0,0)*x + 544.D0*Hr4(-1,0,0,0)*dp - 512.D0*Hr4(-1,0,0,1) +    &
     &    512.D0*Hr4(-1,0,0,1)*x + 1024.D0*Hr4(-1,0,0,1)*dp - 32.D0*    &
     &    Hr4(-1,0,1,0) )                                               
      gqq2 = gqq2 + cf**2*ca * ( 32.D0*Hr4(-1,0,1,0)*x + 64.D0*Hr4(-1,0 &
     &    ,1,0)*dp + 320.D0*Hr4(0,-1,-1,0) + 128.D0*Hr4(0,-1,-1,0)*x -  &
     &    128.D0*Hr4(0,-1,-1,0)*dp - 448.D0*Hr4(0,-1,-1,0)*dm - 464.D0* &
     &    Hr4(0,-1,0,0) + 304.D0*Hr4(0,-1,0,0)*x + 672.D0*Hr4(0,-1,0,0) &
     &    *dp + 160.D0*Hr4(0,-1,0,0)*dm - 416.D0*Hr4(0,-1,0,1) + 544.D0 &
     &    *Hr4(0,-1,0,1)*x + 960.D0*Hr4(0,-1,0,1)*dp - 128.D0*Hr4(0,-1, &
     &    0,1)*dm - 128.D0*Hr4(0,0,-1,0) + 128.D0*Hr4(0,0,-1,0)*x + 160.&
     &    D0*Hr4(0,0,-1,0)*dp - 32.D0*Hr4(0,0,-1,0)*dm - 224.D0*Hr4(0,0 &
     &    ,0,0)*x - 160.D0*Hr4(0,0,0,0)*dp + 160.D0*Hr4(0,0,0,0)*dm +   &
     &    96.D0*Hr4(0,0,0,1) - 224.D0*Hr4(0,0,0,1)*x - 320.D0*Hr4(0,0,0 &
     &    ,1)*dp + 32.D0*Hr4(0,0,0,1)*dm - 32.D0*Hr4(0,0,1,0)*x - 32.D0 &
     &    *Hr4(0,0,1,0)*dp + 32.D0*Hr4(0,0,1,0)*dm - 48.D0*Hr4(0,1,0,0) &
     &     - 48.D0*Hr4(0,1,0,0)*x + 160.D0*Hr4(0,1,0,0)*dm + 256.D0*    &
     &    Hr4(1,0,-1,0) + 256.D0*Hr4(1,0,-1,0)*x - 512.D0*Hr4(1,0,-1,0) &
     &    *dm - 176.D0*Hr4(1,0,0,0) - 176.D0*Hr4(1,0,0,0)*x + 352.D0*   &
     &    Hr4(1,0,0,0)*dm )                                             
      gqq2 = gqq2 + cf**2*ca * ( 128.D0*Hr4(1,0,0,1) + 128.D0*Hr4(1,0,0 &
     &    ,1)*x - 256.D0*Hr4(1,0,0,1)*dm - 128.D0*Hr4(1,1,0,0) - 128.D0 &
     &    *Hr4(1,1,0,0)*x + 256.D0*Hr4(1,1,0,0)*dm )                    
      gqq2 = gqq2 + cf**3 * (  - 62.D0 + 62.D0*x - 48.D0*z3 - 720.D0*z3 &
     &    *x - 144.D0*z3*dp - 308.D0*z2 - 372.D0*z2*x - 56.D0/5.D0*     &
     &    z2**2 + 504.D0/5.D0*z2**2*x + 112.D0*z2**2*dp + 144.D0/5.D0*  &
     &    z2**2*dm - 576.D0*Hr1(-1)*z3 + 576.D0*Hr1(-1)*z3*x + 1152.D0* &
     &    Hr1(-1)*z3*dp + 384.D0*Hr1(-1)*z2 + 576.D0*Hr1(-1)*z2*x + 192.&
     &    D0*Hr1(-1)*z2*dp + 24.D0*Hr1(0) - 560.D0*Hr1(0)*x - 48.D0*    &
     &    Hr1(0)*dp - 6.D0*Hr1(0)*dm + 288.D0*Hr1(0)*z3 - 224.D0*Hr1(0) &
     &    *z3*x - 416.D0*Hr1(0)*z3*dp + 32.D0*Hr1(0)*z3*dm - 96.D0*Hr1( &
     &    0)*z2 - 448.D0*Hr1(0)*z2*x - 48.D0*Hr1(0)*z2*dp - 48.D0*Hr1(0 &
     &    )*z2*dm + 560.D0*Hr1(1) - 560.D0*Hr1(1)*x - 192.D0*Hr1(1)*z3  &
     &     - 192.D0*Hr1(1)*z3*x + 384.D0*Hr1(1)*z3*dm + 96.D0*Hr1(1)*z2 &
     &     - 96.D0*Hr1(1)*z2*x + 768.D0*Hr2(-1,-1)*z2 - 768.D0*Hr2(-1,  &
     &    -1)*z2*x - 1536.D0*Hr2(-1,-1)*z2*dp - 32.D0*Hr2(-1,0) - 32.D0 &
     &    *Hr2(-1,0)*x - 640.D0*Hr2(-1,0)*z2 + 640.D0*Hr2(-1,0)*z2*x +  &
     &    1280.D0*Hr2(-1,0)*z2*dp - 608.D0*Hr2(0,-1)*z2 + 416.D0*Hr2(0, &
     &    -1)*z2*x )                                                    
      gqq2 = gqq2 + cf**3 * ( 1024.D0*Hr2(0,-1)*z2*dp + 192.D0*Hr2(0,-1 &
     &    )*z2*dm - 44.D0*Hr2(0,0) + 356.D0*Hr2(0,0)*x + 52.D0*Hr2(0,0) &
     &    *dm + 240.D0*Hr2(0,0)*z2 - 240.D0*Hr2(0,0)*z2*x - 448.D0*Hr2( &
     &    0,0)*z2*dp + 308.D0*Hr2(0,1) + 340.D0*Hr2(0,1)*x - 96.D0*Hr2( &
     &    0,1)*z2 + 96.D0*Hr2(0,1)*z2*x + 192.D0*Hr2(0,1)*z2*dp - 16.D0 &
     &    *Hr2(1,0) + 16.D0*Hr2(1,0)*x + 192.D0*Hr3(-1,-1,0) + 192.D0*  &
     &    Hr3(-1,-1,0)*x - 464.D0*Hr3(-1,0,0) - 368.D0*Hr3(-1,0,0)*x +  &
     &    96.D0*Hr3(-1,0,0)*dp - 288.D0*Hr3(-1,0,1) - 480.D0*Hr3(-1,0,1 &
     &    )*x - 192.D0*Hr3(-1,0,1)*dp - 128.D0*Hr3(0,-1,0) - 192.D0*    &
     &    Hr3(0,-1,0)*x + 96.D0*Hr3(0,-1,0)*dp + 120.D0*Hr3(0,0,0) +    &
     &    248.D0*Hr3(0,0,0)*x - 144.D0*Hr3(0,0,0)*dp + 96.D0*Hr3(0,0,1) &
     &     + 256.D0*Hr3(0,0,1)*x + 96.D0*Hr3(0,0,1)*dp + 72.D0*Hr3(0,1, &
     &    0) + 8.D0*Hr3(0,1,0)*x - 96.D0*Hr3(0,1,0)*dm + 96.D0*Hr3(1,0, &
     &    0) + 96.D0*Hr3(1,0,0)*x - 192.D0*Hr3(1,0,0)*dm - 640.D0*Hr4(  &
     &    -1,-1,0,0) + 640.D0*Hr4(-1,-1,0,0)*x + 1280.D0*Hr4(-1,-1,0,0) &
     &    *dp )                                                         
      gqq2 = gqq2 + cf**3 * (  - 768.D0*Hr4(-1,-1,0,1) + 768.D0*Hr4(-1, &
     &    -1,0,1)*x + 1536.D0*Hr4(-1,-1,0,1)*dp - 128.D0*Hr4(-1,0,-1,0) &
     &     + 128.D0*Hr4(-1,0,-1,0)*x + 256.D0*Hr4(-1,0,-1,0)*dp + 352.D0&
     &    *Hr4(-1,0,0,0) - 352.D0*Hr4(-1,0,0,0)*x - 704.D0*Hr4(-1,0,0,0 &
     &    )*dp + 512.D0*Hr4(-1,0,0,1) - 512.D0*Hr4(-1,0,0,1)*x - 1024.D0&
     &    *Hr4(-1,0,0,1)*dp + 64.D0*Hr4(-1,0,1,0) - 64.D0*Hr4(-1,0,1,0) &
     &    *x - 128.D0*Hr4(-1,0,1,0)*dp - 320.D0*Hr4(0,-1,-1,0) - 64.D0* &
     &    Hr4(0,-1,-1,0)*x + 256.D0*Hr4(0,-1,-1,0)*dp + 384.D0*Hr4(0,-1 &
     &    ,-1,0)*dm + 576.D0*Hr4(0,-1,0,0) - 384.D0*Hr4(0,-1,0,0)*x -   &
     &    832.D0*Hr4(0,-1,0,0)*dp - 192.D0*Hr4(0,-1,0,0)*dm + 448.D0*   &
     &    Hr4(0,-1,0,1) - 448.D0*Hr4(0,-1,0,1)*x - 896.D0*Hr4(0,-1,0,1) &
     &    *dp + 224.D0*Hr4(0,0,-1,0) - 96.D0*Hr4(0,0,-1,0)*x - 192.D0*  &
     &    Hr4(0,0,-1,0)*dp - 64.D0*Hr4(0,0,-1,0)*dm - 112.D0*Hr4(0,0,0, &
     &    0) + 176.D0*Hr4(0,0,0,0)*x + 192.D0*Hr4(0,0,0,0)*dp - 64.D0*  &
     &    Hr4(0,0,0,0)*dm - 240.D0*Hr4(0,0,0,1) + 144.D0*Hr4(0,0,0,1)*x &
     &     + 384.D0*Hr4(0,0,0,1)*dp )                                   
      gqq2 = gqq2 + cf**3 * ( 64.D0*Hr4(0,0,0,1)*dm - 128.D0*Hr4(0,0,1, &
     &    0) - 64.D0*Hr4(0,0,1,0)*x + 64.D0*Hr4(0,0,1,0)*dp + 128.D0*   &
     &    Hr4(0,0,1,0)*dm - 64.D0*Hr4(0,0,1,1) - 64.D0*Hr4(0,0,1,1)*x   &
     &     + 128.D0*Hr4(0,0,1,1)*dm - 80.D0*Hr4(0,1,0,0) - 80.D0*Hr4(0, &
     &    1,0,0)*x + 64.D0*Hr4(0,1,0,0)*dm - 64.D0*Hr4(0,1,0,1) - 64.D0 &
     &    *Hr4(0,1,0,1)*x + 128.D0*Hr4(0,1,0,1)*dm - 64.D0*Hr4(0,1,1,0) &
     &     - 64.D0*Hr4(0,1,1,0)*x + 128.D0*Hr4(0,1,1,0)*dm - 128.D0*    &
     &    Hr4(1,0,-1,0) - 128.D0*Hr4(1,0,-1,0)*x + 256.D0*Hr4(1,0,-1,0) &
     &    *dm + 64.D0*Hr4(1,0,0,0) + 64.D0*Hr4(1,0,0,0)*x - 128.D0*Hr4( &
     &    1,0,0,0)*dm - 128.D0*Hr4(1,0,0,1) - 128.D0*Hr4(1,0,0,1)*x +   &
     &    256.D0*Hr4(1,0,0,1)*dm - 64.D0*Hr4(1,0,1,0) - 64.D0*Hr4(1,0,1 &
     &    ,0)*x + 128.D0*Hr4(1,0,1,0)*dm )                              
!                                                                       
      gqq2 = gqq2                                                       &
     &  + nf*cf*ca * (  - 182.D0/3.D0 + 160.D0/9.D0*z2*dm - 160.D0/9.D0 &
     &    *z2*dp - 184.D0/9.D0*z2*x + 8.D0*z2 - 48.D0*z3*dm + 16.D0*z3* &
     &    dp + 32.D0*z3*x + 16.D0*z3 - 836.D0/27.D0*dm + 2474.D0/27.D0* &
     &    x - 64.D0/3.D0*Hr1(-1)*z2*dp - 32.D0/3.D0*Hr1(-1)*z2*x + 32.D0&
     &    /3.D0*Hr1(-1)*z2 + 68.D0/27.D0*Hr1(0) + 32.D0/3.D0*Hr1(0)*z2* &
     &    dm + 16.D0/3.D0*Hr1(0)*z2*dp - 8.D0/3.D0*Hr1(0)*z2*x - 8.D0*  &
     &    Hr1(0)*z2 - 1336.D0/27.D0*Hr1(0)*dm + 1700.D0/27.D0*Hr1(0)*x  &
     &     - 16.D0*Hr1(1) + 16.D0*Hr1(1)*x + 64.D0/9.D0*Hr2(-1,0) - 320.&
     &    D0/9.D0*Hr2(-1,0)*dp - 256.D0/9.D0*Hr2(-1,0)*x + 88.D0/9.D0*  &
     &    Hr2(0,0) - 112.D0/3.D0*Hr2(0,0)*dm + 160.D0/9.D0*Hr2(0,0)*dp  &
     &     + 272.D0/9.D0*Hr2(0,0)*x - 8.D0*Hr2(0,1) - 8.D0*Hr2(0,1)*x   &
     &     + 16.D0/3.D0*Hr3(-1,0,0) - 32.D0/3.D0*Hr3(-1,0,0)*dp - 16.D0/&
     &    3.D0*Hr3(-1,0,0)*x - 32.D0/3.D0*Hr3(-1,0,1) + 64.D0/3.D0*Hr3( &
     &    -1,0,1)*dp + 32.D0/3.D0*Hr3(-1,0,1)*x + 16.D0/3.D0*Hr3(0,-1,0 &
     &    ) - 32.D0/3.D0*Hr3(0,-1,0)*dp - 16.D0/3.D0*Hr3(0,-1,0)*x - 32.&
     &    D0/3.D0*Hr3(0,0,0)*dm )                                       
      gqq2 = gqq2 + nf*cf*ca * ( 32.D0/3.D0*Hr3(0,0,0)*dp + 32.D0/3.D0* &
     &    Hr3(0,0,0)*x + 8.D0*Hr3(0,0,1) - 16.D0/3.D0*Hr3(0,0,1)*dm -   &
     &    32.D0/3.D0*Hr3(0,0,1)*dp - 8.D0/3.D0*Hr3(0,0,1)*x - 8.D0*Hr3( &
     &    1,0,0) + 16.D0*Hr3(1,0,0)*dm - 8.D0*Hr3(1,0,0)*x )            
      gqq2 = gqq2 + nf*cf**2 * ( 5.D0/9.D0 + 320.D0/9.D0*z2*dp + 160.D0/&
     &    9.D0*z2*x - 160.D0/9.D0*z2 + 160.D0/3.D0*z3*dm - 32.D0*z3*dp  &
     &     - 128.D0/3.D0*z3*x - 32.D0/3.D0*z3 - 110.D0/3.D0*dm + 325.D0/&
     &    9.D0*x + 128.D0/3.D0*Hr1(-1)*z2*dp + 64.D0/3.D0*Hr1(-1)*z2*x  &
     &     - 64.D0/3.D0*Hr1(-1)*z2 - 148.D0/9.D0*Hr1(0) + 32.D0/3.D0*   &
     &    Hr1(0)*z2*dm - 32.D0/3.D0*Hr1(0)*z2*dp - 32.D0/3.D0*Hr1(0)*z2 &
     &    *x + 20.D0/3.D0*Hr1(0)*dm - 20.D0*Hr1(0)*x + 64.D0/3.D0*Hr1(1 &
     &    ) - 64.D0/3.D0*Hr1(1)*x - 128.D0/9.D0*Hr2(-1,0) + 640.D0/9.D0 &
     &    *Hr2(-1,0)*dp + 512.D0/9.D0*Hr2(-1,0)*x + 16.D0/3.D0*Hr2(0,0) &
     &     + 16.D0*Hr2(0,0)*dm - 320.D0/9.D0*Hr2(0,0)*dp - 80.D0/9.D0*  &
     &    Hr2(0,0)*x + 160.D0/9.D0*Hr2(0,1) - 320.D0/9.D0*Hr2(0,1)*dm   &
     &     + 352.D0/9.D0*Hr2(0,1)*x + 64.D0/9.D0*Hr2(1,0) - 320.D0/9.D0 &
     &    *Hr2(1,0)*dm + 256.D0/9.D0*Hr2(1,0)*x - 32.D0/3.D0*Hr3(-1,0,0 &
     &    ) + 64.D0/3.D0*Hr3(-1,0,0)*dp + 32.D0/3.D0*Hr3(-1,0,0)*x + 64.&
     &    D0/3.D0*Hr3(-1,0,1) - 128.D0/3.D0*Hr3(-1,0,1)*dp - 64.D0/3.D0 &
     &    *Hr3(-1,0,1)*x )                                              
      gqq2 = gqq2 + nf*cf**2 * (  - 32.D0/3.D0*Hr3(0,-1,0) + 64.D0/3.D0 &
     &    *Hr3(0,-1,0)*dp + 32.D0/3.D0*Hr3(0,-1,0)*x + 24.D0*Hr3(0,0,0) &
     &     - 32.D0/3.D0*Hr3(0,0,0)*dm - 64.D0/3.D0*Hr3(0,0,0)*dp + 8.D0/&
     &    3.D0*Hr3(0,0,0)*x - 64.D0/3.D0*Hr3(0,0,1)*dm + 64.D0/3.D0*    &
     &    Hr3(0,0,1)*dp + 64.D0/3.D0*Hr3(0,0,1)*x + 32.D0/3.D0*Hr3(0,1, &
     &    0) - 64.D0/3.D0*Hr3(0,1,0)*dm + 32.D0/3.D0*Hr3(0,1,0)*x + 64.D&
     &    0/3.D0*Hr3(1,0,0) - 128.D0/3.D0*Hr3(1,0,0)*dm + 64.D0/3.D0*   &
     &    Hr3(1,0,0)*x )                                                
      gqq2 = gqq2 + nf2*cf * ( 112.D0/27.D0 - 16.D0/27.D0*dm - 32.D0/   &
     &    9.D0*x + 8.D0/27.D0*Hr1(0) + 80.D0/27.D0*Hr1(0)*dm - 88.D0/27.&
     &    D0*Hr1(0)*x - 8.D0/9.D0*Hr2(0,0) + 16.D0/9.D0*Hr2(0,0)*dm - 8.&
     &    D0/9.D0*Hr2(0,0)*x )                                          
!                                                                       
! ...The soft (`+'-distribution) part of the splitting function         
!
      ! GPS: now included from module qcd
!       A3 =                                                             &
!     &      ca**2*cf * ( + 490.D0/3.D0 + 88.D0/3.D0*z3 - 1072.D0/9.D0*z2&
!     &                   + 176.D0/5.D0*z2**2 )                          &
!     &    + ca*cf*nf * ( - 836./27.D0 + 160./9.D0*z2 - 112./3.D0*z3 )   &
!     &    + cf**2*nf * ( - 110./3.D0 + 32.*z3 ) - cf*nf2 * 16./27.D0    
!                                                                       
       GQQ2L = DM * A3 
!                                                                       
! ...The regular piece of the splitting function                        
!                                                                       
       X2NSPA = GQQ2 - GQQ2L 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..This is the regular piece of P_NS-                                  
!                                                                       
       FUNCTION X2NSMA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0,                    &
     &             Z5 = 1.0369 27755 14336 99263 D0 )                   
!                                                                       
! ..The soft coefficient for use in X2NSPB and X2NSPC                   
!                                                                       
!       COMMON / P2SOFT / A3 
!                                                                       
! ...Colour factors                                                     
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
! ...Some abbreviations                                                 
!                                                                       
       DX = 1.D0/X 
       DM = 1.D0/(1.D0-X) 
       DP = 1.D0/(1.D0+X) 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!    (without the delta(1-x) part, but with the soft contribution)      
!                                                                       
      gqq2 =  cf*ca**2 * ( 923.D0/27.D0 - 5333.D0/27.D0*x + 490.D0      &
     &    /3.D0*dm + 112.D0*z3 + 48.D0*z3*x + 88.D0*z3*dp + 16.D0*z3*dm &
     &     + 1504.D0/9.D0*z2 + 224.D0/3.D0*z2*x - 1072.D0/9.D0*z2*dp -  &
     &    1072.D0/9.D0*z2*dm - 242.D0/5.D0*z2**2 - 62.D0/5.D0*z2**2*x   &
     &     + 32.D0*z2**2*dp + 384.D0/5.D0*z2**2*dm + 192.D0*Hr1(-1)*z3  &
     &     - 192.D0*Hr1(-1)*z3*x - 384.D0*Hr1(-1)*z3*dp - 208.D0/3.D0*  &
     &    Hr1(-1)*z2 - 560.D0/3.D0*Hr1(-1)*z2*x - 352.D0/3.D0*Hr1(-1)*  &
     &    z2*dp - 1378.D0/27.D0*Hr1(0) - 2266.D0/27.D0*Hr1(0)*x + 24.D0 &
     &    *Hr1(0)*dp + 4172.D0/27.D0*Hr1(0)*dm - 144.D0*Hr1(0)*z3 + 128.&
     &    D0*Hr1(0)*z3*dp + 128.D0*Hr1(0)*z3*dm + 332.D0/3.D0*Hr1(0)*z2 &
     &     + 188.D0*Hr1(0)*z2*x + 16.D0/3.D0*Hr1(0)*z2*dp - 248.D0/3.D0 &
     &    *Hr1(0)*z2*dm - 592.D0/3.D0*Hr1(1) + 592.D0/3.D0*Hr1(1)*x -   &
     &    144.D0*Hr1(1)*z3 - 144.D0*Hr1(1)*z3*x + 288.D0*Hr1(1)*z3*dm   &
     &     - 32.D0*Hr1(1)*z2 + 32.D0*Hr1(1)*z2*x - 256.D0*Hr2(-1,-1)*z2 &
     &     + 256.D0*Hr2(-1,-1)*z2*x + 512.D0*Hr2(-1,-1)*z2*dp + 832.D0/ &
     &    9.D0*Hr2(-1,0) )                                              
      gqq2 = gqq2 + cf*ca**2 * (  - 1312.D0/9.D0*Hr2(-1,0)*x - 2144.D0/ &
     &    9.D0*Hr2(-1,0)*dp + 176.D0*Hr2(-1,0)*z2 - 176.D0*Hr2(-1,0)*z2 &
     &    *x - 352.D0*Hr2(-1,0)*z2*dp + 136.D0*Hr2(0,-1)*z2 - 136.D0*   &
     &    Hr2(0,-1)*z2*x - 256.D0*Hr2(0,-1)*z2*dp - 130.D0*Hr2(0,0) +   &
     &    238.D0/9.D0*Hr2(0,0)*x + 1072.D0/9.D0*Hr2(0,0)*dp + 1556.D0/9.&
     &    D0*Hr2(0,0)*dm - 68.D0*Hr2(0,0)*z2 + 36.D0*Hr2(0,0)*z2*x + 96.&
     &    D0*Hr2(0,0)*z2*dp - 224.D0/3.D0*Hr2(0,1) - 224.D0/3.D0*Hr2(0, &
     &    1)*x + 24.D0*Hr2(0,1)*z2 - 40.D0*Hr2(0,1)*z2*x - 64.D0*Hr2(0, &
     &    1)*z2*dp + 16.D0*Hr2(1,0)*z2 + 16.D0*Hr2(1,0)*z2*x - 32.D0*   &
     &    Hr2(1,0)*z2*dm + 64.D0*Hr3(-1,-1,0) + 64.D0*Hr3(-1,-1,0)*x +  &
     &    232.D0/3.D0*Hr3(-1,0,0) + 56.D0/3.D0*Hr3(-1,0,0)*x - 176.D0/3.&
     &    D0*Hr3(-1,0,0)*dp + 304.D0/3.D0*Hr3(-1,0,1) + 656.D0/3.D0*    &
     &    Hr3(-1,0,1)*x + 352.D0/3.D0*Hr3(-1,0,1)*dp + 328.D0/3.D0*Hr3( &
     &    0,-1,0) - 376.D0/3.D0*Hr3(0,-1,0)*x - 176.D0/3.D0*Hr3(0,-1,0) &
     &    *dp - 48.D0*Hr3(0,-1,0)*dm - 416.D0/3.D0*Hr3(0,0,0) + 248.D0/ &
     &    3.D0*Hr3(0,0,0)*dp )                                          
      gqq2 = gqq2 + cf*ca**2 * ( 248.D0/3.D0*Hr3(0,0,0)*dm - 4.D0/3.D0* &
     &    Hr3(0,0,1) - 188.D0*Hr3(0,0,1)*x - 176.D0/3.D0*Hr3(0,0,1)*dp  &
     &     + 88.D0/3.D0*Hr3(0,0,1)*dm + 12.D0*Hr3(1,0,0) + 76.D0*Hr3(1, &
     &    0,0)*x - 88.D0*Hr3(1,0,0)*dm + 128.D0*Hr4(-1,-1,0,0) - 128.D0 &
     &    *Hr4(-1,-1,0,0)*x - 256.D0*Hr4(-1,-1,0,0)*dp + 256.D0*Hr4(-1, &
     &    -1,0,1) - 256.D0*Hr4(-1,-1,0,1)*x - 512.D0*Hr4(-1,-1,0,1)*dp  &
     &     - 48.D0*Hr4(-1,0,0,0) + 48.D0*Hr4(-1,0,0,0)*x + 96.D0*Hr4(-1 &
     &    ,0,0,0)*dp - 128.D0*Hr4(-1,0,0,1) + 128.D0*Hr4(-1,0,0,1)*x +  &
     &    256.D0*Hr4(-1,0,0,1)*dp - 48.D0*Hr4(0,-1,-1,0) - 80.D0*Hr4(0, &
     &    -1,-1,0)*x + 128.D0*Hr4(0,-1,-1,0)*dm - 56.D0*Hr4(0,-1,0,0)   &
     &     + 88.D0*Hr4(0,-1,0,0)*x + 128.D0*Hr4(0,-1,0,0)*dp - 32.D0*   &
     &    Hr4(0,-1,0,0)*dm - 160.D0*Hr4(0,-1,0,1) + 96.D0*Hr4(0,-1,0,1) &
     &    *x + 256.D0*Hr4(0,-1,0,1)*dp + 64.D0*Hr4(0,-1,0,1)*dm - 40.D0 &
     &    *Hr4(0,0,-1,0) + 8.D0*Hr4(0,0,-1,0)*x + 32.D0*Hr4(0,0,-1,0)*  &
     &    dp + 32.D0*Hr4(0,0,-1,0)*dm + 40.D0*Hr4(0,0,0,0) - 32.D0*Hr4( &
     &    0,0,0,0)*dp )                                                 
      gqq2 = gqq2 + cf*ca**2 * (  - 32.D0*Hr4(0,0,0,0)*dm + 28.D0*Hr4(0 &
     &    ,0,0,1) - 36.D0*Hr4(0,0,0,1)*x - 64.D0*Hr4(0,0,0,1)*dp + 32.D0&
     &    *Hr4(0,0,0,1)*dm + 28.D0*Hr4(0,1,0,0) + 28.D0*Hr4(0,1,0,0)*x  &
     &     - 64.D0*Hr4(0,1,0,0)*dm - 96.D0*Hr4(1,0,-1,0) - 96.D0*Hr4(1, &
     &    0,-1,0)*x + 192.D0*Hr4(1,0,-1,0)*dm + 48.D0*Hr4(1,0,0,0) + 48.&
     &    D0*Hr4(1,0,0,0)*x - 96.D0*Hr4(1,0,0,0)*dm - 64.D0*Hr4(1,0,0,1 &
     &    ) - 64.D0*Hr4(1,0,0,1)*x + 128.D0*Hr4(1,0,0,1)*dm + 64.D0*    &
     &    Hr4(1,1,0,0) + 64.D0*Hr4(1,1,0,0)*x - 128.D0*Hr4(1,1,0,0)*dm  &
     &     )                                                            
      gqq2 = gqq2 + cf**2*ca * ( 1516.D0/3.D0 - 1516.D0/3.D0*x - 832.D0/&
     &    3.D0*z3 - 880.D0/3.D0*z3*x - 248.D0*z3*dp + 80.D0/3.D0*z3*dm  &
     &     - 3880.D0/9.D0*z2 - 152.D0/9.D0*z2*x + 2144.D0/9.D0*z2*dp +  &
     &    56.D0/5.D0*z2**2 - 24.D0/5.D0*z2**2*x - 8.D0*z2**2*dp - 552.D0&
     &    /5.D0*z2**2*dm - 672.D0*Hr1(-1)*z3 + 672.D0*Hr1(-1)*z3*x +    &
     &    1344.D0*Hr1(-1)*z3*dp + 704.D0/3.D0*Hr1(-1)*z2 + 1696.D0/3.D0 &
     &    *Hr1(-1)*z2*x + 992.D0/3.D0*Hr1(-1)*z2*dp + 3404.D0/9.D0*Hr1( &
     &    0) - 3740.D0/9.D0*Hr1(0)*x - 72.D0*Hr1(0)*dp - 302.D0/3.D0*   &
     &    Hr1(0)*dm + 400.D0*Hr1(0)*z3 - 144.D0*Hr1(0)*z3*x - 464.D0*   &
     &    Hr1(0)*z3*dp - 272.D0*Hr1(0)*z3*dm - 904.D0/3.D0*Hr1(0)*z2 -  &
     &    568.D0*Hr1(0)*z2*x - 104.D0/3.D0*Hr1(0)*z2*dp + 328.D0/3.D0*  &
     &    Hr1(0)*z2*dm + 2008.D0/3.D0*Hr1(1) - 2008.D0/3.D0*Hr1(1)*x +  &
     &    384.D0*Hr1(1)*z3 + 384.D0*Hr1(1)*z3*x - 768.D0*Hr1(1)*z3*dm   &
     &     + 112.D0*Hr1(1)*z2 - 112.D0*Hr1(1)*z2*x + 896.D0*Hr2(-1,-1)* &
     &    z2 - 896.D0*Hr2(-1,-1)*z2*x - 1792.D0*Hr2(-1,-1)*z2*dp - 1232.&
     &    D0/9.D0*Hr2(-1,0) )                                           
      gqq2 = gqq2 + cf**2*ca * ( 3056.D0/9.D0*Hr2(-1,0)*x + 4288.D0/9.D0&
     &    *Hr2(-1,0)*dp - 672.D0*Hr2(-1,0)*z2 + 672.D0*Hr2(-1,0)*z2*x   &
     &     + 1344.D0*Hr2(-1,0)*z2*dp - 480.D0*Hr2(0,-1)*z2 + 576.D0*    &
     &    Hr2(0,-1)*z2*x + 1024.D0*Hr2(0,-1)*z2*dp - 96.D0*Hr2(0,-1)*z2 &
     &    *dm + 2168.D0/9.D0*Hr2(0,0) - 944.D0/3.D0*Hr2(0,0)*x - 2144.D0&
     &    /9.D0*Hr2(0,0)*dp - 104.D0*Hr2(0,0)*dm + 352.D0*Hr2(0,0)*z2   &
     &     - 96.D0*Hr2(0,0)*z2*x - 416.D0*Hr2(0,0)*z2*dp - 128.D0*Hr2(0 &
     &    ,0)*z2*dm + 2648.D0/9.D0*Hr2(0,1) + 152.D0/9.D0*Hr2(0,1)*x +  &
     &    2144.D0/9.D0*Hr2(0,1)*dm - 64.D0*Hr2(0,1)*z2 + 160.D0*Hr2(0,1 &
     &    )*z2*x + 224.D0*Hr2(0,1)*z2*dp - 64.D0*Hr2(0,1)*z2*dm + 176.D0&
     &    /9.D0*Hr2(1,0) - 2320.D0/9.D0*Hr2(1,0)*x + 2144.D0/9.D0*Hr2(1 &
     &    ,0)*dm + 32.D0*Hr2(1,0)*z2 + 32.D0*Hr2(1,0)*z2*x - 64.D0*Hr2( &
     &    1,0)*z2*dm - 224.D0*Hr3(-1,-1,0) - 224.D0*Hr3(-1,-1,0)*x -    &
     &    872.D0/3.D0*Hr3(-1,0,0) - 376.D0/3.D0*Hr3(-1,0,0)*x + 496.D0/ &
     &    3.D0*Hr3(-1,0,0)*dp - 1040.D0/3.D0*Hr3(-1,0,1) - 2032.D0/3.D0 &
     &    *Hr3(-1,0,1)*x )                                              
      gqq2 = gqq2 + cf**2*ca * (  - 992.D0/3.D0*Hr3(-1,0,1)*dp - 752.D0/&
     &    3.D0*Hr3(0,-1,0) + 944.D0/3.D0*Hr3(0,-1,0)*x + 496.D0/3.D0*   &
     &    Hr3(0,-1,0)*dp + 96.D0*Hr3(0,-1,0)*dm + 868.D0/3.D0*Hr3(0,0,0 &
     &    ) - 36.D0*Hr3(0,0,0)*x - 712.D0/3.D0*Hr3(0,0,0)*dp - 184.D0/3.&
     &    D0*Hr3(0,0,0)*dm + 152.D0/3.D0*Hr3(0,0,1) + 568.D0*Hr3(0,0,1) &
     &    *x + 496.D0/3.D0*Hr3(0,0,1)*dp + 64.D0/3.D0*Hr3(0,0,1)*dm -   &
     &    80.D0/3.D0*Hr3(0,1,0) - 80.D0/3.D0*Hr3(0,1,0)*x + 352.D0/3.D0 &
     &    *Hr3(0,1,0)*dm - 304.D0/3.D0*Hr3(1,0,0) - 688.D0/3.D0*Hr3(1,0 &
     &    ,0)*x + 992.D0/3.D0*Hr3(1,0,0)*dm - 576.D0*Hr4(-1,-1,0,0) +   &
     &    576.D0*Hr4(-1,-1,0,0)*x + 1152.D0*Hr4(-1,-1,0,0)*dp - 896.D0* &
     &    Hr4(-1,-1,0,1) + 896.D0*Hr4(-1,-1,0,1)*x + 1792.D0*Hr4(-1,-1, &
     &    0,1)*dp - 64.D0*Hr4(-1,0,-1,0) + 64.D0*Hr4(-1,0,-1,0)*x + 128.&
     &    D0*Hr4(-1,0,-1,0)*dp + 272.D0*Hr4(-1,0,0,0) - 272.D0*Hr4(-1,0 &
     &    ,0,0)*x - 544.D0*Hr4(-1,0,0,0)*dp + 512.D0*Hr4(-1,0,0,1) -    &
     &    512.D0*Hr4(-1,0,0,1)*x - 1024.D0*Hr4(-1,0,0,1)*dp + 32.D0*    &
     &    Hr4(-1,0,1,0) )                                               
      gqq2 = gqq2 + cf**2*ca * (  - 32.D0*Hr4(-1,0,1,0)*x - 64.D0*Hr4(  &
     &    -1,0,1,0)*dp + 128.D0*Hr4(0,-1,-1,0) + 320.D0*Hr4(0,-1,-1,0)* &
     &    x + 128.D0*Hr4(0,-1,-1,0)*dp - 448.D0*Hr4(0,-1,-1,0)*dm + 304.&
     &    D0*Hr4(0,-1,0,0) - 464.D0*Hr4(0,-1,0,0)*x - 672.D0*Hr4(0,-1,0 &
     &    ,0)*dp + 160.D0*Hr4(0,-1,0,0)*dm + 544.D0*Hr4(0,-1,0,1) - 416.&
     &    D0*Hr4(0,-1,0,1)*x - 960.D0*Hr4(0,-1,0,1)*dp - 128.D0*Hr4(0,  &
     &    -1,0,1)*dm + 128.D0*Hr4(0,0,-1,0) - 128.D0*Hr4(0,0,-1,0)*x -  &
     &    160.D0*Hr4(0,0,-1,0)*dp - 32.D0*Hr4(0,0,-1,0)*dm - 224.D0*    &
     &    Hr4(0,0,0,0) + 160.D0*Hr4(0,0,0,0)*dp + 160.D0*Hr4(0,0,0,0)*  &
     &    dm - 224.D0*Hr4(0,0,0,1) + 96.D0*Hr4(0,0,0,1)*x + 320.D0*Hr4( &
     &    0,0,0,1)*dp + 32.D0*Hr4(0,0,0,1)*dm - 32.D0*Hr4(0,0,1,0) + 32.&
     &    D0*Hr4(0,0,1,0)*dp + 32.D0*Hr4(0,0,1,0)*dm - 48.D0*Hr4(0,1,0, &
     &    0) - 48.D0*Hr4(0,1,0,0)*x + 160.D0*Hr4(0,1,0,0)*dm + 256.D0*  &
     &    Hr4(1,0,-1,0) + 256.D0*Hr4(1,0,-1,0)*x - 512.D0*Hr4(1,0,-1,0) &
     &    *dm - 176.D0*Hr4(1,0,0,0) - 176.D0*Hr4(1,0,0,0)*x + 352.D0*   &
     &    Hr4(1,0,0,0)*dm )                                             
      gqq2 = gqq2 + cf**2*ca * ( 128.D0*Hr4(1,0,0,1) + 128.D0*Hr4(1,0,0 &
     &    ,1)*x - 256.D0*Hr4(1,0,0,1)*dm - 128.D0*Hr4(1,1,0,0) - 128.D0 &
     &    *Hr4(1,1,0,0)*x + 256.D0*Hr4(1,1,0,0)*dm )                    
      gqq2 = gqq2 + cf**3 * (  - 302.D0 + 302.D0*x + 48.D0*z3 + 336.D0* &
     &    z3*x + 144.D0*z3*dp + 204.D0*z2 + 12.D0*z2*x + 504.D0/5.D0*   &
     &    z2**2 - 56.D0/5.D0*z2**2*x - 112.D0*z2**2*dp + 144.D0/5.D0*   &
     &    z2**2*dm + 576.D0*Hr1(-1)*z3 - 576.D0*Hr1(-1)*z3*x - 1152.D0* &
     &    Hr1(-1)*z3*dp - 192.D0*Hr1(-1)*z2 - 384.D0*Hr1(-1)*z2*x - 192.&
     &    D0*Hr1(-1)*z2*dp - 328.D0*Hr1(0) + 464.D0*Hr1(0)*x + 48.D0*   &
     &    Hr1(0)*dp - 6.D0*Hr1(0)*dm - 224.D0*Hr1(0)*z3 + 288.D0*Hr1(0) &
     &    *z3*x + 416.D0*Hr1(0)*z3*dp + 32.D0*Hr1(0)*z3*dm + 192.D0*    &
     &    Hr1(0)*z2 + 544.D0*Hr1(0)*z2*x + 48.D0*Hr1(0)*z2*dp - 48.D0*  &
     &    Hr1(0)*z2*dm - 400.D0*Hr1(1) + 400.D0*Hr1(1)*x - 192.D0*Hr1(1 &
     &    )*z3 - 192.D0*Hr1(1)*z3*x + 384.D0*Hr1(1)*z3*dm - 96.D0*Hr1(1 &
     &    )*z2 + 96.D0*Hr1(1)*z2*x - 768.D0*Hr2(-1,-1)*z2 + 768.D0*Hr2( &
     &    -1,-1)*z2*x + 1536.D0*Hr2(-1,-1)*z2*dp - 96.D0*Hr2(-1,0) - 96.&
     &    D0*Hr2(-1,0)*x + 640.D0*Hr2(-1,0)*z2 - 640.D0*Hr2(-1,0)*z2*x  &
     &     - 1280.D0*Hr2(-1,0)*z2*dp + 416.D0*Hr2(0,-1)*z2 - 608.D0*    &
     &    Hr2(0,-1)*z2*x )                                              
      gqq2 = gqq2 + cf**3 * (  - 1024.D0*Hr2(0,-1)*z2*dp + 192.D0*Hr2(0 &
     &    ,-1)*z2*dm - 172.D0*Hr2(0,0) + 4.D0*Hr2(0,0)*x + 52.D0*Hr2(0, &
     &    0)*dm - 240.D0*Hr2(0,0)*z2 + 240.D0*Hr2(0,0)*z2*x + 448.D0*   &
     &    Hr2(0,0)*z2*dp - 300.D0*Hr2(0,1) - 12.D0*Hr2(0,1)*x + 96.D0*  &
     &    Hr2(0,1)*z2 - 96.D0*Hr2(0,1)*z2*x - 192.D0*Hr2(0,1)*z2*dp -   &
     &    144.D0*Hr2(1,0) + 144.D0*Hr2(1,0)*x + 192.D0*Hr3(-1,-1,0) +   &
     &    192.D0*Hr3(-1,-1,0)*x + 272.D0*Hr3(-1,0,0) + 176.D0*Hr3(-1,0, &
     &    0)*x - 96.D0*Hr3(-1,0,0)*dp + 288.D0*Hr3(-1,0,1) + 480.D0*    &
     &    Hr3(-1,0,1)*x + 192.D0*Hr3(-1,0,1)*dp + 64.D0*Hr3(0,-1,0) -   &
     &    128.D0*Hr3(0,-1,0)*x - 96.D0*Hr3(0,-1,0)*dp - 168.D0*Hr3(0,0, &
     &    0) - 168.D0*Hr3(0,0,0)*x + 144.D0*Hr3(0,0,0)*dp - 128.D0*Hr3( &
     &    0,0,1) - 544.D0*Hr3(0,0,1)*x - 96.D0*Hr3(0,0,1)*dp + 8.D0*    &
     &    Hr3(0,1,0) - 56.D0*Hr3(0,1,0)*x - 96.D0*Hr3(0,1,0)*dm + 96.D0 &
     &    *Hr3(1,0,0) + 96.D0*Hr3(1,0,0)*x - 192.D0*Hr3(1,0,0)*dm + 640.&
     &    D0*Hr4(-1,-1,0,0) - 640.D0*Hr4(-1,-1,0,0)*x - 1280.D0*Hr4(-1, &
     &    -1,0,0)*dp )                                                  
      gqq2 = gqq2 + cf**3 * ( 768.D0*Hr4(-1,-1,0,1) - 768.D0*Hr4(-1,-1, &
     &    0,1)*x - 1536.D0*Hr4(-1,-1,0,1)*dp + 128.D0*Hr4(-1,0,-1,0) -  &
     &    128.D0*Hr4(-1,0,-1,0)*x - 256.D0*Hr4(-1,0,-1,0)*dp - 352.D0*  &
     &    Hr4(-1,0,0,0) + 352.D0*Hr4(-1,0,0,0)*x + 704.D0*Hr4(-1,0,0,0) &
     &    *dp - 512.D0*Hr4(-1,0,0,1) + 512.D0*Hr4(-1,0,0,1)*x + 1024.D0 &
     &    *Hr4(-1,0,0,1)*dp - 64.D0*Hr4(-1,0,1,0) + 64.D0*Hr4(-1,0,1,0) &
     &    *x + 128.D0*Hr4(-1,0,1,0)*dp - 64.D0*Hr4(0,-1,-1,0) - 320.D0* &
     &    Hr4(0,-1,-1,0)*x - 256.D0*Hr4(0,-1,-1,0)*dp + 384.D0*Hr4(0,-1 &
     &    ,-1,0)*dm - 384.D0*Hr4(0,-1,0,0) + 576.D0*Hr4(0,-1,0,0)*x +   &
     &    832.D0*Hr4(0,-1,0,0)*dp - 192.D0*Hr4(0,-1,0,0)*dm - 448.D0*   &
     &    Hr4(0,-1,0,1) + 448.D0*Hr4(0,-1,0,1)*x + 896.D0*Hr4(0,-1,0,1) &
     &    *dp - 96.D0*Hr4(0,0,-1,0) + 224.D0*Hr4(0,0,-1,0)*x + 192.D0*  &
     &    Hr4(0,0,-1,0)*dp - 64.D0*Hr4(0,0,-1,0)*dm + 176.D0*Hr4(0,0,0, &
     &    0) - 112.D0*Hr4(0,0,0,0)*x - 192.D0*Hr4(0,0,0,0)*dp - 64.D0*  &
     &    Hr4(0,0,0,0)*dm + 144.D0*Hr4(0,0,0,1) - 240.D0*Hr4(0,0,0,1)*x &
     &     - 384.D0*Hr4(0,0,0,1)*dp )                                   
      gqq2 = gqq2 + cf**3 * ( 64.D0*Hr4(0,0,0,1)*dm - 64.D0*Hr4(0,0,1,0 &
     &    ) - 128.D0*Hr4(0,0,1,0)*x - 64.D0*Hr4(0,0,1,0)*dp + 128.D0*   &
     &    Hr4(0,0,1,0)*dm - 64.D0*Hr4(0,0,1,1) - 64.D0*Hr4(0,0,1,1)*x   &
     &     + 128.D0*Hr4(0,0,1,1)*dm - 80.D0*Hr4(0,1,0,0) - 80.D0*Hr4(0, &
     &    1,0,0)*x + 64.D0*Hr4(0,1,0,0)*dm - 64.D0*Hr4(0,1,0,1) - 64.D0 &
     &    *Hr4(0,1,0,1)*x + 128.D0*Hr4(0,1,0,1)*dm - 64.D0*Hr4(0,1,1,0) &
     &     - 64.D0*Hr4(0,1,1,0)*x + 128.D0*Hr4(0,1,1,0)*dm - 128.D0*    &
     &    Hr4(1,0,-1,0) - 128.D0*Hr4(1,0,-1,0)*x + 256.D0*Hr4(1,0,-1,0) &
     &    *dm + 64.D0*Hr4(1,0,0,0) + 64.D0*Hr4(1,0,0,0)*x - 128.D0*Hr4( &
     &    1,0,0,0)*dm - 128.D0*Hr4(1,0,0,1) - 128.D0*Hr4(1,0,0,1)*x +   &
     &    256.D0*Hr4(1,0,0,1)*dm - 64.D0*Hr4(1,0,1,0) - 64.D0*Hr4(1,0,1 &
     &    ,0)*x + 128.D0*Hr4(1,0,1,0)*dm )                              
      gqq2 = gqq2 + nf*cf*ca * (  - 1034.D0/9.D0 + 3938.D0/27.D0*x -    &
     &    836.D0/27.D0*dm + 32.D0*z3 + 16.D0*z3*x - 16.D0*z3*dp - 48.D0 &
     &    *z3*dm - 88.D0/9.D0*z2 - 8.D0/3.D0*z2*x + 160.D0/9.D0*z2*dp   &
     &     + 160.D0/9.D0*z2*dm - 32.D0/3.D0*Hr1(-1)*z2 + 32.D0/3.D0*    &
     &    Hr1(-1)*z2*x + 64.D0/3.D0*Hr1(-1)*z2*dp - 916.D0/27.D0*Hr1(0) &
     &     + 716.D0/27.D0*Hr1(0)*x - 1336.D0/27.D0*Hr1(0)*dm - 8.D0/3.D0&
     &    *Hr1(0)*z2 - 8.D0*Hr1(0)*z2*x - 16.D0/3.D0*Hr1(0)*z2*dp + 32.D&
     &    0/3.D0*Hr1(0)*z2*dm + 16.D0/3.D0*Hr1(1) - 16.D0/3.D0*Hr1(1)*x &
     &     - 64.D0/9.D0*Hr2(-1,0) + 256.D0/9.D0*Hr2(-1,0)*x + 320.D0/9.D&
     &    0*Hr2(-1,0)*dp + 104.D0/9.D0*Hr2(0,0) - 32.D0/9.D0*Hr2(0,0)*x &
     &     - 160.D0/9.D0*Hr2(0,0)*dp - 112.D0/3.D0*Hr2(0,0)*dm + 8.D0/3.&
     &    D0*Hr2(0,1) + 8.D0/3.D0*Hr2(0,1)*x - 16.D0/3.D0*Hr3(-1,0,0)   &
     &     + 16.D0/3.D0*Hr3(-1,0,0)*x + 32.D0/3.D0*Hr3(-1,0,0)*dp + 32.D&
     &    0/3.D0*Hr3(-1,0,1) - 32.D0/3.D0*Hr3(-1,0,1)*x - 64.D0/3.D0*   &
     &    Hr3(-1,0,1)*dp - 16.D0/3.D0*Hr3(0,-1,0) + 16.D0/3.D0*Hr3(0,-1 &
     &    ,0)*x )                                                       
      gqq2 = gqq2 + nf*cf*ca * ( 32.D0/3.D0*Hr3(0,-1,0)*dp + 32.D0/3.D0 &
     &    *Hr3(0,0,0) - 32.D0/3.D0*Hr3(0,0,0)*dp - 32.D0/3.D0*Hr3(0,0,0 &
     &    )*dm - 8.D0/3.D0*Hr3(0,0,1) + 8.D0*Hr3(0,0,1)*x + 32.D0/3.D0* &
     &    Hr3(0,0,1)*dp - 16.D0/3.D0*Hr3(0,0,1)*dm - 8.D0*Hr3(1,0,0) -  &
     &    8.D0*Hr3(1,0,0)*x + 16.D0*Hr3(1,0,0)*dm )                     
      gqq2 = gqq2 + nf*cf**2 * ( 109.D0 - 217.D0/3.D0*x - 110.D0/3.D0*  &
     &    dm - 128.D0/3.D0*z3 - 32.D0/3.D0*z3*x + 32.D0*z3*dp + 160.D0/ &
     &    3.D0*z3*dm + 160.D0/9.D0*z2 - 160.D0/9.D0*z2*x - 320.D0/9.D0* &
     &    z2*dp + 64.D0/3.D0*Hr1(-1)*z2 - 64.D0/3.D0*Hr1(-1)*z2*x - 128.&
     &    D0/3.D0*Hr1(-1)*z2*dp + 508.D0/9.D0*Hr1(0) + 476.D0/9.D0*Hr1( &
     &    0)*x + 20.D0/3.D0*Hr1(0)*dm - 32.D0/3.D0*Hr1(0)*z2 + 32.D0/3.D&
     &    0*Hr1(0)*z2*dp + 32.D0/3.D0*Hr1(0)*z2*dm - 64.D0/3.D0*Hr1(1)  &
     &     + 64.D0/3.D0*Hr1(1)*x + 128.D0/9.D0*Hr2(-1,0) - 512.D0/9.D0* &
     &    Hr2(-1,0)*x - 640.D0/9.D0*Hr2(-1,0)*dp + 16.D0/9.D0*Hr2(0,0)  &
     &     + 176.D0/3.D0*Hr2(0,0)*x + 320.D0/9.D0*Hr2(0,0)*dp + 16.D0*  &
     &    Hr2(0,0)*dm - 32.D0/9.D0*Hr2(0,1) + 160.D0/9.D0*Hr2(0,1)*x -  &
     &    320.D0/9.D0*Hr2(0,1)*dm + 64.D0/9.D0*Hr2(1,0) + 256.D0/9.D0*  &
     &    Hr2(1,0)*x - 320.D0/9.D0*Hr2(1,0)*dm + 32.D0/3.D0*Hr3(-1,0,0) &
     &     - 32.D0/3.D0*Hr3(-1,0,0)*x - 64.D0/3.D0*Hr3(-1,0,0)*dp - 64.D&
     &    0/3.D0*Hr3(-1,0,1) + 64.D0/3.D0*Hr3(-1,0,1)*x + 128.D0/3.D0*  &
     &    Hr3(-1,0,1)*dp )                                              
      gqq2 = gqq2 + nf*cf**2 * ( 32.D0/3.D0*Hr3(0,-1,0) - 32.D0/3.D0*   &
     &    Hr3(0,-1,0)*x - 64.D0/3.D0*Hr3(0,-1,0)*dp + 8.D0/3.D0*Hr3(0,0 &
     &    ,0) + 24.D0*Hr3(0,0,0)*x + 64.D0/3.D0*Hr3(0,0,0)*dp - 32.D0/3.&
     &    D0*Hr3(0,0,0)*dm + 64.D0/3.D0*Hr3(0,0,1) - 64.D0/3.D0*Hr3(0,0 &
     &    ,1)*dp - 64.D0/3.D0*Hr3(0,0,1)*dm + 32.D0/3.D0*Hr3(0,1,0) +   &
     &    32.D0/3.D0*Hr3(0,1,0)*x - 64.D0/3.D0*Hr3(0,1,0)*dm + 64.D0/3.D&
     &    0*Hr3(1,0,0) + 64.D0/3.D0*Hr3(1,0,0)*x - 128.D0/3.D0*Hr3(1,0, &
     &    0)*dm )                                                       
      gqq2 = gqq2 + nf**2*cf * ( 112.D0/27.D0 - 32.D0/9.D0*x - 16.D0/27.&
     &    D0*dm + 8.D0/27.D0*Hr1(0) - 88.D0/27.D0*Hr1(0)*x + 80.D0/27.D0&
     &    *Hr1(0)*dm - 8.D0/9.D0*Hr2(0,0) - 8.D0/9.D0*Hr2(0,0)*x + 16.D0&
     &    /9.D0*Hr2(0,0)*dm )                                           
!                                                                       
! ...The soft (`+'-distribution) part of the splitting function         
!
      ! GPS: now included from module qcd
!       A3 =                                                             &
!     &      ca**2*cf * ( + 490.D0/3.D0 + 88.D0/3.D0*z3 - 1072.D0/9.D0*z2&
!     &                   + 176.D0/5.D0*z2**2 )                          &
!     &    + ca*cf*nf * ( - 836./27.D0 + 160./9.D0*z2 - 112./3.D0*z3 )   &
!     &    + cf**2*nf * ( - 110./3.D0 + 32.*z3 ) - cf*nf2 * 16./27.D0    
!                                                                       
       GQQ2L = DM * A3 
!                                                                       
! ...The regular piece of the splitting function                        
!                                                                       
       X2NSMA = GQQ2 - GQQ2L 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..This is the singular (soft) piece.                                  
!                                                                       
       FUNCTION X2NSB (Y, NF) 
       IMPLICIT REAL*8 (A - Z) 
       INTEGER NF 
!                                                                       
!       COMMON / P2SOFT / A3 
!                                                                       
       X2NSB  = A3/(1.D0-Y) 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..This is the 'local' piece.                                          
!                                                                       
       FUNCTION X2NSC (Y, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       INTEGER NF, NF2 
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0,                    &
     &             Z5 = 1.0369 27755 14336 99263 D0 )                   
!                                                                       
!       COMMON / P2SOFT / A3 
!                                                                       
! ...Colour factors                                                     
!                                                                       
       !CF  = 4./3.D0 
       !CA  = 3.D0 
       NF2 = NF*NF 
!                                                                       
! ...The coefficient of delta(1-x)                                      
!                                                                       
       P2DELT =                                                         &
     &     + 29.D0/2.D0*cf**3                                           &
     &     + 151.D0/4.D0*ca*cf**2                                       &
     &     - 1657.D0/36.D0*ca**2*cf                                     &
     &     - 240.D0*z5*cf**3                                            &
     &     + 120.D0*z5*ca*cf**2                                         &
     &     + 40.D0*z5*ca**2*cf                                          &
     &     + 68.D0*z3*cf**3                                             &
     &     + 844.D0/3.D0*z3*ca*cf**2                                    &
     &     - 1552.D0/9.D0*z3*ca**2*cf                                   &
     &     + 18.D0*z2*cf**3                                             &
     &     - 410.D0/3.D0*z2*ca*cf**2                                    &
     &     + 4496.D0/27.D0*z2*ca**2*cf                                  &
     &     - 32.D0*z2*z3*cf**3                                          &
     &     + 16.D0*z2*z3*ca*cf**2                                       &
     &     + 288.D0/5.D0*z2**2*cf**3                                    &
     &     - 988.D0/15.D0*z2**2*ca*cf**2                                &
     &     - 2.D0*z2**2*ca**2*cf                                        &
     &     - 1336.D0/27.D0*z2*ca*cf*nf                                  &
     &     + 4.D0/5.D0*z2**2*ca*cf*nf                                   &
     &     + 200.D0/9.D0*z3*ca*cf*nf                                    &
     &     + 20.D0*ca*cf*nf                                             &
     &     + 20.D0/3.D0*z2*cf**2*nf                                     &
     &     + 232.D0/15.D0*z2**2*cf**2*nf                                &
     &     - 136.D0/3.D0*z3*cf**2*nf                                    &
     &     - 23.D0*cf**2*nf                                             &
     &     + 80.D0/27.D0*z2*cf*nf2                                      &
     &     - 16.D0/9.D0*z3*cf*nf2                                       &
     &     - 17.D0/9.D0*cf*nf2                                          
!                                                                       
!                                                                       
       X2NSC = LOG (1.D0-Y) * A3 + P2DELT 
!                                                                       
       RETURN 
      END FUNCTION
!                                                                       
! --------------------------------------------------------------------- 
!                                                                       
!                                                                       
! ..This is P_NSS, the difference of P_NSV and P_NS-.                   
!                                                                       
       FUNCTION X2NSSA (X, NF) 
!                                                                       
       IMPLICIT REAL*8 (A - Z) 
       COMPLEX*16 HC1, HC2, HC3, HC4 
       INTEGER NF, NF2, N1, N2, NW, I1, I2, I3, N 
       PARAMETER ( N1 = -1, N2 = 1, NW = 4 ) 
       DIMENSION HC1(N1:N2),HC2(N1:N2,N1:N2),HC3(N1:N2,N1:N2,N1:N2),    &
     &           HC4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HR1(N1:N2),HR2(N1:N2,N1:N2),HR3(N1:N2,N1:N2,N1:N2),    &
     &           HR4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       DIMENSION HI1(N1:N2),HI2(N1:N2,N1:N2),HI3(N1:N2,N1:N2,N1:N2),    &
     &           HI4(N1:N2,N1:N2,N1:N2,N1:N2)                           
       PARAMETER ( Z2 = 1.6449 34066 84822 64365 D0,                    &
     &             Z3 = 1.2020 56903 15959 42854 D0,                    &
     &             Z5 = 1.0369 27755 14336 99263 D0 )                   
!                                                                       
! ...Some abbreviations                                                 
!                                                                       
       DX = 1.D0/X 
       DM = 1.D0/(1.D0-X) 
       DP = 1.D0/(1.D0+X) 
!                                                                       
! ...The harmonic polylogs up to weight 4 by Gehrmann and Remiddi       
!                                                                       
       CALL HPLOG (X, NW, HC1,HC2,HC3,HC4, HR1,HR2,HR3,HR4,             &
     &            HI1,HI2,HI3,HI4, N1, N2)                              
!                                                                       
! ...The splitting function in terms of the harmonic polylogs           
!                                                                       
      gqq2 =                                                            &
     &  + 5./18.D0 * NF * ( 6400.D0/3.D0 - 6400.D0/3.D0*x + 256.D0*z3   &
     &     + 1280.D0/3.D0*z3*x**2 - 2144.D0/3.D0*z2 - 1312.D0/3.D0*z2*x &
     &     + 96.D0*z2**2 + 160.D0*z2**2*x - 192.D0*Hr1(-1)*z2 - 192.D0* &
     &    Hr1(-1)*z2*x - 256.D0*Hr1(-1)*z2*x**2 - 256.D0*Hr1(-1)*z2*dx  &
     &     + 3200.D0/3.D0*Hr1(0) + 96.D0*Hr1(0)*x - 256.D0*Hr1(0)*z3 +  &
     &    32.D0*Hr1(0)*z2 + 288.D0*Hr1(0)*z2*x + 1024.D0/3.D0*Hr1(0)*z2 &
     &    *x**2 + 2912.D0/3.D0*Hr1(1) - 2912.D0/3.D0*Hr1(1)*x - 64.D0*  &
     &    Hr1(1)*z2 + 64.D0*Hr1(1)*z2*x + 256.D0/3.D0*Hr1(1)*z2*x**2 -  &
     &    256.D0/3.D0*Hr1(1)*z2*dx - 832.D0/3.D0*Hr2(-1,0) - 832.D0/3.D0&
     &    *Hr2(-1,0)*x + 128.D0*Hr2(0,-1)*z2 - 128.D0*Hr2(0,-1)*z2*x +  &
     &    1216.D0/3.D0*Hr2(0,0) + 928.D0/3.D0*Hr2(0,0)*x - 320.D0*Hr2(0 &
     &    ,0)*z2 - 192.D0*Hr2(0,0)*z2*x + 1312.D0/3.D0*Hr2(0,1) + 1312.D&
     &    0/3.D0*Hr2(0,1)*x - 128.D0*Hr2(0,1)*z2 - 128.D0*Hr2(0,1)*z2*x &
     &     + 128.D0*Hr3(-1,-1,0) + 128.D0*Hr3(-1,-1,0)*x - 512.D0/3.D0* &
     &    Hr3(-1,-1,0)*x**2 - 512.D0/3.D0*Hr3(-1,-1,0)*dx + 64.D0*Hr3(  &
     &    -1,0,0) )                                                     
      gqq2 = gqq2 + 5./18.D0 * NF* ( 64.D0*Hr3(-1,0,0)*x + 512.D0/3.D   &
     &    0*Hr3(-1,0,0)*x**2 + 512.D0/3.D0*Hr3(-1,0,0)*dx + 256.D0*Hr3( &
     &    -1,0,1) + 256.D0*Hr3(-1,0,1)*x + 512.D0/3.D0*Hr3(-1,0,1)*x**2 &
     &     + 512.D0/3.D0*Hr3(-1,0,1)*dx + 64.D0*Hr3(0,-1,0) - 192.D0*   &
     &    Hr3(0,-1,0)*x + 512.D0/3.D0*Hr3(0,-1,0)*x**2 - 64.D0*Hr3(0,0, &
     &    0) - 512.D0/3.D0*Hr3(0,0,0)*x**2 + 32.D0*Hr3(0,0,1) - 288.D0* &
     &    Hr3(0,0,1)*x - 512.D0/3.D0*Hr3(0,0,1)*x**2 - 96.D0*Hr3(1,0,0) &
     &     + 96.D0*Hr3(1,0,0)*x + 256.D0*Hr4(0,-1,-1,0) - 256.D0*Hr4(0, &
     &    -1,-1,0)*x - 128.D0*Hr4(0,-1,0,0) + 128.D0*Hr4(0,-1,0,0)*x -  &
     &    128.D0*Hr4(0,0,-1,0) + 128.D0*Hr4(0,0,-1,0)*x + 128.D0*Hr4(0, &
     &    0,0,0) + 192.D0*Hr4(0,0,0,1) + 192.D0*Hr4(0,0,0,1)*x - 64.D0* &
     &    Hr4(0,1,0,0) - 64.D0*Hr4(0,1,0,0)*x )                         
!                                                                       
       X2NSSA = GQQ2 
!                                                                       
       RETURN 
      END FUNCTION
      end module xpns2e
