#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""Script to generate reference results for alphas tests in Fortran format.

The code generated here is, for now, pasted into test_alphas.f90

It uses the alphas.py module from Gavin (available privately)
"""
import alphas as al

mc = 1.67
mb = 4.78
mt = 172.57
mz = 91.1880
asmz=0.1180 

# pole masses by default
thresholds = al.thresholds(mc, mb, mt)
dt = 0.2 * al._default_dt

Qvals = [1.0, 3.0, 9.0, 10000.0]

nloop = 4
alphas_vfn = al.alphas(alphas_mu = asmz, mu = mz, nloop = nloop, thresholds = thresholds, dt = dt)

print(f"""
    !-- reference results generated by unit-tests/gen-alphas-ref.py
    real(dp), parameter :: mc={mc:f}_dp, mb={mb:f}_dp, mt={mt:f}_dp, mz={mz:f}_dp
    real(dp), parameter :: alphas_mz={asmz:f}_dp
    real(dp), parameter :: Qvals(*) = [{", ".join([f"{Q:f}_dp" for Q in Qvals])}]
    real(dp), parameter :: ref_4loop_vfn(*) = [{", ".join([f"{alphas_vfn(Q):.12e}_dp" for Q in Qvals])}]
    !-- end of reference results
""")

