def flatten(l):
    return [item for sublist in l for item in sublist]


u_volume_metric = {
    "cl": [r"cls?", r"centilit(?:er|re)s?"],
    "ml": [r"mls?", r"milliliter", r"millilitre"],
    "l": [r"l", r"liters?", r"litres?"],
    "dl": [r"dls?", r"deciliters?", r"decilitres?"],
}

u_volume_imperial = {
    "tsp": [r"tsps?\.?", r"t", r"tspn\.?", r"(?:heaping )?teaspoons?"],
    "tbsp": [
        r"(?:heaping )?tablespoons?",
        r"T",
        r"t",
        r"tbls?\.?",
        r"tbs\.",
        r"tbs",
        r"tbsps?\.?",
    ],
    "fl oz": [r"fl ?oz", r"fluid ounces?"],
    "gill": [r"gills?", r"gals?"],
    "cup": [r"cups?", r"c\.?"],
    "pint": [r"pints?", r"p", r"pt", r"fl ?pt"],
    "half-pint": [r"half-pints?"],
    "quart": [r"quarts?", r"q", r"qt", r"fl ?qt"],
    "gallon": [r"gallons?", r"gals?"],
    "jigger": [r"jiggers?"],
}

u_weight_metric = {
    "mg": [r"mgs?", r"milligrams?", r"milligrammes?"],
    "g": [r"g", r"grams?", r"grammes?"],
    "kg": [r"kgs?", r"kilograms?", r"kilogrammes?"],
}

u_weight_imperial = {"lb": [r"lbs?", r"pounds?", r"#s?"], "oz": [r"oz", r"ounces?"]}

u_length_metric = {
    "cm": [r"centimeters?", r"cm"],
    "m": [r"met(?:er|re)s?", r"m"],
    "dm": [r"decimet(?:er|re)s?", r"dm"],
    "mm": [r"millimet(?:er|re)s?", r"mm"],
}

u_length_imperial = {
    "inch": [r"inch(?:es)?", r"in", r'"', r"''"],
    "ft": [r"feet", r"foot", r"ft"],
    "yard": [r"yards?", r"yds?"],
}

u_misc = {
    "twist": [r"twists?"],
    "squeeze": [r"squeezes?"],
    "quarter": [r"quarters?"],
    "half": [r"hal(?:f|ves)"],
    "third": [r"thirds?"],
    "part": [r"parts?"],
    "segment": [r"segments?"],
    "wedge": [r"wedges?"],
    "drizzle": [r"drizzles?"],
    "handful": [r"handfuls?"],
    "knob": [r"knobs?"],
    "tub": [r"tubs?"],
    "rasher": [r"rashers?"],
    "can": [r"cans?"],
    "package": [r"packages?", r"pkgs?\.?"],
    "sachet": [r"sachets?"],
    "pack": [r"packs?"],
    "tin": [r"tins?"],
    "rack": [r"racks?"],
    "pinch": [r"pinch(?:es)?"],
    "slice": [r"slices?"],
    "bunch": [r"bunch(?:es)?"],
    "dash": [r"dash(?:es)?"],
    "jar": [r"jars?"],
    "container": [r"containers?", r"cont\.?"],
    "bottle": [r"bottles?"],
    # 'bone': [r'bones?'],
    "chunk": [r"chunks?"],
    "box": [r"box(?:es)?"],
    "stem": [r"stems?"],
    "bulb": [r"bulbs?"],
    "clove": [r"cloves?(?=.*garlic)", r"(?<=garlic )cloves?"],
    "stalk": [r"stalks?"],
    "sprig": [r"sprigs?"],
    "head": [r"heads?"],
    "root": [r"roots?"],
    "loaf": [r"loa(?:f|ves)"],
    "piece": [r"pieces?"],
    "packet": [r"packets?"],
    "drop": [r"drops?"],
    "envelope": [r"envelopes?"],
    "sheet": [r"sheets?"],
    "leaf": [r"lea(?:f|ves)"],
    "bag": [r"bags?"],
    "carton": [r"cartons?"],
    "stick": [r"sticks?"],
    "link": [r"links?"],
    "scoop": [r"scoops?"],
    "cube": [r"cubes?"],
    "recipe": [r"recipes?"],
    "glass": [r"glass(?:es)?"],
    "splash": [r"splash(?:es)?"],
    # 'half': [r'(?<!half-and-)hal(?:f|ves)(?!-and-half)'],
    "pod": [r"pods?"],
    "square": [r"squares?"],
    "strip": [r"strips?"],
    "ball": [r"balls?"],
    # "zest": [r"zests?"],
    # "zest and juice": [r"zest? and juices?"],
    # "juice": [r"juices?"],
}

states = [
    r"gold(?:en)?",
    "dark",
    "hearty",
    "rich",
    "homemade",
    "tasty",
    "delicious",
    "yummy",
    "good",
    "cheap",
    "expensive",
    "entire",
    "leftover",
    "quick",
    "easy",
    "simple",
    "fine",
    r"\w+[- ]?sodium",
    "creamy",
    "organic",
    "broken",
    "all-butter",
    "sweet",
    "mild",
    "sharp",
    "firm",
    "soft",
    "aged",
    "thin",
    "thick",
    "lean",
    "stoneground",
    r"\w+[- ]?style",
    r"(?:[0-9]+ [0-9]+/[0-9]+|[0-9]+)[- ]?inch(?:[ -]thick)?",
    r"\w+-sodium",
    r"\w+-fat",
    r"free[- ]range",
    "whole",
    "skin-on",
    "hot",
    "cold",
    "warm",
    "boiling",
    r"\b(?<!\.)(?!0+(?:\.0+)?[ -]?%)(?:\d|[1-9]\d|100)(?:(?<!100)\.\d+)?[ -]?%",
    r"fresh(?:ly)?",
    r"[0-9]+[- ]bone",
    "quality",
    "chopped",
    "ground",
    "sliced",
    "minced",
    "cut",
    "diced",
    "peeled",
    "grated",
    "shredded",
    "drained",
    "dry",
    "coarse",
    "crushed",
    "crusted",
    "dried",
    "cooked",
    "boneless",
    "seeded",
    "beaten",
    "skinless",
    "unsalted",
    "cubed",
    "rinsed",
    "melted",
    "softened",
    "canned",
    "toasted",
    "crumbled",
    "quartered",
    "uncooked",
    "roasted",
    "trimmed",
    "pitted",
    "thawed",
    "granulated",
    "frozen",
    "washed",
    "ripe",
    "mixed",
    "powdered",
    "cored",
    "unsweetened",
    "condensed",
    "smoked",
    "deveined",
    "reduced",
    "mashed",
    "halved",
    "separated",
    "boiled",
    "raw",
    "undrained",
    "seasoned",
    "sifted",
    "slivered",
    "juiced",
    "squeezed",
    "sweetened",
    "evaporated",
    "whipped",
    "blanched",
    "chilled",
    "julienned",
    "cracked",
    "prepared",
    "shelled",
    "stemmed",
    "refried",
    "stewed",
    "unbleached",
    "flaked",
    "skinned",
    "flavored",
    "refrigerated",
    "semisweet",
    "unpeeled",
    "smashed",
    "salted",
    "pickled",
    "packed",
    "snipped",
    "seedless",
    "bottled",
    "deseeded",
    "soaked",
    "rolled",
    "cooled",
    "candied",
    "warmed",
    "baked",
    "scrubbed",
    "steamed",
    "distilled",
    "pressed",
    "corned",
    "marinated",
    "brewed",
    "undiluted",
    "shaved",
    "clarified",
    "stuffed",
    "pureed",
    "unflavored",
    "desiccated",
    "creamed",
    "grilled",
    "zested",
    "hulled",
    "substituted",
    "defrosted",
    "unbaked",
    "assorted",
    "heated",
    "husked",
    "preserved",
    "strained",
    "browned",
    "scraped",
    "thickened",
    "processed",
    "cleaned",
    "jarred",
    "bruised",
    "unseasoned",
    "chunked",
    "crystallized",
    "scalded",
    "rubbed",
    "precooked",
    "buttered",
    "carbonated",
    "stoned",
    "sauteed",
    "tied",
    "shucked",
    "unsifted",
    "butterflied",
    "bone-in",
    "colored",
    "debearded",
    "cured",
    "spiced",
    "spicy",
    "converted",
    "imported",
    "seperated",
    "tinned",
    "blended",
    "added",
    "whisked",
    "deboned",
    "hardboiled",
    "shaped",
    "purchased",
    "fermented",
    "sectioned",
    "veined",
    "suggested",
    "unsliced",
    "pounded",
    "ripened",
    "parboiled",
    "packaged",
    "sorted",
    "textured",
    "dehydrated",
    "grounded",
    "refined",
    "filtered",
    "poached",
    "chipped",
    "compressed",
    "segmented",
    "sieved",
    "heaped",
    "jointed",
    "flattened",
    "combined",
    "unrefined",
    "gutted",
    "caramelized",
    "sprinkled",
    "scaled",
    "pulled",
    "desired",
    "based",
    "rendered",
    "tailed",
    "unblanched",
    "brushed",
    "stripped",
    "diluted",
    "stirred",
    "homogenized",
    "barbecued",
    "concentrated",
    "wedged",
    "herbed",
    "rehydrated",
    "breaded",
    "deviened",
    "scored",
    "rounded",
    "wiped",
    "posted",
    "defatted",
    "filleted",
    "frenched",
    "skin-on",
    "unwaxed",
    "reconstituted",
    "tossed",
    "flavoured",
    "unshelled",
    "choped",
    "tenderized",
    "charred",
    "pasteurized",
    "malted",
    "unsmoked",
    "filled",
]


colors = [
    "red",
    "white",
    "black",
    "brown",
    "green",
    "yellow",
    "blue",
    "purple",
    r"gold(?:en)?",
    "dark",
    r"orange(?=.*pepper|.*beans?)",
]

s_substitutions = {
    "xs": [r"extra small", "mini", "tiny", "super small", "petite"],
    "sm": [
        r"small",
        r"small small",
        r"small[- ]medium",
        r"small[ -]to[ -]medium",
        r"thumb[- ]sized",
    ],
    "md": [r"medium", r"medium small", r"medium[- ]large", r"mediuum", r"medum"],
    "lg": [
        r"large",
        r"extra[- ]large",
        r"large/extra",
        r"big",
        r"huge",
        r"giant",
        r"massive",
    ],
    "misc": [r"(?:\w|-)+[- ]sized"],
}

u_volume_conversions = {
    "tsp": 5,
    "tbsp": 14.8,
    "cup": 250,
    "fl oz": 30,
    "quart": 946,
    "l": 1000,
    "dl": 100,
    "ml": 1,
    "pint": 473.17,
    "half-pint": 236.585,
    "gallon": 3785.41,
    "jigger": 44,
    "gill": 118.29,
    "kg": 1000,
    "g": 1,
    "mg": 0.001,
    "oz": 28.34,
    "lb": 453.59,
    "dash": 0.6,
    "pinch": 1.25,
    "dollop": 6.25,
    "splash": 2.5,
    "glug": 29.6,
    "drizzle": 16,
    "glass": 225,
    "handful": 125,
    "fistful": 62.5,
}

u_weight_conversions = {
    "kg": 1000,
    "g": 1,
    "mg": 0.001,
    "oz": 28.34,
    "lb": 453.59,
}

u_conversions = {**u_weight_conversions, **u_volume_conversions}


n_substitutions = {
    None: [r"(?:a )?few", r"a little", r"some", r"several"],
    24: [r"(?:two|2) dozens?"],
    36: [r"(?:three|3) dozens?"],
    12: [r"dozen", r"(?:one|1) dozen", r"a dozen"],
    1: [r"one", r"a", r"an"],
    2: [r"two"],
    3: [r"three"],
    4: [r"four"],
    5: [r"five"],
    6: [r"six"],
    7: [r"seven"],
    8: [r"eight"],
    9: [r"nine"],
    10: [r"ten"],
    0.5: [r"half"],
}


u_misc_values = flatten(u_misc.values())
u_all_values = flatten(
    [
        flatten(list(unit_dict.values()))
        for unit_dict in [
            u_volume_imperial,
            u_volume_metric,
            u_misc,
            u_weight_imperial,
            u_weight_metric,
            u_length_imperial,
            u_length_metric,
        ]
    ]
)
u_metric_values = flatten(
    [
        flatten(list(unit_dict.values()))
        for unit_dict in [u_volume_metric, u_weight_metric, u_length_metric]
    ]
)

u_imperial_values = flatten(
    [
        flatten(list(unit_dict.values()))
        for unit_dict in [u_volume_imperial, u_weight_imperial, u_length_metric]
    ]
)

word_numbers = flatten(n_substitutions.values())

u_substitutions = {}
for set in [
    u_weight_imperial,
    u_weight_metric,
    u_volume_imperial,
    u_volume_metric,
    u_misc,
    u_length_imperial,
    u_length_metric,
]:
    for key, values in set.items():
        u_substitutions[key] = rf"(?:\b(?:{r'|'.join(values)})\b)"


sizes = flatten(s_substitutions.values())
