import re

dictionary = {
    "salad dressing": [r"salad dressing$"],
    "vinaigrette": [r"vinaigrette"],
    "wine vinegar": [r"wine vinegar"],
    "cider vinegar": [r"c[iy]der vinegar"],
    "balsamic vinegar": [r"balsamic vinegar"],
    "rice vinegar": [r"rice vinegar$"],
    "vinegar": [r"vinegar$"],
    "rice": [
        r"\brice$",
        r"\bgrain$",
        r"\barborio$",
        r"\bbasmati$",
        r"\bbaldo$",
        r"carnarolli$",
        r"maratelli$",
        r"vialone nano",
    ],
    "couscous": [r"couscous$"],
    "oil": [r"\boil$", r"oil spray"],
    "gravy": [r"\bgravy$"],
    "bone": [r"\bbones?$"],
    "jalapeno": [r"^jalapeno(?:$| pepper$)"],
    "ghee": [r"ghee"],
    "nut butter": [r"(?:nut|cashew|almond).*butter$"],
    "butter": [r"butter margarine", r"margarine", r"butter$"],
    "water": [
        r"(?:cold |hot |warm |\bice |soda |tap |seltzer |cool |pasta |salt |lukewarm |^)water$"
    ],
    "egg": [r"(?<!chocolate )\beggs?$"],
    "tomato": [r" tomato$"],
    "potato": [r" potato$"],
    "masala": [r"masala"],
    "dark chocolate": [r"dark chocolate"],
    "white chocolate": [r"white chocolate"],
    "chocolate": [r"chocolate baking square", r"chocolate$", r"chocolate square"],
    "wonton wrapper": [r"spring wrapper"],
    # ALCOHOL
    "irish cream": [r"irish cream", r"bailey's"],
    "beer": [r"\bbeer$", r"\bale$", r"\bstout$"],
    "whiskey": [r"whiske?y$", r"scotch$"],
    "vodka": [r"\bvodka$"],
    "cider": [r"c[iy]der$"],
    "citrus liqueur": [r"limoncello", r"orange liqueur", r"margarita mix"],
    "fruit liqueur": [r"amaretto", r"curacao"],
    "liqueur": [
        r"rumchata",
        r"\brum$",
        r"liqueur$",
        r"liquor$",
        r"creme de cacao",
        r"frangelico",
        r"rum$",
        r"amarula cream liqueur",
        r"ouzo",
        r"kirsch",
        r"bourbon$",
        r"brandy$",
        r"^gin$",
        r"kahlua",
        r"grand marnier",
        r"cognac",
        r"triple sec",
        r"vodka",
        r"tequila",
        r"brandy",
        r"bitters?$",
    ],
    "grain mustard": [r"grainy mustard$"],
    "dijon mustard": [r"dijon mustard$"],
    "mustard": [r"mustard$"],
    "olive": [r"\bolive$"],
    "fortified wine": [
        r"marsala(?: wine)?$",
        r"madeira wine$",
        r"port wine$",
        r"mistell?a wine",
        r"\bport$",
        r"vermouth",
        r"sherry wine$",
        r"sherry$",
    ],
    "rice wine": [
        r"shaoxing wine$",
        r"rice wine$",
        r"cooking wine",
        r"^sake$",
        r"chinese wine$",
    ],
    "wine": [r"\bwine"],
    "spicy pepper": [
        r"chipotle chile",
        r"chill?[iey](?: pepper)?$",
        r"hot pepper$",
        r"serrano(?: pepper)?$",
        r"poblano(?: pepper)?$",
        r"scotch bonnet(?: pepper)?$",
        r"habanero(?: pepper)?$",
        r"chipotle(?: pepper)?$",
        r"pepperoncini(?: pepper)?$",
        r"banana pepper$",
        r"anaheim chili",
        r"pimi?ento(?: pepper)?$",
        r"\bchile$",
        r"\bchilly$",
        r"\bchili$",
    ],
    "bell pepper": [r"green pepper", r"yellow pepper", r"capsicum", r"bell pepper$"],
    "scallion": [r"green onion$", r"spring onion$", r"scallion$", r"\bleek$"],
    "pearl onion": [
        r"pearl onion$",
        r"baby onion$",
        r"pickling onion$",
        r"cocktail onion$",
    ],
    "onion": [r"\bonion$"],
    "food coloring": [r"coloring$"],
    "sugar": [r"sugar substitute", r"jaggery", r"sweetener", r"splenda", r"\bsugar$"],
    "corn": [
        r"\bmaize$",
        r"ear corn",
        r"mexican corn",
        r"sweetcorn",
        r"mexicorn",
        r"corn cob",
        r"white corn",
        r"kernel",
    ],
    "egg white": [r"egg beater substitute"],
    "avocado": [r"avocado(?: pear)?$", r"alligator pear$"],
    "yogurt": [r"yogh?o?urt"],
    "foil": [r"foil$"],
    "bulgur": [r"bulgh?[au]r wheat", r"bulgh?[au]r$"],
    "pineapple": [
        r"pineapple rings?",
        r"pineapple$",
        r"pineapple tidbits?",
        r"pineapple chunks?",
        r"ananas$",
    ],
    "pepper": [r"pepper powder$"],
    "coffee": [r"black cofee$", r"espresso", r"coffee$"],
    "coffee powder": [r"espresso powder", r"coffee granule"],
    "miso": [r"\bmiso$"],
    "celery": [r"celery(?: sticks?| roots?)?$"],
    "arugula": [r"arug[ua]la", r"roquette$", r"rocket", r"rucola"],
    "syrup": [r"syrup$", r"nectar$", r"sirup$"],
    "shortening": [r"shortening", r"crisco"],
    "cracker": [r"cracker$", r"matzo meal", r"matzo"],
    "molasses": [r"molasses"],
    "salsa": [r"salsa$", r"rotel tomato chilies", r"^rotel"],
    "garlic powder": [r"garlic granule"],
    "garlic head": [r"head garlic", r"bulb garlic"],
    "fat": [r"\bsuet$", r"\bgrease$", r"\bdripping$", r"\blard$", r"\bfat$"],
    "yeast": [r"yeast$"],
    "italian seasoning": [
        r"italian spice",
        r"italian herb",
        r"italian.*seasoning",
    ],
    "za'atar seasoning": [r"za'?atar"],
    "dressing": [r"dressing(?: mix)?"],
    "msg": [r"accent seasoning", r"msg$", r"monosodium glutamate"],
    "coconut cream": [r"cream coconut"],
    "coconut": [r"coconut$", r"coconut meat"],
    "mayonnaise": [r"miracle whip", r"mayo$", r"mayonnaise$"],
    "hominy": [r"hominy$"],
    "bisquick": [r"bisquick"],
    "lemon pepper": [r"lemon[- ]?pepper"],
    "bread roll": [
        r"^french$",
        r"^crescent$",
        r"^kaiser$",
        r"hoagie",
        r"crescent dinner",
        r"french baguette",
        r"baguette",
    ],
    "bok choy": [r"bok cho[iy]", r"pak cho[yi]"],
    "bouillon cube": [r"buillon cube", r"buillon granule", r"stock cube"],
    "tortilla": [r"tortilla$", r"egg wrap"],
    "salami": [r"salami$", r"pepperoni$"],
    "flower water": [r"flower water", r"rose water"],
    "sweet potato": [r"yam", r"sweet potato", r"kumara"],
    "pita bread": [r"pita bread"],
    "heavy cream": [
        r"double cream$",
        r"whipping cream",
        r"^cream$",
        r"half cream",
        r"nonfat cream",
        r"single cream",
    ],
    "bread": [r"bread$", r"ciabatta"],
    "cooking spray": [r"cooking spray"],
    "liquid smoke": [r"liquid smoke"],
    "milk": [r"\bmilk$"],
    "milk powder": [r"milk powder", r"powdered milk"],
    "tofu": [r"tofu$"],
    "pickle": [r"pickle$", r"gherkin", r"pickled cucumber$", r"cornichon$"],
    "skewer": [r"skewer$"],
    "broccoli": [r"broccoli$"],
    "eggplant": [r"aubergine"],
    "zucchini": [r"courgette", r"zucchinis?"],
    "honey": [r"honey$"],
    "saffron": [r"saffron"],
    "sweet sour mix": [r"^mix$"],
    "chili flake": [r"chili flake$", r"pepper flake$"],
    "mango chutney": [r"chutney$"],
    "tortilla chip": [r"tortilla chip", r"corn chip"],
    "all-purpose flour": [r"masa harina"],
    "whipped cream": [r"cool whip"],
    "breadcrumb": [r"breadcrumb$", r"bread crumb"],
    "pesto": [r"pesto"],
    "ketchup": [r"ketchup$", r"catsup", r"cetchup"],
    "oat": [r"\boat$"],
    "pistachio": [r"pistachio"],
    "soy milk": [r"soymilk"],
    "kiwi": [r"kiwi fruit", r"kiwi$", r"chineese gooseberry"],
    "asparagus": [r"asparagus spear"],
    "barley": [r"pearl barley"],
    "starch": [r"starch$", r"cornstarch", r"pectin"],
    "maraschino cherry": [r"glace cherry"],
    "phyllo pastry": [r"phyllo dough"],
    "cornmeal": [r"cornmeal", r"indian meal$"],
    "spinach": [r"spinach leaf"],
    "vanilla extract": [r"vanilla essence", r"^vanilla$"],
    "vanilla bean": [r"vanilla pod"],
    "raisin": [r"sultana"],
    "sour cream": [r"creme fraiche", r"sour(?:ed)? cream"],
    "pie crust": [r"pie shell", r"crust pie"],
    "vanilla ice cream": [r"ice cream"],
    "lettuce": [r"lettuce leaf", r"leaf lettuce"],
    "cream of tartar": [r"cream tartar", r"potassium bitartrate"],
    "beet": [r"beetroot"],
    "ice": [r"ice cube", r"\bice$"],
    "cocoa": [r"cocoa powder"],
    "cauliflower": [r"^cauliflower"],
    "lemongrass": [r"lemon ?grass"],
    "artichoke": [r"artichoke(?: hearts?)?$"],
    # ROOTS
    "jicama": [r"jicama"],
    "sunchoke": [r"sunchoke"],
    "ginger": [
        r"ginger ?(?:root|paste|powder)",
        r"root ginger",
    ],
    "turmeric": [r"turmeric powder", r"turmeric"],
    "wasabi": [r"wasabi paste", r"wasabi powder", r"wasabi"],
    "horseradish": [r"horseradish"],
    "root vegetable": [
        r"root vegetable",
        r"root veggie",
        r"root veg",
        r"daikon$",
        r"radish$",
        r"parsnip$",
        r"turnip$",
        r"rutabaga$",
    ],
    # HERBS
    "mint": [r"mint leaf", r"mint$"],
    "basil": [r"basil leaf", r"\bbasil$"],
    "cilantro": [r"cilantro$", r"coriander(?: cress)?$"],
    "dill": [r"dill weed", r"dill$"],
    "oregano": [r"oregano", r"marjoram"],
    "thyme": [r"thyme leaf", r"thyme leave", r"thyme$"],
    "parsley": [r"parsley$", r"parsley leaf", r"parsley flake"],
    "rosemary": [r"rosemary leaf", r"rosemary$"],
    "fenugreek": [
        r"fenugreek$",
        r"fenugreek leaf",
        r"methi$",
        r"methi leaf",
        r"greek clover",
    ],
    "sage": [r"\bsage leaf", r"\bsage$"],
    "tarragon": [r"tarragon leaf", r"tarragon$"],
    "chive": [r"\bchive$", r"\bchive stalk"],
    "bay leaf": [r"bay leaf", r"bay leave"],
    "chervil": [r"chervil$"],
    "lavender": [r"lavender$"],
    "savory": [r"savory$"],
    "watercress": [r"watercress$"],
    "sorrel": [r"sorrel$"],
    # LEGUMES
    "brussel sprout": [r"brussels? sprouts?"],
    "vanilla bean": [r"^vanilla beans?$"],
    "coffee bean": [r"\bcoffee beans?\b", r"espresso bean"],
    "sprout": [r"\bsprouts?\b"],
    "lentil": [r"\blentil(?:s?| bean)$"],
    "pea": [r"^snow$", r"\bpea(?:s?| bean)$"],
    "dal": [
        r"\bchann?a\b",
        r"\bur[ai]d\b",
        r"\btoor\b",
        r"\bdhal$",
        r"\bdal$",
        r"\bpulse$",
    ],
    "edamame": [r"\bsoy beans?$", r"\bedamame(?:s?| bean)$"],
    "chickpea": [r"\bchickpeas?$", r"\bbengal\b", r"\bgarbanzo\b"],
    "bean": [r"\brajma\b", r"\bbeans?$", r"bean kidney", r"\bcannellini(?:s?| bean)$"],
    # MUSHROOMS
    "morel mushroom": [r"\bmorels?\b"],
    "cremini mushroom": [
        r"button mushroom",
        r"cremini",
        r"baby port[oa]bell[oa]",
        r"chestnut.*mushroom",
        r"baby bella",
        r"brown.*mushroom",
        r"crimini",
    ],
    "chanterelle mushroom": [r"chante?relle", r"girolle", r"golden.*mushroom"],
    "black mushroom": [r"black.*mushroom"],
    "enoki mushroom": [r"enoki", r"beech", r"shimeji"],
    "oyster mushroom": [r"oyster", r"trumpet.*mushroom"],
    "shiitake mushroom": [r"shiitake", r"chinese.*mushroom", r"japanese.*mushroom"],
    "porcini mushroom": [r"porcini", r"bolet", r"king mushroom"],
    "champignon mushroom": [
        r"field mushroom",
        r"port[ao]bell[ao]",
        r"straw mushroom",
        r"large mushroom",
        r"champignon",
    ],
    "mushroom": [r"mushroom$", r"mushroom cap", r"mushroom stem"],
    # PASTA
    "pasta": [
        r"rigatoni",
        r"rotini",
        r"ziti",
        r"pasta shell",
        r"vermicelli",
        r"pasta shell",
        r"gnocchi",
        r"manicotti",
        r"noodle",
        r"noodles",
        r"spaghetti",
        r"penne",
        r"pappardelle",
        r"orecchiette",
        r"macaroni",
        r"linguine",
        r"farfalle",
        r"fusilli",
        r"fettuccine",
        r"capellini",
        r"lasagna",
        r"angel hair",
        r"dital[io]ni",
        r"paccheri",
        r"tort[ei]glioni",
        r"cavatelli",
        r"conchiglie",
        r"orzo",
        r"risoni",
        r"ravioli",
        r"tortell[io]ni",
        r" pasta$",
    ],
    # FLOUR
    "wheat flour": [
        r"whole[ -]?(?:meal|wheat) flour",
        # grain flours
        r"graham flour",
        r"teff flour",
        r"oat flour",
        r"buckwheat flour",
        r"quinoa flour",
        r"rye flour",
        r"spelt flour",
        r"sorghum flour",
        r"chickpea flour",
        r"gram flour",
        # white grain flours
        r"masa harina",
        r"amaranth flour",
        r"barley flour",
        r"rice flour",
        r"millet flour",
        r"corn flour",
        r"potato flour",
    ],
    "flour": [r" flour$"],
    # CHEESE
    "monterey jack cheese": [r"monterey jack"],
    "mexican cheese": [r"queso fresco", r"mexican cheese$"],
    "feta cheese": [r"\bfeta$"],
    "mozzarella cheese": [r"mozzarella", r"stracciatella$", r"stracciatella cheese"],
    "pecorino cheese": [r"pecorino"],
    "mascarpone cheese": [r"mascarpone"],
    "ricotta cheese": [r"ricotta"],
    "gruyere cheese": [r"gruyere(?: cheese)?"],
    "swiss cheese": [r"swiss cheese", r"emmenth?al(?:er)?"],
    "cottage cheese": [r"cottage cheese", r"cottage$", r"farmers? cheese"],
    "pepper jack cheese": [r"pepper ?jack"],
    "cream cheese": [r"cream cheese$", r"neufchatel"],
    "cheddar cheese": [
        r"cheddar cheese$",
        r"cheddar(?: cheese)?$",
        r"caerphilly(?: cheese)?",
    ],
    "brie cheese": [
        r"brie(?: cheese)?$",
        r"camembert(?: cheese)?$",
        r"goat'?s? cheese$",
    ],
    "parmesan cheese": [r"parmigiano", r"parmesan", r"grana? padano"],
    "paneer cheese": [r"pan(?:ee|i)r(?: cheese)?"],
    "halloumi cheese": [
        r"halloumi(?: cheese)?",
        r"hellim(?: cheese)?",
        r"hallumi(?: cheese)?",
        r"cypriot cheese",
    ],
    "blue cheese": [
        r"blue(?: cheese)?$",
        r"blue cheese crumble",
        r"gorgonzola(?: cheese)?",
        r"roquefort(?: cheese)?",
        r"stilton(?: cheese)?",
        r"danish blue(?: cheese)?",
        r"bleu(?: cheese)?",
    ],
    "cheese": [r"cheese$"],
    # STOCKS
    "chicken stock": [
        r"chicken stock",
        r"chicken broth",
        r"chicken bouillon",
        r"chicken granule",
    ],
    "vegetable stock": [
        r"(?:vegetable|veggie) stock",
        r"(?:vegetable|veggie) broth",
        r"(?:vegetable|veggie) bouillon",
        r"(?:vegetable|veggie) granule",
    ],
    "beef stock": [r"beef (?:stock|broth|bouillon|granule|juice|consomme|veloute)"],
    "fish stock": [
        r"(?:fish|seafood|crab|mussel) (?:stock|broth|bouillon|granule|juice|consomme|veloute)"
    ],
    "pork stock": [r"pork (?:stock|broth|bouillon|granule|juice|consomme|veloute)"],
    "stock": [r"(?:stock|broth|bouillon|granule|consomme|veloute)$"],
    # SAUCES
    "adobo sauce": [r"chipotle pepper adobo sauce"],
    "soy sauce": [r"ketjap manis", r"soya? sauce", r"tamari$", r"tamari sauce"],
    "tomato sauce": [r"tomato sauce$", r"tomato puree"],
    "fish sauce": [r"nam pla", r"fish sauce", r"seafood sauce"],
    "enchilada sauce": [r"enchilada sauce"],
    "hot sauce": [r"sriracha", r"adobo sauce", r"hot sauce"],
    "pepper sauce": [r"pepper.*sauce$"],
    "garlic paste": [r"garlic paste"],
    "chili paste": [
        r"chill?i?[iey].*paste",
        r"adobo.*(?:paste|sauce)",
        r"ranchero.*sauce",
    ],
    "curry paste": [r"curry.*paste"],
    "tomato paste": [r"tomato.*paste"],
    # SPICES
    "salt": [r"\bsalt(?:.*pepper)?$", r"\bsalt$", r"sea-salt$"],
    "garlic": [r"garlic$", r"garlic bulb", r"garlic clove"],
    "mustard powder": [r"mustard powder"],
    "coriander powder": [r"coriander powder"],
    "fivespice": [r"fivespice"],
    "spicy powder": [
        "cayenne",
        r"chill?[iey] powder",
        r"(?:chipotle|habanero|poblano|pepperoncino).*powder",
    ],
    "curry powder": [r"curry.*powder"],
    "cardamom": [r"cardamom powder", r"cardamom$"],
    "cumin": [
        r"cumin(?: powder)?$",
        r"jeera(?: powder)?$",
        r"nigella seed",
        r"caraway(?: seed)?$",
    ],
    "cinammon": [
        r"(?:cinammon|cassia)(?: powder| bark)?$",
    ],
    "peppercorn": [r"peppercorn$"],
    "sichuan pepper": [
        r"(?:whole)?sz?[ei]ch[uw]an pepper(?:corn)?",
    ],
    # NUTS
    "cashew": [r"\bcashew(?: nut)?$"],
    "chestnut": [r"chest ?nut$"],
    "walnut": [r"walnut(?: hal(?:f|ves))?$"],
    "peanut": [r"peanut$"],
    "almond": [r"almond$", r"macadamia(?: nut)?$"],
    "pistachio": [r"pistachio(?: nut)?$"],
    "pecan": [r"pecan(?: nut)?$"],
    "hazelnut": [r"hazel ?nut$"],
    "pine nut": [r"pine ?nut$"],
    "nut": [r"\bnut$", r"sacha inchi", r"acorns?$", r"butternuts?$"],
    # SEEDS
    "chia": [r"chia(?: seed)?"],
    "anise": [r"anise(?: seed)?"],
    "cardamom pod": [r"cardamom pod", r"cardamom seed"],
    "mustard seed": [r"mustard seed$"],
    "sesame": [r"sesame seeds?", r"sesame$"],
    "poppy": [r"poppy seeds?", r"poppy$"],
    "sunflower seed": [r"sunflower seed"],
    "flaxseed": [r"flaxseed$"],
    "seed": [r"\bseed$"],
    # VEGETABLES
    "spinach": [r"spinach$"],
    "kale": [r"\bkale$"],
}


class Ingredient:
    def __init__(self, phrase, ingredient) -> None:
        self.phrase = phrase
        self.id = None
        self.categories = []
        self.quantity = []
        self.name = ""
        self.synonyms = []
        self.regex = r""
        self.unit = ""

    def __str__(self) -> str:
        return self.name

    def __repr__(self) -> str:
        return self.name

    def __eq__(self, o: object) -> bool:
        return self.id == o.id


def get_cheese():
    return [key for key in list(dictionary.keys()) if re.search(r"\bcheese$")]
